---
name: discover-wasm
description: Automatically discover WebAssembly skills when working with WebAssembly, WASM, WASI, wasm-bindgen, Rust to WASM, wasm-pack, or browser runtime. Activates for WASM development tasks.
license: MIT
metadata:
  author: rand
  version: "3.1"
compatibility: Designed for Claude Code. Compatible with any agent supporting the Agent Skills format.
---

# Wasm Skills Discovery

Provides automatic access to comprehensive wasm skills.

## When This Skill Activates

This skill auto-activates when you're working with:
- WebAssembly
- WASM
- wasm-pack
- Rust to WASM
- browser WASM
- WASI
- portable bytecode

## Available Skills

### Quick Reference

The Wasm category contains 4 skills:

1. **wasm-browser-integration**
2. **wasm-fundamentals**
3. **wasm-rust-toolchain**
4. **wasm-server-side**

### Load Full Category Details

For complete descriptions and workflows:

Read <cc-polymath-root>/skills/wasm/INDEX.md


This loads the full Wasm category index with:
- Detailed skill descriptions
- Usage triggers for each skill
- Common workflow combinations
- Cross-references to related skills

### Load Specific Skills

Load individual skills as needed:

Read <cc-polymath-root>/skills/wasm/wasm-browser-integration.md
Read <cc-polymath-root>/skills/wasm/wasm-fundamentals.md
Read <cc-polymath-root>/skills/wasm/wasm-rust-toolchain.md
Read <cc-polymath-root>/skills/wasm/wasm-server-side.md


## Progressive Loading

This gateway skill enables progressive loading:
- **Level 1**: Gateway loads automatically (you're here now)
- **Level 2**: Load category INDEX.md for full overview
- **Level 3**: Load specific skills as needed

## Usage Instructions

1. **Auto-activation**: This skill loads automatically when Claude Code detects wasm work
2. **Browse skills**: Run `Read <cc-polymath-root>/skills/wasm/INDEX.md` for full category overview
3. **Load specific skills**: Use bash commands above to load individual skills


**Next Steps**: Run `Read <cc-polymath-root>/skills/wasm/INDEX.md` to see full category details.
