---
name: discover-workflow
description: Automatically discover workflow and task management skills when working with Beads. Activates for workflow development tasks.
---

# Workflow Skills Discovery

Provides automatic access to comprehensive workflow skills.

## When This Skill Activates

This skill auto-activates when you're working with:
- Beads
- workflow
- task management
- context strategies
- dependency management
- multi-session
- project synthesis
- cleanup
- consolidation
- roadmap

## Available Skills

### Quick Reference

The Workflow category contains 5 skills:

1. **beads-context-strategies** - Context management across Beads sessions
2. **beads-dependency-management** - Managing task dependencies in Beads
3. **beads-multi-session-patterns** - Multi-session work coordination
4. **beads-workflow** - Core Beads commands and session patterns
5. **project-synthesis** - Consolidate scattered plans/docs/tests into unified roadmap

### Load Full Category Details

For complete descriptions and workflows:

```bash
cat ~/.claude/skills/workflow/INDEX.md
```

This loads the full Workflow category index with:
- Detailed skill descriptions
- Usage triggers for each skill
- Common workflow combinations
- Cross-references to related skills

### Load Specific Skills

Load individual skills as needed:

```bash
cat ~/.claude/skills/workflow/beads-context-strategies.md
cat ~/.claude/skills/workflow/beads-dependency-management.md
cat ~/.claude/skills/workflow/beads-multi-session-patterns.md
cat ~/.claude/skills/workflow/beads-workflow.md
cat ~/.claude/skills/workflow/project-synthesis.md
```

## Progressive Loading

This gateway skill enables progressive loading:
- **Level 1**: Gateway loads automatically (you're here now)
- **Level 2**: Load category INDEX.md for full overview
- **Level 3**: Load specific skills as needed

## Usage Instructions

1. **Auto-activation**: This skill loads automatically when Claude Code detects workflow work
2. **Browse skills**: Run `cat ~/.claude/skills/workflow/INDEX.md` for full category overview
3. **Load specific skills**: Use bash commands above to load individual skills

---

**Next Steps**: Run `cat ~/.claude/skills/workflow/INDEX.md` to see full category details.
