---
name: discover-zig
description: Automatically discover Zig programming skills when working with Zig, comptime, allocators, build.zig, safety, C interop, memory management, or systems programming. Activates for Zig development tasks.
license: MIT
metadata:
  author: rand
  version: "3.1"
compatibility: Designed for Claude Code. Compatible with any agent supporting the Agent Skills format.
---

# Zig Skills Discovery

Provides automatic access to comprehensive zig skills.

## When This Skill Activates

This skill auto-activates when you're working with:
- Zig
- systems programming
- comptime
- allocators
- C interop
- build.zig
- zon package manager

## Available Skills

### Quick Reference

The Zig category contains 6 skills:

1. **zig-build-system**
2. **zig-c-interop**
3. **zig-memory-management**
4. **zig-package-management**
5. **zig-project-setup**
6. **zig-testing**

### Load Full Category Details

For complete descriptions and workflows:

Read <cc-polymath-root>/skills/zig/INDEX.md


This loads the full Zig category index with:
- Detailed skill descriptions
- Usage triggers for each skill
- Common workflow combinations
- Cross-references to related skills

### Load Specific Skills

Load individual skills as needed:

Read <cc-polymath-root>/skills/zig/zig-build-system.md
Read <cc-polymath-root>/skills/zig/zig-c-interop.md
Read <cc-polymath-root>/skills/zig/zig-memory-management.md


## Progressive Loading

This gateway skill enables progressive loading:
- **Level 1**: Gateway loads automatically (you're here now)
- **Level 2**: Load category INDEX.md for full overview
- **Level 3**: Load specific skills as needed

## Usage Instructions

1. **Auto-activation**: This skill loads automatically when Claude Code detects zig work
2. **Browse skills**: Run `Read <cc-polymath-root>/skills/zig/INDEX.md` for full category overview
3. **Load specific skills**: Use bash commands above to load individual skills


**Next Steps**: Run `Read <cc-polymath-root>/skills/zig/INDEX.md` to see full category details.
