# Tools and Libraries Reference

## Design Tools

**Prototyping:**
- Figma (https://figma.com)
- Sketch (https://sketch.com)
- Adobe XD

**Flow Diagrams:**
- Graphviz (`apt-get install graphviz`)
- Excalidraw (https://excalidraw.com)
- Mermaid (https://mermaid.js.org)

**Debugging:**
- Chrome DevTools
- React DevTools
- Redux DevTools

## Typography

**Fonts:**
- Geist (https://vercel.com/font)
- JetBrains Mono (https://jetbrains.com/mono)
- Google Fonts (https://fonts.google.com)
- Modern Font Stacks (https://modernfontstacks.com)

**Tools:**
- Type Scale Generator (https://typescale.com)
- Modular Scale Calculator (https://modularscale.com)

## Color Tools

**Palette Generators:**
- Coolors (https://coolors.co)
- Huemint (https://huemint.com) - AI-based
- Adobe Color (https://color.adobe.com)
- Realtime Colors (https://realtimecolors.com)

**Contrast Checkers:**
- WebAIM Contrast Checker (https://webaim.org/resources/contrastchecker)
- Color.review (https://color.review)
- Colorable (https://colorable.jxnblk.com)

**Dark Mode:**
- Night Eye - preview dark mode
- Dark Reader - test dark themes

## Animation

**Libraries:**
- Framer Motion (https://framer.com/motion)
- GSAP (https://greensock.com/gsap)
- React Spring (https://react-spring.dev)

**Tools:**
- Cubic Bezier Generator (https://cubic-bezier.com)
- Easings.net (https://easings.net)

## Icons

- Lucide (https://lucide.dev) - Used by shadcn/ui
- Heroicons (https://heroicons.com)
- Phosphor Icons (https://phosphoricons.com)
- Feather Icons (https://feathericons.com)

## Syntax Highlighting

**Primary:**
- Shiki (https://shiki.style) - TextMate grammars
  
**Alternatives:**
- Prism (https://prismjs.com)
- highlight.js (https://highlightjs.org)

**Editors:**
- Monaco Editor (https://microsoft.github.io/monaco-editor)
- CodeMirror (https://codemirror.net)

## Markdown & Content

- react-markdown (https://github.com/remarkjs/react-markdown)
- remark-gfm (GitHub Flavored Markdown)
- MDX (https://mdxjs.com)
- rehype-sanitize (HTML sanitization)

## Streaming & Real-time

**Native APIs:**
- Server-Sent Events (SSE)
- WebSockets
- Fetch API with streams

**Libraries:**
- React Query (https://tanstack.com/query)
- SWR (https://swr.vercel.app)
- Socket.IO (https://socket.io)

## Diff & Version Control

- diff-match-patch (Google's diff library)
- react-diff-viewer
- Monaco Diff Editor

## Virtual Scrolling

- react-window (https://github.com/bvaughn/react-window)
- react-virtualized
- TanStack Virtual (https://tanstack.com/virtual)

## Accessibility Testing

**Browser Extensions:**
- axe DevTools
- WAVE
- Lighthouse (built into Chrome)

**Screen Readers:**
- NVDA (Windows) - Free
- JAWS (Windows) - Commercial
- VoiceOver (macOS/iOS) - Built-in

## Performance

**Analysis:**
- Lighthouse (Chrome DevTools)
- WebPageTest (https://webpagetest.org)
- Bundle Analyzer (webpack/vite)

**Optimization:**
- Next.js Image component
- Sharp (image processing)
- Vite (fast build tool)

## Form Handling

- React Hook Form (https://react-hook-form.com)
- Zod (validation)
- Formik (alternative)

## Testing

**Unit Testing:**
- Vitest
- Jest
- React Testing Library

**E2E Testing:**
- Playwright
- Cypress

**Visual Regression:**
- Percy
- Chromatic
