#!/bin/bash
# ABOUTME: Setup script for ts-morph-analyzer skill.
# ABOUTME: Installs ts-morph and TypeScript dependencies.

set -e

SCRIPT_DIR="$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)"

echo "Setting up ts-morph-analyzer..."
echo ""

cd "$SCRIPT_DIR"

# Check for npm
if ! command -v npm &> /dev/null; then
    echo "Error: npm not found. Please install Node.js first."
    exit 1
fi

# Install dependencies
echo "Installing dependencies..."
npm install

echo ""
echo "Setup complete!"
echo ""
echo "Usage:"
echo "  npx ts-node scripts/extract-signatures.ts <path>"
echo "  npx ts-node scripts/trace-calls.ts <file>:<function> --up"
echo "  npx ts-node scripts/analyze-exports.ts <path>"
echo "  npx ts-node scripts/code-smells.ts <path>"
echo ""
echo "Run any script with --help for more options."
