# Article Title Best Practices

This reference document provides comprehensive guidance on creating effective, marketable article titles that attract readers while maintaining integrity and accuracy.

## Core Principles

### 1. Length Guidelines
- **Optimal length**: 6-12 words (50-70 characters)
- **Maximum for SEO**: 60 characters (Google truncates beyond this in search results)
- **Readability**: Shorter titles are easier to scan and remember
- **Social media**: Twitter displays ~70 characters, so aim for this as absolute maximum

### 2. Title-Subtitle Format
The format `<Title>: <Subtitle>` provides structure and allows for both attention-grabbing and informative elements:
- **Title (main)**: Hook the reader, create curiosity, emotional impact
- **Subtitle**: Clarify, provide context, set expectations
- **Balance**: Neither part should dominate; aim for roughly equal weight

### 3. Clarity vs. Curiosity Balance
- **Too clear**: Boring, no reason to click ("An Article About AI in Healthcare")
- **Too vague**: Clickbait, loses trust ("You Will Not Believe What Happened Next")
- **Sweet spot**: Intriguing yet informative ("The Hidden Bias in Medical AI")

## MANDATORY CONSTRAINTS

**ALL generated titles must comply with these three critical constraints:**

### 1. No AI-Generated Tropes
Avoid obvious AI writing patterns, clichéd phrasing, and overused terminology that signals robotic or formulaic content:
- **NEVER use**: "Algorithm", "Algorithms", "Algorithmic", "Black-Box", "Black Box"
- **AVOID**: Predictable AI-content patterns like "The X Will See You Now", "Welcome to the Age of X", "The Rise of X", "X: A Game Changer", "X is a Game Changer"
- **Why**: These words and phrases have become clichéd markers of AI-generated content and reduce authenticity and reader engagement
- **Instead**: Use fresh, specific language that authentically describes the actual content without relying on tech-writing clichés
- **Examples**:
  - ❌ "The Algorithm Will See You Now"
  - ❌ "The Machine Will See You Now" (trope phrasing)
  - ❌ "Black-Box AI in Healthcare"
  - ✓ "Opaque AI in Healthcare: Why Explainability Matters Now"
  - ❌ "When Algorithms Fail Minorities"
  - ✓ "Medical AI Fails Minorities: The Data Representation Crisis"

### 2. No Apostrophes
Do not use apostrophes anywhere in the title for contractions or possessives:
- **NEVER use**: "don't", "can't", "won't", "it's", "AI's", "doctor's", "reader's", etc.
- **Why**: Apostrophes create visual clutter and complicate parsing
- **Instead use**: Full forms or rephrase to avoid possessives
- **Examples**:
  - ❌ "Why AI Won't Replace Doctors"
  - ✓ "Why AI Will Not Replace Doctors"
  - ❌ "The Doctor's AI Dilemma"
  - ✓ "The AI Dilemma for Doctors"
  - ❌ "It's Time to Regulate AI"
  - ✓ "The Time to Regulate AI"

### 3. No Question Marks in Title Segment
Question marks in the Title segment create visually awkward ?: combinations when rendered:
- **NEVER use**: Question marks before the colon in Title segment
- **Allowed**: Questions in the Subtitle segment (after the colon)
- **Why**: The ?: punctuation combination is visually jarring and breaks reading flow
- **Instead**: Use questions in Subtitle, or rephrase Title as statement
- **Examples**:
  - ❌ "Can AI Be Trusted?: The Bias Problem"
  - ✓ "Medical AI and Trust: Can We Fix the Bias Problem"
  - ✓ "The Trust Problem in Medical AI: Why Bias Matters"
  - ❌ "Why Do Systems Fail?: Understanding Root Causes"
  - ✓ "When Systems Fail: Why It Happens and How to Prevent It"

**Validation Checklist:**
Before finalizing any title, verify:
- [ ] Does NOT contain "algorithm" or variants
- [ ] Does NOT contain any apostrophes
- [ ] Does NOT have question mark in Title segment (before colon)
- [ ] Follows `<Title>: <Subtitle>` format
- [ ] Is 10-12 words total maximum

## Proven Title Formulas

### Formula 1: Question Format
- "[Statement]: Why Does [Problem] Happen"
- Example: "Medical AI Fails Minorities: Why Data Representation Matters"
- **Strengths**: Engages reader's curiosity, promises answers
- **Use when**: Article explores causes or explanations
- **Note**: Question must be in Subtitle segment to avoid awkward ?: combination

### Formula 2: Number/List Format
- "[Number] [Topic]: [Outcome/Benefit]"
- Example: "5 Hidden Biases in AI: What Every Doctor Should Know"
- **Strengths**: Specific, scannable, sets clear expectations
- **Use when**: Article has discrete points or steps

### Formula 3: Contrarian/Provocative Format
- "[Common Belief] Is Wrong: [Reality]"
- Example: "AI Will Replace Radiologists Is Wrong: Here Is Why"
- **Strengths**: Challenges assumptions, creates cognitive dissonance
- **Use when**: Article debunks myths or presents unexpected findings

### Formula 4: How-To Format
- "How to [Achieve Goal]: [Method/Approach]"
- Example: "How to Detect AI Bias: A Guide for Radiologists"
- **Strengths**: Practical, action-oriented, promises value
- **Use when**: Article provides actionable advice

### Formula 5: The Future/Trend Format
- "The Future of [Topic]: [Key Insight]"
- Example: "The Future of Medical Diagnosis: Human-AI Partnership"
- **Strengths**: Forward-looking, authoritative, positions reader ahead of curve
- **Use when**: Article explores emerging trends or predictions

### Formula 6: Problem-Solution Format
- "[Problem]: [Solution/Approach]"
- Example: "Opaque AI in Medicine: The Push for Explainability"
- **Strengths**: Clear value proposition, addresses reader pain points
- **Use when**: Article presents solutions to known problems

### Formula 7: Unexpected Juxtaposition
- "[A] Meets [B]: [Outcome]"
- Example: "When AI Meets Ethics: The Healthcare Dilemma"
- **Strengths**: Creates intrigue through contrast
- **Use when**: Article explores intersection of distinct concepts

### Formula 8: Emotional Hook
- "The [Emotion] Truth About [Topic]: [Insight]"
- Example: "The Uncomfortable Truth About Medical AI: Widespread Bias"
- **Strengths**: Emotional engagement, honesty signal
- **Use when**: Article addresses difficult or controversial topics

## Success Criteria & Evaluation Framework

### 1. Clickability (Weight: 25%)
**Measures**: Likelihood to grab attention and generate clicks
- **High**: Creates curiosity gap, uses power words, specific numbers
- **Medium**: Informative but not particularly compelling
- **Low**: Generic, vague, or boring
- **Power words**: Hidden, Secret, Proven, Ultimate, Essential, Critical, Surprising, Shocking (use sparingly)

### 2. SEO Effectiveness (Weight: 20%)
**Measures**: Search engine optimization and discoverability
- **Keyword placement**: Primary keyword in first 3-5 words
- **Length**: 50-60 characters ideal for search results
- **Natural language**: Readable, not keyword-stuffed
- **Search intent match**: Title matches what people actually search for

### 3. Clarity/Informativeness (Weight: 20%)
**Measures**: How well title communicates article content
- **High**: Reader knows exactly what to expect
- **Medium**: General idea but some ambiguity
- **Low**: Vague, misleading, or confusing
- **Test**: Can someone unfamiliar with the topic understand the subject?

### 4. Emotional Impact (Weight: 15%)
**Measures**: Emotional resonance and engagement
- **Curiosity**: Creates information gap that compels reading
- **Surprise**: Challenges assumptions or presents unexpected angles
- **Urgency**: Suggests timely or critical information
- **Relevance**: Connects to reader's concerns or interests

### 5. Memorability (Weight: 10%)
**Measures**: Likelihood to stick in reader's mind
- **Distinctive**: Unique phrasing, not generic
- **Rhythmic**: Flows well when read aloud
- **Concrete**: Uses specific, vivid language over abstractions
- **Punchy**: Short, impactful words over lengthy descriptions

### 6. Social Shareability (Weight: 10%)
**Measures**: Likelihood to be shared on social media
- **Identity expression**: Sharing signals something about the sharer
- **Conversation starter**: Likely to generate discussion
- **Platform fit**: Works across Twitter, LinkedIn, Facebook
- **Screenshot-worthy**: Looks good in social media cards

## Common Pitfalls to Avoid

### 1. Clickbait
- **What it is**: Misleading or exaggerated titles that don't deliver on promise
- **Why avoid**: Erodes trust, damages credibility, high bounce rates
- **Examples**: "You Won't Believe...", "Doctors Hate This...", "One Weird Trick..."

### 2. Keyword Stuffing
- **What it is**: Cramming multiple keywords unnaturally
- **Why avoid**: Hurts readability, looks spammy, SEO penalties
- **Example**: "AI Medical Healthcare Diagnosis Technology Algorithm Machine Learning"

### 3. Vagueness
- **What it is**: Titles so general they could apply to thousands of articles
- **Why avoid**: No differentiation, no reason to click
- **Examples**: "Thoughts on AI", "Understanding Healthcare", "Technology and Medicine"

### 4. Over-promising
- **What it is**: Titles that promise more than article delivers
- **Why avoid**: Reader disappointment, credibility loss
- **Examples**: "The Complete Guide to AI" (for a 2000-word article), "Everything You Need to Know About..."

### 5. Jargon Overload
- **What it is**: Technical terms that alienate general audience
- **Why avoid**: Limits reach, confuses readers, reduces engagement
- **Example**: "Convolutional Neural Networks in Radiological Pathognomonic Feature Extraction"
- **Better**: "How AI Learns to Spot Disease in Medical Images"

### 6. Being Too Clever
- **What it is**: Puns, wordplay, or references that obscure meaning
- **Why avoid**: Doesn't translate across audiences, SEO issues, confusion
- **Balance**: Clever is fine if it doesn't sacrifice clarity

## Industry-Specific Considerations

### Technical/Professional Articles
- **Audience**: Experts want specificity and accuracy
- **Approach**: Be precise, use correct terminology, highlight novelty
- **Example**: "Explainable AI in Radiology: Bridging the Trust Gap"

### General Interest/Popular Science
- **Audience**: Lay readers need accessible language
- **Approach**: Use analogies, avoid jargon, emphasize impact
- **Example**: "AI Doctors and Trust: Can We Fix the Bias Problem"

### News/Current Events
- **Audience**: Want timely, relevant information
- **Approach**: Emphasize newness, implications, urgency
- **Example**: "New FDA Rules Change AI in Medicine: What to Know"

### Opinion/Commentary
- **Audience**: Seek perspectives and analysis
- **Approach**: Signal viewpoint, be provocative (within reason)
- **Example**: "AI Will Not Replace Radiologists: But They Should Worry"

## Testing & Validation

### A/B Testing Questions
When choosing between title candidates, ask:
1. **Thumb-stopping power**: Would this make me pause while scrolling?
2. **Value proposition**: Is the benefit of reading clear?
3. **Audience fit**: Does this speak to my target reader?
4. **Authenticity**: Does this accurately represent the article?
5. **Differentiation**: How does this stand out from similar articles?

### Red Flags
Reject titles that:
- Are deceptive or misleading
- Contain factual errors
- Use offensive language
- Perpetuate stereotypes
- Are too similar to existing popular articles (plagiarism risk)

## Examples: Before & After

### Example 1: Technical Article
**Before**: "A Comprehensive Analysis of Algorithmic Bias in Artificial Intelligence Systems Applied to Medical Imaging with Specific Focus on Radiological Diagnoses"
- **Problems**: Way too long (21 words), jargon-heavy, no hook
**After**: "Hidden Bias in Medical AI: How Systems Fail Minorities"
- **Improvements**: Concise (8 words), accessible language, emotional hook, clear problem

### Example 2: General Interest
**Before**: "Things to Consider About AI"
- **Problems**: Vague, generic, no value proposition
**After**: "Medical AI and Racism: The Troubling Truth About Bias"
- **Improvements**: Provocative topic, specific focus, emotional engagement, clear subject

### Example 3: How-To Article
**Before**: "Guide to Understanding AI in Healthcare Settings"
- **Problems**: Generic, passive, no urgency
**After**: "How Doctors Should Question AI: A Practical Guide"
- **Improvements**: Specific audience, action-oriented, practical value

### Example 4: News/Analysis
**Before**: "New Developments in Medical Technology Regulation"
- **Problems**: Boring, no specifics, no angle
**After**: "New FDA AI Rules: What Changes for Patients and Doctors"
- **Improvements**: Specific event, clear stakeholders, practical relevance

## Recommended Workflow

When generating article titles:

1. **Analyze article content** deeply - identify:
   - Core thesis/argument
   - Key findings or insights
   - Primary audience
   - Emotional tone
   - Main keywords

2. **Generate diverse candidates** using different formulas:
   - Question format
   - How-to format
   - Problem-solution format
   - Contrarian format
   - Future/trend format

3. **Evaluate each candidate** against all six criteria:
   - Clickability (25%)
   - SEO effectiveness (20%)
   - Clarity/informativeness (20%)
   - Emotional impact (15%)
   - Memorability (10%)
   - Social shareability (10%)

4. **Score systematically**:
   - Rate each criterion 1-10
   - Apply weights
   - Calculate weighted average
   - Consider qualitative factors

5. **Select winner** based on:
   - Highest overall score
   - Best fit for article tone and audience
   - Authentic representation of content
   - No red flags or ethical concerns

6. **Validate** by asking:
   - Would I click this?
   - Does it deliver on the promise?
   - Will readers share it?
   - Does it stand out?
