# Midjourney Style Guide for FLUX 1.1 Pro

This reference document provides comprehensive guidelines for transforming user requests into Midjourney-quality prompts optimized for the FLUX 1.1 Pro model.

## Core Midjourney Aesthetic Principles

### Visual Characteristics
- **Ultra-detailed rendering**: Every element should be crystal clear with sharp focus on the main subject
- **Cinematic composition**: Rule of thirds, leading lines, balanced framing
- **Professional color grading**: Rich, saturated colors with tonal depth and contrast
- **Dramatic lighting**: Motivated light sources, rim lighting, atmospheric effects
- **Shallow depth of field**: Subject isolation with beautiful bokeh
- **Editorial quality**: Polished, magazine-worthy presentation
- **Artistic sensibility**: Not just photorealistic, but aesthetically elevated

### Technical Photography Qualities
- **Lighting setups**: Golden hour, studio lighting, natural window light, rim lighting, backlighting
- **Camera specifications**: Wide apertures (f/1.4, f/2.8), focal lengths (35mm, 85mm, 24-70mm)
- **Professional equipment**: Shot on RED, ARRI, Canon R5, Hasselblad, Phase One
- **Post-processing**: Color grading, tonal adjustments, professional retouching

## Prompt Structure Template

### Layer 1: Main Subject & Core Composition (Required)
Start with the primary subject and its core positioning:
```
[Subject] [action/pose/position], [composition placement]
```

Examples:
- "A woman standing in a field, centered composition"
- "Vintage sports car parked on coastal highway, rule of thirds"
- "Modern skyscraper reaching into clouds, low angle perspective"

### Layer 2: Visual Style & Aesthetic (Required)
Add artistic direction and visual treatment:
```
[art style/movement], [mood descriptor], [color treatment]
```

Examples:
- "cinematic realism, moody and atmospheric, rich earth tones"
- "hyper-realistic photography, elegant and refined, muted pastels"
- "editorial fashion photography, dramatic and bold, high contrast monochrome"

### Layer 3: Lighting & Environment (Highly Recommended)
Specify lighting conditions and environmental context:
```
[lighting type], [time of day], [weather/atmosphere]
```

Examples:
- "golden hour sunlight, late afternoon, light fog"
- "studio softbox lighting, professional setup, clean backdrop"
- "dramatic rim lighting, twilight blue hour, scattered clouds"

### Layer 4: Technical Details & Quality Enhancers (Recommended)
Add photography specifications and quality modifiers:
```
[camera/lens specs], [depth of field], [quality terms]
```

Examples:
- "shot on Canon R5, 85mm f/1.4, shallow depth of field, professional photography"
- "medium format Hasselblad, 35mm wide angle, tack sharp focus, 8k resolution"
- "35mm film grain, Portra 400, bokeh background, highly detailed"

### Layer 5: Artistic References & Influences (Optional)
Include when appropriate for stylistic guidance:
```
[artist name], [art movement], [cultural reference]
```

Examples:
- "in the style of Annie Leibovitz, contemporary portrait photography"
- "inspired by Blade Runner 2049, neo-noir cinematography"
- "reminiscent of Gregory Crewdson, staged photography, suburban surrealism"

## Midjourney-Quality Descriptive Vocabulary

### Lighting Terms
- Golden hour, blue hour, twilight, dusk, dawn
- Rim lighting, backlighting, side lighting, three-point lighting
- Soft diffused light, hard directional light, volumetric lighting
- Studio lighting, natural light, candlelight, neon glow
- God rays, lens flare, atmospheric haze, light shafts

### Composition Terms
- Rule of thirds, centered composition, symmetrical framing
- Low angle, high angle, bird's eye view, worm's eye view
- Dutch angle, over-the-shoulder, close-up, wide shot
- Negative space, leading lines, framing within frame
- Depth layering, foreground interest, background separation

### Mood & Atmosphere
- Cinematic, dramatic, ethereal, dreamlike, surreal
- Moody, atmospheric, intimate, epic, grandiose
- Melancholic, nostalgic, futuristic, timeless
- Serene, tranquil, chaotic, dynamic, peaceful
- Mysterious, ominous, hopeful, triumphant

### Color & Tone
- Rich earth tones, muted pastels, vibrant colors, desaturated
- High contrast, low contrast, tonal depth, color grading
- Warm tones, cool tones, complementary colors, analogous palette
- Monochromatic, duotone, technicolor, sepia toned
- Film emulation, Fuji Velvia, Kodak Portra, Ilford HP5

### Quality Enhancers
- Highly detailed, ultra realistic, photorealistic, 8k resolution
- Professional photography, award-winning, museum quality
- Tack sharp, crisp focus, pin sharp, crystal clear
- Fine art photography, editorial quality, commercial photography
- Masterful composition, expert color grading, professional retouching

### Texture & Material
- Soft fabric, rough concrete, polished metal, weathered wood
- Smooth glass, organic textures, intricate details
- Translucent, reflective surface, matte finish, glossy sheen
- Fine grain, subtle texture, rich tactile quality

### Camera & Technical
- Shot on [camera brand/model]: RED, ARRI, Canon R5, Sony A7R
- Lens focal length: 24mm, 35mm, 50mm, 85mm, 200mm
- Aperture: f/1.4, f/2.8, f/4, f/5.6, f/8
- Film stock: Kodak Portra 400, Fuji Velvia, Ilford HP5
- Medium format, large format, 35mm film, digital cinema

## FLUX vs Midjourney Adaptation Strategies

### Key Differences
1. **Literal interpretation**: FLUX is more literal than Midjourney's artistic interpretation
2. **Text rendering**: FLUX excels at accurate text in images
3. **Photorealism strength**: FLUX is exceptionally strong at photorealism
4. **Color accuracy**: FLUX produces more accurate colors vs Midjourney's stylization

### Adaptation Techniques

**For Midjourney's artistic elevation:**
- Add explicit quality terms: "editorial quality", "professional color grading"
- Specify "cinematic" or "artistic photography" to avoid too-literal interpretation
- Include "carefully composed" or "expertly framed" for deliberate composition

**For color grading:**
- Be specific: "warm color grading with orange and teal tones"
- Reference film stocks: "Kodak Portra 400 color palette"
- Specify mood through color: "moody desaturated blues and greens"

**For lighting drama:**
- Describe complete lighting setup: "key light from left, rim light from behind"
- Reference cinematic sources: "Blade Runner 2049 lighting style"
- Specify atmospheric conditions: "volumetric fog, god rays, atmospheric haze"

**For texture and detail:**
- FLUX loves detail, so be specific: "intricate fabric textures, visible skin pores"
- Request specific materials: "brushed aluminum, weathered leather, silk fabric"

## Prompt Length Optimization

**Target range**: 40-75 words
- **Under 40 words**: Risk losing Midjourney aesthetic richness
- **40-60 words**: Optimal for most prompts, balanced detail
- **60-75 words**: Complex scenes with multiple elements
- **Over 75 words**: Diminishing returns, potential confusion

## Common Prompt Patterns

### Portrait Photography
```
[Subject] [pose/expression], [framing], cinematic portrait photography, [lighting], [mood], shot on [camera] [lens] [aperture], [background treatment], professional color grading, [quality enhancers]
```

Example:
"Woman with contemplative expression, three-quarter profile, cinematic portrait photography, soft window light from left, intimate and elegant mood, shot on Canon R5 85mm f/1.4, shallow depth of field with bokeh background, warm color grading, highly detailed, professional retouching"

### Landscape/Environment
```
[Location/scene], [time of day], [weather/atmosphere], [composition], [lighting quality], [camera specs], [color treatment], [artistic reference]
```

Example:
"Ancient temple ruins in misty jungle, early morning golden hour, light fog rolling through, wide angle establishing shot, dramatic side lighting through trees, shot on ARRI Alexa 24mm, rich earth tones and deep greens, inspired by Terrence Malick cinematography, highly detailed, 8k resolution"

### Product Photography
```
[Product] [positioning], [style], [lighting setup], [background], [camera specs], [material emphasis], [quality terms]
```

Example:
"Luxury watch on marble surface, editorial product photography, studio lighting with subtle reflections, minimalist white background, shot on Phase One medium format 80mm f/2.8, emphasize polished metal and sapphire crystal, tack sharp focus, commercial photography quality"

### Architectural
```
[Building/structure], [perspective], [time/lighting], [environment], [mood], [camera specs], [artistic treatment]
```

Example:
"Modern glass skyscraper, low angle perspective looking up, blue hour twilight, urban cityscape background, dramatic and imposing, shot on Canon R5 24mm tilt-shift, architectural photography, clean lines and geometric patterns, professional color grading, highly detailed"

### Fashion Editorial
```
[Subject] [outfit/styling], [pose/action], [setting], [lighting], [mood/aesthetic], [camera specs], [artistic reference], [quality terms]
```

Example:
"Model in flowing silk gown, dynamic movement with fabric in motion, minimal studio setting, dramatic backlighting with rim light, high fashion editorial aesthetic, shot on Hasselblad 50mm f/2.8, inspired by Peter Lindbergh, monochromatic with rich tonal depth, award-winning fashion photography"

## Artistic Movement & Style References

### Photography Styles
- **Contemporary portrait**: Annie Leibovitz, Peter Lindbergh, Paolo Roversi
- **Fine art photography**: Gregory Crewdson, Cindy Sherman, Andreas Gursky
- **Fashion editorial**: Steven Meisel, Tim Walker, Nick Knight
- **Landscape**: Ansel Adams, Michael Kenna, Sebastião Salgado
- **Street photography**: Henri Cartier-Bresson, Vivian Maier, Fan Ho

### Cinematic References
- **Blade Runner 2049**: Neo-noir, orange and teal grading, volumetric lighting
- **The Grand Budapest Hotel**: Symmetrical framing, pastel colors, whimsical
- **Mad Max Fury Road**: High contrast, desaturated with orange highlights, dynamic
- **Her**: Soft natural light, warm tones, intimate framing
- **The Revenant**: Natural light only, cold tones, raw cinematography

### Art Movements
- **Impressionism**: Soft focus, visible brushwork effect, light and color emphasis
- **Surrealism**: Dreamlike, unexpected juxtapositions, Salvador Dalí influence
- **Minimalism**: Clean lines, negative space, limited color palette
- **Art Nouveau**: Organic flowing lines, decorative elements, intricate details
- **Brutalism**: Raw concrete, geometric forms, stark and imposing

## Quality Control Checklist

Before finalizing a prompt, verify:
- [ ] Main subject is clearly defined and positioned
- [ ] Lighting is specified with direction and quality
- [ ] Mood/atmosphere is conveyed through descriptive terms
- [ ] Technical photography details add authenticity
- [ ] Color treatment or grading is mentioned
- [ ] Composition guidance is included
- [ ] Quality enhancers elevate to Midjourney standard
- [ ] Prompt length is 40-75 words
- [ ] No redundant or contradictory terms
- [ ] Flows naturally when read aloud

## Avoid These Common Mistakes

❌ **Too generic**: "beautiful landscape photo"
✅ **Specific**: "misty mountain valley at golden hour, dramatic god rays, cinematic landscape photography"

❌ **Contradictory lighting**: "bright sunlight, moody dark atmosphere"
✅ **Coherent**: "overcast diffused light, moody and atmospheric"

❌ **Overstuffed**: Listing every possible quality term
✅ **Selective**: Choose 2-3 most relevant quality enhancers

❌ **Missing technical anchor**: "nice photo of a person"
✅ **Technically grounded**: "shot on Canon R5 85mm f/1.4, professional portrait photography"

❌ **Vague style**: "artistic and creative"
✅ **Specific reference**: "inspired by Annie Leibovitz, contemporary editorial portrait"
