# Midjourney-Style Prompt Examples

This reference provides before/after examples showing how to transform basic user requests into rich, Midjourney-quality prompts optimized for FLUX 1.1 Pro.

## Example Transformation Methodology

Each example follows this pattern:
1. **User Request**: Original user input (usually brief and generic)
2. **Analysis**: What's missing for Midjourney quality
3. **Enhanced Prompt**: Fully developed Midjourney-style prompt
4. **Word Count**: Verification it's in optimal 40-75 word range
5. **Why It Works**: Explanation of improvements

---

## Portrait Photography Examples

### Example 1: Simple Portrait Request

**User Request:**
"A woman in a field"

**Analysis:**
Missing: composition, lighting, mood, technical specs, color treatment, quality markers

**Enhanced Prompt:**
"Woman with flowing hair standing in golden wheat field, centered composition, editorial portrait photography, golden hour sunlight from behind creating rim light, warm and ethereal mood, shot on Canon R5 85mm f/1.4, shallow depth of field with soft bokeh background, warm color grading with rich earth tones, highly detailed, professional photography"

**Word Count:** 56 words ✓

**Why It Works:**
- Adds specific composition (centered)
- Defines style (editorial portrait photography)
- Describes lighting (golden hour, rim light)
- Establishes mood (warm and ethereal)
- Includes technical specs (Canon R5 85mm f/1.4)
- Specifies depth of field and bokeh
- Details color treatment (warm grading, earth tones)
- Adds quality markers (highly detailed, professional)

### Example 2: Character Portrait

**User Request:**
"Portrait of an old fisherman"

**Analysis:**
Missing: setting context, lighting, emotional tone, technical photography details

**Enhanced Prompt:**
"Weathered fisherman with grey beard and sun-worn face, three-quarter profile close-up, cinematic portrait photography, soft diffused natural light from window, intimate and contemplative mood, shot on Hasselblad 80mm f/2.8, shallow depth of field, muted earth tones with desaturated blues, in the style of Steve McCurry, highly detailed facial textures, award-winning documentary photography"

**Word Count:** 58 words ✓

**Why It Works:**
- Rich character details (weathered, grey beard, sun-worn)
- Specific framing (three-quarter profile close-up)
- Professional category (cinematic portrait, documentary)
- Natural lighting specified (soft diffused window light)
- Emotional tone (intimate and contemplative)
- High-end technical specs (Hasselblad)
- Color palette defined (muted earth tones, desaturated blues)
- Artistic reference (Steve McCurry)
- Texture emphasis (facial textures)

### Example 3: Fashion Portrait

**User Request:**
"Model in elegant dress"

**Analysis:**
Missing: styling details, pose/movement, setting, lighting setup, fashion photography specifics

**Enhanced Prompt:**
"Fashion model in flowing black silk evening gown, elegant pose with hand on hip, minimal studio setting, dramatic side lighting with rim light accent, high fashion editorial aesthetic, shot on Phase One medium format 80mm f/2.8, shallow depth of field, monochromatic with rich tonal depth, inspired by Peter Lindbergh, professional hair and makeup, award-winning fashion photography, highly detailed fabric texture"

**Word Count:** 63 words ✓

**Why It Works:**
- Specific garment details (flowing black silk evening gown)
- Defined pose (hand on hip)
- Clear setting (minimal studio)
- Complete lighting setup (side lighting with rim light)
- Fashion-specific style (high fashion editorial)
- Premium equipment (Phase One medium format)
- Color treatment (monochromatic with tonal depth)
- Legendary photographer reference (Peter Lindbergh)
- Professional production values (hair and makeup)
- Material emphasis (fabric texture)

---

## Landscape/Environment Examples

### Example 4: Mountain Landscape

**User Request:**
"Beautiful mountain view"

**Analysis:**
Missing: time of day, weather, composition, photographic style, color treatment

**Enhanced Prompt:**
"Majestic snow-capped mountain peaks rising above clouds, wide angle establishing shot, early morning golden hour, light mist in valleys, cinematic landscape photography, dramatic side lighting highlighting mountain ridges, shot on Sony A7R IV 24mm, deep focus front to back, rich color saturation with cool blues and warm highlights, inspired by Ansel Adams, highly detailed, 8k resolution, award-winning landscape photography"

**Word Count:** 64 words ✓

**Why It Works:**
- Vivid scene description (snow-capped peaks, above clouds)
- Composition specified (wide angle establishing shot)
- Perfect timing (early morning golden hour)
- Atmospheric details (light mist in valleys)
- Professional category (cinematic landscape)
- Lighting direction (side lighting on ridges)
- Technical specs (Sony A7R IV 24mm)
- Focus treatment (deep focus)
- Color palette (cool blues, warm highlights)
- Master photographer reference (Ansel Adams)
- Quality markers throughout

### Example 5: Urban Scene

**User Request:**
"City street at night"

**Analysis:**
Missing: specific location character, lighting sources, atmosphere, photographic approach

**Enhanced Prompt:**
"Neon-lit Tokyo street after rain, wet pavement reflecting colorful signs, bustling crowds with motion blur, cinematic urban photography, blue hour twilight with glowing neon lights, shot on ARRI Alexa 35mm, medium depth of field isolating foreground, vibrant color grading with orange and teal tones, inspired by Blade Runner cinematography, atmospheric haze, highly detailed, 8k resolution"

**Word Count:** 59 words ✓

**Why It Works:**
- Specific location flavor (Tokyo, neon-lit)
- Visual interest (wet pavement reflections)
- Dynamic elements (bustling crowds, motion blur)
- Professional style (cinematic urban photography)
- Time of day (blue hour)
- Lighting character (glowing neon)
- Cinema camera (ARRI Alexa)
- Focus strategy (medium depth of field, foreground isolation)
- Popular color scheme (orange and teal)
- Cinematic reference (Blade Runner)
- Atmosphere (haze)

### Example 6: Coastal Landscape

**User Request:**
"Beach sunset"

**Analysis:**
Missing: composition, foreground interest, atmospheric conditions, emotional tone

**Enhanced Prompt:**
"Rugged coastal rocks in foreground with crashing waves, dramatic sunset over ocean horizon, long exposure creating smooth water, golden hour with scattered clouds, cinematic coastal photography, warm side lighting, shot on Canon R5 24-70mm f/4, wide angle perspective, rich warm color grading with orange and purple tones, serene and majestic atmosphere, highly detailed textures, professional landscape photography"

**Word Count:** 60 words ✓

**Why It Works:**
- Strong foreground (rugged coastal rocks, crashing waves)
- Compositional depth (foreground to horizon)
- Technical technique (long exposure)
- Time and conditions (golden hour, scattered clouds)
- Professional approach (cinematic coastal photography)
- Lighting quality (warm side lighting)
- Versatile lens choice (24-70mm)
- Perspective (wide angle)
- Sunset colors specified (orange and purple)
- Emotional tone (serene and majestic)
- Texture emphasis

---

## Product Photography Examples

### Example 7: Luxury Watch

**User Request:**
"Photo of a watch"

**Analysis:**
Missing: product category, setting, lighting setup, material emphasis, commercial photography standards

**Enhanced Prompt:**
"Luxury Swiss watch with leather strap on polished marble surface, editorial product photography, studio lighting with subtle reflections highlighting sapphire crystal, minimalist composition with negative space, shot on Phase One medium format 80mm macro f/4, tack sharp focus on watch face, emphasize brushed metal and leather texture, neutral background, professional color grading, commercial photography quality, highly detailed"

**Word Count:** 62 words ✓

**Why It Works:**
- Product specificity (luxury Swiss watch, leather strap)
- Premium surface (polished marble)
- Professional category (editorial product photography)
- Detailed lighting setup (studio with subtle reflections)
- Material highlights (sapphire crystal)
- Composition approach (minimalist, negative space)
- Top-tier equipment (Phase One macro)
- Critical focus (tack sharp on watch face)
- Texture emphasis (brushed metal, leather)
- Clean presentation (neutral background)
- Quality standards (commercial photography quality)

### Example 8: Tech Product

**User Request:**
"Headphones product shot"

**Analysis:**
Missing: product positioning, lighting style, background treatment, brand positioning

**Enhanced Prompt:**
"Premium wireless headphones floating on clean white background, modern product photography, soft studio lighting from multiple angles, minimal shadows, shot on Canon R5 100mm macro f/2.8, tack sharp focus throughout, emphasize matte black finish and metal accents, professional color grading with neutral tones, Apple-style minimal aesthetic, commercial product photography, 8k resolution, highly detailed"

**Word Count:** 56 words ✓

**Why It Works:**
- Product quality tier (premium wireless)
- Clean presentation (floating on white)
- Contemporary style (modern product photography)
- Professional lighting (studio, multiple angles, minimal shadows)
- Macro lens for detail (Canon 100mm macro)
- Complete focus (tack sharp throughout)
- Material callouts (matte black, metal accents)
- Color approach (neutral tones)
- Brand aesthetic reference (Apple-style)
- Commercial standard
- Resolution spec

---

## Architectural Photography Examples

### Example 9: Modern Building

**User Request:**
"Modern office building"

**Analysis:**
Missing: perspective, time of day, architectural style specifics, composition approach

**Enhanced Prompt:**
"Contemporary glass and steel skyscraper, low angle perspective looking up, blue hour twilight with interior lights glowing, urban cityscape background, architectural photography, clean geometric lines and reflective surfaces, shot on Canon R5 24mm tilt-shift, deep focus, cool color grading with blue tones, minimalist composition, professional architectural photography, highly detailed, 8k resolution"

**Word Count:** 55 words ✓

**Why It Works:**
- Material specificity (glass and steel)
- Strong perspective (low angle looking up)
- Optimal timing (blue hour twilight)
- Visual interest (interior lights glowing)
- Context (urban cityscape)
- Professional category (architectural photography)
- Architectural elements (geometric lines, reflective surfaces)
- Specialized lens (tilt-shift for architecture)
- Focus strategy (deep focus)
- Color palette (cool blues)
- Composition (minimalist)
- Professional standard

### Example 10: Historic Architecture

**User Request:**
"Old church building"

**Analysis:**
Missing: architectural details, historical period, lighting drama, compositional approach

**Enhanced Prompt:**
"Gothic cathedral with intricate stone facade, symmetrical frontal composition, golden hour sunlight illuminating weathered details, dramatic shadows emphasizing architectural depth, fine art architectural photography, shot on Hasselblad medium format 50mm, tilt-shift perspective correction, rich warm tones with deep shadows, inspired by architectural documentary photography, emphasize carved stone textures and stained glass windows, highly detailed, 8k resolution"

**Word Count:** 60 words ✓

**Why It Works:**
- Architectural style (Gothic cathedral)
- Detail emphasis (intricate stone facade)
- Classical composition (symmetrical frontal)
- Dramatic lighting (golden hour, shadows)
- Depth technique (shadows for architectural depth)
- Fine art approach
- Premium equipment (Hasselblad)
- Technical correction (tilt-shift)
- Period-appropriate colors (warm tones, deep shadows)
- Documentary reference
- Texture and feature callouts (carved stone, stained glass)

---

## Conceptual/Artistic Examples

### Example 11: Surreal Scene

**User Request:**
"Surreal desert landscape"

**Analysis:**
Missing: surreal elements, mood, color treatment, artistic references

**Enhanced Prompt:**
"Lone tree growing from cracked desert earth under impossible floating rocks, surreal landscape photography, late afternoon golden light, dreamlike and otherworldly atmosphere, shot on Hasselblad 80mm f/2.8, deep focus, rich color saturation with warm desert tones and cool sky blues, inspired by Salvador Dalí surrealism and Gregory Crewdson staged photography, cinematic composition, highly detailed, 8k resolution"

**Word Count:** 61 words ✓

**Why It Works:**
- Clear surreal element (floating rocks)
- Grounding detail (lone tree, cracked earth)
- Professional category (surreal landscape photography)
- Beautiful timing (late afternoon golden light)
- Mood establishment (dreamlike and otherworldly)
- Quality equipment (Hasselblad)
- Focus approach (deep focus for surreal clarity)
- Color specificity (warm desert, cool sky)
- Dual artistic references (Dalí, Crewdson)
- Cinematic quality
- Technical excellence markers

### Example 12: Atmospheric Portrait

**User Request:**
"Mysterious person in fog"

**Analysis:**
Missing: character details, setting, lighting mood, photographic approach

**Enhanced Prompt:**
"Silhouette of figure in long coat standing in dense fog, minimal visibility creating mystery, moody atmospheric photography, diffused overcast light, blue-grey color grading, shot on Sony A7R IV 85mm f/1.8, shallow depth of field with fog creating natural depth, noir cinematography aesthetic, inspired by film noir lighting, dramatic and ominous mood, highly detailed fog textures, cinematic composition"

**Word Count:** 60 words ✓

**Why It Works:**
- Character suggestion (silhouette, long coat)
- Atmosphere (dense fog, minimal visibility)
- Mood-driven category (moody atmospheric photography)
- Lighting type (diffused overcast)
- Color palette (blue-grey grading)
- Technical specs (Sony A7R IV 85mm)
- Depth technique (fog as depth element)
- Strong aesthetic reference (noir cinematography, film noir lighting)
- Emotional tone (dramatic and ominous)
- Texture detail (fog textures)
- Cinematic standard

---

## Automotive/Mechanical Examples

### Example 13: Classic Car

**User Request:**
"Vintage car photo"

**Analysis:**
Missing: car specifics, setting, time/lighting, photographic style

**Enhanced Prompt:**
"1960s vintage convertible parked on coastal highway overlook, sunset ocean view in background, automotive editorial photography, golden hour side lighting, warm nostalgic color grading with slight film grain, shot on Canon R5 50mm f/1.4, shallow depth of field isolating car, emphasize chrome details and period-correct paint, sense of freedom and nostalgia, highly detailed, professional automotive photography"

**Word Count:** 59 words ✓

**Why It Works:**
- Era specificity (1960s, convertible)
- Evocative setting (coastal highway overlook, ocean view)
- Professional category (automotive editorial)
- Perfect timing (golden hour)
- Lighting direction (side lighting)
- Mood through color (warm nostalgic, film grain)
- Quality equipment (Canon R5)
- Focus strategy (shallow DOF, car isolated)
- Detail emphasis (chrome, period paint)
- Emotional quality (freedom and nostalgia)
- Professional standard

### Example 14: Modern Vehicle

**User Request:**
"Sports car"

**Analysis:**
Missing: vehicle character, environment, lighting drama, commercial photography elements

**Enhanced Prompt:**
"Modern supercar in minimalist studio environment, low dramatic lighting creating strong shadows, automotive commercial photography, three-quarter front angle, shot on Phase One medium format 80mm, emphasize aerodynamic lines and reflective paint surface, cool color grading with metallic highlights, sleek and powerful aesthetic, professional car photography, tack sharp focus, highly detailed, 8k resolution"

**Word Count:** 56 words ✓

**Why It Works:**
- Vehicle type (modern supercar)
- Clean setting (minimalist studio)
- Dramatic lighting (low angle, strong shadows)
- Commercial approach
- Standard automotive angle (three-quarter front)
- Premium equipment (Phase One)
- Design emphasis (aerodynamic lines)
- Material callout (reflective paint)
- Color treatment (cool with metallic highlights)
- Brand aesthetic (sleek and powerful)
- Technical excellence (tack sharp, 8k)

---

## Wildlife/Nature Examples

### Example 15: Animal Portrait

**User Request:**
"Photo of a wolf"

**Analysis:**
Missing: environment context, behavior, lighting, wildlife photography specifics

**Enhanced Prompt:**
"Grey wolf standing alert in snowy forest clearing, winter landscape, wildlife documentary photography, soft overcast light, intimate eye contact with camera, shot on Canon R3 400mm f/2.8, shallow depth of field with blurred snow-covered trees, cool color palette with muted earth tones, National Geographic style, emphasize fur texture and intense eyes, highly detailed, professional wildlife photography"

**Word Count:** 59 words ✓

**Why It Works:**
- Species and behavior (grey wolf, standing alert)
- Contextual setting (snowy forest clearing, winter)
- Professional category (wildlife documentary)
- Appropriate lighting (soft overcast for winter)
- Connection element (eye contact)
- Wildlife lens (Canon 400mm telephoto)
- Subject isolation (shallow DOF, blurred background)
- Season-appropriate colors (cool palette, muted earth tones)
- Gold standard reference (National Geographic)
- Detail emphasis (fur texture, eyes)
- Professional benchmark

---

## Food Photography Examples

### Example 16: Gourmet Dish

**User Request:**
"Food photography of pasta"

**Analysis:**
Missing: dish specifics, plating, lighting setup, food styling details

**Enhanced Prompt:**
"Artisanal handmade pasta in white ceramic bowl, rustic wooden table setting, editorial food photography, natural window light from side creating soft shadows, garnished with fresh herbs and parmesan, shot on Canon R5 50mm f/2.8 macro, shallow depth of field with foreground bokeh, warm color grading with earthy tones, ingredients visible in background, highly detailed textures, professional food styling"

**Word Count:** 61 words ✓

**Why It Works:**
- Dish quality (artisanal handmade pasta)
- Presentation (white ceramic bowl)
- Setting atmosphere (rustic wooden table)
- Professional category (editorial food photography)
- Food photography lighting (natural window, soft shadows)
- Styling details (fresh herbs, parmesan garnish)
- Appropriate lens (macro for detail)
- Focus strategy (shallow DOF, foreground bokeh)
- Appetite-appeal colors (warm, earthy)
- Context (ingredients in background)
- Texture emphasis
- Professional styling

---

## Transformation Principles Summary

### From Basic to Midjourney Quality

**Always Add:**
1. **Professional category**: Editorial, cinematic, documentary, etc.
2. **Lighting specifics**: Direction, quality, time of day
3. **Technical specs**: Camera, lens, aperture
4. **Color treatment**: Specific grading and palette
5. **Composition approach**: Framing, perspective, rule of thirds
6. **Quality markers**: Highly detailed, professional, award-winning
7. **Mood/atmosphere**: Emotional tone through adjectives
8. **Artistic references**: When appropriate and relevant

**Enhancement Formula:**
```
Basic request → + Professional category + Specific details + Lighting +
Technical specs + Color treatment + Composition + Quality markers + Mood =
Midjourney-quality prompt
```

### Word Count Management

**If under 40 words after initial enhancement:**
- Add atmospheric details
- Include artistic reference
- Expand color treatment description
- Add texture or material emphasis

**If over 75 words:**
- Remove redundant quality terms
- Consolidate similar descriptors
- Keep most impactful elements
- Maintain coherent flow

### Quality Checklist

Before finalizing any enhanced prompt, verify:
- ✅ 40-75 word count range
- ✅ Professional photography category included
- ✅ Lighting described with direction and quality
- ✅ Technical camera/lens specs present
- ✅ Color treatment specified
- ✅ Composition guidance included
- ✅ At least 2-3 quality markers
- ✅ Mood or atmosphere conveyed
- ✅ Reads naturally and coherently
- ✅ No contradictory elements
