# n8n Docs

> Documentation for n8n, a workflow automation platform.

Documentation for n8n, a workflow automation platform. This file helps LLMs understand and use the documentation more effectively.


# All documentation

# Welcome to n8n Docs

This is the documentation for [n8n](https://n8n.io/), a [fair-code](https://faircode.io) licensed workflow automation tool that combines AI capabilities with business process automation.

It covers everything from setup to usage and development. It's a work in progress and all [contributions](help-community/contributing/) are welcome.

## Where to start

- **Quickstarts**

  Jump in with n8n's quickstart guides.

  [Try it out](try-it-out/)

- **Choose the right n8n for you**

  Cloud, npm, self-host . . .

  [Options](choose-n8n/)

- **Explore integrations**

  Browse n8n's integrations library.

  [Find your apps](integrations/)

- **Build AI functionality**

  n8n supports building AI functionality and tools.

  [Advanced AI](advanced-ai/)

## About n8n

n8n (pronounced n-eight-n) helps you to connect any app with an API with any other, and manipulate its data with little or no code.

- Customizable: highly flexible workflows and the option to build custom nodes.
- Convenient: use the npm or Docker to try out n8n, or the Cloud hosting option if you want us to handle the infrastructure.
- Privacy-focused: self-host n8n for privacy and security.

# n8n v1.0 migration guide

This document provides a summary of what you should be aware of before updating to version 1.0 of n8n.

The release of n8n 1.0 marks a milestone in n8n's journey to make n8n available for demanding production environments. Version 1.0 represents the hard work invested over the last four years to make n8n the most accessible, powerful, and versatile automation tool. n8n 1.0 is now ready for use in production.

## New features

### Python support in the Code node

Although JavaScript remains the default language, you can now also select Python as an option in the [Code node](../code/code-node/) and even make use of [many Python modules](https://pyodide.org/en/stable/usage/packages-in-pyodide.html#packages-in-pyodide). Note that Python is unavailable in Code nodes added to a workflow before v1.0.

[PR #4295](https://github.com/n8n-io/n8n/pull/4295), [PR #6209](https://github.com/n8n-io/n8n/pull/6209)

### Execution order

n8n 1.0 introduces a new execution order for multi-branch workflows:

In multi-branch workflows, n8n needs to determine the order in which to execute nodes on branches. Previously, n8n executed the first node of each branch, then the second of each branch, and so on (breadth-first). The new execution order ensures that each branch executes completely before starting the next one (depth-first). Branches execute based on their position on the canvas, from top to bottom. If two branches are at the same height, the leftmost one executes first.

n8n used to execute multi-input nodes as long as they received data on their first input. Nodes connected to the second input of multi-input nodes automatically executed regardless of whether they received data. The new execution order introduced in n8n 1.0 simplifies this behavior: Nodes are now executed only when they receive data, and multi-input nodes require data on at least one of their inputs to execute.

Your existing workflows will use the legacy order, while new workflows will execute using the v1 order. You can configure the execution order for each workflow in [workflow settings](../workflows/settings/).

[PR #4238](https://github.com/n8n-io/n8n/pull/4238), [PR #6246](https://github.com/n8n-io/n8n/pull/6246), [PR #6507](https://github.com/n8n-io/n8n/pull/6507)

## Deprecations

### MySQL and MariaDB

n8n has deprecated support for MySQL and MariaDB as storage backends for n8n. These database systems are used by only a few users, yet they require continuous development and maintenance efforts. n8n recommends migrating to PostgreSQL for better compatibility and long-term support.

[PR #6189](https://github.com/n8n-io/n8n/pull/6189)

### EXECUTIONS_PROCESS and "own" mode

Previously, you could use the `EXECUTIONS_PROCESS` environment variable to specify whether executions should run in the `main` process or in their `own` processes. This option and `own` mode are now deprecated and will be removed in a future version of n8n. This is because it led to increased code complexity while offering marginal benefits. Starting from n8n 1.0, `main` will be the new default.

Note that executions start much faster in `main` mode than in `own` mode. However, if a workflow consumes more memory than is available, it might crash the entire n8n application instead of just the worker thread. To mitigate this, make sure to allocate enough system resources or configure [queue mode](../hosting/scaling/queue-mode/) to distribute executions among multiple workers.

[PR #6196](https://github.com/n8n-io/n8n/pull/6196)

## Breaking changes

### Docker

#### Permissions change

When using Docker-based deployments, the n8n process is now run by the user `node` instead of `root`. This change increases security.

If permission errors appear in your n8n container logs when starting n8n, you may need to update the permissions by executing the following command on the Docker host:

```
docker run --rm -it --user root -v ~/.n8n:/home/node/.n8n --entrypoint chown n8nio/base:16 -R node:node /home/node/.n8n
```

#### Image removal

We've removed the Debian and RHEL images. If you were using these you need to change the image you use. This shouldn't result in any errors unless you were making a custom image based on one of those images.

#### Entrypoint change

The entrypoint for the container has changed and you no longer need to specify the n8n command. If you were previously running `n8n worker --concurrency=5` it's now `worker --concurrency=5`

[PR #6365](https://github.com/n8n-io/n8n/pull/6365)

### Workflow failures due to expression errors

Workflow executions may fail due to syntax or runtime errors in expressions, such as those that reference non-existent nodes. While expressions already throw errors on the frontend, this change ensures that n8n also throws errors on the backend, where they were previously silently ignored. To receive notifications of failing workflows, n8n recommends setting up an "error workflow" under workflow settings.

[PR #6352](https://github.com/n8n-io/n8n/pull/6352)

### Mandatory owner account

This change makes [User Management](../user-management/) mandatory and removes support for other authentication methods, such as BasicAuth and External JWT. Note that the number of permitted users on [n8n.cloud](https://n8n.cloud/) or custom plans still varies depending on your subscription.

[PR #6362](https://github.com/n8n-io/n8n/pull/6362)

### Directory for installing custom nodes

n8n will no longer load custom nodes from its global `node_modules` directory. Instead, you must install (or link) them to `~/.n8n/custom` (or a directory defined by `N8N_CUSTOM_EXTENSIONS`). Custom nodes that are npm packages will be located in `~/.n8n/nodes`. If you have custom nodes that were linked using `npm link` into the global `node_modules` directory, you need to link them again, into `~/.n8n/nodes` instead.

[PR #6396](https://github.com/n8n-io/n8n/pull/6396)

### WebSockets

The `N8N_PUSH_BACKEND` environment variable can be used to configure one of two available methods for pushing updates to the user interface: `sse` and `websocket`. Starting with n8n 1.0, `websocket` is the default method.

[PR #6196](https://github.com/n8n-io/n8n/pull/6196)

### Date transformation functions

n8n provides various transformation functions that operate on dates. These functions may return either a JavaScript `Date` or a Luxon `DateTime` object. With the new behavior, the return type always matches the input. If you call a date transformation function on a `Date`, it returns a `Date`. Similarly, if you call it on a `DateTime` object, it returns a `DateTime` object.

To identify any workflows and nodes that might be impacted by this change, you can use this [utility workflow](https://n8n.io/workflows/1929-v1-helper-find-params-with-affected-expressions/).

For more information about date transformation functions, please refer to the [official documentation](../code/builtin/data-transformation-functions/dates/).

[PR #6435](https://github.com/n8n-io/n8n/pull/6435)

### Execution data retention

Starting from n8n 1.0, all successful, failed, and manual workflow executions will be saved by default. These settings can be modified for each workflow under "Workflow Settings," or globally using the respective environment variables. Additionally, the `EXECUTIONS_DATA_PRUNE` setting will be enabled by default, with `EXECUTIONS_DATA_PRUNE_MAX_COUNT` set to 10,000. These default settings are designed to prevent performance degradation when using SQLite. Make sure to configure them according to your individual requirements and system capacity.

[PR #6577](https://github.com/n8n-io/n8n/pull/6577)

### Removed N8N_USE_DEPRECATED_REQUEST_LIB

The legacy `request` library has been deprecated for some time now. As of n8n 1.0, the ability to fall back to it in the HTTP Request node by setting the `N8N_USE_DEPRECATED_REQUEST_LIB` environment variable has been fully removed. The HTTP Request node will now always use the new `HttpRequest` interface.

If you build custom nodes, refer to [HTTP request helpers](../integrations/creating-nodes/build/reference/http-helpers/) for more information on migrating to the new interface.

[PR #6413](https://github.com/n8n-io/n8n/pull/6413)

### Removed WEBHOOK_TUNNEL_URL

As of version 0.227.0, n8n has renamed the `WEBHOOK_TUNNEL_URL` configuration option to `WEBHOOK_URL`. In n8n 1.0, `WEBHOOK_TUNNEL_URL` has been removed. Update your setup to reflect the new name. For more information about this configuration option, refer to [the docs](../hosting/configuration/configuration-examples/webhook-url/).

[PR #1408](https://github.com/n8n-io/n8n/pull/1408)

### Remove Node 16 support

n8n now requires Node 18.17.0 or above.

## Updating to n8n 1.0

1. Create a full backup of n8n.
1. n8n recommends updating to the latest n8n 0.x release before updating to n8n 1.x. This will allow you to pinpoint any potential issues to the correct release. Once you have verified that n8n 0.x starts up without any issues, proceed to the next step.
1. Carefully read the [Deprecations](#deprecations) and [Breaking Changes](#breaking-changes) sections above to assess how they may affect your setup.
1. Update to n8n 1.0:
   - During beta (before July 24th 2023): If using Docker, pull the `next` Docker image.
   - After July 24th 2023: If using Docker, pull the `latest` Docker image.
1. If you encounter any issues, redeploy the previous n8n version and restore the backup.

## Reporting issues

If you encounter any issues during the process of updating to n8n 1.0, please seek help in the community [forum](https://community.n8n.io/).

## Thank you

We would like to take a moment to express our gratitude to all of our users for their continued support and feedback. Your contributions are invaluable in helping us make n8n the best possible automation tool. We're excited to continue working with you as we move forward with the release of version 1.0 and beyond. Thank you for being a part of our journey!

# Choose your n8n

This section contains information on n8n's range of platforms, pricing plans, and licenses.

## Platforms

There are different ways to set up n8n depending on how you intend to use it:

- [n8n Cloud](../manage-cloud/overview/): hosted solution, no need to install anything.
- [Self-host](../hosting/): recommended method for production or customized use cases.
  - [npm](../hosting/installation/npm/)
  - [Docker](../hosting/installation/docker/)
  - [Server setup guides](../hosting/installation/server-setups/) for popular platforms
- [Embed](../embed/): n8n Embed allows you to white label n8n and build it into your own product. Contact n8n on the [Embed website](https://n8n.io/embed/) for pricing and support.

Self-hosting knowledge prerequisites

Self-hosting n8n requires technical knowledge, including:

- Setting up and configuring servers and containers
- Managing application resources and scaling
- Securing servers and applications
- Configuring n8n

n8n recommends self-hosting for expert users. Mistakes can lead to data loss, security issues, and downtime. If you aren't experienced at managing servers, n8n recommends [n8n Cloud](https://n8n.io/cloud/).

## Licenses

n8n's [Sustainable Use License](https://github.com/n8n-io/n8n/blob/master/LICENSE.md) and [n8n Enterprise License](https://github.com/n8n-io/n8n/blob/master/LICENSE_EE.md) are based on the [fair-code](https://faircode.io/) model.

For a detailed explanation of the license, refer to [Sustainable Use License](../sustainable-use-license/).

## Free versions

n8n offers the following free options:

- A free trial of Cloud
- A free self-hosted community edition for self-hosted users

## Paid versions

n8n has two paid versions:

- n8n Cloud: choose from a range of paid plans to suit your usage and feature needs.
- Self-hosted: there are both free and paid versions of self-hosted.

For details of the Cloud plans and contact details for Enterprise Self-hosted, refer to [Pricing](https://n8n.io/pricing/) on the n8n website.

# External secrets

Feature availability

- External secrets are available on Enterprise Self-hosted and Enterprise Cloud plans.
- n8n supports AWS Secrets Manager, Azure Key Vault, GCP Secrets Manager, Infisical and HashiCorp Vault.
- n8n doesn't support [HashiCorp Vault Secrets](https://developer.hashicorp.com/hcp/docs/vault-secrets).

You can use an external secrets store to manage [credentials](../glossary/#credential-n8n) for n8n.

n8n stores all credentials encrypted in its database, and restricts access to them by default. With the external secrets feature, you can store sensitive credential information in an external vault, and have n8n load it in when required. This provides an extra layer of security and allows you to manage credentials used across multiple [n8n environments](../source-control-environments/) in one central place.

## Connect n8n to your secrets store

Secret names

Your secret names can't contain spaces, hyphens, or other special characters. n8n supports secret names containing alphanumeric characters (`a-z`, `A-Z`, and `0-9`), and underscores. n8n currently only supports plaintext values for secrets, not JSON objects or key-value pairs.

1. In n8n, go to **Settings** > **External Secrets**.

1. Select **Set Up** for your store provider.

1. Enter the credentials for your provider:

   - Azure Key Vault: Provide your **vault name**, **tenant ID**, **client ID**, and **client secret**. Refer to the Azure documentation to [register a Microsoft Entra ID app and create a service principal](https://learn.microsoft.com/en-us/entra/identity-platform/howto-create-service-principal-portal). n8n supports only single-line values for secrets.

   - AWS Secrets Manager: provide your **access key ID**, **secret access key**, and **region**. The IAM user must have the `secretsmanager:ListSecrets`, `secretsmanager:BatchGetSecretValue`, and `secretsmanager:GetSecretValue` permissions.

     To give n8n access to all secrets in your AWS Secrets Manager, you can attach the following policy to the IAM user:

     ```
     {
     	"Version": "2012-10-17",
     	"Statement": [
     		{
     			"Sid": "AccessAllSecrets",
     			"Effect": "Allow",
     			"Action": [
     				"secretsmanager:ListSecrets",
     				"secretsmanager:BatchGetSecretValue",
     				"secretsmanager:GetResourcePolicy",
     				"secretsmanager:GetSecretValue",
     				"secretsmanager:DescribeSecret",
     				"secretsmanager:ListSecretVersionIds",
     			],
     			"Resource": "*"
     		}
     	]
     }
     ```

     You can also be more restrictive and give n8n access to select specific AWS Secret Manager secrets. You still need to allow the `secretsmanager:ListSecrets` and `secretsmanager:BatchGetSecretValue` permissions to access all resources. These permissions allow n8n to retrieve ARN-scoped secrets, but don't provide access to the secret values.

     Next, you need set the scope for the `secretsmanager:GetSecretValue` permission to the specific Amazon Resource Names (ARNs) for the secrets you wish to share with n8n. Ensure you use the correct region and account ID in each resource ARNs. You can find the ARN details in the AWS dashboard for your secrets.

     For example, the following IAM policy only allows access to secrets with a name starting with `n8n` in your specified AWS account and region:

     ```
     {
     	"Version": "2012-10-17",
     	"Statement": [
     		{
     			"Sid": "ListingSecrets",
     			"Effect": "Allow",
     			"Action": [
     				"secretsmanager:ListSecrets",
     				"secretsmanager:BatchGetSecretValue"
     			],
     			"Resource": "*"
     		},
     		{
     			"Sid": "RetrievingSecrets",
     			"Effect": "Allow",
     			"Action": [
     				"secretsmanager:GetSecretValue",
     				"secretsmanager:DescribeSecret"
     			],
     			"Resource": [
     				"arn:aws:secretsmanager:us-west-2:123456789000:secret:n8n*"
     			]
     		}
     	]
     }
     ```

     For more IAM permission policy examples, consult the [AWS documentation](https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access_iam-policies.html#auth-and-access_examples_batch).

   - HashiCorp Vault: provide the **Vault URL** for your vault instance, and select your **Authentication Method**. Enter your authentication details. Optionally provide a namespace.

     - Refer to the HashiCorp documentation for your authentication method: [Token auth method](https://developer.hashicorp.com/vault/docs/auth/token)\
       [AppRole auth method](https://developer.hashicorp.com/vault/docs/auth/approle)\
       [Userpass auth method](https://developer.hashicorp.com/vault/docs/auth/userpass)
     - If you use vault namespaces, you can enter the namespace n8n should connect to. Refer to [Vault Enterprise namespaces](https://developer.hashicorp.com/vault/docs/enterprise/namespaces) for more information on HashiCorp Vault namespaces.

   - Infisical: provide a **Service Token**. Refer to Infisical's [Service token](https://infisical.com/docs/documentation/platform/token) documentation for information on getting your token. If you self-host Infisical, enter the **Site URL**.

     Infisical environment

     Make sure you select the correct Infisical environment when creating your token. n8n will load secrets from this environment, and won't have access to secrets in other Infisical environments. n8n only support service tokens that have access to a single environment.

     Infisical folders

     n8n doesn't support [Infisical folders](https://infisical.com/docs/documentation/platform/folder).

   - Google Cloud Platform: provide a **Service Account Key** (JSON) for a service account that has at least these roles: `Secret Manager Secret Accessor` and `Secret Manager Secret Viewer`. Refer to Google's [service account documentation](https://cloud.google.com/iam/docs/service-account-overview) for more information.

1. **Save** your configuration.

1. Enable the provider using the **Disabled / Enabled** toggle.

## Use secrets in n8n credentials

To use a secret from your store in an n8n credential:

1. Create a new credential, or open an existing one.

1. On the field where you want to use a secret:

   1. Hover over the field.
   1. Select **Expression**.

1. In the field where you want to use a secret, enter an [expression](../glossary/#expression-n8n) referencing the secret name:

   ```
   {{ $secrets.<vault-name>.<secret-name> }}
   ```

   `<vault-name>` is either `vault` (for HashiCorp) or `infisical` or `awsSecretsManager`. Replace `<secret-name>` with the name as it appears in your vault.

## Using external secrets with n8n environments

n8n's [Source control and environments](../source-control-environments/) feature allows you to create different n8n environments, backed by Git. The feature doesn't support using different credentials in different instances. You can use an external secrets vault to provide different credentials for different environments by connecting each n8n instance to a different vault or project environment.

For example, you have two n8n instances, one for development and one for production. You use Infisical for your vault. In Infisical, create a project with two environments, development and production. Generate a token for each Infisical environment. Use the token for the development environment to connect your development n8n instance, and the token for your production environment to connect your production n8n instance.

## Using external secrets in projects

To use external secrets in an [RBAC project](../user-management/rbac/), you must have an [instance owner or instance admin](../user-management/account-types/) as a member of the project.

## Troubleshooting

### Infisical version changes

Infisical version upgrades can introduce problems connecting to n8n. If your Infisical connection stops working, check if there was a recent version change. If so, report the issue to help@n8n.io.

### Only set external secrets on credentials owned by an instance owner or admin

Due to the permissions that instance owners and admins have, it's possible for owners and admins to update credentials owned by another user with a secrets expression. This will appear to work in preview for an instance owner or admin, but the secret won't resolve when the workflow runs in production.

Only use external secrets for credentials that are owned by an instance admin or owner. This ensures they resolve correctly in production.

#### AI agent

AI agents are artificial intelligence systems capable of responding to requests, making decisions, and performing real-world tasks for users. They use large language models (LLMs) to interpret user input and make decisions about how to best process requests using the information and resources they have available.

#### AI chain

AI chains allow you to interact with large language models (LLMs) and other resources in sequences of calls to components. AI chains in n8n don't use persistent memory, so you can't use them to reference previous context (use AI agents for this).

#### AI completion

Completions are the responses generated by a model like GPT.

#### AI embedding

Embeddings are numerical representations of data using vectors. They're used by AI to interpret complex data and relationships by mapping values across many dimensions. Vector databases, or vector stores, are databases designed to store and access embeddings.

#### AI groundedness

In AI, and specifically in retrieval-augmented generation (RAG) contexts, groundedness and ungroundedness are measures of how much a model's responses accurately reflect source information. The model uses its source documents to generate grounded responses, while ungrounded responses involve speculation or hallucination unsupported by those same sources.

#### AI hallucination

Hallucination in AI is when an LLM (large language model) mistakenly perceives patterns or objects that don't exist.

#### AI reranking

Reranking is a technique that refines the order of a list of candidate documents to improve the relevance of search results. Retrieval-Augmented Generation (RAG) and other applications use reranking to prioritize the most relevant information for generation or downstream tasks.

#### AI memory

In an AI context, memory allows AI tools to persist message context across interactions. This allows you to have a continuing conversations with AI agents, for example, without submitting ongoing context with each message. In n8n, AI agent nodes can use memory, but AI chains can't.

#### AI retrieval-augmented generation (RAG)

Retrieval-augmented generation, or RAG, is a technique for providing LLMs access to new information from external sources to improve AI responses. RAG systems retrieve relevant documents to ground responses in up-to-date, domain-specific, or proprietary knowledge to supplement their original training data. RAG systems often rely on vector stores to manage and search this external data efficiently.

#### AI tool

In an AI context, a tool is an add-on resource that the AI can refer to for specific information or functionality when responding to a request. The AI model can use a tool to interact with external systems or complete specific, focused tasks.

#### AI vector store

A vector store, or vector database, stores mathematical representations of information. Use with embeddings and retrievers to create a database that your AI can access when answering questions.

#### API

APIs, or application programming interfaces, offer programmatic access to a service's data and functionality. APIs make it easier for software to interact with external systems. They're often offered as an alternative to traditional user-focused interfaces accessed through web browsers or UI.

#### canvas (n8n)

The canvas is the main interface for building workflows in n8n's editor UI. You use the canvas to add and connect nodes to compose workflows.

#### cluster node (n8n)

In n8n, cluster nodes are groups of nodes that work together to provide functionality in a workflow. They consist of a root node and one or more sub nodes that extend the node's functionality.

#### credential (n8n)

In n8n, credentials store authentication information to connect with specific apps and services. After creating credentials with your authentication information (username and password, API key, OAuth secrets, etc.), you can use the associated app node to interact with the service.

#### data pinning (n8n)

Data pinning allows you to temporarily freeze the output data of a node during workflow development. This allows you to develop workflows with predictable data without making repeated requests to external services. Production workflows ignore pinned data and request new data on each execution.

#### editor (n8n)

The n8n editor UI allows you to create and manage workflows. The main area is the canvas, where you can compose workflows by adding, configuring, and connecting nodes. The side and top panels allow you to access other areas of the UI like credentials, templates, variables, executions, and more.

#### entitlement (n8n)

In n8n, entitlements grant n8n instances access to plan-restricted features for a specific period of time.

Floating entitlements are a pool of entitlements that you can distribute among various n8n instances. You can re-assign a floating entitlement to transfer its access to a different n8n instance.

#### evaluation (n8n)

In n8n, evaluation allows you to tag and organize execution history and compare it against new executions. You can use this to understand how your workflow performs over time as you make changes. In particular, this is useful while developing AI-centered workflows.

#### expression (n8n)

In n8n, expressions allow you to populate node parameters dynamically by executing JavaScript code. Instead of providing a static value, you can use the n8n expression syntax to define the value using data from previous nodes, other workflows, or your n8n environment.

#### LangChain

LangChain is an AI-development framework used to work with large language models (LLMs). LangChain provides a standardized system for working with a wide variety of models and other resources and linking different components together to build complex applications.

#### Large language model (LLM)

Large language models, or LLMs, are AI machine learning models designed to excel in natural language processing (NLP) tasks. They're built by training on large amounts of data to develop probabilistic models of language and other data.

#### node (n8n)

In n8n, nodes are individual components that you compose to create workflows. Nodes define when the workflow should run, allow you to fetch, send, and process data, can define flow control logic, and connect with external services.

#### project (n8n)

n8n projects allow you to separate workflows, variables, and credentials into separate groups for easier management. Projects make it easier for teams to collaborate by sharing and compartmentalizing related resources.

#### root node (n8n)

Each n8n cluster node contains a single root nodes that defines the main functionality of the cluster. One or more sub nodes attach to the root node to extend its functionality.

#### sub node (n8n)

n8n cluster nodes consist of one or more sub nodes connected to a root node. Sub nodes extend the functionality of the root node, providing access to specific services or resources or offering specific types of dedicated processing, like calculator functionality, for example.

#### template (n8n)

n8n templates are pre-built workflows designed by n8n and community members that you can import into your n8n instance. When using templates, you may need to fill in credentials and adjust the configuration to suit your needs.

#### trigger node (n8n)

A trigger node is a special node responsible for executing the workflow in response to certain conditions. All production workflows need at least one trigger to determine when the workflow should run.

#### workflow (n8n)

An n8n workflow is a collection of nodes that automate a process. Workflows begin execution when a trigger condition occurs and execute sequentially to achieve complex tasks.

# Insights

Insights gives instance owners and admins visibility into how workflows perform over time. This feature consists of three parts:

- [**Insights summary banner**](#insights-summary-banner): Shows key metrics about your instance from the last 7 days at the top of the overview space.
- [**Insights dashboard**](#insights-dashboard): A more detailed visual breakdown with per-workflow metrics and historical comparisons.
- [**Time saved (Workflow ROI)**](#setting-the-time-saved-by-a-workflow): For each workflow, you can set the number of minutes of work that each production execution saves you.

Feature availability

The insights summary banner displays activity from the last 7 days for all plans. The insights dashboard is only available on Pro (with limited date ranges) and Enterprise plans.

## Insights summary banner

n8n collects several metrics for both the insights summary banner and dashboard. They include:

- Total production executions (not including sub-workflow executions or manual executions)
- Total failed production executions
- Production execution failure rate
- Time saved (when set on at least one or more active workflows)
- Run time average (including wait time from any wait nodes)

## Insights dashboard

Those on the Pro and Enterprise plans can access the **Insights** section from the side navigation. Each metric from the summary banner is also clickable, taking you to the corresponding chart.

The insights dashboard also has a table showing individual insights from each workflow including total production executions, failed production executions, failure rate, time saved, and run time average.

## Insights time periods

By default, the insights summary banner and dashboard show a rolling 7 day window with a comparison to the previous period to identify increases or decreases for each metric. On the dashboard, paid plans also display data for other date ranges:

- Pro: 7 and 14 days
- Enterprise: 24 hours, 7 days, 14 days, 30 days, 90 days, 6 months, 1 year

## Setting the time saved by a workflow

For each workflow, you can set the number of minutes of work a workflow saves you each time it runs. You can configure this by navigating to the workflow, selecting the three dots menu in the top right and selecting settings. There you can update the **Estimated time saved** value and save.

This setting helps you calculate how much time automating a process saves over time vs the manual effort to complete the same task or process. Once set, n8n calculates the amount of time the workflow saves you based on the number of production executions and displays it on the summary banner and dashboard.

## Disable or configure insights metrics collection

If you self-host n8n, you can disable or configure insights and metrics collection using [environment variables](../hosting/configuration/environment-variables/insights/).

## Insights FAQs

### Which executions do n8n use to calculate the values in the insights banner and dashboard?

n8n insights only collects data from production executions (for example, those from active workflows triggered on a schedule or a webhook) from the main (parent) workflow. This means that it doesn't count manual (test) executions or executions from sub-workflows or error workflows.

### Does n8n use historic execution data when upgrading to a version with insights?

n8n only starts collecting data for insights once you update to the first supported version (1.89.0). This means it only reports on executions from that point forward and you won't see execution data in insights from prior periods.

# Keyboard shortcuts and controls

n8n provides keyboard shortcuts for some actions.

## Workflow controls

- **Ctrl** + **Alt** + **n**: create new workflow
- **Ctrl** + **o**: open workflow
- **Ctrl** + **s**: save the current workflow
- **Ctrl** + **z**: undo
- **Ctrl** + **shift** + **z**: redo
- **Ctrl** + **Enter**: execute workflow

## Canvas

### Move the canvas

- **Ctrl** + **Left Mouse Button** + drag: move node view
- **Ctrl** + **Middle mouse button** + drag: move node view
- **Space** + drag: move node view
- **Middle mouse button** + drag: move node view
- Two fingers on a touch screen: move node view

### Canvas zoom

- **+** or **=**: zoom in
- **-** or **\_**: zoom out
- **0**: reset zoom level
- **1**: zoom to fit workflow
- **Ctrl** + **Mouse wheel**: zoom in/out

### Nodes on the canvas

- **Double click** on a node: open the node details
- **Ctrl/Cmd** + **Double click** on a sub-workflow node: open the sub-workflow in a new tab
- **Ctrl** + **a**: select all nodes
- **Ctrl** + **v**: paste nodes
- **Shift** + **s**: add sticky note

### With one or more nodes selected in canvas

- **ArrowDown**: select sibling node below the current one
- **ArrowLeft**: select node left of the current one
- **ArrowRight**: select node right of the current one
- **ArrowUp**: select sibling node above the current one
- **Ctrl** + **c**: copy
- **Ctrl** + **x**: cut
- **D**: deactivate
- **Delete**: delete
- **Enter**: open
- **F2**: rename
- **P**: pin data in node. Refer to [Data pinning](../data/data-pinning/) for more information.
- **Shift** + **ArrowLeft**: select all nodes left of the current one
- **Shift** + **ArrowRight**: select all nodes right of the current one
- **Ctrl/Cmd** + **Shift** + **o** on a sub-workflow node: open the sub-workflow in a new tab

## Node panel

- **Tab**: open the Node Panel
- **Enter**: insert selected node into workflow
- **Escape**: close Node panel

### Node panel categories

- **Enter**: insert node into workflow, collapse/expand category, open subcategory
- **ArrowRight**: expand category, open subcategory
- **ArrowLeft**: collapse category, close subcategory view

## Within nodes

- **=**: in an empty parameter input, this switches to [expressions](../glossary/#expression-n8n) mode.

This guide outlines a series of tutorials and resources designed to get you started with n8n.

It's not necessary to complete all items listed to start using n8n. Use this as a reference to navigate to the most relevant parts of the documentation and other resources according to your needs.

## Join the community

n8n has an active community where you can get and offer help. Connect, share, and learn with other n8n users:

- [Ask questions](https://community.n8n.io/t/readme-welcome-to-the-n8n-community/44381) and [make feature requests](https://community.n8n.io/c/feature-requests) in the Community Forum.
- [Report bugs](https://github.com/n8n-io/n8n/issues) and [contribute](https://github.com/n8n-io/n8n/blob/master/CONTRIBUTING.md) on GitHub.

## Set up your n8n

If you don't have an account yet, sign up to a [free trial on n8n Cloud](https://app.n8n.cloud/register) or install n8n's community edition with [Docker](../hosting/installation/docker/) (recommended) or [npm](../hosting/installation/npm/). See [Choose your n8n](../choose-n8n/) for more details.

## Try it out

Start with the quickstart guides to help you get up and running with building basic workflows.

- [A very quick quickstart](../try-it-out/quickstart/)
- [A longer introduction](../try-it-out/tutorial-first-workflow/)
- [Build an AI workflow in n8n](../advanced-ai/intro-tutorial/)

## Structured Courses

n8n offers two sets of courses.

### Video courses

Learn key concepts and n8n features, while building examples as you go.

- The [Beginner](https://www.youtube.com/playlist?list=PLlET0GsrLUL59YbxstZE71WszP3pVnZfI) course covers the basics of n8n.
- The [Advanced](https://www.youtube.com/playlist?list=PLlET0GsrLUL5bxmx5c1H1Ms_OtOPYZIEG) course covers more complex workflows, more technical nodes, and enterprise features

### Text courses

Build more complex workflows while learning key concepts along the way. Earn a badge and an avatar in your community profile.

- [Level 1: Beginner Course](https://blog.n8n.io/announcing-the-n8n-certification-course-for-beginners-level-1/)
- [Level 2: Intermediate Course](https://blog.n8n.io/announcing-course-level-two/)

## Self-hosting n8n

Explore various [self-hosting options in n8n](../hosting/). If you’re not sure where to start, these are two popular options:

- [Hosting n8n on DigitalOcean](../hosting/installation/server-setups/digital-ocean/)
- [Hosting n8n on Amazon Web Services](../hosting/installation/server-setups/aws/)

## Build a node

If you can't find a node for a specific app or a service, you can build a node yourself and share with the community. See what others have built on [npm website](https://www.npmjs.com/search?q=keywords:n8n-community-node-package).

- [Build a declarative-style node](../integrations/creating-nodes/build/declarative-style-node/)
- [Learn how to build your own n8n nodes (Youtube Video)](https://www.youtube.com/live/OI6zHJ56eW0?si=SMD7L1J5fZ2mf79W)

## Stay updated

- Follow new features and bug fixes in the [Release Notes](../release-notes/)
- Follow n8n on socials: [Twitter/X](https://twitter.com/n8n_io), [Discord](https://discord.com/invite/vWwMVThRta), [LinkedIn](https://www.linkedin.com/company/n8n/), [YouTube](https://www.youtube.com/@n8n-io)

# License Key

To enable certain licensed features, you must first activate your license. You can do this either through the UI or by setting environment variables.

## Add a license key using the UI

In your n8n instance:

1. Log in as **Admin** or **Owner**.
1. Select **Settings** > **Usage and plan**.
1. Select **Enter activation key**.
1. Paste in your license key.
1. Select **Activate**.

## Add a license key using an environment variables

In your n8n configuration, set `N8N_LICENSE_ACTIVATION_KEY` to your license key. If the instance already has an activated license, this variable will have no effect.

Refer to [Environment variables](../hosting/configuration/configuration-methods/) to learn more about configuring n8n.

## Allowlist the license server IP addresses

n8n uses Cloudflare to host the license server. As the specific IP addresses can change, you need to allowlist the [full range of Cloudflare IP addresses](https://www.cloudflare.com/ips/) to ensure n8n can always reach the license server.

# Log streaming

Feature availability

Log Streaming is available on all Enterprise plans.

Log streaming allows you to send events from n8n to your own logging tools. This allows you to manage your n8n monitoring in your own alerting and logging processes.

## Set up log streaming

To use log streaming, you have to add a streaming destination.

1. Navigate to **Settings** > **Log Streaming**.
1. Select **Add new destination**.
1. Choose your destination type. n8n opens the **New Event Destination** modal.
1. In the **New Event Destination** modal, enter the configuration information for your event destination. These depend on the type of destination you're using.
1. Select **Events** to choose which events to stream.
1. Select **Save**.

Self-hosted users

If you self-host n8n, you can configure additional log streaming behavior using [Environment variables](../hosting/configuration/environment-variables/logs/#log-streaming).

## Events

The following events are available. You can choose which events to stream in **Settings** > **Log Streaming** > **Events**.

- Workflow
  - Started
  - Success
  - Failed
- Node executions
  - Started
  - Finished
- Audit
  - User signed up
  - User updated
  - User deleted
  - User invited
  - User invitation accepted
  - User re-invited
  - User email failed
  - User reset requested
  - User reset
  - User credentials created
  - User credentials shared
  - User credentials updated
  - User credentials deleted
  - User API created
  - User API deleted
  - Package installed
  - Package updated
  - Package deleted
  - Workflow created
  - Workflow deleted
  - Workflow updated
- AI node logs
  - Memory get messages
  - Memory added message
  - Output parser get instructions
  - Output parser parsed
  - Retriever get relevant documents
  - Embeddings embedded document
  - Embeddings embedded query
  - Document processed
  - Text splitter split
  - Tool called
  - Vector store searched
  - LLM generated
  - Vector store populated
- Runner
  - Task requested
  - Response received
- Queue
  - Job enqueued
  - Job dequeued
  - Job completed
  - Job failed
  - Job stalled

## Destinations

n8n supports three destination types:

- A syslog server
- A generic webhook
- A Sentry client

# Release notes

New features and bug fixes for n8n.

You can also view the [Releases](https://github.com/n8n-io/n8n/releases) in the GitHub repository.

Latest and Next versions

n8n releases a new minor version most weeks. The `latest` version is for production use. `next` is the most recent release. You should treat `next` as a beta: it may be unstable. To report issues, use the [forum](https://community.n8n.io/c/questions/12).

Current `latest`: 1.118.2\
Current `next`: 1.119.0

## How to update n8n

The steps to update your n8n depend on which n8n platform you use. Refer to the documentation for your n8n:

- [Cloud](../manage-cloud/update-cloud-version/)
- Self-hosted options:
  - [npm](../hosting/installation/npm/)
  - [Docker](../hosting/installation/docker/)

## Semantic versioning in n8n

n8n uses [semantic versioning](https://semver.org/). All version numbers are in the format `MAJOR.MINOR.PATCH`. Version numbers increment as follows:

- MAJOR version when making incompatible changes which can require user action.
- MINOR version when adding functionality in a backward-compatible manner.
- PATCH version when making backward-compatible bug fixes.

Older versions

You can find the release notes for older versions of n8n [here](0-x/)

## n8n@1.118.2

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.118.1...n8n@1.118.2) for this version.\
**Release date:** 2025-11-05

Latest version

This is the `latest` version. n8n recommends using the `latest` version. The `next` version may be unstable. To report issues, use the [forum](https://community.n8n.io/c/questions/12).

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.119.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.118.0...n8n@1.119.0) for this version.\
**Release date:** 2025-11-03

Next version

This is the `next` version. n8n recommends using the `latest` version. The `next` version may be unstable. To report issues, use the [forum](https://community.n8n.io/c/questions/12).

This release includes multiple bug fixes for AI Agent, task runners, editor, and integrations, as well as new features like improved workflow settings, AWS Assume Role credentials, and enhanced security and audit capabilities.

### Guardrails Node

The Guardrails node provides a set of rules and policies that control an AI agent's behavior by filtering its inputs and outputs. This helps safeguard from malicious input and from generating unsafe or undesirable responses. There are two operations:

- Check Text for Violations: Validate text against a set of policies (e.g. NSFW, prompt injection).
- Sanitize Text: Detects and replaces specific data such as PII, URLs, or secrets with placeholders.

The default presets and prompts are adapted from the open-source [guardrails package](https://github.com/openai/openai-guardrails-js) made available by OpenAI.

For more info, see [Guardrails documentation](../integrations/builtin/core-nodes/n8n-nodes-langchain.guardrails/)

### Contributors

[cesars-gh](https://github.com/cesars-gh)\
[ongdisheng](https://github.com/ongdisheng)

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.118.1

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.118.0...n8n@1.118.1) for this version.\
**Release date:** 2025-10-28

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.117.3

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.117.2...n8n@1.117.3) for this version.\
**Release date:** 2025-10-28

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.118.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.117.0...n8n@1.118.0) for this version.\
**Release date:** 2025-10-27

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.117.2

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.117.1...n8n@1.117.2) for this version.\
**Release date:** 2025-10-27

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.117.1

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.117.0...n8n@1.117.1) for this version.\
**Release date:** 2025-10-24

This release contains bug fixes.

### AI Workflow Builder is now available to Enterprise Cloud users.

AI Workflow Builder turns prompts into workflows. Describe what you want to build, and n8n will generate a draft workflow by adding, configuring, and connecting nodes for you. From there, you can refine and expand the workflow directly in the editor.

**What’s new:**

- Previously available to Starter and Pro users, AI Workflow Builder is now accessible to Enterprise Cloud users as well, with 1,000 monthly credits.
- Supported on n8n version 1.115+. **If you don’t see the feature yet, open /settings/usage to trigger a license refresh.**
- We’ve fixed a bug and now cloud users on v1.117.1 onwards will have access to a more reliable builder.
- We’re currently working on bringing AI Workflow Builder to self-hosted users as well, including Community, Business, and Enterprise.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.117.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.116.0...n8n@1.117.0) for this version.\
**Release date:** 2025-10-21

This release contains bug fixes.

### Contributors

[jackfrancismurphy](https://github.com/jackfrancismurphy)\
[JiriDeJonghe](https://github.com/JiriDeJonghe)\
[ramkrishna2910](https://github.com/ramkrishna2910)\
Oracle and/or its affiliates ([sudarshan12s](https://github.com/sudarshan12s))

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.116.2

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.116.1...n8n@1.116.2) for this version.\
**Release date:** 2025-10-21

This release contains a bug fix.

## n8n@1.115.4

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.115.3...n8n@1.115.4) for this version.\
**Release date:** 2025-10-21

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.116.1

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.116.0...n8n@1.116.1) for this version.\
**Release date:** 2025-10-14

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.116.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.115.0...n8n@1.116.0) for this version.\
**Release date:** 2025-10-13

This release contains bug fixes.

### Data migration tool

You can now easily migrate n8n data between different database types. This new tooling currently supports SQLite and Postgres, making the transition to a scaling database choice simpler, allowing you to take your data with you.

The tooling comes in the form of two new CLI commands, `export:entities` and `import:entities`

**`Export`** The new export command lets you export data from your existing n8n database (SQLite / Postgres), producing a set of encrypted files within a compressed directory for you to move around and use with the import commands.

For details, see [Export entities](../hosting/cli-commands/#export-entities)

**`Import`** The new import command allows you to read from a compressed and encrypted set of files generated from the new export command, and import them in to your new database of choice (SQLite / Postgres) to be used with your n8n instance.

For details, see [Import entities](../hosting/cli-commands/#import-entities)

### Contributors

[JHTosas](https://github.com/JHTosas)\
[clesecq](https://github.com/clesecq)\
[Gulianrdgd](https://github.com/Gulianrdgd)\
[tishun](https://github.com/tishun)

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.116.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.115.0...n8n@1.116.0) for this version.\
**Release date:** 2025-10-13

This release contains bug fixes.

### Contributors

[JHTosas](https://github.com/JHTosas)\
[clesecq](https://github.com/clesecq)\
[Gulianrdgd](https://github.com/Gulianrdgd)\
[tishun](https://github.com/tishun)

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.115.3

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.115.2...n8n@1.115.3) for this version.\
**Release date:** 2025-10-14

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.115.2

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.115.1...n8n@1.115.2) for this version.\
**Release date:** 2025-10-10

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.114.4

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.114.3...n8n@1.114.4) for this version.\
**Release date:** 2025-10-07

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.115.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.114.0...n8n@1.115.0) for this version.\
**Release date:** 2025-10-06

This release contains bug fixes.

### AI Workflow Builder (Beta)

**AI Workflow Builder** turns your natural language prompts into working automations. Describe what you want to build, and n8n will generate a draft workflow by adding and configuring nodes and wiring up the logic for you. From there, you can refine, expand, or adjust the workflow directly in the editor.

This feature helps you move from idea to implementation faster and without losing technical control. It’s especially helpful when starting from a blank canvas, validating an approach, or exploring new nodes and capabilities. Multi-turn interaction lets you iterate in conversation, turning your ideas into structured, production-ready workflows step by step.

Learn more about how we we’re building this feature in our [forum post](https://community.n8n.io/t/ai-powered-workflow-building-coming-soon/196499).

[](/_video/release-notes/AI_Workflow_Builder.webm)

**Availability:**

- This feature is initially going to be available for Cloud users on the 14-day Trial, Starter and Pro plans.
- Availability for Enterprise users on Cloud will follow in a future update.
- We are actively exploring the best way to bring this feature to self-hosted users.

**Rollout timing:**

- To ensure the smoothest experience for all users, this feature will be rolled out to users on version 1.115.0 over the course of a week so you may not have access to the feature immediately when you upgrade to 1.115.0.

**Credit limits by plan:** This feature will have monthly credit limits [by plan](https://n8n.io/pricing/).

- Each prompt/interaction with the AI Workflow Builder consumes one credit.
- Trial users have access to 20 credits, Starter plans have 50 per month and Pro plans will have 150 credits per month.
- At this time, there will not be a way to access additional credits within your plan, however we are we are exploring this.

Learn more about AI Workflow Builder in [documentation](https://docs.n8n.io/advanced-ai/ai-workflow-builder/).

### Source Control: Added HTTPS support

You can now connect to Git repositories via HTTPS in addition to SSH, making Source Control usable in environments where SSH is restricted.

HTTPS is now supported as a connection type in Environments.

### Contributors

[baileympearson](https://github.com/baileympearson)\
[h40huynh](https://github.com/h40huynh)\
[Ankit-69k](https://github.com/Ankit-69k)\
[francisfontoura](https://github.com/francisfontoura)\
[iocanel](https://github.com/iocanel)

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.114.3

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.114.2...n8n@1.114.3) for this version.\
**Release date:** 2025-10-06

This release contains bug fixes.

## n8n@1.114.2

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.114.1...n8n@1.114.2) for this version.\
**Release date:** 2025-10-02

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.114.1

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.114.0...n8n@1.114.1) for this version.\
**Release date:** 2025-10-02

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.114.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.113.0...n8n@1.114.0) for this version.\
**Release date:** 2025-09-29

This release contains core updates, editor improvements, project updates, performance improvements, and bug fixes.

### Contributors

[nealzhu3](https://github.com/nealzhu3)

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.113.3

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.113.2...n8n@1.113.3) for this version.\
**Release date:** 2025-09-26

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.112.6

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.112.5...n8n@1.112.6) for this version.\
**Release date:** 2025-09-26

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.113.2

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.113.1...n8n@1.113.2) for this version.\
**Release date:** 2025-09-24

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

### Python task runner

This version introduces the **Python task runner** as a beta feature. This feature secures n8n's Python sandbox and enables users to run real Python modules in n8n workflows. The original Pyodide-based implementation will be phased out.

This is a **breaking change** that replaces Pyodide - see [here](https://docs.n8n.io/integrations/builtin/core-nodes/n8n-nodes-base.code/#python-native-beta) for a list of differences. Any Code node set to the legacy `python` parameter will need to be manually updated to use the new `pythonNative` parameter. Any Code node script set to `python` and relying on Pyodide syntax is likely to need to be manually adjusted to account for breaking changes.

- For self-hosting users, see [here](https://docs.n8n.io/hosting/configuration/task-runners/#setting-up-external-mode) for deployment instructions for task runners going forward and how to install extra dependencies.
- On n8n Cloud, this will be a gradual transition. If in your n8n Cloud instance the Code node offers an option named "Python (Native) (Beta)", then your instance has been transitioned to native Python and you will need to look out for any breaking changes. Imports are disabled for security reasons at this time.

The native Python runner is currently in beta and is subject to change as we find a balance between security and usability. Your feedback is welcome.

## n8n@1.112.5

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.112.4...n8n@1.112.5) for this version.\
**Release date:** 2025-09-24

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.113.1

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.113.0...n8n@1.113.1) for this version.\
**Release date:** 2025-09-23

This release contains bug fixes.

### Data tables

We’re excited to introduce **data tables**, bringing built-in data storage to n8n. You can now store and query structured data directly inside the platform, without relying on external databases for many common automation scenarios. Track workflow state between runs, store tokens or session data, keep product or customer reference tables, or stage intermediate results for multi-step processes.

Previously, persisting data meant provisioning and connecting to an external store such as Redis or Google Sheets. That added credential setup, infrastructure overhead, latency, and constant context switching. **Data tables** eliminate that friction and keeps your data easily editable and close to your workflows.

Data tables are available today on all plans. They currently support numbers, strings, and datetimes with JSON support coming soon. On Cloud, each instance can store up to 50 MB. On self-hosted setups, the default is also 50 MB, but this limit can be adjusted if your infrastructure allows.

[Overview of data tables](https://www.youtube.com/watch?v=ljkiIkt6lZ4)

🛠️ **How to:**

**Create a data table**

- From the canvas, open the **Create workflow** dropdown and select **Create Data table**.
- Or, go to the **Overview** panel on the left-side navigation bar and open the **Data tables** tab.

**Use a data table in your workflow**

- Add the **Data table node** to your workflow to get, update, insert, upsert, or delete rows.

**Adjust the storage limit** (self-hosted only)

- Change the default 50 MB limit with the environment variable: `N8N_DATA_TABLES_MAX_SIZE_BYTES`. [See configuration docs](https://docs.n8n.io/hosting/configuration/configuration-methods/).

🧠**Keep in mind**

- Data tables don’t currently support foreign keys or default values.
- For now, all data tables are accessible to everyone in a project. More granular permissions and sharing options are planned.

Learn more about [**data tables**](../data/data-tables/) and the [**Data table node**](../integrations/builtin/core-nodes/n8n-nodes-base.datatable/).

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.112.4

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.112.3...n8n@1.112.4) for this version.\
**Release date:** 2025-09-23

This release contains an editor improvement.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.113.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.112.0...n8n@1.113.0) for this version.\
**Release date:** 2025-09-22

This release contains core updates, editor improvements, a new node, node updates, and bug fixes.

### SSO improvements

We’ve made updates to strengthen Single Sign-On (SSO) reliability and security, especially for enterprise and multi-instance setups.

- OIDC and SAML sync in multi-main setups \[version: 1.113.0\]: In multi-main deployments, updates to SSO settings are now synchronized across all instances, ensuring consistent login behavior everywhere.
- Enhanced OIDC integration \[version 1.111.0\]: n8n now supports OIDC providers that enforce state and nonce parameters. These are validated during login, providing smoother and more secure Single Sign-On.

### Filter insights by project

We've added project filtering to insights, enabling more granular reporting and visibility into individual project performance.

Filter insights

### Contributors

[ongdisheng](https://github.com/ongdisheng)

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.112.3

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.112.2...n8n@1.112.3) for this version.\
**Release date:** 2025-09-19

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.111.1

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.111.0...n8n@1.111.1) for this version.\
**Release date:** 2025-09-19

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.110.2

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.110.1...n8n@1.110.2) for this version.\
**Release date:** 2025-09-19

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.112.2

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.112.1...n8n@1.112.2) for this version.\
**Release date:** 2025-09-18

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.112.1

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.112.0...n8n@1.112.1) for this version.\
**Release date:** 2025-09-17

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.112.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.111.0...n8n@1.112.0) for this version.\
**Release date:** 2025-09-15

This release contains API improvements, core updates, editor improvements, node updates, and bug fixes.

### Additional API Endpoints versions

We’ve made several updates to the Executions API:

- Execution details: `GET /executions` now includes *status* and *workflow_name* in the response.
- Retry execution endpoint: Added new public API endpoints to retry failed executions.
- Additional filters: You can now filter executions by running or canceled status.

### Enhancements to workflow diff

We added a several updates on workflows diffs as well:

- Better view in Code nodes and Stickies: Workflow diffs now highlight changes per line instead of per block, making edits easier to review and understand.
- Enable/Disable sync: You can now enable or disable sync in the viewport, letting you compare a workflow change in one view without affecting the other.

Workflow diff

### Contributors

[GuraaseesSingh](https://github.com/GuraaseesSingh)\
[jabbson](https://github.com/jabbson)\
[ongdisheng](https://github.com/ongdisheng)

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.111.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.110.0...n8n@1.111.0) for this version.\
**Release date:** 2025-09-08

This release contains core updates, API improvements, node updates, and bug fixes.

### Contributors

[abellion](https://github.com/abellion)\
[cesars-gh](https://github.com/cesars-gh)\
[durran](https://github.com/durran)

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.110.1

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.110.0...n8n@1.110.1) for this version.\
**Release date:** 2025-09-03

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.109.2

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.109.1...n8n@1.109.2) for this version.\
**Release date:** 2025-09-03

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.110.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.109.0...n8n@1.110.0) for this version.\
**Release date:** 2025-09-01

This release contains core updates, editor improvements, node updates, performance improvements, and bug fixes.

### Contributors

[heyxmirko](https://github.com/heyxmirko)

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.109.1

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.109.0...n8n@1.109.1) for this version.\
**Release date:** 2025-08-27

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.108.2

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.108.1...n8n@1.108.2) for this version.\
**Release date:** 2025-08-27

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.109.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.108.0...n8n@1.109.0) for this version.\
**Release date:** 2025-08-25

This release contains core updates, editor improvements, node updates, performance improvements, and bug fixes.

### Contributors

[naXa777](https://github.com/naXa777)\
[prettycode2022](https://github.com/prettycode2022)\
[oppai](https://github.com/oppai)

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.107.4

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.107.3...n8n@1.107.4) for this version.\
**Release date:** 2025-08-20

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.108.1

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.108.0...n8n@1.108.1) for this version.\
**Release date:** 2025-08-20

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.107.3

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.107.2...n8n@1.107.3) for this version.\
**Release date:** 2025-08-18

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.108.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.107.0...n8n@1.108.0) for this version.\
**Release date:** 2025-08-18

This release contains a new CLI tool, editor improvements, node updates, performance improvements, and bug fixes.

### Workflow Diff

For teams working across different environments, deployments often involve multiple people making changes at different times. Without a clear view of those changes, it’s easy to miss something important.

[Workflow Diff](../source-control-environments/using/compare-changes/) gives you an easy and visual way to review workflow changes before you deploy them between environments.

With it, you can:

- Quickly see what’s been added, changed, or deleted, with clear colour highlights.
- Easily see important settings changes on a workflow.
- Check changes inside each node, and spot connector updates, with a side-by-side view of its settings.
- Get a quick count of all changes to understand the size of a deployment.

Workflow Diff

Workflow Diff eases the review and approval of changes before deployment, enabling teams to collaborate on workflows without breaking existing automations or disrupting production. It’s one step further in integrating DevOps best practices in n8n.

Now available for Enterprise customers using Environments.

### Contributors

[ManuLasker](https://github.com/ManuLasker)\
[EternalDeiwos](https://github.com/EternalDeiwos)\
[jreyesr](https://github.com/jreyesr)

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.107.2

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.107.1...n8n@1.107.2) for this version.\
**Release date:** 2025-08-15

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.107.1

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.107.0...n8n@1.107.1) for this version.\
**Release date:** 2025-08-14

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.106.3

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.106.2...n8n@1.106.3) for this version.\
**Release date:** 2025-08-11

This release contains a backported update.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.107.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.106.0...n8n@1.107.0) for this version.\
**Release date:** 2025-08-11

This release contains bug fixes.

### Contributors

[Amsal1](https://github.com/Amsal1)\
[andrewzolotukhin](https://github.com/andrewzolotukhin)\
[DMA902](https://github.com/DMA902)\
[fkowal](https://github.com/fkowal)\
[Gulianrdgd](https://github.com/Gulianrdgd)

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.106.2

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.106.1...n8n@1.106.2) for this version.\
**Release date:** 2025-08-08

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.106.1

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.106.0...n8n@1.106.1) for this version.\
**Release date:** 2025-08-07

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.105.4

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.105.3...n8n@1.105.4) for this version.\
**Release date:** 2025-08-07

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.105.3

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.105.2...n8n@1.105.3) for this version.\
**Release date:** 2025-08-05

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.106.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.105.0...n8n@1.106.0) for this version.\
**Release date:** 2025-08-04

This release contains performance improvements, core updates, editor improvements, node updates, a new node, and bug fixes.

### **No more limit of active workflows and new self-hosted Business Plan**

We have rolled out a new pricing model to make it easier for builders of all sizes to adopt and scale automation with n8n.

***What’s new***

**No more limit of active workflows.**

All n8n plans, from Starter to Enterprise, now include unlimited users, workflows, and steps. Our pricing is based on the volume of executions. Meaning you can build and test as many workflows as you want, including complex, data-heavy, or long-running automations, without worrying about quotas.

**New self-hosted Business Plan for growing teams**

Designed for SMBs and mid-sized companies, the Business Plan includes features such as:

- 6 shared projects
- SSO, SAML and LDAP
- Different environments
- Global variables
- Version control using Git
- 30 days of Insights

Please note that this plan only includes support from our community forum. For dedicated support we recommend upgrading to our Enterprise plan.

**Enterprise pricing now scales with executions**

Enterprise plans no longer use workflow-based pricing, and is now also based on the volume of executions.

***What you need to do***

To ensure these changes apply to your account, update your n8n instance to the latest version.

[Read the blog](https://blog.n8n.io/build-without-limits-everything-you-need-to-know-about-n8ns-new-pricing/) for full details.

### Contributors

[baruchiro](https://github.com/baruchiro)\
[killthekitten](https://github.com/killthekitten)\
[baileympearson](https://github.com/baileympearson)\
[Yingrjimsch](https://github.com/Yingrjimsch)\
[joshualipman123](https://github.com/joshualipman123)

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.105.2

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.105.1...n8n@1.105.2) for this version.\
**Release date:** 2025-08-01

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.105.1

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.105.0...n8n@1.105.1) for this version.\
**Release date:** 2025-08-01

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.104.2

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.104.1...n8n@1.104.2) for this version.\
**Release date:** 2025-07-31

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.105.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.104.0...n8n@1.105.0) for this version.\
**Release date:** 2025-07-28

This release contains core updates, editor improvements, node updates, and bug fixes.

### **Respond to Chat node**

With the [\*\*Respond to Chat](../integrations/builtin/core-nodes/n8n-nodes-langchain.respondtochat/) node\*\*, you can now access Human-in-the-Loop functionality natively in n8n Chat.

Enable conversational experiences where you can ask for clarification, request approval before taking further action, and get back intermediate results — all within a single workflow execution.

This unlocks multi-turn interactions that feel more natural and reduce the number of executions required. It is ideal for building interactive AI use cases like conversational forms, branched workflows based on user replies, and step-by-step approvals.

🛠️ **How to:**

- Add a **Chat Trigger** node and select **Using Respond Nodes** for the **Response mode**
- Place the **Respond to Chat** node anywhere in your workflow to send a message into the Chat and optionally wait for the user to input a response before continuing execution of the workflow steps.

[](/_video/release-notes/Respond-to-chat.webm)

### Contributors

[dana-gill](https://github.com/dana-gill)

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.104.1

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.104.0...n8n@1.104.1) for this version.\
**Release date:** 2025-07-23

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.103.2

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.103.1...n8n@1.103.2) for this version.\
**Release date:** 2025-07-22

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.104.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.103.0...n8n@1.104.0) for this version.\
**Release date:** 2025-07-21

\=======

This release contains core updates, editor improvements, a new node, node updates, and bug fixes.

### Contributors

[nunulk](https://github.com/nunulk)\
[iaptsiauri](https://github.com/iaptsiauri)\
[KGuillaume-chaps](https://github.com/KGuillaume-chaps)

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.101.3

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.101.2...n8n@1.101.3) for this version.\
**Release date:** 2025-07-18

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.102.4

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.102.3...n8n@1.102.4) for this version.\
**Release date:** 2025-07-17

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.103.1

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.103.0...n8n@1.103.1) for this version.\
**Release date:** 2025-07-17

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.102.3

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.102.2...n8n@1.102.3) for this version.\
**Release date:** 2025-07-14

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.103.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.102.0...n8n@1.103.0) for this version.\
**Release date:** 2025-07-14

This release contains core updates, editor improvements, new nodes, node improvements, and bug fixes.

### **Chat streaming**

No more waiting for full responses to load when using the n8n chat interface. **Streaming** now delivers AI-generated text replies word by word so users can read messages as they’re being generated. It feels faster, smoother, and more like what people expect from chat experiences.

Streaming is available in public chat views (hosted or embedded) and can be used in custom apps via webhook.

🛠️ How-to

Configure streaming in the Node Details View of these nodes:

- Chat Trigger node: Options>Add Field>Response Mode>Streaming
- Webhook node: Respond>Streaming
- AI Agent node: Add option> Enable streaming

[](/_video/release-notes/streaming.webm)

### Improved instance user list with more visibility

The instance user list has been updated with a new table layout and additional details to help admins manage access more easily.

You can now:

- See total users and filter by name or email
- View which projects each user has access to
- Whether a user has enabled 2FA and sort based on that
- See the last active date for each user

This makes it easier to audit user activity, identify inactive accounts, and understand how access is distributed across your instance.

### Webhook HTML responses

Starting with this release, if your workflow sends an HTML response to a webhook, n8n automatically wraps the content in an `<iframe>`. This is a security mechanism to protect the instance users.

This has the following implications:

- HTML renders in a sandboxed iframe instead of directly in the parent document.
- JavaScript code that attempts to access the top-level window or local storage will fail.
- Authentication headers aren't available in the sandboxed iframe (for example, basic auth). You need to use an alternative approach, like embedding a short-lived access token within the HTML.
- Relative URLs (for example, `<form action="/">`) won't work. Use absolute URLs instead.

### Built-in Metrics for AI Evaluations

Using evaluations is a best practice for any AI solution, and a must if reliability and predictability are business-critical. With this release, we’ve made it easier to set up evaluations in n8n by introducing a set of built-in metrics. These metrics can review AI responses and assign scores based on factors like correctness, helpfulness, and more.

You can run regular evaluations and review scores over time as a way to monitor your AI workflow's performance. You can also compare results across different models to help guide model selection, or run evaluations before and after a prompt change to support data-driven, iterative building.

As with all evaluations in n8n, you’ll need a dataset that includes the inputs you want to test. For some evaluations, the dataset must also include expected outputs (ground truth) to compare against. The evaluation workflow runs each input through the portion you're testing to generate a response. The built-in metric scores each response based on the aspect you're measuring, allowing you to compare results before and after changes or track trends over time in the Evaluations tab.

You can still define your own custom metrics, but for common use cases, the built-in options make it much faster to implement.

🛠️ **How to:**

1. Set up your evaluation as described [here](../advanced-ai/evaluations/metric-based-evaluations/#how-it-works), using an **Evaluation** node as the trigger and another with the **Set Metrics** operation.
1. In the **Set Metrics** node, choose a metric from the dropdown list.
1. Define any additional parameters required for your selected metric. In most cases, this includes mapping the dataset columns to the appropriate fields.

📏 **Available built-in metrics:**

- **Correctness (AI-based):** Compares AI workflow-generated responses to expected answers. Another LLM acts as a judge, scoring the responses based on guidance you provide in the prompt.
- **Helpfulness (AI-based):** Evaluates how helpful a response is in relation to a user query, using an LLM and prompt-defined scoring criteria.
- **String Similarity:** Measures how closely the response matches the expected output by comparing strings. Useful for command generation or when output needs to follow a specific structure.
- **Categorization:** Checks whether a response matches an expected label, such as assigning items to the correct category.
- **Tools Used:** Verifies whether the AI agent called the tools you specified in your dataset. To enable this, make sure **Return Intermediate Steps** is turned on in your agent so the evaluation can access the tools it actually called.

🧠 Keep in mind

- Registered Community Edition enables analysis of one evaluation in the **Evaluations** tab which allows easy comparison of evaluation runs over time. Pro and Enterprise plans allow unlimited evaluations in the **Evaluations** tab.

Built-in Metrics

[Learn more](../advanced-ai/evaluations/overview/) about setting up and customizing evaluations.

### AI Agent Tool node

With the **AI Agent Tool** node we are introducing a simplified pattern for multi-agent orchestration that can be run in a single execution and stay entirely on one canvas. You can now connect multiple **AI Agent Tool** nodes to a primary **AI Agent** node, allowing it to supervise and delegate work across other specialized agents.

This setup is especially useful for building complex systems that function like real-world teams, where a lead agent assigns parts of a task to specialists. You can even add multiple layers of agents directing other agents, just like you would have in a real multi-tiered organizational structure. It also helps with prompt management by letting you split long, complex instructions into smaller, focused tasks across multiple agents. While similar orchestration was already possible using sub-workflows, AI Agent Tool nodes are a good choice when you want the interaction to happen within a single execution or prefer to manage and debug everything from a single canvas.

🛠️ **How to:**

- Add an **AI Agent** node to your workflow and click **+** to create a Tools connection.
- Search for and select the **AI Agent Tool** node from the Nodes Panel.
- Name the node clearly so the primary agent can reference it, then add a short description and prompt.
- Connect any LLMs, memory, and tools the agent needs to perform its role.
- Instruct the primary **AI Agent** on when to use the **AI Agent Tool** and to pass along relevant context in its prompt.

🧠 **Keep in mind:**

- The orchestrating agent does not pass full execution context by default. Any necessary context must be included in the prompt.

**AI Agent Tool** nodes makes it easier to build layered, agent-to-agent workflows without relying on sub-workflows, helping you move faster when building and debugging multi-agent systems.

AI Agent Tool node

### Contributors

[ksg97031](https://github.com/ksg97031)\
[israelshenkar](https://github.com/israelshenkar)

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.102.2

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.102.1...n8n@1.102.2) for this version.\
**Release date:** 2025-07-11

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.101.2

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.101.1...n8n@1.101.2) for this version.\
**Release date:** 2025-07-11

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.102.1

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.102.0...n8n@1.102.1) for this version.\
**Release date:** 2025-07-09

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.102.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.101.0...n8n@1.102.0) for this version.\
**Release date:** 2025-07-07

This release contains core updates, editor improvements, new nodes, node updates, and bug fixes.

### Enforce 2FA across your instance

Enterprise Instance owners can now enforce two-factor authentication (2FA) for all users in their instance.

Once enabled, any user who hasn’t set up 2FA will be redirected to complete the setup before they can continue using n8n. This helps organizations meet internal security policies and ensures stronger protection across the workspace.

This feature is available only on the Enterprise plan.

### Contributors

[marty-sullivan](https://github.com/marty-sullivan)\
[cesars-gh](https://github.com/cesars-gh)\
[dudanogueira](https://github.com/dudanogueira)

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.101.1

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.101.0...n8n@1.101.1) for this version.\
**Release date:** 2025-07-03

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.101.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.100.0...n8n@1.101.0) for this version.\
**Release date:** 2025-06-30

This release contains core updates, editor improvements, node updates, and bug fixes.

### Contributors

[luka-mimi](https://github.com/luka-mimi)

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.100.1

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.100.0...n8n@1.100.1) for this version.\
**Release date:** 2025-06-25

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.100.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.99.0...n8n@1.100.0) for this version.\
**Release date:** 2025-06-23

This release contains core updates, editor improvements, a new node, node updates, and bug fixes.

### Model Selector node

The [Model Selector node](../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.modelselector/) gives you more control when working with multiple LLMs in your workflows.

Use it to determine which connected model should handle a given input, based on conditions like expressions or global variables. This makes it easier to implement model routing strategies, such as switching models based on performance, task type, cost, or availability.

🛠️ **How to:** Connect multiple model nodes to the Model Selector node, then configure routing conditions in the node’s settings.

🧠 **Keep in mind:**

- Rules are evaluated in order. The first matching rule determines which model is used even if others would also match.
- As a sub-node, expressions behave differently here: they always resolves to the first item rather than resolving for each item in turn.

The Model Selector node is especially useful in evaluation or production scenarios where routing logic between models needs to adapt based on performance, cost, availability, or dataset-specific needs.

Model Selector node

### Support for OIDC (OpenID Connect) authentication

You can now use OIDC (OpenID Connect) as an authentication method for Single Sign-On (SSO).

This gives enterprise teams more flexibility to integrate n8n with their existing identity providers using a widely adopted and easy-to-manage standard. OIDC is now available alongside SAML, giving Enterprises the choice to select what best fits their internal needs.

### Project admins can now commit to Git within environments

Project admins now have the ability to commit workflow and credential changes directly to Git through the environments feature. This update streamlines the workflow deployment process by giving project-level admins direct control over committing their changes. It also ensures that the those who know their workflows best can review and commit updates themselves, without needing to involve instance-level admins.

[Learn more about source control environments](../source-control-environments/)

### Contributors

[aliou](https://github.com/aliou)

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.99.1

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.99.0...n8n@1.99.1) for this version.\
**Release date:** 2025-06-19

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.98.2

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.98.1...n8n@1.98.2) for this version.\
**Release date:** 2025-06-18

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.99.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.98.0...n8n@1.99.0) for this version.\
**Release date:** 2025-06-16

This release contains performance improvements, core updates, editor changes, node updates, and bug fixes.

### Automatically name nodes

Default node names now update automatically based on the resource and operation selected, so you’ll always know what a node does at a glance.

This adds clarity to your canvas and saves time renaming nodes manually.

Don’t worry, automatic naming won’t break references. And, and if you’ve renamed a node yourself, we’ll leave it just the way you wrote it.

[](/_video/release-notes/automatic_node_naming.mp4)

### Support for RAG extended with built-in templates

Retrieval-Augmented Generation (RAG) can improve AI responses by providing language models access to data sources with up-to-date, domain-specific, or proprietary knowledge. RAG workflows typically rely on vector stores to manage and search this data efficiently.

To get the benefits of using vector stores, such as returning results based on semantic meaning rather than just keyword matches, you need a way to upload your data to the vector store and a way to query it.

In n8n, uploading and querying vectors stores happens in two workflows. Now, you have an example to get your started and make implementation easier with the **RAG starter template**.

- The **Load Data** workflow shows how to add data with the appropriate embedding model, split it into chunks with the [Default Data Loader](../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.documentdefaultdataloader/), and add metadata as desired.
- The **Retriever** workflow for querying data, shows how agents and vector stores work together to help you define highly relevant results and save tokens using the **Question and Answer** tool.

Enable semantic search and the retrieval of unstructured data for increased quality and relevance of AI responses.

🛠️ **How to:**

- Search for **RAG starter template** in the search bar of the Nodes panel to insert it into your workflow.

Learn more about implementing RAG in n8n [here](../advanced-ai/rag-in-n8n/).

RAG starter template

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.98.1

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.98.0...n8n@1.98.1) for this version.\
**Release date:** 2025-06-12

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.98.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.97.0...n8n@1.98.0) for this version.\
**Release date:** 2025-06-11

This release contains performance improvements, core updates, editor changes, node updates, a new node, and bug fixes.

### Contributors

[luka-mimi](https://github.com/luka-mimi)\
[Alexandero89](https://github.com/Alexandero89)\
[khoazero123](https://github.com/khoazero123)

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.97.1

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.97.0...n8n@1.97.1) for this version.\
**Release date:** 2025-06-04

This release contains backports.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.95.3

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.95.2...n8n@1.95.3) for this version.\
**Release date:** 2025-06-03

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.97.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.96.0...n8n@1.97.0) for this version.\
**Release date:** 2025-06-02

This release contains new features, performance improvements and bug fixes.

### Convert to sub-workflow

Large, monolithic workflows can slow things down. They’re harder to maintain, tougher to debug, and more difficult to scale. With sub-workflows, you can take a more modular approach, breaking up big workflows into smaller, manageable parts that are easier to reuse, test, understand, and explain.

Until now, creating sub-workflows required copying and pasting nodes manually, setting up a new workflow from scratch, and reconnecting everything by hand. **Convert to sub-workflow** allows you to simplify this process into a single action, so you can spend more time building and less time restructuring.

[](/_video/release-notes/convert_to_sub-workflow.mp4)

**How it works**

1. Highlight the nodes you want to convert to a sub-workflow. These must:
   - Be fully connected, meaning no missing steps in between them
   - Start from a single starting node
   - End with a single node
1. Right-click to open the context menu and select **Convert to sub-workflow**
   - Or use the shortcut: `Alt + X`
1. n8n will:
   - Open a new tab containing the selected nodes
   - Preserve all node parameters as-is
   - Replace the selected nodes in the original workflow with a **Call My Sub-workflow** node

*Note*: You will need to manually adjust the field types in the Start and Return nodes in the new sub-workflow.

This makes it easier to keep workflows modular, performant, and easier to maintain.

Learn more about [sub-workflows](../flow-logic/subworkflows/).

This release contains performance improvements and bug fixes.

### Contributors

[maatthc](https://github.com/maatthc)

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.96.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.95.0...n8n@1.96.0) for this version.\
**Release date:** 2025-06-02

Build failure

This release failed to build. Please use `1.97.0` instead.

This release contains API updates, core changes, editor improvements, node updates, and bug fixes.

### API support for assigning users to projects

You can now use the API to add and update users within projects. This includes:

- Assigning existing or pending users to a project with a specific role
- Updating a user’s role within a project
- Removing users from one or more projects

This update now allows you to use the API to add users to both the instance and specific projects, removing the need to manually assign them in the UI.

### Add pending users to project member assignment

You can now add **pending users,** those who have been invited but haven't completed sign-up, to projects as members.

This change lets you configure a user's project access upfront, without waiting for them to finish setting up their account. It eliminates the back-and-forth of managing access post-sign-up, ensuring users have the right project roles immediately upon joining.

### Contributors

[matthabermehl](https://github.com/matthabermehl)\
[Stamsy](https://github.com/Stamsy)

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.95.2

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.95.1...n8n@1.95.2) for this version.\
**Release date:** 2025-05-29

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.95.1

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.95.0...n8n@1.95.1) for this version.\
**Release date:** 2025-05-27

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.94.1

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.94.0...n8n@1.94.1) for this version.\
**Release date:** 2025-05-27

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.95.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.94.0...n8n@1.95.0) for this version.\
**Release date:** 2025-05-26

This release contains core updates, editor improvements, node updates, and bug fixes.

### Evaluations for AI workflows

We’ve added a feature to help you iterate, test, and compare changes to your AI automations before pushing them to production so you can achieve more predictability and make better decisions.

When you're building with AI, a small prompt tweak or model swap might improve results with some inputs, while quietly degrading performance with others. But without a way to evaluate performance across many inputs, you’re left guessing whether your AI is actually getting better when you make a change.

By implementing **Evaluations for AI workflows** in n8n, you can assess how your AI performs across a range of inputs by adding a dedicated path in your workflow for running test cases and applying custom metrics to track results. This helps you build viable proof-of-concepts quickly, iterate more effectively, catch regressions early, and make more confident decisions when your AI is in production.

#### Evaluation node and tab

The **Evaluation node** includes several operations that, when used together, enable end-to-end AI evaluation.

Evaluation node

Use this node to:

- Run your AI logic against a wide range of test cases in the same execution
- Capture the outputs of those test cases
- Score the results using your own metrics or LLM-as-judge logic
- Isolate a testing path to only include the nodes and logic you want to evaluate

The **Evaluations tab** enables you to review test results in the n8n UI, perfect for comparing runs, spotting regressions, and viewing performance over time.

#### 🛠 How evaluations work

The evaluation path runs alongside your normal execution logic and only activates when you want—making it ideal for testing and iteration.

Get started by selecting an AI workflow you want to evaluate that includes one or more LLM or Agent nodes.

1. Add an **Evaluation** node with the **On new Evaluation event** operation. This node will act as an additional trigger you’ll run only when testing. Configure it to read your dataset from Google Sheets, with each row representing a test input.

   > 💡 Better datasets mean better evaluations. Craft your dataset from a variety of test cases, including edge cases and typical inputs, to get meaningful feedback on how your AI performs. Learn more and access sample datasets [here](../advanced-ai/evaluations/light-evaluations/#1-create-a-dataset).

1. Add a second **Evaluation** node using the **Set Outputs** operation after the part of the workflow you're testing—typically after an LLM or Agent node. This captures the response and writes it back to your dataset in Google Sheets.

1. To evaluate output quality, add a third **Evaluation** node with the **Set Metrics** operation at a point after you’ve generated the outputs. You can develop workflow logic, custom calculations, or add an LLM-as-Judge to score the outputs. Map these metrics to your dataset in the node’s parameters.

   > 💡 Well-defined metrics = smarter decisions. Scoring your outputs based on similarity, correctness, or categorization can help you track whether changes are actually improving performance. Learn more and get links to example templates [here](../advanced-ai/evaluations/metric-based-evaluations/#2-add-metrics-to-workflow).

Evaluation workflow

When the Evaluation trigger node is executed, it runs each input in our dataset through your AI logic. This continues until all test cases are processed, a limit is reached, or you manually stop the execution. Once your evaluation path is set up, you can update your prompt, model, or workflow logic—and re-run the Evaluation trigger node to compare results. If you’ve added metrics, they’ll appear in the Evaluations tab.

In some instances, you may want to isolate your testing path to make iteration faster or to avoid executing downstream logic. In this case, you can add an Evaluation node with the `Check If Evaluating` operation to ensure only the expected nodes run when performing evaluations.

#### Things to keep in mind

Evaluations for AI Workflows are designed to fit into your development flow, with more enhancements on the way. For now, here are a few things to note:

- Test datasets are currently managed through Google Sheets. You’ll need a Google Sheets credential to run evaluations.
- Each workflow supports one evaluation at a time. If you’d like to test multiple segments, consider splitting them into sub-workflows for more flexibility.
- Community Edition supports one single evaluation. Pro and Enterprise plans allow unlimited evaluations.
- AI Evaluations are not enabled for instances in scaling mode at this time.

You can find details, tips, and common troubleshooting info [here](../advanced-ai/evaluations/tips-and-common-issues/).

👉 Learn more about the AI evaluation strategies and practical implementation techniques. [Watch now](https://www.youtube.com/live/QkciQpotQBQ?feature=shared).

### Contributors

[Phiph](https://github.com/Phiph)\
[cesars-gh](https://github.com/cesars-gh)

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.94.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.93.0...n8n@1.94.0) for this version.\
**Release date:** 2025-05-19

This release contains editor improvements, an API update, node updates, new nodes, and bug fixes.

### Verified community nodes on Cloud

We’ve expanded the n8n ecosystem and unlocked a new level of flexibility for all users including those on n8n Cloud! Now you can access a select set of community nodes and partner integrations without leaving the canvas. This means you install and automate with a wider range of integrations without leaving your workspace. The power of the community is now built-in.

This update focuses on three major improvements:

- **Cloud availability**: Community nodes are no longer just for self-hosted users. A select set of nodes is now available on n8n Cloud.
- **Built-in discovery**: You can find and explore these nodes right from the Nodes panel without leaving the editor or searching on npm.
- **Trust and verification**: Nodes that appear in the editor have been manually vetted for quality and security. These verified nodes are marked with a checkmark.

We’re starting with a selection of around 25 nodes, including some of the most-used community-built packages and partner-supported integrations. For this phase, we focused on nodes that don’t include external package dependencies - helping streamline the review process and ensure a smooth rollout.

This is just the start. We plan to expand the library gradually, bringing even more verified nodes into the editor along with the powerful and creative use cases they unlock. In time, our criteria will evolve, opening the door to a wider range of contributions while keeping quality and security in focus.

Learn more about this update and find out which nodes are already installable from the editor in our [blog](https://blog.n8n.io/community-nodes-available-on-n8n-cloud/) post.

💻 **Use a verified node**

Make sure you're on **n8n version 1.94.0** or later and the instance Owner has enabled verified community nodes. On Cloud, this can be done from the Admin Panel. For self-hosted instances, please refer to [documentation](../hosting/configuration/environment-variables/nodes/). In both cases, verified nodes are enabled by default.

- Open the **Nodes panel** from the editor
- Search for the Node. Verified nodes are indicated by a shield 🛡️
- Select the node and click **Install**

[](/_video/release-notes/Community-nodes-node-panel.mp4)

Once an Owner installs a node, everyone on the instance can start using it—just drag, drop, and connect like any other node in your workflow.

🛠️ **Build a node and get it verified**

Want your node to be verified and discoverable from the editor? Here’s how to get involved:

1. Review the [community node verification guidelines](../integrations/creating-nodes/build/reference/verification-guidelines/).
1. If you’re building something new, follow the recommendations for [creating nodes](../integrations/creating-nodes/overview/).
1. Check your design against the [UX guidelines](../integrations/creating-nodes/build/reference/ux-guidelines/).
1. [Submit your node](../integrations/creating-nodes/deploy/submit-community-nodes/) to npm.
1. Request verification by filling out [this form](https://internal.users.n8n.cloud/form/f0ff9304-f34a-420e-99da-6103a2f8ac5b).

**Already built a node? Raise your hand!**

If you’ve already published a community node and want it considered for verification, make sure it meets the requirements noted above, then let us know by submitting the interest [form](https://internal.users.n8n.cloud/form/f0ff9304-f34a-420e-99da-6103a2f8ac5b). We’re actively curating the next batch and would love to include your work.

### Extended logs view

When workflows get complex, debugging can get... clicky. That’s where an extended **Logs View** comes in. Now you can get a clearer path to trace executions, troubleshoot issues, and understand the behavior of a complete workflow — without bouncing between node detail views.

This update brings a unified, always-accessible panel to the bottom of the canvas, showing you each step of the execution as it happens. Whether you're working with loops, sub-workflows, or AI agents, you’ll see a structured view of everything that ran, in the order it ran—with input, output, and status info right where you need it.

You can jump into node details when you want to dig deeper, or follow a single item through every step it touched. Real-time highlighting shows you which nodes are currently running or have failed, and you’ll see total execution time for any workflow—plus token usage for AI workflows to help monitor performance. And if you're debugging across multiple screens? Just pop the logs out and drag them wherever you’d like.

⚙️**What it does**

- Adds a **Logs view** to the bottom of the canvas that can be opened or collapsed. (Chat also appears here if your workflow uses it).
- Displays a **hierarchical list of nodes** in the order they were executed—including expanded views of sub-workflows.
- Allows you to **click a node in hierarchy** to preview inputs and outputs directly, or jump into the full Node Details view with a link.
- Provides ability to **toggle** input and output data on and off.
- Highlights each node **live as it runs**, showing when it starts, completes, or fails.
- Includes **execution history** view to explore past execution data in a similar way.
- Shows **roll-up stats** like total execution time and total AI tokens used (for AI-enabled workflows).
- Includes a **“pop out”** button to open the logs as a floating window—perfect for dragging to another screen while debugging.

🛠️**How to**

To access the expanded logs view, click on the Logs bar at the bottom of the canvas. The view is also opens up when you open the chat window on the bottom of the page.

### Contributors

[Stamsy](https://github.com/Stamsy)\
[feelgood-interface](https://github.com/feelgood-interface)

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.93.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.92.0...n8n@1.93.0) for this version.\
**Release date:** 2025-05-12

This release contains core updates, editor improvements, new nodes, node updates, and bug fixes.

### Faster ways to open sub-workflows

We’ve added several new ways to navigate your multi-workflow automations faster.

From any workflow with a sub-workflow node:

🖱️ Right-click on a sub-workflow node and select `Open sub-workflow` from the context menu

⌨️ Keyboard shortcuts

- **Windows:** `CTRL + SHIFT + O` or `CTRL + Double Click`
- **Mac:** `CMD + SHIFT + O` or `CMD + Double Click`

These options will bring your sub-workflow up in a new tab.

### Archive workflows

If you’ve ever accidentally removed a workflow, you’ll appreciate the new archiving feature. Instead of permanently deleting workflows with the Remove action, workflows are now archived by default. This allows you to recover them if needed.

**How to:**

- **Archive a workflow** - Select **Archive** from the Editor UI menu. It has replaced the **Remove** action.
- **Find archived workflows** - Archived workflows are hidden by default. To find your archived workflows, select the option for **Show archived workflows** in the workflow filter menu.
- **Permanently delete a workflow** - Once a workflow is archived, you can **Delete** it from the options menu.
- **Recover a workflow** - Select **Unarchive** from the options menu.

**Keep in mind:**

- Workflows archival requires the same permissions as required previously for removal.
- You cannot select archived workflows as sub-workflows to execute
- Active workflows are deactivated when they are archived
- Archived workflows can not be edited

### Contributors

[LeaDevelop](https://github.com/LeaDevelop)\
[ayhandoslu](https://github.com/ayhandoslu)\
[valentina98](https://github.com/valentina98)

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.92.2

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.92.1...n8n@1.92.2) for this version.\
**Release date:** 2025-05-08

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.91.3

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.91.2...n8n@1.91.3) for this version.\
**Release date:** 2025-05-08

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.92.1

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.92.0...n8n@1.92.1) for this version.\
**Release date:** 2025-05-06

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.92.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.91.0...n8n@1.92.0) for this version.\
**Release date:** 2025-05-05

This release contains core updates, editor improvements, node updates, and bug fixes.

### Partial Execution for AI Tools

We’ve made it easier to build and iterate on AI agents in n8n. You can now run and test specific tools without having to execute the entire agent workflow.

Partial execution is especially useful when refining or troubleshooting parts of your agent logic. It allows you to test changes incrementally, without triggering full agent runs, reducing unnecessary AI calls, token usage, and downstream activity. This makes iteration faster, more cost-efficient, and more precise when working with complex or multi-step AI workflows.

Partial execution for AI tools is available now for all tools - making it even easier to build, test, and fine-tune AI agents in n8n.

[](/_video/release-notes/AI-agent-partial-execution.mp4)

**How to:**

To use this feature you can either:

- Click the **Play** button on the tool you want to execute directly from the canvas view.
- Open the tool’s **Node Details View** and select **"Execute Step"** to run it from there.

If you have previously run the workflow, the input and output will be prefilled with data from the last execution. A pop-up form will open where you can manually fill in the parameters before executing your test.

### Extended logs view

When workflows get complex, debugging can get... clicky. That’s where an extended **Logs View** comes in. Now you can get a clearer path to trace executions, troubleshoot issues, and understand the behavior of a complete workflow — without bouncing between node detail views.

This update brings a unified, always-accessible panel to the bottom of the canvas, showing you each step of the execution as it happens. Whether you're working with loops, sub-workflows, or AI agents, you’ll see a structured view of everything that ran, in the order it ran—with input, output, and status info right where you need it.

You can jump into node details when you want to dig deeper, or follow a single item through every step it touched. Real-time highlighting shows you which nodes are currently running or have failed, and you’ll see total execution time for any workflow—plus token usage for AI workflows to help monitor performance. And if you're debugging across multiple screens? Just pop the logs out and drag them wherever you’d like.

⚙️**What it does**

- Adds a **Logs view** to the bottom of the canvas that can be opened or collapsed. (Chat also appears here if your workflow uses it).
- Displays a **hierarchical list of nodes** in the order they were executed—including expanded views of sub-workflows.
- Allows you to **click a node in hierarchy** to preview inputs and outputs directly, or jump into the full Node Details view with a link.
- Provides ability to **toggle** input and output data on and off.
- Highlights each node **live as it runs**, showing when it starts, completes, or fails.
- Includes **execution history** view to explore past execution data in a similar way.
- Shows **roll-up stats** like total execution time and total AI tokens used (for AI-enabled workflows).
- Includes a **“pop out”** button to open the logs as a floating window—perfect for dragging to another screen while debugging.

🛠️**How to**

To access the expanded logs view, click on the Logs bar at the bottom of the canvas. The view is also opens up when you open the chat window on the bottom of the page.

### Insights enhancements for Enterprise

Two weeks after the launch of [Insights](../insights/), we’re releasing some enhancements designed for enterprise users.

- **Expanded time ranges**. You can now filter insights over a variety of time periods, from the last 24 hours up to 1 year. Pro users are limited to 7 day and 14 day views.
- **Hourly granularity**. Drill down into the last 24 hours of production executions with hourly granularity, making it easier to analyze workflows and quickly identify issues.

These updates provide deeper visibility into workflow history, helping you uncover trends over longer periods and detect problems sooner with more precise reporting.

Filter insights

### Contributors

[Stamsy](https://github.com/Stamsy)

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.91.2

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.91.1...n8n@1.91.2) for this version.\
**Release date:** 2025-05-05

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.90.3

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.90.2...n8n@1.90.3) for this version.\
**Release date:** 2025-05-05

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.91.1

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.91.0...n8n@1.91.1) for this version.\
**Release date:** 2025-05-01

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.91.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.90.0...n8n@1.91.0) for this version.\
**Release date:** 2025-04-28

This release contains core updates, editor improvements, node updates, and bug fixes.

### Breadcrumb view from the canvas

We’ve added **breadcrumb navigation directly on the canvas**, so you can quickly navigate to any of a workflow’s parent folders right from the canvas.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.90.2

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.90.1...n8n@1.90.2) for this version.\
**Release date:** 2025-04-25

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.90.1

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.90.0...n8n@1.90.1) for this version.\
**Release date:** 2025-04-22

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.90.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.89.0...n8n@1.90.0) for this version.\
**Release date:** 2025-04-22

This release contains core updates, editor updates, node updates, performance improvements, and bug fixes.

### Extended HTTP Request tool functionality

We’ve brought the full power of the HTTP Request node to the HTTP Request tool in AI workflows. That means your AI Agents now have access to all the advanced configuration options—like Pagination, Batching, Timeout, Redirects, Proxy support, and even cURL import.

[](/_video/release-notes/http-request-tool.mp4)

This update also includes support for the `$fromAI` function to dynamically generate the right parameters based on the context of your prompt — making API calls smarter, faster, and more flexible than ever.

**How to:**

- Open your AI Agent node in the canvas.
- Click the **‘+’ icon** to add a new tool connection.
- In the **Tools panel**, select HTTP **Request Tool.**
- Configure it just like you would a regular **HTTP Request node** — including advanced options

👉 Learn more about configuring the [HTTP Request tool](../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.toolhttprequest/).

### Scoped API keys

Users on the Enterprise plan can now create API keys with specific scopes to control exactly what each key can access.

Scoped API keys

Previously, API keys had full read/write access across all endpoints. While sometimes necessary, this level of access can be excessive and too powerful for most use cases. Scoped API keys allow you to limit access to only the resources and actions a service or user actually needs.

**What’s new**

When creating a new API key, you can now:

- Select whether the key has read, write, or both types of access.
- Specify which resources the key can interact with.

Supported scopes include:

- Variables — list, create, delete
- Security audit — generate reports
- Projects — list, create, update, delete
- Executions — list, read, delete
- Credentials — list, create, update, delete, move
- Workflows — list, create, update, delete, move, add/remove tags

Scoped API keys give you more control and security. You can limit access to only what’s needed, making it safer to work with third parties and easier to manage internal API usage.

### Drag and Drop in Folders

Folders just got friendlier. With this release, you can now **drag and drop workflows and folders** — making it even easier to keep things tidy.

Need to reorganize? Just select a workflow or folder and drag it into another folder or breadcrumb location. It’s a small change that makes a big difference when managing a growing collection of workflows.

[](/_video/release-notes/Drag-and-drop-folders.mp4)

📁 Folders are available to all [registered](../hosting/community-edition-features/#registered-community-edition) users—jump in and get your workspace in order!

### Contributors

[Zordrak](https://github.com/Zordrak)

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.89.2

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.89.1...n8n@1.89.2) for this version.\
**Release date:** 2025-04-16

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.89.1

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.89.0...n8n@1.89.1) for this version.\
**Release date:** 2025-04-15

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.89.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.88.0...n8n@1.89.0) for this version.\
**Release date:** 2025-04-14

This release contains API updates, core updates, editor updates, a new node, node updates, and bug fixes.

### Insights

We're rolling out [Insights](../insights/), a new dashboard to monitor how your workflows are performing over time. It's designed to give admins (and owners) better visibility of their most important workflow metrics and help troubleshoot potential issues and improvements.

In this first release, we’re introducing a summary banner, the insights dashboard, and time saved per execution.

#### 1. Summary banner

A new banner on the overview page that gives instance admins and owners a birds eye view of key metrics over the last 7 days.

Insights summary banner

Available metrics:

- Total production executions
- Total failed executions
- Failure rate
- Average runtime of all workflows
- Estimated time saved

This overview is designed to help you stay on top of workflow activity at a glance. It is available for all plans and editions.

#### 2. Insights dashboard

On Pro and Enterprise plans, a new dashboard offers a deeper view into workflow performance and activity.

Insights dashboard

The dashboard includes:

- Total production executions over time, including a comparison of successful and failed executions
- Per-workflow breakdowns of key metrics
- Comparisons with previous periods to help spot changes in usage or behavior
- Runtime average and failure rate over time

#### 3. Time saved per execution

Within workflow settings, you can now assign a “time saved per execution” value to any workflow. This makes it possible to track the impact of your workflows and make it easier to share this visually with other teams and stakeholders.

This is just the beginning for Insights: the next phase will introduce more advanced filtering and comparisons, custom date ranges, and additional monitoring capabilities.

### Node updates

- We added a credential check for the Salesforce node
- We added SearXNG as a tool for AI agents

You can now search within subfolders, making it easier to find workflows across all folder levels. Just type in the search bar and go.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.88.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.87.0...n8n@1.88.0) for this version.\
**Release date:** 2025-04-10

This release contains new features, new nodes, performance improvements, and bug fixes.

### Model Context Protocol (MCP) nodes

MCP aims to standardise how LLMs like Claude, ChatGPT, or Cursor can interact with tools or integrate data for their agents. Many providers - both established or new - are adopting MCP as a standard way to build agentic systems. It is an easy way to either expose your own app as a server, making capabilities available to a model as tools, or as a client that can call on tools outside of your own system.

While it’s still early in the development process, we want to give you access to our new MCP nodes. This will help us understand your requirements better and will also let us converge on a great general solution quicker.

We are adding two new nodes:

- a MCP [Server Trigger](../integrations/builtin/core-nodes/n8n-nodes-langchain.mcptrigger/) for any workflow
- a MCP [Client Tool](../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.toolmcp/) for the AI Agent

The MCP Server Trigger turns n8n into an MCP server, providing n8n tools to models running outside of n8n. You can run multiple MCP servers from your n8n instance. The MCP Client Tool connects LLMs - and other intelligent agents - to any MCP-enabled service through a single interface.

Max from our DevRel team created an official walkthrough for you to get started:

[Studio Update #04](https://youtu.be/45WPU7P-1QQ?feature=shared)

### MCP Server Trigger

The MCP Server Trigger turns n8n into an MCP server, providing n8n tools to models running outside of n8n. The node acts as an entry point into n8n for MCP clients. It operates by exposing a URL that MCP clients can interact with to access n8n tools. This means your n8n workflows and integrations are now available to models run elsewhere. Pretty neat.

MCP Server Trigger

[Explore the MCP Server Trigger docs](../integrations/builtin/core-nodes/n8n-nodes-langchain.mcptrigger/)

### MCP Client Tool

The MCP Client Tool node is a MCP client, allowing you to use the tools exposed by an external MCP server. You can connect the MCP Client Tool node to your models to call external tools with n8n agents. In this regard it is similar to using a n8n tool with your AI agent. One advantage is that the MCP Client Tool can access multiple tools on the MCP server at once, keeping your canvas cleaner and easier to understand.

MCP Client Tools

[Explore the MCP Client Tool docs](../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.toolmcp/)

### Node updates

- Added a node for Azure Cosmos DB
- Added a node for Milvus Vector Store
- Updated the Email Trigger (IMAP) node

### Contributors

[adina-hub](https://github.com/adina-hub)\
[umanamente](https://github.com/umanamente)

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.87.2

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.87.1...n8n@1.87.2) for this version.\
**Release date:** 2025-04-09

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.86.1

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.86.0...n8n@1.86.1) for this version.\
**Release date:** 2025-04-09

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.87.1

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.87.0...n8n@1.87.1) for this version.\
**Release date:** 2025-04-08

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.87.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.86.0...n8n@1.87.0) for this version.\
**Release date:** 2025-04-07

This release contains new nodes, node updates, API updates, core updates, editor updates, and bug fixes.

### Contributors

[cesars-gh](https://github.com/cesars-gh)\
[Stamsy](https://github.com/Stamsy)\
[Pash10g](https://github.com/Pash10g)

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.86.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.85.0...n8n@1.86.0) for this version.\
**Release date:** 2025-03-31

This release contains API updates, core updates, editor improvements, node updates, and bug fixes.

### Contributors

[Aijeyomah](https://github.com/Aijeyomah)\
[ownerer](https://github.com/ownerer)\
[ulevitsky](https://github.com/ulevitsky)

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.85.4

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.85.3...n8n@1.85.4) for this version.\
**Release date:** 2025-03-27

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.84.3

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.84.2...n8n@1.84.3) for this version.\
**Release date:** 2025-03-27

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.84.2

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.84.1...n8n@1.84.2) for this version.\
**Release date:** 2025-03-26

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.85.3

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.85.2...n8n@1.85.3) for this version.\
**Release date:** 2025-03-26

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.85.2

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.85.1...n8n@1.85.2) for this version.\
**Release date:** 2025-03-25

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.85.1

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.85.0...n8n@1.85.1) for this version.\
**Release date:** 2025-03-25

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.85.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.84.0...n8n@1.85.0) for this version.\
**Release date:** 2025-03-24

This release contains a new node, a new credential, core updates, editor updates, node updates, and bug fixes.

### Folders

What can we say about folders? Well, they’re super handy for categorizing just about everything and they’re finally available for your n8n workflows. Tidy up your workspace with unlimited folders and nested folders. Search for workflows within folders. It’s one of the ways we’re making it easier to organize your n8n instances more effectively.

**How to use it:**

Create and manage folders within your personal space or within projects. You can also create workflows from within a folder. You may need to restart your instance in order to activate folders.

It's a folder alright

Folders are available for all [registered](../hosting/community-edition-features/#registered-community-edition) users so get started with decluttering your workspace now and look for more features (like drag and drop) to organize your instances soon.

### Enhancements to Form Trigger Node

Recent updates to the Form Trigger node have made it a more powerful tool for building business solutions. These enhancements provide more flexibility and customization, enabling teams to create visually engaging and highly functional workflows with forms.

- **HTML customization:** Add custom HTML to forms, including embedded images and videos, for richer user experiences.
- **Custom CSS support**: Apply custom styles to user-facing components to align forms with your brand’s look and feel. Adjust fonts, colors, and spacing for a seamless visual identity.
- **Form previews:** Your form’s description and title will pull into previews of your form when sharing on social media or messaging apps, providing a more polished look.
- **Hidden fields:** Use query parameters to add hidden fields, allowing you to pass data—such as a referral source—without exposing it to the user.
- **New responses options:** Respond to user submissions in multiple ways including text, HTML, or a downloadable file (binary format). This enables forms to display rich webpages or deliver digital assets such as dynamically generated invoices or personalized certificates.

Form with custom CSS applied

These improvements elevate the Form Trigger node beyond a simple workflow trigger, transforming it into a powerful tool for addressing use cases from data collection and order processing to custom content creation.

### Contributors

[Fank](https://github.com/Fank)

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.84.1

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.84.0...n8n@1.84.1) for this version.\
**Release date:** 2025-03-18

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.84.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.83.0...n8n@1.84.0) for this version.\
**Release date:** 2025-03-17

This release contains a new node, node updates, editor updates, and bug fixes.

### Contributors

[Pash10g](https://github.com/Pash10g)

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.83.2

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.83.1...n8n@1.83.2) for this version.\
**Release date:** 2025-03-14

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.82.4

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.82.3...n8n@1.82.4) for this version.\
**Release date:** 2025-03-14

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.82.3

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.82.2...n8n@1.82.3) for this version.\
**Release date:** 2025-03-13

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.83.1

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.83.0...n8n@1.83.1) for this version.\
**Release date:** 2025-03-12

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.83.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.82.0...n8n@1.83.0) for this version.\
**Release date:** 2025-03-12

This release contains bug fixes and an editor update.

### Schema Preview

Schema Preview lets you view and work with a node’s expected output without executing it or adding credentials, keeping you in flow while building.

- **See expected node outputs instantly.** View schemas for over 100+ nodes to help you design workflows efficiently without extra steps.
- **Define workflow logic first, take care of credentials later.** Build your end-to-end workflow without getting sidetracked by credential setup.
- **Avoid unwanted executions when building.** Prevent unnecessary API calls, unwanted data changes, or potential third-party service costs by viewing outputs without executing nodes.

**How to use it:**

- Add a node with Schema Preview support to your workflow.
- Open the next node in the sequence - Schema Preview data appears in the Node Editor where you would typically find it in the Schema View.
- Use Schema Preview fields just like other schema data - drag and drop them into parameters and settings as needed.

[](/_video/release-notes/Schema_preview.mp4)

Don’t forget to add the required credentials before putting your workflow into production.

### Contributors

[pemontto](https://github.com/pemontto)\
[Haru922](https://github.com/Haru922)

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.82.2

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.82.1...n8n@1.82.2) for this version.\
**Release date:** 2025-03-12

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.82.1

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.82.0...n8n@1.82.1) for this version.\
**Release date:** 2025-03-04

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.82.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.81.0...n8n@1.82.0) for this version.\
**Release date:** 2025-03-03

This release contains core updates, editor updates, new nodes, node updates, new credentials, credential updates, and bug fixes.

### Tidy up

Tidy up instantly aligns nodes, centers stickies, untangles connections, and brings structure to your workflows. Whether you're preparing to share a workflow or just want to improve readability, this feature saves you time and makes your logic easier to follow. Clean, well-organized workflows aren't just nicer to look at—they’re also quicker to understand.

**How to:**

Open the workflow you want to tidy, then choose one of these options:

- Click the **Tidy up** button in the bottom-left corner of the canvas (it looks like a broom 🧹)
- Press **Shift + Alt + T** on your keyboard
- Right-click anywhere on the canvas and select **Tidy up workflow**

Want to tidy up just part of your workflow? Select the specific nodes you want to clean up first - Tidy up will only adjust those, along with any stickies behind them.

[](/_video/release-notes/tidy_up.mp4)

### Multiple API keys

n8n now supports multiple API keys, allowing users to generate and manage separate keys for different workflows or integrations. This improves security by enabling easier key rotation and isolation of credentials. Future updates will introduce more granular controls.

Multiple API keys

### Contributors

[Rostammahabadi](https://github.com/Rostammahabadi)\
[Lanhild](https://github.com/Lanhild)\
[matthiez](https://github.com/matthiez)\
[feelgood-interface](https://github.com/feelgood-interface)\
[adina-hub](https://github.com/adina-hub)

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.81.4

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.81.3...n8n@1.81.4) for this version.\
**Release date:** 2025-03-03

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.81.3

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.81.2...n8n@1.81.3) for this version.\
**Release date:** 2025-03-03

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.81.2

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.81.1...n8n@1.81.2) for this version.\
**Release date:** 2025-02-28

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.80.5

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.80.4...n8n@1.80.5) for this version.\
**Release date:** 2025-02-28

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.80.4

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.80.3...n8n@1.80.4) for this version.\
**Release date:** 2025-02-27

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.81.1

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.81.0...n8n@1.81.1) for this version.\
**Release date:** 2025-02-27

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.81.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.80.0...n8n@1.81.0) for this version.\
**Release date:** 2025-02-24

This release contains bug fixes, a core update, editor improvements, and a node update.

### Improved partial executions

The new execution engine for partial executions ensures that testing parts of a workflow in the builder closely mirrors production behaviour. This makes iterating with updated run-data faster and more reliable, particularly for complex workflows.

Before, user would test parts of a workflow in the builder that didn't consistently reflect production behaviour, leading to unexpected results during development.

This update aligns workflow execution in the builder with production behavior.

Here is an example for loops:

Before

[](/_video/release-notes/Partial-execution-loop-before.mp4)

After

[](/_video/release-notes/Partial-execution-loop-after.mp4)

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.80.3

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.80.2...n8n@1.80.3) for this version.\
**Release date:** 2025-02-21

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.79.4

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.79.3...n8n@1.79.4) for this version.\
**Release date:** 2025-02-21

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.80.2

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.80.1...n8n@1.80.2) for this version.\
**Release date:** 2025-02-21

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.79.3

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.79.2...n8n@1.79.3) for this version.\
**Release date:** 2025-02-21

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.80.1

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.80.0...n8n@1.80.1) for this version.\
**Release date:** 2025-02-20

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.79.2

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.79.1...n8n@1.79.2) for this version.\
**Release date:** 2025-02-20

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.80.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.79.0...n8n@1.80.0) for this version.\
**Release date:** 2025-02-17

This release contains bug fixes and an editor improvement.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.75.3

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.75.2...n8n@1.75.3) for this version.\
**Release date:** 2025-02-17

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.74.4

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.74.3...n8n@1.74.4) for this version.\
**Release date:** 2025-02-17

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.79.1

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.79.0...n8n@1.79.1) for this version.\
**Release date:** 2025-02-15

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.78.1

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.78.0...n8n@1.78.1) for this version.\
**Release date:** 2025-02-15

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.77.4

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.77.3...n8n@1.77.4) for this version.\
**Release date:** 2025-02-15

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.76.4

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.76.3...n8n@1.76.4) for this version.\
**Release date:** 2025-02-15

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.79.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.77.0...n8n@1.78.0) for this version.\
**Release date:** 2025-02-12

This release contains new features, node updates, and bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.77.3

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.77.2...n8n@1.77.3) for this version.\
**Release date:** 2025-02-06

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.78.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.77.0...n8n@1.78.0) for this version.\
**Release date:** 2025-02-05

This release contains new features, node updates, and bug fixes.

### Contributors

[mocanew](https://github.com/mocanew)\
[Timtendo12](https://github.com/Timtendo12)

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.77.2

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.77.1...n8n@1.77.2) for this version.\
**Release date:** 2025-02-04

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.76.3

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.76.2...n8n@1.76.3) for this version.\
**Release date:** 2025-02-04

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.77.1

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.77.0...n8n@1.77.1) for this version.\
**Release date:** 2025-02-03

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.76.2

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.76.1...n8n@1.76.2) for this version.\
**Release date:** 2025-02-03

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.77.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.76.0...n8n@1.77.0) for this version.\
**Release date:** 2025-01-29

This release contains new features, editor updates, new nodes, new credentials, node updates, and bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.76.1

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.76.0...n8n@1.76.1) for this version.\
**Release date:** 2025-01-23

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.76.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.75.0...n8n@1.76.0) for this version.\
**Release date:** 2025-01-22

This release contains new features, editor updates, new credentials, node improvements, and bug fixes.

### Contributors

[Stamsy](https://github.com/Stamsy)\
[GKdeVries](https://github.com/GKdeVries)

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.75.2

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.75.1...n8n@1.75.2) for this version.\
**Release date:** 2025-01-17

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.74.3

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.74.2...n8n@1.74.3) for this version.\
**Release date:** 2025-01-17

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.75.1

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.75.0...n8n@1.75.1) for this version.\
**Release date:** 2025-01-17

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.74.2

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.74.1...n8n@1.74.2) for this version.\
**Release date:** 2025-01-17

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.75.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.74.0...n8n@1.75.0) for this version.\
**Release date:** 2025-01-15

This release contains bug fixes and editor updates.

### Improved consistency across environments

We added new UX and automatic changes improvements resulting in a better consistency between your staging and production instances.

Previously, users faced issues like:

- Lack of visibility into required credential updates when pulling changes
- Incomplete synchronization, where changes — such as deletions — weren’t always applied across environments
- Confusing commit process, making it unclear what was being pushed or pulled

We addressed these by:

- Clearly indicating required credential updates when pulling changes
- Ensuring deletions and other modifications sync correctly across environments
- Improving commit selection to provide better visibility into what’s being pushed

Commit modal

Pull notification

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.74.1

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.74.0...n8n@1.74.1) for this version.\
**Release date:** 2025-01-09

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.74.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.73.0...n8n@1.74.0) for this version.\
**Release date:** 2025-01-08

This release contains new features, a new node, node updates, performance improvements and bug fixes.

### Overhauled Code node editing experience

We added a ton of new helpers to the Code node, making edits of your code much faster and more comfortable. You get:

- TypeScript autocomplete
- TypeScript linting
- TypeScript hover tips
- Search and replace
- New keyboard shortcuts based on the VSCode keymap
- Auto-formatting using prettier (Alt+Shift+F)
- Remember folded regions and history after refresh
- Multi cursor
- Type function in the Code node using JSDoc types
- Drag and drop for all Code node modes
- Indentation markers

We build this on a web worker architecture so you won't have to suffer from performance degradation while typing.

To get the full picture, check out our Studio update with Max and Elias, where they discuss and demo the new editing experience. 👇

[Studio Update #04](https://youtu.be/De1E58MPaMQ?t=645)

### New node: Microsoft Entra ID

Microsoft Entra ID (formerly known as Microsoft Azure Active Directory or Azure AD) is used for cloud-based identity and access management. [The new node](../integrations/builtin/app-nodes/n8n-nodes-base.microsoftentra/) supports a wide range of Microsoft Entra ID features, which includes creating, getting, updating, and deleting users and groups, as well as adding users to and removing them from groups.

### Node updates

- [AI Agent](../integrations/builtin/cluster-nodes/root-nodes/n8n-nodes-langchain.agent/): Vector stores can now be directly used as tools for the agent
- [Code](../code/builtin/overview/): Tons of new speed and convenience features, see above for details
- [Google Vertex Chat](../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.lmchatgooglevertex/): Added option to specify the GCP region for the Google API credentials
- [HighLevel](../integrations/builtin/app-nodes/n8n-nodes-base.highlevel/): Added support for calendar items

We also added a custom [projects](../user-management/rbac/projects/) icon selector on top of the available emojis. Pretty!

### Contributors

[igatanasov](https://github.com/igatanasov)\
[Stamsy](https://github.com/Stamsy)\
[feelgood-interface](https://github.com/feelgood-interface)

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.73.1

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.73.0...n8n@1.73.1) for this version.\
**Release date:** 2024-12-19

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.73.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.72.0...n8n@1.73.0) for this version.\
**Release date:** 2024-12-19

This release contains node updates, performance improvements, and bug fixes.

### Node updates

- [AI Agent](../integrations/builtin/cluster-nodes/root-nodes/n8n-nodes-langchain.agent/): Updated descriptions for Chat Trigger options
- [Facebook Graph API](../integrations/builtin/app-nodes/n8n-nodes-base.facebookgraphapi/): Updated for API v21.0
- [Gmail](../integrations/builtin/app-nodes/n8n-nodes-base.gmail/): Added two new options for the `Send and wait` operation, free text and custom form
- [Linear Trigger](../integrations/builtin/trigger-nodes/n8n-nodes-base.lineartrigger/): Added support for admin scope
- [MailerLite](../integrations/builtin/app-nodes/n8n-nodes-base.mailerlite/): Now supports the new API
- [Slack](../integrations/builtin/app-nodes/n8n-nodes-base.slack/): Added two new options for the `Send and wait` operation, free text and custom form

We also added credential support for [SolarWinds IPAM](../integrations/builtin/credentials/solarwindsipam/) and [SolarWinds Observability](../integrations/builtin/credentials/solarwindsobservability/).

Last, but not least, we [improved the schema view performance in the node details view by 90%](https://github.com/n8n-io/n8n/pull/12180) and added drag and drop re-ordering to parameters. This comes in very handy in the [If](../integrations/builtin/core-nodes/n8n-nodes-base.if/) or [Edit Fields](../integrations/builtin/core-nodes/n8n-nodes-base.set/) nodes.

### Contributors

[CodeShakingSheep](https://github.com/CodeShakingSheep)\
[mickaelandrieu](https://github.com/mickaelandrieu)\
[Stamsy](https://github.com/Stamsy)\
[pbdco](https://github.com/pbdco)

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.72.1

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.72.0...n8n@1.72.1) for this version.\
**Release date:** 2024-12-12

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.71.3

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.71.2...n8n@1.71.3) for this version.\
**Release date:** 2024-12-12

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.72.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.71.0...n8n@1.72.0) for this version.\
**Release date:** 2024-12-11

This release contains node updates, usability improvements, and bug fixes.

### Node updates

- [AI Transform](../integrations/builtin/core-nodes/n8n-nodes-base.aitransform/): The `maximum context length` error now retries with reduced payload size
- [Redis](../integrations/builtin/app-nodes/n8n-nodes-base.redis/): Added support for `continue on fail`

### Improved commit modal

We added filters and text search to the commit modal when working with [Environments](../source-control-environments/). This will make committing easier as we provide more information and better visibility. Environments are available on the Enterprise plan.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.71.2

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.71.1...n8n@1.71.2) for this version.\
**Release date:** 2024-12-10

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.70.4

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.70.3...n8n@1.70.4) for this version.\
**Release date:** 2024-12-10

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.71.1

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.71.0...n8n@1.71.1) for this version.\
**Release date:** 2024-12-06

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.70.3

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.70.2...n8n@1.70.3) for this version.\
**Release date:** 2024-12-05

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.71.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.70.2...n8n@1.71.0) for this version.\
**Release date:** 2024-12-04

This release contains node updates, performance improvements, and bug fixes.

### Task runners for the Code node in public beta

We're introducing a significant performance upgrade to the Code node with our new Task runner system. This enhancement moves JavaScript code execution to a separate process, improving your workflow execution speed while adding better isolation.

Task runners overview

Our benchmarks show up to 6x improvement in workflow executions using Code nodes - from approximately 6 to 35 executions per second. All these improvements happen under the hood, keeping your Code node experience exactly the same.

The Task runner comes in two modes:

- Internal mode (default): Perfect for getting started, automatically managing task runners as child processes
- External mode: For advanced hosting scenarios requiring maximum isolation and security

Currently, this feature is opt-in and can be enabled using [environment variables](../hosting/configuration/environment-variables/task-runners/). Once stable, it will become the default execution method for Code nodes.

To start using Task runners today, [check out the docs](../hosting/configuration/task-runners/).

### Node updates

- [AI Transform node](../integrations/builtin/core-nodes/n8n-nodes-base.aitransform/): We improved the prompt for code generation to transform data
- [Code node](../integrations/builtin/core-nodes/n8n-nodes-base.code/): We added a warning if `pairedItem` is absent or could not be auto mapped

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.70.2

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.70.1...n8n@1.70.2) for this version.\
**Release date:** 2024-12-04

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.70.1

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.70.0...n8n@1.70.1) for this version.\
**Release date:** 2024-11-29

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.70.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.69.0...n8n@1.70.0) for this version.\
**Release date:** 2024-11-27

This release contains node updates, performance improvements and bug fixes.

### New canvas in beta

The new canvas is now the default setting for all users. It should bring significant performance improvements and adds a handy minimap. As it is still a beta version you can still revert to the previous version with the three dot menu.

We're looking forward to your feedback. Should you encounter a bug, you will find a handy button to create an issue at the bottom of the new canvas as well.

### Node updates

- We added credential support for [Zabbix](../integrations/builtin/credentials/zabbix/) to the HTTP request node
- We added new OAuth2 credentials for [Microsoft SharePoint](../integrations/builtin/credentials/microsoft/)
- The [Slack node](../integrations/builtin/app-nodes/n8n-nodes-base.slack/#operations) now uses markdown for the approval message when using the `Send and Wait for Approval` operation

### Contributors

[feelgood-interface](https://github.com/feelgood-interface)\
[adina-hub](https://github.com/adina-hub)

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.68.1

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.68.0...n8n@1.68.1) for this version.\
**Release date:** 2024-11-26

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.69.2

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.69.1...n8n@1.69.2) for this version.\
**Release date:** 2024-11-26

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.69.1

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.69.0...n8n@1.69.1) for this version.\
**Release date:** 2024-11-25

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.69.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.68.0...n8n@1.69.0) for this version.\
**Release date:** 2024-11-20

This release contains a new feature, node improvements and bug fixes.

### Sub-workflow debugging

We made it much easier to debug sub-workflows by improving their accessibility from the parent workflow.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.68.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.67.1...n8n@1.68.0) for this version.\
**Release date:** 2024-11-13

This release contains node updates, performance improvements and many bug fixes.

#### New AI agent canvas chat

We revamped the chat experience for AI agents on the canvas. A neatly organized view instead of a modal hiding the nodes. You can now see the canvas, chat and logs at the same time when testing your workflow.

[](/_video/release-notes/AI-chat-on-canvas.mp4)

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.67.1

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.67.0...n8n@1.67.1) for this version.\
**Release date:** 2024-11-07

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.67.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.66.0...n8n@1.67.0) for this version.\
**Release date:** 2024-11-06

This release contains node updates and bug fixes.

### Node updates

- [AI Transform](../integrations/builtin/core-nodes/n8n-nodes-base.aitransform/): Improved usability
- [Anthropic Chat Model Node](../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.lmchatanthropic/): Added Haiku 3.5 support
- [Convert to File](../integrations/builtin/core-nodes/n8n-nodes-base.converttofile/): Added delimiter option for writing to CSV
- [Gmail Trigger](../integrations/builtin/trigger-nodes/n8n-nodes-base.gmailtrigger/): Added option to filter for draft messages
- [Intercom](../integrations/builtin/app-nodes/n8n-nodes-base.intercom/): Credential can now be used in the HTTP Request node
- [Rapid7 InsightVM](../integrations/builtin/credentials/rapid7insightvm/): Added credential support

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.66.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.65.2...n8n@1.66.0) for this version.\
**Release date:** 2024-10-31

This release contains performance improvements, a node update and bug fixes.

### Node update

- [Anthropic Chat Model](../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.lmchatanthropic/): Added support for claude-3-5-sonnet-20241022

We made updates to how projects and workflow ownership are displayed making them easier to understand and navigate.

We further improved the performance logic of partial executions, leading to a smoother and more enjoyable building experience.

### New n8n canvas alpha

We have enabled the alpha version of our new canvas. The canvas is the ‘drawing board’ of the n8n editor, and we’re working on a full rewrite. Your feedback and testing will help us improve it. [Read all about it on our community forum](https://community.n8n.io/t/help-us-test-the-new-n8n-canvas-alpha/60070).

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.65.2

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.65.1...n8n@1.65.2) for this version.\
**Release date:** 2024-10-28

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.64.3

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.64.2...n8n@1.64.3) for this version.\
**Release date:** 2024-10-25

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.65.1

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.65.0...n8n@1.65.1) for this version.\
**Release date:** 2024-10-25

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.65.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.64.1...n8n@1.65.0) for this version.\
**Release date:** 2024-10-24

[Breaking change](https://github.com/n8n-io/n8n/blob/master/packages/cli/BREAKING-CHANGES.md)

What changed? Queue polling via the environment variable `QUEUE_RECOVERY_INTERVAL` has been removed.

When is action necessary? If you have set `QUEUE_RECOVERY_INTERVAL`, you can remove it as it no longer has any effect.

This release contains a new features, new nodes, node enhancements, and bug fixes.

### New node: n8n Form

Use the [n8n Form node](../integrations/builtin/core-nodes/n8n-nodes-base.form/) to create user-facing forms with multiple pages. You can add other nodes with custom logic between to process user input. Start the workflow with a [n8n Form Trigger](../integrations/builtin/core-nodes/n8n-nodes-base.formtrigger/).

A multi-page form with branching

Additionally you can:

- Set default selections with query parameters
- Define the form with a JSON array of objects
- Show a completion screen and redirect to another URL

### Node updates

New nodes:

- [Google Business Profile](../integrations/builtin/app-nodes/n8n-nodes-base.googlebusinessprofile/) and [Google Business Profile Trigger](../integrations/builtin/trigger-nodes/n8n-nodes-base.googlebusinessprofiletrigger/): Use these to integrate Google Business Profile reviews and posts with your workflows

Enhanced nodes:

- [AI Agent](../integrations/builtin/cluster-nodes/root-nodes/n8n-nodes-langchain.agent/): Removed the requirement to add at least one tool
- [GitHub](../integrations/builtin/app-nodes/n8n-nodes-base.github/): Added workflows as a resource operation
- [Structured Output Parser](../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.outputparserstructured/): Added more user-friendly error messages

For additional security, we improved how we handle multi-factor authentication, hardened config file permissions and introduced JWT for the public API.

For better performance, we improved how partial executions are handled in loops.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

### Contributors

- [Idan Fishman](https://github.com/idanfishman)

## n8n@1.64.2

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.64.1...n8n@1.64.2) for this version.\
**Release date:** 2024-10-24

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.64.1

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.64.0...n8n@1.64.1) for this version.\
**Release date:** 2024-10-21

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.64.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.63.4...n8n@1.64.0) for this version.\
**Release date:** 2024-10-16

This release contains a new node, node enhancements, performance improvements and bug fixes.

### Enhanced node: Remove Duplicates

The [Remove Duplicates node](../integrations/builtin/core-nodes/n8n-nodes-base.removeduplicates/) got a major makeover with the addition of two new operations:

- Remove Items Processed in Previous Executions: Compare items in the current input to items from previous executions and remove duplicates
- Clear Deduplication History: Wipe the memory of items from previous executions.

This makes it easier to only process new items from any data source. For example, you can now more easily poll a Google sheet for new entries by `id` or remove duplicate orders from the same customer by comparing their `order date`. The great thing is, you can now do this within **and across** workflow runs.

### New node: Gong

The new node for [Gong](../integrations/builtin/app-nodes/n8n-nodes-base.gong/) allows you to get users and calls to process them further in n8n. Very useful for sales related workflows.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

### Contributors

- [Sören Uhrbach](https://github.com/soerenuhrbach)

## n8n@1.63.4

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.63.3...n8n@1.63.4) for this version.\
**Release date:** 2024-10-15

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.62.6

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.62.5...n8n@1.62.6) for this version.\
**Release date:** 2024-10-15

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.63.3

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.63.2...n8n@1.63.3) for this version.\
**Release date:** 2024-10-15

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.63.2

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.63.1...n8n@1.63.2) for this version.\
**Release date:** 2024-10-11

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.62.5

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.62.4...n8n@1.62.5) for this version.\
**Release date:** 2024-10-11

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.63.1

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.63.0...n8n@1.63.1) for this version.\
**Release date:** 2024-10-11

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.62.4

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.62.3...n8n@1.62.4) for this version.\
**Release date:** 2024-10-11

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.63.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.62.3...n8n@1.63.0) for this version.\
**Release date:** 2024-10-09

[Breaking change](https://github.com/n8n-io/n8n/blob/master/packages/cli/BREAKING-CHANGES.md)

What changed?

- The worker server used to bind to IPv6 by default. It now binds to IPv4 by default.
- The worker server's `/healthz` used to report healthy status based on database and Redis checks. It now reports healthy status regardless of database and Redis status, and the database and Redis checks are part of `/healthz/readiness`.

When is action necessary?

- If you experience a port conflict error when starting a worker server using its default port, set a different port for the worker server with `QUEUE_HEALTH_CHECK_PORT`.
- If you are relying on database and Redis checks for worker health status, switch to checking `/healthz/readiness` instead of `/healthz`.

This release contains new features, node enhancements and bug fixes.

### Node updates

- [OpenAI](../integrations/builtin/app-nodes/n8n-nodes-langchain.openai/): Added the option to choose between the default memory connector to provide memory to the assistant or to specify a thread ID
- [Gmail](../integrations/builtin/app-nodes/n8n-nodes-base.gmail/) and [Slack](../integrations/builtin/app-nodes/n8n-nodes-base.slack/): Added custom approval operations to have a human in the loop of a workflow

We have also optimized the [worker health checks](../hosting/logging-monitoring/monitoring/) (see breaking change above).

Each credential now has a seperate url you can link to. This makes sharing much easier.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

### Contributors

[Pemontto](https://github.com/pemontto)

## n8n@1.62.3

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.62.2...n8n@1.62.3) for this version.\
**Release date:** 2024-10-08

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.62.2

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.62.1...n8n@1.62.2) for this version.\
**Release date:** 2024-10-07

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.62.1

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.61.0...n8n@1.62.1) for this version.\
**Release date:** 2024-10-02

This release contains new features, node enhancements and bug fixes.

Skipped 1.62.0

We skipped 1.62.0 and went straight to 1.62.1 with an additional fix.

#### Additional nodes as tools

We have made additional nodes usable with the [Tools AI Agent node](../integrations/builtin/cluster-nodes/root-nodes/n8n-nodes-langchain.agent/tools-agent/).

[](/_video/release-notes/nodes-as-tools.mp4)

Additionally, we have added a `$fromAI()` placeholder function to use with tools, allowing you to dynamically pass information from the models to the connected tools. This function works similarly to placeholders used elsewhere in n8n.

Both of these new features enable you to build even more powerful AI agents by drawing directly from the apps your business uses. This makes integrating LLMs into your business processes even easier than before.

### Node updates

- [Google BigQuery](../integrations/builtin/app-nodes/n8n-nodes-base.googlebigquery/): Added option to return numeric values as integers and not strings
- [HTTP Request](../integrations/builtin/core-nodes/n8n-nodes-base.httprequest/): Added credential support for Sysdig
- [Invoice Ninja](../integrations/builtin/app-nodes/n8n-nodes-base.invoiceninja/): Additional query params for getAll requests
- [Question and Answer Chain](../integrations/builtin/cluster-nodes/root-nodes/n8n-nodes-langchain.chainretrievalqa/): Added the option to use a custom prompt

Drag and drop insertion on cursor position from schema view is now also enabled for code, SQL and Html fields in nodes.

Customers with an enterprise license can now rate, tag and highlight execution data in the executions view. To use highlighting, add an [Execution Data Node](../integrations/builtin/core-nodes/n8n-nodes-base.executiondata/) (or Code node) to the workflow to set [custom executions data](../workflows/executions/custom-executions-data/).

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

### Contributors

[Benjamin Roedell](https://github.com/benrobot)\
[CodeShakingSheep](https://github.com/CodeShakingSheep)\
[manuelbcd](https://github.com/manuelbcd)\
[Miguel Prytoluk](https://github.com/mprytoluk)

## n8n@1.61.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.60.1...n8n@1.61.0) for this version.\
**Release date:** 2024-09-25

This release contains new features, node enhancements and bug fixes.

### Node updates

- [Brandfetch](../integrations/builtin/app-nodes/n8n-nodes-base.brandfetch/): Updated to use the new API
- [Slack](../integrations/builtin/app-nodes/n8n-nodes-base.slack/): Made adding or removing the workflow link to a message easier

Big datasets now render faster thanks to virtual scrolling and execution annotations are harder to delete.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.59.4

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.59.3...n8n@1.59.4) for this version.\
**Release date:** 2024-09-20

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.60.1

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.60.0...n8n@1.60.1) for this version.\
**Release date:** 2024-09-20

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.60.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.59.3...n8n@1.60.0) for this version.\
**Release date:** 2024-09-18

This release contains new features, node enhancements and bug fixes.

#### Queue metrics for workers

You can now [expose and consume metrics from your workers](../hosting/configuration/configuration-examples/prometheus/). The worker instances have the same metrics available as the main instance(s) and can be configured with [environment variables](../hosting/configuration/environment-variables/endpoints/).

You can now customize the maximum file size when uploading files within forms to webhooks. The [environment variable to set](../hosting/configuration/environment-variables/endpoints/) for this is `N8N_FORMDATA_FILE_SIZE_MAX`. The default setting is 200MiB.

### Node updates

Enhanced nodes:

- [Invoice Ninja](../integrations/builtin/app-nodes/n8n-nodes-base.invoiceninja/): Added actions for bank transactions
- [OpenAI](../integrations/builtin/app-nodes/n8n-nodes-langchain.openai/): Added O1 models to the model select

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

### Contributors

[CodeShakingSheep](https://github.com/CodeShakingSheep)

## n8n@1.59.3

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.59.2...n8n@1.59.3) for this version.\
**Release date:** 2024-09-18

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.59.2

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.59.1...n8n@1.59.2) for this version.\
**Release date:** 2024-09-17

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.59.1

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.59.0...n8n@1.59.1) for this version.\
**Release date:** 2024-09-16

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.58.2

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.58.1...n8n@1.58.2) for this version.\
**Release date:** 2024-09-12

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.59.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.58.1...n8n@1.59.0) for this version.\
**Release date:** 2024-09-11

Chat Trigger

If you are using the Chat Trigger in "Embedded Chat" mode, with authentication turned on, you could see errors connecting to n8n if the authentication on the sending/embedded side is mis-configured.

This release contains bug fixes and feature enhancements.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

### Contributors

[oscarpedrero](https://github.com/oscarpedrero)

## n8n@1.58.1

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.58.0...n8n@1.58.1) for this version.\
**Release date:** 2024-09-06

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.58.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.57.0...n8n@1.58.0) for this version.\
**Release date:** 2024-09-05

This release contains new features, bug fixes and feature enhancements.

#### New node: PGVector Vector Store

This release adds the PGVector Vector Store node. Use this node to interact with the PGVector tables in your PostgreSQL database. You can insert, get, and retrieve documents from a vector table to provide them to a retriever connected to a chain.

#### See active collaborators on workflows

We added collaborator avatars back to the workflow canvas. You will see other users who are active on the workflow, preventing you from overriding each other's work.

Collaboration avatars

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.57.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.56.2...n8n@1.57.0) for this version.\
**Release date:** 2024-08-28

This release contains new features and bug fixes.

#### Improved execution queue handling

We are [exposing new execution queue metrics](../hosting/configuration/configuration-examples/prometheus/) to give users more visibility of the queue length. This helps to inform decisions on horizontal scaling, based on queue status. We have also made querying executions faster.

#### New credentials for the HTTP Request node

We added credential support for Datadog, Dynatrace, Elastic Security, Filescan, Iris, and Malcore to the HTTP Request node making it easier to use existing credentials.

We also made it easier to select workflows as tools when working with AI agents by implementing a new `workflow selector` parameter type.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

### Contributors

[Bram Kn](https://github.com/bramkn)

## n8n@1.56.2

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.56.1...n8n@1.56.2) for this version.\
**Release date:** 2024-08-26

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.56.1

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.56.0...n8n@1.56.1) for this version.\
**Release date:** 2024-08-23

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.56.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.55.3...n8n@1.56.0) for this version.\
**Release date:** 2024-08-21

This release contains node updates, security and bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

### Contributors

[CodeShakingSheep](https://github.com/CodeShakingSheep)\
[Oz Weiss](https://github.com/thewizarodofoz)

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.55.3

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.55.2...n8n@1.55.3) for this version.\
**Release date:** 2024-08-16

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.55.2

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.55.1...n8n@1.55.2) for this version.\
**Release date:** 2024-08-16

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.55.1

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.55.0...n8n@1.55.1) for this version.\
**Release date:** 2024-08-15

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.54.4

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.54.3...n8n@1.54.4) for this version.\
**Release date:** 2024-08-15

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.54.3

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.54.2...n8n@1.54.3) for this version.\
**Release date:** 2024-08-15

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.54.2

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.54.1...n8n@1.54.2) for this version.\
**Release date:** 2024-08-14

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.55.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.54.1...n8n@1.55.0) for this version.\
**Release date:** 2024-08-14

[Breaking change](https://github.com/n8n-io/n8n/blob/master/packages/cli/BREAKING-CHANGES.md)

The N8N_BLOCK_FILE_ACCESS_TO_N8N_FILES environment variable now also blocks access to n8n's static cache directory at ~/.cache/n8n/public.

If you are writing to or reading from a file at n8n's static cache directory via a node, e.g. Read/Write Files from Disk, please update your node to use a different path.

This release contains a new feature, a new node, a node update and bug fixes.

#### Override the npm registry

This release adds the option to override the npm registry for installing community packages. This is a paid feature.

We now also prevent npm downloading community packages from a compromised npm registry by explicitly using --registry in all npm install commands.

#### New node: AI Transform

This release adds the [AI Transform node](../integrations/builtin/core-nodes/n8n-nodes-base.aitransform/). Use the AI Transform node to generate code snippets based on your prompt. The AI is context-aware, understanding the workflow’s nodes and their data types. The node is only available on [Cloud plans](../manage-cloud/overview/).

#### New node: Okta

This release adds the [Okta node](../integrations/builtin/app-nodes/n8n-nodes-base.okta/). Use the Okta node to automate work in Okta and integrate Okta with other applications. n8n has built-in support for a wide range of Okta features, which includes creating, updating, and deleting users.

### Node updates

Enhanced node:

- [MySQL](../integrations/builtin/app-nodes/n8n-nodes-base.mysql/)

This release also adds the new schema view for the expression editor modal.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.54.1

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.54.0...n8n@1.54.1) for this version.\
**Release date:** 2024-08-13

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.53.2

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.53.1...n8n@1.53.2) for this version.\
**Release date:** 2024-08-08

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.54.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.53.1...n8n@1.54.0) for this version.\
**Release date:** 2024-08-07

This release contains new features, node enhancements, bug fixes and updates to our API.

### API update

Our [public REST API](../api/) now supports additional operations:

- Create, delete, and edit roles for users
- Create, read, update and delete projects

Find the details in the [API reference](../api/api-reference/).

### Contributors

[CodeShakingSheep](https://github.com/CodeShakingSheep)\
[Javier Ferrer González](https://github.com/JavierCane)\
[Mickaël Andrieu](https://github.com/mickaelandrieu)\
[Oz Weiss](https://github.com/thewizarodofoz)\
[Pemontto](https://github.com/pemontto)

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.45.2

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.45.1...n8n@1.45.2) for this version.\
**Release date:** 2024-08-06

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.53.1

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.53.0...n8n@1.53.1) for this version.\
**Release date:** 2024-08-02

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.53.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.52.2...n8n@1.53.0) for this version.\
**Release date:** 2024-07-31

This release contains new features, new nodes, node enhancements, bug fixes and updates to our API.

#### Added Google Cloud Platform Secrets Manager support

This release adds [Google Cloud Platform Secrets Manager](../external-secrets/) to the list of external secret stores. We already support AWS secrets, Azure Key Vault, Infisical and HashiCorp Vault. External secret stores are available under an enterprise license.

#### New node: Information Extractor

This release adds the [Information Extractor node](../integrations/builtin/cluster-nodes/root-nodes/n8n-nodes-langchain.information-extractor/). The node is specifically tailored for information extraction tasks. It uses Structured Output Parser under the hood, but provides a simpler way to extract information from text in a structured JSON form.

#### New node: Sentiment Analysis

This release adds the [Sentiment Analysis node](../integrations/builtin/cluster-nodes/root-nodes/n8n-nodes-langchain.sentimentanalysis/). The node leverages LLMs to analyze and categorize the sentiment of input text. Users can easily integrate this node into their workflows to perform sentiment analysis on text data. The node is flexible enough to handle various use cases, from basic positive/negative classification to more nuanced sentiment categories.

### Node updates

Enhanced nodes:

- [Calendly Trigger](../integrations/builtin/trigger-nodes/n8n-nodes-base.calendlytrigger/)
- [HTTP Request](../integrations/builtin/core-nodes/n8n-nodes-base.httprequest/)
- [n8n Form Trigger](../integrations/builtin/core-nodes/n8n-nodes-base.formtrigger/)
- [Shopify](../integrations/builtin/app-nodes/n8n-nodes-base.shopify/)

### API update

Our [public REST API](../api/) now supports additional operations:

- Create, read, and delete for variables
- Filtering workflows by project
- Transferring workflows

Find the details in the [API reference](../api/api-reference/).

### Contributors

[feelgood-interface](https://github.com/feelgood-interface)\
[Oz Weiss](https://github.com/thewizarodofoz)

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.52.2

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.52.1...n8n@1.52.2) for this version.\
**Release date:** 2024-07-31

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.52.1

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.52.0...n8n@1.52.1) for this version.\
**Release date:** 2024-07-26

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.51.2

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.51.1...n8n@1.51.2) for this version.\
**Release date:** 2024-07-26

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.52.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.51.1...n8n@1.52.0) for this version.\
**Release date:** 2024-07-25

[Breaking change](https://github.com/n8n-io/n8n/blob/master/packages/cli/BREAKING-CHANGES.md)

Prometheus metrics enabled via N8N_METRICS_INCLUDE_DEFAULT_METRICS and N8N_METRICS_INCLUDE_API_ENDPOINTS were fixed to include the default n8n\_ prefix.

If you are using Prometheus metrics from these categories and are using a non-empty prefix, please update those metrics to match their new prefixed names.

This release contains new features, node enhancements and bug fixes.

#### Added Azure Key Vault support

This release adds [Azure Key Vault](../external-secrets/) to the list of external secret stores. We already support AWS secrets, Infisical and HashiCorp Vault and are working on Google Secrets Manager. External secret stores are available under an enterprise license.

### Node updates

Enhanced nodes:

- [Pinecone Vector Store](../integrations/builtin/cluster-nodes/root-nodes/n8n-nodes-langchain.vectorstorepinecone/)
- [Supabase Vector Store](../integrations/builtin/cluster-nodes/root-nodes/n8n-nodes-langchain.vectorstoresupabase/)
- [Send Email](../integrations/builtin/core-nodes/n8n-nodes-base.sendemail/)

Deprecated nodes:

- OpenAI Model: You can use the OpenAI Chat Model instead
- Google Palm Chat Model: You can use Google Vertex or Gemini instead
- Google Palm Model: You can use Google Vertex or Gemini instead

## n8n@1.51.1

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.51.0...n8n@1.51.1) for this version.\
**Release date:** 2024-07-23

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.50.2

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.50.1...n8n@1.50.2) for this version.\
**Release date:** 2024-07-23

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.51.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.50.1...n8n@1.51.0) for this version.\
**Release date:** 2024-07-18

This release contains new nodes, node enhancements and bug fixes.

#### New node: Text Classifier

This release adds the [Text Classifier node](../integrations/builtin/cluster-nodes/root-nodes/n8n-nodes-langchain.text-classifier/).

#### New node: Postgres Chat Memory

This release adds the [Postgres Chat Memory node](../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.memorypostgreschat/).

#### New node: Google Vertex Chat Model

This release adds the [Google Vertex Chat Model node](../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.lmchatgooglevertex/).

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

### Node updates

- Enhanced nodes: Asana

## n8n@1.50.1

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.50.0...n8n@1.50.1) for this version.\
**Release date:** 2024-07-16

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.50.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.49.0...n8n@1.50.0) for this version.\
**Release date:** 2024-07-10

This release contains node enhancements and bug fixes.

### Node updates

- Enhanced nodes: Chat Trigger, Google Cloud Firestore, Qdrant Vector Store, Splunk, Telegram
- Deprecated node: Orbit (product shut down)

### Beta Feature Removal

The Ask AI beta feature for the HTTP Request node has been removed from this version

### Contributors

[Stanley Yoshinori Takamatsu](https://github.com/stanleytakamatsu)\
[CodeShakingSheep](https://github.com/CodeShakingSheep)\
[jeanpaul](https://github.com/jeanpaul)\
[adrian-martinez-onestic](https://github.com/adrian-martinez-onestic)\
[Malki Davis](https://github.com/mxdavis)

## n8n@1.49.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.48.3...n8n@1.49.0) for this version.\
**Release date:** 2024-07-03

This release contains a new node, node enhancements, and bug fixes.

### Node updates

- New node added: [Vector Store Tool](../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.toolvectorstore/) for the AI Agent
- Enhanced nodes: Zep Cloud Memory, Copper, Embeddings Cohere, GitHub, Merge, Zammad

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

### Contributors

[Jochem](https://github.com/jvdweerthof)\
[KhDu](https://github.com/KhDu)\
[Nico Weichbrodt](https://github.com/envy)\
[Pavlo Paliychuk](https://github.com/paul-paliychuk)

## n8n@1.48.3

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.48.2...n8n@1.48.3) for this version.\
**Release date:** 2024-07-03

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.47.3

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.47.2...n8n@1.47.3) for this version.\
**Release date:** 2024-07-03

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.48.2

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.48.1...n8n@1.48.2) for this version.\
**Release date:** 2024-07-01

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.47.2

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.47.1...n8n@1.47.2) for this version.\
**Release date:** 2024-07-01

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.48.1

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.48.0...n8n@1.48.1) for this version.\
**Release date:** 2024-06-27

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.48.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.47.1...n8n@1.48.0) for this version.\
**Release date:** 2024-06-27

This release contains bug fixes and feature enhancements.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

### Contributors

[KubeAl](https://github.com/KubeAl)

## n8n@1.47.1

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.47.0...n8n@1.47.1) for this version.\
**Release date:** 2024-06-26

This is a bug fix release.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.47.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.46.0...n8n@1.47.0) for this version.\
**Release date:** 2024-06-20

Breaking change

Calling `$(...).last()` (or `(...).first()` or `$(...).all()`) without arguments now returns the last item (or first or all items) of the output that connects two nodes. Previously, it returned the item/items of the first output of that node. Refer to the [breaking changes log](https://github.com/n8n-io/n8n/blob/master/packages/cli/BREAKING-CHANGES.md#1470) for details.

This release contains bug fixes, feature enhancements, a new node, node enhancements and performance improvements.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

#### New node: HTTP request tool

This release adds the HTTP request tool. You can use it with an AI agent as a tool to collect information from a website or API. Refer to the [HTTP request tool](../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.toolhttprequest/) for details.

### Contributors

[Daniel](https://github.com/daniel-alba17)\
[ekadin-mtc](https://github.com/ekadin-mtc)\
[Eric Francis](https://github.com/EricFrancis12)\
[Josh Sorenson](https://github.com/joshsorenson)\
Mohammad Alsmadi [Nikolai T. Jensen](https://github.com/ch0wm3in)\
[n8n-ninja](https://github.com/n8n-ninja)\
[pebosi](https://github.com/pebosi)\
[Taylor Hoffmann](https://github.com/TaylorHo)

## n8n@1.45.1

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.45.0...n8n@1.45.1) for this version.\
**Release date:** 2024-06-12

This is a bug fix release.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.46.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.45.0...n8n@1.46.0) for this version.\
**Release date:** 2024-06-12

This release contains feature enhancements, node enhancements, and bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

### Contributors

[Jean Khawand](https://github.com/jeankhawand)\
[pemontto](https://github.com/pemontto)\
[Valentin Coppin](https://github.com/valimero)

## n8n@1.44.2

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.44.1...n8n@1.44.2) for this version.\
**Release date:** 2024-06-12

This is a bug fix release.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.42.2

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.42.1...n8n@1.42.2) for this version.\
**Release date:** 2024-06-10

This is a bug fix release.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.45.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.44.1...n8n@1.45.0) for this version.\
**Release date:** 2024-06-06

This release contains new features, node enhancements, and bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.44.1

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.44.0...n8n@1.44.1) for this version.\
**Release date:** 2024-06-03

This is a bug fix release.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.44.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.43.1...n8n@1.44.0) for this version.\
**Release date:** 2024-05-30

This release contains new features, node enhancements, and bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.43.1

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.43.0...n8n@1.43.1) for this version.\
**Release date:** 2024-05-28

This is a bug fix release.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.43.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.42.1...n8n@1.43.0) for this version.\
**Release date:** 2024-05-22

This release contains new features, node enhancements, and bug fixes.

Backup recommended

Although this release doesn't include a breaking change, it is a significant update including database migrations. n8n recommends backing up your data before updating to this version.

Credential sharing required for manual executions

Instance owners and admins: you will see changes if you try to manually execute a workflow where the credentials aren't shared with you. Manual workflow executions now use the same permissions checks as production executions, meaning you can't do a manual execution of a workflow if you don't have access to the credentials. Previously, owners and admins could do manual executions without credentials being shared with them. To resolve this, the credential creator needs to [share the credential](../credentials/credential-sharing/) with you.

#### New feature: Projects

With projects and roles, you can give your team access to collections of workflows and credentials, rather than having to share each workflow and credential individually. Simultaneously, you tighten security by limiting access to people on the relevant team.

Refer to the [RBAC](../user-management/rbac/) documentation for information on creating projects and using roles.

The number of projects and role types vary depending on your plan. Refer to [Pricing](https://n8n.io/pricing/) for details.

[](/_video/release-notes/rbac-glimpse.mp4)

#### New node: Slack Trigger

This release adds a trigger node for Slack. Refer to the [Slack Trigger documentation](../integrations/builtin/trigger-nodes/n8n-nodes-base.slacktrigger/) for details.

### Other highlights

- Improved [memory support for OpenAI assistants](../integrations/builtin/app-nodes/n8n-nodes-langchain.openai/).

### Rolling back to a previous version

If you update to this version, then decide you need to role back:

Self-hosted n8n:

1. Delete any RBAC projects you created.
1. Revert the database migrations using `n8n db:revert`.

Cloud: contact [help@n8n.io](mailto:help@n8n.io).

### Contributors

[Ayato Hayashi](https://github.com/hayashi-ay)\
[Daniil Zobov](https://github.com/ddzobov)\
[Guilherme Barile](https://github.com/GuilhermeBarile)\
[Romain MARTINEAU](https://github.com/RJiraya)

## n8n@1.42.1

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.42.0...n8n@1.42.1) for this version.\
**Release date:** 2024-05-20

This is a bug fix release.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.41.1

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.41.0...n8n@1.41.1) for this version.\
**Release date:** 2024-05-16

This is a bug fix release.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.42.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.41.0...n8n@1.42.0) for this version.\
**Release date:** 2024-05-15

This release contains new features, node enhancements, and bug fixes.

Note that this release removes the AI error debugger. We're working on a new and improved version.

#### New feature: Tools Agent

This release adds a new option to the Agent node: the [Tools Agent](../integrations/builtin/cluster-nodes/root-nodes/n8n-nodes-langchain.agent/tools-agent/).

This agent has an enhanced ability to work with tools, and can ensure a standard output format. This is now the recommended default agent.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

### Contributors

[Mike Quinlan](https://github.com/mjquinlan2000)\
[guangwu](https://github.com/testwill)

## n8n@1.41.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.40.0...n8n@1.41.0) for this version.\
**Release date:** 2024-05-08

This release contains new features, node enhancements, and bug fixes.

Note that this release temporarily disables the AI error helper.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

### Contributors

[Florin Lungu](https://github.com/floryn90)

## n8n@1.40.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.39.1...n8n@1.40.0) for this version.\
**Release date:** 2024-05-02

Breaking change

Please note that this version contains a breaking change for instances using a Postgres database. The default value for the DB_POSTGRESDB_USER environment variable was switched from `root` to `postgres`. Refer to the [breaking changes log](https://github.com/n8n-io/n8n/blob/master/packages/cli/BREAKING-CHANGES.md#1400) for details.

This release contains new features, new nodes, node enhancements, and bug fixes.

#### New feature: Ask AI in the HTTP node

You can now ask AI to help create API requests in the HTTP Request node:

1. In the HTTP Request node, select **Ask AI**.
1. Enter the **Service** and **Request** you want to use. For example, to use the NASA API to get their picture of the day, enter `NASA` in **Service** and `get picture of the day` in **Request**.
1. Check the parameters: the AI tries to fill them out, but you may still need to adjust or correct the configuration.

Self-hosted users need to [enable AI features and provide their own API keys](../hosting/configuration/environment-variables/)

#### New node: Groq Chat Model

This release adds the [Groq Chat Model node](../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.lmchatgroq/).

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

### Contributors

[Alberto Pasqualetto](https://github.com/albertopasqualetto)\
[Bram Kn](https://github.com/bramkn)\
[CodeShakingSheep](https://github.com/CodeShakingSheep)\
[Nicolas-nwb](https://github.com/Nicolas-nwb)\
[pemontto](https://github.com/pemontto)\
[pengqiseven](https://github.com/pengqiseven)\
[webk](https://github.com/webkp)\
[Yoshino-s](https://github.com/Yoshino-s)

## n8n@1.39.1

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.39.0...n8n@1.39.1) for this version.\
**Release date:** 2024-04-25

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.38.2

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.38.1...n8n@1.38.2) for this version.\
**Release date:** 2024-04-25

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.37.4

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.37.3...n8n@1.37.4) for this version.\
**Release date:** 2024-04-25

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.39.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.38.1...n8n@1.39.0) for this version.\
**Release date:** 2024-04-24

This release contains new nodes, node enhancements, and bug fixes.

#### New node: WhatsApp Trigger

This release adds the [WhatsApp Trigger node](../integrations/builtin/trigger-nodes/n8n-nodes-base.whatsapptrigger/).

#### Node enhancement: Multiple methods, one Webhook node

The Webhook Trigger node can now handle calls to multiple HTTP methods. Refer to the [Webhook node documentation](../integrations/builtin/core-nodes/n8n-nodes-base.webhook/common-issues/#listen-for-multiple-http-methods) for information on enabling this.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

### Contributors

[Bram Kn](https://github.com/bramkn)

## n8n@1.38.1

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.38.0...n8n@1.38.1) for this version.\
**Release date:** 2024-04-18

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.37.3

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.37.2...n8n@1.37.3) for this version.\
**Release date:** 2024-04-18

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.38.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.37.2...n8n@1.38.0) for this version.\
**Release date:** 2024-04-17

This release contains new nodes, bug fixes, and node enhancements.

#### New node: Google Gemini Chat Model

This release adds the [Google Gemini Chat Model sub-node](../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.lmchatgooglegemini/).

#### New node: Embeddings Google Gemini

This release adds the [Google Gemini Embeddings sub-node](../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.embeddingsgooglegemini/).

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

### Contributors

[Chengyou Liu](https://github.com/cyliu0)\
[Francesco Mannino](https://github.com/manninofrancesco)

## n8n@1.37.2

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.37.1...n8n@1.37.2) for this version.\
**Release date:** 2024-04-17

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.36.4

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.36.3...n8n@1.36.4) for this version.\
**Release date:** 2024-04-15

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.36.3

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.36.2...n8n@1.36.3) for this version.\
**Release date:** 2024-04-12

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.37.1

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.37.0...n8n@1.37.1) for this version.\
**Release date:** 2024-04-11

Breaking change

Please note that this version contains a breaking change for self-hosted n8n. It removes the `--file` flag for the `execute` CLI command. If you have scripts relying on the `--file` flag, update them to first import the workflow and then execute it using the `--id` flag. Refer to [CLI commands](../hosting/cli-commands/) for more information on CLI options.

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.36.2

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.36.1...n8n@1.36.2) for this version.\
**Release date:** 2024-04-11

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.37.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.36.1...n8n@1.37.0) for this version.\
**Release date:** 2024-04-10

Breaking change

Please note that this version contains a breaking change for self-hosted n8n. It removes the `--file` flag for the `execute` CLI command. If you have scripts relying on the `--file` flag, update them to first import the workflow and then execute it using the `--id` flag. Refer to [CLI commands](../hosting/cli-commands/) for more information on CLI options.

This release contains a new node, improvements to error handling and messaging, node enhancements, and bug fixes.

#### New node: JWT

This release adds the [JWT core node](../integrations/builtin/core-nodes/n8n-nodes-base.jwt/).

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

### Contributors

[Miguel Prytoluk](https://github.com/mprytoluk)

## n8n@1.36.1

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.36.0...n8n@1.36.1) for this version.\
**Release date:** 2024-04-04

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.36.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.35.0...n8n@1.36.0) for this version.\
**Release date:** 2024-04-03

This release contains new nodes, enhancements and bug fixes.

#### New node: Salesforce Trigger node

This release adds the [Salesforce Trigger node](../integrations/builtin/trigger-nodes/n8n-nodes-base.salesforcetrigger/).

#### New node: Twilio Trigger node

This release adds the [Twilio Trigger node](../integrations/builtin/trigger-nodes/n8n-nodes-base.twiliotrigger/).

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.35.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.34.2...n8n@1.35.0) for this version.\
**Release date:** 2024-03-28

This release contains enhancements and bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.34.2

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.34.1...n8n@1.34.2) for this version.\
**Release date:** 2024-03-26

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.34.1

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.34.0...n8n@1.34.1) for this version.\
**Release date:** 2024-03-25

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.34.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.33.1...n8n@1.34.0) for this version.\
**Release date:** 2024-03-20

This release contains new features, new nodes, and bug fixes.

#### New node: Microsoft OneDrive Trigger node

This release adds the [Microsoft OneDrive Trigger node](../integrations/builtin/trigger-nodes/n8n-nodes-base.microsoftonedrivetrigger/). You can now trigger workflows on file and folder creation and update events.

#### New data transformation functions

This release introduces new [data transformation functions](../code/builtin/data-transformation-functions/):

**String**

```
toDateTime() //replaces toDate(). toDate() is retained for backwards compatability.
parseJson()
extractUrlPath()
toBoolean()
base64Encode()
base64Decode()
```

**Number**

```
toDateTime()
toBoolean()
```

**Object**

```
toJsonString()
```

**Array**

```
toJsonString()
```

**Date & DateTime**

```
toDateTime()
toInt()
```

**Boolean**

```
toInt()
```

### Contributors

[Bram Kn](https://github.com/bramkn)\
[pemontto](https://github.com/pemontto)

## n8n@1.33.1

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.33.0...n8n@1.33.1) for this version.\
**Release date:** 2024-03-15

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.32.2

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.32.1...n8n@1.32.2) for this version.\
**Release date:** 2024-03-15

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.33.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.32.1...n8n@1.33.0) for this version.\
**Release date:** 2024-03-13

This release contains new features, node enhancements, and bug fixes.

#### Support for Claude 3

This release adds support for Claude 3 to the [Anthropic Chat Model](../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.lmchatanthropic/) node.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

### Contributors

[gumida](https://github.com/gumida)\
[Ayato Hayashi](https://github.com/hayashi-ay)\
[Jordan](https://github.com/jordanburke)\
[MC Naveen](https://github.com/mcnaveen)

## n8n@1.32.1

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.32.0...n8n@1.32.1) for this version.\
**Release date:** 2024-03-07

This is a bug fix release.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.31.2

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.31.1...n8n@1.31.2) for this version.\
**Release date:** 2024-03-07

This is a bug fix release.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.32.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.31.1...n8n@1.32.0) for this version.\
**Release date:** 2024-03-06

This release contains new features, node enhancements, performance improvements, and bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.31.1

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.31.0...n8n@1.31.1) for this version.\
**Release date:** 2024-03-06

Breaking changes

Please note that this version contains a breaking change. HTTP connections to the editor will fail on domains other than localhost. You can read more about it [here](https://github.com/n8n-io/n8n/blob/master/packages/cli/BREAKING-CHANGES.md#1320).

This is a bug fix release and it contains a breaking change.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.31.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.30.0...n8n@1.31.0) for this version.\
**Release date:** 2024-02-28

This release contains new features, new nodes, node enhancements and bug fixes.

#### New nodes: Microsoft Outlook trigger and Ollama embeddings

This release adds two new nodes.

- [Microsoft Outlook Trigger](../integrations/builtin/trigger-nodes/n8n-nodes-base.microsoftoutlooktrigger/)
- [Ollama Embeddings](../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.embeddingsollama/)

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.30.1

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.30.0...n8n@1.30.1) for this version.\
**Release date:** 2024-02-23

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.30.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.29.1...n8n@1.30.0) for this version.\
**Release date:** 2024-02-21

This release contains new features, node enhancements, and bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.29.1

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.29.0...n8n@1.29.1) for this version.\
**Release date:** 2024-02-16

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.29.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.28.0...n8n@1.29.0) for this version.\
**Release date:** 2024-02-15

This release contains new features, node enhancements, and bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

### New features

#### OpenAI node overhaul

This release includes a new version of the [OpenAI node](../integrations/builtin/app-nodes/n8n-nodes-langchain.openai/), adding more operations, including support for working with assistants.

Other highlights:

- Support for AI events in [log streaming](../log-streaming/).
- Added support for workflow tags in the [public API](../api/).

### Contributors

[Bruno Inec](https://github.com/sweenu)\
[Jesús Burgers](https://github.com/jburgers-chakray)

## n8n@1.27.3

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.27.2...n8n@1.27.3) for this version.\
**Release date:** 2024-02-15

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.28.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.27.2...n8n@1.28.0) for this version.\
**Release date:** 2024-02-07

This release contains new features, new nodes, node enhancements and bug fixes.

#### New nodes: Azure OpenAI chat model and embeddings

This release adds two new nodes to work with [Azure OpenAI](https://azure.microsoft.com/en-gb/products/ai-services/openai-service/) in your advanced AI workflows:

- [Embeddings Azure OpenAI](../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.embeddingsazureopenai/)
- [Azure OpenAI Chat Model](../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.lmchatazureopenai/)

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

### Contributors

[Andrea Ascari](https://github.com/ascariandrea)

## n8n@1.27.2

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.27.1...n8n@1.27.2) for this version.\
**Release date:** 2024-02-02

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.27.1

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.26.0...n8n@1.27.1) for this version.\
**Release date:** 2024-01-31

This release contains new features, node enhancements, and bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.27.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.26.0...n8n@1.27.0) for this version.\
**Release date:** 2024-01-31

Breaking change

This release removes `own` mode for self-hosted n8n. You must now use `EXECUTIONS_MODE` and set to either `regular` or `queue`. Refer to [Queue mode](../hosting/scaling/queue-mode/) for information on configuring queue mode.

Skip this release

Please upgrade directly to 1.27.1.

This release contains node enhancements and bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.26.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.25.1...n8n@1.26.0) for this version.\
**Release date:** 2024-01-24

This release contains new features, node enhancements, and bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

### Contributors

[Daniel Schröder](https://github.com/schroedan)\
[Nihaal Sangha](https://github.com/nihaals)

## n8n@1.25.1

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.25.0...n8n@1.25.1) for this version.\
**Release date:** 2024-01-22

This is a bug fix release.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

### Contributors

[Nihaal Sangha](https://github.com/nihaals)

## n8n@1.25.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.24.1...n8n@1.25.0) for this version.\
**Release date:** 2024-01-17

This release contains a new node, feature improvements, and bug fixes.

#### New node: Chat Memory Manager

The [Chat Memory Manager](../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.memorymanager/) node replaces the Chat Messages Retriever node. It manages chat message memories within your AI workflows.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.24.1

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.24.0...n8n@1.24.1) for this version.\
**Release date:** 2024-01-16

This is a bug fix release.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.22.6

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.22.5...n8n@1.22.6) for this version.\
**Release date:** 2024-01-10

This is a bug fix release. It includes important fixes for the HTTP Request and monday.com nodes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.24.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.23.0...n8n@1.24.0) for this version.\
**Release date:** 2024-01-10

This release contains new nodes for advanced AI, node enhancements, new features, performance enhancements, and bug fixes.

#### Chat trigger

n8n has created a new [Chat Trigger node](../integrations/builtin/core-nodes/n8n-nodes-langchain.chattrigger/). The new node provides a chat interface that you can make publicly available, with customization and authentication options.

#### Mistral Cloud Chat and Embeddings

This release introduces two new nodes to support [Mistral AI](https://mistral.ai/):

- [Mistral Cloud Chat Model](../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.lmchatmistralcloud/)
- [Embeddings Mistral Cloud](../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.embeddingsmistralcloud/)

### Contributors

[Anush](https://github.com/Anush008)\
[Eric Koleda](https://github.com/ekoleda-codaio)\
[Mason Geloso](https://github.com/MasonGeloso)\
[vacitbaydarman](https://github.com/vacitbaydarman)

## n8n@1.22.5

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.22.4...n8n@1.22.5) for this version.\
**Release date:** 2024-01-09

This is a bug fix release.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.23.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.22.4...n8n@1.23.0) for this version.\
**Release date:** 2024-01-03

This release contains new nodes, node enhancements, new features, and bug fixes.

#### New nodes and improved experience for working with files

This release includes a major overhaul of nodes relating to files (binary data).

There are now three key nodes dedicated to handling binary data files:

- [Read/Write Files from Disk](../integrations/builtin/core-nodes/n8n-nodes-base.readwritefile/) to read and write files from/to the machine where n8n is running.
- [Convert to File](../integrations/builtin/core-nodes/n8n-nodes-base.converttofile/) to take input data and output it as a file.
- [Extract From File](../integrations/builtin/core-nodes/n8n-nodes-base.extractfromfile/) to get data from a binary format and convert it to JSON.

n8n has moved support for iCalendar, PDF, and spreadsheet formats into these nodes, and removed the iCalendar, Read PDF, and Spreadsheet File nodes. There are still standalone nodes for [HTML](../integrations/builtin/core-nodes/n8n-nodes-base.html/) and [XML](../integrations/builtin/core-nodes/n8n-nodes-base.xml/).

#### New node: Qdrant vector store

This release adds support for [Qdrant](https://qdrant.tech/) with the Qdrant vector store node.

Read n8n's [Qdrant vector store node documentation](../integrations/builtin/cluster-nodes/root-nodes/n8n-nodes-langchain.vectorstoreqdrant/)

### Contributors

[Aaron Gutierrez](https://github.com/aarongut)\
[Advaith Gundu](https://github.com/geodic)\
[Anush](https://github.com/Anush008)\
[Bin](https://github.com/soulhat)\
[Nihaal Sangha](https://github.com/nihaals)

## n8n@1.22.4

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.22.3...n8n@1.22.4) for this version.\
**Release date:** 2024-01-03

This is a bug fix release.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.22.3

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.22.2...n8n@1.22.3) for this version.\
**Release date:** 2023-12-27

Upgrade directly to 1.22.4

Due to issues with this release, upgrade directly to 1.22.4.

This is a bug fix release.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.22.2

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.22.1...n8n@1.22.2) for this version.\
**Release date:** 2023-12-27

Upgrade directly to 1.22.4

Due to issues with this release, upgrade directly to 1.22.4.

This is a bug fix release.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.22.1

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.22.0...n8n@1.22.1) for this version.\
**Release date:** 2023-12-21

This is a bug fix release.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.22.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.21.1...n8n@1.22.0) for this version.\
**Release date:** 2023-12-21

This release contains node enhancements, new features, performance improvements, and bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.18.4

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.18.3...n8n@1.18.4) for this version.\
**Release date:** 2023-12-19

This is a bug fix release.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.21.1

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.20.0...n8n@1.21.1) for this version.\
**Release date:** 2023-12-15

This is a bug fix release.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.18.3

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.18.2...n8n@1.18.3) for this version.\
**Release date:** 2023-12-15

This is a bug fix release.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.21.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.20.0...n8n@1.21.0) for this version.\
**Release date:** 2023-12-13

This release contains new features and nodes, node enhancements, and bug fixes.

#### New user role: Admin

This release introduces a third account type: admin. This role is available on pro and enterprise plans. Admins have similar permissions to instance owners.

[Read more about user roles](../user-management/account-types/)

#### New data transformation nodes

This release replaces the Item Lists node with a collection of nodes for data transformation tasks:

- [Aggregate](../integrations/builtin/core-nodes/n8n-nodes-base.aggregate/): take separate items, or portions of them, and group them together into individual items.
- [Limit](../integrations/builtin/core-nodes/n8n-nodes-base.aggregate/): remove items beyond a defined maximum number.
- [Remove Duplicates](../integrations/builtin/core-nodes/n8n-nodes-base.removeduplicates/): identify and delete items that are identical across all fields or a subset of fields.
- [Sort](../integrations/builtin/core-nodes/n8n-nodes-base.sort/): organize lists of in a desired ordering, or generate a random selection.
- [Split Out](../integrations/builtin/core-nodes/n8n-nodes-base.splitout/): separate a single data item containing a list into multiple items.
- [Summarize](../integrations/builtin/core-nodes/n8n-nodes-base.summarize/): aggregate items together, in a manner similar to Excel pivot tables.

#### Increased sharing permissions for owners and admins

Instance owners and users with the admin role can now see and share all workflows and credentials. They can't view sensitive credential information.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.20.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.19.5...n8n@1.20.0) for this version.\
**Release date:** 2023-12-06

This release contains bug fixes, node enhancements, and ongoing new feature work.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

### Contributors

[Andrey Starostin](https://github.com/mayorandrew)

## n8n@1.19.5

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.19.4...n8n@1.19.5) for this version.\
**Release date:** 2023-12-05

This is a bug fix release.

Breaking change

This release removes the TensorFlow Embeddings node.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.18.2

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.18.1...n8n@1.18.2) for this version.\
**Release date:** 2023-12-05

This is a bug fix release.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.19.4

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.19.0...n8n@1.19.4) for this version.\
**Release date:** 2023-12-01

Missing ARM v7 support

This version doesn't support ARM v7. n8n is working on fixing this in future releases.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.19.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.18.0...n8n@1.19.0) for this version.\
**Release date:** 2023-11-29

Upgrade directly to 1.19.4

Due to issues with this release, upgrade directly to 1.19.4.

This release contains new features, node enhancements, and bug fixes.

#### LangChain general availability

This release adds LangChain support to the main n8n version. Refer to [LangChain](../advanced-ai/langchain/overview/) for more information on how to build AI tools in n8n, the new nodes n8n has introduced, and related learning resources.

#### Show avatars of users working on the same workflow

This release improves the experience of users collaborating on workflows. You can now see who else is editing at the same time as you.

## n8n@1.18.1

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.18.0...n8n@1.18.1) for this version.\
**Release date:** 2023-11-30

This is a bug fix release.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.18.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.17.1...n8n@1.18.0) for this version.\
**Release date:** 2023-11-22

This release contains new features and bug fixes.

#### Template creator hub

Built a template you want to share? This release introduces the n8n Creator hub. Refer to the [creator hub Notion doc](https://www.notion.so/n8n-Creator-hub-7bd2cbe0fce0449198ecb23ff4a2f76f) for more information on this project.

#### Node input and output search filter

Cloud Pro and Enterprise users can now search and filter the input and output data in nodes. Refer to [Data filtering](../data/data-filtering/) for more information.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.17.1

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.17.0...n8n@1.17.1) for this version.\
**Release date:** 2023-11-17

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.17.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.16.0...n8n@1.17.0) for this version.\
**Release date:** 2023-11-15

This release contains node enhancements and bug fixes.

#### Sticky Note Colors

You can now select background colors for sticky notes.

#### Discord Node Overhaul

An overhaul of the Discord node, improving the UI making it easier to configure, improving error handling, and fixing issues.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

### Contributors

[antondollmaier](https://github.com/antondollmaier)\
[teomane](https://github.com/teomane)

## n8n@1.16.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.15.2...n8n@1.16.0) for this version.\
**Release date:** 2023-11-08

This release contains node enhancements and bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.15.2

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.15.1...n8n@1.15.2) for this version.\
**Release date:** 2023-11-07

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.15.1

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.14.2...n8n@1.15.1) for this version.\
**Release date:** 2023-11-02

This release contains new features, node enhancements, and bug fixes.

#### Workflow history

This release introduces workflow history: view and load previous versions of your workflows.

Workflow history is available in Enterprise n8n, and with limited history for Cloud Pro.

Learn more in the [Workflow history](../workflows/history/) documentation.

#### Dark mode

*Almost* in time for Halloween: this release introduces dark mode.

To enable dark mode:

1. Select **Settings** > **Personal**.
1. Under **Personalisation**, change **Theme** to **Dark theme**.

#### Optional error output for nodes

All nodes apart from sub-nodes and trigger nodes have a new optional output: **Error**. Use this to add steps to handle node errors.

#### Pagination support added to HTTP Request node

The HTTP Request node now supports an pagination. Read the [node docs](../integrations/builtin/core-nodes/n8n-nodes-base.httprequest/) for information and examples.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

### Contributors

[Yoshino-s](https://github.com/Yoshino-s)

## n8n@1.14.2

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.14.1...n8n@1.14.2) for this version.\
**Release date:** 2023-10-26

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.14.1

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.14.0...n8n@1.14.1) for this version.\
**Release date:** 2023-10-26

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.14.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.13.0...n8n@1.14.0) for this version.\
**Release date:** 2023-10-25

This release contains node enhancements and bug fixes.

#### Switch node supports more outputs

The [Switch node](../integrations/builtin/core-nodes/n8n-nodes-base.switch/) now supports an unlimited number of outputs.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.13.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.12.2...n8n@1.13.0) for this version.\
**Release date:** 2023-10-25

This release contains new features, feature enhancements, and bug fixes.

Upgrade directly to 1.14.0

This release failed to publish to npm. Upgrade directly to 1.14.0.

#### RSS Feed Trigger node

This releases introduces a new node, the [RSS Feed Trigger](../integrations/builtin/core-nodes/n8n-nodes-base.rssfeedreadtrigger/). Use this node to start a workflow when a new RSS feed item is published.

#### Facebook Lead Ads Trigger node

This releases add another new node, the [Facebook Lead Ads Trigger](../integrations/builtin/trigger-nodes/n8n-nodes-base.facebookleadadstrigger/). Use this node to trigger a workflow when you get a new lead.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.12.2

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.12.1...n8n@1.12.2) for this version.\
**Release date:** 2023-10-24

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

### Contributors

[Burak Akgün](https://github.com/mbakgun)

## n8n@1.12.1

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.12.0...n8n@1.12.1) for this version.\
**Release date:** 2023-10-23

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

### Contributors

[Léo Martinez](https://github.com/martinezleoml)

## n8n@1.11.2

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.11.1...n8n@1.11.2) for this version.\
**Release date:** 2023-10-23

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

### Contributors

[Inga](https://github.com/inga-lovinde)\
[pemontto](https://github.com/pemontto)

## n8n@1.12.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.11.1...n8n@1.12.0) for this version.\
**Release date:** 2023-10-18

This release contains new features, node enhancements, and bug fixes.

#### Form Trigger node

This releases introduces a new node, the [n8n Form Trigger](../integrations/builtin/core-nodes/n8n-nodes-base.formtrigger/). Use this node to start a workflow based on a user submitting a form. It provides a configurable form interface.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

### Contributors

[Damian Karzon](https://github.com/dkarzon)\
[Inga](https://github.com/inga-lovinde)\
[pemontto](https://github.com/pemontto)

## n8n@1.11.1

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.11.0...n8n@1.11.1) for this version.\
**Release date:** 2023-10-13

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.11.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.10.1...n8n@1.11.0) for this version.\
**Release date:** 2023-10-11

This release contains new features and bug fixes.

#### External storage for binary files

Self-hosted users can now use an external service to store binary data. Learn more in [External storage](../hosting/scaling/external-storage/).

If you're using n8n Cloud and are interested in this feature, please [contact n8n](https://n8n-community.typeform.com/to/y9X2YuGa).

#### Item Lists node supports binary data

The Item Lists node now supports splitting and concatenating binary data inputs. This means you no longer need to use code to split a collection of files into multiple items.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.10.1

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.10.0...n8n@1.10.1) for this version.\
**Release date:** 2023-10-11

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.9.3

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.9.2...n8n@1.9.3) for this version.\
**Release date:** 2023-10-10

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.9.2

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.9.1...n8n@1.9.2) for this version.\
**Release date:** 2023-10-09

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.10.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.9.1...n8n@1.10.0) for this version.\
**Release date:** 2023-10-05

This release contains bug fixes and preparatory work for new features.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.9.1

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.9.0...n8n@1.9.1) for this version.\
**Release date:** 2023-10-04

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## LangChain in n8n (beta)

**Release date:** 2023-10-04

This release introduces support for building with LangChain in n8n.

With n8n's LangChain nodes you can build AI-powered functionality within your workflows. The LangChain nodes are configurable, meaning you can choose your preferred agent, LLM, memory, and other components. Alongside the LangChain nodes, you can connect any n8n node as normal: this means you can integrate your LangChain logic with other data sources and services.

Read more:

- This is a beta release, and not yet available in the main product. Follow the instructions in [Access LangChain in n8n](../advanced-ai/langchain/overview/) to try it out. Self-hosted and Cloud options are available.
- Learn how LangChain concepts map to n8n nodes in [LangChain concepts in n8n](../advanced-ai/langchain/langchain-n8n/).
- Browse n8n's new [Cluster nodes](../integrations/builtin/cluster-nodes/). This is a new set of node types that allows for multiple nodes to work together to configure each other.

## n8n@1.9.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.8.2...n8n@1.9.0) for this version.\
**Release date:** 2023-09-28

This release contains new features, performance improvements, and bug fixes.

#### Tournament

This releases replaces RiotTmpl, the templating language used in expressions, with n8n's own templating language, [Tournament](https://github.com/n8n-io/tournament). You can now use arrow functions in expressions.

#### `N8N_BINARY_DATA_TTL` and `EXECUTIONS_DATA_PRUNE_TIMEOUT` removed

The environment variables `N8N_BINARY_DATA_TTL` and `EXECUTIONS_DATA_PRUNE_TIMEOUT` no longer have any effect and can be removed. Instead of relying on a TTL system for binary data, n8n cleans up binary data together with executions during pruning.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.8.2

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.8.1...n8n@1.8.2) for this version.\
**Release date:** 2023-09-25

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.8.1

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.8.0...n8n@1.8.1) for this version.\
**Release date:** 2023-09-21

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.8.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.7.1...n8n@1.8.0) for this version.\
**Release date:** 2023-09-20

This release contains node enhancements and bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.7.1

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.7.0...n8n@1.7.1) for this version.\
**Release date:** 2023-09-14

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.7.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.6.1...n8n@1.7.0) for this version.\
**Release date:** 2023-09-13

This release contains node enhancements and bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

### Contributors

[Quang-Linh LE](https://github.com/linktohack)\
[MC Naveen](https://github.com/mcnaveen)

## n8n@1.6.1

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.6.0...n8n@1.6.1) for this version.\
**Release date:** 2023-09-06

This is a bug fix release.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.6.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.5.1...n8n@1.6.0) for this version.\
**Release date:** 2023-09-06

This release contains bug fixes, new features, and node enhancements.

Upgrade directly to 1.6.1

Skip this version and upgrade directly to 1.6.1, which contains essential bug fixes.

#### TheHive 5

This release introduces support for TheHive API version 5. This uses a new node and credentials:

- [TheHive 5 node](../integrations/builtin/app-nodes/n8n-nodes-base.thehive5/)
- [TheHive 5 Trigger node](../integrations/builtin/trigger-nodes/n8n-nodes-base.thehive5trigger/)
- [TheHive 5 credentials](../integrations/builtin/credentials/thehive5/)

#### `N8N_PERSISTED_BINARY_DATA_TTL` removed

The environment variables `N8N_PERSISTED_BINARY_DATA_TTL` no longer has any effect and can be removed. This legacy flag was originally introduced to support ephemeral executions (see [details](https://github.com/n8n-io/n8n/pull/7046)), which are no longer supported.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.5.1

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.5.0...n8n@1.5.1) for this version.\
**Release date:** 2023-08-31

This is a bug fix release.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.5.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.4.1...n8n@1.5.0) for this version.\
**Release date:** 2023-08-31

This release contains new features, node enhancements, and bug fixes.

Upgrade directly to 1.5.1

Skip this version and upgrade directly to 1.5.1, which contains essential bug fixes.

### Highlights

#### External secrets storage for credentials

Enterprise-tier accounts can now use external secrets vaults to manage credentials in n8n. This allows you to store credential information securely outside your n8n instance. n8n supports Infisical and HashiCorp Vault.

Refer to [External secrets](../external-secrets/) for guidance on enabling and using this feature.

#### Two-factor authentication

n8n now supports two-factor authentication (2FA) for self-hosted instances. n8n is working on bringing support to Cloud. Refer to [Two-factor authentication](../user-management/two-factor-auth/) for guidance on enabling and using it.

#### Debug executions

Users on a paid n8n plan can now load data from previous executions into their current workflow. This is useful when debugging a failed execution.

Refer to [Debug executions](../workflows/executions/debug/) for guidance on using this feature.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.4.1

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.4.0...n8n@1.4.1) for this version.\
**Release date:** 2023-08-29

This is a bug fix release.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.4.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.3.1...n8n@1.4.0) for this version.\
**Release date:** 2023-08-23

This release contains new features, node enhancements, and bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

### Contributors

[pemontto](https://github.com/pemontto)

## n8n@1.3.1

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.3.0...n8n@1.3.1) for this version.\
**Release date:** 2023-08-18

This is a bug fix release.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.3.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.2.2...n8n@1.3.0) for this version.\
**Release date:** 2023-08-16

This release contains new features and bug fixes.

### Highlights

#### Trial feature: AI support in the Code node

This release introduces limited support for using AI to generate code in the Code node. Initially this feature is only available on Cloud, and will gradually be rolled out, starting with about 20% of users.

Learn how to use the feature, including guidance on writing prompts, in [Generate code with ChatGPT](../code/ai-code/).

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

### Contributors

[Ian Gallagher](https://github.com/craSH)\
[Xavier Calland](https://github.com/xavier-calland)

## n8n@1.2.2

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.2.1...n8n@1.2.2) for this version.\
**Release date:** 2023-08-14

This is a bug fix release.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.2.1

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.2.0...n8n@1.2.1) for this version.\
**Release date:** 2023-08-09

This is a bug fix release.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.2.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.1.1...n8n@1.2.0) for this version.\
**Release date:** 2023-08-09

This release contains new features, node enhancements, bug fixes, and performance improvements.

Upgrade directly to 1.2.1

When upgrading, skip this release and go directly to 1.2.1.

### Highlights

#### Credential support for SecOps services

This release introduces support for setting up credentials in n8n for the following services:

- [AlienVault](../integrations/builtin/credentials/alienvault/)
- [Auth0 Management](../integrations/builtin/credentials/auth0management/)
- [Carbon Black API](../integrations/builtin/credentials/carbonblack/)
- [Cisco Meraki API](../integrations/builtin/credentials/ciscomeraki/)
- [Cisco Secure Endpoint](../integrations/builtin/credentials/ciscosecureendpoint/)
- [Cisco Umbrella API](../integrations/builtin/credentials/ciscoumbrella/)
- [CrowdStrike](../integrations/builtin/credentials/crowdstrike/)
- [F5 Big-IP](../integrations/builtin/credentials/f5bigip/)
- [Fortinet FortiGate](../integrations/builtin/credentials/fortigate/)
- [Hybrid Analysis](../integrations/builtin/credentials/hybridanalysis/)
- [Imperva WAF](../integrations/builtin/credentials/impervawaf/)
- [Kibana](../integrations/builtin/credentials/kibana/)
- [Microsoft Entra ID](../integrations/builtin/credentials/microsoftentra/)
- [Mist](../integrations/builtin/credentials/mist/)
- [Okta](../integrations/builtin/credentials/okta/)
- [OpenCTI](../integrations/builtin/credentials/opencti/)
- [QRadar](../integrations/builtin/credentials/qradar/)
- [Qualys](../integrations/builtin/credentials/qualys/)
- [Recorded Future](../integrations/builtin/credentials/recordedfuture/)
- [Sekoia](../integrations/builtin/credentials/sekoia/)
- [Shuffler](../integrations/builtin/credentials/shuffler/)
- [Trellix ePO](../integrations/builtin/credentials/trellixepo/)
- [VirusTotal](../integrations/builtin/credentials/virustotal/)
- [Zscaler ZIA](../integrations/builtin/credentials/zscalerzia/)

This makes it easier to do [Custom operations](../integrations/custom-operations/) with these services, using the [HTTP Request](../integrations/builtin/core-nodes/n8n-nodes-base.httprequest/) node.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.1.1

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.1.0...n8n@1.1.1) for this version.\
**Release date:** 2023-07-27

This is a bug fix release.

Breaking changes

Please note that this version contains breaking changes if upgrading from a `0.x.x` version. For full details, refer to the [n8n v1.0 migration guide](../1-0-migration-checklist/).

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.1.0

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.0.5...n8n@1.1.0) for this version.\
**Release date:** 2023-07-26

This release contains new features, bug fixes, and node enhancements.

Breaking changes

Please note that this version contains breaking changes if upgrading from a `0.x.x` version. For full details, refer to the [n8n v1.0 migration guide](../1-0-migration-checklist/).

### Highlights

#### Source control and environments

This release introduces source control and environments for enterprise users.

n8n uses Git-based source control to support environments. Linking your n8n instances to a Git repository lets you create multiple n8n environments, backed by Git branches.

Refer to [Source control and environments](../source-control-environments/) to learn more about the features and set up your environments.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

### Contributors

[Adrián Martínez](https://github.com/adrian-martinez-vdshop)\
[Alberto Pasqualetto](https://github.com/albertopasqualetto)\
[Marten Steketee](https://github.com/Marten-S)\
[perseus-algol](https://github.com/perseus-algol)\
[Sandra Ashipala](https://github.com/sandramsc)\
[ZergRael](https://github.com/ZergRael)

## n8n@1.0.5

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.0.4...n8n@1.0.5) for this version.\
**Release date:** 2023-07-24

This is a bug fix release.

Breaking changes

Please note that this version contains breaking changes if upgrading from a `0.x.x` version. For full details, refer to the [n8n v1.0 migration guide](../1-0-migration-checklist/).

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## n8n@1.0.4

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.0.3...n8n@1.0.4) for this version.\
**Release date:** 2023-07-19

This is a bug fix release.

Breaking changes

Please note that this version contains breaking changes if upgrading from a `0.x.x` version. For full details, refer to the [n8n v1.0 migration guide](../1-0-migration-checklist/).

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

### Contributors

[Romain Dunand](https://github.com/airmoi)\
[noctarius aka Christoph Engelbert](https://github.com/noctarius)

## n8n@1.0.3

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.0.2...n8n@1.0.3) for this version.\
**Release date:** 2023-07-13

This release contains API enhancements and adds support for sending messages to forum threads in the Telegram node.

Breaking changes

Please note that this version contains breaking changes if upgrading from a `0.x.x` version. For full details, refer to the [n8n v1.0 migration guide](../1-0-migration-checklist/).

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

### Contributors

[Kirill](https://github.com/chrtkv)

## n8n@1.0.2

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.0.1...n8n@1.0.2) for this version.\
**Release date:** 2023-07-05

This is a bug fix release.

Breaking changes

Please note that this version contains breaking changes if upgrading from a `0.x.x` version. For full details, refer to the [n8n v1.0 migration guide](../1-0-migration-checklist/).

### Contributors

[Romain Dunand](https://github.com/airmoi)

## n8n@1.0.1

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.0.0...n8n@1.0.1) for this version.\
**Release date:** 2023-07-05

Breaking changes

Please note that this version contains breaking changes. For full details, refer to the [n8n v1.0 migration guide](../1-0-migration-checklist/).

This is n8n's version one release.

For full details, refer to the [n8n v1.0 migration guide](../1-0-migration-checklist/).

### Highlights

#### Python support

Although JavaScript remains the default language, you can now also select Python as an option in the [Code node](../code/code-node/) and even make use of [many Python modules](https://pyodide.org/en/stable/usage/packages-in-pyodide.html#packages-in-pyodide). Note that Python is unavailable in Code nodes added to a workflow before v1.0.

### Contributors

[Marten Steketee](https://github.com/Marten-S)

# Sustainable Use License

Proprietary licenses for Enterprise

Proprietary licenses are available for enterprise customers. [Get in touch](mailto:license@n8n.io) for more information.

n8n's [Sustainable Use License](https://github.com/n8n-io/n8n/blob/master/LICENSE.md) and [n8n Enterprise License](https://github.com/n8n-io/n8n/blob/master/LICENSE_EE.md) are based on the [fair-code](https://faircode.io/) model.

## License FAQs

### What license do you use?

n8n uses the [Sustainable Use License](https://github.com/n8n-io/n8n/blob/master/LICENSE.md) and [n8n Enterprise License](https://github.com/n8n-io/n8n/blob/master/LICENSE_EE.md). These licenses are based on the [fair-code](https://faircode.io/) model.

### What source code is covered by the Sustainable Use License?

The [Sustainable Use License](https://github.com/n8n-io/n8n/blob/master/LICENSE.md) applies to all our source code hosted in our [main GitHub repository](https://github.com/n8n-io/n8n) except:

- Content of branches other than master.
- Source code files that contain `.ee.` in their file name. These are licensed under the [n8n Enterprise License](https://github.com/n8n-io/n8n/blob/master/LICENSE_EE.md).

### What is the Sustainable Use License?

The Sustainable Use License is a fair-code software license created by n8n in 2022. You can read more about why we did this [here](#why-did-you-create-a-license). The license allows you the free right to use, modify, create derivative works, and redistribute, with three limitations:

- You may use or modify the software only for your own internal business purposes or for non-commercial or personal use.
- You may distribute the software or provide it to others only if you do so free of charge for non-commercial purposes.
- You may not alter, remove, or obscure any licensing, copyright, or other notices of the licensor in the software. Any use of the licensor's trademarks is subject to applicable law.

We encourage anyone who wants to use the Sustainable Use License. If you are building something out in the open, it makes sense to think about licensing earlier in order to avoid problems later. Contact us at [license@n8n.io](mailto:license@n8n.io) if you would like to ask any questions about it.

### What is and isn't allowed under the license in the context of n8n's product?

Our license restricts use to "internal business purposes". In practice this means all use is allowed unless you are selling a product, service, or module in which the value derives entirely or substantially from n8n functionality. Here are some examples that wouldn't be allowed:

- White-labeling n8n and offering it to your customers for money.
- Hosting n8n and charging people money to access it.

All of the following examples are allowed under our license:

- Using n8n to sync the data you control as a company, for example from a CRM to an internal database.
- Creating an n8n node for your product or any other integration between your product and n8n.
- Providing consulting services related to n8n, for example building workflows, custom features closely connect to n8n, or code that gets executed by n8n.
- Supporting n8n, for example by setting it up or maintaining it on an internal company server.

#### Can I use n8n to act as the back-end to power a feature in my app?

Usually yes, as long as the back-end process doesn't use users' own credentials to access their data.

Here are two examples to clarify:

##### Example 1: Sync ACME app with HubSpot

Bob sets up n8n to collect a user's HubSpot credentials to sync data in the ACME app with data in HubSpot.

**NOT ALLOWED** under the Sustainable Use License. This use case collects the user's own HubSpot credentials to pull information to feed into the ACME app.

##### Example 2: Embed AI chatbot in ACME app

Bob sets up n8n to embed an AI chatbot within the ACME app. The AI chatbot's credentials in n8n use Bob's company credentials. ACME app end-users only enter their questions or queries to the chatbot.

**ALLOWED** under the Sustainable Use License. No user credentials are being collected.

### What if I want to use n8n for something that's not permitted by the license?

You must sign a separate commercial agreement with us. We actively encourage software creators to embed n8n within their products; we just ask them to sign an agreement laying out the terms of use, and the fees owed to n8n for using the product in this way. We call this mode of use n8n Embed. You can learn more, and contact us about it [here](https://n8n.io/embed).

If you are unsure whether the use case you have in mind constitutes an internal business purpose or not, take a look at [the examples](#what-is-and-isnt-allowed-under-the-license-in-the-context-of-n8ns-product), and if you're still unclear, email us at [license@n8n.io](mailto:license@n8n.io).

### Why don't you use an open source license?

n8n's mission is to give everyone who uses a computer technical superpowers. We've decided the best way for us to achieve this mission is to make n8n as widely and freely available as possible for users, while ensuring we can build a sustainable, viable business. By making our product free to use, easy to distribute, and source-available we help everyone access the product. By operating as a business, we can continue to release features, fix bugs, and provide reliable software at scale long-term.

### Why did you create a license?

Creating a license was our least favorite option. We only went down this path after reviewing the possible existing licenses and deciding nothing fit our specific needs. There are two ways in which we try to mitigate the pain and friction of using a proprietary license:

1. By using plain English, and keeping it as short as possible.
1. By promoting [fair-code](https://faircode.io/) with the goal of making it a well-known umbrella term to describe software models like ours.

Our goals when we created the Sustainable Use License were:

1. To be as permissive as possible.
1. Safeguarding our ability to build a business.
1. Being as clear as possible what use was permitted or not.

### My company has a policy against using code that restricts commercial use – can I still use n8n?

Provided you are using n8n for internal business purposes, and not making n8n available to your customers for them to connect their accounts and build workflows, you should be able to use n8n. If you are unsure whether the use case you have in mind constitutes an internal business purpose or not, take a look at [the examples](#what-is-and-isnt-allowed-under-the-license-in-the-context-of-n8ns-product), and if you're still unclear, email us at [license@n8n.io](mailto:license@n8n.io).

### What happens to the code I contribute to n8n in light of the Sustainable Use License?

Any code you contribute on GitHub is subject to GitHub's [terms of use](https://docs.github.com/en/site-policy/github-terms/github-terms-of-service#d-user-generated-content). In simple terms, this means you own, and are responsible for, anything you contribute, but that you grant other GitHub users certain rights to use this code. When you contribute code to a repository containing notice of a license, you license the code under the same terms.

n8n asks every contributor to sign our [Contributor License Agreement](https://github.com/n8n-io/n8n/blob/master/CONTRIBUTOR_LICENSE_AGREEMENT.md). In addition to the above, this gives n8n the ability to change its license without seeking additional permission. It also means you aren't liable for your contributions (e.g. in case they cause damage to someone else's business).

It's easy to get started contributing code to n8n [here](https://github.com/n8n-io), and we've listed broader ways of participating in our community [here](../help-community/contributing/).

### Why did you switch to the Sustainable Use License from your previous license arrangement (Apache 2.0 with Commons Clause)?

n8n was licensed under Apache 2.0 with Commons Clause until 17 March 2022. Commons Clause was initiated by various software companies wanting to protect their rights against cloud providers. The concept involved adding a commercial restriction on top of an existing open source license.

However, the use of the Commons Clause as an additional condition to an open source license, as well as the use of wording that's open to interpretation, created some confusion and uncertainty regarding the terms of use. The Commons Clause also restricted people's ability to offer consulting and support services: we realized these services are critical in enabling people to get value from n8n, so we wanted to remove this restriction.

We created the Sustainable Use License to be more permissive and more clear about what use is allowed, while continuing to ensure n8n gets the funding needed to build and improve our product.

### What are the main differences between the Sustainable Use License and your previous license arrangement (Apache 2.0 with Commons Clause)?

There are two main differences between the Sustainable Use License and our previous license arrangement. The first is that we have tightened the definition of how you can use the software. Previously the Commons Clause restricted users ability to "sell" the software; we have redefined this to restrict use to internal business purposes. The second difference is that our previous license restricted people's ability to charge fees for consulting or support services related to the software: we have lifted that restriction altogether.

That means you are now free to offer commercial consulting or support services (e.g. building n8n workflows) without the need for a separate license agreement with us. If you are interested in joining our community of n8n experts providing these services, you can learn more here.

### Is n8n open source?

Although n8n's source code is available under the Sustainable Use License, according to the [Open Source Initiative](https://opensource.org/) (OSI), open source licenses can't include limitations on use, so we do not call ourselves open source. In practice, n8n offers most users many of the same benefits as OSI-approved open source.

We coined the term ['fair-code'](https://faircode.io/) as a way of describing our licensing model, and the model of other companies who are source-available, but restrict commercial use of their source code.

### What is fair-code, and how does the Sustainable Use License relate to it?

Fair-code isn't a software license. It describes a software model where software:

- Is generally free to use and can be distributed by anybody.
- Has its source code openly available.
- Can be extended by anybody in public and private communities.
- Is commercially restricted by its authors.

The Sustainable Use License is a fair-code license. You can read more about it and see other examples of fair-code licenses [here](https://faircode.io/).

We're always excited to talk about software licenses, fair-code, and other principles around sharing code with interested parties. To get in touch to chat, email [license@n8n.io](mailto:license@n8n.io).

### Can I use n8n's Sustainable Use License for my own project?

Yes! We're excited to see more software use the Sustainable Use License. We'd love to hear about your project if you're using our license: [license@n8n.io](mailto:license@n8n.io).

# Video courses

n8n provides two video courses on YouTube.

For support, join the [Forum](https://community.n8n.io/).

## Beginner

The [Beginner](https://www.youtube.com/playlist?list=PLlET0GsrLUL59YbxstZE71WszP3pVnZfI) course covers the basics of n8n:

- [Introduction and workflows](https://youtu.be/4BVTkqbn_tY?si=g2A5eD8kAoia5k6y)
- [APIs and Webhooks](https://youtu.be/y_cpFMF1pzk?si=zi3wM4W7nx8Jkcw3)
- [Nodes](https://youtu.be/rCPXBkeBWCQ?si=-T2iUsydwS5ym6yI)
- [Data in n8n](https://youtu.be/2YfWuNziPE4?si=4jB-fubG1_T0HXYx)
- [Core workflow concepts](https://youtu.be/kkrA7tGHYNo?si=mLVbuV98ohL5YVnm)
- [Useful nodes](https://youtu.be/Rmi-ckbMOQE?si=H_dF77uf5KJU7RtH)
- [Error handling](https://youtu.be/XEUVl3bbMhI?si=nUyaME5kyxe6daGO)
- [Debugging](https://youtu.be/Gxe_RfCRH-o?si=F-pAviLTIeL3-X13)
- [Collaboration](https://youtu.be/pI0W-0Qcwmo?si=X7sALFXo2e-cY9FQ)

## Advanced

The [Advanced](https://www.youtube.com/playlist?list=PLlET0GsrLUL5bxmx5c1H1Ms_OtOPYZIEG) course covers more complex workflows, more technical nodes, and enterprise features:

- [Introduction and complex data flows](https://youtu.be/TFTLMQLozCI?si=vX0ooIH1RmbsgAkC)
- [Advanced technical nodes](https://youtu.be/JM4jqYs4Fxo?si=YSNMeSay3C29C8HS)
- [Pinning and editing output data](https://youtu.be/zcNB8L4_9mA?si=LZJ9DlYDQQxL7eeP)
- [Sub-workflows](https://youtu.be/xr05Ie_Hkyg?si=rqqP8llttZPBjBeD)
- [Error workflows](https://youtu.be/77Ewdaby47M?si=6YRlC4nMgG4hVQPV)
- [Building a full example](https://youtu.be/wOKLEfeJLVE?si=YMW5t-PzPq7QKbPY)
- [Handling files](https://youtu.be/2RAZYNigqOY?si=9x4vLX2Qo08xx8vC)
- [Enterprise features](https://youtu.be/fXEubzmVJ_E?si=aK9_fI9tkF6F5CtB)

# Advanced AI

Build AI functionality using n8n: from creating your own chat bot, to using AI to process documents and data from other sources.

Feature availability

This feature is available on Cloud and self-hosted n8n, in version 1.19.4 and above.

- **Get started**

  Work through the short tutorial to learn the basics of building AI workflows in n8n.

  [Tutorial](intro-tutorial/)

- **Use a Starter Kit**

  Try n8n's Self-hosted AI Starter Kit to quickly start building AI workflows.

  [Self-hosted AI Starter Kit](../hosting/starter-kits/ai-starter-kit/)

- **Explore examples and concepts**

  Browse examples and workflow templates to help you build. Includes explanations of important AI concepts.

  [Examples](examples/introduction/)

- **How n8n uses LangChain**

  Learn more about how n8n builds on LangChain.

  [LangChain in n8n](langchain/overview/)

- **Browse AI templates**

  Explore a wide range of AI workflow templates on the n8n website.

  [AI workflows on n8n.io](https://n8n.io/workflows/?categories=25)

## Related resources

Related documentation and tools.

### Node types

This feature uses [Cluster nodes](../integrations/builtin/cluster-nodes/): groups of [root](../integrations/builtin/cluster-nodes/root-nodes/) and [sub](../integrations/builtin/cluster-nodes/sub-nodes/) nodes that work together.

[Cluster nodes](../glossary/#cluster-node-n8n) are node groups that work together to provide functionality in an n8n workflow. Instead of using a single node, you use a [root node](../glossary/#root-node-n8n) and one or more [sub-nodes](../glossary/#sub-node-n8n) that extend the functionality of the node.

### Workflow templates

You can browse [workflow templates](../glossary/#template-n8n) in-app or on the n8n website [Workflows](https://n8n.io/workflows/?categories=25,26) page.

Refer to [Templates](../workflows/templates/) for information on accessing templates in-app.

### Chat trigger

Use the [n8n Chat Trigger](../integrations/builtin/core-nodes/n8n-nodes-langchain.chattrigger/) to trigger a workflow based on chat interactions.

### Chatbot widget

n8n provides a chatbot widget that you can use as a frontend for AI-powered chat workflows. Refer to the [@n8n/chat npm page](https://www.npmjs.com/package/@n8n/chat) for usage information.

# AI Workflow Builder

AI Workflow Builder enables you to create, refine, and debug workflows using natural language descriptions of your goals.

It handles the entire workflow construction process, including node selection, placement, and configuration, thereby reducing the time required to build functional workflows.

For details of pricing and availability of AI Workflow Builder, see [n8n Plans and Pricing](https://n8n.io/pricing/).

## Working with the builder

1. **Describe your workflow:** Either select an example prompt or describe your requirements in natural language.
1. **Monitor the build:** The builder provides real-time feedback through several phases.
1. **Review and refine the generated workflow:** Review required credentials and other parameters. Refine the workflow using prompts.

### Commands you can run in the builder

- `/clear`: Clears the context for the LLM and lets you start from scratch

## Understanding credits

### How credits work

Each time you send a message to the builder asking it to create or modify a workflow, that counts as one **interaction**, which is worth one **credit**.

✅ **Counts as an interaction**

- Sending a message to create a new workflow
- Asking the builder to modify an existing workflow
- Clicking the **Execute and refine** button in the builder window after a workflow is built

❌ **Does NOT count as an interaction**

- Messages that fail or produce generation errors
- Requests you manually stop by clicking the stop button

### Getting more credits

If you've used your monthly limit, you can upgrade to a higher plan.

For details on plans and pricing, see [n8n Plans and Pricing](https://n8n.io/pricing/).

## AI model and data handling

The following data are sent to the LLM:

- Text prompts that you provide to create, refine, or debug the workflow
- Node definitions, parameters, and connections and the current workflow definition.
- Any mock execution data that is loaded when using the builder

The following data are not sent:

- Details of any credentials you use
- Past executions of the workflow

# Build an AI chat agent with n8n

Welcome to the introductory tutorial for building AI workflows with n8n. Whether you have used n8n before, or this is your first time, we will show you how the building blocks of AI workflows fit together and construct a working AI-powered chat agent which you can easily customize for your own purposes.

Many people find it easier to take in new information in video format. This tutorial is based on one of n8n's popular videos, linked below. Watch the video or read the steps here, or both!

### What you will need

- **n8n**: For this tutorial we recommend using the [n8n cloud](../../manage-cloud/overview/) service - there is a free trial for new users! For a self hosted service, refer to the [installation pages](../../hosting/installation/docker/).
- **Credentials for a chat model**: This tutorial uses OpenAI, but you can easily use DeepSeek, Google Gemini, Groq, Azure, and others (see the [sub-nodes documentation](../../integrations/builtin/cluster-nodes/sub-nodes/) for more).

### What you will learn

- AI concepts in n8n
- How to use the AI Agent node
- Working with Chat input
- Connecting with AI models
- Customising input
- Observing the conversation
- Adding persistence

## AI concepts in n8n

If you're already familiar with AI, feel free to skip this section. This is a basic introduction to AI concepts and how they can be used in n8n workflows.

An [AI agent](../../glossary/#ai-agent) builds on [Large Language Models (LLMs)](../../glossary/#large-language-model-llm), which generate text based on input by predicting the next word. While LLMs only process input to produce output, AI agents add goal-oriented functionality. They can use [tools](../../glossary/#ai-tool), process their outputs, and make decisions to complete tasks and solve problems.

In n8n, the AI agent is represented as a node with some extra connections.

| Feature             | LLM                        | AI Agent                           |
| ------------------- | -------------------------- | ---------------------------------- |
| Core Capability     | Text generation            | Goal-oriented task completion      |
| Decision-Making     | None                       | Yes                                |
| Uses Tools/APIs     | No                         | Yes                                |
| Workflow Complexity | Single-step                | Multi-step                         |
| Scope               | Generates language         | Performs complex, real-world tasks |
| Example             | LLM generating a paragraph | An agent scheduling an appointment |

By incorporating the AI agent as a node, n8n can combine AI-driven steps with traditional programming for efficient, real-world workflows. For instance, simpler tasks, like validating an email address, do not require AI, whereas a complex tasks, like processing the *content* of an email or dealing with multimodal inputs (e.g., images, audio), are excellent uses of an AI agent.

## 1. Create a new workflow

When you open n8n, you'll see either:

- An empty workflow: if you have no workflows and you're logging in for the first time. Use this workflow.
- The **Workflows** list on the **Overview** page. Select the **button** to create a new workflow.

## 2. Add a trigger node

Every workflow needs somewhere to start. In n8n these are called ['trigger nodes'](../../glossary/#trigger-node-n8n). For this workflow, we want to start with a chat node.

1. Select **Add first step** or press `Tab` to open the node menu.
1. Search for **Chat Trigger**. n8n shows a list of nodes that match the search.
1. Select **Chat Trigger** to add the node to the canvas. n8n opens the node.
1. Close the node details view (Select **Back to canvas**) to return to the canvas.

More about the Chat Trigger node...

The trigger node generates output when there is an event causing it to trigger. In this case we want to be able to type in text to cause the workflow to run. In production, this trigger can be hooked up to a public chat interface as provided by n8n or embedded into another website. To start this simple workflow we will just use the built-in local chat interface to communicate, so no further setup is required.

[View workflow file](/_workflows//advanced-ai/tutorials/chat_01.json)

## 3. Add an AI Agent Node

The AI Agent node is the core of adding AI to your workflows.

1. Select the **Add node** connector on the trigger node to bring up the node search.
1. Start typing "AI" and choose the **AI agent** node to add it.
1. The editing view of the **AI agent** will now be displayed.
1. There are some fields which can be changed. As we're using the **Chat Trigger** node, the default setting for the source and specification of the prompt don't need to be changed.

[View workflow file](/_workflows//advanced-ai/tutorials/chat_02.json)

## 4. Configure the node

AI agents require a chat model to be attached to process the incoming prompts.

1. Add a chat model by clicking the plus button underneath the **Chat Model** connection on the **AI Agent** node (it's the first connection along the bottom of the node).
1. The search dialog will appear, filtered on 'Language Models'. These are the models with built-in support in n8n. For this tutorial we will use **OpenAI Chat Model**.
1. Selecting the **OpenAI Chat model** from the list will attach it to the **AI Agent** node and open the node editor. One of the parameters which can be changed is the 'Model'. Note that for the basic OpenAI accounts, only the 'gpt-4o-mini' model is allowed.

Which chat model?

As mentioned earlier, the LLM is the component which generates the text according to a prompt it is given. LLMs have to be created and trained, usually an intensive process. Different LLMS may have different capabilities or specialties, depending on the data they were trained with.

## 5. Add credentials (if needed)

In order for n8n to communicate with the chat model, it will need some [credentials](../../credentials/) (login data giving it access to an account on a different online service). If you already have credentials set up for OpenAI, these should appear by default in the credentials selector. Otherwise you can use the Credentials selector to help you add a new credential.

1. To add a new credential, click on the text which says 'Select credential'. An option to add a new credential will appear
1. This credential just needs an API key. When adding credentials of any type, check the text to the right-hand side. In this case it has a handy link to take you straight to your OpenAI account to retrieve the API key.
1. The API key is just one long string. That's all you need for this particular credential. Copy it from the OpenAI website and paste it into the **API key** section.

Keeping your credentials safe

Credentials are private pieces of information issued by apps and services to authenticate you as a user and allow you to connect and share information between the app or service and the n8n node. The type of information required varies depending on the app/service concerned. You should be careful about sharing or revealing the credentials outside of n8n.

## 6. Test the node

Now that the node is connected to the **Chat Trigger** and a chat model, we can test this part of the workflow.

1. Click on the 'Chat' button near the bottom of the canvas. This opens up a local chat window on the left and the AI agent logs on the right.
1. Type in a message and press `Enter`. You will now see the response from the chat model appear below your message.
1. The log window displays the inputs to and outputs from the AI Agent.

Accessing the logs...

You can access the logs for the AI node even when you aren't using the chat interface. Open up the **AI Agent** node and click on the **Logs** tab in the right hand panel.

## 7. Changing the prompt

The logs in the previous step reveal some extra data - the system prompt. This is the default message that the **AI Agent** primes the chat model with. From the log you can see this is set to "You are a helpful assistant". We can however change this prompt to alter the behavior of the chat model.

1. Open the **AI Agent** node. In the bottom of the panel is a section labeled 'Options' and a selector labeled 'Add Option'. Use this to select 'System message'
1. The system message is now displayed. This is the same priming prompt we noticed before in the logs. Change the prompt to something else to prime the chat model in a different way. You could try something like "You are a brilliant poet who always replies in rhyming couplets" for example.
1. Close the node and return to the chat window. Repeat your message and notice how the output has changed.

## 8. Adding persistence

The chat model is now giving us useful output, but there is something wrong with it which will become apparent when you try to have a conversation.

1. Use the chat and tell the chat model your name, for example "Hi there, my name is Nick".
1. Wait for the response, then type the message "What's my name?". The AI will not be able to tell you, however apologetic it may seem. The reason for this is we are not saving the context. The AI Agent has no [memory](../../glossary/#ai-memory).
1. In order to remember what has happened in the conversation, the AI Agent needs to preserve context. We can do this by adding memory to the **AI Agent** node. On the canvas click on the on the bottom of the **AI Agent** node labeled "Memory".
1. From the panel which appears, select "Simple Memory". This will use the memory from the instance running n8n, and is usually sufficient for simple usage. The default value of 5 interactions should be sufficient here, but remember where this option is if you may want to change it later.
1. Repeat the exercise of having a conversation above, and see that the AI Agent now remembers your name.

## 9. Saving the workflow

Before we leave the workflow editor, remember to save the workflow or all your changes will be lost.

1. Click on the "Save" button in the top right of the editor window. Your workflow will now be saved and you can return to it later to chat again or add new features.

## Congratulations!

You have taken your first steps in building useful and effective workflows with AI. In this tutorial we have investigated the basic building blocks of an AI workflow, added an **AI Agent** and a chat model, and adjusted the prompt to get the kind of output we wanted. We also added memory so the chat could retain context between messages.

[View workflow file](/_workflows//advanced-ai/tutorials/chat_complete.json)

## Next steps

Now you have seen how to create a basic AI workflow, there are plenty of resources to build on that knowledge and plenty of examples to give you ideas of where to go next:

- Learn more about AI concepts and view examples in [Examples and concepts](../examples/introduction/).
- Browse AI [Workflow templates](https://n8n.io/workflows/?categories=25).
- Find out how to [enhance the AI agent with tools](../examples/understand-tools/).

# RAG in n8n

## What is RAG

[Retrieval-Augmented Generation (RAG)](../../glossary/#ai-retrieval-augmented-generation-rag) is a technique that improves AI responses by combining language models with external data sources. Instead of relying solely on the model's internal training data, RAG systems retrieve relevant documents to [ground](../../glossary/#ai-groundedness) responses in up-to-date, domain-specific, or proprietary knowledge. RAG workflows typically rely on vector stores to manage and search this external data efficiently.

## What is a vector store?

A [vector store](../../glossary/#ai-vector-store) is a special database designed to store and search high-dimensional vectors: numerical representations of text, images, or other data. When you upload a document, the vector store splits it into chunks and converts each chunk into a vector using an [embedding model](../../glossary/#ai-embedding).

You can query these vectors using similarity searches, which construct results based on *semantic meaning*, rather than keyword matches. This makes vector stores a powerful foundation for RAG and other AI systems that need to retrieve and reason over large sets of knowledge.

## How to use RAG in n8n

Start with a RAG template

👉 Try out RAG in n8n with the [RAG Starter Template](https://n8n.io/workflows/5010-rag-starter-template-using-simple-vector-stores-form-trigger-and-openai). The template includes two ready-made workflows: one for uploading files and one for querying them.

### Inserting data into your vector store

Before your agent can access custom knowledge, you need to upload that data to a vector store:

1. Add the nodes needed to fetch your source data.
1. Insert a **Vector Store** node (e.g. the [Simple Vector Store](../../integrations/builtin/cluster-nodes/root-nodes/n8n-nodes-langchain.vectorstoreinmemory/)) and choose the **Insert Documents** operation.
1. Select an **embedding model**, which converts your text into vector embeddings. Consult the FAQ for more information on [choosing the right embedding model](#how-do-i-choose-the-right-embedding-model).
1. Add a [Default Data Loader](../../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.documentdefaultdataloader/) node, which splits your content into chunks. You can use the default settings or define your own chunking strategy:
   - **Character Text Splitter:** splits by character length.
   - **Recursive Character Text Splitter:** recursively splits by Markdown, HTML, code blocks or simple characters (recommended for most use cases).
   - **Token Text Splitter:** splits by token count.
1. (Optional) Add **metadata** to each chunk to enrich the context and allow better filtering later.

### Querying your data

You can query the data in two main ways: using an agent or directly through a node.

### Using agents

1. Add an [agent](../../integrations/builtin/cluster-nodes/root-nodes/n8n-nodes-langchain.agent/) to your workflow.
1. Add the vector store as a **tool** and give it a **description** to help the agent understand when to use it:
   - Set the **limit** to define how many chunks to return.
   - Enable **Include Metadata** to provide extra context for each chunk.
1. Add the same **embedding model** you used when inserting the data.

Pro tip

To save tokens on an expensive model, you can first use the [Vector Store Question Answer tool](../../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.toolvectorstore/) to retrieve relevant data, and only then pass the result to the Agent. To see this in action, check out [this template](https://n8n.io/workflows/5011-save-costs-in-rag-workflows-using-the-qanda-tool-with-multiple-models).

### Using the node directly

1. Add your vector store node to the canvas and choose the **Get Many** operation.
1. Enter a query or prompt:
   - Set a **limit** for how many chunks to return.
   - Enable **Include Metadata** if needed.

## FAQs

### How do I choose the right embedding model?

The right embedding model differs from case to case.

In general, smaller models (for example, `text-embedding-ada-002`) are faster and cheaper and thus ideal for short, general-purpose documents or lightweight RAG workflows. Larger models (for example, `text-embedding-3-large`) offer better semantic understanding. These are best for long documents, complex topics, or when accuracy is critical.

### What is the best text splitting for my use case?

This again depends a lot on your data:

- Small chunks (for example, 200 to 500 tokens) are good for fine-grained retrieval.
- Large chunks may carry more context but can become diluted or noisy.

Using the right overlap size is important for the AI to understand the context of the chunk. That's also why using the Markdown or Code Block splitting can often help to make chunks better.

Another good approach is to add more context to it (for example, about the document where the chunk came from). If you want you can read more about this, you can check out [this great article from Anthropic](https://www.anthropic.com/news/contextual-retrieval).

# Light evaluations

Available on registered community and paid plans

Light evaluations are available to registered community users and on all paid plans.

## What are light evaluations?

When building your workflow, you often want to test it with a handful of examples to get a sense of how it performs and make improvements. At this stage of workflow development, looking over workflow outputs for each example is often enough. The benefits of setting up more [formal scoring or metrics](../metric-based-evaluations/) don't yet justify the effort.

Light evaluation allows you to run the examples in a test dataset through your workflow one-by-one, writing the outputs back to your dataset. You can then examine those outputs next to each other, and visually compare them to the expected outputs (if you have them).

## How it works

Credentials for Google Sheets

Evaluations use data tables or Google Sheets to store the test dataset. To use Google Sheets as a dataset source, configure a [Google Sheets credential](../../../integrations/builtin/credentials/google/).

Light evaluations take place in the 'Editor' tab of your workflow, although you’ll find instructions on how to set it up in the 'Evaluations' tab.

Steps:

1. Create a dataset
1. Wire the dataset up to the workflow
1. Write workflow outputs back to dataset
1. Run evaluation

The following explanation will use a sample workflow that assigns a category and priority to incoming support tickets.

### 1. Create a dataset

Create a data table or Google Sheet with a handful of examples for your workflow. Your dataset should contain columns for:

- The workflow input
- (Optional) The expected or correct workflow output
- The actual output

Leave the actual output column or columns blank, since you'll be filling them during the evaluation.

A [sample dataset](https://docs.google.com/spreadsheets/d/1uuPS5cHtSNZ6HNLOi75A2m8nVWZrdBZ_Ivf58osDAS8/edit?gid=294497137#gid=294497137) for the support ticket classification workflow.

### 2. Wire the dataset up to your workflow

#### Insert an evaluation trigger to pull in your dataset

Each time the [evaluation trigger](../../../integrations/builtin/core-nodes/n8n-nodes-base.evaluationtrigger/) runs, it will output a single item representing one row of your dataset.

Clicking the 'Evaluate all' button to the left of the evaluation trigger will run your workflow multiple times in sequence, once for each row in your dataset. This is a special behavior of the evaluation trigger.

While wiring the trigger up, you often only want to run it once. You can do this by either:

- Setting the trigger's 'Max rows to process' to 1
- Clicking on the 'Execute node' button on the trigger (rather than the 'Evaluate all' button)

#### Wire the trigger up to your workflow

You can now connect the evaluation trigger to the rest of your workflow and reference the data that it outputs. At a minimum, you need to use the dataset’s input column(s) later in the workflow.

If you have multiple triggers in your workflow you will need to [merge their branches together](../tips-and-common-issues/#combining-multiple-triggers).

The support ticket classification workflow with the evaluation trigger added in and wired up.

### 3. Write workflow outputs back to dataset

To populate the output column(s) of your dataset when the evaluation runs:

- Insert the 'Set outputs' action of the [evaluation node](../../../integrations/builtin/core-nodes/n8n-nodes-base.evaluation/)
- Wire it up to your workflow at a point after it has produced the outputs you're evaluating
- In the node's parameters, map the workflow outputs into the correct dataset column

The support ticket classification workflow with the 'set outputs' node added in and wired up.

### 4. Run evaluation

Click on the **Execute workflow** button to the left of the evaluation trigger. The workflow will execute multiple times, once for each row of the dataset:

Review the outputs of each execution in the data table or Google Sheet, and examine the execution details using the workflow's 'executions' tab if you need to.

Once your dataset grows past a handful of examples, consider [metric-based evaluation](../metric-based-evaluations/) to get a numerical view of performance. See also [tips and common issues](../tips-and-common-issues/).

# Metric-based evaluations

Available on Pro and Enterprise plans

Metric-based evaluation is available on Pro and Enterprise plans. Registered community and Starter plan users can also use it for a single workflow.

### What are metric-based evaluations?

Once your workflow is ready for deployment, you often want to test it on more examples than [when you were building it](../light-evaluations/).

For example, when production executions start to turn up edge cases, you want to add them to your test dataset so that you can make sure they're covered.

For large datasets like the ones built from production data, it can be hard to get a sense of performance just by eyeballing the results. Instead, you must measure performance. Metric-based evaluations can assign one or more scores to each test run, which you can compare to previous runs. Individual scores get rolled up to measure performance on the whole dataset.

This feature allows you to run evaluations that calculate metrics, track how those metrics change between runs and drill down into the reasons for those changes.

Metrics can be deterministic functions (such as the distance between two strings) or you can calculate them using AI. Metrics often involve checking how far away the output is from a *reference output* (also called ground truth). To do so, the dataset must contain that reference output. Some evaluations don't need this reference output though (for example, checking text for sentiment or toxicity).

## How it works

Credentials for Google Sheets

Evaluations use data tables or Google Sheets to store the test dataset. To use Google Sheets as a dataset source, configure a [Google Sheets credential](../../../integrations/builtin/credentials/google/).

1. Set up [light evaluation](../light-evaluations/)
1. Add metrics to workflow
1. Run evaluation and view results

### 1. Set up light evaluation

Follow the [setup instructions](../light-evaluations/) to create a dataset and wire it up to your workflow, writing outputs back to the dataset.

The following steps use the same support ticket classification workflow from the light evaluation docs:

### 2. Add metrics to workflow

Metrics are dimensions used to score the output of your workflow. They often compare the actual workflow output with a reference output. It's common to use AI to calculate metrics, although it's sometimes possible to just use code. In n8n, metrics are always numbers.

You need to add the logic to calculate the metrics for your workflow, at a point after it has produced the outputs. You can add any reference outputs your metric uses as a column in your dataset. This makes sure they it will be available in the workflow, since they will be output by the evaluation trigger.

Use the **Set Metrics** operation to calculate:

- **Correctness (AI-based)**: Whether the answer's meaning is consistent with a supplied reference answer. Uses a scale of 1 to 5, with 5 being the best.
- **Helpfulness (AI-based)**: Whether the response answers the given query. Uses a scale of 1 to 5, with 5 being the best.
- **String Similarity**: How close the answer is to the reference answer, measured character-by-character (edit distance). Returns a score between 0 and 1.
- **Categorization**: Whether the answer is an exact match with the reference answer. Returns 1 when matching and 0 otherwise.
- **Tools Used**: Whether the execution used tools or not. Returns a score between 0 and 1.

You can also add custom metrics. Just calculate the metrics within the workflow and then map them into an Evaluation node. Use the **Set Metrics** operation and choose **Custom Metrics** as the Metric. You can then set the names and values for the metrics you want to return.

For example:

- [RAG document relevance](https://n8n.io/workflows/4273): when working with a vector database, whether the documents retrieved are relevant to the question.

Calculating metrics can add latency and cost, so you may only want to do it when running an evaluation and avoid it when making a production execution. You can do this by putting the metric logic after a ['check if evaluating' operation](../../../integrations/builtin/core-nodes/n8n-nodes-base.evaluation/#check-if-evaluating).

### 3. Run evaluation and view results

Switch to the **Evaluations** tab on your workflow and click the **Run evaluation** button. An evaluation will start. Once the evaluation has finished, it will display a summary score for each metric.

You can see the results for each test case by clicking on the test run row. Clicking on an individual test case will open the execution that produced it (in a new tab).

# Overview

## What are evaluations?

Evaluation is a crucial technique for checking that your AI workflow is reliable. It can be the difference between a flaky proof of concept and a solid production workflow. It's important both in the building phase and after deploying to production.

The foundation of evaluation is running a test dataset through your workflow. This dataset contains multiple test cases. Each test case contains a sample input for your workflow, and often includes the expected output(s) too.

Evaluation allows you to:

- **Test your workflow over a range of inputs** so you know how it performs on edge cases
- **Make changes with confidence** without inadvertently making things worse elsewhere
- **Compare performance** across different models or prompts

The following video explains what evaluations are, why they're useful, and how they work:

## Why is evaluation needed?

AI models are fundamentally different than code. Code is deterministic and you can reason about it. This is difficult to do with LLMs, since they're black boxes. Instead, you must *measure* LLM output by running data through them and observing the output.

You can only build confidence that your model performs reliably after you have run it over multiple inputs that accurately reflect all the edge cases that it will have to deal with in production.

## Two types of evaluation

### Light evaluation (pre-deployment)

Building a clean, comprehensive dataset is hard. In the initial building phase, it often makes sense to generate just a handful of examples. These can be enough to iterate the workflow to a releasable state (or a proof of concept). You can visually compare the results to get a sense of the workflow's quality, without setting up formal metrics.

### Metric-based evaluation (post-deployment)

Once you deploy your workflow, it's easier to build a bigger, more representative dataset from production executions. When you discover a bug, you can add the input that caused it to the dataset. When fixing the bug, it's important to run the whole dataset over the workflow again as a [regression test](https://en.wikipedia.org/wiki/Regression_testing) to check that the fix hasn't inadvertently made something else worse.

Since there are too many test cases to check individually, evaluations measure the quality of the outputs using a metric, a numeric value representing a particular characteristic. This also allows you to track quality changes between runs.

### Comparison of evaluation types

|                                                  | Light evaluation (pre-deployment) | Metric-based evaluation (post-deployment) |
| ------------------------------------------------ | --------------------------------- | ----------------------------------------- |
| **Performance improvements with each iteration** | Large                             | Small                                     |
| **Dataset size**                                 | Small                             | Large                                     |
| **Dataset sources**                              | Hand-generated AI-generated Other | Production executions AI-generated Other  |
| **Actual outputs**                               | Required                          | Required                                  |
| **Expected outputs**                             | Optional                          | Required (usually)                        |
| **Evaluation** **metric**                        | Optional                          | Required                                  |

## Learn more

- [Light evaluations](../light-evaluations/): Perfect for evaluating your AI workflows against hand-selected test cases during development.
- [Metric-based evaluations](../metric-based-evaluations/): Advanced evaluations to maintain performance and correctness in production by using scoring and metrics with large datasets.
- [Tips and common issues](../tips-and-common-issues/): Learn how to set up specific evaluation use cases and work around common issues.

# Tips and common issues

## Combining multiple triggers

If you have another trigger in the workflow already, you have two potential starting points: that trigger and the [evaluation trigger](../../../integrations/builtin/core-nodes/n8n-nodes-base.evaluationtrigger/). To make sure your workflow works as expected no matter which trigger executes, you will need to merge these branches together.

Logic to merge two trigger branches together so that they have the same data format and can be referenced from a single node.

To do so:

1. **Get the data format of the other trigger**:
   - Execute the other trigger.
   - Open it and navigate to the JSON view of its output pane.
   - Click the **copy** button on the right.
1. **Re-shape the evaluation trigger data to match**:
   - Insert an [Edit Fields (Set) node](../../../integrations/builtin/core-nodes/n8n-nodes-base.set/) after the evaluation trigger and connect them together.
   - Change its mode to **JSON**.
   - Paste your data into the 'JSON' field, removing the `[` and `]` on the first and last lines.
   - Switch the field type to **Expression**.
   - Map in the data from the trigger by dragging it from the input pane.
   - For strings, make sure to replace the entire value (including the quotes) and add `.toJsonString()` to the end of the expression.
1. **Merge the branches using a 'No-op' node**: Insert a [No-op node](../../../integrations/builtin/core-nodes/n8n-nodes-base.noop/) and wire both the other trigger and the Set node up to it. The 'No-op' node just outputs whatever input it receives.
1. **Reference the 'No-op' node outputs in the rest of the workflow**: Since both paths will flow through this node with the same format, you can be sure that your input data will always be there.

## Avoiding evaluation breaking the chat

n8n's internal chat reads the output data of the last executed node in the workflow. After adding an evaluation node with the ['set outputs' operation](../../../integrations/builtin/core-nodes/n8n-nodes-base.evaluation/#set-outputs), this data may not be in the expected format, or even contain the chat response.

The solution is to add an extra branch coming out of your agent. [Lower branches execute later](../../../flow-logic/execution-order/) in n8n, which means any node you attach to this branch will execute last. You can use a no-op node here since it only needs to pass the agent output through.

## Accessing tool data when calculating metrics

Sometimes you need to know what happened in executed sub-nodes of an agent, for example to check whether it executed a tool. You can't reference these nodes directly with expressions, but you can enable the **Return intermediate steps** option in the agent. This will add an extra output field called `intermediateSteps` which you can use in later nodes:

## Multiple evaluations in the same workflow

You can only have one evaluation set up per workflow. In other words, you can only have one evaluation trigger per workflow.

Even so, you can still test different parts of your workflow with different evaluations by putting those parts in [sub-workflows](../../../flow-logic/subworkflows/) and evaluating each sub-workflow.

## Dealing with inconsistent results

Metrics can often have noise: they may be different across evaluation runs of the exact same workflow. This is because the workflow itself may return different results, or any LLM-based metrics might have natural variation in them.

You can compensate for this by duplicating the rows of your dataset, so that each row appears more than once in the dataset. Since this means that each input will effectively be running multiple times, it will smooth out any variations.

# Demonstration of key differences between agents and chains

In this workflow you can choose whether your chat query goes to an [agent](../../../glossary/#ai-agent) or [chain](../../../glossary/#ai-chain). It shows some of the ways that agents are more powerful than chains.

[View workflow file](/_workflows/advanced-ai/examples/agents_vs_chains.json)

## Key features

This workflow uses:

- [Chat Trigger](../../../integrations/builtin/core-nodes/n8n-nodes-langchain.chattrigger/): start your workflow and respond to user chat interactions. The node provides a customizable chat interface.
- [Switch node](../../../integrations/builtin/core-nodes/n8n-nodes-base.switch/): directs your query to either the agent or chain, depending on which you specify in your query. If you say "agent" it sends it to the agent. If you say "chain" it sends it to the chain.
- [Agent](../../../integrations/builtin/cluster-nodes/root-nodes/n8n-nodes-langchain.agent/): the Agent node interacts with other components of the workflow and makes decisions about what [tools](../../../glossary/#ai-tool) to use.
- [Basic LLM Chain](../../../integrations/builtin/cluster-nodes/root-nodes/n8n-nodes-langchain.chainllm/): the Basic LLM Chain node supports chatting with a connected LLM, but doesn't support [memory](../../../glossary/#ai-memory) or tools.

## Using the example

To load the template into your n8n instance:

1. Download the workflow JSON file.
1. Open a new workflow in your n8n instance.
1. Copy in the JSON, or select **Workflow menu** > **Import from file...**.

The example workflows use Sticky Notes to guide you:

- Yellow: notes and information.
- Green: instructions to run the workflow.
- Orange: you need to change something to make the workflow work.
- Blue: draws attention to a key feature of the example.

# Call an API to fetch data

Use n8n to bring data from any [API](../../../glossary/#api) to your AI. This workflow uses the [Chat Trigger](../../../integrations/builtin/core-nodes/n8n-nodes-langchain.chattrigger/) to provide the chat interface, and the [Call n8n Workflow Tool](../../../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.toolworkflow/) to call a second workflow that calls the API. The second workflow uses AI functionality to refine the API request based on the user's query.

[View workflow file](/_workflows/advanced-ai/examples/let_your_ai_call_an_api.json)

## Key features

This workflow uses:

- [Chat Trigger](../../../integrations/builtin/core-nodes/n8n-nodes-langchain.chattrigger/): start your workflow and respond to user chat interactions. The node provides a customizable chat interface.
- [Agent](../../../integrations/builtin/cluster-nodes/root-nodes/n8n-nodes-langchain.agent/): the key piece of the AI workflow. The Agent interacts with other components of the workflow and makes decisions about what tools to use.
- [Call n8n Workflow Tool](../../../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.toolworkflow/): plug in n8n workflows as custom tools. In AI, a tool is an interface the AI can use to interact with the world (in this case, the data provided by your workflow). The AI model uses the tool to access information beyond its built-in dataset.
- A [Basic LLM Chain](../../../integrations/builtin/cluster-nodes/root-nodes/n8n-nodes-langchain.chainllm/) with an [Auto-fixing Output Parser](../../../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.outputparserautofixing/) and [Structured Output Parser](../../../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.outputparserstructured/) to read the user's query and set parameters for the API call based on the user input.

## Using the example

To load the template into your n8n instance:

1. Download the workflow JSON file.
1. Open a new workflow in your n8n instance.
1. Copy in the JSON, or select **Workflow menu** > **Import from file...**.

The example workflows use Sticky Notes to guide you:

- Yellow: notes and information.
- Green: instructions to run the workflow.
- Orange: you need to change something to make the workflow work.
- Blue: draws attention to a key feature of the example.

# Chat with a Google Sheet using AI

Use n8n to bring your own data to AI. This workflow uses the [Chat Trigger](../../../integrations/builtin/core-nodes/n8n-nodes-langchain.chattrigger/) to provide the chat interface, and the [Call n8n Workflow Tool](../../../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.toolworkflow/) to call a second workflow that queries Google Sheets.

[View workflow file](/_workflows/advanced-ai/examples/chat_with_google_sheets_docs_version.json)

## Key features

This workflow uses:

- [Chat Trigger](../../../integrations/builtin/core-nodes/n8n-nodes-langchain.chattrigger/): start your workflow and respond to user chat interactions. The node provides a customizable chat interface.
- [Agent](../../../integrations/builtin/cluster-nodes/root-nodes/n8n-nodes-langchain.agent/): the key piece of the AI workflow. The Agent interacts with other components of the workflow and makes decisions about what tools to use.
- [Call n8n Workflow Tool](../../../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.toolworkflow/): plug in n8n workflows as custom tools. In AI, a tool is an interface the AI can use to interact with the world (in this case, the data provided by your workflow). The AI model uses the tool to access information beyond its built-in dataset.

## Using the example

To load the template into your n8n instance:

1. Download the workflow JSON file.
1. Open a new workflow in your n8n instance.
1. Copy in the JSON, or select **Workflow menu** > **Import from file...**.

The example workflows use Sticky Notes to guide you:

- Yellow: notes and information.
- Green: instructions to run the workflow.
- Orange: you need to change something to make the workflow work.
- Blue: draws attention to a key feature of the example.

# Have a human fallback for AI workflows

This is a workflow that tries to answer user queries using the standard GPT-4 model. If it can't answer, it sends a message to Slack to ask for human help. It prompts the user to supply an email address.

This workflow uses the [Chat Trigger](../../../integrations/builtin/core-nodes/n8n-nodes-langchain.chattrigger/) to provide the chat interface, and the [Call n8n Workflow Tool](../../../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.toolworkflow/) to call a second workflow that handles checking for email addresses and sending the Slack message.

[View workflow file](/_workflows/advanced-ai/examples/ask_a_human.json)

## Key features

This workflow uses:

- [Chat Trigger](../../../integrations/builtin/core-nodes/n8n-nodes-langchain.chattrigger/): start your workflow and respond to user chat interactions. The node provides a customizable chat interface.
- [Agent](../../../integrations/builtin/cluster-nodes/root-nodes/n8n-nodes-langchain.agent/): the key piece of the AI workflow. The Agent interacts with other components of the workflow and makes decisions about what tools to use.
- [Call n8n Workflow Tool](../../../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.toolworkflow/): plug in n8n workflows as custom tools. In AI, a tool is an interface the AI can use to interact with the world (in this case, the data provided by your workflow). It allows the AI model to access information beyond its built-in dataset.

## Using the example

To load the template into your n8n instance:

1. Download the workflow JSON file.
1. Open a new workflow in your n8n instance.
1. Copy in the JSON, or select **Workflow menu** > **Import from file...**.

The example workflows use Sticky Notes to guide you:

- Yellow: notes and information.
- Green: instructions to run the workflow.
- Orange: you need to change something to make the workflow work.
- Blue: draws attention to a key feature of the example.

# Advanced AI examples and concepts

This section provides explanations of important AI concepts, and workflow templates that highlight those concepts, with explanations and configuration guides. The examples cover common use cases and highlight different features of advanced AI in n8n.

- **Agents and chains**

  Learn about [agents](../../../glossary/#ai-agent) and [chains](../../../glossary/#ai-chain) in AI, including exploring key differences using the example workflow.

  [What's a chain in AI?](../understand-chains/)\
  [What's an agent in AI?](../understand-agents/)\
  [Demonstration of key differences between agents and chains](../agent-chain-comparison/)

- **Call n8n Workflow Tool**

  Learn about [tools](../../../glossary/#ai-tool) in AI, then explore examples that use n8n workflows as custom tools to give your AI workflow access to more data.

  [What's a tool in AI?](../understand-tools/)\
  [Chat with Google Sheets](../data-google-sheets/)\
  [Call an API to fetch data](../api-workflow-tool/)\
  [Set up a human fallback](../human-fallback/)\
  [Let AI specify tool parameters with `$fromAI()`](../using-the-fromai-function/)

- **Vector databases**

  Learn about [vector databases](../../../glossary/#ai-vector-store) in AI, along with related concepts including [embeddings](../../../glossary/#ai-embedding) and retrievers.

  [What's a vector database?](../understand-vector-databases/)\
  [Populate a Pinecone vector database from a website](../vector-store-website/)

- **Memory**

  Learn about [memory](../../../glossary/#ai-memory) in AI.

  [What's memory in AI?](../understand-memory/)

- **AI workflow templates**

  You can browse AI templates, included community contributions, on the n8n website.

  [Browse all AI templates](https://n8n.io/workflows/?categories=25)

# What's an agent in AI?

One way to think of an [agent](../../../glossary/#ai-agent) is as a [chain](../understand-chains/) that knows how to make decisions. Where a chain follows a predetermined sequence of calls to different AI components, an agent uses a language model to determine which actions to take.

Agents are the part of AI that act as decision-makers. They can interact with other agents and [tools](../../../glossary/#ai-tool). When you send a query to an agent, it tries to choose the best tools to use to answer. Agents adapt to your specific queries, as well as the prompts that configure their behavior.

## Agents in n8n

n8n provides one Agent node, which can act as different types of agent depending on the settings you choose. Refer to the [Agent node documentation](../../../integrations/builtin/cluster-nodes/root-nodes/n8n-nodes-langchain.agent/) for details on the available agent types.

When you execute a workflow containing an agent, the agent runs multiple times. For example, it may do an initial setup, followed by a run to call a tool, then another run to evaluate the tool response and respond to the user.

# What's a chain in AI?

[Chains](../../../glossary/#ai-chain) bring together different components of AI to create a cohesive system. They set up a sequence of calls between the components. These components can include models and [memory](../../../glossary/#ai-memory) (though note that in n8n chains can't use memory).

## Chains in n8n

n8n provides three chain nodes:

- [Basic LLM Chain](../../../integrations/builtin/cluster-nodes/root-nodes/n8n-nodes-langchain.chainllm/): use to interact with an LLM, without any additional components.
- [Question and Answer Chain](../../../integrations/builtin/cluster-nodes/root-nodes/n8n-nodes-langchain.chainretrievalqa/): can connect to a [vector store](../../../glossary/#ai-vector-store) using a retriever, or to an n8n workflow using the Workflow Retriever node. Use this if you want to create a workflow that supports asking questions about specific documents.
- [Summarization Chain](../../../integrations/builtin/cluster-nodes/root-nodes/n8n-nodes-langchain.chainsummarization/): takes an input and returns a summary.

There's an important difference between chains in n8n and in other tools such as LangChain: none of the chain nodes support memory. This means they can't remember previous user queries. If you use LangChain to code an AI application, you can give your application memory. In n8n, if you need your workflow to support memory, use an agent. This is essential if you want users to be able to have a natural ongoing conversation with your app.

# What's memory in AI?

Memory is a key part of AI chat services. The [memory](../../../glossary/#ai-memory) keeps a history of previous messages, allowing for an ongoing conversation with the AI, rather than every interaction starting fresh.

## AI memory in n8n

To add memory to your AI workflow you can use either:

- [Simple Memory](../../../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.memorybufferwindow/): stores a customizable length of chat history for the current session. This is the easiest to get started with.
- One of the memory services that n8n provides nodes for. These include:
  - [Motorhead](../../../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.memorymotorhead/)
  - [Redis Chat Memory](../../../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.memoryredischat/)
  - [Postgres Chat Memory](../../../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.memorypostgreschat/)
  - [Xata](../../../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.memoryxata/)
  - [Zep](../../../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.memoryzep/)

If you need to do advanced AI memory management in your workflows, use the [Chat Memory Manager](../../../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.memorymanager/) node.

This node is useful when you:

- Can't add a memory node directly.
- Need to do more complex memory management, beyond what the memory nodes offer. For example, you can add this node to check the memory size of the Agent node's response, and reduce it if needed.
- Want to inject messages to the AI that look like user messages, to give the AI more context.

# What's a tool in AI?

In AI, 'tools' has a specific meaning. Tools act like addons that your AI can use to access extra context or resources.

Here are a couple of other ways of expressing it:

> Tools are interfaces that an agent can use to interact with the world ([source](https://langchain-ai.github.io/langgraphjs/how-tos/tool-calling/))

> We can think of these tools as being almost like functions that your AI model can call ([source](https://www.udemy.com/course/chatgpt-and-langchain-the-complete-developers-masterclass/))

## AI tools in n8n

n8n provides tool [sub-nodes](../../../glossary/#sub-node-n8n) that you can connect to your [AI agent](../../../glossary/#ai-agent). As well as providing some popular tools, such as [Wikipedia](../../../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.toolwikipedia/) and [SerpAPI](../../../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.toolserpapi/), n8n provides three especially powerful tools:

- [Call n8n Workflow Tool](../../../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.toolworkflow/): use this to load any n8n workflow as a tool.
- [Custom Code Tool](../../../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.toolcode/): write code that your agent can run.
- [HTTP Request Tool](../../../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.toolhttprequest/): make calls to fetch a website or data from an API.

The next three examples highlight the Call n8n Workflow Tool:

- [Chat with Google Sheets](../data-google-sheets/)
- [Call an API to fetch data](../api-workflow-tool/)
- [Set up a human fallback](../human-fallback/)

You can also learn how to [let AI dynamically specify parameters for tools with the `$fromAI()` function](../using-the-fromai-function/).

# What are vector databases?

Vector databases store information as numbers:

> A vector database is a type of database that stores data as high-dimensional vectors, which are mathematical representations of features or attributes. ([source](https://learn.microsoft.com/en-us/semantic-kernel/memories/vector-db))

This enables fast and accurate similarity searches. With a vector database, instead of using conventional database queries, you can search for relevant data based on semantic and contextual meaning.

## A simplified example

A vector database could store the sentence "n8n is a source-available automation tool that you can self-host", but instead of storing it as text, the vector database stores an array of dimensions (numbers between 0 and 1) that represent its features. This doesn't mean turning each letter in the sentence into a number. Instead, the vectors in the vector database describe the sentence.

Suppose that in a vector store `0.1` represents `automation tool`, `0.2` represents `source available`, and `0.3` represents `can be self-hosted`. You could end up with the following vectors:

| Sentence                                                         | Vector (array of dimensions) |
| ---------------------------------------------------------------- | ---------------------------- |
| n8n is a source-available automation tool that you can self-host | [0.1, 0.2, 0.3]              |
| Zapier is an automation tool                                     | [0.1]                        |
| Make is an automation tool                                       | [0.1]                        |
| Confluence is a wiki tool that you can self-host                 | [0.3]                        |

This example is very simplified

In practice, vectors are far more complex. A vector can range in size from tens to thousands of dimensions. The dimensions don't have a one-to-one relationship to a single feature, so you can't translate individual dimensions directly into single concepts. This example gives an approximate mental model, not a true technical understanding.

## Demonstrating the power of similarity search

Qdrant provides [vector search demos](https://qdrant.tech/demo/) to help users understand the power of vector databases. The [food discovery demo](https://food-discovery.qdrant.tech/) shows how a vector store can help match pictures based on visual similarities.

> This demo uses data from Delivery Service. Users may like or dislike the photo of a dish, and the app will recommend more similar meals based on how they look. It's also possible to choose to view results from the restaurants within the delivery radius. ([source](https://qdrant.tech/demo/))

For full technical details, refer to the [Qdrant demo-food-discovery GitHub repository](https://github.com/qdrant/demo-food-discovery).

## Embeddings, retrievers, text splitters, and document loaders

Vector databases require other tools to function:

- Document loaders and text splitters: document loaders pull in documents and data, and prepare them for [embedding](../../../glossary/#ai-embedding). Document loaders can use text splitters to break documents into chunks.
- Embeddings: these are the tools that turn the data (text, images, and so on) into vectors, and back into raw data. Note that n8n only supports text embeddings.
- Retrievers: retrievers fetch documents from vector databases. You need to pair them with an embedding to translate the vectors back into data.

# Let AI specify the tool parameters

When configuring [tools](../../../glossary/#ai-tool) connected to the Tools Agent, many parameters can be filled in by the AI model itself. The AI model will use the context from the task and information from other connected tools to fill in the appropriate details.

There are two ways to do this, and you can switch between them.

## Let the model fill in the parameter

Each appropriate parameter field in the tool's editing dialog has an extra button at the end:

On activating this button, the [AI Agent](../../../glossary/#ai-agent) will fill in the expression for you, with no need for any further user input. The field itself is filled in with a message indicating that the parameter has been defined automatically by the model.

If you want to define the parameter yourself, click on the 'X' in this box to revert to user-defined values. Note that the 'expression' field will now contain the expression generated by this feature, though you can now edit it further to add extra details as described in the following section.

Warning

Activating this feature will overwrite any manual definition you may have already added.

## Use the `$fromAI()` function

The `$fromAI()` function uses AI to dynamically fill in parameters for tools connected to the [Tools AI agent](../../../integrations/builtin/cluster-nodes/root-nodes/n8n-nodes-langchain.agent/tools-agent/).

Only for tools

The `$fromAI()` function is only available for tools connected to the AI Agent node. The `$fromAI()` function doesn't work with the [Code](../../../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.toolcode/) tool or with [other non-tool cluster sub-nodes](../../../integrations/builtin/cluster-nodes/sub-nodes/).

To use the `$fromAI()` function, call it with the required `key` parameter:

```
{{ $fromAI('email') }}
```

The `key` parameter and other arguments to the `$fromAI()` function aren't references to existing values. Instead, think of these arguments as hints that the AI model will use to populate the right data.

For instance, if you choose a key called `email`, the AI Model will look for an email address in its context, other tools, and input data. In chat workflows, it may ask the user for an email address if it can't find one elsewhere. You can optionally pass other parameters like `description` to give extra context to the AI model.

### Parameters

The `$fromAI()` function accepts the following parameters:

| Parameter      | Type   | Required? | Description                                                                                                                                                                                             |
| -------------- | ------ | --------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| `key`          | string |           | A string representing the key or name of the argument. This must be between 1 and 64 characters in length and can only contain lowercase letters, uppercase letters, numbers, underscores, and hyphens. |
| `description`  | string |           | A string describing the argument.                                                                                                                                                                       |
| `type`         | string |           | A string specifying the data type. Can be string, number, boolean, or json (defaults to string).                                                                                                        |
| `defaultValue` | any    |           | The default value to use for the argument.                                                                                                                                                              |

### Examples

As an example, you could use the following `$fromAI()` expression to dynamically populate a field with a name:

```
$fromAI("name", "The commenter's name", "string", "Jane Doe")
```

If you don't need the optional parameters, you could simplify this as:

```
$fromAI("name")
```

To dynamically populate the number of items you have in stock, you could use a `$fromAI()` expression like this:

```
$fromAI("numItemsInStock", "Number of items in stock", "number", 5)
```

If you only want to fill in parts of a field with a dynamic value from the model, you can use it in a normal expression as well. For example, if you want the model to fill out the `subject` parameter for an e-mail, but always pre-fix the generated value with the string 'Generated by AI:', you could use the following expression:

```
Generated by AI: {{ $fromAI("subject") }}
```

### Templates

You can see the `$fromAI()` function in action in the following [templates](../../../glossary/#template-n8n):

- [Angie, Personal AI Assistant with Telegram Voice and Text](https://n8n.io/workflows/2462-angie-personal-ai-assistant-with-telegram-voice-and-text/)
- [Automate Customer Support Issue Resolution using AI Text Classifier](https://n8n.io/workflows/2468-automate-customer-support-issue-resolution-using-ai-text-classifier/)
- [Scale Deal Flow with a Pitch Deck AI Vision, Chatbot and QDrant Vector Store](https://n8n.io/workflows/2464-scale-deal-flow-with-a-pitch-deck-ai-vision-chatbot-and-qdrant-vector-store/)

# Populate a Pinecone vector database from a website

Use n8n to scrape a website, load the data into Pinecone, then query it using a chat workflow. This workflow uses the [HTTP node](../../../integrations/builtin/core-nodes/n8n-nodes-base.httprequest/) to get website data, extracts the relevant content using the [HTML node](../../../integrations/builtin/core-nodes/n8n-nodes-base.html/), then uses the [Pinecone Vector Store node](../../../integrations/builtin/cluster-nodes/root-nodes/n8n-nodes-langchain.vectorstorepinecone/) to send it to Pinecone.

[View workflow file](/_workflows/advanced-ai/examples/populate_a_pinecone_vector_database_from_a_website.json)

## Key features

This workflow uses:

- [HTTP node](../../../integrations/builtin/core-nodes/n8n-nodes-base.httprequest/): fetches website data.
- [HTML node](../../../integrations/builtin/core-nodes/n8n-nodes-base.html/): simplifies the data by extracting the main content from the page.
- [Pinecone Vector Store node](../../../integrations/builtin/cluster-nodes/root-nodes/n8n-nodes-langchain.vectorstorepinecone/) and [Embeddings OpenAI](../../../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.embeddingsopenai/): transform the data into vectors and store it in Pinecone.
- [Chat Trigger](../../../integrations/builtin/core-nodes/n8n-nodes-langchain.chattrigger/) and [Question and Answer Chain](../../../integrations/builtin/cluster-nodes/root-nodes/n8n-nodes-langchain.chainretrievalqa/) to query the vector database.

## Using the example

To load the template into your n8n instance:

1. Download the workflow JSON file.
1. Open a new workflow in your n8n instance.
1. Copy in the JSON, or select **Workflow menu** > **Import from file...**.

The example workflows use Sticky Notes to guide you:

- Yellow: notes and information.
- Green: instructions to run the workflow.
- Orange: you need to change something to make the workflow work.
- Blue: draws attention to a key feature of the example.

# LangChain learning resources

You don't need to know details about LangChain to use n8n, but it can be helpful to learn a few concepts. This pages lists some learning resources that people at n8n have found helpful.

The [LangChain documentation](https://docs.langchain.com/docs/) includes introductions to key concepts and possible use cases. Choose the [LangChain | Python](https://python.langchain.com/docs/get_started/introduction) or [LangChain | JavaScript](https://js.langchain.com/docs/get_started/introduction/) documentation for quickstarts, code examples, and API documentation. LangChain also provide [code templates](https://github.com/langchain-ai/langchain/tree/master/cookbook) (Python only), offering ideas for potential use cases and common patterns.

[What Product People Need To Know About LangChain](https://www.commandbar.com/blog/langchain-guide) provides a list of terminology and concepts, explained with helpful metaphors. Aimed at a wide audience.

If you prefer video, this [YouTube series by Greg Kamradt](https://youtu.be/_v_fgW2SkkQ?si=8Z2tfAoXnN3lXU9s) works through the LangChain documentation, providing code examples as it goes.

n8n offers space to discuss LangChain on the [Discord](https://discord.gg/bAt54txhHg). Join to share your projects and discuss ideas with the community.

# LangChain concepts in n8n

This page explains how LangChain concepts and features map to n8n nodes.

This page includes lists of the LangChain-focused nodes in n8n. You can use any n8n node in a workflow where you interact with LangChain, to link LangChain to other services. The LangChain features uses n8n's [Cluster nodes](../../../integrations/builtin/cluster-nodes/).

n8n implements LangChain JS

This feature is n8n's implementation of [LangChain's JavaScript framework](https://js.langchain.com/docs/get_started/introduction).

## Trigger nodes

[Chat Trigger](../../../integrations/builtin/core-nodes/n8n-nodes-langchain.chattrigger/)

## Cluster nodes

[Cluster nodes](../../../glossary/#cluster-node-n8n) are node groups that work together to provide functionality in an n8n workflow. Instead of using a single node, you use a [root node](../../../glossary/#root-node-n8n) and one or more [sub-nodes](../../../glossary/#sub-node-n8n) that extend the functionality of the node.

### Root nodes

Each cluster starts with one [root node](../../../glossary/#root-node-n8n).

#### Chains

A [chain](../../../glossary/#ai-chain) is a series of LLMs, and related tools, linked together to support functionality that can't be provided by a single LLM alone.

Available nodes:

- [Basic LLM Chain](../../../integrations/builtin/cluster-nodes/root-nodes/n8n-nodes-langchain.chainllm/)
- [Retrieval Q&A Chain](../../../integrations/builtin/cluster-nodes/root-nodes/n8n-nodes-langchain.chainretrievalqa/)
- [Summarization Chain](../../../integrations/builtin/cluster-nodes/root-nodes/n8n-nodes-langchain.chainsummarization/)
- [Sentiment Analysis](../../../integrations/builtin/cluster-nodes/root-nodes/n8n-nodes-langchain.sentimentanalysis/)
- [Text Classifier](../../../integrations/builtin/cluster-nodes/root-nodes/n8n-nodes-langchain.text-classifier/)

Learn more about [chaining in LangChain](https://js.langchain.com/docs/concepts/lcel).

#### Agents

> An [agent](../../../glossary/#ai-agent) has access to a suite of tools, and determines which ones to use depending on the user input. Agents can use multiple tools, and use the output of one tool as the input to the next. [Source](https://github.com/langchain-ai/langchainjs/blob/def3a26c054575e1ed40b9062087e8c0a8899633/docs/core_docs/docs/modules/agents/index.mdx)

Available nodes:

- [Agent](../../../integrations/builtin/cluster-nodes/root-nodes/n8n-nodes-langchain.agent/)

Learn more about [Agents in LangChain](https://js.langchain.com/docs/concepts/agents).

#### Vector stores

[Vector stores](../../../glossary/#ai-vector-store) store embedded data, and perform vector searches on it.

- [Simple Vector Store](../../../integrations/builtin/cluster-nodes/root-nodes/n8n-nodes-langchain.vectorstoreinmemory/)
- [PGVector Vector Store](../../../integrations/builtin/cluster-nodes/root-nodes/n8n-nodes-langchain.vectorstorepgvector/)
- [Pinecone Vector Store](../../../integrations/builtin/cluster-nodes/root-nodes/n8n-nodes-langchain.vectorstorepinecone/)
- [Qdrant Vector Store](../../../integrations/builtin/cluster-nodes/root-nodes/n8n-nodes-langchain.vectorstoreqdrant/)
- [Supabase Vector Store](../../../integrations/builtin/cluster-nodes/root-nodes/n8n-nodes-langchain.vectorstoresupabase/)
- [Zep Vector Store](../../../integrations/builtin/cluster-nodes/root-nodes/n8n-nodes-langchain.vectorstorezep/)

Learn more about [Vector stores in LangChain](https://js.langchain.com/docs/concepts/vectorstores/).

#### Miscellaneous

Utility nodes.

[LangChain Code](../../../integrations/builtin/cluster-nodes/root-nodes/n8n-nodes-langchain.code/): import LangChain. This means if there is functionality you need that n8n hasn't created a node for, you can still use it.

### Sub-nodes

Each root node can have one or more [sub-nodes](../../../glossary/#sub-node-n8n) attached to it.

#### Document loaders

Document loaders add data to your chain as documents. The data source can be a file or web service.

Available nodes:

- [Default Document Loader](../../../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.documentdefaultdataloader/)
- [GitHub Document Loader](../../../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.documentgithubloader/)

Learn more about [Document loaders in LangChain](https://js.langchain.com/docs/concepts/document_loaders).

#### Language models

[LLMs (large language models)](../../../glossary/#large-language-model-llm) are programs that analyze datasets. They're the key element of working with AI.

Available nodes:

- [Anthropic Chat Model](../../../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.lmchatanthropic/)
- [AWS Bedrock Chat Model](../../../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.lmchatawsbedrock/)
- [Cohere Model](../../../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.lmcohere/)
- [Hugging Face Inference Model](../../../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.lmopenhuggingfaceinference/)
- [Mistral Cloud Chat Model](../../../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.lmchatmistralcloud/)
- [Ollama Chat Model](../../../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.lmchatollama/)
- [Ollama Model](../../../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.lmollama/)
- [OpenAI Chat Model](../../../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.lmchatopenai/)

Learn more about [Language models in LangChain](https://js.langchain.com/docs/concepts/chat_models).

#### Memory

[Memory](../../../glossary/#ai-memory) retains information about previous queries in a series of queries. For example, when a user interacts with a chat model, it's useful if your application can remember and call on the full conversation, not just the most recent query entered by the user.

Available nodes:

- [Motorhead](../../../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.memorymotorhead/)
- [Redis Chat Memory](../../../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.memoryredischat/)
- [Postgres Chat Memory](../../../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.memorypostgreschat/)
- [Simple Memory](../../../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.memorybufferwindow/)
- [Xata](../../../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.memoryxata/)
- [Zep](../../../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.memoryzep/)

Learn more about [Memory in LangChain](https://langchain-ai.github.io/langgraphjs/concepts/memory/).

#### Output parsers

Output parsers take the text generated by an LLM and format it to match the structure you require.

Available nodes:

- [Auto-fixing Output Parser](../../../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.outputparserautofixing/)
- [Item List Output Parser](../../../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.outputparseritemlist/)
- [Structured Output Parser](../../../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.outputparserstructured/)

Learn more about [Output parsers in LangChain](https://js.langchain.com/docs/concepts/output_parsers/).

#### Retrievers

- [Contextual Compression Retriever](../../../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.retrievercontextualcompression/)
- [MultiQuery Retriever](../../../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.retrievermultiquery/)
- [Vector Store Retriever](../../../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.retrievervectorstore/)
- [Workflow Retriever](../../../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.retrieverworkflow/)

#### Text splitters

Text splitters break down data (documents), making it easier for the LLM to process the information and return accurate results.

Available nodes:

- [Character Text Splitter](../../../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.textsplittercharactertextsplitter/)
- [Recursive Character Text Splitter](../../../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.textsplitterrecursivecharactertextsplitter/)
- [Token Splitter](../../../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.textsplittertokensplitter/)

n8n's text splitter nodes implements parts of [LangChain's text_splitter API](https://js.langchain.com/docs/concepts/text_splitters/).

#### Tools

Utility [tools](../../../glossary/#ai-tool).

- [Calculator](../../../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.toolcalculator/)
- [Code Tool](../../../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.toolcode/)
- [SerpAPI](../../../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.toolserpapi/)
- [Think Tool](../../../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.toolthink/)
- [Vector Store Tool](../../../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.toolvectorstore/)
- [Wikipedia](../../../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.toolwikipedia/)
- [Wolfram|Alpha](../../../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.toolwolframalpha/)
- [Workflow Tool](../../../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.toolworkflow/)

#### Embeddings

> [Embeddings](../../../glossary/#ai-embedding) capture the "relatedness" of text, images, video, or other types of information. ([source](https://supabase.com/docs/guides/ai/concepts))

Available nodes:

- [Embeddings AWS Bedrock](../../../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.embeddingsawsbedrock/)
- [Embeddings Cohere](../../../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.embeddingscohere/)
- [Embeddings Google PaLM](../../../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.embeddingsgooglepalm/)
- [Embeddings Hugging Face Inference](../../../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.embeddingshuggingfaceinference/)
- [Embeddings Mistral Cloud](../../../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.embeddingsmistralcloud/)
- [Embeddings Ollama](../../../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.embeddingsollama/)
- [Embeddings OpenAI](../../../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.embeddingsopenai/)

Learn more about [Text embeddings in LangChain](https://js.langchain.com/docs/concepts/embedding_models/).

#### Miscellaneous

- [Chat Memory Manager](../../../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.memorymanager/)

# Use LangSmith with n8n

[LangSmith](https://www.langchain.com/langsmith) is a developer platform created by the LangChain team. You can connect your n8n instance to LangSmith to record and monitor runs in n8n, just as you can in a LangChain application.

Feature availability

Self-hosted n8n only.

## Connect your n8n instance to LangSmith

1. [Log in to LangSmith](https://smith.langchain.com/settings) and get your API key.

1. Set the LangSmith environment variables:

   | Variable             | Value                               |
   | -------------------- | ----------------------------------- |
   | LANGCHAIN_ENDPOINT   | `"https://api.smith.langchain.com"` |
   | LANGCHAIN_TRACING_V2 | `true`                              |
   | LANGCHAIN_API_KEY    | Set this to your API key            |

   Set the variables so that they're available globally in the environment where you host your n8n instance. You can do this in the same way as the rest of your general configuration.

1. Restart n8n.

For information on using LangSmith, refer to [LangSmith's documentation](https://docs.smith.langchain.com/).

# LangChain in n8n

n8n provides a collection of nodes that implement LangChain's functionality. The LangChain nodes are configurable, meaning you can choose your preferred agent, LLM, memory, and so on. Alongside the LangChain nodes, you can connect any n8n node as normal: this means you can integrate your LangChain logic with other data sources and services.

- [Learning resources](../langchain-learning-resources/): n8n's documentation for LangChain assumes you're familiar with AI and LangChain concepts. This page provides links to learning resources.
- [LangChain concepts and features in n8n](../langchain-n8n/): how n8n represents LangChain concepts and features.

# n8n public REST API

Feature availability

The n8n API isn't available during the free trial. Please upgrade to access this feature.

Using n8n's public [API](../glossary/#api), you can programmatically perform many of the same tasks as you can in the GUI. This section introduces n8n's REST API, including:

- How to [authenticate](authentication/)
- [Paginating](pagination/) results
- Using the [built-in API playground](using-api-playground/) (self-hosted n8n only)
- [Endpoint reference](api-reference/)

n8n provides an [n8n API node](../integrations/builtin/core-nodes/n8n-nodes-base.n8n/) to access the API in your workflows.

## Learn about REST APIs

The API documentation assumes you are familiar with REST APIs. If you're not, these resources may be helpful:

- [KnowledgeOwl's guide to working with APIs](https://support.knowledgeowl.com/help/working-with-apis): a basic introduction, including examples of how to call REST APIs.
- [IBM Cloud Learn Hub - What is an Application Programming Interface (API)](https://www.ibm.com/cloud/learn/api): this gives a general, but technical, introduction to APIs.
- [IBM Cloud Learn Hub - What is a REST API?](https://www.ibm.com/cloud/learn/rest-apis): more detailed information about REST APIs.
- [MDN web docs - An overview of HTTP](https://developer.mozilla.org/en-US/docs/Web/HTTP/Overview): REST APIs work over HTTP and use HTTP verbs, or methods, to specify the action to perform.

Use the API playground

Trying out the API in the [playground](using-api-playground/) can help you understand how APIs work. If you're worried about changing live data, consider setting up a test workflow, or test n8n instance, to explore safely.


# API authentication

n8n uses API keys to authenticate API calls.

Feature availability

The n8n API isn't available during the free trial. Please upgrade to access this feature.

## API Scopes

Users of [enterprise instances](https://n8n.io/enterprise/) can limit which resources and actions a key can access with scopes. API key scopes allow you specify the exact level of access a key needs for its intended purpose.

Non-enterprise API keys have full access to all the account's resources and capabilities.

## Create an API key

1. Log in to n8n.
1. Go to **Settings** > **n8n API**.
1. Select **Create an API key**.
1. Choose a **Label** and set an **Expiration** time for the key.
1. If on an enterprise plan, choose the **Scopes** to give the key.
1. Copy **My API Key** and use this key to authenticate your calls.

## Call the API using your key

Send the API key in your API call as a header named `X-N8N-API-KEY`.

For example, say you want to get all active workflows. Your curl request will look like this:

```
# For a self-hosted n8n instance
curl -X 'GET' \
  '<N8N_HOST>:<N8N_PORT>/<N8N_PATH>/api/v<version-number>/workflows?active=true' \
  -H 'accept: application/json' \
  -H 'X-N8N-API-KEY: <your-api-key>'

# For n8n Cloud
curl -X 'GET' \
  '<your-cloud-instance>/api/v<version-number>/workflows?active=true' \
  -H 'accept: application/json' \
  -H 'X-N8N-API-KEY: <your-api-key>'
```

## Delete an API key

1. Log in to n8n.
1. Go to **Settings** > **n8n API**.
1. Select **Delete** next to the key you want to delete.
1. Confirm the delete by selecting **Delete Forever**.

# API pagination

The default page size is 100 results. You can change the page size limit. The maximum permitted size is 250.

When a response contains more than one page, it includes a cursor, which you can use to request the next pages.

For example, say you want to get all active workflows, 150 at a time.

Get the first page:

```
# For a self-hosted n8n instance
curl -X 'GET' \
  '<N8N_HOST>:<N8N_PORT>/<N8N_PATH>/api/v<version-number>/workflows?active=true&limit=150' \
  -H 'accept: application/json' \
  -H 'X-N8N-API-KEY: <your-api-key>'

# For n8n Cloud
curl -X 'GET' \
  '<your-cloud-instance>/api/v<version-number>/workflows?active=true&limit=150' \
  -H 'accept: application/json' \
  -H 'X-N8N-API-KEY: <your-api-key>'
```

The response is in JSON format, and includes a `nextCursor` value. This is an example response.

```
{
  "data": [
    // The response contains an object for each workflow
    {
      // Workflow data
    }
  ],
  "nextCursor": "MTIzZTQ1NjctZTg5Yi0xMmQzLWE0NTYtNDI2NjE0MTc0MDA"
}
```

Then to request the next page:

```
# For a self-hosted n8n instance
curl -X 'GET' \
  '<N8N_HOST>:<N8N_PORT>/<N8N_PATH>/api/v<version-number>/workflows?active=true&limit=150&cursor=MTIzZTQ1NjctZTg5Yi0xMmQzLWE0NTYtNDI2NjE0MTc0MDA' \
  -H 'accept: application/json'

# For n8n Cloud
curl -X 'GET' \
  '<your-cloud-instance>/api/v<version-number>/workflows?active=true&limit=150&cursor=MTIzZTQ1NjctZTg5Yi0xMmQzLWE0NTYtNDI2NjE0MTc0MDA' \
  -H 'accept: application/json'
```

# Using an API playground

This documentation site provides a playground to test out calls. Self-hosted users also have access to a built-in playground hosted as part of their instance.

## Documentation playground

You can test API calls from this site's [API reference](../api-reference/). You need to set your server's base URL and instance name, and add an API key.

n8n uses [Scalar's](https://github.com/scalar/scalar) open source API platform to power this functionality.

Exposed API key and data

Use a test API key with limited scopes and test data when using a playground. All calls from the playground are routed through Scalar's proxy servers.

Real data

You have access to your live data. This is useful for trying out requests. Be aware you can change or delete real data.

## Built-in playground

Feature availability

The API playground isn't available on Cloud. It's available for all self-hosted pricing tiers.

The n8n API comes with a built-in Swagger UI playground in self-hosted versions. This provides interactive documentation, where you can try out requests. The path to access the playground depends on your hosting.

n8n constructs the path from values set in your environment variables:

```
N8N_HOST:N8N_PORT/N8N_PATH/api/v<api-version-number>/docs
```

The API version number is `1`. There may be multiple versions available in the future.

Real data

If you select **Authorize** and enter your API key in the API playground, you have access to your live data. This is useful for trying out requests. Be aware you can change or delete real data.

The API includes built-in documentation about credential formats. This is available using the `credentials` endpoint:

```
N8N_HOST:N8N_PORT/N8N_PATH/api/v<api-version-number>/credentials/schema/{credentialTypeName}
```

How to find `credentialTypeName`

To find the type, download your workflow as JSON and examine it. For example, for a Google Drive node the `{credentialTypeName}` is `googleDriveOAuth2Api`:

```
{
    ...,
    "credentials": {
        "googleDriveOAuth2Api": {
        "id": "9",
        "name": "Google Drive"
        }
    }
}
```

# Code in n8n

n8n is a low-code tool. This means you can do a lot without code, then add code when needed.

## Code in your workflows

There are two places in your workflows where you can use code:

- **Expressions**

  Use [expressions](../glossary/#expression-n8n) to transform [data](../data/) in your nodes. You can use JavaScript in expressions, as well as n8n's [Built-in methods and variables](builtin/overview/) and [Data transformation functions](builtin/data-transformation-functions/).

  [Expressions](expressions/)

- **Code node**

  Use the Code node to add JavaScript or Python to your workflow.

  [Code node](code-node/)

## Other technical resources

These are features that are relevant to technical users.

### Technical nodes

n8n provides core nodes, which simplify adding key functionality such as API requests, webhooks, scheduling, and file handling.

- **Write a backend**

  The [HTTP Request](../integrations/builtin/core-nodes/n8n-nodes-base.httprequest/), [Webhook](../integrations/builtin/core-nodes/n8n-nodes-base.webhook/), and [Code](code-node/) nodes help you make API calls, respond to webhooks, and write any JavaScript in your workflow.

  Use this do things like [Create an API endpoint](https://n8n.io/workflows/1750-creating-an-api-endpoint/).

  [Core nodes](../integrations/builtin/core-nodes/)

- **Represent complex logic**

  You can build complex flows, using nodes like [If](../integrations/builtin/core-nodes/n8n-nodes-base.if/), [Switch](../integrations/builtin/core-nodes/n8n-nodes-base.switch/), and [Merge](../integrations/builtin/core-nodes/n8n-nodes-base.merge/) nodes.

  [Flow logic](../flow-logic/)

### Other developer resources

- **The n8n API**

  n8n provides an API, where you can programmatically perform many of the same tasks as you can in the GUI. There's an [n8n API node](../integrations/builtin/core-nodes/n8n-nodes-base.n8n/) to access the API in your workflows.

  [API](../api/)

- **Self-host**

  You can self-host n8n. This keeps your data on your own infrastructure.

  [Hosting](../hosting/)

- **Build your own nodes**

  You can build custom nodes, install them on your n8n instance, and publish them to [npm](https://www.npmjs.com/).

  [Creating nodes](../integrations/creating-nodes/overview/)

# AI coding with GPT

Not available on self-hosted.

Python isn't supported. ///

## Use AI in the Code node

Feature availability

AI assistance in the Code node is available to Cloud users. It isn't available in self-hosted n8n.

AI generated code overwrites your code

If you've already written some code on the **Code** tab, the AI generated code will replace it. n8n recommends using AI as a starting point to create your initial code, then editing it as needed.

To use ChatGPT to generate code in the Code node:

1. In the Code node, set **Language** to **JavaScript**.
1. Select the **Ask AI** tab.
1. Write your query.
1. Select **Generate Code**. n8n sends your query to ChatGPT, then displays the result in the **Code** tab.

## Usage limits

During the trial phase there are no usage limits. If n8n makes the feature permanent, there may be usage limits as part of your pricing tier.

## Feature limits

The ChatGPT implementation in n8n has the following limitations:

- The AI writes code that manipulates data from the n8n workflow. You can't ask it to pull in data from other sources.
- The AI doesn't know your data, just the schema, so you need to tell it things like how to find the data you want to extract, or how to check for null.
- Nodes before the Code node must execute and deliver data to the Code node before you run your AI query.
- Doesn't work with large incoming data schemas.
- May have issues if there are a lot of nodes before the code node.

## Writing good prompts

Writing good prompts increases the chance of getting useful code back.

Some general tips:

- Provide examples: if possible, give a sample expected output. This helps the AI to better understand the transformation or logic you’re aiming for.
- Describe the processing steps: if there are specific processing steps or logic that should apply to the data, list them in sequence. For example: "First, filter out all users under 18. Then, sort the remaining users by their last name."
- Avoid ambiguities: while the AI understands various instructions, being clear and direct ensures you get the most accurate code. Instead of saying "Get the older users," you might say "Filter users who are 60 years and above."
- Be clear about what you expect as the output. Do you want the data transformed, filtered, aggregated, or sorted? Provide as much detail as possible.

And some n8n-specific guidance:

- Think about the input data: make sure ChatGPT knows which pieces of the data you want to access, and what the incoming data represents. You may need to tell ChatGPT about the availability of n8n's built-in methods and variables.
- Declare interactions between nodes: if your logic involves data from multiple nodes, specify how they should interact. "Merge the output of 'Node A' with 'Node B' based on the 'userID' property". if you prefer data to come from certain nodes or to ignore others, be clear: "Only consider data from the 'Purchases' node and ignore the 'Refunds' node."
- Ensure the output is compatible with n8n. Refer to [Data structure](../../data/data-structure/) for more information on the data structure n8n requires.

### Example prompts

These examples show a range of possible prompts and tasks.

#### Example 1: Find a piece of data inside a second dataset

To try the example yourself, [download the example workflow](../../_workflows/ai-code/find-a-piece-of-data.json) and import it into n8n.

In the third Code node, enter this prompt:

> The slack data contains only one item. The input data represents all Notion users. Sometimes the person property that holds the email can be null. I want to find the notionId of the Slack user and return it.

Take a look at the code the AI generates.

This is the JavaScript you need:

```
const slackUser = $("Mock Slack").all()[0];
const notionUsers = $input.all();
const slackUserEmail = slackUser.json.email;

const notionUser = notionUsers.find(
  (user) => user.json.person && user.json.person.email === slackUserEmail
);

return notionUser ? [{ json: { notionId: notionUser.json.id } }] : [];
```

#### Example 2: Data transformation

To try the example yourself, [download the example workflow](../../_workflows/ai-code/data-transformation.json) and import it into n8n.

In the **Join items** Code node, enter this prompt:

> Return a single line of text that has all usernames listed with a comma. Each username should be enquoted with a double quotation mark.

Take a look at the code the AI generates.

This is the JavaScript you need:

```
const items = $input.all();
const usernames = items.map((item) => `"${item.json.username}"`);
const result = usernames.join(", ");
return [{ json: { usernames: result } }];
```

#### Example 3: Summarize data and create a Slack message

To try the example yourself, [download the example workflow](../../_workflows/ai-code/summarize-data.json) and import it into n8n.

In the **Summarize** Code node, enter this prompt:

> Create a markdown text for Slack that counts how many ideas, features and bugs have been submitted. The type of submission is saved in the property_type field. A feature has the property "Feature", a bug has the property "Bug" and an idea has the property "Bug". Also, list the five top submissions by vote in that message. Use "" as markdown for links.

Take a look at the code the AI generates.

This is the JavaScript you need:

```
const submissions = $input.all();

// Count the number of ideas, features, and bugs
let ideaCount = 0;
let featureCount = 0;
let bugCount = 0;

submissions.forEach((submission) => {
  switch (submission.json.property_type[0]) {
    case "Idea":
      ideaCount++;
      break;
    case "Feature":
      featureCount++;
      break;
    case "Bug":
      bugCount++;
      break;
  }
});

// Sort submissions by votes and take the top 5
const topSubmissions = submissions
  .sort((a, b) => b.json.property_votes - a.json.property_votes)
  .slice(0, 5);

let topSubmissionText = "";
topSubmissions.forEach((submission) => {
  topSubmissionText += `<${submission.json.url}|${submission.json.name}> with ${submission.json.property_votes} votes\n`;
});

// Construct the Slack message
const slackMessage = `*Summary of Submissions*\n
Ideas: ${ideaCount}\n
Features: ${featureCount}\n
Bugs: ${bugCount}\n
Top 5 Submissions:\n
${topSubmissionText}`;

return [{ json: { slackMessage } }];
```

### Reference incoming node data explicitly

If your incoming data contains nested fields, using dot notation to reference them can help the AI understand what data you want.

To try the example yourself, [download the example workflow](../../_workflows/ai-code/reference-incoming-data-explicitly.json) and import it into n8n.

In the second Code node, enter this prompt:

> The data in "Mock data" represents a list of people. For each person, return a new item containing personal_info.first_name and work_info.job_title.

This is the JavaScript you need:

```
const items = $input.all();
const newItems = items.map((item) => {
  const firstName = item.json.personal_info.first_name;
  const jobTitle = item.json.work_info.job_title;
  return {
    json: {
      firstName,
      jobTitle,
    },
  };
});
return newItems;
```

### Related resources

Pluralsight offer a short guide on [How to use ChatGPT to write code](https://www.pluralsight.com/blog/software-development/how-use-chatgpt-programming-coding), which includes example prompts.

## Fixing the code

The AI-generated code may work without any changes, but you may have to edit it. You need to be aware of n8n's [Data structure](../../data/data-structure/). You may also find n8n's built-in methods and variables useful.

# Using the Code node

Use the Code node to write custom JavaScript or Python and run it as a step in your workflow.

Coding in n8n

This page gives usage information about the Code node. For more guidance on coding in n8n, refer to the [Code](../) section. It includes:

- Reference documentation on [Built-in methods and variables](../builtin/overview/)
- Guidance on [Handling dates](../cookbook/luxon/) and [Querying JSON](../cookbook/jmespath/)
- A growing collection of examples in the [Cookbook](../cookbook/code-node/)

Examples and templates

For usage examples and templates to help you get started, refer to n8n's [Code integrations](https://n8n.io/integrations/code/) page.

Function and Function Item nodes

The Code node replaces the Function and Function Item nodes from version 0.198.0. If you're using an older version of n8n, you can still view the [Function node documentation](https://github.com/n8n-io/n8n-docs/blob/67935ad2528e2e30d7984ea917e4af2910a096ec/docs/integrations/builtin/core-nodes/n8n-nodes-base.function.md) and [Function Item node documentation](https://github.com/n8n-io/n8n-docs/blob/67935ad2528e2e30d7984ea917e4af2910a096ec/docs/integrations/builtin/core-nodes/n8n-nodes-base.functionItem.md).

## Usage

How to use the Code node.

### Choose a mode

There are two modes:

- **Run Once for All Items**: this is the default. When your workflow runs, the code in the code node executes once, regardless of how many input items there are.
- **Run Once for Each Item**: choose this if you want your code to run for every input item.

## JavaScript

The Code node supports Node.js.

### Supported JavaScript features

The Code node supports:

- Promises. Instead of returning the items directly, you can return a promise which resolves accordingly.
- Writing to your browser console using `console.log`. This is useful for debugging and troubleshooting your workflows.

### External libraries

If you self-host n8n, you can import and use built-in and external npm modules in the Code node. To learn how to enable external modules, refer to the [Enable modules in Code node](../../hosting/configuration/configuration-examples/modules-in-code-node/) guide.

If you use n8n Cloud, you can't import external npm modules. n8n makes two modules available for you:

- [crypto Node.js module](https://nodejs.org/docs/latest-v18.x/api/crypto.html)
- [moment npm package](https://www.npmjs.com/package/moment)

### Built-in methods and variables

n8n provides built-in methods and variables for working with data and accessing n8n data. Refer to [Built-in methods and variables](../builtin/overview/) for more information.

The syntax to use the built-in methods and variables is `$variableName` or `$methodName()`. Type `$` in the Code node or expressions editor to see a list of suggested methods and variables.

### Keyboard shortcuts

The Code node editing environment supports time-saving and useful keyboard shortcuts for a range of operations from autocompletion to code-folding and using multiple-cursors. See the full list of [keyboard shortcuts](../../integrations/builtin/core-nodes/n8n-nodes-base.code/keyboard-shortcuts/).

## Python (Pyodide - legacy)

Pyodide is a legacy feature. Future versions of n8n will no longer support this feature.

n8n added Python support in version 1.0. It doesn't include a Python executable. Instead, n8n provides Python support using [Pyodide](https://pyodide.org/en/stable/), which is a port of CPython to WebAssembly. This limits the available Python packages to the [Packages included with Pyodide](https://pyodide.org/en/stable/usage/packages-in-pyodide.html#packages-in-pyodide). n8n downloads the package automatically the first time you use it.

Slower than JavaScript

The Code node takes longer to process Python than JavaScript. This is due to the extra compilation steps.

### Built-in methods and variables

n8n provides built-in methods and variables for working with data and accessing n8n data. Refer to [Built-in methods and variables](../builtin/overview/) for more information.

The syntax to use the built-in methods and variables is `_variableName` or `_methodName()`. Type `_` in the Code node to see a list of suggested methods and variables.

### Keyboard shortcuts

The Code node editing environment supports time-saving and useful keyboard shortcuts for a range of operations from autocompletion to code-folding and using multiple-cursors. See the full list of [keyboard shortcuts](../../integrations/builtin/core-nodes/n8n-nodes-base.code/keyboard-shortcuts/).

## File system and HTTP requests

You can't access the file system or make HTTP requests. Use the following nodes instead:

- [Read/Write File From Disk](../../integrations/builtin/core-nodes/n8n-nodes-base.readwritefile/)
- [HTTP Request](../../integrations/builtin/core-nodes/n8n-nodes-base.httprequest/)

## Python (Native - beta)

n8n added native Python support using task runners (beta) in version 1.111.0.

Main differences from Pyodide:

- Native Python supports only `_items` in all-items mode and `_item` in per-item mode. It doesn't support other n8n built-in methods and variables.
- Native Python supports importing native Python modules from the standard library and from third-parties, if the `n8nio/runners` image includes them and explicitly allowlists them. See [adding extra dependencies for task runners](../../hosting/configuration/task-runners/#adding-extra-dependencies) for more details.
- Native Python denies insecure built-ins by default. See [task runners environment variables](../../hosting/configuration/environment-variables/task-runners/) for more details.
- Unlike Pyodide, which accepts dot access notation, for example, `item.json.myNewField`, native Python only accepts bracket access notation, for example, `item["json"]["my_new_field"]`. There may be other minor syntax differences where Pyodide accepts constructs that aren't legal in native Python.

Keep in mind upgrading to native Python is a breaking change, so you may need to adjust your Python scripts to use the native Python runner.

This feature is in beta and is subject to change. As it becomes stable, n8n will roll it out progressively to n8n cloud users during 2025. Self-hosting users can [try it out](../../hosting/configuration/task-runners/) and provide feedback.

## Coding in n8n

There are two places where you can use code in n8n: the Code node and the expressions editor. When using either area, there are some key concepts you need to know, as well as some built-in methods and variables to help with common tasks.

### Key concepts

When working with the Code node, you need to understand the following concepts:

- [Data structure](../../data/data-structure/): understand the data you receive in the Code node, and requirements for outputting data from the node.
- [Item linking](../../data/data-mapping/data-item-linking/): learn how data items work, and how to link to items from previous nodes. You need to handle item linking in your code when the number of input and output items doesn't match.

### Built-in methods and variables

n8n includes built-in methods and variables. These provide support for:

- Accessing specific item data
- Accessing data about workflows, executions, and your n8n environment
- Convenience variables to help with data and time

Refer to [Built-in methods and variables](../builtin/overview/) for more information.

## Use AI in the Code node

Feature availability

AI assistance in the Code node is available to Cloud users. It isn't available in self-hosted n8n.

AI generated code overwrites your code

If you've already written some code on the **Code** tab, the AI generated code will replace it. n8n recommends using AI as a starting point to create your initial code, then editing it as needed.

To use ChatGPT to generate code in the Code node:

1. In the Code node, set **Language** to **JavaScript**.
1. Select the **Ask AI** tab.
1. Write your query.
1. Select **Generate Code**. n8n sends your query to ChatGPT, then displays the result in the **Code** tab.

# Expressions

Expressions are a powerful feature implemented in all n8n nodes. They allow node parameters to be set dynamically based on data from:

- Previous node executions
- The workflow
- Your n8n environment

You can also execute JavaScript within an expression, making this a convenient and easy way to manipulate data into useful parameter values without writing extensive extra code.

n8n created and uses a templating language called [Tournament](https://github.com/n8n-io/tournament), and extends it with [custom methods and variables](../builtin/overview/) and [data transformation functions](../builtin/data-transformation-functions/). These features make it easier to perform common tasks like getting data from other nodes or accessing workflow metadata.

n8n additionally supports two libraries:

- [Luxon](https://github.com/moment/luxon/), for working with dates and time.
- [JMESPath](https://jmespath.org/), for querying JSON.

Data in n8n

When writing expressions, it's helpful to understand data structure and behavior in n8n. Refer to [Data](../../data/) for more information on working with data in your workflows.

## Writing expressions

To use an expression to set a parameter value:

1. Hover over the parameter where you want to use an expression.
1. Select **Expressions** in the **Fixed/Expression** toggle.
1. Write your expression in the parameter, or select **Open expression editor** to open the expressions editor. If you use the expressions editor, you can browse the available data in the **Variable selector**. All expressions have the format `{{ your expression here }}`.

### Example: Get data from webhook body

Consider the following scenario: you have a webhook trigger that receives data through the webhook body. You want to extract some of that data for use in the workflow.

Your webhook data looks similar to this:

```
[
  {
    "headers": {
      "host": "n8n.instance.address",
      ...
    },
    "params": {},
    "query": {},
    "body": {
      "name": "Jim",
      "age": 30,
      "city": "New York"
    }
  }
]
```

In the next node in the workflow, you want to get just the value of `city`. You can use the following expression:

```
{{$json.body.city}}
```

This expression:

1. Accesses the incoming JSON-formatted data using n8n's custom `$json` variable.
1. Finds the value of `city` (in this example, "New York"). Note that this example uses JMESPath syntax to query the JSON data. You can also write this expression as `{{$json['body']['city']}}`.

### Example: Writing longer JavaScript

You can do things like variable assignments or multiple statements in an expression, but you need to wrap your code using the syntax for an IIFE (Immediately Invoked Function Expression).

The following code use the Luxon date and time library to find the time between two dates in months. We surround the code in both the handlebar brackets for an expression and the IIFE syntax.

```
{{(()=>{
  let end = DateTime.fromISO('2017-03-13');
  let start = DateTime.fromISO('2017-02-13');
  let diffInMonths = end.diff(start, 'months');
  return diffInMonths.toObject();
})()}}
```

## Common issues

For common errors or issues with expressions and suggested resolution steps, refer to [Common Issues](../cookbook/expressions/common-issues/).

# Custom variables

Feature availability

- Available on Self-hosted Enterprise and Pro Cloud plans.
- Only instance owners and admins can create variables.

Custom variables are read-only variables that you can use to store and reuse values in n8n workflows.

Variable scope and availability

- **Global variables** are available to everyone on your n8n instance, across all projects.
- **Project-scoped variables** are available only within the specific project they're created in.
- Project-scoped variables are available in 1.118.0 and above. Previous versions only support global variables accessible from the left side menu.

## Create variables

You can access the **Variables** tab from either the overview page or a specific project.

To create a new variable:

1. On the **Variables** tab, select **Add Variable**.
1. Enter a **Key** and **Value**. The maximum key length is 50 characters, and the maximum value length is 1000 characters. n8n limits the characters you can use in the key and value to lowercase and uppercase letters, numbers, and underscores (`A-Z`, `a-z`, `0-9`, `_`).
1. Select the **Scope** (only available when creating from the overview page):
   - **Global**: The variable is available across all projects in the n8n instance.
   - **Project**: The variable is available only within a specific project (you can select which project).
   - When creating from a project page, the scope is automatically set to that project.
1. Select **Save**. The variable is now available for use in workflows according to its scope.

## Edit and delete variables

To edit or delete a variable:

1. On the **Variables** tab, hover over the variable you want to change.
1. Select **Edit** or **Delete**.

## Use variables in workflows

You can access variables in the Code node and in [expressions](../../glossary/#expression-n8n):

```
// Access a variable
$vars.<variable-name>
```

All variables are strings.

During workflow execution, n8n replaces the variables with the variable value. If the variable has no value, n8n treats its value as `undefined`. Workflows don't automatically fail in this case.

Variable precedence

When a project-scoped variable has the same key as a global variable, the project-scoped variable value takes precedence and overrides the global variable value within that project's workflows.

Variables are read-only. You must use the UI to change the values. If you need to set and access custom data within your workflow, use [Workflow static data](../cookbook/builtin/get-workflow-static-data/).

# Convenience methods

n8n provides these methods to make it easier to perform common tasks in [expressions](../../../glossary/#expression-n8n).

Python support

You can use Python in the Code node. It isn't available in expressions.

| Method                                                        | Description                                                                                                                                                                                                                                                                                                                                                                                 | Available in Code node? |
| ------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ----------------------- |
| `$evaluateExpression(expression: string, itemIndex?: number)` | Evaluates a string as an expression. If you don't provide `itemIndex`, n8n uses the data from item 0 in the Code node.                                                                                                                                                                                                                                                                      |                         |
| `$ifEmpty(value, defaultValue)`                               | The `$ifEmpty()` function takes two parameters, tests the first to check if it's empty, then returns either the parameter (if not empty) or the second parameter (if the first is empty). The first parameter is empty if it's: - `undefined` - `null` - An empty string `''` - An array where `value.length` returns `false` - An object where `Object.keys(value).length` returns `false` |                         |
| `$if()`                                                       | The `$if()` function takes three parameters: a condition, the value to return if true, and the value to return if false.                                                                                                                                                                                                                                                                    |                         |
| `$max()`                                                      | Returns the highest of the provided numbers.                                                                                                                                                                                                                                                                                                                                                |                         |
| `$min()`                                                      | Returns the lowest of the provided numbers.                                                                                                                                                                                                                                                                                                                                                 |                         |

| Method                                                        | Description                                                                                                                                                                                                                                                                                                                                                                                 |
| ------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| `_evaluateExpression(expression: string, itemIndex?: number)` | Evaluates a string as an expression. If you don't provide `itemIndex`, n8n uses the data from item 0 in the Code node.                                                                                                                                                                                                                                                                      |
| `_ifEmpty(value, defaultValue)`                               | The `_ifEmpty()` function takes two parameters, tests the first to check if it's empty, then returns either the parameter (if not empty) or the second parameter (if the first is empty). The first parameter is empty if it's: - `undefined` - `null` - An empty string `''` - An array where `value.length` returns `false` - An object where `Object.keys(value).length` returns `false` |

# Current node input

Methods for working with the input of the current node. Some methods and variables aren't available in the Code node.

Python support

You can use Python in the Code node. It isn't available in expressions.

| Method                       | Description                                                                                                                                                                                    | Available in Code node?           |
| ---------------------------- | ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | --------------------------------- |
| `$binary`                    | Shorthand for `$input.item.binary`. Incoming binary data from a node                                                                                                                           |                                   |
| `$input.item`                | The input item of the current node that's being processed. Refer to [Item linking](../../../data/data-mapping/data-item-linking/) for more information on paired items and item linking.       |                                   |
| `$input.all()`               | All input items in current node.                                                                                                                                                               |                                   |
| `$input.first()`             | First input item in current node.                                                                                                                                                              |                                   |
| `$input.last()`              | Last input item in current node.                                                                                                                                                               |                                   |
| `$input.params`              | Object containing the query settings of the previous node. This includes data such as the operation it ran, result limits, and so on.                                                          |                                   |
| `$json`                      | Shorthand for `$input.item.json`. Incoming JSON data from a node. Refer to [Data structure](../../../data/data-structure/) for information on item structure.                                  | (when running once for each item) |
| `$input.context.noItemsLeft` | Boolean. Only available when working with the Loop Over Items node. Provides information about what's happening in the node. Use this to determine whether the node is still processing items. |                                   |

| Method                       | Description                                                                                                                                                                                                                  |
| ---------------------------- | ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| `_input.item`                | The input item of the current node that's being processed. Refer to [Item linking](../../../data/data-mapping/data-item-linking/) for more information on paired items and item linking.                                     |
| `_input.all()`               | All input items in current node.                                                                                                                                                                                             |
| `_input.first()`             | First input item in current node.                                                                                                                                                                                            |
| `_input.last()`              | Last input item in current node.                                                                                                                                                                                             |
| `_input.params`              | Object containing the query settings of the previous node. This includes data such as the operation it ran, result limits, and so on.                                                                                        |
| `_json`                      | Shorthand for `_input.item.json`. Incoming JSON data from a node. Refer to [Data structure](../../../data/data-structure/) for information on item structure. Available when you set **Mode** to **Run Once for Each Item**. |
| `_input.context.noItemsLeft` | Boolean. Only available when working with the Loop Over Items node. Provides information about what's happening in the node. Use this to determine whether the node is still processing items.                               |

# Built-in date and time methods

Methods for working with date and time.

Python support

You can use Python in the Code node. It isn't available in expressions.

| Method   | Description                                                                                                                                                      | Available in Code node? |
| -------- | ---------------------------------------------------------------------------------------------------------------------------------------------------------------- | ----------------------- |
| `$now`   | A Luxon object containing the current timestamp. Equivalent to `DateTime.now()`.                                                                                 |                         |
| `$today` | A Luxon object containing the current timestamp, rounded down to the day. Equivalent to `DateTime.now().set({ hour: 0, minute: 0, second: 0, millisecond: 0 })`. |                         |

| Method   | Description                                                                                                                                                      |
| -------- | ---------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| `_now`   | A Luxon object containing the current timestamp. Equivalent to `DateTime.now()`.                                                                                 |
| `_today` | A Luxon object containing the current timestamp, rounded down to the day. Equivalent to `DateTime.now().set({ hour: 0, minute: 0, second: 0, millisecond: 0 })`. |

Don't mix native JavaScript and Luxon dates

While you can use both native JavaScript dates and Luxon dates in n8n, they aren't directly interoperable. It's best to [convert JavaScript dates to Luxon](../../cookbook/luxon/#convert-javascript-dates-to-luxon) to avoid problems.

n8n provides built-in convenience functions to support data transformation in expressions for dates. Refer to [Data transformation functions | Dates](../data-transformation-functions/dates/) for more information.

# HTTP node variables

Variables for working with HTTP node requests and responses when using pagination.

Refer to [HTTP Request](../../../integrations/builtin/core-nodes/n8n-nodes-base.httprequest/) for guidance on using the HTTP node, including configuring pagination.

Refer to [HTTP Request node cookbook | Pagination](../../cookbook/http-node/pagination/) for example pagination configurations.

HTTP node only

These variables are for use in expressions in the HTTP node. You can't use them in other nodes.

| Variable     | Description                                                                                                                                                                                  |
| ------------ | -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| `$pageCount` | The pagination count. Tracks how many pages the node has fetched.                                                                                                                            |
| `$request`   | The request object sent by the HTTP node.                                                                                                                                                    |
| `$response`  | The response object from the HTTP call. Includes `$response.body`, `$response.headers`, and `$response.statusCode`. The contents of `body` and `headers` depend on the data sent by the API. |

# JMESPath method

This is an n8n-provided method for working with the [JMESPath](../../cookbook/jmespath/) library.

Python support

You can use Python in the Code node. It isn't available in expressions.

| Method        | Description                                       | Available in Code node? |
| ------------- | ------------------------------------------------- | ----------------------- |
| `$jmespath()` | Perform a search on a JSON object using JMESPath. |                         |

| Method        | Description                                       |
| ------------- | ------------------------------------------------- |
| `_jmespath()` | Perform a search on a JSON object using JMESPath. |

# LangChain Code node methods

n8n provides these methods to make it easier to perform common tasks in the [LangChain Code node](../../../integrations/builtin/cluster-nodes/root-nodes/n8n-nodes-langchain.code/).

LangChain Code node only

These variables are for use in expressions in the LangChain Code node. You can't use them in other nodes.

| Method                                                           | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             |
| ---------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| `this.addInputData(inputName, data)`                             | Populate the data of a specified non-main input. Useful for mocking data. - `inputName` is the input connection type, and must be one of: `ai_agent`, `ai_chain`, `ai_document`, `ai_embedding`, `ai_languageModel`, `ai_memory`, `ai_outputParser`, `ai_retriever`, `ai_textSplitter`, `ai_tool`, `ai_vectorRetriever`, `ai_vectorStore` - `data` contains the data you want to add. Refer to [Data structure](../../../data/data-structure/) for information on the data structure expected by n8n.   |
| `this.addOutputData(outputName, data)`                           | Populate the data of a specified non-main output. Useful for mocking data. - `outputName` is the input connection type, and must be one of: `ai_agent`, `ai_chain`, `ai_document`, `ai_embedding`, `ai_languageModel`, `ai_memory`, `ai_outputParser`, `ai_retriever`, `ai_textSplitter`, `ai_tool`, `ai_vectorRetriever`, `ai_vectorStore` - `data` contains the data you want to add. Refer to [Data structure](../../../data/data-structure/) for information on the data structure expected by n8n. |
| `this.getInputConnectionData(inputName, itemIndex, inputIndex?)` | Get data from a specified non-main input. - `inputName` is the input connection type, and must be one of: `ai_agent`, `ai_chain`, `ai_document`, `ai_embedding`, `ai_languageModel`, `ai_memory`, `ai_outputParser`, `ai_retriever`, `ai_textSplitter`, `ai_tool`, `ai_vectorRetriever`, `ai_vectorStore` - `itemIndex` should always be `0` (this parameter will be used in upcoming functionality) - Use `inputIndex` if there is more than one node connected to the specified input.                |
| `this.getInputData(inputIndex?, inputName?)`                     | Get data from the main input.                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |
| `this.getNode()`                                                 | Get the current node.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   |
| `this.getNodeOutputs()`                                          | Get the outputs of the current node.                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |
| `this.getExecutionCancelSignal()`                                | Use this to stop the execution of a function when the workflow stops. In most cases n8n handles this, but you may need to use it if building your own chains or agents. It replaces the [Cancelling a running LLMChain](https://js.langchain.com/docs/modules/chains/foundational/llm_chain#cancelling-a-running-llmchain) code that you'd use if building a LangChain application normally.                                                                                                            |

# n8n metadata

Methods for working with n8n metadata.

This includes:

- Access to n8n environment variables for self-hosted n8n.
- Metadata about workflows, executions, and nodes.
- Information about instance [Variables](../../variables/) and [External secrets](../../../external-secrets/).

Python support

You can use Python in the Code node. It isn't available in expressions.

| Method                         | Description                                                                                                                                                                                                                                                 | Available in Code node? |
| ------------------------------ | ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ----------------------- |
| `$env`                         | Contains n8n instance configuration [environment variables](../../../hosting/configuration/environment-variables/).                                                                                                                                         |                         |
| `$execution.customData`        | Set and get custom execution data. Refer to [Custom executions data](../../../workflows/executions/custom-executions-data/) for more information.                                                                                                           |                         |
| `$execution.id`                | The unique ID of the current workflow execution.                                                                                                                                                                                                            |                         |
| `$execution.mode`              | Whether the execution was triggered automatically, or by manually running the workflow. Possible values are `test` and `production`.                                                                                                                        |                         |
| `$execution.resumeUrl`         | The webhook URL to call to resume a workflow waiting at a [Wait node](../../../integrations/builtin/core-nodes/n8n-nodes-base.wait/).                                                                                                                       |                         |
| `$getWorkflowStaticData(type)` | View an [example](../../cookbook/builtin/get-workflow-static-data/). Static data doesn't persist when testing workflows. The workflow must be active and called by a trigger or webhook to save static data. This gives access to the static workflow data. |                         |
| `$("<node-name>").isExecuted`  | Check whether a node has already executed.                                                                                                                                                                                                                  |                         |
| `$itemIndex`                   | The index of an item in a list of items.                                                                                                                                                                                                                    |                         |
| `$nodeVersion`                 | Get the version of the current node.                                                                                                                                                                                                                        |                         |
| `$prevNode.name`               | The name of the node that the current input came from. When using the Merge node, note that `$prevNode` always uses the first input connector.                                                                                                              |                         |
| `$prevNode.outputIndex`        | The index of the output connector that the current input came from. Use this when the previous node had multiple outputs (such as an If or Switch node). When using the Merge node, note that `$prevNode` always uses the first input connector.            |                         |
| `$prevNode.runIndex`           | The run of the previous node that generated the current input. When using the Merge node, note that `$prevNode` always uses the first input connector.                                                                                                      |                         |
| `$runIndex`                    | How many times n8n has executed the current node. Zero-based (the first run is 0, the second is 1, and so on).                                                                                                                                              |                         |
| `$secrets`                     | Contains information about your [External secrets](../../../external-secrets/) setup.                                                                                                                                                                       |                         |
| `$vars`                        | Contains the [Variables](../../variables/) available in the active environment.                                                                                                                                                                             |                         |
| `$version`                     | The node version.                                                                                                                                                                                                                                           |                         |
| `$workflow.active`             | Whether the workflow is active (true) or not (false).                                                                                                                                                                                                       |                         |
| `$workflow.id`                 | The workflow ID.                                                                                                                                                                                                                                            |                         |
| `$workflow.name`               | The workflow name.                                                                                                                                                                                                                                          |                         |

| Method   | Description                                                           |
| -------- | --------------------------------------------------------------------- |
| `_items` | Contains incoming items in "Run once for all items" mode.             |
| `_item`  | Contains the item being iterated on in "Run once for each item" mode. |

| Method                         | Description                                                                                                                                                                                                                                                 |
| ------------------------------ | ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| `_env`                         | Contains n8n instance configuration [environment variables](../../../hosting/configuration/environment-variables/).                                                                                                                                         |
| `_execution.customData`        | Set and get custom execution data. Refer to [Custom executions data](../../../workflows/executions/custom-executions-data/) for more information.                                                                                                           |
| `_execution.id`                | The unique ID of the current workflow execution.                                                                                                                                                                                                            |
| `_execution.mode`              | Whether the execution was triggered automatically, or by manually running the workflow. Possible values are `test` and `production`.                                                                                                                        |
| `_execution.resumeUrl`         | The webhook URL to call to resume a workflow waiting at a [Wait node](../../../integrations/builtin/core-nodes/n8n-nodes-base.wait/).                                                                                                                       |
| `_getWorkflowStaticData(type)` | View an [example](../../cookbook/builtin/get-workflow-static-data/). Static data doesn't persist when testing workflows. The workflow must be active and called by a trigger or webhook to save static data. This gives access to the static workflow data. |
| `_("<node-name>").isExecuted`  | Check whether a node has already executed.                                                                                                                                                                                                                  |
| `_nodeVersion`                 | Get the version of the current node.                                                                                                                                                                                                                        |
| `_prevNode.name`               | The name of the node that the current input came from. When using the Merge node, note that `_prevNode` always uses the first input connector.                                                                                                              |
| `_prevNode.outputIndex`        | The index of the output connector that the current input came from. Use this when the previous node had multiple outputs (such as an If or Switch node). When using the Merge node, note that `_prevNode` always uses the first input connector.            |
| `_prevNode.runIndex`           | The run of the previous node that generated the current input. When using the Merge node, note that `_prevNode` always uses the first input connector.                                                                                                      |
| `_runIndex`                    | How many times n8n has executed the current node. Zero-based (the first run is 0, the second is 1, and so on).                                                                                                                                              |
| `_secrets`                     | Contains information about your [External secrets](../../../external-secrets/) setup.                                                                                                                                                                       |
| `_vars`                        | Contains the [Variables](../../variables/) available in the active environment.                                                                                                                                                                             |
| `_workflow.active`             | Whether the workflow is active (true) or not (false).                                                                                                                                                                                                       |
| `_workflow.id`                 | The workflow ID.                                                                                                                                                                                                                                            |
| `_workflow.name`               | The workflow name.                                                                                                                                                                                                                                          |

# Output of other nodes

Methods for working with the output of other nodes. Some methods and variables aren't available in the Code node.

Python support

You can use Python in the Code node. It isn't available in expressions.

| Method                                                 | Description                                                                                                                                                                                            | Available in Code node? |
| ------------------------------------------------------ | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------ | ----------------------- |
| `$("<node-name>").all(branchIndex?, runIndex?)`        | Returns all items from a given node. If `branchIndex` isn't given it will default to the output that connects `node-name` with the node where you use the expression or code.                          |                         |
| `$("<node-name>").first(branchIndex?, runIndex?)`      | The first item output by the given node. If `branchIndex` isn't given it will default to the output that connects `node-name` with the node where you use the expression or code.                      |                         |
| `$("<node-name>").last(branchIndex?, runIndex?)`       | The last item output by the given node. If `branchIndex` isn't given it will default to the output that connects `node-name` with the node where you use the expression or code.                       |                         |
| `$("<node-name>").item`                                | The linked item. This is the item in the specified node used to produce the current item. Refer to [Item linking](../../../data/data-mapping/data-item-linking/) for more information on item linking. |                         |
| `$("<node-name>").params`                              | Object containing the query settings of the given node. This includes data such as the operation it ran, result limits, and so on.                                                                     |                         |
| `$("<node-name>").context`                             | Boolean. Only available when working with the Loop Over Items node. Provides information about what's happening in the node. Use this to determine whether the node is still processing items.         |                         |
| `$("<node-name>").itemMatching(currentNodeInputIndex)` | Use instead of `$("<node-name>").item` in the Code node if you need to trace back from an input item.                                                                                                  |                         |

| Method                                                 | Description                                                                                                                                                                                                               | Available in Code node? |
| ------------------------------------------------------ | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ----------------------- |
| `_("<node-name>").all(branchIndex?, runIndex?)`        | Returns all items from a given node. If `branchIndex` isn't given it will default to the output that connects`node-name` with the node where you use the expression or code.                                              |                         |
| `_("<node-name>").first(branchIndex?, runIndex?)`      | The first item output by the given node. If `branchIndex` isn't given it will default to the output that connects`node-name` with the node where you use the expression or code.                                          |                         |
| `_("<node-name>").last(branchIndex?, runIndex?)`       | The last item output by the given node. If `branchIndex` isn't given it will default to the output that connects`node-name` with the node where you use the expression or code.                                           |                         |
| `_("<node-name>").item`                                | The linked item. This is the item in the specified node used to produce the current item. Refer to [Item linking](../../../data/data-mapping/data-item-linking/) for more information on item linking.                    |                         |
| `_("<node-name>").params`                              | Object containing the query settings of the given node. This includes data such as the operation it ran, result limits, and so on.                                                                                        |                         |
| `_("<node-name>").context`                             | Boolean. Only available when working with the Loop Over Items node. Provides information about what's happening in the node. Use this to determine whether the node is still processing items.                            |                         |
| `_("<node-name>").itemMatching(currentNodeInputIndex)` | Use instead of `_("<node-name>").item` in the Code node if you need to trace back from an input item. Refer to [Retrieve linked items from earlier in the workflow](../../cookbook/builtin/itemmatching/) for an example. |                         |

# Built-in methods and variables

n8n provides built-in methods and variables for working with data and accessing n8n data. This section provides a reference of available methods and variables for use in [expressions](../../../glossary/#expression-n8n), with a short description.

Availability in the expressions editor and the Code node

Some methods and variables aren't available in the Code node. These aren't in the documentation.

All data transformation functions are only available in the expressions editor.

The [Cookbook](../../) contains examples for some common tasks, including some [Code node only](../../cookbook/code-node/) functions.

- [Current node input](/code/builtin/current-node-input/)
- [Output of other nodes](/code/builtin/output-other-nodes/)
- [Date and time](/code/builtin/date-time/)
- [JMESPath](/code/builtin/jmespath/)
- [HTTP node](/code/builtin/http-node-variables/)
- [LangChain Code node](/code/builtin/langchain-methods/)
- [n8n metadata](/code/builtin/n8n-metadata/)
- [Convenience methods](/code/builtin/convenience/)
- [Data transformation functions](/code/builtin/data-transformation-functions/)

# Data transformation functions

Data transformation functions are helper functions to make data transformation easier in [expressions](../../../glossary/#expression-n8n).

JavaScript in expressions

You can use any JavaScript in expressions. Refer to [Expressions](../../expressions/) for more information.

For a list of available functions, refer to the page for your data type:

- [Arrays](arrays/)
- [Dates](dates/)
- [Numbers](numbers/)
- [Objects](objects/)
- [Strings](strings/)

## Usage

Data transformation functions are available in the expressions editor.

The syntax is:

```
{{ dataItem.function() }}
```

For example, to check if a string is an email:

```
{{ "example@example.com".isEmail() }}

// Returns true
```

# Arrays

A reference document listing built-in convenience functions to support data transformation in [expressions](../../../../glossary/#expression-n8n) for arrays.

JavaScript in expressions

You can use any JavaScript in expressions. Refer to [Expressions](../../../expressions/) for more information.

### average(): Number

Returns the value of elements in an array

______________________________________________________________________

### chunk(size: Number): Array

Splits arrays into chunks with a length of size

#### Function parameters

sizeRequiredNumber

The size of each chunk.

______________________________________________________________________

### compact(): Array

Removes empty values from the array.

______________________________________________________________________

### difference(arr: Array): Array

Compares two arrays. Returns all elements in the base array that aren't present in arr.

#### Function parameters

arrRequiredArray

The array to compare to the base array.

______________________________________________________________________

### intersection(arr: Array): Array

Compares two arrays. Returns all elements in the base array that are present in arr.

#### Function parameters

arrRequiredArray

The array to compare to the base array.

______________________________________________________________________

### first(): Array item

Returns the first element of the array.

______________________________________________________________________

### isEmpty(): Boolean

Checks if the array doesn't have any elements.

______________________________________________________________________

### isNotEmpty(): Boolean

Checks if the array has elements.

______________________________________________________________________

### last(): Array item

Returns the last element of the array.

______________________________________________________________________

### max(): Number

Returns the highest value in an array.

______________________________________________________________________

### merge(arr: Array): Array

Merges two Object-arrays into one array by merging the key-value pairs of each element.

#### Function parameters

arrRequiredArray

The array to merge into the base array.

______________________________________________________________________

### min(): Number

Gets the minimum value from a number-only array.

______________________________________________________________________

### pluck(fieldName?: String): Array

Returns an array of Objects where keys equal the given field names.

#### Function parameters

fieldNameOptionalString

The key(s) you want to retrieve. You can enter as many keys as you want, as comma-separated strings.

______________________________________________________________________

### randomItem(): Array item

Returns a random element from an array.

______________________________________________________________________

### removeDuplicates(key?: String): Array

Removes duplicates from an array.

#### Function parameters

keyOptionalString

A key, or comma-separated list of keys, to check for duplicates.

______________________________________________________________________

### renameKeys(from: String, to: String): Array

Renames all matching keys in the array. You can rename more than one key by entering a series of comma separated strings, in the pattern oldKeyName, newKeyName.

#### Function parameters

fromRequiredString

The key you want to rename.

toRequiredString

The new name.

______________________________________________________________________

### smartJoin(keyField: String, nameField: String): Array

Operates on an array of objects where each object contains key-value pairs. Creates a new object containing key-value pairs, where the key is the value of the first pair, and the value is the value of the second pair. Removes non-matching and empty values and trims any whitespace before joining.

#### Function parameters

keyFieldRequiredString

The key to join.

nameFieldRequiredString

The value to join.

#### Example

##### Basic usage

```
// Input
{{ [{"type":"fruit", "name":"apple"},{"type":"vegetable", "name":"carrot"} ].smartJoin("type","name") }}
// Output
[Object: {"fruit":"apple","vegetable":"carrot"}]
```

______________________________________________________________________

### sum(): Number

Returns the total sum all the values in an array of parsable numbers.

______________________________________________________________________

### toJsonString(): String

Convert an array to a JSON string. Equivalent of `JSON.stringify`.

______________________________________________________________________

### union(arr: Array): Array

Concatenates two arrays and then removes duplicate.

#### Function parameters

arrRequiredArray

The array to compare to the base array.

______________________________________________________________________

### unique(key?: String): Array

Remove duplicates from an array.

#### Function parameters

keyOptionalString

A key, or comma-separated list of keys, to check for duplicates.

______________________________________________________________________

# Booleans

A reference document listing built-in convenience functions to support data transformation in [expressions](../../../../glossary/#expression-n8n) for arrays.

JavaScript in expressions

You can use any JavaScript in expressions. Refer to [Expressions](../../../expressions/) for more information.

### toInt(): Number

Convert a boolean to a number. `false` converts to `0`, `true` converts to `1`.

______________________________________________________________________

# Dates

A reference document listing built-in convenience functions to support data transformation in [expressions](../../../../glossary/#expression-n8n) for dates.

JavaScript in expressions

You can use any JavaScript in expressions. Refer to [Expressions](../../../expressions/) for more information.

### beginningOf(unit?: DurationUnit): Date

Transforms a Date to the start of the given time period. Returns either a JavaScript Date or Luxon Date, depending on input.

#### Function parameters

unitOptionalString enum

A valid string specifying the time unit.

Default: `week`

One of: `second`, `minute`, `hour`, `day`, `week`, `month`, `year`

______________________________________________________________________

### endOfMonth(): Date

Transforms a Date to the end of the month.

______________________________________________________________________

### extract(datePart?: DurationUnit): Number

Extracts the part defined in datePart from a Date. Returns either a JavaScript Date or Luxon Date, depending on input.

#### Function parameters

datePartOptionalString enum

A valid string specifying the time unit.

Default: `week`

One of: `second`, `minute`, `hour`, `day`, `week`, `month`, `year`

______________________________________________________________________

### format(fmt: TimeFormat): String

Formats a Date in the given structure

#### Function parameters

fmtRequiredString enum

A valid string specifying the time format. Refer to [Luxon | Table of tokens](https://moment.github.io/luxon/#/formatting?id=table-of-tokens) for formats.

______________________________________________________________________

### isBetween(date1: Date | DateTime, date2: Date | DateTime): Boolean

Checks if a Date is between two given dates.

#### Function parameters

date1RequiredDate or DateTime

The first date in the range.

date2RequiredDate or DateTime

The last date in the range.

______________________________________________________________________

### isDst(): Boolean

Checks if a Date is within Daylight Savings Time.

______________________________________________________________________

### isInLast(n?: Number, unit?: DurationUnit): Boolean

Checks if a Date is within a given time period.

#### Function parameters

nOptionalNumber

The number of units. For example, to check if the date is in the last nine weeks, enter 9.

Default: `0`

unitOptionalString enum

A valid string specifying the time unit.

Default: `minutes`

One of: `second`, `minute`, `hour`, `day`, `week`, `month`, `year`

______________________________________________________________________

### isWeekend(): Boolean

Checks if the Date falls on a Saturday or Sunday.

______________________________________________________________________

### minus(n: Number, unit?: DurationUnit): Date

Subtracts a given time period from a Date. Returns either a JavaScript Date or Luxon Date, depending on input.

#### Function parameters

nRequiredNumber

The number of units. For example, to subtract nine seconds, enter 9 here.

unitOptionalString enum

A valid string specifying the time unit.

Default: `milliseconds`

One of: `second`, `minute`, `hour`, `day`, `week`, `month`, `year`

______________________________________________________________________

### plus(n: Number, unit?: DurationUnit): Date

Adds a given time period to a Date. Returns either a JavaScript Date or Luxon Date, depending on input.

#### Function parameters

nRequiredNumber

The number of units. For example, to add nine seconds, enter 9 here.

unitOptionalString enum

A valid string specifying the time unit.

Default: `milliseconds`

One of: `second`, `minute`, `hour`, `day`, `week`, `month`, `year`

______________________________________________________________________

### toDateTime(): Date

Converts a JavaScript date to a [Luxon date object](https://docs.n8n.io/code/cookbook/luxon/).

______________________________________________________________________

# Numbers

A reference document listing built-in convenience functions to support data transformation in [expressions](../../../../glossary/#expression-n8n) for numbers.

JavaScript in expressions

You can use any JavaScript in expressions. Refer to [Expressions](../../../expressions/) for more information.

### ceil(): Number

Rounds up a number to a whole number.

______________________________________________________________________

### floor(): Number

Rounds down a number to a whole number.

______________________________________________________________________

### format(locales?: LanguageCode, options?: FormatOptions): String

This is a wrapper around [Intl.NumberFormat()](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Intl/NumberFormat/NumberFormat). Returns a formatted string of a number based on the given LanguageCode and FormatOptions. When no arguments are given, transforms the number in a like format 1.234.

#### Function parameters

localesOptionalString

An IETF BCP 47 language tag.

Default: `en-US`

optionsOptionalObject

Configure options for number formatting. Refer to [MDN | Intl.NumberFormat()](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Intl/NumberFormat/NumberFormat) for more information.

______________________________________________________________________

### isEven(): Boolean

Returns true if the number is even. Only works on whole numbers.

______________________________________________________________________

### isOdd(): Boolean

Returns true if the number is odd. Only works on whole numbers.

______________________________________________________________________

### round(decimalPlaces?: Number): Number

Returns the value of a number rounded to the nearest whole number, unless a decimal place is specified.

#### Function parameters

decimalPlacesOptionalNumber

How many decimal places to round to.

Default: `0`

______________________________________________________________________

### toBoolean(): Boolean

Converts a number to a boolean. `0` converts to `false`. All other values convert to `true`.

______________________________________________________________________

### toDateTime(format?: String): Date

Converts a number to a [Luxon date object](https://docs.n8n.io/code/cookbook/luxon/).

#### Function parameters

formatOptionalString enum

Can be `ms` (milliseconds), `s` (seconds), or `excel` (Excel 1900). Defaults to milliseconds.

______________________________________________________________________

# Objects

A reference document listing built-in convenience functions to support data transformation in expressions for objects.

JavaScript in expressions

You can use any JavaScript in expressions. Refer to [Expressions](../../../expressions/) for more information.

### isEmpty(): Boolean

Checks if the Object has no key-value pairs.

______________________________________________________________________

### merge(object: Object): Object

Merges two Objects into a single Object using the first as the base Object. If a key exists in both Objects, the key in the base Object takes precedence.

#### Function parameters

objectRequiredObject

The Object to merge with the base Object.

______________________________________________________________________

### hasField(fieldName: String): Boolean

Checks if the Object has a given field. Only top-level keys are supported.

#### Function parameters

fieldNameRequiredString

The field to search for.

______________________________________________________________________

### removeField(key: String): Object

Removes a given field from the Object

#### Function parameters

keyRequiredString

The field key of the field to remove.

______________________________________________________________________

### removeFieldsContaining(value: String): Object

Removes fields with a given value from the Object.

#### Function parameters

valueRequiredString

The field value of the field to remove.

______________________________________________________________________

### keepFieldsContaining(value: String): Object

Removes fields that do not match the given value from the Object.

#### Function parameters

valueRequiredString

The field value of the field to keep.

______________________________________________________________________

### compact(): Object

Removes empty values from an Object.

______________________________________________________________________

### toJsonString(): String

Convert an object to a JSON string. Equivalent of `JSON.stringify`.

______________________________________________________________________

### urlEncode(): String

Transforms an Object into a URL parameter list. Only top-level keys are supported.

______________________________________________________________________

# Strings

A reference document listing built-in convenience functions to support data transformation in [expressions](../../../../glossary/#expression-n8n) for strings.

JavaScript in expressions

You can use any JavaScript in expressions. Refer to [Expressions](../../../expressions/) for more information.

### base64Encode(): A base64 encoded string.

Encode a string as base64.

______________________________________________________________________

### base64Decode(): A plain string.

Convert a base64 encoded string to a normal string.

______________________________________________________________________

### extractDomain(): String

Extracts a domain from a string containing a valid URL. Returns undefined if none is found.

______________________________________________________________________

### extractEmail(): String

Extracts an email from a string. Returns undefined if none is found.

______________________________________________________________________

### extractUrl(): String

Extracts a URL from a string. Returns undefined if none is found.

______________________________________________________________________

### extractUrlPath(): String

Extract the path but not the root domain from a URL. For example, `"https://example.com/orders/1/details".extractUrlPath()` returns `"/orders/1/details/"`.

______________________________________________________________________

### hash(algo?: Algorithm): String

Returns a string hashed with the given algorithm.

#### Function parameters

algoOptionalString enum

Which hashing algorithm to use.

Default: `md5`

One of: `md5`, `base64`, `sha1`, `sha224`, `sha256`, `sha384`, `sha512`, `sha3`, `ripemd160`

______________________________________________________________________

### isDomain(): Boolean

Checks if a string is a domain.

______________________________________________________________________

### isEmail(): Boolean

Checks if a string is an email.

______________________________________________________________________

### isEmpty(): Boolean

Checks if a string is empty.

______________________________________________________________________

### isNotEmpty(): Boolean

Checks if a string has content.

______________________________________________________________________

### isNumeric(): Boolean

Checks if a string only contains digits.

______________________________________________________________________

### isUrl(): Boolean

Checks if a string is a valid URL.

______________________________________________________________________

### parseJson(): Object

Equivalent of `JSON.parse()`. Parses a string as a JSON object.

______________________________________________________________________

### quote(mark?: String): String

Returns a string wrapped in the quotation marks. Default quotation is `"`.

#### Function parameters

markOptionalString

Which quote mark style to use.

Default: `"`

______________________________________________________________________

### removeMarkdown(): String

Removes Markdown formatting from a string.

______________________________________________________________________

### replaceSpecialChars(): String

Replaces non-ASCII characters in a string with an ASCII representation.

______________________________________________________________________

### removeTags(): String

Remove tags, such as HTML or XML, from a string.

______________________________________________________________________

### toBoolean(): Boolean

Convert a string to a boolean. `"false"`, `"0"`, `""`, and `"no"` convert to `false`.

______________________________________________________________________

### toDateTime(): Date

Converts a string to a [Luxon date object](https://docs.n8n.io/code/cookbook/luxon/).

______________________________________________________________________

### toDecimalNumber(): Number

See [toFloat](#string-toFloat)

______________________________________________________________________

### toFloat(): Number

Converts a string to a decimal number.

______________________________________________________________________

### toInt(): Number

Converts a string to an integer.

______________________________________________________________________

### toSentenceCase(): String

Formats a string to sentence case.

______________________________________________________________________

### toSnakeCase(): String

Formats a string to snake case.

______________________________________________________________________

### toTitleCase(): String

Formats a string to title case. Will not change already uppercase letters to prevent losing information from acronyms and trademarks such as iPhone or FAANG.

______________________________________________________________________

### toWholeNumber(): Number

Converts a string to a whole number.

______________________________________________________________________

### urlDecode(entireString?: Boolean): String

Decodes a URL-encoded string. It decodes any percent-encoded characters in the input string, and replaces them with their original characters.

#### Function parameters

entireStringOptionalBoolean

Whether to decode characters that are part of the URI syntax (true) or not (false).

______________________________________________________________________

### urlEncode(entireString?: Boolean): String

Encodes a string to be used/included in a URL.

#### Function parameters

entireStringOptionalBoolean

Whether to encode characters that are part of the URI syntax (true) or not (false).

______________________________________________________________________

# Query JSON with JMESPath

[JMESPath](https://jmespath.org/) is a query language for JSON that you can use to extract and transform elements from a JSON document. For full details of how to use JMESPath, refer to the [JMESPath documentation](https://jmespath.org/tutorial.html).

## The `jmespath()` method

n8n provides a custom method, `jmespath()`. Use this method to perform a search on a JSON object using the JMESPath query language.

The basic syntax is:

```
$jmespath(object, searchString)
```

```
_jmespath(object, searchString)
```

To help understand what the method does, here is the equivalent longer JavaScript:

```
var jmespath = require('jmespath');
jmespath.search(object, searchString);
```

Expressions must be single-line

The longer code example doesn't work in Expressions, as they must be single-line.

`object` is a JSON object, such as the output of a previous node. `searchString` is an expression written in the JMESPath query language. The [JMESPath Specification](https://jmespath.org/specification.html#jmespath-specification) provides a list of supported expressions, while their [Tutorial](https://jmespath.org/tutorial.html) and [Examples](https://jmespath.org/examples.html) provide interactive examples.

Search parameter order

The examples in the [JMESPath Specification](https://jmespath.org/specification.html#jmespath-specification) follow the pattern `search(searchString, object)`. The [JMESPath JavaScript library](https://github.com/jmespath/jmespath.js/), which n8n uses, supports `search(object, searchString)` instead. This means that when using examples from the JMESPath documentation, you may need to change the order of the search function parameters.

## Common tasks

This section provides examples for some common operations. More examples, and detailed guidance, are available in [JMESPath's own documentation](https://jmespath.org/tutorial.html).

When trying out these examples, you need to set the Code node **Mode** to **Run Once for Each Item**.

### Apply a JMESPath expression to a collection of elements with projections

From the [JMESPath projections documentation](https://jmespath.org/tutorial.html#projections):

> Projections are one of the key features of JMESPath. Use it to apply an expression to a collection of elements. JMESPath supports five kinds of projections:
>
> - List Projections
> - Slice Projections
> - Object Projections
> - Flatten Projections
> - Filter Projections

The following example shows basic usage of list, slice, and object projections. Refer to the [JMESPath projections documentation](https://jmespath.org/tutorial.html#projections) for detailed explanations of each projection type, and more examples.

Given this JSON from a webhook node:

```
[
  {
    "headers": {
      "host": "n8n.instance.address",
      ...
    },
    "params": {},
    "query": {},
    "body": {
      "people": [
        {
          "first": "James",
          "last": "Green"
        },
        {
          "first": "Jacob",
          "last": "Jones"
        },
        {
          "first": "Jayden",
          "last": "Smith"
        }
      ],
      "dogs": {
        "Fido": {
          "color": "brown",
          "age": 7
        },
        "Spot": {
          "color": "black and white",
          "age": 5
        }
      }
    }
  }
]
```

Retrieve a [list](https://jmespath.org/tutorial.html#list-and-slice-projections) of all the people's first names:

```
{{$jmespath($json.body.people, "[*].first" )}}
// Returns ["James", "Jacob", "Jayden"]
```

```
let firstNames = $jmespath($json.body.people, "[*].first" )
return {firstNames};
/* Returns:
[
	{
		"firstNames": [
			"James",
			"Jacob",
			"Jayden"
		]
	}
]
*/
```

```
firstNames = _jmespath(_json.body.people, "[*].first" )
return {"firstNames":firstNames}
"""
Returns:
[
 	{
		"firstNames": [
			"James",
			"Jacob",
			"Jayden"
		]
	}
]
"""
```

Get a [slice](https://jmespath.org/tutorial.html#list-and-slice-projections) of the first names:

```
{{$jmespath($json.body.people, "[:2].first")}}
// Returns ["James", "Jacob"]
```

```
let firstTwoNames = $jmespath($json.body.people, "[:2].first");
return {firstTwoNames};
/* Returns:
[
	{
		"firstNames": [
			"James",
			"Jacob",
			"Jayden"
		]
	}
]
*/
```

```
firstTwoNames = _jmespath(_json.body.people, "[:2].first" )
return {"firstTwoNames":firstTwoNames}
"""
Returns:
[
	{
		"firstTwoNames": [
		"James",
		"Jacob"
		]
	}
]
"""
```

Get a list of the dogs' ages using [object projections](https://jmespath.org/tutorial.html#object-projections):

```
{{$jmespath($json.body.dogs, "*.age")}}
// Returns [7,5]
```

```
let dogsAges = $jmespath($json.body.dogs, "*.age");
return {dogsAges};
/* Returns:
[
	{
		"dogsAges": [
			7,
			5
		]
	}
]
*/
```

```
dogsAges = _jmespath(_json.body.dogs, "*.age")
return {"dogsAges": dogsAges}
"""
Returns:
[
	{
		"dogsAges": [
			7,
			5
		]
	}
]
"""
```

### Select multiple elements and create a new list or object

Use [Multiselect](https://jmespath.org/tutorial.html#multiselect) to select elements from a JSON object and combine them into a new list or object.

Given this JSON from a webhook node:

```
[
  {
    "headers": {
      "host": "n8n.instance.address",
      ...
    },
    "params": {},
    "query": {},
    "body": {
      "people": [
        {
          "first": "James",
          "last": "Green"
        },
        {
          "first": "Jacob",
          "last": "Jones"
        },
        {
          "first": "Jayden",
          "last": "Smith"
        }
      ],
      "dogs": {
        "Fido": {
          "color": "brown",
          "age": 7
        },
        "Spot": {
          "color": "black and white",
          "age": 5
        }
      }
    }
  }
]
```

Use multiselect list to get the first and last names and create new lists containing both names:

```
{{$jmespath($json.body.people, "[].[first, last]")}}
// Returns [["James","Green"],["Jacob","Jones"],["Jayden","Smith"]]
```

```
let newList = $jmespath($json.body.people, "[].[first, last]");
return {newList};
/* Returns:
[
	{
		"newList": [
			[
				"James",
				"Green"
			],
			[
				"Jacob",
				"Jones"
			],
			[
				"Jayden",
				"Smith"
			]
		]
	}
]
*/
```

```
newList = _jmespath(_json.body.people, "[].[first, last]")
return {"newList":newList}
"""
Returns:
[
	{
		"newList": [
			[
				"James",
				"Green"
			],
			[
				"Jacob",
				"Jones"
			],
			[
				"Jayden",
				"Smith"
			]
		]
	}
]
"""
```

### An alternative to arrow functions in expressions

For example, generate some input data by returning the below code from the Code node:

```
return[
  {
    "json": {      
      "num_categories": "0",
      "num_products": "45",
      "category_id": 5529735,
      "parent_id": 1407340,
      "pos_enabled": 1,
      "pos_favorite": 0,
      "name": "HP",
      "description": "",
      "image": ""
    }
  },
  {
    "json": {
      "num_categories": "0",
      "num_products": "86",
      "category_id": 5529740,
      "parent_id": 1407340,
      "pos_enabled": 1,
      "pos_favorite": 0,
      "name": "Lenovo",
      "description": "",
      "image": ""
    }
  }  
]
```

You could do a search like "find the item with the name Lenovo and tell me their category ID."

```
{{ $jmespath($("Code").all(), "[?json.name=='Lenovo'].json.category_id") }}
```

# Date and time with Luxon

[Luxon](https://github.com/moment/luxon/) is a JavaScript library that makes it easier to work with date and time. For full details of how to use Luxon, refer to [Luxon's documentation](https://moment.github.io/luxon/#/?id=luxon).

n8n passes dates between nodes as strings, so you need to parse them. Luxon makes this easier.

Python support

Luxon is a JavaScript library. The two convenience [variables](#get-the-current-datetime-or-date) created by n8n are available when using Python in the Code node, but their functionality is limited:

- You can't perform Luxon operations on these variables. For example, there is no Python equivalent for `$today.minus(...)`.
- The generic Luxon functionality, such as [Convert date string to Luxon](#convert-date-string-to-luxon), isn't available for Python users.

## Date and time behavior in n8n

Be aware of the following:

- In a workflow, n8n converts dates and times to strings between nodes. Keep this in mind when doing arithmetic on dates and times from other nodes.
- With vanilla JavaScript, you can convert a string to a date with `new Date('2019-06-23')`. In Luxon, you must use a function explicitly stating the format, such as `DateTime.fromISO('2019-06-23')` or `DateTime.fromFormat("23-06-2019", "dd-MM-yyyy")`.

## Setting the timezone in n8n

Luxon uses the n8n timezone. This value is either:

- Default: `America/New York`
- A custom timezone for your n8n instance, set using the `GENERIC_TIMEZONE` environment variable.
- A custom timezone for an individual workflow, configured in workflow settings.

## Common tasks

This section provides examples for some common operations. More examples, and detailed guidance, are available in [Luxon's own documentation](https://moment.github.io/luxon/#/?id=luxon).

### Get the current datetime or date

Use the [`$now` and `$today` Luxon objects](../../builtin/date-time/) to get the current time or day:

- `now`: a Luxon object containing the current timestamp. Equivalent to `DateTime.now()`.
- `today`: a Luxon object containing the current timestamp, rounded down to the day. Equivalent to `DateTime.now().set({ hour: 0, minute: 0, second: 0, millisecond: 0 })`.

Note that these variables can return different time formats when cast as a string:

```
{{$now}}
// n8n displays the ISO formatted timestamp
// For example 2022-03-09T14:02:37.065+00:00
{{"Today's date is " + $now}}
// n8n displays "Today's date is <unix timestamp>"
// For example "Today's date is 1646834498755"
```

```
$now
// n8n displays <ISO formatted timestamp>
// For example 2022-03-09T14:00:25.058+00:00
let rightNow = "Today's date is " + $now
// n8n displays "Today's date is <unix timestamp>"
// For example "Today's date is 1646834498755"
```

```
_now
# n8n displays <ISO formatted timestamp>
# For example 2022-03-09T14:00:25.058+00:00
rightNow = "Today's date is " + str(_now)
# n8n displays "Today's date is <unix timestamp>"
# For example "Today's date is 1646834498755"
```

n8n provides built-in convenience functions to support data transformation in expressions for dates. Refer to [Data transformation functions | Dates](../../builtin/data-transformation-functions/dates/) for more information.

### Convert JavaScript dates to Luxon

To convert a native JavaScript date to a Luxon date:

- In expressions, use the [`.toDateTime()` method](../../builtin/data-transformation-functions/dates/#date-toDateTime). For example, `{{ (new Date()).ToDateTime() }}`.
- In the Code node, use `DateTime.fromJSDate()`. For example, `let luxondate = DateTime.fromJSDate(new Date())`.

### Convert date string to Luxon

You can convert date strings and other date formats to a Luxon DateTime object. You can convert from standard formats and from arbitrary strings.

A difference between Luxon DateTime and JavaScript Date

With vanilla JavaScript, you can convert a string to a date with `new Date('2019-06-23')`. In Luxon, you must use a function explicitly stating the format, such as `DateTime.fromISO('2019-06-23')` or `DateTime.fromFormat("23-06-2019", "dd-MM-yyyy")`.

#### If you have a date in a supported standard technical format:

Most dates use `fromISO()`. This creates a Luxon DateTime from an ISO 8601 string. For example:

```
{{DateTime.fromISO('2019-06-23T00:00:00.00')}}
```

```
let luxonDateTime = DateTime.fromISO('2019-06-23T00:00:00.00')
```

Luxon's API documentation has more information on [fromISO](https://moment.github.io/luxon/api-docs/index.html#datetimefromiso).

Luxon provides functions to handle conversions for a range of formats. Refer to Luxon's guide to [Parsing technical formats](https://moment.github.io/luxon/#/parsing?id=parsing-technical-formats) for details.

#### If you have a date as a string that doesn't use a standard format:

Use Luxon's [Ad-hoc parsing](https://moment.github.io/luxon/#/parsing?id=ad-hoc-parsing). To do this, use the `fromFormat()` function, providing the string and a set of [tokens](https://moment.github.io/luxon/#/parsing?id=table-of-tokens) that describe the format.

For example, you have n8n's founding date, 23rd June 2019, formatted as `23-06-2019`. You want to turn this into a Luxon object:

```
{{DateTime.fromFormat("23-06-2019", "dd-MM-yyyy")}}
```

```
let newFormat = DateTime.fromFormat("23-06-2019", "dd-MM-yyyy")
```

When using ad-hoc parsing, note Luxon's warning about [Limitations](https://moment.github.io/luxon/#/parsing?id=limitations). If you see unexpected results, try their [Debugging](https://moment.github.io/luxon/#/parsing?id=debugging) guide.

### Get n days from today

Get a number of days before or after today.

For example, you want to set a field to always show the date seven days before the current date.

In the expressions editor, enter:

```
{{$today.minus({days: 7})}}
```

On the 23rd June 2019, this returns `[Object: "2019-06-16T00:00:00.000+00:00"]`.

This example uses n8n's custom variable `$today` for convenience. It's the equivalent of `DateTime.now().set({ hour: 0, minute: 0, second: 0, millisecond: 0 }).minus({days: 7})`.

For example, you want a variable containing the date seven days before the current date.

In the code editor, enter:

```
let sevenDaysAgo = $today.minus({days: 7})
```

On the 23rd June 2019, this returns `[Object: "2019-06-16T00:00:00.000+00:00"]`.

This example uses n8n's custom variable `$today` for convenience. It's the equivalent of `DateTime.now().set({ hour: 0, minute: 0, second: 0, millisecond: 0 }).minus({days: 7})`.

For more detailed information and examples, refer to:

- Luxon's [guide to math](https://moment.github.io/luxon/#/math)
- Their API documentation on [DateTime plus](https://moment.github.io/luxon/api-docs/index.html#datetimeplus) and [DateTime minus](https://moment.github.io/luxon/api-docs/index.html#datetimeminus)

### Create human-readable dates

In [Get n days from today](#get-n-days-from-today), the example gets the date seven days before the current date, and returns it as `[Object: "yyyy-mm-dd-T00:00:00.000+00:00"]` (for expressions) or `yyyy-mm-dd-T00:00:00.000+00:00` (in the Code node). To make this more readable, you can use Luxon's formatting functions.

For example, you want the field containing the date to be formatted as DD/MM/YYYY, so that on the 23rd June 2019, it returns `23/06/2019`.

This expression gets the date seven days before today, and converts it to the DD/MM/YYYY format.

```
{{$today.minus({days: 7}).toLocaleString()}}
```

```
let readableSevenDaysAgo = $today.minus({days: 7}).toLocaleString()
```

You can alter the format. For example:

```
{{$today.minus({days: 7}).toLocaleString({month: 'long', day: 'numeric', year: 'numeric'})}}
```

On 23rd June 2019, this returns "16 June 2019".

```
let readableSevenDaysAgo = $today.minus({days: 7}).toLocaleString({month: 'long', day: 'numeric', year: 'numeric'})
```

On 23rd June 2019, this returns "16 June 2019".

Refer to Luxon's guide on [toLocaleString (strings for humans)](https://moment.github.io/luxon/#/formatting?id=tolocalestring-strings-for-humans) for more information.

### Get the time between two dates

To get the time between two dates, use Luxon's diffs feature. This subtracts one date from another and returns a duration.

For example, get the number of months between two dates:

```
{{DateTime.fromISO('2019-06-23').diff(DateTime.fromISO('2019-05-23'), 'months').toObject()}}
```

This returns `[Object: {"months":1}]`.

```
let monthsBetweenDates = DateTime.fromISO('2019-06-23').diff(DateTime.fromISO('2019-05-23'), 'months').toObject()
```

This returns `{"months":1}`.

Refer to Luxon's [Diffs](https://moment.github.io/luxon/#/math?id=diffs) for more information.

### A longer example: How many days to Christmas?

This example brings together several Luxon features, uses JMESPath, and does some basic string manipulation.

The scenario: you want a countdown to 25th December. Every day, it should tell you the number of days remaining to Christmas. You don't want to update it for next year - it needs to seamlessly work for every year.

```
{{"There are " + $today.diff(DateTime.fromISO($today.year + '-12-25'), 'days').toObject().days.toString().substring(1) + " days to Christmas!"}}
```

This outputs `"There are <number of days> days to Christmas!"`. For example, on 9th March, it outputs "There are 291 days to Christmas!".

A detailed explanation of what the expression does:

- `{{`: indicates the start of the expression.
- `"There are "`: a string.
- `+`: used to join two strings.
- `$today.diff()`: This is similar to the example in [Get the time between two dates](#get-the-time-between-two-dates), but it uses n8n's custom `$today` variable.
- `DateTime.fromISO($today.year + '-12-25'), 'days'`: this part gets the current year using `$today.year`, turns it into an ISO string along with the month and date, and then takes the whole ISO string and converts it to a Luxon DateTime data structure. It also tells Luxon that you want the duration in days.
- `toObject()` turns the result of diff() into a more usable object. At this point, the expression returns `[Object: {"days":-<number-of-days>}]`. For example, on 9th March, `[Object: {"days":-291}]`.
- `.days` uses JMESPath syntax to retrieve just the number of days from the object. For more information on using JMESPath with n8n, refer to our [JMESpath](../jmespath/) documentation. This gives you the number of days to Christmas, as a negative number.
- `.toString().substring(1)` turns the number into a string and removes the `-`.
- `+ " days to Christmas!"`: another string, with a `+` to join it to the previous string.
- `}}`: indicates the end of the expression.

```
let daysToChristmas = "There are " + $today.diff(DateTime.fromISO($today.year + '-12-25'), 'days').toObject().days.toString().substring(1) + " days to Christmas!";
```

This outputs `"There are <number of days> days to Christmas!"`. For example, on 9th March, it outputs "There are 291 days to Christmas!".

A detailed explanation of what the code does:

- `"There are "`: a string.
- `+`: used to join two strings.
- `$today.diff()`: This is similar to the example in [Get the time between two dates](#get-the-time-between-two-dates), but it uses n8n's custom `$today` variable.
- `DateTime.fromISO($today.year + '-12-25'), 'days'`: this part gets the current year using `$today.year`, turns it into an ISO string along with the month and date, and then takes the whole ISO string and converts it to a Luxon DateTime data structure. It also tells Luxon that you want the duration in days.
- `toObject()` turns the result of diff() into a more usable object. At this point, the expression returns `[Object: {"days":-<number-of-days>}]`. For example, on 9th March, `[Object: {"days":-291}]`.
- `.days` uses JMESPath syntax to retrieve just the number of days from the object. For more information on using JMESPath with n8n, refer to our [JMESpath](../jmespath/) documentation. This gives you the number of days to Christmas, as a negative number.
- `.toString().substring(1)` turns the number into a string and removes the `-`.
- `+ " days to Christmas!"`: another string, with a `+` to join it to the previous string.

# Examples using n8n's built-in methods and variables

n8n provides built-in methods and variables for working with data and accessing n8n data. This section provides usage examples.

- [execution](/code/cookbook/builtin/execution/)
- [getWorkflowStaticData](/code/cookbook/builtin/get-workflow-static-data/)
- [Retrieve linked items from earlier in the workflow](/code/cookbook/builtin/itemmatching/)
- [(node-name).all](/code/cookbook/builtin/all/)
- [vars](/code/cookbook/builtin/vars/)

## Related resources

- [Built-in methods and variables reference](../../builtin/overview/)
- [Expressions](../../expressions/)
- [Code node](../../code-node/)

# `("<node-name>").all(branchIndex?: number, runIndex?: number)`

This gives access to all the items of the current or parent nodes. If you don't supply any parameters, it returns all the items of the current node.

## Getting items

```
// Returns all the items of the given node and current run
let allItems = $("<node-name>").all();

// Returns all items the node "IF" outputs (index: 0 which is Output "true" of its most recent run)
let allItems = $("IF").all();

// Returns all items the node "IF" outputs (index: 0 which is Output "true" of the same run as current node)
let allItems = $("IF").all(0, $runIndex);

// Returns all items the node "IF" outputs (index: 1 which is Output "false" of run 0 which is the first run)
let allItems = $("IF").all(1, 0);
```

```
# Returns all the items of the given node and current run
allItems = _("<node-name>").all();

# Returns all items the node "IF" outputs (index: 0 which is Output "true" of its most recent run)
allItems = _("IF").all();

# Returns all items the node "IF" outputs (index: 0 which is Output "true" of the same run as current node)
allItems = _("IF").all(0, _runIndex);

# Returns all items the node "IF" outputs (index: 1 which is Output "false" of run 0 which is the first run)
allItems = _("IF").all(1, 0);
```

## Accessing item data

Get all items output by a previous node, and log out the data they contain:

```
previousNodeData = $("<node-name>").all();
for(let i=0; i<previousNodeData.length; i++) {
	console.log(previousNodeData[i].json);
}
```

```
previousNodeData = _("<node-name>").all();
for item in previousNodeData:
	# item is of type <class 'pyodide.ffi.JsProxy'>
	# You need to convert it to a Dict
	itemDict = item.json.to_py()
	print(itemDict)
```

# `execution`

## `execution.id`

Contains the unique ID of the current workflow execution.

```
let executionId = $execution.id;
```

```
executionId = _execution.id
```

## `execution.resumeUrl`

The webhook URL to call to resume a [waiting](../../../../integrations/builtin/core-nodes/n8n-nodes-base.wait/) workflow.

See the [Wait > On webhook call](../../../../integrations/builtin/core-nodes/n8n-nodes-base.wait/#on-webhook-call) documentation to learn more.

`execution.resumeUrl` is available in workflows containing a Wait node, along with a node that waits for a webhook response.

## `execution.customData`

This is only available in the Code node.

```
// Set a single piece of custom execution data
$execution.customData.set("key", "value");

// Set the custom execution data object
$execution.customData.setAll({"key1": "value1", "key2": "value2"})

// Access the current state of the object during the execution
var customData = $execution.customData.getAll()

// Access a specific value set during this execution
var customData = $execution.customData.get("key")
```

```
# Set a single piece of custom execution data
_execution.customData.set("key", "value");

# Set the custom execution data object
_execution.customData.setAll({"key1": "value1", "key2": "value2"})

# Access the current state of the object during the execution
customData = _execution.customData.getAll()

# Access a specific value set during this execution
customData = _execution.customData.get("key")
```

Refer to [Custom executions data](../../../../workflows/executions/custom-executions-data/) for more information.

______________________________________________________________________

# `getWorkflowStaticData(type)`

This gives access to the static workflow data.

Experimental feature

- Static data isn't available when testing workflows. The workflow must be active and called by a [trigger](../../../../glossary/#trigger-node-n8n) or webhook to save static data.
- This feature may behave unreliably under high-frequency workflow executions.

You can save data directly in the workflow. This data should be small.

As an example: you can save a timestamp of the last item processed from an RSS feed or database. It will always return an object. Properties can then read, delete or set on that object. When the workflow execution succeeds, n8n checks automatically if the data has changed and saves it, if necessary.

There are two types of static data, global and node. Global static data is the same in the whole workflow. Every node in the workflow can access it. The node static data is unique to the node. Only the node that set it can retrieve it again.

Example with global data:

```
// Get the global workflow static data
const workflowStaticData = $getWorkflowStaticData('global');

// Access its data
const lastExecution = workflowStaticData.lastExecution;

// Update its data
workflowStaticData.lastExecution = new Date().getTime();

// Delete data
delete workflowStaticData.lastExecution;
```

```
# Get the global workflow static data
workflowStaticData = _getWorkflowStaticData('global')

# Access its data
lastExecution = workflowStaticData.lastExecution

# Update its data
workflowStaticData.lastExecution = new Date().getTime()

# Delete data
delete workflowStaticData.lastExecution
```

Example with node data:

```
// Get the static data of the node
const nodeStaticData = $getWorkflowStaticData('node');

// Access its data
const lastExecution = nodeStaticData.lastExecution;

// Update its data
nodeStaticData.lastExecution = new Date().getTime();

// Delete data
delete nodeStaticData.lastExecution;
```

```
# Get the static data of the node
nodeStaticData = _getWorkflowStaticData('node')

# Access its data
lastExecution = nodeStaticData.lastExecution

# Update its data
nodeStaticData.lastExecution = new Date().getTime()

# Delete data
delete nodeStaticData.lastExecution
```

## Templates and examples

[View template details](https://n8n.io/workflows/2538-demo-workflow-how-to-use-workflowstaticdata/)

# Retrieve linked items from earlier in the workflow

Every item in a node's input data links back to the items used in previous nodes to generate it. This is useful if you need to retrieve linked items from further back than the immediate previous node.

To access the linked items from earlier in the workflow, use `("<node-name>").itemMatching(currentNodeinputIndex)`.

For example, consider a workflow that does the following:

1. The Customer Datastore node generates example data:

   ```
   [
   	{
   		"id": "23423532",
   		"name": "Jay Gatsby",
   		"email": "gatsby@west-egg.com",
   		"notes": "Keeps asking about a green light??",
   		"country": "US",
   		"created": "1925-04-10"
   	},
   	{
   		"id": "23423533",
   		"name": "José Arcadio Buendía",
   		"email": "jab@macondo.co",
   		"notes": "Lots of people named after him. Very confusing",
   		"country": "CO",
   		"created": "1967-05-05"
   	},
   	...
   ]
   ```

1. The Edit Fields node simplifies this data:

   ```
   [
   	{
   		"name": "Jay Gatsby"
   	},
   	{
   		"name": "José Arcadio Buendía"
   	},
       ...
   ]
   ```

1. The Code node restore the email address to the correct person:

   ```
   [
   	{
   		"name": "Jay Gatsby",
   		"restoreEmail": "gatsby@west-egg.com"
   	},
   	{
   		"name": "José Arcadio Buendía",
   		"restoreEmail": "jab@macondo.co"
   	},
   	...
   ]
   ```

The Code node does this using the following code:

```
for(let i=0; i<$input.all().length; i++) {
	$input.all()[i].json.restoreEmail = $('Customer Datastore (n8n training)').itemMatching(i).json.email;
}
return $input.all();
```

```
for i,item in enumerate(_input.all()):
	_input.all()[i].json.restoreEmail = _('Customer Datastore (n8n training)').itemMatching(i).json.email

return _input.all();
```

You can view and download the example workflow from [n8n website | itemMatchin usage example](https://n8n.io/workflows/1966-itemmatching-usage-example/) .

# `vars`

Feature availability

- Available on Self-hosted Enterprise and Pro and Enterprise Cloud plans.
- You need access to the n8n instance owner account to create variables.

`vars` contains all [Variables](../../../variables/) for the active environment. It's read-only: you can access variables using `vars`, but must set them using the UI.

```
// Access a variable
$vars.<variable-name>
```

```
# Access a variable
_vars.<variable-name>
```

`vars` and `env`

`vars` gives access to user-created variables. It's part of the [Environments](../../../../source-control-environments/) feature. `env` gives access to the [configuration environment variables](../../../../hosting/configuration/environment-variables/) for your n8n instance.

# Code node cookbook

This section contains examples and recipes for tasks you can do with the Code node.

- [Get number of items returned by last node](/code/cookbook/code-node/number-items-last-node/)
- [Get the binary data buffer](/code/cookbook/code-node/get-binary-data-buffer/)
- [Output to the browser console](/code/cookbook/code-node/console-log/)

## Related resources

- [Built-in methods and variables reference](../../builtin/overview/)
- [Code node](../../code-node/)

# Output to the browser console with `console.log()` or `print()` in the Code node

You can use `console.log()` or `print()` in the Code node to help when writing and debugging your code.

For help opening your browser console, refer to [this guide by Balsamiq](https://balsamiq.com/support/faqs/browserconsole/).

## console.log (JavaScript)

For technical information on `console.log()`, refer to the [MDN developer docs](https://developer.mozilla.org/en-US/docs/Web/API/Console/log).

For example, copy the following code into a Code node, then open your console and run the node:

```
let a = "apple";
console.log(a);
```

## print (Python)

For technical information on `print()`, refer to the [Real Python's guide](https://realpython.com/python-print/).

For example, set your Code node **Language** to **Python**, copy the following code into the node, then open your console and run the node:

```
a = "apple"
print(a)
```

### Handling an output of `[object Object]`

If the console displays `[object Object]` when you print, check the data type, then convert it as needed.

To check the data type:

```
print(type(myData))
```

#### JsProxy

If `type()` outputs `<class 'pyodide.ffi.JsProxy'>`, you need to convert the JsProxy to a native Python object using `to_py()`. This occurs when working with data in the n8n node data structure, such as node inputs and outputs. For example, if you want to print the data from a previous node in the workflow:

```
previousNodeData = _("<node-name>").all();
for item in previousNodeData:
	# item is of type <class 'pyodide.ffi.JsProxy'>
	# You need to convert it to a Dict
	itemDict = item.json.to_py()
	print(itemDict)
```

Refer to the Pyodide documentation on [JsProxy](https://pyodide.org/en/stable/usage/api/python-api/ffi.html#pyodide.ffi.JsProxy) for more information on this class.

# Get the binary data buffer

The binary data buffer contains all the binary file data processed by a workflow. You need to access it if you want to perform operations on the binary data, such as:

- Manipulating the data: for example, adding column headers to a CSV file.
- Using the data in calculations: for example, calculating a hash value based on it.
- Complex HTTP requests: for example, combining file upload with sending other data formats.

Not available in Python

`getBinaryDataBuffer()` isn't supported when using Python.

You can access the buffer using n8n's `getBinaryDataBuffer()` function:

```
/* 
* itemIndex: number. The index of the item in the input data.
* binaryPropertyName: string. The name of the binary property. 
* The default in the Read/Write File From Disk node is 'data'. 
*/
let binaryDataBufferItem = await this.helpers.getBinaryDataBuffer(itemIndex, binaryPropertyName);
```

For example:

```
let binaryDataBufferItem = await this.helpers.getBinaryDataBuffer(0, 'data');
// Returns the data in the binary buffer for the first input item
```

You should always use the `getBinaryDataBuffer()` function, and avoid using older methods of directly accessing the buffer, such as targeting it with expressions like `items[0].binary.data.data`.

# Get number of items returned by the previous node

To get the number of items returned by the previous node:

```
if (Object.keys(items[0].json).length === 0) {
return [
	{
		json: {
			results: 0,
		}
	}
]
}
return [
	{
		json: {
			results: items.length,
		}
	}
];
```

The output will be similar to the following.

```
[
	{
		"results": 8
	}
]
```

```
if len(items[0].json) == 0:
	return [
		{
			"json": {
				"results": 0,
			}
		}
	]
else:
	return [
		{
			"json": {
				"results": items.length,
			}
		}
	]
```

The output will be similar to the following.

```
[
	{
		"results": 8
	}
]
```

# Expressions cookbook

This section contains examples and recipes for tasks you can do with [expressions](../../../glossary/#expression-n8n).

Python support

You can use Python in the Code node. It isn't available in expressions.

- [Check incoming data](/code/cookbook/expressions/check-incoming-data/)
- [Common issues](/code/cookbook/expressions/common-issues/)

## Related resources

- [Built-in methods and variables reference](../../builtin/overview/)
- [Expressions](../../expressions/)

# Check incoming data

At times, you may want to check the incoming data. If the incoming data doesn't match a condition, you may want to return a different value. For example, you want to check if a variable from the previous node is empty and return a string if it's empty. Use the following code snippet to return `not found` if the variable is empty.

```
{{$json["variable_name"]? $json["variable_name"] :"not found"}}
```

The above expression uses the ternary operator. You can learn more about the ternary operator [here](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/Conditional_Operator).

As an alternative, you can use the [nullish coalescing operator (??)](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/Nullish_coalescing) or the [logical or operator (||)](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/Logical_OR):

```
{{ $x ?? "default value" }}
{{ $x || "default value" }}
```

In either of the above two cases, the value of `$x` will be used if it's set to a non-null, non-false value. The string `default value` is the fallback value.

# Expressions common issues

Here are some common errors and issues related to [expressions](../../../expressions/) and steps to resolve or troubleshoot them.

## The 'JSON Output' in item 0 contains invalid JSON

This error occurs when you use JSON mode but don't provide a valid JSON object. Depending on the problem with the JSON object, the error sometimes display as `The 'JSON Output' in item 0 does not contain a valid JSON object`.

To resolve this, make sure that the code you provide is valid JSON:

- Check the JSON with a [JSON validator](https://jsonlint.com/).
- Check that your JSON object doesn't reference undefined input data. This may occur if the incoming data doesn't always include the same fields.

## Can't get data for expression

This error occurs when n8n can't retrieve the data referenced by an expression. Often, this happens when the preceding node hasn't been run yet.

Another variation of this may appear as `Referenced node is unexecuted`. In that case, the full text of this error will tell you the exact node that isn't executing in this format:

> An expression references the node '<node-name>', but it hasn’t been executed yet. Either change the expression, or re-wire your workflow to make sure that node executes first.

To begin troubleshooting, test the workflow up to the named node.

For nodes that use JavaScript or other custom code, you can check if a previous node has executed before trying to use its value by checking the following:

```
$("<node-name>").isExecuted
```

As an example, this JSON references the parameters of the input data. This error will display if you test this step without connecting it to another node:

```
{
  "my_field_1": {{ $input.params }}
}
```

## Invalid syntax

This error occurs when you use an expression that has a syntax error.

For example, the expression in this JSON includes a trailing period, which results in an invalid syntax error:

```
{
  "my_field_1": "value",
  "my_field_2": {{ $('If').item.json. }}
}
```

To resolve this error, check your [expression syntax](../../../expressions/) to make sure they follow the expected format.

# Examples using n8n's HTTP Request node

The HTTP Request node is one of the most versatile nodes in n8n. Use this node to make HTTP requests to query data from any app or service with a REST API.

Refer to [HTTP Request](../../../integrations/builtin/core-nodes/n8n-nodes-base.httprequest/) for information on node settings.

- [Pagination](/code/cookbook/http-node/pagination/)

## Related resources

- [HTTP Request](../../../integrations/builtin/core-nodes/n8n-nodes-base.httprequest/)
- [Built-in methods and variables reference](../../builtin/overview/)
- [Expressions](../../expressions/)

# Pagination in the HTTP Request node

The HTTP Request node supports pagination. This page provides some example configurations, including using the [HTTP node variables](../../../builtin/http-node-variables/).

Refer to [HTTP Request](../../../../integrations/builtin/core-nodes/n8n-nodes-base.httprequest/) for more information on the node.

API differences

Different APIs implement pagination in different ways. Check the API documentation for the API you're using for details. You need to find out things like:

- Does the API provide the URL for the next page?
- Are there API-specific limits on page size or page number?
- The structure of the data that the API returns.

## Enable pagination

In the HTTP Request node, select **Add Option** > **Pagination**.

## Use a URL from the response to get the next page using `$response`

If the API returns the URL of the next page in its response:

1. Set **Pagination Mode** to **Response Contains Next URL**. n8n displays the parameters for this option.

1. In **Next URL**, use an [expression](../../../../glossary/#expression-n8n) to set the URL. The exact expression depends on the data returned by your API. For example, if the API includes a parameter called `next-page` in the response body:

   ```
   {{ $response.body["next-page"] }}
   ```

## Get the next page by number using `$pageCount`

If the API you're using supports targeting a specific page by number:

1. Set **Pagination Mode** to **Update a Parameter in Each Request**.
1. Set **Type** to **Query**.
1. Enter the **Name** of the query parameter. This depends on your API and is usually described in its documentation. For example, some APIs use a query parameter named `page` to set the page. So **Name** would be `page`.
1. Hover over **Value** and toggle **Expression** on.
1. Enter `{{ $pageCount + 1 }}`

`$pageCount` is the number of pages the HTTP Request node has fetched. It starts at zero. Most API pagination counts from one (the first page is page one). This means that adding `+1` to `$pageCount` means the node fetches page one on its first loop, page two on its second, and so on.

## Navigate pagination through body parameters

If the API you're using allows you to paginate through the body parameters:

1. Set the HTTP Request Method to **POST**
1. Set **Pagination Mode** to **Update a Parameter in Each Request**.
1. Select **Body** in the **Type** parameter.
1. Enter the **Name** of the body parameter. This depends on the API you're using. `page` is a common key name.
1. Hover over **Value** and toggle **Expression** on.
1. Enter `{{ $pageCount + 1 }}`

## Set the page size in the query

If the API you're using supports choosing the page size in the query:

1. Select **Send Query Parameters** in main node parameters (this is the parameters you see when you first open the node, not the settings within options).
1. Enter the **Name** of the query parameter. This depends on your API. For example, a lot of APIs use a query parameter named `limit` to set page size. So **Name** would be `limit`.
1. In **Value**, enter your page size.

# Text courses

If you've found your way here, it means you're serious about your interest in automation. Maybe you're tired of manually entering data into the same spreadsheet every day, of clicking through a series of tabs and buttons for that one piece of information you need, of managing tens of different tools and systems.

Whatever the reason, one thing is clear: you shouldn't spend precious time doing things that don't spark joy or contribute to your personal and professional growth.

These tasks can and should be automated! And you don't need advanced technical knowledge or excellent coding skills to do this–with no-code tools like n8n, automation is for everyone.

## Available courses

- [Level 1: Beginner course](level-one/)
- [Level 2: Intermediate course](level-two/)

# Level one: Introduction

Welcome to the **n8n Course Level 1**!

## Is this course right for me?

This course introduces you to the fundamental concepts within n8n and develops your low-code automation expertise.

This course is for you if you:

- Are starting to use n8n for the first time.
- Are looking for some extra help creating your first workflow.
- Want to automate processes in your personal or working life.

This course introduces n8n concepts and demonstrates practical workflow building without assuming any prior familiarity with n8n. If you'd like to get a feel for the basics without as much explanation, consult our [quickstart guide](../../try-it-out/tutorial-first-workflow/).

## What will I learn in this course?

We believe in learning by doing. You can expect some theoretical information about the basic concepts and components of n8n, followed by practice of building workflows step by step.

By the end of this course you will know:

- How to set up n8n and navigate the Editor UI.
- How n8n structures data.
- How to configure different node parameters and add credentials.
- When and how to use conditional logic in workflows.
- How to schedule and control workflows.
- How to import, download, and share workflows with others.

You will build two workflows:

- A two-node workflow to get articles from Hacker News
- A seven-node workflow to help your client get records from a data warehouse, filter them, make calculations, and notify team members about the results

## What do I need to get started?

1. **n8n set up**: You can use [n8n Cloud](../../manage-cloud/overview/) (or the [self-hosted version](../../hosting/installation/docker/) if you have experience hosting services).
1. **A course user ID**: [Sign up here](https://n8n-community.typeform.com/to/PDEMrevI) to get your unique ID and other credentials you will need in this course (Level 1).
1. Basic knowledge of JavaScript and [APIs](https://blog.n8n.io/what-are-apis-how-to-use-them-with-no-code/) would be helpful, but isn't necessary.
1. An [account on the n8n community forum](https://community.n8n.io/) if you wish to receive a profile badge and avatar upon successful completion.

## How long does the course take?

Completing the course should take around **two hours**. You don't have to complete it in one go; feel free to take breaks and resume whenever you are ready.

## How do I complete the course?

There are two milestones in this course that test your knowledge of what you have learned in the lessons:

- Building the [main workflow](chapter-5/chapter-5.1/)
- Passing the [quiz](https://n8n-community.typeform.com/to/JMoBXeGA) at the end of the course

Check your progress

You can always **check your progress** throughout the course by entering your unique ID [here](https://internal.users.n8n.cloud/webhook/course-level-1/verify).

If you complete the milestones above, you will get [**a badge and an avatar**](https://community.n8n.io/badges/104/completed-n8n-course-level-1) in your forum profile. You can then share your profile and course verification ID to showcase your n8n skills to others.

[Let's get started!](chapter-1/)

# Navigating the Editor UI

In this lesson you will learn how to navigate the [Editor UI](../../../glossary/#editor-n8n). We will walk through the [canvas](../../../glossary/#canvas-n8n) and show you what each icon means and where to find things you will need while building workflows in n8n.

n8n version

This course is based on n8n version 1.82.1. In other versions, some user interfaces might look different, but this shouldn't impact the core functionality.

## Getting started

Begin by setting up n8n.

We recommend starting with [n8n Cloud](https://app.n8n.cloud/register), a hosted solution that doesn't require installation and includes a free trial.

Alternative set up

If n8n Cloud isn't a good option for you, you can [self-host with Docker](../../../hosting/installation/docker/). This is an advanced option recommended only for technical users familiar with hosting services, Docker, and the command line.

For more details on the different ways to set up n8n, see our [platforms documentation](../../../choose-n8n/#platforms).

Once you have n8n running, open the Editor UI in a browser window. Log in to your n8n instance. Select **Overview** and then **Create Workflow** to view the main canvas.

It should look like this:

*Editor UI*

## Editor UI settings

The editor UI is the web interface where you build [workflows](../../../workflows/). You can access all your workflows and [credentials](../../../glossary/#credential-n8n), as well as support pages, from the Editor UI.

### Left-side panel

On the left side of the **Editor UI**, there is a panel which contains the core functionalities and settings for managing your workflows. Expand and collapse it by selecting the small arrow icon.

The panel contains the following sections:

- **Overview**: Contains all the workflows, credentials, and executions you have access to. During this course, create new workflows here.
- **Personal**: Every user gets a default personal project. If you don’t create a custom project, your workflows and credentials are stored here.
- **Projects**: Projects let you group workflows and credentials together. You can assign [roles](../../../user-management/rbac/role-types/) to users in a project to control what they can do. Projects aren’t available on the Community edition.
- **Admin Panel**: n8n Cloud only. Access your n8n instance usage, billing, and version settings.
- **Templates**: A collection of pre-made workflows. Great place to get started with common use cases.
- **Variables**: Used to store and access fixed data across your workflows. This feature is available on the Pro and Enterprise Plans.
- **Insights**: Provides analytics and insights about your workflows.
- **Help**: Contains resources around n8n product and community.
- **What’s New**: Shows the latest product updates and features.

*Editor UI left-side menu*

### Top bar

The top bar of the **Editor UI** contains the following information:

- **Workflow Name**: By default, n8n names a new workflow as "My workflow", but you can edit the name at any time.
- **+ Add Tag**: Tags help you organise your workflows by category, use case, or whatever is relevant for you. Tags are optional.
- **Inactive/active toggle**: This button activates or deactivates the current workflow. By default, workflows are deactivated.
- **Share**: You can share and collaborate with others on workflows on the Starter, Pro, and Enterprise plans.
- **Save**: This button saves the current workflow.
- **History**: Once you save your workflow, you can view previous versions here.

*Editor UI top bar*

### Canvas

The **canvas** is the gray dotted grid background in the Editor UI. It displays several icons and a node with different functionalities:

- Buttons to zoom the canvas to fit the screen, zoom in or out of the canvas, reset zoom, and tidy up the nodes on screen.
- A button to **Execute workflow** once you add your first node. When you click on it, n8n executes all nodes on the canvas in sequence.
- A button with a **+** sign inside. This button opens the nodes panel.
- A button with a note icon inside. This button adds a [sticky note](../../../workflows/components/sticky-notes/) to the canvas (visible when hovering on the top right + icon).
- A button labeled **Ask Assistant** appears on the right side of the canvas. You can ask the AI Assistant for help with building workflows.
- A dotted square with the text "Add first step." This is where you add your first node.

*Workflow canvas*

Moving the canvas

You can move the workflow canvas around in three ways:

- Select `Ctrl`+`Left Button` on the canvas and move it around.
- Select `Middle Button` on the canvas and move it around.
- Place two fingers on your touchpad and slide.

Don't worry about workflow execution and activation for now; we'll explain these concepts later on in the course.

## Nodes

You can think of nodes as building blocks that serve different functions that, when put together, make up a functioning machine: an automated workflow.

Node

A node is an individual step in your workflow: one that either (a) loads, (b) processes, or (c) sends data.

Based on their function, n8n classifies nodes into four types:

- **App** or **Action Nodes** add, remove, and edit data; request and send external data; and trigger events in other systems. Refer to the [Action nodes library](../../../integrations/builtin/app-nodes/) for a full list of these nodes.
- **Trigger Nodes** start a workflow and supply the initial data. Refer to the [Trigger nodes library](../../../integrations/builtin/trigger-nodes/) for a list of trigger nodes.
- **Core Nodes** can be trigger or app nodes. Whereas most nodes connect to a specific external service, core nodes provide functionality such as logic, scheduling, or generic API calls. Refer to the [Core Nodes library](../../../integrations/builtin/core-nodes/) for a full list of core nodes.
- **Cluster Nodes** are node groups that work together to provide functionality in a workflow, primarily for AI workflows. Refer to [Cluster nodes](../../../integrations/builtin/cluster-nodes/) for more information.

Learn more

Refer to [Node types](../../../integrations/builtin/node-types/) for a more detailed explanation of all node types.

### Finding nodes

You can find all available nodes in the **nodes panel** on the right side of the Editor UI. There are three ways in which you can open the nodes panel:

- Click the **+** icon in the top right corner of the canvas.
- Click the **+** icon on the right side of an existing node on the canvas (the node to which you want to add another one).
- Click the `Tab` key on your keyboard.

*Nodes panel*

In the nodes panel, notice that when adding your first node, you will see the different trigger node categories. After you have added your trigger node, you'll see that the nodes panel changes to show Advanced AI, Actions in an App, Data transformation, Flow, Core, and Human in the loop nodes.

If you want to find a specific node, use the search input at the top of the nodes panel.

### Adding nodes

There are two ways to add nodes to your canvas:

- Select the node you want in the nodes panel. The new node will automatically connect to the selected node on the canvas.
- Drag and drop the node from the nodes panel to the canvas.

### Node buttons

If you hover on a node, you'll notice that three icons appear on top:

- Execute the node (Play icon)
- Deactivate/Activate the node (Power icon)
- Delete the node (Trash icon)

There will also be an ellipsis icon, which opens a context menu containing other [node options](../../../workflows/components/nodes/#node-controls).

Moving a workflow

To move a workflow around the canvas, select all nodes with your mouse or `Ctrl`+`A`, select and hold on a node, then drag it to any point you want on the canvas.

## Summary

In this lesson you learned how to navigate the Editor UI, what the icons mean, how to access the left-side and node panels, and how to add nodes to the canvas.

In the next lesson, you will build a mini-workflow to put into practice what you've learned so far.

# Building a Mini-workflow

In this lesson, you will build a small [workflow](../../../glossary/#workflow-n8n) that gets 10 articles about automation from Hacker News. The process consists of five steps:

1. [Add a Manual Trigger node](#1-add-a-manual-trigger-node)
1. [Add the Hacker News node](#2-add-the-hacker-news-node)
1. [Configure the Hacker News node](#3-configure-the-hacker-news-node)
1. [Execute the node](#4-execute-the-node)
1. [Save the workflow](#5-save-the-workflow)

The finished workflow will look like this:

[View workflow file](/_workflows//courses/level-one/chapter-2.json)

## 1. Add a Manual Trigger node

Open the nodes panel (reminder: you can open this by selecting the **+** icon in the top right corner of the [canvas](../../../glossary/#canvas-n8n) or selecting `Tab` on your keyboard).

Then:

1. Search for the **Manual Trigger** node.
1. Select it when it appears in the search.

This will add the [Manual Trigger](../../../integrations/builtin/core-nodes/n8n-nodes-base.manualworkflowtrigger/) node to your canvas, which allows you to run the workflow at any time by selecting the **Execute workflow** button.

Manual triggers

For faster workflow creation, you can skip this step in the future. Adding any other node without a trigger will add the Manual Trigger node to the workflow.

In a real-world scenario, you would probably want to set up a schedule or some other [trigger](../../../glossary/#trigger-node-n8n) to run the workflow.

## 2. Add the Hacker News node

Select the **+** icon to the right of the Manual Trigger node to open the nodes panel.

Then:

1. Search for the **Hacker News** node.
1. Select it when it appears in the search.
1. In the **Actions** section, select **Get many items**.

n8n adds the node to your canvas and the node window opens to display its configuration details.

## 3. Configure the Hacker News node

When you add a new node to the Editor UI, the node is automatically activated. The node details will open in a window with several options:

- **Parameters**: Adjust parameters to refine and control the node's functionality.
- **Settings**: Adjust settings to control the node's design and executions.
- **Docs**: Open the n8n documentation for this node in a new window.

Parameters vs. Settings

- **Parameters** are different for each node, depending on its functionality.
- **Settings** are the same for all nodes.

### Parameters

We need to configure several parameters for the Hacker News node to make it work:

- **Resource**: All\
  This resource selects all data records (articles).
- **Operation**: Get Many\
  This operation fetches all the selected articles.
- **Limit**: 10\
  This parameter sets a limit to the number of results the Get Many operation returns.
- **Additional Fields** > **Add Field** > **Keyword**: automation\
  **Additional fields** are options that you can add to certain nodes to make your request more specific or filter the results. For this example, we want to get only articles that include the keyword "automation."

The configuration of the parameters for the Hacker News node should now look like this:

*Hacker News node parameters*

### Settings

The **Settings** section includes several options for node design and executions. In this case, we'll configure only the final two settings, which set the node's appearance in the Editor UI canvas.

In the Hacker News node Settings, edit:

- **Notes**: Get the 10 latest articles.

  Node notes

  It's often helpful to add a short description in the node about what it does. This is helpful for complex or shared workflows in particular!

- **Display note in flow?**: toggle to true\
  This option will display the Note under the node in the canvas.

The configuration of the settings for the Hacker News node should now look like this:

*Hacker News node settings*

Renaming a node

You can rename the node with a name that's more descriptive for your use case. There are three ways to do this:

- Select the node you want to rename and at the same time press the F2 key on your keyboard.
- Double-click on the node to open the node window. Click on the name of the node in the top left corner of the window, rename it as you like, then click **Rename** to save the node under the new name.
- Right-click on the node and select the **Rename** option.

*Renaming a node from the keyboard*

To find the original node name (the type of node), open the node window and select **Settings**. The bottom of the page contains the node type and version.

## 4. Execute the node

Select the **Execute step** button in the node details window. You should see 10 results in the Output **Table** view.

*Results in Table view for the Hacker News node*

### Node executions

Node execution

A node execution represents a run of that node to retrieve or process the specified data.

If a node executes successfully, a small green checkmark appears on top of the node in the canvas

*Successfully executed workflow*

If there are no problems with the parameters and everything works fine, the requested data displays in the node window in **Table**, **JSON**, and **Schema** format. You can switch between these views by selecting the one you want from the **Table | JSON | Schema** button at the top of the node window.

Table vs JSON views

The **Table** view is the default. It displays the requested data in a table, where the rows are the records and the columns are the available attributes of those records.

Here's our Hacker News output in JSON view:

*Results in JSON view for the Hacker News node*

The node window displays more information about the node execution:

- Next to the **Output** title, notice a small icon (this will be a green checkmark if the node execution succeeded). Beside it, there is an info icon. If you hover on it, you'll get two more pieces of information that can provide insights into the performance of each individual node in a workflow:
  - **Start Time**: When the node execution started.
  - **Execution Time**: How long it took for the node to return the results from the moment it started executing.
- Just below the **Output** title, you'll notice another piece of information: **10 items**. This field displays the number of items (records) that the node request returned. In this example, it's expected to be 10, since this is the limit we set in step 2. But if you don't set a limit, it's useful to see how many records are actually returned.

Error in nodes

A red warning icon on a node means that the node has errors. This might happen if the node credentials are missing or incorrect or the node parameters aren't configured correctly.

*Error in nodes*

## 5. Save the workflow

Once you're finished editing the node, select **Back to canvas** to return to the main canvas.

By default, your workflow is automatically saved as "My workflow."

For this lesson, rename the workflow to be "Hacker News workflow."

Reminder

You can rename a workflow by clicking on the workflow's name at the top of the Editor UI.

Once you've renamed the workflow, be sure to save it.

There are two ways in which you can save a workflow:

- From the Canvas in Editor UI, click **Ctrl + S** or **Cmd + S** on your keyboard.
- Select the **Save** button in the top right corner of the Editor UI. You may need to leave the node editor first by clicking outside the dialog.

If you see a grey **Saved** text instead of the **Save** button, your workflow was automatically saved.

## Summary

Congratulations, you just built your first workflow! In this lesson, you learned how to use actions in app nodes, configure their parameters and settings, and save and execute your workflow.

In the next lesson, you'll meet your new client, Nathan, who needs to automate his sales reporting work. You will build a more complex workflow for his use case, helping him become more productive at work.

# Automating a (Real-world) Use Case

Meet Nathan 🙋. Nathan works as an Analytics Manager at ABCorp. His job is to support the ABCorp team with reporting and analytics. Being a true jack of all trades, he also handles several miscellaneous initiatives.

Some things that Nathan does are repetitive and mind-numbing. He wants to automate some of these tasks so that he doesn't burn out. As an **Automation Expert**, you are meeting with Nathan today to help him understand how he can offload some of his responsibilities to n8n.

## Understanding the scenario

**You 👩‍🔧:** Nice to meet you, Nathan. Glad to be doing this! What's a repetitive task that's error-prone and that you'd like to get off your plate first?

**Nathan 🙋:** Thanks for coming in! The most annoying one's gotta be the weekly sales reporting.

I have to collect sales data from our legacy data warehouse, which manages data from the main business processes of an organization, such as sales or production. Now, each sales order can have the status Processing or Booked. I have to calculate the sum of all the Booked orders and announce them in the company Discord every Monday. Then I have to create a spreadsheet of all the Processing sales so that the Sales Managers can review them and check if they need to follow up with customers.

This manual work is tough and requires high attention to detail to make sure that all the numbers are right. Inevitably, I lose my focus and mistype a number or I don't get it done on time. I've been criticized once by my manager for miscalculating the data.

**You 👩‍🔧:** Oh no! Doesn't the data warehouse have a way to export the data?

**Nathan 🙋:** The data warehouse was written in-house ages ago. It doesn't have a CSV export but they recently added a couple of API endpoints that expose this data, if that helps.

**You 👩‍🔧:** Perfect! That's a good start. If you have a generic API, we can add some custom code and a couple of services to make an automated workflow. This gig has n8n written all over it. Let's get started!

# Designing the Workflow

Now that we know what Nathan wants to automate, let's consider the steps he needs to take to achieve his goals:

1. Get the relevant data (order id, order status, order value, employee name) from the data warehouse
1. Filter the orders by their status (Processing or Booked)
1. Calculate the total value of all the Booked orders
1. Notify the team members about the Booked orders in the company's Discord channel
1. Insert the details about the Processing orders in Airtable for follow-up
1. Schedule this workflow to run every Monday morning

Nathan's workflow involves sending data from the company's data warehouse to two external services:

- Discord
- Airtable

Before that, the data has to be wrangled with general functions (conditional filtering, calculation, scheduling).

n8n provides integrations for all these steps, so Nathan's workflow in n8n would look like this:

[View workflow file](/_workflows//courses/level-one/finished.json)

You will build this workflow in eight steps:

1. [Getting data from the data warehouse](../chapter-5/chapter-5.1/)
1. [Inserting data into Airtable](../chapter-5/chapter-5.2/)
1. [Filtering orders](../chapter-5/chapter-5.3/)
1. [Setting values for processing orders](../chapter-5/chapter-5.4/)
1. [Calculating booked orders](../chapter-5/chapter-5.5/)
1. [Notifying the team](../chapter-5/chapter-5.6/)
1. [Scheduling the workflow](../chapter-5/chapter-5.7/)
1. [Activating and examining the workflow](../chapter-5/chapter-5.8/)

To build this workflow, you will need the credentials found in the email you received from n8n when you signed up for this course. If you haven't signed up already, you can do it [here](https://n8n-community.typeform.com/to/PDEMrevI?typeform-source=127.0.0.1). If you haven't received a confirmation email after signing up, [contact us](mailto:help@n8n.io).

[Start building!](../chapter-5/chapter-5.1/)

# Exporting and importing workflows

In this chapter, you will learn how to export and import workflows.

## Exporting and importing workflows

You can save n8n workflows locally as JSON files. This is useful if you want to share your workflow with someone else or import a workflow from someone else.

Sharing credentials

Exported workflow JSON files include [credential](../../../glossary/#credential-n8n) names and IDs. While IDs aren't sensitive, the names could be, depending on how you name your credentials. HTTP Request nodes may contain authentication headers when imported from cURL. Remove or anonymize this information from the JSON file before sharing to protect your credentials.

*Import & Export workflows menu*

You can export and import workflows in three ways:

- From the **Editor UI** menu:
  - Export: From the top navigation bar, select the three dots in the upper right, then select **Download**. This will download your current workflow as a JSON file on your computer.
  - Import: From the top navigation bar, select the three dots in the upper right, then select **Import from URL** (to import a published workflow) or **Import from File** (to import a workflow as a JSON file).
- From the **Editor UI** canvas:
  - Export: Select all the nodes on the canvas and use `Ctrl`+`C` to copy the workflow JSON. You can paste this into a file or share it directly with other people.
  - Import: You can paste a copied workflow JSON directly into the canvas with `Ctrl`+`V`.
- From the command line:
  - Export: See the [full list of commands](../../../hosting/cli-commands/) for exporting workflows or credentials.
  - Import: See the [full list of commands](../../../hosting/cli-commands/#import-workflows-and-credentials) for importing workflows or credentials.

# Test your knowledge

Congratulations, you finished the n8n Course Level 1!

You've learned a lot about workflow automation and built your first business workflow. Why not showcase your skills?

You can test your knowledge by taking a **quiz**, which consists of questions about the theoretical concepts and workflows covered in this course.

- You need to have at least 80% correct answers in each part to pass the quiz.
- You can take the quiz as many times as you want.
- There's no time limit on answering the quiz questions.

[Take the quiz!](https://n8n-community.typeform.com/to/JMoBXeGA)

## What's next?

- Create new workflows for your work or personal use and share them with us. Don't have any ideas? Find inspiration on our [blog](https://n8n.io/blog/), [YouTube channel](https://www.youtube.com/c/n8n-io), [community forum](https://community.n8n.io), and [Discord server](https://discord.gg/vWwMVThRta).
- Take the n8n [Course Level 2](../../level-two/).

# 1. Getting data from the data warehouse

In this part of the workflow, you will learn how to get data by making HTTP requests with the [**HTTP Request**](../../../../integrations/builtin/core-nodes/n8n-nodes-base.httprequest/) node.

After completing this section, your workflow will look like this:

[View workflow file](/_workflows//courses/level-one/chapter-5/chapter-5.1.json)

First, let's set the scene for building Nathan's workflow.

## Create new workflow

Open your Editor UI and create a new workflow with one of the two possible commands:

- Select `Ctrl`+`Alt`+`N` or `Cmd`+`Option`+`N` on your keyboard.
- Open the left menu, navigate to **Workflows**, and select **Add workflow**.

Name this new workflow "Nathan's workflow."

The first thing you need to do is get data from ABCorp's old data warehouse.

In a previous chapter, you used an action node designed for a specific service (Hacker News). But not all apps or services have dedicated nodes, like the legacy data warehouse from Nathan's company.

Though we can't directly export the data, Nathan told us that the data warehouse has a couple of API endpoints. That's all we need to access the data using the [HTTP Request](../../../../integrations/builtin/core-nodes/n8n-nodes-base.httprequest/) node in n8n.

No node for that service?

The HTTP Request node is one of the most versatile nodes, allowing you to make HTTP requests to query data from apps and services. You can use it to access data from apps or services that don't have a dedicated node in n8n.

## Add an HTTP Request node

Now, in your Editor UI, add an HTTP Request node like you learned in the lesson [Adding nodes](../../chapter-1/#adding-nodes). The node window will open, where you need to configure some parameters.

*HTTP Request node*

This node will use credentials.

Credentials

[Credentials](../../../../glossary/#credential-n8n) are unique pieces of information that identify a user or a service and allow them to access apps or services (in our case, represented as n8n nodes). A common form of credentials is a username and a password, but they can take other forms depending on the service.

In this case, you'll need the credentials for the ABCorp data warehouse API included in the email from n8n you received when you signed up for this course. If you haven't signed up yet, [sign up here](https://n8n-community.typeform.com/to/PDEMrevI).

In the **Parameters** of the HTTP Request node, make the following adjustments:

- **Method**: This should default to GET. Make sure it's set to GET.
- **URL**: Add the **Dataset URL** you received in the email when you signed up for this course.
- **Send Headers**: Toggle this control to true. In **Specify Headers**, ensure **Using Fields Below** is selected.
  - **Header Parameters** > **Name**: Enter `unique_id`.
  - **Header Parameters** > **Value**: The Unique ID you received in the email when you signed up for this course.
- **Authentication**: Select **Generic Credential Type**. This option requires credentials before allowing you to access the data.
  - **Generic Auth Type**: Select **Header Auth**. (This field will appear after you select the Generic Credential Type for the Authentication.)

  - **Credential for Header Auth**: To add your credentials, select **+ Create new credential**. This will open the Credentials window.

  - In the Credentials window, set **Name** to be the **Header Auth name** you received in the email when you signed up for this course.

  - In the Credentials window, set **Value** to be the **Header Auth value** you received in the email when you signed up for this course.

  - Select the **Save** button in the Credentials window to save your credentials. Your **Credentials Connection** window should look like this:

    *HTTP Request node credentials*

Credentials naming

New credential names follow the " account" format by default. You can rename the credentials by clicking on the name, similarly to renaming nodes. It's good practice to give them names that identify the app/service, type, and purpose of the credential. A naming convention makes it easier to keep track of and identify your credentials.

Once you save, exit out of the Credentials window to return to the HTTP Request node.

## Get the data

Select the **Execute step** button in the HTTP Request node window. The table view of the HTTP request results should look like this:

*HTTP Request node output*

This view should be familiar to you from the [Building a mini-workflow](../../chapter-2/) page.

This is the data from ABCorp's data warehouse that Nathan needs to work with. This data set includes sales information from 30 customers with five columns:

- `orderID`: The unique id of each order.
- `customerID`: The unique id of each customer.
- `employeeName`: The name of Nathan's colleague responsible for the customer.
- `orderPrice`: The total price of the customer's order.
- `orderStatus`: Whether the customer's order status is `booked` or still in `processing`.

## What's next?

**Nathan 🙋**: This is great! You already automated an important part of my job with only one node. Now instead of manually accessing the data every time I need it, I can use the HTTP Request Node to automatically get the information.

**You 👩‍🔧**: Exactly! In the next step, I'll help you one step further and insert the data you retrieved into Airtable.

# 2. Inserting data into Airtable

In this step of the workflow, you will learn how to insert the data received from the HTTP Request node into Airtable using the [Airtable node](../../../../integrations/builtin/app-nodes/n8n-nodes-base.airtable/).

Spreadsheet nodes

You can replace the Airtable node with another spreadsheet app/service. For example, n8n also has a node for [**Google Sheets**](../../../../integrations/builtin/app-nodes/n8n-nodes-base.googlesheets/).

After this step, your workflow should look like this:

[View workflow file](/_workflows//courses/level-one/chapter-5/chapter-5.2.json)

## Configure your table

If we're going to insert data into Airtable, we first need to set up a table there. To do this:

1. [Create an Airtable account](https://airtable.com/signup).

1. In your Airtable workspace add a new base from scratch and name it, for example, *beginner course*.

   *Create an Airtable base*

1. In the beginner course base, by default, you have a table called **Table 1** with four fields: `Name`, `Notes`, `Assignee`, and `Status`. These fields aren't relevant for us since they aren't in our "orders" data set. This brings us to the next point: the names of the fields in Airtable have to match the names of the columns in the node result. Prepare the table by doing the following:

   - Rename the table from **Table 1** to **orders** to make it easier to identify.
   - Delete the 3 blank records created by default.
   - Delete the `Notes`, `Assignee`, and `Status` fields.
   - Edit the `Name` field (the primary field) to read `orderID`, with the **Number** field type.
   - Add the rest of the fields, and their field types, using the table below as a reference:

   | Field name     | Field type       |
   | -------------- | ---------------- |
   | `orderID`      | Number           |
   | `customerID`   | Number           |
   | `employeeName` | Single line text |
   | `orderPrice`   | Number           |
   | `orderStatus`  | Single line text |

Now your table should look like this:

*Orders table in Airtable*

Now that the table is ready, let's return to the workflow in the n8n Editor UI.

## Add an Airtable node to the HTTP Request node

Add an Airtable node connected to the HTTP Request node.

Remember

You can add a node connected to an existing node by selecting the **+** icon next to the existing node.

In the node panel:

1. Search for Airtable.
1. Select **Create a record** from the **Record Actions** search results.

This will add the Airtable node to your canvas and open the node details window.

In the Airtable node window, configure the following parameters:

- **Credential to connect with**:
  - Select **Create new credential**.
  - Keep the default option **Connect using: Access Token** selected.
  - **Access token**: Follow the instructions from the [Airtable credential](../../../../integrations/builtin/credentials/airtable/) page to create your token. Use the recommended scopes and add access to your beginners course base. Save the credential and close the Credential window when you're finished.
- **Resource**: Record.
- **Operation**: Create. This operation will create new records in the table.
- **Base**: You can pick your base from a list (for example, beginner course).
- **Table**: orders.
- **Mapping Column Mode**: Map automatically. In this mode, the incoming data fields must have the same as the columns in Airtable.

## Test the Airtable node

Once you've finished configuring the Airtable node, execute it by selecting **Execute step**. This might take a moment to process, but you can follow the progress by viewing the base in Airtable.

Your results should look like this:

*Airtable node results*

All 30 data records will now appear in the orders table in Airtable:

*Imported records in the orders table*

## What's next?

**Nathan 🙋**: Wow, this automation is already so useful! But this inserts all collected data from the HTTP Request node into Airtable. Remember that I actually need to insert only processing orders in the table and calculate the price of booked orders?

**You 👩‍🔧**: Sure, no problem. As a next step, I'll use a new node to filter the orders based on their status.

# 3. Filtering Orders

In this step of the workflow, you will learn how to filter data using conditional logic and how to use expressions in nodes using the [If node](../../../../integrations/builtin/core-nodes/n8n-nodes-base.if/).

After this step, your workflow should look like this:

[View workflow file](/_workflows//courses/level-one/chapter-5/chapter-5.3.json)

To insert only processing orders into Airtable we need to filter our data by `orderStatus`. Basically, we want to tell the program that *if* the `orderStatus` is processing, *then* insert all records with this status into Airtable; *else*, for example, if the `orderStatus` isn't *processing*, calculate the sum of all orders with the other `orderStatus` (`booked`).

This if-then-else command is conditional logic. In n8n workflows, you can add conditional logic with the [If node](../../../../integrations/builtin/core-nodes/n8n-nodes-base.if/), which splits a workflow conditionally based on comparison operations.

If vs. Switch

If you need to filter data on more than boolean values (true and false), use the [Switch node](../../../../integrations/builtin/core-nodes/n8n-nodes-base.switch/). The Switch node is similar to the If node, but supports multiple output connectors.

## Add If node before the Airtable node

First, let's add an If node between the connection from the HTTP Request node to the Airtable node:

1. Hover over the arrow connection the **HTTP Request** node and the **Airtable** node.
1. Select the **+** sign between the HTTP Request node and the Airtable node.

## Configure the If node

Selecting the plus removes the connection to the Airtable node to the HTTP request. Now, let's add an If node connected to the HTTP Request node:

1. Search for the If node.
1. Select it when it appears in the search.

For the If node, we'll use an expression.

Expressions

An [expression](../../../../glossary/#expression-n8n) is a string of characters and symbols in a programming language that can be evaluated to get a value, often according to its input. In n8n workflows, you can use expressions in a node to refer to another node for input data. In our example, the If node references the data output by the HTTP Request node.

In the If node window, configure the parameters:

- Set the `value1` placeholder to `{{ $json.orderStatus }}` with the following steps:

  1. Hover over the value1 field.

  1. Select the **Expression** tab on the right side of the `value1` field.

  1. Next, open the expression editor by selecting the link icon:

     *Opening the Expression Editor*

  1. Use the left-side panel to select **HTTP Request** > **orderStatus** and drag it into the **Expression** field in the center of the window.

     *Expression Editor in the If node*

  1. Once you add the expression, close the **Edit Expression** dialog.

- **Operation**: Select **String** > **is equal to**

- Set the `value2` placeholder to `processing`.

Data Type

Make sure to select the correct data type (boolean, date & time, number, or string) when you select the **Operation**.

Select **Execute step** to test the If node.

Your results should look like this:

*If node output*

Note that the orders with a `processing` order status should show for the **True Branch** output, while the orders with a `booked` order status should show in the **False Branch** output.

Close the If node detail view when you're finished.

## Insert data into Airtable

Next, we want to insert this data into Airtable. Remember what Nathan said at the end of the [Inserting data into Airtable](../chapter-5.2/) lesson?

> I actually need to insert only processing orders in the table...

Since Nathan only needs the `processing` orders in the table, we'll connect the Airtable node to the If node's `true` connector.

In this case, since the Airtable node is already on our canvas, select the **If node** `true` connector and drag it to the Airtable node.

It's a good idea at this point to retest the Airtable node. Before you do, open your table in Airtable and delete all existing rows. Then open the Airtable node window in n8n and select **Execute step**.

Review your data in Airtable to be sure your workflow only added the correct orders (those with `orderStatus` of `processing`). There should be 14 records now instead of 30.

At this stage, your workflow should look like this:

[View workflow file](/_workflows//courses/level-one/chapter-5/chapter-5.3.json)

## What's next?

**Nathan 🙋**: This If node is so useful for filtering data! Now I have all the information about processing orders. I actually only need the `employeeName` and `orderID`, but I guess I can keep all the other fields just in case.

**You 👩‍🔧**: Actually, I wouldn't recommend doing that. Inserting more data requires more computational power, the data transfer is slower and takes longer, and takes up more storage resources in your table. In this particular case, 14 records with 5 fields might not seem like it'd make a significant difference, but if your business grows to thousands of records and dozens of fields, things add up and even one extra column can affect performance.

**Nathan 🙋**: Oh, that's good to know. Can you select only two fields from the processing orders?

**You 👩‍🔧**: Sure, I'll do that in the next step.

# 4. Setting Values for Processing Orders

In this step of the workflow, you will learn how to select and set data before transferring it to Airtable using the Edit Fields (Set) node. After this step, your workflow should look like this:

[View workflow file](/_workflows//courses/level-one/chapter-5/chapter-5.4.json)

The next step in Nathan's workflow is to filter the data to only insert the `employeeName` and `orderID` of all `processing` orders into Airtable.

For this, you need to use the [Edit Fields (Set) node](../../../../integrations/builtin/core-nodes/n8n-nodes-base.set/), which allows you to select and set the data you want to transfer from one node to another.

Edit Fields node

The Edit Fields node can set completely new data as well as overwrite data that already exists. This node is crucial in workflows which expect incoming data from previous nodes, such as when inserting values into spreadsheets or databases.

## Add another node before the Airtable node

In your workflow, add another node before the **Airtable node** from the **If node** in the same way we did it in the [Filtering Orders](../chapter-5.3/#add-if-node-before-the-airtable-node) lesson on the If node's `true` connector. Feel free to drag the Airtable node further away if your canvas feels crowded.

## Configure the Edit Fields node

Now search for the **Edit Fields (Set) node** after you've selected the **+** sign coming off the If node's `true` connector.

With the Edit Fields node window open, configure these parameters:

- Ensure **Mode** is set to **Manual Mapping**.
- While you can use the **Expression editor** we used in the [Filtering Orders](../chapter-5.3/) lesson, this time, let's drag the fields from the **Input** into the **Fields to Set**:
  - Drag **If** > **orderID** as the first field.
  - Drag **If** > **employeeName** as the second field.
- Ensure that **Include Other Input Fields** is set to false.

Select **Execute step**. You should see the following results:

*Edit Fields (Set) node*

## Add data to Airtable

Next, let's insert these values into Airtable:

1. Go to your Airtable base.

1. Add a new table called `processingOrders`.

1. Replace the existing columns with two new columns:

   - `orderID` (primary field): Number
   - `employeeName`: Single line text

   Reminder

   If you get stuck, refer to the [Inserting data into Airtable](../chapter-5.2/) lesson.

1. Delete the three empty rows in the new table.

1. In n8n, connect the Edit Fields node **connector to the** Airtable node\*\*.

1. Update the Airtable node configuration to point to the new `processingOrders` table instead of the `orders` table.

1. Test your Airtable node to be sure it inserts records into the new `processingOrders` table.

At this stage, your workflow should now look like this:

[View workflow file](/_workflows//courses/level-one/chapter-5/chapter-5.4.json)

## What's next?

**Nathan 🙋**: You've already automated half of my work! Now I still need to calculate the booked orders for my colleagues. Can we automate that as well?

**You 👩‍🔧**: Yes! In the next step, I'll use some JavaScript code in a node to calculate the booked orders.

# 5. Calculating Booked Orders

In this step of the workflow you will learn how n8n structures data and how to add custom JavaScript code to perform calculations using the Code node. After this step, your workflow should look like this:

[View workflow file](/_workflows//courses/level-one/chapter-5/chapter-5.5.json)

The next step in Nathan's workflow is to calculate two values from the booked orders:

- The total number of booked orders
- The total value of all booked orders

To calculate data and add more functionality to your workflows you can use the Code node, which lets you write custom JavaScript code.

## About the Code node

Code node modes

The Code node has two operational **modes**, depending on how you want to process items:

- **Run Once for All Items** allows you to write code to process all input items at once, as a group.
- **Run Once for Each Item** executes your code once for each input item.

Learn more about how to use the [Code node](../../../../integrations/builtin/core-nodes/n8n-nodes-base.code/).

In n8n, the data that's passed between nodes is an array of objects with the following JSON structure:

```
[
    {
   	 "json": { // (1)!
   		 "apple": "beets",
   		 "carrot": {
   			 "dill": 1
   		 }
   	 },
   	 "binary": { // (2)!
   		 "apple-picture": { // (3)!
   			 "data": "....", // (4)!
   			 "mimeType": "image/png", // (5)!
   			 "fileExtension": "png", // (6)!
   			 "fileName": "example.png", // (7)!
   		 }
   	 }
    },
    ...
]
```

1. (required) n8n stores the actual data within a nested `json` key. This property is required, but can be set to anything from an empty object (like `{}`) to arrays and deeply nested data. The code node automatically wraps the data in a `json` object and parent array (`[]`) if it's missing.
1. (optional) Binary data of item. Most items in n8n don't contain binary data.
1. (required) Arbitrary key name for the binary data.
1. (required) Base64-encoded binary data.
1. (optional) Should set if possible.
1. (optional) Should set if possible.
1. (optional) Should set if possible.

You can learn more about the expected format on the [n8n data structure](../../../../data/data-structure/) page.

## Configure the Code node

Now let's see how to accomplish Nathan's task using the Code node.

In your workflow, add a **Code node** connected to the `false` branch of the **If node**.

With the Code node window open, configure these parameters:

- **Mode**: Select **Run Once for All Items**.

- **Language**: Select **JavaScript**.

  Using Python in code nodes

  While we use JavaScript below, you can also use Python in the Code node. To learn more, refer to the [Code node](../../../../code/code-node/) documentation.

- Copy the Code below and paste it into the **Code** box to replace the existing code:

  ```
  let items = $input.all();
  let totalBooked = items.length;
  let bookedSum = 0;

  for (let i=0; i < items.length; i++) {
    bookedSum = bookedSum + items[i].json.orderPrice;
  }

  return [{ json: {totalBooked, bookedSum} }];
  ```

Notice the format in which we return the results of the calculation:

```
return [{ json: {totalBooked, bookedSum} }]
```

Data structure error

If you don't use the correct data structure, you will get an error message: `Error: Always an Array of items has to be returned!`

Now select **Execute step** and you should see the following results:

*Code node output*

## What's next?

**Nathan 🙋**: Wow, the Code node is powerful! This means that if I have some basic JavaScript skills I can power up my workflows.

**You 👩‍🔧**: Yes! You can progress from no-code to low-code!

**Nathan 🙋**: Now, how do I send the calculations for the booked orders to my team's Discord channel?

**You 👩‍🔧**: There's an n8n node for that. I'll set it up in the next step.

# 6. Notifying the Team

In this step of the workflow, you will learn how to send messages to a Discord channel using the [Discord node](../../../../integrations/builtin/app-nodes/n8n-nodes-base.discord/). After this step, your workflow should look like this:

[View workflow file](/_workflows//courses/level-one/chapter-5/chapter-5.6.json)

Now that you have a calculated summary of the booked orders, you need to notify Nathan's team in their Discord channel. For this workflow, you will send messages to the [n8n server](https://discord.gg/G98WXzsjky) on Discord.

Before you begin the steps below, use the link above to connect to the n8n server on Discord. Be sure you can access the `#course-level-1` channel.

Communication app nodes

You can replace the Discord node with another communication app. For example, n8n also has nodes for [Slack](../../../../integrations/builtin/app-nodes/n8n-nodes-base.slack/) and [Mattermost](../../../../integrations/builtin/app-nodes/n8n-nodes-base.mattermost/).

In your workflow, add a Discord node connected to the Code node.

When you search for the Discord node, look for **Message Actions** and select **Send a message** to add the node.

In the Discord node window, configure these parameters:

- **Connection Type**: Select **Webhook**.
- **Credential for Discord Webhook**: Select **- Create New Credential -**.
  - Copy the **Webhook URL** from the email you received when you signed up for this course and paste it into the **Webhook URL** field of the credentials.
  - Select **Save** and then close the credentials dialog.
- **Operation**: Select **Send a Message**.
- **Message**:
  - Select the **Expression** tab on the right side of the Message field.

  - Copy the text below and paste it into the **Expression** window, or construct it manually using the **Expression Editor**.

    ```
    This week we've {{$json["totalBooked"]}} booked orders with a total value of {{$json["bookedSum"]}}. My Unique ID: {{ $('HTTP Request').params["headerParameters"]["parameters"][0]["value"] }}
    ```

Now select **Execute step** in the Discord node. If all works well, you should see this output in n8n:

*Discord node output*

And your message should appear in the Discord channel #course-level-1:

*Discord message*

## What's next?

**Nathan 🙋**: Incredible, you've saved me hours of tedious work already! Now I can execute this workflow when I need it. I just need to remember to run it every Monday morning at 9 AM.

**You 👩‍🔧**: Don't worry about that, you can actually schedule the workflow to run on a specific day, time, or interval. I'll set this up in the next step.

# 7. Scheduling the Workflow

In this step of the workflow, you will learn how to schedule your workflow so that it runs automatically at a set time/interval using the Schedule Trigger node. After this step, your workflow should look like this:

[View workflow file](/_workflows//courses/level-one/finished.json)

The workflow you've built so far executes only when you click on **Execute Workflow**. But Nathan needs it to run automatically every Monday morning. You can do this with the [Schedule Trigger](../../../../integrations/builtin/core-nodes/n8n-nodes-base.scheduletrigger/), which allows you to schedule workflows to run periodically at fixed dates, times, or intervals.

To achieve this, we'll remove the Manual Trigger node we started with and replace it with a Schedule Trigger node instead.

## Remove the Manual Trigger node

First, let's remove the Manual Trigger node:

1. Select the Manual Trigger node connected to your HTTP Request node.
1. Select the trash can icon to delete.

This removes the Manual Trigger node and you'll see an "Add first step" option.

## Add the Schedule Trigger node

1. Open the nodes panel and search for **Schedule Trigger**.
1. Select it when it appears in the search results.

In the Schedule Trigger node window, configure these parameters:

- **Trigger Interval**: Select **Weeks**.
- **Weeks Between Triggers**: Enter `1`.
- **Trigger on weekdays**: Select **Monday** (and remove **Sunday** if added by default).
- **Trigger at Hour**: Select **9am**.
- **Trigger at Minute**: Enter `0`.

Your Schedule Trigger node should look like this:

*Schedule Trigger Node*

Keep in mind

To ensure accurate scheduling with the Schedule Trigger node, be sure to set the correct timezone for your [n8n instance](../../../../manage-cloud/set-cloud-timezone/) or the [workflow's settings](../../../../workflows/settings/). The Schedule Trigger node will use the workflow's timezone if it's set; it will fall back to the n8n instance's timezone if it's not.

## Connect the Schedule Trigger node

Return to the canvas and connect your Schedule Trigger node to the HTTP Request node by dragging the arrow from it to the HTTP Request node.

Your full workflow should look like this:

[View workflow file](/_workflows//courses/level-one/finished.json)

## What's next?

**You 👩‍🔧**: That was it for the workflow! I've added and configured all necessary nodes. Now every time you click on **Execute workflow**, n8n will execute all the nodes: getting, filtering, calculating, and transferring the sales data.

**Nathan 🙋**: This is just what I needed! My workflow will run automatically every Monday morning, correct?

**You 👩‍🔧**: Not so fast. To do that, you need to activate your workflow. I'll do this in the next step and show you how to interpret the execution log.

# 8. Activating and Examining the Workflow

In this step of the workflow, you will learn how to activate your workflow and change the default workflow settings.

Activating a workflow means that it will run automatically every time a trigger node receives input or meets a condition. By default, all newly created workflows start deactivated.

To activate your workflow, set the **Inactive** toggle in the top navigation of the Editor UI to be **Activated**. Nathan's workflow will now be executed automatically every Monday at 9 AM:

*Activated workflow*

## Workflow Executions

An execution represents a completed run of a workflow, from the first to the last node. n8n logs workflow executions, allowing you to see if the workflow succeeded or not. The execution log is useful for debugging your workflow and seeing at what stage it runs into issues.

To view the executions for a specific workflow, you can switch to the **Executions** tab when the workflow is open on the canvas. Use the **Editor** tab to swap back to the node editor.

To see the execution log for the entire n8n instance, in your Editor UI, select **Overview** and then select the **Executions** tab in the main panel.

*Execution List*

The **Executions** window displays a table with the following information:

- **Name**: The name of the workflow
- **Started At**: The date and time when the workflow started
- **Status**: The status of the workflow (Waiting, Running, Succeeded, Cancelled, or Failed) and the amount of time it took the workflow to execute
- **Execution ID**: The ID of this workflow execution

Workflow execution status

You can filter the displayed **Executions** by workflow and by status (**Any Status**, **Failed**, **Cancelled**, **Running**, **Success**, or **Waiting**). The information displayed here depends on which executions you configure to save in the [**Workflow Settings**](../../../../workflows/settings/).

## Workflow Settings

You can customize your workflows and executions, or overwrite some global default settings in [**Workflow Settings**](../../../../workflows/settings/).

Access these settings by selecting the three dots in the upper right corner of the Editor UI when the workflow is open on the canvas, then select **Settings**.

*Workflow Settings*

In the **Workflow Settings** window you can configure the following settings:

- **Execution Order**: Choose the execution logic for multi-branch workflows. You should leave this set to `v1` if you don't have workflows that rely on the legacy execution ordering.
- [**Error Workflow**](../../../../flow-logic/error-handling/): A workflow to run if the execution of the current workflow fails.
- **This workflow can be called by**: Workflows allowed to call this workflow using the [Execute Sub-workflow node](../../../../integrations/builtin/core-nodes/n8n-nodes-base.executeworkflow/).
- **Timezone**: The timezone to use in the current workflow. If not set, the global timezone. In particular, this setting is important for the [Schedule Trigger node](../../../../integrations/builtin/core-nodes/n8n-nodes-base.scheduletrigger/), as you want to make sure that the workflow gets executed at the right time.
- **Save failed production executions**: If n8n should save the Execution data of the workflow when it fails. Default is to save.
- **Save successful production executions**: If n8n should save the Execution data of the workflow when it succeeds. Default is to save.
- **Save manual executions**: If n8n should save executions started from the Editor UI. Default is to save.
- **Save execution progress**: If n8n should save the execution data of each node. If set to Save, you can resume the workflow from where it stopped in case of an error, though keep in mind that this might make the execution slower. Default is to not save.
- **Timeout Workflow**: Whether to cancel a workflow execution after a specific period of time. Default is to not timeout.

## What's next?

**You 👩‍🔧**: That was it! Now you have a 7-node workflow that will run automatically every Monday morning. You don't have to worry about remembering to wrangle the data. Instead, you can start your week with more meaningful or exciting work.

**Nathan 🙋**: This workflow is incredibly helpful, thank you! Now, what's next for you?

**You 👩‍🔧**: I'd like to build more workflows, share them with others, and use some workflows built by other people.

# Level two: Introduction

Welcome to the **n8n Course Level 2**!

## Is this course right for me?

This course is for you if you:

- Want to automate somewhat complex business processes.
- Want to dive deeper into n8n after taking the [Level 1 course](../level-one/).

## What will I learn in this course?

The focus in this course is on working with data. You will learn how to:

- Use the data structure of n8n correctly.
- Process different data types (for example, XML, HTML, date, time, and binary data).
- Merge data from different sources (for example, a database, spreadsheet, or CRM).
- Use functions and JavaScript code in the [Code node](../../integrations/builtin/core-nodes/n8n-nodes-base.code/).
- Deal with error workflows and workflow errors.

You will learn all this by completing short practical exercises after the theoretical explanations and building a business workflow following instructions.

## What do I need to get started?

To follow along this course (at a comfortable pace) you will need the following:

- **n8n set up**: You can use the [self-hosted version](../../hosting/installation/npm/) or [n8n Cloud](../../manage-cloud/overview/).
- **A user ID**: [Sign up here](https://n8n-community.typeform.com/to/HQoQ7nXg) to get your unique ID and other credentials you will need in this course (Level 2). If you're a Level 1 finisher, please sign up again as you'll get different credentials for the Level 2 workflows.
- **Basic n8n skills**: We strongly recommend taking the [Level 1 course](../level-one/) before this one.
- **Basic JavaScript understanding**

## How long does the course take?

Completing the course should take around **two hours**. You don't have to complete it in one go; feel free to take breaks and resume whenever you are ready.

## How do I complete the course?

There are two milestones in this course that test your knowledge of what you have learned in the lessons:

- Building the [main workflow](chapter-5/chapter-5.0/)
- Passing the [quiz](https://n8n-community.typeform.com/to/r9hDbytg) at the end of the course

You can always **check your progress** throughout the course by entering your unique ID [here](https://internal.users.n8n.cloud/webhook/course-level-2/verify).

If you successfully complete the milestones above, you will get [**a badge and an avatar**](https://community.n8n.io/badges/105/completed-n8n-course-level-2) in your forum profile. You can then share your profile and course verification ID to showcase your n8n skills to others.

[Let's get started!](chapter-1/)

# Understanding the data structure

In this chapter, you will learn about the data structure of n8n and how to use the [Code node](../../../integrations/builtin/core-nodes/n8n-nodes-base.code/) to transform data and simulate node outputs.

## Data structure of n8n

In a basic sense, n8n nodes function as an Extract, Transform, Load (ETL) tool. The nodes allow you to access (extract) data from multiple disparate sources, modify (transform) that data in a particular way, and pass (load) it along to where it needs to be.

The data that moves along from node to node in your workflow must be in a format (structure) that can be recognized and interpreted by each node. In n8n, this required structure is an array of objects.

About array of objects

An array is a list of values. The array can be empty or contain several elements. Each element is stored at a position (index) in the list, starting at 0, and can be referenced by the index number. For example, in the array `["Leonardo", "Michelangelo", "Donatello", "Raphael"];` the element `Donatello` is stored at index 2.

An object stores key-value pairs, instead of values at numbered indexes as in arrays. The order of the pairs isn't important, as the values can be accessed by referencing the key name. For example, the object below contains two properties (`name` and `color`):

```
{
	name: 'Michelangelo',
	color: 'blue',
}
```

An array of objects is an array that contains one or more objects. For example, the array `turtles` below contains four objects:

```
var turtles = [
	{
		name: 'Michelangelo',
		color: 'orange',
	},
	{
		name: 'Donatello',
		color: 'purple',
	},
	{
		name: 'Raphael',
		color: 'red',
	},
	{
		name: 'Leonardo',
		color: 'blue',
	}
];
```

You can access the properties of an object using dot notation with the syntax `object.property`. For example, `turtles[1].color` gets the color of the second turtle.

Data sent from one node to another is sent as an array of JSON objects. The elements in this collection are called items.

*Items*

An n8n node performs its action on each item of incoming data.

*Items in the Customer Datastore node*

## Creating data sets with the Code node

Now that you are familiar with the n8n data structure, you can use it to create your own data sets or simulate node outputs. To do this, use the [Code node](../../../integrations/builtin/core-nodes/n8n-nodes-base.code/) to write JavaScript code defining your array of objects with the following structure:

```
return [
	{
		json: {
			apple: 'beets',
		}
	}
];
```

For example, the array of objects representing the Ninja turtles would look like this in the Code node:

*Array of objects in the Code node*

JSON objects

Notice that this array of objects contains an extra key: `json`. n8n expects you to wrap each object in an array in another object, with the key `json`.

*Illustration of data structure in n8n*

It's good practice to pass the data in the right structure used by n8n. But don't worry if you forget to add the `json` key to an item, n8n (version 0.166.0 and above) adds it automatically.

You can also have nested pairs, for example if you want to define a primary and a secondary color. In this case, you need to further wrap the key-value pairs in curly braces `{}`.

n8n data structure video

[This talk](https://www.youtube.com/watch?v=mQHT3Unn4tY) offers a more detailed explanation of data structure in n8n.

### Exercise

In a Code node, create an array of objects named `myContacts` that contains the properties `name` and `email`, and the `email` property is further split into `personal` and `work`.

Show me the solution

In the **Code node**, in the JavaScript Code field you have to write the following code:

```
var myContacts = [
	{
		json: {
			name: 'Alice',
			email: {
				personal: 'alice@home.com',
				work: 'alice@wonderland.org'
			},
		}
	},
	{
		json: {
			name: 'Bob',
			email: {
				personal: 'bob@mail.com',
				work: 'contact@thebuilder.com'
				},
		}
	},
];

return myContacts;
```

When you execute the **Code node**, the result should look like this:

*Result of Code node*

## Referencing node data with the Code node

Just like you can use [expressions](../../../code/expressions/) to reference data from other nodes, you can also use some [methods and variables](../../../code/builtin/overview/) in the **Code node**.

Please make sure you read these pages before continuing to the next exercise.

### Exercise

Let's build on the previous exercise, in which you used the Code node to create a data set of two contacts with their names and emails. Now, connect a second Code node to the first one. In the new node, write code to create a new column named `workEmail` that references the work email of the first contact.

Show me the solution

In the **Code node**, in the JavaScript Code field you have to write the following code:

```
let items = $input.all();
items[0].json.workEmail = items[0].json.email['work'];
return items;
```

When you execute the **Code node**, the result should look like this:

*Code node reference*

## Transforming data

The incoming data from some nodes may have a different data structure than the one used in n8n. In this case, you need to [transform the data](../../../data/transforming-data/), so that each item can be processed individually.

The two most common operations for data transformation are:

- Creating multiple items from one item
- Creating a single item from multiple items

There are several ways to transform data for the purposes mentioned above:

- Use n8n's [data transformation nodes](../../../data/#data-transformation-nodes). Use these nodes to modify the structure of incoming data that contain lists (arrays) without needing to use JavaScript code in the **Code node**:
  - Use the [**Split Out node**](../../../integrations/builtin/core-nodes/n8n-nodes-base.splitout/) to separate a single data item containing a list into multiple items.
  - Use the [**Aggregate node**](../../../integrations/builtin/core-nodes/n8n-nodes-base.aggregate/) to take separate items, or portions of them, and group them together into individual items.
- Use the **Code node** to write JavaScript functions to modify the data structure of incoming data using the **Run Once for All Items** mode:
  - To create multiple items from a single item, you can use JavaScript code like this. This example assumes that the item has a key named `data` set to an array of items in the form of: `[{ "data": [{<item_1>}, {<item_2>}, ...] }]`:

    ```
    return $input.first().json.data.map(item => {
        return {
            json: item
        }
    });
    ```

  - To create a single item from multiple items, you can use this JavaScript code:

    ```
    return [
    	{
        	json: {
        		data_object: $input.all().map(item => item.json)
        	}
        }
      ];
    ```

These JavaScript examples assume your entire input is what you want to transform. As in the exercise above, you can also execute either operation on a specific field by identifying that in the items list, for example, if our workEmail example had multiple emails in a single field, we could run some code like this:

```
let items = $input.all();
return items[0].json.workEmail.map(item => {
	return {
		json: item
	}
});
```

### Exercise

1. Use the **HTTP Request node** to make a GET request to the PokéAPI `https://pokeapi.co/api/v2/pokemon`. (This API requires no authentication).
1. Transform the data in the `results` field with the **Split Out node**.
1. Transform the data in the `results` field with the **Code node**.

Show me the solution

1. To get the pokemon from the PokéAPI, execute the **HTTP Request node** with the following parameters:

   - **Authentication**: None
   - **Request Method**: GET
   - **URL**: https://pokeapi.co/api/v2/pokemon

1. To transform the data with the **Split Out node**, connect this node to the **HTTP Request node** and set the following parameters:

   - **Field To Split Out**: results
   - **Include**: No Other Fields

1. To transform the data with the **Code node**, connect this node to the **HTTP Request node** and write the following code in the JavaScript Code field:

   ```
   let items = $input.all();
   return items[0].json.results.map(item => {
   	return {
   		json: item
   	}
   });
   ```

# Processing different data types

In this chapter, you will learn how to process different types of data using [n8n core nodes](../../../workflows/components/nodes/).

## HTML and XML data

You're most likely familiar with HTML and XML.

HTML vs. XML

HTML is a markup language used to describe the structure and semantics of a web page. XML looks similar to HTML, but the tag names are different, as they describe the kind of data they hold.

If you need to process HTML or XML data in your n8n workflows, use the [**HTML node**](../../../integrations/builtin/core-nodes/n8n-nodes-base.html/) or the [**XML node**](../../../integrations/builtin/core-nodes/n8n-nodes-base.xml/).

Use the **HTML node** to extract HTML content of a webpage by referencing CSS selectors. This is useful if you want to collect structured information from a website (web-scraping).

### HTML Exercise

Let's get the title of the latest n8n blog post:

1. Use the **HTTP Request node** to make a GET request to the URL `https://blog.n8n.io/` (this endpoint requires no authentication).
1. Connect an **HTML node** and configure it to extract the title of the first blog post on the page.
   - Hint: If you're not familiar with CSS selectors or reading HTML, the CSS selector `.post .item-title a` should help!

Show me the solution

1. Configure the HTTP Request node with the following parameters:
   - **Authentication**: None
   - **Request Method**: GET
   - **URL**: https://blog.n8n.io/ The result should look like this:

*Result of HTTP Request node*

2. Connect an **HTML node** to the **HTTP Request node** and configure the former's parameters:
   - **Operation**: Extract HTML Content
   - **Source Data**: JSON
   - **JSON Property**: data
   - **Extraction Values**:
     - **Key**: title
     - **CSS Selector**: `.post .item-title a`
     - **Return Value**: HTML

You can add more values to extract more data.

The result should look like this:

*Result of HTML Extract node*

Use the **XML node** to convert XML to JSON and JSON to XML. This operation is useful if you work with different web services that use either XML or JSON and need to get and submit data between them in the two formats.

### XML Exercise

In the [final exercise of Chapter 1](../chapter-1/#exercise_2), you used an **HTTP Request node** to make a request to the PokéAPI. In this exercise, we'll return to that same API but we'll convert the output to XML:

1. Add an **HTTP Request node** that makes the same request to the PokéAPI at `https://pokeapi.co/api/v2/pokemon`.
1. Use the XML node to convert the JSON output to XML.

Show me the solution

1. To get the pokemon from the PokéAPI, execute the **HTTP Request node** with the following parameters:
   - **Authentication**: None
   - **Request Method**: GET
   - **URL**: https://pokeapi.co/api/v2/pokemon
1. Connect an **XML node** to it with the following parameters:
   - **Mode**: JSON to XML
   - **Property name**: data

The result should look like this:

*XML node (JSON to XML) – Table View*

To transform data the other way around, select the mode **XML to JSON**.

## Date, time, and interval data

Date and time data types include `DATE`, `TIME`, `DATETIME`, `TIMESTAMP`, and `YEAR`. The dates and times can be passed in different formats, for example:

- `DATE`: March 29 2022, 29-03-2022, 2022/03/29
- `TIME`: 08:30:00, 8:30, 20:30
- `DATETIME`: 2022/03/29 08:30:00
- `TIMESTAMP`: 1616108400 (Unix timestamp), 1616108400000 (Unix ms timestamp)
- `YEAR`: 2022, 22

There are a few ways you can work with dates and times:

- Use the [**Date & Time node**](../../../integrations/builtin/core-nodes/n8n-nodes-base.datetime/) to convert date and time data to different formats and calculate dates.
- Use [**Schedule Trigger node**](../../../integrations/builtin/core-nodes/n8n-nodes-base.scheduletrigger/) to schedule workflows to run at a specific time, interval, or duration.

Sometimes, you might need to pause the workflow execution. This might be necessary if you know that a service doesn't process the data instantly or it's slow to return all the results. In these cases, you don't want n8n to pass incomplete data to the next node.

If you run into situations like this, use the [**Wait node**](../../../integrations/builtin/core-nodes/n8n-nodes-base.wait/) after the node that you want to delay. The **Wait node** pauses the workflow execution and will resume execution:

- At a specific time.
- After a specified time interval.
- On a webhook call.

### Date Exercise

Build a workflow that adds five days to an input date from the Customer Datastore node that you used before. Then, if the calculated date occurred after 1959, the workflow waits 1 minute before [setting](../../../integrations/builtin/core-nodes/n8n-nodes-base.set/) the calculated date as a value. The workflow should be triggered every 30 minutes.

To begin:

1. Add the **Customer Datastore (n8n training) node** with the **Get All People** action selected. Return All.
1. Add the **Date & Time node** to Round Up the created Date from the datastore to End of Month. Output this to field new-date. Include all input fields.
1. Add the **If node** to check if that new rounded date is after `1960-01-01 00:00:00`.
1. Add the **Wait node** to the True output of that node and set it to wait for one minute.
1. Add the **Edit Fields (Set) node** to set a new field called outputValue to a String containing new-date. Include all input fields.
1. Add the **Schedule Trigger node** at the beginning of the workflow to trigger it every 30 minutes. (You can keep the [Manual Trigger node](../../../integrations/builtin/core-nodes/n8n-nodes-base.manualworkflowtrigger/) for testing!)

Show me the solution

1. Add the **Customer Datastore (n8n training) node** with the **Get All People** action selected.
   - Select the option to **Return All**.
1. Add a **Date & Time node** connected to the Customer Datastore node. Select the option to **Round a Date**.
   - Add the `created` date as the **Date** to round.
   - Select `Round Up` as the **Mode** and `End of Month` as the **To**.
   - Set the **Output Field Name** as `new-date`.
   - In **Options**, select **Add Option** and use the control to **Include Input Fields**
1. Add an **If node** connected to the **Date & Time node**.
   - Add the new-date field as the first part of the condition.
   - Set the comparison to **Date &Time > is after**
   - Add `1960-01-01 00:00:00` as the second part of the expression. (This should produce 3 items in the True Branch and 2 items in the False Branch)
1. Add a **Wait node** to the True output of the **If node**.
   - Set **Resume** to `After Time interval`.
   - Set **Wait Amount** to `1.00`.
   - Set **Wait Unit** to `Minutes`.
1. Add an **Edit Fields (Set) node** to the **Wait node**.
   - Use either JSON or Manual Mapping **Mode**.
   - Set a new field called `outputValue` to be the value of the new-date field.
   - Select the option to **Include Other Input Fields** and include **All** fields.
1. Add a **Schedule Trigger node** at the beginning of the workflow.
   - Set the **Trigger Interval** to use `Minutes`.
   - Set the **Minutes Between Triggers** to 30.
   - To test your schedule, be sure to activate the workflow.
   - Be sure to connect this node to the **Customer Datastore (n8n training) node** you began with!

The workflow should look like this:

*Workflow for transforming dates*

To check the configuration of each node, you can copy the JSON code of this workflow and either paste it into the Editor UI or save it as a file and import from file into a new workflow. See [Export and import workflows](../../../workflows/export-import/) for more information.

```
{
"name": "Course 2, Ch 2, Date exercise",
"nodes": [
	{
	"parameters": {},
	"id": "6bf64d5c-4b00-43cf-8439-3cbf5e5f203b",
	"name": "When clicking \"Execute workflow\"",
	"type": "n8n-nodes-base.manualTrigger",
	"typeVersion": 1,
	"position": [
		620,
		280
	]
	},
	{
	"parameters": {
		"operation": "getAllPeople",
		"returnAll": true
	},
	"id": "a08a8157-99ee-4d50-8fe4-b6d7e16e858e",
	"name": "Customer Datastore (n8n training)",
	"type": "n8n-nodes-base.n8nTrainingCustomerDatastore",
	"typeVersion": 1,
	"position": [
		840,
		360
	]
	},
	{
	"parameters": {
		"operation": "roundDate",
		"date": "={{ $json.created }}",
		"mode": "roundUp",
		"outputFieldName": "new-date",
		"options": {
		"includeInputFields": true
		}
	},
	"id": "f66a4356-2584-44b6-a4e9-1e3b5de53e71",
	"name": "Date & Time",
	"type": "n8n-nodes-base.dateTime",
	"typeVersion": 2,
	"position": [
		1080,
		360
	]
	},
	{
	"parameters": {
		"conditions": {
		"options": {
			"caseSensitive": true,
			"leftValue": "",
			"typeValidation": "strict"
		},
		"conditions": [
			{
			"id": "7c82823a-e603-4166-8866-493f643ba354",
			"leftValue": "={{ $json['new-date'] }}",
			"rightValue": "1960-01-01T00:00:00",
			"operator": {
				"type": "dateTime",
				"operation": "after"
			}
			}
		],
		"combinator": "and"
		},
		"options": {}
	},
	"id": "cea39877-6183-4ea0-9400-e80523636912",
	"name": "If",
	"type": "n8n-nodes-base.if",
	"typeVersion": 2,
	"position": [
		1280,
		360
	]
	},
	{
	"parameters": {
		"amount": 1,
		"unit": "minutes"
	},
	"id": "5aa860b7-c73c-4df0-ad63-215850166f13",
	"name": "Wait",
	"type": "n8n-nodes-base.wait",
	"typeVersion": 1.1,
	"position": [
		1480,
		260
	],
	"webhookId": "be78732e-787d-463e-9210-2c7e8239761e"
	},
	{
	"parameters": {
		"assignments": {
		"assignments": [
			{
			"id": "e058832a-2461-4c6d-b584-043ecc036427",
			"name": "outputValue",
			"value": "={{ $json['new-date'] }}",
			"type": "string"
			}
		]
		},
		"includeOtherFields": true,
		"options": {}
	},
	"id": "be034e9e-3cf1-4264-9d15-b6760ce28f91",
	"name": "Edit Fields",
	"type": "n8n-nodes-base.set",
	"typeVersion": 3.3,
	"position": [
		1700,
		260
	]
	},
	{
	"parameters": {
		"rule": {
		"interval": [
			{
			"field": "minutes",
			"minutesInterval": 30
			}
		]
		}
	},
	"id": "6e8e4308-d0e0-4d0d-bc29-5131b57cf061",
	"name": "Schedule Trigger",
	"type": "n8n-nodes-base.scheduleTrigger",
	"typeVersion": 1.1,
	"position": [
		620,
		480
	]
	}
],
"pinData": {},
"connections": {
	"When clicking \"Execute workflow\"": {
	"main": [
		[
		{
			"node": "Customer Datastore (n8n training)",
			"type": "main",
			"index": 0
		}
		]
	]
	},
	"Customer Datastore (n8n training)": {
	"main": [
		[
		{
			"node": "Date & Time",
			"type": "main",
			"index": 0
		}
		]
	]
	},
	"Date & Time": {
	"main": [
		[
		{
			"node": "If",
			"type": "main",
			"index": 0
		}
		]
	]
	},
	"If": {
	"main": [
		[
		{
			"node": "Wait",
			"type": "main",
			"index": 0
		}
		]
	]
	},
	"Wait": {
	"main": [
		[
		{
			"node": "Edit Fields",
			"type": "main",
			"index": 0
		}
		]
	]
	},
	"Schedule Trigger": {
	"main": [
		[
		{
			"node": "Customer Datastore (n8n training)",
			"type": "main",
			"index": 0
		}
		]
	]
	}
}
}
```

## Binary data

Up to now, you have mainly worked with text data. But what if you want to process data that's not text, like images or PDF files? These types of files are represented in the binary numeral system, so they're considered binary data. In this form, binary data doesn't offer you useful information, so you'll need to convert it into a readable form.

In n8n, you can process binary data with the following nodes:

- [HTTP Request](../../../integrations/builtin/core-nodes/n8n-nodes-base.httprequest/) to request and send files from/to web resources and APIs.
- [Read/Write Files from Disk](../../../integrations/builtin/core-nodes/n8n-nodes-base.readwritefile/) to read and write files from/to the machine where n8n is running.
- [Convert to File](../../../integrations/builtin/core-nodes/n8n-nodes-base.converttofile/) to take input data and output it as a file.
- [Extract From File](../../../integrations/builtin/core-nodes/n8n-nodes-base.extractfromfile/) to get data from a binary format and convert it to JSON.

Reading and writing files is only available on self-hosted n8n

Reading and writing files to disk isn't available on n8n Cloud. You'll read and write to the machine where you installed n8n. If you run n8n in Docker, your command runs in the n8n container and not the Docker host. The Read/Write Files From Disk node looks for files relative to the n8n install path. n8n recommends using absolute file paths to prevent any errors.

To read or write a binary file, you need to write the path (location) of the file in the node's `File(s) Selector` parameter (for the Read operation) or in the node's `File Path and Name` parameter (for the Write operation).

Naming the right path

The file path looks slightly different depending on how you are running n8n:

- npm: `~/my_file.json`
- n8n cloud / Docker: `/tmp/my_file.json`

### Binary Exercise 1

For our first binary exercise, let's convert a PDF file to JSON:

1. Make an HTTP request to get this PDF file: `https://media.kaspersky.com/pdf/Kaspersky_Lab_Whitepaper_Anti_blocker.pdf.`
1. Use the **Extract From File node** to convert the file from binary to JSON.

Show me the solution

In the **HTTP Request node**, you should see the PDF file, like this:

*HTTP Request node to get PDF*

When you convert the PDF from binary to JSON using the **Extract From File node**, the result should look like this:

*Extract From File node*

To check the configuration of the nodes, you can copy the JSON workflow code below and paste it into your Editor UI:

```
{
	"name": "Binary to JSON",
	"nodes": [
		{
		"parameters": {},
		"id": "78639a25-b69a-4b9c-84e0-69e045bed1a3",
		"name": "When clicking \"Execute Workflow\"",
		"type": "n8n-nodes-base.manualTrigger",
		"typeVersion": 1,
		"position": [
			480,
			520
		]
		},
		{
		"parameters": {
			"url": "https://media.kaspersky.com/pdf/Kaspersky_Lab_Whitepaper_Anti_blocker.pdf",
			"options": {}
		},
		"id": "a11310df-1287-4e9a-b993-baa6bd4265a6",
		"name": "HTTP Request",
		"type": "n8n-nodes-base.httpRequest",
		"typeVersion": 4.1,
		"position": [
			700,
			520
		]
		},
		{
		"parameters": {
			"operation": "pdf",
			"options": {}
		},
		"id": "88697b6b-fb02-4c3d-a715-750d60413e9f",
		"name": "Extract From File",
		"type": "n8n-nodes-base.extractFromFile",
		"typeVersion": 1,
		"position": [
			920,
			520
		]
		}
	],
	"pinData": {},
	"connections": {
		"When clicking \"Execute Workflow\"": {
		"main": [
			[
			{
				"node": "HTTP Request",
				"type": "main",
				"index": 0
			}
			]
		]
		},
		"HTTP Request": {
		"main": [
			[
			{
				"node": "Extract From File",
				"type": "main",
				"index": 0
			}
			]
		]
		}
	}
}
```

### Binary Exercise 2

For our second binary exercise, let's convert some JSON data to binary:

1. Make an HTTP request to the Poetry DB API `https://poetrydb.org/random/1`.
1. Convert the returned data from JSON to binary using the **Convert to File node**.
1. Write the new binary file data to the machine where n8n is running using the **Read/Write Files From Disk node**.
1. To check that it worked out, use the **Read/Write Files From Disk node** to read the generated binary file.

Show me the solution

The workflow for this exercise looks like this:

*Workflow for moving JSON to binary data*

To check the configuration of the nodes, you can copy the JSON workflow code below and paste it into your Editor UI:

```
{
	"name": "JSON to file and Read-Write",
	"nodes": [
		{
		"parameters": {},
		"id": "78639a25-b69a-4b9c-84e0-69e045bed1a3",
		"name": "When clicking \"Execute Workflow\"",
		"type": "n8n-nodes-base.manualTrigger",
		"typeVersion": 1,
		"position": [
			480,
			520
		]
		},
		{
		"parameters": {
			"url": "https://poetrydb.org/random/1",
			"options": {}
		},
		"id": "a11310df-1287-4e9a-b993-baa6bd4265a6",
		"name": "HTTP Request",
		"type": "n8n-nodes-base.httpRequest",
		"typeVersion": 4.1,
		"position": [
			680,
			520
		]
		},
		{
		"parameters": {
			"operation": "toJson",
			"options": {}
		},
		"id": "06be18f6-f193-48e2-a8d9-35f4779d8324",
		"name": "Convert to File",
		"type": "n8n-nodes-base.convertToFile",
		"typeVersion": 1,
		"position": [
			880,
			520
		]
		},
		{
		"parameters": {
			"operation": "write",
			"fileName": "/tmp/poetrydb.json",
			"options": {}
		},
		"id": "f2048e5d-fa8f-4708-b15a-d07de359f2e5",
		"name": "Read/Write Files from Disk",
		"type": "n8n-nodes-base.readWriteFile",
		"typeVersion": 1,
		"position": [
			1080,
			520
		]
		},
		{
		"parameters": {
			"fileSelector": "={{ $json.fileName }}",
			"options": {}
		},
		"id": "d630906c-09d4-49f4-ba14-416c0f4de1c8",
		"name": "Read/Write Files from Disk1",
		"type": "n8n-nodes-base.readWriteFile",
		"typeVersion": 1,
		"position": [
			1280,
			520
		]
		}
	],
	"pinData": {},
	"connections": {
		"When clicking \"Execute Workflow\"": {
		"main": [
			[
			{
				"node": "HTTP Request",
				"type": "main",
				"index": 0
			}
			]
		]
		},
		"HTTP Request": {
		"main": [
			[
			{
				"node": "Convert to File",
				"type": "main",
				"index": 0
			}
			]
		]
		},
		"Convert to File": {
		"main": [
			[
			{
				"node": "Read/Write Files from Disk",
				"type": "main",
				"index": 0
			}
			]
		]
		},
		"Read/Write Files from Disk": {
		"main": [
			[
			{
				"node": "Read/Write Files from Disk1",
				"type": "main",
				"index": 0
			}
			]
		]
		}
	}
}
```

# Merging and splitting data

In this chapter, you will learn how to merge and split data, and in what cases it might be useful to perform these operations.

## Merging data

In some cases, you might need to merge (combine) and process data from different sources.

Merging data can involve:

- Creating one data set from multiple sources.
- Synchronizing data between multiple systems. This could include removing duplicate data or updating data in one system when it changes in another.

One-way vs. two-way sync

In a one-way sync, data is synchronized in one direction. One system serves as the single source of truth. When information changes in that main system, it automatically changes in the secondary system; but if information changes in the secondary system, the changes aren't reflected in the main system.

In a two-way sync, data is synchronized in both directions (between both systems). When information changes in either of the two systems, it automatically changes in the other one as well.

[This blog tutorial](https://blog.n8n.io/how-to-sync-data-between-two-systems/) explains how to sync data one-way and two-way between two CRMs.

In n8n, you can merge data from two different nodes using the [Merge node](../../../integrations/builtin/core-nodes/n8n-nodes-base.merge/), which provides several merging options:

- [Append](../../../integrations/builtin/core-nodes/n8n-nodes-base.merge/#append)
- [Combine](../../../integrations/builtin/core-nodes/n8n-nodes-base.merge/#combine)
  - [Merge by Fields](../../../integrations/builtin/core-nodes/n8n-nodes-base.merge/#combine-by-matching-fields): requires input fields to match on
  - [Merge by Position](../../../integrations/builtin/core-nodes/n8n-nodes-base.merge/#combine-by-position)
  - [Combine all possible combinations](../../../integrations/builtin/core-nodes/n8n-nodes-base.merge/#combine-by-all-possible-combinations)
- [Choose Branch](../../../integrations/builtin/core-nodes/n8n-nodes-base.merge/#choose-branch)

Notice that Combine > Merge by Fields requires you enter input fields to match on. These fields should contain identical values between the data sources so n8n can properly match data together. In the **Merge node**, they're called `Input 1 Field` and `Input 2 Field`.

*Property Input fields in the Merge node*

Property Input in dot notation

If you want to reference nested values in the **Merge node** parameters `Input 1 Field` and `Input 2 Field`, you need to enter the property key in dot-notation format (as text, not as an expression).

Note

You can also find the **Merge node** under the alias Join. This might be more intuitive if you're familiar with SQL joins.

### Merge Exercise

Build a workflow that merges data from the Customer Datastore node and Code node.

1. Add a **Merge node** that takes `Input 1` from a **Customer Datastore node** and `Input 2` from a **Code node**.
1. In the **Customer Datastore node**, run the operation **Get All People**.
1. In the **Code node**, create an array of two objects with three properties: `name`, `language`, and `country`, where the property `country` has two sub-properties `code` and `name`.
   - Fill out the values of these properties with the information of two characters from the Customer Database.
   - For example, Jay Gatsby's language is English and country name is United States.
1. In the **Merge node**, try out different merge options.

Show me the solution

The workflow for this exercise looks like this:

*Workflow exercise for merging data*

If you merge data with the option **Keep Matches** using the name as the input fields to match, the result should look like this (note this example only contains Jay Gatsby; yours might look different depending on which characters you selected):

*Output of Merge node with option to keep matches*

To check the configuration of the nodes, you can copy the JSON workflow code below and paste it into your Editor UI:

```
{
"meta": {
	"templateCredsSetupCompleted": true,
	"instanceId": "cb484ba7b742928a2048bf8829668bed5b5ad9787579adea888f05980292a4a7"
},
"nodes": [
	{
	"parameters": {
		"mode": "combine",
		"mergeByFields": {
		"values": [
			{
			"field1": "name",
			"field2": "name"
			}
		]
		},
		"options": {}
	},
	"id": "578365f3-26dd-4fa6-9858-f0a5fdfc413b",
	"name": "Merge",
	"type": "n8n-nodes-base.merge",
	"typeVersion": 2.1,
	"position": [
		720,
		580
	]
	},
	{
	"parameters": {},
	"id": "71aa5aad-afdf-4f8a-bca0-34450eee8acc",
	"name": "When clicking \"Execute workflow\"",
	"type": "n8n-nodes-base.manualTrigger",
	"typeVersion": 1,
	"position": [
		260,
		560
	]
	},
	{
	"parameters": {
		"operation": "getAllPeople"
	},
	"id": "497174fe-3cab-4160-8103-78b44efd038d",
	"name": "Customer Datastore (n8n training)",
	"type": "n8n-nodes-base.n8nTrainingCustomerDatastore",
	"typeVersion": 1,
	"position": [
		500,
		460
	]
	},
	{
	"parameters": {
		"jsCode": "return [\n  {\n    'name': 'Jay Gatsby',\n    'language': 'English',\n    'country': {\n      'code': 'US',\n      'name': 'United States'\n    }\n    \n  }\n  \n];"
	},
	"id": "387e8a1e-e796-4f05-8e75-7ce25c786c5f",
	"name": "Code",
	"type": "n8n-nodes-base.code",
	"typeVersion": 2,
	"position": [
		500,
		720
	]
	}
],
"connections": {
	"When clicking \"Execute workflow\"": {
	"main": [
		[
		{
			"node": "Customer Datastore (n8n training)",
			"type": "main",
			"index": 0
		},
		{
			"node": "Code",
			"type": "main",
			"index": 0
		}
		]
	]
	},
	"Customer Datastore (n8n training)": {
	"main": [
		[
		{
			"node": "Merge",
			"type": "main",
			"index": 0
		}
		]
	]
	},
	"Code": {
	"main": [
		[
		{
			"node": "Merge",
			"type": "main",
			"index": 1
		}
		]
	]
	}
},
"pinData": {}
}
```

## Looping

In some cases, you might need to perform the same operation on each element of an array or each data item (for example sending a message to every contact in your address book). In technical terms, you need to iterate through the data (with loops).

n8n generally handles this repetitive processing automatically, as the nodes run once for each item, so you don't need to build loops into your workflows.

However, there are some [exceptions of nodes and operations](../../../flow-logic/looping/#node-exceptions) that will require you to build a loop into your workflow.

To [create a loop in an n8n workflow](../../../flow-logic/looping/#using-loops-in-n8n), you need to connect the output of one node to the input of a previous node, and add an **If node** to check when to stop the loop.

## Splitting data in batches

If you need to process large volumes of incoming data, execute the **Code node** multiple times, or avoid API rate limits, it's best to split the data into batches (groups) and process these batches.

For these processes, use the [**Loop Over Items node**](../../../integrations/builtin/core-nodes/n8n-nodes-base.splitinbatches/). This node splits input data into a specified batch size and, with each iteration, returns a predefined amount of data.

Execution of Loop Over Items node

The **Loop Over Items node** stops executing after all the incoming items get divided into batches and passed on to the next node in the workflow, so it's not necessary to add an **If node** to stop the loop.

### Loop/Batch Exercise

Build a workflow that reads the RSS feed from Medium and dev.to. The workflow should consist of three nodes:

1. A **Code node** that returns the URLs of the RSS feeds of Medium (`https://medium.com/feed/n8n-io`) and dev.to (`https://dev.to/feed/n8n`).
1. A **Loop Over Items node** with `Batch Size: 1`, that takes in the inputs from the **Code node** and **RSS Read node** and iterates over the items.
1. An **RSS Read node** that gets the URL of the Medium RSS feed, passed as an expression: `{{ $json.url }}`.
   - The **RSS Read node** is one of the [exception nodes](../../../flow-logic/looping/#node-exceptions) which processes only the first item it receives, so the **Loop Over Items node** is necessary for iterating over multiple items.

Show me the solution

1. Add a **Code Node**. You can format the code in several ways, one way is:
   - Set **Mode** to `Run Once for All Items`.

   - Set **Language** to `JavaScript`.

   - Copy the code below and paste it into the JavaScript Code editor:

     ```
     let urls = [
     	{
     		json: {
     		url: 'https://medium.com/feed/n8n-io'
     		}
     	},
     	{
     	json: {
     		url: 'https://dev.to/feed/n8n'
     		} 
     	}
     ]
     return urls;
     ```
1. Add a **Loop Over Items node** connected to the **Code node**.
   - Set **Batch Size** to `1`.
1. The **Loop Over Items node** automatically adds a node called "Replace Me". Replace that node with an **RSS Read node**.
   - Set the **URL** to use the url from the Code Node: `{{ $json.url }}`.

The workflow for this exercise looks like this:

*Workflow for getting RSS feeds from two blogs*

To check the configuration of the nodes, you can copy the JSON workflow code below and paste it into your Editor UI:

```
{
"meta": {
	"templateCredsSetupCompleted": true,
	"instanceId": "cb484ba7b742928a2048bf8829668bed5b5ad9787579adea888f05980292a4a7"
},
"nodes": [
	{
	"parameters": {},
	"id": "ed8dc090-ae8c-4db6-a93b-0fa873015c25",
	"name": "When clicking \"Execute workflow\"",
	"type": "n8n-nodes-base.manualTrigger",
	"typeVersion": 1,
	"position": [
		460,
		460
	]
	},
	{
	"parameters": {
		"jsCode": "let urls = [\n  {\n    json: {\n      url: 'https://medium.com/feed/n8n-io'\n    }\n  },\n  {\n   json: {\n     url: 'https://dev.to/feed/n8n'\n   } \n  }\n]\n\nreturn urls;"
	},
	"id": "1df2a9bf-f970-4e04-b906-92dbbc9e8d3a",
	"name": "Code",
	"type": "n8n-nodes-base.code",
	"typeVersion": 2,
	"position": [
		680,
		460
	]
	},
	{
	"parameters": {
		"options": {}
	},
	"id": "3cce249a-0eab-42e2-90e3-dbdf3684e012",
	"name": "Loop Over Items",
	"type": "n8n-nodes-base.splitInBatches",
	"typeVersion": 3,
	"position": [
		900,
		460
	]
	},
	{
	"parameters": {
		"url": "={{ $json.url }}",
		"options": {}
	},
	"id": "50e1c1dc-9a5d-42d3-b7c0-accc31636aa6",
	"name": "RSS Read",
	"type": "n8n-nodes-base.rssFeedRead",
	"typeVersion": 1,
	"position": [
		1120,
		460
	]
	}
],
"connections": {
	"When clicking \"Execute workflow\"": {
	"main": [
		[
		{
			"node": "Code",
			"type": "main",
			"index": 0
		}
		]
	]
	},
	"Code": {
	"main": [
		[
		{
			"node": "Loop Over Items",
			"type": "main",
			"index": 0
		}
		]
	]
	},
	"Loop Over Items": {
	"main": [
		null,
		[
		{
			"node": "RSS Read",
			"type": "main",
			"index": 0
		}
		]
	]
	},
	"RSS Read": {
	"main": [
		[
		{
			"node": "Loop Over Items",
			"type": "main",
			"index": 0
		}
		]
	]
	}
},
"pinData": {}
}
```

# Dealing with errors in workflows

Sometimes you build a nice workflow, but it fails when you try to execute it. Workflow executions may fail for a variety of reasons, ranging from straightforward problems with incorrectly configuring a node or a failure in a third-party service to more mysterious errors.

But don't panic. In this lesson, you'll learn how you can troubleshoot errors so you can get your workflow up and running as soon as possible.

## Checking failed workflows

n8n tracks executions of your workflows.

When one of your workflows fails, you can check the Executions log to see what went wrong. The Executions log shows you a list of the latest execution time, status, mode, and running time of your saved workflows.

Open the Executions log by selecting [**Executions**](../../../workflows/executions/#execution-modes) in the left-side panel.

To investigate a specific failed execution from the list, select the name or the **View** button that appears when you hover over the row of the respective execution.

*Executions log*

This will open the workflow in read-only mode, where you can see the execution of each node. This representation can help you identify at what point the workflow ran into issues.

To toggle between viewing the execution and the editor, select the **Editor | Executions** button at the top of the page.

*Workflow execution view*

## Catching erroring workflows

To catch failed workflows, create a separate [**Error Workflow**](../../../flow-logic/error-handling/) with the [**Error Trigger node**](../../../integrations/builtin/core-nodes/n8n-nodes-base.errortrigger/). This workflow will only execute if the main workflow execution fails.

Use additional nodes in your **Error Workflow** that make sense, like sending notifications about the failed workflow and its errors using email or Slack.

To receive error messages for a failed workflow, set the **Error Workflow** in the [Workflow Settings](../../../workflows/settings/) to an Error Workflow that uses an **Error Trigger node**.

The only difference between a regular workflow and an Error Workflow is that the latter contains an **Error Trigger node**. Make sure to create this node before you set this as another workflow's designated Error Workflow.

Error workflows

- If a workflow uses the Error Trigger node, you don't have to activate the workflow.
- If a workflow contains the Error Trigger node, by default, the workflow uses itself as the error workflow.
- You can't test error workflows when running workflows manually. The Error trigger only runs when an automatic workflow errors.
- You can set the same Error Workflow for multiple workflows.

### Exercise

In the previous chapters, you've built several small workflows. Now, pick one of them that you want to monitor and create an Error Workflow for it:

1. Create a new Error Workflow.
1. Add the **Error Trigger node**.
1. Connect a node for the communication platform of your choice to the Error Trigger node, like [Slack](../../../integrations/builtin/app-nodes/n8n-nodes-base.slack/), [Discord](../../../integrations/builtin/app-nodes/n8n-nodes-base.discord/), [Telegram](../../../integrations/builtin/app-nodes/n8n-nodes-base.telegram/), or even [Gmail](../../../integrations/builtin/app-nodes/n8n-nodes-base.gmail/) or a more generic [Send Email](../../../integrations/builtin/core-nodes/n8n-nodes-base.sendemail/).
1. In the workflow you want to monitor, open the [Workflow Settings](../../../workflows/settings/) and select the new Error Workflow you just created. Note that this workflow needs to run automatically to trigger the error workflow.

Show me the solution

The workflow for this exercise looks like this:

*Error workflow*

To check the configuration of the nodes, you can copy the JSON workflow code below and paste it into your Editor UI:

```
{
	"nodes": [
		{
			"parameters": {},
			"name": "Error Trigger",
			"type": "n8n-nodes-base.errorTrigger",
			"typeVersion": 1,
			"position": [
				720,
				-380
			]
		},
		{
			"parameters": {
				"channel": "channelname",
				"text": "=This workflow {{$node[\"Error Trigger\"].json[\"workflow\"][\"name\"]}}failed.\nHave a look at it here: {{$node[\"Error Trigger\"].json[\"execution\"][\"url\"]}}",
				"attachments": [],
				"otherOptions": {}
			},
			"name": "Slack",
			"type": "n8n-nodes-base.slack",
			"position": [
				900,
				-380
			],
			"typeVersion": 1,
			"credentials": {
				"slackApi": {
					"id": "17",
					"name": "slack_credentials"
				}
			}
		}
	],
	"connections": {
		"Error Trigger": {
			"main": [
				[
					{
						"node": "Slack",
						"type": "main",
						"index": 0
					}
				]
			]
		}
	}
}
```

## Throwing exceptions in workflows

Another way of troubleshooting workflows is to include a [**Stop and Error node**](../../../integrations/builtin/core-nodes/n8n-nodes-base.stopanderror/) in your workflow. This node throws an error. You can specify the error type:

- **Error Message**: returns a custom message about the error
- **Error Object**: returns the type of error

You can only use the **Stop and Error node** as the last node in a workflow.

When to throw errors

Throwing exceptions with the **Stop and Error node** is useful for verifying the data (or assumptions about the data) from a node and returning custom error messages.

If you are working with data from a third-party service, you may come across problems such as:

- Wrongly formatted JSON output
- Data with the wrong type (for example, numeric data that has a non-numeric value)
- Missing values
- Errors from remote servers

Though this kind of invalid data might not cause the workflow to fail right away, it could cause problems later on, and then it can become difficult to track the source error. This is why it's better to throw an error at the time you know there might be a problem.

*Stop and Error node with error message*

# Test your knowledge

Congratulations, you finished the n8n Course Level 2!

You've learned a lot about workflow automation and built quite a complex business workflow. Why not showcase your skills?

You can test your knowledge by taking a **quiz**, which consists of questions about the theoretical concepts and workflows covered in this course.

- You need to have at least 80% correct answers to pass the quiz.
- You can take the quiz as many times as you want.
- There's no time limit on answering the quiz questions.

[Take the quiz!](https://n8n-community.typeform.com/to/r9hDbytg)

## What's next?

- Create new workflows for your work or personal use and share them with us. Don't have any ideas? Find inspiration on the [workflows page](https://n8n.io/workflows) and on our [blog](https://n8n.io/blog/).
- Dive deeper into n8n's features by reading the [docs](../../../).

# Automating a business workflow

Remember [our friend Nathan](../../../level-one/chapter-3/)?

**Nathan 🙋:** Hello, it's me again. My manager was so impressed with my first workflow automation solution that she entrusted me with more responsibility.\
**You 👩‍🔧:** More work and responsibility. Congratulations, I guess. What do you need to do now?\
**Nathan 🙋:** I got access to all our sales data and I'm now responsible for creating two reports: one for regional sales and one for orders prices. They're based on data from different sources and come in different formats.\
**You 👩‍🔧:** Sounds like a lot of manual work, but the kind that can be automated. Let's do it!

## Workflow design

Now that we know what Nathan wants to automate, let's list the steps he needs to take to achieve this:

1. Get and combine data from all necessary sources.
1. Sort the data and format the dates.
1. Write binary files.
1. Send notifications using email and Discord.

n8n provides [core nodes](../../../../integrations/builtin/node-types/#core-nodes) for all these steps. This use case is somewhat complex. We should build it from three separate workflows:

1. A workflow that merges the company data with external information.
1. A workflow that generates the reports.
1. A workflow that monitors errors in the second workflow.

## Workflow prerequisites

To build the workflows, you will need the following:

- An [Airtable](https://airtable.com/) account and [credentials](../../../../integrations/builtin/credentials/airtable/).
- A [Google](https://www.google.com/account/about/) account and [credentials](../../../../integrations/builtin/credentials/google/) to access Gmail.
- A [Discord](https://discord.com/) account and webhook URL (you receive this using email when you sign up for this course).

Next, you will build these three workflows with step-by-step instructions.

# Workflow 1: Merging data

Nathan's company stores its customer data in Airtable. This data contains information about the customers' ID, country, email, and join date, but lacks data about their respective region and subregion. You need to fill in these last two fields in order to create the reports for regional sales.

To accomplish this task, you first need to make a copy of this table in your Airtable account:

When setting up your Airtable, ensure that the `customerSince` column is configured as a Date type field with the **Include time** option enabled. Without this setting, you may encounter errors in step 4 when updating the table.

Next, build a small workflow that merges data from Airtable and a REST Countries API:

1. Use the [**Airtable node**](../../../../integrations/builtin/app-nodes/n8n-nodes-base.airtable/) to list the data in the Airtable table named `customers`.
1. Use the [**HTTP Request node**](../../../../integrations/builtin/core-nodes/n8n-nodes-base.httprequest/) to get data from the REST Countries API: `https://restcountries.com/v3.1/all`, and send the query parameter name `fields` with the value `name,region,subregion`. This will return data about world countries, split out into separate items.
1. Use the [**Merge node**](../../../../integrations/builtin/core-nodes/n8n-nodes-base.merge/) to merge data from Airtable and the Countries API by country name, represented as `customerCountry` in Airtable and `name.common` in the Countries API, respectively.
1. Use another Airtable node to update the fields `region` and `subregion` in Airtable with the data from the Countries API.

The workflow should look like this:

*Workflow 1 for merging data from Airtable and the Countries API*

Quiz questions

- How many items does the **HTTP Request node** return?
- How many items does the **Merge node** return?
- How many unique regions are assigned in the customers table?
- What's the subregion assigned to the customerID 10?

# Workflow 2: Generating reports

In this workflow, you will merge data from different sources, transform binary data, generate files, and send notifications about them. The final workflow should look like this:

*Workflow 2 for aggregating data and generating files*

To make things easier, let's split the workflow into three parts.

## Part 1: Getting data from different sources

The first part of the workflow consists of five nodes:

*Workflow 1: Getting data from different sources*

1. Use the [**HTTP Request node**](../../../../integrations/builtin/core-nodes/n8n-nodes-base.httprequest/) to get data from the API endpoint that stores company data. Configure the following node parameters:

   - **Method**: Get
   - **URL**: The **Dataset URL** you received in the email when you signed up for this course.
   - **Authentication**: Generic Credential Type
     - **Generic Auth Type**: Header Auth
     - **Credentials for Header Auth**: The Header Auth name and Header Auth value you received in the email when you signed up for this course.
   - **Send Headers**: Toggle to true
     - **Specify Headers**: Select `Using Fields Below`
     - **Name**: `unique_id`
     - **Value**: The unique ID you received in the email when you signed up for this course.

1. Use the [**Airtable node**](../../../../integrations/builtin/app-nodes/n8n-nodes-base.airtable/) to list data from the `customers` table (where you updated the fields `region` and `subregion`).

1. Use the [**Merge node**](../../../../integrations/builtin/core-nodes/n8n-nodes-base.merge/) to merge data from the Airtable and HTTP Request node, based on matching the input fields for `customerID`.

1. Use the [**Sort node**](../../../../integrations/builtin/core-nodes/n8n-nodes-base.sort/) to sort data by `orderPrice` in descending order.

Quiz questions

- What's the name of the employee assigned to customer 1?
- What's the order status of customer 2?
- What's the highest order price?

## Part 2: Generating file for regional sales

The second part of the workflow consists of four nodes:

*Workflow 2: Generating file for regional sales*

1. Use the [**If node**](../../../../integrations/builtin/core-nodes/n8n-nodes-base.if/) to filter to only display orders from the region `Americas`.
1. Use the [**Convert to File**](../../../../integrations/builtin/core-nodes/n8n-nodes-base.converttofile/) to transform the incoming data from JSON to binary format. Convert each item to a separate file. (Bonus points if you can figure out how to name each report based on the orderID!)
1. Use the [**Gmail node**](../../../../integrations/builtin/app-nodes/n8n-nodes-base.gmail/) (or another email node) to send the files using email to an address you have access to. Note that you need to add an attachment with the data property.
1. Use the [**Discord node**](../../../../integrations/builtin/app-nodes/n8n-nodes-base.discord/) to send a message in the n8n Discord channel `#course-level-two`. In the node, configure the following parameters:
   - **Webhook URL**: The Discord URL you received in the email when you signed up for this course.
   - **Text**: "I sent the file using email with the label ID `{label ID}`. My ID: " followed by the unique ID emailed to you when you registered for this course.\
     Note that you need to replace the text in curly braces `{}` with [expressions](../../../../glossary/#expression-n8n) that reference the data from the nodes.

Quiz questions

- How many orders are assigned to the `Americas` region?
- What's the total price of the orders in the `Americas` region?
- How many items does the **Write Binary File node** return?

## Part 3: Generating files for total sales

The third part of the workflow consists of five nodes:

*Workflow 3: Generating files for total sales*

1. Use the [**Loop Over Items node**](../../../../integrations/builtin/core-nodes/n8n-nodes-base.splitinbatches/) to split data from the Item Lists node into batches of 5.
1. Use the [**Set node**](../../../../integrations/builtin/core-nodes/n8n-nodes-base.set/) to set four values, referenced with expressions from the previous node: `customerEmail`, `customerRegion`, `customerSince`, and `orderPrice`.
1. Use the [**Date & Time node**](../../../../integrations/builtin/core-nodes/n8n-nodes-base.datetime/) to change the date format of the field `customerSince` to the format MM/DD/YYYY.
   - Set the **Include Input Fields** option to keep all the data together.
1. Use the [**Convert to File node**](../../../../integrations/builtin/core-nodes/n8n-nodes-base.converttofile/) to create a CSV spreadsheet with the file name set as the expression: `{{$runIndex > 0 ? 'file_low_orders':'file_high_orders'}}`.
1. Use the [**Discord node**](../../../../integrations/builtin/app-nodes/n8n-nodes-base.discord/) to send a message in the n8n Discord channel `#course-level-two`. In the node, configure the following parameters:
   - **Webhook URL**: The Discord URL you received in the email when you signed up for this course.
   - **Text**: "I created the spreadsheet `{file name}`. My ID:" followed by the unique ID emailed to you when you registered for this course.\
     Note that you need to replace `{file name}` with an expression that references data from the previous **Convert to File node**.

Quiz questions

- What's the lowest order price in the first batch of items?
- What's the formatted date of customer 7?
- How many items does the **Convert to File node** return?

Show me the solution

To check the configuration of the nodes, you can copy the JSON workflow code below and paste it into your Editor UI:

```
{
"meta": {
    "templateCredsSetupCompleted": true,
    "instanceId": "cb484ba7b742928a2048bf8829668bed5b5ad9787579adea888f05980292a4a7"
},
"nodes": [
    {
    "parameters": {
        "sendTo": "bart@n8n.io",
        "subject": "Your TPS Reports",
        "emailType": "text",
        "message": "Please find your TPS report attached.",
        "options": {
        "attachmentsUi": {
            "attachmentsBinary": [
            {}
            ]
        }
        }
    },
    "id": "d889eb42-8b34-4718-b961-38c8e7839ea6",
    "name": "Gmail",
    "type": "n8n-nodes-base.gmail",
    "typeVersion": 2.1,
    "position": [
        2100,
        500
    ],
    "credentials": {
        "gmailOAuth2": {
        "id": "HFesCcFcn1NW81yu",
        "name": "Gmail account 7"
        }
    }
    },
    {
    "parameters": {},
    "id": "c0236456-40be-4f8f-a730-e56cb62b7b5c",
    "name": "When clicking \"Execute workflow\"",
    "type": "n8n-nodes-base.manualTrigger",
    "typeVersion": 1,
    "position": [
        780,
        600
    ]
    },
    {
    "parameters": {
        "url": "https://internal.users.n8n.cloud/webhook/level2-erp",
        "authentication": "genericCredentialType",
        "genericAuthType": "httpHeaderAuth",
        "sendHeaders": true,
        "headerParameters": {
        "parameters": [
            {
            "name": "unique_id",
            "value": "recFIcD6UlSyxaVMQ"
            }
        ]
        },
        "options": {}
    },
    "id": "cc106fa0-6630-4c84-aea4-a4c7a3c149e9",
    "name": "HTTP Request",
    "type": "n8n-nodes-base.httpRequest",
    "typeVersion": 4.1,
    "position": [
        1000,
        500
    ],
    "credentials": {
        "httpHeaderAuth": {
        "id": "qeHdJdqqqaTC69cm",
        "name": "Course L2 Credentials"
        }
    }
    },
    {
    "parameters": {
        "operation": "search",
        "base": {
        "__rl": true,
        "value": "apprtKkVasbQDbFa1",
        "mode": "list",
        "cachedResultName": "All your base",
        "cachedResultUrl": "https://airtable.com/apprtKkVasbQDbFa1"
        },
        "table": {
        "__rl": true,
        "value": "tblInZ7jeNdlUOvxZ",
        "mode": "list",
        "cachedResultName": "Course L2, Workflow 1",
        "cachedResultUrl": "https://airtable.com/apprtKkVasbQDbFa1/tblInZ7jeNdlUOvxZ"
        },
        "options": {}
    },
    "id": "e5ae1927-b531-401c-9cb2-ecf1f2836ba6",
    "name": "Airtable",
    "type": "n8n-nodes-base.airtable",
    "typeVersion": 2,
    "position": [
        1000,
        700
    ],
    "credentials": {
        "airtableTokenApi": {
        "id": "MIplo6lY3AEsdf7L",
        "name": "Airtable Personal Access Token account 4"
        }
    }
    },
    {
    "parameters": {
        "mode": "combine",
        "mergeByFields": {
        "values": [
            {
            "field1": "customerID",
            "field2": "customerID"
            }
        ]
        },
        "options": {}
    },
    "id": "1cddc984-7fca-45e0-83b8-0c502cb4c78c",
    "name": "Merge",
    "type": "n8n-nodes-base.merge",
    "typeVersion": 2.1,
    "position": [
        1220,
        600
    ]
    },
    {
    "parameters": {
        "sortFieldsUi": {
        "sortField": [
            {
            "fieldName": "orderPrice",
            "order": "descending"
            }
        ]
        },
        "options": {}
    },
    "id": "2f55af2e-f69b-4f61-a9e5-c7eefaad93ba",
    "name": "Sort",
    "type": "n8n-nodes-base.sort",
    "typeVersion": 1,
    "position": [
        1440,
        600
    ]
    },
    {
    "parameters": {
        "conditions": {
        "options": {
            "caseSensitive": true,
            "leftValue": "",
            "typeValidation": "strict"
        },
        "conditions": [
            {
            "id": "d3afe65c-7c80-4caa-9d1c-33c62fbc2197",
            "leftValue": "={{ $json.region }}",
            "rightValue": "Americas",
            "operator": {
                "type": "string",
                "operation": "equals",
                "name": "filter.operator.equals"
            }
            }
        ],
        "combinator": "and"
        },
        "options": {}
    },
    "id": "2ed874a9-5bcf-4cc9-9b52-ea503a562892",
    "name": "If",
    "type": "n8n-nodes-base.if",
    "typeVersion": 2,
    "position": [
        1660,
        500
    ]
    },
    {
    "parameters": {
        "operation": "toJson",
        "mode": "each",
        "options": {
        "fileName": "=report_orderID_{{ $('If').item.json.orderID }}.json"
        }
    },
    "id": "d93b4429-2200-4a84-8505-16266fedfccd",
    "name": "Convert to File",
    "type": "n8n-nodes-base.convertToFile",
    "typeVersion": 1.1,
    "position": [
        1880,
        500
    ]
    },
    {
    "parameters": {
        "authentication": "webhook",
        "content": "I sent the file using email with the label ID  and wrote the binary file {file name}. My ID: 123",
        "options": {}
    },
    "id": "26f43f2c-1422-40de-9f40-dd2d80926b1c",
    "name": "Discord",
    "type": "n8n-nodes-base.discord",
    "typeVersion": 2,
    "position": [
        2320,
        500
    ],
    "credentials": {
        "discordWebhookApi": {
        "id": "WEBrtPdoLrhlDYKr",
        "name": "L2 Course Discord Webhook account"
        }
    }
    },
    {
    "parameters": {
        "batchSize": 5,
        "options": {}
    },
    "id": "0fa1fbf6-fe77-4044-a445-c49a1db37dec",
    "name": "Loop Over Items",
    "type": "n8n-nodes-base.splitInBatches",
    "typeVersion": 3,
    "position": [
        1660,
        700
    ]
    },
    {
    "parameters": {
        "assignments": {
        "assignments": [
            {
            "id": "ce839b80-c50d-48f5-9a24-bb2df6fdd2ff",
            "name": "customerEmail",
            "value": "={{ $json.customerEmail }}",
            "type": "string"
            },
            {
            "id": "0c613366-3808-45a2-89cc-b34c7b9f3fb7",
            "name": "region",
            "value": "={{ $json.region }}",
            "type": "string"
            },
            {
            "id": "0f19a88c-deb0-4119-8965-06ed62a840b2",
            "name": "customerSince",
            "value": "={{ $json.customerSince }}",
            "type": "string"
            },
            {
            "id": "a7e890d6-86af-4839-b5df-d2a4efe923f7",
            "name": "orderPrice",
            "value": "={{ $json.orderPrice }}",
            "type": "number"
            }
        ]
        },
        "options": {}
    },
    "id": "09b8584c-4ead-4007-a6cd-edaa4669a757",
    "name": "Edit Fields",
    "type": "n8n-nodes-base.set",
    "typeVersion": 3.3,
    "position": [
        1880,
        700
    ]
    },
    {
    "parameters": {
        "operation": "formatDate",
        "date": "={{ $json.customerSince }}",
        "options": {
        "includeInputFields": true
        }
    },
    "id": "c96fae90-e080-48dd-9bff-3e4506aafb86",
    "name": "Date & Time",
    "type": "n8n-nodes-base.dateTime",
    "typeVersion": 2,
    "position": [
        2100,
        700
    ]
    },
    {
    "parameters": {
        "options": {
        "fileName": "={{$runIndex > 0 ? 'file_low_orders':'file_high_orders'}}"
        }
    },
    "id": "43dc8634-2f16-442b-a754-89f47c51c591",
    "name": "Convert to File1",
    "type": "n8n-nodes-base.convertToFile",
    "typeVersion": 1.1,
    "position": [
        2320,
        700
    ]
    },
    {
    "parameters": {
        "authentication": "webhook",
        "content": "I created the spreadsheet {file name}. My ID: 123",
        "options": {}
    },
    "id": "05da1c22-d1f6-4ea6-9102-f74f9ae2e9d3",
    "name": "Discord1",
    "type": "n8n-nodes-base.discord",
    "typeVersion": 2,
    "position": [
        2540,
        700
    ],
    "credentials": {
        "discordWebhookApi": {
        "id": "WEBrtPdoLrhlDYKr",
        "name": "L2 Course Discord Webhook account"
        }
    }
    }
],
"connections": {
    "Gmail": {
    "main": [
        [
        {
            "node": "Discord",
            "type": "main",
            "index": 0
        }
        ]
    ]
    },
    "When clicking \"Execute workflow\"": {
    "main": [
        [
        {
            "node": "HTTP Request",
            "type": "main",
            "index": 0
        },
        {
            "node": "Airtable",
            "type": "main",
            "index": 0
        }
        ]
    ]
    },
    "HTTP Request": {
    "main": [
        [
        {
            "node": "Merge",
            "type": "main",
            "index": 0
        }
        ]
    ]
    },
    "Airtable": {
    "main": [
        [
        {
            "node": "Merge",
            "type": "main",
            "index": 1
        }
        ]
    ]
    },
    "Merge": {
    "main": [
        [
        {
            "node": "Sort",
            "type": "main",
            "index": 0
        }
        ]
    ]
    },
    "Sort": {
    "main": [
        [
        {
            "node": "Loop Over Items",
            "type": "main",
            "index": 0
        },
        {
            "node": "If",
            "type": "main",
            "index": 0
        }
        ]
    ]
    },
    "If": {
    "main": [
        [
        {
            "node": "Convert to File",
            "type": "main",
            "index": 0
        }
        ]
    ]
    },
    "Convert to File": {
    "main": [
        [
        {
            "node": "Gmail",
            "type": "main",
            "index": 0
        }
        ]
    ]
    },
    "Loop Over Items": {
    "main": [
        null,
        [
        {
            "node": "Edit Fields",
            "type": "main",
            "index": 0
        }
        ]
    ]
    },
    "Edit Fields": {
    "main": [
        [
        {
            "node": "Date & Time",
            "type": "main",
            "index": 0
        }
        ]
    ]
    },
    "Date & Time": {
    "main": [
        [
        {
            "node": "Convert to File1",
            "type": "main",
            "index": 0
        }
        ]
    ]
    },
    "Convert to File1": {
    "main": [
        [
        {
            "node": "Discord1",
            "type": "main",
            "index": 0
        }
        ]
    ]
    },
    "Discord1": {
    "main": [
        [
        {
            "node": "Loop Over Items",
            "type": "main",
            "index": 0
        }
        ]
    ]
    }
},
"pinData": {}
}
```

# Workflow 3: Monitoring workflow errors

Last but not least, let's help Nathan know if there are any errors running the workflow.

To accomplish this task, create an Error workflow that monitors the main workflow:

1. Create a new workflow.

1. Add an **Error Trigger node** (and execute it as a test).

1. Connect a **Discord node** to the **Error Trigger node** and configure these fields:

   - **Webhook URL**: The Discord URL that you received in the email from n8n when you signed up for this course.

   - **Text**: "The workflow `{workflow name}` failed, with the error message: `{execution error message}`. Last node executed: `{name of the last executed node}`. Check this workflow execution here: `{execution URL}` My Unique ID: " followed by the unique ID emailed to you when you registered for this course.

     Note that you need to replace the text in curly brackets `{}` with expressions that take the respective information from the Error Trigger node.

1. Execute the Discord node.

1. Set the newly created workflow as the **Error Workflow** for the main workflow you created in the previous lesson.

The workflow should look like this:

*Workflow 3 for monitoring workflow errors*

Quiz questions

- What fields does the **Error Trigger node** return?
- What information about the execution does the **Error Trigger node** return?
- What information about the workflow does the **Error Trigger node** return?
- What's the expression to reference the workflow name?

# Credentials

[Credentials](../glossary/#credential-n8n) are private pieces of information issued by apps and services to authenticate you as a user and allow you to connect and share information between the app or service and the n8n node.

Access the credentials UI by opening the left menu and selecting **Credentials**. n8n lists credentials you created on the **My credentials** tab. The **All credentials** tab shows all credentials you can use, included credentials shared with you by other users.

- [Create and edit credentials](add-edit-credentials/).
- Learn about [credential sharing](credential-sharing/).
- Find information on setting up credentials for your services in the [credentials library](../integrations/builtin/credentials/).

# Create and edit credentials

Credentials are securely stored authentication information used to connect n8n workflows to external services such as APIs, or databases.

## Create a credential

1. Select the  **Create** button in the upper-left corner of the side menu. Select credential.
1. If your n8n instance supports [projects](../../glossary/#project-n8n), you'll also need to choose whether to create the credential inside your personal space or a specific project you have access to. If you're using the community version, you'll create the credential inside your personal space.
1. Select the app or service you wish to connect to.

Or:

1. Using the **Create** button in the upper-right corner from either the **Overview** page or a specific project. Select Credential.
1. If you're doing this from the **Overview** page, you'll create the credential inside your personal space. If you're doing this from inside a project, you'll create the credential inside that specific project.
1. Select the app or service you wish to connect to.

You can also create new credential in the credential drop down when editing a node on the workflow editor.

Once in the credential modal, enter the details required by your service. Refer to your service's page in the [credentials library](../../integrations/builtin/credentials/) for guidance.

When you save a credential, n8n tests it to confirm it works.

Credentials naming

n8n names new credentials "*node name* account" by default. You can rename the credentials by clicking on the name, similarly to renaming nodes. It's good practice to give them names that identify the app or service, type, and purpose of the credential. A naming convention makes it easier to keep track of and identify your credentials.

## Expressions in credentials

You can use [expressions](../../glossary/#expression-n8n) to set credentials dynamically as your workflow runs:

1. In your workflow, find the data path containing the credential. This varies depending on the exact parameter names in your data. Make sure that the data containing the credential is available in the workflow when you get to the node that needs it.
1. When creating your credential, hover over the field where you want to use an expression.
1. Toggle **Expression** on.
1. Enter your expression.

### Example workflow

[View workflow file](/_workflows/credentials/dynamic_credentials_using_expressions.json)

#### Using the example

To load the template into your n8n instance:

1. Download the workflow JSON file.
1. Open a new workflow in your n8n instance.
1. Copy in the JSON, or select **Workflow menu** > **Import from file...**.

The example workflows use Sticky Notes to guide you:

- Yellow: notes and information.
- Green: instructions to run the workflow.
- Orange: you need to change something to make the workflow work.
- Blue: draws attention to a key feature of the example.

# Credential sharing

Feature availability

Available on all Cloud plans, and Enterprise self-hosted plans.

You can share a credential directly with other users to use in their own workflows. Or share a credential in a [project](../../glossary/#project-n8n) for all members of that project to use. Any users using a shared credential won't be able to view or edit the credential details.

Users can share credentials they created and own. Only project admins can share credentials created in and owned by a project. Instance owners and instance admins can view and share all credentials on an instance.

Refer to [Account types](../../user-management/account-types/) for more information about owners and admins.

In [projects](../../user-management/rbac/), a user's role controls how they can interact with the workflows and credentials associated to the projects they're a member of.

## Share a credential

To share a credential:

1. From the left menu, select either **Overview** or a project.
1. Select **Credentials** to see a list of your credentials.
1. Select the credential you want to share.
1. Select **Sharing**.
1. In the **Share with projects or users** dropdown, browse or search for the user or project with which you want to share your credentials.
1. Select a user or project.
1. Select **Save** to apply the changes.

## Remove access to a credential

To unshare a credential:

1. From the left menu, select either **Overview** or a project.
1. Select **Credentials** to see a list of your credentials.
1. Select the credential you want to unshare.
1. Select **Sharing**.
1. Select **trash icon** on the user or project you want to remove from the list of shared users and projects.
1. Select **Save** to apply the changes.

# Data

Data is the information that n8n nodes receive and process. For basic usage of n8n you don't need to understand data structures and manipulation. However, it becomes important if you want to:

- Create your own node
- Write custom [expressions](../glossary/#expression-n8n)
- Use the Function or Function Item node

This section covers:

- [Data structure](data-structure/)
- [Data flow within nodes](data-flow-nodes/)
- [Transforming data](transforming-data/)
- [Process data using code](code/)
- [Pinning](data-pinning/) and [editing](data-editing/) data during workflow development.
- [Data mapping](data-mapping/) and [Item linking](data-mapping/data-item-linking/): how data items link to each other.

## Related resources

### Data transformation nodes

n8n provides a collection of nodes to transform data:

- [Aggregate](../integrations/builtin/core-nodes/n8n-nodes-base.aggregate/): take separate items, or portions of them, and group them together into individual items.
- [Limit](../integrations/builtin/core-nodes/n8n-nodes-base.aggregate/): remove items beyond a defined maximum number.
- [Remove Duplicates](../integrations/builtin/core-nodes/n8n-nodes-base.removeduplicates/): identify and delete items that are identical across all fields or a subset of fields.
- [Sort](../integrations/builtin/core-nodes/n8n-nodes-base.sort/): organize lists of in a desired ordering, or generate a random selection.
- [Split Out](../integrations/builtin/core-nodes/n8n-nodes-base.splitout/): separate a single data item containing a list into multiple items.
- [Summarize](../integrations/builtin/core-nodes/n8n-nodes-base.summarize/): aggregate items together, in a manner similar to Excel pivot tables.

# Binary data

Binary data is any file-type data, such as image files or documents.

This page collects resources relating to binary data in n8n.

## Working with binary data in your workflows

You can process binary data in n8n workflows. n8n provides nodes to help you work with binary data. You can also use code.

### Nodes

There are three key nodes dedicated to handling binary data files:

- [Read/Write Files from Disk](../../integrations/builtin/core-nodes/n8n-nodes-base.readwritefile/) to read and write files from/to the machine where n8n is running.
- [Convert to File](../../integrations/builtin/core-nodes/n8n-nodes-base.converttofile/) to take input data and output it as a file.
- [Extract From File](../../integrations/builtin/core-nodes/n8n-nodes-base.extractfromfile/) to get data from a binary format and convert it to JSON.

There are separate nodes for working with XML and HTML data:

- [HTML](../../integrations/builtin/core-nodes/n8n-nodes-base.html/)
- [XML](../../integrations/builtin/core-nodes/n8n-nodes-base.xml/)

And nodes for performing common tasks:

- [Compression](../../integrations/builtin/core-nodes/n8n-nodes-base.compression/)
- [Edit Image](../../integrations/builtin/core-nodes/n8n-nodes-base.editimage/)
- [FTP](../../integrations/builtin/core-nodes/n8n-nodes-base.ftp/)

You can trigger a workflow based on changes to a local file using the [Local File trigger](../../integrations/builtin/core-nodes/n8n-nodes-base.localfiletrigger/).

To split or concatenate binary data items, use the [data transformation nodes](../#data-transformation-nodes).

### Code

You can use the [Code node](../../code/code-node/) to manipulate binary data in your workflows. For example, [Get the binary data buffer](../../code/cookbook/code-node/get-binary-data-buffer/): get the binary data available in your workflow.

## Configure binary data mode when self-hosting

You can configure how your self-hosted n8n instance handles binary data using the [Binary data environment variables](../../hosting/configuration/environment-variables/binary-data/). This includes tasks such as setting the storage path and choosing how to store binary data.

Your configuration affects how well n8n scales: [Scaling | Binary data filesystem mode](../../hosting/scaling/binary-data/).

Reading and writing binary files can have security implications. If you want to disable reading and writing binary data, use the `NODES_EXCLUDE` environment variable. Refer to [Environment variables | Nodes](../../hosting/configuration/environment-variables/nodes/) for more information.

# Processing data with code

## Function

A function is a block of code designed to perform a certain task. In n8n, you can write custom JavaScript or Python code snippets to add, remove, and update the data you receive from a node.

The [Code](../../integrations/builtin/core-nodes/n8n-nodes-base.code/) node gives you access to the incoming data and you can manipulate it. With this node you can create any function you want using JavaScript code.

# Data editing

n8n allows you to edit [pinned data](../data-pinning/). This means you can check different scenarios without setting up each scenario and sending the relevant data from your external system. It makes it easier to test edge cases.

For development only

Data editing isn't available for production workflow executions. It's a feature to help test workflows during development.

## Edit output data

To edit output data:

1. Run the node to load data.
1. In the **OUTPUT** view, select **JSON** to switch to JSON view.
1. Select **Edit** .
1. Edit your data.
1. Select **Save**. n8n saves your data changes and pins your data.

## Use data from previous executions

You can copy data from nodes in previous workflow executions:

1. Open the left menu.
1. Select **Executions**.
1. Browse the workflow executions list to find the one with the data you want to copy.
1. Select **Open Past Execution** .
1. Double click the node whose data you want to copy.
1. If it's table layout, select **JSON** to switch to JSON view.
1. There are two ways to copy the JSON:
1. Select the JSON you want by highlighting it, like selecting text. Then use `ctrl` + `c` to copy it.
1. Select the JSON you want to copy by clicking on a parameter. Then:
   1. Hover over the JSON. n8n displays the **Copy** button.
   1. Select **Copy** .
   1. You can choose what to copy:
      - **Copy Item Path** and **Copy Parameter Path** gives you expressions that access parts of the JSON.
      - **Copy Value**: copies the entire selected JSON.
1. Return to the workflow you're working on:
   1. Open the left menu.
   1. Select **Workflows**.
   1. Select **Open**.
   1. Select the workflow you want to open.
1. Open the node where you want to use the copied data.
1. If there is no data, run the node to load data.
1. In the **OUTPUT** view, select **JSON** to switch to JSON view.
1. Select **Edit** .
1. Paste in the data from the previous execution.
1. Select **Save**. n8n saves your data changes and pins your data.

# Data filtering

Feature availability

Available on Cloud Pro and Enterprise plans.

Search and filter data in the node **INPUT** and **OUTPUT** panels. Use this to check your node's data.

To search:

1. In a node, select **Search** in the **INPUT** or **OUTPUT** panel.
1. Enter your search term.

n8n filters as you type your search, displaying the objects or rows containing the term.

Filtering is purely visual: n8n doesn't change or delete data. The filter resets when you close and reopen the node.

# Data flow within nodes

Nodes can process multiple items.

For example, if you set the Trello node to `Create-Card`, and create an expression that sets `Name` using a property called `name-input-value` from the incoming data, the node creates a card for each item, always choosing the `name-input-value` of the current item.

For example, this input will create two cards. One named `test1` the other one named `test2`:

```
[
	{
		name-input-value: "test1"
	},
	{
		name-input-value: "test2"
	}
]
```

# Data mocking

Data mocking is simulating or faking data. It's useful when developing a workflow. By mocking data, you can:

- Avoid making repeated calls to your data source. This saves time and costs.
- Work with a small, predictable dataset during initial development.
- Avoid the risk of overwriting live data: in the early stages of building your workflow, you don't need to connect your real data source.

## Mocking with real data using data pinning

Using [data pinning](../data-pinning/), you load real data into your workflow, then pin it in the output panel of a node. Using this approach you have realistic data, with only one call to your data source. You can [edit pinned data](../data-editing/).

Use this approach when you need to configure your workflow to handle the exact data structure and parameters provided by your data source.

To pin data in a node:

1. Run the node to load data.
1. In the **OUTPUT** view, select **Pin data** . When data pinning is active, the button is disabled and a "This data is pinned" banner is displayed in the **OUTPUT** view.

Nodes that output binary data

You can't pin data if the output data includes binary data.

## Generate custom data using the Code or Edit Fields nodes

You can create a custom dataset in your workflow using either the [Code node](../../integrations/builtin/core-nodes/n8n-nodes-base.code/) or the [Edit Fields (Set) node](../../integrations/builtin/core-nodes/n8n-nodes-base.set/).

In the Code node, you can create any data set you want, and return it as the node output. In the Edit Fields node, select **Add fields** to add your custom data.

The Edit Fields node is a good choice for small tests. To create more complex datasets, use the Code node.

## Output a sample data set from the Customer Datastore node

The Customer Datastore node provides a fake dataset to work with. Add and execute the node to explore the data.

Use this approach if you need some test data when exploring n8n, and you don't have a real use-case to work with.

# Data pinning

You can 'pin' data during workflow development. Data pinning means saving the output data of a node, and using the saved data instead of fetching fresh data in future workflow executions.

You can use this when working with data from external sources to avoid having to repeat requests to the external system. This can save time and resources:

- If your workflow relies on an external system to trigger it, such as a webhook call, being able to pin data means you don't need to use the external system every time you test the workflow.
- If the external resource has data or usage limits, pinning data during tests avoids consuming your resource limits.
- You can fetch and pin the data you want to test, then have confidence that the data is consistent in all your workflow tests.

You can only pin data for nodes that have a single main output ("error" outputs don't count for this purpose).

For development only

Data pinning isn't available for production workflow executions. It's a feature to help test workflows during development.

## Pin data

To pin data in a node:

1. Run the node to load data.
1. In the **OUTPUT** view, select **Pin data** . When data pinning is active, the button is disabled and a "This data is pinned" banner is displayed in the **OUTPUT** view.

Nodes that output binary data

You can't pin data if the output data includes binary data.

## Unpin data

When data pinning is active, a banner appears at the top of the node's output panel indicating that n8n has pinned the data. To unpin data and fetch fresh data on the next execution, select the **Unpin** link in the banner.

# Data structure

In n8n, all data passed between nodes is an array of objects. It has the following structure:

```
[
	{
		// For most data:
		// Wrap each item in another object, with the key 'json'
		"json": {
			// Example data
			"apple": "beets",
			"carrot": {
				"dill": 1
			}
		},
		// For binary data:
		// Wrap each item in another object, with the key 'binary'
		"binary": {
			// Example data
			"apple-picture": {
				"data": "....", // Base64 encoded binary data (required)
				"mimeType": "image/png", // Best practice to set if possible (optional)
				"fileExtension": "png", // Best practice to set if possible (optional)
				"fileName": "example.png", // Best practice to set if possible (optional)
			}
		}
	},
]
```

Skipping the `json` key and array syntax

From 0.166.0 on, when using the Function node or Code node, n8n automatically adds the `json` key if it's missing. It also automatically wraps your items in an array (`[]`) if needed. This is only the case when using the Function or Code nodes. When building your own nodes, you must still make sure the node returns data with the `json` key.

## Data item processing

Nodes can process multiple items.

For example, if you set the Trello node to `Create-Card`, and create an expression that sets `Name` using a property called `name-input-value` from the incoming data, the node creates a card for each item, always choosing the `name-input-value` of the current item.

For example, this input will create two cards. One named `test1` the other one named `test2`:

```
[
	{
		name-input-value: "test1"
	},
	{
		name-input-value: "test2"
	}
]
```

# Data tables

## Overview

Data tables integrate data storage within your n8n environment. Using data tables, you can save, manage, and interact with data directly inside your workflows without relying on external database systems for scenarios such as:

- Persisting data across workflows in the same project
- Storing markers to prevent duplicate runs or control workflow triggers
- Reusing prompts or messages across workflows
- Storing evaluation data for AI workflows
- Storing data generated from workflow executions
- Combining data from different sources to enrich your datasets
- Creating lookup tables as quick reference points within workflows

## How to use data tables

There are two parts to working with data tables: creating them and interacting with them in workflows.

### Step 1: Creating a data table

1. In your n8n project, select the **Data tables** tab.
1. Click the split button located in the top right corner and select **Create Data table**.
1. Enter a descriptive name for your table.

In the table view that appears, you can:

- Add and reorder columns to organize your data
- Add, delete, and update rows
- Edit existing data

### Step 2: Interacting with Data tables in workflows

Interact with data tables in your workflow using the **Data table** node, which allows you to retreive, update, and manipulate the data stored in a Data table.

See [Data table node](../../integrations/builtin/core-nodes/n8n-nodes-base.datatable/).

## Considerations and limitations of data tables

- Data tables are suitable for light to moderate data storage. By default, a data table can't contain more than 50MB of data. In self-hosted environments, you can increase this default size limit using the environment variable `N8N_DATA_TABLES_MAX_SIZE_BYTES`.
- When a data table approaches 80% of your storage limit, a warning will alert you. A final warning appears when you reach the storage limit. Exceeding this limit will disable manual additions to tables and cause workflow execution errors during attempts to insert or update data.
- By default, data tables created within a project are accessible to all team members in that project.
- Tables created in a **Personal** space are only accessible by their creator.

## Data tables versus variables

| Feature                    | Data tables | Variables |
| -------------------------- | ----------- | --------- |
| Unified tabular view       | ✓           | ✗         |
| Row-column relationships   | ✓           | ✗         |
| Cross-project access       | ✗           | ✓         |
| Individual value display   | ✗           | ✓         |
| Optimized for short values | ✗           | ✓         |
| Structured data            | ✓           | ✗         |
| Scoped to projects         | ✓           | ✗         |
| Use values as expressions  | ✗           | ✓         |

## Exporting and importing data

To transfer data between n8n and external tools, use workflows that:

1. Retrieve data from a data table.
1. Export it using an API or file export.
1. Import data into another system or data table accordingly.

# Schema Preview

Schema Preview exposes expected schema data from the previous node in the Node Editor without the user having to provide credentials or execute the node. This makes it possible to construct workflows without having to provide credentials in advance. The preview doesn't include mock data, but it does expose the expected fields, making it possible to select and incorporate them into the input of subsequent nodes.

## Using the preview

1. There must be a node with Schema Preview available in your workflow.
1. When clicking on the details of the next node in the sequence, the Schema Preview data will show up in the Node Editor where schema data would typically be exposed.
1. Use data from the Schema Preview just as you would other schemas - drag and drop fields as input into your node parameters and settings.

# Transforming data

n8n uses a predefined [data structure](../data-structure/) that allows all nodes to process incoming data correctly.

Your incoming data may have a different data structure, in which case you will need to transform it to allow each item to be processed individually.

For example, the image below shows the output of an [HTTP Request](../../integrations/builtin/core-nodes/n8n-nodes-base.httprequest/) node that returns data incompatible with n8n's data structure. The node returns the data and displays that only one item was returned.

To transform this kind of structure into the n8n data structure you can use the data transformation nodes:

- [Aggregate](../../integrations/builtin/core-nodes/n8n-nodes-base.aggregate/): take separate items, or portions of them, and group them together into individual items.
- [Limit](../../integrations/builtin/core-nodes/n8n-nodes-base.limit/): remove items beyond a defined maximum number.
- [Remove Duplicates](../../integrations/builtin/core-nodes/n8n-nodes-base.removeduplicates/): identify and delete items that are identical across all fields or a subset of fields.
- [Sort](../../integrations/builtin/core-nodes/n8n-nodes-base.sort/): organize lists of in a desired ordering, or generate a random selection.
- [Split Out](../../integrations/builtin/core-nodes/n8n-nodes-base.splitout/): separate a single data item containing a list into multiple items.
- [Summarize](../../integrations/builtin/core-nodes/n8n-nodes-base.summarize/): aggregate items together, in a manner similar to Excel pivot tables.

# Data mapping

Data mapping means referencing data from previous nodes.

This section contains guidance on:

- Mapping data in most scenarios: [Data mapping in the UI](data-mapping-ui/) and [Data mapping in expression](data-mapping-expressions/)
- How to handle [item linking](data-item-linking/) when using the Code node or building your own nodes.

# Mapping in the expressions editor

These examples show how to access linked items in the expressions editor. Refer to [expressions](../../../code/expressions/) for more information on expressions, including built in variables and methods.

For information on errors with mapping and linking items, refer to [Item linking errors](../data-item-linking/item-linking-errors/).

## Access the linked item in a previous node's output

When you use this, n8n works back up the item linking chain, to find the parent item in the given node.

```
// Returns the linked item
{{$("<node-name>").item}}
```

As a longer example, consider a scenario where a node earlier in the workflow has the following output data:

```
[
  {
    "id": "23423532",
    "name": "Jay Gatsby",
  },
  {
    "id": "23423533",
    "name": "José Arcadio Buendía",
  },
  {
    "id": "23423534",
    "name": "Max Sendak",
  },
  {
    "id": "23423535",
    "name": "Zaphod Beeblebrox",
  },
  {
    "id": "23423536",
    "name": "Edmund Pevensie",
  }
]
```

To extract the name, use the following expression:

```
{{$("<node-name>").item.json.name}}
```

### Access the linked item in the current node's input

In this case, the item linking is within the node: find the input item that the node links to an output item.

```
// Returns the linked item
{{$input.item}}
```

As a longer example, consider a scenario where the current node has the following input data:

```
[
  {
    "id": "23423532",
    "name": "Jay Gatsby",
  },
  {
    "id": "23423533",
    "name": "José Arcadio Buendía",
  },
  {
    "id": "23423534",
    "name": "Max Sendak",
  },
  {
    "id": "23423535",
    "name": "Zaphod Beeblebrox",
  },
  {
    "id": "23423536",
    "name": "Edmund Pevensie",
  }
]
```

To extract the name, you'd normally use drag-and-drop [Data mapping](../), but you could also write the following expression:

```
{{$input.item.json.name}}
```

# Mapping in the UI

Data mapping means referencing data from previous nodes. It doesn't include changing (transforming) data, just referencing it.

You can map data in the following ways:

- Using the expressions editor.
- By dragging and dropping data from the **INPUT** into parameters. This generates the expression for you.

For information on errors with mapping and linking items, refer to [Item linking errors](../data-item-linking/item-linking-errors/).

## How to drag and drop data

1. Run your workflow to load data.
1. Open the node where you need to map data.
1. You can map in table, JSON, and schema view:
   - In table view: click and hold a table heading to map top level data, or a field in the table to map nested data.
   - In JSON view: click and hold a key.
   - In schema view: click and hold a key.
1. Drag the item into the field where you want to use the data.

### Understand what you're mapping with drag and drop

Data mapping maps the key path, and loads the key's value into the field. For example, given the following data:

```
[
	{
		"fruit": "apples",
		"color": "green"
	}
]
```

You can map `fruit` by dragging and dropping **fruit** from the **INPUT** into the field where you want to use its value. This creates an expression, `{{ $json.fruit }}`. When the node iterates over input items, the value of the field becomes the value of `fruit` for each item.

### Understand nested data

Given the following data:

```
[
  {
    "name": "First item",
    "nested": {
      "example-number-field": 1,
      "example-string-field": "apples"
    }
  },
  {
    "name": "Second item",
    "nested": {
      "example-number-field": 2,
      "example-string-field": "oranges"
    }
  }
]
```

n8n displays it in table form like this:

# Data item linking

An item is a single piece of data. Nodes receive one or more items, operate on them, and output new items. Each item links back to previous items.

You need to understand this behavior if you're:

- Building a programmatic-style node that implements complex behaviors with its input and output data.
- Using the Code node or expressions editor to access data from earlier items in the workflow.
- Using the Code node for complex behaviors with input and output data.

This section provides:

- A conceptual overview of [Item linking concepts](item-linking-concepts/).
- Information on [Item linking for node creators](item-linking-node-building/).
- Support for end users who need to [Work with the data path](item-linking-code-node/) to retrieve item data from previous nodes, and link items when using the Code node.
- Guidance on troubleshooting [Errors](item-linking-errors/).

# Item linking in the Code node

Use n8n's item linking to access data from items that precede the current item. It also has implications when using the Code node. Most nodes link every output item to an input item. This creates a chain of items that you can work back along to access previous items. For a deeper conceptual overview of this topic, refer to [Item linking concepts](../item-linking-concepts/). This document focuses on practical usage examples.

When using the Code node, there are some scenarios where you need to manually supply item linking information if you want to be able to use `$("<node-name>").item` later in the workflow. All these scenarios only apply if you have more than one incoming item. n8n automatically handles item linking for single items.

These scenarios are when you:

- Add new items: the new items aren't linked to any input.
- Return new items.
- Want to manually control the item linking.

[n8n's automatic item linking](../item-linking-concepts/) handles the other scenarios.

To control item linking, set `pairedItem` when returning data. For example, to link to the item at index 0:

```
[
	{
		"json": {
			. . . 
		},
		// The index of the input item that generated this output item
		"pairedItem": 0
	}
]
```

### `pairedItem` usage example

Take this input data:

```
[
  {
    "id": "23423532",
    "name": "Jay Gatsby"
  },
  {
    "id": "23423533",
    "name": "José Arcadio Buendía"
  },
  {
    "id": "23423534",
    "name": "Max Sendak"
  },
  {
    "id": "23423535",
    "name": "Zaphod Beeblebrox"
  },
  {
    "id": "23423536",
    "name": "Edmund Pevensie"
  }
]
```

And use it to generate new items, containing just the name, along with a new piece of data:

```
newItems = [];
for(let i=0; i<items.length; i++){
  newItems.push(
    {
    "json":
      {
        "name": items[i].json.name,
				"aBrandNewField": "New data for item " + i
      }
    }
  )
}

return newItems;
```

`newItems` is an array of items with no `pairedItem`. This means there's no way to trace back from these items to the items used to generate them.

Add the `pairedItem` object:

```
newItems = [];
for(let i=0; i<items.length; i++){
  newItems.push(
    {
      "json":
        {
          "name": items[i].json.name,
					"aBrandNewField": "New data for item " + i
        },
      "pairedItem": i
    }    
  )
}
return newItems;
```

Each new item now links to the item used to create it.

# Item linking concepts

Each output item created by a node includes metadata that links them to the input item (or items) that the node used to generate them. This creates a chain of items that you can work back along to access previous items. This can be complicated to understand, especially if the node splits or merges data. You need to understand item linking when building your own programmatic nodes, or in some scenarios using the Code node.

This document provides a conceptual overview of this feature. For usage details, refer to:

- [Item linking for node creators](../item-linking-node-building/), for details on how to handle item linking when building a node.
- [Item linking in the Code node](../item-linking-code-node/), to learn how to handle item linking in the Code node.
- [Item linking errors](../item-linking-errors/), to understand the errors you may encounter in the editor UI.

## n8n's automatic item linking

If a node doesn't control how to link input items to output items, n8n tries to guess how to link the items automatically:

- Single input, single output: the output links to the input.
- Single input, multiple outputs: all outputs link to that input.
- Multiple inputs and outputs:
  - If you keep the input items, but change the order (or remove some but keep others), n8n can automatically add the correct linked item information.
  - If the number of inputs and outputs is equal, n8n links the items in order. This means that output-1 links to input-1, output-2 to input-2, and so on.
  - If the number isn't equal, or you create completely new items, n8n can't automatically link items.

If n8n can't link items automatically, and the node doesn't handle the item linking, n8n displays an error. Refer to [Item linking errors](../item-linking-errors/) for more information.

## Item linking example

In this example, it's possible for n8n to link an item in one node back several steps, despite the item order changing. This means the node that sorts movies alphabetically can access information about the linked item in the node that gets famous movie actors.

The methods for accessing linked items are different depending on whether you're using the UI, expressions, or the code node. Explore the following resources:

- [Mapping in the UI](../../data-mapping-ui/)
- [Mapping in the expressions editor](../../data-mapping-expressions/)
- [Item linking in the Code node](../item-linking-code-node/)
- [Item linking errors](../item-linking-errors/)

# Item linking errors

In n8n you can reference data from any previous node. This doesn't have to be the node just before: it can be any previous node in the chain. When referencing nodes further back, you use the expression syntax `$(node_name).item`.

Diagram of threads for different items. Due to the item linking, you can get the actor for each movie using `$('Get famous movie actors').item`.

Since the previous node can have multiple items in it, n8n needs to know which one to use. When using `.item`, n8n figures this out for you behind the scenes. Refer to [Item linking concepts](../item-linking-concepts/) for detailed information on how this works.

`.item` fails if information is missing. To figure out which item to use, n8n maintains a thread back through the workflow's nodes for each item. For a given item, this thread tells n8n which items in previous nodes generated it. To find the matching item in a given previous node, n8n follows this thread back until it reaches the node in question.

When using `.item`, n8n displays an error when:

- The thread is broken
- The thread points to more than one item in the previous node (as it's unclear which one to use)

To solve these errors, you can either avoid using `.item`, or fix the root cause.

You can avoid `.item` by using `.first()`, `.last()` or `.all()[index]` instead. They require you to know the position of the item that you’re targeting within the target node's output items. Refer to [Built in methods and variables | Output of other nodes](../../../../code/builtin/output-other-nodes/) for more detail on these methods.

The fix for the root cause depends on the exact error.

### Fix for 'Info for expressions missing from previous node'

If you see this error message:

> ERROR: Info for expression missing from previous node

There's a node in the chain that doesn't return pairing information. The solution here depends on the type of the previous node:

- Code nodes: make sure you return which input items the node used to produce each output item. Refer to [Item linking in the code node](../item-linking-code-node/) for more information.
- Custom or community nodes: the node creator needs to update the node to return which input items it uses to produce each output item. Refer to [Item linking for node creators](../item-linking-node-building/) for more information.

### Fix for 'Multiple matching items for expression'

This is the error message:

> ERROR: Multiple matching items for expression

Sometimes n8n uses multiple items to create a single item. Examples include the Summarize, Aggregate, and Merge nodes. These nodes can combine information from multiple items.

When you use `.item` and there are multiple possible matches, n8n doesn't know which one to use. To solve this you can either:

- Use `.first()`, `.last()` or `.all()[index]` instead. Refer to [Built in methods and variables | Output of other nodes](../../../../code/builtin/output-other-nodes/) for more detail on these methods.
- Reference a different node that contains the same information, but doesn't have multiple matching items.

# Item linking for node creators

Programmatic-style nodes only

This guidance applies to programmatic-style nodes. If you're using declarative style, n8n handles paired items for you automatically.

Use n8n's item linking to access data from items that precede the current item. n8n needs to know which input item a given output item comes from. If this information is missing, expressions in other nodes may break. As a node developer, you must ensure any items returned by your node support this.

This applies to programmatic nodes (including trigger nodes). You don't need to consider item linking when building a declarative-style node. Refer to [Choose your node building approach](../../../../integrations/creating-nodes/plan/choose-node-method/) for more information on node styles.

Start by reading [Item linking concepts](../item-linking-concepts/), which provides a conceptual overview of item linking, and details of the scenarios where n8n can handle the linking automatically.

If you need to handle item linking manually, do this by setting `pairedItem` on each item your node returns:

```
// Use the pairedItem information of the incoming item
newItem = {
	"json": { . . . },
	"pairedItem": {
		"item": item.pairedItem,
		// Optional: choose the input to use
		// Set this if your node combines multiple inputs
		"input": 0
};

// Or set the index manually
newItem = {
		"json": { . . . }
		"pairedItem": {
			"item": i,
			// Optional: choose the input to use
			// Set this if your node combines multiple inputs
			"input": 0
		},
};
```

# n8n Embed

n8n Embed is part of n8n's paid offering. Using Embed, you can white label n8n, or incorporate it in your software as part of your commercial product.

For more information about when to use Embed, as well as costs and licensing processes, refer to [Embed](https://n8n.io/embed/) on the n8n website.

## Support

The [community forum](https://community.n8n.io/) can help with various issues. If you are a current Embed customer, you can also contact n8n support, using the email provided when you bought the license.

## Russia and Belarus

n8n Embed isn't available in Russia and Belarus. Refer to n8n's blog post [Update on n8n cloud accounts in Russia and Belarus](https://blog.n8n.io/update-on-n8n-cloud-accounts-in-russia-and-belarus/) for more information.

# Configuration

Feature availability

Embed requires an embed license. For more information about when to use Embed, as well as costs and licensing processes, refer to [Embed](https://n8n.io/embed/) on the n8n website.

## Authentication

You can secure n8n by setting up [User management](../../user-management/), n8n's built-in authentication feature.

n8n supports [LDAP](../../user-management/ldap/) and [SAML](../../user-management/saml/).

### Credential overwrites

To offer OAuth login to users, it's possible to overwrite [credentials](../../glossary/#credential-n8n) on a global basis. This credential data isn't visible to users but the backend uses it automatically.

In the Editor UI, n8n hides all overwritten fields by default. This means that users are able to authenticate using OAuth by pressing the "connect" button on the credentials.

n8n offers two ways to apply credential overwrites: using Environment Variable and using the REST API.

#### Using environment variables

You can set credential overwrites using environment variable by setting the `CREDENTIALS_OVERWRITE_DATA` to `{ CREDENTIAL_NAME: { PARAMETER: VALUE }}`.

Warning

Even though this is possible, it isn't recommended. Environment variables aren't protected in n8n, so the data can leak to users.

#### Using REST APIs

The recommended way is to load the data using a custom REST endpoint. Set the `CREDENTIALS_OVERWRITE_ENDPOINT` to a path under which this endpoint should be made available. You can set `CREDENTIALS_OVERWRITE_ENDPOINT_AUTH_TOKEN` to require a token for accessing the endpoint. When this token is configured, the endpoint is only accessible if the token is included in the `Authorization` header as a `Bearer` token.

Note

The endpoint can be called just once for security reasons, unless `CREDENTIALS_OVERWRITE_ENDPOINT_AUTH_TOKEN` is set.

For example:

1. Activate the endpoint by setting the environment variable in the environment n8n runs under:

   ```
   export CREDENTIALS_OVERWRITE_ENDPOINT=send-credentials
   ```

1. A JSON file with the credentials to overwrite is then needed. For example, a `oauth-credentials.json` file to overwrite credentials for Asana and GitHub could look like this:

   ```
   {
       "asanaOAuth2Api": {
           "clientId": "<id>",
           "clientSecret": "<secret>"
       },
       "githubOAuth2Api": {
           "clientId": "<id>",
           "clientSecret": "<secret>"
       }
   }
   ```

1. Then apply it to the instance by sending it using curl:

   ```
   curl -H "Content-Type: application/json" --data @oauth-credentials.json http://localhost:5678/send-credentials
   ```

Note

There are cases when credentials are based on others. For example, the `googleSheetsOAuth2Api` extends the `googleOAuth2Api`. In this case, you can set parameters on the parent credentials (`googleOAuth2Api`) for all child-credentials (`googleSheetsOAuth2Api`) to use.

In case `CREDENTIALS_OVERWRITE_ENDPOINT_AUTH_TOKEN` is set to `secure-token`, the curl command will be:

````
```sh
curl -H "Content-Type: application/json" -H "Authorization: Bearer secure-token" --data @oauth-credentials.json http://localhost:5678/send-credentials
````

```

## Environment variables

n8n has many [environment variables](../../hosting/configuration/environment-variables/) you can configure. Here are the most relevant environment variables for your hosted solution:

| Variable | Type | Default | Description |
| --- | --- | --- | --- |
| `EXECUTIONS_TIMEOUT` | Number | `-1` | Sets a default timeout (in seconds) to all workflows after which n8n stops their execution. Users can override this for individual workflows up to the duration set in `EXECUTIONS_TIMEOUT_MAX`. Set `EXECUTIONS_TIMEOUT` to `-1` to disable. |
| `EXECUTIONS_DATA_PRUNE` | Boolean | `true` | Whether to delete data of past executions on a rolling basis. |
| `EXECUTIONS_DATA_MAX_AGE` | Number | `336` | The execution age (in hours) before it's deleted. |
| `EXECUTIONS_DATA_PRUNE_MAX_COUNT` | Number | `10000` | Maximum number of executions to keep in the database. 0 = no limit |
| `NODES_EXCLUDE` | Array of strings | - | Specify which nodes not to load. For example, to block nodes that can be a security risk if users aren't trustworthy: `NODES_EXCLUDE: "[\"n8n-nodes-base.executeCommand\", \"n8n-nodes-base.readWriteFile\"]"` |
| `NODES_INCLUDE` | Array of strings | - | Specify which nodes to load. |
| `N8N_TEMPLATES_ENABLED` | Boolean | `true` | Enable [workflow templates](../../glossary/#template-n8n) (true) or disable (false). |
| `N8N_TEMPLATES_HOST` | String | `https://api.n8n.io` | Change this if creating your own workflow template library. Note that to use your own workflow templates library, your API must provide the same endpoints and response structure as n8n's. Refer to [Workflow templates](../../workflows/templates/) for more information. |

## Backend hooks

It's possible to define external hooks that n8n executes whenever a specific operation runs. You can use these, for example, to log data, change data, or forbid an action by throwing an error.

### Available hooks

| Hook | Arguments | Description |
| --- | --- | --- |
| `credentials.create` | `[credentialData: ICredentialsDb]` | Called before new credentials get created. Use to restrict the number of credentials. |
| `credentials.delete` | `[id: credentialId]` | Called before credentials get deleted. |
| `credentials.update` | `[credentialData: ICredentialsDb]` | Called before existing credentials are saved. |
| `frontend.settings` | `[frontendSettings: IN8nUISettings]` | Gets called on n8n startup. Allows you to, for example, overwrite frontend data like the displayed OAuth URL. |
| `n8n.ready` | `[app: App]` | Called once n8n is ready. Use to, for example, register custom API endpoints. |
| `n8n.stop` |  | Called when an n8n process gets stopped. Allows you to save some process data. |
| `oauth1.authenticate` | `[oAuthOptions: clientOAuth1.Options, oauthRequestData: {oauth_callback: string}]` | Called before an OAuth1 authentication. Use to overwrite an OAuth callback URL. |
| `oauth2.callback` | `[oAuth2Parameters: {clientId: string, clientSecret: string \| undefined, accessTokenUri: string, authorizationUri: string, redirectUri: string, scopes: string[]}]` | Called in an OAuth2 callback. Use to overwrite an OAuth callback URL. |
| `workflow.activate` | `[workflowData: IWorkflowDb]` | Called before a workflow gets activated. Use to restrict the number of active workflows. |
| `workflow.afterDelete` | `[workflowId: string]` | Called after a workflow gets deleted. |
| `workflow.afterUpdate` | `[workflowData: IWorkflowBase]` | Called after an existing workflow gets saved. |
| `workflow.create` | `[workflowData: IWorkflowBase]` | Called before a workflow gets created. Use to restrict the number of saved workflows. |
| `workflow.delete` | `[workflowId: string]` | Called before a workflow gets delete. |
| `workflow.postExecute` | `[run: IRun, workflowData: IWorkflowBase]` | Called after a workflow gets executed. |
| `workflow.preExecute` | `[workflow: Workflow: mode: WorkflowExecuteMode]` | Called before a workflow gets executed. Allows you to count or limit the number of workflow executions. |
| `workflow.update` | `[workflowData: IWorkflowBase]` | Called before an existing workflow gets saved. |
| `workflow.afterArchive` | `[workflowId: string]` | Called after you archive a workflow. |
| `workflow.afterUnarchive` | `[workflowId: string]` | Called after you restore a workflow from the archive. |

### Registering hooks

Set hooks by registering a hook file that contains the hook functions.
To register a hook, set the environment variable `EXTERNAL_HOOK_FILES`.

You can set the variable to a single file:

`EXTERNAL_HOOK_FILES=/data/hook.js`

Or to contain multiple files separated by a semicolon:

`EXTERNAL_HOOK_FILES=/data/hook1.js;/data/hook2.js`

### Backend hook files

Hook files are regular JavaScript files that have the following format:

```

module.exports = { "frontend": { "settings": [ async function (settings) { settings.oauthCallbackUrls.oauth1 = 'https://n8n.example.com/oauth1/callback'; settings.oauthCallbackUrls.oauth2 = 'https://n8n.example.com/oauth2/callback'; } ] }, "workflow": { "activate": \[ async function (workflowData) { const activeWorkflows = await this.dbCollections.Workflow.count({ active: true });

```
            if (activeWorkflows > 1) {
                throw new Error(
                    'Active workflow limit reached.'
                );
            }
        }
    ]
}
```

}

```

### Backend hook functions

A hook or a hook file can contain multiple hook functions, with all functions executed one after another.

If the parameters of the hook function are objects, it's possible to change the data of that parameter to change the behavior of n8n.

You can also access the database in any hook function using `this.dbCollections` (refer to the code sample in [Backend hook files](#backend-hook-files).

## Frontend external hooks

Like backend external hooks, it's possible to define external hooks in the frontend code that get executed by n8n whenever a user performs a specific operation. You can use them, for example, to log data and change data.

### Available hooks

| Hook | Description |
| --- | --- |
| `credentialsEdit.credentialTypeChanged` | Called when an existing credential's type changes. |
| `credentials.create` | Called when someone creates a new credential. |
| `credentialsList.dialogVisibleChanged` |  |
| `dataDisplay.nodeTypeChanged` |  |
| `dataDisplay.onDocumentationUrlClick` | Called when someone selects the help documentation link. |
| `execution.open` | Called when an existing execution opens. |
| `executionsList.openDialog` | Called when someone selects an execution from existing Workflow Executions. |
| `expressionEdit.itemSelected` |  |
| `expressionEdit.dialogVisibleChanged` |  |
| `nodeCreateList.filteredNodeTypesComputed` |  |
| `nodeCreateList.nodeFilterChanged` | Called when someone makes any changes to the node panel filter. |
| `nodeCreateList.selectedTypeChanged` |  |
| `nodeCreateList.mounted` |  |
| `nodeCreateList.destroyed` |  |
| `nodeSettings.credentialSelected` |  |
| `nodeSettings.valueChanged` |  |
| `nodeView.createNodeActiveChanged` |  |
| `nodeView.addNodeButton` |  |
| `nodeView.createNodeActiveChanged` |  |
| `nodeView.mount` |  |
| `pushConnection.executionFinished` |  |
| `showMessage.showError` |  |
| `runData.displayModeChanged` |  |
| `workflow.activeChange` |  |
| `workflow.activeChangeCurrent` |  |
| `workflow.afterUpdate` | Called when someone updates an existing workflow. |
| `workflow.open` |  |
| `workflowRun.runError` |  |
| `workflowRun.runWorkflow` | Called when a workflow executes. |
| `workflowSettings.dialogVisibleChanged` |  |
| `workflowSettings.saveSettings` | Called when someone saves the settings of a workflow. |

### Registering hooks

You can set hooks by loading the hooks script on the page. One way to do this is by creating a hooks file in the project and adding a script tag in your `editor-ui/public/index.html` file:

```

<script src="frontend-hooks.js"></script>

```

### Frontend hook files

Frontend external hook files are regular JavaScript files which have the following format:

```

window.n8nExternalHooks = { nodeView: { mount: [ function (store, meta) { // do something }, ], createNodeActiveChanged: [ function (store, meta) { // do something }, function (store, meta) { // do something else }, ], addNodeButton: [ function (store, meta) { // do something }, ], }, };

````

### Frontend hook functions

You can define multiple hook functions per hook. Each hook function is invoked with the following arguments arguments:

- `store`: The Vuex store object. You can use this to change or get data from the store.
- `metadata`: The object that contains any data provided by the hook. To see what's passed, search for the hook in the `editor-ui` package.```
````

# Deployment

Feature availability

Embed requires an embed license. For more information about when to use Embed, as well as costs and licensing processes, refer to [Embed](https://n8n.io/embed/) on the n8n website.

See the [hosting documentation](../../hosting/installation/server-setups/) for detailed setup options.

## User data

n8n recommends that you follow the same or similar practices used internally for n8n Cloud: Save user data using [Rook](https://rook.io/) and, if an n8n server goes down, a new instance starts on another machine using the same data.

Due to this, you don't need to use backups except in case of a catastrophic failure, or when a user wants to reactivate their account within your prescribed retention period (two weeks for n8n Cloud).

## Backups

n8n recommends creating nightly backups by attaching another container, and copying all data to this second container. In this manner, RAM usage is negligible, and so doesn't impact the amount of users you can place on the server.

## Restarting

If your instance is down or restarting, missed executions (for example, Cron or Webhook nodes) during this time aren't recoverable. If it's important for you to maintain 100% uptime, you need to build another proxy in front of it which caches the data.

# Workflow management in Embed

Feature availability

Embed requires an embed license. For more information about when to use Embed, as well as costs and licensing processes, refer to [Embed](https://n8n.io/embed/) on the n8n website.

When managing an embedded n8n deployment, spanning across teams or organizations, you will likely need to run the same (or similar) workflows for multiple users. There are two available options for doing so:

| Solution                                                              | Pros                                                               | Cons                                           |
| --------------------------------------------------------------------- | ------------------------------------------------------------------ | ---------------------------------------------- |
| Create a workflow for each user                                       | No limitation on how workflow starts (can use any trigger)         | Requires managing multiple workflows.          |
| Create a single workflow, and pass it user credentials when executing | Simplified workflow management (only need to change one workflow). | To run the workflow, your product must call it |

Warning

The APIs referenced in this document are subject to change at any time. Be sure the check for continued functionality with each version upgrade.

## Workflow per user

There are three general steps to follow:

- Obtain the credentials for each user, and any additional parameters that may be required based on the workflow.
- Create the [n8n credentials](../../glossary/#credential-n8n) for this user.
- Create the workflow.

### 1. Obtain user credentials

Here you need to capture all credentials for any node/service this user must authenticate with, along with any additional parameters required for the particular workflow. The credentials and any parameters needed will depend on your workflow and what you are trying to do.

### 2. Create user credentials

After all relevant credential details have been obtained, you can proceed to create the relevant service credentials in n8n. This can be done using the Editor UI or API call.

#### Using the Editor UI

1. From the menu select **Credentials** > **New**.
1. Use the drop-down to select the **Credential type** to create, for example *Airtable*.
1. In the **Create New Credentials** modal, enter the corresponding credentials details for the user, and select the nodes that will have access to these credentials.
1. Click **Create** to finish and save.

#### Using the API

The frontend API used by the Editor UI can also be called to achieve the same result. The API endpoint is in the format: `https://<n8n-domain>/rest/credentials`.

For example, to create the credentials in the Editor UI example above, the request would be:

```
POST https://<n8n-domain>/rest/credentials
```

With the request body:

```
{
   "name":"MyAirtable",
   "type":"airtableApi",
   "nodesAccess":[
      {
         "nodeType":"n8n-nodes-base.airtable"
      }
   ],
   "data":{
      "apiKey":"q12we34r5t67yu"
   }
}
```

The response will contain the ID of the new credentials, which you will use when creating the workflow for this user:

```
{
   "data":{
      "name":"MyAirtable",
      "type":"airtableApi",
      "data":{
         "apiKey":"q12we34r5t67yu"
      },
      "nodesAccess":[
         {
            "nodeType":"n8n-nodes-base.airtable",
            "date":"2021-09-10T07:41:27.770Z"
         }
      ],
      "id":"29",
      "createdAt":"2021-09-10T07:41:27.777Z",
      "updatedAt":"2021-09-10T07:41:27.777Z"
   }
}
```

### 3. Create the workflow

Best practice is to have a “base” workflow that you then duplicate and customize for each new user with their credentials (and any other details).

You can duplicate and customize your template workflow using either the Editor UI or API call.

#### Using the Editor UI

1. From the menu select **Workflows** > **Open** to open the template workflow to be duplicated.
1. Select **Workflows** > **Duplicate**, then enter a name for this new workflow and click **Save**.
1. Update all relevant nodes to use the credentials for this user (created above).
1. **Save** this workflow set it to **Active** using the toggle in the top-right corner.

#### Using the API

1. Fetch the JSON of the template workflow using the endpoint: `https://<n8n-domain>/rest/workflows/<workflow_id>`

   ```
   GET https://<n8n-domain>/rest/workflows/1012
   ```

The response will contain the JSON data of the selected workflow:

```
{
  "data": {
    "id": "1012",
    "name": "Nathan's Workflow",
    "active": false,
    "nodes": [
      {
        "parameters": {},
        "name": "Start",
        "type": "n8n-nodes-base.start",
        "typeVersion": 1,
        "position": [
          130,
          640
        ]
      },
      {
        "parameters": {
          "authentication": "headerAuth",
          "url": "https://internal.users.n8n.cloud/webhook/custom-erp",
          "options": {
            "splitIntoItems": true
          },
          "headerParametersUi": {
            "parameter": [
              {
                "name": "unique_id",
                "value": "recLhLYQbzNSFtHNq"
              }
            ]
          }
        },
        "name": "HTTP Request",
        "type": "n8n-nodes-base.httpRequest",
        "typeVersion": 1,
        "position": [
          430,
          300
        ],
        "credentials": {
          "httpHeaderAuth": "beginner_course"
        }
      },
      {
        "parameters": {
          "operation": "append",
          "application": "appKBGQfbm6NfW6bv",
          "table": "processingOrders",
          "options": {}
        },
        "name": "Airtable",
        "type": "n8n-nodes-base.airtable",
        "typeVersion": 1,
        "position": [
          990,
          210
        ],
        "credentials": {
          "airtableApi": "Airtable"
        }
      },
      {
        "parameters": {
          "conditions": {
            "string": [
              {
                "value1": "={{$json[\"orderStatus\"]}}",
                "value2": "processing"
              }
            ]
          }
        },
        "name": "IF",
        "type": "n8n-nodes-base.if",
        "typeVersion": 1,
        "position": [
          630,
          300
        ]
      },
      {
        "parameters": {
          "keepOnlySet": true,
          "values": {
            "number": [
              {
                "name": "=orderId",
                "value": "={{$json[\"orderID\"]}}"
              }
            ],
            "string": [
              {
                "name": "employeeName",
                "value": "={{$json[\"employeeName\"]}}"
              }
            ]
          },
          "options": {}
        },
        "name": "Set",
        "type": "n8n-nodes-base.set",
        "typeVersion": 1,
        "position": [
          800,
          210
        ]
      },
      {
        "parameters": {
          "functionCode": "let totalBooked = items.length;\nlet bookedSum = 0;\n\nfor(let i=0; i < items.length; i++) {\n  bookedSum = bookedSum + items[i].json.orderPrice;\n}\nreturn [{json:{totalBooked, bookedSum}}]\n"
        },
        "name": "Function",
        "type": "n8n-nodes-base.function",
        "typeVersion": 1,
        "position": [
          800,
          400
        ]
      },
      {
        "parameters": {
          "webhookUri": "https://discord.com/api/webhooks/865213348202151968/oD5_WPDQwtr22Vjd_82QP3-_4b_lGhAeM7RynQ8Js5DzyXrQEnj0zeAQIA6fki1JLtXE",
          "text": "=This week we have {{$json[\"totalBooked\"]}} booked orders with a total value of {{$json[\"bookedSum\"]}}. My Unique ID: {{$node[\"HTTP Request\"].parameter[\"headerParametersUi\"][\"parameter\"][0][\"value\"]}}"
        },
        "name": "Discord",
        "type": "n8n-nodes-base.discord",
        "typeVersion": 1,
        "position": [
          1000,
          400
        ]
      },
      {
        "parameters": {
          "triggerTimes": {
            "item": [
              {
                "mode": "everyWeek",
                "hour": 9
              }
            ]
          }
        },
        "name": "Cron",
        "type": "n8n-nodes-base.cron",
        "typeVersion": 1,
        "position": [
          220,
          300
        ]
      }
    ],
    "connections": {
      "HTTP Request": {
        "main": [
          [
            {
              "node": "IF",
              "type": "main",
              "index": 0
            }
          ]
        ]
      },
      "Start": {
        "main": [
          []
        ]
      },
      "IF": {
        "main": [
          [
            {
              "node": "Set",
              "type": "main",
              "index": 0
            }
          ],
          [
            {
              "node": "Function",
              "type": "main",
              "index": 0
            }
          ]
        ]
      },
      "Set": {
        "main": [
          [
            {
              "node": "Airtable",
              "type": "main",
              "index": 0
            }
          ]
        ]
      },
      "Function": {
        "main": [
          [
            {
              "node": "Discord",
              "type": "main",
              "index": 0
            }
          ]
        ]
      },
      "Cron": {
        "main": [
          [
            {
              "node": "HTTP Request",
              "type": "main",
              "index": 0
            }
          ]
        ]
      }
    },
    "createdAt": "2021-07-16T11:15:46.066Z",
    "updatedAt": "2021-07-16T12:05:44.045Z",
    "settings": {},
    "staticData": null,
    "tags": []
  }
}
```

1. Save the returned JSON data and update any relevant credentials and fields for the new user.

1. Create a new workflow using the updated JSON as the request body at endpoint: `https://<n8n-domain>/rest/workflows`

   ```
   POST https://<n8n-domain>/rest/workflows/
   ```

The response will contain the ID of the new workflow, which you will use in the next step.

1. Lastly, activate the new workflow:

   ```
   PATCH https://<n8n-domain>/rest/workflows/1012
   ```

Passing the additional value `active` in your JSON payload:

```
// ...
"active":true,
"settings": {},
"staticData": null,
"tags": []
```

## Single workflow

There are four steps to follow to implement this method:

- Obtain the credentials for each user, and any additional parameters that may be required based on the workflow. See [Obtain user credentials](#1-obtain-user-credentials) above.
- Create the n8n credentials for this user. See [Create user credentials](#2-create-user-credentials) above.
- Create the workflow.
- Call the workflow as needed.

### Create the workflow

The details and scope of this workflow will vary greatly according to the individual use case, however there are a few design implementations to keep in mind:

- This workflow must be triggered by a [Webhook](../../integrations/builtin/core-nodes/n8n-nodes-base.webhook/) node.
- The incoming webhook call must contain the user’s credentials and any other workflow parameters required.
- Each node where the user’s credentials are needed should use an [expression](../../code/expressions/) so that the node’s credential field reads the credential provided in the webhook call.
- Save and activate the workflow, ensuring the production URL is selected for the Webhook node. Refer to [webhook node](../../integrations/builtin/core-nodes/n8n-nodes-base.webhook/) for more information.

### Call the workflow

For each new user, or for any existing user as may be needed, call the webhook defined as the workflow trigger and provide the necessary credentials (and any other workflow parameters).

# Prerequisites

Feature availability

Embed requires an embed license. For more information about when to use Embed, as well as costs and licensing processes, refer to [Embed](https://n8n.io/embed/) on the n8n website.

The requirements provided here are an example based on n8n Cloud and are for illustrative purposes only. Your requirements may vary depending on the number of users, workflows, and executions. Contact n8n for more information.

| Component | Sizing                                   | Supported                   |
| --------- | ---------------------------------------- | --------------------------- |
| CPU/vCPU  | Minimum 10 CPU cycles, scaling as needed | Any public or private cloud |
| Database  | 512 MB - 4 GB SSD                        | SQLite or PostgreSQL        |
| Memory    | 320 MB - 2 GB                            |                             |

## CPU considerations

n8n isn't CPU intensive so even small instances (of providers such as AWS and GCP) should be enough for most use cases. Usually, memory requirements supersede CPU requirements, so focus resources there when planning your infrastructure.

## Database considerations

n8n uses its database to store [credentials](../../glossary/#credential-n8n), past executions, and workflows.

A core feature of n8n is the flexibility to choose a database. All the supported databases have different advantages and disadvantages, which you have to consider individually and pick the one that best suits your needs. By default n8n creates an SQLite database if no database exists at the given location.

n8n recommends that every n8n instance have a dedicated database. This helps to prevent dependencies and potential performance degradation. If it isn't possible to provide a dedicated database for every n8n instance, n8n recommends making use of Postgres's schema feature.

For Postgres, the database must already exist on the DB-instance. The database user for the n8n process needs to have full permissions on all tables that they're using or creating. n8n creates and maintains the database schema.

### Best practices

- SSD storage.
- In containerized cloud environments, ensure that the volume is persisted and mounted when stopping/starting a container. If not, all data is lost.
- If using Postgres, don't use the `tablePrefix` configuration option. It will be deprecated in the near future.
- Pay attention to the changelog of new versions and consider reverting migrations before downgrading.
- Set up at least the basic database security and stability mechanisms such as IP allow lists and backups.

## Memory considerations

An n8n instance doesn't typically require large amounts of available memory. For example an n8n Cloud instance at idle requires ~100MB. It's the nature of your workflows and the data being processed that determines your memory requirements.

For example, while most nodes just pass data to the next node in the workflow, the [Code node](../../code/code-node/) creates a pre-processing and post-processing copy of the data. When dealing will large binary files, this can consume all available resources.

# White labelling

Feature availability

Embed requires an embed license. For more information about when to use Embed, as well as costs and licensing processes, refer to [Embed](https://n8n.io/embed/) on the n8n website.

White labelling n8n means customizing the frontend styling and assets to match your brand identity. The process involves changing two packages in n8n's source code [github.com/n8n-io/n8n](https://github.com/n8n-io/n8n):

- [packages/frontend/@n8n/design-system](https://github.com/n8n-io/n8n/tree/master/packages/frontend/@n8n/design-system): n8n's [storybook](https://storybook.js.org/) design system with CSS styles and Vue.js components
- [packages/frontend/editor-ui](https://github.com/n8n-io/n8n/tree/master/packages/frontend/editor-ui): n8n's [Vue.js](https://vuejs.org/) frontend build with [Vite.js](https://vitejs.dev)

## Prerequisites

You need the following installed on your development machine:

- [git](https://git-scm.com/downloads)
- Node.js and npm. Minimum version Node 18.17.0. You can find instructions on how to install both using nvm (Node Version Manager) for Linux, Mac, and WSL [here](https://github.com/nvm-sh/nvm). For Windows users, refer to Microsoft's guide to [Install NodeJS on Windows](https://docs.microsoft.com/en-us/windows/dev-environment/javascript/nodejs-on-windows).

Create a fork of [n8n's repository](https://github.com/n8n-io/n8n) and clone your new repository.

```
git clone https://github.com/<your-organization>/n8n.git n8n
cd n8n
```

Install all dependencies, build and start n8n.

```
npm install
npm run build
npm run start
```

Whenever you make changes you need to rebuild and restart n8n. While developing you can use `npm run dev` to automatically rebuild and restart n8n anytime you make code changes.

## Theme colors

To customize theme colors open [packages/frontend/@n8n/design-system](https://github.com/n8n-io/n8n/tree/master/packages/frontend/@n8n/design-system) and start with:

- [packages/frontend/@n8n/design-system/src/css/\_tokens.scss](https://github.com/n8n-io/n8n/blob/master/packages/frontend/@n8n/design-system/src/css/_tokens.scss)
- [packages/frontend/@n8n/design-system/src/css/\_tokens.dark.scss](https://github.com/n8n-io/n8n/blob/master/packages/frontend/@n8n/design-system/src/css/_tokens.dark.scss)

At the top of `_tokens.scss` you will find `--color-primary` variables as HSL colors:

```
@mixin theme {
	--color-primary-h: 6.9;
	--color-primary-s: 100%;
	--color-primary-l: 67.6%;
```

In the following example the primary color changes to #0099ff. To convert to HSL you can use a [color converter tool](https://www.w3schools.com/colors/colors_converter.asp).

```
@mixin theme {
	--color-primary-h: 204;
	--color-primary-s: 100%;
	--color-primary-l: 50%;
```

## Theme logos

To change the editor’s logo assets look into [packages/frontend/editor-ui/public](https://github.com/n8n-io/n8n/tree/master/packages/frontend/editor-ui/public) and replace:

- favicon-16x16.png
- favicon-32x32.png
- favicon.ico
- n8n-logo.svg
- n8n-logo-collapsed.svg
- n8n-logo-expanded.svg

Replace these logo assets. n8n uses them in Vue.js components, including:

- [MainSidebar.vue](https://github.com/n8n-io/n8n/blob/master/packages/frontend/editor-ui/src/components/MainSidebar.vue): top/left logo in the main sidebar.
- [Logo.vue](https://github.com/n8n-io/n8n/blob/master/packages/frontend/editor-ui/src/components/Logo/Logo.vue): reused in other components.

In the following example replace `n8n-logo-collapsed.svg` and `n8n-logo-expanded.svg` to update the main sidebar's logo assets.

If your logo assets require different sizing or placement you can customize SCSS styles at the bottom of [MainSidebar.vue](https://github.com/n8n-io/n8n/blob/master/packages/frontend/editor-ui/src/components/MainSidebar.vue).

```
.logoItem {
	display: flex;
	justify-content: space-between;
	height: $header-height;
	line-height: $header-height;
	margin: 0 !important;
	border-radius: 0 !important;
	border-bottom: var(--border-width-base) var(--border-style-base) var(--color-background-xlight);
	cursor: default;

	&:hover, &:global(.is-active):hover {
		background-color: initial !important;
	}

	* { vertical-align: middle; }
	.icon {
		height: 18px;
		position: relative;
		left: 6px;
	}

}
```

## Text localization

To change all text occurrences like `n8n` or `n8n.io` to your brand identity you can customize n8n's English internationalization file: [packages/frontend/@n8n/i18n/src/locales/en.json](https://github.com/n8n-io/n8n/blob/master/packages/frontend/@n8n/i18n/src/locales/en.json).

n8n uses the [Vue I18n](https://kazupon.github.io/vue-i18n/) internationalization plugin for Vue.js to translate the majority of UI texts. To search and replace text occurrences inside `en.json` you can use [Linked locale messages](https://kazupon.github.io/vue-i18n/guide/messages.html#linked-locale-messages).

In the following example add the `_brand.name` translation key to white label n8n's [AboutModal.vue](https://github.com/n8n-io/n8n/blob/master/packages/frontend/editor-ui/src/components/AboutModal.vue).

```
{
	"_brand.name": "My Brand",
	//replace n8n with link to _brand.name
	"about.aboutN8n": "About @:_brand.name",
	"about.n8nVersion": "@:_brand.name Version",
}
```

### Window title

To change n8n's window title to your brand name, edit the following:

- [packages/frontend/editor-ui/index.html](https://github.com/n8n-io/n8n/blob/master/packages/frontend/editor-ui/index.html)
- [packages/frontend/editor-ui/src/composables/useDocumentTitle.ts](https://github.com/n8n-io/n8n/blob/master/packages/frontend/editor-ui/src/composables/useDocumentTitle.ts)

The following example replaces all occurrences of `n8n` and `n8n.io` with `My Brand` in `index.html` and `useDocumentTitle.ts`.

```
<!DOCTYPE html>
<html lang="en">
<head>
	<!-- Replace html title attribute -->
	<title>My Brand - Workflow Automation</title>
</head>
```

```
import { useSettingsStore } from '@/stores/settings.store';

// replace n8n
const DEFAULT_TITLE = 'My Brand';
const DEFAULT_TAGLINE = 'Workflow Automation';
```

# Workflow templates

Feature availability

Embed requires an embed license. For more information about when to use Embed, as well as costs and licensing processes, refer to [Embed](https://n8n.io/embed/) on the n8n website.

n8n provides a library of workflow [templates](../../glossary/#template-n8n). When embedding n8n, you can:

- Continue to use n8n's workflow templates library (this is the default behavior)
- Disable workflow templates
- Create your own workflow templates library

## Disable workflow templates

In your environment variables, set `N8N_TEMPLATES_ENABLED` to false.

## Use your own workflow templates library

In your environment variables, set `N8N_TEMPLATES_HOST` to the base URL of your API.

### Endpoints

Your API must provide the same endpoints and data structure as n8n's.

The endpoints are:

| Method | Path                          |
| ------ | ----------------------------- |
| GET    | /templates/workflows/`<id>`   |
| GET    | /templates/search             |
| GET    | /templates/collections/`<id>` |
| GET    | /templates/collections        |
| GET    | /templates/categories         |
| GET    | /health                       |

### Query parameters

The `/templates/search` endpoint accepts the following query parameters:

| Parameter  | Type                                         | Description                                      |
| ---------- | -------------------------------------------- | ------------------------------------------------ |
| `page`     | integer                                      | The page of results to return                    |
| `rows`     | integer                                      | The maximum number of results to return per page |
| `category` | comma-separated list of strings (categories) | The categories to search within                  |
| `search`   | string                                       | The search query                                 |

The `/templates/collections` endpoint accepts the following query parameters:

| Parameter  | Type                                         | Description                     |
| ---------- | -------------------------------------------- | ------------------------------- |
| `category` | comma-separated list of strings (categories) | The categories to search within |
| `search`   | string                                       | The search query                |

### Data schema

You can explore the data structure of the items in the response object returned by endpoints here:

Show `workflow` item data schema

```
{
  "$schema": "http://json-schema.org/draft-07/schema#",
  "title": "Generated schema for Root",
  "type": "object",
  "properties": {
    "id": {
      "type": "number"
    },
    "name": {
      "type": "string"
    },
    "totalViews": {
      "type": "number"
    },
    "price": {},
    "purchaseUrl": {},
    "recentViews": {
      "type": "number"
    },
    "createdAt": {
      "type": "string"
    },
    "user": {
      "type": "object",
      "properties": {
        "username": {
          "type": "string"
        },
        "verified": {
          "type": "boolean"
        }
      },
      "required": [
        "username",
        "verified"
      ]
    },
    "nodes": {
      "type": "array",
      "items": {
        "type": "object",
        "properties": {
          "id": {
            "type": "number"
          },
          "icon": {
            "type": "string"
          },
          "name": {
            "type": "string"
          },
          "codex": {
            "type": "object",
            "properties": {
              "data": {
                "type": "object",
                "properties": {
                  "details": {
                    "type": "string"
                  },
                  "resources": {
                    "type": "object",
                    "properties": {
                      "generic": {
                        "type": "array",
                        "items": {
                          "type": "object",
                          "properties": {
                            "url": {
                              "type": "string"
                            },
                            "icon": {
                              "type": "string"
                            },
                            "label": {
                              "type": "string"
                            }
                          },
                          "required": [
                            "url",
                            "label"
                          ]
                        }
                      },
                      "primaryDocumentation": {
                        "type": "array",
                        "items": {
                          "type": "object",
                          "properties": {
                            "url": {
                              "type": "string"
                            }
                          },
                          "required": [
                            "url"
                          ]
                        }
                      }
                    },
                    "required": [
                      "primaryDocumentation"
                    ]
                  },
                  "categories": {
                    "type": "array",
                    "items": {
                      "type": "string"
                    }
                  },
                  "nodeVersion": {
                    "type": "string"
                  },
                  "codexVersion": {
                    "type": "string"
                  }
                },
                "required": [
                  "categories"
                ]
              }
            }
          },
          "group": {
            "type": "string"
          },
          "defaults": {
            "type": "object",
            "properties": {
              "name": {
                "type": "string"
              },
              "color": {
                "type": "string"
              }
            },
            "required": [
              "name"
            ]
          },
          "iconData": {
            "type": "object",
            "properties": {
              "icon": {
                "type": "string"
              },
              "type": {
                "type": "string"
              },
              "fileBuffer": {
                "type": "string"
              }
            },
            "required": [
              "type"
            ]
          },
          "displayName": {
            "type": "string"
          },
          "typeVersion": {
            "type": "number"
          },
          "nodeCategories": {
            "type": "array",
            "items": {
              "type": "object",
              "properties": {
                "id": {
                  "type": "number"
                },
                "name": {
                  "type": "string"
                }
              },
              "required": [
                "id",
                "name"
              ]
            }
          }
        },
        "required": [
          "id",
          "icon",
          "name",
          "codex",
          "group",
          "defaults",
          "iconData",
          "displayName",
          "typeVersion"
        ]
      }
    }
  },
  "required": [
    "id",
    "name",
    "totalViews",
    "price",
    "purchaseUrl",
    "recentViews",
    "createdAt",
    "user",
    "nodes"
  ]
}
```

Show `category` item data schema

```
{
  "$schema": "http://json-schema.org/draft-07/schema#",
  "type": "object",
  "properties": {
    "id": {
      "type": "number"
    },
    "name": {
      "type": "string"
    }
  },
  "required": [
    "id",
    "name"
  ]
}
```

Show `collection` item data schema

```
{
  "$schema": "http://json-schema.org/draft-07/schema#",
  "type": "object",
  "properties": {
    "id": {
      "type": "number"
    },
    "rank": {
      "type": "number"
    },
    "name": {
      "type": "string"
    },
    "totalViews": {},
    "createdAt": {
      "type": "string"
    },
    "workflows": {
      "type": "array",
      "items": {
        "type": "object",
        "properties": {
          "id": {
            "type": "number"
          }
        },
        "required": [
          "id"
        ]
      }
    },
    "nodes": {
      "type": "array",
      "items": {}
    }
  },
  "required": [
    "id",
    "rank",
    "name",
    "totalViews",
    "createdAt",
    "workflows",
    "nodes"
  ]
}
```

You can also interactively explore n8n's API endpoints:

<https://api.n8n.io/templates/categories>\
<https://api.n8n.io/templates/collections>\
<https://api.n8n.io/templates/search>\
<https://api.n8n.io/health>

You can [contact us](mailto:help@n8n.io) for more support.

## Add your workflows to the n8n library

You can submit your workflows to n8n's template library.

n8n is working on a creator program, and developing a marketplace of templates. This is an ongoing project, and details are likely to change.

Refer to [n8n Creator hub](https://www.notion.so/n8n/n8n-Creator-hub-7bd2cbe0fce0449198ecb23ff4a2f76f) for information on how to submit templates and become a creator.

# Flow logic

n8n allows you to represent complex logic in your workflows.

This section covers:

- [Splitting with conditionals](/flow-logic/splitting/)
- [Merging data](/flow-logic/merging/)
- [Looping](/flow-logic/looping/)
- [Waiting](/flow-logic/waiting/)
- [Sub-workflows](/flow-logic/subworkflows/)
- [Error handling](/flow-logic/error-handling/)
- [Execution order in multi-branch workflows](/flow-logic/execution-order/)

## Related sections

You need some understanding of [Data](../data/) in n8n, including [Data structure](../data/data-structure/) and [Data flow within nodes](../data/data-flow-nodes/).

When building your logic, you'll use n8n's [Core nodes](../integrations/builtin/core-nodes/), including:

- Splitting: [IF](../integrations/builtin/core-nodes/n8n-nodes-base.if/) and [Switch](../integrations/builtin/core-nodes/n8n-nodes-base.switch/).
- Merging: [Merge](../integrations/builtin/core-nodes/n8n-nodes-base.merge/), [Compare Datasets](../integrations/builtin/core-nodes/n8n-nodes-base.comparedatasets/), and [Code](../integrations/builtin/core-nodes/n8n-nodes-base.code/).
- Looping: [IF](../integrations/builtin/core-nodes/n8n-nodes-base.if/) and [Loop Over Items](../integrations/builtin/core-nodes/n8n-nodes-base.splitinbatches/).
- Waiting: [Wait](../integrations/builtin/core-nodes/n8n-nodes-base.wait/).
- Creating sub-workflows: [Execute Workflow](../integrations/builtin/core-nodes/n8n-nodes-base.executeworkflow/) and [Execute Workflow Trigger](../integrations/builtin/core-nodes/n8n-nodes-base.executeworkflowtrigger/).
- Error handling: [Stop And Error](../integrations/builtin/core-nodes/n8n-nodes-base.stopanderror/) and [Error Trigger](../integrations/builtin/core-nodes/n8n-nodes-base.errortrigger/).

# Error handling

When designing your flow logic, it's a good practice to consider potential errors, and set up methods to handle them gracefully. With an error workflow, you can control how n8n responds to a workflow execution failure.

Investigating errors

To investigate failed executions, you can:

- Review your [Executions](../../workflows/executions/), for a [single workflow](../../workflows/executions/single-workflow-executions/) or [all workflows you have access to](../../workflows/executions/all-executions/). You can [load data from previous execution](../../workflows/executions/debug/) into your current workflow.
- Enable [Log streaming](../../log-streaming/).

## Create and set an error workflow

For each workflow, you can set an error workflow in **Workflow Settings**. It runs if an execution fails. This means you can, for example, send email or Slack alerts when a workflow execution errors. The error workflow must start with the [Error Trigger](../../integrations/builtin/core-nodes/n8n-nodes-base.errortrigger/).

You can use the same error workflow for multiple workflows.

1. Create a new workflow, with the Error Trigger as the first node.
1. Give the workflow a name, for example `Error Handler`.
1. Select **Save**.
1. In the workflow where you want to use this error workflow:
   1. Select **Options** > **Settings**.
   1. In **Error workflow**, select the workflow you just created. For example, if you used the name Error Handler, select **Error handler**.
   1. Select **Save**. Now, when this workflow errors, the related error workflow runs.

## Error data

The default error data received by the Error Trigger is:

```
[
	{
		"execution": {
			"id": "231",
			"url": "https://n8n.example.com/execution/231",
			"retryOf": "34",
			"error": {
				"message": "Example Error Message",
				"stack": "Stacktrace"
			},
			"lastNodeExecuted": "Node With Error",
			"mode": "manual"
		},
		"workflow": {
			"id": "1",
			"name": "Example Workflow"
		}
	}
]
```

All information is always present, except:

- `execution.id`: requires the execution to be saved in the database. Not present if the error is in the trigger node of the main workflow, as the workflow doesn't execute.
- `execution.url`: requires the execution to be saved in the database. Not present if the error is in the trigger node of the main workflow, as the workflow doesn't execute.
- `execution.retryOf`: only present when the execution is a retry of a failed execution.

If the error is caused by the trigger node of the main workflow, rather than a later stage, the data sent to the error workflow is different. There's less information in `execution{}` and more in `trigger{}`:

```
{
  "trigger": {
    "error": {
      "context": {},
      "name": "WorkflowActivationError",
      "cause": {
        "message": "",
        "stack": ""
      },
      "timestamp": 1654609328787,
      "message": "",
      "node": {
        . . . 
      }
    },
    "mode": "trigger"
  },
  "workflow": {
    "id": "",
    "name": ""
  }
}
```

## Cause a workflow execution failure using Stop And Error

When you create and set an error workflow, n8n runs it when an execution fails. Usually, this is due to things like errors in node settings, or the workflow running out of memory.

You can add the [Stop And Error](../../integrations/builtin/core-nodes/n8n-nodes-base.stopanderror/) node to your workflow to force executions to fail under your chosen circumstances, and trigger the error workflow.

# Execution order in multi-branch workflows

n8n's node execution order depends on the version of n8n you're using:

- For workflows created before version 1.0: n8n executes the first node of each branch, then the second node of each branch, and so on.
- For workflows created in version 1.0 and above: executes each branch in turn, completing one branch before starting another. n8n orders the branches based on their position on the [canvas](../../glossary/#canvas-n8n), from topmost to bottommost. If two branches are at the same height, the leftmost branch executes first.

You can change the execution order in your [workflow settings](../../workflows/settings/).

# Looping in n8n

Looping is useful when you want to process multiple items or perform an action repeatedly, such as sending a message to every contact in your address book. n8n handles this repetitive processing automatically, meaning you don't need to specifically build loops into your workflows. There are [some nodes](#node-exceptions) where this isn't true.

## Using loops in n8n

n8n nodes take any number of items as input, process these items, and output the results. You can think of each item as a single data point, or a single row in the output table of a node.

Nodes usually run once for each item. For example, if you wanted to send the name and notes of the customers in the Customer Datastore node as a message on Slack, you would:

1. Connect the Slack node to the Customer Datastore node.
1. Configure the parameters.
1. Execute the node.

You would receive five messages: one for each item.

This is how you can process multiple items without having to explicitly connect nodes in a loop.

### Executing nodes once

For situations where you don't want a node to process all received items, for example sending a Slack message only to the first customer, you can do so by toggling the **Execute Once** parameter in the **Settings** tab of that node This setting is helpful when the incoming data contains multiple items and you want to only process the first one.

## Creating loops

n8n typically handles the iteration for all incoming items. However, there are certain scenarios where you will have to create a loop to iterate through all items. Refer to [Node exceptions](#node-exceptions) for a list of nodes that don't automatically iterate over all incoming items.

### Loop until a condition is met

To create a loop in an n8n workflow, connect the output of one node to the input of a previous node. Add an [IF](../../integrations/builtin/core-nodes/n8n-nodes-base.if/) node to check when to stop the loop.

Here is an [example workflow](https://n8n.io/workflows/1130) that implements a loop with an `IF` node:

### Loop until all items are processed

Use the [Loop Over Items](../../integrations/builtin/core-nodes/n8n-nodes-base.splitinbatches/) node when you want to loop until all items are processed. To process each item individually, set **Batch Size** to `1`.

You can batch the data in groups and process these batches. This approach is useful for avoiding API rate limits when processing large incoming data or when you want to process a specific group of returned items.

The Loop Over Items node stops executing after all the incoming items get divided into batches and passed on to the next node in the workflow so it's not necessary to add an IF node to stop the loop.

## Node exceptions

Nodes and operations where you need to design a loop into your workflow:

- [CrateDB](../../integrations/builtin/app-nodes/n8n-nodes-base.cratedb/) executes once for `insert` and `update`.
- [Code](../../integrations/builtin/core-nodes/n8n-nodes-base.code/) node in **Run Once for All Items** mode: processes all the items based on the entered code snippet.
- [Execute Workflow](../../integrations/builtin/core-nodes/n8n-nodes-base.executeworkflow/) node in **Run Once for All Items** mode.
- [HTTP Request](../../integrations/builtin/core-nodes/n8n-nodes-base.httprequest/): you must handle pagination yourself. If your API call returns paginated results you must create a loop to fetch one page at a time.
- [Microsoft SQL](../../integrations/builtin/app-nodes/n8n-nodes-base.microsoftsql/) executes once for `insert`, `update`, and `delete`.
- [MongoDB](../../integrations/builtin/app-nodes/n8n-nodes-base.mongodb/) executes once for `insert` and `update`.
- [QuestDB](../../integrations/builtin/app-nodes/n8n-nodes-base.questdb/) executes once for `insert`.
- [Redis](../../integrations/builtin/app-nodes/n8n-nodes-base.redis/):
  - Info: this operation executes only once, regardless of the number of items in the incoming data.
- [RSS Read](../../integrations/builtin/core-nodes/n8n-nodes-base.rssfeedread/) executes once for the requested URL.
- [TimescaleDB](../../integrations/builtin/app-nodes/n8n-nodes-base.timescaledb/) executes once for `insert` and `update`.

# Merging data

Merging brings multiple data streams together. You can achieve this using different nodes depending on your workflow requirements.

- Merge data from different data streams or nodes: Use the [Merge](../../integrations/builtin/core-nodes/n8n-nodes-base.merge/) node to combine data from various sources into one.
- Merge data from multiple node executions: Use the [Code](../../integrations/builtin/core-nodes/n8n-nodes-base.code/) node for complex scenarios where you need to merge data from multiple executions of a node or multiple nodes.
- Compare and merge data: Use the [Compare Datasets](../../integrations/builtin/core-nodes/n8n-nodes-base.comparedatasets/) node to compare, merge, and output data streams based on the comparison.

Explore each method in more detail in the sections below.

## Merge data from different data streams

If your workflow [splits](../splitting/), you combine the separate streams back into one stream.

Here's an [example workflow](https://n8n.io/workflows/1747-joining-different-datasets/) showing different types of merging: appending data sets, keeping only new items, and keeping only existing items. The [Merge node](../../integrations/builtin/core-nodes/n8n-nodes-base.merge/) documentation contains details on each of the merge operations.

[View template details](https://n8n.io/workflows/1747-joining-different-datasets/)

## Merge data from different nodes

You can use the Merge node to combine data from two previous nodes, even if the workflow hasn't split into separate data streams. This can be useful if you want to generate a single dataset from the data generated by multiple nodes.

Merging data from two previous nodes

## Merge data from multiple node executions

Use the Code node to merge data from multiple node executions. This is useful in some [Looping](../looping/) scenarios.

Node executions and workflow executions

This section describes merging data from multiple node executions. This is when a node executes multiple times during a single workflow execution.

Refer to this [example workflow](https://n8n.io/workflows/1814-merge-multiple-runs-into-one/) using Loop Over Items and Wait to artificially create multiple executions.

[View template details](https://n8n.io/workflows/1814-merge-multiple-runs-into-one/)

## Compare, merge, and split again

The [Compare Datasets](../../integrations/builtin/core-nodes/n8n-nodes-base.comparedatasets/) node compares data streams before merging them. It outputs up to four different data streams.

Refer to this [example workflow](https://n8n.io/workflows/1943-comparing-data-with-the-compare-datasets-node/) for an example.

[View template details](https://n8n.io/workflows/1943-comparing-data-with-the-compare-datasets-node/)

# Splitting workflows with conditional nodes

Splitting uses the [IF](../../integrations/builtin/core-nodes/n8n-nodes-base.if/) or [Switch](../../integrations/builtin/core-nodes/n8n-nodes-base.switch/) nodes. It turns a single-branch workflow into a multi-branch workflow. This is a key piece of representing complex logic in n8n.

Compare these workflows:

This is the power of splitting and conditional nodes in n8n.

Refer to the [IF](../../integrations/builtin/core-nodes/n8n-nodes-base.if/) or [Switch](../../integrations/builtin/core-nodes/n8n-nodes-base.switch/) documentation for usage details.

# Sub-workflows

You can call one workflow from another workflow. This allows you to build modular, microservice-like workflows. It can also help if your workflow grows large enough to encounter [memory issues](../../hosting/scaling/memory-errors/). Creating sub-workflows uses the [Execute Workflow](../../integrations/builtin/core-nodes/n8n-nodes-base.executeworkflow/) and [Execute Sub-workflow Trigger](../../integrations/builtin/core-nodes/n8n-nodes-base.executeworkflowtrigger/) nodes.

Sub-wokflow executions don't count towards your plan's monthly execution or active workflow limits.

## Set up and use a sub-workflow

This section walks through setting up both the parent workflow and sub-workflow.

### Create the sub-workflow

1. Create a new workflow.

   Create sub-workflows from existing workflows

   You can optionally create a sub-workflow directly from an existing parent workflow using the [Execute Sub-workflow](../../integrations/builtin/core-nodes/n8n-nodes-base.executeworkflow/) node. In the node, select the **Database** and **From list** options and select **Create a sub-workflow** in the list.

   You can also extract selected nodes directly using [Sub-workflow conversion](../../workflows/subworkflow-conversion/) in the context menu.

1. **Optional**: configure which workflows can call the sub-workflow:

   1. Select the **Options** menu > **Settings**. n8n opens the **Workflow settings** modal.
   1. Change the **This workflow can be called by** setting. Refer to [Workflow settings](../../workflows/settings/) for more information on configuring your workflows.

1. Add the **Execute Sub-workflow** trigger node (if you are searching under trigger nodes, this is also titled **When Executed by Another Workflow**).

1. Set the **Input data mode** to choose how you will define the sub-workflow's input data:

   - **Define using fields below**: Choose this mode to define individual input names and data types that the calling workflow needs to provide. The [Execute Sub-workflow node](../../integrations/builtin/core-nodes/n8n-nodes-base.executeworkflow/) or [Call n8n Workflow Tool node](../../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.toolworkflow/) in the calling workflow will automatically pull in the fields defined here.
   - **Define using JSON example**: Choose this mode to provide an example JSON object that demonstrates the expected input items and their types.
   - **Accept all data**: Choose this mode to accept all data unconditionally. The sub-workflow won't define any required input items. This sub-workflow must handle any input inconsistencies or missing values.

1. Add other nodes as needed to build your sub-workflow functionality.

1. Save the sub-workflow.

Sub-workflow mustn't contain errors

If there are errors in the sub-workflow, the parent workflow can't trigger it.

Load data into sub-workflow before building

This requires the ability to [load data from previous executions](../../workflows/executions/debug/), which is available on n8n Cloud and registered Community plans.

If you want to load data into your sub-workflow to use while building it:

1. Create the sub-workflow and add the **Execute Sub-workflow Trigger**.
1. Set the node's **Input data mode** to **Accept all data** or define the input items using fields or JSON if they're already known.
1. In the sub-workflow [settings](../../workflows/settings/), set **Save successful production executions** to **Save**.
1. Skip ahead to setting up the parent workflow, and run it.
1. Follow the steps to [load data from previous executions](../../workflows/executions/debug/).
1. Adjust the **Input data mode** to match the input sent by the parent workflow if necessary.

You can now pin example data in the trigger node, enabling you to work with real data while configuring the rest of the workflow.

### Call the sub-workflow

1. Open the workflow where you want to call the sub-workflow.

1. Add the **Execute Sub-workflow** node.

1. In the **Execute Sub-workflow** node, set the sub-workflow you want to call. You can choose to call the workflow by ID, load a workflow from a local file, add workflow JSON as a parameter in the node, or target a workflow by URL.

   Find your workflow ID

   Your sub-workflow's ID is the alphanumeric string at the end of its URL.

1. Fill in the required input items defined by the sub-workflow.

1. Save your workflow.

When your workflow executes, it will send data to the sub-workflow, and run it.

You can follow the execution flow from the parent workflow to the sub-workflow by opening the Execute Sub-workflow node and selecting the **View sub-execution** link. Likewise, the sub-workflow's execution contains a link back to the parent workflow's execution to navigate in the other direction.

## How data passes between workflows

As an example, imagine you have an Execute Sub-workflow node in **Workflow A**. The Execute Sub-workflow node calls another workflow called **Workflow B**:

1. The Execute Sub-workflow node passes the data to the Execute Sub-workflow Trigger node (titled "When executed by another node" in the canvas) of **Workflow B**.
1. The last node of **Workflow B** sends the data back to the Execute Sub-workflow node in **Workflow A**.

## Sub-workflow conversion

See [sub-workflow conversion](../../workflows/subworkflow-conversion/) for how to divide your existing workflows into sub-workflows.

# Waiting

Waiting allows you to pause a workflow mid-execution, then resume where the workflow left off, with the same data. This is useful if you need to rate limit your calls to a service, or wait for an external event to complete. You can wait for a specified duration, or until a webhook fires.

Making a workflow wait uses the [Wait](../../integrations/builtin/core-nodes/n8n-nodes-base.wait/) node. Refer to the node documentation for usage details.

n8n provides a workflow template with a basic example of [Rate limiting and waiting for external events](https://n8n.io/workflows/1749-rate-limiting-and-waiting-for-external-events/).

# How can you contribute?

There are a several ways in which you can contribute to n8n, depending on your skills and interests. Each form of contribution is valuable to us!

## Share some love: Review us

- Star n8n on [GitHub](https://github.com/n8n-io/n8n) and [Docker Hub](https://hub.docker.com/r/n8nio/n8n).
- Follow us on [Twitter](https://twitter.com/n8n_io), [LinkedIn](https://www.linkedin.com/company/28491094), and [Facebook](https://www.facebook.com/n8nio/).
- Upvote n8n on [AlternativeTo](https://alternativeto.net/software/n8n-io/) and [Alternative.me](https://alternative.me/n8n-io).
- Add n8n to your stack on [Stackshare](https://stackshare.io/n8n).
- Write a review about n8n on [G2](https://www.g2.com/products/n8n/reviews), [Slant](https://www.slant.co/improve/options/37977/~n8n-review), and [Capterra](https://www.capterra.com/p/198028/n8n-io/).

## Help out the community

You can participate in the [forum](https://community.n8n.io/) and help the community members out with their questions.

When sharing workflows in the community forum for debugging, use code blocks. Use triple backticks ```` ``` ```` to wrap the workflow JSON in a code block.

The following video demonstrates the steps of sharing workflows on the community forum:

## Contribute a workflow template

You can submit your workflows to n8n's template library.

n8n is working on a creator program, and developing a marketplace of templates. This is an ongoing project, and details are likely to change.

Refer to [n8n Creator hub](https://www.notion.so/n8n/n8n-Creator-hub-7bd2cbe0fce0449198ecb23ff4a2f76f) for information on how to submit templates and become a creator.

## Build a node

Create an integration for a third party service. Check out [the node creation docs](../../integrations/creating-nodes/overview/) for guidance on how to create and publish a community node.

## Contribute to the code

There are different ways in which you can contribute to the n8n code base:

- Fix [issues](https://github.com/n8n-io/n8n/issues) reported on GitHub. The [CONTRIBUTING guide](https://github.com/n8n-io/n8n/blob/master/CONTRIBUTING.md) will help you get your development environment ready in minutes.
- Add additional functionality to an existing third party integration.
- Add a new feature to n8n.

## Contribute to the docs

You can contribute to the n8n documentation, for example by documenting nodes or fixing issues.

The repository for the docs is [here](https://github.com/n8n-io/n8n-docs) and the guidelines for contributing to the docs are [here](https://github.com/n8n-io/n8n-docs/blob/master/CONTRIBUTING.md).

## Contribute to community tutorials

Share your own video or written guides on our [community-driven, searchable library of n8n tutorials and training materials](https://community.n8n.io/t/how-to-share-your-tutorials/48398). Tag them for easy discovery, and post in your language’s subcategory. Follow the contribution guidelines to help keep our growing library high-quality and accessible to everyone.

### How to submit a post

n8n appreciates all contributions. Publishing a tutorial on your own site that supports the community is a great contribution. If you want n8n to highlight your post on the blog, follow these steps:

1. Email your idea to [marketing@n8n.io](mailto:marketing@n8n.io) with the subject "Blog contribution: [Your Topic]."
1. Submit your draft:
   - Write your post in a Google Doc following the [style guide](https://www.notion.so/97dc73436a624933b75ddc941a361b70?pvs=21).
   - If your blog post includes example workflows, include the workflow JSON in a separate section at the end.
   - For author credit, provide a second Google Doc with your full name, a short byline, and your image. n8n will use this to create your author page and credit you as the author of the post.
1. Wait for feedback. We will respond if your draft fits with the blog's strategy and requirements. If you don't hear back within 30 days, it means we won't be moving forward with your blog post.

## Refer a candidate

Do you know someone who would be a great fit for one of our [open positions](https://n8n.io/careers)? Refer them to us! In return, we'll pay you €1,000 when the referral successfully passes their probationary period.

Here's how this works:

1. **Search**: Have a look at the description and requirements of each role, and consider if someone you know would be a great fit.
1. **Referral**: Once you've identified a potential candidate, send an email to [Jobs at n8n](mailto:jobs@n8n.io) with the subject line *Employee referral - [job title]* and a short description of the person you're referring (and the reason why). Also, tell your referral to apply for the job through our [careers page](https://n8n.io/careers).
1. **Evaluation**: We'll screen the application and inform you about the next steps of the hiring process.
1. **Reward**: As soon as your referral has successfully finished the probationary period, we'll reward you for your efforts by transferring the €1,000 to your bank account.

# Get help with n8n

## Where to get help

n8n provides different support options depending on your plan and the nature of your problem.

### n8n community forum

n8n provides free community support for all n8n users through the [forum](https://community.n8n.io/).

This is the best source for answers of all kinds, as both the n8n support team and community members can help.

### Email support

n8n offers email support through the [help@n8n.io](mailto:help@n8n.io) for the following plans:

- [Enterprise plans](https://n8n.io/enterprise/) can use email support with an SLA for technical, account, billing, and other inquiries.
- Other [Cloud plans](https://n8n.io/pricing/) can use email support for admin and billing issues. For technical support, please refer to the forum.

## What to include in your message

When posting to the forum or emailing customer support, you'll get help faster if you provide details in your first message about your n8n instance and the issue you're experiencing.

### Your n8n instance details

To collect basic information about your n8n instance:

1. Open the left-side panel.
1. Select **Help**.
1. Select **About n8n**.
1. The **About n8n** modal opens to display your current information.
1. Select **Copy debug information** to copy your information.
1. Include this information in your forum post or support email.

### Details about your problem

To help resolve your issues more efficiently, here are some things you can include to provide more context:

- **Screenshots or video recordings**: A quick Loom or screen recording that shows what's happening.
- **Relevant documentation**: If you've followed any guides or documentation, include links to them in your message.
- **n8n Cloud workspace (if possible)**: If contacting support, provide the workspace URL for your n8n Cloud instance. It looks something like `https://xxxxx.n8n.app.cloud`.
- **Steps to reproduce the issue**: A simple step-by-step outline of what you did before encountering the issue.
- **Workflow or Configuration files**: Sharing relevant workflows or configuration files can be a huge help.

It may also be helpful to include a [HAR (HTTP Archive) file](<https://en.wikipedia.org/wiki/HAR_(file_format)>) in your message. You can learn how to generate a HAR file in your browser and how to redact sensitive details before posting using the [Har Analizer](https://toolbox.googleapps.com/apps/har_analyzer/).

# Self-hosting n8n

This section provides guidance on setting up n8n for both the Enterprise and Community self-hosted editions. The Community edition is free, the Enterprise edition isn't.

See [Community edition features](community-edition-features/) for a list of available features.

- **Installation and server setups**

  Install n8n on any platform using npm or Docker. Or follow our guides to popular hosting platforms.

  [Docker installation guide](installation/docker/)

- **Configuration**

  Learn how to configure n8n with environment variables.

  [Environment Variables](configuration/environment-variables/)

- **Users and authentication**

  Choose and set up user authentication for your n8n instance.

  [Authentication](configuration/user-management-self-hosted/)

- **Scaling**

  Manage data, modes, and processes to keep n8n running smoothly at scale.

  [Scaling](scaling/queue-mode/)

- **Securing n8n**

  Secure your n8n instance by setting up SSL, SSO, or 2FA or blocking or opting out of some data collection or features.

  [Securing n8n guide](securing/overview/)

- **Starter kits**

  New to n8n or AI? Try our Self-hosted AI Starter Kit. Curated by n8n, it combines the self-hosted n8n platform with compatible AI products and components to get you started building self-hosted AI workflows.

  [Starter kits](starter-kits/ai-starter-kit/)

Self-hosting knowledge prerequisites

Self-hosting n8n requires technical knowledge, including:

- Setting up and configuring servers and containers
- Managing application resources and scaling
- Securing servers and applications
- Configuring n8n

n8n recommends self-hosting for expert users. Mistakes can lead to data loss, security issues, and downtime. If you aren't experienced at managing servers, n8n recommends [n8n Cloud](https://n8n.io/cloud/).

# CLI commands for n8n

n8n includes a CLI (command line interface), allowing you to perform actions using the CLI rather than the n8n editor. These include starting workflows, and exporting and importing workflows and credentials.

## Running CLI commands

You can use CLI commands with self-hosted n8n. Depending on how you choose to install n8n, there are differences in how to run the commands:

- npm: the `n8n` command is directly available. The documentation uses this in the examples below.

- Docker: the `n8n` command is available within your Docker container:

  ```
  docker exec -u node -it <n8n-container-name> <n8n-cli-command>
  ```

## Start a workflow

You can start workflows directly using the CLI.

Execute a saved workflow by its ID:

```
n8n execute --id <ID>
```

## Change the active status of a workflow

You can change the active status of a workflow using the CLI.

Restart required

These commands operate on your n8n database. If you execute them while n8n is running, the changes don't take effect until you restart n8n.

Set the active status of a workflow by its ID to false:

```
n8n update:workflow --id=<ID> --active=false
```

Set the active status of a workflow by its ID to true:

```
n8n update:workflow --id=<ID> --active=true
```

Set the active status to false for all the workflows:

```
n8n update:workflow --all --active=false
```

Set the active status to true for all the workflows:

```
n8n update:workflow --all --active=true
```

## Export entities

You can export your database entities from n8n using the CLI. This tooling allows you to export all entity types from one database type, such as SQLite, and import them into another database type, such as Postgres.

Command flags:

| Flag                                | Description                                                                                    |
| ----------------------------------- | ---------------------------------------------------------------------------------------------- |
| --help                              | Help prompt.                                                                                   |
| --outputDir                         | Output directory path                                                                          |
| --includeExecutionHistoryDataTables | Include execution history data tables, these are excluded by default as they can be very large |

```
n8n export:entities --outputDir ./outputs --includeExecutionHistoryDataTables true
```

## Export workflows and credentials

You can export your workflows and credentials from n8n using the CLI.

Command flags:

| Flag        | Description                                                                                 |
| ----------- | ------------------------------------------------------------------------------------------- |
| --help      | Help prompt.                                                                                |
| --all       | Exports all workflows/credentials.                                                          |
| --backup    | Sets --all --pretty --separate for backups. You can optionally set --output.                |
| --id        | The ID of the workflow to export.                                                           |
| --output    | Outputs file name or directory if using separate files.                                     |
| --pretty    | Formats the output in an easier to read fashion.                                            |
| --separate  | Exports one file per workflow (useful for versioning). Must set a directory using --output. |
| --decrypted | Exports the credentials in a plain text format.                                             |

### Workflows

Export all your workflows to the standard output (terminal):

```
n8n export:workflow --all
```

Export a workflow by its ID and specify the output file name:

```
n8n export:workflow --id=<ID> --output=file.json
```

Export all workflows to a specific directory in a single file:

```
n8n export:workflow --all --output=backups/latest/file.json
```

Export all the workflows to a specific directory using the `--backup` flag (details above):

```
n8n export:workflow --backup --output=backups/latest/
```

### Credentials

Export all your credentials to the standard output (terminal):

```
n8n export:credentials --all
```

Export credentials by their ID and specify the output file name:

```
n8n export:credentials --id=<ID> --output=file.json
```

Export all credentials to a specific directory in a single file:

```
n8n export:credentials --all --output=backups/latest/file.json
```

Export all the credentials to a specific directory using the `--backup` flag (details above):

```
n8n export:credentials --backup --output=backups/latest/
```

Export all the credentials in plain text format. You can use this to migrate from one installation to another that has a different secret key in the configuration file.

Sensitive information

All sensitive information is visible in the files.

```
n8n export:credentials --all --decrypted --output=backups/decrypted.json
```

## Import entities

You can import entities from a previous `export:entities` command using this command, it allows importing of entities into a database type that differs from the exported database type. Current supported database types include: SQLite, Postgres.

The database is expected to be empty prior to import, this can be forced with the `--truncateTables` parameter.

Command flags:

| Flag             | Description                                        |
| ---------------- | -------------------------------------------------- |
| --help           | Help prompt.                                       |
| --inputDir       | Input directory that holds output files for import |
| --truncateTables | Truncate tables before import                      |

```
n8n import:entities --inputDir ./outputs --truncateTables true
```

## Import workflows and credentials

You can import your workflows and credentials from n8n using the CLI.

Update the IDs

When exporting workflows and credentials, n8n also exports their IDs. If you have workflows and credentials with the same IDs in your existing database, they will be overwritten. To avoid this, delete or change the IDs before importing.

Available flags:

| Flag        | Description                                                                                |
| ----------- | ------------------------------------------------------------------------------------------ |
| --help      | Help prompt.                                                                               |
| --input     | Input file name or directory if you use --separate.                                        |
| --projectId | Import the workflow or credential to the specified project. Can't be used with `--userId`. |
| --separate  | Imports `*.json` files from directory provided by --input.                                 |
| --userId    | Import the workflow or credential to the specified user. Can't be used with `--projectId`. |

Migrating to SQLite

n8n limits workflow and credential names to 128 characters, but SQLite doesn't enforce size limits.

This might result in errors like **Data too long for column name** during the import process.

In this case, you can edit the names from the n8n interface and export again, or edit the JSON file directly before importing.

### Workflows

Import workflows from a specific file:

```
n8n import:workflow --input=file.json
```

Import all the workflow files as JSON from the specified directory:

```
n8n import:workflow --separate --input=backups/latest/
```

### Credentials

Import credentials from a specific file:

```
n8n import:credentials --input=file.json
```

Import all the credentials files as JSON from the specified directory:

```
n8n import:credentials --separate --input=backups/latest/
```

## License

### Clear

Clear your existing license from n8n's database and reset n8n to default features:

```
n8n license:clear
```

If your license includes [floating entitlements](../../glossary/#entitlement-n8n), running this command will also attempt to release them back to the pool, making them available for other instances.

### Info

Display information about the existing license:

```
n8n license:info
```

## User management

You can reset user management using the n8n CLI. This returns user management to its pre-setup state. It removes all user accounts.

Use this if you forget your password, and don't have SMTP set up to do password resets by email.

```
n8n user-management:reset
```

### Disable MFA for a user

If a user loses their recovery codes you can disable MFA for a user with this command. The user will then be able to log back in to set up MFA again.

```
n8n mfa:disable --email=johndoe@example.com
```

### Disable LDAP

You can reset the LDAP settings using the command below.

```
n8n ldap:reset
```

## Uninstall community nodes and credentials

You can manage [community nodes](../../integrations/community-nodes/installation/) using the n8n CLI. For now, you can only uninstall community nodes and credentials, which is useful if a community node causes instability.

Command flags:

| Flag         | Description                                                                                                                |
| ------------ | -------------------------------------------------------------------------------------------------------------------------- |
| --help       | Show CLI help.                                                                                                             |
| --credential | The credential type. Get this value by visiting the node's `<NODE>.credential.ts` file and getting the value of `name`.    |
| --package    | Package name of the community node.                                                                                        |
| --uninstall  | Uninstalls the node.                                                                                                       |
| --userId     | The ID of the user who owns the credential. On self-hosted, query the database. On cloud, query the API with your API key. |

### Nodes

Uninstall a community node by package name:

```
n8n community-node --uninstall --package <COMMUNITY_NODE_NAME>
```

For example, to uninstall the [Evolution API community node](https://www.npmjs.com/package/n8n-nodes-evolution-api), type:

```
n8n community-node --uninstall --package n8n-nodes-evolution-api
```

### Credentials

Uninstall a community node credential:

```
n8n community-node --uninstall --credential <CREDENTIAL_TYPE> --userId <ID>
```

For example, to uninstall the [Evolution API community node credential](https://www.npmjs.com/package/n8n-nodes-evolution-api), visit the [repository](https://github.com/oriondesign2015/n8n-nodes-evolution-api) and navigate to the [`credentials.ts` file](https://github.com/oriondesign2015/n8n-nodes-evolution-api/blob/main/credentials/EvolutionApi.credentials.ts) to find the `name`:

```
n8n community-node --uninstall --credential evolutionApi --userId 1234
```

## Security audit

You can run a [security audit](../securing/security-audit/) on your n8n instance, to detect common security issues.

```
n8n audit
```

# Community Edition Features

The community edition includes almost the complete feature set of n8n, except for the features listed here.

The community edition doesn't include these features:

- [Custom Variables](../../code/variables/)
- [Environments](../../source-control-environments/)
- [External secrets](../../external-secrets/)
- [External storage for binary data](../scaling/external-storage/)
- [Log streaming](../../log-streaming/) ([Logging](../logging-monitoring/logging/) *is* included)
- [Multi-main mode](../scaling/queue-mode/#multi-main-setup) ([Queue mode](../scaling/queue-mode/) *is* included)
- [Projects](../../user-management/rbac/projects/)
- SSO ([SAML](../securing/set-up-sso/), [LDAP](../../user-management/ldap/))
- Sharing ([workflows](../../workflows/sharing/), [credentials](../../credentials/credential-sharing/)) (Only the instance owner and the user who creates them can access workflows and credentials)
- [Version control using Git](../../source-control-environments/)
- [Workflow history](../../workflows/history/) (You can get one day of workflow history with the community edition by [registering](#registered-community-edition))

These features are available on the Enterprise Cloud plan, including the self-hosted Enterprise edition. Some of these features are available on the Starter and Pro Cloud plan.

See [pricing](https://n8n.io/pricing/) for reference.

## Registered Community Edition

You can unlock extra features by registering your n8n community edition. You register with your email and receive a license key.

Registering unlocks these features for the community edition:

- [Folders](../../release-notes/#folders): Organize your workflows into tidy folders
- [Debug in editor](../../workflows/executions/debug/): Copy and [pin](../../glossary/#data-pinning-n8n) execution data when working on a workflow
- One day of [workflow history](../../workflows/history/): 24 hours of workflow history so you can revert back to previous workflow versions
- [Custom execution data](../../workflows/executions/custom-executions-data/): Save, find, and annotate execution metadata

To register a new community edition instance, select the option during your initial account creation.

To register an existing community edition instance:

1. Select the **three dots icon** in the lower-left corner.
1. Select **Settings** and then **Usage and plan**.
1. Select **Unlock** to enter your email and then select **Send me a free license key**.
1. Check your email for the account you entered.

Once you have a license key, activate it by clicking the button in the license email or by visiting **Options > Settings > Usage and plan** and selecting **Enter activation key**.

Once activated, your license will not expire. We may change the unlocked features in the future. This will not impact previously unlocked features.

# Database structure

This page describes the purpose of each table in the n8n database.

## Database and query technology

By default, n8n uses SQLite as the database. If you are using another database the structure will be similar, but the data-types may be different depending on the database.

n8n uses [TypeORM](https://github.com/typeorm/typeorm) for queries and migrations.

To inspect the n8n database, you can use [DBeaver](https://dbeaver.io), which is an open-source universal database tool.

## Tables

These are the tables n8n creates during setup.

### auth_identity

Stores details of external authentication providers when using [SAML](../../../user-management/saml/).

### auth_provider_sync_history

Stores the history of a SAML connection.

### credentials_entity

Stores the [credentials](../../../glossary/#credential-n8n) used to authenticate with integrations.

### event_destinations

Contains the destination configurations for [Log streaming](../../../log-streaming/).

### execution_data

Contains the workflow at time of running, and the execution data.

### execution_entity

Stores all saved workflow executions. Workflow settings can affect which executions n8n saves.

### execution_metadata

Stores [Custom executions data](../../../workflows/executions/custom-executions-data/).

### installed_nodes

Lists the [community nodes](../../../integrations/community-nodes/installation/) installed in your n8n instance.

### installed_packages

Details of npm community nodes packages installed in your n8n instance. [installed_nodes](#installed_nodes) lists each individual node. `installed_packages` lists npm packages, which may contain more than one node.

### migrations

A log of all database migrations. Read more about [Migrations](https://typeorm.io/docs/advanced-topics/migrations/) in TypeORM's documentation.

### project

Lists the [projects](../../../user-management/rbac/projects/) in your instance.

### project_relation

Describes the relationship between a user and a [project](../../../user-management/rbac/projects/), including the user's [role type](../../../user-management/rbac/role-types/).

### role

Not currently used. For use in future work on custom roles.

### settings

Records custom instance settings. These are settings that you can't control using environment variables. They include:

- Whether the instance owner is set up
- Whether the user chose to skip owner and user management setup
- Whether certain types of authentication, including SAML and LDAP, are on
- License key

### shared_credentials

Maps credentials to users.

### shared_workflow

Maps workflows to users.

### tag_entity

All workflow tags created in the n8n instance. This table lists the tags. [workflows_tags](#workflows_tags) records which workflows have which tags.

### user

Contains user data.

### variables

Store [variables](../../../code/variables/).

### webhook_entity

Records the active webhooks in your n8n instance's workflows. This isn't just webhooks uses in the Webhook node. It includes all active webhooks used by any trigger node.

### workflow_entity

Your n8n instance's saved workflows.

### workflow_history

Store previous versions of workflows.

### workflow_statistics

Counts workflow IDs and their status.

### workflows_tags

Maps tags to workflows. [tag_entity](#tag_entity) contains tag details.

## Entity Relationship Diagram (ERD)

# Architecture

Understanding n8n's underlying architecture is helpful if you need to:

- Embed n8n
- Customize n8n's default databases

This section is a work in progress. If you have questions, please try the [forum](https://community.n8n.io/) and let n8n know which architecture documents would be useful for you.

# Configuration

You can change n8n's settings using environment variables. For a full list of available configurations see [Environment Variables](../environment-variables/).

## Set environment variables by command line

### npm

For npm, set your desired environment variables in terminal. The command depends on your command line.

Bash CLIs:

```
export <variable>=<value>
```

In cmd.exe:

```
set <variable>=<value>
```

In PowerShell:

```
$env:<variable>=<value>
```

### Docker

In Docker you can use the `-e` flag from the command line:

```
docker run -it --rm \
 --name n8n \
 -p 5678:5678 \
 -e N8N_TEMPLATES_ENABLED="false" \
 docker.n8n.io/n8nio/n8n
```

## Docker Compose file

In Docker, you can set your environment variables in the `n8n: environment:` element of your `docker-compose.yaml` file.

For example:

```
n8n:
    environment:
      - N8N_TEMPLATES_ENABLED=false
```

## Keeping sensitive data in separate files

You can append `_FILE` to individual environment variables to provide their configuration in a separate file, enabling you to avoid passing sensitive details using environment variables. n8n loads the data from the file with the given name, making it possible to load data from [Docker-Secrets](https://docs.docker.com/engine/swarm/secrets/) and [Kubernetes-Secrets](https://kubernetes.io/docs/concepts/configuration/secret/).

Refer to [Environment variables](../environment-variables/) for details on each variable.

While most environment variables can use the `_FILE` suffix, it's more beneficial for sensitive data such as [credentials](../../../glossary/#credential-n8n) and database configuration. Here are some examples:

```
CREDENTIALS_OVERWRITE_DATA_FILE=/path/to/credentials_data
DB_TYPE_FILE=/path/to/db_type
DB_POSTGRESDB_DATABASE_FILE=/path/to/database_name
DB_POSTGRESDB_HOST_FILE=/path/to/database_host
DB_POSTGRESDB_PORT_FILE=/path/to/database_port
DB_POSTGRESDB_USER_FILE=/path/to/database_user
DB_POSTGRESDB_PASSWORD_FILE=/path/to/database_password
DB_POSTGRESDB_SCHEMA_FILE=/path/to/database_schema
DB_POSTGRESDB_SSL_CA_FILE=/path/to/ssl_ca
DB_POSTGRESDB_SSL_CERT_FILE=/path/to/ssl_cert
DB_POSTGRESDB_SSL_KEY_FILE=/path/to/ssl_key
DB_POSTGRESDB_SSL_REJECT_UNAUTHORIZED_FILE=/path/to/ssl_reject_unauth
```

# Supported databases

By default, n8n uses SQLite to save credentials, past executions, and workflows. n8n also supports PostgresDB.

## Shared settings

The following environment variables get used by all databases:

- `DB_TABLE_PREFIX` (default: -) - Prefix for table names

## PostgresDB

To use PostgresDB as the database, you can provide the following environment variables:

- `DB_TYPE=postgresdb`
- `DB_POSTGRESDB_DATABASE` (default: 'n8n')
- `DB_POSTGRESDB_HOST` (default: 'localhost')
- `DB_POSTGRESDB_PORT` (default: 5432)
- `DB_POSTGRESDB_USER` (default: 'postgres')
- `DB_POSTGRESDB_PASSWORD` (default: empty)
- `DB_POSTGRESDB_SCHEMA` (default: 'public')
- `DB_POSTGRESDB_SSL_CA` (default: undefined): Path to the server's CA certificate used to validate the connection (opportunistic encryption isn't supported)
- `DB_POSTGRESDB_SSL_CERT` (default: undefined): Path to the client's TLS certificate
- `DB_POSTGRESDB_SSL_KEY` (default: undefined): Path to the client's private key corresponding to the certificate
- `DB_POSTGRESDB_SSL_REJECT_UNAUTHORIZED` (default: true): If TLS connections that fail validation should be rejected

```
export DB_TYPE=postgresdb
export DB_POSTGRESDB_DATABASE=n8n
export DB_POSTGRESDB_HOST=postgresdb
export DB_POSTGRESDB_PORT=5432
export DB_POSTGRESDB_USER=n8n
export DB_POSTGRESDB_PASSWORD=n8n
export DB_POSTGRESDB_SCHEMA=n8n

# optional:
export DB_POSTGRESDB_SSL_CA=$(pwd)/ca.crt
export DB_POSTGRESDB_SSL_REJECT_UNAUTHORIZED=false

n8n start
```

### Required permissions

n8n needs to create and modify the schemas of the tables it uses.

Recommended permissions:

```
CREATE DATABASE n8n-db;
CREATE USER n8n-user WITH PASSWORD 'random-password';
GRANT ALL PRIVILEGES ON DATABASE n8n-db TO n8n-user;
```

### TLS

You can choose between these configurations:

- Not declaring (default): Connect with `SSL=off`
- Declaring only the CA and unauthorized flag: Connect with `SSL=on` and verify the server's signature
- Declaring `_{CERT,KEY}` and the above: Use the certificate and key for client TLS authentication

## SQLite

This is the default database that gets used if nothing is defined.

The database file is located at: `~/.n8n/database.sqlite`

# Task runners

Task runners are a generic mechanism to execute tasks in a secure and performant way. They're used to execute user-provided JavaScript and Python code in the [Code node](../../../integrations/builtin/core-nodes/n8n-nodes-base.code/).

In beta

Task runner support for native Python and the `n8nio/runners` image are in beta. Until this feature is stable, you must use the `N8N_NATIVE_PYTHON_RUNNER=true` environment variable to enable the Python runner.

This document describes how task runners work and how you can configure them.

## How it works

The task runner feature consists of these components: one or more task runners, a task broker, and a task requester.

Task runners connect to the task broker using a websocket connection. A task requester submits a task request to the broker where an available task runner can pick it up for execution.

The runner executes the task and submits the results to the task requester. The task broker coordinates communication between the runner and the requester.

The n8n instance (main and worker) acts as the broker. The Code node in this case is the task requester.

## Task runner modes

You can use task runners in two different modes: internal and external.

### Internal mode

In internal mode, the n8n instance launches the task runner as a child process. The n8n process monitors and manages the life cycle of the task runner. The task runner process shares the same `uid` and `gid` as n8n. This is **not** recommended for production.

### External mode

In external mode, a [launcher application](https://github.com/n8n-io/task-runner-launcher) launches task runners on demand and manages their lifecycle. Typically, this means that next to n8n you add a sidecar container running the [`n8nio/runners`](https://hub.docker.com/r/n8nio/runners) image containing the launcher, the JS task runner and the Python task runner. This sidecar container is independent from the n8n instance.

When using [Queue mode](../../scaling/queue-mode/), each worker needs to have its own sidecar container for task runners.

In addition, if you haven't enabled offloading manual executions to workers (if you aren't setting `OFFLOAD_MANUAL_EXECUTIONS_TO_WORKERS=true` in your configuration), then your main instance will run manual executions and needs its own sidecar container for task runners as well. Please note that running n8n with offloading disabled isn't recommended for production.

## Setting up external mode

In external mode, you run the `n8nio/runners` image as a sidecar container next to n8n. Below you will find a docker compose as a reference. Keep in mind that the `n8nio/runners` image version must match that of the `n8nio/n8n` image, and the n8n version must be >=1.111.0.

```
services:
  n8n:
    image: n8nio/n8n:1.111.0
    container_name: n8n-main
    environment:
      - N8N_RUNNERS_ENABLED=true
      - N8N_RUNNERS_MODE=external
      - N8N_RUNNERS_BROKER_LISTEN_ADDRESS=0.0.0.0
      - N8N_RUNNERS_AUTH_TOKEN=your-secret-here
      - N8N_NATIVE_PYTHON_RUNNER=true
    ports:
      - "5678:5678"
    volumes:
      - n8n_data:/home/node/.n8n
    # etc.

  task-runners:
    image: n8nio/runners:1.111.0
    container_name: n8n-runners
    environment:
      - N8N_RUNNERS_TASK_BROKER_URI=http://n8n-main:5679
      - N8N_RUNNERS_AUTH_TOKEN=your-secret-here
      # etc.
    depends_on:
      - n8n

volumes:
  n8n_data:
```

### Configuring n8n container in external mode

These are the main environment variables that you can set on the n8n container running in external mode:

| Environment variables                                  | Description                                                                                                                                                                   |
| ------------------------------------------------------ | ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| `N8N_RUNNERS_ENABLED=true`                             | Enables task runners.                                                                                                                                                         |
| `N8N_RUNNERS_MODE=external`                            | Use task runners in external mode.                                                                                                                                            |
| `N8N_RUNNERS_AUTH_TOKEN=<random secure shared secret>` | A shared secret task runners use to connect to the broker.                                                                                                                    |
| `N8N_RUNNERS_BROKER_LISTEN_ADDRESS=0.0.0.0`            | By default, the task broker only listens to localhost. When using multiple containers (for example, with Docker Compose), it needs to be able to accept external connections. |

For full list of environment variables see [task runner environment variables](../environment-variables/task-runners/).

### Configuring runners container in external mode

These are the main environment variables that you can set on the runners container running in external mode:

| Environment variables                                  | Description                                                                                                                                                                                                                 |
| ------------------------------------------------------ | --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| `N8N_RUNNERS_AUTH_TOKEN=<random secure shared secret>` | The shared secret the task runner uses to connect to the broker.                                                                                                                                                            |
| `N8N_RUNNERS_TASK_BROKER_URI=localhost:5679`           | The address of the task broker server within the n8n instance.                                                                                                                                                              |
| `N8N_RUNNERS_AUTO_SHUTDOWN_TIMEOUT=15`                 | Number of seconds of inactivity to wait before shutting down the task runner process. The launcher will automatically start the runner again when there are new tasks to execute. Set to `0` to disable automatic shutdown. |

For full list of environment variables see [task runner environment variables](../environment-variables/task-runners/).

### Configuring launcher in runners container in external mode

The launcher will read environment variables from runners container environment, and will pass them along to each runner as defined in the [default launcher configuration file](https://github.com/n8n-io/n8n/blob/master/docker/images/runners/n8n-task-runners.json), located in the container at `/etc/task-runners.json`. The default launcher configuration file is locked down, but you will likely want to edit this file, for example, to allowlist first- or third-party modules. To customize the launcher configuration file, mount to this path:

```
path/to/n8n-task-runners.json:/etc/n8n-task-runners.json
```

For further information about the launcher config file, see [here](https://github.com/n8n-io/task-runner-launcher/blob/main/docs/setup.md#config-file).

## Adding extra dependencies

You can customize the `n8nio/runners` image. To do so, you will find the runners Dockerfile at [this directory](https://github.com/n8n-io/n8n/tree/master/docker/images/runners) in the n8n repository. The manifests referred to below are also found in this directory.

To make additional packages available on the Code node, you can bake extra packages into your custom runners image at build time:

- JavaScript: edit `docker/images/runners/package.json` (package.json manifest used to install runtime-only deps into the JS runner)
- Python (Native): edit `docker/images/runners/extras.txt` (requirements.txt-style list installed into the Python runner venv)

> Important: for security, any external libraries must be explicitly allowed for Code node use. Update `n8n-task-runners.json` to allowlist what you add.

### 1) JavaScript packages

Edit the runtime extras manifest `docker/images/runners/package.json`:

```
{
  "name": "task-runner-runtime-extras",
  "description": "Runtime-only deps for the JS task-runner image, installed at image build.",
  "private": true,
  "dependencies": {
    "moment": "2.30.1"
  }
}
```

Add any packages you want under `"dependencies"` (pin them for reproducibility), e.g.:

```
"dependencies": {
  "moment": "2.30.1",
  "uuid": "9.0.0"
}
```

### 2) Python packages

Edit the requirements file `docker/images/runners/extras.txt`:

```
# Runtime-only extras for the Python task runner (installed at image build)
numpy==2.3.2
# add more, one per line, e.g.:
# pandas==2.2.2
```

Pin versions (for example, `==2.3.2`) for deterministic builds.

### 3) Allowlist packages for the Code node

Open `docker/images/runners/n8n-task-runners.json` and add your packages to the env overrides:

```
{
  "task-runners": [
    {
      "runner-type": "javascript",
      "env-overrides": {
        "NODE_FUNCTION_ALLOW_BUILTIN": "crypto",
        "NODE_FUNCTION_ALLOW_EXTERNAL": "moment,uuid",   // <-- add JS packages here
      }
    },
    {
      "runner-type": "python",
      "env-overrides": {
        "PYTHONPATH": "/opt/runners/task-runner-python",
        "N8N_RUNNERS_STDLIB_ALLOW": "json",
        "N8N_RUNNERS_EXTERNAL_ALLOW": "numpy,pandas"     // <-- add Python packages here
      }
    }
  ]
}
```

- `NODE_FUNCTION_ALLOW_BUILTIN`: comma-separated list of allowed node builtin modules.
- `NODE_FUNCTION_ALLOW_EXTERNAL`: comma-separated list of allowed JS packages.
- `N8N_RUNNERS_STDLIB_ALLOW`: comma-separated list of allowed Python standard library packages.
- `N8N_RUNNERS_EXTERNAL_ALLOW`: comma-separated list of allowed Python packages.

### 4) Build your custom image

For example, from the n8n repository root:

```
docker buildx build \
  -f docker/images/runners/Dockerfile \
  -t n8nio/runners:custom \
  .
```

### 5) Run it

For example:

```
docker run --rm -it \
  -e N8N_RUNNERS_AUTH_TOKEN=test \
  -e N8N_RUNNERS_LAUNCHER_LOG_LEVEL=debug \
  -e N8N_RUNNERS_TASK_BROKER_URI=http://host.docker.internal:5679 \
  -p 5680:5680 \
  n8nio/runners:custom
```

# Configure self-hosted n8n for user management

User management in n8n allows you to invite people to work in your n8n instance.

This document describes how to configure your n8n instance to support user management, and the steps to start inviting users.

Refer to the main [User management](../../../user-management/) guide for more information about usage, including:

- [Managing users](../../../user-management/manage-users/)
- [Account types](../../../user-management/account-types/)
- [Best practices](../../../user-management/best-practices/)

For LDAP setup information, refer to [LDAP](../../../user-management/ldap/).

For SAML setup information, refer to [SAML](../../../user-management/saml/).

Basic auth and JWT removed

n8n removed support for basic auth and JWT in version 1.0.

## Setup

There are three stages to set up user management in n8n:

1. Configure your n8n instance to use your SMTP server.
1. Start n8n and follow the setup steps in the app.
1. Invite users.

### Step one: SMTP

n8n recommends setting up an SMTP server, for user invites and password resets.

Optional from 0.210.1

From version 0.210.1 onward, this step is optional. You can choose to manually copy and send invite links instead of setting up SMTP. Note that if you skip this step, users can't reset passwords.

Get the following information from your SMTP provider:

- Server name
- SMTP username
- SMTP password
- SMTP sender name

To set up SMTP with n8n, configure the SMTP environment variables for your n8n instance. For information on how to set environment variables, refer to [Configuration](../configuration-methods/)

| Variable                                    | Type    | Description                                                                                                                  | Required? |
| ------------------------------------------- | ------- | ---------------------------------------------------------------------------------------------------------------------------- | --------- |
| `N8N_EMAIL_MODE`                            | string  | `smtp`                                                                                                                       | Required  |
| `N8N_SMTP_HOST`                             | string  | *your_SMTP_server_name*                                                                                                      | Required  |
| `N8N_SMTP_PORT`                             | number  | *your_SMTP_server_port* Default is `465`.                                                                                    | Optional  |
| `N8N_SMTP_USER`                             | string  | *your_SMTP_username*                                                                                                         | Optional  |
| `N8N_SMTP_PASS`                             | string  | *your_SMTP_password*                                                                                                         | Optional  |
| `N8N_SMTP_OAUTH_SERVICE_CLIENT`             | string  | *your_OAuth_service_client*                                                                                                  | Optional  |
| `N8N_SMTP_OAUTH_PRIVATE_KEY`                | string  | *your_OAuth_private_key*                                                                                                     | Optional  |
| `N8N_SMTP_SENDER`                           | string  | Sender email address. You can optionally include the sender name. Example with name: *N8N `<contact@n8n.com>`*               | Required  |
| `N8N_SMTP_SSL`                              | boolean | Whether to use SSL for SMTP (true) or not (false). Defaults to `true`.                                                       | Optional  |
| `N8N_UM_EMAIL_TEMPLATES_INVITE`             | string  | Full path to your HTML email template. This overrides the default template for invite emails.                                | Optional  |
| `N8N_UM_EMAIL_TEMPLATES_PWRESET`            | string  | Full path to your HTML email template. This overrides the default template for password reset emails.                        | Optional  |
| `N8N_UM_EMAIL_TEMPLATES_WORKFLOW_SHARED`    | String  | Overrides the default HTML template for notifying users that a credential was shared. Provide the full path to the template. | Optional  |
| `N8N_UM_EMAIL_TEMPLATES_CREDENTIALS_SHARED` | String  | Overrides the default HTML template for notifying users that a credential was shared. Provide the full path to the template. | Optional  |
| `N8N_UM_EMAIL_TEMPLATES_PROJECT_SHARED`     | String  | Overrides the default HTML template for notifying users that a project was shared. Provide the full path to the template.    | Optional  |

If your n8n instance is already running, you need to restart it to enable the new SMTP settings.

More configuration options

There are more configuration options available as environment variables. Refer to [Environment variables](../environment-variables/) for a list. These include options to disable tags, workflow templates, and the personalization survey, if you don't want your users to see them.

New to SMTP?

If you're not familiar with SMTP, this [blog post by SendGrid](https://sendgrid.com/blog/what-is-an-smtp-server/) offers a short introduction, while [Wikipedia's Simple Mail Transfer Protocol article](https://en.wikipedia.org/wiki/Simple_Mail_Transfer_Protocol) provides more detailed technical background.

### Step two: In-app setup

When you set up user management for the first time, you create an owner account.

1. Open n8n. The app displays a signup screen.
1. Enter your details. Your password must be at least eight characters, including at least one number and one capital letter.
1. Click **Next**. n8n logs you in with your new owner account.

### Step three: Invite users

You can now invite other people to your n8n instance.

1. Sign into your workspace with your owner account. (If you are in the Admin Panel open your **Workspace** from the Dashboard)
1. Click the three dots next to your user icon at the bottom left and click **Settings**. n8n opens your **Personal settings** page.
1. Click **Users** to go to the **Users** page.
1. Click **Invite**.
1. Enter the new user's email address.
1. Click **Invite user**. n8n sends an email with a link for the new user to join.

# Configuration examples

This section contains examples for how to configure n8n to solve particular use cases.

- [Isolate n8n](/hosting/configuration/configuration-examples/isolation/)
- [Configure the Base URL](/hosting/configuration/configuration-examples/base-url/)
- [Configure custom SSL certificate authorities](/hosting/configuration/configuration-examples/custom-certificate-authority/)
- [Set a custom encryption key](/hosting/configuration/configuration-examples/encryption-key/)
- [Configure workflow timeouts](/hosting/configuration/configuration-examples/execution-timeout/)
- [Specify custom nodes location](/hosting/configuration/configuration-examples/custom-nodes-location/)
- [Enable modules in Code node](/hosting/configuration/configuration-examples/modules-in-code-node/)
- [Set the timezone](/hosting/configuration/configuration-examples/time-zone/)
- [Specify user folder path](/hosting/configuration/configuration-examples/user-folder/)
- [Configure webhook URLs with reverse proxy](/hosting/configuration/configuration-examples/webhook-url/)
- [Enable Prometheus metrics](/hosting/configuration/configuration-examples/prometheus/)

# Configure the Base URL for n8n's front end access

Requires manual UI build

This use case involves configuring the `VUE_APP_URL_BASE_API` environmental variable which requires a manual build of the `n8n-editor-ui` package. You can't use it with the default n8n Docker image where the default setting for this variable is `/`, meaning that it uses the root-domain.

You can configure the Base URL that the front end uses to connect to the back end's REST API. This is relevant when you want to host n8n's front end and back end separately.

```
export VUE_APP_URL_BASE_API=https://n8n.example.com/
```

Refer to [Environment variables reference](../../environment-variables/deployment/) for more information on this variable.

# Configure n8n to use your own certificate authority or self-signed certificate

You can add your own certificate authority (CA) or self-signed certificate to n8n. This means you are able to trust a certain SSL certificate instead of trusting all invalid certificates, which is a potential security risk.

Added in version 1.42.0

This feature is available in version 1.42.0 and above.

To use this feature you need to place your certificates in a folder and mount the folder to `/opt/custom-certificates` in the container. The external path that you map to `/opt/custom-certificates` must be writable by the container.

## Docker

The examples below assume you have a folder called `pki` that contains your certificates in either the directory you run the command from or next to your docker compose file.

### Docker CLI

When using the CLI you can use the `-v` flag from the command line:

```
docker run -it --rm \
 --name n8n \
 -p 5678:5678 \
 -v ./pki:/opt/custom-certificates \
 docker.n8n.io/n8nio/n8n
```

### Docker Compose

```
name: n8n
services:
    n8n:
        volumes:
            - ./pki:/opt/custom-certificates
        container_name: n8n
        ports:
            - 5678:5678
        image: docker.n8n.io/n8nio/n8n
```

You should also give the right permissions to the imported certs. You can do this once the container is running (assuming n8n as the container name):

```
docker exec --user 0 n8n chown -R 1000:1000 /opt/custom-certificates
```

## Certificate requirements for Custom Trust Store

Supported certificate types:

- Root CA Certificates: these are certificates from Certificate Authorities that sign other certificates. Trust these to accept all certificates signed by that CA.
- Self-Signed Certificates: certificates that servers create and sign themselves. Trust these to accept connections to that specific server only.

You must use PEM format:

- Text-based format with BEGIN/END markers
- Supported file extensions: `.pem`, `.crt`, `.cer`
- Contains the public certificate (no private key needed)

For example:

```
-----BEGIN CERTIFICATE-----
MIIDXTCCAkWgAwIBAgIJAKoK/heBjcOuMA0GCSqGSIb3DQEBBQUAMEUxCzAJBgNV
[base64 encoded data]
-----END CERTIFICATE-----
```

The system doesn't accept:

- DER/binary format files
- PKCS#7 (.p7b) files
- PKCS#12 (.pfx, .p12) files
- Private key files
- Convert these formats to PEM before use.

# Specify location for your custom nodes

Every user can add custom nodes that get loaded by n8n on startup. The default location is in the subfolder `.n8n/custom` of the user who started n8n.

You can define more folders with an environment variable:

```
export N8N_CUSTOM_EXTENSIONS="/home/jim/n8n/custom-nodes;/data/n8n/nodes"
```

Refer to [Environment variables reference](../../environment-variables/nodes/) for more information on this variable.

# Set a custom encryption key

n8n creates a random encryption key automatically on the first launch and saves it in the `~/.n8n` folder. n8n uses that key to encrypt the credentials before they get saved to the database. If the key isn't yet in the settings file, you can set it using an environment variable, so that n8n uses your custom key instead of generating a new one.

In [queue mode](../../../scaling/queue-mode/), you must specify the encryption key environment variable for all workers.

```
export N8N_ENCRYPTION_KEY=<SOME RANDOM STRING>
```

Refer to [Environment variables reference](../../environment-variables/deployment/) for more information on this variable.

# Configure workflow timeout settings

A workflow times out and gets canceled after this time (in seconds). If the workflow runs in the main process, a soft timeout happens (takes effect after the current node finishes). If a workflow runs in its own process, n8n attempts a soft timeout first, then kills the process after waiting for a fifth of the given timeout duration.

`EXECUTIONS_TIMEOUT` default is `-1`. For example, if you want to set the timeout to one hour:

```
export EXECUTIONS_TIMEOUT=3600
```

You can also set maximum execution time (in seconds) for each workflow individually. For example, if you want to set maximum execution time to two hours:

```
export EXECUTIONS_TIMEOUT_MAX=7200
```

Refer to [Environment variables reference](../../environment-variables/executions/) for more information on these variables.

# Isolate n8n

By default, a self-hosted n8n instance sends data to n8n's servers. It notifies users about available updates, workflow templates, and diagnostics.

To prevent your n8n instance from connecting to n8n's servers, set these environment variables to false:

```
N8N_DIAGNOSTICS_ENABLED=false
N8N_VERSION_NOTIFICATIONS_ENABLED=false
N8N_TEMPLATES_ENABLED=false
```

Unset n8n's diagnostics configuration:

```
EXTERNAL_FRONTEND_HOOKS_URLS=
N8N_DIAGNOSTICS_CONFIG_FRONTEND=
N8N_DIAGNOSTICS_CONFIG_BACKEND=
```

Refer to [Environment variables reference](../../environment-variables/deployment/) for more information on these variables.

# Enable modules in Code node

For security reasons, the Code node restricts importing modules. It's possible to lift that restriction for built-in and external modules by setting the following environment variables:

- `NODE_FUNCTION_ALLOW_BUILTIN`: For built-in modules
- `NODE_FUNCTION_ALLOW_EXTERNAL`: For external modules sourced from n8n/node_modules directory. External module support is disabled when an environment variable isn't set.

```
# Allows usage of all builtin modules
export NODE_FUNCTION_ALLOW_BUILTIN=*

# Allows usage of only crypto
export NODE_FUNCTION_ALLOW_BUILTIN=crypto

# Allows usage of only crypto and fs
export NODE_FUNCTION_ALLOW_BUILTIN=crypto,fs

# Allow usage of external npm modules.
export NODE_FUNCTION_ALLOW_EXTERNAL=moment,lodash
```

If using Task Runners

If n8n instance is setup with [Task Runners](../../task-runners/), add the environment variables to the Task Runners instead to the main n8n node.

Refer to [Environment variables reference](../../environment-variables/nodes/) for more information on these variables.

# Enable Prometheus metrics

To collect and expose metrics, n8n uses the [prom-client](https://www.npmjs.com/package/prom-client) library.

The `/metrics` endpoint is disabled by default, but it's possible to enable it using the `N8N_METRICS` environment variable.

```
export N8N_METRICS=true
```

Refer to the respective [Environment Variables](../../environment-variables/endpoints/) (`N8N_METRICS_INCLUDE_*`) for configuring which metrics and labels should get exposed.

Both `main` and `worker` instances are able to expose metrics.

## Queue metrics

To enable queue metrics, set the `N8N_METRICS_INCLUDE_QUEUE_METRICS` env var to `true`. You can adjust the refresh rate with `N8N_METRICS_QUEUE_METRICS_INTERVAL`.

n8n gathers these metrics from Bull and exposes them on the main instances. On multi-main setups, when aggregating queries, you can identify the leader using the `instance_role_leader` gauge, set to `1` for the leader main and `0` otherwise.

```
# HELP n8n_scaling_mode_queue_jobs_active Current number of jobs being processed across all workers in scaling mode.
# TYPE n8n_scaling_mode_queue_jobs_active gauge
n8n_scaling_mode_queue_jobs_active 0

# HELP n8n_scaling_mode_queue_jobs_completed Total number of jobs completed across all workers in scaling mode since instance start.
# TYPE n8n_scaling_mode_queue_jobs_completed counter
n8n_scaling_mode_queue_jobs_completed 0

# HELP n8n_scaling_mode_queue_jobs_failed Total number of jobs failed across all workers in scaling mode since instance start.
# TYPE n8n_scaling_mode_queue_jobs_failed counter
n8n_scaling_mode_queue_jobs_failed 0

# HELP n8n_scaling_mode_queue_jobs_waiting Current number of enqueued jobs waiting for pickup in scaling mode.
# TYPE n8n_scaling_mode_queue_jobs_waiting gauge
n8n_scaling_mode_queue_jobs_waiting 0
```

# Set the self-hosted instance timezone

The default timezone is America/New_York. For instance, the Schedule node uses it to know at what time the workflow should start. To set a different default timezone, set `GENERIC_TIMEZONE` to the appropriate value. For example, if you want to set the timezone to Berlin (Germany):

```
export GENERIC_TIMEZONE=Europe/Berlin
```

You can find the name of your timezone [here](https://momentjs.com/timezone/).

Refer to [Environment variables reference](../../environment-variables/timezone-localization/) for more information on this variable.

# Specify user folder path

n8n saves user-specific data like the encryption key, SQLite database file, and the ID of the tunnel (if used) in the subfolder `.n8n` of the user who started n8n. It's possible to overwrite the user-folder using an environment variable.

```
export N8N_USER_FOLDER=/home/jim/n8n
```

Refer to [Environment variables reference](../../environment-variables/deployment/) for more information on this variable.

# Configure n8n webhooks with reverse proxy

n8n creates the webhook URL by combining `N8N_PROTOCOL`, `N8N_HOST` and `N8N_PORT`. If n8n runs behind a reverse proxy, that won't work. That's because n8n runs internally on port 5678 but the reverse proxy exposes it to the web on port 443.

When running n8n behind a reverse proxy, it's important to do the following:

- set the webhook URL manually with the `WEBHOOK_URL` environment variable so that n8n can display it in the editor UI and register the correct webhook URLs with external services.
- Set the `N8N_PROXY_HOPS` environment variable to `1`.
- On the last proxy on the request path, set the following headers to pass on information about the initial request:
  - [`X-Forwarded-For`](https://developer.mozilla.org/en-US/docs/Web/HTTP/Reference/Headers/X-Forwarded-For)
  - [`X-Forwarded-Host`](https://developer.mozilla.org/en-US/docs/Web/HTTP/Reference/Headers/X-Forwarded-Host)
  - [`X-Forwarded-Proto`](https://developer.mozilla.org/en-US/docs/Web/HTTP/Reference/Headers/X-Forwarded-Proto)

```
export WEBHOOK_URL=https://n8n.example.com/
export N8N_PROXY_HOPS=1
```

Refer to [Environment variables reference](../../environment-variables/endpoints/) for more information on this variable.

# Environment variables overview

This section lists the environment variables that you can use to change n8n's configuration settings when self-hosting n8n.

File-based configuration

You can provide a [configuration file](../configuration-methods/) for n8n. You can also append `_FILE` to certain variables to provide their configuration in a separate file.

- [Binary data](/hosting/configuration/environment-variables/binary-data/)
- [Credentials](/hosting/configuration/environment-variables/credentials/)
- [Database](/hosting/configuration/environment-variables/database/)
- [Deployment](/hosting/configuration/environment-variables/deployment/)
- [Endpoints](/hosting/configuration/environment-variables/endpoints/)
- [Executions](/hosting/configuration/environment-variables/executions/)
- [External data storage](/hosting/configuration/environment-variables/external-data-storage/)
- [External hooks](/hosting/configuration/environment-variables/external-hooks/)
- [External secrets](/hosting/configuration/environment-variables/external-secrets/)
- [Insights](/hosting/configuration/environment-variables/insights/)
- [Logs](/hosting/configuration/environment-variables/logs/)
- [License](/hosting/configuration/environment-variables/licenses/)
- [Nodes](/hosting/configuration/environment-variables/nodes/)
- [Queue mode](/hosting/configuration/environment-variables/queue-mode/)
- [Security](/hosting/configuration/environment-variables/security/)
- [Source control](/hosting/configuration/environment-variables/source-control/)
- [Task runners](/hosting/configuration/environment-variables/task-runners/)
- [Timezone and localization](/hosting/configuration/environment-variables/timezone-localization/)
- [User management and 2FA](/hosting/configuration/environment-variables/user-management-smtp-2fa/)
- [Workflows](/hosting/configuration/environment-variables/workflows/)

# Binary data environment variables

File-based configuration

You can add `_FILE` to individual variables to provide their configuration in a separate file. Refer to [Keeping sensitive data in separate files](../../configuration-methods/#keeping-sensitive-data-in-separate-files) for more details.

By default, n8n uses memory to store binary data. Enterprise users can choose to use an external service instead. Refer to [External storage](../../../scaling/external-storage/) for more information on using external storage for binary data.

| Variable                          | Type   | Default                      | Description                                                                                                                                                                                                                                                                                                                                                                     |
| --------------------------------- | ------ | ---------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| `N8N_AVAILABLE_BINARY_DATA_MODES` | String | `filesystem`                 | A comma separated list of available binary data modes.                                                                                                                                                                                                                                                                                                                          |
| `N8N_BINARY_DATA_STORAGE_PATH`    | String | `N8N_USER_FOLDER/binaryData` | The path where n8n stores binary data.                                                                                                                                                                                                                                                                                                                                          |
| `N8N_DEFAULT_BINARY_DATA_MODE`    | String | `default`                    | The default binary data mode. `default` keeps binary data in memory. Set to `filesystem` to use the filesystem, or `s3` to AWS S3. Note that binary data pruning operates on the active binary data mode. For example, if your instance stored data in S3, and you later switched to filesystem mode, n8n only prunes binary data in the filesystem. This may change in future. |

# Credentials environment variables

File-based configuration

You can add `_FILE` to individual variables to provide their configuration in a separate file. Refer to [Keeping sensitive data in separate files](../../configuration-methods/#keeping-sensitive-data-in-separate-files) for more details.

Enable credential overwrites using the following environment variables. Refer to [Credential overwrites](../../../../embed/configuration/#credential-overwrites) for details.

| Variable                              | Type   | Default          | Description                            |
| ------------------------------------- | ------ | ---------------- | -------------------------------------- |
| `CREDENTIALS_OVERWRITE_DATA` /`_FILE` | \*     | -                | Overwrites for credentials.            |
| `CREDENTIALS_OVERWRITE_ENDPOINT`      | String | -                | The API endpoint to fetch credentials. |
| `CREDENTIALS_DEFAULT_NAME`            | String | `My credentials` | The default name for credentials.      |

# Database environment variables

File-based configuration

You can add `_FILE` to individual variables to provide their configuration in a separate file. Refer to [Keeping sensitive data in separate files](../../configuration-methods/#keeping-sensitive-data-in-separate-files) for more details.

By default, n8n uses SQLite. n8n also supports PostgreSQL. n8n [deprecated support for MySQL and MariaDB](../../../../1-0-migration-checklist/#mysql-and-mariadb) in v1.0.

This page outlines environment variables to configure your chosen database for your self-hosted n8n instance.

| Variable                   | Type                                | Default  | Description                                                                                        |
| -------------------------- | ----------------------------------- | -------- | -------------------------------------------------------------------------------------------------- |
| `DB_TYPE` /`_FILE`         | Enum string: `sqlite`, `postgresdb` | `sqlite` | The database to use.                                                                               |
| `DB_TABLE_PREFIX`          | \*                                  | -        | Prefix to use for table names.                                                                     |
| `DB_PING_INTERVAL_SECONDS` | Number                              | `2`      | The interval, in seconds, between pings to the database to check if the connection is still alive. |

## PostgreSQL

| Variable                                         | Type    | Default     | Description                                                                                                                                                              |
| ------------------------------------------------ | ------- | ----------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------ |
| `DB_POSTGRESDB_DATABASE` /`_FILE`                | String  | `n8n`       | The name of the PostgreSQL database.                                                                                                                                     |
| `DB_POSTGRESDB_HOST` /`_FILE`                    | String  | `localhost` | The PostgreSQL host.                                                                                                                                                     |
| `DB_POSTGRESDB_PORT` /`_FILE`                    | Number  | `5432`      | The PostgreSQL port.                                                                                                                                                     |
| `DB_POSTGRESDB_USER` /`_FILE`                    | String  | `postgres`  | The PostgreSQL user.                                                                                                                                                     |
| `DB_POSTGRESDB_PASSWORD` /`_FILE`                | String  | -           | The PostgreSQL password.                                                                                                                                                 |
| `DB_POSTGRESDB_POOL_SIZE` /`_FILE`               | Number  | `2`         | Control how many parallel open Postgres connections n8n should have. Increasing it may help with resource utilization, but too many connections may degrade performance. |
| `DB_POSTGRESDB_CONNECTION_TIMEOUT` /`_FILE`      | Number  | `20000`     | Postgres connection timeout (ms).                                                                                                                                        |
| `DB_POSTGRESDB_IDLE_CONNECTION_TIMEOUT` /`_FILE` | Number  | `30000`     | Amount of time before an idle connection is eligible for eviction for being idle.                                                                                        |
| `DB_POSTGRESDB_SCHEMA` /`_FILE`                  | String  | `public`    | The PostgreSQL schema.                                                                                                                                                   |
| `DB_POSTGRESDB_SSL_ENABLED` /`_FILE`             | Boolean | `false`     | Whether to enable SSL. Automatically enabled if `DB_POSTGRESDB_SSL_CA`, `DB_POSTGRESDB_SSL_CERT` or `DB_POSTGRESDB_SSL_KEY` is defined.                                  |
| `DB_POSTGRESDB_SSL_CA` /`_FILE`                  | String  | -           | The PostgreSQL SSL certificate authority.                                                                                                                                |
| `DB_POSTGRESDB_SSL_CERT` /`_FILE`                | String  | -           | The PostgreSQL SSL certificate.                                                                                                                                          |
| `DB_POSTGRESDB_SSL_KEY` /`_FILE`                 | String  | -           | The PostgreSQL SSL key.                                                                                                                                                  |
| `DB_POSTGRESDB_SSL_REJECT_UNAUTHORIZED` /`_FILE` | Boolean | `true`      | If n8n should reject unauthorized SSL connections (true) or not (false).                                                                                                 |

## SQLite

| Variable                      | Type    | Default | Description                                                                                                                                                                                                                                                                                                                                                                                                               |
| ----------------------------- | ------- | ------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| `DB_SQLITE_POOL_SIZE`         | Number  | `0`     | Controls whether to open the SQLite file in [WAL mode](https://www.sqlite.org/wal.html) or [rollback journal mode](https://www.sqlite.org/lockingv3.html#rollback). Uses rollback journal mode when set to zero. When greater than zero, uses WAL mode with the value determining the number of parallel SQL read connections to configure. WAL mode is much more performant and reliable than the rollback journal mode. |
| `DB_SQLITE_VACUUM_ON_STARTUP` | Boolean | `false` | Runs [VACUUM](https://www.sqlite.org/lang_vacuum.html) operation on startup to rebuild the database. Reduces file size and optimizes indexes. This is a long running blocking operation and increases start-up time.                                                                                                                                                                                                      |

# Deployment environment variables

File-based configuration

You can add `_FILE` to individual variables to provide their configuration in a separate file. Refer to [Keeping sensitive data in separate files](../../configuration-methods/#keeping-sensitive-data-in-separate-files) for more details.

This page lists the deployment configuration options for your self-hosted n8n instance, including setting up access URLs, enabling templates, customizing encryption, and configuring server details.

Proxy variable priorities

The [`proxy-from-env`](https://www.npmjs.com/package/proxy-from-env) package that n8n uses to handle proxy environment variables (those ending with `_PROXY`) imposes a certain variable precedence. Notably, for proxy variables, lowercase versions (like `http_proxy`) have precedence over uppercase variants (for example `HTTP_PROXY`) when both are present.

To learn more about proxy environment variables, check the [environment variables section of the package details](https://www.npmjs.com/package/proxy-from-env#environment-variables).

| Variable                             | Type                         | Default                                                          | Description                                                                                                                                                                                                                                                                       |
| ------------------------------------ | ---------------------------- | ---------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| `HTTP_PROXY`                         | String                       | -                                                                | A URL to proxy unencrypted HTTP requests through. When set, n8n proxies all unencrypted HTTP traffic from nodes through the proxy URL.                                                                                                                                            |
| `HTTPS_PROXY`                        | String                       | -                                                                | A URL to proxy TLS/SSL encrypted HTTP requests through. When set, n8n proxies all TLS/SSL encrypted HTTP traffic from nodes through the proxy URL.                                                                                                                                |
| `ALL_PROXY`                          | String                       | -                                                                | A URL to proxy both unencrypted and encrypted HTTP requests through. When set, n8n uses this value when more specific variables (`HTTP_PROXY` or `HTTPS_PROXY`) aren't present.                                                                                                   |
| `NO_PROXY`                           | String                       | -                                                                | A comma-separated list of hostnames or URLs that should bypass the proxy. When using `HTTP_PROXY`, `HTTPS_PROXY`, or `ALL_PROXY`, n8n will connect directly to the URLs or hostnames defined here instead of using the proxy.                                                     |
| `N8N_EDITOR_BASE_URL`                | String                       | -                                                                | Public URL where users can access the editor. Also used for emails sent from n8n and the redirect URL for SAML based authentication.                                                                                                                                              |
| `N8N_CONFIG_FILES` (deprecated)      | String                       | -                                                                | Use to provide the path to a JSON configuration file. This option is deprecated and will be removed in a future version. Use `.env` files or `*_FILE` environment variables instead.                                                                                              |
| `N8N_DISABLE_UI`                     | Boolean                      | `false`                                                          | Set to `true` to disable the UI.                                                                                                                                                                                                                                                  |
| `N8N_PREVIEW_MODE`                   | Boolean                      | `false`                                                          | Set to `true` to run in preview mode.                                                                                                                                                                                                                                             |
| `N8N_TEMPLATES_ENABLED`              | Boolean                      | `false`                                                          | Enables [workflow templates](../../../../glossary/#template-n8n) (true) or disable (false).                                                                                                                                                                                       |
| `N8N_TEMPLATES_HOST`                 | String                       | `https://api.n8n.io`                                             | Change this if creating your own workflow template library. Note that to use your own workflow templates library, your API must provide the same endpoints and response structure as n8n's. Refer to [Workflow templates](../../../../workflows/templates/) for more information. |
| `N8N_ENCRYPTION_KEY`                 | String                       | Random key generated by n8n                                      | Provide a custom key used to encrypt credentials in the n8n database. By default n8n generates a random key on first launch.                                                                                                                                                      |
| `N8N_USER_FOLDER`                    | String                       | `user-folder`                                                    | Provide the path where n8n will create the `.n8n` folder. This directory stores user-specific data, such as database file and encryption key.                                                                                                                                     |
| `N8N_PATH`                           | String                       | `/`                                                              | The path n8n deploys to.                                                                                                                                                                                                                                                          |
| `N8N_HOST`                           | String                       | `localhost`                                                      | Host name n8n runs on.                                                                                                                                                                                                                                                            |
| `N8N_PORT`                           | Number                       | `5678`                                                           | The HTTP port n8n runs on.                                                                                                                                                                                                                                                        |
| `N8N_LISTEN_ADDRESS`                 | String                       | `::`                                                             | The IP address n8n should listen on.                                                                                                                                                                                                                                              |
| `N8N_PROTOCOL`                       | Enum string: `http`, `https` | `http`                                                           | The protocol used to reach n8n.                                                                                                                                                                                                                                                   |
| `N8N_SSL_KEY`                        | String                       | -                                                                | The SSL key for HTTPS protocol.                                                                                                                                                                                                                                                   |
| `N8N_SSL_CERT`                       | String                       | -                                                                | The SSL certificate for HTTPS protocol.                                                                                                                                                                                                                                           |
| `N8N_PERSONALIZATION_ENABLED`        | Boolean                      | `true`                                                           | Whether to ask users personalisation questions and then customise n8n accordingly.                                                                                                                                                                                                |
| `N8N_VERSION_NOTIFICATIONS_ENABLED`  | Boolean                      | `true`                                                           | When enabled, n8n sends notifications of new versions and security updates.                                                                                                                                                                                                       |
| `N8N_VERSION_NOTIFICATIONS_ENDPOINT` | String                       | `https://api.n8n.io/versions/`                                   | The endpoint to retrieve where version information.                                                                                                                                                                                                                               |
| `N8N_VERSION_NOTIFICATIONS_INFO_URL` | String                       | `https://docs.n8n.io/getting-started/installation/updating.html` | The URL displayed in the New Versions panel for more information.                                                                                                                                                                                                                 |
| `N8N_DIAGNOSTICS_ENABLED`            | Boolean                      | `true`                                                           | Whether to share selected, anonymous [telemetry](../../../../privacy-security/privacy/) with n8n. Note that if you set this to `false`, you can't enable Ask AI in the Code node.                                                                                                 |
| `N8N_DIAGNOSTICS_CONFIG_FRONTEND`    | String                       | `1zPn9bgWPzlQc0p8Gj1uiK6DOTn;https://telemetry.n8n.io`           | Telemetry configuration for the frontend.                                                                                                                                                                                                                                         |
| `N8N_DIAGNOSTICS_CONFIG_BACKEND`     | String                       | `1zPn7YoGC3ZXE9zLeTKLuQCB4F6;https://telemetry.n8n.io/v1/batch`  | Telemetry configuration for the backend.                                                                                                                                                                                                                                          |
| `N8N_PUSH_BACKEND`                   | String                       | `websocket`                                                      | Choose whether the n8n backend uses server-sent events (`sse`) or WebSockets (`websocket`) to send changes to the UI.                                                                                                                                                             |
| `VUE_APP_URL_BASE_API`               | String                       | `http://localhost:5678/`                                         | Used when building the `n8n-editor-ui` package manually to set how the frontend can reach the backend API. Refer to [Configure the Base URL](../../configuration-examples/base-url/).                                                                                             |
| `N8N_HIRING_BANNER_ENABLED`          | Boolean                      | `true`                                                           | Whether to show the n8n hiring banner in the console (true) or not (false).                                                                                                                                                                                                       |
| `N8N_PUBLIC_API_SWAGGERUI_DISABLED`  | Boolean                      | `false`                                                          | Whether the Swagger UI (API playground) is disabled (true) or not (false).                                                                                                                                                                                                        |
| `N8N_PUBLIC_API_DISABLED`            | Boolean                      | `false`                                                          | Whether to disable the public API (true) or not (false).                                                                                                                                                                                                                          |
| `N8N_PUBLIC_API_ENDPOINT`            | String                       | `api`                                                            | Path for the public API endpoints.                                                                                                                                                                                                                                                |
| `N8N_GRACEFUL_SHUTDOWN_TIMEOUT`      | Number                       | `30`                                                             | How long should the n8n process wait (in seconds) for components to shut down before exiting the process.                                                                                                                                                                         |
| `N8N_DEV_RELOAD`                     | Boolean                      | `false`                                                          | When working on the n8n source code, set this to `true` to automatically reload or restart the application when changes occur in the source code files.                                                                                                                           |
| `N8N_REINSTALL_MISSING_PACKAGES`     | Boolean                      | `false`                                                          | If set to `true`, n8n will automatically attempt to reinstall any missing packages.                                                                                                                                                                                               |
| `N8N_TUNNEL_SUBDOMAIN`               | String                       | -                                                                | Specifies the subdomain for the n8n tunnel. If not set, n8n generates a random subdomain.                                                                                                                                                                                         |
| `N8N_PROXY_HOPS`                     | Number                       | 0                                                                | Number of reverse-proxies n8n is running behind.                                                                                                                                                                                                                                  |

# Endpoints environment variables

File-based configuration

You can add `_FILE` to individual variables to provide their configuration in a separate file. Refer to [Keeping sensitive data in separate files](../../configuration-methods/#keeping-sensitive-data-in-separate-files) for more details.

This page lists environment variables for customizing endpoints in n8n.

| Variable                                        | Type    | Default           | Description                                                                                                                                               |
| ----------------------------------------------- | ------- | ----------------- | --------------------------------------------------------------------------------------------------------------------------------------------------------- |
| `N8N_PAYLOAD_SIZE_MAX`                          | Number  | `16`              | The maximum payload size in MiB.                                                                                                                          |
| `N8N_FORMDATA_FILE_SIZE_MAX`                    | Number  | `200`             | Max payload size for files in form-data webhook payloads in MiB.                                                                                          |
| `N8N_METRICS`                                   | Boolean | `false`           | Whether to enable the `/metrics` endpoint.                                                                                                                |
| `N8N_METRICS_PREFIX`                            | String  | `n8n_`            | Optional prefix for n8n specific metrics names.                                                                                                           |
| `N8N_METRICS_INCLUDE_DEFAULT_METRICS`           | Boolean | `true`            | Whether to expose default system and node.js metrics.                                                                                                     |
| `N8N_METRICS_INCLUDE_CACHE_METRICS`             | Boolean | false             | Whether to include metrics (true) for cache hits and misses, or not include them (false).                                                                 |
| `N8N_METRICS_INCLUDE_MESSAGE_EVENT_BUS_METRICS` | Boolean | `false`           | Whether to include metrics (true) for events, or not include them (false).                                                                                |
| `N8N_METRICS_INCLUDE_WORKFLOW_ID_LABEL`         | Boolean | `false`           | Whether to include a label for the workflow ID on workflow metrics.                                                                                       |
| `N8N_METRICS_INCLUDE_NODE_TYPE_LABEL`           | Boolean | `false`           | Whether to include a label for the node type on node metrics.                                                                                             |
| `N8N_METRICS_INCLUDE_CREDENTIAL_TYPE_LABEL`     | Boolean | `false`           | Whether to include a label for the credential type on credential metrics.                                                                                 |
| `N8N_METRICS_INCLUDE_API_ENDPOINTS`             | Boolean | `false`           | Whether to expose metrics for API endpoints.                                                                                                              |
| `N8N_METRICS_INCLUDE_API_PATH_LABEL`            | Boolean | `false`           | Whether to include a label for the path of API invocations.                                                                                               |
| `N8N_METRICS_INCLUDE_API_METHOD_LABEL`          | Boolean | `false`           | Whether to include a label for the HTTP method (GET, POST, ...) of API invocations.                                                                       |
| `N8N_METRICS_INCLUDE_API_STATUS_CODE_LABEL`     | Boolean | `false`           | Whether to include a label for the HTTP status code (200, 404, ...) of API invocations.                                                                   |
| `N8N_METRICS_INCLUDE_QUEUE_METRICS`             | Boolean | `false`           | Whether to include metrics for jobs in scaling mode. Not supported in multi-main setup.                                                                   |
| `N8N_METRICS_QUEUE_METRICS_INTERVAL`            | Integer | `20`              | How often (in seconds) to update queue metrics.                                                                                                           |
| `N8N_ENDPOINT_REST`                             | String  | `rest`            | The path used for REST endpoint.                                                                                                                          |
| `N8N_ENDPOINT_WEBHOOK`                          | String  | `webhook`         | The path used for webhook endpoint.                                                                                                                       |
| `N8N_ENDPOINT_WEBHOOK_TEST`                     | String  | `webhook-test`    | The path used for test-webhook endpoint.                                                                                                                  |
| `N8N_ENDPOINT_WEBHOOK_WAIT`                     | String  | `webhook-waiting` | The path used for waiting-webhook endpoint.                                                                                                               |
| `WEBHOOK_URL`                                   | String  | -                 | Used to manually provide the Webhook URL when running n8n behind a reverse proxy. See [here](../../configuration-examples/webhook-url/) for more details. |
| `N8N_DISABLE_PRODUCTION_MAIN_PROCESS`           | Boolean | `false`           | Disable production webhooks from main process. This helps ensure no HTTP traffic load to main process when using webhook-specific processes.              |

# Executions environment variables

File-based configuration

You can add `_FILE` to individual variables to provide their configuration in a separate file. Refer to [Keeping sensitive data in separate files](../../configuration-methods/#keeping-sensitive-data-in-separate-files) for more details.

This page lists environment variables to configure workflow execution settings.

| Variable                                     | Type                            | Default   | Description                                                                                                                                                                                                                                   |
| -------------------------------------------- | ------------------------------- | --------- | --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| `EXECUTIONS_MODE`                            | Enum string: `regular`, `queue` | `regular` | Whether executions should run directly or using queue. Refer to [Queue mode](../../../scaling/queue-mode/) for more details.                                                                                                                  |
| `EXECUTIONS_TIMEOUT`                         | Number                          | `-1`      | Sets a default timeout (in seconds) to all workflows after which n8n stops their execution. Users can override this for individual workflows up to the duration set in `EXECUTIONS_TIMEOUT_MAX`. Set `EXECUTIONS_TIMEOUT` to `-1` to disable. |
| `EXECUTIONS_TIMEOUT_MAX`                     | Number                          | `3600`    | The maximum execution time (in seconds) that users can set for an individual workflow.                                                                                                                                                        |
| `EXECUTIONS_DATA_SAVE_ON_ERROR`              | Enum string: `all`, `none`      | `all`     | Whether n8n saves execution data on error.                                                                                                                                                                                                    |
| `EXECUTIONS_DATA_SAVE_ON_SUCCESS`            | Enum string: `all`, `none`      | `all`     | Whether n8n saves execution data on success.                                                                                                                                                                                                  |
| `EXECUTIONS_DATA_SAVE_ON_PROGRESS`           | Boolean                         | `false`   | Whether to save progress for each node executed (true) or not (false).                                                                                                                                                                        |
| `EXECUTIONS_DATA_SAVE_MANUAL_EXECUTIONS`     | Boolean                         | `true`    | Whether to save data of executions when started manually.                                                                                                                                                                                     |
| `EXECUTIONS_DATA_PRUNE`                      | Boolean                         | `true`    | Whether to delete data of past executions on a rolling basis.                                                                                                                                                                                 |
| `EXECUTIONS_DATA_MAX_AGE`                    | Number                          | `336`     | The execution age (in hours) before it's deleted.                                                                                                                                                                                             |
| `EXECUTIONS_DATA_PRUNE_MAX_COUNT`            | Number                          | `10000`   | Maximum number of executions to keep in the database. 0 = no limit                                                                                                                                                                            |
| `EXECUTIONS_DATA_HARD_DELETE_BUFFER`         | Number                          | `1`       | How old (hours) the finished execution data has to be to get hard-deleted. By default, this buffer excludes recent executions as the user may need them while building a workflow.                                                            |
| `EXECUTIONS_DATA_PRUNE_HARD_DELETE_INTERVAL` | Number                          | `15`      | How often (minutes) execution data should be hard-deleted.                                                                                                                                                                                    |
| `EXECUTIONS_DATA_PRUNE_SOFT_DELETE_INTERVAL` | Number                          | `60`      | How often (minutes) execution data should be soft-deleted.                                                                                                                                                                                    |
| `N8N_CONCURRENCY_PRODUCTION_LIMIT`           | Number                          | `-1`      | Max production executions allowed to run concurrently, in both regular and scaling modes. `-1` to disable in regular mode.                                                                                                                    |

# External data storage environment variables

File-based configuration

You can add `_FILE` to individual variables to provide their configuration in a separate file. Refer to [Keeping sensitive data in separate files](../../configuration-methods/#keeping-sensitive-data-in-separate-files) for more details.

Refer to [External storage](../../../scaling/external-storage/) for more information on using external storage for binary data.

| Variable                                   | Type    | Default | Description                                                                                                                                                                                                                                                                                     |
| ------------------------------------------ | ------- | ------- | ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| `N8N_EXTERNAL_STORAGE_S3_HOST`             | String  | -       | Host of the n8n bucket in S3-compatible external storage. For example, `s3.us-east-1.amazonaws.com`                                                                                                                                                                                             |
| `N8N_EXTERNAL_STORAGE_S3_BUCKET_NAME`      | String  | -       | Name of the n8n bucket in S3-compatible external storage.                                                                                                                                                                                                                                       |
| `N8N_EXTERNAL_STORAGE_S3_BUCKET_REGION`    | String  | -       | Region of the n8n bucket in S3-compatible external storage. For example, `us-east-1`                                                                                                                                                                                                            |
| `N8N_EXTERNAL_STORAGE_S3_ACCESS_KEY`       | String  | -       | Access key in S3-compatible external storage                                                                                                                                                                                                                                                    |
| `N8N_EXTERNAL_STORAGE_S3_ACCESS_SECRET`    | String  | -       | Access secret in S3-compatible external storage.                                                                                                                                                                                                                                                |
| `N8N_EXTERNAL_STORAGE_S3_AUTH_AUTO_DETECT` | Boolean | -       | Use automatic credential detection to authenticate S3 calls for external storage. This will ignore the access key and access secret and use the default [credential provider chain](https://docs.aws.amazon.com/sdk-for-javascript/v3/developer-guide/setting-credentials-node.html#credchain). |

# External hooks environment variables

File-based configuration

You can add `_FILE` to individual variables to provide their configuration in a separate file. Refer to [Keeping sensitive data in separate files](../../configuration-methods/#keeping-sensitive-data-in-separate-files) for more details.

You can define external hooks that n8n executes whenever a specific operation runs. Refer to [Backend hooks](../../../../embed/configuration/#backend-hooks) for examples of available hooks and [Hook files](../../../../embed/configuration/#backend-hook-files) for information on file formatting.

| Variable                       | Type   | Description                                                                                                |
| ------------------------------ | ------ | ---------------------------------------------------------------------------------------------------------- |
| `EXTERNAL_HOOK_FILES`          | String | Files containing backend external hooks. Provide multiple files as a colon-separated list ("`:`").         |
| `EXTERNAL_FRONTEND_HOOKS_URLS` | String | URLs to files containing frontend external hooks. Provide multiple URLs as a colon-separated list ("`:`"). |

# External secrets environment variables

File-based configuration

You can add `_FILE` to individual variables to provide their configuration in a separate file. Refer to [Keeping sensitive data in separate files](../../configuration-methods/#keeping-sensitive-data-in-separate-files) for more details.

You can use an external secrets store to manage credentials for n8n. Refer to [External secrets](../../../../external-secrets/) for details.

| Variable                               | Type   | Default           | Description                                         |
| -------------------------------------- | ------ | ----------------- | --------------------------------------------------- |
| `N8N_EXTERNAL_SECRETS_UPDATE_INTERVAL` | Number | `300` (5 minutes) | How often (in seconds) to check for secret updates. |

# Insights environment variables

File-based configuration

You can add `_FILE` to individual variables to provide their configuration in a separate file. Refer to [Keeping sensitive data in separate files](../../configuration-methods/#keeping-sensitive-data-in-separate-files) for more details.

Insights gives instance owners and admins visibility into how workflows perform over time. Refer to [Insights](../../../../insights/) for details.

| Variable                                                 | Type   | Default | Description                                                                             |
| -------------------------------------------------------- | ------ | ------- | --------------------------------------------------------------------------------------- |
| `N8N_DISABLED_MODULES`                                   | String | -       | Set to `insights` to disable the feature and metrics collection for an instance.        |
| `N8N_INSIGHTS_COMPACTION_BATCH_SIZE`                     | Number | 500     | The number of raw insights data to compact in a single batch.                           |
| `N8N_INSIGHTS_COMPACTION_DAILY_TO_WEEKLY_THRESHOLD_DAYS` | Number | 180     | The maximum age (in days) of daily insights data to compact.                            |
| `N8N_INSIGHTS_COMPACTION_HOURLY_TO_DAILY_THRESHOLD_DAYS` | Number | 90      | The maximum age (in days) of hourly insights data to compact.                           |
| `N8N_INSIGHTS_COMPACTION_INTERVAL_MINUTES`               | Number | 60      | Interval (in minutes) at which compaction should run.                                   |
| `N8N_INSIGHTS_FLUSH_BATCH_SIZE`                          | Number | 1000    | The maximum number of insights data to keep in the buffer before flushing.              |
| `N8N_INSIGHTS_FLUSH_INTERVAL_SECONDS`                    | Number | 30      | The interval (in seconds) at which the insights data should be flushed to the database. |

# License environment variables

File-based configuration

You can add `_FILE` to individual variables to provide their configuration in a separate file. Refer to [Keeping sensitive data in separate files](../../configuration-methods/#keeping-sensitive-data-in-separate-files) for more details.

To enable certain licensed features, you must first activate your license. You can do this either through the UI or by setting environment variables. For more information, see [license key](../../../../license-key/).

| Variable                                  | Type    | Default                        | Description                                                                                                                                                                                                                                                                                                                     |
| ----------------------------------------- | ------- | ------------------------------ | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| `N8N_HIDE_USAGE_PAGE`                     | boolean | `false`                        | Hide the usage and plans page in the app.                                                                                                                                                                                                                                                                                       |
| `N8N_LICENSE_ACTIVATION_KEY`              | String  | `''`                           | Activation key to initialize license. Not applicable if the n8n instance was already activated.                                                                                                                                                                                                                                 |
| `N8N_LICENSE_AUTO_RENEW_ENABLED`          | Boolean | `true`                         | Enables (true) or disables (false) autorenewal for licenses. If disabled, you need to manually renew the license every 10 days by navigating to **Settings** > **Usage and plan**, and pressing `F5`. Failure to renew the license will disable all licensed features.                                                          |
| `N8N_LICENSE_DETACH_FLOATING_ON_SHUTDOWN` | Boolean | `true`                         | Controls whether the instance releases [floating entitlements](../../../../glossary/#entitlement-n8n) back to the pool upon shutdown. Set to `true` to allow other instances to reuse the entitlements, or `false` to retain them. For production instances that must always keep their licensed features, set this to `false`. |
| `N8N_LICENSE_SERVER_URL`                  | String  | `https://license.n8n.io/v1`    | Server URL to retrieve license.                                                                                                                                                                                                                                                                                                 |
| `N8N_LICENSE_TENANT_ID`                   | Number  | `1`                            | Tenant ID associated with the license. Only set this variable if explicitly instructed by n8n.                                                                                                                                                                                                                                  |
| `https_proxy_license_server`              | String  | `https://user:pass@proxy:port` | Proxy server URL for HTTPS requests to retrieve license. This variable name needs to be lowercase.                                                                                                                                                                                                                              |

# Logs environment variables

File-based configuration

You can add `_FILE` to individual variables to provide their configuration in a separate file. Refer to [Keeping sensitive data in separate files](../../configuration-methods/#keeping-sensitive-data-in-separate-files) for more details.

This page lists environment variables to set up logging for debugging. Refer to [Logging in n8n](../../../logging-monitoring/logging/) for details.

## n8n logs

| Variable                        | Type                                                           | Default                             | Description                                                                                                                                                                                                                     |
| ------------------------------- | -------------------------------------------------------------- | ----------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| `N8N_LOG_LEVEL`                 | Enum string: `info`, `warn`, `error`, `debug`                  | `info`                              | Log output level. Refer to [Log levels](../../../logging-monitoring/logging/#log-levels) for details.                                                                                                                           |
| `N8N_LOG_OUTPUT`                | Enum string: `console`, `file`                                 | `console`                           | Where to output logs. Provide multiple values as a comma-separated list.                                                                                                                                                        |
| `N8N_LOG_FORMAT`                | Enum string: `text`, `json`                                    | `text`                              | The log format to use. `text` prints human readable messages. `json` prints one JSON object per line containing the message, level, timestamp, and all metadata. This is useful for production monitoring as well as debugging. |
| `N8N_LOG_CRON_ACTIVE_INTERVAL`  | Number                                                         | `0`                                 | Interval in minutes to log currently active cron jobs. Set to `0` to disable.                                                                                                                                                   |
| `N8N_LOG_FILE_COUNT_MAX`        | Number                                                         | `100`                               | Max number of log files to keep.                                                                                                                                                                                                |
| `N8N_LOG_FILE_SIZE_MAX`         | Number                                                         | `16`                                | Max size of each log file in MB.                                                                                                                                                                                                |
| `N8N_LOG_FILE_LOCATION`         | String                                                         | `<n8n-directory-path>/logs/n8n.log` | Log file location. Requires N8N_LOG_OUTPUT set to `file`.                                                                                                                                                                       |
| `DB_LOGGING_ENABLED`            | Boolean                                                        | `false`                             | Whether to enable database-specific logging.                                                                                                                                                                                    |
| `DB_LOGGING_OPTIONS`            | Enum string: `query`, `error`, `schema`, `warn`, `info`, `log` | `error`                             | Database log output level. To enable all logging, specify `all`. Refer to [TypeORM logging options](https://orkhan.gitbook.io/typeorm/docs/docs/advanced-topics/5-logging#logging-options)                                      |
| `DB_LOGGING_MAX_EXECUTION_TIME` | Number                                                         | `1000`                              | Maximum execution time (in milliseconds) before n8n logs a warning. Set to `0` to disable long running query warning.                                                                                                           |
| `CODE_ENABLE_STDOUT`            | Boolean                                                        | `false`                             | Set to `true` to send Code node logs from `console.log` or `print` to the process's stdout, only for production executions.                                                                                                     |
| `NO_COLOR`                      | any                                                            | `undefined`                         | Set to any value to output logs without ANSI colors. For more information, see the [no-color.org website](https://no-color.org/).                                                                                               |

## Log streaming

Refer to [Log streaming](../../../../log-streaming/) for more information on this feature.

| Variable                                 | Type    | Default       | Description                                                                                                                     |
| ---------------------------------------- | ------- | ------------- | ------------------------------------------------------------------------------------------------------------------------------- |
| `N8N_EVENTBUS_CHECKUNSENTINTERVAL`       | Number  | `0`           | How often (in milliseconds) to check for unsent event messages. Can in rare cases send message twice. Set to `0` to disable it. |
| `N8N_EVENTBUS_LOGWRITER_SYNCFILEACCESS`  | Boolean | `false`       | Whether all file access happens synchronously within the thread (true) or not (false).                                          |
| `N8N_EVENTBUS_LOGWRITER_KEEPLOGCOUNT`    | Number  | `3`           | Number of event log files to keep.                                                                                              |
| `N8N_EVENTBUS_LOGWRITER_MAXFILESIZEINKB` | Number  | `10240`       | Maximum size (in kilo-bytes) of an event log file before a new one starts.                                                      |
| `N8N_EVENTBUS_LOGWRITER_LOGBASENAME`     | String  | `n8nEventLog` | Basename of the event log file.                                                                                                 |

# Nodes environment variables

File-based configuration

You can add `_FILE` to individual variables to provide their configuration in a separate file. Refer to [Keeping sensitive data in separate files](../../configuration-methods/#keeping-sensitive-data-in-separate-files) for more details.

This page lists the environment variables configuration options for managing [nodes](../../../../glossary/#node-n8n) in n8n, including specifying which nodes to load or exclude, importing built-in or external modules in the Code node, and enabling community nodes.

| Variable                                 | Type             | Default                       | Description                                                                                                                                                                                                               |
| ---------------------------------------- | ---------------- | ----------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| `N8N_COMMUNITY_PACKAGES_ENABLED`         | Boolean          | `true`                        | Enables (true) or disables (false) the functionality to install and load community nodes. If set to false, neither verified nor unverified community packages will be available, regardless of their individual settings. |
| `N8N_COMMUNITY_PACKAGES_PREVENT_LOADING` | Boolean          | `false`                       | Prevents (true) or allows (false) loading installed community nodes on instance startup. Use this if a faulty node prevents the instance from starting.                                                                   |
| `N8N_COMMUNITY_PACKAGES_REGISTRY`        | String           | `https://registry.npmjs.org`  | NPM registry URL to pull community packages from (license required).                                                                                                                                                      |
| `N8N_CUSTOM_EXTENSIONS`                  | String           | -                             | Specify the path to directories containing your custom nodes.                                                                                                                                                             |
| `N8N_PYTHON_ENABLED`                     | Boolean          | `true`                        | Whether to enable Python execution on the Code node.                                                                                                                                                                      |
| `N8N_UNVERIFIED_PACKAGES_ENABLED`        | Boolean          | `true`                        | When `N8N_COMMUNITY_PACKAGES_ENABLED` is true, this variable controls whether to enable the installation and use of unverified community nodes from an NPM registry (true) or not (false).                                |
| `N8N_VERIFIED_PACKAGES_ENABLED`          | Boolean          | `true`                        | When `N8N_COMMUNITY_PACKAGES_ENABLED` is true, this variable controls whether to show verified community nodes in the nodes panel for installation and use (true) or to hide them (false).                                |
| `NODE_FUNCTION_ALLOW_BUILTIN`            | String           | -                             | Permit users to import specific built-in modules in the Code node. Use * to allow all. n8n disables importing modules by default.                                                                                         |
| `NODE_FUNCTION_ALLOW_EXTERNAL`           | String           | -                             | Permit users to import specific external modules (from `n8n/node_modules`) in the Code node. n8n disables importing modules by default.                                                                                   |
| `NODES_ERROR_TRIGGER_TYPE`               | String           | `n8n-nodes-base.errorTrigger` | Specify which node type to use as Error Trigger.                                                                                                                                                                          |
| `NODES_EXCLUDE`                          | Array of strings | -                             | Specify which nodes not to load. For example, to block nodes that can be a security risk if users aren't trustworthy: `NODES_EXCLUDE: "[\"n8n-nodes-base.executeCommand\", \"@n8n/n8n-nodes-langchain.lmChatDeepSeek\"]"` |
| `NODES_INCLUDE`                          | Array of strings | -                             | Specify which nodes to load.                                                                                                                                                                                              |

# Queue mode environment variables

File-based configuration

You can add `_FILE` to individual variables to provide their configuration in a separate file. Refer to [Keeping sensitive data in separate files](../../configuration-methods/#keeping-sensitive-data-in-separate-files) for more details.

You can run n8n in different modes depending on your needs. Queue mode provides the best scalability. Refer to [Queue mode](../../../scaling/queue-mode/) for more information.

| Variable                                | Type    | Default     | Description                                                                                                                                                                                                                                                                                                                                       |
| --------------------------------------- | ------- | ----------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| `OFFLOAD_MANUAL_EXECUTIONS_TO_WORKERS`  | Boolean | `false`     | Set to `true` if you want manual executions to run on the worker rather than on main.                                                                                                                                                                                                                                                             |
| `QUEUE_BULL_PREFIX`                     | String  | -           | Prefix to use for all queue keys.                                                                                                                                                                                                                                                                                                                 |
| `QUEUE_BULL_REDIS_DB`                   | Number  | `0`         | The Redis database used.                                                                                                                                                                                                                                                                                                                          |
| `QUEUE_BULL_REDIS_HOST`                 | String  | `localhost` | The Redis host.                                                                                                                                                                                                                                                                                                                                   |
| `QUEUE_BULL_REDIS_PORT`                 | Number  | `6379`      | The Redis port used.                                                                                                                                                                                                                                                                                                                              |
| `QUEUE_BULL_REDIS_USERNAME`             | String  | -           | The Redis username (needs Redis version 6 or above). Don't define it for Redis < 6 compatibility                                                                                                                                                                                                                                                  |
| `QUEUE_BULL_REDIS_PASSWORD`             | String  | -           | The Redis password.                                                                                                                                                                                                                                                                                                                               |
| `QUEUE_BULL_REDIS_TIMEOUT_THRESHOLD`    | Number  | `10000`     | The Redis timeout threshold (in ms).                                                                                                                                                                                                                                                                                                              |
| `QUEUE_BULL_REDIS_CLUSTER_NODES`        | String  | -           | Expects a comma-separated list of Redis Cluster nodes in the format `host:port`, for the Redis client to initially connect to. If running in queue mode (`EXECUTIONS_MODE = queue`), setting this variable will create a Redis Cluster client instead of a Redis client, and n8n will ignore `QUEUE_BULL_REDIS_HOST` and `QUEUE_BULL_REDIS_PORT`. |
| `QUEUE_BULL_REDIS_TLS`                  | Boolean | `false`     | Enable TLS on Redis connections.                                                                                                                                                                                                                                                                                                                  |
| `QUEUE_BULL_REDIS_DUALSTACK`            | Boolean | `false`     | Enable dual-stack support (IPv4 and IPv6) on Redis connections.                                                                                                                                                                                                                                                                                   |
| `QUEUE_WORKER_TIMEOUT` (**deprecated**) | Number  | `30`        | **Deprecated** Use `N8N_GRACEFUL_SHUTDOWN_TIMEOUT` instead. How long should n8n wait (seconds) for running executions before exiting worker process on shutdown.                                                                                                                                                                                  |
| `QUEUE_HEALTH_CHECK_ACTIVE`             | Boolean | `false`     | Whether to enable health checks (true) or disable (false).                                                                                                                                                                                                                                                                                        |
| `QUEUE_HEALTH_CHECK_PORT`               | Number  | 5678        | The port to serve health checks on. If you experience a port conflict error when starting a worker server using its default port, change this.                                                                                                                                                                                                    |
| `QUEUE_WORKER_LOCK_DURATION`            | Number  | `60000`     | How long (in ms) is the lease period for a worker to work on a message.                                                                                                                                                                                                                                                                           |
| `QUEUE_WORKER_LOCK_RENEW_TIME`          | Number  | `10000`     | How frequently (in ms) should a worker renew the lease time.                                                                                                                                                                                                                                                                                      |
| `QUEUE_WORKER_STALLED_INTERVAL`         | Number  | `30000`     | How often should a worker check for stalled jobs (use 0 for never).                                                                                                                                                                                                                                                                               |
| `QUEUE_WORKER_MAX_STALLED_COUNT`        | Number  | `1`         | Maximum amount of times a stalled job will be re-processed.                                                                                                                                                                                                                                                                                       |

## Multi-main setup

Refer to [Configuring multi-main setup](../../../scaling/queue-mode/#configuring-multi-main-setup) for details.

| Variable                              | Type    | Default | Description                                                           |
| ------------------------------------- | ------- | ------- | --------------------------------------------------------------------- |
| `N8N_MULTI_MAIN_SETUP_ENABLED`        | Boolean | `false` | Whether to enable multi-main setup for queue mode (license required). |
| `N8N_MULTI_MAIN_SETUP_KEY_TTL`        | Number  | `10`    | Time to live (in seconds) for leader key in multi-main setup.         |
| `N8N_MULTI_MAIN_SETUP_CHECK_INTERVAL` | Number  | `3`     | Interval (in seconds) for leader check in multi-main setup.           |

# Security environment variables

File-based configuration

You can add `_FILE` to individual variables to provide their configuration in a separate file. Refer to [Keeping sensitive data in separate files](../../configuration-methods/#keeping-sensitive-data-in-separate-files) for more details.

| Variable                                     | Type                                 | Default | Description                                                                                                                                                                                                                                                                                     |
| -------------------------------------------- | ------------------------------------ | ------- | ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| `N8N_BLOCK_ENV_ACCESS_IN_NODE`               | Boolean                              | `false` | Whether to allow users to access environment variables in expressions and the Code node (false) or not (true).                                                                                                                                                                                  |
| `N8N_BLOCK_FILE_ACCESS_TO_N8N_FILES`         | Boolean                              | `true`  | Set to `true` to block access to all files in the `.n8n` directory and user defined configuration files.                                                                                                                                                                                        |
| `N8N_ENFORCE_SETTINGS_FILE_PERMISSIONS`      | Boolean                              | `false` | Set to `true` to try to set 0600 permissions for the settings file, giving only the owner read and write access.                                                                                                                                                                                |
| `N8N_RESTRICT_FILE_ACCESS_TO`                | String                               |         | Limits access to files in these directories. Provide multiple files as a colon-separated list ("`:`").                                                                                                                                                                                          |
| `N8N_SECURITY_AUDIT_DAYS_ABANDONED_WORKFLOW` | Number                               | 90      | Number of days to consider a workflow abandoned if it's not executed.                                                                                                                                                                                                                           |
| `N8N_SECURE_COOKIE`                          | Boolean                              | `true`  | Ensures that cookies are only sent over HTTPS, enhancing security.                                                                                                                                                                                                                              |
| `N8N_SAMESITE_COOKIE`                        | Enum string: `strict`, `lax`, `none` | `lax`   | Controls cross-site cookie behavior ([learn more](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Set-Cookie/SameSite)): - `strict`: Sent only for first-party requests. - `lax` (default): Sent with top-level navigation requests. - `none`: Sent in all contexts (requires HTTPS). |
| `N8N_GIT_NODE_DISABLE_BARE_REPOS`            | Boolean                              | `false` | Set to `true` to prevent the [Git node](../../../../integrations/builtin/core-nodes/n8n-nodes-base.git/) from working with bare repositories, enhancing security.                                                                                                                               |

# Source control environment variables

File-based configuration

You can add `_FILE` to individual variables to provide their configuration in a separate file. Refer to [Keeping sensitive data in separate files](../../configuration-methods/#keeping-sensitive-data-in-separate-files) for more details.

n8n uses Git-based source control to support environments. Refer to [Source control and environments](../../../../source-control-environments/setup/) for more information on how to link a Git repository to an n8n instance and configure your source control.

| Variable                                 | Type   | Default   | Description                                                                                                                   |
| ---------------------------------------- | ------ | --------- | ----------------------------------------------------------------------------------------------------------------------------- |
| `N8N_SOURCECONTROL_DEFAULT_SSH_KEY_TYPE` | String | `ed25519` | Set to `rsa` to make RSA the default SSH key type for [Source control setup](../../../../source-control-environments/setup/). |

# Task runner environment variables

File-based configuration

You can add `_FILE` to individual variables to provide their configuration in a separate file. Refer to [Keeping sensitive data in separate files](../../configuration-methods/#keeping-sensitive-data-in-separate-files) for more details.

[Task runners](../../task-runners/) execute code defined by the [Code node](../../../../integrations/builtin/core-nodes/n8n-nodes-base.code/).

## n8n instance environment variables

| Variable                            | Type                                | Default         | Description                                                                                                                                                                    |
| ----------------------------------- | ----------------------------------- | --------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------ |
| `N8N_RUNNERS_ENABLED`               | Boolean                             | `false`         | Are task runners enabled.                                                                                                                                                      |
| `N8N_RUNNERS_MODE`                  | Enum string: `internal`, `external` | `internal`      | How to launch and run the task runner. `internal` means n8n will launch a task runner as child process. `external` means an external orchestrator will launch the task runner. |
| `N8N_RUNNERS_AUTH_TOKEN`            | String                              | Random string   | Shared secret used by a task runner to authenticate to n8n. Required when using `external` mode.                                                                               |
| `N8N_RUNNERS_BROKER_PORT`           | Number                              | `5679`          | Port the task broker listens on for task runner connections.                                                                                                                   |
| `N8N_RUNNERS_BROKER_LISTEN_ADDRESS` | String                              | `127.0.0.1`     | Address the task broker listens on.                                                                                                                                            |
| `N8N_RUNNERS_MAX_PAYLOAD`           | Number                              | `1 073 741 824` | Maximum payload size in bytes for communication between a task broker and a task runner.                                                                                       |
| `N8N_RUNNERS_MAX_OLD_SPACE_SIZE`    | String                              |                 | The `--max-old-space-size` option to use for a task runner (in MB). By default, Node.js will set this based on available memory.                                               |
| `N8N_RUNNERS_MAX_CONCURRENCY`       | Number                              | `5`             | The number of concurrent tasks a task runner can execute at a time.                                                                                                            |
| `N8N_RUNNERS_TASK_TIMEOUT`          | Number                              | `60`            | How long (in seconds) a task can take to complete before the task aborts and the runner restarts. Must be greater than 0.                                                      |
| `N8N_RUNNERS_HEARTBEAT_INTERVAL`    | Number                              | `30`            | How often (in seconds) the runner must send a heartbeat to the broker, else the task aborts and the runner restarts. Must be greater than 0.                                   |
| `N8N_RUNNERS_INSECURE_MODE`         | Boolean                             | `false`         | Whether to disable all security measures in the task runner, for compatibility with modules that rely on insecure JS features. **Discouraged for production use.**             |

## Task runner launcher environment variables

| Variable                                 | Type                                          | Default                 | Description                                                                              |
| ---------------------------------------- | --------------------------------------------- | ----------------------- | ---------------------------------------------------------------------------------------- |
| `N8N_RUNNERS_LAUNCHER_LOG_LEVEL`         | Enum string: `debug`, `info`, `warn`, `error` | `info`                  | Which log messages to show.                                                              |
| `N8N_RUNNERS_AUTH_TOKEN`                 | String                                        | -                       | Shared secret used to authenticate to n8n.                                               |
| `N8N_RUNNERS_AUTO_SHUTDOWN_TIMEOUT`      | Number                                        | `15`                    | The number of seconds to wait before shutting down an idle runner.                       |
| `N8N_RUNNERS_TASK_BROKER_URI`            | String                                        | `http://127.0.0.1:5679` | The URI of the task broker server (n8n instance).                                        |
| `N8N_RUNNERS_LAUNCHER_HEALTH_CHECK_PORT` | Number                                        | `5680`                  | Port for the launcher's health check server.                                             |
| `N8N_RUNNERS_MAX_PAYLOAD`                | Number                                        | `1 073 741 824`         | Maximum payload size in bytes for communication between a task broker and a task runner. |
| `N8N_RUNNERS_MAX_CONCURRENCY`            | Number                                        | `5`                     | The number of concurrent tasks a task runner can execute at a time.                      |

## Task runner environment variables (all languages)

| Variable                                 | Type   | Default                 | Description                                                                                                 |
| ---------------------------------------- | ------ | ----------------------- | ----------------------------------------------------------------------------------------------------------- |
| `N8N_RUNNERS_GRANT_TOKEN`                | String | Random string           | Token the runner uses to authenticate with the task broker. This is automatically provided by the launcher. |
| `N8N_RUNNERS_AUTO_SHUTDOWN_TIMEOUT`      | Number | `15`                    | The number of seconds to wait before shutting down an idle runner.                                          |
| `N8N_RUNNERS_TASK_BROKER_URI`            | String | `http://127.0.0.1:5679` | The URI of the task broker server (n8n instance).                                                           |
| `N8N_RUNNERS_LAUNCHER_HEALTH_CHECK_PORT` | Number | `5680`                  | Port for the launcher's health check server.                                                                |
| `N8N_RUNNERS_MAX_PAYLOAD`                | Number | `1 073 741 824`         | Maximum payload size in bytes for communication between a task broker and a task runner.                    |
| `N8N_RUNNERS_MAX_CONCURRENCY`            | Number | `5`                     | The number of concurrent tasks a task runner can execute at a time.                                         |

## Task runner environment variables (JavaScript)

| Variable                               | Type    | Default            | Description                                                                                                                                                                                                          |
| -------------------------------------- | ------- | ------------------ | -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| `NODE_FUNCTION_ALLOW_BUILTIN`          | String  | -                  | Permit users to import specific built-in modules in the Code node. Use * to allow all. n8n disables importing modules by default.                                                                                    |
| `NODE_FUNCTION_ALLOW_EXTERNAL`         | String  | -                  | Permit users to import specific external modules (from `n8n/node_modules`) in the Code node. n8n disables importing modules by default.                                                                              |
| `N8N_RUNNERS_ALLOW_PROTOTYPE_MUTATION` | Boolean | `false`            | Whether to allow prototype mutation for external libraries. Set to `true` to allow modules that rely on runtime prototype mutation (for example, [`puppeteer`](https://pptr.dev/)) at the cost of relaxing security. |
| `GENERIC_TIMEZONE`                     | \*      | `America/New_York` | The [same default timezone as configured for the n8n instance](../timezone-localization/).                                                                                                                           |
| `NODE_OPTIONS`                         | String  | -                  | [Options](https://nodejs.org/api/cli.html#node_optionsoptions) for Node.js.                                                                                                                                          |
| `N8N_RUNNERS_MAX_OLD_SPACE_SIZE`       | String  |                    | The `--max-old-space-size` option to use for a task runner (in MB). By default, Node.js will set this based on available memory.                                                                                     |

## Task runner environment variables (Python)

| Variable                      | Type    | Default                                                                                                                                  | Description                                                                                                                                                                                                                                                                                                                    |
| ----------------------------- | ------- | ---------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------ |
| `N8N_RUNNERS_STDLIB_ALLOW`    | String  | -                                                                                                                                        | Python standard library modules that you can use in the Code node, including their submodules. Use `*` to allow all stdlib modules. n8n disables all Python standard library imports by default.                                                                                                                               |
| `N8N_RUNNERS_EXTERNAL_ALLOW`  | String  | -                                                                                                                                        | Third-party Python modules that are allowed to be used in the Code node, including their submodules. Use `*` to allow all external modules. n8n disables all third-party Python modules by default. Third-party Python modules must be [included](../../task-runners/#adding-extra-dependencies) in the `n8nio/runners` image. |
| `N8N_RUNNERS_BUILTINS_DENY`   | String  | `eval,exec,compile,open,input,breakpoint,getattr,object,type,vars,setattr,delattr,hasattr,dir,memoryview,__build_class__,globals,locals` | Python built-ins that you can't use in the Code node. Set to an empty string to allow all built-ins.                                                                                                                                                                                                                           |
| `N8N_BLOCK_RUNNER_ENV_ACCESS` | Boolean | `true`                                                                                                                                   | Whether to block access to the runner's environment from within Python code tasks. Set to `false` to enable all Python code node users access to the runner's environment via `os.environ`. For security reasons, environment variable access is blocked by default.                                                           |

# Timezone and localization environment variables

File-based configuration

You can add `_FILE` to individual variables to provide their configuration in a separate file. Refer to [Keeping sensitive data in separate files](../../configuration-methods/#keeping-sensitive-data-in-separate-files) for more details.

| Variable             | Type   | Default            | Description                                                                                                                                                                                                                                                                                                                                                    |
| -------------------- | ------ | ------------------ | -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| `GENERIC_TIMEZONE`   | \*     | `America/New_York` | The n8n instance timezone. Important for schedule nodes (such as Cron).                                                                                                                                                                                                                                                                                        |
| `N8N_DEFAULT_LOCALE` | String | `en`               | A locale identifier, compatible with the [Accept-Language header](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Accept-Language). n8n doesn't support regional identifiers, such as `de-AT`. When running in a locale other than the default, n8n displays UI strings in the selected locale, and falls back to `en` for any untranslated strings. |

# User management SMTP, and two-factor authentication environment variables

File-based configuration

You can add `_FILE` to individual variables to provide their configuration in a separate file. Refer to [Keeping sensitive data in separate files](../../configuration-methods/#keeping-sensitive-data-in-separate-files) for more details.

Refer to [User management](../../user-management-self-hosted/) for more information on setting up user management and emails.

| Variable                                        | Type    | Default | Description                                                                                                                                                                                                                                                          |
| ----------------------------------------------- | ------- | ------- | -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| `N8N_EMAIL_MODE`                                | String  | `smtp`  | Enable emails.                                                                                                                                                                                                                                                       |
| `N8N_SMTP_HOST`                                 | String  | -       | *your_SMTP_server_name*                                                                                                                                                                                                                                              |
| `N8N_SMTP_PORT`                                 | Number  | -       | *your_SMTP_server_port*                                                                                                                                                                                                                                              |
| `N8N_SMTP_USER`                                 | String  | -       | *your_SMTP_username*                                                                                                                                                                                                                                                 |
| `N8N_SMTP_PASS`                                 | String  | -       | *your_SMTP_password*                                                                                                                                                                                                                                                 |
| `N8N_SMTP_OAUTH_SERVICE_CLIENT`                 | String  | -       | If using 2LO with a service account this is your client ID                                                                                                                                                                                                           |
| `N8N_SMTP_OAUTH_PRIVATE_KEY`                    | String  | -       | If using 2LO with a service account this is your private key                                                                                                                                                                                                         |
| `N8N_SMTP_SENDER`                               | String  | -       | Sender email address. You can optionally include the sender name. Example with name: *N8N `<contact@n8n.com>`*                                                                                                                                                       |
| `N8N_SMTP_SSL`                                  | Boolean | `true`  | Whether to use SSL for SMTP (true) or not (false).                                                                                                                                                                                                                   |
| `N8N_SMTP_STARTTLS`                             | Boolean | `true`  | Whether to use STARTTLS for SMTP (true) or not (false).                                                                                                                                                                                                              |
| `N8N_UM_EMAIL_TEMPLATES_INVITE`                 | String  | -       | Full path to your HTML email template. This overrides the default template for invite emails.                                                                                                                                                                        |
| `N8N_UM_EMAIL_TEMPLATES_PWRESET`                | String  | -       | Full path to your HTML email template. This overrides the default template for password reset emails.                                                                                                                                                                |
| `N8N_UM_EMAIL_TEMPLATES_WORKFLOW_SHARED`        | String  | -       | Overrides the default HTML template for notifying users that a workflow was shared. Provide the full path to the template.                                                                                                                                           |
| `N8N_UM_EMAIL_TEMPLATES_CREDENTIALS_SHARED`     | String  | -       | Overrides the default HTML template for notifying users that a credential was shared. Provide the full path to the template.                                                                                                                                         |
| `N8N_UM_EMAIL_TEMPLATES_PROJECT_SHARED`         | String  | -       | Overrides the default HTML template for notifying users that a project was shared. Provide the full path to the template.                                                                                                                                            |
| `N8N_USER_MANAGEMENT_JWT_SECRET`                | String  | -       | Set a specific JWT secret. By default, n8n generates one on start.                                                                                                                                                                                                   |
| `N8N_USER_MANAGEMENT_JWT_DURATION_HOURS`        | Number  | 168     | Set an expiration date for the JWTs in hours.                                                                                                                                                                                                                        |
| `N8N_USER_MANAGEMENT_JWT_REFRESH_TIMEOUT_HOURS` | Number  | 0       | How many hours before the JWT expires to automatically refresh it. 0 means 25% of `N8N_USER_MANAGEMENT_JWT_DURATION_HOURS`. -1 means it will never refresh, which forces users to log in again after the period defined in `N8N_USER_MANAGEMENT_JWT_DURATION_HOURS`. |
| `N8N_MFA_ENABLED`                               | Boolean | `true`  | Whether to enable two-factor authentication (true) or disable (false). n8n ignores this if existing users have 2FA enabled.                                                                                                                                          |
| `N8N_INVITE_LINKS_EMAIL_ONLY`                   | Boolean | `false` | When set to true, n8n will only deliver invite links via email and will not expose them through the API. This option enhances security by preventing invite URLs from being accessible programmatically, or to high priviledged users.                               |

# Workflows environment variables

File-based configuration

You can add `_FILE` to individual variables to provide their configuration in a separate file. Refer to [Keeping sensitive data in separate files](../../configuration-methods/#keeping-sensitive-data-in-separate-files) for more details.

| Variable                                    | Type    | Default                  | Description                                                                                                                                                                                |
| ------------------------------------------- | ------- | ------------------------ | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------ |
| `N8N_ONBOARDING_FLOW_DISABLED`              | Boolean | `false`                  | Whether to disable onboarding tips when creating a new workflow (true) or not (false).                                                                                                     |
| `N8N_WORKFLOW_ACTIVATION_BATCH_SIZE`        | Number  | `1`                      | How many workflows to activate simultaneously during startup.                                                                                                                              |
| `N8N_WORKFLOW_CALLER_POLICY_DEFAULT_OPTION` | String  | `workflowsFromSameOwner` | Which workflows can call a workflow. Options are: `any`, `none`, `workflowsFromAList`, `workflowsFromSameOwner`. This feature requires [Workflow sharing](../../../../workflows/sharing/). |
| `N8N_WORKFLOW_TAGS_DISABLED`                | Boolean | `false`                  | Whether to disable workflow tags (true) or enable tags (false).                                                                                                                            |
| `WORKFLOWS_DEFAULT_NAME`                    | String  | `My workflow`            | The default name used for new workflows.                                                                                                                                                   |

# Docker Installation

n8n recommends using [Docker](https://www.docker.com/) for most self-hosting needs. It provides a clean, isolated environment, avoids operating system and tooling incompatibilities, and makes database and environment management simpler.

You can also use n8n in Docker with [Docker Compose](../server-setups/docker-compose/). You can find Docker Compose configurations for various architectures in the [n8n-hosting repository](https://github.com/n8n-io/n8n-hosting).

Self-hosting knowledge prerequisites

Self-hosting n8n requires technical knowledge, including:

- Setting up and configuring servers and containers
- Managing application resources and scaling
- Securing servers and applications
- Configuring n8n

n8n recommends self-hosting for expert users. Mistakes can lead to data loss, security issues, and downtime. If you aren't experienced at managing servers, n8n recommends [n8n Cloud](https://n8n.io/cloud/).

You can also follow along with our video guide here:

## Prerequisites

Before proceeding, install Docker:

- [Docker Desktop](https://docs.docker.com/get-docker/) is available for Mac, Windows, and Linux. Docker Desktop includes the Docker Engine and Docker Compose.
- [Docker Engine](https://docs.docker.com/engine/install/) and [Docker Compose](https://docs.docker.com/compose/install/linux/) are also available as separate packages for Linux. Use this for Linux machines without a graphical environment or when you don't want the Docker Desktop UI.

Latest and Next versions

n8n releases a new minor version most weeks. The `latest` version is for production use. `next` is the most recent release. You should treat `next` as a beta: it may be unstable. To report issues, use the [forum](https://community.n8n.io/c/questions/12).

Current `latest`: 1.118.2\
Current `next`: 1.119.0

## Starting n8n

From your terminal, run the following commands, replacing the `<YOUR_TIMEZONE>` placeholders with [your timezone](https://en.wikipedia.org/wiki/List_of_tz_database_time_zones#List):

```
docker volume create n8n_data

docker run -it --rm \
 --name n8n \
 -p 5678:5678 \
 -e GENERIC_TIMEZONE="<YOUR_TIMEZONE>" \
 -e TZ="<YOUR_TIMEZONE>" \
 -e N8N_ENFORCE_SETTINGS_FILE_PERMISSIONS=true \
 -e N8N_RUNNERS_ENABLED=true \
 -v n8n_data:/home/node/.n8n \
 docker.n8n.io/n8nio/n8n
```

This command creates a volume to store persistent data, downloads the required n8n image, and starts the container with the following settings:

- Maps and exposes port `5678` on the host.
- Sets the timezone for the container:
  - the `TZ` environment variable sets the system timezone to control what scripts and commands like `date` return.
  - the [`GENERIC_TIMEZONE` environment variable](../../configuration/environment-variables/timezone-localization/) sets the correct timezone for schedule-oriented nodes like the [Schedule Trigger node](../../../integrations/builtin/core-nodes/n8n-nodes-base.scheduletrigger/).
- Enforces secure file permissions for the n8n configuration file.
- Enables [task runners](../../configuration/task-runners/), the recommended way of executing tasks in n8n.
- Mounts the `n8n_data` volume to the `/home/node/.n8n` directory to persist your data across container restarts.

Once running, you can access n8n by opening: <http://localhost:5678>

## Using with PostgreSQL

By default, n8n uses SQLite to save [credentials](../../../glossary/#credential-n8n), past executions, and workflows. n8n also supports PostgreSQL, configurable using environment variables as detailed below.

Persisting the `.n8n` directory still recommended

When using PostgreSQL, n8n doesn't need to use the `.n8n` directory for the SQLite database file. However, the directory still contains other important data like encryption keys, instance logs, and source control feature assets. While you can work around some of these requirements, (for example, by setting the [`N8N_ENCRYPTION_KEY` environment variable](../../configuration/environment-variables/deployment/)), it's best to continue mapping a persistent volume for the directory to avoid potential issues.

To use n8n with PostgreSQL, execute the following commands, replacing the placeholders (depicted within angled brackets, for example `<POSTGRES_USER>`) with your actual values:

```
docker volume create n8n_data

docker run -it --rm \
 --name n8n \
 -p 5678:5678 \
 -e GENERIC_TIMEZONE="<YOUR_TIMEZONE>" \
 -e TZ="<YOUR_TIMEZONE>" \
 -e N8N_ENFORCE_SETTINGS_FILE_PERMISSIONS=true \
 -e N8N_RUNNERS_ENABLED=true \
 -e DB_TYPE=postgresdb \
 -e DB_POSTGRESDB_DATABASE=<POSTGRES_DATABASE> \
 -e DB_POSTGRESDB_HOST=<POSTGRES_HOST> \
 -e DB_POSTGRESDB_PORT=<POSTGRES_PORT> \
 -e DB_POSTGRESDB_USER=<POSTGRES_USER> \
 -e DB_POSTGRESDB_SCHEMA=<POSTGRES_SCHEMA> \
 -e DB_POSTGRESDB_PASSWORD=<POSTGRES_PASSWORD> \
 -v n8n_data:/home/node/.n8n \
 docker.n8n.io/n8nio/n8n
```

You can find a complete `docker-compose` file for PostgreSQL in the [n8n hosting repository](https://github.com/n8n-io/n8n-hosting/tree/main/docker-compose/withPostgres).

## Updating

To update n8n, in Docker Desktop, navigate to the **Images** tab and select **Pull** from the context menu to download the latest n8n image:

You can also use the command line to pull the latest, or a specific version:

```
# Pull latest (stable) version
docker pull docker.n8n.io/n8nio/n8n

# Pull specific version
docker pull docker.n8n.io/n8nio/n8n:1.81.0

# Pull next (unstable) version
docker pull docker.n8n.io/n8nio/n8n:next
```

After pulling the updated image, stop your n8n container and start it again. You can also use the command line. Replace `<container_id>` in the commands below with the container ID you find in the first command:

```
# Find your container ID
docker ps -a

# Stop the container with the `<container_id>`
docker stop <container_id>

# Remove the container with the `<container_id>`
docker rm <container_id>

# Start the container
docker run --name=<container_name> [options] -d docker.n8n.io/n8nio/n8n
```

### Updating Docker Compose

If you run n8n using a Docker Compose file, follow these steps to update n8n:

```
# Navigate to the directory containing your docker compose file
cd </path/to/your/compose/file/directory>

# Pull latest version
docker compose pull

# Stop and remove older version
docker compose down

# Start the container
docker compose up -d
```

## n8n with tunnel

Danger

Use this for local development and testing. It isn't safe to use it in production.

To use webhooks for trigger nodes of external services like GitHub, n8n has to be reachable from the web. n8n runs a [tunnel service](https://github.com/localtunnel/localtunnel) that can redirect requests from n8n's servers to your local n8n instance.

Start n8n with `--tunnel` by running:

```
docker volume create n8n_data

docker run -it --rm \
 --name n8n \
 -p 5678:5678 \
 -e GENERIC_TIMEZONE="<YOUR_TIMEZONE>" \
 -e TZ="<YOUR_TIMEZONE>" \
 -e N8N_ENFORCE_SETTINGS_FILE_PERMISSIONS=true \
 -e N8N_RUNNERS_ENABLED=true \
 -v n8n_data:/home/node/.n8n \
 docker.n8n.io/n8nio/n8n \
 start --tunnel
```

## Next steps

- Find more information about Docker setup in the README file for the [Docker image](https://github.com/n8n-io/n8n/tree/master/docker/images/n8n).
- Learn more about [configuring](../../configuration/environment-variables/) and [scaling](../../scaling/overview/) n8n.
- Or explore using n8n: try the [Quickstarts](../../../try-it-out/).

# npm

npm is a quick way to get started with n8n on your local machine. You must have [Node.js](https://nodejs.org/en/) installed. n8n requires a Node.js version between 20.19 and 24.x, inclusive.

Latest and Next versions

n8n releases a new minor version most weeks. The `latest` version is for production use. `next` is the most recent release. You should treat `next` as a beta: it may be unstable. To report issues, use the [forum](https://community.n8n.io/c/questions/12).

Current `latest`: 1.118.2\
Current `next`: 1.119.0

## Try n8n with npx

You can try n8n without installing it using npx.

From the terminal, run:

```
npx n8n
```

This command will download everything that's needed to start n8n. You can then access n8n and start building workflows by opening <http://localhost:5678>.

## Install globally with npm

To install n8n globally, use npm:

```
npm install n8n -g
```

To install or update to a specific version of n8n use the `@` syntax to specify the version. For example:

```
npm install -g n8n@0.126.1
```

To install `next`:

```
npm install -g n8n@next
```

After the installation, start n8n by running:

```
n8n
# or
n8n start
```

### Next steps

Try out n8n using the [Quickstarts](../../../try-it-out/).

## Updating

To update your n8n instance to the `latest` version, run:

```
npm update -g n8n
```

To install the `next` version:

```
npm install -g n8n@next
```

## n8n with tunnel

Danger

Use this for local development and testing. It isn't safe to use it in production.

To use webhooks for trigger nodes of external services like GitHub, n8n has to be reachable from the web. n8n runs a [tunnel service](https://github.com/localtunnel/localtunnel) that can redirect requests from n8n's servers to your local n8n instance.

Start n8n with `--tunnel` by running:

```
n8n start --tunnel
```

## Reverting an upgrade

Install the older version that you want to go back to.

If the upgrade involved a database migration:

1. Check the feature documentation and release notes to see if there are any manual changes you need to make.
1. Run `n8n db:revert` on your current version to roll back the database. If you want to revert more than one database migration, you need to repeat this process.

## Windows troubleshooting

If you are experiencing issues running n8n on Windows, make sure your Node.js environment is correctly set up. Follow Microsoft's guide to [Install NodeJS on Windows](https://learn.microsoft.com/en-us/windows/dev-environment/javascript/nodejs-on-windows).

# Update self-hosted n8n

It's important to keep your n8n version up to date. This ensures you get the latest features and fixes.

Some tips when updating:

- Update frequently: this avoids having to jump multiple versions at once, reducing the risk of a disruptive update. Try to update at least once a month.
- Check the [Release notes](../../../release-notes/) for breaking changes.
- Use [Environments](../../../source-control-environments/) to create a test version of your instance. Test the update there first.

For instructions on how to update, refer to the documentation for your installation method:

- [Installed with npm](../npm/#updating)
- [Installed with Docker](../docker/#updating)

# Server setups

Self-host with Docker Compose:

- [Digital Ocean](digital-ocean/)
- [Heroku](heroku/)
- [Hetzner Cloud](hetzner/)

Self-host with Google Cloud Run (with access to n8n workflow tools for Google Workspace, e.g. Gmail, Drive):

- [Google Cloud Run](google-cloud-run/)

Starting points for a Kubernetes setup:

- [AWS](aws/)
- [Azure](azure/)
- [Google Kubernetes Engine (GKE)](google-kubernetes-engine/)

Configuration guides to help you get started on other platforms:

- [Docker Compose](docker-compose/)

# Hosting n8n on Amazon Web Services

This hosting guide shows you how to self-host n8n with Amazon Web Services (AWS). It uses n8n with Postgres as a database backend using Kubernetes to manage the necessary resources and reverse proxy.

## Hosting options

AWS offers several ways suitable for hosting n8n, including EC2 (virtual machines), and EKS (containers running with Kubernetes).

This guide uses [EKS](https://aws.amazon.com/eks/) as the hosting option. Using Kubernetes requires some additional complexity and configuration, but is the best method for scaling n8n as demand changes.

## Prerequisites

The steps in this guide use a mix of the AWS UI and [the eksctl CLI tool for EKS](https://eksctl.io).

While not mentioned in the documentation for eksctl, you also need to [install the AWS CLI tool](https://docs.aws.amazon.com/cli/latest/userguide/getting-started-install.html), and [configure authentication of the tool](https://docs.aws.amazon.com/cli/latest/userguide/cli-configure-quickstart.html).

Self-hosting knowledge prerequisites

Self-hosting n8n requires technical knowledge, including:

- Setting up and configuring servers and containers
- Managing application resources and scaling
- Securing servers and applications
- Configuring n8n

n8n recommends self-hosting for expert users. Mistakes can lead to data loss, security issues, and downtime. If you aren't experienced at managing servers, n8n recommends [n8n Cloud](https://n8n.io/cloud/).

Latest and Next versions

n8n releases a new minor version most weeks. The `latest` version is for production use. `next` is the most recent release. You should treat `next` as a beta: it may be unstable. To report issues, use the [forum](https://community.n8n.io/c/questions/12).

Current `latest`: 1.118.2\
Current `next`: 1.119.0

## Create a cluster

Use the eksctl tool to create a cluster specifying a name and a region with the following command:

```
eksctl create cluster --name n8n --region <your-aws-region>
```

This can take a while to create the cluster.

Once the cluster is created, eksctl automatically sets the kubectl context to the cluster.

## Clone configuration repository

Kubernetes and n8n require a series of configuration files. You can clone these from [this repository](https://github.com/n8n-io/n8n-hosting). The following steps tell you what each file does, and what settings you need to change.

Clone the repository with the following command:

```
git clone https://github.com/n8n-io/n8n-hosting.git
```

And change directory:

```
cd n8n-hosting/kubernetes
```

## Configure Postgres

For larger scale n8n deployments, Postgres provides a more robust database backend than SQLite.

### Configure volume for persistent storage

To maintain data between pod restarts, the Postgres deployment needs a persistent volume. The default AWS storage class, [gp3](https://docs.aws.amazon.com/ebs/latest/userguide/general-purpose.html#gp3-ebs-volume-type), is suitable for this purpose. This is defined in the `postgres-claim0-persistentvolumeclaim.yaml` manifest.

```
…
spec:
  storageClassName: gp3
  accessModes:
    - ReadWriteOnce
…
```

### Postgres environment variables

Postgres needs some environment variables set to pass to the application running in the containers.

The example `postgres-secret.yaml` file contains placeholders you need to replace with values of your own for user details and the database to use.

The `postgres-deployment.yaml` manifest then uses the values from this manifest file to send to the application pods.

## Configure n8n

### Create a volume for file storage

While not essential for running n8n, using persistent volumes helps maintain files uploaded while using n8n and if you want to persist [manual n8n encryption keys](../../../configuration/environment-variables/deployment/) between restarts, which saves a file containing the key into file storage during startup.

The `n8n-claim0-persistentvolumeclaim.yaml` manifest creates this, and the n8n Deployment mounts that claim in the `volumes` section of the `n8n-deployment.yaml` manifest.

```
…
volumes:
  - name: n8n-claim0
    persistentVolumeClaim:
      claimName: n8n-claim0
…
```

### Pod resources

[Kubernetes](https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/) lets you specify the minimum resources application containers need and the limits they can run to. The example YAML files cloned above contain the following in the `resources` section of the `n8n-deployment.yaml` file:

```
…
resources:
  requests:
    memory: "250Mi"
  limits:
    memory: "500Mi"
…
```

This defines a minimum of 250mb per container, a maximum of 500mb, and lets Kubernetes handle CPU. You can change these values to match your own needs. As a guide, here are the resources values for the n8n cloud offerings:

- **Start**: 320mb RAM, 10 millicore CPU burstable
- **Pro (10k executions)**: 640mb RAM, 20 millicore CPU burstable
- **Pro (50k executions)**: 1280mb RAM, 80 millicore CPU burstable

### Optional: Environment variables

You can configure n8n settings and behaviors using environment variables.

Create an `n8n-secret.yaml` file. Refer to [Environment variables](../../../configuration/environment-variables/) for n8n environment variables details.

## Deployments

The two deployment manifests (`n8n-deployment.yaml` and `postgres-deployment.yaml`) define the n8n and Postgres applications to Kubernetes.

The manifests define the following:

- Send the environment variables defined to each application pod
- Define the container image to use
- Set resource consumption limits
- The `volumes` defined earlier and `volumeMounts` to define the path in the container to mount volumes.
- Scaling and restart policies. The example manifests define one instance of each pod. You should change this to meet your needs.

## Services

The two service manifests (`postgres-service.yaml` and `n8n-service.yaml`) expose the services to the outside world using the Kubernetes load balancer using ports 5432 and 5678 respectively by default.

## Send to Kubernetes cluster

Send all the manifests to the cluster by running the following command in the `n8n-kubernetes-hosting` directory:

```
kubectl apply -f .
```

Namespace error

You may see an error message about not finding an "n8n" namespace as that resources isn't ready yet. You can run the same command again, or apply the namespace manifest first with the following command:

```
kubectl apply -f namespace.yaml
```

## Set up DNS

n8n typically operates on a subdomain. Create a DNS record with your provider for the subdomain and point it to a static address of the instance.

To find the address of the n8n service running on the instance:

1. Open the **Clusters** section of the **Amazon Elastic Kubernetes Service** page in the AWS console.
1. Select the name of the cluster to open its configuration page.
1. Select the **Resources** tab, then **Service and networking** > **Services**.
1. Select the **n8n** service and copy the **Load balancer URLs** value. Use this value suffixed with the n8n service port (5678) for DNS.

Use HTTP

This guide uses HTTP connections for the services it defines, for example in `n8n-deployment.yaml`. However, if you click the **Load balancer URLs** value, EKS takes you to an "HTTPS" URL which results in an error. To solve this, when you open the n8n subdomain, make sure to use HTTP.

## Delete resources

If you need to delete the setup, you can remove the resources created by the manifests with the following command:

```
kubectl delete -f .
```

## Next steps

- Learn more about [configuring](../../../configuration/environment-variables/) and [scaling](../../../scaling/overview/) n8n.
- Or explore using n8n: try the [Quickstarts](../../../../try-it-out/).

# Hosting n8n on Azure

This hosting guide shows you how to self-host n8n on Azure. It uses n8n with Postgres as a database backend using Kubernetes to manage the necessary resources and reverse proxy.

## Prerequisites

You need [The Azure command line tool](https://learn.microsoft.com/en-us/cli/azure/install-azure-cli)

Self-hosting knowledge prerequisites

Self-hosting n8n requires technical knowledge, including:

- Setting up and configuring servers and containers
- Managing application resources and scaling
- Securing servers and applications
- Configuring n8n

n8n recommends self-hosting for expert users. Mistakes can lead to data loss, security issues, and downtime. If you aren't experienced at managing servers, n8n recommends [n8n Cloud](https://n8n.io/cloud/).

Latest and Next versions

n8n releases a new minor version most weeks. The `latest` version is for production use. `next` is the most recent release. You should treat `next` as a beta: it may be unstable. To report issues, use the [forum](https://community.n8n.io/c/questions/12).

Current `latest`: 1.118.2\
Current `next`: 1.119.0

## Hosting options

Azure offers several ways suitable for hosting n8n, including Azure Container Instances (optimized for running containers), Linux Virtual Machines, and Azure Kubernetes Service (containers running with Kubernetes).

This guide uses the Azure Kubernetes Service (AKS) as the hosting option. Using Kubernetes requires some additional complexity and configuration, but is the best method for scaling n8n as demand changes.

The steps in this guide use a mix of the Azure UI and command line tool, but you can use either to accomplish most tasks.

## Open the Azure Kubernetes Service

From [the Azure portal](https://portal.azure.com/) select **Kubernetes services**.

## Create a cluster

From the Kubernetes services page, select **Create** > **Create a Kubernetes cluster**.

You can select any of the configuration options that suit your needs, then select **Create** when done.

## Set Kubectl context

The remainder of the steps in this guide require you to set the Azure instance as the Kubectl context. You can find the connection details for a cluster instance by opening its details page and then the **Connect** button. The resulting code snippets shows the steps to paste and run into a terminal to change your local Kubernetes settings to use the new cluster.

## Clone configuration repository

Kubernetes and n8n require a series of configuration files. You can clone these from [this repository](https://github.com/n8n-io/n8n-hosting). The following steps tell you which file configures what and what you need to change.

Clone the repository with the following command:

```
git clone https://github.com/n8n-io/n8n-hosting.git
```

And change directory:

```
cd n8n-hosting/kubernetes
```

## Configure Postgres

For larger scale n8n deployments, Postgres provides a more robust database backend than SQLite.

### Configure volume for persistent storage

To maintain data between pod restarts, the Postgres deployment needs a persistent volume. The default storage class is suitable for this purpose and is defined in the `postgres-claim0-persistentvolumeclaim.yaml` manifest.

Specialized storage classes

If you have specialised or higher requirements for storage classes, [read more on the options Azure offers in the documentation](https://learn.microsoft.com/en-us/azure/aks/concepts-storage#storage-classes).

### Postgres environment variables

Postgres needs some environment variables set to pass to the application running in the containers.

The example `postgres-secret.yaml` file contains placeholders you need to replace with your own values. Postgres will use these details when creating the database..

The `postgres-deployment.yaml` manifest then uses the values from this manifest file to send to the application pods.

## Configure n8n

### Create a volume for file storage

While not essential for running n8n, using persistent volumes is required for:

- Using nodes that interact with files, such as the binary data node.
- If you want to persist [manual n8n encryption keys](../../../configuration/environment-variables/deployment/) between restarts. This saves a file containing the key into file storage during startup.

The `n8n-claim0-persistentvolumeclaim.yaml` manifest creates this, and the n8n Deployment mounts that claim in the `volumes` section of the `n8n-deployment.yaml` manifest.

```
…
volumes:
  - name: n8n-claim0
    persistentVolumeClaim:
      claimName: n8n-claim0
…
```

### Pod resources

[Kubernetes lets you](https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/) optionally specify the minimum resources application containers need and the limits they can run to. The example YAML files cloned above contain the following in the `resources` section of the `n8n-deployment.yaml` file:

```
…
resources:
  requests:
    memory: "250Mi"
  limits:
    memory: "500Mi"
…
```

This defines a minimum of 250mb per container, a maximum of 500mb, and lets Kubernetes handle CPU. You can change these values to match your own needs. As a guide, here are the resources values for the n8n cloud offerings:

- **Start**: 320mb RAM, 10 millicore CPU burstable
- **Pro (10k executions)**: 640mb RAM, 20 millicore CPU burstable
- **Pro (50k executions)**: 1280mb RAM, 80 millicore CPU burstable

### Optional: Environment variables

You can configure n8n settings and behaviors using environment variables.

Create an `n8n-secret.yaml` file. Refer to [Environment variables](../../../configuration/environment-variables/) for n8n environment variables details.

## Deployments

The two deployment manifests (`n8n-deployment.yaml` and `postgres-deployment.yaml`) define the n8n and Postgres applications to Kubernetes.

The manifests define the following:

- Send the environment variables defined to each application pod
- Define the container image to use
- Set resource consumption limits with the `resources` object
- The `volumes` defined earlier and `volumeMounts` to define the path in the container to mount volumes.
- Scaling and restart policies. The example manifests define one instance of each pod. You should change this to meet your needs.

## Services

The two service manifests (`postgres-service.yaml` and `n8n-service.yaml`) expose the services to the outside world using the Kubernetes load balancer using ports 5432 and 5678 respectively.

## Send to Kubernetes cluster

Send all the manifests to the cluster with the following command:

```
kubectl apply -f .
```

Namespace error

You may see an error message about not finding an "n8n" namespace as that resources isn't ready yet. You can run the same command again, or apply the namespace manifest first with the following command:

```
kubectl apply -f namespace.yaml
```

## Set up DNS

n8n typically operates on a subdomain. Create a DNS record with your provider for the subdomain and point it to the IP address of the n8n service. Find the IP address of the n8n service from the **Services & ingresses** menu item of the cluster you want to use under the **External IP** column. You need to add the n8n port, "5678" to the URL.

Static IP addresses with AKS

[Read this tutorial](https://learn.microsoft.com/en-us/azure/aks/static-ip) for more details on how to use a static IP address with AKS.

## Delete resources

Remove the resources created by the manifests with the following command:

```
kubectl delete -f .
```

## Next steps

- Learn more about [configuring](../../../configuration/environment-variables/) and [scaling](../../../scaling/overview/) n8n.
- Or explore using n8n: try the [Quickstarts](../../../../try-it-out/).

# Hosting n8n on DigitalOcean

This hosting guide shows you how to self-host n8n on a DigitalOcean droplet. It uses:

- [Caddy](https://caddyserver.com) (a reverse proxy) to allow access to the Droplet from the internet. Caddy will also automatically create and manage SSL / TLS certificates for your n8n instance.
- [Docker Compose](https://docs.docker.com/compose/) to create and define the application components and how they work together.

Self-hosting knowledge prerequisites

Self-hosting n8n requires technical knowledge, including:

- Setting up and configuring servers and containers
- Managing application resources and scaling
- Securing servers and applications
- Configuring n8n

n8n recommends self-hosting for expert users. Mistakes can lead to data loss, security issues, and downtime. If you aren't experienced at managing servers, n8n recommends [n8n Cloud](https://n8n.io/cloud/).

Latest and Next versions

n8n releases a new minor version most weeks. The `latest` version is for production use. `next` is the most recent release. You should treat `next` as a beta: it may be unstable. To report issues, use the [forum](https://community.n8n.io/c/questions/12).

Current `latest`: 1.118.2\
Current `next`: 1.119.0

## Create a Droplet

1. [Log in](https://cloud.digitalocean.com/login) to DigitalOcean.
1. Select the project to host the Droplet, or [create a new project](https://docs.digitalocean.com/products/projects/how-to/create/).
1. In your project, select **Droplets** from the **Manage** menu.
1. [Create a new Droplet](https://docs.digitalocean.com/products/droplets/how-to/create/) using the [Docker image](https://marketplace.digitalocean.com/apps/docker) available on the **Marketplace** tab.

Droplet resources

When creating the Droplet, DigitalOcean asks you to choose a plan. For most usage levels, a basic shared CPU plan is enough.

SSH key or Password

DigitalOcean lets you choose between SSH key and password-based authentication. SSH keys are considered more secure.

## Log in to your Droplet and create new user

The rest of this guide requires you to log in to the Droplet using a terminal with SSH. Refer to [How to Connect to Droplets with SSH](https://docs.digitalocean.com/products/droplets/how-to/connect-with-ssh/) for more information.

You should create a new user, to avoid working as the root user:

1. Log in as root.

1. Create a new user:

   ```
   adduser <username>
   ```

1. Follow the prompts in the CLI to finish creating the user.

1. Grant the new user administrative privileges:

   ```
   usermod -aG sudo <username>
   ```

   You can now run commands with superuser privileges by using `sudo` before the command.

1. Follow the steps to set up SSH for the new user: [Add Public Key Authentication](https://www.digitalocean.com/community/tutorials/initial-server-setup-with-ubuntu-14-04#step-four-add-public-key-authentication-recommended).

1. Log out of the droplet.

1. Log in using SSH as the new user.

## Clone configuration repository

Docker Compose, n8n, and Caddy require a series of folders and configuration files. You can clone these from [this repository](https://github.com/n8n-io/n8n-docker-caddy) into the home folder of the logged-in user on your Droplet. The following steps will tell you which file to change and what changes to make.

Clone the repository with the following command:

```
git clone https://github.com/n8n-io/n8n-docker-caddy.git
```

And change directory to the root of the repository you cloned:

```
cd n8n-docker-caddy
```

## Default folders and files

The host operating system (the DigitalOcean Droplet) copies the two folders you created to Docker containers to make them available to Docker. The two folders are:

- `caddy_config`: Holds the Caddy configuration files.
- `local_files`: A folder for files you upload or add using n8n.

### Create Docker volumes

To persist the Caddy cache between restarts and speed up start times, create [a Docker volume](https://docs.docker.com/storage/volumes/) that Docker reuses between restarts:

```
sudo docker volume create caddy_data
```

Create a Docker volume for the n8n data:

```
sudo docker volume create n8n_data
```

## Set up DNS

n8n typically operates on a subdomain. Create a DNS record with your provider for the subdomain and point it to the IP address of the Droplet. The exact steps for this depend on your DNS provider, but typically you need to create a new "A" record for the n8n subdomain. DigitalOcean provide [An Introduction to DNS Terminology, Components, and Concepts](https://www.digitalocean.com/community/tutorials/an-introduction-to-dns-terminology-components-and-concepts).

## Open ports

n8n runs as a web application, so the Droplet needs to allow incoming access to traffic on port 80 for non-secure traffic, and port 443 for secure traffic.

Open the following ports in the Droplet's firewall by running the following two commands:

```
sudo ufw allow 80
sudo ufw allow 443
```

## Configure n8n

n8n needs some environment variables set to pass to the application running in the Docker container. The example `.env` file contains placeholders you need to replace with values of your own.

Open the file with the following command:

```
nano .env
```

The file contains inline comments to help you know what to change.

Refer to [Environment variables](../../../configuration/environment-variables/) for n8n environment variables details.

## The Docker Compose file

The Docker Compose file (`docker-compose.yml`) defines the services the application needs, in this case Caddy and n8n.

- The Caddy service definition defines the ports it uses and the local volumes to copy to the containers.
- The n8n service definition defines the ports it uses, the environment variables n8n needs to run (some defined in the `.env` file), and the volumes it needs to copy to the containers.

The Docker Compose file uses the environment variables set in the `.env` file, so you shouldn't need to change it's content, but to take a look, run the following command:

```
nano docker-compose.yml
```

## Configure Caddy

Caddy needs to know which domains it should serve, and which port to expose to the outside world. Edit the `Caddyfile` file in the `caddy_config` folder.

```
nano caddy_config/Caddyfile
```

Change the placeholder domain to yours. If you followed the steps to name the subdomain n8n, your full domain is similar to `n8n.example.com`. The `n8n` in the `reverse_proxy` setting tells Caddy to use the service definition defined in the `docker-compose.yml` file:

```
n8n.<domain>.<suffix> {
    reverse_proxy n8n:5678 {
      flush_interval -1
    }
}
```

If you were to use `automate.example.com`, your `Caddyfile` may look something like:

```
automate.example.com {
    reverse_proxy n8n:5678 {
      flush_interval -1
    }
}
```

## Start Docker Compose

Start n8n and Caddy with the following command:

```
sudo docker compose up -d
```

This may take a few minutes.

## Test your setup

In your browser, open the URL formed of the subdomain and domain name defined earlier. Enter the user name and password defined earlier, and you should be able to access n8n.

## Stop n8n and Caddy

You can stop n8n and Caddy with the following command:

```
sudo docker compose stop
```

## Updating

If you run n8n using a Docker Compose file, follow these steps to update n8n:

```
# Navigate to the directory containing your docker compose file
cd </path/to/your/compose/file/directory>

# Pull latest version
docker compose pull

# Stop and remove older version
docker compose down

# Start the container
docker compose up -d
```

## Next steps

- Learn more about [configuring](../../../configuration/environment-variables/) and [scaling](../../../scaling/overview/) n8n.
- Or explore using n8n: try the [Quickstarts](../../../../try-it-out/).

# Docker-Compose

These instructions cover how to run n8n on a Linux server using Docker Compose.

If you have already installed Docker and Docker-Compose, then you can start with [step 3](#3-dns-setup).

You can find Docker Compose configurations for various architectures in the [n8n-hosting repository](https://github.com/n8n-io/n8n-hosting).

Self-hosting knowledge prerequisites

Self-hosting n8n requires technical knowledge, including:

- Setting up and configuring servers and containers
- Managing application resources and scaling
- Securing servers and applications
- Configuring n8n

n8n recommends self-hosting for expert users. Mistakes can lead to data loss, security issues, and downtime. If you aren't experienced at managing servers, n8n recommends [n8n Cloud](https://n8n.io/cloud/).

Latest and Next versions

n8n releases a new minor version most weeks. The `latest` version is for production use. `next` is the most recent release. You should treat `next` as a beta: it may be unstable. To report issues, use the [forum](https://community.n8n.io/c/questions/12).

Current `latest`: 1.118.2\
Current `next`: 1.119.0

## 1. Install Docker and Docker Compose

The way that you install Docker and Docker Compose depends on your Linux distribution. You can find specific instructions for each component in the links below:

- [Docker Engine](https://docs.docker.com/engine/install/)
- [Docker Compose](https://docs.docker.com/compose/install/linux/)

After following the installation instructions, verify that Docker and Docker Compose are available by typing:

```
docker --version
docker compose version
```

## 2. Optional: Non-root user access

You can optionally grant access to run Docker without the `sudo` command.

To grant access to the user that you're currently logged in with (assuming they have `sudo` access), run:

```
sudo usermod -aG docker ${USER}
# Register the `docker` group membership with current session without changing your primary group
exec sg docker newgrp
```

To grant access to a different user, type the following, substituting `<USER_TO_RUN_DOCKER>` with the appropriate username:

```
sudo usermod -aG docker <USER_TO_RUN_DOCKER>
```

You will need to run `exec sg docker newgrp` from any of that user's existing sessions for it to access the new group permissions.

You can verify that your current session recognizes the `docker` group by typing:

```
groups
```

## 3. DNS setup

To host n8n online or on a network, create a dedicated subdomain pointed at your server.

Add an A record to route the subdomain accordingly:

| Record type | Name                              | Destination                |
| ----------- | --------------------------------- | -------------------------- |
| A           | `n8n` (or your desired subdomain) | `<your_server_IP_address>` |

## 4. Create an `.env` file

Create a project directory to store your n8n environment configuration and Docker Compose files and navigate inside:

```
mkdir n8n-compose
cd n8n-compose
```

Inside the `n8n-compose` directory, create an `.env` file to customize your n8n instance's details. Change it to match your own information:

```
# DOMAIN_NAME and SUBDOMAIN together determine where n8n will be reachable from
# The top level domain to serve from
DOMAIN_NAME=example.com

# The subdomain to serve from
SUBDOMAIN=n8n

# The above example serve n8n at: https://n8n.example.com

# Optional timezone to set which gets used by Cron and other scheduling nodes
# New York is the default value if not set
GENERIC_TIMEZONE=Europe/Berlin

# The email address to use for the TLS/SSL certificate creation
SSL_EMAIL=user@example.com
```

## 5. Create local files directory

Inside your project directory, create a directory called `local-files` for sharing files between the n8n instance and the host system (for example, using the [Read/Write Files from Disk node](../../../../integrations/builtin/core-nodes/n8n-nodes-base.readwritefile/)):

```
mkdir local-files
```

The Docker Compose file below can automatically create this directory, but doing it manually ensures that it's created with the right ownership and permissions.

## 6. Create Docker Compose file

Create a `compose.yaml` file. Paste the following in the file:

```
services:
  traefik:
    image: "traefik"
    restart: always
    command:
      - "--api.insecure=true"
      - "--providers.docker=true"
      - "--providers.docker.exposedbydefault=false"
      - "--entrypoints.web.address=:80"
      - "--entrypoints.web.http.redirections.entryPoint.to=websecure"
      - "--entrypoints.web.http.redirections.entrypoint.scheme=https"
      - "--entrypoints.websecure.address=:443"
      - "--certificatesresolvers.mytlschallenge.acme.tlschallenge=true"
      - "--certificatesresolvers.mytlschallenge.acme.email=${SSL_EMAIL}"
      - "--certificatesresolvers.mytlschallenge.acme.storage=/letsencrypt/acme.json"
    ports:
      - "80:80"
      - "443:443"
    volumes:
      - traefik_data:/letsencrypt
      - /var/run/docker.sock:/var/run/docker.sock:ro

  n8n:
    image: docker.n8n.io/n8nio/n8n
    restart: always
    ports:
      - "127.0.0.1:5678:5678"
    labels:
      - traefik.enable=true
      - traefik.http.routers.n8n.rule=Host(`${SUBDOMAIN}.${DOMAIN_NAME}`)
      - traefik.http.routers.n8n.tls=true
      - traefik.http.routers.n8n.entrypoints=web,websecure
      - traefik.http.routers.n8n.tls.certresolver=mytlschallenge
      - traefik.http.middlewares.n8n.headers.SSLRedirect=true
      - traefik.http.middlewares.n8n.headers.STSSeconds=315360000
      - traefik.http.middlewares.n8n.headers.browserXSSFilter=true
      - traefik.http.middlewares.n8n.headers.contentTypeNosniff=true
      - traefik.http.middlewares.n8n.headers.forceSTSHeader=true
      - traefik.http.middlewares.n8n.headers.SSLHost=${DOMAIN_NAME}
      - traefik.http.middlewares.n8n.headers.STSIncludeSubdomains=true
      - traefik.http.middlewares.n8n.headers.STSPreload=true
      - traefik.http.routers.n8n.middlewares=n8n@docker
    environment:
      - N8N_ENFORCE_SETTINGS_FILE_PERMISSIONS=true
      - N8N_HOST=${SUBDOMAIN}.${DOMAIN_NAME}
      - N8N_PORT=5678
      - N8N_PROTOCOL=https
      - N8N_RUNNERS_ENABLED=true
      - NODE_ENV=production
      - WEBHOOK_URL=https://${SUBDOMAIN}.${DOMAIN_NAME}/
      - GENERIC_TIMEZONE=${GENERIC_TIMEZONE}
      - TZ=${GENERIC_TIMEZONE}
    volumes:
      - n8n_data:/home/node/.n8n
      - ./local-files:/files

volumes:
  n8n_data:
  traefik_data:
```

The Docker Compose file above configures two containers: one for n8n, and one to run [traefik](https://github.com/traefik/traefik), an application proxy to manage TLS/SSL certificates and handle routing.

It also creates and mounts two [Docker Volumes](https://docs.docker.com/engine/storage/volumes/) and mounts the `local-files` directory you created earlier:

| Name            | Type                                                        | Container mount   | Description                                                                                                                         |
| --------------- | ----------------------------------------------------------- | ----------------- | ----------------------------------------------------------------------------------------------------------------------------------- |
| `n8n_data`      | [Volume](https://docs.docker.com/engine/storage/volumes/)   | `/home/node/.n8n` | Where n8n saves its SQLite database file and encryption key.                                                                        |
| `traefik_data`  | [Volume](https://docs.docker.com/engine/storage/volumes/)   | `/letsencrypt`    | Where traefik saves TLS/SSL certificate data.                                                                                       |
| `./local-files` | [Bind](https://docs.docker.com/engine/storage/bind-mounts/) | `/files`          | A local directory shared between the n8n instance and host. In n8n, use the `/files` path to read from and write to this directory. |

## 7. Start Docker Compose

Start n8n by typing:

```
sudo docker compose up -d
```

To stop the containers, type:

```
sudo docker compose stop
```

## 8. Done

You can now reach n8n using the subdomain + domain combination you defined in your `.env` file configuration. The above example would result in `https://n8n.example.com`.

n8n is only accessible using secure HTTPS, not over plain HTTP.

If you have trouble reaching your instance, check your server's firewall settings and your DNS configuration.

## Next steps

- Learn more about [configuring](../../../configuration/environment-variables/) and [scaling](../../../scaling/overview/) n8n.
- Or explore using n8n: try the [Quickstarts](../../../../try-it-out/).

# Hosting n8n on Google Cloud Run

This hosting guide shows you how to self-host n8n on Google Cloud Run, a serverless container runtime. If you're just getting started with n8n and don't need a production-grade deployment, you can go with the "easy mode" option below for deployment. Otherwise, if you intend to use this n8n deployment at-scale, refer to the "durable mode" instructions further down.

You can also enable access via OAuth to Google Workspace, such as Gmail and Drive, to use these services as n8n workflow tools. Instructions for granting n8n access to these services are at the end of of this documentation.

If you want to deploy to Google Kubernetes Engine (GKE) instead, you can refer to [these instructions](../google-kubernetes-engine/).

Self-hosting knowledge prerequisites

Self-hosting n8n requires technical knowledge, including:

- Setting up and configuring servers and containers
- Managing application resources and scaling
- Securing servers and applications
- Configuring n8n

n8n recommends self-hosting for expert users. Mistakes can lead to data loss, security issues, and downtime. If you aren't experienced at managing servers, n8n recommends [n8n Cloud](https://n8n.io/cloud/).

Latest and Next versions

n8n releases a new minor version most weeks. The `latest` version is for production use. `next` is the most recent release. You should treat `next` as a beta: it may be unstable. To report issues, use the [forum](https://community.n8n.io/c/questions/12).

Current `latest`: 1.118.2\
Current `next`: 1.119.0

## Before you begin: get a Google Cloud project

If you have not yet created a Google Cloud project, [do this first](https://developers.google.com/workspace/guides/create-project) (and ensure you have billing enabled on the project; even if your Cloud Run service runs for free you must have billing activated to deploy). Otherwise, navigate to the project where you want to deploy n8n.

## Easy mode

This is the fastest way to deploy n8n on Cloud Run. For this deployment, n8n's data is in-memory so this is only recommended for demo purposes. **Anytime this Cloud Run service scales to zero or is redeployed, the n8n data will be lost.** Refer to the durable mode instructions below if you need a production-grade deployment.

If you have not yet created a Google Cloud project, [do this first](https://developers.google.com/workspace/guides/create-project) (and ensure you have billing enabled on the project; even if your Cloud Run service will run for free you must have billing enabled to activated to deploy). Otherwise, navigate to the project where you want to deploy n8n.

Open the Cloud Shell Terminal (on the Google Cloud console, either type "G" then "S" or click on the terminal icon on the upper right).

Once your session is open, you may need to run this command first to login (and follow the steps it asks you to complete):

```
gcloud auth login
```

You can also explicitly enable the Cloud Run API (even if you don't do this, it will ask if you want this enabled when you deploy):

```
gcloud services enable run.googleapis.com
```

To deploy n8n:

```
gcloud run deploy n8n \
    --image=n8nio/n8n \
    --region=us-west1 \
    --allow-unauthenticated \
    --port=5678 \
    --no-cpu-throttling \
    --memory=2Gi
```

(you can specify whichever region you prefer, instead of "us-west1")

Once the deployment finishes, open another tab to navigate to the Service URL. n8n may still be loading and you will see a "n8n is starting up. Please wait" message, but shortly thereafter you should see the n8n login screen.

Optional: If you want to keep this n8n service running for as long as possible to avoid data loss, you can also set manual scale to 1 to prevent it from autoscaling to 0.

```
gcloud run deploy n8n \
    --image=n8nio/n8n \
    --region=us-west1 \
    --allow-unauthenticated \
    --port=5678 \
    --no-cpu-throttling \
    --memory=2Gi \
    --scaling=1
```

This does not prevent data loss completely, such as whenever the Cloud Run service is re-deployed/updated. If you want truly persistant data, you should refer to the instructions below for how to attach a database.

## Durable mode

The following instructions are intended for a more durable, production-grade deployment of n8n on Cloud Run. It includes resources such as a database for persistance and secret manager for sensitive data.

## Enable APIs and set env vars

Open the Cloud Shell Terminal (on the Google Cloud console, either type "G" then "S" or click on the terminal icon on the upper right) and run these commands in the terminal session:

```
## You may need to login first
gcloud auth login

gcloud services enable run.googleapis.com
gcloud services enable sqladmin.googleapis.com
gcloud services enable secretmanager.googleapis.com
```

You'll also want to set some environment variables for the remainder of these instructions:

```
export PROJECT_ID=your-project
export REGION=region-where-you-want-this-deployed
```

## Setup your Postgres database

Run this command to create the Postgres DB instance (it will take a few minutes to complete; also ensure you update the root-password field with your own desired password):

```
gcloud sql instances create n8n-db \
    --database-version=POSTGRES_13 \
    --tier=db-f1-micro \
    --region=$REGION \
    --root-password="change-this-password" \
    --storage-size=10GB \
    --availability-type=ZONAL \
    --no-backup \
    --storage-type=HDD
```

Once complete, you can add the database that n8n will use:

```
gcloud sql databases create n8n --instance=n8n-db
```

Create the DB user for n8n (change the password value, of course):

```
gcloud sql users create n8n-user \
    --instance=n8n-db \
    --password="change-this-password"
```

You can save the password you set for this n8n-user to a file for the next step of saving the password in Secret Manager. Be sure to delete this file later.

## Store sensitive data in Secret Manager

While not required, it's absolutely recommended to store your sensitive data in Secrets Manager.

Create a secret for the database password (replace "/your/password/file" with the file you created above for the n8n-user password):

```
gcloud secrets create n8n-db-password \
    --data-file=/your/password/file \
    --replication-policy="automatic"
```

Create an encryption key (you can use your own, this example generates a random one):

```
openssl rand -base64 -out my-encryption-key 42
```

Create a secret for this encryption key (replace "my-encryption-key" if you are supplying your own):

```
gcloud secrets create n8n-encryption-key \
    --data-file=my-encryption-key \
    --replication-policy="automatic"
```

Now you can delete my-encryption-key and the database password files you created. These values are now securely stored in Secret Manager.

## Create a service account for Cloud Run

You want this Cloud Run service to be restricted to access only the resources it needs. The following commands create the service account and adds the permissions necessary to access secrets and the database:

```
gcloud iam service-accounts create n8n-service-account \
    --display-name="n8n Service Account"

gcloud secrets add-iam-policy-binding n8n-db-password \
    --member="serviceAccount:n8n-service-account@$PROJECT_ID.iam.gserviceaccount.com" \
    --role="roles/secretmanager.secretAccessor"

gcloud secrets add-iam-policy-binding n8n-encryption-key \
    --member="serviceAccount:n8n-service-account@$PROJECT_ID.iam.gserviceaccount.com" \
    --role="roles/secretmanager.secretAccessor"

gcloud projects add-iam-policy-binding $PROJECT_ID \
    --member="serviceAccount:n8n-service-account@$PROJECT_ID.iam.gserviceaccount.com" \
    --role="roles/cloudsql.client"
```

## Deploy the Cloud Run service

Now you can deploy your n8n service:

```
gcloud run deploy n8n \
    --image=n8nio/n8n:latest \
    --command="/bin/sh" \
    --args="-c,sleep 5;n8n start" \
    --region=$REGION \
    --allow-unauthenticated \
    --port=5678 \
    --memory=2Gi \
    --no-cpu-throttling \
    --set-env-vars="N8N_PORT=5678,N8N_PROTOCOL=https,DB_TYPE=postgresdb,DB_POSTGRESDB_DATABASE=n8n,DB_POSTGRESDB_USER=n8n-user,DB_POSTGRESDB_HOST=/cloudsql/$PROJECT_ID:$REGION:n8n-db,DB_POSTGRESDB_PORT=5432,DB_POSTGRESDB_SCHEMA=public,GENERIC_TIMEZONE=UTC,QUEUE_HEALTH_CHECK_ACTIVE=true" \
    --set-secrets="DB_POSTGRESDB_PASSWORD=n8n-db-password:latest,N8N_ENCRYPTION_KEY=n8n-encryption-key:latest" \
    --add-cloudsql-instances=$PROJECT_ID:$REGION:n8n-db \
    --service-account=n8n-service-account@$PROJECT_ID.iam.gserviceaccount.com
```

Once the deployment finishes, open another tab to navigate to the Service URL. You should see the n8n login screen.

## Troubleshooting

If you see a "Cannot GET /" screen this usually indicates that n8n is still starting up. You can refresh the page and it should eventually load.

## (Optional) Enabling Google Workspace services as n8n tools

If you want to use Google Workspace services (Gmail, Calendar, Drive, etc.) as tools in n8n, it's recommended to setup OAuth to access these services.

First ensure the respective APIs you want are enabled:

```
## Enable whichever APIs you need
## Note: If you want Sheets/Docs, it's not enough to just enable Drive; these services each have their own API
gcloud services enable gmail.googleapis.com
gcloud services enable drive.googleapis.com
gcloud services enable sheets.googleapis.com
gcloud services enable docs.googleapis.com
gcloud services enable calendar-json.googleapis.com
```

Re-deploy n8n on Cloud Run with the necessary OAuth callback URLs as environment variables:

```
export SERVICE_URL="your-n8n-service-URL"
## e.g. https://n8n-12345678.us-west1.run.app

gcloud run services update n8n \
    --region=$REGION \
    --update-env-vars="N8N_HOST=$(echo $SERVICE_URL | sed 's/https:\/\///'),WEBHOOK_URL=$SERVICE_URL,N8N_EDITOR_BASE_URL=$SERVICE_URL"
```

Lastly, you must setup OAuth for these services. Visit `https://console.cloud.google.com/auth` and follow these steps:

1. Click "Get Started" if this button shows (when you have not yet setup OAuth in this Cloud project).
1. For "App Information", enter whichever "App Name" and "User Support Email" you prefer.
1. For "Audience", select "Internal" if you intend to only enable access to your user(s) within this same Google Workspace. Otherwise, you can select "External".
1. Enter "Contact Information".
1. If you selected "External", then click "Audience" and add any test users you need to grant access.
1. Click "Clients" > "Create client", select "Web application" for "Application type", enter your n8n service URL into "Authorized JavaScript origins", and "/rest/oauth2-credential/callback" into "Authorized redirect URIs" where your YOUR-N8N-URL is also the n8n service URL (e.g. `https://n8n-12345678.us-west1.run.app/rest/oauth2-credential/callback`). Make sure you download the created client's JSON file since it contains the client secret which you will not be able to see later in the Console.
1. Click "Data Access" and add the scopes you want n8n to have access for (e.g. to access Google Sheets, you need `https://googleapis.com/auth/drive.file` and `https://googleapis.com/auth/spreadsheets`)
1. Now you should be able to use these workspace services. You can test if it works by logging into n8n, add a Tool for the respective service and add its credentials using the information in the OAuth client JSON file from step 6.

# Hosting n8n on Google Kubernetes Engine

Google Cloud offers several options suitable for hosting n8n, including Cloud Run (optimized for running containers), Compute Engine (VMs), and Kubernetes Engine (containers running with Kubernetes).

This guide uses the Google Kubernetes Engine (GKE) as the hosting option. If you want to use Cloud Run, refer to [these instructions](../google-cloud-run/).

Most of the steps in this guide use the Google Cloud UI, but you can also use the [gcloud command line tool](https://cloud.google.com/sdk/gcloud/) instead to undertake all the steps.

## Prerequisites

- The [gcloud command line tool](https://cloud.google.com/sdk/gcloud/)
- The [gke-gcloud-auth-plugin](https://cloud.google.com/blog/products/containers-kubernetes/kubectl-auth-changes-in-gke) (install the gcloud CLI first)

Self-hosting knowledge prerequisites

Self-hosting n8n requires technical knowledge, including:

- Setting up and configuring servers and containers
- Managing application resources and scaling
- Securing servers and applications
- Configuring n8n

n8n recommends self-hosting for expert users. Mistakes can lead to data loss, security issues, and downtime. If you aren't experienced at managing servers, n8n recommends [n8n Cloud](https://n8n.io/cloud/).

Latest and Next versions

n8n releases a new minor version most weeks. The `latest` version is for production use. `next` is the most recent release. You should treat `next` as a beta: it may be unstable. To report issues, use the [forum](https://community.n8n.io/c/questions/12).

Current `latest`: 1.118.2\
Current `next`: 1.119.0

## Create project

GCP encourages you to create projects to logically organize resources and configuration. Create a new project for your n8n deployment from your Google Cloud Console: select the project dropdown menu and then the **NEW PROJECT** button. Then select the newly created project. As you follow the other steps in this guide, make sure you have the correct project selected.

## Enable the Kubernetes Engine API

GKE isn't enabled by default. Search for "Kubernetes" in the top search bar and select "Kubernetes Engine" from the results.

Select **ENABLE** to enable the Kubernetes Engine API for this project.

## Create a cluster

From the [GKE service page](https://console.cloud.google.com/kubernetes/list/overview), select **Clusters** > **CREATE**. Make sure you select the "Standard" cluster option, n8n doesn't work with an "Autopilot" cluster. You can leave the cluster configuration on defaults unless there's anything specifically you need to change, such as location.

## Set Kubectl context

The rest of the steps in this guide require you to set the GCP instance as the Kubectl context. You can find the connection details for a cluster instance by opening its details page and selecting **CONNECT**. The displayed code snippet shows a connection string for the gcloud CLI tool. Paste and run the code snippet in the gcloud CLI to change your local Kubernetes settings to use the new gcloud cluster.

## Clone configuration repository

Kubernetes and n8n require a series of configuration files. You can clone these from [this repository](https://github.com/n8n-io/n8n-hosting) locally. The following steps explain the file configuration and how to add your information.

Clone the repository with the following command:

```
git clone https://github.com/n8n-io/n8n-hosting.git
```

And change directory:

```
cd n8n-hosting/kubernetes
```

## Configure Postgres

For larger scale n8n deployments, Postgres provides a more robust database backend than SQLite.

### Create a volume for persistent storage

To maintain data between pod restarts, the Postgres deployment needs a persistent volume. Running Postgres on GCP requires a specific Kubernetes Storage Class. You can read [this guide](https://cloud.google.com/architecture/deploying-highly-available-postgresql-with-gke) for specifics, but the `storage.yaml` manifest creates it for you. You may want to change the regions to create the storage in under the `allowedTopologies` > `matchedLabelExpressions` > `values` key. By default, they're set to `us-central`.

```
…
allowedTopologies:
  - matchLabelExpressions:
      - key: failure-domain.beta.kubernetes.io/zone
        values:
          - us-central1-b
          - us-central1-c
```

### Postgres environment variables

Postgres needs some environment variables set to pass to the application running in the containers.

The example `postgres-secret.yaml` file contains placeholders you need to replace with your own values. Postgres will use these details when creating the database..

The `postgres-deployment.yaml` manifest then uses the values from this manifest file to send to the application pods.

## Configure n8n

### Create a volume for file storage

While not essential for running n8n, using persistent volumes is required for:

- Using nodes that interact with files, such as the binary data node.
- If you want to persist [manual n8n encryption keys](../../../configuration/environment-variables/deployment/) between restarts. This saves a file containing the key into file storage during startup.

The `n8n-claim0-persistentvolumeclaim.yaml` manifest creates this, and the n8n Deployment mounts that claim in the `volumes` section of the `n8n-deployment.yaml` manifest.

```
…
volumes:
  - name: n8n-claim0
    persistentVolumeClaim:
      claimName: n8n-claim0
…
```

### Pod resources

[Kubernetes lets you](https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/) optionally specify the minimum resources application containers need and the limits they can run to. The example YAML files cloned above contain the following in the `resources` section of the `n8n-deployment.yaml` and `postgres-deployment.yaml` files:

```
…
resources:
  requests:
    memory: "250Mi"
  limits:
    memory: "500Mi"
…
```

This defines a minimum of 250mb per container, a maximum of 500mb, and lets Kubernetes handle CPU. You can change these values to match your own needs. As a guide, here are the resources values for the n8n cloud offerings:

- **Start**: 320mb RAM, 10 millicore CPU burstable
- **Pro (10k executions)**: 640mb RAM, 20 millicore CPU burstable
- **Pro (50k executions)**: 1280mb RAM, 80 millicore CPU burstable

### Optional: Environment variables

You can configure n8n settings and behaviors using environment variables.

Create an `n8n-secret.yaml` file. Refer to [Environment variables](../../../configuration/environment-variables/) for n8n environment variables details.

## Deployments

The two deployment manifests (`n8n-deployment.yaml` and `postgres-deployment.yaml`) define the n8n and Postgres applications to Kubernetes.

The manifests define the following:

- Send the environment variables defined to each application pod
- Define the container image to use
- Set resource consumption limits with the `resources` object
- The `volumes` defined earlier and `volumeMounts` to define the path in the container to mount volumes.
- Scaling and restart policies. The example manifests define one instance of each pod. You should change this to meet your needs.

## Services

The two service manifests (`postgres-service.yaml` and `n8n-service.yaml`) expose the services to the outside world using the Kubernetes load balancer using ports 5432 and 5678 respectively.

## Send to Kubernetes cluster

Send all the manifests to the cluster with the following command:

```
kubectl apply -f .
```

Namespace error

You may see an error message about not finding an "n8n" namespace as that resources isn't ready yet. You can run the same command again, or apply the namespace manifest first with the following command:

```
kubectl apply -f namespace.yaml
```

## Set up DNS

n8n typically operates on a subdomain. Create a DNS record with your provider for the subdomain and point it to the IP address of the n8n service. Find the IP address of the n8n service from the **Services & Ingress** menu item of the cluster you want to use under the **Endpoints** column.

GKE and IP addresses

[Read this GKE tutorial](https://cloud.google.com/kubernetes-engine/docs/tutorials/configuring-domain-name-static-ip#configuring_your_domain_name_records) for more details on how reserved IP addresses work with GKE and Kubernetes resources.

## Delete resources

Remove the resources created by the manifests with the following command:

```
kubectl delete -f .
```

## Next steps

- Learn more about [configuring](../../../configuration/environment-variables/) and [scaling](../../../scaling/overview/) n8n.
- Or explore using n8n: try the [Quickstarts](../../../../try-it-out/).

# Hosting n8n on Heroku

This hosting guide shows you how to self-host n8n on Heroku. It uses:

- [Docker Compose](https://docs.docker.com/compose/) to create and define the application components and how they work together.
- [Heroku's PostgreSQL service](https://devcenter.heroku.com/categories/heroku-postgres) to host n8n's data storage.
- A **Deploy to Heroku** button offering a one click, with minor configuration, deployment.

Self-hosting knowledge prerequisites

Self-hosting n8n requires technical knowledge, including:

- Setting up and configuring servers and containers
- Managing application resources and scaling
- Securing servers and applications
- Configuring n8n

n8n recommends self-hosting for expert users. Mistakes can lead to data loss, security issues, and downtime. If you aren't experienced at managing servers, n8n recommends [n8n Cloud](https://n8n.io/cloud/).

Latest and Next versions

n8n releases a new minor version most weeks. The `latest` version is for production use. `next` is the most recent release. You should treat `next` as a beta: it may be unstable. To report issues, use the [forum](https://community.n8n.io/c/questions/12).

Current `latest`: 1.118.2\
Current `next`: 1.119.0

## Use the deployment template to create a Heroku project

The quickest way to get started with deploying n8n to Heroku is using the **Deploy to Heroku** button:

This opens the **Create New App** page on Heroku. Set a name for the project, and choose the region to deploy the project to.

### Configure environment variables

Heroku pre-fills the configuration options defined in the `env` section of the `app.json` file, which also sets default values for the environment variables n8n uses.

You can change any of these values to suit your needs. You must change the following values:

- **N8N_ENCRYPTION_KEY**, which n8n uses to [encrypt user account details](../../../configuration/environment-variables/deployment/) before saving to the database.
- **WEBHOOK_URL** should match the application name you create to ensure that webhooks have the correct URL.

### Deploy n8n

Select **Deploy app**.

After Heroku builds and deploys the app it provides links to **Manage App** or **View** the application.

Heroku and DNS

Refer to the [Heroku documentation](https://devcenter.heroku.com/categories/networking-dns) to find out how to connect your domain to a Heroku application.

## Changing the deployment template

You can make changes to the deployment template by forking the [repository](https://github.com/n8n-io/n8n-heroku) and deploying from you fork.

### The Dockerfile

By default the Dockerfile pulls the latest n8n image, if you want to use a different or fixed version, then update the image tag on the top line of the `Dockerfile`.

### Heroku and exposing ports

Heroku doesn't allow Docker-based applications to define an exposed port with the `EXPOSE` command. Instead, Heroku provides a `PORT` environment variable that it dynamically populates at application runtime. The `entrypoint.sh` file overrides the default Docker image command to instead set the port variable that Heroku provides. You can then access n8n on port 80 in a web browser.

Docker limitations with Heroku

[Read this guide](https://devcenter.heroku.com/articles/container-registry-and-runtime#unsupported-dockerfile-commands) for more details on the limitations of using Docker with Heroku.

### Configuring Heroku

The `heroku.yml` file defines the application you want to create on Heroku. It consists of two sections:

- `setup` > `addons` defines the Heroku addons to use. In this case, the PostgreSQL database addon.
- The `build` section defines how Heroku builds the application. In this case it uses the Docker buildpack to build a `web` service based on the supplied `Dockerfile`.

## Next steps

- Learn more about [configuring](../../../configuration/environment-variables/) and [scaling](../../../scaling/overview/) n8n.
- Or explore using n8n: try the [Quickstarts](../../../../try-it-out/).

# Hosting n8n on Hetzner cloud

This hosting guide shows you how to self-host n8n on a Hetzner cloud server. It uses:

- [Caddy](https://caddyserver.com) (a reverse proxy) to allow access to the Server from the internet.
- [Docker Compose](https://docs.docker.com/compose/) to create and define the application components and how they work together.

Self-hosting knowledge prerequisites

Self-hosting n8n requires technical knowledge, including:

- Setting up and configuring servers and containers
- Managing application resources and scaling
- Securing servers and applications
- Configuring n8n

n8n recommends self-hosting for expert users. Mistakes can lead to data loss, security issues, and downtime. If you aren't experienced at managing servers, n8n recommends [n8n Cloud](https://n8n.io/cloud/).

Latest and Next versions

n8n releases a new minor version most weeks. The `latest` version is for production use. `next` is the most recent release. You should treat `next` as a beta: it may be unstable. To report issues, use the [forum](https://community.n8n.io/c/questions/12).

Current `latest`: 1.118.2\
Current `next`: 1.119.0

## Create a server

1. [Log in](https://console.hetzner.cloud/) to the Hetzner Cloud Console.
1. Select the project to host the server, or create a new project by selecting **+ NEW PROJECT**.
1. Select **+ CREATE SERVER** on the project tile you want to add it to.

You can change most of the settings to suit your needs, but as this guide uses Docker to run the application, under the **Image** section, select "Docker CE" from the **APPS** tab.

Type

When creating the server, Hetzner asks you to choose a plan. For most usage levels, the CPX11 type is enough.

SSH keys

Hetzner lets you choose between SSH and password-based authentication. SSH is more secure. The rest of this guide assumes you are using SSH.

## Log in to your server

The rest of this guide requires you to log in to the server using a terminal with SSH. Refer to [Access with SSH/rsync/BorgBackup](https://docs.hetzner.com/robot/storage-box/access/access-ssh-rsync-borg) for more information. You can find the public IP in the listing of the servers in your project.

## Install Docker Compose

The Hetzner Docker app image doesn't have Docker compose installed. Install it with the following commands:

```
apt update && apt -y upgrade
apt install docker-compose-plugin
```

## Clone configuration repository

Docker Compose, n8n, and Caddy require a series of folders and configuration files. You can clone these from [this repository](https://github.com/n8n-io/n8n-docker-caddy) into the root user folder of the server. The following steps will tell you which file to change and what changes to make.

Clone the repository with the following command:

```
git clone https://github.com/n8n-io/n8n-docker-caddy.git
```

And change directory to the root of the repository you cloned:

```
cd n8n-docker-caddy
```

## Default folders and files

The host operating system (the server) copies the two folders you created to Docker containers to make them available to Docker. The two folders are:

- `caddy_config`: Holds the Caddy configuration files.
- `local_files`: A folder for files you upload or add using n8n.

### Create Docker volume

To persist the Caddy cache between restarts and speed up start times, create [a Docker volume](https://docs.docker.com/storage/volumes/) that Docker reuses between restarts:

```
docker volume create caddy_data
```

Create a Docker volume for the n8n data:

```
sudo docker volume create n8n_data
```

## Set up DNS

n8n typically operates on a subdomain. Create a DNS record with your provider for the subdomain and point it to the IP address of the server. The exact steps for this depend on your DNS provider, but typically you need to create a new "A" record for the n8n subdomain. DigitalOcean provide [An Introduction to DNS Terminology, Components, and Concepts](https://www.digitalocean.com/community/tutorials/an-introduction-to-dns-terminology-components-and-concepts).

## Open ports

n8n runs as a web application, so the server needs to allow incoming access to traffic on port 80 for non-secure traffic, and port 443 for secure traffic.

Open the following ports in the server's firewall by running the following two commands:

```
sudo ufw allow 80
sudo ufw allow 443
```

## Configure n8n

n8n needs some environment variables set to pass to the application running in the Docker container. The example `.env` file contains placeholders you need to replace with values of your own.

Open the file with the following command:

```
nano .env
```

The file contains inline comments to help you know what to change.

Refer to [Environment variables](../../../configuration/environment-variables/) for n8n environment variables details.

## The Docker Compose file

The Docker Compose file (`docker-compose.yml`) defines the services the application needs, in this case Caddy and n8n.

- The Caddy service definition defines the ports it uses and the local volumes to copy to the containers.
- The n8n service definition defines the ports it uses, the environment variables n8n needs to run (some defined in the `.env` file), and the volumes it needs to copy to the containers.

The Docker Compose file uses the environment variables set in the `.env` file, so you shouldn't need to change it's content, but to take a look, run the following command:

```
nano docker-compose.yml
```

## Configure Caddy

Caddy needs to know which domains it should serve, and which port to expose to the outside world. Edit the `Caddyfile` file in the `caddy_config` folder.

```
nano caddy_config/Caddyfile
```

Change the placeholder subdomain to yours. If you followed the steps to name the subdomain n8n, your full domain is similar to `n8n.example.com`. The `n8n` in the `reverse_proxy` setting tells Caddy to use the service definition defined in the `docker-compose.yml` file:

```
n8n.<domain>.<suffix> {
    reverse_proxy n8n:5678 {
      flush_interval -1
    }
}
```

## Start Docker Compose

Start n8n and Caddy with the following command:

```
docker compose up -d
```

This may take a few minutes.

## Test your setup

In your browser, open the URL formed of the subdomain and domain name defined earlier. Enter the user name and password defined earlier, and you should be able to access n8n.

## Stop n8n and Caddy

You can stop n8n and Caddy with the following command:

```
sudo docker compose stop
```

## Updating

If you run n8n using a Docker Compose file, follow these steps to update n8n:

```
# Navigate to the directory containing your docker compose file
cd </path/to/your/compose/file/directory>

# Pull latest version
docker compose pull

# Stop and remove older version
docker compose down

# Start the container
docker compose up -d
```

## Next steps

- Learn more about [configuring](../../../configuration/environment-variables/) and [scaling](../../../scaling/overview/) n8n.
- Or explore using n8n: try the [Quickstarts](../../../../try-it-out/).

# Logging in n8n

Logging is an important feature for debugging. n8n uses the [winston](https://www.npmjs.com/package/winston) logging library.

Log streaming

n8n Self-hosted Enterprise tier includes [Log streaming](../../../log-streaming/), in addition to the logging options described in this document.

## Setup

To set up logging in n8n, you need to set the following environment variables (you can also set the values in the [configuration file](../../configuration/environment-variables/))

| Setting in the configuration file | Using environment variables | Description                                                                                                                                                                                               |
| --------------------------------- | --------------------------- | --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| n8n.log.level                     | N8N_LOG_LEVEL               | The log output level. The available options are (from lowest to highest level) are error, warn, info, and debug. The default value is `info`. You can learn more about these options [here](#log-levels). |
| n8n.log.output                    | N8N_LOG_OUTPUT              | Where to output logs. The available options are `console` and `file`. Multiple values can be used separated by a comma (`,`). `console` is used by default.                                               |
| n8n.log.file.location             | N8N_LOG_FILE_LOCATION       | The log file location, used only if log output is set to file. By default, `<n8nFolderPath>/logs/n8n.log` is used.                                                                                        |
| n8n.log.file.fileSizeMax          | N8N_LOG_FILE_SIZE_MAX       | The maximum size (in MB) for each log file. By default, n8n uses 16 MB.                                                                                                                                   |
| n8n.log.file.fileCountMax         | N8N_LOG_FILE_COUNT_MAX      | The maximum number of log files to keep. The default value is 100. This value should be set when using workers.                                                                                           |

```
# Set the logging level to 'debug'
export N8N_LOG_LEVEL=debug

# Set log output to both console and a log file
export N8N_LOG_OUTPUT=console,file

# Set a save location for the log file
export N8N_LOG_FILE_LOCATION=/home/jim/n8n/logs/n8n.log

# Set a 50 MB maximum size for each log file
export N8N_LOG_FILE_SIZE_MAX=50

# Set 60 as the maximum number of log files to be kept
export N8N_LOG_FILE_COUNT_MAX=60
```

### Log levels

n8n uses standard log levels to report:

- `silent`: outputs nothing at all
- `error`: outputs only errors and nothing else
- `warn`: outputs errors and warning messages
- `info`: contains useful information about progress
- `debug`: the most verbose output. n8n outputs a lot of information to help you debug issues.

## Development

During development, adding log messages is a good practice. It assists in debugging errors. To configure logging for development, follow the guide below.

### Implementation details

n8n uses the `LoggerProxy` class, located in the `workflow` package. Calling the `LoggerProxy.init()` by passing in an instance of `Logger`, initializes the class before the usage.

The initialization process happens only once. The [`start.ts`](https://github.com/n8n-io/n8n/blob/master/packages/cli/src/commands/start.ts) file already does this process for you. If you are creating a new command from scratch, you need to initialize the `LoggerProxy` class.

Once the `Logger` implementation gets created in the `cli` package, it can be obtained by calling the `getInstance` convenience method from the exported module.

Check the [start.ts](https://github.com/n8n-io/n8n/blob/master/packages/cli/src/commands/start.ts) file to learn more about how this process works.

### Adding logs

Once the `LoggerProxy` class gets initialized in the project, you can import it to any other file and add logs.

Convenience methods are provided for all logging levels, so new logs can be added whenever needed using the format `Logger.<logLevel>('<message>', ...meta)`, where `meta` represents any additional properties desired beyond `message`.

In the example above, we use the standard log levels described [above](#log-levels). The `message` argument is a string, and `meta` is a data object.

```
// You have to import the LoggerProxy. We rename it to Logger to make it easier

import {
	LoggerProxy as Logger
} from 'n8n-workflow';

// Info-level logging of a trigger function, with workflow name and workflow ID as additional metadata properties

Logger.info(`Polling trigger initiated for workflow "${workflow.name}"`, {workflowName: workflow.name, workflowId: workflow.id});
```

When creating new loggers, some useful standards to keep in mind are:

- Craft log messages to be as human-readable as possible. For example, always wrap names in quotes.
- Duplicating information in the log message and metadata, like workflow name in the above example, can be useful as messages are easier to search and metadata enables easier filtering.
- Include multiple IDs (for example, `executionId`, `workflowId`, and `sessionId`) throughout all logs.
- Use node types instead of node names (or both) as this is more consistent, and so easier to search.

## Front-end logs

As of now, front-end logs aren't available. Using `Logger` or `LoggerProxy` would yield errors in the `editor-ui` package. This functionality will get implemented in the future versions.

# Monitoring

There are three API endpoints you can call to check the status of your instance: `/healthz`, `healthz/readiness`, and `/metrics`.

## healthz and healthz/readiness

The `/healthz` endpoint returns a standard HTTP status code. 200 indicates the instance is reachable. It doesn't indicate DB status. It's available for both self-hosted and Cloud users.

Access the endpoint:

```
<your-instance-url>/healthz
```

The `/healthz/readiness` endpoint is similar to the `/healthz` endpoint, but it returns a HTTP status code of 200 if the DB is connected and migrated and therefore the instance is ready to accept traffic.

Access the endpoint:

```
<your-instance-url>/healthz/readiness
```

## metrics

The `/metrics` endpoint provides more detailed information about the current status of the instance.

Access the endpoint:

```
<your-instance-url>/metrics
```

Feature availability

The `/metrics` endpoint isn't available on n8n Cloud.

## Enable metrics and healthz for self-hosted n8n

The `/metrics` and `/healthz` endpoints are disabled by default. To enable them, configure your n8n instance:

```
# metrics
N8N_METRICS=true
# healthz
QUEUE_HEALTH_CHECK_ACTIVE=true
```

Refer to [Configuration methods](../../configuration/configuration-methods/) for more information on how to configure your instance using environment variables.

# Binary data

Binary data is any file-type data, such as image files or documents generated or processed during the execution of a workflow.

## Enable filesystem mode

When handling binary data, n8n keeps the data in memory by default. This can cause crashes when working with large files.

To avoid this, change the `N8N_DEFAULT_BINARY_DATA_MODE` [environment variable](../../configuration/environment-variables/binary-data/) to `filesystem`. This causes n8n to save data to disk, instead of using memory.

If you're using queue mode, keep this to `default`. n8n doesn't support filesystem mode with queue mode.

## Binary data pruning

n8n executes binary data pruning as part of execution data pruning. Refer to [Execution data | Enable executions pruning](../execution-data/#enable-executions-pruning) for details.

If you configure multiple binary data modes, binary data pruning operates on the active binary data mode. For example, if your instance stored data in S3, and you later switched to filesystem mode, n8n only prunes binary data in the filesystem. Refer to [External storage](../external-storage/#usage) for details.

# Self-hosted concurrency control

Only for self-hosted n8n

This document is for self-hosted concurrency control. Read [Cloud concurrency](../../../manage-cloud/concurrency/) to learn how concurrency works with n8n Cloud accounts.

In regular mode, n8n doesn't limit how many production executions may run at the same time. This can lead to a scenario where too many concurrent executions thrash the event loop, causing performance degradation and unresponsiveness.

To prevent this, you can set a concurrency limit for production executions in regular mode. Use this to control how many production executions run concurrently, and queue up any concurrent production executions over the limit. These executions remain in the queue until concurrency capacity frees up, and are then processed in FIFO order.

Concurrency control is disabled by default. To enable it:

```
export N8N_CONCURRENCY_PRODUCTION_LIMIT=20
```

Keep in mind:

- Concurrency control applies only to production executions: those started from a webhook or [trigger](../../../glossary/#trigger-node-n8n) node. It doesn't apply to any other kinds, such as manual executions, sub-workflow executions, error executions, or started from CLI.

- You can't retry queued executions. Cancelling or deleting a queued execution also removes it from the queue.

- On instance startup, n8n resumes queued executions up to the concurrency limit and re-enqueues the rest.

- To monitor concurrency control, watch logs for executions being added to the queue and released. In a future version, n8n will show concurrency control in the UI.

When you enable concurrency control, you can view the number of active executions and the configured limit at the top of a project's or workflow's executions tab.

## Comparison to queue mode

In queue mode, you can control how many jobs a worker may run concurrently using the [`--concurrency` flag](../queue-mode/#configure-worker-concurrency).

Concurrency control in queue mode is a separate mechanism from concurrency control in regular mode, but the environment variable `N8N_CONCURRENCY_PRODUCTION_LIMIT` controls both of them. In queue mode, n8n takes the limit from this variable if set to a value other than `-1`, falling back to the `--concurrency` flag or its default.

# Execution data

Depending on your executions settings and volume, your n8n database can grow in size and run out of storage.

To avoid this, n8n recommends that you don't save unnecessary data, and enable pruning of old executions data.

To do this, configure the corresponding [environment variables](../../configuration/environment-variables/executions/).

## Reduce saved data

Configuration at workflow level

You can also configure these settings on an individual workflow basis using the [workflow settings](../../../workflows/settings/).

You can select which executions data n8n saves. For example, you can save only executions that result in an `Error`.

```
# npm
# Save executions ending in errors
export EXECUTIONS_DATA_SAVE_ON_ERROR=all

# Don't save successful executions
export EXECUTIONS_DATA_SAVE_ON_SUCCESS=none

# Don't save node progress for each execution
export EXECUTIONS_DATA_SAVE_ON_PROGRESS=false

# Don't save manually launched executions
export EXECUTIONS_DATA_SAVE_MANUAL_EXECUTIONS=false
```

```
# Docker
docker run -it --rm \
 --name n8n \
 -p 5678:5678 \
 -e EXECUTIONS_DATA_SAVE_ON_ERROR=all \
 -e EXECUTIONS_DATA_SAVE_ON_SUCCESS=none \
 -e EXECUTIONS_DATA_SAVE_ON_PROGRESS=true \
 -e EXECUTIONS_DATA_SAVE_MANUAL_EXECUTIONS=false \
 docker.n8n.io/n8nio/n8n
```

```
# Docker Compose
n8n:
    environment:
      - EXECUTIONS_DATA_SAVE_ON_ERROR=all
      - EXECUTIONS_DATA_SAVE_ON_SUCCESS=none
      - EXECUTIONS_DATA_SAVE_ON_PROGRESS=true
      - EXECUTIONS_DATA_SAVE_MANUAL_EXECUTIONS=false
```

## Enable executions pruning

Executions pruning deletes finished executions along with their execution data and binary data on a regular schedule. n8n enables pruning by default. For performance reasons, pruning first marks targets for deletion, and then later permanently removes them.

n8n prunes executions when **either** of the following condition occur:

- **Age**: The execution finished more than `EXECUTIONS_DATA_MAX_AGE` hours ago (default: 336 hours -> 14 days).
- **Count**: The total number of executions exceeds `EXECUTIONS_DATA_PRUNE_MAX_COUNT` (default: 10,000). When this occurs, n8n deletes executions from oldest to newest.

Keep in mind:

- Executions with the `new`, `running`, or `waiting` status aren't eligible for pruning.
- Annotated executions are permanently exempt from pruning.
- Pruning honors a safety buffer period of `EXECUTIONS_DATA_HARD_DELETE_BUFFER` hours (default: 1h), to ensure recent data remains available while the user is building or debugging a workflow.

```
# Enable executions pruning
export EXECUTIONS_DATA_PRUNE=true

# How old (hours) a finished execution must be to qualify for soft-deletion
export EXECUTIONS_DATA_MAX_AGE=168

# Max number of finished executions to keep. May not strictly prune back down to the exact max count. Set to `0` for unlimited.
export EXECUTIONS_DATA_PRUNE_MAX_COUNT=50000
```

```
# Docker
docker run -it --rm \
 --name n8n \
 -p 5678:5678 \
 -e EXECUTIONS_DATA_PRUNE=true \
 -e EXECUTIONS_DATA_MAX_AGE=168 \
 docker.n8n.io/n8nio/n8n
```

```
# Docker Compose
n8n:
    environment:
      - EXECUTIONS_DATA_PRUNE=true
      - EXECUTIONS_DATA_MAX_AGE=168
	  	- EXECUTIONS_DATA_PRUNE_MAX_COUNT=50000
```

SQLite

If you run n8n using the default SQLite database, the disk space of any pruned data isn't automatically freed up but rather reused for future executions data. To free up this space configure the `DB_SQLITE_VACUUM_ON_STARTUP` [environment variable](../../configuration/environment-variables/database/#sqlite) or manually run the [VACUUM](https://www.sqlite.org/lang_vacuum.html) operation.

Binary data pruning

Binary data pruning operates on the active binary data mode. For example, if your instance stored data in S3, and you later switched to filesystem mode, n8n only prunes binary data in the filesystem. This may change in future.

# External storage

Feature availability

- Available on Self-hosted Enterprise plans
- If you want access to this feature on Cloud Enterprise, [contact n8n](https://n8n-community.typeform.com/to/y9X2YuGa).

n8n can store binary data produced by workflow executions externally. This feature is useful to avoid relying on the filesystem for storing large amounts of binary data.

n8n will introduce external storage for other data types in the future.

## Storing n8n's binary data in S3

n8n supports [AWS S3](https://docs.aws.amazon.com/AmazonS3/latest/userguide/Welcome.html) as an external store for binary data produced by workflow executions. You can use other S3-compatible services like Cloudflare R2 and Backblaze B2, but n8n doesn't officially support these.

Enterprise-tier feature

You will need an [Enterprise license key](../../../license-key/) for external storage. If your license key expires and you remain on S3 mode, the instance will be able to read from, but not write to, the S3 bucket.

### Setup

Create and configure a bucket following the [AWS documentation](https://docs.aws.amazon.com/AmazonS3/latest/userguide/creating-bucket.html). You can use the following policy, replacing `<bucket-name>` with the name of the bucket you created:

```
{
 "Version": "2012-10-17",
 "Statement": [
  {
   "Sid": "VisualEditor0",
   "Effect": "Allow",
   "Action": ["s3:*"],
   "Resource": ["arn:aws:s3:::<bucket-name>", "arn:aws:s3:::<bucket-name>/*"]
  }
 ]
}
```

Set a bucket-level lifecycle configuration so that S3 automatically deletes old binary data. n8n delegates pruning of binary data to S3, so setting a lifecycle configuration is required unless you want to preserve binary data indefinitely.

Once you finish creating the bucket, you will have a host, bucket name and region, and an access key ID and secret access key. You need to set them in n8n's environment:

```
export N8N_EXTERNAL_STORAGE_S3_HOST=... # example: s3.us-east-1.amazonaws.com
export N8N_EXTERNAL_STORAGE_S3_BUCKET_NAME=...
export N8N_EXTERNAL_STORAGE_S3_BUCKET_REGION=...
export N8N_EXTERNAL_STORAGE_S3_ACCESS_KEY=...
export N8N_EXTERNAL_STORAGE_S3_ACCESS_SECRET=...
```

No region

If your provider doesn't require a region, you can set `N8N_EXTERNAL_STORAGE_S3_BUCKET_REGION` to `'auto'`.

Tell n8n to store binary data in S3:

```
export N8N_AVAILABLE_BINARY_DATA_MODES=filesystem,s3
export N8N_DEFAULT_BINARY_DATA_MODE=s3
```

Auth autodetection

To automatically detect credentials to authenticate your S3 calls, set `N8N_EXTERNAL_STORAGE_S3_AUTH_AUTO_DETECT` to `true`. This will use the default [credential provider chain](https://docs.aws.amazon.com/sdk-for-javascript/v3/developer-guide/setting-credentials-node.html#credchain).

Restart the server to load the new configuration.

### Usage

After you enable S3, n8n writes and reads any new binary data to and from the S3 bucket. n8n writes binary data to your S3 bucket in this format:

```
workflows/{workflowId}/executions/{executionId}/binary_data/{binaryFileId}
```

n8n continues to read older binary data stored in the filesystem from the filesystem, if `filesystem` remains listed as an option in `N8N_AVAILABLE_BINARY_DATA_MODES`.

If you store binary data in S3 and later switch to filesystem mode, the instance continues to read any data stored in S3, as long as `s3` remains listed in `N8N_AVAILABLE_BINARY_DATA_MODES` and your S3 credentials remain valid.

Binary data pruning

Binary data pruning operates on the active binary data mode. For example, if your instance stored data in S3, and you later switched to filesystem mode, n8n only prunes binary data in the filesystem. This may change in future.

# Memory-related errors

n8n doesn't restrict the amount of data each node can fetch and process. While this gives you freedom, it can lead to errors when workflow executions require more memory than available. This page explains how to identify and avoid these errors.

Only for self-hosted n8n

This page describes memory-related errors when [self-hosting n8n](../../). Visit [Cloud data management](../../../manage-cloud/cloud-data-management/) to learn about memory limits for [n8n Cloud](../../../manage-cloud/overview/).

## Identifying out of memory situations

n8n provides error messages that warn you in some out of memory situations. For example, messages such as **Execution stopped at this node (n8n may have run out of memory while executing it)**.

Error messages including **Problem running workflow**, **Connection Lost**, or **503 Service Temporarily Unavailable** suggest that an n8n instance has become unavailable.

When self-hosting n8n, you may also see error messages such as **Allocation failed - JavaScript heap out of memory** in your server logs.

On n8n Cloud, or when using n8n's Docker image, n8n restarts automatically when encountering such an issue. However, when running n8n with npm you might need to restart it manually.

## Typical causes

Such problems occur when a workflow execution requires more memory than available to an n8n instance. Factors increasing the memory usage for a workflow execution include:

- Amount of [JSON data](../../../data/data-structure/).
- Size of binary data.
- Number of nodes in a workflow.
- Some nodes are memory-heavy: the [Code](../../../integrations/builtin/core-nodes/n8n-nodes-base.code/) node and the older Function node can increase memory consumption significantly.
- Manual or automatic workflow executions: manual executions increase memory consumption as n8n makes a copy of the data for the frontend.
- Additional workflows running at the same time.

## Avoiding out of memory situations

When encountering an out of memory situation, there are two options: either increase the amount of memory available to n8n or reduce the memory consumption.

### Increase available memory

When self-hosting n8n, increasing the amount of memory available to n8n means provisioning your n8n instance with more memory. This may incur additional costs with your hosting provider.

On n8n cloud you need to upgrade to a larger plan.

### Reduce memory consumption

This approach is more complex and means re-building the workflows causing the issue. This section provides some guidelines on how to reduce memory consumption. Not all suggestions are applicable to all workflows.

- Split the data processed into smaller chunks. For example, instead of fetching 10,000 rows with each execution, process 200 rows with each execution.
- Avoid using the Code node where possible.
- Avoid manual executions when processing larger amounts of data.
- Split the workflow up into sub-workflows and ensure each sub-workflow returns a limited amount of data to its parent workflow.

Splitting the workflow might seem counter-intuitive at first as it usually requires adding at least two more nodes: the [Loop Over Items](../../../integrations/builtin/core-nodes/n8n-nodes-base.splitinbatches/) node to split up the items into smaller batches and the [Execute Workflow](../../../integrations/builtin/core-nodes/n8n-nodes-base.executeworkflow/) node to start the sub-workflow.

However, as long as your sub-workflow does the heavy lifting for each batch and then returns only a small result set to the main workflow, this reduces memory consumption. This is because the sub-workflow only holds the data for the current batch in memory, after which the memory is free again.

### Increase old memory

This applies to self-hosting n8n. When encountering **JavaScript heap out of memory** errors, it's often useful to allocate additional memory to the old memory section of the V8 JavaScript engine. To do this, set the appropriate [V8 option](https://nodejs.org/api/cli.html#--max-old-space-sizesize-in-megabytes) `--max-old-space-size=SIZE` either through the CLI or through the `NODE_OPTIONS` [environment variable](https://nodejs.org/api/cli.html#node_optionsoptions).

# Scaling n8n

When running n8n at scale, with a large number of users, workflows, or executions, you need to change your n8n configuration to ensure good performance.

n8n can run in different [modes](../queue-mode/) depending on your needs. The `queue` mode provides the best scalability. Refer to [Queue mode](../queue-mode/) for configuration details.

You can configure data saving and pruning to improve database performance. Refer to [Execution data](../execution-data/) for details.

# Performance and benchmarking

n8n can handle up to 220 workflow executions per second on a single instance, with the ability to scale up further by adding more instances.

This document outlines n8n's performance benchmarking. It describes the factors that affect performance, and includes two example benchmarks.

## Performance factors

The performance of n8n depends on factors including:

- The workflow type
- The resources available to n8n
- How you configure n8n's scaling options

## Run your own benchmarking

To get an accurate estimate for your use case, run n8n's [benchmarking framework](https://github.com/n8n-io/n8n/tree/master/packages/%40n8n/benchmark). The repository contains more information about the benchmarking.

## Example: Single instance performance

This test measures how response time increases as requests per second increase. It looks at the response time when calling the Webhook Trigger node.

Setup:

- Hardware: ECS c5a.large instance (4GB RAM)
- n8n setup: Single n8n instance (running in main mode, with Postgres database)
- Workflow: Webhook Trigger node, Edit Fields node

This graph shows the percentage of requests to the Webhook Trigger node getting a response within 100 seconds, and how that varies with load. Under higher loads n8n usually still processes the data, but takes over 100s to respond.

## Example: Multi-instance performance

This test measures how response time increases as requests per second increase. It looks at the response time when calling the Webhook Trigger node.

Setup:

- Hardware: seven ECS c5a.4xlarge instances (8GB RAM each)
- n8n setup: two webhook instances, four worker instances, one database instance (MySQL), one main instance running n8n and Redis
- Workflow: Webhook Trigger node, Edit Fields node
- Multi-instance setups use [Queue mode](../queue-mode/)

This graph shows the percentage of requests to the Webhook Trigger node getting a response within 100 seconds, and how that varies with load. Under higher loads n8n usually still processes the data, but takes over 100s to respond.

# Queue mode

You can run n8n in different modes depending on your needs. The queue mode provides the best scalability.

Binary data storage

n8n doesn't support queue mode with binary data storage in filesystem. If your workflows need to persist binary data in queue mode, you can use [S3 external storage](../external-storage/).

## How it works

When running in queue mode, you have multiple n8n instances set up, with one main instance receiving workflow information (such as triggers) and the worker instances performing the executions.

Each worker is its own Node.js instance, running in `main` mode, but able to handle multiple simultaneous workflow executions due to their high IOPS (input-output operations per second).

By using worker instances and running in queue mode, you can scale n8n up (by adding workers) and down (by removing workers) as needed to handle the workload.

This is the process flow:

1. The main n8n instance handles timers and webhook calls, generating (but not running) a workflow execution.
1. It passes the execution ID to a message broker, [Redis](#start-redis), which maintains the queue of pending executions and allows the next available worker to pick them up.
1. A worker in the pool picks up message from Redis.
1. The worker uses the execution ID to get workflow information from the database.
1. After completing the workflow execution, the worker:
   - Writes the results to the database.
   - Posts to Redis, saying that the execution has finished.
1. Redis notifies the main instance.

## Configuring workers

Workers are n8n instances that do the actual work. They receive information from the main n8n process about the workflows that have to get executed, execute the workflows, and update the status after each execution is complete.

### Set encryption key

n8n automatically generates an encryption key upon first startup. You can also provide your own custom key using [environment variable](../../configuration/environment-variables/) if desired.

The encryption key of the main n8n instance must be shared with all worker and webhooks processor nodes to ensure these worker nodes are able to access credentials stored in the database.

Set the encryption key for each worker node in a [configuration file](../../configuration/configuration-methods/) or by setting the corresponding environment variable:

```
export N8N_ENCRYPTION_KEY=<main_instance_encryption_key>
```

### Set executions mode

Database considerations

n8n recommends using Postgres 13+. Running n8n with execution mode set to `queue` with an SQLite database isn't recommended.

Set the environment variable `EXECUTIONS_MODE` to `queue` on the main instance and any workers using the following command.

```
export EXECUTIONS_MODE=queue
```

Alternatively, you can set `executions.mode` to `queue` in the [configuration file](../../configuration/environment-variables/).

### Start Redis

Running Redis on a separate machine

You can run Redis on a separate machine, just make sure that it's accessible by the n8n instance.

To run Redis in a Docker container, follow the instructions below:

Run the following command to start a Redis instance:

```
docker run --name some-redis -p 6379:6379  -d redis
```

By default, Redis runs on `localhost` on port `6379` with no password. Based on your Redis configuration, set the following configurations for the main n8n process. These will allow n8n to interact with Redis.

| Using configuration file          | Using environment variables       | Description                                                                               |
| --------------------------------- | --------------------------------- | ----------------------------------------------------------------------------------------- |
| `queue.bull.redis.host:localhost` | `QUEUE_BULL_REDIS_HOST=localhost` | By default, Redis runs on `localhost`.                                                    |
| `queue.bull.redis.port:6379`      | `QUEUE_BULL_REDIS_PORT=6379`      | The default port is `6379`. If Redis is running on a different port, configure the value. |

You can also set the following optional configurations:

| Using configuration file                    | Using environment variables          | Description                                                                                                                         |
| ------------------------------------------- | ------------------------------------ | ----------------------------------------------------------------------------------------------------------------------------------- |
| `queue.bull.redis.username:USERNAME`        | `QUEUE_BULL_REDIS_USERNAME`          | By default, Redis doesn't require a username. If you're using a specific user, configure it variable.                               |
| `queue.bull.redis.password:PASSWORD`        | `QUEUE_BULL_REDIS_PASSWORD`          | By default, Redis doesn't require a password. If you're using a password, configure it variable.                                    |
| `queue.bull.redis.db:0`                     | `QUEUE_BULL_REDIS_DB`                | The default value is `0`. If you change this value, update the configuration.                                                       |
| `queue.bull.redis.timeoutThreshold:10000ms` | `QUEUE_BULL_REDIS_TIMEOUT_THRESHOLD` | Tells n8n how long it should wait if Redis is unavailable before exiting. The default value is `10000` (ms).                        |
| `queue.bull.gracefulShutdownTimeout:30`     | `N8N_GRACEFUL_SHUTDOWN_TIMEOUT`      | A graceful shutdown timeout for workers to finish executing jobs before terminating the process. The default value is `30` seconds. |

Now you can start your n8n instance and it will connect to your Redis instance.

### Start workers

You will need to start worker processes to allow n8n to execute workflows. If you want to host workers on a separate machine, install n8n on the machine and make sure that it's connected to your Redis instance and the n8n database.

Start worker processes by running the following command from the root directory:

```
./packages/cli/bin/n8n worker
```

If you're using Docker, use the following command:

```
docker run --name n8n-queue -p 5679:5678 docker.n8n.io/n8nio/n8n worker
```

You can set up multiple worker processes. Make sure that all the worker processes have access to Redis and the n8n database.

#### Worker server

Each worker process runs a server that exposes optional endpoints:

- `/healthz`: returns whether the worker is up, if you enable the `QUEUE_HEALTH_CHECK_ACTIVE` environment variable
- `/healthz/readiness`: returns whether worker's DB and Redis connections are ready, if you enable the `QUEUE_HEALTH_CHECK_ACTIVE` environment variable
- [credentials overwrite endpoint](../../../embed/configuration/#credential-overwrites)
- [`/metrics`](../../configuration/configuration-examples/prometheus/)

#### View running workers

Feature availability

- Available on Self-hosted Enterprise plans.
- If you want access to this feature on Cloud Enterprise, [contact n8n](https://n8n-community.typeform.com/to/y9X2YuGa).

You can view running workers and their performance metrics in n8n by selecting **Settings** > **Workers**.

## Running n8n with queues

When running n8n with queues, all the production workflow executions get processed by worker processes. This means that even the webhook calls get delegated to the worker processes, which might add some overhead and extra latency.

Redis acts as the message broker, and the database persists data, so access to both is required. Running a distributed system with this setup over SQLite isn't supported.

Migrate data

If you want to migrate data from one database to another, you can use the Export and Import commands. Refer to the [CLI commands for n8n](../../cli-commands/#export-workflows-and-credentials) documentation to learn how to use these commands.

## Webhook processors

Keep in mind

Webhook processes rely on Redis and need the `EXECUTIONS_MODE` environment variable set too. Follow the [configure the workers](#configuring-workers) section above to setup webhook processor nodes.

Webhook processors are another layer of scaling in n8n. Configuring the webhook processor is optional, and allows you to scale the incoming webhook requests.

This method allows n8n to process a huge number of parallel requests. All you have to do is add more webhook processes and workers accordingly. The webhook process will listen to requests on the same port (default: `5678`). Run these processes in containers or separate machines, and have a load balancing system to route requests accordingly.

n8n doesn't recommend adding the main process to the load balancer pool. If you add the main process to the pool, it will receive requests and possibly a heavy load. This will result in degraded performance for editing, viewing, and interacting with the n8n UI.

You can start the webhook processor by executing the following command from the root directory:

```
./packages/cli/bin/n8n webhook
```

If you're using Docker, use the following command:

```
docker run --name n8n-queue -p 5679:5678 -e "EXECUTIONS_MODE=queue" docker.n8n.io/n8nio/n8n webhook
```

### Configure webhook URL

To configure your webhook URL, execute the following command on the machine running the main n8n instance:

```
export WEBHOOK_URL=https://your-webhook-url.com
```

You can also set this value in the configuration file.

### Configure load balancer

When using multiple webhook processes you will need a load balancer to route requests. If you are using the same domain name for your n8n instance and the webhooks, you can set up your load balancer to route requests as follows:

- Redirect any request that matches `/webhook/*` to the webhook servers pool
- All other paths (the n8n internal API, the static files for the editor, etc.) should get routed to the main process

**Note:** The default URL for manual workflow executions is `/webhook-test/*`. Make sure that these URLs route to your main process.

You can change this path in the configuration file `endpoints.webhook` or using the `N8N_ENDPOINT_WEBHOOK` environment variable. If you change these, update your load balancer accordingly.

### Disable webhook processing in the main process (optional)

You have webhook processors to execute the workflows. You can disable the webhook processing in the main process. This will make sure to execute all webhook executions in the webhook processors. In the configuration file set `endpoints.disableProductionWebhooksOnMainProcess` to `true` so that n8n doesn't process webhook requests on the main process.

Alternatively, you can use the following command:

```
export N8N_DISABLE_PRODUCTION_MAIN_PROCESS=true
```

When disabling the webhook process in the main process, run the main process and don't add it to the load balancer's webhook pool.

## Configure worker concurrency

You can define the number of jobs a worker can run in parallel by using the `concurrency` flag. It defaults to `10`. To change it:

```
n8n worker --concurrency=5
```

## Concurrency and scaling recommendations

n8n recommends setting concurrency to 5 or higher for your worker instances. Setting low concurrency values with a large numbers of workers can exhaust your database's connection pool, leading to processing delays and failures.

## Multi-main setup

Feature availability

- Available on Self-hosted Enterprise plans.

In queue mode you can run more than one `main` process for high availability.

In a single-mode setup, the `main` process does two sets of tasks:

- **regular tasks**, such as running the API, serving the UI, and listening for webhooks, and
- **at-most-once tasks**, such as running non-HTTP triggers (timers, pollers, and persistent connections like RabbitMQ and IMAP), and pruning executions and binary data.

In a multi-main setup, there are two kinds of `main` processes:

- **followers**, which run **regular tasks**, and
- the **leader**, which runs **both regular and at-most-once tasks**.

### Leader designation

In a multi-main setup, all main instances handle the leadership process transparently to users. In case the current leader becomes unavailable, for example because it crashed or its event loop became too busy, other followers can take over. If the previous leader becomes responsive again, it becomes a follower.

### Configuring multi-main setup

To deploy n8n in multi-main setup, ensure:

- All `main` processes are running in queue mode and are connected to Postgres and Redis.
- All `main` and `worker` processes are running the same version of n8n.
- All `main` processes have set the environment variable `N8N_MULTI_MAIN_SETUP_ENABLED` to `true`.
- All `main` processes are running behind a load balancer with session persistence (sticky sessions) enabled.

If needed, you can adjust the leader key options:

| Using configuration file    | Using environment variables             | Description                                                   |
| --------------------------- | --------------------------------------- | ------------------------------------------------------------- |
| `multiMainSetup.ttl:10`     | `N8N_MULTI_MAIN_SETUP_KEY_TTL=10`       | Time to live (in seconds) for leader key in multi-main setup. |
| `multiMainSetup.interval:3` | `N8N_MULTI_MAIN_SETUP_CHECK_INTERVAL=3` | Interval (in seconds) for leader check in multi-main setup.   |

# Block access to nodes

For security reasons, you may want to block your users from accessing or working with specific n8n nodes. This is helpful if your users might be untrustworthy.

Use the `NODES_EXCLUDE` environment variable to prevent your users from accessing specific nodes.

## Exclude nodes

Update your `NODES_EXCLUDE` environment variable to include an array of strings containing any nodes you want to block your users from using.

For example, setting the variable this way:

```
NODES_EXCLUDE: "[\"n8n-nodes-base.executeCommand\", \"n8n-nodes-base.readWriteFile\"]"
```

Blocks the [Execute Command](../../../integrations/builtin/core-nodes/n8n-nodes-base.executecommand/) and [Read/Write Files from Disk](../../../integrations/builtin/core-nodes/n8n-nodes-base.readwritefile/) nodes.

Your n8n users won't be able to search for or use these nodes.

## Suggested nodes to block

The nodes that can pose security risks vary based on your use case and user profile. Here are some nodes you might want to start with:

- [Execute Command](../../../integrations/builtin/core-nodes/n8n-nodes-base.executecommand/)
- [Read/Write Files from Disk](../../../integrations/builtin/core-nodes/n8n-nodes-base.readwritefile/)

## Related resources

Refer to [Nodes environment variables](../../configuration/environment-variables/nodes/) for more information on this environment variable.

Refer to [Configuration](../../configuration/configuration-methods/) for more information on setting environment variables.

# Disable the public REST API

The [n8n public REST API](../../../api/) allows you to programmatically perform many of the same tasks as you can in the n8n GUI.

If you don't plan on using this API, n8n recommends disabling it to improve the security of your n8n installation.

To disable the [public REST API](../../../api/), set the `N8N_PUBLIC_API_DISABLED` environment variable to `true`, for example:

```
export N8N_PUBLIC_API_DISABLED=true
```

## Disable the API playground

To disable the [API playground](../../../api/using-api-playground/), set the `N8N_PUBLIC_API_SWAGGERUI_DISABLED` environment variable to `true`, for example:

```
export N8N_PUBLIC_API_SWAGGERUI_DISABLED=true
```

## Related resources

Refer to [Deployment environment variables](../../configuration/environment-variables/deployment/) for more information on these environment variables.

Refer to [Configuration](../../configuration/configuration-methods/) for more information on setting environment variables.

# Hardening task runners

[Task runners](../../configuration/task-runners/) are responsible for executing code from the [Code node](../../../integrations/builtin/core-nodes/n8n-nodes-base.code/). While Code node executions are secure, you can follow these recommendations to further harden your task runners.

## Run task runners as sidecars in external mode

To increase the isolation between the core n8n process and code in the Code node, run task runners in [external mode](../../configuration/task-runners/#setting-up-external-mode). External task runners launch as separate containers, providing a fully isolated environment to execute the JavaScript defined in the Code node.

# Securing n8n

Securing your n8n instance can take several forms.

At a high level, you can:

- Conduct a [security audit](../security-audit/) to identify security risks.
- [Set up SSL](../set-up-ssl/) to enforce secure connections.
- [Set up Single Sign-On](../set-up-sso/) for user account management.
- Use [two-factor authentication (2FA)](../../../user-management/two-factor-auth/) for your users.

More granularly, consider blocking or opting out of features or data collection you don't want:

- [Disable the public API](../disable-public-api/) if you aren't using it.
- [Opt out of data collection](../telemetry-opt-out/) of the anonymous data n8n collects automatically.
- [Block certain nodes](../blocking-nodes/) from being available to your users.

# Security audit

You can run a security audit on your n8n instance, to detect common security issues.

## Run an audit

You can run an audit using the CLI, the public API, or the n8n node.

### CLI

Run `n8n audit`.

### API

Make a `POST` call to the `/audit` endpoint. You must authenticate as the instance owner.

### n8n node

Add the [n8n node](../../../integrations/builtin/core-nodes/n8n-nodes-base.n8n/) to your workflow. Select **Resource** > **Audit** and **Operation** > **Generate**.

## Report contents

The audit generates five risk reports:

### Credentials

This report shows:

- Credentials not used in a workflow.
- Credentials not used in an active workflow.
- Credentials not use in a recently active workflow.

### Datab