# N8N - Llms-Txt

**Pages:** 1301

---

## HTTP Request node common issues

**URL:** llms-txt#http-request-node-common-issues

**Contents:**
- Bad request - please check your parameters
- The resource you are requesting could not be found
- JSON parameter need to be an valid JSON
- Forbidden - perhaps check your credentials
- 429 - The service is receiving too many requests from you
  - Batching
  - Retry on Fail

Here are some common errors and issues with the [HTTP Request node](../) and steps to resolve or troubleshoot them.

## Bad request - please check your parameters

This error displays when the node receives a 400 error indicating a bad request. This error most often occurs because:

- You're using an invalid name or value in a **Query Parameter**.
- You're passing array values in a **Query Parameter** but the array isn't formatted correctly. Try using the [**Array Format in Query Parameters**](../#array-format-in-query-parameters) option.

Review the API documentation for your service to format your query parameters.

## The resource you are requesting could not be found

This error displays when the endpoint **URL** you entered is invalid.

This may be due to a typo in the URL or a deprecated API. Refer to your service's API documentation to verify you have a valid endpoint.

## JSON parameter need to be an valid JSON

This error displays when you've passed a parameter as JSON and it's not formatted as valid JSON.

To resolve, review the JSON you've entered for these issues:

- Test your JSON in a JSON checker or syntax parser to find errors like missing quotation marks, extra or missing commas, incorrectly formatted arrays, extra or missing square brackets or curly brackets, and so on.

- If you've used an **Expression** in the node, be sure you've wrapped the entire JSON in double curly brackets, for example:

## Forbidden - perhaps check your credentials

This error displays when the node receives a 403 error indicating authentication failed.

To resolve, review the selected credentials and make sure you can authenticate with them. You may need to:

- Update permissions or scopes so that your API key or account can perform the operation you've selected.
- Format your generic credential in a different way.
- Generate a new API key or token with the appropriate permissions or scopes.

## 429 - The service is receiving too many requests from you

This error displays when the node receives a [429 error](https://developer.mozilla.org/en-US/docs/Web/HTTP/Status/429) from the service that you're calling. This often means that you have hit the rate limits of that service. You can find out more on the [Handling API rate limits](../../../rate-limits/) page.

To resolve the error, you can use one of the built-in options of the HTTP request node:

Use this option to send requests in batches and introduce a delay between them.

1. In the HTTP Request node, select **Add Option > Batching**.
1. Set **Items per Batch** to the number of input items to include in each request.
1. Set **Batch Interval (ms)** to introduce a delay between requests in milliseconds. For example, to send one request to an API per second, set **Batch Interval (ms)** to `1000`.

Use this option to retry the node after a failed attempt.

1. In the HTTP Request node, go to **Settings** and enable **Retry on Fail**.
1. Set **Max Tries** to the maximum number of times n8n should retry the node.
1. Set **Wait Between Tries (ms)** to the desired delay in milliseconds between retries. For example, to wait one second before retrying the request again, set **Wait Between Tries (ms)** to `1000`.

**Examples:**

Example 1 (unknown):
```unknown
{{
      {
      "myjson":
      {
          "name1": "value1",
          "name2": "value2",
          "array1":
              ["value1","value2"]
      }
      }
  }}
```

---

## JWT credentials

**URL:** llms-txt#jwt-credentials

**Contents:**
- Supported authentication methods
- Related resources
- Using Passphrase
- Using private key (PEM key)
- Available algorithms

You can use these credentials to authenticate the following nodes:

- [JWT](../../core-nodes/n8n-nodes-base.jwt/)
- [Webhook](../../core-nodes/n8n-nodes-base.webhook/)

## Supported authentication methods

- Passphrase: Signed with a secret with HMAC algorithm
- Private key (PEM key): For use with [Private Key JWT](https://auth0.com/docs/get-started/authentication-and-authorization-flow/authenticate-with-private-key-jwt) with RSA or ECDSA algorithm

Refer to the [JSON Web Token spec](https://datatracker.ietf.org/doc/html/rfc7519) for more details.

For a more verbose introduction, refer to the [JWT website Introduction to JSON Web Tokens](https://jwt.io/introduction). Refer to [JSON Web Token (JWT) Signing Algorithms Overview](https://auth0.com/blog/json-web-token-signing-algorithms-overview/) for more information on selecting between the two types and the algorithms involved.

To configure this credential:

1. Select the **Key Type** of **Passphrase**.
1. Enter the Passphrase **Secret**
1. Select the **Algorithm** used to sign the assertion. Refer to [Available algorithms](#available-algorithms) below for a list of supported algorithms.

## Using private key (PEM key)

To configure this credential:

1. Select the **Key Type** of **PEM Key**.
1. A **Private Key**: Obtained from generating a Key Pair. Refer to [Generate RSA Key Pair](https://auth0.com/docs/secure/application-credentials/generate-rsa-key-pair) for an example.
1. A **Public Key**: Obtained from generating a Key Pair. Refer to [Generate RSA Key Pair](https://auth0.com/docs/secure/application-credentials/generate-rsa-key-pair) for an example.
1. Select the **Algorithm** used to sign the assertion. Refer to [Available algorithms](#available-algorithms) below for a list of supported algorithms.

## Available algorithms

This n8n credential supports the following algorithms:

- `HS256`
- `HS384`
- `HS512`
- `RS256`
- `RS384`
- `RS512`
- `ES256`
- `ES384`
- `ES512`
- `PS256`
- `PS384`
- `PS512`
- `none`

---

## White labelling

**URL:** llms-txt#white-labelling

**Contents:**
- Prerequisites
- Theme colors
- Theme logos
- Text localization
  - Window title

Embed requires an embed license. For more information about when to use Embed, as well as costs and licensing processes, refer to [Embed](https://n8n.io/embed/) on the n8n website.

White labelling n8n means customizing the frontend styling and assets to match your brand identity. The process involves changing two packages in n8n's source code [github.com/n8n-io/n8n](https://github.com/n8n-io/n8n):

- [packages/frontend/@n8n/design-system](https://github.com/n8n-io/n8n/tree/master/packages/frontend/@n8n/design-system): n8n's [storybook](https://storybook.js.org/) design system with CSS styles and Vue.js components
- [packages/frontend/editor-ui](https://github.com/n8n-io/n8n/tree/master/packages/frontend/editor-ui): n8n's [Vue.js](https://vuejs.org/) frontend build with [Vite.js](https://vitejs.dev)

You need the following installed on your development machine:

- [git](https://git-scm.com/downloads)
- Node.js and npm. Minimum version Node 18.17.0. You can find instructions on how to install both using nvm (Node Version Manager) for Linux, Mac, and WSL [here](https://github.com/nvm-sh/nvm). For Windows users, refer to Microsoft's guide to [Install NodeJS on Windows](https://docs.microsoft.com/en-us/windows/dev-environment/javascript/nodejs-on-windows).

Create a fork of [n8n's repository](https://github.com/n8n-io/n8n) and clone your new repository.

Install all dependencies, build and start n8n.

Whenever you make changes you need to rebuild and restart n8n. While developing you can use `npm run dev` to automatically rebuild and restart n8n anytime you make code changes.

To customize theme colors open [packages/frontend/@n8n/design-system](https://github.com/n8n-io/n8n/tree/master/packages/frontend/@n8n/design-system) and start with:

- [packages/frontend/@n8n/design-system/src/css/\_tokens.scss](https://github.com/n8n-io/n8n/blob/master/packages/frontend/@n8n/design-system/src/css/_tokens.scss)
- [packages/frontend/@n8n/design-system/src/css/\_tokens.dark.scss](https://github.com/n8n-io/n8n/blob/master/packages/frontend/@n8n/design-system/src/css/_tokens.dark.scss)

At the top of `_tokens.scss` you will find `--color-primary` variables as HSL colors:

In the following example the primary color changes to #0099ff. To convert to HSL you can use a [color converter tool](https://www.w3schools.com/colors/colors_converter.asp).

To change the editor’s logo assets look into [packages/frontend/editor-ui/public](https://github.com/n8n-io/n8n/tree/master/packages/frontend/editor-ui/public) and replace:

- favicon-16x16.png
- favicon-32x32.png
- favicon.ico
- n8n-logo.svg
- n8n-logo-collapsed.svg
- n8n-logo-expanded.svg

Replace these logo assets. n8n uses them in Vue.js components, including:

- [MainSidebar.vue](https://github.com/n8n-io/n8n/blob/master/packages/frontend/editor-ui/src/components/MainSidebar.vue): top/left logo in the main sidebar.
- [Logo.vue](https://github.com/n8n-io/n8n/blob/master/packages/frontend/editor-ui/src/components/Logo/Logo.vue): reused in other components.

In the following example replace `n8n-logo-collapsed.svg` and `n8n-logo-expanded.svg` to update the main sidebar's logo assets.

If your logo assets require different sizing or placement you can customize SCSS styles at the bottom of [MainSidebar.vue](https://github.com/n8n-io/n8n/blob/master/packages/frontend/editor-ui/src/components/MainSidebar.vue).

To change all text occurrences like `n8n` or `n8n.io` to your brand identity you can customize n8n's English internationalization file: [packages/frontend/@n8n/i18n/src/locales/en.json](https://github.com/n8n-io/n8n/blob/master/packages/frontend/@n8n/i18n/src/locales/en.json).

n8n uses the [Vue I18n](https://kazupon.github.io/vue-i18n/) internationalization plugin for Vue.js to translate the majority of UI texts. To search and replace text occurrences inside `en.json` you can use [Linked locale messages](https://kazupon.github.io/vue-i18n/guide/messages.html#linked-locale-messages).

In the following example add the `_brand.name` translation key to white label n8n's [AboutModal.vue](https://github.com/n8n-io/n8n/blob/master/packages/frontend/editor-ui/src/components/AboutModal.vue).

To change n8n's window title to your brand name, edit the following:

- [packages/frontend/editor-ui/index.html](https://github.com/n8n-io/n8n/blob/master/packages/frontend/editor-ui/index.html)
- [packages/frontend/editor-ui/src/composables/useDocumentTitle.ts](https://github.com/n8n-io/n8n/blob/master/packages/frontend/editor-ui/src/composables/useDocumentTitle.ts)

The following example replaces all occurrences of `n8n` and `n8n.io` with `My Brand` in `index.html` and `useDocumentTitle.ts`.

**Examples:**

Example 1 (unknown):
```unknown
git clone https://github.com/<your-organization>/n8n.git n8n
cd n8n
```

Example 2 (unknown):
```unknown
npm install
npm run build
npm run start
```

Example 3 (unknown):
```unknown
@mixin theme {
	--color-primary-h: 6.9;
	--color-primary-s: 100%;
	--color-primary-l: 67.6%;
```

Example 4 (unknown):
```unknown
@mixin theme {
	--color-primary-h: 204;
	--color-primary-s: 100%;
	--color-primary-l: 50%;
```

---

## Vercel AI Gateway Chat Model node

**URL:** llms-txt#vercel-ai-gateway-chat-model-node

**Contents:**
- Node parameters
  - Model
- Node options
  - Frequency Penalty
  - Maximum Number of Tokens
  - Response Format
  - Presence Penalty
  - Sampling Temperature
  - Timeout
  - Max Retries

Use the Vercel AI Gateway Chat Model node to use AI Gateway chat models with conversational agents.

On this page, you'll find the node parameters for the Vercel AI Gateway Chat Model node and links to more resources.

You can find authentication information for this node [here](../../../credentials/vercel/).

Parameter resolution in sub-nodes

Sub-nodes behave differently to other nodes when processing multiple items using an expression.

Most nodes, including root nodes, take any number of items as input, process these items, and output the results. You can use expressions to refer to input items, and the node resolves the expression for each item in turn. For example, given an input of five `name` values, the expression `{{ $json.name }}` resolves to each name in turn.

In sub-nodes, the expression always resolves to the first item. For example, given an input of five `name` values, the expression `{{ $json.name }}` always resolves to the first name.

Select the model to use to generate the completion.

n8n dynamically loads models from the AI Gateway and you'll only see the models available to your account.

Use these options to further refine the node's behavior.

### Frequency Penalty

Use this option to control the chance of the model repeating itself. Higher values reduce the chance of the model repeating itself.

### Maximum Number of Tokens

Enter the maximum number of tokens used, which sets the completion length.

Choose **Text** or **JSON**. **JSON** ensures the model returns valid JSON.

Use this option to control the chance of the model talking about new topics. Higher values increase the chance of the model talking about new topics.

### Sampling Temperature

Use this option to control the randomness of the sampling process. A higher temperature creates more diverse sampling, but increases the risk of hallucinations.

Enter the maximum request time in milliseconds.

Enter the maximum number of times to retry a request.

Use this option to set the probability the completion should use. Use a lower value to ignore less probable options.

## Templates and examples

[Browse Vercel AI Gateway Chat Model integration templates](https://n8n.io/integrations/vercel-ai-gateway-chat-model/), or [search all templates](https://n8n.io/workflows/)

As the Vercel AI Gateway is API-compatible with OpenAI, you can refer to [LangChains's OpenAI documentation](https://js.langchain.com/docs/integrations/chat/openai/) for more information about the service.

View n8n's [Advanced AI](../../../../../advanced-ai/) documentation.

---

## Scaling n8n

**URL:** llms-txt#scaling-n8n

When running n8n at scale, with a large number of users, workflows, or executions, you need to change your n8n configuration to ensure good performance.

n8n can run in different [modes](../queue-mode/) depending on your needs. The `queue` mode provides the best scalability. Refer to [Queue mode](../queue-mode/) for configuration details.

You can configure data saving and pruning to improve database performance. Refer to [Execution data](../execution-data/) for details.

---

## Code node

**URL:** llms-txt#code-node

**Contents:**
- Usage
  - Choose a mode
- JavaScript
  - Supported JavaScript features
  - External libraries
  - Built-in methods and variables
  - Keyboard shortcuts
- Python (Pyodide - legacy)
  - Built-in methods and variables
  - Keyboard shortcuts

Use the Code node to write custom JavaScript or Python and run it as a step in your workflow.

This page gives usage information about the Code node. For more guidance on coding in n8n, refer to the [Code](../../../../code/) section. It includes:

- Reference documentation on [Built-in methods and variables](../../../../code/builtin/overview/)
- Guidance on [Handling dates](../../../../code/cookbook/luxon/) and [Querying JSON](../../../../code/cookbook/jmespath/)
- A growing collection of examples in the [Cookbook](../../../../code/cookbook/code-node/)

Examples and templates

For usage examples and templates to help you get started, refer to n8n's [Code integrations](https://n8n.io/integrations/code/) page.

Function and Function Item nodes

The Code node replaces the Function and Function Item nodes from version 0.198.0. If you're using an older version of n8n, you can still view the [Function node documentation](https://github.com/n8n-io/n8n-docs/blob/67935ad2528e2e30d7984ea917e4af2910a096ec/docs/integrations/builtin/core-nodes/n8n-nodes-base.function.md) and [Function Item node documentation](https://github.com/n8n-io/n8n-docs/blob/67935ad2528e2e30d7984ea917e4af2910a096ec/docs/integrations/builtin/core-nodes/n8n-nodes-base.functionItem.md).

How to use the Code node.

- **Run Once for All Items**: this is the default. When your workflow runs, the code in the code node executes once, regardless of how many input items there are.
- **Run Once for Each Item**: choose this if you want your code to run for every input item.

The Code node supports Node.js.

### Supported JavaScript features

The Code node supports:

- Promises. Instead of returning the items directly, you can return a promise which resolves accordingly.
- Writing to your browser console using `console.log`. This is useful for debugging and troubleshooting your workflows.

### External libraries

If you self-host n8n, you can import and use built-in and external npm modules in the Code node. To learn how to enable external modules, refer to the [Enable modules in Code node](../../../../hosting/configuration/configuration-examples/modules-in-code-node/) guide.

If you use n8n Cloud, you can't import external npm modules. n8n makes two modules available for you:

- [crypto Node.js module](https://nodejs.org/docs/latest-v18.x/api/crypto.html)
- [moment npm package](https://www.npmjs.com/package/moment)

### Built-in methods and variables

n8n provides built-in methods and variables for working with data and accessing n8n data. Refer to [Built-in methods and variables](../../../../code/builtin/overview/) for more information.

The syntax to use the built-in methods and variables is `$variableName` or `$methodName()`. Type `$` in the Code node or expressions editor to see a list of suggested methods and variables.

### Keyboard shortcuts

The Code node editing environment supports time-saving and useful keyboard shortcuts for a range of operations from autocompletion to code-folding and using multiple-cursors. See the full list of [keyboard shortcuts](keyboard-shortcuts/).

## Python (Pyodide - legacy)

Pyodide is a legacy feature. Future versions of n8n will no longer support this feature.

n8n added Python support in version 1.0. It doesn't include a Python executable. Instead, n8n provides Python support using [Pyodide](https://pyodide.org/en/stable/), which is a port of CPython to WebAssembly. This limits the available Python packages to the [Packages included with Pyodide](https://pyodide.org/en/stable/usage/packages-in-pyodide.html#packages-in-pyodide). n8n downloads the package automatically the first time you use it.

Slower than JavaScript

The Code node takes longer to process Python than JavaScript. This is due to the extra compilation steps.

### Built-in methods and variables

n8n provides built-in methods and variables for working with data and accessing n8n data. Refer to [Built-in methods and variables](../../../../code/builtin/overview/) for more information.

The syntax to use the built-in methods and variables is `_variableName` or `_methodName()`. Type `_` in the Code node to see a list of suggested methods and variables.

### Keyboard shortcuts

The Code node editing environment supports time-saving and useful keyboard shortcuts for a range of operations from autocompletion to code-folding and using multiple-cursors. See the full list of [keyboard shortcuts](keyboard-shortcuts/).

## File system and HTTP requests

You can't access the file system or make HTTP requests. Use the following nodes instead:

- [Read/Write File From Disk](../n8n-nodes-base.readwritefile/)
- [HTTP Request](../n8n-nodes-base.httprequest/)

## Python (Native - beta)

n8n added native Python support using task runners (beta) in version 1.111.0.

Main differences from Pyodide:

- Native Python supports only `_items` in all-items mode and `_item` in per-item mode. It doesn't support other n8n built-in methods and variables.
- Native Python supports importing native Python modules from the standard library and from third-parties, if the `n8nio/runners` image includes them and explicitly allowlists them. See [adding extra dependencies for task runners](../../../../hosting/configuration/task-runners/#adding-extra-dependencies) for more details.
- Native Python denies insecure built-ins by default. See [task runners environment variables](../../../../hosting/configuration/environment-variables/task-runners/) for more details.
- Unlike Pyodide, which accepts dot access notation, for example, `item.json.myNewField`, native Python only accepts bracket access notation, for example, `item["json"]["my_new_field"]`. There may be other minor syntax differences where Pyodide accepts constructs that aren't legal in native Python.

Keep in mind upgrading to native Python is a breaking change, so you may need to adjust your Python scripts to use the native Python runner.

This feature is in beta and is subject to change. As it becomes stable, n8n will roll it out progressively to n8n cloud users during 2025. Self-hosting users can [try it out](../../../../hosting/configuration/task-runners/) and provide feedback.

There are two places where you can use code in n8n: the Code node and the expressions editor. When using either area, there are some key concepts you need to know, as well as some built-in methods and variables to help with common tasks.

When working with the Code node, you need to understand the following concepts:

- [Data structure](../../../../data/data-structure/): understand the data you receive in the Code node, and requirements for outputting data from the node.
- [Item linking](../../../../data/data-mapping/data-item-linking/): learn how data items work, and how to link to items from previous nodes. You need to handle item linking in your code when the number of input and output items doesn't match.

### Built-in methods and variables

n8n includes built-in methods and variables. These provide support for:

- Accessing specific item data
- Accessing data about workflows, executions, and your n8n environment
- Convenience variables to help with data and time

Refer to [Built-in methods and variables](../../../../code/builtin/overview/) for more information.

## Use AI in the Code node

AI assistance in the Code node is available to Cloud users. It isn't available in self-hosted n8n.

AI generated code overwrites your code

If you've already written some code on the **Code** tab, the AI generated code will replace it. n8n recommends using AI as a starting point to create your initial code, then editing it as needed.

To use ChatGPT to generate code in the Code node:

1. In the Code node, set **Language** to **JavaScript**.
1. Select the **Ask AI** tab.
1. Write your query.
1. Select **Generate Code**. n8n sends your query to ChatGPT, then displays the result in the **Code** tab.

For common questions or issues and suggested solutions, refer to [Common Issues](common-issues/).

---

## monday.com node

**URL:** llms-txt#monday.com-node

**Contents:**
- Operations
- Templates and examples
- What to do if your operation isn't supported

Use the monday.com node to automate work in monday.com, and integrate monday.com with other applications. n8n has built-in support for a wide range of monday.com features, including creating a new board, and adding, deleting, and getting items on the board.

On this page, you'll find a list of operations the monday.com node supports and links to more resources.

Minimum required version

This node requires n8n version 1.22.6 or above.

Refer to [monday.com credentials](../../credentials/mondaycom/) for guidance on setting up authentication.

This node can be used as an AI tool

This node can be used to enhance the capabilities of an AI agent. When used in this way, many parameters can be set automatically, or with information directed by AI - find out more in the [AI tool parameters documentation](../../../../advanced-ai/examples/using-the-fromai-function/).

- Board
  - Archive a board
  - Create a new board
  - Get a board
  - Get all boards
- Board Column
  - Create a new column
  - Get all columns
- Board Group
  - Delete a group in a board
  - Create a group in a board
  - Get list of groups in a board
- Board Item
  - Add an update to an item.
  - Change a column value for a board item
  - Change multiple column values for a board item
  - Create an item in a board's group
  - Delete an item
  - Get an item
  - Get all items
  - Get items by column value
  - Move item to group

## Templates and examples

**Create ticket on specific customer messages in Telegram**

[View template details](https://n8n.io/workflows/368-create-ticket-on-specific-customer-messages-in-telegram/)

**Microsoft Outlook AI Email Assistant with contact support from Monday and Airtable**

by Cognitive Creators

[View template details](https://n8n.io/workflows/2809-microsoft-outlook-ai-email-assistant-with-contact-support-from-monday-and-airtable/)

**Retrieve a Monday.com row and all data in a single node**

[View template details](https://n8n.io/workflows/2086-retrieve-a-mondaycom-row-and-all-data-in-a-single-node/)

[Browse monday.com integration templates](https://n8n.io/integrations/mondaycom/), or [search all templates](https://n8n.io/workflows/)

## What to do if your operation isn't supported

If this node doesn't support the operation you want to do, you can use the [HTTP Request node](../../core-nodes/n8n-nodes-base.httprequest/) to call the service's API.

You can use the credential you created for this service in the HTTP Request node:

1. In the HTTP Request node, select **Authentication** > **Predefined Credential Type**.
1. Select the service you want to connect to.
1. Select your credential.

Refer to [Custom API operations](../../../custom-operations/) for more information.

---

## RBAC role types

**URL:** llms-txt#rbac-role-types

**Contents:**
- Project Admin
- Project Editor
- Project Viewer

- The Project Editor role is available on Pro Cloud and Self-hosted Enterprise plans.
- The Project Viewer role is only available on Self-hosted Enterprise and Cloud Enterprise plans.

Within projects, there are three user roles: Admin, Editor, and Viewer. These roles control what the user can do in a project. A user can have different roles within different projects.

A Project Admin role has the highest level of permissions. Project admins can:

- Manage project settings: Change name, delete project.
- Manage project members: Invite members and remove members, change members' roles.
- View, create, update, and delete any workflows, credentials, or executions within a project.

A Project Editor can view, create, update, and delete any workflows, credentials, or executions within a project.

A Project Viewer is effectively a `read-only` role with access to all workflows, credentials, and executions within a project.

Viewers aren't able to manually execute any workflows that exist in a project.

Role types and account types

Role types and [account types](../../account-types/) are different things. Every account has one type. The account can have different role types for different [projects](../projects/).

| Permission                      | Admin | Editor | Viewer |
| ------------------------------- | ----- | ------ | ------ |
| View workflows in the project   |       |        |        |
| View credentials in the project |       |        |        |
| View executions                 |       |        |        |
| Edit credentials and workflows  |       |        |        |
| Add workflows and credentials   |       |        |        |
| Execute workflows               |       |        |        |
| Manage members                  |       |        |        |
| Modify the project              |       |        |        |

[Variables](../../../code/variables/) and [tags](../../../workflows/tags/) aren't affected by RBAC: they're global across the n8n instance.

---

## Export and import workflows

**URL:** llms-txt#export-and-import-workflows

**Contents:**
- Copy-Paste
- From the Editor UI menu
- From the command line

n8n saves workflows in JSON format. You can export your workflows as JSON files or import JSON files into your n8n library. You can export and import workflows in several ways.

Exported workflow JSON files include [credential](../../glossary/#credential-n8n) names and IDs. While IDs aren't sensitive, the names could be, depending on how you name your credentials. HTTP Request nodes may contain authentication headers when imported from cURL. Remove or anonymize this information from the JSON file before sharing to protect your credentials.

You can copy and paste a workflow or parts of it by selecting the nodes you want to copy to the clipboard (`Ctrl + c` or `cmd +c`) and pasting it (`Ctrl + v` or `cmd + v`) into the Editor UI.

To select all nodes or a group of nodes, click and drag:

## From the Editor UI menu

From the top navigation bar, select the three dots in the upper right to see the following options:

*Import & Export workflows menu*

- **Download**: Downloads your current workflow as a JSON file to your computer.
- **Import from URL**: Imports workflow JSON from a URL, for example, [this workflow JSON file on GitHub](https://raw.githubusercontent.com/n8n-io/self-hosted-ai-starter-kit/refs/heads/main/n8n/demo-data/workflows/srOnR8PAY3u4RSwb.json).
- **Import from File**: Imports a workflow as a JSON file from your computer.

## From the command line

- Export: See the [full list of commands](../../hosting/cli-commands/#export-workflows-and-credentials) for exporting workflows or credentials.
- Import: See the [full list of commands](../../hosting/cli-commands/#import-workflows-and-credentials) for importing workflows or credentials.

---

## Customer Datastore (n8n Training) node

**URL:** llms-txt#customer-datastore-(n8n-training)-node

Use this node only for the n8n new user onboarding tutorial. It provides dummy data for testing purposes and has no further functionality.

---

## Replace 2.1.0 with your version number

**URL:** llms-txt#replace-2.1.0-with-your-version-number

npm install n8n-nodes-nodeName@2.1.0
```

---

## DeepSeek Chat Model node

**URL:** llms-txt#deepseek-chat-model-node

**Contents:**
- Node parameters
  - Model
- Node options
  - Base URL
  - Frequency Penalty
  - Maximum Number of Tokens
  - Response Format
  - Presence Penalty
  - Sampling Temperature
  - Timeout

Use the DeepSeek Chat Model node to use DeepSeek's chat models with conversational [agents](../../../../../glossary/#ai-agent).

On this page, you'll find the node parameters for the DeepSeek Chat Model node and links to more resources.

You can find authentication information for this node [here](../../../credentials/deepseek/).

Parameter resolution in sub-nodes

Sub-nodes behave differently to other nodes when processing multiple items using an expression.

Most nodes, including root nodes, take any number of items as input, process these items, and output the results. You can use expressions to refer to input items, and the node resolves the expression for each item in turn. For example, given an input of five `name` values, the expression `{{ $json.name }}` resolves to each name in turn.

In sub-nodes, the expression always resolves to the first item. For example, given an input of five `name` values, the expression `{{ $json.name }}` always resolves to the first name.

Select the model to use to generate the completion.

n8n dynamically loads models from DeepSeek and you'll only see the models available to your account.

Use these options to further refine the node's behavior.

Enter a URL here to override the default URL for the API.

### Frequency Penalty

Use this option to control the chances of the model repeating itself. Higher values reduce the chance of the model repeating itself.

### Maximum Number of Tokens

Enter the maximum number of tokens used, which sets the completion length.

Choose **Text** or **JSON**. **JSON** ensures the model returns valid JSON.

Use this option to control the chances of the model talking about new topics. Higher values increase the chance of the model talking about new topics.

### Sampling Temperature

Use this option to control the randomness of the sampling process. A higher temperature creates more diverse sampling, but increases the risk of hallucinations.

Enter the maximum request time in milliseconds.

Enter the maximum number of times to retry a request.

Use this option to set the probability the completion should use. Use a lower value to ignore less probable options.

## Templates and examples

**🐋🤖 DeepSeek AI Agent + Telegram + LONG TERM Memory 🧠**

[View template details](https://n8n.io/workflows/2864-deepseek-ai-agent-telegram-long-term-memory/)

**🤖 AI content generation for Auto Service 🚘 Automate your social media📲!**

[View template details](https://n8n.io/workflows/4600-ai-content-generation-for-auto-service-automate-your-social-media/)

**AI Research Assistant via Telegram (GPT-4o mini + DeepSeek R1 + SerpAPI)**

[View template details](https://n8n.io/workflows/5924-ai-research-assistant-via-telegram-gpt-4o-mini-deepseek-r1-serpapi/)

[Browse DeepSeek Chat Model integration templates](https://n8n.io/integrations/deepseek-chat-model/), or [search all templates](https://n8n.io/workflows/)

As DeepSeek is API-compatible with OpenAI, you can refer to [LangChains's OpenAI documentation](https://js.langchain.com/docs/integrations/chat/openai/) for more information about the service.

View n8n's [Advanced AI](../../../../../advanced-ai/) documentation.

---

## Cisco Meraki credentials

**URL:** llms-txt#cisco-meraki-credentials

**Contents:**
- Prerequisites
- Authentication methods
- Related resources
- Using API key

You can use these credentials to authenticate when using the [HTTP Request node](../../core-nodes/n8n-nodes-base.httprequest/) to make a [Custom API call](../../../custom-operations/).

- Create a [Cisco DevNet developer account](https://developer.cisco.com).
- Access to a [Cisco Meraki account](https://meraki.cisco.com/).

## Authentication methods

Refer to [Cisco Meraki's API documentation](https://developer.cisco.com/meraki/api-v1/introduction/) for more information about the service.

This is a credential-only node. Refer to [Custom API operations](../../../custom-operations/) to learn more. View [example workflows and related content](https://n8n.io/integrations/cisco-meraki/) on n8n's website.

To configure this credential, you'll need:

- An **API Key**: Refer to the [Cisco Meraki Obtaining your Meraki API Key documentation](https://developer.cisco.com/meraki/api-v1/authorization/#obtaining-your-meraki-api-key) for instructions on getting your API Key.

---

## crowd.dev credentials

**URL:** llms-txt#crowd.dev-credentials

**Contents:**
- Prerequisites
- Supported authentication methods
- Related resources
- Using API key

You can use these credentials to authenticate the following nodes:

- [crowd.dev](../../app-nodes/n8n-nodes-base.crowddev/)
- [crowd.dev Trigger](../../trigger-nodes/n8n-nodes-base.crowddevtrigger/)

Create a working instance of [crowd.dev](https://www.crowd.dev/).

## Supported authentication methods

Refer to [crowd.dev's documentation](https://docs.crowd.dev/docs) for more information about the service, and their [API documentation](https://api.crowd.dev/api-reference) for working with the API.

To configure this credential, you'll need:

- A **URL**:
  - If your crowd.dev instance is hosted on crowd.dev, keep the default of `https://app.crowd.dev`.
  - If your crowd.dev instance is [self-hosted](https://docs.crowd.dev/docs/technical-docs/self-hosting), use the URL you use to access your crowd.dev instance.
- Your crowd.dev **Tenant ID**: Displayed in the **Settings** section of the crowd.dev app
- An API **Token**: Displayed in the **Settings** section of the crowd.dev app

Refer to the [crowd.dev API documentation](https://api.crowd.dev/api-reference) for more detailed instructions.

---

## Wise credentials

**URL:** llms-txt#wise-credentials

**Contents:**
- Prerequisites
- Supported authentication methods
- Related resources
- Using API token
- Add a private key

You can use these credentials to authenticate the following nodes:

- [Wise](../../app-nodes/n8n-nodes-base.wise/)
- [Wise Trigger](../../trigger-nodes/n8n-nodes-base.wisetrigger/)

Create a [Wise](https://wise.com/) account.

## Supported authentication methods

Refer to [Wise's API documentation](https://docs.wise.com/api-docs/api-reference) for more information about the service.

To configure this credential, you'll need:

- An **API Token**: Go to your **user menu > Settings > API tokens** to generate an API token. Enter the generated API key in your n8n credential. Refer to [Getting started with the API](https://wise.com/help/articles/2958107/getting-started-with-the-api) for more information.
- Your **Environment**: Select the environment that best matches your Wise account environment.
  - If you're using a Wise test sandbox account, select **Test**.
  - Otherwise, select **Live**.
- **Private Key (Optional)**: For live endpoints requiring Strong Customer Authentication (SCA), generate a public and private key. Enter the private key here. Refer to [Add a private key](#add-a-private-key) for more information.
  - If you're using a **Test** environment, you'll only need to enter a Private Key if you've enabled Strong Customer Authentication on the [public keys management page](https://sandbox.transferwise.tech/public-keys).

Wise protects some live endpoints and operations with Strong Customer Authentication (SCA). Refer to [Strong Customer Authentication & 2FA](https://docs.wise.com/api-docs/features/strong-customer-authentication-2fa) for details.

If you make a request to an endpoint that requires SCA, Wise returns a 403 Forbidden HTTP status code. The error returned will look like this:

> This request requires Strong Customer Authentication (SCA). Please add a key pair to your account and n8n credentials. See https://api-docs.transferwise.com/#strong-customer-authentication-personal-token

To use endpoints requiring SCA, generate an RSA key pair and add the relevant key information to both Wise and n8n:

1. Generate an RSA key pair:

1. Add the content of the public key `public.pem` to your Wise **user menu > Settings > API tokens > Manage public keys**.

1. Add the content of the private key `private.pem` in n8n to the **Private Key (Optional)**.

Refer to [Personal Token SCA](https://docs.wise.com/api-docs/guides/strong-customer-authentication-2fa/personal-token-sca) for more information.

**Examples:**

Example 1 (unknown):
```unknown
$ openssl genrsa -out private.pem 2048 
   $ openssl rsa -pubout -in private.pem -out public.pem
```

---

## AI coding with GPT

**URL:** llms-txt#ai-coding-with-gpt

**Contents:**
- Use AI in the Code node
- Usage limits
- Feature limits
- Writing good prompts
  - Example prompts
  - Reference incoming node data explicitly
  - Related resources
- Fixing the code

Not available on self-hosted.

Python isn't supported. ///

## Use AI in the Code node

AI assistance in the Code node is available to Cloud users. It isn't available in self-hosted n8n.

AI generated code overwrites your code

If you've already written some code on the **Code** tab, the AI generated code will replace it. n8n recommends using AI as a starting point to create your initial code, then editing it as needed.

To use ChatGPT to generate code in the Code node:

1. In the Code node, set **Language** to **JavaScript**.
1. Select the **Ask AI** tab.
1. Write your query.
1. Select **Generate Code**. n8n sends your query to ChatGPT, then displays the result in the **Code** tab.

During the trial phase there are no usage limits. If n8n makes the feature permanent, there may be usage limits as part of your pricing tier.

The ChatGPT implementation in n8n has the following limitations:

- The AI writes code that manipulates data from the n8n workflow. You can't ask it to pull in data from other sources.
- The AI doesn't know your data, just the schema, so you need to tell it things like how to find the data you want to extract, or how to check for null.
- Nodes before the Code node must execute and deliver data to the Code node before you run your AI query.
- Doesn't work with large incoming data schemas.
- May have issues if there are a lot of nodes before the code node.

## Writing good prompts

Writing good prompts increases the chance of getting useful code back.

- Provide examples: if possible, give a sample expected output. This helps the AI to better understand the transformation or logic you’re aiming for.
- Describe the processing steps: if there are specific processing steps or logic that should apply to the data, list them in sequence. For example: "First, filter out all users under 18. Then, sort the remaining users by their last name."
- Avoid ambiguities: while the AI understands various instructions, being clear and direct ensures you get the most accurate code. Instead of saying "Get the older users," you might say "Filter users who are 60 years and above."
- Be clear about what you expect as the output. Do you want the data transformed, filtered, aggregated, or sorted? Provide as much detail as possible.

And some n8n-specific guidance:

- Think about the input data: make sure ChatGPT knows which pieces of the data you want to access, and what the incoming data represents. You may need to tell ChatGPT about the availability of n8n's built-in methods and variables.
- Declare interactions between nodes: if your logic involves data from multiple nodes, specify how they should interact. "Merge the output of 'Node A' with 'Node B' based on the 'userID' property". if you prefer data to come from certain nodes or to ignore others, be clear: "Only consider data from the 'Purchases' node and ignore the 'Refunds' node."
- Ensure the output is compatible with n8n. Refer to [Data structure](../../data/data-structure/) for more information on the data structure n8n requires.

These examples show a range of possible prompts and tasks.

#### Example 1: Find a piece of data inside a second dataset

To try the example yourself, [download the example workflow](../../_workflows/ai-code/find-a-piece-of-data.json) and import it into n8n.

In the third Code node, enter this prompt:

> The slack data contains only one item. The input data represents all Notion users. Sometimes the person property that holds the email can be null. I want to find the notionId of the Slack user and return it.

Take a look at the code the AI generates.

This is the JavaScript you need:

#### Example 2: Data transformation

To try the example yourself, [download the example workflow](../../_workflows/ai-code/data-transformation.json) and import it into n8n.

In the **Join items** Code node, enter this prompt:

> Return a single line of text that has all usernames listed with a comma. Each username should be enquoted with a double quotation mark.

Take a look at the code the AI generates.

This is the JavaScript you need:

#### Example 3: Summarize data and create a Slack message

To try the example yourself, [download the example workflow](../../_workflows/ai-code/summarize-data.json) and import it into n8n.

In the **Summarize** Code node, enter this prompt:

> Create a markdown text for Slack that counts how many ideas, features and bugs have been submitted. The type of submission is saved in the property_type field. A feature has the property "Feature", a bug has the property "Bug" and an idea has the property "Bug". Also, list the five top submissions by vote in that message. Use "" as markdown for links.

Take a look at the code the AI generates.

This is the JavaScript you need:

### Reference incoming node data explicitly

If your incoming data contains nested fields, using dot notation to reference them can help the AI understand what data you want.

To try the example yourself, [download the example workflow](../../_workflows/ai-code/reference-incoming-data-explicitly.json) and import it into n8n.

In the second Code node, enter this prompt:

> The data in "Mock data" represents a list of people. For each person, return a new item containing personal_info.first_name and work_info.job_title.

This is the JavaScript you need:

### Related resources

Pluralsight offer a short guide on [How to use ChatGPT to write code](https://www.pluralsight.com/blog/software-development/how-use-chatgpt-programming-coding), which includes example prompts.

The AI-generated code may work without any changes, but you may have to edit it. You need to be aware of n8n's [Data structure](../../data/data-structure/). You may also find n8n's built-in methods and variables useful.

**Examples:**

Example 1 (unknown):
```unknown
const slackUser = $("Mock Slack").all()[0];
const notionUsers = $input.all();
const slackUserEmail = slackUser.json.email;

const notionUser = notionUsers.find(
  (user) => user.json.person && user.json.person.email === slackUserEmail
);

return notionUser ? [{ json: { notionId: notionUser.json.id } }] : [];
```

Example 2 (unknown):
```unknown
const items = $input.all();
const usernames = items.map((item) => `"${item.json.username}"`);
const result = usernames.join(", ");
return [{ json: { usernames: result } }];
```

Example 3 (unknown):
```unknown
const submissions = $input.all();

// Count the number of ideas, features, and bugs
let ideaCount = 0;
let featureCount = 0;
let bugCount = 0;

submissions.forEach((submission) => {
  switch (submission.json.property_type[0]) {
    case "Idea":
      ideaCount++;
      break;
    case "Feature":
      featureCount++;
      break;
    case "Bug":
      bugCount++;
      break;
  }
});

// Sort submissions by votes and take the top 5
const topSubmissions = submissions
  .sort((a, b) => b.json.property_votes - a.json.property_votes)
  .slice(0, 5);

let topSubmissionText = "";
topSubmissions.forEach((submission) => {
  topSubmissionText += `<${submission.json.url}|${submission.json.name}> with ${submission.json.property_votes} votes\n`;
});

// Construct the Slack message
const slackMessage = `*Summary of Submissions*\n
Ideas: ${ideaCount}\n
Features: ${featureCount}\n
Bugs: ${bugCount}\n
Top 5 Submissions:\n
${topSubmissionText}`;

return [{ json: { slackMessage } }];
```

Example 4 (unknown):
```unknown
const items = $input.all();
const newItems = items.map((item) => {
  const firstName = item.json.personal_info.first_name;
  const jobTitle = item.json.work_info.job_title;
  return {
    json: {
      firstName,
      jobTitle,
    },
  };
});
return newItems;
```

---

## MSG91 credentials

**URL:** llms-txt#msg91-credentials

**Contents:**
- Prerequisites
- Supported authentication methods
- Related resources
- Using API key
- IP Security

You can use these credentials to authenticate the following nodes:

- [MSG91](../../app-nodes/n8n-nodes-base.msg91/)

Create a [MSG91](https://msg91.com/) account.

## Supported authentication methods

Refer to [MSG91's API documentation](https://docs.msg91.com/overview) for more information about the service.

To configure this credential, you'll need:

- An **Authentication Key**: To get your Authentication Key, go to the user menu and select **Authkey**. Refer to MSG91's [Where can I find my authentication key? documentation](https://msg91.com/help/api/where-can-i-find-my-authentication-ke) for more information.

MSG91 enables [IP Security](https://msg91.com/help/api/what-do-you-mean-by-api-security) by default for authkeys.

For the n8n credentials to function with this setting enabled, add all the [n8n IP addresses](../../../../manage-cloud/cloud-ip/) as whitelisted IPs in MSG91. You can add them in one of two places, depending on your desired security level:

- To allow any/all authkeys in the account to work with n8n, add the n8n IP addresses in the **Company's whitelisted IPs** section of the **Authkey** page.
- To allow only specific authkeys to work with n8n, add the n8n IP addresses in the **Whitelisted IPs** section of an authkey's details.

---

## Limit

**URL:** llms-txt#limit

**Contents:**
- Node parameters
  - Max Items
  - Keep
- Templates and examples
- Related resources

Use the Limit node to remove items beyond a defined maximum number. You can choose whether n8n takes the items from the beginning or end of the input data.

Configure this node using the following parameters.

Enter the maximum number of items that n8n should keep. If the input data contains more than this value, n8n removes the items.

If the node has to remove items, select where it keeps the input items from:

- **First Items**: Keeps the **Max Items** number of items from the beginning of the input data.
- **Last Items**: Keeps the **Max Items** number of items from the end of the input data.

## Templates and examples

**Scrape and summarize webpages with AI**

[View template details](https://n8n.io/workflows/1951-scrape-and-summarize-webpages-with-ai/)

**Generate Leads with Google Maps**

[View template details](https://n8n.io/workflows/2605-generate-leads-with-google-maps/)

**Chat with OpenAI Assistant (by adding a memory)**

[View template details](https://n8n.io/workflows/2098-chat-with-openai-assistant-by-adding-a-memory/)

[Browse Limit integration templates](https://n8n.io/integrations/limit/), or [search all templates](https://n8n.io/workflows/)

Learn more about [data structure and data flow](../../../../data/) in n8n workflows.

---

## Toggl Trigger node

**URL:** llms-txt#toggl-trigger-node

[Toggl](https://toggl.com/) is a time tracking app that offers online time tracking and reporting services through their website along with mobile and desktop applications.

You can find authentication information for this node [here](../../credentials/toggl/).

Examples and templates

For usage examples and templates to help you get started, refer to n8n's [Toggl Trigger integrations](https://n8n.io/integrations/toggl-trigger/) page.

---

## Guardrails node

**URL:** llms-txt#guardrails-node

**Contents:**
- Node parameters
  - Operation
  - Text To Check
  - Guardrails
  - Customize System Message

Use the Guardrails node to enforce safety, security, and content policies on text. You can use it to validate user input *before* sending it to an AI model, or to check the *output* from an AI model before using it in your workflow.

Chat Model Connection Required for LLM-based Guardrails

This node requires a Chat Model node to be connected to its Model input when using the **Check Text for Violations** operation with LLM-based guardrails. Many guardrail checks (like Jailbreak, NSFW, and Topical Alignment) are LLM-based and use this connection to evaluate the input text.

Use these parameters to configure the Guardrails node.

The operation mode for this node to define its behavior.

- **Check Text for Violations**: Provides a full set of guardrails. Any violation will send items to **Fail** branch.
- **Sanitize Text**: Provides a subset of guardrails that can detect URLs, regular expressions, secret keys, or personally identifiable information (PII), such as phone numbers and credit card numbers. The node replaces detected violations with placeholders.

The text the guardrails evaluate. Typically, you map this text using an expression from a previous node, such as text from a user query or a response from an AI model.

Select one or more guardrails to apply to the **Text To Check**. When you add a guardrail from the list, its specific configuration options appear below.

- **Keywords:** Checks if specified keywords appear in the input text.
  - **Keywords**: A comma-separated list of words to block.
- **Jailbreak:** Detects attempts to bypass AI safety measures or exploit the model.
  - **Customize Prompt**: (Boolean) If you turn this on, a text input appears with the default prompt for the jailbreak detection model. You can change this prompt to fine-tune the guardrail.
  - **Threshold**: A value between 0.0 and 1.0. This represents the confidence level required from the AI model to flag the input as a jailbreak attempt. A higher threshold is stricter.
- **NSFW:** Detects attempts to generate Not Safe For Work (NSFW) content.
  - **Customize Prompt**: (Boolean) If you turn this on, a text input appears with the default prompt for the NSFW detection model. You can change this prompt to fine-tune the guardrail.
  - **Threshold**: A value between 0.0 and 1.0 representing the confidence level required to flag the content as NSFW.
- **PII:** Detects personally identifiable information (PII) in the text.
  - **Type**: Choose which PII entities to scan for:
    - **All**: Scans for all available entity types.
    - **Selected**: Allows you to choose specific entities from a list.
  - **Entities**: (Appears if **Type** is **Selected**) A multi-select list of PII types to detect (for example, `CREDIT_CARD`, `EMAIL_ADDRESS`, `PHONE_NUMBER`, and `US_SSN`).
- **Secret Keys:** Detects the presence of secret keys or API credentials in the text.
  - **Permissiveness**: How strict or permissive the detection should be when flagging secret keys:
    - **Strict**
    - **Permissive**
    - **Balanced**
- **Topical Alignment:** Ensures the conversation stays within a predefined scope or topic (also known as "business scope").
  - **Prompt**: A preset prompt that defines the *allowed* topic. The guardrail checks if the **Text To Check** aligns with this prompt.
  - **Threshold**: A value between 0.0 and 1.0 representing the confidence level required to flag the input as *off-topic*.
- **URLs:** Manages URLs the node finds in the input text. It detects all URLs as violations, unless you specify them in **Block All URLs Except**.
  - **Block All URLs Except**: (Optional) A comma-separated list of URLs that you permit.
  - **Allowed Schemes**: Select the URL schemes to permit (for example, `https`, `http`, `ftp`, and `mailto`).
  - **Block userinfo**: (Boolean) If you turn this on, the node blocks URLs containing user credentials (for example, `user:pass@example.com`) to prevent credential injection.
  - **Allow subdomain**: (Boolean) If you turn this on, the node automatically allows subdomains of any URL in the **Block All URLs Except** list (for example, `sub.example.com` would be allowed if `example.com` is in the list).
- **Custom:** Define your own custom, LLM-based guardrail.
  - **Name**: A descriptive name for your custom guardrail (for example, "Check for rude language").
  - **Prompt**: A prompt that instructs the AI model what to check for.
  - **Threshold**: A value between 0.0 and 1.0 representing the confidence level required to flag the input as a violation.
- **Custom Regex**: Define your own custom regular expression patterns.
  - **Name**: A name for your custom pattern. The node uses this name as a placeholder in the **Sanitize Text** mode.
  - **Regex**: Your regular expression pattern.

### Customize System Message

If you turn this on, a text input appears with a message that the guardrail uses to enforce thresholds and JSON output according to schema. Change it to modify the global guardrails behavior.

---

## CircleCI credentials

**URL:** llms-txt#circleci-credentials

**Contents:**
- Prerequisites
- Supported authentication methods
- Related resources
- Using personal API token

You can use these credentials to authenticate the following nodes:

- [CircleCI](../../app-nodes/n8n-nodes-base.circleci/)

Create a [CircleCI](https://circleci.com/) account.

## Supported authentication methods

Refer to [CircleCI's API documentation](https://circleci.com/docs/api/v2/index.html) for more information about the service.

## Using personal API token

To configure this credential, you'll need:

- A **Personal API Token**: Refer to the [CircleCI Creating a Personal API token documentation](https://circleci.com/docs/managing-api-tokens/#creating-a-personal-api-token) for instructions on creating your token.

---

## Hybrid Analysis credentials

**URL:** llms-txt#hybrid-analysis-credentials

**Contents:**
- Prerequisites
- Supported authentication methods
- Related resources
- Using API key

You can use these credentials to authenticate when using the [HTTP Request node](../../core-nodes/n8n-nodes-base.httprequest/) to make a [Custom API call](../../../custom-operations/).

Create a [Hybrid Analysis](https://www.hybrid-analysis.com/) account.

## Supported authentication methods

Refer to [Hybrid Analysis' API documentation](https://www.hybrid-analysis.com/docs/api/v2) for more information about the service.

This is a credential-only node. Refer to [Custom API operations](../../../custom-operations/) to learn more. View [example workflows and related content](https://n8n.io/integrations/hybrid-analysis/) on n8n's website.

To configure this credential, you'll need:

- An **API Key**: Refer to the [Hybrid Analysis' API documentation](https://www.hybrid-analysis.com/docs/api/v2) for instructions on generating an API key.

---

## Postmark Trigger node

**URL:** llms-txt#postmark-trigger-node

[Postmark](https://postmarkapp.com) helps deliver and track application email. You can track statistics such as the number of emails sent or processed, opens, bounces and, spam complaints.

You can find authentication information for this node [here](../../credentials/postmark/).

Examples and templates

For usage examples and templates to help you get started, refer to n8n's [Postmark Trigger integrations](https://n8n.io/integrations/postmark-trigger/) page.

---

## AWS Certificate Manager node

**URL:** llms-txt#aws-certificate-manager-node

**Contents:**
- Operations
- Templates and examples
- Related resources
- What to do if your operation isn't supported

Use the AWS Certificate Manager node to automate work in AWS Certificate Manager, and integrate AWS Certificate Manager with other applications. n8n has built-in support for a wide range of AWS Certificate Manager features, including creating, deleting, getting, and renewing SSL certificates.

On this page, you'll find a list of operations the AWS Certificate Manager node supports and links to more resources.

Refer to [AWS Certificate Manager credentials](../../credentials/aws/) for guidance on setting up authentication.

- Certificate
  - Delete
  - Get
  - Get Many
  - Get Metadata
  - Renew

## Templates and examples

**Clean Up Expired AWS ACM Certificates with Slack Approval**

[View template details](https://n8n.io/workflows/7626-clean-up-expired-aws-acm-certificates-with-slack-approval/)

**Generate SSL/TLS Certificate Expiry Reports with AWS ACM and AI for Slack & Email**

[View template details](https://n8n.io/workflows/7689-generate-ssltls-certificate-expiry-reports-with-aws-acm-and-ai-for-slack-and-email/)

**Auto-Renew AWS Certificates with Slack Approval Workflow**

[View template details](https://n8n.io/workflows/7490-auto-renew-aws-certificates-with-slack-approval-workflow/)

[Browse AWS Certificate Manager integration templates](https://n8n.io/integrations/aws-certificate-manager/), or [search all templates](https://n8n.io/workflows/)

Refer to [AWS Certificate Manager's documentation](https://docs.aws.amazon.com/acm/latest/userguide/acm-overview.html) for more information on this service.

## What to do if your operation isn't supported

If this node doesn't support the operation you want to do, you can use the [HTTP Request node](../../core-nodes/n8n-nodes-base.httprequest/) to call the service's API.

You can use the credential you created for this service in the HTTP Request node:

1. In the HTTP Request node, select **Authentication** > **Predefined Credential Type**.
1. Select the service you want to connect to.
1. Select your credential.

Refer to [Custom API operations](../../../custom-operations/) for more information.

---

## LingvaNex node

**URL:** llms-txt#lingvanex-node

**Contents:**
- Operations
- Templates and examples

Use the LingvaNex node to automate work in LingvaNex, and integrate LingvaNex with other applications. n8n has built-in support for translating data with LingvaNex.

On this page, you'll find a list of operations the LingvaNex node supports and links to more resources.

Refer to [LingvaNex credentials](../../credentials/lingvanex/) for guidance on setting up authentication.

## Templates and examples

**Get data from Hacker News and send to Airtable or via SMS**

[View template details](https://n8n.io/workflows/888-get-data-from-hacker-news-and-send-to-airtable-or-via-sms/)

**Get daily poems in Telegram**

[View template details](https://n8n.io/workflows/975-get-daily-poems-in-telegram/)

**Translate instructions using LingvaNex**

[View template details](https://n8n.io/workflows/797-translate-instructions-using-lingvanex/)

[Browse LingvaNex integration templates](https://n8n.io/integrations/lingvanex/), or [search all templates](https://n8n.io/workflows/)

---

## Wolfram|Alpha credentials

**URL:** llms-txt#wolfram|alpha-credentials

**Contents:**
- Supported authentication methods
- Related resources
- Using API key
- Resolve Forbidden connection error

You can use these credentials to authenticate the following nodes:

- [Wolfram|Alpha](../../cluster-nodes/sub-nodes/n8n-nodes-langchain.toolwolframalpha/)

## Supported authentication methods

Refer to [Wolfram|Alpha's Simple API documentation](https://products.wolframalpha.com/simple-api/documentation) for more information about the service.

View n8n's [Advanced AI](../../../../advanced-ai/) documentation.

To configure this credential, you'll need a registered [Wolfram ID](https://account.wolfram.com) and:

1. Open the Wolfram|Alpha Developer Portal and go to [**API Access**](https://developer.wolframalpha.com/access).
1. Select **Get an App ID**.
1. Enter a **Name** for your application, like `n8n integration`.
1. Enter a **Description** for your application.
1. Select **Simple API** as the **API**.
1. Select **Submit**.
1. Copy the generated **App ID** and enter it in your n8n credential.

Refer to **Getting Started** in the [Wolfram|Alpha Simple API documentation](https://products.wolframalpha.com/simple-api/documentation) for more information.

## Resolve Forbidden connection error

If you enter your App ID and get an error that the credential is **Forbidden**, make sure that you have verified your email address for your Wolfram ID:

1. Go to your [Wolfram ID Details](https://account.wolfram.com/wolframid).
1. If you don't see the **Verified** label underneath your **Email address**, select the link to **Send a verification email**.
1. You must open the link in that email to verify your email address.

It may take several minutes for the verification to populate to the API, but once it does, retrying the n8n credential should succeed.

---

## Simple Vector Store node

**URL:** llms-txt#simple-vector-store-node

**Contents:**
- Data safety limitations
  - Vector store data isn't persistent
  - All instance users can access vector store data
- Node usage patterns
  - Use as a regular node to insert and retrieve documents
  - Connect directly to an AI agent as a tool
  - Use a retriever to fetch documents
  - Use the Vector Store Question Answer Tool to answer questions
- Memory Management
  - Configuration Options

Use the Simple Vector Store node to store and retrieve [embeddings](../../../../../glossary/#ai-embedding) in n8n's in-app memory.

On this page, you'll find the node parameters for the Simple Vector Store node, and links to more resources.

Parameter resolution in sub-nodes

Sub-nodes behave differently to other nodes when processing multiple items using an expression.

Most nodes, including root nodes, take any number of items as input, process these items, and output the results. You can use expressions to refer to input items, and the node resolves the expression for each item in turn. For example, given an input of five `name` values, the expression `{{ $json.name }}` resolves to each name in turn.

In sub-nodes, the expression always resolves to the first item. For example, given an input of five `name` values, the expression `{{ $json.name }}` always resolves to the first name.

This node is different from AI memory nodes

The simple vector storage described here is different to the AI memory nodes such as [Simple Memory](../../sub-nodes/n8n-nodes-langchain.memorybufferwindow/).

This node creates a [vector database](../../../../../glossary/#ai-vector-store) in the app memory.

## Data safety limitations

Before using the Simple Vector Store node, it's important to understand its limitations and how it works.

n8n recommends using Simple Vector store for development use only.

### Vector store data isn't persistent

This node stores data in memory only. All data is lost when n8n restarts and may also be purged in low-memory conditions.

### All instance users can access vector store data

Memory keys for the Simple Vector Store node are global, not scoped to individual workflows.

This means that all users of the instance can access vector store data by adding a Simple Vector Store node and selecting the memory key, regardless of the access controls set for the original workflow. Take care not to expose sensitive information when ingesting data with the Simple Vector Store node.

## Node usage patterns

You can use the Simple Vector Store node in the following patterns.

### Use as a regular node to insert and retrieve documents

You can use the Simple Vector Store as a regular node to insert or get documents. This pattern places the Simple Vector Store in the regular connection flow without using an agent.

You can see an example of in step 2 of [this template](https://n8n.io/workflows/2465-building-your-first-whatsapp-chatbot/).

### Connect directly to an AI agent as a tool

You can connect the Simple Vector Store node directly to the [tool](../../../../../glossary/#ai-tool) connector of an [AI agent](../n8n-nodes-langchain.agent/) to use a vector store as a resource when answering queries.

Here, the connection would be: AI agent (tools connector) -> Simple Vector Store node.

### Use a retriever to fetch documents

You can use the [Vector Store Retriever](../../sub-nodes/n8n-nodes-langchain.retrievervectorstore/) node with the Simple Vector Store node to fetch documents from the Simple Vector Store node. This is often used with the [Question and Answer Chain](../n8n-nodes-langchain.chainretrievalqa/) node to fetch documents from the vector store that match the given chat input.

An [example of the connection flow](https://n8n.io/workflows/1960-ask-questions-about-a-pdf-using-ai/) (the linked example uses Pinecone, but the pattern is the same) would be: Question and Answer Chain (Retriever connector) -> Vector Store Retriever (Vector Store connector) -> Simple Vector Store.

### Use the Vector Store Question Answer Tool to answer questions

Another pattern uses the [Vector Store Question Answer Tool](../../sub-nodes/n8n-nodes-langchain.toolvectorstore/) to summarize results and answer questions from the Simple Vector Store node. Rather than connecting the Simple Vector Store directly as a tool, this pattern uses a tool specifically designed to summarizes data in the vector store.

The [connections flow](https://n8n.io/workflows/2465-building-your-first-whatsapp-chatbot/) in this case would look like this: AI agent (tools connector) -> Vector Store Question Answer Tool (Vector Store connector) -> Simple Vector store.

The Simple Vector Store implements memory management to prevent excessive memory usage:

- Automatically cleans up old vector stores when memory pressure increases
- Removes inactive stores that haven't been accessed for a configurable amount of time

### Configuration Options

You can control memory usage with these environment variables:

| Variable                      | Type   | Default | Description                                                                         |
| ----------------------------- | ------ | ------- | ----------------------------------------------------------------------------------- |
| `N8N_VECTOR_STORE_MAX_MEMORY` | Number | -1      | Maximum memory in MB allowed for all vector stores combined (-1 to disable limits). |
| `N8N_VECTOR_STORE_TTL_HOURS`  | Number | -1      | Hours of inactivity after which a store gets removed (-1 to disable TTL).           |

On n8n Cloud, these values are preset to 100MB (about 8,000 documents, depending on document size and metadata) and 7 days respectively. For self-hosted instances, both values default to -1(no memory limits or time-based cleanup).

This Vector Store node has four modes: **Get Many**, **Insert Documents**, **Retrieve Documents (As Vector Store for Chain/Tool)**, and **Retrieve Documents (As Tool for AI Agent)**. The mode you select determines the operations you can perform with the node and what inputs and outputs are available.

In this mode, you can retrieve multiple documents from your vector database by providing a prompt. The prompt is embedded and used for similarity search. The node returns the documents that are most similar to the prompt with their similarity score. This is useful if you want to retrieve a list of similar documents and pass them to an agent as additional context.

#### Insert Documents

Use insert documents mode to insert new documents into your vector database.

#### Retrieve Documents (as Vector Store for Chain/Tool)

Use Retrieve Documents (As Vector Store for Chain/Tool) mode with a vector-store retriever to retrieve documents from a vector database and provide them to the retriever connected to a chain. In this mode you must connect the node to a retriever node or root node.

#### Retrieve Documents (as Tool for AI Agent)

Use Retrieve Documents (As Tool for AI Agent) mode to use the vector store as a tool resource when answering queries. When formulating responses, the agent uses the vector store when the vector store name and description match the question details.

Enables [reranking](../../../../../glossary/#ai-reranking). If you enable this option, you must connect a reranking node to the vector store. That node will then rerank the results for queries. You can use this option with the `Get Many`, `Retrieve Documents (As Vector Store for Chain/Tool)` and `Retrieve Documents (As Tool for AI Agent)` modes.

### Get Many parameters

- **Memory Key**: Select or create the key containing the vector memory you want to query.
- **Prompt**: Enter the search query.
- **Limit**: Enter how many results to retrieve from the vector store. For example, set this to `10` to get the ten best results.

### Insert Documents parameters

- **Memory Key**: Select or create the key you want to store the vector memory as.
- **Clear Store**: Use this parameter to control whether to wipe the vector store for the given memory key for this workflow before inserting data (turned on).

### Retrieve Documents (As Vector Store for Chain/Tool) parameters

- **Memory Key**: Select or create the key containing the vector memory you want to query.

### Retrieve Documents (As Tool for AI Agent) parameters

- **Name**: The name of the vector store.
- **Description**: Explain to the LLM what this tool does. A good, specific description allows LLMs to produce expected results more often.
- **Memory Key**: Select or create the key containing the vector memory you want to query.
- **Limit**: Enter how many results to retrieve from the vector store. For example, set this to `10` to get the ten best results.

## Templates and examples

**Building Your First WhatsApp Chatbot**

[View template details](https://n8n.io/workflows/2465-building-your-first-whatsapp-chatbot/)

**RAG Chatbot for Company Documents using Google Drive and Gemini**

[View template details](https://n8n.io/workflows/2753-rag-chatbot-for-company-documents-using-google-drive-and-gemini/)

**🤖 AI Powered RAG Chatbot for Your Docs + Google Drive + Gemini + Qdrant**

[View template details](https://n8n.io/workflows/2982-ai-powered-rag-chatbot-for-your-docs-google-drive-gemini-qdrant/)

[Browse Simple Vector Store integration templates](https://n8n.io/integrations/in-memory-vector-store/), or [search all templates](https://n8n.io/workflows/)

Refer to [LangChains's Memory Vector Store documentation](https://js.langchain.com/docs/integrations/vectorstores/memory/) for more information about the service.

View n8n's [Advanced AI](../../../../../advanced-ai/) documentation.

---

## Customer Messenger (n8n Training) node

**URL:** llms-txt#customer-messenger-(n8n-training)-node

Use this node only for the n8n new user onboarding tutorial. It provides no further functionality.

---

## Line node

**URL:** llms-txt#line-node

**Contents:**
- Operations
- Templates and examples
- What to do if your operation isn't supported

Deprecated: End of service

LINE Notify is discontinuing service as of April 1st 2025 and this node will no longer work after that date. View LINE Notify's [end of service announement](https://notify-bot.line.me/closing-announce) for more information.

Use the Line node to automate work in Line, and integrate Line with other applications. n8n has built-in support for a wide range of Line features, including sending notifications.

On this page, you'll find a list of operations the Line node supports and links to more resources.

Refer to [Line credentials](../../credentials/line/) for guidance on setting up authentication.

This node can be used as an AI tool

This node can be used to enhance the capabilities of an AI agent. When used in this way, many parameters can be set automatically, or with information directed by AI - find out more in the [AI tool parameters documentation](../../../../advanced-ai/examples/using-the-fromai-function/).

- Notification
  - Sends notifications to users or groups

## Templates and examples

**Line Message API : Push Message & Reply**

[View template details](https://n8n.io/workflows/2733-line-message-api-push-message-and-reply/)

**Customer Support Channel and Ticketing System with Slack and Linear**

[View template details](https://n8n.io/workflows/2323-customer-support-channel-and-ticketing-system-with-slack-and-linear/)

**Send daily weather updates via a notification in Line**

[View template details](https://n8n.io/workflows/773-send-daily-weather-updates-via-a-notification-in-line/)

[Browse Line integration templates](https://n8n.io/integrations/line/), or [search all templates](https://n8n.io/workflows/)

## What to do if your operation isn't supported

If this node doesn't support the operation you want to do, you can use the [HTTP Request node](../../core-nodes/n8n-nodes-base.httprequest/) to call the service's API.

You can use the credential you created for this service in the HTTP Request node:

1. In the HTTP Request node, select **Authentication** > **Predefined Credential Type**.
1. Select the service you want to connect to.
1. Select your credential.

Refer to [Custom API operations](../../../custom-operations/) for more information.

---

## Splitting workflows with conditional nodes

**URL:** llms-txt#splitting-workflows-with-conditional-nodes

Splitting uses the [IF](../../integrations/builtin/core-nodes/n8n-nodes-base.if/) or [Switch](../../integrations/builtin/core-nodes/n8n-nodes-base.switch/) nodes. It turns a single-branch workflow into a multi-branch workflow. This is a key piece of representing complex logic in n8n.

Compare these workflows:

This is the power of splitting and conditional nodes in n8n.

Refer to the [IF](../../integrations/builtin/core-nodes/n8n-nodes-base.if/) or [Switch](../../integrations/builtin/core-nodes/n8n-nodes-base.switch/) documentation for usage details.

---

## User management SMTP, and two-factor authentication environment variables

**URL:** llms-txt#user-management-smtp,-and-two-factor-authentication-environment-variables

File-based configuration

You can add `_FILE` to individual variables to provide their configuration in a separate file. Refer to [Keeping sensitive data in separate files](../../configuration-methods/#keeping-sensitive-data-in-separate-files) for more details.

Refer to [User management](../../user-management-self-hosted/) for more information on setting up user management and emails.

| Variable                                        | Type    | Default | Description                                                                                                                                                                                                                                                          |
| ----------------------------------------------- | ------- | ------- | -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| `N8N_EMAIL_MODE`                                | String  | `smtp`  | Enable emails.                                                                                                                                                                                                                                                       |
| `N8N_SMTP_HOST`                                 | String  | -       | *your_SMTP_server_name*                                                                                                                                                                                                                                              |
| `N8N_SMTP_PORT`                                 | Number  | -       | *your_SMTP_server_port*                                                                                                                                                                                                                                              |
| `N8N_SMTP_USER`                                 | String  | -       | *your_SMTP_username*                                                                                                                                                                                                                                                 |
| `N8N_SMTP_PASS`                                 | String  | -       | *your_SMTP_password*                                                                                                                                                                                                                                                 |
| `N8N_SMTP_OAUTH_SERVICE_CLIENT`                 | String  | -       | If using 2LO with a service account this is your client ID                                                                                                                                                                                                           |
| `N8N_SMTP_OAUTH_PRIVATE_KEY`                    | String  | -       | If using 2LO with a service account this is your private key                                                                                                                                                                                                         |
| `N8N_SMTP_SENDER`                               | String  | -       | Sender email address. You can optionally include the sender name. Example with name: *N8N `<contact@n8n.com>`*                                                                                                                                                       |
| `N8N_SMTP_SSL`                                  | Boolean | `true`  | Whether to use SSL for SMTP (true) or not (false).                                                                                                                                                                                                                   |
| `N8N_SMTP_STARTTLS`                             | Boolean | `true`  | Whether to use STARTTLS for SMTP (true) or not (false).                                                                                                                                                                                                              |
| `N8N_UM_EMAIL_TEMPLATES_INVITE`                 | String  | -       | Full path to your HTML email template. This overrides the default template for invite emails.                                                                                                                                                                        |
| `N8N_UM_EMAIL_TEMPLATES_PWRESET`                | String  | -       | Full path to your HTML email template. This overrides the default template for password reset emails.                                                                                                                                                                |
| `N8N_UM_EMAIL_TEMPLATES_WORKFLOW_SHARED`        | String  | -       | Overrides the default HTML template for notifying users that a workflow was shared. Provide the full path to the template.                                                                                                                                           |
| `N8N_UM_EMAIL_TEMPLATES_CREDENTIALS_SHARED`     | String  | -       | Overrides the default HTML template for notifying users that a credential was shared. Provide the full path to the template.                                                                                                                                         |
| `N8N_UM_EMAIL_TEMPLATES_PROJECT_SHARED`         | String  | -       | Overrides the default HTML template for notifying users that a project was shared. Provide the full path to the template.                                                                                                                                            |
| `N8N_USER_MANAGEMENT_JWT_SECRET`                | String  | -       | Set a specific JWT secret. By default, n8n generates one on start.                                                                                                                                                                                                   |
| `N8N_USER_MANAGEMENT_JWT_DURATION_HOURS`        | Number  | 168     | Set an expiration date for the JWTs in hours.                                                                                                                                                                                                                        |
| `N8N_USER_MANAGEMENT_JWT_REFRESH_TIMEOUT_HOURS` | Number  | 0       | How many hours before the JWT expires to automatically refresh it. 0 means 25% of `N8N_USER_MANAGEMENT_JWT_DURATION_HOURS`. -1 means it will never refresh, which forces users to log in again after the period defined in `N8N_USER_MANAGEMENT_JWT_DURATION_HOURS`. |
| `N8N_MFA_ENABLED`                               | Boolean | `true`  | Whether to enable two-factor authentication (true) or disable (false). n8n ignores this if existing users have 2FA enabled.                                                                                                                                          |
| `N8N_INVITE_LINKS_EMAIL_ONLY`                   | Boolean | `false` | When set to true, n8n will only deliver invite links via email and will not expose them through the API. This option enhances security by preventing invite URLs from being accessible programmatically, or to high priviledged users.                               |

---

## WhatsApp Business Cloud node

**URL:** llms-txt#whatsapp-business-cloud-node

**Contents:**
- Operations
- Waiting for a response
  - Response Type
  - Approval response customization
  - Free Text response customization
  - Custom Form response customization
- Templates and examples
- Related resources
- Common issues
- What to do if your operation isn't supported

Use the WhatsApp Business Cloud node to automate work in WhatsApp Business, and integrate WhatsApp Business with other applications. n8n has built-in support for a wide range of WhatsApp Business features, including sending messages, and uploading, downloading, and deleting media.

On this page, you'll find a list of operations the WhatsApp Business Cloud node supports and links to more resources.

Refer to [WhatsApp Business Cloud credentials](../../credentials/whatsapp/) for guidance on setting up authentication.

- Message
  - Send
  - Send and Wait for Response
  - Send Template
- Media
  - Upload
  - Download
  - Delete

## Waiting for a response

By choosing the **Send and Wait for a Response** operation, you can send a message and pause the workflow execution until a person confirms the action or provides more information.

You can choose between the following types of waiting and approval actions:

- **Approval**: Users can approve or disapprove from within the message.
- **Free Text**: Users can submit a response with a form.
- **Custom Form**: Users can submit a response with a custom form.

You can customize the waiting and response behavior depending on which response type you choose. You can configure these options in any of the above response types:

- **Limit Wait Time**: Whether the workflow will automatically resume execution after a specified time limit. This can be an interval or a specific wall time.
- **Append n8n Attribution**: Whether to mention in the message that it was sent automatically with n8n (turned on) or not (turned off).

### Approval response customization

When using the Approval response type, you can choose whether to present only an approval button or both approval *and* disapproval buttons.

You can also customize the button labels for the buttons you include.

### Free Text response customization

When using the Free Text response type, you can customize the message button label, the form title and description, and the response button label.

### Custom Form response customization

When using the Custom Form response type, you build a form using the fields and options you want.

You can customize each form element with the settings outlined in the [n8n Form trigger's form elements](../../core-nodes/n8n-nodes-base.formtrigger/#form-elements). To add more fields, select the **Add Form Element** button.

You'll also be able to customize the message button label, the form title and description, and the response button label.

## Templates and examples

**Building Your First WhatsApp Chatbot**

[View template details](https://n8n.io/workflows/2465-building-your-first-whatsapp-chatbot/)

**Respond to WhatsApp Messages with AI Like a Pro!**

[View template details](https://n8n.io/workflows/2466-respond-to-whatsapp-messages-with-ai-like-a-pro/)

**AI-Powered WhatsApp Chatbot 🤖📲 for Text, Voice, Images & PDFs with memory 🧠**

[View template details](https://n8n.io/workflows/3586-ai-powered-whatsapp-chatbot-for-text-voice-images-and-pdfs-with-memory/)

[Browse WhatsApp Business Cloud integration templates](https://n8n.io/integrations/whatsapp-business-cloud/), or [search all templates](https://n8n.io/workflows/)

Refer to [WhatsApp Business Platform's Cloud API documentation](https://developers.facebook.com/docs/whatsapp/cloud-api) for details about the operations.

For common errors or issues and suggested resolution steps, refer to [Common Issues](common-issues/).

## What to do if your operation isn't supported

If this node doesn't support the operation you want to do, you can use the [HTTP Request node](../../core-nodes/n8n-nodes-base.httprequest/) to call the service's API.

You can use the credential you created for this service in the HTTP Request node:

1. In the HTTP Request node, select **Authentication** > **Predefined Credential Type**.
1. Select the service you want to connect to.
1. Select your credential.

Refer to [Custom API operations](../../../custom-operations/) for more information.

---

## Strapi node

**URL:** llms-txt#strapi-node

**Contents:**
- Operations
- Templates and examples
- Related resources
- What to do if your operation isn't supported

Use the Strapi node to automate work in Strapi, and integrate Strapi with other applications. n8n has built-in support for a wide range of Strapi features, including creating and deleting entries.

On this page, you'll find a list of operations the Strapi node supports and links to more resources.

Refer to [Strapi credentials](../../credentials/strapi/) for guidance on setting up authentication.

- Entry
  - Create
  - Delete
  - Get
  - Get Many
  - Update

## Templates and examples

**Enrich FAQ sections on your website pages at scale with AI**

[View template details](https://n8n.io/workflows/2434-enrich-faq-sections-on-your-website-pages-at-scale-with-ai/)

**Create, update, and get an entry in Strapi**

[View template details](https://n8n.io/workflows/779-create-update-and-get-an-entry-in-strapi/)

**Automate testimonials in Strapi with n8n**

[View template details](https://n8n.io/workflows/1535-automate-testimonials-in-strapi-with-n8n/)

[Browse Strapi integration templates](https://n8n.io/integrations/strapi/), or [search all templates](https://n8n.io/workflows/)

Refer to [Strapi's documentation](https://docs.strapi.io/dev-docs/api/rest) for more information about the service.

## What to do if your operation isn't supported

If this node doesn't support the operation you want to do, you can use the [HTTP Request node](../../core-nodes/n8n-nodes-base.httprequest/) to call the service's API.

You can use the credential you created for this service in the HTTP Request node:

1. In the HTTP Request node, select **Authentication** > **Predefined Credential Type**.
1. Select the service you want to connect to.
1. Select your credential.

Refer to [Custom API operations](../../../custom-operations/) for more information.

---

## Using an API playground

**URL:** llms-txt#using-an-api-playground

**Contents:**
- Documentation playground
- Built-in playground

This documentation site provides a playground to test out calls. Self-hosted users also have access to a built-in playground hosted as part of their instance.

## Documentation playground

You can test API calls from this site's [API reference](../api-reference/). You need to set your server's base URL and instance name, and add an API key.

n8n uses [Scalar's](https://github.com/scalar/scalar) open source API platform to power this functionality.

Exposed API key and data

Use a test API key with limited scopes and test data when using a playground. All calls from the playground are routed through Scalar's proxy servers.

You have access to your live data. This is useful for trying out requests. Be aware you can change or delete real data.

## Built-in playground

The API playground isn't available on Cloud. It's available for all self-hosted pricing tiers.

The n8n API comes with a built-in Swagger UI playground in self-hosted versions. This provides interactive documentation, where you can try out requests. The path to access the playground depends on your hosting.

n8n constructs the path from values set in your environment variables:

The API version number is `1`. There may be multiple versions available in the future.

If you select **Authorize** and enter your API key in the API playground, you have access to your live data. This is useful for trying out requests. Be aware you can change or delete real data.

The API includes built-in documentation about credential formats. This is available using the `credentials` endpoint:

How to find `credentialTypeName`

To find the type, download your workflow as JSON and examine it. For example, for a Google Drive node the `{credentialTypeName}` is `googleDriveOAuth2Api`:

**Examples:**

Example 1 (unknown):
```unknown
N8N_HOST:N8N_PORT/N8N_PATH/api/v<api-version-number>/docs
```

Example 2 (unknown):
```unknown
N8N_HOST:N8N_PORT/N8N_PATH/api/v<api-version-number>/credentials/schema/{credentialTypeName}
```

Example 3 (unknown):
```unknown
{
    ...,
    "credentials": {
        "googleDriveOAuth2Api": {
        "id": "9",
        "name": "Google Drive"
        }
    }
}
```

---

## Choose your node building approach

**URL:** llms-txt#choose-your-node-building-approach

**Contents:**
- Data handling differences
- Syntax differences

n8n has two node-building styles, declarative and programmatic.

You should use the declarative style for most nodes. This style:

- Uses a JSON-based syntax, making it simpler to write, with less risk of introducing bugs.
- Is more future-proof.
- Supports integration with REST APIs.

The programmatic style is more verbose. You must use the programmatic style for:

- Trigger nodes
- Any node that isn't REST-based. This includes nodes that need to call a GraphQL API and nodes that use external dependencies.
- Any node that needs to transform incoming data.
- Full versioning. Refer to [Node versioning](../../build/reference/node-versioning/) for more information on types of versioning.

## Data handling differences

The main difference between the declarative and programmatic styles is how they handle incoming data and build API requests. The programmatic style requires an `execute()` method, which reads incoming data and parameters, then builds a request. The declarative style handles this using the `routing` key in the `operations` object. Refer to [Node base file](../../build/reference/node-base-files/) for more information on node parameters and the `execute()` method.

## Syntax differences

To understand the difference between the declarative and programmatic styles, compare the two code snippets below. This example creates a simplified version of the SendGrid integration, called "FriendGrid." The following code snippets aren't complete: they emphasize the differences in the node building styles.

In programmatic style:

In declarative style:

**Examples:**

Example 1 (unknown):
```unknown
import {
	IExecuteFunctions,
	INodeExecutionData,
	INodeType,
	INodeTypeDescription,
	IRequestOptions,
} from 'n8n-workflow';

// Create the FriendGrid class
export class FriendGrid implements INodeType {
  description: INodeTypeDescription = {
    displayName: 'FriendGrid',
    name: 'friendGrid',
    . . .
    properties: [
      {
        displayName: 'Resource',
        . . .
      },
      {
        displayName: 'Operation',
        name: 'operation',
        type: 'options',
        displayOptions: {
          show: {
              resource: [
              'contact',
              ],
          },
        },
        options: [
          {
            name: 'Create',
            value: 'create',
            description: 'Create a contact',
          },
        ],
        default: 'create',
        description: 'The operation to perform.',
      },
      {
        displayName: 'Email',
        name: 'email',
        . . .
      },
      {
        displayName: 'Additional Fields',
        // Sets up optional fields
      },
    ],
};

  async execute(this: IExecuteFunctions): Promise<INodeExecutionData[][]> {
    let responseData;
    const resource = this.getNodeParameter('resource', 0) as string;
    const operation = this.getNodeParameter('operation', 0) as string;
    //Get credentials the user provided for this node
    const credentials = await this.getCredentials('friendGridApi') as IDataObject;

    if (resource === 'contact') {
      if (operation === 'create') {
      // Get email input
      const email = this.getNodeParameter('email', 0) as string;
      // Get additional fields input
      const additionalFields = this.getNodeParameter('additionalFields', 0) as IDataObject;
      const data: IDataObject = {
          email,
      };

      Object.assign(data, additionalFields);

      // Make HTTP request as defined in https://sendgrid.com/docs/api-reference/
      const options: IRequestOptions = {
        headers: {
            'Accept': 'application/json',
            'Authorization': `Bearer ${credentials.apiKey}`,
        },
        method: 'PUT',
        body: {
            contacts: [
            data,
            ],
        },
        url: `https://api.sendgrid.com/v3/marketing/contacts`,
        json: true,
      };
      responseData = await this.helpers.httpRequest(options);
      }
    }
    // Map data to n8n data
    return [this.helpers.returnJsonArray(responseData)];
  }
}
```

Example 2 (unknown):
```unknown
import { INodeType, INodeTypeDescription } from 'n8n-workflow';

// Create the FriendGrid class
export class FriendGrid implements INodeType {
  description: INodeTypeDescription = {
    displayName: 'FriendGrid',
    name: 'friendGrid',
    . . .
    // Set up the basic request configuration
    requestDefaults: {
      baseURL: 'https://api.sendgrid.com/v3/marketing'
    },
    properties: [
      {
        displayName: 'Resource',
        . . .
      },
      {
        displayName: 'Operation',
        name: 'operation',
        type: 'options',
        displayOptions: {
          show: {
            resource: [
              'contact',
            ],
          },
        },
        options: [
          {
            name: 'Create',
            value: 'create',
            description: 'Create a contact',
            // Add the routing object
            routing: {
              request: {
                method: 'POST',
                url: '=/contacts',
                send: {
                  type: 'body',
                  properties: {
                    email: {{$parameter["email"]}}
                  }
                }
              }
            },
            // Handle the response to contact creation
            output: {
              postReceive: [
                {
                  type: 'set',
                  properties: {
                    value: '={{ { "success": $response } }}'
                  }
                }
              ]
            }
          },
        ],
        default: 'create',
        description: 'The operation to perform.',
      },
      {
        displayName: 'Email',
        . . .
      },
      {
        displayName: 'Additional Fields',
        // Sets up optional fields
      },
    ],
  }
  // No execute method needed
}
```

---

## Workflow management in Embed

**URL:** llms-txt#workflow-management-in-embed

**Contents:**
- Workflow per user
  - 1. Obtain user credentials
  - 2. Create user credentials
  - 3. Create the workflow
- Single workflow
  - Create the workflow
  - Call the workflow

Embed requires an embed license. For more information about when to use Embed, as well as costs and licensing processes, refer to [Embed](https://n8n.io/embed/) on the n8n website.

When managing an embedded n8n deployment, spanning across teams or organizations, you will likely need to run the same (or similar) workflows for multiple users. There are two available options for doing so:

| Solution                                                              | Pros                                                               | Cons                                           |
| --------------------------------------------------------------------- | ------------------------------------------------------------------ | ---------------------------------------------- |
| Create a workflow for each user                                       | No limitation on how workflow starts (can use any trigger)         | Requires managing multiple workflows.          |
| Create a single workflow, and pass it user credentials when executing | Simplified workflow management (only need to change one workflow). | To run the workflow, your product must call it |

The APIs referenced in this document are subject to change at any time. Be sure the check for continued functionality with each version upgrade.

There are three general steps to follow:

- Obtain the credentials for each user, and any additional parameters that may be required based on the workflow.
- Create the [n8n credentials](../../glossary/#credential-n8n) for this user.
- Create the workflow.

### 1. Obtain user credentials

Here you need to capture all credentials for any node/service this user must authenticate with, along with any additional parameters required for the particular workflow. The credentials and any parameters needed will depend on your workflow and what you are trying to do.

### 2. Create user credentials

After all relevant credential details have been obtained, you can proceed to create the relevant service credentials in n8n. This can be done using the Editor UI or API call.

#### Using the Editor UI

1. From the menu select **Credentials** > **New**.
1. Use the drop-down to select the **Credential type** to create, for example *Airtable*.
1. In the **Create New Credentials** modal, enter the corresponding credentials details for the user, and select the nodes that will have access to these credentials.
1. Click **Create** to finish and save.

The frontend API used by the Editor UI can also be called to achieve the same result. The API endpoint is in the format: `https://<n8n-domain>/rest/credentials`.

For example, to create the credentials in the Editor UI example above, the request would be:

With the request body:

The response will contain the ID of the new credentials, which you will use when creating the workflow for this user:

### 3. Create the workflow

Best practice is to have a “base” workflow that you then duplicate and customize for each new user with their credentials (and any other details).

You can duplicate and customize your template workflow using either the Editor UI or API call.

#### Using the Editor UI

1. From the menu select **Workflows** > **Open** to open the template workflow to be duplicated.
1. Select **Workflows** > **Duplicate**, then enter a name for this new workflow and click **Save**.
1. Update all relevant nodes to use the credentials for this user (created above).
1. **Save** this workflow set it to **Active** using the toggle in the top-right corner.

1. Fetch the JSON of the template workflow using the endpoint: `https://<n8n-domain>/rest/workflows/<workflow_id>`

The response will contain the JSON data of the selected workflow:

1. Save the returned JSON data and update any relevant credentials and fields for the new user.

1. Create a new workflow using the updated JSON as the request body at endpoint: `https://<n8n-domain>/rest/workflows`

The response will contain the ID of the new workflow, which you will use in the next step.

1. Lastly, activate the new workflow:

Passing the additional value `active` in your JSON payload:

There are four steps to follow to implement this method:

- Obtain the credentials for each user, and any additional parameters that may be required based on the workflow. See [Obtain user credentials](#1-obtain-user-credentials) above.
- Create the n8n credentials for this user. See [Create user credentials](#2-create-user-credentials) above.
- Create the workflow.
- Call the workflow as needed.

### Create the workflow

The details and scope of this workflow will vary greatly according to the individual use case, however there are a few design implementations to keep in mind:

- This workflow must be triggered by a [Webhook](../../integrations/builtin/core-nodes/n8n-nodes-base.webhook/) node.
- The incoming webhook call must contain the user’s credentials and any other workflow parameters required.
- Each node where the user’s credentials are needed should use an [expression](../../code/expressions/) so that the node’s credential field reads the credential provided in the webhook call.
- Save and activate the workflow, ensuring the production URL is selected for the Webhook node. Refer to [webhook node](../../integrations/builtin/core-nodes/n8n-nodes-base.webhook/) for more information.

### Call the workflow

For each new user, or for any existing user as may be needed, call the webhook defined as the workflow trigger and provide the necessary credentials (and any other workflow parameters).

**Examples:**

Example 1 (unknown):
```unknown
POST https://<n8n-domain>/rest/credentials
```

Example 2 (unknown):
```unknown
{
   "name":"MyAirtable",
   "type":"airtableApi",
   "nodesAccess":[
      {
         "nodeType":"n8n-nodes-base.airtable"
      }
   ],
   "data":{
      "apiKey":"q12we34r5t67yu"
   }
}
```

Example 3 (unknown):
```unknown
{
   "data":{
      "name":"MyAirtable",
      "type":"airtableApi",
      "data":{
         "apiKey":"q12we34r5t67yu"
      },
      "nodesAccess":[
         {
            "nodeType":"n8n-nodes-base.airtable",
            "date":"2021-09-10T07:41:27.770Z"
         }
      ],
      "id":"29",
      "createdAt":"2021-09-10T07:41:27.777Z",
      "updatedAt":"2021-09-10T07:41:27.777Z"
   }
}
```

Example 4 (unknown):
```unknown
GET https://<n8n-domain>/rest/workflows/1012
```

---

## Taiga credentials

**URL:** llms-txt#taiga-credentials

**Contents:**
- Prerequisites
- Supported authentication methods
- Related resources
- Using basic auth

You can use these credentials to authenticate the following nodes:

- [Taiga](../../app-nodes/n8n-nodes-base.taiga/)
- [Taiga Trigger](../../trigger-nodes/n8n-nodes-base.taigatrigger/)

Create a [Taiga](https://taiga.io/) account.

## Supported authentication methods

Refer to [Taiga's API documentation](https://docs.taiga.io/api.html) for more information about the service.

To configure this credential, you'll need:

- A **Username**: Enter your username or user email address. Refer to [Normal login](https://docs.taiga.io/api.html#auth-normal-login) for more information.
- A **Password**: Enter your password.
- The **Environment**: Choose between **Cloud** or **Self-Hosted**. For **Self-Hosted** instances, you'll also need to add:
  - The **URL**: Enter your Taiga URL.

---

## n8n Form node

**URL:** llms-txt#n8n-form-node

**Contents:**
- Setting up the node
  - Set default selections with query parameters
  - Displaying custom HTML
  - Including hidden fields
  - Defining the form using JSON
  - Form Ending
  - Forms with branches
  - Node options
- Running the node
  - Build and test workflows

Use the n8n Form node to create user-facing forms with multiple steps. You can add other nodes with custom logic between to process user input. You must start the workflow with the [n8n Form Trigger node](../n8n-nodes-base.formtrigger/).

[View workflow file](/_workflows/integrations/builtin/core-nodes/n8n-nodes-base.form/mutually-exclusive-branching.json)

## Setting up the node

### Set default selections with query parameters

You can set the initial values for fields by using [query parameters](https://en.wikipedia.org/wiki/Query_string#Web_forms) with the initial URL provided by the [n8n Form Trigger node](../n8n-nodes-base.formtrigger/). Every page in the form receives the same query parameters sent to the n8n Form Trigger node URL.

Query parameters are only available when using the form in production mode. n8n won't populate field values from query parameters in testing mode.

When using query parameters, [percent-encode](https://en.wikipedia.org/wiki/Percent-encoding) any field names or values that use special characters. This ensures n8n uses the initial values for the given fields. You can use tools like [URL Encode/Decode](https://www.url-encode-decode.com/) to format your query parameters using percent-encoding.

As an example, imagine you have a form with the following properties:

- Production URL: `https://my-account.n8n.cloud/form/my-form`
- Fields:
  - `name`: `Jane Doe`
  - `email`: `jane.doe@example.com`

With query parameters and percent-encoding, you could use the following URL to set initial field values to the data above:

Here, percent-encoding replaces the at-symbol (`@`) with the string `%40` and the space character () with the string `%20`. This will set the initial value for these fields no matter which page of the form they appear on.

### Displaying custom HTML

You can display custom HTML on your form by adding a **Custom HTML** field to your form. This provides an **HTML** box where you can insert arbitrary HTML code to display as part of the form page.

You can use the HTML field to enrich your form page by including things like links, images, videos, and more. n8n will render the content with the rest of the form fields in the normal document flow.

Because custom HTML content is read-only, these fields aren't included in the form output data by default. To include the raw HTML content in the node output, provide a name for the data using the **Element Name** field.

The HTML field doesn't support `<script>`, `<style>`, or `<input>` elements.

If you're using the [Form Ending](#form-ending) Page Type, you can fully customize the final page that you send users (including the use of `<script>`, `<style>`, and `<input>` elements) by selecting the **On n8n Form Submission** parameter to **Show Text**.

### Including hidden fields

It's possible to include fields in a form without displaying them to users. This is useful when you want to pass extra data to the form that doesn't require interactive user input.

To add fields that won't show up on the form, use the **Hidden Field** form element. There, you can define the **Field Name** and optionally provide a default value by filling out the **Field Value**.

When serving the form, you can pass values for hidden fields using [query parameters](#set-default-selections-with-query-parameters).

### Defining the form using JSON

Use **Define Form** > **Using JSON** to define the fields of your form with a [JSON array of objects](../../../../data/data-structure/). Each object defines a single field by using a combination of these keys:

- `fieldLabel`: The label that appears above the input field.
- `fieldType`: Choose from `checkbox`, `date`, `dropdown`, `email`, `file`, `hiddenField`, `html`, `number`, `password`, `radio`, `text`, or `textarea`.
  - Use `date` to include a date picker in the form. Refer to [Date and time with Luxon](../../../../code/cookbook/luxon/) for more information on formatting dates.
  - When using `dropdown`, set the choices with `fieldOptions` (reference the example below). By default, the dropdown is single-choice. To make it multiple-choice, set `multiselect` to `true`. As an alternative, you can use `checkbox` or `radio` together with `fieldOptions` too.
  - When using `file`, set `multipleFiles` to `true` to allow users to select more than one file. To define the file types to allow, set `acceptFileTypes` to a string containing a comma-separated list of file extensions (reference the example below).
  - Use `hiddenField` to add a hidden field to your form. Refer to [Including hidden fields](#including-hidden-fields) for more information.
  - Use `html` to display custom HTML on your form. Refer to [Displaying custom HTML](#displaying-custom-html) for more information.
- `placeholder`: Specify placeholder data for the field. You can use this for every `fieldType` except `dropdown`, `date`, and `file`.
- `requiredField`: Require users to complete this field on the form.

An example JSON that shows the general format required and the keys available:

Use the **Form Ending** Page Type to end a form and either show a completion page, redirect the user to a URL, or display custom HTML or text. Only one Form Ending page displays per execution, even when n8n executes [multiple branches](#forms-with-branches) that contain Form Ending nodes.

Choose between these options when using **On n8n Form Submission**:

- **Show Completion Screen**: Shows users a final screen to confirm that they submitted the form.
  - Fill in **Completion Title** to set the `h1` title on the form.
  - n8n displays the **Completion Message** as a subtitle below the main `h1` title on the form. Use `\n` or `<br>` to add a line break.
  - Select **Add option** and fill in **Completion Page Title** to set the page's title in the browser tab.
- **Redirect to URL**: Redirect the user to a specified URL when the form completes.
  - Fill in the **URL** field with the page you want to redirect to when users complete the form.
- **Show Text**: Display a final page defined by arbitrary plain text and HTML.
  - Fill in the **Text** field with the HTML or plain text content you wish to show.
- **Return Binary File**: Return a binary file upon completion.
  - Fill in **Completion Title** to set the `h1` title on the form.
  - n8n displays the **Completion Message** as a subtitle below the main `h1` title on the form. Use `\n` or `<br>` to add a line break.
  - Provide the **Input Data Field Name** containing the binary file to return to the user.

### Forms with branches

The n8n Form node executes and displays its associated form page whenever it receives data from a previous node. When building forms with n8n, to avoid confusion, it's important to understand how forms behave when branching occurs.

#### Workflows with mutually exclusive branches

Form workflows containing mutually exclusive branches work as expected. n8n will execute a single branch according to the submitted data and conditions you outline. As it executes, n8n will display each page in the branch, ending with an n8n Form node with the **Form Ending** page type.

This workflow demonstrates mutually exclusive branching. Each selection can only execute a single branch.

[View workflow file](/_workflows/integrations/builtin/core-nodes/n8n-nodes-base.form/mutually-exclusive-branching.json)

#### Workflows that may execute multiple branches

Form workflows that send data to multiple branches at the same time require more care. When multiple branches receive data during an execution (for example, from a [switch](../n8n-nodes-base.switch/) node), n8n executes each branch that receives data [sequentially](../../../../flow-logic/execution-order/). Upon reaching the end of one branch, the execution will move to the next branch with data.

n8n only executes a single **Form Ending** n8n Form node for each execution. When multiple branches of a form workflow receive data, n8n ignores all Form Ending nodes except for the one associated with the final branch.

This workflow may execute more than one branch during an execution. Here, n8n executes all valid branches sequentially. This impacts which n8n Form nodes n8n executes (in particular, which **Form Ending** node displays):

[View workflow file](/_workflows/integrations/builtin/core-nodes/n8n-nodes-base.form/multiple-branch-execution.json)

Select **Add Option** to view more configuration options:

- **Form Title**: The title for your form. n8n displays the **Form Title** as the webpage title and main `h1` title on the form.
- **Form Description**: The description for your form. n8n displays the **Form Description** as a subtitle below the main `h1` title on the form. This field supports HTML. Use `\n` or `<br>` to add a line break. The Form Description also populates the [HTML meta description](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/meta/name#standard_metadata_names_defined_in_the_html_specification) for the page.
- **Button Label**: The label to use for your form's submit button. n8n displays the **Button Label** as the name of the submit button.
- **Custom Form Styling**: Override the default styling of the public form interface with CSS. The field pre-populates with the default styling so you can change only what you need to.
- **Completion Page Title**: The title for the final completion page of the form.

### Build and test workflows

While building or testing a workflow, use the **Test URL** in the [n8n Form Trigger node](../n8n-nodes-base.formtrigger/). Using a test URL ensures that you can view the incoming data in the editor UI, which is useful for debugging.

There are two ways to test:

- Select **Execute Step**. n8n opens the form. When you submit the form, n8n runs the node and any previous nodes, but not the rest of the workflow.
- Select **Execute Workflow**. n8n opens the form. When you submit the form, n8n runs the workflow.

### Production workflows

When your workflow is ready, switch to using the n8n Form Trigger's **Production URL** by opening the trigger node and selecting the **Production URL** in the **From URLS** selector. You can then activate your workflow, and n8n runs it automatically when a user submits the form.

When working with a production URL, ensure that you have saved and activated the workflow. Data flowing through the Form trigger isn't visible in the editor UI with the production URL.

## Templates and examples

**✨🤖Automate Multi-Platform Social Media Content Creation with AI**

[View template details](https://n8n.io/workflows/3066-automate-multi-platform-social-media-content-creation-with-ai/)

**AI-Powered Social Media Content Generator & Publisher**

[View template details](https://n8n.io/workflows/2950-ai-powered-social-media-content-generator-and-publisher/)

**🚀Transform Podcasts into Viral TikTok Clips with Gemini+ Multi-Platform Posting✅**

[View template details](https://n8n.io/workflows/4568-transform-podcasts-into-viral-tiktok-clips-with-gemini-multi-platform-posting/)

[Browse n8n Form integration templates](https://n8n.io/integrations/n8n-form/), or [search all templates](https://n8n.io/workflows/)

**Examples:**

Example 1 (unknown):
```unknown
https://my-account.n8n.cloud/form/my-form?email=jane.doe%40example.com&name=Jane%20Doe
```

Example 2 (unknown):
```unknown
// Use the "requiredField" key on any field to mark it as mandatory
// Use the "placeholder" key to specify placeholder data for all fields
// except 'dropdown', 'date' and 'file'

[
  {
    "fieldLabel": "Date Field",
    "fieldType": "date",
    "formatDate": "mm/dd/yyyy", // how to format received date in n8n
    "requiredField": true
  },
  {
    "fieldLabel": "Dropdown Options",
    "fieldType": "dropdown",
    "fieldOptions": {
      "values": [
        {
          "option": "option 1"
        },
        {
          "option": "option 2"
        }
      ]
    },
    "requiredField": true
  },
  {
    "fieldLabel": "Multiselect",
    "fieldType": "dropdown",
    "fieldOptions": {
      "values": [
        {
          "option": "option 1"
        },
        {
          "option": "option 2"
        }
      ]
    },
    "multiselect": true // setting to true allows multi-select
  },
  {
    "fieldLabel": "Email",
    "fieldType": "email",
    "placeholder": "me@mail.con"
  },
  {
    "fieldLabel": "File",
    "fieldType": "file",
    "multipleFiles": true, // setting to true allows multiple files selection
    "acceptFileTypes": ".jpg, .png" // allowed file types
  },
  {
    "fieldLabel": "Number",
    "fieldType": "number"
  },
  {
    "fieldLabel": "Password",
    "fieldType": "password"
  },
  {
    // "fieldType": "text" can be omitted since it's the default type
    "fieldLabel": "Text"
  },
  {
    "fieldLabel": "Textarea",
    "fieldType": "textarea"
  },
  {
    "fieldType": "html",
    "elementName": "content", // Optional field. It can be used to include the html in the output.
    "html": "<div>Custom element</div>"
  },
  {
    "fieldLabel": "Checkboxes",
    "fieldType": "checkbox",
    "fieldOptions": {
      "values": [
        {
          "option": "option 1"
        },
        {
          "option": "option 2"
        }
      ]
    }
  },
  {
    "fieldLabel": "Radio",
    "fieldType": "radio",
    "fieldOptions": {
      "values": [
        {
          "option": "option 1"
        },
        {
          "option": "option 2"
        }
      ]
    }
  },
  {
    "fieldLabel": "hidden label",
    "fieldType": "hiddenField",
    "fieldValue": "extra form data"
  }
]
```

---

## Cloudflare credentials

**URL:** llms-txt#cloudflare-credentials

**Contents:**
- Prerequisites
- Supported authentication methods
- Related resources
- Using API token

You can use these credentials to authenticate the following nodes:

- [Cloudflare node](../../app-nodes/n8n-nodes-base.cloudflare/)

- Create a [Cloudflare account](https://developers.cloudflare.com/fundamentals/setup/account/).
- [Add a domain](https://developers.cloudflare.com/fundamentals/setup/manage-domains/add-site/).

## Supported authentication methods

Refer to [Cloudflare's API documentation](https://developers.cloudflare.com/fundamentals/api/) for more information about the service.

To configure this credential, you'll need:

- An **API token**: Follow the [Cloudflare documentation to create an API token](https://developers.cloudflare.com/fundamentals/api/get-started/create-token/).

---

## Specify user folder path

**URL:** llms-txt#specify-user-folder-path

n8n saves user-specific data like the encryption key, SQLite database file, and the ID of the tunnel (if used) in the subfolder `.n8n` of the user who started n8n. It's possible to overwrite the user-folder using an environment variable.

Refer to [Environment variables reference](../../environment-variables/deployment/) for more information on this variable.

**Examples:**

Example 1 (unknown):
```unknown
export N8N_USER_FOLDER=/home/jim/n8n
```

---

## Pull latest version

**URL:** llms-txt#pull-latest-version

---

## Release notes

**URL:** llms-txt#release-notes

**Contents:**
- How to update n8n
- Semantic versioning in n8n
- n8n@1.118.2
- n8n@1.119.0
  - Guardrails Node
  - Contributors
- n8n@1.118.1
- n8n@1.117.3
- n8n@1.118.0
- n8n@1.117.2

New features and bug fixes for n8n.

You can also view the [Releases](https://github.com/n8n-io/n8n/releases) in the GitHub repository.

Latest and Next versions

n8n releases a new minor version most weeks. The `latest` version is for production use. `next` is the most recent release. You should treat `next` as a beta: it may be unstable. To report issues, use the [forum](https://community.n8n.io/c/questions/12).

Current `latest`: 1.118.2\
Current `next`: 1.119.0

The steps to update your n8n depend on which n8n platform you use. Refer to the documentation for your n8n:

- [Cloud](../manage-cloud/update-cloud-version/)
- Self-hosted options:
  - [npm](../hosting/installation/npm/)
  - [Docker](../hosting/installation/docker/)

## Semantic versioning in n8n

n8n uses [semantic versioning](https://semver.org/). All version numbers are in the format `MAJOR.MINOR.PATCH`. Version numbers increment as follows:

- MAJOR version when making incompatible changes which can require user action.
- MINOR version when adding functionality in a backward-compatible manner.
- PATCH version when making backward-compatible bug fixes.

You can find the release notes for older versions of n8n [here](0-x/)

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.118.1...n8n@1.118.2) for this version.\
**Release date:** 2025-11-05

This is the `latest` version. n8n recommends using the `latest` version. The `next` version may be unstable. To report issues, use the [forum](https://community.n8n.io/c/questions/12).

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.118.0...n8n@1.119.0) for this version.\
**Release date:** 2025-11-03

This is the `next` version. n8n recommends using the `latest` version. The `next` version may be unstable. To report issues, use the [forum](https://community.n8n.io/c/questions/12).

This release includes multiple bug fixes for AI Agent, task runners, editor, and integrations, as well as new features like improved workflow settings, AWS Assume Role credentials, and enhanced security and audit capabilities.

The Guardrails node provides a set of rules and policies that control an AI agent's behavior by filtering its inputs and outputs. This helps safeguard from malicious input and from generating unsafe or undesirable responses. There are two operations:

- Check Text for Violations: Validate text against a set of policies (e.g. NSFW, prompt injection).
- Sanitize Text: Detects and replaces specific data such as PII, URLs, or secrets with placeholders.

The default presets and prompts are adapted from the open-source [guardrails package](https://github.com/openai/openai-guardrails-js) made available by OpenAI.

For more info, see [Guardrails documentation](../integrations/builtin/core-nodes/n8n-nodes-langchain.guardrails/)

[cesars-gh](https://github.com/cesars-gh)\
[ongdisheng](https://github.com/ongdisheng)

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.118.0...n8n@1.118.1) for this version.\
**Release date:** 2025-10-28

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.117.2...n8n@1.117.3) for this version.\
**Release date:** 2025-10-28

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.117.0...n8n@1.118.0) for this version.\
**Release date:** 2025-10-27

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.117.1...n8n@1.117.2) for this version.\
**Release date:** 2025-10-27

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.117.0...n8n@1.117.1) for this version.\
**Release date:** 2025-10-24

This release contains bug fixes.

### AI Workflow Builder is now available to Enterprise Cloud users.

AI Workflow Builder turns prompts into workflows. Describe what you want to build, and n8n will generate a draft workflow by adding, configuring, and connecting nodes for you. From there, you can refine and expand the workflow directly in the editor.

- Previously available to Starter and Pro users, AI Workflow Builder is now accessible to Enterprise Cloud users as well, with 1,000 monthly credits.
- Supported on n8n version 1.115+. **If you don’t see the feature yet, open /settings/usage to trigger a license refresh.**
- We’ve fixed a bug and now cloud users on v1.117.1 onwards will have access to a more reliable builder.
- We’re currently working on bringing AI Workflow Builder to self-hosted users as well, including Community, Business, and Enterprise.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.116.0...n8n@1.117.0) for this version.\
**Release date:** 2025-10-21

This release contains bug fixes.

[jackfrancismurphy](https://github.com/jackfrancismurphy)\
[JiriDeJonghe](https://github.com/JiriDeJonghe)\
[ramkrishna2910](https://github.com/ramkrishna2910)\
Oracle and/or its affiliates ([sudarshan12s](https://github.com/sudarshan12s))

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.116.1...n8n@1.116.2) for this version.\
**Release date:** 2025-10-21

This release contains a bug fix.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.115.3...n8n@1.115.4) for this version.\
**Release date:** 2025-10-21

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.116.0...n8n@1.116.1) for this version.\
**Release date:** 2025-10-14

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.115.0...n8n@1.116.0) for this version.\
**Release date:** 2025-10-13

This release contains bug fixes.

### Data migration tool

You can now easily migrate n8n data between different database types. This new tooling currently supports SQLite and Postgres, making the transition to a scaling database choice simpler, allowing you to take your data with you.

The tooling comes in the form of two new CLI commands, `export:entities` and `import:entities`

**`Export`** The new export command lets you export data from your existing n8n database (SQLite / Postgres), producing a set of encrypted files within a compressed directory for you to move around and use with the import commands.

For details, see [Export entities](../hosting/cli-commands/#export-entities)

**`Import`** The new import command allows you to read from a compressed and encrypted set of files generated from the new export command, and import them in to your new database of choice (SQLite / Postgres) to be used with your n8n instance.

For details, see [Import entities](../hosting/cli-commands/#import-entities)

[JHTosas](https://github.com/JHTosas)\
[clesecq](https://github.com/clesecq)\
[Gulianrdgd](https://github.com/Gulianrdgd)\
[tishun](https://github.com/tishun)

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.115.0...n8n@1.116.0) for this version.\
**Release date:** 2025-10-13

This release contains bug fixes.

[JHTosas](https://github.com/JHTosas)\
[clesecq](https://github.com/clesecq)\
[Gulianrdgd](https://github.com/Gulianrdgd)\
[tishun](https://github.com/tishun)

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.115.2...n8n@1.115.3) for this version.\
**Release date:** 2025-10-14

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.115.1...n8n@1.115.2) for this version.\
**Release date:** 2025-10-10

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.114.3...n8n@1.114.4) for this version.\
**Release date:** 2025-10-07

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.114.0...n8n@1.115.0) for this version.\
**Release date:** 2025-10-06

This release contains bug fixes.

### AI Workflow Builder (Beta)

**AI Workflow Builder** turns your natural language prompts into working automations. Describe what you want to build, and n8n will generate a draft workflow by adding and configuring nodes and wiring up the logic for you. From there, you can refine, expand, or adjust the workflow directly in the editor.

This feature helps you move from idea to implementation faster and without losing technical control. It’s especially helpful when starting from a blank canvas, validating an approach, or exploring new nodes and capabilities. Multi-turn interaction lets you iterate in conversation, turning your ideas into structured, production-ready workflows step by step.

Learn more about how we we’re building this feature in our [forum post](https://community.n8n.io/t/ai-powered-workflow-building-coming-soon/196499).

[](/_video/release-notes/AI_Workflow_Builder.webm)

- This feature is initially going to be available for Cloud users on the 14-day Trial, Starter and Pro plans.
- Availability for Enterprise users on Cloud will follow in a future update.
- We are actively exploring the best way to bring this feature to self-hosted users.

- To ensure the smoothest experience for all users, this feature will be rolled out to users on version 1.115.0 over the course of a week so you may not have access to the feature immediately when you upgrade to 1.115.0.

**Credit limits by plan:** This feature will have monthly credit limits [by plan](https://n8n.io/pricing/).

- Each prompt/interaction with the AI Workflow Builder consumes one credit.
- Trial users have access to 20 credits, Starter plans have 50 per month and Pro plans will have 150 credits per month.
- At this time, there will not be a way to access additional credits within your plan, however we are we are exploring this.

Learn more about AI Workflow Builder in [documentation](https://docs.n8n.io/advanced-ai/ai-workflow-builder/).

### Source Control: Added HTTPS support

You can now connect to Git repositories via HTTPS in addition to SSH, making Source Control usable in environments where SSH is restricted.

HTTPS is now supported as a connection type in Environments.

[baileympearson](https://github.com/baileympearson)\
[h40huynh](https://github.com/h40huynh)\
[Ankit-69k](https://github.com/Ankit-69k)\
[francisfontoura](https://github.com/francisfontoura)\
[iocanel](https://github.com/iocanel)

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.114.2...n8n@1.114.3) for this version.\
**Release date:** 2025-10-06

This release contains bug fixes.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.114.1...n8n@1.114.2) for this version.\
**Release date:** 2025-10-02

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.114.0...n8n@1.114.1) for this version.\
**Release date:** 2025-10-02

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.113.0...n8n@1.114.0) for this version.\
**Release date:** 2025-09-29

This release contains core updates, editor improvements, project updates, performance improvements, and bug fixes.

[nealzhu3](https://github.com/nealzhu3)

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.113.2...n8n@1.113.3) for this version.\
**Release date:** 2025-09-26

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.112.5...n8n@1.112.6) for this version.\
**Release date:** 2025-09-26

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.113.1...n8n@1.113.2) for this version.\
**Release date:** 2025-09-24

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

### Python task runner

This version introduces the **Python task runner** as a beta feature. This feature secures n8n's Python sandbox and enables users to run real Python modules in n8n workflows. The original Pyodide-based implementation will be phased out.

This is a **breaking change** that replaces Pyodide - see [here](https://docs.n8n.io/integrations/builtin/core-nodes/n8n-nodes-base.code/#python-native-beta) for a list of differences. Any Code node set to the legacy `python` parameter will need to be manually updated to use the new `pythonNative` parameter. Any Code node script set to `python` and relying on Pyodide syntax is likely to need to be manually adjusted to account for breaking changes.

- For self-hosting users, see [here](https://docs.n8n.io/hosting/configuration/task-runners/#setting-up-external-mode) for deployment instructions for task runners going forward and how to install extra dependencies.
- On n8n Cloud, this will be a gradual transition. If in your n8n Cloud instance the Code node offers an option named "Python (Native) (Beta)", then your instance has been transitioned to native Python and you will need to look out for any breaking changes. Imports are disabled for security reasons at this time.

The native Python runner is currently in beta and is subject to change as we find a balance between security and usability. Your feedback is welcome.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.112.4...n8n@1.112.5) for this version.\
**Release date:** 2025-09-24

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.113.0...n8n@1.113.1) for this version.\
**Release date:** 2025-09-23

This release contains bug fixes.

We’re excited to introduce **data tables**, bringing built-in data storage to n8n. You can now store and query structured data directly inside the platform, without relying on external databases for many common automation scenarios. Track workflow state between runs, store tokens or session data, keep product or customer reference tables, or stage intermediate results for multi-step processes.

Previously, persisting data meant provisioning and connecting to an external store such as Redis or Google Sheets. That added credential setup, infrastructure overhead, latency, and constant context switching. **Data tables** eliminate that friction and keeps your data easily editable and close to your workflows.

Data tables are available today on all plans. They currently support numbers, strings, and datetimes with JSON support coming soon. On Cloud, each instance can store up to 50 MB. On self-hosted setups, the default is also 50 MB, but this limit can be adjusted if your infrastructure allows.

[Overview of data tables](https://www.youtube.com/watch?v=ljkiIkt6lZ4)

**Create a data table**

- From the canvas, open the **Create workflow** dropdown and select **Create Data table**.
- Or, go to the **Overview** panel on the left-side navigation bar and open the **Data tables** tab.

**Use a data table in your workflow**

- Add the **Data table node** to your workflow to get, update, insert, upsert, or delete rows.

**Adjust the storage limit** (self-hosted only)

- Change the default 50 MB limit with the environment variable: `N8N_DATA_TABLES_MAX_SIZE_BYTES`. [See configuration docs](https://docs.n8n.io/hosting/configuration/configuration-methods/).

- Data tables don’t currently support foreign keys or default values.
- For now, all data tables are accessible to everyone in a project. More granular permissions and sharing options are planned.

Learn more about [**data tables**](../data/data-tables/) and the [**Data table node**](../integrations/builtin/core-nodes/n8n-nodes-base.datatable/).

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.112.3...n8n@1.112.4) for this version.\
**Release date:** 2025-09-23

This release contains an editor improvement.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.112.0...n8n@1.113.0) for this version.\
**Release date:** 2025-09-22

This release contains core updates, editor improvements, a new node, node updates, and bug fixes.

We’ve made updates to strengthen Single Sign-On (SSO) reliability and security, especially for enterprise and multi-instance setups.

- OIDC and SAML sync in multi-main setups \[version: 1.113.0\]: In multi-main deployments, updates to SSO settings are now synchronized across all instances, ensuring consistent login behavior everywhere.
- Enhanced OIDC integration \[version 1.111.0\]: n8n now supports OIDC providers that enforce state and nonce parameters. These are validated during login, providing smoother and more secure Single Sign-On.

### Filter insights by project

We've added project filtering to insights, enabling more granular reporting and visibility into individual project performance.

[ongdisheng](https://github.com/ongdisheng)

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.112.2...n8n@1.112.3) for this version.\
**Release date:** 2025-09-19

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.111.0...n8n@1.111.1) for this version.\
**Release date:** 2025-09-19

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.110.1...n8n@1.110.2) for this version.\
**Release date:** 2025-09-19

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.112.1...n8n@1.112.2) for this version.\
**Release date:** 2025-09-18

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.112.0...n8n@1.112.1) for this version.\
**Release date:** 2025-09-17

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.111.0...n8n@1.112.0) for this version.\
**Release date:** 2025-09-15

This release contains API improvements, core updates, editor improvements, node updates, and bug fixes.

### Additional API Endpoints versions

We’ve made several updates to the Executions API:

- Execution details: `GET /executions` now includes *status* and *workflow_name* in the response.
- Retry execution endpoint: Added new public API endpoints to retry failed executions.
- Additional filters: You can now filter executions by running or canceled status.

### Enhancements to workflow diff

We added a several updates on workflows diffs as well:

- Better view in Code nodes and Stickies: Workflow diffs now highlight changes per line instead of per block, making edits easier to review and understand.
- Enable/Disable sync: You can now enable or disable sync in the viewport, letting you compare a workflow change in one view without affecting the other.

[GuraaseesSingh](https://github.com/GuraaseesSingh)\
[jabbson](https://github.com/jabbson)\
[ongdisheng](https://github.com/ongdisheng)

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.110.0...n8n@1.111.0) for this version.\
**Release date:** 2025-09-08

This release contains core updates, API improvements, node updates, and bug fixes.

[abellion](https://github.com/abellion)\
[cesars-gh](https://github.com/cesars-gh)\
[durran](https://github.com/durran)

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.110.0...n8n@1.110.1) for this version.\
**Release date:** 2025-09-03

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.109.1...n8n@1.109.2) for this version.\
**Release date:** 2025-09-03

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.109.0...n8n@1.110.0) for this version.\
**Release date:** 2025-09-01

This release contains core updates, editor improvements, node updates, performance improvements, and bug fixes.

[heyxmirko](https://github.com/heyxmirko)

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.109.0...n8n@1.109.1) for this version.\
**Release date:** 2025-08-27

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.108.1...n8n@1.108.2) for this version.\
**Release date:** 2025-08-27

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.108.0...n8n@1.109.0) for this version.\
**Release date:** 2025-08-25

This release contains core updates, editor improvements, node updates, performance improvements, and bug fixes.

[naXa777](https://github.com/naXa777)\
[prettycode2022](https://github.com/prettycode2022)\
[oppai](https://github.com/oppai)

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.107.3...n8n@1.107.4) for this version.\
**Release date:** 2025-08-20

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.108.0...n8n@1.108.1) for this version.\
**Release date:** 2025-08-20

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.107.2...n8n@1.107.3) for this version.\
**Release date:** 2025-08-18

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.107.0...n8n@1.108.0) for this version.\
**Release date:** 2025-08-18

This release contains a new CLI tool, editor improvements, node updates, performance improvements, and bug fixes.

For teams working across different environments, deployments often involve multiple people making changes at different times. Without a clear view of those changes, it’s easy to miss something important.

[Workflow Diff](../source-control-environments/using/compare-changes/) gives you an easy and visual way to review workflow changes before you deploy them between environments.

- Quickly see what’s been added, changed, or deleted, with clear colour highlights.
- Easily see important settings changes on a workflow.
- Check changes inside each node, and spot connector updates, with a side-by-side view of its settings.
- Get a quick count of all changes to understand the size of a deployment.

Workflow Diff eases the review and approval of changes before deployment, enabling teams to collaborate on workflows without breaking existing automations or disrupting production. It’s one step further in integrating DevOps best practices in n8n.

Now available for Enterprise customers using Environments.

[ManuLasker](https://github.com/ManuLasker)\
[EternalDeiwos](https://github.com/EternalDeiwos)\
[jreyesr](https://github.com/jreyesr)

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.107.1...n8n@1.107.2) for this version.\
**Release date:** 2025-08-15

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.107.0...n8n@1.107.1) for this version.\
**Release date:** 2025-08-14

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.106.2...n8n@1.106.3) for this version.\
**Release date:** 2025-08-11

This release contains a backported update.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.106.0...n8n@1.107.0) for this version.\
**Release date:** 2025-08-11

This release contains bug fixes.

[Amsal1](https://github.com/Amsal1)\
[andrewzolotukhin](https://github.com/andrewzolotukhin)\
[DMA902](https://github.com/DMA902)\
[fkowal](https://github.com/fkowal)\
[Gulianrdgd](https://github.com/Gulianrdgd)

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.106.1...n8n@1.106.2) for this version.\
**Release date:** 2025-08-08

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.106.0...n8n@1.106.1) for this version.\
**Release date:** 2025-08-07

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.105.3...n8n@1.105.4) for this version.\
**Release date:** 2025-08-07

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.105.2...n8n@1.105.3) for this version.\
**Release date:** 2025-08-05

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.105.0...n8n@1.106.0) for this version.\
**Release date:** 2025-08-04

This release contains performance improvements, core updates, editor improvements, node updates, a new node, and bug fixes.

### **No more limit of active workflows and new self-hosted Business Plan**

We have rolled out a new pricing model to make it easier for builders of all sizes to adopt and scale automation with n8n.

**No more limit of active workflows.**

All n8n plans, from Starter to Enterprise, now include unlimited users, workflows, and steps. Our pricing is based on the volume of executions. Meaning you can build and test as many workflows as you want, including complex, data-heavy, or long-running automations, without worrying about quotas.

**New self-hosted Business Plan for growing teams**

Designed for SMBs and mid-sized companies, the Business Plan includes features such as:

- 6 shared projects
- SSO, SAML and LDAP
- Different environments
- Global variables
- Version control using Git
- 30 days of Insights

Please note that this plan only includes support from our community forum. For dedicated support we recommend upgrading to our Enterprise plan.

**Enterprise pricing now scales with executions**

Enterprise plans no longer use workflow-based pricing, and is now also based on the volume of executions.

***What you need to do***

To ensure these changes apply to your account, update your n8n instance to the latest version.

[Read the blog](https://blog.n8n.io/build-without-limits-everything-you-need-to-know-about-n8ns-new-pricing/) for full details.

[baruchiro](https://github.com/baruchiro)\
[killthekitten](https://github.com/killthekitten)\
[baileympearson](https://github.com/baileympearson)\
[Yingrjimsch](https://github.com/Yingrjimsch)\
[joshualipman123](https://github.com/joshualipman123)

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.105.1...n8n@1.105.2) for this version.\
**Release date:** 2025-08-01

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.105.0...n8n@1.105.1) for this version.\
**Release date:** 2025-08-01

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.104.1...n8n@1.104.2) for this version.\
**Release date:** 2025-07-31

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.104.0...n8n@1.105.0) for this version.\
**Release date:** 2025-07-28

This release contains core updates, editor improvements, node updates, and bug fixes.

### **Respond to Chat node**

With the [\*\*Respond to Chat](../integrations/builtin/core-nodes/n8n-nodes-langchain.respondtochat/) node\*\*, you can now access Human-in-the-Loop functionality natively in n8n Chat.

Enable conversational experiences where you can ask for clarification, request approval before taking further action, and get back intermediate results — all within a single workflow execution.

This unlocks multi-turn interactions that feel more natural and reduce the number of executions required. It is ideal for building interactive AI use cases like conversational forms, branched workflows based on user replies, and step-by-step approvals.

- Add a **Chat Trigger** node and select **Using Respond Nodes** for the **Response mode**
- Place the **Respond to Chat** node anywhere in your workflow to send a message into the Chat and optionally wait for the user to input a response before continuing execution of the workflow steps.

[](/_video/release-notes/Respond-to-chat.webm)

[dana-gill](https://github.com/dana-gill)

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.104.0...n8n@1.104.1) for this version.\
**Release date:** 2025-07-23

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.103.1...n8n@1.103.2) for this version.\
**Release date:** 2025-07-22

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.103.0...n8n@1.104.0) for this version.\
**Release date:** 2025-07-21

This release contains core updates, editor improvements, a new node, node updates, and bug fixes.

[nunulk](https://github.com/nunulk)\
[iaptsiauri](https://github.com/iaptsiauri)\
[KGuillaume-chaps](https://github.com/KGuillaume-chaps)

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.101.2...n8n@1.101.3) for this version.\
**Release date:** 2025-07-18

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.102.3...n8n@1.102.4) for this version.\
**Release date:** 2025-07-17

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.103.0...n8n@1.103.1) for this version.\
**Release date:** 2025-07-17

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.102.2...n8n@1.102.3) for this version.\
**Release date:** 2025-07-14

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.102.0...n8n@1.103.0) for this version.\
**Release date:** 2025-07-14

This release contains core updates, editor improvements, new nodes, node improvements, and bug fixes.

### **Chat streaming**

No more waiting for full responses to load when using the n8n chat interface. **Streaming** now delivers AI-generated text replies word by word so users can read messages as they’re being generated. It feels faster, smoother, and more like what people expect from chat experiences.

Streaming is available in public chat views (hosted or embedded) and can be used in custom apps via webhook.

Configure streaming in the Node Details View of these nodes:

- Chat Trigger node: Options>Add Field>Response Mode>Streaming
- Webhook node: Respond>Streaming
- AI Agent node: Add option> Enable streaming

[](/_video/release-notes/streaming.webm)

### Improved instance user list with more visibility

The instance user list has been updated with a new table layout and additional details to help admins manage access more easily.

- See total users and filter by name or email
- View which projects each user has access to
- Whether a user has enabled 2FA and sort based on that
- See the last active date for each user

This makes it easier to audit user activity, identify inactive accounts, and understand how access is distributed across your instance.

### Webhook HTML responses

Starting with this release, if your workflow sends an HTML response to a webhook, n8n automatically wraps the content in an `<iframe>`. This is a security mechanism to protect the instance users.

This has the following implications:

- HTML renders in a sandboxed iframe instead of directly in the parent document.
- JavaScript code that attempts to access the top-level window or local storage will fail.
- Authentication headers aren't available in the sandboxed iframe (for example, basic auth). You need to use an alternative approach, like embedding a short-lived access token within the HTML.
- Relative URLs (for example, `<form action="/">`) won't work. Use absolute URLs instead.

### Built-in Metrics for AI Evaluations

Using evaluations is a best practice for any AI solution, and a must if reliability and predictability are business-critical. With this release, we’ve made it easier to set up evaluations in n8n by introducing a set of built-in metrics. These metrics can review AI responses and assign scores based on factors like correctness, helpfulness, and more.

You can run regular evaluations and review scores over time as a way to monitor your AI workflow's performance. You can also compare results across different models to help guide model selection, or run evaluations before and after a prompt change to support data-driven, iterative building.

As with all evaluations in n8n, you’ll need a dataset that includes the inputs you want to test. For some evaluations, the dataset must also include expected outputs (ground truth) to compare against. The evaluation workflow runs each input through the portion you're testing to generate a response. The built-in metric scores each response based on the aspect you're measuring, allowing you to compare results before and after changes or track trends over time in the Evaluations tab.

You can still define your own custom metrics, but for common use cases, the built-in options make it much faster to implement.

1. Set up your evaluation as described [here](../advanced-ai/evaluations/metric-based-evaluations/#how-it-works), using an **Evaluation** node as the trigger and another with the **Set Metrics** operation.
1. In the **Set Metrics** node, choose a metric from the dropdown list.
1. Define any additional parameters required for your selected metric. In most cases, this includes mapping the dataset columns to the appropriate fields.

📏 **Available built-in metrics:**

- **Correctness (AI-based):** Compares AI workflow-generated responses to expected answers. Another LLM acts as a judge, scoring the responses based on guidance you provide in the prompt.
- **Helpfulness (AI-based):** Evaluates how helpful a response is in relation to a user query, using an LLM and prompt-defined scoring criteria.
- **String Similarity:** Measures how closely the response matches the expected output by comparing strings. Useful for command generation or when output needs to follow a specific structure.
- **Categorization:** Checks whether a response matches an expected label, such as assigning items to the correct category.
- **Tools Used:** Verifies whether the AI agent called the tools you specified in your dataset. To enable this, make sure **Return Intermediate Steps** is turned on in your agent so the evaluation can access the tools it actually called.

- Registered Community Edition enables analysis of one evaluation in the **Evaluations** tab which allows easy comparison of evaluation runs over time. Pro and Enterprise plans allow unlimited evaluations in the **Evaluations** tab.

[Learn more](../advanced-ai/evaluations/overview/) about setting up and customizing evaluations.

### AI Agent Tool node

With the **AI Agent Tool** node we are introducing a simplified pattern for multi-agent orchestration that can be run in a single execution and stay entirely on one canvas. You can now connect multiple **AI Agent Tool** nodes to a primary **AI Agent** node, allowing it to supervise and delegate work across other specialized agents.

This setup is especially useful for building complex systems that function like real-world teams, where a lead agent assigns parts of a task to specialists. You can even add multiple layers of agents directing other agents, just like you would have in a real multi-tiered organizational structure. It also helps with prompt management by letting you split long, complex instructions into smaller, focused tasks across multiple agents. While similar orchestration was already possible using sub-workflows, AI Agent Tool nodes are a good choice when you want the interaction to happen within a single execution or prefer to manage and debug everything from a single canvas.

- Add an **AI Agent** node to your workflow and click **+** to create a Tools connection.
- Search for and select the **AI Agent Tool** node from the Nodes Panel.
- Name the node clearly so the primary agent can reference it, then add a short description and prompt.
- Connect any LLMs, memory, and tools the agent needs to perform its role.
- Instruct the primary **AI Agent** on when to use the **AI Agent Tool** and to pass along relevant context in its prompt.

- The orchestrating agent does not pass full execution context by default. Any necessary context must be included in the prompt.

**AI Agent Tool** nodes makes it easier to build layered, agent-to-agent workflows without relying on sub-workflows, helping you move faster when building and debugging multi-agent systems.

[ksg97031](https://github.com/ksg97031)\
[israelshenkar](https://github.com/israelshenkar)

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.102.1...n8n@1.102.2) for this version.\
**Release date:** 2025-07-11

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.101.1...n8n@1.101.2) for this version.\
**Release date:** 2025-07-11

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.102.0...n8n@1.102.1) for this version.\
**Release date:** 2025-07-09

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.101.0...n8n@1.102.0) for this version.\
**Release date:** 2025-07-07

This release contains core updates, editor improvements, new nodes, node updates, and bug fixes.

### Enforce 2FA across your instance

Enterprise Instance owners can now enforce two-factor authentication (2FA) for all users in their instance.

Once enabled, any user who hasn’t set up 2FA will be redirected to complete the setup before they can continue using n8n. This helps organizations meet internal security policies and ensures stronger protection across the workspace.

This feature is available only on the Enterprise plan.

[marty-sullivan](https://github.com/marty-sullivan)\
[cesars-gh](https://github.com/cesars-gh)\
[dudanogueira](https://github.com/dudanogueira)

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.101.0...n8n@1.101.1) for this version.\
**Release date:** 2025-07-03

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.100.0...n8n@1.101.0) for this version.\
**Release date:** 2025-06-30

This release contains core updates, editor improvements, node updates, and bug fixes.

[luka-mimi](https://github.com/luka-mimi)

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.100.0...n8n@1.100.1) for this version.\
**Release date:** 2025-06-25

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.99.0...n8n@1.100.0) for this version.\
**Release date:** 2025-06-23

This release contains core updates, editor improvements, a new node, node updates, and bug fixes.

### Model Selector node

The [Model Selector node](../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.modelselector/) gives you more control when working with multiple LLMs in your workflows.

Use it to determine which connected model should handle a given input, based on conditions like expressions or global variables. This makes it easier to implement model routing strategies, such as switching models based on performance, task type, cost, or availability.

🛠️ **How to:** Connect multiple model nodes to the Model Selector node, then configure routing conditions in the node’s settings.

- Rules are evaluated in order. The first matching rule determines which model is used even if others would also match.
- As a sub-node, expressions behave differently here: they always resolves to the first item rather than resolving for each item in turn.

The Model Selector node is especially useful in evaluation or production scenarios where routing logic between models needs to adapt based on performance, cost, availability, or dataset-specific needs.

### Support for OIDC (OpenID Connect) authentication

You can now use OIDC (OpenID Connect) as an authentication method for Single Sign-On (SSO).

This gives enterprise teams more flexibility to integrate n8n with their existing identity providers using a widely adopted and easy-to-manage standard. OIDC is now available alongside SAML, giving Enterprises the choice to select what best fits their internal needs.

### Project admins can now commit to Git within environments

Project admins now have the ability to commit workflow and credential changes directly to Git through the environments feature. This update streamlines the workflow deployment process by giving project-level admins direct control over committing their changes. It also ensures that the those who know their workflows best can review and commit updates themselves, without needing to involve instance-level admins.

[Learn more about source control environments](../source-control-environments/)

[aliou](https://github.com/aliou)

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.99.0...n8n@1.99.1) for this version.\
**Release date:** 2025-06-19

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.98.1...n8n@1.98.2) for this version.\
**Release date:** 2025-06-18

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.98.0...n8n@1.99.0) for this version.\
**Release date:** 2025-06-16

This release contains performance improvements, core updates, editor changes, node updates, and bug fixes.

### Automatically name nodes

Default node names now update automatically based on the resource and operation selected, so you’ll always know what a node does at a glance.

This adds clarity to your canvas and saves time renaming nodes manually.

Don’t worry, automatic naming won’t break references. And, and if you’ve renamed a node yourself, we’ll leave it just the way you wrote it.

[](/_video/release-notes/automatic_node_naming.mp4)

### Support for RAG extended with built-in templates

Retrieval-Augmented Generation (RAG) can improve AI responses by providing language models access to data sources with up-to-date, domain-specific, or proprietary knowledge. RAG workflows typically rely on vector stores to manage and search this data efficiently.

To get the benefits of using vector stores, such as returning results based on semantic meaning rather than just keyword matches, you need a way to upload your data to the vector store and a way to query it.

In n8n, uploading and querying vectors stores happens in two workflows. Now, you have an example to get your started and make implementation easier with the **RAG starter template**.

- The **Load Data** workflow shows how to add data with the appropriate embedding model, split it into chunks with the [Default Data Loader](../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.documentdefaultdataloader/), and add metadata as desired.
- The **Retriever** workflow for querying data, shows how agents and vector stores work together to help you define highly relevant results and save tokens using the **Question and Answer** tool.

Enable semantic search and the retrieval of unstructured data for increased quality and relevance of AI responses.

- Search for **RAG starter template** in the search bar of the Nodes panel to insert it into your workflow.

Learn more about implementing RAG in n8n [here](../advanced-ai/rag-in-n8n/).

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.98.0...n8n@1.98.1) for this version.\
**Release date:** 2025-06-12

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.97.0...n8n@1.98.0) for this version.\
**Release date:** 2025-06-11

This release contains performance improvements, core updates, editor changes, node updates, a new node, and bug fixes.

[luka-mimi](https://github.com/luka-mimi)\
[Alexandero89](https://github.com/Alexandero89)\
[khoazero123](https://github.com/khoazero123)

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.97.0...n8n@1.97.1) for this version.\
**Release date:** 2025-06-04

This release contains backports.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.95.2...n8n@1.95.3) for this version.\
**Release date:** 2025-06-03

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.96.0...n8n@1.97.0) for this version.\
**Release date:** 2025-06-02

This release contains new features, performance improvements and bug fixes.

### Convert to sub-workflow

Large, monolithic workflows can slow things down. They’re harder to maintain, tougher to debug, and more difficult to scale. With sub-workflows, you can take a more modular approach, breaking up big workflows into smaller, manageable parts that are easier to reuse, test, understand, and explain.

Until now, creating sub-workflows required copying and pasting nodes manually, setting up a new workflow from scratch, and reconnecting everything by hand. **Convert to sub-workflow** allows you to simplify this process into a single action, so you can spend more time building and less time restructuring.

[](/_video/release-notes/convert_to_sub-workflow.mp4)

1. Highlight the nodes you want to convert to a sub-workflow. These must:
   - Be fully connected, meaning no missing steps in between them
   - Start from a single starting node
   - End with a single node
1. Right-click to open the context menu and select **Convert to sub-workflow**
   - Or use the shortcut: `Alt + X`
1. n8n will:
   - Open a new tab containing the selected nodes
   - Preserve all node parameters as-is
   - Replace the selected nodes in the original workflow with a **Call My Sub-workflow** node

*Note*: You will need to manually adjust the field types in the Start and Return nodes in the new sub-workflow.

This makes it easier to keep workflows modular, performant, and easier to maintain.

Learn more about [sub-workflows](../flow-logic/subworkflows/).

This release contains performance improvements and bug fixes.

[maatthc](https://github.com/maatthc)

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.95.0...n8n@1.96.0) for this version.\
**Release date:** 2025-06-02

This release failed to build. Please use `1.97.0` instead.

This release contains API updates, core changes, editor improvements, node updates, and bug fixes.

### API support for assigning users to projects

You can now use the API to add and update users within projects. This includes:

- Assigning existing or pending users to a project with a specific role
- Updating a user’s role within a project
- Removing users from one or more projects

This update now allows you to use the API to add users to both the instance and specific projects, removing the need to manually assign them in the UI.

### Add pending users to project member assignment

You can now add **pending users,** those who have been invited but haven't completed sign-up, to projects as members.

This change lets you configure a user's project access upfront, without waiting for them to finish setting up their account. It eliminates the back-and-forth of managing access post-sign-up, ensuring users have the right project roles immediately upon joining.

[matthabermehl](https://github.com/matthabermehl)\
[Stamsy](https://github.com/Stamsy)

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.95.1...n8n@1.95.2) for this version.\
**Release date:** 2025-05-29

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.95.0...n8n@1.95.1) for this version.\
**Release date:** 2025-05-27

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.94.0...n8n@1.94.1) for this version.\
**Release date:** 2025-05-27

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.94.0...n8n@1.95.0) for this version.\
**Release date:** 2025-05-26

This release contains core updates, editor improvements, node updates, and bug fixes.

### Evaluations for AI workflows

We’ve added a feature to help you iterate, test, and compare changes to your AI automations before pushing them to production so you can achieve more predictability and make better decisions.

When you're building with AI, a small prompt tweak or model swap might improve results with some inputs, while quietly degrading performance with others. But without a way to evaluate performance across many inputs, you’re left guessing whether your AI is actually getting better when you make a change.

By implementing **Evaluations for AI workflows** in n8n, you can assess how your AI performs across a range of inputs by adding a dedicated path in your workflow for running test cases and applying custom metrics to track results. This helps you build viable proof-of-concepts quickly, iterate more effectively, catch regressions early, and make more confident decisions when your AI is in production.

#### Evaluation node and tab

The **Evaluation node** includes several operations that, when used together, enable end-to-end AI evaluation.

- Run your AI logic against a wide range of test cases in the same execution
- Capture the outputs of those test cases
- Score the results using your own metrics or LLM-as-judge logic
- Isolate a testing path to only include the nodes and logic you want to evaluate

The **Evaluations tab** enables you to review test results in the n8n UI, perfect for comparing runs, spotting regressions, and viewing performance over time.

#### 🛠 How evaluations work

The evaluation path runs alongside your normal execution logic and only activates when you want—making it ideal for testing and iteration.

Get started by selecting an AI workflow you want to evaluate that includes one or more LLM or Agent nodes.

1. Add an **Evaluation** node with the **On new Evaluation event** operation. This node will act as an additional trigger you’ll run only when testing. Configure it to read your dataset from Google Sheets, with each row representing a test input.

> 💡 Better datasets mean better evaluations. Craft your dataset from a variety of test cases, including edge cases and typical inputs, to get meaningful feedback on how your AI performs. Learn more and access sample datasets [here](../advanced-ai/evaluations/light-evaluations/#1-create-a-dataset).

1. Add a second **Evaluation** node using the **Set Outputs** operation after the part of the workflow you're testing—typically after an LLM or Agent node. This captures the response and writes it back to your dataset in Google Sheets.

1. To evaluate output quality, add a third **Evaluation** node with the **Set Metrics** operation at a point after you’ve generated the outputs. You can develop workflow logic, custom calculations, or add an LLM-as-Judge to score the outputs. Map these metrics to your dataset in the node’s parameters.

> 💡 Well-defined metrics = smarter decisions. Scoring your outputs based on similarity, correctness, or categorization can help you track whether changes are actually improving performance. Learn more and get links to example templates [here](../advanced-ai/evaluations/metric-based-evaluations/#2-add-metrics-to-workflow).

When the Evaluation trigger node is executed, it runs each input in our dataset through your AI logic. This continues until all test cases are processed, a limit is reached, or you manually stop the execution. Once your evaluation path is set up, you can update your prompt, model, or workflow logic—and re-run the Evaluation trigger node to compare results. If you’ve added metrics, they’ll appear in the Evaluations tab.

In some instances, you may want to isolate your testing path to make iteration faster or to avoid executing downstream logic. In this case, you can add an Evaluation node with the `Check If Evaluating` operation to ensure only the expected nodes run when performing evaluations.

#### Things to keep in mind

Evaluations for AI Workflows are designed to fit into your development flow, with more enhancements on the way. For now, here are a few things to note:

- Test datasets are currently managed through Google Sheets. You’ll need a Google Sheets credential to run evaluations.
- Each workflow supports one evaluation at a time. If you’d like to test multiple segments, consider splitting them into sub-workflows for more flexibility.
- Community Edition supports one single evaluation. Pro and Enterprise plans allow unlimited evaluations.
- AI Evaluations are not enabled for instances in scaling mode at this time.

You can find details, tips, and common troubleshooting info [here](../advanced-ai/evaluations/tips-and-common-issues/).

👉 Learn more about the AI evaluation strategies and practical implementation techniques. [Watch now](https://www.youtube.com/live/QkciQpotQBQ?feature=shared).

[Phiph](https://github.com/Phiph)\
[cesars-gh](https://github.com/cesars-gh)

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.93.0...n8n@1.94.0) for this version.\
**Release date:** 2025-05-19

This release contains editor improvements, an API update, node updates, new nodes, and bug fixes.

### Verified community nodes on Cloud

We’ve expanded the n8n ecosystem and unlocked a new level of flexibility for all users including those on n8n Cloud! Now you can access a select set of community nodes and partner integrations without leaving the canvas. This means you install and automate with a wider range of integrations without leaving your workspace. The power of the community is now built-in.

This update focuses on three major improvements:

- **Cloud availability**: Community nodes are no longer just for self-hosted users. A select set of nodes is now available on n8n Cloud.
- **Built-in discovery**: You can find and explore these nodes right from the Nodes panel without leaving the editor or searching on npm.
- **Trust and verification**: Nodes that appear in the editor have been manually vetted for quality and security. These verified nodes are marked with a checkmark.

We’re starting with a selection of around 25 nodes, including some of the most-used community-built packages and partner-supported integrations. For this phase, we focused on nodes that don’t include external package dependencies - helping streamline the review process and ensure a smooth rollout.

This is just the start. We plan to expand the library gradually, bringing even more verified nodes into the editor along with the powerful and creative use cases they unlock. In time, our criteria will evolve, opening the door to a wider range of contributions while keeping quality and security in focus.

Learn more about this update and find out which nodes are already installable from the editor in our [blog](https://blog.n8n.io/community-nodes-available-on-n8n-cloud/) post.

💻 **Use a verified node**

Make sure you're on **n8n version 1.94.0** or later and the instance Owner has enabled verified community nodes. On Cloud, this can be done from the Admin Panel. For self-hosted instances, please refer to [documentation](../hosting/configuration/environment-variables/nodes/). In both cases, verified nodes are enabled by default.

- Open the **Nodes panel** from the editor
- Search for the Node. Verified nodes are indicated by a shield 🛡️
- Select the node and click **Install**

[](/_video/release-notes/Community-nodes-node-panel.mp4)

Once an Owner installs a node, everyone on the instance can start using it—just drag, drop, and connect like any other node in your workflow.

🛠️ **Build a node and get it verified**

Want your node to be verified and discoverable from the editor? Here’s how to get involved:

1. Review the [community node verification guidelines](../integrations/creating-nodes/build/reference/verification-guidelines/).
1. If you’re building something new, follow the recommendations for [creating nodes](../integrations/creating-nodes/overview/).
1. Check your design against the [UX guidelines](../integrations/creating-nodes/build/reference/ux-guidelines/).
1. [Submit your node](../integrations/creating-nodes/deploy/submit-community-nodes/) to npm.
1. Request verification by filling out [this form](https://internal.users.n8n.cloud/form/f0ff9304-f34a-420e-99da-6103a2f8ac5b).

**Already built a node? Raise your hand!**

If you’ve already published a community node and want it considered for verification, make sure it meets the requirements noted above, then let us know by submitting the interest [form](https://internal.users.n8n.cloud/form/f0ff9304-f34a-420e-99da-6103a2f8ac5b). We’re actively curating the next batch and would love to include your work.

### Extended logs view

When workflows get complex, debugging can get... clicky. That’s where an extended **Logs View** comes in. Now you can get a clearer path to trace executions, troubleshoot issues, and understand the behavior of a complete workflow — without bouncing between node detail views.

This update brings a unified, always-accessible panel to the bottom of the canvas, showing you each step of the execution as it happens. Whether you're working with loops, sub-workflows, or AI agents, you’ll see a structured view of everything that ran, in the order it ran—with input, output, and status info right where you need it.

You can jump into node details when you want to dig deeper, or follow a single item through every step it touched. Real-time highlighting shows you which nodes are currently running or have failed, and you’ll see total execution time for any workflow—plus token usage for AI workflows to help monitor performance. And if you're debugging across multiple screens? Just pop the logs out and drag them wherever you’d like.

- Adds a **Logs view** to the bottom of the canvas that can be opened or collapsed. (Chat also appears here if your workflow uses it).
- Displays a **hierarchical list of nodes** in the order they were executed—including expanded views of sub-workflows.
- Allows you to **click a node in hierarchy** to preview inputs and outputs directly, or jump into the full Node Details view with a link.
- Provides ability to **toggle** input and output data on and off.
- Highlights each node **live as it runs**, showing when it starts, completes, or fails.
- Includes **execution history** view to explore past execution data in a similar way.
- Shows **roll-up stats** like total execution time and total AI tokens used (for AI-enabled workflows).
- Includes a **“pop out”** button to open the logs as a floating window—perfect for dragging to another screen while debugging.

To access the expanded logs view, click on the Logs bar at the bottom of the canvas. The view is also opens up when you open the chat window on the bottom of the page.

[Stamsy](https://github.com/Stamsy)\
[feelgood-interface](https://github.com/feelgood-interface)

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.92.0...n8n@1.93.0) for this version.\
**Release date:** 2025-05-12

This release contains core updates, editor improvements, new nodes, node updates, and bug fixes.

### Faster ways to open sub-workflows

We’ve added several new ways to navigate your multi-workflow automations faster.

From any workflow with a sub-workflow node:

🖱️ Right-click on a sub-workflow node and select `Open sub-workflow` from the context menu

⌨️ Keyboard shortcuts

- **Windows:** `CTRL + SHIFT + O` or `CTRL + Double Click`
- **Mac:** `CMD + SHIFT + O` or `CMD + Double Click`

These options will bring your sub-workflow up in a new tab.

### Archive workflows

If you’ve ever accidentally removed a workflow, you’ll appreciate the new archiving feature. Instead of permanently deleting workflows with the Remove action, workflows are now archived by default. This allows you to recover them if needed.

- **Archive a workflow** - Select **Archive** from the Editor UI menu. It has replaced the **Remove** action.
- **Find archived workflows** - Archived workflows are hidden by default. To find your archived workflows, select the option for **Show archived workflows** in the workflow filter menu.
- **Permanently delete a workflow** - Once a workflow is archived, you can **Delete** it from the options menu.
- **Recover a workflow** - Select **Unarchive** from the options menu.

- Workflows archival requires the same permissions as required previously for removal.
- You cannot select archived workflows as sub-workflows to execute
- Active workflows are deactivated when they are archived
- Archived workflows can not be edited

[LeaDevelop](https://github.com/LeaDevelop)\
[ayhandoslu](https://github.com/ayhandoslu)\
[valentina98](https://github.com/valentina98)

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.92.1...n8n@1.92.2) for this version.\
**Release date:** 2025-05-08

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.91.2...n8n@1.91.3) for this version.\
**Release date:** 2025-05-08

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.92.0...n8n@1.92.1) for this version.\
**Release date:** 2025-05-06

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.91.0...n8n@1.92.0) for this version.\
**Release date:** 2025-05-05

This release contains core updates, editor improvements, node updates, and bug fixes.

### Partial Execution for AI Tools

We’ve made it easier to build and iterate on AI agents in n8n. You can now run and test specific tools without having to execute the entire agent workflow.

Partial execution is especially useful when refining or troubleshooting parts of your agent logic. It allows you to test changes incrementally, without triggering full agent runs, reducing unnecessary AI calls, token usage, and downstream activity. This makes iteration faster, more cost-efficient, and more precise when working with complex or multi-step AI workflows.

Partial execution for AI tools is available now for all tools - making it even easier to build, test, and fine-tune AI agents in n8n.

[](/_video/release-notes/AI-agent-partial-execution.mp4)

To use this feature you can either:

- Click the **Play** button on the tool you want to execute directly from the canvas view.
- Open the tool’s **Node Details View** and select **"Execute Step"** to run it from there.

If you have previously run the workflow, the input and output will be prefilled with data from the last execution. A pop-up form will open where you can manually fill in the parameters before executing your test.

### Extended logs view

When workflows get complex, debugging can get... clicky. That’s where an extended **Logs View** comes in. Now you can get a clearer path to trace executions, troubleshoot issues, and understand the behavior of a complete workflow — without bouncing between node detail views.

This update brings a unified, always-accessible panel to the bottom of the canvas, showing you each step of the execution as it happens. Whether you're working with loops, sub-workflows, or AI agents, you’ll see a structured view of everything that ran, in the order it ran—with input, output, and status info right where you need it.

You can jump into node details when you want to dig deeper, or follow a single item through every step it touched. Real-time highlighting shows you which nodes are currently running or have failed, and you’ll see total execution time for any workflow—plus token usage for AI workflows to help monitor performance. And if you're debugging across multiple screens? Just pop the logs out and drag them wherever you’d like.

- Adds a **Logs view** to the bottom of the canvas that can be opened or collapsed. (Chat also appears here if your workflow uses it).
- Displays a **hierarchical list of nodes** in the order they were executed—including expanded views of sub-workflows.
- Allows you to **click a node in hierarchy** to preview inputs and outputs directly, or jump into the full Node Details view with a link.
- Provides ability to **toggle** input and output data on and off.
- Highlights each node **live as it runs**, showing when it starts, completes, or fails.
- Includes **execution history** view to explore past execution data in a similar way.
- Shows **roll-up stats** like total execution time and total AI tokens used (for AI-enabled workflows).
- Includes a **“pop out”** button to open the logs as a floating window—perfect for dragging to another screen while debugging.

To access the expanded logs view, click on the Logs bar at the bottom of the canvas. The view is also opens up when you open the chat window on the bottom of the page.

### Insights enhancements for Enterprise

Two weeks after the launch of [Insights](../insights/), we’re releasing some enhancements designed for enterprise users.

- **Expanded time ranges**. You can now filter insights over a variety of time periods, from the last 24 hours up to 1 year. Pro users are limited to 7 day and 14 day views.
- **Hourly granularity**. Drill down into the last 24 hours of production executions with hourly granularity, making it easier to analyze workflows and quickly identify issues.

These updates provide deeper visibility into workflow history, helping you uncover trends over longer periods and detect problems sooner with more precise reporting.

[Stamsy](https://github.com/Stamsy)

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.91.1...n8n@1.91.2) for this version.\
**Release date:** 2025-05-05

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.90.2...n8n@1.90.3) for this version.\
**Release date:** 2025-05-05

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.91.0...n8n@1.91.1) for this version.\
**Release date:** 2025-05-01

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.90.0...n8n@1.91.0) for this version.\
**Release date:** 2025-04-28

This release contains core updates, editor improvements, node updates, and bug fixes.

### Breadcrumb view from the canvas

We’ve added **breadcrumb navigation directly on the canvas**, so you can quickly navigate to any of a workflow’s parent folders right from the canvas.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.90.1...n8n@1.90.2) for this version.\
**Release date:** 2025-04-25

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.90.0...n8n@1.90.1) for this version.\
**Release date:** 2025-04-22

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.89.0...n8n@1.90.0) for this version.\
**Release date:** 2025-04-22

This release contains core updates, editor updates, node updates, performance improvements, and bug fixes.

### Extended HTTP Request tool functionality

We’ve brought the full power of the HTTP Request node to the HTTP Request tool in AI workflows. That means your AI Agents now have access to all the advanced configuration options—like Pagination, Batching, Timeout, Redirects, Proxy support, and even cURL import.

[](/_video/release-notes/http-request-tool.mp4)

This update also includes support for the `$fromAI` function to dynamically generate the right parameters based on the context of your prompt — making API calls smarter, faster, and more flexible than ever.

- Open your AI Agent node in the canvas.
- Click the **‘+’ icon** to add a new tool connection.
- In the **Tools panel**, select HTTP **Request Tool.**
- Configure it just like you would a regular **HTTP Request node** — including advanced options

👉 Learn more about configuring the [HTTP Request tool](../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.toolhttprequest/).

Users on the Enterprise plan can now create API keys with specific scopes to control exactly what each key can access.

Previously, API keys had full read/write access across all endpoints. While sometimes necessary, this level of access can be excessive and too powerful for most use cases. Scoped API keys allow you to limit access to only the resources and actions a service or user actually needs.

When creating a new API key, you can now:

- Select whether the key has read, write, or both types of access.
- Specify which resources the key can interact with.

Supported scopes include:

- Variables — list, create, delete
- Security audit — generate reports
- Projects — list, create, update, delete
- Executions — list, read, delete
- Credentials — list, create, update, delete, move
- Workflows — list, create, update, delete, move, add/remove tags

Scoped API keys give you more control and security. You can limit access to only what’s needed, making it safer to work with third parties and easier to manage internal API usage.

### Drag and Drop in Folders

Folders just got friendlier. With this release, you can now **drag and drop workflows and folders** — making it even easier to keep things tidy.

Need to reorganize? Just select a workflow or folder and drag it into another folder or breadcrumb location. It’s a small change that makes a big difference when managing a growing collection of workflows.

[](/_video/release-notes/Drag-and-drop-folders.mp4)

📁 Folders are available to all [registered](../hosting/community-edition-features/#registered-community-edition) users—jump in and get your workspace in order!

[Zordrak](https://github.com/Zordrak)

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.89.1...n8n@1.89.2) for this version.\
**Release date:** 2025-04-16

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.89.0...n8n@1.89.1) for this version.\
**Release date:** 2025-04-15

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.88.0...n8n@1.89.0) for this version.\
**Release date:** 2025-04-14

This release contains API updates, core updates, editor updates, a new node, node updates, and bug fixes.

We're rolling out [Insights](../insights/), a new dashboard to monitor how your workflows are performing over time. It's designed to give admins (and owners) better visibility of their most important workflow metrics and help troubleshoot potential issues and improvements.

In this first release, we’re introducing a summary banner, the insights dashboard, and time saved per execution.

#### 1. Summary banner

A new banner on the overview page that gives instance admins and owners a birds eye view of key metrics over the last 7 days.

Insights summary banner

- Total production executions
- Total failed executions
- Failure rate
- Average runtime of all workflows
- Estimated time saved

This overview is designed to help you stay on top of workflow activity at a glance. It is available for all plans and editions.

#### 2. Insights dashboard

On Pro and Enterprise plans, a new dashboard offers a deeper view into workflow performance and activity.

The dashboard includes:

- Total production executions over time, including a comparison of successful and failed executions
- Per-workflow breakdowns of key metrics
- Comparisons with previous periods to help spot changes in usage or behavior
- Runtime average and failure rate over time

#### 3. Time saved per execution

Within workflow settings, you can now assign a “time saved per execution” value to any workflow. This makes it possible to track the impact of your workflows and make it easier to share this visually with other teams and stakeholders.

This is just the beginning for Insights: the next phase will introduce more advanced filtering and comparisons, custom date ranges, and additional monitoring capabilities.

- We added a credential check for the Salesforce node
- We added SearXNG as a tool for AI agents

You can now search within subfolders, making it easier to find workflows across all folder levels. Just type in the search bar and go.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.87.0...n8n@1.88.0) for this version.\
**Release date:** 2025-04-10

This release contains new features, new nodes, performance improvements, and bug fixes.

### Model Context Protocol (MCP) nodes

MCP aims to standardise how LLMs like Claude, ChatGPT, or Cursor can interact with tools or integrate data for their agents. Many providers - both established or new - are adopting MCP as a standard way to build agentic systems. It is an easy way to either expose your own app as a server, making capabilities available to a model as tools, or as a client that can call on tools outside of your own system.

While it’s still early in the development process, we want to give you access to our new MCP nodes. This will help us understand your requirements better and will also let us converge on a great general solution quicker.

We are adding two new nodes:

- a MCP [Server Trigger](../integrations/builtin/core-nodes/n8n-nodes-langchain.mcptrigger/) for any workflow
- a MCP [Client Tool](../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.toolmcp/) for the AI Agent

The MCP Server Trigger turns n8n into an MCP server, providing n8n tools to models running outside of n8n. You can run multiple MCP servers from your n8n instance. The MCP Client Tool connects LLMs - and other intelligent agents - to any MCP-enabled service through a single interface.

Max from our DevRel team created an official walkthrough for you to get started:

[Studio Update #04](https://youtu.be/45WPU7P-1QQ?feature=shared)

### MCP Server Trigger

The MCP Server Trigger turns n8n into an MCP server, providing n8n tools to models running outside of n8n. The node acts as an entry point into n8n for MCP clients. It operates by exposing a URL that MCP clients can interact with to access n8n tools. This means your n8n workflows and integrations are now available to models run elsewhere. Pretty neat.

[Explore the MCP Server Trigger docs](../integrations/builtin/core-nodes/n8n-nodes-langchain.mcptrigger/)

The MCP Client Tool node is a MCP client, allowing you to use the tools exposed by an external MCP server. You can connect the MCP Client Tool node to your models to call external tools with n8n agents. In this regard it is similar to using a n8n tool with your AI agent. One advantage is that the MCP Client Tool can access multiple tools on the MCP server at once, keeping your canvas cleaner and easier to understand.

[Explore the MCP Client Tool docs](../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.toolmcp/)

- Added a node for Azure Cosmos DB
- Added a node for Milvus Vector Store
- Updated the Email Trigger (IMAP) node

[adina-hub](https://github.com/adina-hub)\
[umanamente](https://github.com/umanamente)

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.87.1...n8n@1.87.2) for this version.\
**Release date:** 2025-04-09

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.86.0...n8n@1.86.1) for this version.\
**Release date:** 2025-04-09

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.87.0...n8n@1.87.1) for this version.\
**Release date:** 2025-04-08

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.86.0...n8n@1.87.0) for this version.\
**Release date:** 2025-04-07

This release contains new nodes, node updates, API updates, core updates, editor updates, and bug fixes.

[cesars-gh](https://github.com/cesars-gh)\
[Stamsy](https://github.com/Stamsy)\
[Pash10g](https://github.com/Pash10g)

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.85.0...n8n@1.86.0) for this version.\
**Release date:** 2025-03-31

This release contains API updates, core updates, editor improvements, node updates, and bug fixes.

[Aijeyomah](https://github.com/Aijeyomah)\
[ownerer](https://github.com/ownerer)\
[ulevitsky](https://github.com/ulevitsky)

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.85.3...n8n@1.85.4) for this version.\
**Release date:** 2025-03-27

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.84.2...n8n@1.84.3) for this version.\
**Release date:** 2025-03-27

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.84.1...n8n@1.84.2) for this version.\
**Release date:** 2025-03-26

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.85.2...n8n@1.85.3) for this version.\
**Release date:** 2025-03-26

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.85.1...n8n@1.85.2) for this version.\
**Release date:** 2025-03-25

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.85.0...n8n@1.85.1) for this version.\
**Release date:** 2025-03-25

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.84.0...n8n@1.85.0) for this version.\
**Release date:** 2025-03-24

This release contains a new node, a new credential, core updates, editor updates, node updates, and bug fixes.

What can we say about folders? Well, they’re super handy for categorizing just about everything and they’re finally available for your n8n workflows. Tidy up your workspace with unlimited folders and nested folders. Search for workflows within folders. It’s one of the ways we’re making it easier to organize your n8n instances more effectively.

Create and manage folders within your personal space or within projects. You can also create workflows from within a folder. You may need to restart your instance in order to activate folders.

It's a folder alright

Folders are available for all [registered](../hosting/community-edition-features/#registered-community-edition) users so get started with decluttering your workspace now and look for more features (like drag and drop) to organize your instances soon.

### Enhancements to Form Trigger Node

Recent updates to the Form Trigger node have made it a more powerful tool for building business solutions. These enhancements provide more flexibility and customization, enabling teams to create visually engaging and highly functional workflows with forms.

- **HTML customization:** Add custom HTML to forms, including embedded images and videos, for richer user experiences.
- **Custom CSS support**: Apply custom styles to user-facing components to align forms with your brand’s look and feel. Adjust fonts, colors, and spacing for a seamless visual identity.
- **Form previews:** Your form’s description and title will pull into previews of your form when sharing on social media or messaging apps, providing a more polished look.
- **Hidden fields:** Use query parameters to add hidden fields, allowing you to pass data—such as a referral source—without exposing it to the user.
- **New responses options:** Respond to user submissions in multiple ways including text, HTML, or a downloadable file (binary format). This enables forms to display rich webpages or deliver digital assets such as dynamically generated invoices or personalized certificates.

Form with custom CSS applied

These improvements elevate the Form Trigger node beyond a simple workflow trigger, transforming it into a powerful tool for addressing use cases from data collection and order processing to custom content creation.

[Fank](https://github.com/Fank)

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.84.0...n8n@1.84.1) for this version.\
**Release date:** 2025-03-18

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.83.0...n8n@1.84.0) for this version.\
**Release date:** 2025-03-17

This release contains a new node, node updates, editor updates, and bug fixes.

[Pash10g](https://github.com/Pash10g)

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.83.1...n8n@1.83.2) for this version.\
**Release date:** 2025-03-14

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.82.3...n8n@1.82.4) for this version.\
**Release date:** 2025-03-14

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.82.2...n8n@1.82.3) for this version.\
**Release date:** 2025-03-13

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.83.0...n8n@1.83.1) for this version.\
**Release date:** 2025-03-12

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.82.0...n8n@1.83.0) for this version.\
**Release date:** 2025-03-12

This release contains bug fixes and an editor update.

Schema Preview lets you view and work with a node’s expected output without executing it or adding credentials, keeping you in flow while building.

- **See expected node outputs instantly.** View schemas for over 100+ nodes to help you design workflows efficiently without extra steps.
- **Define workflow logic first, take care of credentials later.** Build your end-to-end workflow without getting sidetracked by credential setup.
- **Avoid unwanted executions when building.** Prevent unnecessary API calls, unwanted data changes, or potential third-party service costs by viewing outputs without executing nodes.

- Add a node with Schema Preview support to your workflow.
- Open the next node in the sequence - Schema Preview data appears in the Node Editor where you would typically find it in the Schema View.
- Use Schema Preview fields just like other schema data - drag and drop them into parameters and settings as needed.

[](/_video/release-notes/Schema_preview.mp4)

Don’t forget to add the required credentials before putting your workflow into production.

[pemontto](https://github.com/pemontto)\
[Haru922](https://github.com/Haru922)

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.82.1...n8n@1.82.2) for this version.\
**Release date:** 2025-03-12

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.82.0...n8n@1.82.1) for this version.\
**Release date:** 2025-03-04

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.81.0...n8n@1.82.0) for this version.\
**Release date:** 2025-03-03

This release contains core updates, editor updates, new nodes, node updates, new credentials, credential updates, and bug fixes.

Tidy up instantly aligns nodes, centers stickies, untangles connections, and brings structure to your workflows. Whether you're preparing to share a workflow or just want to improve readability, this feature saves you time and makes your logic easier to follow. Clean, well-organized workflows aren't just nicer to look at—they’re also quicker to understand.

Open the workflow you want to tidy, then choose one of these options:

- Click the **Tidy up** button in the bottom-left corner of the canvas (it looks like a broom 🧹)
- Press **Shift + Alt + T** on your keyboard
- Right-click anywhere on the canvas and select **Tidy up workflow**

Want to tidy up just part of your workflow? Select the specific nodes you want to clean up first - Tidy up will only adjust those, along with any stickies behind them.

[](/_video/release-notes/tidy_up.mp4)

### Multiple API keys

n8n now supports multiple API keys, allowing users to generate and manage separate keys for different workflows or integrations. This improves security by enabling easier key rotation and isolation of credentials. Future updates will introduce more granular controls.

[Rostammahabadi](https://github.com/Rostammahabadi)\
[Lanhild](https://github.com/Lanhild)\
[matthiez](https://github.com/matthiez)\
[feelgood-interface](https://github.com/feelgood-interface)\
[adina-hub](https://github.com/adina-hub)

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.81.3...n8n@1.81.4) for this version.\
**Release date:** 2025-03-03

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.81.2...n8n@1.81.3) for this version.\
**Release date:** 2025-03-03

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.81.1...n8n@1.81.2) for this version.\
**Release date:** 2025-02-28

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.80.4...n8n@1.80.5) for this version.\
**Release date:** 2025-02-28

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.80.3...n8n@1.80.4) for this version.\
**Release date:** 2025-02-27

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.81.0...n8n@1.81.1) for this version.\
**Release date:** 2025-02-27

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.80.0...n8n@1.81.0) for this version.\
**Release date:** 2025-02-24

This release contains bug fixes, a core update, editor improvements, and a node update.

### Improved partial executions

The new execution engine for partial executions ensures that testing parts of a workflow in the builder closely mirrors production behaviour. This makes iterating with updated run-data faster and more reliable, particularly for complex workflows.

Before, user would test parts of a workflow in the builder that didn't consistently reflect production behaviour, leading to unexpected results during development.

This update aligns workflow execution in the builder with production behavior.

Here is an example for loops:

[](/_video/release-notes/Partial-execution-loop-before.mp4)

[](/_video/release-notes/Partial-execution-loop-after.mp4)

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.80.2...n8n@1.80.3) for this version.\
**Release date:** 2025-02-21

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.79.3...n8n@1.79.4) for this version.\
**Release date:** 2025-02-21

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.80.1...n8n@1.80.2) for this version.\
**Release date:** 2025-02-21

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.79.2...n8n@1.79.3) for this version.\
**Release date:** 2025-02-21

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.80.0...n8n@1.80.1) for this version.\
**Release date:** 2025-02-20

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.79.1...n8n@1.79.2) for this version.\
**Release date:** 2025-02-20

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.79.0...n8n@1.80.0) for this version.\
**Release date:** 2025-02-17

This release contains bug fixes and an editor improvement.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.75.2...n8n@1.75.3) for this version.\
**Release date:** 2025-02-17

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.74.3...n8n@1.74.4) for this version.\
**Release date:** 2025-02-17

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.79.0...n8n@1.79.1) for this version.\
**Release date:** 2025-02-15

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.78.0...n8n@1.78.1) for this version.\
**Release date:** 2025-02-15

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.77.3...n8n@1.77.4) for this version.\
**Release date:** 2025-02-15

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.76.3...n8n@1.76.4) for this version.\
**Release date:** 2025-02-15

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.77.0...n8n@1.78.0) for this version.\
**Release date:** 2025-02-12

This release contains new features, node updates, and bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.77.2...n8n@1.77.3) for this version.\
**Release date:** 2025-02-06

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.77.0...n8n@1.78.0) for this version.\
**Release date:** 2025-02-05

This release contains new features, node updates, and bug fixes.

[mocanew](https://github.com/mocanew)\
[Timtendo12](https://github.com/Timtendo12)

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.77.1...n8n@1.77.2) for this version.\
**Release date:** 2025-02-04

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.76.2...n8n@1.76.3) for this version.\
**Release date:** 2025-02-04

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.77.0...n8n@1.77.1) for this version.\
**Release date:** 2025-02-03

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.76.1...n8n@1.76.2) for this version.\
**Release date:** 2025-02-03

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.76.0...n8n@1.77.0) for this version.\
**Release date:** 2025-01-29

This release contains new features, editor updates, new nodes, new credentials, node updates, and bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.76.0...n8n@1.76.1) for this version.\
**Release date:** 2025-01-23

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.75.0...n8n@1.76.0) for this version.\
**Release date:** 2025-01-22

This release contains new features, editor updates, new credentials, node improvements, and bug fixes.

[Stamsy](https://github.com/Stamsy)\
[GKdeVries](https://github.com/GKdeVries)

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.75.1...n8n@1.75.2) for this version.\
**Release date:** 2025-01-17

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.74.2...n8n@1.74.3) for this version.\
**Release date:** 2025-01-17

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.75.0...n8n@1.75.1) for this version.\
**Release date:** 2025-01-17

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.74.1...n8n@1.74.2) for this version.\
**Release date:** 2025-01-17

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.74.0...n8n@1.75.0) for this version.\
**Release date:** 2025-01-15

This release contains bug fixes and editor updates.

### Improved consistency across environments

We added new UX and automatic changes improvements resulting in a better consistency between your staging and production instances.

Previously, users faced issues like:

- Lack of visibility into required credential updates when pulling changes
- Incomplete synchronization, where changes — such as deletions — weren’t always applied across environments
- Confusing commit process, making it unclear what was being pushed or pulled

We addressed these by:

- Clearly indicating required credential updates when pulling changes
- Ensuring deletions and other modifications sync correctly across environments
- Improving commit selection to provide better visibility into what’s being pushed

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.74.0...n8n@1.74.1) for this version.\
**Release date:** 2025-01-09

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.73.0...n8n@1.74.0) for this version.\
**Release date:** 2025-01-08

This release contains new features, a new node, node updates, performance improvements and bug fixes.

### Overhauled Code node editing experience

We added a ton of new helpers to the Code node, making edits of your code much faster and more comfortable. You get:

- TypeScript autocomplete
- TypeScript linting
- TypeScript hover tips
- Search and replace
- New keyboard shortcuts based on the VSCode keymap
- Auto-formatting using prettier (Alt+Shift+F)
- Remember folded regions and history after refresh
- Multi cursor
- Type function in the Code node using JSDoc types
- Drag and drop for all Code node modes
- Indentation markers

We build this on a web worker architecture so you won't have to suffer from performance degradation while typing.

To get the full picture, check out our Studio update with Max and Elias, where they discuss and demo the new editing experience. 👇

[Studio Update #04](https://youtu.be/De1E58MPaMQ?t=645)

### New node: Microsoft Entra ID

Microsoft Entra ID (formerly known as Microsoft Azure Active Directory or Azure AD) is used for cloud-based identity and access management. [The new node](../integrations/builtin/app-nodes/n8n-nodes-base.microsoftentra/) supports a wide range of Microsoft Entra ID features, which includes creating, getting, updating, and deleting users and groups, as well as adding users to and removing them from groups.

- [AI Agent](../integrations/builtin/cluster-nodes/root-nodes/n8n-nodes-langchain.agent/): Vector stores can now be directly used as tools for the agent
- [Code](../code/builtin/overview/): Tons of new speed and convenience features, see above for details
- [Google Vertex Chat](../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.lmchatgooglevertex/): Added option to specify the GCP region for the Google API credentials
- [HighLevel](../integrations/builtin/app-nodes/n8n-nodes-base.highlevel/): Added support for calendar items

We also added a custom [projects](../user-management/rbac/projects/) icon selector on top of the available emojis. Pretty!

[igatanasov](https://github.com/igatanasov)\
[Stamsy](https://github.com/Stamsy)\
[feelgood-interface](https://github.com/feelgood-interface)

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.73.0...n8n@1.73.1) for this version.\
**Release date:** 2024-12-19

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.72.0...n8n@1.73.0) for this version.\
**Release date:** 2024-12-19

This release contains node updates, performance improvements, and bug fixes.

- [AI Agent](../integrations/builtin/cluster-nodes/root-nodes/n8n-nodes-langchain.agent/): Updated descriptions for Chat Trigger options
- [Facebook Graph API](../integrations/builtin/app-nodes/n8n-nodes-base.facebookgraphapi/): Updated for API v21.0
- [Gmail](../integrations/builtin/app-nodes/n8n-nodes-base.gmail/): Added two new options for the `Send and wait` operation, free text and custom form
- [Linear Trigger](../integrations/builtin/trigger-nodes/n8n-nodes-base.lineartrigger/): Added support for admin scope
- [MailerLite](../integrations/builtin/app-nodes/n8n-nodes-base.mailerlite/): Now supports the new API
- [Slack](../integrations/builtin/app-nodes/n8n-nodes-base.slack/): Added two new options for the `Send and wait` operation, free text and custom form

We also added credential support for [SolarWinds IPAM](../integrations/builtin/credentials/solarwindsipam/) and [SolarWinds Observability](../integrations/builtin/credentials/solarwindsobservability/).

Last, but not least, we [improved the schema view performance in the node details view by 90%](https://github.com/n8n-io/n8n/pull/12180) and added drag and drop re-ordering to parameters. This comes in very handy in the [If](../integrations/builtin/core-nodes/n8n-nodes-base.if/) or [Edit Fields](../integrations/builtin/core-nodes/n8n-nodes-base.set/) nodes.

[CodeShakingSheep](https://github.com/CodeShakingSheep)\
[mickaelandrieu](https://github.com/mickaelandrieu)\
[Stamsy](https://github.com/Stamsy)\
[pbdco](https://github.com/pbdco)

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.72.0...n8n@1.72.1) for this version.\
**Release date:** 2024-12-12

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.71.2...n8n@1.71.3) for this version.\
**Release date:** 2024-12-12

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.71.0...n8n@1.72.0) for this version.\
**Release date:** 2024-12-11

This release contains node updates, usability improvements, and bug fixes.

- [AI Transform](../integrations/builtin/core-nodes/n8n-nodes-base.aitransform/): The `maximum context length` error now retries with reduced payload size
- [Redis](../integrations/builtin/app-nodes/n8n-nodes-base.redis/): Added support for `continue on fail`

### Improved commit modal

We added filters and text search to the commit modal when working with [Environments](../source-control-environments/). This will make committing easier as we provide more information and better visibility. Environments are available on the Enterprise plan.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.71.1...n8n@1.71.2) for this version.\
**Release date:** 2024-12-10

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.70.3...n8n@1.70.4) for this version.\
**Release date:** 2024-12-10

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.71.0...n8n@1.71.1) for this version.\
**Release date:** 2024-12-06

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.70.2...n8n@1.70.3) for this version.\
**Release date:** 2024-12-05

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.70.2...n8n@1.71.0) for this version.\
**Release date:** 2024-12-04

This release contains node updates, performance improvements, and bug fixes.

### Task runners for the Code node in public beta

We're introducing a significant performance upgrade to the Code node with our new Task runner system. This enhancement moves JavaScript code execution to a separate process, improving your workflow execution speed while adding better isolation.

Task runners overview

Our benchmarks show up to 6x improvement in workflow executions using Code nodes - from approximately 6 to 35 executions per second. All these improvements happen under the hood, keeping your Code node experience exactly the same.

The Task runner comes in two modes:

- Internal mode (default): Perfect for getting started, automatically managing task runners as child processes
- External mode: For advanced hosting scenarios requiring maximum isolation and security

Currently, this feature is opt-in and can be enabled using [environment variables](../hosting/configuration/environment-variables/task-runners/). Once stable, it will become the default execution method for Code nodes.

To start using Task runners today, [check out the docs](../hosting/configuration/task-runners/).

- [AI Transform node](../integrations/builtin/core-nodes/n8n-nodes-base.aitransform/): We improved the prompt for code generation to transform data
- [Code node](../integrations/builtin/core-nodes/n8n-nodes-base.code/): We added a warning if `pairedItem` is absent or could not be auto mapped

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.70.1...n8n@1.70.2) for this version.\
**Release date:** 2024-12-04

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.70.0...n8n@1.70.1) for this version.\
**Release date:** 2024-11-29

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.69.0...n8n@1.70.0) for this version.\
**Release date:** 2024-11-27

This release contains node updates, performance improvements and bug fixes.

### New canvas in beta

The new canvas is now the default setting for all users. It should bring significant performance improvements and adds a handy minimap. As it is still a beta version you can still revert to the previous version with the three dot menu.

We're looking forward to your feedback. Should you encounter a bug, you will find a handy button to create an issue at the bottom of the new canvas as well.

- We added credential support for [Zabbix](../integrations/builtin/credentials/zabbix/) to the HTTP request node
- We added new OAuth2 credentials for [Microsoft SharePoint](../integrations/builtin/credentials/microsoft/)
- The [Slack node](../integrations/builtin/app-nodes/n8n-nodes-base.slack/#operations) now uses markdown for the approval message when using the `Send and Wait for Approval` operation

[feelgood-interface](https://github.com/feelgood-interface)\
[adina-hub](https://github.com/adina-hub)

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.68.0...n8n@1.68.1) for this version.\
**Release date:** 2024-11-26

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.69.1...n8n@1.69.2) for this version.\
**Release date:** 2024-11-26

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.69.0...n8n@1.69.1) for this version.\
**Release date:** 2024-11-25

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.68.0...n8n@1.69.0) for this version.\
**Release date:** 2024-11-20

This release contains a new feature, node improvements and bug fixes.

### Sub-workflow debugging

We made it much easier to debug sub-workflows by improving their accessibility from the parent workflow.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.67.1...n8n@1.68.0) for this version.\
**Release date:** 2024-11-13

This release contains node updates, performance improvements and many bug fixes.

#### New AI agent canvas chat

We revamped the chat experience for AI agents on the canvas. A neatly organized view instead of a modal hiding the nodes. You can now see the canvas, chat and logs at the same time when testing your workflow.

[](/_video/release-notes/AI-chat-on-canvas.mp4)

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.67.0...n8n@1.67.1) for this version.\
**Release date:** 2024-11-07

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.66.0...n8n@1.67.0) for this version.\
**Release date:** 2024-11-06

This release contains node updates and bug fixes.

- [AI Transform](../integrations/builtin/core-nodes/n8n-nodes-base.aitransform/): Improved usability
- [Anthropic Chat Model Node](../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.lmchatanthropic/): Added Haiku 3.5 support
- [Convert to File](../integrations/builtin/core-nodes/n8n-nodes-base.converttofile/): Added delimiter option for writing to CSV
- [Gmail Trigger](../integrations/builtin/trigger-nodes/n8n-nodes-base.gmailtrigger/): Added option to filter for draft messages
- [Intercom](../integrations/builtin/app-nodes/n8n-nodes-base.intercom/): Credential can now be used in the HTTP Request node
- [Rapid7 InsightVM](../integrations/builtin/credentials/rapid7insightvm/): Added credential support

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.65.2...n8n@1.66.0) for this version.\
**Release date:** 2024-10-31

This release contains performance improvements, a node update and bug fixes.

- [Anthropic Chat Model](../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.lmchatanthropic/): Added support for claude-3-5-sonnet-20241022

We made updates to how projects and workflow ownership are displayed making them easier to understand and navigate.

We further improved the performance logic of partial executions, leading to a smoother and more enjoyable building experience.

### New n8n canvas alpha

We have enabled the alpha version of our new canvas. The canvas is the ‘drawing board’ of the n8n editor, and we’re working on a full rewrite. Your feedback and testing will help us improve it. [Read all about it on our community forum](https://community.n8n.io/t/help-us-test-the-new-n8n-canvas-alpha/60070).

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.65.1...n8n@1.65.2) for this version.\
**Release date:** 2024-10-28

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.64.2...n8n@1.64.3) for this version.\
**Release date:** 2024-10-25

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.65.0...n8n@1.65.1) for this version.\
**Release date:** 2024-10-25

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.64.1...n8n@1.65.0) for this version.\
**Release date:** 2024-10-24

[Breaking change](https://github.com/n8n-io/n8n/blob/master/packages/cli/BREAKING-CHANGES.md)

What changed? Queue polling via the environment variable `QUEUE_RECOVERY_INTERVAL` has been removed.

When is action necessary? If you have set `QUEUE_RECOVERY_INTERVAL`, you can remove it as it no longer has any effect.

This release contains a new features, new nodes, node enhancements, and bug fixes.

### New node: n8n Form

Use the [n8n Form node](../integrations/builtin/core-nodes/n8n-nodes-base.form/) to create user-facing forms with multiple pages. You can add other nodes with custom logic between to process user input. Start the workflow with a [n8n Form Trigger](../integrations/builtin/core-nodes/n8n-nodes-base.formtrigger/).

A multi-page form with branching

Additionally you can:

- Set default selections with query parameters
- Define the form with a JSON array of objects
- Show a completion screen and redirect to another URL

- [Google Business Profile](../integrations/builtin/app-nodes/n8n-nodes-base.googlebusinessprofile/) and [Google Business Profile Trigger](../integrations/builtin/trigger-nodes/n8n-nodes-base.googlebusinessprofiletrigger/): Use these to integrate Google Business Profile reviews and posts with your workflows

- [AI Agent](../integrations/builtin/cluster-nodes/root-nodes/n8n-nodes-langchain.agent/): Removed the requirement to add at least one tool
- [GitHub](../integrations/builtin/app-nodes/n8n-nodes-base.github/): Added workflows as a resource operation
- [Structured Output Parser](../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.outputparserstructured/): Added more user-friendly error messages

For additional security, we improved how we handle multi-factor authentication, hardened config file permissions and introduced JWT for the public API.

For better performance, we improved how partial executions are handled in loops.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

- [Idan Fishman](https://github.com/idanfishman)

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.64.1...n8n@1.64.2) for this version.\
**Release date:** 2024-10-24

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.64.0...n8n@1.64.1) for this version.\
**Release date:** 2024-10-21

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.63.4...n8n@1.64.0) for this version.\
**Release date:** 2024-10-16

This release contains a new node, node enhancements, performance improvements and bug fixes.

### Enhanced node: Remove Duplicates

The [Remove Duplicates node](../integrations/builtin/core-nodes/n8n-nodes-base.removeduplicates/) got a major makeover with the addition of two new operations:

- Remove Items Processed in Previous Executions: Compare items in the current input to items from previous executions and remove duplicates
- Clear Deduplication History: Wipe the memory of items from previous executions.

This makes it easier to only process new items from any data source. For example, you can now more easily poll a Google sheet for new entries by `id` or remove duplicate orders from the same customer by comparing their `order date`. The great thing is, you can now do this within **and across** workflow runs.

The new node for [Gong](../integrations/builtin/app-nodes/n8n-nodes-base.gong/) allows you to get users and calls to process them further in n8n. Very useful for sales related workflows.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

- [Sören Uhrbach](https://github.com/soerenuhrbach)

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.63.3...n8n@1.63.4) for this version.\
**Release date:** 2024-10-15

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.62.5...n8n@1.62.6) for this version.\
**Release date:** 2024-10-15

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.63.2...n8n@1.63.3) for this version.\
**Release date:** 2024-10-15

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.63.1...n8n@1.63.2) for this version.\
**Release date:** 2024-10-11

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.62.4...n8n@1.62.5) for this version.\
**Release date:** 2024-10-11

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.63.0...n8n@1.63.1) for this version.\
**Release date:** 2024-10-11

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.62.3...n8n@1.62.4) for this version.\
**Release date:** 2024-10-11

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.62.3...n8n@1.63.0) for this version.\
**Release date:** 2024-10-09

[Breaking change](https://github.com/n8n-io/n8n/blob/master/packages/cli/BREAKING-CHANGES.md)

- The worker server used to bind to IPv6 by default. It now binds to IPv4 by default.
- The worker server's `/healthz` used to report healthy status based on database and Redis checks. It now reports healthy status regardless of database and Redis status, and the database and Redis checks are part of `/healthz/readiness`.

When is action necessary?

- If you experience a port conflict error when starting a worker server using its default port, set a different port for the worker server with `QUEUE_HEALTH_CHECK_PORT`.
- If you are relying on database and Redis checks for worker health status, switch to checking `/healthz/readiness` instead of `/healthz`.

This release contains new features, node enhancements and bug fixes.

- [OpenAI](../integrations/builtin/app-nodes/n8n-nodes-langchain.openai/): Added the option to choose between the default memory connector to provide memory to the assistant or to specify a thread ID
- [Gmail](../integrations/builtin/app-nodes/n8n-nodes-base.gmail/) and [Slack](../integrations/builtin/app-nodes/n8n-nodes-base.slack/): Added custom approval operations to have a human in the loop of a workflow

We have also optimized the [worker health checks](../hosting/logging-monitoring/monitoring/) (see breaking change above).

Each credential now has a seperate url you can link to. This makes sharing much easier.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

[Pemontto](https://github.com/pemontto)

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.62.2...n8n@1.62.3) for this version.\
**Release date:** 2024-10-08

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.62.1...n8n@1.62.2) for this version.\
**Release date:** 2024-10-07

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.61.0...n8n@1.62.1) for this version.\
**Release date:** 2024-10-02

This release contains new features, node enhancements and bug fixes.

We skipped 1.62.0 and went straight to 1.62.1 with an additional fix.

#### Additional nodes as tools

We have made additional nodes usable with the [Tools AI Agent node](../integrations/builtin/cluster-nodes/root-nodes/n8n-nodes-langchain.agent/tools-agent/).

[](/_video/release-notes/nodes-as-tools.mp4)

Additionally, we have added a `$fromAI()` placeholder function to use with tools, allowing you to dynamically pass information from the models to the connected tools. This function works similarly to placeholders used elsewhere in n8n.

Both of these new features enable you to build even more powerful AI agents by drawing directly from the apps your business uses. This makes integrating LLMs into your business processes even easier than before.

- [Google BigQuery](../integrations/builtin/app-nodes/n8n-nodes-base.googlebigquery/): Added option to return numeric values as integers and not strings
- [HTTP Request](../integrations/builtin/core-nodes/n8n-nodes-base.httprequest/): Added credential support for Sysdig
- [Invoice Ninja](../integrations/builtin/app-nodes/n8n-nodes-base.invoiceninja/): Additional query params for getAll requests
- [Question and Answer Chain](../integrations/builtin/cluster-nodes/root-nodes/n8n-nodes-langchain.chainretrievalqa/): Added the option to use a custom prompt

Drag and drop insertion on cursor position from schema view is now also enabled for code, SQL and Html fields in nodes.

Customers with an enterprise license can now rate, tag and highlight execution data in the executions view. To use highlighting, add an [Execution Data Node](../integrations/builtin/core-nodes/n8n-nodes-base.executiondata/) (or Code node) to the workflow to set [custom executions data](../workflows/executions/custom-executions-data/).

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

[Benjamin Roedell](https://github.com/benrobot)\
[CodeShakingSheep](https://github.com/CodeShakingSheep)\
[manuelbcd](https://github.com/manuelbcd)\
[Miguel Prytoluk](https://github.com/mprytoluk)

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.60.1...n8n@1.61.0) for this version.\
**Release date:** 2024-09-25

This release contains new features, node enhancements and bug fixes.

- [Brandfetch](../integrations/builtin/app-nodes/n8n-nodes-base.brandfetch/): Updated to use the new API
- [Slack](../integrations/builtin/app-nodes/n8n-nodes-base.slack/): Made adding or removing the workflow link to a message easier

Big datasets now render faster thanks to virtual scrolling and execution annotations are harder to delete.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.59.3...n8n@1.59.4) for this version.\
**Release date:** 2024-09-20

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.60.0...n8n@1.60.1) for this version.\
**Release date:** 2024-09-20

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.59.3...n8n@1.60.0) for this version.\
**Release date:** 2024-09-18

This release contains new features, node enhancements and bug fixes.

#### Queue metrics for workers

You can now [expose and consume metrics from your workers](../hosting/configuration/configuration-examples/prometheus/). The worker instances have the same metrics available as the main instance(s) and can be configured with [environment variables](../hosting/configuration/environment-variables/endpoints/).

You can now customize the maximum file size when uploading files within forms to webhooks. The [environment variable to set](../hosting/configuration/environment-variables/endpoints/) for this is `N8N_FORMDATA_FILE_SIZE_MAX`. The default setting is 200MiB.

- [Invoice Ninja](../integrations/builtin/app-nodes/n8n-nodes-base.invoiceninja/): Added actions for bank transactions
- [OpenAI](../integrations/builtin/app-nodes/n8n-nodes-langchain.openai/): Added O1 models to the model select

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

[CodeShakingSheep](https://github.com/CodeShakingSheep)

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.59.2...n8n@1.59.3) for this version.\
**Release date:** 2024-09-18

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.59.1...n8n@1.59.2) for this version.\
**Release date:** 2024-09-17

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.59.0...n8n@1.59.1) for this version.\
**Release date:** 2024-09-16

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.58.1...n8n@1.58.2) for this version.\
**Release date:** 2024-09-12

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.58.1...n8n@1.59.0) for this version.\
**Release date:** 2024-09-11

If you are using the Chat Trigger in "Embedded Chat" mode, with authentication turned on, you could see errors connecting to n8n if the authentication on the sending/embedded side is mis-configured.

This release contains bug fixes and feature enhancements.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

[oscarpedrero](https://github.com/oscarpedrero)

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.58.0...n8n@1.58.1) for this version.\
**Release date:** 2024-09-06

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.57.0...n8n@1.58.0) for this version.\
**Release date:** 2024-09-05

This release contains new features, bug fixes and feature enhancements.

#### New node: PGVector Vector Store

This release adds the PGVector Vector Store node. Use this node to interact with the PGVector tables in your PostgreSQL database. You can insert, get, and retrieve documents from a vector table to provide them to a retriever connected to a chain.

#### See active collaborators on workflows

We added collaborator avatars back to the workflow canvas. You will see other users who are active on the workflow, preventing you from overriding each other's work.

Collaboration avatars

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.56.2...n8n@1.57.0) for this version.\
**Release date:** 2024-08-28

This release contains new features and bug fixes.

#### Improved execution queue handling

We are [exposing new execution queue metrics](../hosting/configuration/configuration-examples/prometheus/) to give users more visibility of the queue length. This helps to inform decisions on horizontal scaling, based on queue status. We have also made querying executions faster.

#### New credentials for the HTTP Request node

We added credential support for Datadog, Dynatrace, Elastic Security, Filescan, Iris, and Malcore to the HTTP Request node making it easier to use existing credentials.

We also made it easier to select workflows as tools when working with AI agents by implementing a new `workflow selector` parameter type.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

[Bram Kn](https://github.com/bramkn)

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.56.1...n8n@1.56.2) for this version.\
**Release date:** 2024-08-26

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.56.0...n8n@1.56.1) for this version.\
**Release date:** 2024-08-23

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.55.3...n8n@1.56.0) for this version.\
**Release date:** 2024-08-21

This release contains node updates, security and bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

[CodeShakingSheep](https://github.com/CodeShakingSheep)\
[Oz Weiss](https://github.com/thewizarodofoz)

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.55.2...n8n@1.55.3) for this version.\
**Release date:** 2024-08-16

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.55.1...n8n@1.55.2) for this version.\
**Release date:** 2024-08-16

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.55.0...n8n@1.55.1) for this version.\
**Release date:** 2024-08-15

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.54.3...n8n@1.54.4) for this version.\
**Release date:** 2024-08-15

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.54.2...n8n@1.54.3) for this version.\
**Release date:** 2024-08-15

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.54.1...n8n@1.54.2) for this version.\
**Release date:** 2024-08-14

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.54.1...n8n@1.55.0) for this version.\
**Release date:** 2024-08-14

[Breaking change](https://github.com/n8n-io/n8n/blob/master/packages/cli/BREAKING-CHANGES.md)

The N8N_BLOCK_FILE_ACCESS_TO_N8N_FILES environment variable now also blocks access to n8n's static cache directory at ~/.cache/n8n/public.

If you are writing to or reading from a file at n8n's static cache directory via a node, e.g. Read/Write Files from Disk, please update your node to use a different path.

This release contains a new feature, a new node, a node update and bug fixes.

#### Override the npm registry

This release adds the option to override the npm registry for installing community packages. This is a paid feature.

We now also prevent npm downloading community packages from a compromised npm registry by explicitly using --registry in all npm install commands.

#### New node: AI Transform

This release adds the [AI Transform node](../integrations/builtin/core-nodes/n8n-nodes-base.aitransform/). Use the AI Transform node to generate code snippets based on your prompt. The AI is context-aware, understanding the workflow’s nodes and their data types. The node is only available on [Cloud plans](../manage-cloud/overview/).

This release adds the [Okta node](../integrations/builtin/app-nodes/n8n-nodes-base.okta/). Use the Okta node to automate work in Okta and integrate Okta with other applications. n8n has built-in support for a wide range of Okta features, which includes creating, updating, and deleting users.

- [MySQL](../integrations/builtin/app-nodes/n8n-nodes-base.mysql/)

This release also adds the new schema view for the expression editor modal.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.54.0...n8n@1.54.1) for this version.\
**Release date:** 2024-08-13

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.53.1...n8n@1.53.2) for this version.\
**Release date:** 2024-08-08

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.53.1...n8n@1.54.0) for this version.\
**Release date:** 2024-08-07

This release contains new features, node enhancements, bug fixes and updates to our API.

Our [public REST API](../api/) now supports additional operations:

- Create, delete, and edit roles for users
- Create, read, update and delete projects

Find the details in the [API reference](../api/api-reference/).

[CodeShakingSheep](https://github.com/CodeShakingSheep)\
[Javier Ferrer González](https://github.com/JavierCane)\
[Mickaël Andrieu](https://github.com/mickaelandrieu)\
[Oz Weiss](https://github.com/thewizarodofoz)\
[Pemontto](https://github.com/pemontto)

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.45.1...n8n@1.45.2) for this version.\
**Release date:** 2024-08-06

This release contains a bug fix.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.53.0...n8n@1.53.1) for this version.\
**Release date:** 2024-08-02

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.52.2...n8n@1.53.0) for this version.\
**Release date:** 2024-07-31

This release contains new features, new nodes, node enhancements, bug fixes and updates to our API.

#### Added Google Cloud Platform Secrets Manager support

This release adds [Google Cloud Platform Secrets Manager](../external-secrets/) to the list of external secret stores. We already support AWS secrets, Azure Key Vault, Infisical and HashiCorp Vault. External secret stores are available under an enterprise license.

#### New node: Information Extractor

This release adds the [Information Extractor node](../integrations/builtin/cluster-nodes/root-nodes/n8n-nodes-langchain.information-extractor/). The node is specifically tailored for information extraction tasks. It uses Structured Output Parser under the hood, but provides a simpler way to extract information from text in a structured JSON form.

#### New node: Sentiment Analysis

This release adds the [Sentiment Analysis node](../integrations/builtin/cluster-nodes/root-nodes/n8n-nodes-langchain.sentimentanalysis/). The node leverages LLMs to analyze and categorize the sentiment of input text. Users can easily integrate this node into their workflows to perform sentiment analysis on text data. The node is flexible enough to handle various use cases, from basic positive/negative classification to more nuanced sentiment categories.

- [Calendly Trigger](../integrations/builtin/trigger-nodes/n8n-nodes-base.calendlytrigger/)
- [HTTP Request](../integrations/builtin/core-nodes/n8n-nodes-base.httprequest/)
- [n8n Form Trigger](../integrations/builtin/core-nodes/n8n-nodes-base.formtrigger/)
- [Shopify](../integrations/builtin/app-nodes/n8n-nodes-base.shopify/)

Our [public REST API](../api/) now supports additional operations:

- Create, read, and delete for variables
- Filtering workflows by project
- Transferring workflows

Find the details in the [API reference](../api/api-reference/).

[feelgood-interface](https://github.com/feelgood-interface)\
[Oz Weiss](https://github.com/thewizarodofoz)

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.52.1...n8n@1.52.2) for this version.\
**Release date:** 2024-07-31

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.52.0...n8n@1.52.1) for this version.\
**Release date:** 2024-07-26

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.51.1...n8n@1.51.2) for this version.\
**Release date:** 2024-07-26

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.51.1...n8n@1.52.0) for this version.\
**Release date:** 2024-07-25

[Breaking change](https://github.com/n8n-io/n8n/blob/master/packages/cli/BREAKING-CHANGES.md)

Prometheus metrics enabled via N8N_METRICS_INCLUDE_DEFAULT_METRICS and N8N_METRICS_INCLUDE_API_ENDPOINTS were fixed to include the default n8n\_ prefix.

If you are using Prometheus metrics from these categories and are using a non-empty prefix, please update those metrics to match their new prefixed names.

This release contains new features, node enhancements and bug fixes.

#### Added Azure Key Vault support

This release adds [Azure Key Vault](../external-secrets/) to the list of external secret stores. We already support AWS secrets, Infisical and HashiCorp Vault and are working on Google Secrets Manager. External secret stores are available under an enterprise license.

- [Pinecone Vector Store](../integrations/builtin/cluster-nodes/root-nodes/n8n-nodes-langchain.vectorstorepinecone/)
- [Supabase Vector Store](../integrations/builtin/cluster-nodes/root-nodes/n8n-nodes-langchain.vectorstoresupabase/)
- [Send Email](../integrations/builtin/core-nodes/n8n-nodes-base.sendemail/)

- OpenAI Model: You can use the OpenAI Chat Model instead
- Google Palm Chat Model: You can use Google Vertex or Gemini instead
- Google Palm Model: You can use Google Vertex or Gemini instead

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.51.0...n8n@1.51.1) for this version.\
**Release date:** 2024-07-23

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.50.1...n8n@1.50.2) for this version.\
**Release date:** 2024-07-23

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.50.1...n8n@1.51.0) for this version.\
**Release date:** 2024-07-18

This release contains new nodes, node enhancements and bug fixes.

#### New node: Text Classifier

This release adds the [Text Classifier node](../integrations/builtin/cluster-nodes/root-nodes/n8n-nodes-langchain.text-classifier/).

#### New node: Postgres Chat Memory

This release adds the [Postgres Chat Memory node](../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.memorypostgreschat/).

#### New node: Google Vertex Chat Model

This release adds the [Google Vertex Chat Model node](../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.lmchatgooglevertex/).

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

- Enhanced nodes: Asana

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.50.0...n8n@1.50.1) for this version.\
**Release date:** 2024-07-16

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.49.0...n8n@1.50.0) for this version.\
**Release date:** 2024-07-10

This release contains node enhancements and bug fixes.

- Enhanced nodes: Chat Trigger, Google Cloud Firestore, Qdrant Vector Store, Splunk, Telegram
- Deprecated node: Orbit (product shut down)

### Beta Feature Removal

The Ask AI beta feature for the HTTP Request node has been removed from this version

[Stanley Yoshinori Takamatsu](https://github.com/stanleytakamatsu)\
[CodeShakingSheep](https://github.com/CodeShakingSheep)\
[jeanpaul](https://github.com/jeanpaul)\
[adrian-martinez-onestic](https://github.com/adrian-martinez-onestic)\
[Malki Davis](https://github.com/mxdavis)

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.48.3...n8n@1.49.0) for this version.\
**Release date:** 2024-07-03

This release contains a new node, node enhancements, and bug fixes.

- New node added: [Vector Store Tool](../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.toolvectorstore/) for the AI Agent
- Enhanced nodes: Zep Cloud Memory, Copper, Embeddings Cohere, GitHub, Merge, Zammad

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

[Jochem](https://github.com/jvdweerthof)\
[KhDu](https://github.com/KhDu)\
[Nico Weichbrodt](https://github.com/envy)\
[Pavlo Paliychuk](https://github.com/paul-paliychuk)

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.48.2...n8n@1.48.3) for this version.\
**Release date:** 2024-07-03

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.47.2...n8n@1.47.3) for this version.\
**Release date:** 2024-07-03

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.48.1...n8n@1.48.2) for this version.\
**Release date:** 2024-07-01

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.47.1...n8n@1.47.2) for this version.\
**Release date:** 2024-07-01

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.48.0...n8n@1.48.1) for this version.\
**Release date:** 2024-06-27

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.47.1...n8n@1.48.0) for this version.\
**Release date:** 2024-06-27

This release contains bug fixes and feature enhancements.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

[KubeAl](https://github.com/KubeAl)

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.47.0...n8n@1.47.1) for this version.\
**Release date:** 2024-06-26

This is a bug fix release.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.46.0...n8n@1.47.0) for this version.\
**Release date:** 2024-06-20

Calling `$(...).last()` (or `(...).first()` or `$(...).all()`) without arguments now returns the last item (or first or all items) of the output that connects two nodes. Previously, it returned the item/items of the first output of that node. Refer to the [breaking changes log](https://github.com/n8n-io/n8n/blob/master/packages/cli/BREAKING-CHANGES.md#1470) for details.

This release contains bug fixes, feature enhancements, a new node, node enhancements and performance improvements.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

#### New node: HTTP request tool

This release adds the HTTP request tool. You can use it with an AI agent as a tool to collect information from a website or API. Refer to the [HTTP request tool](../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.toolhttprequest/) for details.

[Daniel](https://github.com/daniel-alba17)\
[ekadin-mtc](https://github.com/ekadin-mtc)\
[Eric Francis](https://github.com/EricFrancis12)\
[Josh Sorenson](https://github.com/joshsorenson)\
Mohammad Alsmadi [Nikolai T. Jensen](https://github.com/ch0wm3in)\
[n8n-ninja](https://github.com/n8n-ninja)\
[pebosi](https://github.com/pebosi)\
[Taylor Hoffmann](https://github.com/TaylorHo)

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.45.0...n8n@1.45.1) for this version.\
**Release date:** 2024-06-12

This is a bug fix release.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.45.0...n8n@1.46.0) for this version.\
**Release date:** 2024-06-12

This release contains feature enhancements, node enhancements, and bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

[Jean Khawand](https://github.com/jeankhawand)\
[pemontto](https://github.com/pemontto)\
[Valentin Coppin](https://github.com/valimero)

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.44.1...n8n@1.44.2) for this version.\
**Release date:** 2024-06-12

This is a bug fix release.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.42.1...n8n@1.42.2) for this version.\
**Release date:** 2024-06-10

This is a bug fix release.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.44.1...n8n@1.45.0) for this version.\
**Release date:** 2024-06-06

This release contains new features, node enhancements, and bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.44.0...n8n@1.44.1) for this version.\
**Release date:** 2024-06-03

This is a bug fix release.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.43.1...n8n@1.44.0) for this version.\
**Release date:** 2024-05-30

This release contains new features, node enhancements, and bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.43.0...n8n@1.43.1) for this version.\
**Release date:** 2024-05-28

This is a bug fix release.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.42.1...n8n@1.43.0) for this version.\
**Release date:** 2024-05-22

This release contains new features, node enhancements, and bug fixes.

Although this release doesn't include a breaking change, it is a significant update including database migrations. n8n recommends backing up your data before updating to this version.

Credential sharing required for manual executions

Instance owners and admins: you will see changes if you try to manually execute a workflow where the credentials aren't shared with you. Manual workflow executions now use the same permissions checks as production executions, meaning you can't do a manual execution of a workflow if you don't have access to the credentials. Previously, owners and admins could do manual executions without credentials being shared with them. To resolve this, the credential creator needs to [share the credential](../credentials/credential-sharing/) with you.

#### New feature: Projects

With projects and roles, you can give your team access to collections of workflows and credentials, rather than having to share each workflow and credential individually. Simultaneously, you tighten security by limiting access to people on the relevant team.

Refer to the [RBAC](../user-management/rbac/) documentation for information on creating projects and using roles.

The number of projects and role types vary depending on your plan. Refer to [Pricing](https://n8n.io/pricing/) for details.

[](/_video/release-notes/rbac-glimpse.mp4)

#### New node: Slack Trigger

This release adds a trigger node for Slack. Refer to the [Slack Trigger documentation](../integrations/builtin/trigger-nodes/n8n-nodes-base.slacktrigger/) for details.

- Improved [memory support for OpenAI assistants](../integrations/builtin/app-nodes/n8n-nodes-langchain.openai/).

### Rolling back to a previous version

If you update to this version, then decide you need to role back:

1. Delete any RBAC projects you created.
1. Revert the database migrations using `n8n db:revert`.

Cloud: contact [help@n8n.io](mailto:help@n8n.io).

[Ayato Hayashi](https://github.com/hayashi-ay)\
[Daniil Zobov](https://github.com/ddzobov)\
[Guilherme Barile](https://github.com/GuilhermeBarile)\
[Romain MARTINEAU](https://github.com/RJiraya)

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.42.0...n8n@1.42.1) for this version.\
**Release date:** 2024-05-20

This is a bug fix release.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.41.0...n8n@1.41.1) for this version.\
**Release date:** 2024-05-16

This is a bug fix release.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.41.0...n8n@1.42.0) for this version.\
**Release date:** 2024-05-15

This release contains new features, node enhancements, and bug fixes.

Note that this release removes the AI error debugger. We're working on a new and improved version.

#### New feature: Tools Agent

This release adds a new option to the Agent node: the [Tools Agent](../integrations/builtin/cluster-nodes/root-nodes/n8n-nodes-langchain.agent/tools-agent/).

This agent has an enhanced ability to work with tools, and can ensure a standard output format. This is now the recommended default agent.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

[Mike Quinlan](https://github.com/mjquinlan2000)\
[guangwu](https://github.com/testwill)

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.40.0...n8n@1.41.0) for this version.\
**Release date:** 2024-05-08

This release contains new features, node enhancements, and bug fixes.

Note that this release temporarily disables the AI error helper.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

[Florin Lungu](https://github.com/floryn90)

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.39.1...n8n@1.40.0) for this version.\
**Release date:** 2024-05-02

Please note that this version contains a breaking change for instances using a Postgres database. The default value for the DB_POSTGRESDB_USER environment variable was switched from `root` to `postgres`. Refer to the [breaking changes log](https://github.com/n8n-io/n8n/blob/master/packages/cli/BREAKING-CHANGES.md#1400) for details.

This release contains new features, new nodes, node enhancements, and bug fixes.

#### New feature: Ask AI in the HTTP node

You can now ask AI to help create API requests in the HTTP Request node:

1. In the HTTP Request node, select **Ask AI**.
1. Enter the **Service** and **Request** you want to use. For example, to use the NASA API to get their picture of the day, enter `NASA` in **Service** and `get picture of the day` in **Request**.
1. Check the parameters: the AI tries to fill them out, but you may still need to adjust or correct the configuration.

Self-hosted users need to [enable AI features and provide their own API keys](../hosting/configuration/environment-variables/)

#### New node: Groq Chat Model

This release adds the [Groq Chat Model node](../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.lmchatgroq/).

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

[Alberto Pasqualetto](https://github.com/albertopasqualetto)\
[Bram Kn](https://github.com/bramkn)\
[CodeShakingSheep](https://github.com/CodeShakingSheep)\
[Nicolas-nwb](https://github.com/Nicolas-nwb)\
[pemontto](https://github.com/pemontto)\
[pengqiseven](https://github.com/pengqiseven)\
[webk](https://github.com/webkp)\
[Yoshino-s](https://github.com/Yoshino-s)

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.39.0...n8n@1.39.1) for this version.\
**Release date:** 2024-04-25

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.38.1...n8n@1.38.2) for this version.\
**Release date:** 2024-04-25

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.37.3...n8n@1.37.4) for this version.\
**Release date:** 2024-04-25

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.38.1...n8n@1.39.0) for this version.\
**Release date:** 2024-04-24

This release contains new nodes, node enhancements, and bug fixes.

#### New node: WhatsApp Trigger

This release adds the [WhatsApp Trigger node](../integrations/builtin/trigger-nodes/n8n-nodes-base.whatsapptrigger/).

#### Node enhancement: Multiple methods, one Webhook node

The Webhook Trigger node can now handle calls to multiple HTTP methods. Refer to the [Webhook node documentation](../integrations/builtin/core-nodes/n8n-nodes-base.webhook/common-issues/#listen-for-multiple-http-methods) for information on enabling this.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

[Bram Kn](https://github.com/bramkn)

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.38.0...n8n@1.38.1) for this version.\
**Release date:** 2024-04-18

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.37.2...n8n@1.37.3) for this version.\
**Release date:** 2024-04-18

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.37.2...n8n@1.38.0) for this version.\
**Release date:** 2024-04-17

This release contains new nodes, bug fixes, and node enhancements.

#### New node: Google Gemini Chat Model

This release adds the [Google Gemini Chat Model sub-node](../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.lmchatgooglegemini/).

#### New node: Embeddings Google Gemini

This release adds the [Google Gemini Embeddings sub-node](../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.embeddingsgooglegemini/).

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

[Chengyou Liu](https://github.com/cyliu0)\
[Francesco Mannino](https://github.com/manninofrancesco)

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.37.1...n8n@1.37.2) for this version.\
**Release date:** 2024-04-17

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.36.3...n8n@1.36.4) for this version.\
**Release date:** 2024-04-15

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.36.2...n8n@1.36.3) for this version.\
**Release date:** 2024-04-12

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.37.0...n8n@1.37.1) for this version.\
**Release date:** 2024-04-11

Please note that this version contains a breaking change for self-hosted n8n. It removes the `--file` flag for the `execute` CLI command. If you have scripts relying on the `--file` flag, update them to first import the workflow and then execute it using the `--id` flag. Refer to [CLI commands](../hosting/cli-commands/) for more information on CLI options.

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.36.1...n8n@1.36.2) for this version.\
**Release date:** 2024-04-11

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.36.1...n8n@1.37.0) for this version.\
**Release date:** 2024-04-10

Please note that this version contains a breaking change for self-hosted n8n. It removes the `--file` flag for the `execute` CLI command. If you have scripts relying on the `--file` flag, update them to first import the workflow and then execute it using the `--id` flag. Refer to [CLI commands](../hosting/cli-commands/) for more information on CLI options.

This release contains a new node, improvements to error handling and messaging, node enhancements, and bug fixes.

This release adds the [JWT core node](../integrations/builtin/core-nodes/n8n-nodes-base.jwt/).

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

[Miguel Prytoluk](https://github.com/mprytoluk)

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.36.0...n8n@1.36.1) for this version.\
**Release date:** 2024-04-04

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.35.0...n8n@1.36.0) for this version.\
**Release date:** 2024-04-03

This release contains new nodes, enhancements and bug fixes.

#### New node: Salesforce Trigger node

This release adds the [Salesforce Trigger node](../integrations/builtin/trigger-nodes/n8n-nodes-base.salesforcetrigger/).

#### New node: Twilio Trigger node

This release adds the [Twilio Trigger node](../integrations/builtin/trigger-nodes/n8n-nodes-base.twiliotrigger/).

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.34.2...n8n@1.35.0) for this version.\
**Release date:** 2024-03-28

This release contains enhancements and bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.34.1...n8n@1.34.2) for this version.\
**Release date:** 2024-03-26

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.34.0...n8n@1.34.1) for this version.\
**Release date:** 2024-03-25

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.33.1...n8n@1.34.0) for this version.\
**Release date:** 2024-03-20

This release contains new features, new nodes, and bug fixes.

#### New node: Microsoft OneDrive Trigger node

This release adds the [Microsoft OneDrive Trigger node](../integrations/builtin/trigger-nodes/n8n-nodes-base.microsoftonedrivetrigger/). You can now trigger workflows on file and folder creation and update events.

#### New data transformation functions

This release introduces new [data transformation functions](../code/builtin/data-transformation-functions/):

[Bram Kn](https://github.com/bramkn)\
[pemontto](https://github.com/pemontto)

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.33.0...n8n@1.33.1) for this version.\
**Release date:** 2024-03-15

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.32.1...n8n@1.32.2) for this version.\
**Release date:** 2024-03-15

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.32.1...n8n@1.33.0) for this version.\
**Release date:** 2024-03-13

This release contains new features, node enhancements, and bug fixes.

#### Support for Claude 3

This release adds support for Claude 3 to the [Anthropic Chat Model](../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.lmchatanthropic/) node.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

[gumida](https://github.com/gumida)\
[Ayato Hayashi](https://github.com/hayashi-ay)\
[Jordan](https://github.com/jordanburke)\
[MC Naveen](https://github.com/mcnaveen)

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.32.0...n8n@1.32.1) for this version.\
**Release date:** 2024-03-07

This is a bug fix release.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.31.1...n8n@1.31.2) for this version.\
**Release date:** 2024-03-07

This is a bug fix release.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.31.1...n8n@1.32.0) for this version.\
**Release date:** 2024-03-06

This release contains new features, node enhancements, performance improvements, and bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.31.0...n8n@1.31.1) for this version.\
**Release date:** 2024-03-06

Please note that this version contains a breaking change. HTTP connections to the editor will fail on domains other than localhost. You can read more about it [here](https://github.com/n8n-io/n8n/blob/master/packages/cli/BREAKING-CHANGES.md#1320).

This is a bug fix release and it contains a breaking change.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.30.0...n8n@1.31.0) for this version.\
**Release date:** 2024-02-28

This release contains new features, new nodes, node enhancements and bug fixes.

#### New nodes: Microsoft Outlook trigger and Ollama embeddings

This release adds two new nodes.

- [Microsoft Outlook Trigger](../integrations/builtin/trigger-nodes/n8n-nodes-base.microsoftoutlooktrigger/)
- [Ollama Embeddings](../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.embeddingsollama/)

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.30.0...n8n@1.30.1) for this version.\
**Release date:** 2024-02-23

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.29.1...n8n@1.30.0) for this version.\
**Release date:** 2024-02-21

This release contains new features, node enhancements, and bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.29.0...n8n@1.29.1) for this version.\
**Release date:** 2024-02-16

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.28.0...n8n@1.29.0) for this version.\
**Release date:** 2024-02-15

This release contains new features, node enhancements, and bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

#### OpenAI node overhaul

This release includes a new version of the [OpenAI node](../integrations/builtin/app-nodes/n8n-nodes-langchain.openai/), adding more operations, including support for working with assistants.

- Support for AI events in [log streaming](../log-streaming/).
- Added support for workflow tags in the [public API](../api/).

[Bruno Inec](https://github.com/sweenu)\
[Jesús Burgers](https://github.com/jburgers-chakray)

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.27.2...n8n@1.27.3) for this version.\
**Release date:** 2024-02-15

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.27.2...n8n@1.28.0) for this version.\
**Release date:** 2024-02-07

This release contains new features, new nodes, node enhancements and bug fixes.

#### New nodes: Azure OpenAI chat model and embeddings

This release adds two new nodes to work with [Azure OpenAI](https://azure.microsoft.com/en-gb/products/ai-services/openai-service/) in your advanced AI workflows:

- [Embeddings Azure OpenAI](../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.embeddingsazureopenai/)
- [Azure OpenAI Chat Model](../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.lmchatazureopenai/)

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

[Andrea Ascari](https://github.com/ascariandrea)

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.27.1...n8n@1.27.2) for this version.\
**Release date:** 2024-02-02

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.26.0...n8n@1.27.1) for this version.\
**Release date:** 2024-01-31

This release contains new features, node enhancements, and bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.26.0...n8n@1.27.0) for this version.\
**Release date:** 2024-01-31

This release removes `own` mode for self-hosted n8n. You must now use `EXECUTIONS_MODE` and set to either `regular` or `queue`. Refer to [Queue mode](../hosting/scaling/queue-mode/) for information on configuring queue mode.

Please upgrade directly to 1.27.1.

This release contains node enhancements and bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.25.1...n8n@1.26.0) for this version.\
**Release date:** 2024-01-24

This release contains new features, node enhancements, and bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

[Daniel Schröder](https://github.com/schroedan)\
[Nihaal Sangha](https://github.com/nihaals)

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.25.0...n8n@1.25.1) for this version.\
**Release date:** 2024-01-22

This is a bug fix release.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

[Nihaal Sangha](https://github.com/nihaals)

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.24.1...n8n@1.25.0) for this version.\
**Release date:** 2024-01-17

This release contains a new node, feature improvements, and bug fixes.

#### New node: Chat Memory Manager

The [Chat Memory Manager](../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.memorymanager/) node replaces the Chat Messages Retriever node. It manages chat message memories within your AI workflows.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.24.0...n8n@1.24.1) for this version.\
**Release date:** 2024-01-16

This is a bug fix release.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.22.5...n8n@1.22.6) for this version.\
**Release date:** 2024-01-10

This is a bug fix release. It includes important fixes for the HTTP Request and monday.com nodes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.23.0...n8n@1.24.0) for this version.\
**Release date:** 2024-01-10

This release contains new nodes for advanced AI, node enhancements, new features, performance enhancements, and bug fixes.

n8n has created a new [Chat Trigger node](../integrations/builtin/core-nodes/n8n-nodes-langchain.chattrigger/). The new node provides a chat interface that you can make publicly available, with customization and authentication options.

#### Mistral Cloud Chat and Embeddings

This release introduces two new nodes to support [Mistral AI](https://mistral.ai/):

- [Mistral Cloud Chat Model](../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.lmchatmistralcloud/)
- [Embeddings Mistral Cloud](../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.embeddingsmistralcloud/)

[Anush](https://github.com/Anush008)\
[Eric Koleda](https://github.com/ekoleda-codaio)\
[Mason Geloso](https://github.com/MasonGeloso)\
[vacitbaydarman](https://github.com/vacitbaydarman)

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.22.4...n8n@1.22.5) for this version.\
**Release date:** 2024-01-09

This is a bug fix release.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.22.4...n8n@1.23.0) for this version.\
**Release date:** 2024-01-03

This release contains new nodes, node enhancements, new features, and bug fixes.

#### New nodes and improved experience for working with files

This release includes a major overhaul of nodes relating to files (binary data).

There are now three key nodes dedicated to handling binary data files:

- [Read/Write Files from Disk](../integrations/builtin/core-nodes/n8n-nodes-base.readwritefile/) to read and write files from/to the machine where n8n is running.
- [Convert to File](../integrations/builtin/core-nodes/n8n-nodes-base.converttofile/) to take input data and output it as a file.
- [Extract From File](../integrations/builtin/core-nodes/n8n-nodes-base.extractfromfile/) to get data from a binary format and convert it to JSON.

n8n has moved support for iCalendar, PDF, and spreadsheet formats into these nodes, and removed the iCalendar, Read PDF, and Spreadsheet File nodes. There are still standalone nodes for [HTML](../integrations/builtin/core-nodes/n8n-nodes-base.html/) and [XML](../integrations/builtin/core-nodes/n8n-nodes-base.xml/).

#### New node: Qdrant vector store

This release adds support for [Qdrant](https://qdrant.tech/) with the Qdrant vector store node.

Read n8n's [Qdrant vector store node documentation](../integrations/builtin/cluster-nodes/root-nodes/n8n-nodes-langchain.vectorstoreqdrant/)

[Aaron Gutierrez](https://github.com/aarongut)\
[Advaith Gundu](https://github.com/geodic)\
[Anush](https://github.com/Anush008)\
[Bin](https://github.com/soulhat)\
[Nihaal Sangha](https://github.com/nihaals)

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.22.3...n8n@1.22.4) for this version.\
**Release date:** 2024-01-03

This is a bug fix release.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.22.2...n8n@1.22.3) for this version.\
**Release date:** 2023-12-27

Upgrade directly to 1.22.4

Due to issues with this release, upgrade directly to 1.22.4.

This is a bug fix release.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.22.1...n8n@1.22.2) for this version.\
**Release date:** 2023-12-27

Upgrade directly to 1.22.4

Due to issues with this release, upgrade directly to 1.22.4.

This is a bug fix release.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.22.0...n8n@1.22.1) for this version.\
**Release date:** 2023-12-21

This is a bug fix release.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.21.1...n8n@1.22.0) for this version.\
**Release date:** 2023-12-21

This release contains node enhancements, new features, performance improvements, and bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.18.3...n8n@1.18.4) for this version.\
**Release date:** 2023-12-19

This is a bug fix release.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.20.0...n8n@1.21.1) for this version.\
**Release date:** 2023-12-15

This is a bug fix release.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.18.2...n8n@1.18.3) for this version.\
**Release date:** 2023-12-15

This is a bug fix release.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.20.0...n8n@1.21.0) for this version.\
**Release date:** 2023-12-13

This release contains new features and nodes, node enhancements, and bug fixes.

#### New user role: Admin

This release introduces a third account type: admin. This role is available on pro and enterprise plans. Admins have similar permissions to instance owners.

[Read more about user roles](../user-management/account-types/)

#### New data transformation nodes

This release replaces the Item Lists node with a collection of nodes for data transformation tasks:

- [Aggregate](../integrations/builtin/core-nodes/n8n-nodes-base.aggregate/): take separate items, or portions of them, and group them together into individual items.
- [Limit](../integrations/builtin/core-nodes/n8n-nodes-base.aggregate/): remove items beyond a defined maximum number.
- [Remove Duplicates](../integrations/builtin/core-nodes/n8n-nodes-base.removeduplicates/): identify and delete items that are identical across all fields or a subset of fields.
- [Sort](../integrations/builtin/core-nodes/n8n-nodes-base.sort/): organize lists of in a desired ordering, or generate a random selection.
- [Split Out](../integrations/builtin/core-nodes/n8n-nodes-base.splitout/): separate a single data item containing a list into multiple items.
- [Summarize](../integrations/builtin/core-nodes/n8n-nodes-base.summarize/): aggregate items together, in a manner similar to Excel pivot tables.

#### Increased sharing permissions for owners and admins

Instance owners and users with the admin role can now see and share all workflows and credentials. They can't view sensitive credential information.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.19.5...n8n@1.20.0) for this version.\
**Release date:** 2023-12-06

This release contains bug fixes, node enhancements, and ongoing new feature work.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

[Andrey Starostin](https://github.com/mayorandrew)

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.19.4...n8n@1.19.5) for this version.\
**Release date:** 2023-12-05

This is a bug fix release.

This release removes the TensorFlow Embeddings node.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.18.1...n8n@1.18.2) for this version.\
**Release date:** 2023-12-05

This is a bug fix release.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.19.0...n8n@1.19.4) for this version.\
**Release date:** 2023-12-01

Missing ARM v7 support

This version doesn't support ARM v7. n8n is working on fixing this in future releases.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.18.0...n8n@1.19.0) for this version.\
**Release date:** 2023-11-29

Upgrade directly to 1.19.4

Due to issues with this release, upgrade directly to 1.19.4.

This release contains new features, node enhancements, and bug fixes.

#### LangChain general availability

This release adds LangChain support to the main n8n version. Refer to [LangChain](../advanced-ai/langchain/overview/) for more information on how to build AI tools in n8n, the new nodes n8n has introduced, and related learning resources.

#### Show avatars of users working on the same workflow

This release improves the experience of users collaborating on workflows. You can now see who else is editing at the same time as you.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.18.0...n8n@1.18.1) for this version.\
**Release date:** 2023-11-30

This is a bug fix release.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.17.1...n8n@1.18.0) for this version.\
**Release date:** 2023-11-22

This release contains new features and bug fixes.

#### Template creator hub

Built a template you want to share? This release introduces the n8n Creator hub. Refer to the [creator hub Notion doc](https://www.notion.so/n8n-Creator-hub-7bd2cbe0fce0449198ecb23ff4a2f76f) for more information on this project.

#### Node input and output search filter

Cloud Pro and Enterprise users can now search and filter the input and output data in nodes. Refer to [Data filtering](../data/data-filtering/) for more information.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.17.0...n8n@1.17.1) for this version.\
**Release date:** 2023-11-17

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.16.0...n8n@1.17.0) for this version.\
**Release date:** 2023-11-15

This release contains node enhancements and bug fixes.

#### Sticky Note Colors

You can now select background colors for sticky notes.

#### Discord Node Overhaul

An overhaul of the Discord node, improving the UI making it easier to configure, improving error handling, and fixing issues.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

[antondollmaier](https://github.com/antondollmaier)\
[teomane](https://github.com/teomane)

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.15.2...n8n@1.16.0) for this version.\
**Release date:** 2023-11-08

This release contains node enhancements and bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.15.1...n8n@1.15.2) for this version.\
**Release date:** 2023-11-07

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.14.2...n8n@1.15.1) for this version.\
**Release date:** 2023-11-02

This release contains new features, node enhancements, and bug fixes.

#### Workflow history

This release introduces workflow history: view and load previous versions of your workflows.

Workflow history is available in Enterprise n8n, and with limited history for Cloud Pro.

Learn more in the [Workflow history](../workflows/history/) documentation.

*Almost* in time for Halloween: this release introduces dark mode.

1. Select **Settings** > **Personal**.
1. Under **Personalisation**, change **Theme** to **Dark theme**.

#### Optional error output for nodes

All nodes apart from sub-nodes and trigger nodes have a new optional output: **Error**. Use this to add steps to handle node errors.

#### Pagination support added to HTTP Request node

The HTTP Request node now supports an pagination. Read the [node docs](../integrations/builtin/core-nodes/n8n-nodes-base.httprequest/) for information and examples.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

[Yoshino-s](https://github.com/Yoshino-s)

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.14.1...n8n@1.14.2) for this version.\
**Release date:** 2023-10-26

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.14.0...n8n@1.14.1) for this version.\
**Release date:** 2023-10-26

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.13.0...n8n@1.14.0) for this version.\
**Release date:** 2023-10-25

This release contains node enhancements and bug fixes.

#### Switch node supports more outputs

The [Switch node](../integrations/builtin/core-nodes/n8n-nodes-base.switch/) now supports an unlimited number of outputs.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.12.2...n8n@1.13.0) for this version.\
**Release date:** 2023-10-25

This release contains new features, feature enhancements, and bug fixes.

Upgrade directly to 1.14.0

This release failed to publish to npm. Upgrade directly to 1.14.0.

#### RSS Feed Trigger node

This releases introduces a new node, the [RSS Feed Trigger](../integrations/builtin/core-nodes/n8n-nodes-base.rssfeedreadtrigger/). Use this node to start a workflow when a new RSS feed item is published.

#### Facebook Lead Ads Trigger node

This releases add another new node, the [Facebook Lead Ads Trigger](../integrations/builtin/trigger-nodes/n8n-nodes-base.facebookleadadstrigger/). Use this node to trigger a workflow when you get a new lead.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.12.1...n8n@1.12.2) for this version.\
**Release date:** 2023-10-24

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

[Burak Akgün](https://github.com/mbakgun)

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.12.0...n8n@1.12.1) for this version.\
**Release date:** 2023-10-23

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

[Léo Martinez](https://github.com/martinezleoml)

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.11.1...n8n@1.11.2) for this version.\
**Release date:** 2023-10-23

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

[Inga](https://github.com/inga-lovinde)\
[pemontto](https://github.com/pemontto)

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.11.1...n8n@1.12.0) for this version.\
**Release date:** 2023-10-18

This release contains new features, node enhancements, and bug fixes.

#### Form Trigger node

This releases introduces a new node, the [n8n Form Trigger](../integrations/builtin/core-nodes/n8n-nodes-base.formtrigger/). Use this node to start a workflow based on a user submitting a form. It provides a configurable form interface.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

[Damian Karzon](https://github.com/dkarzon)\
[Inga](https://github.com/inga-lovinde)\
[pemontto](https://github.com/pemontto)

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.11.0...n8n@1.11.1) for this version.\
**Release date:** 2023-10-13

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.10.1...n8n@1.11.0) for this version.\
**Release date:** 2023-10-11

This release contains new features and bug fixes.

#### External storage for binary files

Self-hosted users can now use an external service to store binary data. Learn more in [External storage](../hosting/scaling/external-storage/).

If you're using n8n Cloud and are interested in this feature, please [contact n8n](https://n8n-community.typeform.com/to/y9X2YuGa).

#### Item Lists node supports binary data

The Item Lists node now supports splitting and concatenating binary data inputs. This means you no longer need to use code to split a collection of files into multiple items.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.10.0...n8n@1.10.1) for this version.\
**Release date:** 2023-10-11

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.9.2...n8n@1.9.3) for this version.\
**Release date:** 2023-10-10

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.9.1...n8n@1.9.2) for this version.\
**Release date:** 2023-10-09

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.9.1...n8n@1.10.0) for this version.\
**Release date:** 2023-10-05

This release contains bug fixes and preparatory work for new features.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.9.0...n8n@1.9.1) for this version.\
**Release date:** 2023-10-04

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

## LangChain in n8n (beta)

**Release date:** 2023-10-04

This release introduces support for building with LangChain in n8n.

With n8n's LangChain nodes you can build AI-powered functionality within your workflows. The LangChain nodes are configurable, meaning you can choose your preferred agent, LLM, memory, and other components. Alongside the LangChain nodes, you can connect any n8n node as normal: this means you can integrate your LangChain logic with other data sources and services.

- This is a beta release, and not yet available in the main product. Follow the instructions in [Access LangChain in n8n](../advanced-ai/langchain/overview/) to try it out. Self-hosted and Cloud options are available.
- Learn how LangChain concepts map to n8n nodes in [LangChain concepts in n8n](../advanced-ai/langchain/langchain-n8n/).
- Browse n8n's new [Cluster nodes](../integrations/builtin/cluster-nodes/). This is a new set of node types that allows for multiple nodes to work together to configure each other.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.8.2...n8n@1.9.0) for this version.\
**Release date:** 2023-09-28

This release contains new features, performance improvements, and bug fixes.

This releases replaces RiotTmpl, the templating language used in expressions, with n8n's own templating language, [Tournament](https://github.com/n8n-io/tournament). You can now use arrow functions in expressions.

#### `N8N_BINARY_DATA_TTL` and `EXECUTIONS_DATA_PRUNE_TIMEOUT` removed

The environment variables `N8N_BINARY_DATA_TTL` and `EXECUTIONS_DATA_PRUNE_TIMEOUT` no longer have any effect and can be removed. Instead of relying on a TTL system for binary data, n8n cleans up binary data together with executions during pruning.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.8.1...n8n@1.8.2) for this version.\
**Release date:** 2023-09-25

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.8.0...n8n@1.8.1) for this version.\
**Release date:** 2023-09-21

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.7.1...n8n@1.8.0) for this version.\
**Release date:** 2023-09-20

This release contains node enhancements and bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.7.0...n8n@1.7.1) for this version.\
**Release date:** 2023-09-14

This release contains bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.6.1...n8n@1.7.0) for this version.\
**Release date:** 2023-09-13

This release contains node enhancements and bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

[Quang-Linh LE](https://github.com/linktohack)\
[MC Naveen](https://github.com/mcnaveen)

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.6.0...n8n@1.6.1) for this version.\
**Release date:** 2023-09-06

This is a bug fix release.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.5.1...n8n@1.6.0) for this version.\
**Release date:** 2023-09-06

This release contains bug fixes, new features, and node enhancements.

Upgrade directly to 1.6.1

Skip this version and upgrade directly to 1.6.1, which contains essential bug fixes.

This release introduces support for TheHive API version 5. This uses a new node and credentials:

- [TheHive 5 node](../integrations/builtin/app-nodes/n8n-nodes-base.thehive5/)
- [TheHive 5 Trigger node](../integrations/builtin/trigger-nodes/n8n-nodes-base.thehive5trigger/)
- [TheHive 5 credentials](../integrations/builtin/credentials/thehive5/)

#### `N8N_PERSISTED_BINARY_DATA_TTL` removed

The environment variables `N8N_PERSISTED_BINARY_DATA_TTL` no longer has any effect and can be removed. This legacy flag was originally introduced to support ephemeral executions (see [details](https://github.com/n8n-io/n8n/pull/7046)), which are no longer supported.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.5.0...n8n@1.5.1) for this version.\
**Release date:** 2023-08-31

This is a bug fix release.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.4.1...n8n@1.5.0) for this version.\
**Release date:** 2023-08-31

This release contains new features, node enhancements, and bug fixes.

Upgrade directly to 1.5.1

Skip this version and upgrade directly to 1.5.1, which contains essential bug fixes.

#### External secrets storage for credentials

Enterprise-tier accounts can now use external secrets vaults to manage credentials in n8n. This allows you to store credential information securely outside your n8n instance. n8n supports Infisical and HashiCorp Vault.

Refer to [External secrets](../external-secrets/) for guidance on enabling and using this feature.

#### Two-factor authentication

n8n now supports two-factor authentication (2FA) for self-hosted instances. n8n is working on bringing support to Cloud. Refer to [Two-factor authentication](../user-management/two-factor-auth/) for guidance on enabling and using it.

#### Debug executions

Users on a paid n8n plan can now load data from previous executions into their current workflow. This is useful when debugging a failed execution.

Refer to [Debug executions](../workflows/executions/debug/) for guidance on using this feature.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.4.0...n8n@1.4.1) for this version.\
**Release date:** 2023-08-29

This is a bug fix release.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.3.1...n8n@1.4.0) for this version.\
**Release date:** 2023-08-23

This release contains new features, node enhancements, and bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

[pemontto](https://github.com/pemontto)

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.3.0...n8n@1.3.1) for this version.\
**Release date:** 2023-08-18

This is a bug fix release.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.2.2...n8n@1.3.0) for this version.\
**Release date:** 2023-08-16

This release contains new features and bug fixes.

#### Trial feature: AI support in the Code node

This release introduces limited support for using AI to generate code in the Code node. Initially this feature is only available on Cloud, and will gradually be rolled out, starting with about 20% of users.

Learn how to use the feature, including guidance on writing prompts, in [Generate code with ChatGPT](../code/ai-code/).

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

[Ian Gallagher](https://github.com/craSH)\
[Xavier Calland](https://github.com/xavier-calland)

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.2.1...n8n@1.2.2) for this version.\
**Release date:** 2023-08-14

This is a bug fix release.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.2.0...n8n@1.2.1) for this version.\
**Release date:** 2023-08-09

This is a bug fix release.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.1.1...n8n@1.2.0) for this version.\
**Release date:** 2023-08-09

This release contains new features, node enhancements, bug fixes, and performance improvements.

Upgrade directly to 1.2.1

When upgrading, skip this release and go directly to 1.2.1.

#### Credential support for SecOps services

This release introduces support for setting up credentials in n8n for the following services:

- [AlienVault](../integrations/builtin/credentials/alienvault/)
- [Auth0 Management](../integrations/builtin/credentials/auth0management/)
- [Carbon Black API](../integrations/builtin/credentials/carbonblack/)
- [Cisco Meraki API](../integrations/builtin/credentials/ciscomeraki/)
- [Cisco Secure Endpoint](../integrations/builtin/credentials/ciscosecureendpoint/)
- [Cisco Umbrella API](../integrations/builtin/credentials/ciscoumbrella/)
- [CrowdStrike](../integrations/builtin/credentials/crowdstrike/)
- [F5 Big-IP](../integrations/builtin/credentials/f5bigip/)
- [Fortinet FortiGate](../integrations/builtin/credentials/fortigate/)
- [Hybrid Analysis](../integrations/builtin/credentials/hybridanalysis/)
- [Imperva WAF](../integrations/builtin/credentials/impervawaf/)
- [Kibana](../integrations/builtin/credentials/kibana/)
- [Microsoft Entra ID](../integrations/builtin/credentials/microsoftentra/)
- [Mist](../integrations/builtin/credentials/mist/)
- [Okta](../integrations/builtin/credentials/okta/)
- [OpenCTI](../integrations/builtin/credentials/opencti/)
- [QRadar](../integrations/builtin/credentials/qradar/)
- [Qualys](../integrations/builtin/credentials/qualys/)
- [Recorded Future](../integrations/builtin/credentials/recordedfuture/)
- [Sekoia](../integrations/builtin/credentials/sekoia/)
- [Shuffler](../integrations/builtin/credentials/shuffler/)
- [Trellix ePO](../integrations/builtin/credentials/trellixepo/)
- [VirusTotal](../integrations/builtin/credentials/virustotal/)
- [Zscaler ZIA](../integrations/builtin/credentials/zscalerzia/)

This makes it easier to do [Custom operations](../integrations/custom-operations/) with these services, using the [HTTP Request](../integrations/builtin/core-nodes/n8n-nodes-base.httprequest/) node.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.1.0...n8n@1.1.1) for this version.\
**Release date:** 2023-07-27

This is a bug fix release.

Please note that this version contains breaking changes if upgrading from a `0.x.x` version. For full details, refer to the [n8n v1.0 migration guide](../1-0-migration-checklist/).

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.0.5...n8n@1.1.0) for this version.\
**Release date:** 2023-07-26

This release contains new features, bug fixes, and node enhancements.

Please note that this version contains breaking changes if upgrading from a `0.x.x` version. For full details, refer to the [n8n v1.0 migration guide](../1-0-migration-checklist/).

#### Source control and environments

This release introduces source control and environments for enterprise users.

n8n uses Git-based source control to support environments. Linking your n8n instances to a Git repository lets you create multiple n8n environments, backed by Git branches.

Refer to [Source control and environments](../source-control-environments/) to learn more about the features and set up your environments.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

[Adrián Martínez](https://github.com/adrian-martinez-vdshop)\
[Alberto Pasqualetto](https://github.com/albertopasqualetto)\
[Marten Steketee](https://github.com/Marten-S)\
[perseus-algol](https://github.com/perseus-algol)\
[Sandra Ashipala](https://github.com/sandramsc)\
[ZergRael](https://github.com/ZergRael)

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.0.4...n8n@1.0.5) for this version.\
**Release date:** 2023-07-24

This is a bug fix release.

Please note that this version contains breaking changes if upgrading from a `0.x.x` version. For full details, refer to the [n8n v1.0 migration guide](../1-0-migration-checklist/).

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.0.3...n8n@1.0.4) for this version.\
**Release date:** 2023-07-19

This is a bug fix release.

Please note that this version contains breaking changes if upgrading from a `0.x.x` version. For full details, refer to the [n8n v1.0 migration guide](../1-0-migration-checklist/).

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

[Romain Dunand](https://github.com/airmoi)\
[noctarius aka Christoph Engelbert](https://github.com/noctarius)

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.0.2...n8n@1.0.3) for this version.\
**Release date:** 2023-07-13

This release contains API enhancements and adds support for sending messages to forum threads in the Telegram node.

Please note that this version contains breaking changes if upgrading from a `0.x.x` version. For full details, refer to the [n8n v1.0 migration guide](../1-0-migration-checklist/).

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

[Kirill](https://github.com/chrtkv)

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.0.1...n8n@1.0.2) for this version.\
**Release date:** 2023-07-05

This is a bug fix release.

Please note that this version contains breaking changes if upgrading from a `0.x.x` version. For full details, refer to the [n8n v1.0 migration guide](../1-0-migration-checklist/).

[Romain Dunand](https://github.com/airmoi)

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@1.0.0...n8n@1.0.1) for this version.\
**Release date:** 2023-07-05

Please note that this version contains breaking changes. For full details, refer to the [n8n v1.0 migration guide](../1-0-migration-checklist/).

This is n8n's version one release.

For full details, refer to the [n8n v1.0 migration guide](../1-0-migration-checklist/).

Although JavaScript remains the default language, you can now also select Python as an option in the [Code node](../code/code-node/) and even make use of [many Python modules](https://pyodide.org/en/stable/usage/packages-in-pyodide.html#packages-in-pyodide). Note that Python is unavailable in Code nodes added to a workflow before v1.0.

[Marten Steketee](https://github.com/Marten-S)

**Examples:**

Example 1 (unknown):
```unknown
toDateTime() //replaces toDate(). toDate() is retained for backwards compatability.
parseJson()
extractUrlPath()
toBoolean()
base64Encode()
base64Decode()
```

Example 2 (unknown):
```unknown
toDateTime()
toBoolean()
```

Example 3 (unknown):
```unknown
toJsonString()
```

Example 4 (unknown):
```unknown
toJsonString()
```

---

## MailerLite credentials

**URL:** llms-txt#mailerlite-credentials

**Contents:**
- Prerequisites
- Supported authentication methods
- Related resources
- Using API key

You can use these credentials to authenticate the following nodes:

- [MailerLite](../../app-nodes/n8n-nodes-base.mailerlite/)
- [MailerLite Trigger](../../trigger-nodes/n8n-nodes-base.mailerlitetrigger/)

Create a [MailerLite](https://www.mailerlite.com/) account.

## Supported authentication methods

Refer to [MailerLite's API documentation](https://developers.mailerlite.com/docs/) for more information about the service.

To configure this credential, you'll need:

- An **API Key**: Generate an API key from the **Integrations** menu. Refer to the [API Authentication documentation](https://developers.mailerlite.com/docs/#authentication) for more detailed instructions.

Enable the **Classic API** toggle if the API key is for a MailerLite Classic account instead of the newer MailerLite experience.

Most new MailerLite accounts and all free accounts should disable the **Classic API** toggle. You can find out [which version of MailerLite you are using](https://www.mailerlite.com/help/which-version-of-mailerlite-am-i-using) and learn more about the differences between the two in the [MailerLite FAQ](https://www.mailerlite.com/help/new-mailerlite-faq).

---

## Airtable credentials

**URL:** llms-txt#airtable-credentials

**Contents:**
- Prerequisites
- Supported authentication methods
- Related resources
- Using personal access token
- Using OAuth2

You can use these credentials to authenticate the following nodes:

- [Airtable](../../app-nodes/n8n-nodes-base.airtable/)
- [Airtable Trigger](../../trigger-nodes/n8n-nodes-base.airtabletrigger/)

Create an [Airtable](https://airtable.com/) account.

## Supported authentication methods

- Personal Access Token (PAT)
- OAuth2

n8n used to offer an API key authentication method with Airtable. Airtable [fully deprecated these keys](https://support.airtable.com/v1/docs/airtable-api-deprecation-guidelines) as of February 2024. If you were using an Airtable API credential, replace it with an Airtable Personal Access Token or Airtable OAuth2 credential. n8n recommends using Personal Access Token instead.

Refer to [Airtable's API documentation](https://airtable.com/developers/web/api/authentication) for more information about the service.

## Using personal access token

To configure this credential, you'll need:

- A Personal **Access Token** (PAT)

1. Go to the Airtable Builder Hub [Personal access tokens](https://airtable.com/create/tokens) page.
1. Select **+ Create new token**. Airtable opens the **Create personal access token** page.
1. Enter a **Name** for your token, like `n8n credential`.
1. Add **Scopes** to your token. Refer to Airtable's [Scopes](https://airtable.com/developers/web/api/scopes) guide for more information. n8n recommends using these scopes:
   - `data.records:read`
   - `data.records:write`
   - `schema.bases:read`
1. Select the **Access** for your token. Choose from a single base, multiple bases (even bases from different workspaces), all of the current and future bases in a workspace you own, or all of the bases from any workspace that you own including bases/workspace added in the future.
1. Select **Create token**.
1. Airtable opens a modal with your token displayed. Copy this token and enter it in your n8n credential as the **Access Token**.

Refer to Airtable's [Find/create PATs documentation](https://support.airtable.com/v1/docs/creating-personal-access-tokens) for more information.

To configure this credential, you'll need:

- An **OAuth Redirect URL**
- A **Client ID**
- A **Client Secret**

To generate all this information, register a new Airtable integration:

1. Open your Airtable Builder Hub [**OAuth integrations**](https://airtable.com/create/oauth) page.
1. Select the **Register new OAuth integration** button.
1. Enter a name for your OAuth integration.
1. Copy the **OAuth Redirect URL** from your n8n credential.
1. Paste that redirect URL in Airtable as the **OAuth redirect URL**.
1. Select **Register integration**.
1. On the following page, copy the **Client ID** from Airtable and paste it into the **Client ID** in your n8n credential.
1. In Airtable, select **Generate client secret**.
1. Copy the client secret and paste it into the **Client Secret** in your n8n credential.
1. Select the following scopes in Airtable:
   - `data.records:read`
   - `data.records:write`
   - `schema.bases:read`
1. Select **Save changes** in Airtable.
1. In your n8n credential, select the **Connect my account**. A **Grant access** modal opens.
1. Follow the instructions and select the base you want to work on (or all bases).
1. Select **Grant access** to complete the connection.

Refer to the [Airtable Register a new integration documentation](https://airtable.com/developers/web/guides/oauth-integrations) for steps on registering a new Oauth integration.

---

## For a self-hosted n8n instance

**URL:** llms-txt#for-a-self-hosted-n8n-instance

curl -X 'GET' \
  '<N8N_HOST>:<N8N_PORT>/<N8N_PATH>/api/v<version-number>/workflows?active=true&limit=150&cursor=MTIzZTQ1NjctZTg5Yi0xMmQzLWE0NTYtNDI2NjE0MTc0MDA' \
  -H 'accept: application/json'

---

## Mailchimp node

**URL:** llms-txt#mailchimp-node

**Contents:**
- Operations
- Templates and examples
- What to do if your operation isn't supported

Use the Mailchimp node to automate work in Mailchimp, and integrate Mailchimp with other applications. n8n has built-in support for a wide range of Mailchimp features, including creating, updating, and deleting campaigns, as well as getting list groups.

On this page, you'll find a list of operations the Mailchimp node supports and links to more resources.

Refer to [Mailchimp credentials](../../credentials/mailchimp/) for guidance on setting up authentication.

- Campaign
  - Delete a campaign
  - Get a campaign
  - Get all the campaigns
  - Replicate a campaign
  - Creates a Resend to Non-Openers version of this campaign
  - Send a campaign
- List Group
  - Get all groups
- Member
  - Create a new member on list
  - Delete a member on list
  - Get a member on list
  - Get all members on list
  - Update a new member on list
- Member Tag
  - Add tags from a list member
  - Remove tags from a list member

## Templates and examples

**Process Shopify new orders with Zoho CRM and Harvest**

[View template details](https://n8n.io/workflows/1206-process-shopify-new-orders-with-zoho-crm-and-harvest/)

**Add new contacts from HubSpot to the email list in Mailchimp**

[View template details](https://n8n.io/workflows/1770-add-new-contacts-from-hubspot-to-the-email-list-in-mailchimp/)

**Send or update new Mailchimp subscribers in HubSpot**

[View template details](https://n8n.io/workflows/1771-send-or-update-new-mailchimp-subscribers-in-hubspot/)

[Browse Mailchimp integration templates](https://n8n.io/integrations/mailchimp/), or [search all templates](https://n8n.io/workflows/)

## What to do if your operation isn't supported

If this node doesn't support the operation you want to do, you can use the [HTTP Request node](../../core-nodes/n8n-nodes-base.httprequest/) to call the service's API.

You can use the credential you created for this service in the HTTP Request node:

1. In the HTTP Request node, select **Authentication** > **Predefined Credential Type**.
1. Select the service you want to connect to.
1. Select your credential.

Refer to [Custom API operations](../../../custom-operations/) for more information.

---

## Data

**URL:** llms-txt#data

**Contents:**
- Related resources
  - Data transformation nodes

Data is the information that n8n nodes receive and process. For basic usage of n8n you don't need to understand data structures and manipulation. However, it becomes important if you want to:

- Create your own node
- Write custom [expressions](../glossary/#expression-n8n)
- Use the Function or Function Item node

- [Data structure](data-structure/)
- [Data flow within nodes](data-flow-nodes/)
- [Transforming data](transforming-data/)
- [Process data using code](code/)
- [Pinning](data-pinning/) and [editing](data-editing/) data during workflow development.
- [Data mapping](data-mapping/) and [Item linking](data-mapping/data-item-linking/): how data items link to each other.

### Data transformation nodes

n8n provides a collection of nodes to transform data:

- [Aggregate](../integrations/builtin/core-nodes/n8n-nodes-base.aggregate/): take separate items, or portions of them, and group them together into individual items.
- [Limit](../integrations/builtin/core-nodes/n8n-nodes-base.aggregate/): remove items beyond a defined maximum number.
- [Remove Duplicates](../integrations/builtin/core-nodes/n8n-nodes-base.removeduplicates/): identify and delete items that are identical across all fields or a subset of fields.
- [Sort](../integrations/builtin/core-nodes/n8n-nodes-base.sort/): organize lists of in a desired ordering, or generate a random selection.
- [Split Out](../integrations/builtin/core-nodes/n8n-nodes-base.splitout/): separate a single data item containing a list into multiple items.
- [Summarize](../integrations/builtin/core-nodes/n8n-nodes-base.summarize/): aggregate items together, in a manner similar to Excel pivot tables.

---

## Box credentials

**URL:** llms-txt#box-credentials

**Contents:**
- Prerequisites
- Supported authentication methods
- Related resources
- Using OAuth2

You can use these credentials to authenticate the following nodes:

- [Box](../../app-nodes/n8n-nodes-base.box/)
- [Box Trigger](../../trigger-nodes/n8n-nodes-base.boxtrigger/)

Create a [Box](https://www.box.com/) account.

## Supported authentication methods

Refer to [Box's API documentation](https://developer.box.com/reference/) for more information about the service.

Note for n8n Cloud users

Cloud users don't need to provide connection details. Select **Connect my account** to connect through your browser.

If you need to configure OAuth2 from scratch or need more detail on what's happening in the OAuth web flow, you'll need to create a Custom App. Refer to the [Box OAuth2 Setup documentation](https://developer.box.com/guides/authentication/oauth2/oauth2-setup/) for more information.

---

## Edit Image

**URL:** llms-txt#edit-image

**Contents:**
- Operations
- Node parameters
  - Blur parameters
  - Border parameters
  - Composite parameters
  - Create parameters
  - Crop parameters
  - Draw parameters
  - Get Information parameters
  - Multi Step parameters

Use the Edit Image node to manipulate and edit images.

1. If you aren't running n8n on Docker, you need to install [GraphicsMagick](http://www.graphicsmagick.org/README.html).
1. You need to use a node such as the [Read/Write Files from Disk](../n8n-nodes-base.readwritefile/) node or the [HTTP Request](../n8n-nodes-base.httprequest/) node to pass the image file as a data property to the Edit Image node.

- Add a **Blur** to the image to reduce sharpness
- Add a **Border** to the image
- **Composite** an image on top of another image
- **Create** a new image
- **Crop** the image
- **Draw** on an image
- **Get Information** about the image
- **Multi Step** perform multiple operations on the image
- **Resize**: Change the size of the image
- **Rotate** the image
- **Shear** image along the X or Y axis
- Add **Text** to the image
- Make a color in image **Transparent**

The parameters for this node depend on the operation you select.

- **Property Name**: Enter the name of the binary property that stores the image data.
- **Blur**: Enter a number to set how strong the blur should be, between 0 and 1000. Higher numbers create blurrier images.
- **Sigma**: Enter a number to set the stigma for the blur, between 0 and 1000. Higher numbers create blurrier images.

Refer to [Node options](#node-options) for optional configuration options.

### Border parameters

- **Property Name**: Enter the name of the binary property that stores the image data.
- **Border Width**: Enter the width of the border.
- **Border Height**: Enter the height of the border.
- **Border Color**: Set the color for the border. You can either enter a hex or select the color swatch to open a color picker.

Refer to [Node options](#node-options) for optional configuration options.

### Composite parameters

- **Property Name**: Enter the name of the binary property that stores the image data. This image is your base image.
- **Composite Image Property**: Enter the name of the binary property that stores image to composite on top of the **Property Name** image.
- **Operator**: Select composite operator, which determines how the composite works. Options include:
  - **Add**
  - **Atop**
  - **Bumpmap**
  - **Copy**
  - **Copy Black**
  - **Copy Blue**
  - **Copy Cyan**
  - **Copy Green**
  - **Copy Magenta**
  - **Copy Opacity**
  - **Copy Red**
  - **Copy Yellow**
  - **Difference**
  - **Divide**
  - **In**
  - **Minus**
  - **Multiply**
  - **Out**
  - **Over**
  - **Plus**
  - **Subtract**
  - **Xor**
- **Position X**: Enter the x axis position (horizontal) of the composite image.
- **Position Y**: Enter the y axis position (vertical) of the composite image.

Refer to [Node options](#node-options) for optional configuration options.

### Create parameters

- **Property Name**: Enter the name of the binary property that stores the image data.
- **Background Color**: Set the background color for the image. You can either enter a hex or select the color swatch to open a color picker.
- **Image Width**: Enter the width of the image.
- **Image Height**: Enter the height of the image.

Refer to [Node options](#node-options) for optional configuration options.

- **Property Name**: Enter the name of the binary property that stores the image data.
- **Width**: Enter the width you'd like to crop to.
- **Height**: Enter the height you'd like to crop to.
- **Position X**: Enter the x axis position (horizontal) to start the crop from.
- **Position Y**: Enter the y axis position (vertical) to start the crop from.

Refer to [Node options](#node-options) for optional configuration options.

- **Property Name**: Enter the name of the binary property that stores the image data.
- **Primitive**: Select the primitive shape to draw. Choose from:
  - **Circle**
  - **Line**
  - **Rectangle**
- **Color**: Set the color for the primitive. You can either enter a hex or select the color swatch to open a color picker.
- **Start Position X**: Enter the x axis position (horizontal) to start drawing from.
- **Start Position Y**: Enter the y axis position (vertical) to start drawing from.
- **End Position X**: Enter the x axis position (horizontal) to stop drawing at.
- **End Position Y**: Enter the y axis position (vertical) to start drawing at.
- **Corner Radius**: Enter a number to set the corner radius. Adding a corner radius will round the corners of the drawn primitive.

Refer to [Node options](#node-options) for optional configuration options.

### Get Information parameters

For this operation, you only need to add the **Property Name** of the binary property that stores the image data.

Refer to [Node options](#node-options) for optional configuration options.

### Multi Step parameters

- **Property Name**: Enter the name of the binary property that stores the image data.
- **Operations**: Add the operations you want the multi step operation to perform. You can use any of the other operations.

Refer to [Node options](#node-options) for optional configuration options.

### Resize parameters

- **Property Name**: Enter the name of the binary property that stores the image data.
- **Width**: Enter the new width you'd like for the image.
- **Height**: Enter the new height you'd like for the image.
- **Option**: Select how you'd like to resize the image. Choose from:
  - **Ignore Aspect Ratio**: Ignore the aspect ratio and resize to the exact height and width you've entered.
  - **Maximum Area**: The height and width you've entered is the maximum area/size for the image. The image maintains its aspect ratio and won't be larger than the height and/or width you've entered.
  - **Minimum Area**: The height and width you've entered is the minimum area/size for the image. The image maintains its aspect ratio and won't be smaller than the height and/or width you've entered.
  - **Only if Larger**: Resize the image only if it's larger than the width and height you entered. The image maintains its aspect ratio.
  - **Only if Smaller**: Resize the image only if it's smaller than the width and height you entered. The image maintains its aspect ratio.
  - **Percent**: Resize the image using the width and height as percentages of the original image.

Refer to [Node options](#node-options) for optional configuration options.

### Rotate parameters

- **Property Name**: Enter the name of the binary property that stores the image data.
- **Rotate**: Enter the number of degrees to rotate the image, from --360 to 360.
- **Background Color**: Set the background color for the image. You can either enter a hex or select the color swatch to open a color picker. This color is used to fill in the empty background whenever the image is rotated by multiples of 90 degrees. If multipled of 90 degrees are used for the **Rotate** field, the background color isn't used.

Refer to [Node options](#node-options) for optional configuration options.

- **Property Name**: Enter the name of the binary property that stores the image data.
- **Degrees X**: Enter the number of degrees to shear from the x axis.
- **Degrees Y**: Enter the number of degrees to shear from the y axis.

Refer to [Node options](#node-options) for optional configuration options.

- **Property Name**: Enter the name of the binary property that stores the image data.
- **Text**: Enter the text you'd like to write on the image.
- **Font Size**: Select the font size for the text.
- **Font Color**: Set the font color. You can either enter a hex or select the color swatch to open a color picker.
- **Position X**: Enter the x axis position (horizontal) to begin the text at.
- **Position Y**: Enter the y axis position (vertical) to begin the text at.
- **Max Line Length**: Enter the maximum amount of characters in a line before adding a line break.

Refer to [Node options](#node-options) for optional configuration options.

### Transparent parameters

- **Property Name**: Enter the name of the binary property that stores the image data.
- **Color**: Set the color to make transparent. You can either enter a hex or select the color swatch to open a color picker.

Refer to [Node options](#node-options) for optional configuration options.

- **File Name**: Enter the filename of the output file.
- **Format**: Enter the image format of the output file. Choose from:
  - **bmp**
  - **gif**
  - **jpeg**
  - **png**
  - **tiff**
  - **WebP**

The **Text** operation also includes the option for **Font Name or ID**. Select the text font from the dropdown or specify an ID using an [expression](../../../../code/expressions/).

## Templates and examples

**Flux AI Image Generator**

[View template details](https://n8n.io/workflows/2417-flux-ai-image-generator/)

**Generate Instagram Content from Top Trends with AI Image Generation**

by mustafa kendigüzel

[View template details](https://n8n.io/workflows/2803-generate-instagram-content-from-top-trends-with-ai-image-generation/)

**AI-Powered WhatsApp Chatbot 🤖📲 for Text, Voice, Images & PDFs with memory 🧠**

[View template details](https://n8n.io/workflows/3586-ai-powered-whatsapp-chatbot-for-text-voice-images-and-pdfs-with-memory/)

[Browse Edit Image integration templates](https://n8n.io/integrations/edit-image/), or [search all templates](https://n8n.io/workflows/)

---

## Workflow settings

**URL:** llms-txt#workflow-settings

**Contents:**
- Access workflow settings
- Available settings
  - Execution order
  - Error Workflow (to notify when this one errors)
  - This workflow can be called by
  - Timezone
  - Save failed production executions
  - Save successful production executions
  - Save manual executions
  - Save execution progress

You can customize workflow behavior for individual workflows using workflow settings.

## Access workflow settings

To open the settings:

1. Open your workflow.
1. Select the **three dots icon** in the upper-right corner.
1. Select **Settings**. n8n opens the **Workflow settings** modal.

## Available settings

The following settings are available:

Choose the execution order for multi-branch workflows:

**v1 (recommended)** executes each branch in turn, completing one branch before starting another. n8n orders the branches based on their position on the [canvas](../../glossary/#canvas-n8n), from topmost to bottommost. If two branches are at the same height, the leftmost branch executes first.

**v0 (legacy)** executes the first node of each branch, then the second node of each branch, and so on.

### Error Workflow (to notify when this one errors)

Select a workflow to trigger if the current workflow fails. See [error workflows](../../flow-logic/error-handling/) for more details.

### This workflow can be called by

Choose which other workflows can call this workflow.

Sets the timezone for this workflow. The timezone setting is important for the Schedule Trigger node.

You can set your n8n instance's timezone to configure the default timezone workflows use:

- [Set a n8n Cloud instance timezone](../../manage-cloud/set-cloud-timezone/)
- [Configure the timezone for self-hosted instances](../../hosting/configuration/environment-variables/timezone-localization/)

If you don't configure the workflow or instance timezone, n8n defaults to the EDT (New York) timezone.

### Save failed production executions

Whether n8n should save failed executions for active workflows.

### Save successful production executions

Whether n8n should save successful executions for active workflows.

### Save manual executions

Whether n8n should save executions for workflows started by the user in the editor.

### Save execution progress

Whether n8n should save execution data for each node.

If set to **Save**, the workflow resumes from where it stopped in case of an error. This may increase latency.

Whether n8n should cancel the current workflow execution after a certain amount of time elapses.

When enabled, the **Timeout After** option appears. Here, you can set the time (in hours, minutes, and seconds) after which the workflow should timeout. For n8n Cloud users, n8n enforces a maximum available timeout for each plan.

### Estimated time saved

An estimate of the number of minutes each of execution of this workflow saves you.

Setting this lets n8n calculate the amount of time saved for [insights](../../insights/).

---

## Bitbucket Trigger node

**URL:** llms-txt#bitbucket-trigger-node

[Bitbucket](https://bitbucket.org/) is a web-based version control repository hosting service owned by Atlassian, for source code and development projects that use either Mercurial or Git revision control systems.

You can find authentication information for this node [here](../../credentials/bitbucket/).

Examples and templates

For usage examples and templates to help you get started, refer to n8n's [Bitbucket Trigger integrations](https://n8n.io/integrations/bitbucket-trigger/) page.

---

## Venafi TLS Protect Cloud Trigger node

**URL:** llms-txt#venafi-tls-protect-cloud-trigger-node

[Venafi](https://www.venafi.com/) is a cybersecurity company providing services for machine identity management. They offer solutions to manage and protect identities for a wide range of machine types, delivering global visibility, lifecycle automation, and actionable intelligence.

Use the n8n Venafi TLS Protect Cloud Trigger node to start a workflow in n8n in response to events in the [cloud-based Venafi TLS Protect](https://vaas.venafi.com/) service.

You can find authentication information for this node [here](../../credentials/venafitlsprotectcloud/).

Examples and templates

For usage examples and templates to help you get started, refer to n8n's [Venafi TLS Protect Cloud Trigger integrations](https://n8n.io/integrations/venafi-tls-protect-cloud-trigger/) page.

---

## RAG in n8n

**URL:** llms-txt#rag-in-n8n

**Contents:**
- What is RAG
- What is a vector store?
- How to use RAG in n8n
  - Inserting data into your vector store
  - Querying your data
  - Using agents
  - Using the node directly
- FAQs
  - How do I choose the right embedding model?
  - What is the best text splitting for my use case?

[Retrieval-Augmented Generation (RAG)](../../glossary/#ai-retrieval-augmented-generation-rag) is a technique that improves AI responses by combining language models with external data sources. Instead of relying solely on the model's internal training data, RAG systems retrieve relevant documents to [ground](../../glossary/#ai-groundedness) responses in up-to-date, domain-specific, or proprietary knowledge. RAG workflows typically rely on vector stores to manage and search this external data efficiently.

## What is a vector store?

A [vector store](../../glossary/#ai-vector-store) is a special database designed to store and search high-dimensional vectors: numerical representations of text, images, or other data. When you upload a document, the vector store splits it into chunks and converts each chunk into a vector using an [embedding model](../../glossary/#ai-embedding).

You can query these vectors using similarity searches, which construct results based on *semantic meaning*, rather than keyword matches. This makes vector stores a powerful foundation for RAG and other AI systems that need to retrieve and reason over large sets of knowledge.

## How to use RAG in n8n

Start with a RAG template

👉 Try out RAG in n8n with the [RAG Starter Template](https://n8n.io/workflows/5010-rag-starter-template-using-simple-vector-stores-form-trigger-and-openai). The template includes two ready-made workflows: one for uploading files and one for querying them.

### Inserting data into your vector store

Before your agent can access custom knowledge, you need to upload that data to a vector store:

1. Add the nodes needed to fetch your source data.
1. Insert a **Vector Store** node (e.g. the [Simple Vector Store](../../integrations/builtin/cluster-nodes/root-nodes/n8n-nodes-langchain.vectorstoreinmemory/)) and choose the **Insert Documents** operation.
1. Select an **embedding model**, which converts your text into vector embeddings. Consult the FAQ for more information on [choosing the right embedding model](#how-do-i-choose-the-right-embedding-model).
1. Add a [Default Data Loader](../../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.documentdefaultdataloader/) node, which splits your content into chunks. You can use the default settings or define your own chunking strategy:
   - **Character Text Splitter:** splits by character length.
   - **Recursive Character Text Splitter:** recursively splits by Markdown, HTML, code blocks or simple characters (recommended for most use cases).
   - **Token Text Splitter:** splits by token count.
1. (Optional) Add **metadata** to each chunk to enrich the context and allow better filtering later.

### Querying your data

You can query the data in two main ways: using an agent or directly through a node.

1. Add an [agent](../../integrations/builtin/cluster-nodes/root-nodes/n8n-nodes-langchain.agent/) to your workflow.
1. Add the vector store as a **tool** and give it a **description** to help the agent understand when to use it:
   - Set the **limit** to define how many chunks to return.
   - Enable **Include Metadata** to provide extra context for each chunk.
1. Add the same **embedding model** you used when inserting the data.

To save tokens on an expensive model, you can first use the [Vector Store Question Answer tool](../../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.toolvectorstore/) to retrieve relevant data, and only then pass the result to the Agent. To see this in action, check out [this template](https://n8n.io/workflows/5011-save-costs-in-rag-workflows-using-the-qanda-tool-with-multiple-models).

### Using the node directly

1. Add your vector store node to the canvas and choose the **Get Many** operation.
1. Enter a query or prompt:
   - Set a **limit** for how many chunks to return.
   - Enable **Include Metadata** if needed.

### How do I choose the right embedding model?

The right embedding model differs from case to case.

In general, smaller models (for example, `text-embedding-ada-002`) are faster and cheaper and thus ideal for short, general-purpose documents or lightweight RAG workflows. Larger models (for example, `text-embedding-3-large`) offer better semantic understanding. These are best for long documents, complex topics, or when accuracy is critical.

### What is the best text splitting for my use case?

This again depends a lot on your data:

- Small chunks (for example, 200 to 500 tokens) are good for fine-grained retrieval.
- Large chunks may carry more context but can become diluted or noisy.

Using the right overlap size is important for the AI to understand the context of the chunk. That's also why using the Markdown or Code Block splitting can often help to make chunks better.

Another good approach is to add more context to it (for example, about the document where the chunk came from). If you want you can read more about this, you can check out [this great article from Anthropic](https://www.anthropic.com/news/contextual-retrieval).

---

## Dropbox credentials

**URL:** llms-txt#dropbox-credentials

**Contents:**
- Supported authentication methods
- Related resources
- Using access token
- Using OAuth2

You can use these credentials to authenticate the following nodes:

- [Dropbox](../../app-nodes/n8n-nodes-base.dropbox/)

## Supported authentication methods

- API access token: Dropbox recommends this method for testing with your user account and granting a limited number of users access.
- OAuth2: Dropbox recommends this method for production or for testing with more than 50 users.

You can transition an app from the API access token to OAuth2 by creating a new credential in n8n for OAuth2 using the same app.

Refer to [Dropbox's Developer documentation](https://www.dropbox.com/developers/documentation) for more information about the service.

## Using access token

To configure this credential, you'll need a [Dropbox](https://www.dropbox.com/developers) developer account and:

- An **Access Token**: Generated once you create a Dropbox app.
- An **App Access Type**

To set up the credential, create a Dropbox app:

1. Open the [App Console](https://www.dropbox.com/developers/apps) within the Dropbox developer portal.
1. Select **Create app**.
1. In **Choose an API**, select **Scoped access**.
1. In **Choose the type of access you need**, choose whichever option best fits your use of the [Dropbox](../../app-nodes/n8n-nodes-base.dropbox/) node:
   - **App Folder** grants access to a single folder created specifically for your app.
   - **Full Dropbox** grants access to all files and folders in your user's Dropbox.
   - Refer to the [DBX Platform developer guide](https://www.dropbox.com/developers/reference/developer-guide) for more information.
1. In **Name your app**, enter a name for your app, like `n8n integration`.
1. Check the box to agree to the **Dropbox API Terms and Conditions**.
1. Select **Create app**. The app's **Settings** open.
1. In the **OAuth 2** section, in **Generated access token**, select **Generate**.
1. Copy the access token and enter it as the **Access Token** in your n8n credential.
1. In n8n, select the same **App Access Type** you selected for your app.

Refer to the [Dropbox App Console Settings documentation](https://www.dropbox.com/developers/reference/getting-started) for more information.

On the **Settings** tab, you can add other users to your app, even with the access token method. Once your app links 50 Dropbox users, you will have two weeks to apply for and receive production status approval before Dropbox freezes your app from linking more users.

Note for n8n Cloud users

Cloud users don't need to provide connection details. Select **Connect my account** to connect through your browser.

Cloud users need to select the **App Access Type**:

- **App Folder** grants access to a single folder created specifically for your app.
- **Full Dropbox** grants access to all files and folders in your user's Dropbox.
- Refer to the [DBX Platform developer guide](https://www.dropbox.com/developers/reference/developer-guide) for more information.

If you're [self-hosting](../../../../hosting/) n8n, you'll need to configure OAuth2 manually:

1. Open the [App Console](https://www.dropbox.com/developers/apps) within the Dropbox developer portal.
1. Select **Create app**.
1. In **Choose an API**, select **Scoped access**.
1. In **Choose the type of access you need**, choose whichever option best fits your use of the [Dropbox](../../app-nodes/n8n-nodes-base.dropbox/) node:
   - **App Folder** grants access to a single folder created specifically for your app.
   - **Full Dropbox** grants access to all files and folders in your user's Dropbox.
   - Refer to the [DBX Platform developer guide](https://www.dropbox.com/developers/reference/developer-guide) for more information.
1. In **Name your app**, enter a name for your app, like `n8n integration`.
1. Check the box to agree to the **Dropbox API Terms and Conditions**.
1. Select **Create app**. The app's **Settings** open.
1. Copy the **App key** and enter it as the **Client ID** in your n8n credential.
1. Copy the **Secret** and enter it as the **Client Secret** in your n8n credential.
1. In n8n, copy the **OAuth Redirect URL** and enter it in the Dropbox **Redirect URIs**.
1. In n8n, select the same **App Access Type** you selected for your app.

Refer to the instructions in the [Dropbox Implementing OAuth documentation](https://developers.dropbox.com/oauth-guide#implementing-oauth) for more information.

For internal tools and limited usage, you can keep your app private. But if you'd like your app to be used by more than 50 users or you want to distribute it, you'll need to complete Dropbox's production approval process. Refer to **Production Approval** in the [DBX Platform developer guide](https://www.dropbox.com/developers/reference/developer-guide) for more information.

On the **Settings** tab, you can add other users to your app. Once your app links 50 Dropbox users, you will have two weeks to apply for and receive production status approval before Dropbox freezes your app from linking more users.

---

## DHL node

**URL:** llms-txt#dhl-node

**Contents:**
- Operations
- Templates and examples

Use the DHL node to automate work in DHL, and integrate DHL with other applications. n8n has built-in support for a wide range of DHL features, including tracking shipment.

On this page, you'll find a list of operations the DHL node supports and links to more resources.

Refer to [DHL credentials](../../credentials/dhl/) for guidance on setting up authentication.

This node can be used as an AI tool

This node can be used to enhance the capabilities of an AI agent. When used in this way, many parameters can be set automatically, or with information directed by AI - find out more in the [AI tool parameters documentation](../../../../advanced-ai/examples/using-the-fromai-function/).

- Shipment
  - Get Tracking Details

## Templates and examples

**AI-powered WooCommerce Support-Agent**

[View template details](https://n8n.io/workflows/2161-ai-powered-woocommerce-support-agent/)

**Expose Get tracking details to AI Agents via 🛠️ DHL Tool MCP Server**

[View template details](https://n8n.io/workflows/5279-expose-get-tracking-details-to-ai-agents-via-dhl-tool-mcp-server/)

**Automated DHL Shipment Tracking Bot for Web Forms and Email Inquiries**

[View template details](https://n8n.io/workflows/9876-automated-dhl-shipment-tracking-bot-for-web-forms-and-email-inquiries/)

[Browse DHL integration templates](https://n8n.io/integrations/dhl/), or [search all templates](https://n8n.io/workflows/)

---

## Workflow Retriever node

**URL:** llms-txt#workflow-retriever-node

**Contents:**
- Node parameters
  - Source
  - Workflow values
- Templates and examples
- Related resources

Use the Workflow Retriever node to retrieve data from an n8n workflow for use in a Retrieval QA Chain or another Retriever node.

On this page, you'll find the node parameters for the Workflow Retriever node, and links to more resources.

Parameter resolution in sub-nodes

Sub-nodes behave differently to other nodes when processing multiple items using an expression.

Most nodes, including root nodes, take any number of items as input, process these items, and output the results. You can use expressions to refer to input items, and the node resolves the expression for each item in turn. For example, given an input of five `name` values, the expression `{{ $json.name }}` resolves to each name in turn.

In sub-nodes, the expression always resolves to the first item. For example, given an input of five `name` values, the expression `{{ $json.name }}` always resolves to the first name.

Tell n8n which workflow to call. You can choose either:

- **Database** and enter a workflow ID.
- **Parameter** and copy in a complete [workflow JSON](../../../../../workflows/export-import/).

Set values to pass to the workflow you're calling.

These values appear in the output data of the trigger node in the workflow you call. You can access these values in expressions in the workflow. For example, if you have:

- **Workflow Values** with a **Name** of `myCustomValue`
- A workflow with an Execute Sub-workflow Trigger node as its trigger

The expression to access the value of `myCustomValue` is `{{ $('Execute Sub-workflow Trigger').item.json.myCustomValue }}`.

## Templates and examples

**AI Crew to Automate Fundamental Stock Analysis - Q&A Workflow**

[View template details](https://n8n.io/workflows/2183-ai-crew-to-automate-fundamental-stock-analysis-qanda-workflow/)

**Build a PDF Document RAG System with Mistral OCR, Qdrant and Gemini AI**

[View template details](https://n8n.io/workflows/4400-build-a-pdf-document-rag-system-with-mistral-ocr-qdrant-and-gemini-ai/)

**AI: Ask questions about any data source (using the n8n workflow retriever)**

[View template details](https://n8n.io/workflows/1958-ai-ask-questions-about-any-data-source-using-the-n8n-workflow-retriever/)

[Browse Workflow Retriever integration templates](https://n8n.io/integrations/workflow-retriever/), or [search all templates](https://n8n.io/workflows/)

Refer to [LangChain's general retriever documentation](https://js.langchain.com/docs/concepts/retrievers/) for more information about the service.

View n8n's [Advanced AI](../../../../../advanced-ai/) documentation.

---

## Facebook Trigger Page object

**URL:** llms-txt#facebook-trigger-page-object

**Contents:**
- Prerequisites
- Trigger configuration
- Related resources

Use this object to receive updates when updates to your page profile fields or profile settings occur or someone mentions your page. Refer to [Facebook Trigger](../) for more information on the trigger itself.

You can find authentication information for this node [here](../../../credentials/facebookapp/).

Examples and templates

For usage examples and templates to help you get started, refer to n8n's [Facebook Trigger integrations](https://n8n.io/integrations/facebook-trigger/) page.

This Object requires some configuration in your app and page before you can use the trigger:

1. At least one page admin needs to grant the `manage_pages` permission to your app.

1. The page admin needs to have at least moderator privileges. If they don't, they won't receive all content.

1. You'll also need to add the app to your page, and you may need to go to the [Graph API explorer](https://developers.facebook.com/tools/explorer/) and execute this call with your app token:

## Trigger configuration

To configure the trigger with this Object:

1. Select the **Credential to connect with**. Select an existing or create a new [Facebook App credential](../../../credentials/facebookapp/).
1. Enter the **APP ID** of the app connected to your credential. Refer to the [Facebook App credential](../../../credentials/facebookapp/) documentation for more information.
1. Select **Page** as the **Object**.
1. **Field Names or IDs**: By default, the node will trigger on all the available events using the `*` wildcard filter. If you'd like to limit the events, use the `X` to remove the star and use the dropdown or an expression to select the updates you're interested in. Options include individual profile fields, as well as:
   - **Feed**: Describes most changes to a page's feed, including posts, likes, shares, and so on.
   - **Leadgen**: Notifies you when a page's lead generation settings change.
   - **Live Videos**: Notifies you when a page's live video status changes.
   - **Mention**: Notifies you when new mentions in pages, comments, and so on occur.
   - **Merchant Review**: Notifies you when a page's merchant review settings change.
   - **Page Change Proposal**: Notifies you when Facebook suggests proposed changes for your Facebook Page.
   - **Page Upcoming Change**: Notifies you about upcoming changes that will occur on your Facebook Page. Facebook has suggested these changes and they may have a deadline to accept or reject before automatically taking effect.
   - **Product Review**: Notifies you when a page's product review settings change.
   - **Ratings**: Notifies you when a page's ratings change, including new ratings or when a user comments on or reacts to a rating.
   - **Videos**: Notifies you when the encoding status of a video on a page changes.
1. In **Options**, turn on the toggle to **Include Values**. This Object type fails without the option enabled.

Refer to [Webhooks for Pages](https://developers.facebook.com/docs/graph-api/webhooks/getting-started/webhooks-for-pages) and Meta's [Page](https://developers.facebook.com/docs/graph-api/webhooks/reference/page/) Graph API reference for more information.

**Examples:**

Example 1 (unknown):
```unknown
{page-id}/subscribed_apps?subscribed_fields=feed
```

---

## AI Assistant

**URL:** llms-txt#ai-assistant

**Contents:**
- Current capabilities
- Tips for getting the most out of the Assistant
- FAQs
  - What context does the Assistant have?
  - Who can use the Assistant?
  - How does the Assistant work?
- Change instance ownership
- Change instance username

The n8n AI Assistant helps you build, debug, and optimize your workflows seamlessly. From answering questions about n8n to providing help with coding and [expressions](../../glossary/#expression-n8n), the AI Assistant can streamline your workflow-building process and support you as you navigate n8n's capabilities.

## Current capabilities

The AI Assistant offers a range of tools to support you:

- **Debug helper**: Identify and troubleshoot node execution issues in your workflows to keep them running without issues.
- **Answer n8n questions**: Get instant answers to your n8n-related questions, whether they're about specific features or general functionality.
- **Coding support**: Receive guidance on coding, including SQL and JSON, to optimize your nodes and data processing.
- **Expression assistance**: Learn how to create and refine [expressions](../../code/expressions/) to get the most out of your workflows.
- **Credential setup tips**: Find out how to set up and manage node [credentials](../../integrations/builtin/credentials/) securely and efficiently.

## Tips for getting the most out of the Assistant

1. **Engage in a conversation**: The AI Assistant can collaborate with you step-by-step. If a suggestion isn't what you need, let it know! The more context you provide, the better the recommendations will be.

1. **Ask specific questions**: For the best results, ask focused questions (for example, "How do I set up credentials for Google Sheets?"). The assistant works best with clear queries.

1. **Iterate on suggestions**: Don't hesitate to build on the assistant's responses. Try different approaches and keep refining based on the assistant's feedback to get closer to your ideal solution.

1. **Things to try out**:

- Debug any error you're seeing
   - Ask how to setup credentials
   - "Explain what this workflow does."
   - "I need your help to write code: [Explain your code here]"
   - "How can I build X in n8n?"

### What context does the Assistant have?

The AI Assistant has access to all elements displayed on your n8n screen, excluding actual input and output data values (like customer information). To learn more about what data n8n shares with the Assistant, refer to [AI in n8n](../../privacy-security/privacy/#ai-in-n8n).

### Who can use the Assistant?

Any user on a Cloud plan can use the assistant.

### How does the Assistant work?

The underlying logic of the assistant is build with the advanced AI capabilities of n8n. It uses a combination of different [agents](../../glossary/#ai-agent), specialized in different areas of n8n, RAG to gather knowledge from the docs and the community forum, and custom prompts, [memory](../../glossary/#ai-memory) and context.

## Change instance ownership

You can change the ownership of an instance by navigating to the **Settings** page in the owner's account and editing the **Email** field. After making the changes, scroll down and press **Save**. Note that for the change to be effective, the new email address can't be linked to any other n8n account.

Changing emails will change the owner of the instance, the email you log in with, and the email your invoices and general communication gets sent to.

If the workspace is deactivated, there will be no **Settings** page and no possibility to change the email address or the owner info.

## Change instance username

It's not currently possible to change usernames.

If you want your instance to have a different name you will need to create a new account and transfer your work into it. [The import/export documentation](../../workflows/export-import/) explains how you can transfer your work to a new n8n instance.

---

## Facebook Trigger Certificate Transparency object

**URL:** llms-txt#facebook-trigger-certificate-transparency-object

**Contents:**
- Trigger configuration
- Related resources

Use this object to receive updates about newly issued certificates for any domains that you have subscribed for certificate alerts or phishing alerts. Refer to [Facebook Trigger](../) for more information on the trigger itself.

You can find authentication information for this node [here](../../../credentials/facebookapp/).

Examples and templates

For usage examples and templates to help you get started, refer to n8n's [Facebook Trigger integrations](https://n8n.io/integrations/facebook-trigger/) page.

## Trigger configuration

To configure the trigger with this Object:

1. Select the **Credential to connect with**. Select an existing or create a new [Facebook App credential](../../../credentials/facebookapp/).
1. Enter the **APP ID** of the app connected to your credential. Refer to the [Facebook App credential](../../../credentials/facebookapp/) documentation for more information.
1. Select **Certificate Transparency** as the **Object**.
1. **Field Names or IDs**: By default, the node will trigger on all the available events using the `*` wildcard filter. If you'd like to limit the events, use the `X` to remove the star and use the dropdown or an expression to select the updates you're interested in. Options include:
   - **Certificate**: Notifies you when someone issues a new certificate for your subscribed domains. You'll need to subscribe your domain for certificate alerts.
   - **Phishing**: Notifies you when someone issues a new certificate that may be phishing one of your legitimate subscribed domains.
1. In **Options**, turn on the toggle to **Include Values**. This Object type fails without the option enabled.

For these alerts, you'll need to subscribe your domain to the relevant alerts:

- Refer to [Certificate Alerts](https://developers.facebook.com/docs/certificate-transparency-api#certificate-alerts-subscribing) for Certificate Alerts subscriptions.
- Refer to [Phishing Alerts](https://developers.facebook.com/docs/certificate-transparency-api#phishing-alerts-subscribing) for Phishing Alerts subscriptions.

Refer to [Webhooks for Certificate Transparency](https://developers.facebook.com/docs/graph-api/webhooks/getting-started/webhooks-for-certificate-transparency) and Meta's [Certificate Transparency](https://developers.facebook.com/docs/graph-api/webhooks/reference/certificate-transparency/) Graph API reference for more information.

---

## Current node input

**URL:** llms-txt#current-node-input

Methods for working with the input of the current node. Some methods and variables aren't available in the Code node.

You can use Python in the Code node. It isn't available in expressions.

| Method                       | Description                                                                                                                                                                                    | Available in Code node?           |
| ---------------------------- | ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | --------------------------------- |
| `$binary`                    | Shorthand for `$input.item.binary`. Incoming binary data from a node                                                                                                                           |                                   |
| `$input.item`                | The input item of the current node that's being processed. Refer to [Item linking](../../../data/data-mapping/data-item-linking/) for more information on paired items and item linking.       |                                   |
| `$input.all()`               | All input items in current node.                                                                                                                                                               |                                   |
| `$input.first()`             | First input item in current node.                                                                                                                                                              |                                   |
| `$input.last()`              | Last input item in current node.                                                                                                                                                               |                                   |
| `$input.params`              | Object containing the query settings of the previous node. This includes data such as the operation it ran, result limits, and so on.                                                          |                                   |
| `$json`                      | Shorthand for `$input.item.json`. Incoming JSON data from a node. Refer to [Data structure](../../../data/data-structure/) for information on item structure.                                  | (when running once for each item) |
| `$input.context.noItemsLeft` | Boolean. Only available when working with the Loop Over Items node. Provides information about what's happening in the node. Use this to determine whether the node is still processing items. |                                   |

| Method                       | Description                                                                                                                                                                                                                  |
| ---------------------------- | ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| `_input.item`                | The input item of the current node that's being processed. Refer to [Item linking](../../../data/data-mapping/data-item-linking/) for more information on paired items and item linking.                                     |
| `_input.all()`               | All input items in current node.                                                                                                                                                                                             |
| `_input.first()`             | First input item in current node.                                                                                                                                                                                            |
| `_input.last()`              | Last input item in current node.                                                                                                                                                                                             |
| `_input.params`              | Object containing the query settings of the previous node. This includes data such as the operation it ran, result limits, and so on.                                                                                        |
| `_json`                      | Shorthand for `_input.item.json`. Incoming JSON data from a node. Refer to [Data structure](../../../data/data-structure/) for information on item structure. Available when you set **Mode** to **Run Once for Each Item**. |
| `_input.context.noItemsLeft` | Boolean. Only available when working with the Loop Over Items node. Provides information about what's happening in the node. Use this to determine whether the node is still processing items.                               |

---

## Stripe node

**URL:** llms-txt#stripe-node

**Contents:**
- Operations
- Templates and examples
- What to do if your operation isn't supported

Use the Stripe node to automate work in Stripe, and integrate Stripe with other applications. n8n has built-in support for a wide range of Stripe features, including getting balance, creating charge, and deleting customers.

On this page, you'll find a list of operations the Stripe node supports and links to more resources.

Refer to [Stripe credentials](../../credentials/stripe/) for guidance on setting up authentication.

- Balance
  - Get a balance
- Charge
  - Create a charge
  - Get a charge
  - Get all charges
  - Update a charge
- Coupon
  - Create a coupon
  - Get all coupons
- Customer
  - Create a customer
  - Delete a customer
  - Get a customer
  - Get all customers
  - Update a customer
- Customer Card
  - Add a customer card
  - Get a customer card
  - Remove a customer card
- Source
  - Create a source
  - Delete a source
  - Get a source
- Token
  - Create a token

## Templates and examples

**Update HubSpot when a new invoice is registered in Stripe**

[View template details](https://n8n.io/workflows/1468-update-hubspot-when-a-new-invoice-is-registered-in-stripe/)

**Simplest way to create a Stripe Payment Link**

[View template details](https://n8n.io/workflows/2195-simplest-way-to-create-a-stripe-payment-link/)

**Streamline Your Zoom Meetings with Secure, Automated Stripe Payments**

[View template details](https://n8n.io/workflows/2192-streamline-your-zoom-meetings-with-secure-automated-stripe-payments/)

[Browse Stripe integration templates](https://n8n.io/integrations/stripe/), or [search all templates](https://n8n.io/workflows/)

## What to do if your operation isn't supported

If this node doesn't support the operation you want to do, you can use the [HTTP Request node](../../core-nodes/n8n-nodes-base.httprequest/) to call the service's API.

You can use the credential you created for this service in the HTTP Request node:

1. In the HTTP Request node, select **Authentication** > **Predefined Credential Type**.
1. Select the service you want to connect to.
1. Select your credential.

Refer to [Custom API operations](../../../custom-operations/) for more information.

---

## OpenAI File operations

**URL:** llms-txt#openai-file-operations

**Contents:**
- Delete a File
- List Files
  - Options
- Upload a File
  - Options
- Common issues

Use this operation to create, delete, list, message, or update a file in OpenAI. Refer to [OpenAI](../) for more information on the OpenAI node itself.

Use this operation to delete a file from the server.

Enter these parameters:

- **Credential to connect with**: Create or select an existing [OpenAI credential](../../../credentials/openai/).
- **Resource**: Select **File**.
- **Operation**: Select **Delete a File**.
- **File**: Enter the ID of the file to use for this operation or select the file name from the dropdown.

Refer to [Delete file | OpenAI](https://platform.openai.com/docs/api-reference/files/delete) documentation for more information.

Use this operation to list files that belong to the user's organization.

Enter these parameters:

- **Credential to connect with**: Create or select an existing [OpenAI credential](../../../credentials/openai/).
- **Resource**: Select **File**.
- **Operation**: Select **List Files**.

- **Purpose**: Use this to only return files with the given purpose. Use **Assistants** to return only files related to Assistants and Message operations. Use **Fine-Tune** for files related to [Fine-tuning](https://platform.openai.com/docs/api-reference/fine-tuning).

Refer to [List files | OpenAI](https://platform.openai.com/docs/api-reference/files/list) documentation for more information.

Use this operation to upload a file. This can be used across various operations.

Enter these parameters:

- **Credential to connect with**: Create or select an existing [OpenAI credential](../../../credentials/openai/).
- **Resource**: Select **File**.
- **Operation**: Select **Upload a File**.
- **Input Data Field Name**: Defaults to `data`. Enter the name of the binary property which contains the file. The size of individual files can be a maximum of 512 MB or 2 million tokens for Assistants.

- **Purpose**: Enter the intended purpose of the uploaded file. Use **Assistants** for files associated with Assistants and Message operations. Use **Fine-Tune** for [Fine-tuning](https://platform.openai.com/docs/api-reference/fine-tuning).

Refer to [Upload file | OpenAI](https://platform.openai.com/docs/api-reference/files/create) documentation for more information.

For common errors or issues and suggested resolution steps, refer to [Common Issues](../common-issues/).

---

## Zep credentials

**URL:** llms-txt#zep-credentials

**Contents:**
- Supported authentication methods
- Related resources
- Using API key
  - Zep Cloud setup
  - Self-hosted Zep Open Source setup

You can use these credentials to authenticate the following nodes:

- [Zep](../../cluster-nodes/sub-nodes/n8n-nodes-langchain.memoryzep/)
- [Zep Vector Store](../../cluster-nodes/root-nodes/n8n-nodes-langchain.vectorstorezep/)

## Supported authentication methods

Refer to [Zep's Cloud SDK documentation](https://help.getzep.com/install-sdks) for more information about the service. Refer to [Zep's REST API documentation](https://getzep.github.io/zep/) for information about the API.

View n8n's [Advanced AI](../../../../advanced-ai/) documentation.

To configure this credential, you'll need a [Zep server](https://www.getzep.com/) with at least one project and:

- An **API URL**
- An **API Key**

Setup depends on whether you're using Zep Cloud or self-hosted Zep Open Source.

Follow these instructions if you're using [Zep Cloud](https://app.getzep.com):

1. In Zep, open the **Project Settings**.
1. In the **Project Keys** section, select **Add Key**.
1. Enter a **Key Name**, like `n8n integration`.
1. Select **Create**.
1. Copy the key and enter it in your n8n integration as the **API Key**.
1. Turn on the **Cloud** toggle.

### Self-hosted Zep Open Source setup

The Zep team [deprecated the open source Zep Community Edition](https://blog.getzep.com/announcing-a-new-direction-for-zeps-open-source-strategy/) in April, 2025. These instructions may not work in the future.

Follow these instructions if you're self-hosting Zep Open Source:

1. Enter the JWT token for your Zep server as the **API Key** in n8n.
1. Make sure the **Cloud** toggle is off.
1. Enter the URL for your Zep server as the **API URL**.

---

## Lightweight Directory Access Protocol (LDAP)

**URL:** llms-txt#lightweight-directory-access-protocol-(ldap)

**Contents:**
- Enable LDAP
- Merging n8n and LDAP accounts
- LDAP user accounts in n8n
- Turn LDAP off

- Available on Self-hosted Enterprise and Cloud Enterprise plans.
- You need access to the n8n instance owner account.

This page tells you how to enable LDAP in n8n. It assumes you're familiar with LDAP, and have an existing LDAP server set up.

LDAP allows users to sign in to n8n with their organization credentials, instead of an n8n login.

1. Log in to n8n as the instance owner.
1. Select **Settings** > **LDAP**.
1. Toggle on **Enable LDAP Login**.
1. Complete the fields with details from your LDAP server.
1. Select **Test connection** to check your connection setup, or **Save connection** to create the connection.

After enabling LDAP, anyone on your LDAP server can sign in to the n8n instance, unless you exclude them using the **User Filter** setting.

You can still create non-LDAP users (email users) on the **Settings** > **Users** page.

## Merging n8n and LDAP accounts

If n8n finds matching accounts (matching emails) for email users and LDAP users, the user must sign in with their LDAP account. n8n instance owner accounts are excluded from this: n8n never converts owner accounts to LDAP users.

## LDAP user accounts in n8n

On first sign in, n8n creates a user account in n8n for the LDAP user.

You must manage user details on the LDAP server, not in n8n. If you update or delete a user on your LDAP server, the n8n account updates at the next scheduled sync, or when the user next tries to log in, whichever happens first.

If you remove a user from your LDAP server, they lose n8n access on the next sync.

1. Log in to n8n as the instance owner.
1. Select **Settings** > **LDAP**.
1. Toggle off **Enable LDAP Login**.

If you turn LDAP off, n8n converts existing LDAP users to email users on their next login. The users must reset their password.

---

## Zoho credentials

**URL:** llms-txt#zoho-credentials

**Contents:**
- Prerequisites
- Supported authentication methods
- Related resources
- Using OAuth2

You can use these credentials to authenticate the following nodes:

- [Zoho CRM](../../app-nodes/n8n-nodes-base.zohocrm/)

Create a [Zoho](https://www.zoho.com/) account.

## Supported authentication methods

Refer to [Zoho's CRM API documentation](https://www.zoho.com/crm/developer/docs/api/v3/) for more information about the service.

To configure this credential, you'll need:

- An **Access Token URL**: Zoho provides region-specific access token URLs. Select the region that best fits your Zoho data center:
  - **AU**: Select this option for Australia data center.
  - **CN**: Select this option for Canada data center.
  - **EU**: Select this option for the European Union data center.
  - **IN**: Select this option for the India data center.
  - **US**: Select this option for the United States data center.

Refer to [Multi DC](https://www.zoho.com/crm/developer/docs/api/v3/multi-dc.html) for more information about selecting a data center.

Note for n8n Cloud users

Cloud users don't need to provide connection details. Select **Connect my account** to connect through your browser.

If you need to configure OAuth2 from scratch, [register an application](https://www.zoho.com/accounts/protocol/oauth-setup.html) with Zoho.

Use these settings for your application:

- Select **Server-based Applications** as the **Client Type**.
- Copy the **OAuth Callback URL** from n8n and enter it in the Zoho **Authorized Redirect URIs** field.
- Copy the **Client ID** and **Client Secret** from the application and enter them in your n8n credential.

---

## n8n Embed

**URL:** llms-txt#n8n-embed

**Contents:**
- Support
- Russia and Belarus

n8n Embed is part of n8n's paid offering. Using Embed, you can white label n8n, or incorporate it in your software as part of your commercial product.

For more information about when to use Embed, as well as costs and licensing processes, refer to [Embed](https://n8n.io/embed/) on the n8n website.

The [community forum](https://community.n8n.io/) can help with various issues. If you are a current Embed customer, you can also contact n8n support, using the email provided when you bought the license.

## Russia and Belarus

n8n Embed isn't available in Russia and Belarus. Refer to n8n's blog post [Update on n8n cloud accounts in Russia and Belarus](https://blog.n8n.io/update-on-n8n-cloud-accounts-in-russia-and-belarus/) for more information.

---

## Markdown

**URL:** llms-txt#markdown

**Contents:**
- Operations
- Node parameters
- Node options
  - Markdown to HTML options
  - HTML to Markdown options
- Templates and examples
- Parsers

The Markdown node converts between Markdown and HTML formats.

This node's operations are **Modes**:

- **Markdown to HTML**: Use this mode to convert from Markdown to HTML.
- **HTML to Markdown**: Use this mode to convert from HTML to Markdown.

- **HTML** or **Markdown**: Enter the data you want to convert. The field name changes based on which **Mode** you select.
- **Destination Key**: Enter the field you want to put the output in. Specify nested fields using dots, for example `level1.level2.newKey`.

The node's **Options** depend on the **Mode** selected.

Some of the options depend on each other or can interact. We recommend testing out options to confirm the effects are what you want.

### Markdown to HTML options

| Option                                     | Description                                                                                                                                                                                                                                      | Default   |
| ------------------------------------------ | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------ | --------- |
| **Add Blank To Links**                     | Whether to open links a new window (enabled) or not (disabled).                                                                                                                                                                                  | Disabled  |
| **Automatic Linking To URLs**              | Whether to automatically link to URLs (enabled) or not (disabled). If enabled, n8n converts any string that it identifies as a URL to a link.                                                                                                    | Disabled  |
| **Backslash Escapes HTML Tags**            | Whether to allow backslash escaping of HTML tags (enabled) or not (disabled). When enabled, n8n escapes any `<` or `>` prefaced with `\`. For example, `\<div\>` renders as `&lt;div&gt;`.                                                       | Disabled  |
| **Complete HTML Document**                 | Whether to output a complete HTML document (enabled) or an HTML fragment (disabled). A complete HTML document includes the `<DOCTYPE HTML>` declaration, `<html>` and `<body>` tags, and the `<head>` element.                                   | Disabled  |
| **Customized Header ID**                   | Whether to support custom heading IDs (enabled) or not (disabled). When enabled, you can add custom heading IDs using `{header ID here}` after the heading text.                                                                                 | Disabled  |
| **Emoji Support**                          | Whether to support emojis (enabled) or not (disabled).                                                                                                                                                                                           | Disabled. |
| **Encode Emails**                          | Whether to transform ASCII character emails into their equivalent decimal entities (enabled) or not (disabled).                                                                                                                                  | Enabled   |
| **Exclude Trailing Punctuation From URLs** | Whether to exclude trailing punctuation from automatically linked URLs (enabled) or not (disabled). For use with **Automatic Linking To URLs**.                                                                                                  | Disabled  |
| **GitHub Code Blocks**                     | Whether to enable GitHub Flavored Markdown code blocks (enabled) or not (disabled).                                                                                                                                                              | Enabled   |
| **GitHub Compatible Header IDs**           | Whether to generate GitHub Flavored Markdown heading IDs (enabled) or not (disabled). GitHub Flavored Markdown generates heading IDs with `-` in place of spaces and removes non-alphanumeric characters.                                        | Disabled  |
| **GitHub Mention Link**                    | Change the link used with **GitHub Mentions**.                                                                                                                                                                                                   | Disabled  |
| **GitHub Mentions**                        | Whether to support tagging GitHub users with `@` (enabled) or not (disabled). When enabled, n8n replaces `@name` with `https://github.com/name`.                                                                                                 | Disabled  |
| **GitHub Task Lists**                      | Whether to support GitHub Flavored Markdown task lists (enabled) or not (disabled).                                                                                                                                                              | Disabled  |
| **Header Level Start**                     | Number. Set the start level for headers. For example, changing this field to `2` causes n8n to treat `#` as `<h2>`, `##` as `<h3>`, and so on.                                                                                                   | 1         |
| **Mandatory Space Before Header**          | Whether to make a space between `#` and heading text required (enabled) or not (disabled). When enabled, n8n renders a heading written as `##Some header text` literally (it doesn't turn it into a heading element)                             | Disabled  |
| **Middle Word Asterisks**                  | Whether n8n should treat asterisks in words as Markdown (disabled) or render them as literal asterisks (enabled).                                                                                                                                | Disabled  |
| **Middle Word Underscores**                | Whether n8n should treat underscores in words as Markdown (disabled) or render them as literal underscores (enabled).                                                                                                                            | Disabled  |
| **No Header ID**                           | Disable automatic generation of header IDs (enabled).                                                                                                                                                                                            | Disabled  |
| **Parse Image Dimensions**                 | Support setting maximum image dimensions in Markdown syntax (enabled).                                                                                                                                                                           | Disabled  |
| **Prefix Header ID**                       | Define a prefix to add to header IDs.                                                                                                                                                                                                            | None      |
| **Raw Header ID**                          | Whether to remove spaces, `'`, and `"` from header IDs, including prefixes, replacing them with `-` (enabled) or not (disabled).                                                                                                                 | Disabled  |
| **Raw Prefix Header ID**                   | Whether to prevent n8n from modifying header prefixes (enabled) or not (disabled)                                                                                                                                                                | Disabled  |
| **Simple Line Breaks**                     | Whether to create line breaks without a double space at the end of a line (enabled) or not (disabled).                                                                                                                                           | Disabled  |
| **Smart Indentation Fix**                  | Whether to try to smartly fix indentation problems related to ES6 template strings in indented code blocks (enabled) or not (disabled).                                                                                                          | Disabled  |
| **Spaces Indented Sublists**               | Whether to remove the requirement to indent sublists four spaces (enabled) or not (disabled).                                                                                                                                                    | Disabled  |
| **Split Adjacent Blockquotes**             | Whether to split adjacent blockquote blocks (enabled) or not (disabled). If you don't enable this, n8n treats quotes (indicated by `>` at the start of the line) on separate lines as a single blockquote, even when separated by an empty line. | Disabled  |
| **Strikethrough**                          | Whether to support strikethrough syntax (enabled) or not (disabled). When enabled, you can add a ~~strikethrough~~ effect using `~~` around the word or phrase.                                                                                  | Disabled  |
| **Tables Header ID**                       | Whether to add an ID to table header tags (enabled) or not (disabled).                                                                                                                                                                           | Disabled  |
| **Tables Support**                         | Whether to support tables (enabled) or not (disabled).                                                                                                                                                                                           | Disabled  |

### HTML to Markdown options

| Option                        | Description                                                                                                              | Default  |
| ----------------------------- | ------------------------------------------------------------------------------------------------------------------------ | -------- |
| **Bullet Marker**             | Specify the character to use for unordered lists.                                                                        | \*       |
| **Code Block Fence**          | Specify the characters to use for code blocks.                                                                           | \`\`\`   |
| **Emphasis Delimiter**        | Specify the character `<em>`.                                                                                            | \_       |
| **Global Escape Pattern**     | Overrides the default character escape settings. You may want to use Text Replacement Pattern instead.                   | None     |
| **Ignored Elements**          | Ignore given HTML elements, and their children.                                                                          | None     |
| **Keep Images With Data**     | Whether to keep images with data (enabled) or not (disabled). Support files up to 1MB.                                   | Disabled |
| **Line Start Escape Pattern** | Overrides the default character escape settings. You may want to use Text Replacement Pattern instead.                   | None     |
| **Max Consecutive New Lines** | Number. Specify the maximum number of consecutive new lines allowed.                                                     | 3        |
| **Place URLs At The Bottom**  | Whether to place URLs at the bottom of the page and format using link reference definitions (enabled) or not (disabled). | Disabled |
| **Strong Delimiter**          | Specify the characters for `<strong>`.                                                                                   | \*\*     |
| **Style For Code Block**      | Specify the styling for code blocks. Options are **Fence** and **Indented**.                                             | Fence    |
| **Text Replacement Pattern**  | Define a text replacement pattern using regex.                                                                           | None     |
| **Treat As Blocks**           | Specify HTML elements to treat as blocks (surround with blank lines)                                                     | None     |

## Templates and examples

**AI agent that can scrape webpages**

[View template details](https://n8n.io/workflows/2006-ai-agent-that-can-scrape-webpages/)

**Autonomous AI crawler**

[View template details](https://n8n.io/workflows/2315-autonomous-ai-crawler/)

**Personalized AI Tech Newsletter Using RSS, OpenAI and Gmail**

[View template details](https://n8n.io/workflows/3986-personalized-ai-tech-newsletter-using-rss-openai-and-gmail/)

[Browse Markdown integration templates](https://n8n.io/integrations/markdown/), or [search all templates](https://n8n.io/workflows/)

n8n uses the following parsers:

- To convert from HTML to Markdown: [node-html-markdown](https://www.npmjs.com/package/node-html-markdown).
- To convert from Markdown to HTML: [Showdown](https://www.npmjs.com/package/showdown). Some options allow you to extend your Markdown with [GitHub Flavored Markdown](https://github.github.com/gfm/).

---

## Configure the Base URL for n8n's front end access

**URL:** llms-txt#configure-the-base-url-for-n8n's-front-end-access

Requires manual UI build

This use case involves configuring the `VUE_APP_URL_BASE_API` environmental variable which requires a manual build of the `n8n-editor-ui` package. You can't use it with the default n8n Docker image where the default setting for this variable is `/`, meaning that it uses the root-domain.

You can configure the Base URL that the front end uses to connect to the back end's REST API. This is relevant when you want to host n8n's front end and back end separately.

Refer to [Environment variables reference](../../environment-variables/deployment/) for more information on this variable.

**Examples:**

Example 1 (unknown):
```unknown
export VUE_APP_URL_BASE_API=https://n8n.example.com/
```

---

## Bannerbear node

**URL:** llms-txt#bannerbear-node

**Contents:**
- Operations
- Templates and examples

Use the Bannerbear node to automate work in Bannerbear, and integrate Bannerbear with other applications. n8n has built-in support for a wide range of Bannerbear features, including creating and getting images and templates.

On this page, you'll find a list of operations the Bannerbear node supports and links to more resources.

Refer to [Bannerbear credentials](../../credentials/bannerbear/) for guidance on setting up authentication.

- Image
  - Create an image
  - Get an image
- Template
  - Get a template
  - Get all templates

## Templates and examples

**Speed Up Social Media Banners With BannerBear.com**

[View template details](https://n8n.io/workflows/2322-speed-up-social-media-banners-with-bannerbearcom/)

**Render custom text over images**

[View template details](https://n8n.io/workflows/365-render-custom-text-over-images/)

**Send Airtable data as tasks to Trello**

[View template details](https://n8n.io/workflows/385-send-airtable-data-as-tasks-to-trello/)

[Browse Bannerbear integration templates](https://n8n.io/integrations/bannerbear/), or [search all templates](https://n8n.io/workflows/)

---

## Perplexity node

**URL:** llms-txt#perplexity-node

**Contents:**
- Operations
- Templates and examples
- Related resources
- What to do if your operation isn't supported

Use the Perplexity node to automate work in Perplexity and integrate Perplexity with other applications. n8n has built-in support for messaging a model.

On this page, you'll find a list of operations the Perplexity node supports, and links to more resources.

You can find authentication information for this node [here](../../credentials/perplexity/).

- **Message a Model**: Create one or more completions for a given text.

## Templates and examples

**Clone Viral TikToks with AI Avatars & Auto-Post to 9 Platforms using Perplexity & Blotato**

[View template details](https://n8n.io/workflows/4110-clone-viral-tiktoks-with-ai-avatars-and-auto-post-to-9-platforms-using-perplexity-and-blotato/)

**🔍🛠️Generate SEO-Optimized WordPress Content with AI Powered Perplexity Research**

[View template details](https://n8n.io/workflows/3291-generate-seo-optimized-wordpress-content-with-ai-powered-perplexity-research/)

**AI-Powered Multi-Social Media Post Automation: Google Trends & Perplexity AI**

[View template details](https://n8n.io/workflows/4352-ai-powered-multi-social-media-post-automation-google-trends-and-perplexity-ai/)

[Browse Perplexity integration templates](https://n8n.io/integrations/perplexity/), or [search all templates](https://n8n.io/workflows/)

Refer to [Perplexity's documentation](https://docs.perplexity.ai/home) for more information about the service.

## What to do if your operation isn't supported

If this node doesn't support the operation you want to do, you can use the [HTTP Request node](../../core-nodes/n8n-nodes-base.httprequest/) to call the service's API.

You can use the credential you created for this service in the HTTP Request node:

1. In the HTTP Request node, select **Authentication** > **Predefined Credential Type**.
1. Select the service you want to connect to.
1. Select your credential.

Refer to [Custom API operations](../../../custom-operations/) for more information.

---

## SolarWinds Observability SaaS credentials

**URL:** llms-txt#solarwinds-observability-saas-credentials

**Contents:**
- Supported authentication methods
- Related resources
- Using API Token

You can use these credentials to authenticate when using the [HTTP Request node](../../core-nodes/n8n-nodes-base.httprequest/) to make a [Custom API call](../../../custom-operations/).

## Supported authentication methods

Refer to [SolarWinds Observability SaaS's API documentation](https://documentation.solarwinds.com/en/success_center/observability/content/api/api-swagger.htm) for more information about the service.

To configure this credential, you'll need a SolarWinds Observability SaaS account and:

- **URL**: The URL you use to access the SolarWinds Observability SaaS platform
- **API Token**: An API token found in the SolarWinds Observability SaaS platform under **Settings > Api Tokens**

Refer to [SolarWinds Observability SaaS's API documentation](https://documentation.solarwinds.com/en/success_center/observability/content/settings/api-tokens.htm) for more information about authenticating to the service.

---

## Optional timezone to set which gets used by Cron and other scheduling nodes

**URL:** llms-txt#optional-timezone-to-set-which-gets-used-by-cron-and-other-scheduling-nodes

---

## Expressions cookbook

**URL:** llms-txt#expressions-cookbook

**Contents:**
- Related resources

This section contains examples and recipes for tasks you can do with [expressions](../../../glossary/#expression-n8n).

You can use Python in the Code node. It isn't available in expressions.

- [Check incoming data](/code/cookbook/expressions/check-incoming-data/)
- [Common issues](/code/cookbook/expressions/common-issues/)

- [Built-in methods and variables reference](../../builtin/overview/)
- [Expressions](../../expressions/)

---

## Data mocking

**URL:** llms-txt#data-mocking

**Contents:**
- Mocking with real data using data pinning
- Generate custom data using the Code or Edit Fields nodes
- Output a sample data set from the Customer Datastore node

Data mocking is simulating or faking data. It's useful when developing a workflow. By mocking data, you can:

- Avoid making repeated calls to your data source. This saves time and costs.
- Work with a small, predictable dataset during initial development.
- Avoid the risk of overwriting live data: in the early stages of building your workflow, you don't need to connect your real data source.

## Mocking with real data using data pinning

Using [data pinning](../data-pinning/), you load real data into your workflow, then pin it in the output panel of a node. Using this approach you have realistic data, with only one call to your data source. You can [edit pinned data](../data-editing/).

Use this approach when you need to configure your workflow to handle the exact data structure and parameters provided by your data source.

To pin data in a node:

1. Run the node to load data.
1. In the **OUTPUT** view, select **Pin data** . When data pinning is active, the button is disabled and a "This data is pinned" banner is displayed in the **OUTPUT** view.

Nodes that output binary data

You can't pin data if the output data includes binary data.

## Generate custom data using the Code or Edit Fields nodes

You can create a custom dataset in your workflow using either the [Code node](../../integrations/builtin/core-nodes/n8n-nodes-base.code/) or the [Edit Fields (Set) node](../../integrations/builtin/core-nodes/n8n-nodes-base.set/).

In the Code node, you can create any data set you want, and return it as the node output. In the Edit Fields node, select **Add fields** to add your custom data.

The Edit Fields node is a good choice for small tests. To create more complex datasets, use the Code node.

## Output a sample data set from the Customer Datastore node

The Customer Datastore node provides a fake dataset to work with. Add and execute the node to explore the data.

Use this approach if you need some test data when exploring n8n, and you don't have a real use-case to work with.

---

## Cloud IP addresses

**URL:** llms-txt#cloud-ip-addresses

Cloud IP addresses change without warning

n8n can't guarantee static source IPs, as Cloud operates in a dynamic cloud provider environment and scales its infrastructure to meet demand. You should use strong authentication and secure transport protocols when connecting into and out of n8n.

Outbound traffic may appear to originate from any of:

- 20.79.227.226/32
- 20.113.47.122/32
- 20.218.202.73/32
- 98.67.233.91/32
- 4.182.111.50/32
- 4.182.129.20/32
- 4.182.88.118/32
- 4.182.212.136/32
- 98.67.244.108/32
- 72.144.128.145/32
- 72.144.83.147/32
- 72.144.69.38/32
- 72.144.111.50/32
- 4.182.128.108/32
- 4.182.190.144/32
- 4.182.191.184/32
- 98.67.233.200/32
- 20.52.126.0/28
- 20.218.238.112/28
- 4.182.64.64/28
- 20.218.174.0/28
- 4.184.78.240/28
- 20.79.32.32/28
- 51.116.119.64/28

---

## n8n Trigger node

**URL:** llms-txt#n8n-trigger-node

**Contents:**
- Node parameters
- Templates and examples

The n8n Trigger node triggers when the current workflow updates or activates, or when the n8n instance starts or restarts. You can use the n8n Trigger node to notify when these events occur.

The node includes a single parameter to identify the **Events** that should trigger it. Choose from these events:

- **Active Workflow Updated**: If you select this event, the node triggers when this workflow is updated.
- **Instance started**: If you select this event, the node triggers when the n8n instance starts or restarts.
- **Workflow Activated**: If you select this event, the node triggers when this workflow is activated.

You can select one or more of these events.

## Templates and examples

**RAG Starter Template using Simple Vector Stores, Form trigger and OpenAI**

[View template details](https://n8n.io/workflows/5010-rag-starter-template-using-simple-vector-stores-form-trigger-and-openai/)

**Unify multiple triggers into a single workflow**

by Guillaume Duvernay

[View template details](https://n8n.io/workflows/7784-unify-multiple-triggers-into-a-single-workflow/)

**Backup and Delete Workflows to Google Drive with n8n API and Form Trigger**

[View template details](https://n8n.io/workflows/6751-backup-and-delete-workflows-to-google-drive-with-n8n-api-and-form-trigger/)

[Browse n8n Trigger integration templates](https://n8n.io/integrations/n8n-trigger/), or [search all templates](https://n8n.io/workflows/)

---

## LangChain Code node methods

**URL:** llms-txt#langchain-code-node-methods

n8n provides these methods to make it easier to perform common tasks in the [LangChain Code node](../../../integrations/builtin/cluster-nodes/root-nodes/n8n-nodes-langchain.code/).

LangChain Code node only

These variables are for use in expressions in the LangChain Code node. You can't use them in other nodes.

| Method                                                           | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             |
| ---------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| `this.addInputData(inputName, data)`                             | Populate the data of a specified non-main input. Useful for mocking data. - `inputName` is the input connection type, and must be one of: `ai_agent`, `ai_chain`, `ai_document`, `ai_embedding`, `ai_languageModel`, `ai_memory`, `ai_outputParser`, `ai_retriever`, `ai_textSplitter`, `ai_tool`, `ai_vectorRetriever`, `ai_vectorStore` - `data` contains the data you want to add. Refer to [Data structure](../../../data/data-structure/) for information on the data structure expected by n8n.   |
| `this.addOutputData(outputName, data)`                           | Populate the data of a specified non-main output. Useful for mocking data. - `outputName` is the input connection type, and must be one of: `ai_agent`, `ai_chain`, `ai_document`, `ai_embedding`, `ai_languageModel`, `ai_memory`, `ai_outputParser`, `ai_retriever`, `ai_textSplitter`, `ai_tool`, `ai_vectorRetriever`, `ai_vectorStore` - `data` contains the data you want to add. Refer to [Data structure](../../../data/data-structure/) for information on the data structure expected by n8n. |
| `this.getInputConnectionData(inputName, itemIndex, inputIndex?)` | Get data from a specified non-main input. - `inputName` is the input connection type, and must be one of: `ai_agent`, `ai_chain`, `ai_document`, `ai_embedding`, `ai_languageModel`, `ai_memory`, `ai_outputParser`, `ai_retriever`, `ai_textSplitter`, `ai_tool`, `ai_vectorRetriever`, `ai_vectorStore` - `itemIndex` should always be `0` (this parameter will be used in upcoming functionality) - Use `inputIndex` if there is more than one node connected to the specified input.                |
| `this.getInputData(inputIndex?, inputName?)`                     | Get data from the main input.                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |
| `this.getNode()`                                                 | Get the current node.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   |
| `this.getNodeOutputs()`                                          | Get the outputs of the current node.                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |
| `this.getExecutionCancelSignal()`                                | Use this to stop the execution of a function when the workflow stops. In most cases n8n handles this, but you may need to use it if building your own chains or agents. It replaces the [Cancelling a running LLMChain](https://js.langchain.com/docs/modules/chains/foundational/llm_chain#cancelling-a-running-llmchain) code that you'd use if building a LangChain application normally.                                                                                                            |

---

## Gumroad credentials

**URL:** llms-txt#gumroad-credentials

**Contents:**
- Prerequisites
- Supported authentication methods
- Related resources
- Using API access token

You can use these credentials to authenticate the following nodes:

- [Gumroad Trigger](../../trigger-nodes/n8n-nodes-base.gumroadtrigger/)

Create a [Gumroad](https://gumroad.com/) account.

## Supported authentication methods

Refer to [Gumroad's API documentation](https://app.gumroad.com/api) for more information about the service.

## Using API access token

To configure this credential, you'll need:

- An API **Access Token**: Create an application to generate an access token. Refer to the [Gumroad Create an application for the API documentation](https://help.gumroad.com/article/280-create-application-api) for detailed instructions on creating a new application and generating an access token.

---

## Get number of items returned by the previous node

**URL:** llms-txt#get-number-of-items-returned-by-the-previous-node

To get the number of items returned by the previous node:

The output will be similar to the following.

The output will be similar to the following.

**Examples:**

Example 1 (unknown):
```unknown
if (Object.keys(items[0].json).length === 0) {
return [
	{
		json: {
			results: 0,
		}
	}
]
}
return [
	{
		json: {
			results: items.length,
		}
	}
];
```

Example 2 (unknown):
```unknown
[
	{
		"results": 8
	}
]
```

Example 3 (unknown):
```unknown
if len(items[0].json) == 0:
	return [
		{
			"json": {
				"results": 0,
			}
		}
	]
else:
	return [
		{
			"json": {
				"results": items.length,
			}
		}
	]
```

Example 4 (unknown):
```unknown
[
	{
		"results": 8
	}
]
```

---

## Chat Trigger node common issues

**URL:** llms-txt#chat-trigger-node-common-issues

**Contents:**
- Pass data from a website to an embedded Chat Trigger node
- Chat Trigger node doesn't fetch previous messages

Here are some common errors and issues with the [Chat Trigger node](../) and steps to resolve or troubleshoot them.

## Pass data from a website to an embedded Chat Trigger node

When [embedding](https://www.npmjs.com/package/@n8n/chat) the Chat Trigger node in a website, you might want to pass extra information to the Chat Trigger. For example, passing a user ID stored in a site cookie.

To do this, use the `metadata` field in the JSON object you pass to the `createChat` function in your embedded chat window:

The `metadata` field can contain arbitrary data that will appear in the Chat Trigger output alongside other output data. From there, you can query and process the data from downstream nodes as usual using n8n's [data processing features](../../../../../data/).

## Chat Trigger node doesn't fetch previous messages

When you configure a Chat Trigger node, you might experience problems fetching previous messages if you aren't careful about how you configure session loading. This often manifests as a `workflow could not be started!` error.

In Chat Triggers, the **Load Previous Session** option retrieves previous chat messages for a session using the `sessionID`. When you set the **Load Previous Session** option to **From memory**, it's almost always best to [connect the same memory node](../#load-previous-session) to both the Chat Trigger and the Agent in your workflow:

1. In your **Chat Trigger** node, set the **Load Previous Session** option to **From Memory**. This is only visible if you've made the chat publicly available.
1. Attach a **Simple Memory** node to the **Memory** connector.
1. Attach the same **Simple Memory** node to **Memory** connector of your **Agent**.
1. In the **Simple Memory** node, set **Session ID** to **Connected Chat Trigger Node**.

One instance where you may want to attach separate memory nodes to your Chat Trigger and the Agent is if you want to set the **Session ID** in your memory node to **Define below**.

If you're retrieving the session ID from an expression, the same expression must work for each of the nodes attached to it. If the expression isn't compatible with each of the nodes that need memory, you might need to use separate memory nodes so you can customize the expression for the session ID on a per-node basis.

**Examples:**

Example 1 (unknown):
```unknown
createChat({
	webhookUrl: 'YOUR_PRODUCTION_WEBHOOK_URL',
	metadata: {
		'YOUR_KEY': 'YOUR_DATA'
	};
});
```

---

## OpenAI Conversation operations

**URL:** llms-txt#openai-conversation-operations

**Contents:**
- Create a Conversation
  - Options
- Get a Conversation
- Remove a Conversation
- Update a Conversation
  - Options

Use this operation to create, get, update, or remove a conversation in OpenAI. Refer to [OpenAI](../) for more information on the OpenAI node itself.

## Create a Conversation

Use this operation to create a new conversation.

Enter these parameters:

- **Credential to connect with**: Create or select an existing [OpenAI credential](../../../credentials/openai/).
- **Resource**: Select **Conversation**.
- **Operation**: Select **Create a Conversation**.
- **Messages**: A message input to the model. Messages with the `system` role take precedence over instructions given with the `user` role. Messages with the `assistant` role will be assumed to have been generated by the model in previous interactions.

- **Metadata**: A set of key-value pairs for storing structured information. You can attach up to 16 pairs to an object, which is useful for adding custom data that can be used for searching via the API or in the dashboard.

Refer to [Conversations | OpenAI](https://platform.openai.com/docs/api-reference/conversations/create) documentation for more information.

## Get a Conversation

Use this operation to retrieve an existing conversation.

Enter these parameters:

- **Credential to connect with**: Create or select an existing [OpenAI credential](../../../credentials/openai/).
- **Resource**: Select **Conversation**.
- **Operation**: Select **Get Conversation**.
- **Conversation ID**: The ID of the conversation to retrieve.

Refer to [Conversations | OpenAI](https://platform.openai.com/docs/api-reference/conversations/create) documentation for more information.

## Remove a Conversation

Use this operation to remove an existing conversation.

Enter these parameters:

- **Credential to connect with**: Create or select an existing [OpenAI credential](../../../credentials/openai/).
- **Resource**: Select **Conversation**.
- **Operation**: Select **Remove Conversation**.
- **Conversation ID**: The ID of the conversation to remove.

Refer to [Conversations | OpenAI](https://platform.openai.com/docs/api-reference/conversations/create) documentation for more information.

## Update a Conversation

Use this operation to update an existing conversation.

Enter these parameters:

- **Credential to connect with**: Create or select an existing [OpenAI credential](../../../credentials/openai/).
- **Resource**: Select **Conversation**.
- **Operation**: Select **Update a Conversation**.
- **Conversation ID**: The ID of the conversation to update.

- **Metadata**: A set of key-value pairs for storing structured information. You can attach up to 16 pairs to an object, which is useful for adding custom data that can be used for searching via the API or in the dashboard.

Refer to [Conversations | OpenAI](https://platform.openai.com/docs/api-reference/conversations/create) documentation for more information.

---

## Mocean node

**URL:** llms-txt#mocean-node

**Contents:**
- Operations
- Templates and examples

Use the Mocean node to automate work in Mocean, and integrate Mocean with other applications. n8n has built-in support for a wide range of Mocean features, including sending SMS, and voice messages.

On this page, you'll find a list of operations the Mocean node supports and links to more resources.

Refer to [Mocean credentials](../../credentials/mocean/) for guidance on setting up authentication.

- SMS
  - Send SMS/Voice message
- Voice
  - Send SMS/Voice message

## Templates and examples

[Browse Mocean integration templates](https://n8n.io/integrations/mocean/), or [search all templates](https://n8n.io/workflows/)

---

## monday.com credentials

**URL:** llms-txt#monday.com-credentials

**Contents:**
- Supported authentication methods
- Related resources
- Using API token
- Using OAuth2

You can use these credentials to authenticate the following nodes:

- [monday.com](../../app-nodes/n8n-nodes-base.mondaycom/)

Minimum required version

The monday.com node requires n8n version 1.22.6 or above.

## Supported authentication methods

Refer to [monday.com's API documentation](https://developer.monday.com/api-reference/docs/basics) for more information about authenticating with the service.

To configure this credential, you'll need a [monday.com](https://monday.com/) account and:

- An API **Token V2**

1. In your monday.com account, select your profile picture in the top right corner.
1. Select **Developers**. The Developer Center opens in a new tab.
1. In the Developer Center, select **My Access Tokens > Show**.
1. Copy your personal token and enter it in your n8n credential as the **Token V2**.

Refer to [monday.com API Authentication](https://developer.monday.com/api-reference/docs/authentication) for more information.

To configure this credential, you'll need a [monday.com](https://monday.com/) account and:

- A **Client ID**
- A **Client Secret**

To generate both these fields, register a new monday.com application:

1. In your monday.com account, select your profile picture in the top right corner.
1. Select **Developers**. The Developer Center opens in a new tab.
1. In the Developer Center, select **Build app**. The app details open.
1. Enter a **Name** for your app, like `n8n integration`.
1. Copy the **Client ID** and enter it in your n8n credential.
1. **Show** the **Client Secret**, copy it, and enter it in your n8n credential.
1. In the left menu, select **OAuth**.
1. For **Scopes**, select `boards:write` and `boards:read`.
1. Select **Save Scopes**.
1. Select the **Redirect URLs** tab.
1. Copy the **OAuth Redirect URL** from n8n and enter it as the **Redirect URL**.
1. **Save** your changes in monday.com.
1. In n8n, select **Connect my account** to finish the setup.

Refer to [Create an app](https://developer.monday.com/apps/docs/create-an-app) for more information on creating apps.

Refer to [OAuth and permissions](https://developer.monday.com/apps/docs/oauth) for more information on the available scopes and setting up the Redirect URL.

---

## Manual Trigger node

**URL:** llms-txt#manual-trigger-node

**Contents:**
- Common issues
  - Only one 'Manual Trigger' node is allowed in a workflow

Use this node if you want to start a workflow by selecting **Execute Workflow** and don't want any option for the workflow to run automatically.

Workflows always need a trigger, or start point. Most workflows start with a trigger node firing in response to an external event or the [Schedule Trigger](../n8n-nodes-base.scheduletrigger/) firing on a set schedule.

The Manual Trigger node serves as the workflow trigger for workflows that don't have an automatic trigger.

- To test your workflow before you add an automatic trigger of some kind.
- When you don't want the workflow to run automatically.

Here are some common errors and issues with the Manual Trigger node and steps to resolve or troubleshoot them.

### Only one 'Manual Trigger' node is allowed in a workflow

This error displays if you try to add a Manual Trigger node to a workflow which already includes a Manual Trigger node.

Remove your existing Manual Trigger or edit your workflow to connect that trigger to a different node.

---

## Item linking concepts

**URL:** llms-txt#item-linking-concepts

**Contents:**
- n8n's automatic item linking
- Item linking example

Each output item created by a node includes metadata that links them to the input item (or items) that the node used to generate them. This creates a chain of items that you can work back along to access previous items. This can be complicated to understand, especially if the node splits or merges data. You need to understand item linking when building your own programmatic nodes, or in some scenarios using the Code node.

This document provides a conceptual overview of this feature. For usage details, refer to:

- [Item linking for node creators](../item-linking-node-building/), for details on how to handle item linking when building a node.
- [Item linking in the Code node](../item-linking-code-node/), to learn how to handle item linking in the Code node.
- [Item linking errors](../item-linking-errors/), to understand the errors you may encounter in the editor UI.

## n8n's automatic item linking

If a node doesn't control how to link input items to output items, n8n tries to guess how to link the items automatically:

- Single input, single output: the output links to the input.
- Single input, multiple outputs: all outputs link to that input.
- Multiple inputs and outputs:
  - If you keep the input items, but change the order (or remove some but keep others), n8n can automatically add the correct linked item information.
  - If the number of inputs and outputs is equal, n8n links the items in order. This means that output-1 links to input-1, output-2 to input-2, and so on.
  - If the number isn't equal, or you create completely new items, n8n can't automatically link items.

If n8n can't link items automatically, and the node doesn't handle the item linking, n8n displays an error. Refer to [Item linking errors](../item-linking-errors/) for more information.

## Item linking example

In this example, it's possible for n8n to link an item in one node back several steps, despite the item order changing. This means the node that sorts movies alphabetically can access information about the linked item in the node that gets famous movie actors.

The methods for accessing linked items are different depending on whether you're using the UI, expressions, or the code node. Explore the following resources:

- [Mapping in the UI](../../data-mapping-ui/)
- [Mapping in the expressions editor](../../data-mapping-expressions/)
- [Item linking in the Code node](../item-linking-code-node/)
- [Item linking errors](../item-linking-errors/)

---

## Set up SSL

**URL:** llms-txt#set-up-ssl

**Contents:**
- Use a reverse proxy (recommended)
- Pass certificates into n8n directly

There are two methods to support TLS/SSL in n8n.

## Use a reverse proxy (recommended)

Use a reverse proxy like [Traefik](https://doc.traefik.io/traefik/) or a Network Load Balancer (NLB) in front of the n8n instance. This should also take care of certificate renewals.

Refer to [Security | Data encryption](https://n8n.io/legal/#security) for more information.

## Pass certificates into n8n directly

You can also choose to pass certificates into n8n directly. To do so, set the `N8N_SSL_CERT` and `N8N_SSL_KEY` environment variables to point to your generated certificate and key file.

You'll need to make sure the certificate stays renewed and up to date.

Refer to [Deployment environment variables](../../configuration/environment-variables/deployment/) for more information on these variables and [Configuration](../../configuration/configuration-methods/) for more information on setting environment variables.

---

## ActiveCampaign node

**URL:** llms-txt#activecampaign-node

**Contents:**
- Operations
- Templates and examples
- What to do if your operation isn't supported

Use the ActiveCampaign node to automate work in ActiveCampaign, and integrate ActiveCampaign with other applications. n8n has built-in support for a wide range of ActiveCampaign features, including creating, getting, updating, and deleting accounts, contact, orders, e-commerce customers, connections, lists, tags, and deals.

On this page, you'll find a list of operations the ActiveCampaign node supports and links to more resources.

Refer to [ActiveCampaign credentials](../../credentials/activecampaign/) for guidance on setting up authentication.

This node can be used as an AI tool

This node can be used to enhance the capabilities of an AI agent. When used in this way, many parameters can be set automatically, or with information directed by AI - find out more in the [AI tool parameters documentation](../../../../advanced-ai/examples/using-the-fromai-function/).

- Account
  - Create an account
  - Delete an account
  - Get data of an account
  - Get data of all accounts
  - Update an account
- Account Contact
  - Create an association
  - Delete an association
  - Update an association
- Contact
  - Create a contact
  - Delete a contact
  - Get data of a contact
  - Get data of all contact
  - Update a contact
- Contact List
  - Add contact to a list
  - Remove contact from a list
- Contact Tag
  - Add a tag to a contact
  - Remove a tag from a contact
- Connection
  - Create a connection
  - Delete a connection
  - Get data of a connection
  - Get data of all connections
  - Update a connection
- Deal
  - Create a deal
  - Delete a deal
  - Get data of a deal
  - Get data of all deals
  - Update a deal
  - Create a deal note
  - Update a deal note
- E-commerce Order
  - Create a order
  - Delete a order
  - Get data of a order
  - Get data of all orders
  - Update a order
- E-Commerce Customer
  - Create a E-commerce Customer
  - Delete a E-commerce Customer
  - Get data of a E-commerce Customer
  - Get data of all E-commerce Customer
  - Update a E-commerce Customer
- E-commerce Order Products
  - Get data of all order products
  - Get data of a ordered product
  - Get data of an order's products
- List
  - Get all lists
- Tag
  - Create a tag
  - Delete a tag
  - Get data of a tag
  - Get data of all tags
  - Update a tag

## Templates and examples

**Create a contact in ActiveCampaign**

[View template details](https://n8n.io/workflows/412-create-a-contact-in-activecampaign/)

**Receive updates when a new account is added by an admin in ActiveCampaign**

[View template details](https://n8n.io/workflows/488-receive-updates-when-a-new-account-is-added-by-an-admin-in-activecampaign/)

**🛠️ ActiveCampaign Tool MCP Server 💪 all 48 operations**

[View template details](https://n8n.io/workflows/5336-activecampaign-tool-mcp-server-all-48-operations/)

[Browse ActiveCampaign integration templates](https://n8n.io/integrations/activecampaign/), or [search all templates](https://n8n.io/workflows/)

## What to do if your operation isn't supported

If this node doesn't support the operation you want to do, you can use the [HTTP Request node](../../core-nodes/n8n-nodes-base.httprequest/) to call the service's API.

You can use the credential you created for this service in the HTTP Request node:

1. In the HTTP Request node, select **Authentication** > **Predefined Credential Type**.
1. Select the service you want to connect to.
1. Select your credential.

Refer to [Custom API operations](../../../custom-operations/) for more information.

---

## Iterable node

**URL:** llms-txt#iterable-node

**Contents:**
- Operations
- Templates and examples

Use the Iterable node to automate work in Iterable, and integrate Iterable with other applications. n8n has built-in support for a wide range of Iterable features, including creating users, recording the actions performed by the users, and adding and removing users from the list.

On this page, you'll find a list of operations the Iterable node supports and links to more resources.

Refer to [Iterable credentials](../../credentials/iterable/) for guidance on setting up authentication.

- Event
  - Record the actions a user perform
- User
  - Create/Update a user
  - Delete a user
  - Get a user
- User List
  - Add user to list
  - Remove a user from a list

## Templates and examples

[Browse Iterable integration templates](https://n8n.io/integrations/iterable/), or [search all templates](https://n8n.io/workflows/)

---

## Mindee credentials

**URL:** llms-txt#mindee-credentials

**Contents:**
- Prerequisites
- Supported authentication methods
- Related resources
- Using invoice API key
- Using receipt API key

You can use these credentials to authenticate the following nodes:

- [Mindee](../../app-nodes/n8n-nodes-base.mindee/)

Create a [Mindee](https://mindee.com) account.

## Supported authentication methods

- Invoice API key: For use with the [Invoice OCR API](https://www.mindee.com/product/invoice-ocr-api)
- Receipt API key: For use with the [Receipt OCR API](https://www.mindee.com/product/receipt-ocr-api)

Refer to [Mindee's Invoice OCR API documentation](https://developers.mindee.com/docs/invoice-ocr) and [Mindee's Receipt OCR API documentation](https://developers.mindee.com/docs/receipt-ocr) for more information about each service.

## Using invoice API key

To configure this credential, you'll need:

- An **API Key**: Refer to the Mindee [Create & Manage API Keys documentation](https://developers.mindee.com/docs/create-api-key) for instructions on creating API keys.

## Using receipt API key

To configure this credential, you'll need:

- An **API Key**: Refer to the Mindee [Create & Manage API Keys documentation](https://developers.mindee.com/docs/create-api-key) for instructions on creating API keys.

---

## Gmail node Message Operations

**URL:** llms-txt#gmail-node-message-operations

**Contents:**
- Add Label to a message
- Delete a message
- Get a message
- Get Many messages
  - Get Many messages filters
- Mark as Read
- Mark as Unread
- Remove Label from a message
- Reply to a message
  - Reply options

Use the Message operations to send, reply to, delete, mark read or unread, add a label to, remove a label from, or get a message or get a list of messages in Gmail. Refer to the [Gmail node](../) for more information on the Gmail node itself.

## Add Label to a message

Use this operation to add one or more labels to a message.

Enter these parameters:

- Select the **Credential to connect with** or create a new one.
- **Resource**: Select **Message**.
- **Operation**: Select **Add Label**.
- **Message ID**: Enter the ID of the message you want to add the label to.
- **Label Names or IDs**: Select the Label names you want to add or enter an expression to specify IDs. The dropdown populates based on the **Credential** you selected.

Refer to the [Gmail API Method: users.messages.modify](https://developers.google.com/gmail/api/reference/rest/v1/users.messages/modify) documentation for more information.

Use this operation to immediately and permanently delete a message.

This operation can't be undone. For recoverable deletions, use the [Thread Trash operation](../thread-operations/#trash-a-thread) instead.

Enter these parameters:

- Select the **Credential to connect with** or create a new one.
- **Resource**: Select **Message**.
- **Operation**: Select **Delete**.
- **Message ID**: Enter the ID of the message you want to delete.

Refer to the [Gmail API Method: users.messages.delete](https://developers.google.com/gmail/api/reference/rest/v1/users.messages/delete) documentation for more information.

Use this operation to get a single message.

Enter these parameters:

- Select the **Credential to connect with** or create a new one.
- **Resource**: Select **Message**.
- **Operation**: Select **Get**.
- **Message ID**: Enter the ID of the message you wish to retrieve.
- **Simplify**: Choose whether to return a simplified version of the response (turned on) or the raw data (turned off). Default is on.
  - This is the same as setting the `format` for the API call to `metadata`, which returns email message IDs, labels, and email headers, including: From, To, CC, BCC, and Subject.

Refer to the [Gmail API Method: users.messages.get](https://developers.google.com/gmail/api/reference/rest/v1/users.messages/get) documentation for more information.

Use this operation to get two or more messages.

Enter these parameters:

- Select the **Credential to connect with** or create a new one.
- **Resource**: Select **Message**.
- **Operation**: Select **Get Many**.
- **Return All**: Choose whether the node returns all messages (turned on) or only up to a set limit (turned off).
- **Limit**: Enter the maximum number of messages to return. Only used if you've turned off **Return All**.
- **Simplify**: Choose whether to return a simplified version of the response (turned on) or the raw data (turned off). Default is on.
  - This is the same as setting the `format` for the API call to `metadata`, which returns email message IDs, labels, and email headers, including: From, To, CC, BCC, and Subject.

### Get Many messages filters

Use these filters to further refine the node's behavior:

- **Include Spam and Trash**: Select whether the node should get messages in the Spam and Trash folders (turned on) or not (turned off).
- **Label Names or IDs**: Only return messages with the selected labels added to them. Select the Label names you want to apply or enter an expression to specify IDs. The dropdown populates based on the **Credential** you selected.
- **Search**: Enter Gmail search refine filters, like `from:`, to filter the messages returned. Refer to [Refine searches in Gmail](https://support.google.com/mail/answer/7190?hl=en) for more information.
- **Read Status**: Choose whether to receive **Unread and read emails**, **Unread emails only** (default), or **Read emails only**.
- **Received After**: Return only those emails received after the specified date and time. Use the date picker to select the day and time or enter an expression to set a date as a string in ISO format or a timestamp in milliseconds. Refer to [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) for more information on formatting the string.
- **Received Before**: Return only those emails received before the specified date and time. Use the date picker to select the day and time or enter an expression to set a date as a string in ISO format or a timestamp in milliseconds. Refer to [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) for more information on formatting the string.
- **Sender**: Enter an email or a part of a sender name to return messages from only that sender.

Refer to the [Gmail API Method: users.messages.list](https://developers.google.com/gmail/api/reference/rest/v1/users.messages/list) documentation for more information.

Use this operation to mark a message as read.

Enter these parameters:

- Select the **Credential to connect with** or create a new one.
- **Resource**: Select **Message**.
- **Operation**: Select **Mark as Read**.
- **Message ID**: Enter the ID of the message you wish to mark as read.

Refer to the [Gmail API Method: users.messages.modify](https://developers.google.com/gmail/api/reference/rest/v1/users.messages/modify) documentation for more information.

Use this operation to mark a message as unread.

Enter these parameters:

- Select the **Credential to connect with** or create a new one.
- **Resource**: Select **Message**.
- **Operation**: Select **Mark as Unread**.
- **Message ID**: Enter the ID of the message you wish to mark as unread.

Refer to the [Gmail API Method: users.messages.modify](https://developers.google.com/gmail/api/reference/rest/v1/users.messages/modify) documentation for more information.

## Remove Label from a message

Use this operation to remove one or more labels from a message.

Enter these parameters:

- Select the **Credential to connect with** or create a new one.
- **Resource**: Select **Message**.
- **Operation**: Select **Remove Label**.
- **Message ID**: Enter the ID of the message you want to remove the label from.
- **Label Names or IDs**: Select the Label names you want to remove or enter an expression to specify IDs. The dropdown populates based on the **Credential** you selected.

Refer to the [Gmail API Method: users.messages.modify](https://developers.google.com/gmail/api/reference/rest/v1/users.messages/modify) documentation for more information.

## Reply to a message

Use this operation to send a message as a reply to an existing message.

Enter these parameters:

- Select the **Credential to connect with** or create a new one.
- **Resource**: Select **Message**.
- **Operation**: Select **Reply**.
- **Message ID**: Enter the ID of the message you want to reply to.
- Select the **Email Type**. Choose from **Text** or **HTML**.
- **Message**: Enter the email message body.

Use these options to further refine the node's behavior:

- **Append n8n attribution**: By default, the node appends the statement `This email was sent automatically with n8n` to the end of the email. To remove this statement, turn this option off.
- **Attachments**: Select **Add Attachment** to add an attachment. Enter the **Attachment Field Name (in Input)** to identify which field from the input node contains the attachment.
  - For multiple properties, enter a comma-separated list.
- **BCC**: Enter one or more email addresses for blind copy recipients. Separate multiple email addresses with a comma, for example `jay@gatsby.com, jon@smith.com`.
- **CC**: Enter one or more email addresses for carbon copy recipients. Separate multiple email addresses with a comma, for example `jay@gatsby.com, jon@smith.com`.
- **Sender Name**: Enter the name you want displayed in your recipients' email as the sender.
- **Reply to Sender Only**: Choose whether to reply all (turned off) or reply to the sender only (turned on).

Refer to the [Gmail API Method: users.messages.send](https://developers.google.com/gmail/api/reference/rest/v1/users.messages/send) documentation for more information.

Use this operation to send a message.

Enter these parameters:

- Select the **Credential to connect with** or create a new one.
- **Resource**: Select **Message**.
- **Operation**: Select **Send**.
- **To**: Enter the email address you want the email sent to.
- **Subject**: Enter the subject line.
- Select the **Email Type**. Choose from **Text** or **HTML**.
- **Message**: Enter the email message body.

Use these options to further refine the node's behavior:

- **Append n8n attribution**: By default, the node appends the statement `This email was sent automatically with n8n` to the end of the email. To remove this statement, turn this option off.
- **Attachments**: Select **Add Attachment** to add an attachment. Enter the **Attachment Field Name (in Input)** to identify which field from the input node contains the attachment.
  - For multiple properties, enter a comma-separated list.
- **BCC**: Enter one or more email addresses for blind copy recipients. Separate multiple email addresses with a comma, for example `jay@gatsby.com, jon@smith.com`.
- **CC**: Enter one or more email addresses for carbon copy recipients. Separate multiple email addresses with a comma, for example `jay@gatsby.com, jon@smith.com`.
- **Sender Name**: Enter the name you want displayed in your recipients' email as the sender.
- **Send Replies To**: Enter an email address to set as the reply to address.
- **Reply to Sender Only**: Choose whether to reply all (turned off) or reply to the sender only (turned on).

Refer to the [Gmail API Method: users.messages.send](https://developers.google.com/gmail/api/reference/rest/v1/users.messages/send) documentation for more information.

## Send a message and wait for approval

Use this operation to send a message and wait for approval from the recipient before continuing the workflow execution.

Use Wait for complex approvals

The **Send and Wait for Approval** operation is well-suited for simple approval processes. For more complex approvals, consider using the [Wait node](../../../core-nodes/n8n-nodes-base.wait/).

Enter these parameters:

- Select the **Credential to connect with** or create a new one.
- **Resource**: Select **Message**.
- **Operation**: Select **Send and Wait for Approval**.
- **To**: Enter the email address you want the email sent to.
- **Subject**: Enter the subject line.
- **Message**: Enter the email message body.

### Send and wait for approval options

Use these options to further refine the node's behavior:

- **Type of Approval**: Choose **Approve Only** (default) to include only an approval button or **Approve and Disapprove** to also include a disapproval option.
- **Approve Button Label**: The label to use for the approval button (**Approve** by default).
- **Approve Button Style**: Whether to style the approval button as a **Primary** (default) or **Secondary** button.
- **Disapprove Button Label**: The label to use for the disapproval button (**Decline** by default). Only visible when you set **Type of Approval** to **Approve and Disapprove**.
- **Disapprove Button Style**: Whether to style the disapproval button as a **Primary** or **Secondary** (default) button. Only visible when you set **Type of Approval** to **Approve and Disapprove**.

Refer to the [Gmail API Method: users.messages.send](https://developers.google.com/gmail/api/reference/rest/v1/users.messages/send) documentation for more information.

For common errors or issues and suggested resolution steps, refer to [Common Issues](../common-issues/).

---

## Notion Trigger node

**URL:** llms-txt#notion-trigger-node

**Contents:**
- Events
- Related resources

[Notion](https://notion.so) is an all-in-one workspace for your notes, tasks, wikis, and databases.

You can find authentication information for this node [here](../../credentials/notion/).

Examples and templates

For usage examples and templates to help you get started, refer to n8n's [Notion Trigger integrations](https://n8n.io/integrations/notion-trigger-beta/) page.

- Page added to database
- Page updated in database

n8n provides an app node for Notion. You can find the node docs [here](../../app-nodes/n8n-nodes-base.notion/).

View [example workflows and related content](https://n8n.io/integrations/notion-trigger-beta/) on n8n's website.

Refer to [Notion's documentation](https://developers.notion.com/) for details about their API.

---

## Invoice Ninja credentials

**URL:** llms-txt#invoice-ninja-credentials

**Contents:**
- Prerequisites
- Supported authentication methods
- Related resources
- Using API key

You can use these credentials to authenticate the following nodes:

- [Invoice Ninja](../../app-nodes/n8n-nodes-base.invoiceninja/)
- [Invoice Ninja Trigger](../../trigger-nodes/n8n-nodes-base.invoiceninjatrigger/)

Create an [Invoice Ninja](https://www.invoiceninja.com/) account. Only the Pro and Enterprise plans support API integrations.

## Supported authentication methods

Refer to Invoice Ninja's [v4 API documentation](https://invoice-ninja.readthedocs.io/en/latest/api.html) and [v5 API documentation](https://api-docs.invoicing.co/) for more information about the APIs.

To configure this credential, you'll need:

- A **URL**: If Invoice Ninja hosts your installation, use either of the default URLs mentioned. If you're self-hosting your installation, use the URL of your Invoice Ninja instance.
- An **API Token**: Generate an API token in **Settings > Account Management > API Tokens**.
- An optional **Secret**, available only for v5 API users

---

## Mailjet credentials

**URL:** llms-txt#mailjet-credentials

**Contents:**
- Prerequisites
- Supported authentication methods
- Related resources
- Using Email API key
- Using SMS Token

You can use these credentials to authenticate the following nodes:

- [Mailjet](../../app-nodes/n8n-nodes-base.mailjet/)
- [Mailjet Trigger](../../trigger-nodes/n8n-nodes-base.mailjettrigger/)

Create a [Mailjet](https://www.mailjet.com/) account.

## Supported authentication methods

- Email API key: For use with Mailjet's Email API
- SMS token: For use with Mailjet's SMS API

Refer to [Mailjet's Email API documentation](https://dev.mailjet.com/email/guides/) and [Mailjet's SMS API documentation](https://dev.mailjet.com/sms/reference/send-message/) for more information about each service.

## Using Email API key

To configure this credential, you'll need:

- An **API Key**: View and generate API keys in your Mailjet [API Key Management](https://app.mailjet.com/signin) page.
- A **Secret Key**: View your API Secret Keys in your Mailjet [API Key Management](https://app.mailjet.com/signin) page.
- *Optional:* Select whether to use **Sandbox Mode** for calls made using this credential. When turned on, all API calls use Sandbox mode: the API will still validate the payloads but won't deliver the actual messages. This can be useful to troubleshoot any payload error messages without actually sending messages. Refer to Mailjet's [Sandbox Mode documentation](https://dev.mailjet.com/email/guides/send-api-v31/#sandbox-mode) for more information.

For this credential, you can use either:

- Mailjet's primary API key and secret key
- A subaccount API key and secret key

Refer to Mailjet's [How to create a subaccount (or additional API key) documentation](https://documentation.mailjet.com/hc/en-us/articles/360042561974-How-to-create-a-subaccount-or-additional-API-Key) for detailed instructions on creating more API keys. Refer to [What are subaccounts and how does it help me?](https://documentation.mailjet.com/hc/en-us/articles/360042561854-What-are-subaccounts-and-how-does-it-help-me) page for more information on Mailjet subaccounts and when you might want to use one.

To configure this credential, you'll need:

- An access **Token**: Generate a new token from Mailjet's [SMS Dashboard](https://app.mailjet.com/sms).

---

## OpenCTI credentials

**URL:** llms-txt#opencti-credentials

**Contents:**
- Prerequisites
- Authentication methods
- Related resources
- Using API key

You can use these credentials to authenticate when using the [HTTP Request node](../../core-nodes/n8n-nodes-base.httprequest/) to make a [Custom API call](../../../custom-operations/).

Create an [OpenCTI](https://filigran.io/solutions/open-cti/) developer account.

## Authentication methods

Refer to [OpenCTI's documentation](https://docs.opencti.io/latest/) for more information about the service.

This is a credential-only node. Refer to [Custom API operations](../../../custom-operations/) to learn more. View [example workflows and related content](https://n8n.io/integrations/opencti/) on n8n's website.

To configure this credential, you'll need:

- An **API Key**: To get your API key, go to your **Profile > API access**. Refer to the OpenCTI [Integrations Authentication documentation](https://docs.opencti.io/latest/deployment/integrations/#authentication) for more information.

---

## Figma credentials

**URL:** llms-txt#figma-credentials

**Contents:**
- Prerequisites
- Supported authentication methods
- Related resources
- Using API key

You can use these credentials to authenticate the following nodes:

- [Figma Trigger (Beta)](../../trigger-nodes/n8n-nodes-base.figmatrigger/)

Create a [Figma](https://www.figma.com/) account. You need an admin or owner level account.

## Supported authentication methods

Refer to [Figma's API documentation](https://www.figma.com/developers/api) for more information about the service.

To configure this credential, you'll need:

- A Personal **Access Token** (PAT): Refer to the [Figma API Access Tokens documentation](https://www.figma.com/developers/api#access-tokens) for instructions on generating a Personal **Access Token**.

---

## Recorded Future credentials

**URL:** llms-txt#recorded-future-credentials

**Contents:**
- Prerequisites
- Supported authentication methods
- Related resources
- Using API access token

You can use these credentials to authenticate when using the [HTTP Request node](../../core-nodes/n8n-nodes-base.httprequest/) to make a [Custom API call](../../../custom-operations/).

Create a [Recorded Future](https://www.recordedfuture.com) account.

## Supported authentication methods

Refer to [Recorded Future's documentation](https://api.recordedfuture.com/index.html) for more information about the service. The rest of Recorded Future's help center requires a paid account.

This is a credential-only node. Refer to [Custom API operations](../../../custom-operations/) to learn more. View [example workflows and related content](https://n8n.io/integrations/recorded-future/) on n8n's website.

## Using API access token

To configure this credential, you'll need:

- An API **Access Token**

Refer to the [Recorded Future APIs documentation](https://support.recordedfuture.com/hc/en-us/categories/16372120363539-Recorded-Future-APIs) for more information on getting your API access token.

---

## Microsoft Entra ID node

**URL:** llms-txt#microsoft-entra-id-node

**Contents:**
- Operations
- Templates and examples
- Related resources
- What to do if your operation isn't supported
- Common issues
  - Updating the Allow External Senders and Auto Subscribe New Members options fails

Use the Microsoft Entra ID node to automate work in Microsoft Entra ID and integrate Microsoft Entra ID with other applications. n8n has built-in support for a wide range of Microsoft Entra ID features, which includes creating, getting, updating, and deleting users and groups, as well as adding users to and removing them from groups.

On this page, you'll find a list of operations the Microsoft Entra ID node supports, and links to more resources.

You can find authentication information for this node [here](../../credentials/microsoftentra/).

- **Group**
  - **Create**: Create a new group
  - **Delete**: Delete an existing group
  - **Get**: Retrieve data for a specific group
  - **Get Many**: Retrieve a list of groups
  - **Update**: Update a group
- **User**
  - **Create**: Create a new user
  - **Delete**: Delete an existing user
  - **Get**: Retrieve data for a specific user
  - **Get Many**: Retrieve a list of users
  - **Update**: Update a user
  - **Add to Group**: Add user to a group
  - **Remove from Group**: Remove user from a group

## Templates and examples

[Browse Microsoft Entra ID integration templates](https://n8n.io/integrations/microsoft-entra-id-azure-active-directory/), or [search all templates](https://n8n.io/workflows/)

Refer to [Microsoft Entra ID's documentation](https://learn.microsoft.com/en-us/graph/api/resources/identity-network-access-overview?view=graph-rest-1.0) for more information about the service.

## What to do if your operation isn't supported

If this node doesn't support the operation you want to do, you can use the [HTTP Request node](../../core-nodes/n8n-nodes-base.httprequest/) to call the service's API.

You can use the credential you created for this service in the HTTP Request node:

1. In the HTTP Request node, select **Authentication** > **Predefined Credential Type**.
1. Select the service you want to connect to.
1. Select your credential.

Refer to [Custom API operations](../../../custom-operations/) for more information.

Here are some common errors and issues with the Microsoft Entra ID node and steps to resolve or troubleshoot them.

### Updating the Allow External Senders and Auto Subscribe New Members options fails

You can't update the **Allow External Senders** and **Auto Subscribe New Members** options directly after creating a new group. You must wait after creating a group before you can change the values of these options.

When designing workflows that use multiple Microsoft Entra ID nodes to first create groups and then update these options, add a [Wait](../../core-nodes/n8n-nodes-base.wait/) node between the two operations. A Wait node configured to pause for at least two seconds allows time for the group to fully initialize. After the wait, the update operation can complete without erroring.

---

## Cohere Model node

**URL:** llms-txt#cohere-model-node

**Contents:**
- Node Options
- Templates and examples
- Related resources

Use the Cohere Model node to use Cohere's models.

On this page, you'll find the node parameters for the Cohere Model node, and links to more resources.

This node lacks tools support, so it won't work with the [AI Agent](../../root-nodes/n8n-nodes-langchain.agent/) node. Instead, connect it with the [Basic LLM Chain](../../root-nodes/n8n-nodes-langchain.chainllm/) node.

You can find authentication information for this node [here](../../../credentials/cohere/).

Parameter resolution in sub-nodes

Sub-nodes behave differently to other nodes when processing multiple items using an expression.

Most nodes, including root nodes, take any number of items as input, process these items, and output the results. You can use expressions to refer to input items, and the node resolves the expression for each item in turn. For example, given an input of five `name` values, the expression `{{ $json.name }}` resolves to each name in turn.

In sub-nodes, the expression always resolves to the first item. For example, given an input of five `name` values, the expression `{{ $json.name }}` always resolves to the first name.

- **Maximum Number of Tokens**: Enter the maximum number of tokens used, which sets the completion length.
- **Sampling Temperature**: Use this option to control the randomness of the sampling process. A higher temperature creates more diverse sampling, but increases the risk of hallucinations.

## Templates and examples

**Automate Sales Cold Calling Pipeline with Apify, GPT-4o, and WhatsApp**

[View template details](https://n8n.io/workflows/5449-automate-sales-cold-calling-pipeline-with-apify-gpt-4o-and-whatsapp/)

**Create a Multi-Modal Telegram Support Bot with GPT-4 and Supabase RAG**

by Ezema Kingsley Chibuzo

[View template details](https://n8n.io/workflows/5589-create-a-multi-modal-telegram-support-bot-with-gpt-4-and-supabase-rag/)

**Build a Document QA System with RAG using Milvus, Cohere, and OpenAI for Google Drive**

[View template details](https://n8n.io/workflows/3848-build-a-document-qa-system-with-rag-using-milvus-cohere-and-openai-for-google-drive/)

[Browse Cohere Model integration templates](https://n8n.io/integrations/cohere-model/), or [search all templates](https://n8n.io/workflows/)

Refer to [LangChains's Cohere documentation](https://js.langchain.com/docs/integrations/llms/cohere/) for more information about the service.

View n8n's [Advanced AI](../../../../../advanced-ai/) documentation.

---

## 4. Setting Values for Processing Orders

**URL:** llms-txt#4.-setting-values-for-processing-orders

**Contents:**
- Add another node before the Airtable node
- Configure the Edit Fields node
- Add data to Airtable
- What's next?

In this step of the workflow, you will learn how to select and set data before transferring it to Airtable using the Edit Fields (Set) node. After this step, your workflow should look like this:

[View workflow file](/_workflows//courses/level-one/chapter-5/chapter-5.4.json)

The next step in Nathan's workflow is to filter the data to only insert the `employeeName` and `orderID` of all `processing` orders into Airtable.

For this, you need to use the [Edit Fields (Set) node](../../../../integrations/builtin/core-nodes/n8n-nodes-base.set/), which allows you to select and set the data you want to transfer from one node to another.

The Edit Fields node can set completely new data as well as overwrite data that already exists. This node is crucial in workflows which expect incoming data from previous nodes, such as when inserting values into spreadsheets or databases.

## Add another node before the Airtable node

In your workflow, add another node before the **Airtable node** from the **If node** in the same way we did it in the [Filtering Orders](../chapter-5.3/#add-if-node-before-the-airtable-node) lesson on the If node's `true` connector. Feel free to drag the Airtable node further away if your canvas feels crowded.

## Configure the Edit Fields node

Now search for the **Edit Fields (Set) node** after you've selected the **+** sign coming off the If node's `true` connector.

With the Edit Fields node window open, configure these parameters:

- Ensure **Mode** is set to **Manual Mapping**.
- While you can use the **Expression editor** we used in the [Filtering Orders](../chapter-5.3/) lesson, this time, let's drag the fields from the **Input** into the **Fields to Set**:
  - Drag **If** > **orderID** as the first field.
  - Drag **If** > **employeeName** as the second field.
- Ensure that **Include Other Input Fields** is set to false.

Select **Execute step**. You should see the following results:

*Edit Fields (Set) node*

## Add data to Airtable

Next, let's insert these values into Airtable:

1. Go to your Airtable base.

1. Add a new table called `processingOrders`.

1. Replace the existing columns with two new columns:

- `orderID` (primary field): Number
   - `employeeName`: Single line text

If you get stuck, refer to the [Inserting data into Airtable](../chapter-5.2/) lesson.

1. Delete the three empty rows in the new table.

1. In n8n, connect the Edit Fields node **connector to the** Airtable node\*\*.

1. Update the Airtable node configuration to point to the new `processingOrders` table instead of the `orders` table.

1. Test your Airtable node to be sure it inserts records into the new `processingOrders` table.

At this stage, your workflow should now look like this:

[View workflow file](/_workflows//courses/level-one/chapter-5/chapter-5.4.json)

**Nathan 🙋**: You've already automated half of my work! Now I still need to calculate the booked orders for my colleagues. Can we automate that as well?

**You 👩‍🔧**: Yes! In the next step, I'll use some JavaScript code in a node to calculate the booked orders.

---

## Max number of finished executions to keep. May not strictly prune back down to the exact max count. Set to `0` for unlimited.

**URL:** llms-txt#max-number-of-finished-executions-to-keep.-may-not-strictly-prune-back-down-to-the-exact-max-count.-set-to-`0`-for-unlimited.

export EXECUTIONS_DATA_PRUNE_MAX_COUNT=50000

**Examples:**

Example 1 (unknown):
```unknown

```

---

## Mautic credentials

**URL:** llms-txt#mautic-credentials

**Contents:**
- Supported authentication methods
- Related resources
- Using basic auth
- Using OAuth2
- Enable the API

You can use these credentials to authenticate the following nodes:

- [Mautic](../../app-nodes/n8n-nodes-base.mautic/)
- [Mautic Trigger](../../trigger-nodes/n8n-nodes-base.mautictrigger/)

## Supported authentication methods

- Basic auth
- OAuth2

Refer to [Mautic's API documentation](https://developer.mautic.org/#rest-api) for more information about the service.

To set up this credential, your Mautic instance must have the API enabled. Refer to [Enable the API](#enable-the-api) for instructions.

To configure this credential, you'll need an account on a [Mautic](https://www.mautic.org/) instance and:

- Your **URL**
- A **Username**
- A **Password**

1. In Mautic, go to **Configuration > API Settings**.
1. If **Enable HTTP basic auth?** is set to **No**, change it to **Yes** and save. Refer to the [API Settings documentation](https://docs.mautic.org/en/5.x/configuration/settings.html#api-settings) for more information.
1. In n8n, enter the Base **URL** of your Mautic instance.
1. Enter your Mautic **Username**.
1. Enter your Mautic **Password**.

To set up this credential, your Mautic instance must have the API enabled. Refer to [Enable the API](#enable-the-api) for instructions.

To configure this credential, you'll need an account on a [Mautic](https://www.mautic.org/) instance and:

- A **Client ID**: Generated when you create new API credentials.
- A **Client Secret**: Generated when you create new API credentials.
- Your **URL**

1. In Mautic, go to **Configuration > Settings**.

1. Select **API Credentials**.

No API Credentials menu

If you don't see the **API Credentials** option under **Configuration > Settings**, be sure to [Enable the API](#enable-the-api). If you've enabled the API and you still don't see the option, try [manually clearing the cache](https://forum.mautic.org/t/cant-find-api-credentials-menu/10689).

1. Select the option to **Create new client**.

1. Select **OAuth 2** as the **Authorization Protocol**.

1. Enter a **Name** for your credential, like `n8n integration`.

1. In n8n, copy the **OAuth Callback URL** and enter it as the **Redirect URI** in Mautic.

1. Copy the **Client ID** from Mautic and enter it in your n8n credential.

1. Copy the **Client Secret** from Mautic and enter it in your n8n credential.

1. Enter the Base **URL** of your Mautic instance.

Refer to [What is Mautic's API?](https://kb.mautic.org/article/what-is-mautic-039%3bs-api.html#mcetoc_1g7n1bgoo0) for more information.

To enable the API in your Mautic instance:

1. Go to **Settings > Configuration**.
1. Select **API Settings**.
1. Set **API enabled?** to **Yes**.
1. **Save** your changes.

Refer to [How to use the Mautic API](https://kb.mautic.org/article/what-is-mautic-039;s-api.html) for more information.

---

## Kafka node

**URL:** llms-txt#kafka-node

**Contents:**
- Operations
- Templates and examples

Use the Kafka node to automate work in Kafka, and integrate Kafka with other applications. n8n has built-in support for a wide range of Kafka features, including sending messages.

On this page, you'll find a list of operations the Kafka node supports and links to more resources.

Refer to [Kafka credentials](../../credentials/kafka/) for guidance on setting up authentication.

This node can be used as an AI tool

This node can be used to enhance the capabilities of an AI agent. When used in this way, many parameters can be set automatically, or with information directed by AI - find out more in the [AI tool parameters documentation](../../../../advanced-ai/examples/using-the-fromai-function/).

## Templates and examples

[Browse Kafka integration templates](https://n8n.io/integrations/kafka/), or [search all templates](https://n8n.io/workflows/)

---

## Vonage credentials

**URL:** llms-txt#vonage-credentials

**Contents:**
- Prerequisites
- Supported authentication methods
- Related resources
- Using API key

You can use these credentials to authenticate the following nodes:

- [Vonage](../../app-nodes/n8n-nodes-base.vonage/)

Create a [Vonage developer](https://developer.vonage.com) account.

## Supported authentication methods

Refer to [Vonage's SMS API documentation](https://developer.vonage.com/en/api/sms) for more information about the service.

To configure this credential, you'll need:

- An **API Key**
- An **API Secret**

Get your **API Key** and **API Secret** from your [developer dashboard](https://dashboard.nexmo.com/) **user account > Settings > API Settings**. Refer to [Retrieve your account information](https://developer.vonage.com/en/account/guides/dashboard-management#retrieve-your-account-information) for more information.

---

## Date and time with Luxon

**URL:** llms-txt#date-and-time-with-luxon

**Contents:**
- Date and time behavior in n8n
- Setting the timezone in n8n
- Common tasks
  - Get the current datetime or date

[Luxon](https://github.com/moment/luxon/) is a JavaScript library that makes it easier to work with date and time. For full details of how to use Luxon, refer to [Luxon's documentation](https://moment.github.io/luxon/#/?id=luxon).

n8n passes dates between nodes as strings, so you need to parse them. Luxon makes this easier.

Luxon is a JavaScript library. The two convenience [variables](#get-the-current-datetime-or-date) created by n8n are available when using Python in the Code node, but their functionality is limited:

- You can't perform Luxon operations on these variables. For example, there is no Python equivalent for `$today.minus(...)`.
- The generic Luxon functionality, such as [Convert date string to Luxon](#convert-date-string-to-luxon), isn't available for Python users.

## Date and time behavior in n8n

Be aware of the following:

- In a workflow, n8n converts dates and times to strings between nodes. Keep this in mind when doing arithmetic on dates and times from other nodes.
- With vanilla JavaScript, you can convert a string to a date with `new Date('2019-06-23')`. In Luxon, you must use a function explicitly stating the format, such as `DateTime.fromISO('2019-06-23')` or `DateTime.fromFormat("23-06-2019", "dd-MM-yyyy")`.

## Setting the timezone in n8n

Luxon uses the n8n timezone. This value is either:

- Default: `America/New York`
- A custom timezone for your n8n instance, set using the `GENERIC_TIMEZONE` environment variable.
- A custom timezone for an individual workflow, configured in workflow settings.

This section provides examples for some common operations. More examples, and detailed guidance, are available in [Luxon's own documentation](https://moment.github.io/luxon/#/?id=luxon).

### Get the current datetime or date

Use the [`$now` and `$today` Luxon objects](../../builtin/date-time/) to get the current time or day:

- `now`: a Luxon object containing the current timestamp. Equivalent to `DateTime.now()`.
- `today`: a Luxon object containing the current timestamp, rounded down to the day. Equivalent to `DateTime.now().set({ hour: 0, minute: 0, second: 0, millisecond: 0 })`.

Note that these variables can return different time formats when cast as a string:

**Examples:**

Example 1 (unknown):
```unknown
{{$now}}
// n8n displays the ISO formatted timestamp
// For example 2022-03-09T14:02:37.065+00:00
{{"Today's date is " + $now}}
// n8n displays "Today's date is <unix timestamp>"
// For example "Today's date is 1646834498755"
```

Example 2 (unknown):
```unknown
$now
// n8n displays <ISO formatted timestamp>
// For example 2022-03-09T14:00:25.058+00:00
let rightNow = "Today's date is " + $now
// n8n displays "Today's date is <unix timestamp>"
// For example "Today's date is 1646834498755"
```

---

## Microsoft To Do node

**URL:** llms-txt#microsoft-to-do-node

**Contents:**
- Operations
- Templates and examples
- What to do if your operation isn't supported

Use the Microsoft To Do node to automate work in Microsoft To Do, and integrate Microsoft To Do with other applications. n8n has built-in support for a wide range of Microsoft To Do features, including creating, updating, deleting, and getting linked resources, lists, and tasks.

On this page, you'll find a list of operations the Microsoft To Do node supports and links to more resources.

Refer to [Microsoft credentials](../../credentials/microsoft/) for guidance on setting up authentication.

This node can be used as an AI tool

This node can be used to enhance the capabilities of an AI agent. When used in this way, many parameters can be set automatically, or with information directed by AI - find out more in the [AI tool parameters documentation](../../../../advanced-ai/examples/using-the-fromai-function/).

- Linked Resource
  - Create
  - Delete
  - Get
  - Get All
  - Update
- List
  - Create
  - Delete
  - Get
  - Get All
  - Update
- Task
  - Create
  - Delete
  - Get
  - Get All
  - Update

## Templates and examples

**📂 Automatically Update Stock Portfolio from OneDrive to Excel**

[View template details](https://n8n.io/workflows/2507-automatically-update-stock-portfolio-from-onedrive-to-excel/)

**Analyze Email Headers for IP Reputation and Spoofing Detection - Outlook**

[View template details](https://n8n.io/workflows/2676-analyze-email-headers-for-ip-reputation-and-spoofing-detection-outlook/)

**Create, update and get a task in Microsoft To Do**

[View template details](https://n8n.io/workflows/1114-create-update-and-get-a-task-in-microsoft-to-do/)

[Browse Microsoft To Do integration templates](https://n8n.io/integrations/microsoft-to-do/), or [search all templates](https://n8n.io/workflows/)

## What to do if your operation isn't supported

If this node doesn't support the operation you want to do, you can use the [HTTP Request node](../../core-nodes/n8n-nodes-base.httprequest/) to call the service's API.

You can use the credential you created for this service in the HTTP Request node:

1. In the HTTP Request node, select **Authentication** > **Predefined Credential Type**.
1. Select the service you want to connect to.
1. Select your credential.

Refer to [Custom API operations](../../../custom-operations/) for more information.

---

## Shopify node

**URL:** llms-txt#shopify-node

**Contents:**
- Operations
- Templates and examples
- What to do if your operation isn't supported

Use the Shopify node to automate work in Shopify, and integrate Shopify with other applications. n8n has built-in support for a wide range of Shopify features, including creating, updating, deleting, and getting orders and products.

On this page, you'll find a list of operations the Shopify node supports and links to more resources.

Refer to [Shopify credentials](../../credentials/shopify/) for guidance on setting up authentication.

- Order
  - Create an order
  - Delete an order
  - Get an order
  - Get all orders
  - Update an order
- Product
  - Create a product
  - Delete a product
  - Get a product
  - Get all products
  - Update a product

## Templates and examples

**Promote new Shopify products on Twitter and Telegram**

[View template details](https://n8n.io/workflows/1205-promote-new-shopify-products-on-twitter-and-telegram/)

**Run weekly inventories on Shopify sales**

[View template details](https://n8n.io/workflows/1207-run-weekly-inventories-on-shopify-sales/)

**Process Shopify new orders with Zoho CRM and Harvest**

[View template details](https://n8n.io/workflows/1206-process-shopify-new-orders-with-zoho-crm-and-harvest/)

[Browse Shopify integration templates](https://n8n.io/integrations/shopify/), or [search all templates](https://n8n.io/workflows/)

## What to do if your operation isn't supported

If this node doesn't support the operation you want to do, you can use the [HTTP Request node](../../core-nodes/n8n-nodes-base.httprequest/) to call the service's API.

You can use the credential you created for this service in the HTTP Request node:

1. In the HTTP Request node, select **Authentication** > **Predefined Credential Type**.
1. Select the service you want to connect to.
1. Select your credential.

Refer to [Custom API operations](../../../custom-operations/) for more information.

---

## Action Network credentials

**URL:** llms-txt#action-network-credentials

**Contents:**
- Supported authentication methods
- Related resources
- Using API key
- Request API access

You can use these credentials to authenticate the following nodes:

- [Action Network](../../app-nodes/n8n-nodes-base.actionnetwork/)

## Supported authentication methods

Refer to [Action Network's API documentation](https://actionnetwork.org/docs/) for more information about working with the service.

To configure this credential, you'll need an [Action Network](https://actionnetwork.org/) account with [API key access enabled](#request-api-access) and:

1. Log in to your Action Network account.
1. From the **Start Organizing** menu, select **Details >** [**API & Sync**](https://actionnetwork.org/apis).
1. Select the list you want to generate an API key for.
1. Generate an API key for that list.
1. Copy the **API Key** and enter it in your n8n credential.

Refer to the [Action Network API Authentication instructions](https://actionnetwork.org/docs/v2/#auth) for more information.

## Request API access

Each user account and group on the Action Network has a separate API key to access that user or group's data.

You must explicitly request API access from Action Network, which you can do in one of two ways:

1. If you're already a paying customer, [contact them](https://actionnetwork.org/contact) to request partner access. Partner access includes API key access.
1. If you're a developer, [request a developer account](https://actionnetwork.org/developers). Once your account request is granted, you'll have API key access.

---

## QRadar credentials

**URL:** llms-txt#qradar-credentials

**Contents:**
- Prerequisites
- Supported authentication methods
- Related resources
- Using API key

You can use these credentials to authenticate when using the [HTTP Request node](../../core-nodes/n8n-nodes-base.httprequest/) to make a [Custom API call](../../../custom-operations/).

Create a [Qradar](https://www.ibm.com/qradar) account.

## Supported authentication methods

Refer to [QRadar's documentation](https://ibmsecuritydocs.github.io/qradar_api_overview/) for more information about the service.

This is a credential-only node. Refer to [Custom API operations](../../../custom-operations/) to learn more. View [example workflows and related content](https://n8n.io/integrations/qradar/) on n8n's website.

To configure this credential, you'll need:

- An **API Key**: Also known as an authorized service token. Use the **Manage Authorized Services** window on the **Admin** tab to create an authentication token. Refer to [Creating an authentication token](https://www.ibm.com/docs/en/qradar-common?topic=forwarding-creating-authentication-token) for more information.

---

## Programmatic-style execute() method

**URL:** llms-txt#programmatic-style-execute()-method

The main difference between the declarative and programmatic styles is how they handle incoming data and build API requests. The programmatic style requires an `execute()` method, which reads incoming data and parameters, then builds a request. The declarative style handles requests using the `routing` key in the `operations` object.

The `execute()` method creates and returns an instance of `INodeExecutionData`.

You must include input and output item pairing information in the data you return. For more information, refer to [Paired items](../../paired-items/).

---

## Connections

**URL:** llms-txt#connections

**Contents:**
- Create a connection
- Delete a connection

A connection establishes a link between nodes to route data through the workflow. A connection between two nodes passes data from one node's output to another node's input.

## Create a connection

To create a connection between two nodes, select the grey dot or **Add node** on the right side of a node and slide the arrow to the grey rectangle on the left side of the following node.

## Delete a connection

Hover over the connection, then select **Delete** .

---

## Deploy a node

**URL:** llms-txt#deploy-a-node

This section contains details on how to deploy and share your node.

- [Submit your node to the community node repository](submit-community-nodes/). This makes it available for everyone to use, and allows you to [install and use it](../../community-nodes/installation/) like any other community node. This is the only way to use custom nodes on cloud.
- Install the node into your n8n instance as a [private node](install-private-nodes/).

---

## Groq Chat Model node

**URL:** llms-txt#groq-chat-model-node

**Contents:**
- Node parameters
- Node options
- Templates and examples
- Related resources

Use the Groq Chat Model node to access Groq's large language models for conversational AI and text generation tasks.

On this page, you'll find the node parameters for the Groq Chat Model node, and links to more resources.

You can find authentication information for this node [here](../../../credentials/groq/).

Parameter resolution in sub-nodes

Sub-nodes behave differently to other nodes when processing multiple items using an expression.

Most nodes, including root nodes, take any number of items as input, process these items, and output the results. You can use expressions to refer to input items, and the node resolves the expression for each item in turn. For example, given an input of five `name` values, the expression `{{ $json.name }}` resolves to each name in turn.

In sub-nodes, the expression always resolves to the first item. For example, given an input of five `name` values, the expression `{{ $json.name }}` always resolves to the first name.

- **Model**: Select the model which will generate the completion. n8n dynamically loads available models from the Groq API. Learn more in the [Groq model documentation](https://console.groq.com/docs/models).

- **Maximum Number of Tokens**: Enter the maximum number of tokens used, which sets the completion length.
- **Sampling Temperature**: Use this option to control the randomness of the sampling process. A higher temperature creates more diverse sampling, but increases the risk of hallucinations.

## Templates and examples

**Conversational Interviews with AI Agents and n8n Forms**

[View template details](https://n8n.io/workflows/2566-conversational-interviews-with-ai-agents-and-n8n-forms/)

**Telegram chat with PDF**

by felipe biava cataneo

[View template details](https://n8n.io/workflows/2392-telegram-chat-with-pdf/)

**Build an AI-Powered Tech Radar Advisor with SQL DB, RAG, and Routing Agents**

[View template details](https://n8n.io/workflows/3151-build-an-ai-powered-tech-radar-advisor-with-sql-db-rag-and-routing-agents/)

[Browse Groq Chat Model integration templates](https://n8n.io/integrations/groq-chat-model/), or [search all templates](https://n8n.io/workflows/)

Refer to [Groq's API documentation](https://console.groq.com/docs/quickstart) for more information about the service.

View n8n's [Advanced AI](../../../../../advanced-ai/) documentation.

---

## MongoDB Chat Memory node

**URL:** llms-txt#mongodb-chat-memory-node

**Contents:**
- Node parameters
- Related resources
- Single memory instance

Use the MongoDB Chat Memory node to use MongoDB as a [memory](../../../../../glossary/#ai-memory) server for storing chat history.

On this page, you'll find a list of operations the MongoDB Chat Memory node supports, and links to more resources.

You can find authentication information for this node [here](../../../credentials/mongodb/).

Parameter resolution in sub-nodes

Sub-nodes behave differently to other nodes when processing multiple items using an expression.

Most nodes, including root nodes, take any number of items as input, process these items, and output the results. You can use expressions to refer to input items, and the node resolves the expression for each item in turn. For example, given an input of five `name` values, the expression `{{ $json.name }}` resolves to each name in turn.

In sub-nodes, the expression always resolves to the first item. For example, given an input of five `name` values, the expression `{{ $json.name }}` always resolves to the first name.

- **Session Key**: Enter the key to use to store the memory in the workflow data.
- **Collection Name**: Enter the name of the collection to store the chat history in. The system will create the collection if it doesn't exist.
- **Database Name**: Enter the name of the database to store the chat history in. If not provided, the database from credentials will be used.
- **Context Window Length**: Enter the number of previous interactions to consider for context.

Refer to [LangChain's MongoDB Chat Message History documentation](https://js.langchain.com/docs/integrations/memory/mongodb) for more information about the service.

View n8n's [Advanced AI](../../../../../advanced-ai/) documentation.

## Single memory instance

If you add more than one MongoDB Chat Memory node to your workflow, all nodes access the same memory instance by default. Be careful when doing destructive actions that override existing memory contents, such as the override all messages operation in the [Chat Memory Manager](../n8n-nodes-langchain.memorymanager/) node. If you want more than one memory instance in your workflow, set different session IDs in different memory nodes.

---

## Zep node

**URL:** llms-txt#zep-node

**Contents:**
- Node parameters
- Templates and examples
- Related resources
- Single memory instance

This node is deprecated, and will be removed in a future version.

Use the Zep node to use Zep as a [memory](../../../../../glossary/#ai-memory) server.

On this page, you'll find a list of operations the Zep node supports, and links to more resources.

You can find authentication information for this node [here](../../../credentials/zep/).

Parameter resolution in sub-nodes

Sub-nodes behave differently to other nodes when processing multiple items using an expression.

Most nodes, including root nodes, take any number of items as input, process these items, and output the results. You can use expressions to refer to input items, and the node resolves the expression for each item in turn. For example, given an input of five `name` values, the expression `{{ $json.name }}` resolves to each name in turn.

In sub-nodes, the expression always resolves to the first item. For example, given an input of five `name` values, the expression `{{ $json.name }}` always resolves to the first name.

- **Session ID**: Enter the ID to use to store the memory in the workflow data.

## Templates and examples

[Browse Zep integration templates](https://n8n.io/integrations/zep/), or [search all templates](https://n8n.io/workflows/)

Refer to [LangChain's Zep documentation](https://js.langchain.com/docs/integrations/memory/zep_memory) for more information about the service.

View n8n's [Advanced AI](../../../../../advanced-ai/) documentation.

## Single memory instance

If you add more than one Zep node to your workflow, all nodes access the same memory instance by default. Be careful when doing destructive actions that override existing memory contents, such as the override all messages operation in the [Chat Memory Manager](../n8n-nodes-langchain.memorymanager/) node. If you want more than one memory instance in your workflow, set different session IDs in different memory nodes.

---

## Update your Cloud version

**URL:** llms-txt#update-your-cloud-version

**Contents:**
- Best practices for updating
- Automatic update

n8n recommends regularly updating your Cloud version. Check the [Release notes](../../release-notes/) to learn more about changes.

Only instance owners can upgrade n8n Cloud versions. Contact your instance owner if you don't have permission to update n8n Cloud.

1. [Log in to the n8n Cloud dashboard](https://app.n8n.cloud/manage)
1. On your dashboard, select **Manage**.
1. Use the **n8n version** dropdown to select your preferred release version:
   - Latest Stable: recommended for most users.
   - Latest Beta: get the newest n8n. This may be unstable.
1. Select **Save Changes** to restart your n8n instance and perform the update.
1. In the confirmation modal, select **Confirm**.

## Best practices for updating

- Update frequently: this avoids having to jump multiple versions at once, reducing the risk of a disruptive update. Try to update at least once a month.
- Check the [Release notes](../../release-notes/) for breaking changes.
- Use [Environments](../../source-control-environments/) to create a test version of your instance. Test the update there first.

n8n automatically updates outdated Cloud instances.

If you don't update you instance for 120 days, n8n emails you to warn you to update. After a further 30 days, n8n automatically updates your instance.

---

## Postgres node common issues

**URL:** llms-txt#postgres-node-common-issues

**Contents:**
- Dynamically populate SQL `IN` groups with parameters
- Working with timestamps and time zones
- Outputting Date columns as date strings instead of ISO datetime strings

Here are some common errors and issues with the [Postgres node](../) and steps to resolve or troubleshoot them.

## Dynamically populate SQL `IN` groups with parameters

In Postgres, you can use the SQL [`IN` comparison construct](https://www.postgresql.org/docs/current/functions-comparisons.html#FUNCTIONS-COMPARISONS-IN-SCALAR) to make comparisons between groups of values:

While you can use n8n [expressions](../../../../../code/expressions/) in your query to dynamically populate the values in an `IN` group, combining this with [query parameters](../#use-query-parameters) provides extra protection by automatically sanitizing input.

To construct an `IN` group query with query parameters:

1. Set the **Operation** to **Execute Query**.

1. In **Options**, select **Query Parameters**.

1. Use an expression to select an array from the input data. For example, `{{ $json.input_shirt_sizes }}`.

1. In the **Query** parameter, write your query with the `IN` construct with an empty set of parentheses. For example:

1. Inside of the `IN` parentheses, use an expression to dynamically create index-based placeholders (like `$1`, `$2`, and `$3`) for the number of items in your query parameter array. You can do this by increasing each array index by one since the placeholder variables are 1 indexed:

With this technique, n8n automatically creates the correct number of [prepared statement placeholders](https://www.postgresql.org/docs/current/sql-prepare.html) for the `IN` values according to the number of items in your array.

## Working with timestamps and time zones

To avoid complications with how n8n and Postgres interpret timestamp and time zone data, follow these general tips:

- **Use UTC when storing and passing dates**: Using UTC helps avoid confusion over timezone conversions when converting dates between different representations and systems.
- **Set the execution timezone**: Set the global timezone in n8n using either [environment variables](../../../../../hosting/configuration/configuration-examples/time-zone/) (for self-hosted) or in the [settings](../../../../../manage-cloud/set-cloud-timezone/) (for n8n Cloud). You can set a workflow-specific timezone in the [workflow settings](../../../../../workflows/settings/).
- **Use ISO 8601 format**: The [ISO 8601 format](https://en.wikipedia.org/wiki/ISO_8601) encodes the day of the month, month, year, hour, minutes, and seconds in a standardized string. n8n passes dates between nodes as strings and uses [Luxon](../../../../../code/cookbook/luxon/) to parse dates. If you need to cast to ISO 8601 explicitly, you can use the [Date & Time node](../../../core-nodes/n8n-nodes-base.datetime/) and a custom format set to the string `yyyy-MM-dd'T'HH:mm:ss`.

## Outputting Date columns as date strings instead of ISO datetime strings

n8n's uses the [`pg` package](https://www.npmjs.com/package/pg) to integrate with Postgres, which affects how n8n processes date, timestamp, and related types from Postgres.

The `pg` package parses `DATE` values into `new Date(row_value)` by default, which produces a date that follows the [ISO 8601 datetime string](https://en.wikipedia.org/wiki/ISO_8601#Combined_date_and_time_representations) format. For example, a date of `2025-12-25` might produce a datetime sting of `2025-12-25T23:00:00.000Z` depending on the instance's timezone settings.

To work around this, use the [Postgres `TO_CHAR` function](https://www.postgresql.org/docs/current/functions-formatting.html#FUNCTIONS-FORMATTING) to format the date into the expected format at query time:

This will produce the date as a string without the time or timezone components. To continue the earlier example, with this casting, a date of `2025-12-25` would produce the string `2025-12-25`. You can find out more in the [`pg` package documentation on dates](https://node-postgres.com/features/types#date--timestamp--timestamptz).

**Examples:**

Example 1 (unknown):
```unknown
SELECT color, shirt_size FROM shirts WHERE shirt_size IN ('small', 'medium', 'large');
```

Example 2 (unknown):
```unknown
SELECT color, shirt_size FROM shirts WHERE shirt_size IN ();
```

Example 3 (unknown):
```unknown
SELECT color, shirt_size FROM shirts WHERE shirt_size IN ({{ $json.input_shirt_sizes.map((i, pos) => "$" + (pos+1)).join(', ') }});
```

Example 4 (unknown):
```unknown
SELECT TO_CHAR(date_col, 'YYYY-MM-DD') AS date_col_as_date FROM table_with_date_col
```

---

## All documentation

**URL:** llms-txt#all-documentation

---

## Facebook App credentials

**URL:** llms-txt#facebook-app-credentials

**Contents:**
- Supported authentication methods
- Related resources
- Using app access token
  - Create a Meta app
  - Generate an App Access Token
  - Configure the Facebook Trigger
  - Optional: Add an App Secret
  - App review
- Common issues
  - Unverified apps limit

You can use these credentials to authenticate the following nodes:

- [Facebook Trigger](../../trigger-nodes/n8n-nodes-base.facebooktrigger/)

Facebook Graph API credentials

If you want to create credentials for the [Facebook Graph API](../../app-nodes/n8n-nodes-base.facebookgraphapi/) node, follow the instructions in the [Facebook Graph API credentials](../facebookgraph/) documentation.

## Supported authentication methods

Refer to [Meta's Graph API documentation](https://developers.facebook.com/docs/graph-api/overview) for more information about the service.

## Using app access token

To configure this credential, you'll need a [Meta for Developers](https://developers.facebook.com/) account and:

- An app **Access Token**
- An optional **App Secret**: Used to verify the integrity and origin of the payload.

There are five steps in setting up your credential:

1. [Create a Meta app](#create-a-meta-app) with the Webhooks product.
1. [Generate an App Access Token](#generate-an-app-access-token) for that app.
1. [Configure the Facebook trigger](#configure-the-facebook-trigger).
1. Optional: [Add an app secret](#optional-add-an-app-secret).
1. [App Review](#app-review): Only required if your app's users don't have roles on the app itself. If you're creating the app for your own internal purposes, this isn't necessary.

Refer to the detailed instructions below for each step.

### Create a Meta app

To create a Meta app:

1. Go to the Meta Developer [App Dashboard](https://developers.facebook.com/apps) and select **Create App**.
1. If you have a business portfolio and you're ready to connect the app to it, select the business portfolio. If you don't have a business portfolio or you're not ready to connect the app to the portfolio, select **I don’t want to connect a business portfolio yet** and select **Next**. The **Use cases** page opens.
1. Select **Other**, then select **Next**.
1. Select **Business** and **Next**.
1. Complete the essential information:
   - Add an **App name**.
   - Add an **App contact email**.
   - Here again you can connect to a business portfolio or skip it.
1. Select **Create app**.
1. The **Add products to your app** page opens.
1. Select **App settings > Basic** from the left menu.
1. Enter a **Privacy Policy URL**. (Required to take the app "Live.")
1. Select **Save changes**.
1. At the top of the page, toggle the **App Mode** from **Development** to **Live**.
1. In the left menu, select **Add Product**.
1. The **Add products to your app** page appears. Select **Webhooks**.
1. The **Webhooks** product opens.

Refer to Meta's [Create an app](https://developers.facebook.com/docs/development/create-an-app) documentation for more information on creating an app, required fields like the Privacy Policy URL, and adding products.

For more information on the app modes and switching to **Live** mode, refer to [App Modes](https://developers.facebook.com/docs/development/build-and-test/app-modes) and [Publish | App Types](https://developers.facebook.com/docs/development/release#app-types).

### Generate an App Access Token

Next, create an app access token to be used by your n8n credential and the Webhooks product:

1. In a separate tab or window, open the [Graph API explorer](https://developers.facebook.com/tools/explorer/).

1. Select the **Meta App** you just created in the **Access Token** section.

1. In **User or Page**, select **Get App Token**.

1. Select **Generate Access Token**.

1. The page prompts you to log in and grant access. Follow the on-screen prompts.

You may receive a warning that the app isn't available. Once you take an app live, there may be a few minutes' delay before you can generate an access token.

1. Copy the token and enter it in your n8n credential as the **Access Token**. Save this token somewhere else, too, since you'll need it for the Webhooks configuration.

1. Save your n8n credential.

Refer to the Meta instructions for [Your First Request](https://developers.facebook.com/docs/graph-api/get-started#get-started) for more information on generating the token.

### Configure the Facebook Trigger

Now that you have a token, you can configure the Facebook Trigger node:

1. In your Meta app, copy the **App ID** from the top navigation bar.
1. In n8n, open your Facebook Trigger node.
1. Paste the **App ID** into the **APP ID** field.
1. Select **Execute step** to shift the trigger into listening mode.
1. Return to the tab or window where your Meta app's **Webhooks** product configuration is open.
1. **Subscribe** to the objects you want to receive Facebook Trigger notifications about. For each subscription:
   1. Copy the **Webhook URL** from n8n and enter it as the **Callback URL** in your Meta App.
   1. Enter the **Access Token** you copied above as the **Verify token**.
   1. Select **Verify and save**. (This step fails if you don't have your n8n trigger listening.)
   1. Some webhook subscriptions, like **User**, prompt you to subscribe to individual events. Subscribe to the events you're interested in.
   1. You can send some **Test** events from Meta to confirm things are working. If you send a test event, verify its receipt in n8n.

Refer to the [Facebook Trigger node](../../trigger-nodes/n8n-nodes-base.facebooktrigger/) documentation for more information.

### Optional: Add an App Secret

For added security, Meta recommends adding an **App Secret**. This signs all API calls with the `appsecret_proof` parameter. The app secret proof is a sha256 hash of your access token, using your app secret as the key.

To generate an App Secret:

1. In Meta while viewing your app, select **App settings > Basic** from the left menu.
1. Select **Show** next to the **App secret** field.
1. The page prompts you to re-enter your Facebook account credentials. Once you do so, Meta shows the App Secret.
1. Highlight it to select it, copy it, and paste this into your n8n credential as the **App Secret**.
1. **Save** your n8n credential.

Refer to the [App Secret documentation](https://developers.facebook.com/docs/facebook-login/security#appsecret) for more information.

App Review requires Business Verification.

Your app must go through App Review if it will be used by someone who:

- Doesn't have a role on the app itself.
- Doesn't have a role in the Business that has claimed the app.

If your only app users are users who have a role on the app itself, App Review isn't required.

As part of the App Review process, you may need to request advanced access for your webhook subscriptions.

Refer to Meta's [App Review](https://developers.facebook.com/docs/resp-plat-initiatives/app-review) and [Advanced Access](https://developers.facebook.com/docs/graph-api/overview/access-levels#advanced-access) documentation for more information.

### Unverified apps limit

Facebook only lets you have a developer or administrator role on a maximum of 15 apps that aren't already linked to a Meta Verified Business Account.

Refer to [Limitations | Create an app](https://developers.facebook.com/docs/development/create-an-app#limitations) if you're over that limit.

---

## PayPal node

**URL:** llms-txt#paypal-node

**Contents:**
- Operations
- Templates and examples

Use the PayPal node to automate work in PayPal, and integrate PayPal with other applications. n8n has built-in support for a wide range of PayPal features, including creating a batch payout and canceling unclaimed payout items.

On this page, you'll find a list of operations the PayPal node supports and links to more resources.

Refer to [PayPal credentials](../../credentials/paypal/) for guidance on setting up authentication.

- Payout
  - Create a batch payout
  - Show batch payout details
- Payout Item
  - Cancels an unclaimed payout item
  - Show payout item details

## Templates and examples

**Create a PayPal batch payout**

[View template details](https://n8n.io/workflows/438-create-a-paypal-batch-payout/)

**Receive updates when a billing plan is activated in PayPal**

[View template details](https://n8n.io/workflows/653-receive-updates-when-a-billing-plan-is-activated-in-paypal/)

**Automate Digital Delivery After PayPal Purchase Using n8n**

[View template details](https://n8n.io/workflows/3697-automate-digital-delivery-after-paypal-purchase-using-n8n/)

[Browse PayPal integration templates](https://n8n.io/integrations/paypal/), or [search all templates](https://n8n.io/workflows/)

---

## Plan and Execute Agent node

**URL:** llms-txt#plan-and-execute-agent-node

**Contents:**
- Node parameters
  - Prompt
  - Require Specific Output Format
- Node options
  - Human Message Template
- Templates and examples
- Common issues

The Plan and Execute Agent is like the [ReAct agent](../react-agent/) but with a focus on planning. It first creates a high-level plan to solve the given task and then executes the plan step by step. This agent is most useful for tasks that require a structured approach and careful planning.

Refer to [AI Agent](../) for more information on the AI Agent node itself.

Configure the Plan and Execute Agent using the following parameters.

Select how you want the node to construct the prompt (also known as the user's query or input from the chat).

- **Take from previous node automatically**: If you select this option, the node expects an input from a previous node called `chatInput`.
- **Define below**: If you select this option, provide either static text or an expression for dynamic content to serve as the prompt in the **Prompt (User Message)** field.

### Require Specific Output Format

This parameter controls whether you want the node to require a specific output format. When turned on, n8n prompts you to connect one of these output parsers to the node:

- [Auto-fixing Output Parser](../../../sub-nodes/n8n-nodes-langchain.outputparserautofixing/)
- [Item List Output Parser](../../../sub-nodes/n8n-nodes-langchain.outputparseritemlist/)
- [Structured Output Parser](../../../sub-nodes/n8n-nodes-langchain.outputparserstructured/)

Refine the Plan and Execute Agent node's behavior using these options:

### Human Message Template

Enter a message that n8n will send to the agent during each step execution.

Available LangChain expressions:

- `{previous_steps}`: Contains information about the previous steps the agent's already completed.
- `{current_step}`: Contains information about the current step.
- `{agent_scratchpad}`: Information to remember for the next iteration.

## Templates and examples

Refer to the main AI Agent node's [Templates and examples](../#templates-and-examples) section.

For common questions or issues and suggested solutions, refer to [Common issues](../common-issues/).

---

## Zendesk credentials

**URL:** llms-txt#zendesk-credentials

**Contents:**
- Prerequisites
- Supported authentication methods
- Related resources
- Using API token
- Using OAuth2

You can use these credentials to authenticate the following nodes:

- [Zendesk](../../app-nodes/n8n-nodes-base.zendesk/)
- [Zendesk Trigger](../../trigger-nodes/n8n-nodes-base.zendesktrigger/)

- Create a [Zendesk](https://zendesk.com/) account.
- For API token authentication, enable token access to the API in Admin Center under **Apps and integrations > APIs > Zendesk APIs**.

## Supported authentication methods

Refer to [Zendesk's API documentation](https://developer.zendesk.com/api-reference/) for more information about the service.

To configure this credential, you'll need:

- Your **Subdomain**: Your Zendesk subdomain is the portion of the URL between `https://` and `.zendesk.com`. For example, if the Zendesk URL is `https://n8n-example.zendesk.com/agent/dashboard`, the subdomain is `n8n-example`.
- An **Email** address: Enter the email address you use to log in to Zendesk.
- An **API Token**: Generate an API token in **Apps and integrations > APIs > Zendesk API**. Refer to [API token](https://developer.zendesk.com/api-reference/introduction/security-and-auth/#api-token) for more information.

To configure this credential, you'll need:

- A **Client ID**: Generated when you create a new OAuth client.
- A **Client Secret**: Generated when you create a new OAuth client.
- Your **Subdomain**: Your Zendesk subdomain is the portion of the URL between `https://` and `.zendesk.com`. For example, if the Zendesk URL is `https://n8n-example.zendesk.com/agent/dashboard`, the subdomain is `n8n-example`.

To create a new OAuth client, go to **Apps and integrations > APIs > Zendesk API > OAuth Clients**.

- Copy the **OAuth Redirect URL** from n8n and enter it as a **Redirect URL** in the OAuth client.
- Copy the **Unique identifier** for the Zendesk client and enter this as your n8n **Client ID**.
- Copy the **Secret** from Zendesk and enter this as your n8n **Client Secret**

Refer to [Registering your application with Zendesk](https://support.zendesk.com/hc/en-us/articles/4408845965210-Using-OAuth-authentication-with-your-application#topic_s21_lfs_qk) for more information.

---

## Tips and common issues

**URL:** llms-txt#tips-and-common-issues

**Contents:**
- Combining multiple triggers
- Avoiding evaluation breaking the chat
- Accessing tool data when calculating metrics
- Multiple evaluations in the same workflow
- Dealing with inconsistent results

## Combining multiple triggers

If you have another trigger in the workflow already, you have two potential starting points: that trigger and the [evaluation trigger](../../../integrations/builtin/core-nodes/n8n-nodes-base.evaluationtrigger/). To make sure your workflow works as expected no matter which trigger executes, you will need to merge these branches together.

Logic to merge two trigger branches together so that they have the same data format and can be referenced from a single node.

1. **Get the data format of the other trigger**:
   - Execute the other trigger.
   - Open it and navigate to the JSON view of its output pane.
   - Click the **copy** button on the right.
1. **Re-shape the evaluation trigger data to match**:
   - Insert an [Edit Fields (Set) node](../../../integrations/builtin/core-nodes/n8n-nodes-base.set/) after the evaluation trigger and connect them together.
   - Change its mode to **JSON**.
   - Paste your data into the 'JSON' field, removing the `[` and `]` on the first and last lines.
   - Switch the field type to **Expression**.
   - Map in the data from the trigger by dragging it from the input pane.
   - For strings, make sure to replace the entire value (including the quotes) and add `.toJsonString()` to the end of the expression.
1. **Merge the branches using a 'No-op' node**: Insert a [No-op node](../../../integrations/builtin/core-nodes/n8n-nodes-base.noop/) and wire both the other trigger and the Set node up to it. The 'No-op' node just outputs whatever input it receives.
1. **Reference the 'No-op' node outputs in the rest of the workflow**: Since both paths will flow through this node with the same format, you can be sure that your input data will always be there.

## Avoiding evaluation breaking the chat

n8n's internal chat reads the output data of the last executed node in the workflow. After adding an evaluation node with the ['set outputs' operation](../../../integrations/builtin/core-nodes/n8n-nodes-base.evaluation/#set-outputs), this data may not be in the expected format, or even contain the chat response.

The solution is to add an extra branch coming out of your agent. [Lower branches execute later](../../../flow-logic/execution-order/) in n8n, which means any node you attach to this branch will execute last. You can use a no-op node here since it only needs to pass the agent output through.

## Accessing tool data when calculating metrics

Sometimes you need to know what happened in executed sub-nodes of an agent, for example to check whether it executed a tool. You can't reference these nodes directly with expressions, but you can enable the **Return intermediate steps** option in the agent. This will add an extra output field called `intermediateSteps` which you can use in later nodes:

## Multiple evaluations in the same workflow

You can only have one evaluation set up per workflow. In other words, you can only have one evaluation trigger per workflow.

Even so, you can still test different parts of your workflow with different evaluations by putting those parts in [sub-workflows](../../../flow-logic/subworkflows/) and evaluating each sub-workflow.

## Dealing with inconsistent results

Metrics can often have noise: they may be different across evaluation runs of the exact same workflow. This is because the workflow itself may return different results, or any LLM-based metrics might have natural variation in them.

You can compensate for this by duplicating the rows of your dataset, so that each row appears more than once in the dataset. Since this means that each input will effectively be running multiple times, it will smooth out any variations.

---

## Azure OpenAI credentials

**URL:** llms-txt#azure-openai-credentials

**Contents:**
- Prerequisites
- Supported authentication methods
- Related resources
- Using API key
- Using Azure Entra ID (OAuth2)
  - Register an application
  - Generate a client secret
- Setting custom scopes

You can use these credentials to authenticate the following nodes:

- [Chat Azure OpenAI](../../cluster-nodes/sub-nodes/n8n-nodes-langchain.lmchatazureopenai/)
- [Embeddings Azure OpenAI](../../cluster-nodes/sub-nodes/n8n-nodes-langchain.embeddingsazureopenai/)

- Create an [Azure](https://azure.microsoft.com) subscription.
- Access to Azure OpenAI within that subscription. You may need to [request access](https://aka.ms/oai/access) if your organization doesn't yet have it.

## Supported authentication methods

- API key
- Azure Entra ID (OAuth2)

Refer to [Azure OpenAI's API documentation](https://learn.microsoft.com/en-us/azure/ai-services/openai/reference) for more information about the service.

To configure this credential, you'll need:

- A **Resource Name**: the **Name** you give the resource
- An **API key**: **Key 1** works well. This can be accessed before deployment in **Keys and Endpoint**.
- The **API Version** the credentials should use. See the [Azure OpenAI API preview lifecycle documentation](https://learn.microsoft.com/en-us/azure/ai-services/openai/api-version-deprecation) for more information about API versioning in Azure OpenAI.

To get the information above, [create and deploy an Azure OpenAI Service resource](https://learn.microsoft.com/en-us/azure/ai-services/openai/how-to/create-resource).

Model name for Azure OpenAI nodes

Once you deploy the resource, use the **Deployment name** as the model name for the Azure OpenAI nodes where you're using this credential.

## Using Azure Entra ID (OAuth2)

Note for n8n Cloud users

Cloud users don't need to provide connection details. Select **Connect my account** to connect through your browser.

For self-hosted users, there are two main steps to configure OAuth2 from scratch:

1. [Register an application](#register-an-application) with the Microsoft Identity Platform.
1. [Generate a client secret](#generate-a-client-secret) for that application.

Follow the detailed instructions for each step below. For more detail on the Microsoft OAuth2 web flow, refer to [Microsoft authentication and authorization basics](https://learn.microsoft.com/en-us/graph/auth/auth-concepts).

### Register an application

Register an application with the Microsoft Identity Platform:

1. Open the [Microsoft Application Registration Portal](https://aka.ms/appregistrations).
1. Select **Register an application**.
1. Enter a **Name** for your app.
1. In **Supported account types**, select **Accounts in any organizational directory (Any Azure AD directory - Multi-tenant) and personal Microsoft accounts (for example, Skype, Xbox)**.
1. In **Register an application**:
   1. Copy the **OAuth Callback URL** from your n8n credential.
   1. Paste it into the **Redirect URI (optional)** field.
   1. Select **Select a platform** > **Web**.
1. Select **Register** to finish creating your application.
1. Copy the **Application (client) ID** and paste it into n8n as the **Client ID**.

Refer to [Register an application with the Microsoft Identity Platform](https://learn.microsoft.com/en-us/graph/auth-register-app-v2) for more information.

### Generate a client secret

With your application created, generate a client secret for it:

1. On your Microsoft application page, select **Certificates & secrets** in the left navigation.
1. In **Client secrets**, select **+ New client secret**.
1. Enter a **Description** for your client secret, such as `n8n credential`.
1. Select **Add**.
1. Copy the **Secret** in the **Value** column.
1. Paste it into n8n as the **Client Secret**.
1. Select **Connect my account** in n8n to finish setting up the connection.
1. Log in to your Microsoft account and allow the app to access your info.

Refer to Microsoft's [Add credentials](https://learn.microsoft.com/en-us/graph/auth-register-app-v2#add-credentials) for more information on adding a client secret.

## Setting custom scopes

Azure Entra ID credentials use the following scopes by default:

- [`openid`](https://learn.microsoft.com/en-us/entra/identity-platform/scopes-oidc#the-openid-scope)
- [`offline_access`](https://learn.microsoft.com/en-us/entra/identity-platform/scopes-oidc#the-offline_access-scope)
- [`AccessReview.ReadWrite.All`](https://learn.microsoft.com/en-us/graph/permissions-reference#accessreviewreadwriteall)
- [`Directory.ReadWrite.All`](https://learn.microsoft.com/en-us/graph/permissions-reference#directoryreadwriteall)
- [`NetworkAccessPolicy.ReadWrite.All`](https://learn.microsoft.com/en-us/graph/permissions-reference#networkaccesspolicyreadwriteall)
- [`DelegatedAdminRelationship.ReadWrite.All`](https://learn.microsoft.com/en-us/graph/permissions-reference#delegatedadminrelationshipreadwriteall)
- [`EntitlementManagement.ReadWrite.All`](https://learn.microsoft.com/en-us/graph/permissions-reference#entitlementmanagementreadwriteall)
- [`User.ReadWrite.All`](https://learn.microsoft.com/en-us/graph/permissions-reference#userreadwriteall)
- [`Directory.AccessAsUser.All`](https://learn.microsoft.com/en-us/graph/permissions-reference#directoryaccessasuserall)
- [`Sites.FullControl.All`](https://learn.microsoft.com/en-us/graph/permissions-reference#sitesfullcontrolall)
- [`GroupMember.ReadWrite.All`](https://learn.microsoft.com/en-us/graph/permissions-reference#groupmemberreadwriteall)

To select different scopes for your credentials, enable the **Custom Scopes** slider and edit the **Enabled Scopes** list. Keep in mind that some features may not work as expected with more restrictive scopes.

---

## HELP n8n_scaling_mode_queue_jobs_active Current number of jobs being processed across all workers in scaling mode.

**URL:** llms-txt#help-n8n_scaling_mode_queue_jobs_active-current-number-of-jobs-being-processed-across-all-workers-in-scaling-mode.

---

## Chat Trigger node

**URL:** llms-txt#chat-trigger-node

**Contents:**
- Node parameters
  - Make Chat Publicly Available
  - Mode
  - Authentication
  - Initial Message(s)
- Node options
  - Hosted chat options
  - Embedded chat options
- Templates and examples
- Related resources

Use the Chat Trigger node when building AI workflows for chatbots and other chat interfaces. You can configure how users access the chat, using one of n8n's provided interfaces, or your own. You can add authentication.

You must connect either an agent or chain [root node](../../cluster-nodes/root-nodes/).

Workflow execution usage

Every message to the Chat Trigger executes your workflow. This means that one conversation where a user sends 10 messages uses 10 executions from your execution allowance. Check your payment plan for details of your allowance.

This node replaces the Manual Chat Trigger node from version 1.24.0.

### Make Chat Publicly Available

Set whether the chat should be publicly available (turned on) or only available through the manual chat interface (turned off).

Leave this turned off while you're building the workflow. Turn it on when you're ready to activate the workflow and allow users to access the chat.

Choose how users access the chat. Select from:

- **Hosted Chat**: Use n8n's hosted chat interface. Recommended for most users because you can configure the interface using the [node options](#node-options) and don't have to do any other setup.
- **Embedded Chat**: This option requires you to create your own chat interface. You can use n8n's [chat widget](https://www.npmjs.com/package/@n8n/chat) or build your own. Your chat interface must call the webhook URL shown in **Chat URL** in the node.

Choose whether and how to restrict access to the chat. Select from:

- **None**: The chat doesn't use authentication. Anyone can use the chat.
- **Basic Auth**: The chat uses basic authentication.
  - Select or create a **Credential for Basic Auth** with a username and password. All users must use the same username and password.
- **n8n User Auth**: Only users logged in to an n8n account can use the chat.

### Initial Message(s)

This parameter's only available if you're using **Hosted Chat**. Use it to configure the message the n8n chat interface displays when the user arrives on the page.

Available options depend on the chat mode.

### Hosted chat options

#### Allowed Origin (CORS)

Set the origins that can access the chat URL. Enter a comma-separated list of URLs allowed for cross-origin non-preflight requests.

Use `*` (default) to allow all origins.

#### Input Placeholder, Title, and Subtitle

Enter the text for these elements in the chat interface.

#### Load Previous Session

Select whether to load chat messages from a previous chat session.

If you select any option other than **Off**, you must connect the Chat trigger and the Agent you're using to a memory sub-node. The memory connector on the Chat trigger appears when you set **Load Previous Session** to **From Memory**. n8n recommends connecting both the Chat trigger and Agent to the same memory sub-node, as this ensures a single source of truth for both nodes.

Use this option when building a workflow with steps after the agent or chain that's handling the chat. Choose from:

- **When Last Node Finishes**: The Chat Trigger node returns the response code and the data output from the last node executed in the workflow.
- **Using Response Nodes**: The Chat Trigger node responds as defined in a [Respond to Chat](../n8n-nodes-langchain.respondtochat/) node or [Respond to Webhook](../n8n-nodes-base.respondtowebhook/) node. In this response mode, the Chat Trigger will solely show messages as defined in these nodes and not output the data from the last node executed in the workflow.

This mode replaces the 'Using Respond to Webhook Node' mode from version 1.2 of the Chat Trigger node.

- **Streaming response**: Enables real-time data streaming back to the user as the workflow processes. Requires nodes with streaming support in the workflow (for example, the [AI agent](../../cluster-nodes/root-nodes/n8n-nodes-langchain.agent/) node).

#### Require Button Click to Start Chat

Set whether to display a **New Conversation** button on the chat interface (turned on) or not (turned off).

### Embedded chat options

#### Allowed Origin (CORS)

Set the origins that can access the chat URL. Enter a comma-separated list of URLs allowed for cross-origin non-preflight requests.

Use `*` (default) to allow all origins.

#### Load Previous Session

Select whether to load chat messages from a previous chat session.

If you select any option other than **Off**, you must connect the Chat trigger and the Agent you're using to a memory sub-node. The memory connector on the Chat trigger appears when you set **Load Previous Session** to **From Memory**. n8n recommends connecting both the Chat trigger and Agent to the same memory sub-node, as this ensures a single source of truth for both nodes.

Use this option when building a workflow with steps after the agent or chain that's handling the chat. Choose from:

- **When Last Node Finishes**: The Chat Trigger node returns the response code and the data output from the last node executed in the workflow.
- **Using Response Nodes**: The Chat Trigger node responds as defined in a [Respond to Chat](../n8n-nodes-langchain.respondtochat/) node or [Respond to Webhook](../n8n-nodes-base.respondtowebhook/) node. In this response mode, the Chat Trigger will solely show messages as defined in these nodes and not output the data from the last node executed in the workflow.

This mode replaces the 'Using Respond to Webhook Node' mode from version 1.2 of the Chat Trigger node.

- **Streaming response**: Enables real-time data streaming back to the user as the workflow processes. Requires nodes with streaming support enabled.

## Templates and examples

**RAG Starter Template using Simple Vector Stores, Form trigger and OpenAI**

[View template details](https://n8n.io/workflows/5010-rag-starter-template-using-simple-vector-stores-form-trigger-and-openai/)

**Unify multiple triggers into a single workflow**

by Guillaume Duvernay

[View template details](https://n8n.io/workflows/7784-unify-multiple-triggers-into-a-single-workflow/)

**Trigger Outbound Vapi AI Voice Calls From New Jotform Submissions**

[View template details](https://n8n.io/workflows/6695-trigger-outbound-vapi-ai-voice-calls-from-new-jotform-submissions/)

[Browse Chat Trigger integration templates](https://n8n.io/integrations/chat-trigger/), or [search all templates](https://n8n.io/workflows/)

View n8n's [Advanced AI](../../../../advanced-ai/) documentation.

## Set the chat response manually

You need to manually set the chat response when you don't want to directly send the output of an Agent or Chain node to the user. Instead, you want to take the output of an Agent or Chain node and modify it or do something else with it before sending it back to the user.

In a basic workflow, the Agent and Chain nodes output a parameter named either `output` or `text`, and the Chat trigger sends the value of this parameter to the user as the chat response.

If you need to manually create the response sent to the user, you must create a parameter named either `text` or `output`. If you use a different parameter name, the Chat trigger sends the entire object as its response, not just the value.

When you are using a [Respond to Chat](../n8n-nodes-langchain.respondtochat/) node to manually create the response sent to the user, you must set the Chat Trigger response mode to 'Using Response Nodes'.

For common questions or issues and suggested solutions, refer to [Common Issues](common-issues/).

---

## AWS Bedrock Chat Model node

**URL:** llms-txt#aws-bedrock-chat-model-node

**Contents:**
- Node parameters
- Node options
- Proxy limitations
- Templates and examples
- Related resources

The AWS Bedrock Chat Model node allows you use LLM models utilising AWS Bedrock platform.

On this page, you'll find the node parameters for the AWS Bedrock Chat Model node, and links to more resources.

You can find authentication information for this node [here](../../../credentials/aws/).

Parameter resolution in sub-nodes

Sub-nodes behave differently to other nodes when processing multiple items using an expression.

Most nodes, including root nodes, take any number of items as input, process these items, and output the results. You can use expressions to refer to input items, and the node resolves the expression for each item in turn. For example, given an input of five `name` values, the expression `{{ $json.name }}` resolves to each name in turn.

In sub-nodes, the expression always resolves to the first item. For example, given an input of five `name` values, the expression `{{ $json.name }}` always resolves to the first name.

- **Model**: Select the model that generates the completion.

Learn more about available models in the [Amazon Bedrock model documentation](https://docs.aws.amazon.com/bedrock/latest/userguide/models-supported.html).

- **Maximum Number of Tokens**: Enter the maximum number of tokens used, which sets the completion length.
- **Sampling Temperature**: Use this option to control the randomness of the sampling process. A higher temperature creates more diverse sampling, but increases the risk of hallucinations.

This node doesn't support the [`NO_PROXY` environment variable](../../../../../hosting/configuration/environment-variables/deployment/).

## Templates and examples

[Browse AWS Bedrock Chat Model integration templates](https://n8n.io/integrations/aws-bedrock-chat-model/), or [search all templates](https://n8n.io/workflows/)

Refer to [LangChains's AWS Bedrock Chat Model documentation](https://js.langchain.com/docs/integrations/chat/bedrock/) for more information about the service.

View n8n's [Advanced AI](../../../../../advanced-ai/) documentation.

---

## Database structure

**URL:** llms-txt#database-structure

**Contents:**
- Database and query technology
- Tables
  - auth_identity
  - auth_provider_sync_history
  - credentials_entity
  - event_destinations
  - execution_data
  - execution_entity
  - execution_metadata
  - installed_nodes

This page describes the purpose of each table in the n8n database.

## Database and query technology

By default, n8n uses SQLite as the database. If you are using another database the structure will be similar, but the data-types may be different depending on the database.

n8n uses [TypeORM](https://github.com/typeorm/typeorm) for queries and migrations.

To inspect the n8n database, you can use [DBeaver](https://dbeaver.io), which is an open-source universal database tool.

These are the tables n8n creates during setup.

Stores details of external authentication providers when using [SAML](../../../user-management/saml/).

### auth_provider_sync_history

Stores the history of a SAML connection.

### credentials_entity

Stores the [credentials](../../../glossary/#credential-n8n) used to authenticate with integrations.

### event_destinations

Contains the destination configurations for [Log streaming](../../../log-streaming/).

Contains the workflow at time of running, and the execution data.

Stores all saved workflow executions. Workflow settings can affect which executions n8n saves.

### execution_metadata

Stores [Custom executions data](../../../workflows/executions/custom-executions-data/).

Lists the [community nodes](../../../integrations/community-nodes/installation/) installed in your n8n instance.

### installed_packages

Details of npm community nodes packages installed in your n8n instance. [installed_nodes](#installed_nodes) lists each individual node. `installed_packages` lists npm packages, which may contain more than one node.

A log of all database migrations. Read more about [Migrations](https://typeorm.io/docs/advanced-topics/migrations/) in TypeORM's documentation.

Lists the [projects](../../../user-management/rbac/projects/) in your instance.

Describes the relationship between a user and a [project](../../../user-management/rbac/projects/), including the user's [role type](../../../user-management/rbac/role-types/).

Not currently used. For use in future work on custom roles.

Records custom instance settings. These are settings that you can't control using environment variables. They include:

- Whether the instance owner is set up
- Whether the user chose to skip owner and user management setup
- Whether certain types of authentication, including SAML and LDAP, are on
- License key

### shared_credentials

Maps credentials to users.

Maps workflows to users.

All workflow tags created in the n8n instance. This table lists the tags. [workflows_tags](#workflows_tags) records which workflows have which tags.

Store [variables](../../../code/variables/).

Records the active webhooks in your n8n instance's workflows. This isn't just webhooks uses in the Webhook node. It includes all active webhooks used by any trigger node.

Your n8n instance's saved workflows.

Store previous versions of workflows.

### workflow_statistics

Counts workflow IDs and their status.

Maps tags to workflows. [tag_entity](#tag_entity) contains tag details.

## Entity Relationship Diagram (ERD)

---

## optional:

**URL:** llms-txt#optional:

**Contents:**
  - Required permissions
  - TLS
- SQLite

export DB_POSTGRESDB_SSL_CA=$(pwd)/ca.crt
export DB_POSTGRESDB_SSL_REJECT_UNAUTHORIZED=false

CREATE DATABASE n8n-db;
CREATE USER n8n-user WITH PASSWORD 'random-password';
GRANT ALL PRIVILEGES ON DATABASE n8n-db TO n8n-user;
```

You can choose between these configurations:

- Not declaring (default): Connect with `SSL=off`
- Declaring only the CA and unauthorized flag: Connect with `SSL=on` and verify the server's signature
- Declaring `_{CERT,KEY}` and the above: Use the certificate and key for client TLS authentication

This is the default database that gets used if nothing is defined.

The database file is located at: `~/.n8n/database.sqlite`

**Examples:**

Example 1 (unknown):
```unknown
### Required permissions

n8n needs to create and modify the schemas of the tables it uses.

Recommended permissions:
```

---

## Question and Answer Chain node common issues

**URL:** llms-txt#question-and-answer-chain-node-common-issues

**Contents:**
- No prompt specified error
- A Retriever sub-node must be connected error
- Can't produce longer responses

Here are some common errors and issues with the [Question and Answer Chain node](../) and steps to resolve or troubleshoot them.

## No prompt specified error

This error displays when the **Prompt** is empty or invalid.

You might see this in one of two scenarios:

1. When you've set the **Prompt** to **Define below** and have an expression in your **Text** that isn't generating a value.
   - To resolve, enter a valid prompt in the **Text** field.
   - Make sure any expressions reference valid fields and that they resolve to valid input rather than null.
1. When you've set the **Prompt** to **Connected Chat Trigger Node** and the incoming data has null values.
   - To resolve, make sure your input contains a `chatInput` field. Add an [Edit Fields (Set)](../../../../core-nodes/n8n-nodes-base.set/) node to edit an incoming field name to `chatInput`.
   - Remove any null values from the `chatInput` field of the input node.

## A Retriever sub-node must be connected error

This error displays when n8n tries to execute the node without having a Retriever connected.

To resolve this, click the + Retriever button at the bottom of your screen when the node is open, or click the Retriever + connector when the node isn't open. n8n will then open a selection of possible Retrievers to pick from.

## Can't produce longer responses

If you need to generate longer responses than the Question and Answer Chain node produces by default, you can try one or more of the following techniques:

- **Connect a more verbose model**: Some AI models produce more terse results than others. Swapping your model for one with a larger context window and more verbose output can increase the word length of your responses.
- **Increase the maximum number of tokens**: Many model nodes (for example the [OpenAI Chat Model](../../../sub-nodes/n8n-nodes-langchain.lmchatopenai/#maximum-number-of-tokens)) include a **Maximum Number of Tokens** option. You can set this to increase the maximum number of tokens the model can use to produce a response.
- **Build larger responses in stages**: For more detailed answers, you may want to construct replies in stages using a variety of AI nodes. You can use AI split up a single question into multiple prompts and create responses for each. You can then compose a final reply by combining the responses again. Though the details are different, you can find a good example of the general idea in this [template for writing a WordPress post with AI](https://n8n.io/workflows/2187-write-a-wordpress-post-with-ai-starting-from-a-few-keywords/).

---

## Workflow-level executions list

**URL:** llms-txt#workflow-level-executions-list

**Contents:**
- View executions for a single workflow
- Filter executions
- Retry failed workflows

The **Executions** list in a workflow shows all executions for that workflow.

When you delete a workflow, n8n deletes its execution history as well. This means you can't view executions for deleted workflows.

Execution history and workflow history

Don't confuse the execution list with [Workflow history](../../history/).

Executions are workflow runs. With the executions list, you can see previous runs of the current version of the workflow. You can copy previous executions into the editor to [Debug and re-run past executions](../debug/) in your current workflow.

Workflow history is previous versions of the workflow: for example, a version with a different node, or different parameters set.

## View executions for a single workflow

In the workflow, select the **Executions** tab in the top menu. You can preview all executions of that workflow.

You can filter the executions list.

1. In your workflow, select **Executions**.
1. Select **Filters**.
1. Enter your filters. You can filter by:
   - **Status**: choose from **Failed**, **Running**, **Success**, or **Waiting**.

- **Execution start**: see executions that started in the given time.

- **Saved custom data**: this is data you create within the workflow using the Code node. Enter the key and value to filter. Refer to [Custom executions data](../custom-executions-data/) for information on adding custom data.

Custom executions data is available on:

- Cloud: Pro, Enterprise
     - Self-Hosted: Enterprise, registered Community

## Retry failed workflows

If your workflow execution fails, you can retry the execution. To retry a failed workflow:

1. Open the **Executions** list.
1. For the workflow execution you want to retry, select **Refresh** .
1. Select either of the following options to retry the execution:
   - **Retry with currently saved workflow**: Once you make changes to your workflow, you can select this option to execute the workflow with the previous execution data.
   - **Retry with original workflow**: If you want to retry the execution without making changes to your workflow, you can select this option to retry the execution with the previous execution data.

---

## Microsoft OneDrive Trigger node

**URL:** llms-txt#microsoft-onedrive-trigger-node

**Contents:**
- Events
- Related resources

Use the Microsoft OneDrive Trigger node to respond to events in [Microsoft OneDrive](https://www.microsoft.com/en-us/microsoft-365/onedrive/online-cloud-storage) and integrate Microsoft OneDrive with other applications. n8n has built-in support for file and folder events in OneDrive.

On this page, you'll find a list of events the Microsoft OneDrive Trigger node can respond to and links to more resources.

You can find authentication information for this node [here](../../credentials/microsoft/).

Examples and templates

For usage examples and templates to help you get started, refer to n8n's [Microsoft OneDrive integrations](https://n8n.io/integrations/microsoft-onedrive-trigger/) page.

- On File Created
- On File Updated
- On Folder Created
- On Folder Updates

n8n provides an app node for Microsoft OneDrive. You can find the node docs [here](../../app-nodes/n8n-nodes-base.microsoftonedrive/).

View [example workflows and related content](https://n8n.io/integrations/microsoft-onedrive-trigger/) on n8n's website.

Refer to [Microsoft's OneDrive API documentation](https://learn.microsoft.com/en-us/onedrive/developer/rest-api/) for more information about the service.

---

## 6. Notifying the Team

**URL:** llms-txt#6.-notifying-the-team

**Contents:**
- What's next?

In this step of the workflow, you will learn how to send messages to a Discord channel using the [Discord node](../../../../integrations/builtin/app-nodes/n8n-nodes-base.discord/). After this step, your workflow should look like this:

[View workflow file](/_workflows//courses/level-one/chapter-5/chapter-5.6.json)

Now that you have a calculated summary of the booked orders, you need to notify Nathan's team in their Discord channel. For this workflow, you will send messages to the [n8n server](https://discord.gg/G98WXzsjky) on Discord.

Before you begin the steps below, use the link above to connect to the n8n server on Discord. Be sure you can access the `#course-level-1` channel.

Communication app nodes

You can replace the Discord node with another communication app. For example, n8n also has nodes for [Slack](../../../../integrations/builtin/app-nodes/n8n-nodes-base.slack/) and [Mattermost](../../../../integrations/builtin/app-nodes/n8n-nodes-base.mattermost/).

In your workflow, add a Discord node connected to the Code node.

When you search for the Discord node, look for **Message Actions** and select **Send a message** to add the node.

In the Discord node window, configure these parameters:

- **Connection Type**: Select **Webhook**.
- **Credential for Discord Webhook**: Select **- Create New Credential -**.
  - Copy the **Webhook URL** from the email you received when you signed up for this course and paste it into the **Webhook URL** field of the credentials.
  - Select **Save** and then close the credentials dialog.
- **Operation**: Select **Send a Message**.
- **Message**:
  - Select the **Expression** tab on the right side of the Message field.

- Copy the text below and paste it into the **Expression** window, or construct it manually using the **Expression Editor**.

Now select **Execute step** in the Discord node. If all works well, you should see this output in n8n:

*Discord node output*

And your message should appear in the Discord channel #course-level-1:

**Nathan 🙋**: Incredible, you've saved me hours of tedious work already! Now I can execute this workflow when I need it. I just need to remember to run it every Monday morning at 9 AM.

**You 👩‍🔧**: Don't worry about that, you can actually schedule the workflow to run on a specific day, time, or interval. I'll set this up in the next step.

**Examples:**

Example 1 (unknown):
```unknown
This week we've {{$json["totalBooked"]}} booked orders with a total value of {{$json["bookedSum"]}}. My Unique ID: {{ $('HTTP Request').params["headerParameters"]["parameters"][0]["value"] }}
```

---

## Rocket.Chat credentials

**URL:** llms-txt#rocket.chat-credentials

**Contents:**
- Prerequisites
- Supported authentication methods
- Related resources
- Using API access token

You can use these credentials to authenticate the following nodes:

- [Rocket.Chat](../../app-nodes/n8n-nodes-base.rocketchat/)

- Create a [Rocket.Chat](https://rocket.chat/) account.
- Your account must have the `create-personal-access-tokens` permission to generate personal access tokens.

## Supported authentication methods

Refer to [Rocket.Chat's API documentation](https://developer.rocket.chat/reference/api/rest-api) for more information about the service.

## Using API access token

To configure this credential, you'll need:

- Your **User ID**: Displayed when you generate an access token.
- An **Auth Key**: Your personal access token. To generate an access token, go to your **avatar > Account > Personal Access Tokens**. Copy the token and add it as the n8n **Auth Key**.
- Your Rocket.Chat **Domain**: Also known as your default URL or workspace URL.

Refer to [Personal Access Tokens](https://docs.rocket.chat/docs/manage-your-account-settings#personal-access-tokens) for more information.

---

## Simple Memory node

**URL:** llms-txt#simple-memory-node

**Contents:**
- Node parameters
- Templates and examples
- Related resources
- Common issues

Use the Simple Memory node to [persist](../../../../../glossary/#ai-memory) chat history in your workflow.

On this page, you'll find a list of operations the Simple Memory node supports, and links to more resources.

Don't use this node if running n8n in queue mode

If your n8n instance uses [queue mode](../../../../../hosting/scaling/queue-mode/), this node doesn't work in an active production workflow. This is because n8n can't guarantee that every call to Simple Memory will go to the same worker.

Parameter resolution in sub-nodes

Sub-nodes behave differently to other nodes when processing multiple items using an expression.

Most nodes, including root nodes, take any number of items as input, process these items, and output the results. You can use expressions to refer to input items, and the node resolves the expression for each item in turn. For example, given an input of five `name` values, the expression `{{ $json.name }}` resolves to each name in turn.

In sub-nodes, the expression always resolves to the first item. For example, given an input of five `name` values, the expression `{{ $json.name }}` always resolves to the first name.

Configure these parameters to configure the node:

- **Session Key**: Enter the key to use to store the memory in the workflow data.
- **Context Window Length**: Enter the number of previous interactions to consider for context.

## Templates and examples

**Chat with GitHub API Documentation: RAG-Powered Chatbot with Pinecone & OpenAI**

[View template details](https://n8n.io/workflows/2705-chat-with-github-api-documentation-rag-powered-chatbot-with-pinecone-and-openai/)

**🤖 Create a Documentation Expert Bot with RAG, Gemini, and Supabase**

[View template details](https://n8n.io/workflows/5993-create-a-documentation-expert-bot-with-rag-gemini-and-supabase/)

**🤖 Build a Documentation Expert Chatbot with Gemini RAG Pipeline**

[View template details](https://n8n.io/workflows/6137-build-a-documentation-expert-chatbot-with-gemini-rag-pipeline/)

[Browse Simple Memory node documentation integration templates](https://n8n.io/integrations/window-buffer-memory/), or [search all templates](https://n8n.io/workflows/)

Refer to [LangChain's Buffer Window Memory documentation](https://v03.api.js.langchain.com/classes/langchain.memory.BufferWindowMemory.html) for more information about the service.

View n8n's [Advanced AI](../../../../../advanced-ai/) documentation.

For common questions or issues and suggested solutions, refer to [Common issues](common-issues/).

---

## Webex by Cisco Trigger node

**URL:** llms-txt#webex-by-cisco-trigger-node

[Webex by Cisco](https://webex.com/) is a web conferencing and videoconferencing application.

You can find authentication information for this node [here](../../credentials/ciscowebex/).

Examples and templates

For usage examples and templates to help you get started, refer to n8n's [Webex by Cisco Trigger integrations](https://n8n.io/integrations/webex-by-cisco-trigger/) page.

---

## QuickChart node

**URL:** llms-txt#quickchart-node

**Contents:**
- Operations
- Templates and examples
- Related resources

Use the QuickChart node to automate work in QuickChart, and integrate QuickChart with other applications. n8n has built-in support for a wide range of QuickChart chart types, including bar, doughnut, line, pie, and polar charts.

On this page, you'll find a list of operations the QuickChart node supports and links to more resources.

This node can be used as an AI tool

This node can be used to enhance the capabilities of an AI agent. When used in this way, many parameters can be set automatically, or with information directed by AI - find out more in the [AI tool parameters documentation](../../../../advanced-ai/examples/using-the-fromai-function/).

Create a chart by selecting the chart type:

- Chart Type
  - Bar Chart
  - Doughnut Chart
  - Line Chart
  - Pie Chart
  - Polar Chart

## Templates and examples

**AI Agent with charts capabilities using OpenAI Structured Output and Quickchart**

[View template details](https://n8n.io/workflows/2400-ai-agent-with-charts-capabilities-using-openai-structured-output-and-quickchart/)

**Visualize your SQL Agent queries with OpenAI and Quickchart.io**

[View template details](https://n8n.io/workflows/2559-visualize-your-sql-agent-queries-with-openai-and-quickchartio/)

**✨📊Multi-AI Agent Chatbot for Postgres/Supabase DB and QuickCharts + Tool Router**

[View template details](https://n8n.io/workflows/3090-multi-ai-agent-chatbot-for-postgressupabase-db-and-quickcharts-tool-router/)

[Browse QuickChart integration templates](https://n8n.io/integrations/quickchart/), or [search all templates](https://n8n.io/workflows/)

Refer to [QuickChart's API documentation](https://quickchart.io/documentation/) for more information about the service.

---

## License Key

**URL:** llms-txt#license-key

**Contents:**
- Add a license key using the UI
- Add a license key using an environment variables
- Allowlist the license server IP addresses

To enable certain licensed features, you must first activate your license. You can do this either through the UI or by setting environment variables.

## Add a license key using the UI

In your n8n instance:

1. Log in as **Admin** or **Owner**.
1. Select **Settings** > **Usage and plan**.
1. Select **Enter activation key**.
1. Paste in your license key.
1. Select **Activate**.

## Add a license key using an environment variables

In your n8n configuration, set `N8N_LICENSE_ACTIVATION_KEY` to your license key. If the instance already has an activated license, this variable will have no effect.

Refer to [Environment variables](../hosting/configuration/configuration-methods/) to learn more about configuring n8n.

## Allowlist the license server IP addresses

n8n uses Cloudflare to host the license server. As the specific IP addresses can change, you need to allowlist the [full range of Cloudflare IP addresses](https://www.cloudflare.com/ips/) to ensure n8n can always reach the license server.

---

## Convenience methods

**URL:** llms-txt#convenience-methods

n8n provides these methods to make it easier to perform common tasks in [expressions](../../../glossary/#expression-n8n).

You can use Python in the Code node. It isn't available in expressions.

| Method                                                        | Description                                                                                                                                                                                                                                                                                                                                                                                 | Available in Code node? |
| ------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ----------------------- |
| `$evaluateExpression(expression: string, itemIndex?: number)` | Evaluates a string as an expression. If you don't provide `itemIndex`, n8n uses the data from item 0 in the Code node.                                                                                                                                                                                                                                                                      |                         |
| `$ifEmpty(value, defaultValue)`                               | The `$ifEmpty()` function takes two parameters, tests the first to check if it's empty, then returns either the parameter (if not empty) or the second parameter (if the first is empty). The first parameter is empty if it's: - `undefined` - `null` - An empty string `''` - An array where `value.length` returns `false` - An object where `Object.keys(value).length` returns `false` |                         |
| `$if()`                                                       | The `$if()` function takes three parameters: a condition, the value to return if true, and the value to return if false.                                                                                                                                                                                                                                                                    |                         |
| `$max()`                                                      | Returns the highest of the provided numbers.                                                                                                                                                                                                                                                                                                                                                |                         |
| `$min()`                                                      | Returns the lowest of the provided numbers.                                                                                                                                                                                                                                                                                                                                                 |                         |

| Method                                                        | Description                                                                                                                                                                                                                                                                                                                                                                                 |
| ------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| `_evaluateExpression(expression: string, itemIndex?: number)` | Evaluates a string as an expression. If you don't provide `itemIndex`, n8n uses the data from item 0 in the Code node.                                                                                                                                                                                                                                                                      |
| `_ifEmpty(value, defaultValue)`                               | The `_ifEmpty()` function takes two parameters, tests the first to check if it's empty, then returns either the parameter (if not empty) or the second parameter (if the first is empty). The first parameter is empty if it's: - `undefined` - `null` - An empty string `''` - An array where `value.length` returns `false` - An object where `Object.keys(value).length` returns `false` |

---

## Using source control and environments

**URL:** llms-txt#using-source-control-and-environments

- Available on Enterprise.

- You must be an n8n instance owner or instance admin to enable and configure source control.

- Instance owners and instance admins can push changes to and pull changes from the connected repository.

- Project admins can push changes to the connected repository. They can't pull changes from the repository.

- [Push and pull](push-pull/): Send work to Git, and fetch work from Git to your instance. Understand what gets committed, and how n8n handles merge conflicts.

- [Copy work between environments](copy-work/): How to copy work between different n8n instances.

---

## Baserow node

**URL:** llms-txt#baserow-node

**Contents:**
- Operations
- Templates and examples

Use the Baserow node to automate work in Baserow, and integrate Baserow with other applications. n8n has built-in support for a wide range of Baserow features, including creating, getting, retrieving, and updating rows.

On this page, you'll find a list of operations the Baserow node supports and links to more resources.

Refer to [Baserow credentials](../../credentials/baserow/) for guidance on setting up authentication.

This node can be used as an AI tool

This node can be used to enhance the capabilities of an AI agent. When used in this way, many parameters can be set automatically, or with information directed by AI - find out more in the [AI tool parameters documentation](../../../../advanced-ai/examples/using-the-fromai-function/).

- Row
  - Create a row
  - Delete a row
  - Retrieve a row
  - Retrieve all rows
  - Update a row

## Templates and examples

**All-in-One Telegram/Baserow AI Assistant 🤖🧠 Voice/Photo/Save Notes/Long Term Mem**

[View template details](https://n8n.io/workflows/2986-all-in-one-telegrambaserow-ai-assistant-voicephotosave-noteslong-term-mem/)

**User Enablement Demo**

[View template details](https://n8n.io/workflows/1500-user-enablement-demo/)

**Create AI Videos with OpenAI Scripts, Leonardo Images & HeyGen Avatars**

[View template details](https://n8n.io/workflows/4107-create-ai-videos-with-openai-scripts-leonardo-images-and-heygen-avatars/)

[Browse Baserow integration templates](https://n8n.io/integrations/baserow/), or [search all templates](https://n8n.io/workflows/)

---

## Perplexity credentials

**URL:** llms-txt#perplexity-credentials

**Contents:**
- Supported authentication methods
- Related resources
- Using API key

You can use these credentials to authenticate the following nodes:

- [Perplexity](../../app-nodes/n8n-nodes-langchain.perplexity/)

## Supported authentication methods

Refer to [Perplexity's API documentation](https://docs.perplexity.ai/api-reference/) for more information about the service.

To configure this credential, you'll need a [Perplexity account](https://www.perplexity.ai/account) and:

- **a Perplexity API key**: You can find out how to create a Perplexity API key in the [Perplexity API getting started guide](https://docs.perplexity.ai/guides/getting-started).

Refer to [Perplexity's API documentation](https://docs.perplexity.ai/) for more information about authenticating to the service.

---

## Integrations

**URL:** llms-txt#integrations

**Contents:**
- Built-in nodes
- Community nodes
- Credential-only nodes and custom operations
- Generic integrations
- Where to go next

n8n calls integrations nodes.

Nodes are the building blocks of workflows in n8n. They're an entry point for retrieving data, a function to process data, or an exit for sending data. The data process includes filtering, recomposing, and changing data. There can be one or several nodes for your API, service or app. You can connect multiple nodes, which allows you to create complex workflows.

n8n includes a collection of built-in integrations. Refer to [Built-in nodes](builtin/node-types/) for documentation on all n8n's built-in nodes.

As well as using the built-in nodes, you can also install community-built nodes. Refer to [Community nodes](community-nodes/installation/) for more information.

## Credential-only nodes and custom operations

One of the most complex parts of setting up [API](../glossary/#api) calls is managing authentication. n8n provides [credentials](../glossary/#credential-n8n) support for operations and services beyond those supported by built-in nodes.

- Custom operations for existing nodes: n8n supplies hundreds of nodes to create workflows that link multiple products. However, some nodes don't include all the possible operations supported by a product's API. You can work around this by making a custom API call using the [HTTP Request](builtin/core-nodes/n8n-nodes-base.httprequest/) node.
- Credential-only nodes: n8n includes credential-only nodes. These are integrations where n8n supports setting up credentials for use in the HTTP Request node, but doesn't provide a standalone node. You can find a credential-only node in the nodes panel, as you would for any other integration.

Refer to [Custom operations](custom-operations/) for more information.

## Generic integrations

If you need to connect to a service where n8n doesn't have a node, or a credential-only node, you can still use the [HTTP Request](builtin/core-nodes/n8n-nodes-base.httprequest/) node. Refer to the node page for details on how to set up authentication and create your API call.

- If you want to create your own node, head over to the [Creating Nodes](creating-nodes/overview/) section.
- Check out [Community nodes](community-nodes/usage/) to learn about installing and managing community-built nodes.
- If you'd like to learn more about the different nodes in n8n, their functionalities and example usage, check out n8n's node libraries: [Core nodes](builtin/core-nodes/), [Actions](builtin/app-nodes/), and [Triggers](builtin/trigger-nodes/).
- If you'd like to learn how to add the credentials for the different nodes, head over to the [Credentials](builtin/credentials/) section.

---

## Webhook node

**URL:** llms-txt#webhook-node

**Contents:**
- Workflow development process
- Node parameters
  - Webhook URLs
  - HTTP Method
  - Path
  - Supported authentication methods
  - Respond
  - Response Code
  - Response Data
- Node options

Use the Webhook node to create [webhooks](https://en.wikipedia.org/wiki/Webhook), which can receive data from apps and services when an event occurs. It's a trigger node, which means it can start an n8n workflow. This allows services to connect to n8n and run a workflow.

You can use the Webhook node as a trigger for a workflow when you want to receive data and run a workflow based on the data. The Webhook node also supports returning the data generated at the end of a workflow. This makes it useful for building a workflow to process data and return the results, like an API endpoint.

The webhook allows you to trigger workflows from services that don't have a dedicated app trigger node.

## Workflow development process

n8n provides different **Webhook URL**s for testing and production. The testing URL includes an option to **Listen for test event**. Refer to [Workflow development](workflow-development/) for more information on building, testing, and shifting your Webhook node to production.

Use these parameters to configure your node.

The Webhook node has two **Webhook URLs**: test and production. n8n displays the URLs at the top of the node panel.

Select **Test URL** or **Production URL** to toggle which URL n8n displays.

Sample Webhook URLs in the Webhook node's Parameters tab

- **Test**: n8n registers a test webhook when you select **Listen for Test Event** or **Execute workflow**, if the workflow isn't active. When you call the webhook URL, n8n displays the data in the workflow.
- **Production**: n8n registers a production webhook when you activate the workflow. When using the production URL, n8n doesn't display the data in the workflow. You can still view workflow data for a production execution: select the **Executions** tab in the workflow, then select the workflow execution you want to view.

The Webhook node supports standard [HTTP Request Methods](https://developer.mozilla.org/en-US/docs/Web/HTTP/Methods):

The webhook maximum payload size is 16MB. If you're self-hosting n8n, you can change this using the [endpoint environment variable](../../../../hosting/configuration/environment-variables/endpoints/) `N8N_PAYLOAD_SIZE_MAX`.

By default, this field contains a randomly generated webhook URL path, to avoid conflicts with other webhook nodes.

You can manually specify a URL path, including adding route parameters. For example, you may need to do this if you use n8n to prototype an API and want consistent endpoint URLs.

The **Path** field can take the following formats:

- `/:variable`
- `/path/:variable`
- `/:variable/path`
- `/:variable1/path/:variable2`
- `/:variable1/:variable2`

### Supported authentication methods

You can require authentication for any service calling your webhook URL. Choose from these authentication methods:

- Basic auth
- Header auth
- JWT auth
- None

Refer to [Webhook credentials](../../credentials/webhook/) for more information on setting up each credential type.

- **Immediately**: The Webhook node returns the response code and the message **Workflow got started**.
- **When Last Node Finishes**: The Webhook node returns the response code and the data output from the last node executed in the workflow.
- **Using 'Respond to Webhook' Node**: The Webhook node responds as defined in the [Respond to Webhook](../n8n-nodes-base.respondtowebhook/) node.
- **Streaming response**: Enables real-time data streaming back to the user as the workflow processes. Requires nodes with streaming support in the workflow (for example, the [AI agent](../../cluster-nodes/root-nodes/n8n-nodes-langchain.agent/) node).

Customize the [HTTP response code](https://developer.mozilla.org/en-US/docs/Web/HTTP/Status) that the Webhook node returns upon successful execution. Select from common response codes or create a custom code.

Choose what data to include in the response body:

- **All Entries**: The Webhook returns all the entries of the last node in an array.
- **First Entry JSON**: The Webhook returns the JSON data of the first entry of the last node in a JSON object.
- **First Entry Binary**: The Webhook returns the binary data of the first entry of the last node in a binary file.
- **No Response Body**: The Webhook returns without a body.

Applies only to **Respond > When Last Node Finishes**.

Select **Add Option** to view more configuration options. The available options depend on your node parameters. Refer to the table for option availability.

- **Allowed Origins (CORS)**: Set the permitted cross-origin domains. Enter a comma-separated list of URLs allowed for cross-origin non-preflight requests. Use `*` (default) to allow all origins.
- **Binary Property**: Enabling this setting allows the Webhook node to receive binary data, such as an image or audio file. Enter the name of the binary property to write the data of the received file to.
- **Ignore Bots**: Ignore requests from bots like link previewers and web crawlers.
- **IP(s) Whitelist**: Enable this to limit who (or what) can invoke a Webhook trigger URL. Enter a comma-separated list of allowed IP addresses. Access from IP addresses outside the whitelist throws a 403 error. If left blank, all IP addresses can invoke the webhook trigger URL.
- **No Response Body**: Enable this to prevent n8n sending a body with the response.
- **Raw Body**: Specify that the Webhook node will receive data in a raw format, such as JSON or XML.
- **Response Content-Type**: Choose the format for the webhook body.
- **Response Data**: Send custom data with the response.
- **Response Headers**: Send extra headers in the Webhook response. Refer to [MDN Web Docs | Response header](https://developer.mozilla.org/en-US/docs/Glossary/Response_header) to learn more about response headers.
- **Property Name**: by default, n8n returns all available data. You can choose to return a specific JSON key, so that n8n returns the value.

| Option                 | Required node configuration                                              |
| ---------------------- | ------------------------------------------------------------------------ |
| Allowed Origins (CORS) | Any                                                                      |
| Binary Property        | Either: HTTP Method > POST HTTP Method > PATCH HTTP Method > PUT         |
| Ignore Bots            | Any                                                                      |
| IP(s) Whitelist        | Any                                                                      |
| Property Name          | Both: Respond > When Last Node Finishes Response Data > First Entry JSON |
| No Response Body       | Respond > Immediately                                                    |
| Raw Body               | Any                                                                      |
| Response Code          | Any except Respond > Using 'Respond to Webhook' Node                     |
| Response Content-Type  | Both: Respond > When Last Node Finishes Response Data > First Entry JSON |
| Response Data          | Respond > Immediately                                                    |
| Response Headers       | Any                                                                      |

## How n8n secures HTML responses

Starting with [n8n version 1.103.0](../../../../release-notes/#n8n11030), n8n automatically wraps HTML responses to webhooks in `<iframe>` tags. This is a security mechanism to protect the instance users.

This has the following implications:

- HTML renders in a sandboxed iframe instead of directly in the parent document.
- JavaScript code that attempts to access the top-level window or local storage will fail.
- Authentication headers aren't available in the sandboxed iframe (for example, basic auth). You need to use an alternative approach, like embedding a short-lived access token within the HTML.
- Relative URLs (for example, `<form action="/">`) won't work. Use absolute URLs instead.

## Templates and examples

**📚 Auto-generate documentation for n8n workflows with GPT and Docsify**

[View template details](https://n8n.io/workflows/2669-auto-generate-documentation-for-n8n-workflows-with-gpt-and-docsify/)

**Automate Customer Support with Mintlify Documentation & Zendesk AI Agent**

[View template details](https://n8n.io/workflows/5046-automate-customer-support-with-mintlify-documentation-and-zendesk-ai-agent/)

**Transform Cloud Documentation into Security Baselines with OpenAI and GDrive**

by Raphael De Carvalho Florencio

[View template details](https://n8n.io/workflows/7529-transform-cloud-documentation-into-security-baselines-with-openai-and-gdrive/)

[Browse Webhook node documentation integration templates](https://n8n.io/integrations/webhook/), or [search all templates](https://n8n.io/workflows/)

For common questions or issues and suggested solutions, refer to [Common issues](common-issues/).

---

## Returns all items the node "IF" outputs (index: 0 which is Output "true" of its most recent run)

**URL:** llms-txt#returns-all-items-the-node-"if"-outputs-(index:-0-which-is-output-"true"-of-its-most-recent-run)

allItems = _("IF").all();

---

## Netscaler ADC node

**URL:** llms-txt#netscaler-adc-node

**Contents:**
- Operations
- Templates and examples
- Related resources
- What to do if your operation isn't supported

Use the Netscaler ADC node to automate work in Netscaler ADC, and integrate Netscaler ADC with other applications. n8n has built-in support for a wide range of Netscaler ADC features, including creating and installing certificates and files.

On this page, you'll find a list of operations the Netscaler ADC node supports and links to more resources.

Refer to [Netscaler ADC credentials](../../credentials/netscaleradc/) for guidance on setting up authentication.

- Certificate
  - Create
  - Install
- File
  - Delete
  - Download
  - Upload

## Templates and examples

[Browse Netscaler ADC integration templates](https://n8n.io/integrations/netscaler-adc/), or [search all templates](https://n8n.io/workflows/)

Refer to [Netscaler ADC's documentation](https://docs.citrix.com/en-us/citrix-adc/current-release/) for more information about the service.

## What to do if your operation isn't supported

If this node doesn't support the operation you want to do, you can use the [HTTP Request node](../../core-nodes/n8n-nodes-base.httprequest/) to call the service's API.

You can use the credential you created for this service in the HTTP Request node:

1. In the HTTP Request node, select **Authentication** > **Predefined Credential Type**.
1. Select the service you want to connect to.
1. Select your credential.

Refer to [Custom API operations](../../../custom-operations/) for more information.

---

## QuickBooks credentials

**URL:** llms-txt#quickbooks-credentials

**Contents:**
- Prerequisites
- Supported authentication methods
- Related resources
- Using OAuth2

You can use these credentials to authenticate the following nodes:

- [QuickBooks](../../app-nodes/n8n-nodes-base.quickbooks/)

Create an [Intuit developer](https://developer.intuit.com/) account.

## Supported authentication methods

Refer to [Intuit's API documentation](https://developer.intuit.com/app/developer/qbo/docs/develop) for more information about the service.

To configure this credential, you'll need:

- A **Client ID**: Generated when you create an app.
- A **Client Secret**: Generated when you create an app.
- An **Environment**: Select whether this credential should access your **Production** or **Sandbox** environment.

To generate your **Client ID** and **Client Secret**, [create an app](https://developer.intuit.com/app/developer/qbo/docs/get-started/start-developing-your-app#create-an-app).

Use these settings when creating your app:

- Select appropriate scopes for your app. Refer to [Learn about scopes](https://developer.intuit.com/app/developer/qbo/docs/learn/scopes) for more information.
- Enter the **OAuth Redirect URL** from n8n as a **Redirect URI** in the app's **Development > Keys & OAuth** section.
- Copy the **Client ID** and **Client Secret** from the app's **Development > Keys & OAuth** section to enter in n8n. Refer to [Get the Client ID and Client Secret for your app](https://developer.intuit.com/app/developer/qbo/docs/get-started/get-client-id-and-client-secret) for more information.

Refer to Intuit's [Set up OAuth 2.0 documentation](https://developer.intuit.com/app/developer/qbo/docs/develop/authentication-and-authorization/oauth-2.0) for more information on the entire process.

Environment selection

If you're creating a new app from scratch, start with the **Sandbox** environment. Production apps need to fulfill all Intuit's requirements. Refer to Intuit's [Publish your app documentation](https://developer.intuit.com/app/developer/qbo/docs/go-live/publish-app) for more information.

---

## Onfleet node

**URL:** llms-txt#onfleet-node

**Contents:**
- Operations
- Templates and examples

Use the Onfleet node to automate work in Onfleet, and integrate Onfleet with other applications. n8n has built-in support for a wide range of Onfleet features, including creating and deleting tasks in Onfleet as well as retrieving organizations' details.

On this page, you'll find a list of operations the Onfleet node supports and links to more resources.

Refer to [Onfleet credentials](../../credentials/onfleet/) for guidance on setting up authentication.

- Admin
  - Create a new Onfleet admin
  - Delete an Onfleet admin
  - Get all Onfleet admins
  - Update an Onfleet admin
- Container
  - Add task at index (or append)
  - Get container information
  - Fully replace a container's tasks
- Destination
  - Create a new destination
  - Get a specific destination
- Hub
  - Create a new Onfleet hub
  - Get all Onfleet hubs
  - Update an Onfleet hub
- Organization
  - Retrieve your own organization's details
  - Retrieve the details of an organization with which you are connected
- Recipient
  - Create a new Onfleet recipient
  - Get a specific Onfleet recipient
  - Update an Onfleet recipient
- Task
  - Create a new Onfleet task
  - Clone an Onfleet task
  - Force-complete a started Onfleet task
  - Delete an Onfleet task
  - Get all Onfleet tasks
  - Get a specific Onfleet task
  - Update an Onfleet task
- Team
  - Automatically dispatch tasks assigned to a team to on-duty drivers
  - Create a new Onfleet team
  - Delete an Onfleet team
  - Get a specific Onfleet team
  - Get all Onfleet teams
  - Get estimated times for upcoming tasks for a team, returns a selected driver
  - Update an Onfleet team
- Worker
  - Create a new Onfleet worker
  - Delete an Onfleet worker
  - Get a specific Onfleet worker
  - Get all Onfleet workers
  - Get a specific Onfleet worker schedule
  - Update an Onfleet worker

## Templates and examples

**Send a Whatsapp message via Twilio when a certain Onfleet event happens**

[View template details](https://n8n.io/workflows/1525-send-a-whatsapp-message-via-twilio-when-a-certain-onfleet-event-happens/)

**Create a QuickBooks invoice on a new Onfleet Task creation**

[View template details](https://n8n.io/workflows/1546-create-a-quickbooks-invoice-on-a-new-onfleet-task-creation/)

**Send a Discord message when a certain Onfleet event happens**

[View template details](https://n8n.io/workflows/1528-send-a-discord-message-when-a-certain-onfleet-event-happens/)

[Browse Onfleet integration templates](https://n8n.io/integrations/onfleet/), or [search all templates](https://n8n.io/workflows/)

---

## Google Slides node

**URL:** llms-txt#google-slides-node

**Contents:**
- Operations
- Templates and examples
- What to do if your operation isn't supported

Use the Google Slides node to automate work in Google Slides, and integrate Google Slides with other applications. n8n has built-in support for a wide range of Google Slides features, including creating presentations, and getting pages.

On this page, you'll find a list of operations the Google Slides node supports and links to more resources.

Refer to [Google credentials](../../credentials/google/) for guidance on setting up authentication.

This node can be used as an AI tool

This node can be used to enhance the capabilities of an AI agent. When used in this way, many parameters can be set automatically, or with information directed by AI - find out more in the [AI tool parameters documentation](../../../../advanced-ai/examples/using-the-fromai-function/).

- Page
  - Get a page
  - Get a thumbnail
- Presentation
  - Create a presentation
  - Get a presentation
  - Get presentation slides
  - Replace text in a presentation

## Templates and examples

**AI-Powered Post-Sales Call Automated Proposal Generator**

[View template details](https://n8n.io/workflows/4359-ai-powered-post-sales-call-automated-proposal-generator/)

**Dynamically replace images in Google Slides via API**

[View template details](https://n8n.io/workflows/2244-dynamically-replace-images-in-google-slides-via-api/)

**Get all the slides from a presentation and get thumbnails of pages**

[View template details](https://n8n.io/workflows/1035-get-all-the-slides-from-a-presentation-and-get-thumbnails-of-pages/)

[Browse Google Slides integration templates](https://n8n.io/integrations/google-slides/), or [search all templates](https://n8n.io/workflows/)

## What to do if your operation isn't supported

If this node doesn't support the operation you want to do, you can use the [HTTP Request node](../../core-nodes/n8n-nodes-base.httprequest/) to call the service's API.

You can use the credential you created for this service in the HTTP Request node:

1. In the HTTP Request node, select **Authentication** > **Predefined Credential Type**.
1. Select the service you want to connect to.
1. Select your credential.

Refer to [Custom API operations](../../../custom-operations/) for more information.

---

## MySQL credentials

**URL:** llms-txt#mysql-credentials

**Contents:**
- Prerequisites
- Supported authentication methods
- Related resources
- Using database connection

You can use these credentials to authenticate the following nodes:

- [MySQL](../../app-nodes/n8n-nodes-base.mysql/)
- [Agent](../../cluster-nodes/root-nodes/n8n-nodes-langchain.agent/)

The Agent node doesn't support SSH tunnels.

Create a user account on a [MySQL](https://www.mysql.com/) server database.

## Supported authentication methods

- Database connection

Refer to [MySQL's documentation](https://dev.mysql.com/doc/refman/8.3/en/) for more information about the service.

## Using database connection

To configure this credential, you'll need:

- The server **Host**: The database's host name or IP address.
- The **Database** name.
- A **User** name.
- A **Password** for that user.
- The **Port** number used by the MySQL server.
- **Connect Timeout**: The number of milliseconds during the initial database connection before a timeout occurs.
- **SSL**: If your database is using SSL, turn this on and add details for the SSL certificate.
- **SSH Tunnel**: Choose whether to connect over an SSH tunnel. An SSH tunnel lets un-encrypted traffic pass over an encrypted connection and enables authorized remote access to servers protected from outside connections by a firewall.

To set up your database connection credential:

1. Enter your database's hostname as the **Host** in your n8n credential. Run this query to confirm the hostname:

1. Enter your database's name as the **Database** in your n8n credential. Run this query to confirm the database name:

1. Enter the username of a **User** in the database. This user should have appropriate permissions for whatever actions you want n8n to perform.

1. Enter the **Password** for that user.

1. Enter the **Port** number used by the MySQL server (default is `3306`). Run this query to confirm the port number:

1. Enter the **Connect Timeout** you'd like the node to use. The Connect Timeout is the number of milliseconds during the initial database connection the node should wait before timing out. n8n defaults to `10000` which is the default used by MySQL of 10 seconds. If you want to match your database's `connect_timeout`, run this query to get it, then multiply by 1000 before entering it in n8n:

1. If your database uses SSL and you'd like to use **SSL** for the connection, turn this option on in the credential. If you turn it on, enter the information from your MySQL SSL certificate in these fields:

1. Enter the `ca.pem` file contents in the **CA Certificate** field.
   1. Enter the `client-key.pem` file contents in the **Client Private Key** field.
   1. Enter the `client-cert.pem` file contents in the **Client Certificate** field.

1. If you want to use **SSH Tunnel** for the connection, turn this option on in the credential. Otherwise, skip it. If you turn it on:

1. Select the **SSH Authenticate with** to set the SSH Tunnel type to build:
      - Select **Password** if you want to connect to SSH using a password.
      - Select **Private Key** if you want to connect to SSH using an identity file (private key) and a passphrase.
   1. Enter the **SSH Host**. n8n uses this host to create the SSH URI formatted as: `[user@]host:port`.
   1. Enter the **SSH Port**. n8n uses this port to create the SSH URI formatted as: `[user@]host:port`.
   1. Enter the **SSH User** to connect with. n8n uses this user to create the SSH URI formatted as: `[user@]host:port`.
   1. If you selected **Password** for **SSH Authenticate with**, add the **SSH Password**.
   1. If you selected **Private Key** for **SSH Authenticate with**:
      1. Add the contents of the **Private Key** or identity file used for SSH. This is the same as using the `ssh-identity-file` option with the `shell-connect()` command in MySQL.
      1. If the **Private Key** was created with a passphrase, enter that **Passphrase**. This is the same as using the `ssh-identity-pass` option with the `shell-connect()` command in MySQL. If the **Private Key** has no passphrase, leave this field blank.

Refer to [MySQL | Creating SSL and RSA Certificates and Keys](https://dev.mysql.com/doc/refman/8.0/en/creating-ssl-rsa-files.html) for more information on working with SSL certificates in MySQL. Refer to [MySQL | Using an SSH Tunnel](https://dev.mysql.com/doc/mysql-shell/8.0/en/mysql-shell-connection-ssh.html) for more information on working with SSH tunnels in MySQL.

**Examples:**

Example 1 (unknown):
```unknown
SHOW VARIABLES WHERE Variable_name = 'hostname';
```

Example 2 (unknown):
```unknown
SHOW DATABASES;
```

Example 3 (unknown):
```unknown
SHOW VARIABLES WHERE Variable_name = 'port';
```

Example 4 (unknown):
```unknown
SHOW VARIABLES WHERE Variable_name = 'connect_timeout';
```

---

## Malcore credentials

**URL:** llms-txt#malcore-credentials

**Contents:**
- Prerequisites
- Related resources
- Using API key

You can use these credentials to authenticate when using the [HTTP Request node](../../core-nodes/n8n-nodes-base.httprequest/) to make a [Custom API call](../../../custom-operations/).

Create a [Malcore](https://app.malcore.io/register) account.

Refer to [Malcore's API documentation](https://malcore.readme.io/reference/) for more information about authenticating with the service.

This is a credential-only node. Refer to [Custom API operations](../../../custom-operations/) to learn more. View [example workflows and related content](https://n8n.io/integrations/malcore/) on n8n's website.

To configure this credential, you'll need:

- An **API Key**: Get an API Key from your **Account > API**.

Refer to [Using the Malcore API](https://support.malcore.io/hc/en-au/articles/17711707070617-Using-the-Malcore-API) for more information.

---

## Raindrop credentials

**URL:** llms-txt#raindrop-credentials

**Contents:**
- Prerequisites
- Supported authentication methods
- Related resources
- Using OAuth

You can use these credentials to authenticate the following nodes:

- [Raindrop](../../app-nodes/n8n-nodes-base.raindrop/)

Create a [Raindrop](https://raindrop.io/) account.

## Supported authentication methods

Refer to [Raindrop's API documentation](https://developer.raindrop.io/) for more information about the service.

To configure this credential, you'll need:

- A **Client ID**
- A **Client Secret**

Generate both by creating a Raindrop app.

To create an app, go to **Settings >** [**Integrations**](https://app.raindrop.io/settings/integrations) and select **+ Create new app** in the **For Developers** section.

Use these settings for your app:

- Copy the **OAuth Redirect URL** from n8n and add it as a **Redirect URI** in your app.
- Copy the **Client ID** and **Client Secret** from the Raindrop app and enter them in your n8n credential.

---

## Gmail Trigger node

**URL:** llms-txt#gmail-trigger-node

**Contents:**
- Events
- Node parameters
- Node filters
- Related resources
- Common issues

[Gmail](https://www.gmail.com) is an email service developed by Google. The Gmail Trigger node can start a workflow based on events in Gmail.

You can find authentication information for this node [here](../../credentials/google/).

Examples and templates

For usage examples and templates to help you get started, refer to n8n's [Gmail Trigger integrations](https://n8n.io/integrations/gmail-trigger/) page.

- **Message Received**: The node triggers for new messages at the selected **Poll Time**.

Configure the node with these parameters:

- **Credential to connect with**: Select or create a new Google credential to use for the trigger. Refer to [Google credentials](../../credentials/google/) for more information on setting up a new credential.
- **Poll Times**: Select a poll **Mode** to set how often to trigger the poll. Your **Mode** selection will add or remove relevant fields. Refer to [Poll Mode options](poll-mode-options/) to configure the parameters for each mode type.
- **Simplify**: Choose whether to return a simplified version of the response (turned on, default) or the raw data (turned off).
  - The simplified version returns email message IDs, labels, and email headers, including: From, To, CC, BCC, and Subject.

Use these filters to further refine the node's behavior:

- **Include Spam and Trash**: Select whether the node should trigger on new messages in the Spam and Trash folders (turned on) or not (turned off).
- **Label Names or IDs**: Only trigger on messages with the selected labels added to them. Select the Label names you want to apply or enter an expression to specify IDs. The dropdown populates based on the **Credential** you selected.
- **Search**: Enter Gmail search refine filters, like `from:`, to trigger the node on the filtered conditions only. Refer to [Refine searches in Gmail](https://support.google.com/mail/answer/7190?hl=en) for more information.
- **Read Status**: Choose whether to receive **Unread and read emails**, **Unread emails only** (default), or **Read emails only**.
- **Sender**: Enter an email or a part of a sender name to trigger only on messages from that sender.

n8n provides an app node for Gmail. You can find the node docs [here](../../app-nodes/n8n-nodes-base.gmail/).

View [example workflows and related content](https://n8n.io/integrations/gmail-trigger/) on n8n's website.

Refer to [Google's Gmail API documentation](https://developers.google.com/gmail/api/guides) for details about their API.

For common questions or issues and suggested solutions, refer to [Common issues](common-issues/).

---

## Wufoo credentials

**URL:** llms-txt#wufoo-credentials

**Contents:**
- Prerequisites
- Supported authentication methods
- Related resources
- Using API key

You can use these credentials to authenticate the following nodes:

- [Wufoo Trigger](../../trigger-nodes/n8n-nodes-base.wufootrigger/)

Create a [Wufoo](https://wufoo.com) account.

## Supported authentication methods

Refer to [Wufoo's API documentation](https://wufoo.github.io/docs/) for more information about the service.

To configure this credential, you'll need:

- An **API Key**: Get your API key from the [Wufoo Form Manager](https://app.wufoo.com/#/form-manager). To the right of a form, select **More > API Information**. Refer to [Using API Information and Webhooks](https://help.surveymonkey.com/en/wufoo/integrations/wufoo-api/) for more information.
- A **Subdomain**: Your subdomain is the part of your Wufoo URL that comes after `https://` and before `wufoo.com`. So if the full domain is `https://n8n.wufoo.com`, the subdomain is `n8n`. Admins can view the subdomain in the [**Account Manager**](https://help.surveymonkey.com/en/wufoo/account/account-manager/). Refer to [Your Subdomain](https://help.surveymonkey.com/en/wufoo/account/your-subdomain/) for more information.

---

## LDAP

**URL:** llms-txt#ldap

**Contents:**
- Operations
- Compare
- Create
- Delete
- Rename
- Search
  - Search options
- Update
- Templates and examples

This node allows you to interact with your LDAP servers to create, find, and update objects.

You can find authentication information for this node [here](../../credentials/ldap/).

- [**Compare**](#compare) an attribute
- [**Create**](#create) a new entry
- [**Delete**](#delete) an entry
- [**Rename**](#rename) the DN of an existing entry
- [**Search**](#search) LDAP
- [**Update**](#update) attributes

Refer to the sections below for details on configuring the node for each operation.

This node can be used as an AI tool

This node can be used to enhance the capabilities of an AI agent. When used in this way, many parameters can be set automatically, or with information directed by AI - find out more in the [AI tool parameters documentation](../../../../advanced-ai/examples/using-the-fromai-function/).

Configure this operation using these parameters:

- **Credential to connect with**: Select or create an [LDAP credential](../../credentials/ldap/) to connect with.
- **DN**: Enter the Distinguished Name (DN) of the entry to compare.
- **Attribute ID**: Enter the ID of the attribute to compare.
- **Value**: Enter the value to compare.

Configure this operation using these parameters:

- **Credential to connect with**: Select or create an [LDAP credential](../../credentials/ldap/) to connect with.
- **DN**: Enter the Distinguished Name (DN) of the entry to create.
- **Attributes**: Add the **Attribute ID**/**Value** pairs you'd like to create.

Configure this operation using these parameters:

- **Credential to connect with**: Select or create an [LDAP credential](../../credentials/ldap/) to connect with.
- **DN**: Enter the Distinguished Name (DN) of the entry to be deleted.

Configure this operation using these parameters:

- **Credential to connect with**: Select or create an [LDAP credential](../../credentials/ldap/) to connect with.
- **DN**: Enter the current Distinguished Name (DN) of the entry to rename.
- **New DN**: Enter the new Distinguished Name (DN) for the entry in this field.

Configure this operation using these parameters:

- **Credential to connect with**: Select or create an [LDAP credential](../../credentials/ldap/) to connect with.
- **Base DN**: Enter the Distinguished Name (DN) of the subtree to search in.
- **Search For**: Select the directory object class to search for.
- **Attribute**: Select the attribute to search for.
- **Search Text**: Enter the text to search for. Use `*` for a wildcard.
- **Return All**: When turned on, the node will return all results. When turned off, the node will return results up to the set **Limit**.
- **Limit**: Only available when you turn off **Return All**. Enter the maximum number of results to return.

You can also configure this operation using these options:

- **Attribute Names or IDs**: Enter a comma-separated list of attributes to return. Choose from the list or specify IDs using an expression.
- **Page Size**: Enter the maximum number of results to request at one time. Set to 0 to disable paging.
- **Scopes**: The set of entries at or below the **Base DN** to search for potential matches. Select from:
  - **Base Tree**: Often referred to as subordinateSubtree or just "subordinates," selecting this option will search the subordinates of the **Base DN** entry but not the **Base DN** entry itself.
  - **Single Level**: Often referred to as "one," selecting this option will search only the immediate children of the **Base DN** entry.
  - **Whole Subtree**: Often referred to as "sub," selecting this option will search the **Base DN** entry and all its subordinates to any depth.

Refer to [The LDAP Search Operation](https://ldap.com/the-ldap-search-operation/) for more information on search scopes.

Configure this operation using these parameters:

- **Credential to connect with**: Select or create an [LDAP credential](../../credentials/ldap/) to connect with.
- **DN**: Enter the Distinguished Name (DN) of the entry to update.
- ***Update Attributes*\*: Select whether to** Add **new,** Remove **existing, or** Replace\*\* existing attribute.
- Then enter the **Attribute ID**/**Value** pair you'd like to update.

## Templates and examples

**Adaptive RAG with Google Gemini & Qdrant: Context-Aware Query Answering**

[View template details](https://n8n.io/workflows/4043-adaptive-rag-with-google-gemini-and-qdrant-context-aware-query-answering/)

**Adaptive RAG Strategy with Query Classification & Retrieval (Gemini & Qdrant)**

[View template details](https://n8n.io/workflows/3459-adaptive-rag-strategy-with-query-classification-and-retrieval-gemini-and-qdrant/)

**OpenAI Responses API Adapter for LLM and AI Agent Workflows**

[View template details](https://n8n.io/workflows/4218-openai-responses-api-adapter-for-llm-and-ai-agent-workflows/)

[Browse LDAP integration templates](https://n8n.io/integrations/ldap/), or [search all templates](https://n8n.io/workflows/)

---

## Split Out

**URL:** llms-txt#split-out

**Contents:**
- Node parameters
  - Field to Split Out
  - Include
- Node options
  - Disable Dot Notation
  - Destination Field Name
  - Include Binary
- Templates and examples
- Related resources

Use the Split Out node to separate a single data item containing a list into multiple items. For example, a list of customers, and you want to split them so that you have an item for each customer.

Configure this node using the following parameters.

### Field to Split Out

Enter the field containing the list you want to separate out into individual items.

If you're working with binary data inputs, use `$binary` in an expression to set the field to split out.

Select whether and how you want n8n to keep any other fields from the input data with each new individual item.

- **No Other Fields**: No other fields will be included.
- **All Other Fields**: All other fields will be included.
- **Selected Other Fields**: Only the selected fields will be included.
  - **Fields to Include**: Enter a comma separated list of the fields you want to include.

### Disable Dot Notation

By default, n8n enables dot notation to reference child fields in the format `parent.child`. Use this option to disable dot notation (turned on) or to continue using dot (turned off).

### Destination Field Name

Enter the field in the output where the split field contents should go.

Choose whether to include binary data from the input in the new output (turned on) or not (turned off).

## Templates and examples

**Scrape and summarize webpages with AI**

[View template details](https://n8n.io/workflows/1951-scrape-and-summarize-webpages-with-ai/)

**Scrape business emails from Google Maps without the use of any third party APIs**

[View template details](https://n8n.io/workflows/2567-scrape-business-emails-from-google-maps-without-the-use-of-any-third-party-apis/)

**Automated Web Scraping: email a CSV, save to Google Sheets & Microsoft Excel**

[View template details](https://n8n.io/workflows/2275-automated-web-scraping-email-a-csv-save-to-google-sheets-and-microsoft-excel/)

[Browse Split Out integration templates](https://n8n.io/integrations/split-out/), or [search all templates](https://n8n.io/workflows/)

Learn more about [data structure and data flow](../../../../data/) in n8n workflows.

---

## Webflow Trigger node

**URL:** llms-txt#webflow-trigger-node

[Webflow](https://webflow.com) is an application that allows you to build responsive websites with browser-based visual editing software.

You can find authentication information for this node [here](../../credentials/webflow/).

Examples and templates

For usage examples and templates to help you get started, refer to n8n's [Webflow Trigger integrations](https://n8n.io/integrations/webflow-trigger/) page.

---

## Gumroad Trigger node

**URL:** llms-txt#gumroad-trigger-node

[Gumroad](https://gumroad.com) is an online platform that enables creators to sell products directly to consumers.

You can find authentication information for this node [here](../../credentials/gumroad/).

Examples and templates

For usage examples and templates to help you get started, refer to n8n's [Gumroad Trigger integrations](https://n8n.io/integrations/gumroad-trigger/) page.

---

## Twilio node

**URL:** llms-txt#twilio-node

**Contents:**
- Operations
- Templates and examples
- Related resources
- What to do if your operation isn't supported

Use the Twilio node to automate work in Twilio, and integrate Twilio with other applications. n8n supports sending MMS/SMS and WhatsApp messages with Twilio.

On this page, you'll find a list of operations the Twilio node supports and links to more resources.

Refer to [Twilio credentials](../../credentials/twilio/) for guidance on setting up authentication.

This node can be used as an AI tool

This node can be used to enhance the capabilities of an AI agent. When used in this way, many parameters can be set automatically, or with information directed by AI - find out more in the [AI tool parameters documentation](../../../../advanced-ai/examples/using-the-fromai-function/).

- SMS
  - Send SMS/MMS/WhatsApp message
- Call
  - Make a phone call using text-to-speech to say a message

## Templates and examples

**Handling Appointment Leads and Follow-up With Twilio, Cal.com and AI**

[View template details](https://n8n.io/workflows/2342-handling-appointment-leads-and-follow-up-with-twilio-calcom-and-ai/)

**Automate Lead Qualification with RetellAI Phone Agent, OpenAI GPT & Google Sheet**

[View template details](https://n8n.io/workflows/3912-automate-lead-qualification-with-retellai-phone-agent-openai-gpt-and-google-sheet/)

**Enhance Customer Chat by Buffering Messages with Twilio and Redis**

[View template details](https://n8n.io/workflows/2346-enhance-customer-chat-by-buffering-messages-with-twilio-and-redis/)

[Browse Twilio integration templates](https://n8n.io/integrations/twilio/), or [search all templates](https://n8n.io/workflows/)

Refer to [Twilio's documentation](https://www.twilio.com/docs/usage/api) for more information about the service.

## What to do if your operation isn't supported

If this node doesn't support the operation you want to do, you can use the [HTTP Request node](../../core-nodes/n8n-nodes-base.httprequest/) to call the service's API.

You can use the credential you created for this service in the HTTP Request node:

1. In the HTTP Request node, select **Authentication** > **Predefined Credential Type**.
1. Select the service you want to connect to.
1. Select your credential.

Refer to [Custom API operations](../../../custom-operations/) for more information.

---

## Google Drive Trigger node common issues

**URL:** llms-txt#google-drive-trigger-node-common-issues

**Contents:**
- 401 unauthorized error
- Handling more than one file change

Here are some common errors and issues with the [Google Drive Trigger node](../) and steps to resolve or troubleshoot them.

## 401 unauthorized error

The full text of the error looks like this:

This error occurs when there's an issue with the credential you're using and its scopes or permissions.

1. For [OAuth2](../../../credentials/google/oauth-single-service/) credentials, make sure you've enabled the Google Drive API in **APIs & Services > Library**. Refer to [Google OAuth2 Single Service - Enable APIs](../../../credentials/google/oauth-single-service/#enable-apis) for more information.
1. For [Service Account](../../../credentials/google/service-account/) credentials:
   1. [Enable domain-wide delegation](../../../credentials/google/service-account/#enable-domain-wide-delegation).
   1. Make sure you add the Google Drive API as part of the domain-wide delegation configuration.

## Handling more than one file change

The Google Drive Trigger node polls Google Drive for changes at a set interval (once every minute by default).

If multiple changes to the **Watch For** criteria occur during the polling interval, a single Google Drive Trigger event occurs containing the changes as items. To handle this, your workflow must account for times when the data might contain more than one item.

You can use an [if node](../../../core-nodes/n8n-nodes-base.if/) or a [switch node](../../../core-nodes/n8n-nodes-base.switch/) to change your workflow's behavior depending on whether the data from the Google Drive Trigger node contains a single item or multiple items.

**Examples:**

Example 1 (unknown):
```unknown
401 - {"error":"unauthorized_client","error_description":"Client is unauthorized to retrieve access tokens using this method, or client not authorized for any of the scopes requested."}
```

---

## Taiga Trigger node

**URL:** llms-txt#taiga-trigger-node

[Taiga](https://www.taiga.io/) is a free and open-source project management platform for startups, agile developers, and designers.

You can find authentication information for this node [here](../../credentials/taiga/).

Examples and templates

For usage examples and templates to help you get started, refer to n8n's [Taiga Trigger integrations](https://n8n.io/integrations/taiga-trigger/) page.

---

## Oracle Database node

**URL:** llms-txt#oracle-database-node

**Contents:**
- Operations
  - Delete
  - Execute SQL
  - Insert
  - Insert or Update
  - Select
  - Update
- Related resources
- Use bind parameters
- Use n8n Expressions for bind values

Use the Oracle Database node to automate work in Oracle Database, and integrate Oracle Database with other applications. n8n has built-in support for a wide range of Oracle Database features which includes executing an SQL statement, fetching, inserting, updating or deleting data from Oracle Database. This node uses the [node-oracledb driver](https://github.com/oracle/node-oracledb) internally.

On this page, you'll find a list of operations the Oracle Database node supports and links to more resources.

Refer to [Oracle Database credentials](../../credentials/oracledb/) for guidance on setting up authentication.

Requires Oracle Database **19c or later**. For thick mode, use Oracle Client Libraries **19c or later**.

- [**Delete**](#delete): Delete an entire table or rows in a table
- [**Execute SQL**](#execute-sql): Execute an SQL statement
- [**Insert**](#insert): Insert rows in a table
- [**Insert or Update**](#insert-or-update): Insert or update rows in a table
- [**Select**](#select): Select rows from a table
- [**Update**](#update): Update rows in a table

Use this operation to delete an entire table or rows in a table.

Enter these parameters:

- **Credential to connect with**: Create or select an existing [Oracle Database credential](../../credentials/oracledb/).
- **Operation**: Select **Delete**.
- **Schema**: Choose the schema that contains the table you want to work on. Select **From list** to choose the schema from the dropdown list or **By Name** to enter the schema name.
- **Table**: Choose the table that you want to work on. Select **From list** to choose the table from the dropdown list, or select **By Name** to enter the table name.
- **Command**: The deletion action to take:
  - **Truncate**: Removes the table's data but preserves the table's structure.
  - **Delete**: Delete the rows that match the "Select Rows" condition. If you don't select anything, Oracle Database deletes all rows.
    - **Select Rows**: Define a **Column**, **Operator**, and **Value** to match rows on. The value can be passed as JSON using expression or string.
    - **Combine Conditions**: How to combine the conditions in "Select Rows". The **AND** requires all conditions to be true, while **OR** requires at least one condition to be true.
  - **Drop**: Deletes the table's data and structure permanently.

- **Auto Commit**: When this property is set to true, the transaction in the current connection is automatically committed at the end of statement execution.
- **Statement Batching**: The way to send statements to the database:
  - **Single Statement**: A single statement for all incoming items.
  - **Independently**: Execute one statement per incoming item of the execution.
  - **Transaction**: Execute all statements in a transaction. If a failure occurs, Oracle Database rolls back all changes.

Use this operation to execute an SQL statement.

Enter these parameters:

- **Credential to connect with**: Create or select an existing [Oracle Database credential](../../credentials/oracledb/).

- **Operation**: Execute SQL **Execute SQL**.

- **Statement**: The SQL statement to execute. You can use n8n [expressions](../../../../code/expressions/) and positional parameters like `:1`, `:2`, or named parameters like `:name`, `:id` to use with [Use bind parameters](#use-bind-parameters). To run a PL/SQL procedure, for example `demo`, you can use:

#### Execute Statement options

- **Auto Commit**: When this property is set to true, the transaction in the current connection is automatically committed at the end of statement execution.
- **Bind Variable Placeholder Values**: Enter the values for the bind parameters used in the statement [Use bind parameters](#use-bind-parameters).
- **Output Numbers As String**: Indicates if the numbers should be retrieved as a String.
- **Fetch Array Size**: This property is a number that sets the size of an internal buffer used for fetching query rows from Oracle Database. Changing it may affect query performance but does not affect how many rows are returned to the application.
- **Number of Rows to Prefetch**: This property is a query tuning option to set the number of additional rows the underlying Oracle driver fetches during the internal initial statement execution phase of a query.

Use this operation to insert rows in a table.

Enter these parameters:

- **Credential to connect with**: Create or select an existing [Oracle Database credential](../../credentials/oracledb/).
- **Operation**: Select **Insert**.
- **Schema**: Choose the schema that contains the table you want to work on. Select **From list** to choose the schema from the dropdown list or **By Name** to enter the schema name.
- **Table**: Choose the table that you want to work on. Select **From list** to choose the table from the dropdown list, or select **By Name** to enter the table name.
- **Mapping Column Mode**: How to map column names to incoming data:
  - **Map Each Column Manually**: Select the values to use for each column [Use n8n expressions for bind values](#use-n8n-expressions-for-bind-values).
  - **Map Automatically**: Automatically map incoming data to matching column names in Oracle Database. The incoming data field names must match the column names in Oracle Database for this to work. If necessary, consider using the [edit fields (set) node](../../core-nodes/n8n-nodes-base.set/) before this node to adjust the format as needed.

- **Auto Commit**: When this property is set to true, the transaction in the current connection is automatically committed at the end of statement execution.
- **Output Columns**: Choose which columns to output. You can select from a list of available columns or specify IDs using [expressions](../../../../code/expressions/).
- **Statement Batching**: The way to send statements to the database:
  - **Single Statement**: A single statement for all incoming items.
  - **Independently**: Execute one statement per incoming item of the execution.
  - **Transaction**: Execute all statements in a transaction. If a failure occurs, Oracle Database rolls back all changes.

Use this operation to insert or update rows in a table.

Enter these parameters:

- **Credential to connect with**: Create or select an existing [Oracle Database credential](../../credentials/oracledb/).
- **Operation**: Select **Insert or Update**.
- **Schema**: Choose the schema that contains the table you want to work on. Select **From list** to choose the schema from the dropdown list or **By Name** to enter the schema name.
- **Table**: Choose the table that you want to work on. Select **From list** to choose the table from the dropdown list, or select **By Name** to enter the table name.
- **Mapping Column Mode**: How to map column names to incoming data:
  - **Map Each Column Manually**: Select the values to use for each column [Use n8n expressions for bind values](#use-n8n-expressions-for-bind-values).
  - **Map Automatically**: Automatically map incoming data to matching column names in Oracle Database. The incoming data field names must match the column names in Oracle Database for this to work. If necessary, consider using the [edit fields (set) node](../../core-nodes/n8n-nodes-base.set/) before this node to adjust the format as needed.

#### Insert or Update options

- **Auto Commit**: When this property is set to true, the transaction in the current connection is automatically committed at the end of statement execution.
- **Output Columns**: Choose which columns to output. You can select from a list of available columns or specify IDs using [expressions](../../../../code/expressions/).
- **Statement Batching**: The way to send statements to the database:
  - **Single Statement**: A single statement for all incoming items.
  - **Independently**: Execute one statement per incoming item of the execution.
  - **Transaction**: Execute all statements in a transaction. If a failure occurs, Oracle Database rolls back all changes.

Use this operation to select rows in a table.

Enter these parameters:

- **Credential to connect with**: Create or select an existing [Oracle Database credential](../../credentials/oracledb/).
- **Operation**: Select **Select**.
- **Schema**: Choose the schema that contains the table you want to work on. Select **From list** to choose the schema from the dropdown list or **By Name** to enter the schema name.
- **Table**: Choose the table that you want to work on. Select **From list** to choose the table from the dropdown list, or select **By Name** to enter the table name.
- **Return All**: Whether to return all results or only up to a given limit.
- **Limit**: The maximum number of items to return when **Return All** is disabled.
- **Select Rows**: Set the conditions to select rows. Define a **Column**, **Operator**, and **Value**(as `json`) to match rows on. The **Value** can vary by type — for example with Fixed mode:
  - String: "hello", hellowithoutquotes, "hello with space"
  - Number: 12
  - JSON: { "key": "val" }

If you don't select anything, Oracle Database selects all rows.

- **Combine Conditions**: How to combine the conditions in **Select Rows**. The **AND** requires all conditions to be true, while **OR** requires at least one condition to be true.
- **Sort**: Choose how to sort the selected rows. Choose a **Column** from a list or by ID and a sort **Direction**.

- **Auto Commit**: When this property is set to true, the transaction in the current connection is automatically committed at the end of statement execution.
- **Output Numbers As String**: Indicates if the numbers should be retrieved as a String.
- **Fetch Array Size**: This property is a number that sets the size of an internal buffer used for fetching query rows from Oracle Database. Changing it may affect query performance but does not affect how many rows are returned to the application.
- **Number of Rows to Prefetch**: This property is a query tuning option to set the number of additional rows the underlying Oracle driver fetches during the internal initial statement execution phase of a query.

Use this operation to update rows in a table.

Enter these parameters:

- **Credential to connect with**: Create or select an existing [Oracle Database credential](../../credentials/oracledb/).
- **Operation**: Select **Update**.
- **Schema**: Choose the schema that contains the table you want to work on. Select **From list** to choose the schema from the dropdown list or **By Name** to enter the schema name.
- **Table**: Choose the table that you want to work on. Select **From list** to choose the table from the dropdown list, or select **By Name** to enter the table name.
- **Mapping Column Mode**: How to map column names to incoming data:
  - **Map Each Column Manually**: Select the values to use for each column [Use n8n expressions for bind values](#use-n8n-expressions-for-bind-values).
  - **Map Automatically**: Automatically map incoming data to matching column names in Oracle Database. The incoming data field names must match the column names in Oracle Database for this to work. If necessary, consider using the [edit fields (set) node](../../core-nodes/n8n-nodes-base.set/) before this node to adjust the format as needed.

- **Auto Commit**: When this property is set to true, the transaction in the current connection is automatically committed at the end of statement execution.
- **Output Columns**: Choose which columns to output. You can select from a list of available columns or specify IDs using [expressions](../../../../code/expressions/).
- **Statement Batching**: The way to send statements to the database:
  - **Single Statement**: A single statement for all incoming items.
  - **Independently**: Execute one statement per incoming item of the execution.
  - **Transaction**: Execute all statements in a transaction. If a failure occurs, Oracle Database rolls back all changes.

Refer to [SQL Language Reference](https://www.oracle.com/pls/topic/lookup?ctx=dblatest&id=SQLRF) for more information about the service.

Refer to [node-oracledb documentation](https://node-oracledb.readthedocs.io/en/latest/) for more information about the node-oracledb driver.

## Use bind parameters

When creating a statement to run on an Oracle database instance, you can use the **Bind Variable Placeholder Values** field in the **Options** section to load data into the statement. n8n sanitizes data in statement parameters, which prevents SQL injection.

For example, you would want to find specific fruits by their color. Given the following input data:

You can write a statement like:

Then in **Bind Variable Placeholder Values**, provide the field values to use. You can provide fixed values or expressions. For this example, use expressions so the node can pull the color from each input item in turn:

## Use n8n Expressions for bind values

For **Values to Send**, you can provide inputs using n8n Expressions. Below are examples for different data types — you can either enter constant values or reference fields from previous items (`$json`):

- Constant: `{{ { k1: "v1", k2: "v2" } }}`
- From a previous item: `{{ $json.COL_JSON }}`

- Constant: `{{ [1, 2, 3, 4.5] }}`
- From a previous item: `{{ $json.COL_VECTOR }}`

- Constant: `{{ [94, 87, 34] }}` or `{{ ' BLOB data string' }}`
- From a previous item: `{{ $json.COL_BLOB }}`

- Constant: `{{ [94, 87, 34] }}`
- From a previous item: `{{ $json.COL_RAW }}`

- Constant: `{{ true }}`
- From a previous item: `{{ $json.COL_BOOLEAN }}`

- Constant: `1234`
- From a previous item: `{{ $json.COL_NUMBER }}`

- Constant: `' Hello World '`
- From a previous item: `{{ $json.COL_CHAR }}`

These examples assume JSON keys (e.g. `COL_JSON, COL_VECTOR`) map directly to the respective SQL column types.

**Examples:**

Example 1 (unknown):
```unknown
BEGIN
    demo;
  END;
```

Example 2 (unknown):
```unknown
[
    {
        "FRUIT_ID": 1,
        "FRUIT_NAME": "Apple",
        "COLOR": "Red" 
    },
    {
        "FRUIT_ID": 2,
        "FRUIT_NAME": "Banana",
        "COLOR": "Yellow"
    }
]
```

Example 3 (unknown):
```unknown
SELECT * FROM FRUITS WHERE COLOR = :col
```

Example 4 (unknown):
```unknown
// fruits is an example table name
fruits, {{ $json.color }}
```

---

## Zoom credentials

**URL:** llms-txt#zoom-credentials

**Contents:**
- Prerequisites
- Supported authentication methods
- Related resources
- Using API JWT token
- Using OAuth2

You can use these credentials to authenticate the following nodes:

- [Zoom](../../app-nodes/n8n-nodes-base.zoom/)

Create a [Zoom](https://zoom.us/) account. Your account must have one of the following permissions:

- Account owner
- Account admin
- Zoom for developers role

## Supported authentication methods

- API JWT token
- OAuth2

API JWT token deprecation

Zoom removed support for JWT access tokens in June 2023. You must use OAuth2 for all new credentials.

Refer to [Zoom's API documentation](https://developers.zoom.us/docs/api/) for more information about the service.

## Using API JWT token

This authentication method has been fully deprecated by Zoom. Don't create new credentials with it.

To configure this credential, you'll need:

- A **JWT token**: To create a JWT token, create a new JWT app in the [Zoom App Marketplace](https://marketplace.zoom.us/).

To configure this credential, you'll need:

- A **Client ID**: Generated when you create an OAuth app on the Zoom App Marketplace.
- A **Client Secret**: Generated when you create an OAuth app.

To generate your **Client ID** and **Client Secret**, [create an OAuth app](https://developers.zoom.us/docs/integrations/create/).

Use these settings for your OAuth app:

- Select **User-managed app** for **Select how the app is managed**.
- Copy the **OAuth Callback URL** from n8n and enter it as an **OAuth Redirect URL** in Zoom.
- If your n8n credential displays a **Whitelist URL**, also enter that URL as a an **OAuth Redirect URL**.
- Enter **Scopes** for the scopes you plan to use. For all functionality in the [Zoom](../../app-nodes/n8n-nodes-base.zoom/) node, select:
  - `meeting:read`
  - `meeting:write`
  - Refer to [OAuth scopes | Meeting scopes](https://developers.zoom.us/docs/integrations/oauth-scopes/#meeting-scopes) for more information on meeting scopes.
- Copy the **Client ID** and **Client Secret** provided in the Zoom app and enter them in your n8n credential.

---

## Test a node

**URL:** llms-txt#test-a-node

This section contains information about testing your node.

There are two ways to test your node:

- Manually, by [running it on your own machine](run-node-locally/) within a local n8n instance.
- Automatically, using the [linter](node-linter/).

You should use both methods before publishing your node.

---

## Keyboard shortcuts and controls

**URL:** llms-txt#keyboard-shortcuts-and-controls

**Contents:**
- Workflow controls
- Canvas
  - Move the canvas
  - Canvas zoom
  - Nodes on the canvas
  - With one or more nodes selected in canvas
- Node panel
  - Node panel categories
- Within nodes
- Join the community

n8n provides keyboard shortcuts for some actions.

- **Ctrl** + **Alt** + **n**: create new workflow
- **Ctrl** + **o**: open workflow
- **Ctrl** + **s**: save the current workflow
- **Ctrl** + **z**: undo
- **Ctrl** + **shift** + **z**: redo
- **Ctrl** + **Enter**: execute workflow

- **Ctrl** + **Left Mouse Button** + drag: move node view
- **Ctrl** + **Middle mouse button** + drag: move node view
- **Space** + drag: move node view
- **Middle mouse button** + drag: move node view
- Two fingers on a touch screen: move node view

- **+** or **=**: zoom in
- **-** or **\_**: zoom out
- **0**: reset zoom level
- **1**: zoom to fit workflow
- **Ctrl** + **Mouse wheel**: zoom in/out

### Nodes on the canvas

- **Double click** on a node: open the node details
- **Ctrl/Cmd** + **Double click** on a sub-workflow node: open the sub-workflow in a new tab
- **Ctrl** + **a**: select all nodes
- **Ctrl** + **v**: paste nodes
- **Shift** + **s**: add sticky note

### With one or more nodes selected in canvas

- **ArrowDown**: select sibling node below the current one
- **ArrowLeft**: select node left of the current one
- **ArrowRight**: select node right of the current one
- **ArrowUp**: select sibling node above the current one
- **Ctrl** + **c**: copy
- **Ctrl** + **x**: cut
- **D**: deactivate
- **Delete**: delete
- **Enter**: open
- **F2**: rename
- **P**: pin data in node. Refer to [Data pinning](../data/data-pinning/) for more information.
- **Shift** + **ArrowLeft**: select all nodes left of the current one
- **Shift** + **ArrowRight**: select all nodes right of the current one
- **Ctrl/Cmd** + **Shift** + **o** on a sub-workflow node: open the sub-workflow in a new tab

- **Tab**: open the Node Panel
- **Enter**: insert selected node into workflow
- **Escape**: close Node panel

### Node panel categories

- **Enter**: insert node into workflow, collapse/expand category, open subcategory
- **ArrowRight**: expand category, open subcategory
- **ArrowLeft**: collapse category, close subcategory view

- **=**: in an empty parameter input, this switches to [expressions](../glossary/#expression-n8n) mode.

This guide outlines a series of tutorials and resources designed to get you started with n8n.

It's not necessary to complete all items listed to start using n8n. Use this as a reference to navigate to the most relevant parts of the documentation and other resources according to your needs.

## Join the community

n8n has an active community where you can get and offer help. Connect, share, and learn with other n8n users:

- [Ask questions](https://community.n8n.io/t/readme-welcome-to-the-n8n-community/44381) and [make feature requests](https://community.n8n.io/c/feature-requests) in the Community Forum.
- [Report bugs](https://github.com/n8n-io/n8n/issues) and [contribute](https://github.com/n8n-io/n8n/blob/master/CONTRIBUTING.md) on GitHub.

If you don't have an account yet, sign up to a [free trial on n8n Cloud](https://app.n8n.cloud/register) or install n8n's community edition with [Docker](../hosting/installation/docker/) (recommended) or [npm](../hosting/installation/npm/). See [Choose your n8n](../choose-n8n/) for more details.

Start with the quickstart guides to help you get up and running with building basic workflows.

- [A very quick quickstart](../try-it-out/quickstart/)
- [A longer introduction](../try-it-out/tutorial-first-workflow/)
- [Build an AI workflow in n8n](../advanced-ai/intro-tutorial/)

## Structured Courses

n8n offers two sets of courses.

Learn key concepts and n8n features, while building examples as you go.

- The [Beginner](https://www.youtube.com/playlist?list=PLlET0GsrLUL59YbxstZE71WszP3pVnZfI) course covers the basics of n8n.
- The [Advanced](https://www.youtube.com/playlist?list=PLlET0GsrLUL5bxmx5c1H1Ms_OtOPYZIEG) course covers more complex workflows, more technical nodes, and enterprise features

Build more complex workflows while learning key concepts along the way. Earn a badge and an avatar in your community profile.

- [Level 1: Beginner Course](https://blog.n8n.io/announcing-the-n8n-certification-course-for-beginners-level-1/)
- [Level 2: Intermediate Course](https://blog.n8n.io/announcing-course-level-two/)

Explore various [self-hosting options in n8n](../hosting/). If you’re not sure where to start, these are two popular options:

- [Hosting n8n on DigitalOcean](../hosting/installation/server-setups/digital-ocean/)
- [Hosting n8n on Amazon Web Services](../hosting/installation/server-setups/aws/)

If you can't find a node for a specific app or a service, you can build a node yourself and share with the community. See what others have built on [npm website](https://www.npmjs.com/search?q=keywords:n8n-community-node-package).

- [Build a declarative-style node](../integrations/creating-nodes/build/declarative-style-node/)
- [Learn how to build your own n8n nodes (Youtube Video)](https://www.youtube.com/live/OI6zHJ56eW0?si=SMD7L1J5fZ2mf79W)

- Follow new features and bug fixes in the [Release Notes](../release-notes/)
- Follow n8n on socials: [Twitter/X](https://twitter.com/n8n_io), [Discord](https://discord.com/invite/vWwMVThRta), [LinkedIn](https://www.linkedin.com/company/n8n/), [YouTube](https://www.youtube.com/@n8n-io)

---

## Performance and benchmarking

**URL:** llms-txt#performance-and-benchmarking

**Contents:**
- Performance factors
- Run your own benchmarking
- Example: Single instance performance
- Example: Multi-instance performance

n8n can handle up to 220 workflow executions per second on a single instance, with the ability to scale up further by adding more instances.

This document outlines n8n's performance benchmarking. It describes the factors that affect performance, and includes two example benchmarks.

## Performance factors

The performance of n8n depends on factors including:

- The workflow type
- The resources available to n8n
- How you configure n8n's scaling options

## Run your own benchmarking

To get an accurate estimate for your use case, run n8n's [benchmarking framework](https://github.com/n8n-io/n8n/tree/master/packages/%40n8n/benchmark). The repository contains more information about the benchmarking.

## Example: Single instance performance

This test measures how response time increases as requests per second increase. It looks at the response time when calling the Webhook Trigger node.

- Hardware: ECS c5a.large instance (4GB RAM)
- n8n setup: Single n8n instance (running in main mode, with Postgres database)
- Workflow: Webhook Trigger node, Edit Fields node

This graph shows the percentage of requests to the Webhook Trigger node getting a response within 100 seconds, and how that varies with load. Under higher loads n8n usually still processes the data, but takes over 100s to respond.

## Example: Multi-instance performance

This test measures how response time increases as requests per second increase. It looks at the response time when calling the Webhook Trigger node.

- Hardware: seven ECS c5a.4xlarge instances (8GB RAM each)
- n8n setup: two webhook instances, four worker instances, one database instance (MySQL), one main instance running n8n and Redis
- Workflow: Webhook Trigger node, Edit Fields node
- Multi-instance setups use [Queue mode](../queue-mode/)

This graph shows the percentage of requests to the Webhook Trigger node getting a response within 100 seconds, and how that varies with load. Under higher loads n8n usually still processes the data, but takes over 100s to respond.

---

## Asana Trigger node

**URL:** llms-txt#asana-trigger-node

**Contents:**
- Events
- Related resources

[Asana](https://asana.com/) is a web and mobile application designed to help teams organize, track, and manage their work.

You can find authentication information for this node [here](../../credentials/asana/).

Examples and templates

For usage examples and templates to help you get started, refer to n8n's [Asana Trigger integrations](https://n8n.io/integrations/asana-trigger/) page.

n8n provides an app node for Asana. You can find the node docs [here](../../app-nodes/n8n-nodes-base.asana/).

View [example workflows and related content](https://n8n.io/integrations/asana-trigger/) on n8n's website.

Refer to [Asana's documentation](https://developers.asana.com/reference/rest-api-reference) for details about their API.

---

## TYPE n8n_scaling_mode_queue_jobs_active gauge

**URL:** llms-txt#type-n8n_scaling_mode_queue_jobs_active-gauge

n8n_scaling_mode_queue_jobs_active 0

---

## Output of other nodes

**URL:** llms-txt#output-of-other-nodes

Methods for working with the output of other nodes. Some methods and variables aren't available in the Code node.

You can use Python in the Code node. It isn't available in expressions.

| Method                                                 | Description                                                                                                                                                                                            | Available in Code node? |
| ------------------------------------------------------ | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------ | ----------------------- |
| `$("<node-name>").all(branchIndex?, runIndex?)`        | Returns all items from a given node. If `branchIndex` isn't given it will default to the output that connects `node-name` with the node where you use the expression or code.                          |                         |
| `$("<node-name>").first(branchIndex?, runIndex?)`      | The first item output by the given node. If `branchIndex` isn't given it will default to the output that connects `node-name` with the node where you use the expression or code.                      |                         |
| `$("<node-name>").last(branchIndex?, runIndex?)`       | The last item output by the given node. If `branchIndex` isn't given it will default to the output that connects `node-name` with the node where you use the expression or code.                       |                         |
| `$("<node-name>").item`                                | The linked item. This is the item in the specified node used to produce the current item. Refer to [Item linking](../../../data/data-mapping/data-item-linking/) for more information on item linking. |                         |
| `$("<node-name>").params`                              | Object containing the query settings of the given node. This includes data such as the operation it ran, result limits, and so on.                                                                     |                         |
| `$("<node-name>").context`                             | Boolean. Only available when working with the Loop Over Items node. Provides information about what's happening in the node. Use this to determine whether the node is still processing items.         |                         |
| `$("<node-name>").itemMatching(currentNodeInputIndex)` | Use instead of `$("<node-name>").item` in the Code node if you need to trace back from an input item.                                                                                                  |                         |

| Method                                                 | Description                                                                                                                                                                                                               | Available in Code node? |
| ------------------------------------------------------ | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ----------------------- |
| `_("<node-name>").all(branchIndex?, runIndex?)`        | Returns all items from a given node. If `branchIndex` isn't given it will default to the output that connects`node-name` with the node where you use the expression or code.                                              |                         |
| `_("<node-name>").first(branchIndex?, runIndex?)`      | The first item output by the given node. If `branchIndex` isn't given it will default to the output that connects`node-name` with the node where you use the expression or code.                                          |                         |
| `_("<node-name>").last(branchIndex?, runIndex?)`       | The last item output by the given node. If `branchIndex` isn't given it will default to the output that connects`node-name` with the node where you use the expression or code.                                           |                         |
| `_("<node-name>").item`                                | The linked item. This is the item in the specified node used to produce the current item. Refer to [Item linking](../../../data/data-mapping/data-item-linking/) for more information on item linking.                    |                         |
| `_("<node-name>").params`                              | Object containing the query settings of the given node. This includes data such as the operation it ran, result limits, and so on.                                                                                        |                         |
| `_("<node-name>").context`                             | Boolean. Only available when working with the Loop Over Items node. Provides information about what's happening in the node. Use this to determine whether the node is still processing items.                            |                         |
| `_("<node-name>").itemMatching(currentNodeInputIndex)` | Use instead of `_("<node-name>").item` in the Code node if you need to trace back from an input item. Refer to [Retrieve linked items from earlier in the workflow](../../cookbook/builtin/itemmatching/) for an example. |                         |

---

## AMQP Trigger node

**URL:** llms-txt#amqp-trigger-node

[AMQP](https://www.amqp.org/) is an open standard application layer protocol for message-oriented middleware. The defining features of AMQP are message orientation, queuing, routing, reliability and security. This node supports AMQP 1.0 compatible message brokers.

You can find authentication information for this node [here](../../credentials/amqp/).

Examples and templates

For usage examples and templates to help you get started, refer to n8n's [AMQP integrations](https://n8n.io/integrations/amqp-trigger/) page.

---

## Gotify node

**URL:** llms-txt#gotify-node

**Contents:**
- Operations
- Templates and examples

Use the Gotify node to automate work in Gotify, and integrate Gotify with other applications. n8n has built-in support for a wide range of Gotify features, including creating, deleting, and getting messages.

On this page, you'll find a list of operations the Gotify node supports and links to more resources.

Refer to [Gotify credentials](../../credentials/gotify/) for guidance on setting up authentication.

This node can be used as an AI tool

This node can be used to enhance the capabilities of an AI agent. When used in this way, many parameters can be set automatically, or with information directed by AI - find out more in the [AI tool parameters documentation](../../../../advanced-ai/examples/using-the-fromai-function/).

- Message
  - Create
  - Delete
  - Get All

## Templates and examples

**Send daily weather updates via a message using the Gotify node**

[View template details](https://n8n.io/workflows/774-send-daily-weather-updates-via-a-message-using-the-gotify-node/)

**Spotify Sync Liked Songs to Playlist**

[View template details](https://n8n.io/workflows/2634-spotify-sync-liked-songs-to-playlist/)

**🛠️ Gotify Tool MCP Server**

[View template details](https://n8n.io/workflows/5246-gotify-tool-mcp-server/)

[Browse Gotify integration templates](https://n8n.io/integrations/gotify/), or [search all templates](https://n8n.io/workflows/)

---

## OpenID Connect (OIDC)

**URL:** llms-txt#openid-connect-(oidc)

- Available on Enterprise plans.
- You need to be an instance owner or admin to enable and configure OIDC.

This section covers how to enable and manage OpenID Connect (OIDC) for single sign-on (SSO). You can learn more about how OIDC works by visiting [what is OpenID Connect](https://openid.net/developers/how-connect-works/) by the OpenID Foundation.

- [Set up OIDC](setup/): a general guide to setting up OpenID Connect (OIDC) SSO in n8n.
- [Troubleshooting](troubleshooting/): a list of things to check if you encounter issues with OIDC.

---

## Oura node

**URL:** llms-txt#oura-node

**Contents:**
- Operations
- Templates and examples

Use the Oura node to automate work in Oura, and integrate Oura with other applications. n8n has built-in support for a wide range of Oura features, including getting profiles, and summaries.

On this page, you'll find a list of operations the Oura node supports and links to more resources.

Refer to [Oura credentials](../../credentials/oura/) for guidance on setting up authentication.

- Profile
  - Get the user's personal information.
- Summary
  - Get the user's activity summary.
  - Get the user's readiness summary.
  - Get the user's sleep summary

## Templates and examples

[Browse Oura integration templates](https://n8n.io/integrations/oura/), or [search all templates](https://n8n.io/workflows/)

---

## Odoo credentials

**URL:** llms-txt#odoo-credentials

**Contents:**
- Supported authentication methods
- Related resources
- Using API key
- Using password
- Required plan type

You can use these credentials to authenticate the following nodes:

- [Odoo](../../app-nodes/n8n-nodes-base.odoo/)

## Supported authentication methods

- API key (Recommended)
- Password

Refer to [Odoo's External API documentation](https://www.odoo.com/documentation/17.0/developer/reference/external_api.html) for more information about the service.

Refer to the Odoo [Getting Started tutorial](https://www.odoo.com/slides/getting-started-15) if you're new to Odoo.

To configure this credential, you'll need a user account on an [Odoo](https://www.odoo.com/) database and:

- Your **Site URL**
- Your **Username**
- An **API key**
- Your **Database name**

To set up the credential with an API key:

1. Enter your Odoo server or site URL as the **Site URL**.
1. Enter your **Username** as it's displayed on your **Change password** screen in Odoo.
1. To use an API key, go to **Your Profile > Preferences > Account Security > Developer API Keys**.
   - If you don't have this option, you may need to upgrade your Odoo plan. Refer to [Required plan type](#required-plan-type) for more information.
1. Select **New API Key**.
1. Enter a **Description** for the key, like `n8n integration`.
1. Select **Generate Key**.
1. Copy the key and enter it as the **Password or API key** in your n8n credential.
1. Enter your Odoo **Database name**, also known as the instance name.

Refer to [Odoo API Keys](https://www.odoo.com/documentation/15.0/developer/reference/external_api.html?#api-keys) for more information.

To configure this credential, you'll need a user account on an [Odoo](https://www.odoo.com/) database and:

- Your **Site URL**
- Your **Username**
- Your **Password**
- Your **Database name**

To set up the credential with a password:

1. Enter your Odoo server or site URL as the **Site URL**.
1. Enter your **Username** as it's displayed on your **Change password** screen in Odoo.
1. To use a password, enter your user password in the **Password or API key** field.
1. Enter your Odoo **Database name**, also known as the instance name.

Password compatibility

If you try a password credential and it doesn't work for a specific node function, try switching to an API key. Odoo requires an API key for certain modules or based on certain settings.

## Required plan type

Access to the external API is only available on a **Custom** Odoo plan. (The One App Free or Standard plans won't give you access.)

Refer to [Odoo Pricing Plans](https://www.odoo.com/pricing-plan) for more information.

---

## Cortex credentials

**URL:** llms-txt#cortex-credentials

**Contents:**
- Prerequisites
- Supported authentication methods
- Related resources
- Using API key

You can use these credentials to authenticate the following nodes:

- [Cortex](../../app-nodes/n8n-nodes-base.cortex/)

Install [Cortex](https://docs.strangebee.com/cortex/installation-and-configuration/) on your server.

## Supported authentication methods

Refer to [Cortex's API documentation](https://docs.strangebee.com/cortex/api/api-guide/) for more information about the service.

To configure this credential, you'll need:

- An **API Key**: Refer to the [Cortex API Authentication documentation](https://docs.strangebee.com/cortex/api/api-guide/#authentication) for detailed instructions on generating API keys.
- The URL/Server Address for your **Cortex Instance** (defaults to `http://<your_server_address>:9001/`)

---

## DeepSeek credentials

**URL:** llms-txt#deepseek-credentials

**Contents:**
- Prerequisites
- Supported authentication methods
- Related resources
- Using API key

You can use these credentials to authenticate the following nodes:

- [Chat DeepSeek](../../cluster-nodes/sub-nodes/n8n-nodes-langchain.lmchatdeepseek/)

Create a [DeepSeek](https://platform.deepseek.com/sign_up) account.

## Supported authentication methods

Refer to [DeepSeek's API documentation](https://api-docs.deepseek.com/api/deepseek-api) for more information about the service.

To configure this credential, you'll need:

To generate your API Key:

1. Login to your DeepSeek account or [create](https://platform.deepseek.com/sign_up) an account.
1. Open your [API keys](https://platform.deepseek.com/api_keys) page.
1. Select **Create new secret key** to create an API key, optionally naming the key.
1. Copy your key and add it as the **API Key** in n8n.

Refer to the [Your First API Call](https://api-docs.deepseek.com/) page for more information.

---

## What's a tool in AI?

**URL:** llms-txt#what's-a-tool-in-ai?

**Contents:**
- AI tools in n8n

In AI, 'tools' has a specific meaning. Tools act like addons that your AI can use to access extra context or resources.

Here are a couple of other ways of expressing it:

> Tools are interfaces that an agent can use to interact with the world ([source](https://langchain-ai.github.io/langgraphjs/how-tos/tool-calling/))

> We can think of these tools as being almost like functions that your AI model can call ([source](https://www.udemy.com/course/chatgpt-and-langchain-the-complete-developers-masterclass/))

n8n provides tool [sub-nodes](../../../glossary/#sub-node-n8n) that you can connect to your [AI agent](../../../glossary/#ai-agent). As well as providing some popular tools, such as [Wikipedia](../../../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.toolwikipedia/) and [SerpAPI](../../../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.toolserpapi/), n8n provides three especially powerful tools:

- [Call n8n Workflow Tool](../../../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.toolworkflow/): use this to load any n8n workflow as a tool.
- [Custom Code Tool](../../../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.toolcode/): write code that your agent can run.
- [HTTP Request Tool](../../../integrations/builtin/cluster-nodes/sub-nodes/n8n-nodes-langchain.toolhttprequest/): make calls to fetch a website or data from an API.

The next three examples highlight the Call n8n Workflow Tool:

- [Chat with Google Sheets](../data-google-sheets/)
- [Call an API to fetch data](../api-workflow-tool/)
- [Set up a human fallback](../human-fallback/)

You can also learn how to [let AI dynamically specify parameters for tools with the `$fromAI()` function](../using-the-fromai-function/).

---

## Qualys credentials

**URL:** llms-txt#qualys-credentials

**Contents:**
- Prerequisites
- Supported authentication methods
- Related resources
- Using basic auth

You can use these credentials to authenticate when using the [HTTP Request node](../../core-nodes/n8n-nodes-base.httprequest/) to make a [Custom API call](../../../custom-operations/).

Create a [Qualys](https://www.qualys.com/) user account with any user role except Contact.

## Supported authentication methods

Refer to [Qualys's documentation](https://qualysguard.qg2.apps.qualys.com/qwebhelp/fo_portal/api_doc/index.htm) for more information about the service.

This is a credential-only node. Refer to [Custom API operations](../../../custom-operations/) to learn more. View [example workflows and related content](https://n8n.io/integrations/qualys/) on n8n's website.

To configure this credential, you'll need:

- A **Username**
- A **Password**
- A **Requested With** string: Enter a user description, like a user agent, or keep the default `n8n application`. This sets the required `X-Requested-With` header.

---

## External secrets

**URL:** llms-txt#external-secrets

**Contents:**
- Connect n8n to your secrets store
- Use secrets in n8n credentials
- Using external secrets with n8n environments
- Using external secrets in projects
- Troubleshooting
  - Infisical version changes
  - Only set external secrets on credentials owned by an instance owner or admin

- External secrets are available on Enterprise Self-hosted and Enterprise Cloud plans.
- n8n supports AWS Secrets Manager, Azure Key Vault, GCP Secrets Manager, Infisical and HashiCorp Vault.
- n8n doesn't support [HashiCorp Vault Secrets](https://developer.hashicorp.com/hcp/docs/vault-secrets).

You can use an external secrets store to manage [credentials](../glossary/#credential-n8n) for n8n.

n8n stores all credentials encrypted in its database, and restricts access to them by default. With the external secrets feature, you can store sensitive credential information in an external vault, and have n8n load it in when required. This provides an extra layer of security and allows you to manage credentials used across multiple [n8n environments](../source-control-environments/) in one central place.

## Connect n8n to your secrets store

Your secret names can't contain spaces, hyphens, or other special characters. n8n supports secret names containing alphanumeric characters (`a-z`, `A-Z`, and `0-9`), and underscores. n8n currently only supports plaintext values for secrets, not JSON objects or key-value pairs.

1. In n8n, go to **Settings** > **External Secrets**.

1. Select **Set Up** for your store provider.

1. Enter the credentials for your provider:

- Azure Key Vault: Provide your **vault name**, **tenant ID**, **client ID**, and **client secret**. Refer to the Azure documentation to [register a Microsoft Entra ID app and create a service principal](https://learn.microsoft.com/en-us/entra/identity-platform/howto-create-service-principal-portal). n8n supports only single-line values for secrets.

- AWS Secrets Manager: provide your **access key ID**, **secret access key**, and **region**. The IAM user must have the `secretsmanager:ListSecrets`, `secretsmanager:BatchGetSecretValue`, and `secretsmanager:GetSecretValue` permissions.

To give n8n access to all secrets in your AWS Secrets Manager, you can attach the following policy to the IAM user:

You can also be more restrictive and give n8n access to select specific AWS Secret Manager secrets. You still need to allow the `secretsmanager:ListSecrets` and `secretsmanager:BatchGetSecretValue` permissions to access all resources. These permissions allow n8n to retrieve ARN-scoped secrets, but don't provide access to the secret values.

Next, you need set the scope for the `secretsmanager:GetSecretValue` permission to the specific Amazon Resource Names (ARNs) for the secrets you wish to share with n8n. Ensure you use the correct region and account ID in each resource ARNs. You can find the ARN details in the AWS dashboard for your secrets.

For example, the following IAM policy only allows access to secrets with a name starting with `n8n` in your specified AWS account and region:

For more IAM permission policy examples, consult the [AWS documentation](https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access_iam-policies.html#auth-and-access_examples_batch).

- HashiCorp Vault: provide the **Vault URL** for your vault instance, and select your **Authentication Method**. Enter your authentication details. Optionally provide a namespace.

- Refer to the HashiCorp documentation for your authentication method: [Token auth method](https://developer.hashicorp.com/vault/docs/auth/token)\
       [AppRole auth method](https://developer.hashicorp.com/vault/docs/auth/approle)\
       [Userpass auth method](https://developer.hashicorp.com/vault/docs/auth/userpass)
     - If you use vault namespaces, you can enter the namespace n8n should connect to. Refer to [Vault Enterprise namespaces](https://developer.hashicorp.com/vault/docs/enterprise/namespaces) for more information on HashiCorp Vault namespaces.

- Infisical: provide a **Service Token**. Refer to Infisical's [Service token](https://infisical.com/docs/documentation/platform/token) documentation for information on getting your token. If you self-host Infisical, enter the **Site URL**.

Infisical environment

Make sure you select the correct Infisical environment when creating your token. n8n will load secrets from this environment, and won't have access to secrets in other Infisical environments. n8n only support service tokens that have access to a single environment.

n8n doesn't support [Infisical folders](https://infisical.com/docs/documentation/platform/folder).

- Google Cloud Platform: provide a **Service Account Key** (JSON) for a service account that has at least these roles: `Secret Manager Secret Accessor` and `Secret Manager Secret Viewer`. Refer to Google's [service account documentation](https://cloud.google.com/iam/docs/service-account-overview) for more information.

1. **Save** your configuration.

1. Enable the provider using the **Disabled / Enabled** toggle.

## Use secrets in n8n credentials

To use a secret from your store in an n8n credential:

1. Create a new credential, or open an existing one.

1. On the field where you want to use a secret:

1. Hover over the field.
   1. Select **Expression**.

1. In the field where you want to use a secret, enter an [expression](../glossary/#expression-n8n) referencing the secret name:

`<vault-name>` is either `vault` (for HashiCorp) or `infisical` or `awsSecretsManager`. Replace `<secret-name>` with the name as it appears in your vault.

## Using external secrets with n8n environments

n8n's [Source control and environments](../source-control-environments/) feature allows you to create different n8n environments, backed by Git. The feature doesn't support using different credentials in different instances. You can use an external secrets vault to provide different credentials for different environments by connecting each n8n instance to a different vault or project environment.

For example, you have two n8n instances, one for development and one for production. You use Infisical for your vault. In Infisical, create a project with two environments, development and production. Generate a token for each Infisical environment. Use the token for the development environment to connect your development n8n instance, and the token for your production environment to connect your production n8n instance.

## Using external secrets in projects

To use external secrets in an [RBAC project](../user-management/rbac/), you must have an [instance owner or instance admin](../user-management/account-types/) as a member of the project.

### Infisical version changes

Infisical version upgrades can introduce problems connecting to n8n. If your Infisical connection stops working, check if there was a recent version change. If so, report the issue to help@n8n.io.

### Only set external secrets on credentials owned by an instance owner or admin

Due to the permissions that instance owners and admins have, it's possible for owners and admins to update credentials owned by another user with a secrets expression. This will appear to work in preview for an instance owner or admin, but the secret won't resolve when the workflow runs in production.

Only use external secrets for credentials that are owned by an instance admin or owner. This ensures they resolve correctly in production.

AI agents are artificial intelligence systems capable of responding to requests, making decisions, and performing real-world tasks for users. They use large language models (LLMs) to interpret user input and make decisions about how to best process requests using the information and resources they have available.

AI chains allow you to interact with large language models (LLMs) and other resources in sequences of calls to components. AI chains in n8n don't use persistent memory, so you can't use them to reference previous context (use AI agents for this).

Completions are the responses generated by a model like GPT.

Embeddings are numerical representations of data using vectors. They're used by AI to interpret complex data and relationships by mapping values across many dimensions. Vector databases, or vector stores, are databases designed to store and access embeddings.

In AI, and specifically in retrieval-augmented generation (RAG) contexts, groundedness and ungroundedness are measures of how much a model's responses accurately reflect source information. The model uses its source documents to generate grounded responses, while ungrounded responses involve speculation or hallucination unsupported by those same sources.

#### AI hallucination

Hallucination in AI is when an LLM (large language model) mistakenly perceives patterns or objects that don't exist.

Reranking is a technique that refines the order of a list of candidate documents to improve the relevance of search results. Retrieval-Augmented Generation (RAG) and other applications use reranking to prioritize the most relevant information for generation or downstream tasks.

In an AI context, memory allows AI tools to persist message context across interactions. This allows you to have a continuing conversations with AI agents, for example, without submitting ongoing context with each message. In n8n, AI agent nodes can use memory, but AI chains can't.

#### AI retrieval-augmented generation (RAG)

Retrieval-augmented generation, or RAG, is a technique for providing LLMs access to new information from external sources to improve AI responses. RAG systems retrieve relevant documents to ground responses in up-to-date, domain-specific, or proprietary knowledge to supplement their original training data. RAG systems often rely on vector stores to manage and search this external data efficiently.

In an AI context, a tool is an add-on resource that the AI can refer to for specific information or functionality when responding to a request. The AI model can use a tool to interact with external systems or complete specific, focused tasks.

A vector store, or vector database, stores mathematical representations of information. Use with embeddings and retrievers to create a database that your AI can access when answering questions.

APIs, or application programming interfaces, offer programmatic access to a service's data and functionality. APIs make it easier for software to interact with external systems. They're often offered as an alternative to traditional user-focused interfaces accessed through web browsers or UI.

The canvas is the main interface for building workflows in n8n's editor UI. You use the canvas to add and connect nodes to compose workflows.

#### cluster node (n8n)

In n8n, cluster nodes are groups of nodes that work together to provide functionality in a workflow. They consist of a root node and one or more sub nodes that extend the node's functionality.

#### credential (n8n)

In n8n, credentials store authentication information to connect with specific apps and services. After creating credentials with your authentication information (username and password, API key, OAuth secrets, etc.), you can use the associated app node to interact with the service.

#### data pinning (n8n)

Data pinning allows you to temporarily freeze the output data of a node during workflow development. This allows you to develop workflows with predictable data without making repeated requests to external services. Production workflows ignore pinned data and request new data on each execution.

The n8n editor UI allows you to create and manage workflows. The main area is the canvas, where you can compose workflows by adding, configuring, and connecting nodes. The side and top panels allow you to access other areas of the UI like credentials, templates, variables, executions, and more.

#### entitlement (n8n)

In n8n, entitlements grant n8n instances access to plan-restricted features for a specific period of time.

Floating entitlements are a pool of entitlements that you can distribute among various n8n instances. You can re-assign a floating entitlement to transfer its access to a different n8n instance.

#### evaluation (n8n)

In n8n, evaluation allows you to tag and organize execution history and compare it against new executions. You can use this to understand how your workflow performs over time as you make changes. In particular, this is useful while developing AI-centered workflows.

#### expression (n8n)

In n8n, expressions allow you to populate node parameters dynamically by executing JavaScript code. Instead of providing a static value, you can use the n8n expression syntax to define the value using data from previous nodes, other workflows, or your n8n environment.

LangChain is an AI-development framework used to work with large language models (LLMs). LangChain provides a standardized system for working with a wide variety of models and other resources and linking different components together to build complex applications.

#### Large language model (LLM)

Large language models, or LLMs, are AI machine learning models designed to excel in natural language processing (NLP) tasks. They're built by training on large amounts of data to develop probabilistic models of language and other data.

In n8n, nodes are individual components that you compose to create workflows. Nodes define when the workflow should run, allow you to fetch, send, and process data, can define flow control logic, and connect with external services.

n8n projects allow you to separate workflows, variables, and credentials into separate groups for easier management. Projects make it easier for teams to collaborate by sharing and compartmentalizing related resources.

Each n8n cluster node contains a single root nodes that defines the main functionality of the cluster. One or more sub nodes attach to the root node to extend its functionality.

n8n cluster nodes consist of one or more sub nodes connected to a root node. Sub nodes extend the functionality of the root node, providing access to specific services or resources or offering specific types of dedicated processing, like calculator functionality, for example.

n8n templates are pre-built workflows designed by n8n and community members that you can import into your n8n instance. When using templates, you may need to fill in credentials and adjust the configuration to suit your needs.

#### trigger node (n8n)

A trigger node is a special node responsible for executing the workflow in response to certain conditions. All production workflows need at least one trigger to determine when the workflow should run.

An n8n workflow is a collection of nodes that automate a process. Workflows begin execution when a trigger condition occurs and execute sequentially to achieve complex tasks.

**Examples:**

Example 1 (unknown):
```unknown
{
     	"Version": "2012-10-17",
     	"Statement": [
     		{
     			"Sid": "AccessAllSecrets",
     			"Effect": "Allow",
     			"Action": [
     				"secretsmanager:ListSecrets",
     				"secretsmanager:BatchGetSecretValue",
     				"secretsmanager:GetResourcePolicy",
     				"secretsmanager:GetSecretValue",
     				"secretsmanager:DescribeSecret",
     				"secretsmanager:ListSecretVersionIds",
     			],
     			"Resource": "*"
     		}
     	]
     }
```

Example 2 (unknown):
```unknown
{
     	"Version": "2012-10-17",
     	"Statement": [
     		{
     			"Sid": "ListingSecrets",
     			"Effect": "Allow",
     			"Action": [
     				"secretsmanager:ListSecrets",
     				"secretsmanager:BatchGetSecretValue"
     			],
     			"Resource": "*"
     		},
     		{
     			"Sid": "RetrievingSecrets",
     			"Effect": "Allow",
     			"Action": [
     				"secretsmanager:GetSecretValue",
     				"secretsmanager:DescribeSecret"
     			],
     			"Resource": [
     				"arn:aws:secretsmanager:us-west-2:123456789000:secret:n8n*"
     			]
     		}
     	]
     }
```

Example 3 (unknown):
```unknown
{{ $secrets.<vault-name>.<secret-name> }}
```

---

## Harvest credentials

**URL:** llms-txt#harvest-credentials

**Contents:**
- Prerequisites
- Supported authentication methods
- Related resources
- Using API Access Token
- Using OAuth2

You can use these credentials to authenticate the following nodes:

- [Harvest](../../app-nodes/n8n-nodes-base.harvest/)

Create a [Harvest](https://www.getharvest.com/) account.

## Supported authentication methods

- API access token
- OAuth2

Refer to [Harvest's API documentation](https://help.getharvest.com/api-v2/) for more information about the service.

## Using API Access Token

To configure this credential, you'll need:

- A Personal **Access Token**: Refer to the [Harvest Personal Access Token Authentication documentation](https://help.getharvest.com/api-v2/authentication-api/authentication/authentication/#personal-access-tokens) for instructions on creating a personal access token.

Note for n8n Cloud users

Cloud users don't need to provide connection details. Select **Connect my account** to connect through your browser.

If you need to configure OAuth2 from scratch or need more detail on what's happening in the OAuth web flow, refer to the instructions in the [Harvest OAuth2 documentation](https://help.getharvest.com/api-v2/authentication-api/authentication/authentication/#oauth2-application) to set up OAuth.

---

## Queue mode environment variables

**URL:** llms-txt#queue-mode-environment-variables

**Contents:**
- Multi-main setup

File-based configuration

You can add `_FILE` to individual variables to provide their configuration in a separate file. Refer to [Keeping sensitive data in separate files](../../configuration-methods/#keeping-sensitive-data-in-separate-files) for more details.

You can run n8n in different modes depending on your needs. Queue mode provides the best scalability. Refer to [Queue mode](../../../scaling/queue-mode/) for more information.

| Variable                                | Type    | Default     | Description                                                                                                                                                                                                                                                                                                                                       |
| --------------------------------------- | ------- | ----------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| `OFFLOAD_MANUAL_EXECUTIONS_TO_WORKERS`  | Boolean | `false`     | Set to `true` if you want manual executions to run on the worker rather than on main.                                                                                                                                                                                                                                                             |
| `QUEUE_BULL_PREFIX`                     | String  | -           | Prefix to use for all queue keys.                                                                                                                                                                                                                                                                                                                 |
| `QUEUE_BULL_REDIS_DB`                   | Number  | `0`         | The Redis database used.                                                                                                                                                                                                                                                                                                                          |
| `QUEUE_BULL_REDIS_HOST`                 | String  | `localhost` | The Redis host.                                                                                                                                                                                                                                                                                                                                   |
| `QUEUE_BULL_REDIS_PORT`                 | Number  | `6379`      | The Redis port used.                                                                                                                                                                                                                                                                                                                              |
| `QUEUE_BULL_REDIS_USERNAME`             | String  | -           | The Redis username (needs Redis version 6 or above). Don't define it for Redis < 6 compatibility                                                                                                                                                                                                                                                  |
| `QUEUE_BULL_REDIS_PASSWORD`             | String  | -           | The Redis password.                                                                                                                                                                                                                                                                                                                               |
| `QUEUE_BULL_REDIS_TIMEOUT_THRESHOLD`    | Number  | `10000`     | The Redis timeout threshold (in ms).                                                                                                                                                                                                                                                                                                              |
| `QUEUE_BULL_REDIS_CLUSTER_NODES`        | String  | -           | Expects a comma-separated list of Redis Cluster nodes in the format `host:port`, for the Redis client to initially connect to. If running in queue mode (`EXECUTIONS_MODE = queue`), setting this variable will create a Redis Cluster client instead of a Redis client, and n8n will ignore `QUEUE_BULL_REDIS_HOST` and `QUEUE_BULL_REDIS_PORT`. |
| `QUEUE_BULL_REDIS_TLS`                  | Boolean | `false`     | Enable TLS on Redis connections.                                                                                                                                                                                                                                                                                                                  |
| `QUEUE_BULL_REDIS_DUALSTACK`            | Boolean | `false`     | Enable dual-stack support (IPv4 and IPv6) on Redis connections.                                                                                                                                                                                                                                                                                   |
| `QUEUE_WORKER_TIMEOUT` (**deprecated**) | Number  | `30`        | **Deprecated** Use `N8N_GRACEFUL_SHUTDOWN_TIMEOUT` instead. How long should n8n wait (seconds) for running executions before exiting worker process on shutdown.                                                                                                                                                                                  |
| `QUEUE_HEALTH_CHECK_ACTIVE`             | Boolean | `false`     | Whether to enable health checks (true) or disable (false).                                                                                                                                                                                                                                                                                        |
| `QUEUE_HEALTH_CHECK_PORT`               | Number  | 5678        | The port to serve health checks on. If you experience a port conflict error when starting a worker server using its default port, change this.                                                                                                                                                                                                    |
| `QUEUE_WORKER_LOCK_DURATION`            | Number  | `60000`     | How long (in ms) is the lease period for a worker to work on a message.                                                                                                                                                                                                                                                                           |
| `QUEUE_WORKER_LOCK_RENEW_TIME`          | Number  | `10000`     | How frequently (in ms) should a worker renew the lease time.                                                                                                                                                                                                                                                                                      |
| `QUEUE_WORKER_STALLED_INTERVAL`         | Number  | `30000`     | How often should a worker check for stalled jobs (use 0 for never).                                                                                                                                                                                                                                                                               |
| `QUEUE_WORKER_MAX_STALLED_COUNT`        | Number  | `1`         | Maximum amount of times a stalled job will be re-processed.                                                                                                                                                                                                                                                                                       |

Refer to [Configuring multi-main setup](../../../scaling/queue-mode/#configuring-multi-main-setup) for details.

| Variable                              | Type    | Default | Description                                                           |
| ------------------------------------- | ------- | ------- | --------------------------------------------------------------------- |
| `N8N_MULTI_MAIN_SETUP_ENABLED`        | Boolean | `false` | Whether to enable multi-main setup for queue mode (license required). |
| `N8N_MULTI_MAIN_SETUP_KEY_TTL`        | Number  | `10`    | Time to live (in seconds) for leader key in multi-main setup.         |
| `N8N_MULTI_MAIN_SETUP_CHECK_INTERVAL` | Number  | `3`     | Interval (in seconds) for leader check in multi-main setup.           |

---

## Affinity Trigger node

**URL:** llms-txt#affinity-trigger-node

**Contents:**
- Events
- Related resources

[Affinity](https://www.affinity.co/) is a powerful relationship intelligence platform enabling teams to leverage their network to close the next big deal.

You can find authentication information for this node [here](../../credentials/affinity/).

Examples and templates

For usage examples and templates to help you get started, refer to n8n's [Affinity Trigger integrations](https://n8n.io/integrations/affinity-trigger/) page.

- Field value
- Created
- Deleted
- Updated
- Field
- Created
- Deleted
- Updated
- File
- Created
- Deleted
- List entry
- Created
- Deleted
- List
- Created
- Deleted
- Updated
- Note
- Created
- Deleted
- Updated
- Opportunity
- Created
- Deleted
- Updated
- Organization
- Created
- Deleted
- Updated
- Person
- Created
- Deleted
- Updated

n8n provides an app node for Affinity. You can find the node docs [here](../../app-nodes/n8n-nodes-base.affinity/).

View [example workflows and related content](https://n8n.io/integrations/affinity-trigger/) on n8n's website.

Refer to [Affinity's documentation](https://api-docs.affinity.co/) for details about their API.

---

## OpenAI Text operations

**URL:** llms-txt#openai-text-operations

**Contents:**
- Generate a Chat Completion
  - Options
- Generate a Model Response
  - Built-in Tools
  - Options
- Classify Text for Violations
  - Options
- Common issues

Use this operation to message a model or classify text for violations in OpenAI. Refer to [OpenAI](../) for more information on the OpenAI node itself.

Previous node versions

n8n version 1.117.0 introduces the OpenAI node V2 that supports the OpenAI Responses API. It renames the 'Message a Model' operation to 'Generate a Chat Completion' to clarify its association with the Chat Completions API and introduces a separate 'Generate a Model Response' operation that uses the Responses API.

## Generate a Chat Completion

Use this operation to send a message or prompt to an OpenAI model - using the Chat Completions API - and receive a response.

Enter these parameters:

- **Credential to connect with**: Create or select an existing [OpenAI credential](../../../credentials/openai/).
- **Resource**: Select **Text**.
- **Operation**: Select **Generate a Chat Completion**.
- **Model**: Select the model you want to use. If you’re not sure which model to use, try `gpt-4o` if you need high intelligence or `gpt-4o-mini` if you need the fastest speed and lowest cost. Refer to [Models overview | OpenAI Platform](https://platform.openai.com/docs/models) for more information.
- **Messages**: Enter a **Text** prompt and assign a **Role** that the model will use to generate responses. Refer to [Prompt engineering | OpenAI](https://platform.openai.com/docs/guides/prompt-engineering) for more information on how to write a better prompt by using these roles. Choose from one of these roles:
  - **User**: Sends a message as a user and gets a response from the model.
  - **Assistant**: Tells the model to adopt a specific tone or personality.
  - **System**: By default, there is no system message. You can define instructions in the user message, but the instructions set in the system message are more effective. You can set more than one system message per conversation. Use this to set the model's behavior or context for the next user message.
- **Simplify Output**: Turn on to return a simplified version of the response instead of the raw data.
- **Output Content as JSON**: Turn on to attempt to return the response in JSON format. Compatible with `GPT-4 Turbo` and all `GPT-3.5 Turbo` models newer than `gpt-3.5-turbo-1106`.

- **Frequency Penalty**: Apply a penalty to reduce the model's tendency to repeat similar lines. The range is between `0.0` and `2.0`.
- **Maximum Number of Tokens**: Set the maximum number of tokens for the response. One token is roughly four characters for standard English text. Use this to limit the length of the output.
- **Number of Completions**: Defaults to 1. Set the number of completions you want to generate for each prompt. Use carefully since setting a high number will quickly consume your tokens.
- **Presence Penalty**: Apply a penalty to influence the model to discuss new topics. The range is between `0.0` and `2.0`.
- **Output Randomness (Temperature)**: Adjust the randomness of the response. The range is between `0.0` (deterministic) and `1.0` (maximum randomness). We recommend altering this or **Output Randomness (Top P)** but not both. Start with a medium temperature (around `0.7`) and adjust based on the outputs you observe. If the responses are too repetitive or rigid, increase the temperature. If they’re too chaotic or off-track, decrease it. Defaults to `1.0`.
- **Output Randomness (Top P)**: Adjust the Top P setting to control the diversity of the assistant's responses. For example, `0.5` means half of all likelihood-weighted options are considered. We recommend altering this or **Output Randomness (Temperature)** but not both. Defaults to `1.0`.

Refer to [Chat Completions | OpenAI](https://platform.openai.com/docs/api-reference/chat) documentation for more information.

## Generate a Model Response

Use this operation to send a message or prompt to an OpenAI model - using the Responses API - and receive a response.

Enter these parameters:

- **Credential to connect with**: Create or select an existing [OpenAI credential](../../../credentials/openai/).
- **Resource**: Select **Text**.
- **Operation**: Select **Generate a Model Response**.
- **Model**: Select the model you want to use. Refer to [Models overview | OpenAI Platform](https://platform.openai.com/docs/models) for an overview.
- **Messages**: Choose from one of these a **Message Types**:
  - **Text**: Enter a **Text** prompt and assign a **Role** that the model will use to generate responses. Refer to [Prompt engineering | OpenAI](https://platform.openai.com/docs/guides/prompt-engineering) for more information on how to write a better prompt by using these roles.
  - **Image**: Provide an **Image** either through an Image URL, a File ID (using the [OpenAI Files API](https://platform.openai.com/docs/api-reference/files)) or by passing binary data from an earlier node in your workflow.
  - **File**: Provide a **File** in a supported format (currently: PDF only), either through a File URL, a File ID (using the [OpenAI Files API](https://platform.openai.com/docs/api-reference/files)) or by passing binary data from an earlier node in your workflow.
  - For any message type, you can choose from one of these roles:
    - **User**: Sends a message as a user and gets a response from the model.
    - **Assistant**: Tells the model to adopt a specific tone or personality.
    - **System**: By default, the system message is `"You are a helpful assistant"`. You can define instructions in the user message, but the instructions set in the system message are more effective. You can only set one system message per conversation. Use this to set the model's behavior or context for the next user message.
- **Simplify Output**: Turn on to return a simplified version of the response instead of the raw data.

The OpenAI Responses API provides a range of [built-in tools](https://platform.openai.com/docs/guides/tools) to enrich the model's response:

- **Web Search**: Allows models to search the web for the latest information before generating a response.
- **MCP Servers**: Allows models to connect to remote MCP servers. Find out more about using remote MCP servers as tools [here](https://platform.openai.com/docs/guides/tools-connectors-mcp).
- **File Search**: Allow models to search your knowledgebase from previously uploaded files for relevant information before generating a response. Refer to the [OpenAI documentation](https://platform.openai.com/docs/guides/tools-file-search) for more information.
- **Code Interpreter**: Allows models to write and run Python code in a sandboxed environment.

- **Maximum Number of Tokens**: Set the maximum number of tokens for the response. One token is roughly four characters for standard English text. Use this to limit the length of the output.
- **Output Randomness (Temperature)**: Adjust the randomness of the response. The range is between `0.0` (deterministic) and `1.0` (maximum randomness). We recommend altering this or **Output Randomness (Top P)** but not both. Start with a medium temperature (around `0.7`) and adjust based on the outputs you observe. If the responses are too repetitive or rigid, increase the temperature. If they’re too chaotic or off-track, decrease it. Defaults to `1.0`.
- **Output Randomness (Top P)**: Adjust the Top P setting to control the diversity of the assistant's responses. For example, `0.5` means half of all likelihood-weighted options are considered. We recommend altering this or **Output Randomness (Temperature)** but not both. Defaults to `1.0`.
- **Conversation ID**: The conversation that this response belongs to. Input items and output items from this response are automatically added to this conversation after this response completes.
- **Previous Response ID**: The ID of the previous response to continue from. Can't be used in conjunction with Conversation ID.
- **Reasoning**: The level of reasoning effort the model should spend to generate the response. Includes the ability to return a **Summary** of the reasoning performed by the model (for example, for debugging purposes).
- **Store**: Whether to store the generated model response for later retrieval via API. Defaults to `true`.
- **Output Format**: Whether to return the response as **Text**, in a specified **JSON Schema** or as a **JSON Object**.
- **Background**: Whether to run the model in [background mode](https://platform.openai.com/docs/guides/background). This allows executing long-running tasks more reliably.

Refer to [Responses | OpenAI](https://platform.openai.com/docs/api-reference/responses/create) documentation for more information.

## Classify Text for Violations

Use this operation to identify and flag content that might be harmful. OpenAI model will analyze the text and return a response containing:

- `flagged`: A boolean field indicating if the content is potentially harmful.
- `categories`: A list of category-specific violation flags.
- `category_scores`: Scores for each category.

Enter these parameters:

- **Credential to connect with**: Create or select an existing [OpenAI credential](../../../credentials/openai/).
- **Resource**: Select **Text**.
- **Operation**: Select **Classify Text for Violations**.
- **Text Input**: Enter text to classify if it violates the moderation policy.
- **Simplify Output**: Turn on to return a simplified version of the response instead of the raw data.

- **Use Stable Model**: Turn on to use the stable version of the model instead of the latest version, accuracy may be slightly lower.

Refer to [Moderations | OpenAI](https://platform.openai.com/docs/api-reference/moderations) documentation for more information.

For common errors or issues and suggested resolution steps, refer to [Common Issues](../common-issues/).

---

## HTTP request helper for node builders

**URL:** llms-txt#http-request-helper-for-node-builders

**Contents:**
- Usage
- Example
- Deprecation of the previous helper
- Migration guide to the new helper

n8n provides a flexible helper for making HTTP requests, which abstracts away most of the complexity.

Programmatic style only

The information in this document is for node building using the programmatic style. It doesn't apply to declarative style nodes.

Call the helper inside the `execute` function.

`options` is an object:

`url` is required. The other fields are optional. The default method is `GET`.

Some notes about the possible fields:

- `body`: you can use a regular JavaScript object for JSON payload, a buffer for file uploads, an instance of FormData for `multipart/form-data`, and `URLSearchParams` for `application/x-www-form-urlencoded`.
- `headers`: a key-value pair.
  - If `body` is an instance of `FormData` then n8n adds `content-type: multipart/form-data` automatically.
  - If `body` is an instance of `URLSearchParams`, then n8n adds `content-type: application/x-www-form-urlencoded`.
  - To override this behavior, set a `content-type` header.
- `arrayFormat`: if your query string contains an array of data, such as `const qs = {IDs: [15,17]}`, the value of `arrayFormat` defines how n8n formats it.
  - `indices` (default): `{ a: ['b', 'c'] }` as `a[0]=b&a[1]=c`
  - `brackets`: `{ a: ['b', 'c'] }` as `a[]=b&a[]=c`
  - `repeat`: `{ a: ['b', 'c'] }` as `a=b&a=c`
  - `comma`: `{ a: ['b', 'c'] }` as `a=b,c`
- `auth`: Used for Basic auth. Provide `username` and `password`. n8n recommends omitting this, and using `helpers.httpRequestWithAuthentication(...)` instead.
- `disableFollowRedirect`: By default, n8n follows redirects. You can set this to true to prevent this from happening.
- `skipSslCertificateValidation`: Used for calling HTTPS services without proper certificate
- `returnFullResponse`: Instead of returning just the body, returns an object with more data in the following format: `{body: body, headers: object, statusCode: 200, statusMessage: 'OK'}`
- `encoding`: n8n can detect the content type, but you can specify `arrayBuffer` to receive a Buffer you can read from and interact with.

For an example, refer to the [Mattermost node](https://github.com/n8n-io/n8n/blob/master/packages/nodes-base/nodes/Mattermost/v1/MattermostV1.node.ts).

## Deprecation of the previous helper

The previous helper implementation using `this.helpers.request(options)` used and exposed the `request-promise` library. This was removed in version 1.

To minimize incompatibility, n8n made a transparent conversion to another library called `Axios`.

If you are having issues, please report them in the [Community Forums](https://community.n8n.io/) or on [GitHub](https://github.com/n8n-io/n8n/issues).

## Migration guide to the new helper

The new helper is much more robust, library agnostic, and easier to use.

New nodes should all use the new helper. You should strongly consider migrating existing custom nodes to the new helper. These are the main considerations when migrating:

- Accepts `url`. Doesn't accept `uri`.
- `encoding: null` now must be `encoding: arrayBuffer`.
- `rejectUnauthorized: false` is now `skipSslCertificateValidation: true`
- Use `body` according to `content-type` headers to clarify the payload.
- `resolveWithFullResponse` is now `returnFullResponse` and has similar behavior

**Examples:**

Example 1 (unknown):
```unknown
// If no auth needed
const response = await this.helpers.httpRequest(options);

// If auth needed
const response = await this.helpers.httpRequestWithAuthentication.call(
	this, 
	'credentialTypeName', // For example: pipedriveApi
	options,
);
```

Example 2 (unknown):
```unknown
{
	url: string;
	headers?: object;
	method?: 'GET' | 'POST' | 'PUT' | 'DELETE' | 'HEAD';
	body?: FormData | Array | string | number | object | Buffer | URLSearchParams;
	qs?: object;
	arrayFormat?: 'indices' | 'brackets' | 'repeat' | 'comma';
	auth?: {
		username: string,
		password: string,
	};
	disableFollowRedirect?: boolean;
	encoding?: 'arraybuffer' | 'blob' | 'document' | 'json' | 'text' | 'stream';
	skipSslCertificateValidation?: boolean;
	returnFullResponse?: boolean;
	proxy?: {
		host: string;
		port: string | number;
		auth?: {
			username: string;
			password: string;
		},
		protocol?: string;
	};
	timeout?: number;
	json?: boolean;
}
```

---

## Insights

**URL:** llms-txt#insights

**Contents:**
- Insights summary banner
- Insights dashboard
- Insights time periods
- Setting the time saved by a workflow
- Disable or configure insights metrics collection
- Insights FAQs
  - Which executions do n8n use to calculate the values in the insights banner and dashboard?
  - Does n8n use historic execution data when upgrading to a version with insights?

Insights gives instance owners and admins visibility into how workflows perform over time. This feature consists of three parts:

- [**Insights summary banner**](#insights-summary-banner): Shows key metrics about your instance from the last 7 days at the top of the overview space.
- [**Insights dashboard**](#insights-dashboard): A more detailed visual breakdown with per-workflow metrics and historical comparisons.
- [**Time saved (Workflow ROI)**](#setting-the-time-saved-by-a-workflow): For each workflow, you can set the number of minutes of work that each production execution saves you.

The insights summary banner displays activity from the last 7 days for all plans. The insights dashboard is only available on Pro (with limited date ranges) and Enterprise plans.

## Insights summary banner

n8n collects several metrics for both the insights summary banner and dashboard. They include:

- Total production executions (not including sub-workflow executions or manual executions)
- Total failed production executions
- Production execution failure rate
- Time saved (when set on at least one or more active workflows)
- Run time average (including wait time from any wait nodes)

## Insights dashboard

Those on the Pro and Enterprise plans can access the **Insights** section from the side navigation. Each metric from the summary banner is also clickable, taking you to the corresponding chart.

The insights dashboard also has a table showing individual insights from each workflow including total production executions, failed production executions, failure rate, time saved, and run time average.

## Insights time periods

By default, the insights summary banner and dashboard show a rolling 7 day window with a comparison to the previous period to identify increases or decreases for each metric. On the dashboard, paid plans also display data for other date ranges:

- Pro: 7 and 14 days
- Enterprise: 24 hours, 7 days, 14 days, 30 days, 90 days, 6 months, 1 year

## Setting the time saved by a workflow

For each workflow, you can set the number of minutes of work a workflow saves you each time it runs. You can configure this by navigating to the workflow, selecting the three dots menu in the top right and selecting settings. There you can update the **Estimated time saved** value and save.

This setting helps you calculate how much time automating a process saves over time vs the manual effort to complete the same task or process. Once set, n8n calculates the amount of time the workflow saves you based on the number of production executions and displays it on the summary banner and dashboard.

## Disable or configure insights metrics collection

If you self-host n8n, you can disable or configure insights and metrics collection using [environment variables](../hosting/configuration/environment-variables/insights/).

### Which executions do n8n use to calculate the values in the insights banner and dashboard?

n8n insights only collects data from production executions (for example, those from active workflows triggered on a schedule or a webhook) from the main (parent) workflow. This means that it doesn't count manual (test) executions or executions from sub-workflows or error workflows.

### Does n8n use historic execution data when upgrading to a version with insights?

n8n only starts collecting data for insights once you update to the first supported version (1.89.0). This means it only reports on executions from that point forward and you won't see execution data in insights from prior periods.

---

## Manage users with SAML

**URL:** llms-txt#manage-users-with-saml

**Contents:**
- Exempt users from SAML
- Deleting users

- Available on Enterprise plans.
- You need to be an instance owner or admin to enable and configure SAML.

There are some user management tasks that are affected by SAML.

## Exempt users from SAML

You can allow users to log in without using SAML. To do this:

1. Go to **Settings** > **Users**.
1. Select the menu icon by the user you want to exempt from SAML.
1. Select **Allow Manual Login**.

If you remove a user from your IdP, they remain logged in to n8n. You need to manually remove them from n8n as well. Refer to [Manage users](../../manage-users/) for guidance on deleting users.

---

## Okta Workforce Identity SAML setup

**URL:** llms-txt#okta-workforce-identity-saml-setup

**Contents:**
- Prerequisites
- Setup

Set up SAML SSO in n8n with Okta.

Workforce Identity and Customer Identity

This guide covers setting up Workforce Identity. This is the original Okta product. Customer Identity is Okta's name for Auth0, which they've acquired.

You need an Okta Workforce Identity account, and the redirect URL and entity ID from n8n's SAML settings.

Okta Workforce may enforce two factor authentication for users, depending on your Okta configuration.

Read the [Set up SAML](../setup/) guide first.

1. In your Okta admin panel, select **Applications** > **Applications**.

1. Select **Create App Integration**. Okta opens the app creation modal.

1. Select **SAML 2.0**, then select **Next**.

1. On the **General Settings** tab, enter `n8n` as the **App name**.

1. On the **Configure SAML** tab, complete the following **General** fields:

- **Single sign-on URL**: the **Redirect URL** from n8n.
   - **Audience URI (SP Entity ID)**: the **Entity ID** from n8n.
   - **Default RelayState**: leave this empty.
   - **Name ID format**: `EmailAddress`.
   - **Application username**: `Okta username`.
   - **Update application username on**: `Create and update`.

1. Create **Attribute Statements**:

| **Name**                                                             | **Name format** | **Value**      |
   | -------------------------------------------------------------------- | --------------- | -------------- |
   | `http://schemas.xmlsoap.org/ws/2005/05/identity/claims/firstname`    | URI Reference   | user.firstName |
   | `http://schemas.xmlsoap.org/ws/2005/05/identity/claims/lastname`     | URI Reference   | user.lastName  |
   | `http://schemas.xmlsoap.org/ws/2005/05/identity/claims/upn`          | URI Reference   | user.login     |
   | `http://schemas.xmlsoap.org/ws/2005/05/identity/claims/emailaddress` | URI Reference   | user.email     |

1. Select **Next**. Okta may prompt you to complete a marketing form, or may take you directly to your new n8n Okta app.

1. Assign the n8n app to people:

1. On the n8n app dashboard in Okta, select **Assignments**.
   1. Select **Assign** > **Assign to People**. Okta displays a modal with a list of available people.
   1. Select **Assign** next to the person you want to add. Okta displays a prompt to confirm the username.
   1. Leave the username as email address. Select **Save and Go Back**.
   1. Select **Done**.

1. Get the metadata XML: on the **Sign On** tab, copy the Metadata URL. Navigate to it, and copy the XML. Paste this into **Identity Provider Settings** in n8n.

1. Select **Save settings**.

1. Select **Test settings**. n8n opens a new tab. If you're not currently logged in, Okta prompts you to sign in. n8n then displays a success message confirming the attributes returned by Okta.

---

## Notion node

**URL:** llms-txt#notion-node

**Contents:**
- Operations
- Templates and examples
- Related resources
- What to do if your operation isn't supported
- Common issues

Use the Notion node to automate work in Notion, and integrate Notion with other applications. n8n has built-in support for a wide range of Notion features, including getting and searching databases, creating pages, and getting users.

On this page, you'll find a list of operations the Notion node supports and links to more resources.

Refer to [Notion credentials](../../credentials/notion/) for guidance on setting up authentication.

This node can be used as an AI tool

This node can be used to enhance the capabilities of an AI agent. When used in this way, many parameters can be set automatically, or with information directed by AI - find out more in the [AI tool parameters documentation](../../../../advanced-ai/examples/using-the-fromai-function/).

- Block
  - Append After
  - Get Child Blocks
- Database
  - Get
  - Get Many
  - Search
- Database Page
  - Create
  - Get
  - Get Many
  - Update
- Page
  - Archive
  - Create
  - Search
- User
  - Get
  - Get Many

## Templates and examples

**Transcribe Audio Files, Summarize with GPT-4, and Store in Notion**

[View template details](https://n8n.io/workflows/2178-transcribe-audio-files-summarize-with-gpt-4-and-store-in-notion/)

**Host Your Own AI Deep Research Agent with n8n, Apify and OpenAI o3**

[View template details](https://n8n.io/workflows/2878-host-your-own-ai-deep-research-agent-with-n8n-apify-and-openai-o3/)

**Notion AI Assistant Generator**

[View template details](https://n8n.io/workflows/2415-notion-ai-assistant-generator/)

[Browse Notion integration templates](https://n8n.io/integrations/notion/), or [search all templates](https://n8n.io/workflows/)

n8n provides an app node for Notion. You can find the trigger node docs [here](../../trigger-nodes/n8n-nodes-base.notiontrigger/).

Refer to [Notion's documentation](https://developers.notion.com/) for details about their API.

## What to do if your operation isn't supported

If this node doesn't support the operation you want to do, you can use the [HTTP Request node](../../core-nodes/n8n-nodes-base.httprequest/) to call the service's API.

You can use the credential you created for this service in the HTTP Request node:

1. In the HTTP Request node, select **Authentication** > **Predefined Credential Type**.
1. Select the service you want to connect to.
1. Select your credential.

Refer to [Custom API operations](../../../custom-operations/) for more information.

For common errors or issues and suggested resolution steps, refer to [Common issues](common-issues/).

---

## Allows usage of all builtin modules

**URL:** llms-txt#allows-usage-of-all-builtin-modules

export NODE_FUNCTION_ALLOW_BUILTIN=*

---

## Enable modules in Code node

**URL:** llms-txt#enable-modules-in-code-node

For security reasons, the Code node restricts importing modules. It's possible to lift that restriction for built-in and external modules by setting the following environment variables:

- `NODE_FUNCTION_ALLOW_BUILTIN`: For built-in modules
- `NODE_FUNCTION_ALLOW_EXTERNAL`: For external modules sourced from n8n/node_modules directory. External module support is disabled when an environment variable isn't set.

---

## Grafana node

**URL:** llms-txt#grafana-node

**Contents:**
- Operations
- Templates and examples
- What to do if your operation isn't supported

Use the Grafana node to automate work in Grafana, and integrate Grafana with other applications. n8n has built-in support for a wide range of Grafana features, including creating, updating, deleting, and getting dashboards, teams, and users.

On this page, you'll find a list of operations the Grafana node supports and links to more resources.

Refer to [Grafana credentials](../../credentials/grafana/) for guidance on setting up authentication.

This node can be used as an AI tool

This node can be used to enhance the capabilities of an AI agent. When used in this way, many parameters can be set automatically, or with information directed by AI - find out more in the [AI tool parameters documentation](../../../../advanced-ai/examples/using-the-fromai-function/).

- Dashboard
  - Create a dashboard
  - Delete a dashboard
  - Get a dashboard
  - Get all dashboards
  - Update a dashboard
- Team
  - Create a team
  - Delete a team
  - Get a team
  - Retrieve all teams
  - Update a team
- Team Member
  - Add a member to a team
  - Retrieve all team members
  - Remove a member from a team
- User
  - Delete a user from the current organization
  - Retrieve all users in the current organization
  - Update a user in the current organization

## Templates and examples

**Set DevOps Infrastructure with Docker, K3s, Jenkins & Grafana for Linux Servers**

[View template details](https://n8n.io/workflows/6140-set-devops-infrastructure-with-docker-k3s-jenkins-and-grafana-for-linux-servers/)

**🛠️ Grafana Tool MCP Server 💪 all 16 operations**

[View template details](https://n8n.io/workflows/5245-grafana-tool-mcp-server-all-16-operations/)

**Deploy Docker Grafana, API Backend for WHMCS/WISECP**

[View template details](https://n8n.io/workflows/4011-deploy-docker-grafana-api-backend-for-whmcswisecp/)

[Browse Grafana integration templates](https://n8n.io/integrations/grafana/), or [search all templates](https://n8n.io/workflows/)

## What to do if your operation isn't supported

If this node doesn't support the operation you want to do, you can use the [HTTP Request node](../../core-nodes/n8n-nodes-base.httprequest/) to call the service's API.

You can use the credential you created for this service in the HTTP Request node:

1. In the HTTP Request node, select **Authentication** > **Predefined Credential Type**.
1. Select the service you want to connect to.
1. Select your credential.

Refer to [Custom API operations](../../../custom-operations/) for more information.

---

## Jira Trigger node

**URL:** llms-txt#jira-trigger-node

[Jira](https://www.atlassian.com/software/jira) is a proprietary issue tracking product developed by Atlassian that allows bug tracking and agile project management.

You can find authentication information for this node [here](../../credentials/jira/).

Examples and templates

For usage examples and templates to help you get started, refer to n8n's [Jira trigger integrations](https://n8n.io/integrations/jira-trigger/) page.

---

## Slack Trigger node

**URL:** llms-txt#slack-trigger-node

**Contents:**
- Events
- Parameters
- Options
- Related resources
- Required scopes
- Verify the webhook
- Common issues
  - Workflow only works in testing or production
  - Token expired

Use the Slack Trigger node to respond to events in [Slack](https://slack.com/) and integrate Slack with other applications. n8n has built-in support for a wide range of Slack events, including new messages, reactions, and new channels.

On this page, you'll find a list of events the Slack Trigger node can respond to and links to more resources.

You can find authentication information for this node [here](../../credentials/slack/).

Examples and templates

For usage examples and templates to help you get started, refer to n8n's [Slack integrations](https://n8n.io/integrations/slack-trigger/) page.

- **Any Event**: The node triggers on any event in Slack.
- **Bot / App Mention**: The node triggers when your bot or app is [mentioned](https://slack.com/help/articles/205240127-Use-mentions-in-Slack) in a channel the app is in.
- **File Made Public**: The node triggers when a file is [made public](https://slack.com/help/articles/4412651915539-Manage-public-file-sharing).
- **File Shared**: The node triggers when a file is [shared](https://slack.com/help/articles/201330736-Add-files-to-Slack) in a channel the app is in.
- **New Message Posted to Channel**: The node triggers when a new message is posted to a channel the app is in.
- **New Public Channel Created**: The node triggers when a new [public channel](https://slack.com/help/articles/360017938993-What-is-a-channel) is created.
- **New User**: The node triggers when a new user is added to Slack.
- **Reaction Added**: The node triggers when a [reaction](https://slack.com/help/articles/202931348-Use-emoji-and-reactions) is added to a message the app is added to.

Once you've set the events to trigger on, use the remaining parameters to further define the node's behavior:

- **Watch Whole Workspace**: Whether the node should watch for the selected **Events** in all channels in the workspace (turned on) or not (turned off, default).

This will use one execution for every event in any channel your bot or app is in. Use with caution!

- **Channel to Watch**: Select the channel your node should watch for the selected **Events**. This parameter only appears if you don't turn on **Watch Whole Workspace**. You can select a channel:

- **From list**: The node uses your credential to look up a list of channels in the workspace so you can select the channel you want.
  - **By ID**: Enter the ID of a channel you want to watch. Slack displays the channel ID at the bottom of the channel details with a one-click copy button.
  - **By URL**: Enter the URL of the channel you want to watch, formatted as `https://app.slack.com/client/<channel-address>`.

- **Download Files**: Whether to download files and use them in the node's output (turned on) or not (turned off, default). Use this parameter with the **File Made Public** and **File Shared** events.

You can further refine the node's behavior when you **Add Option**s:

- **Resolve IDs**: Whether to resolve the IDs to their respective names and return them (turned on) or not (turned off, default).
- **Usernames or IDs to ignore**: Select usernames or enter a comma-separated string of encoded user IDs to ignore events from. Choose from the list, or specify IDs using an [expression](../../../../code/expressions/).

n8n provides an app node for Slack. You can find the node docs [here](../../app-nodes/n8n-nodes-base.slack/).

View [example workflows and related content](https://n8n.io/integrations/slack-trigger/) on n8n's website.

Refer to [Slack's documentation](https://api.slack.com/apis/connections/events-api) for details about their API.

To use this node, you need to create an application in Slack and enable event subscriptions. Refer to [Slack credentials | Slack Trigger configuration](../../credentials/slack/#slack-trigger-configuration) for more information.

You must add the appropriate scopes to your Slack app for this trigger node to work.

The node requires scopes for the [conversations.list](https://api.slack.com/methods/conversations.list) and [users.list](https://api.slack.com/methods/users.list) methods at minimum. Check out the [Scopes | Slack credentials](../../credentials/slack/#scopes) list for a more complete list of scopes.

## Verify the webhook

From [version `1.106.0`](../../../../release-notes/#n8n11060), you can set a [Slack Signing Secret](https://api.slack.com/authentication/verifying-requests-from-slack#signing_secrets_admin_page) when configuring your [Slack credentials](../../credentials/slack/#slack-trigger-configuration). When set, the Slack trigger node automatically verifies that requests are from Slack and include a trusted signature. n8n recommends setting this to ensure you only process requests sent from Slack.

Here are some common errors and issues with the Slack Trigger node and steps to resolve or troubleshoot them.

### Workflow only works in testing or production

Slack only allows you to register a single webhook per app. This means that you can't switch from using the testing URL to the production URL (and vice versa) without reconfiguring the registered webhook URL.

You may have trouble with this if you try to test a workflow that's also active in production. Slack will only send events to one of the two webhook URLs, so the other will never receive event notifications.

To work around this, you can disable your workflow when testing:

Halts production traffic

This temporarily disables your production workflow for testing. Your workflow will no longer receive production traffic while it's deactivated.

1. Go to your workflow page.
1. Toggle the **Active** switch in the top panel to disable the workflow temporarily.
1. Edit the **Request URL** in your the [Slack Trigger configuration](../../credentials/slack/#slack-trigger-configuration) to use the testing webhook URL instead of the production webhook URL.
1. Test your workflow using the test webhook URL.
1. When you finish testing, edit the **Request URL** in your the [Slack Trigger configuration](../../credentials/slack/#slack-trigger-configuration) to use the production webhook URL instead of the testing webhook URL.
1. Toggle the **Inactive** toggle to enable the workflow again. The production webhook URL should resume working.

Slack offers **token rotation** that you can turn on for bot and user tokens. This makes every tokens expire after 12 hours. While this may be useful for testing, n8n credentials using tokens with this enabled will fail after expiry. If you want to use your Slack credentials in production, this feature must be **off**.

To check if your Slack app has token rotation turned on, refer to the [Slack API Documentation | Token Rotation](https://api.slack.com/authentication/rotation).

If your app uses token rotation

Please note, if your Slack app uses token rotation, you can't turn it off again. You need to create a new Slack app with token rotation disabled instead.

---

## Dynatrace credentials

**URL:** llms-txt#dynatrace-credentials

**Contents:**
- Prerequisites
- Related resources
- Using Access Token

You can use these credentials to authenticate when using the [HTTP Request node](../../core-nodes/n8n-nodes-base.httprequest/) to make a [Custom API call](../../../custom-operations/).

Create a [Dynatrace](https://www.dynatrace.com/signup/) account.

Refer to [Dynatrace's API documentation](https://docs.dynatrace.com/docs/dynatrace-api) for more information about authenticating with the service.

This is a credential-only node. Refer to [Custom API operations](../../../custom-operations/) to learn more. View [example workflows and related content](https://n8n.io/integrations/dynatrace-api/) on n8n's website.

## Using Access Token

To configure this credential, you'll need:

- An **Access Token**

Refer to [Access Tokens](https://docs.dynatrace.com/docs/manage/identity-access-management/access-tokens-and-oauth-clients/access-tokens) on Dynatrace's website for more information.

---

## SeaTable credentials

**URL:** llms-txt#seatable-credentials

**Contents:**
- Prerequisites
- Supported authentication methods
- Related resources
- Using API key

You can use these credentials to authenticate the following nodes:

- [SeaTable](../../app-nodes/n8n-nodes-base.seatable/)
- [SeaTable Trigger](../../trigger-nodes/n8n-nodes-base.seatabletrigger/)

Create a [SeaTable](https://seatable.io/en/) account on either a cloud or self-hosted SeaTable server.

## Supported authentication methods

Refer to [SeaTable's API documentation](https://api.seatable.io) for more information about the service.

To configure this credential, you'll need:

- An **Environment**: Select the environment that matches your SeaTable instance:
  - **Cloud-Hosted**
  - **Self-Hosted**
- An **API Token (of a Base)**: Generate a **Base-Token** in SeaTable from the base options > **Advanced > API Token**.
  - Use **Read-Write** permission for your token.
  - Refer to [Creating an API token](https://seatable.io/en/docs/seatable-api/erzeugen-eines-api-tokens/) for more information.
- A **Timezone**: Select the timezone of your SeaTable server.

---

## Item linking for node creators

**URL:** llms-txt#item-linking-for-node-creators

Programmatic-style nodes only

This guidance applies to programmatic-style nodes. If you're using declarative style, n8n handles paired items for you automatically.

Use n8n's item linking to access data from items that precede the current item. n8n needs to know which input item a given output item comes from. If this information is missing, expressions in other nodes may break. As a node developer, you must ensure any items returned by your node support this.

This applies to programmatic nodes (including trigger nodes). You don't need to consider item linking when building a declarative-style node. Refer to [Choose your node building approach](../../../../integrations/creating-nodes/plan/choose-node-method/) for more information on node styles.

Start by reading [Item linking concepts](../item-linking-concepts/), which provides a conceptual overview of item linking, and details of the scenarios where n8n can handle the linking automatically.

If you need to handle item linking manually, do this by setting `pairedItem` on each item your node returns:

**Examples:**

Example 1 (unknown):
```unknown
// Use the pairedItem information of the incoming item
newItem = {
	"json": { . . . },
	"pairedItem": {
		"item": item.pairedItem,
		// Optional: choose the input to use
		// Set this if your node combines multiple inputs
		"input": 0
};

// Or set the index manually
newItem = {
		"json": { . . . }
		"pairedItem": {
			"item": i,
			// Optional: choose the input to use
			// Set this if your node combines multiple inputs
			"input": 0
		},
};
```

---

## JotForm credentials

**URL:** llms-txt#jotform-credentials

**Contents:**
- Supported authentication methods
- Related resources
- Using API key

You can use these credentials to authenticate the following nodes:

- [JotForm Trigger](../../trigger-nodes/n8n-nodes-base.jotformtrigger/)

## Supported authentication methods

Refer to [JotForm's API documentation](https://api.jotform.com/docs/) for more information about the service.

To configure this credential, you'll need a [JotForm](https://www.jotform.com/) account and:

- An **API Key**
- The **API Domain**

1. Go to **Settings >** [**API**](https://www.jotform.com/myaccount/api).
1. Select **Create New Key**.
1. Select the **Name** in JotForm to update the API key name to something meaningful, like `n8n integration`.
1. Copy the **API Key** and enter it in your n8n credential.
1. In n8n, select the **API Domain** that applies to you based on the forms you're using:
   - **api.jotform.com**: Use this unless the other form types apply to you.
   - **eu-api.jotform.com**: Select this if you're using JotForm [EU Safe Forms](https://www.jotform.com/eu-safe-forms/).
   - **hipaa-api.jotform.com**: Select this if you're using JotForm [HIPAA forms](https://www.jotform.com/hipaa/).

Refer to the [JotForm API documentation](https://api.jotform.com/docs/) for more information on creating keys and API domains.

---

## Gmail node Thread Operations

**URL:** llms-txt#gmail-node-thread-operations

**Contents:**
- Add Label to a thread
- Delete a thread
- Get a thread
  - Get thread options
- Get Many threads
  - Get Many threads filters
- Remove label from a thread
- Reply to a message
  - Reply options
- Trash a thread

Use the Thread operations to delete, reply to, trash, untrash, add/remove labels, get one, or list threads. Refer to the [Gmail node](../) for more information on the Gmail node itself.

## Add Label to a thread

Use this operation to create a new draft.

Enter these parameters:

- Select the **Credential to connect with** or create a new one.
- **Resource**: Select **Thread**.
- **Operation**: Select **Add Label**.
- **Thread ID**: Enter the ID of the thread you want to add the label to.
- **Label Names or IDs**: Select the Label names you want to apply or enter an expression to specify IDs. The dropdown populates based on the **Credential** you selected.

Refer to the [Gmail API Method: users.threads.modify](https://developers.google.com/gmail/api/reference/rest/v1/users.threads/modify) documentation for more information.

Use this operation to immediately and permanently delete a thread and all its messages.

This operation can't be undone. For recoverable deletions, use the [Trash operation](#trash-a-thread) instead.

Enter these parameters:

- Select the **Credential to connect with** or create a new one.
- **Resource**: Select **Thread**.
- **Operation**: Select **Delete**.
- **Thread ID**: Enter the ID of the thread you want to delete.

Refer to the [Gmail API Method: users.threads.delete](https://developers.google.com/gmail/api/reference/rest/v1/users.threads/delete) documentation for more information.

Use this operation to get a single thread.

Enter these parameters:

- Select the **Credential to connect with** or create a new one.
- **Resource**: Select **Thread**.
- **Operation**: Select **Get**.
- **Thread ID**: Enter the ID of the thread you wish to retrieve.
- **Simplify**: Choose whether to return a simplified version of the response (turned on) or the raw data (turned off). Default is on.
  - This is the same as setting the `format` for the API call to `metadata`, which returns email message IDs, labels, and email headers, including: From, To, CC, BCC, and Subject.

### Get thread options

Use these options to further refine the node's behavior:

- **Return Only Messages**: Choose whether to return only thread messages (turned on).

Refer to the [Gmail API Method: users.threads.get](https://developers.google.com/gmail/api/reference/rest/v1/users.threads/get) documentation for more information.

Use this operation to get two or more threads.

Enter these parameters:

- Select the **Credential to connect with** or create a new one.
- **Resource**: Select **Thread**.
- **Operation**: Select **Get Many**.
- **Return All**: Choose whether the node returns all threads (turned on) or only up to a set limit (turned off).
- **Limit**: Enter the maximum number of threads to return. Only used if you've turned off **Return All**.

### Get Many threads filters

Use these filters to further refine the node's behavior:

- **Include Spam and Trash**: Select whether the node should get threads in the Spam and Trash folders (turned on) or not (turned off).
- **Label Names or IDs**: Only return threads with the selected labels added to them. Select the Label names you want to apply or enter an expression to specify IDs. The dropdown populates based on the **Credential** you selected.
- **Search**: Enter Gmail search refine filters, like `from:`, to filter the threads returned. Refer to [Refine searches in Gmail](https://support.google.com/mail/answer/7190?hl=en) for more information.
- **Read Status**: Choose whether to receive **Unread and read emails**, **Unread emails only** (default), or **Read emails only**.
- **Received After**: Return only those emails received after the specified date and time. Use the date picker to select the day and time or enter an expression to set a date as a string in ISO format or a timestamp in milliseconds. Refer to [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) for more information on formatting the string.
- **Received Before**: Return only those emails received before the specified date and time. Use the date picker to select the day and time or enter an expression to set a date as a string in ISO format or a timestamp in milliseconds. Refer to [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) for more information on formatting the string.

Refer to the [Gmail API Method: users.threads.list](https://developers.google.com/gmail/api/reference/rest/v1/users.threads/list) documentation for more information.

## Remove label from a thread

Use this operation to remove a label from a thread.

Enter these parameters:

- Select the **Credential to connect with** or create a new one.
- **Resource**: Select **Thread**.
- **Operation**: Select **Remove Label**.
- **Thread ID**: Enter the ID of the thread you want to remove the label from.
- **Label Names or IDs**: Select the Label names you want to remove or enter an expression to specify their IDs. The dropdown populates based on the **Credential** you selected.

Refer to the [Gmail API Method: users.threads.modify](https://developers.google.com/gmail/api/reference/rest/v1/users.threads/modify) documentation for more information.

## Reply to a message

Use this operation to reply to a message.

Enter these parameters:

- Select the **Credential to connect with** or create a new one.
- **Resource**: Select **Thread**.
- **Operation**: Select **Reply**.
- **Thread ID**: Enter the ID of the thread you want to reply to.
- **Message Snippet or ID**: Select the Message you want to reply to or enter an expression to specify its ID. The dropdown populates based on the **Credential** you selected.
- Select the **Email Type**. Choose from **Text** or **HTML**.
- **Message**: Enter the email message body.

Use these options to further refine the node's behavior:

- **Attachments**: Select **Add Attachment** to add an attachment. Enter the **Attachment Field Name (in Input)** to identify which field from the input node contains the attachment.
  - For multiple properties, enter a comma-separated list.
- **BCC**: Enter one or more email addresses for blind copy recipients. Separate multiple email addresses with a comma, for example `jay@gatsby.com, jon@smith.com`.
- **CC**: Enter one or more email addresses for carbon copy recipients. Separate multiple email addresses with a comma, for example `jay@gatsby.com, jon@smith.com`.
- **Sender Name**: Enter the name you want displayed in your recipients' email as the sender.
- **Reply to Sender Only**: Choose whether to reply all (turned off) or reply to the sender only (turned on).

Refer to the [Gmail API Method: users.messages.send](https://developers.google.com/gmail/api/reference/rest/v1/users.messages/send) documentation for more information.

Use this operation to move a thread and all its messages to the trash.

Enter these parameters:

- Select the **Credential to connect with** or create a new one.
- **Resource**: Select **Thread**.
- **Operation**: Select **Trash**.
- **Thread ID**: Enter the ID of the thread you want to move to the trash.

Refer to the [Gmail API Method: users.threads.trash](https://developers.google.com/gmail/api/reference/rest/v1/users.threads/trash) documentation for more information.

Use this operation to recover a thread and all its messages from the trash.

Enter these parameters:

- Select the **Credential to connect with** or create a new one.
- **Resource**: Select **Thread**.
- **Operation**: Select **Untrash**.
- **Thread ID**: Enter the ID of the thread you want to move to the trash.

Refer to the [Gmail API Method: users.threads.untrash](https://developers.google.com/gmail/api/reference/rest/v1/users.threads/untrash) documentation for more information.

For common errors or issues and suggested resolution steps, refer to [Common Issues](../common-issues/).

---

## Cluster nodes

**URL:** llms-txt#cluster-nodes

**Contents:**
- Root nodes
- Sub-nodes

[Cluster nodes](../../../glossary/#cluster-node-n8n) are node groups that work together to provide functionality in an n8n workflow. Instead of using a single node, you use a [root node](../../../glossary/#root-node-n8n) and one or more [sub-nodes](../../../glossary/#sub-node-n8n) that extend the functionality of the node.

Each cluster starts with one [root node](../../../glossary/#root-node-n8n).

Each root node can have one or more [sub-nodes](../../../glossary/#sub-node-n8n) attached to it.

---

## Workable credentials

**URL:** llms-txt#workable-credentials

**Contents:**
- Prerequisites
- Supported authentication methods
- Related resources
- Using API key

You can use these credentials to authenticate the following nodes:

- [Workable Trigger](../../trigger-nodes/n8n-nodes-base.workabletrigger/)

Create a [Workable](https://www.workable.com/) account.

## Supported authentication methods

Refer to [Workable's API documentation](https://workable.readme.io/reference/generate-an-access-token) for more information about the service.

To configure this credential, you'll need:

- A **Subdomain**: Your Workable subdomain is the part of your Workable domain between `https://` and `.workable.com`. So if the full domain is `https://n8n.workable.com`, the subdomain is `n8n`. The subdomain is also displayed on your Workable **Company Profile** page.

- An **Access Token**: Go to your **profile >** [**Integrations**](https://workable.com/backend/settings/integrations) **> Apps** and select **Generate API token**. Refer to [Generate a new token](https://help.workable.com/hc/en-us/articles/115015785428-Generating-revoking-access-tokens-for-Workable-s-API#Generateanewtoken) for more information.

If you're using this credential with the [Workable Trigger](../../trigger-nodes/n8n-nodes-base.workabletrigger/) node, select the `r_candidates` and `r_jobs` scopes when you generate your token. If you're using this credential in other ways, select scopes that are relevant for your use case.

Refer to [Supported API scopes](https://help.workable.com/hc/en-us/articles/115015785428-Generating-revoking-access-tokens-for-Workable-s-API#SupportedAPIscopes) for more information on scopes.

---

## n8n public REST API

**URL:** llms-txt#n8n-public-rest-api

**Contents:**
- Learn about REST APIs

The n8n API isn't available during the free trial. Please upgrade to access this feature.

Using n8n's public [API](../glossary/#api), you can programmatically perform many of the same tasks as you can in the GUI. This section introduces n8n's REST API, including:

- How to [authenticate](authentication/)
- [Paginating](pagination/) results
- Using the [built-in API playground](using-api-playground/) (self-hosted n8n only)
- [Endpoint reference](api-reference/)

n8n provides an [n8n API node](../integrations/builtin/core-nodes/n8n-nodes-base.n8n/) to access the API in your workflows.

## Learn about REST APIs

The API documentation assumes you are familiar with REST APIs. If you're not, these resources may be helpful:

- [KnowledgeOwl's guide to working with APIs](https://support.knowledgeowl.com/help/working-with-apis): a basic introduction, including examples of how to call REST APIs.
- [IBM Cloud Learn Hub - What is an Application Programming Interface (API)](https://www.ibm.com/cloud/learn/api): this gives a general, but technical, introduction to APIs.
- [IBM Cloud Learn Hub - What is a REST API?](https://www.ibm.com/cloud/learn/rest-apis): more detailed information about REST APIs.
- [MDN web docs - An overview of HTTP](https://developer.mozilla.org/en-US/docs/Web/HTTP/Overview): REST APIs work over HTTP and use HTTP verbs, or methods, to specify the action to perform.

Use the API playground

Trying out the API in the [playground](using-api-playground/) can help you understand how APIs work. If you're worried about changing live data, consider setting up a test workflow, or test n8n instance, to explore safely.

---

## xAI credentials

**URL:** llms-txt#xai-credentials

**Contents:**
- Prerequisites
- Supported authentication methods
- Related resources
- Using API key

You can use these credentials to authenticate the following nodes:

- [Chat xAI Grok](../../cluster-nodes/sub-nodes/n8n-nodes-langchain.lmchatxaigrok/)

Create an [xAI](https://accounts.x.ai/sign-up) account.

## Supported authentication methods

Refer to [xAI's API documentation](https://docs.x.ai/docs/api-reference) for more information about the service.

To configure this credential, you'll need:

- An **API Key**: You can create a new API key on the [xAI Console API Keys page](https://console.x.ai/team/default/api-keys).

Refer to the [The Hitchhiker's Guide to Grok | xAI](https://docs.x.ai/docs/tutorial) for more information.

---

## MailerLite node

**URL:** llms-txt#mailerlite-node

**Contents:**
- Operations
- Templates and examples

Use the MailerLite node to automate work in MailerLite, and integrate MailerLite with other applications. n8n has built-in support for a wide range of MailerLite features, including creating, updating, deleting, and getting subscribers.

On this page, you'll find a list of operations the MailerLite node supports and links to more resources.

Refer to [MailerLite credentials](../../credentials/mailerlite/) for guidance on setting up authentication.

- Subscriber
  - Create a new subscriber
  - Get an subscriber
  - Get all subscribers
  - Update an subscriber

## Templates and examples

**Create, update and get a subscriber using the MailerLite node**

[View template details](https://n8n.io/workflows/751-create-update-and-get-a-subscriber-using-the-mailerlite-node/)

**Receive updates when a subscriber is added to a group in MailerLite**

[View template details](https://n8n.io/workflows/759-receive-updates-when-a-subscriber-is-added-to-a-group-in-mailerlite/)

**Capture Gumroad sales, add buyer to MailerLite group, log to Google Sheets CRM**

[View template details](https://n8n.io/workflows/3676-capture-gumroad-sales-add-buyer-to-mailerlite-group-log-to-google-sheets-crm/)

[Browse MailerLite integration templates](https://n8n.io/integrations/mailerlite/), or [search all templates](https://n8n.io/workflows/)

---

## Bitly node

**URL:** llms-txt#bitly-node

**Contents:**
- Operations
- Templates and examples
- What to do if your operation isn't supported

Use the Bitly node to automate work in Bitly, and integrate Bitly with other applications. n8n has built-in support for a wide range of Bitly features, including creating, getting, and updating links.

On this page, you'll find a list of operations the Bitly node supports and links to more resources.

Refer to [Bitly credentials](../../credentials/bitly/) for guidance on setting up authentication.

- Link
  - Create a link
  - Get a link
  - Update a link

## Templates and examples

**Explore n8n Nodes in a Visual Reference Library**

[View template details](https://n8n.io/workflows/3891-explore-n8n-nodes-in-a-visual-reference-library/)

**Create a URL on Bitly**

[View template details](https://n8n.io/workflows/442-create-a-url-on-bitly/)

**Automate URL Shortening with Bitly Using Llama3 Chat Interface**

[View template details](https://n8n.io/workflows/3885-automate-url-shortening-with-bitly-using-llama3-chat-interface/)

[Browse Bitly integration templates](https://n8n.io/integrations/bitly/), or [search all templates](https://n8n.io/workflows/)

## What to do if your operation isn't supported

If this node doesn't support the operation you want to do, you can use the [HTTP Request node](../../core-nodes/n8n-nodes-base.httprequest/) to call the service's API.

You can use the credential you created for this service in the HTTP Request node:

1. In the HTTP Request node, select **Authentication** > **Predefined Credential Type**.
1. Select the service you want to connect to.
1. Select your credential.

Refer to [Custom API operations](../../../custom-operations/) for more information.

---

## PayPal credentials

**URL:** llms-txt#paypal-credentials

**Contents:**
- Prerequisites
- Supported authentication methods
- Related resources
- Using API client and secret

You can use these credentials to authenticate the following nodes:

- [PayPal](../../app-nodes/n8n-nodes-base.paypal/)
- [PayPal Trigger](../../trigger-nodes/n8n-nodes-base.paypaltrigger/)

Create a [PayPal developer](https://developer.paypal.com/home) account.

## Supported authentication methods

- API client and secret

Refer to [Paypal's API documentation](https://developer.paypal.com/api/rest/) for more information about the service.

## Using API client and secret

To configure this credential, you'll need:

- A **Client ID**: Generated when you create an app.
- A **Secret**: Generated when you create an app.
- An **Environment**: Select **Live** or **Sandbox**.

To generate the **Client ID** and **Secret**, log in to your Paypal [developer dashboard](https://developer.paypal.com/dashboard/). Select **Apps & Credentials > Rest API apps > Create app**. Refer to [Get client ID and client secret](https://developer.paypal.com/api/rest/#link-getclientidandclientsecret) for more information.

---

## Eventbrite Trigger node

**URL:** llms-txt#eventbrite-trigger-node

[Eventbrite](https://www.eventbrite.com/) is an event management and ticketing website. The service allows users to browse, create, and promote local events.

You can find authentication information for this node [here](../../credentials/eventbrite/).

Examples and templates

For usage examples and templates to help you get started, refer to n8n's [Eventbrite Trigger integrations](https://n8n.io/integrations/eventbrite-trigger/) page.

---

## Supabase node common issues

**URL:** llms-txt#supabase-node-common-issues

**Contents:**
- Filtering rows by metadata
- Can't connect to a local Supabase database when using Docker
  - If only Supabase is in Docker
  - If Supabase and n8n are running in separate Docker containers
- Records are accessible through Postgres but not Supabase

Here are some common errors and issues with the [Supabase node](../) and steps to resolve or troubleshoot them.

## Filtering rows by metadata

To filter rows by [Supabase metadata](https://supabase.com/docs/guides/ai/python/metadata), set the **Select Type** to **String**.

From there, you can construct a query in the **Filters (String)** parameter to filter the metadata using the [Supabase metadata query language](https://supabase.com/docs/guides/ai/python/metadata#metadata-query-language), inspired by the [MongoDB selectors](https://www.mongodb.com/docs/manual/reference/operator/query/) format. Access the metadata properties using the [Postgres `->>` arrow JSON operator](https://www.postgresql.org/docs/current/functions-json.html#FUNCTIONS-JSON-PROCESSING) like this (curly brackets denote components to fill in):

For example to access an `age` property in the metadata and return results greater than or equal to 21, you could enter the following in the **Filters (String)** field:

You can combine these operators to construct more complex queries.

## Can't connect to a local Supabase database when using Docker

When you run Supabase in Docker, you need to configure the network so that n8n can connect to Supabase.

The solution depends on how you're hosting the two components.

### If only Supabase is in Docker

If only Supabase is running in Docker, the Docker Compose file used by the [self-hosting guide](https://supabase.com/docs/guides/self-hosting/docker) already runs Supabase bound to the correct interfaces.

When configuring [Supabase credentials](../../../credentials/supabase/), the `localhost` address should work without a problem (set the **Host** to `localhost`).

### If Supabase and n8n are running in separate Docker containers

If both n8n and Supabase are running in Docker in separate containers, you can use Docker networking to connect them.

Configure Supabase to listen on all interfaces by binding to `0.0.0.0` inside of the container (the official [Docker compose configuration](https://supabase.com/docs/guides/self-hosting/docker) already does this this). Add both the Supabase and n8n components to the same [user-defined bridge network](https://docs.docker.com/engine/network/drivers/bridge/) if you aren't already managing them together in the same Docker Compose file.

When configuring [Supabase credentials](../../../credentials/supabase/), use the Supabase API gateway container's name (`supabase-kong` by default) as the host address instead of `localhost`. For example, if you use the default configuration, you would set the **Host** to `http://supabase-kong:8000`.

## Records are accessible through Postgres but not Supabase

If queries for records return empty using the Supabase node, but are available through the [Postgres](../../n8n-nodes-base.postgres/) node or with a Postgres client, there may be a conflict with Supabase's [Row Level Security (RLS)](https://supabase.com/docs/guides/database/postgres/row-level-security) policy.

Supabase always enables RLS when you create a table in a public schema with the Table Editor. When RLS is active, the API doesn't return any data with the public `anon` key until you create policies. This is a security measure to ensure that you only expose data you intend to.

To access data from a table with RLS enabled as the `anon` role, [create a policy](https://supabase.com/docs/guides/database/postgres/row-level-security#creating-policies) to enable the access patterns you intend to use.

**Examples:**

Example 1 (unknown):
```unknown
metadata->>{your-property}={comparison-operator}.{comparison-value}
```

Example 2 (unknown):
```unknown
metadata->>age=gte.21
```

---

## healthz

**URL:** llms-txt#healthz

QUEUE_HEALTH_CHECK_ACTIVE=true
```

Refer to [Configuration methods](../../configuration/configuration-methods/) for more information on how to configure your instance using environment variables.

---

## Cal Trigger node

**URL:** llms-txt#cal-trigger-node

**Contents:**
- Events

[Cal](https://cal.com/) is the event-juggling scheduler for everyone. Focus on meeting, not making meetings.

You can find authentication information for this node [here](../../credentials/cal/).

Examples and templates

For usage examples and templates to help you get started, refer to n8n's [Cal Trigger integrations](https://n8n.io/integrations/cal-trigger/) page.

- Booking cancelled
- Booking created
- Booking rescheduled
- Meeting ended

---

## Data transformation functions

**URL:** llms-txt#data-transformation-functions

**Contents:**
- Usage

Data transformation functions are helper functions to make data transformation easier in [expressions](../../../glossary/#expression-n8n).

JavaScript in expressions

You can use any JavaScript in expressions. Refer to [Expressions](../../expressions/) for more information.

For a list of available functions, refer to the page for your data type:

- [Arrays](arrays/)
- [Dates](dates/)
- [Numbers](numbers/)
- [Objects](objects/)
- [Strings](strings/)

Data transformation functions are available in the expressions editor.

For example, to check if a string is an email:

**Examples:**

Example 1 (unknown):
```unknown
{{ dataItem.function() }}
```

Example 2 (unknown):
```unknown
{{ "example@example.com".isEmail() }}

// Returns true
```

---

## Spotify node

**URL:** llms-txt#spotify-node

**Contents:**
- Operations
- Templates and examples
- What to do if your operation isn't supported

Use the Spotify node to automate work in Spotify, and integrate Spotify with other applications. n8n has built-in support for a wide range of Spotify features, including getting album and artist information.

On this page, you'll find a list of operations the Spotify node supports and links to more resources.

Refer to [Spotify credentials](../../credentials/spotify/) for guidance on setting up authentication.

- Album
  - Get an album by URI or ID.
  - Get a list of new album releases.
  - Get an album's tracks by URI or ID.
  - Search albums by keyword.
- Artist
  - Get an artist by URI or ID.
  - Get an artist's albums by URI or ID.
  - Get an artist's related artists by URI or ID.
  - Get an artist's top tracks by URI or ID.
  - Search artists by keyword.
- Library
  - Get the user's liked tracks.
- My Data
  - Get your followed artists.
- Player
  - Add a song to your queue.
  - Get your currently playing track.
  - Skip to your next track.
  - Pause your music.
  - Skip to your previous song.
  - Get your recently played tracks.
  - Resume playback on the current active device.
  - Set volume on the current active device.
  - Start playing a playlist, artist, or album.
- Playlist
  - Add tracks from a playlist by track and playlist URI or ID.
  - Create a new playlist.
  - Get a playlist by URI or ID.
  - Get a playlist's tracks by URI or ID.
  - Get a user's playlists.
  - Remove tracks from a playlist by track and playlist URI or ID.
  - Search playlists by keyword.
- Track
  - Get a track by its URI or ID.
  - Get audio features for a track by URI or ID.
  - Search tracks by keyword

## Templates and examples

**Add liked songs to a Spotify monthly playlist**

[View template details](https://n8n.io/workflows/1074-add-liked-songs-to-a-spotify-monthly-playlist/)

**IOT Button Remote / Spotify Control Integration with MQTT**

[View template details](https://n8n.io/workflows/2383-iot-button-remote-spotify-control-integration-with-mqtt/)

**Download recently liked songs automatically with Spotify**

[View template details](https://n8n.io/workflows/2285-download-recently-liked-songs-automatically-with-spotify/)

[Browse Spotify integration templates](https://n8n.io/integrations/spotify/), or [search all templates](https://n8n.io/workflows/)

## What to do if your operation isn't supported

If this node doesn't support the operation you want to do, you can use the [HTTP Request node](../../core-nodes/n8n-nodes-base.httprequest/) to call the service's API.

You can use the credential you created for this service in the HTTP Request node:

1. In the HTTP Request node, select **Authentication** > **Predefined Credential Type**.
1. Select the service you want to connect to.
1. Select your credential.

Refer to [Custom API operations](../../../custom-operations/) for more information.

---

## Incident response

**URL:** llms-txt#incident-response

n8n implements incident response best practices for identifying, documenting, resolving and communicating incidents.

n8n publishes incident notifications to a status page at [n8n Status](https://status.n8n.cloud/).

n8n notifies customers of any data breaches according to the company's [Data Processing Addendum](https://n8n.io/legal/#data).

---

## Code node cookbook

**URL:** llms-txt#code-node-cookbook

**Contents:**
- Related resources

This section contains examples and recipes for tasks you can do with the Code node.

- [Get number of items returned by last node](/code/cookbook/code-node/number-items-last-node/)
- [Get the binary data buffer](/code/cookbook/code-node/get-binary-data-buffer/)
- [Output to the browser console](/code/cookbook/code-node/console-log/)

- [Built-in methods and variables reference](../../builtin/overview/)
- [Code node](../../code-node/)

---

## Discourse node

**URL:** llms-txt#discourse-node

**Contents:**
- Operations
- Templates and examples
- What to do if your operation isn't supported

Use the Discourse node to automate work in Discourse, and integrate Discourse with other applications. n8n has built-in support for a wide range of Discourse features, including creating, getting, updating, and removing categories, groups, posts, and users.

On this page, you'll find a list of operations the Discourse node supports and links to more resources.

Refer to [Discourse credentials](../../credentials/discourse/) for guidance on setting up authentication.

- Category
  - Create a category
  - Get all categories
  - Update a category
- Group
  - Create a group
  - Get a group
  - Get all groups
  - Update a group
- Post
  - Create a post
  - Get a post
  - Get all posts
  - Update a post
- User
  - Create a user
  - Get a user
  - Get all users
- User Group
  - Create a user to group
  - Remove user from group

## Templates and examples

**Enrich new Discourse members with Clearbit then notify in Slack**

[View template details](https://n8n.io/workflows/2109-enrich-new-discourse-members-with-clearbit-then-notify-in-slack/)

**Create, update and get a post via Discourse**

[View template details](https://n8n.io/workflows/930-create-update-and-get-a-post-via-discourse/)

**🛠️ Discourse Tool MCP Server 💪 all 16 operations**

[View template details](https://n8n.io/workflows/5278-discourse-tool-mcp-server-all-16-operations/)

[Browse Discourse integration templates](https://n8n.io/integrations/discourse/), or [search all templates](https://n8n.io/workflows/)

## What to do if your operation isn't supported

If this node doesn't support the operation you want to do, you can use the [HTTP Request node](../../core-nodes/n8n-nodes-base.httprequest/) to call the service's API.

You can use the credential you created for this service in the HTTP Request node:

1. In the HTTP Request node, select **Authentication** > **Predefined Credential Type**.
1. Select the service you want to connect to.
1. Select your credential.

Refer to [Custom API operations](../../../custom-operations/) for more information.

---

## n8n community node blocklist

**URL:** llms-txt#n8n-community-node-blocklist

n8n maintains a blocklist of community nodes. You can't install any node on this list.

n8n may add community nodes to the blocklist for a range of reasons, including:

- The node is intentionally malicious
- It's low quality (low enough to be harmful)

If you are a community node creator whose node is on the blocklist, and you believe this is a mistake, contact \[hello@n8n.io\](mailto: hello@n8n.io).

---

## OpenAI Chat Model node

**URL:** llms-txt#openai-chat-model-node

**Contents:**
- Node parameters
  - Model
  - Built-in Tools
- Node options
  - Base URL
  - Frequency Penalty
  - Maximum Number of Tokens
  - Response Format
  - Presence Penalty
  - Sampling Temperature

Use the OpenAI Chat Model node to use OpenAI's chat models with conversational [agents](../../../../../glossary/#ai-agent).

On this page, you'll find the node parameters for the OpenAI Chat Model node and links to more resources.

You can find authentication information for this node [here](../../../credentials/openai/).

Parameter resolution in sub-nodes

Sub-nodes behave differently to other nodes when processing multiple items using an expression.

Most nodes, including root nodes, take any number of items as input, process these items, and output the results. You can use expressions to refer to input items, and the node resolves the expression for each item in turn. For example, given an input of five `name` values, the expression `{{ $json.name }}` resolves to each name in turn.

In sub-nodes, the expression always resolves to the first item. For example, given an input of five `name` values, the expression `{{ $json.name }}` always resolves to the first name.

Select the model to use to generate the completion.

n8n dynamically loads models from OpenAI, and you'll only see the models available to your account.

The OpenAI Responses API provides a range of [built-in tools](https://platform.openai.com/docs/guides/tools) to enrich the model's response:

- **Web Search**: Allows models to search the web for the latest information before generating a response.
- **MCP Servers**: Allows models to connect to remote MCP servers. Find out more about using remote MCP servers as tools [here](https://platform.openai.com/docs/guides/tools-connectors-mcp).
- **File Search**: Allow models to search your knowledgebase from previously uploaded files for relevant information before generating a response. Refer to the [OpenAI documentation](https://platform.openai.com/docs/guides/tools-file-search) for more information.
- **Code Interpreter**: Allows models to write and run Python code in a sandboxed environment.

Use these options to further refine the node's behavior.

Enter a URL here to override the default URL for the API.

### Frequency Penalty

Use this option to control the chances of the model repeating itself. Higher values reduce the chance of the model repeating itself.

### Maximum Number of Tokens

Enter the maximum number of tokens used, which sets the completion length.

Choose **Text** or **JSON**. **JSON** ensures the model returns valid JSON.

Use this option to control the chances of the model talking about new topics. Higher values increase the chance of the model talking about new topics.

### Sampling Temperature

Use this option to control the randomness of the sampling process. A higher temperature creates more diverse sampling, but increases the risk of hallucinations.

Enter the maximum request time in milliseconds.

Enter the maximum number of times to retry a request.

Use this option to set the probability the completion should use. Use a lower value to ignore less probable options.

The conversation that this response belongs to. Input items and output items from this response are automatically added to this conversation after this response completes.

Use this key for caching similar requests to optimize cache hit rates.

### Safety Identifier

Apply an identifier to track users who may violate usage policies.

Select the service tier that fits your needs: Auto, Flex, Default, or Priority.

A set of key-value pairs for storing structured information. You can attach up to 16 pairs to an object, which is useful for adding custom data that can be used for searching by the API or in the dashboard.

Define an integer between 0 and 20 specifying the number of most likely tokens to return at each token position, each with an associated log probability.

Choose a response format: Text, JSON Schema, or JSON Object. Use of JSON Schema is recommended, if you want to receive data in JSON format.

Configure the prompt filled with a unique ID, its version, and substitutable variables.

Control the reasoning level of AI results: Low, Medium, or High.

## Templates and examples

[View template details](https://n8n.io/workflows/1954-ai-agent-chat/)

**Building Your First WhatsApp Chatbot**

[View template details](https://n8n.io/workflows/2465-building-your-first-whatsapp-chatbot/)

**Scrape and summarize webpages with AI**

[View template details](https://n8n.io/workflows/1951-scrape-and-summarize-webpages-with-ai/)

[Browse OpenAI Chat Model integration templates](https://n8n.io/integrations/openai-chat-model/), or [search all templates](https://n8n.io/workflows/)

Refer to [LangChains's OpenAI documentation](https://js.langchain.com/docs/integrations/chat/openai/) for more information about the service.

Refer to [OpenAI documentation](https://platform.openai.com/docs/api-reference/responses/create) for more information about the parameters.

View n8n's [Advanced AI](../../../../../advanced-ai/) documentation.

For common questions or issues and suggested solutions, refer to [Common issues](common-issues/).

---

## Jenkins node

**URL:** llms-txt#jenkins-node

**Contents:**
- Operations
- Templates and examples

Use the Jenkins node to automate work in Jenkins, and integrate Jenkins with other applications. n8n has built-in support for a wide range of Jenkins features, including listing builds, managing instances, and creating and copying jobs.

On this page, you'll find a list of operations the Jenkins node supports and links to more resources.

Refer to [Jenkins credentials](../../credentials/jenkins/) for guidance on setting up authentication.

This node can be used as an AI tool

This node can be used to enhance the capabilities of an AI agent. When used in this way, many parameters can be set automatically, or with information directed by AI - find out more in the [AI tool parameters documentation](../../../../advanced-ai/examples/using-the-fromai-function/).

- Build
  - List Builds
- Instance
  - Cancel quiet down state
  - Put Jenkins in quiet mode, no builds can be started, Jenkins is ready for shutdown
  - Restart Jenkins immediately on environments where it's possible
  - Restart Jenkins once no jobs are running on environments where it's possible
  - Shutdown once no jobs are running
  - Shutdown Jenkins immediately
- Job
  - Copy a specific job
  - Create a new job
  - Trigger a specific job
  - Trigger a specific job

## Templates and examples

[Browse Jenkins integration templates](https://n8n.io/integrations/jenkins/), or [search all templates](https://n8n.io/workflows/)

---

## Mailcheck credentials

**URL:** llms-txt#mailcheck-credentials

**Contents:**
- Prerequisites
- Supported authentication methods
- Related resources
- Using API Key

You can use these credentials to authenticate the following nodes:

- [Mailcheck](../../app-nodes/n8n-nodes-base.mailcheck/)

Create a [Mailcheck](https://mailcheck.co/) account.

## Supported authentication methods

Refer to [Mailcheck's API documentation](https://app.mailcheck.co/docs?from=docs) for more information about the service.

To configure this credential, you'll need:

- An **API Key**: Generate an API Key in the API section of your dashboard. Refer to [Mailcheck's How to create an API key documentation](https://mailcheck.co/create-api-key) for detailed instructions.

---

## Ghost credentials

**URL:** llms-txt#ghost-credentials

**Contents:**
- Prerequisites
- Supported authentication methods
- Related resources
- Using Admin API key
- Using Content API key

You can use these credentials to authenticate the following nodes:

- [Ghost](../../app-nodes/n8n-nodes-base.ghost/)

Create a [Ghost](https://ghost.org/) account.

## Supported authentication methods

- Admin API key
- Content API key

The keys are generated following the same steps, but the authorization flows and key format are different, so n8n stores the credentials separately. The Content API uses an API key; the Admin API uses an API key to generate a token for authentication.

Refer to Ghost's [Admin API documentation](https://ghost.org/docs/admin-api/) for more information about the Admin API service. Refer to Ghost's [Content API documentation](https://ghost.org/docs/content-api/) for more information about the Content API service.

## Using Admin API key

To configure this credential, you'll need:

- The **URL** of your Ghost admin domain. Your [admin domain](https://ghost.org/docs/admin-api/#base-url) can be different to your main domain and may include a subdirectory. All Ghost(Pro) blogs have a `*.ghost.io` domain as their admin domain and require https.
- An **API Key**: To generate a new API key, create a new Custom Integration. Refer to the [Ghost Admin API Token Authentication Key documentation](https://ghost.org/docs/admin-api/#token-authentication) for more detailed instructions. Copy the **Admin API Key** and use this as the **API Key** in the Ghost Admin n8n credential.

## Using Content API key

To configure this credential, you'll need:

- The **URL** of your Ghost admin domain. Your [admin domain](https://ghost.org/docs/content-api/#url) can be different to your main domain and may include a subdirectory. All Ghost(Pro) blogs have a `*.ghost.io` domain as their admin domain and require https.
- An **API Key**: To generate a new API key, create a new Custom Integration. Refer to the [Ghost Content API Key documentation](https://ghost.org/docs/content-api/#key) for more detailed instructions. Copy the **Content API Key** and use this as the **API Key** in the Ghost Content n8n credential.

---

## PostHog credentials

**URL:** llms-txt#posthog-credentials

**Contents:**
- Prerequisites
- Supported authentication methods
- Related resources
- Using API key

You can use these credentials to authenticate the following nodes:

- [PostHog](../../app-nodes/n8n-nodes-base.posthog/)

Create a [PostHog](https://posthog.com/) account or host PostHog on your server.

## Supported authentication methods

Refer to [PostHog's API documentation](https://posthog.com/docs/api) for more information about the service.

To configure this credential, you'll need:

- The API **URL**: Enter the correct domain for your API requests:
  - On US Cloud, use `https://us.i.posthog.com` for public POST-only endpoints or `https://us.posthog.com` for private endpoints.
  - On EU Cloud, use `https://eu.i.posthog.com` for public POST-only endpoints or `https://eu.posthog.com` for private endpoints.
  - For self-hosted instances, use your self-hosted domain.
  - Confirm yours by checking your PostHog instance URL.
- An **API Key**: The API key you use depends on whether you're accessing public or private endpoints:
  - For public POST-only endpoints, use a [Project API key](https://app.posthog.com/project/settings) from your project's **General** Settings.
  - For private endpoints, use a [Personal API key](https://app.posthog.com/settings/user-api-keys) from your User account's **Personal API Keys** Settings. Refer to [How to obtain a personal API key](https://posthog.com/docs/api#private-endpoint-authentication) for more information.

---

## Custom executions data

**URL:** llms-txt#custom-executions-data

**Contents:**
- Set and access custom data using the Code node
  - Set custom executions data
  - Access the custom data object during execution

You can set custom data on your workflow using the Code node or the [Execution Data node](../../../integrations/builtin/core-nodes/n8n-nodes-base.executiondata/). n8n records this with each execution. You can then use this data when filtering the executions list, or fetch it in your workflows using the Code node.

Custom executions data is available on:

- Cloud: Pro, Enterprise
- Self-Hosted: Enterprise, registered Community

## Set and access custom data using the Code node

This section describes how to set and access data using the Code node. Refer to [Execution Data node](../../../integrations/builtin/core-nodes/n8n-nodes-base.executiondata/) for information on using the Execution Data node to set data. You can't retrieve custom data using the Execution Data node.

### Set custom executions data

Set a single piece of extra data:

Set all extra data. This overwrites the whole custom data object for this execution:

There are limitations:

- They must be strings
- `key` has a maximum length of 50 characters
- `value` has a maximum length of 255 characters
- n8n supports a maximum of 10 items of custom data

### Access the custom data object during execution

You can retrieve the custom data object, or a specific value in it, during an execution:

**Examples:**

Example 1 (unknown):
```unknown
$execution.customData.set("key", "value");
```

Example 2 (unknown):
```unknown
_execution.customData.set("key", "value");
```

Example 3 (unknown):
```unknown
$execution.customData.setAll({"key1": "value1", "key2": "value2"})
```

Example 4 (unknown):
```unknown
_execution.customData.setAll({"key1": "value1", "key2": "value2"})
```

---

## Shopify credentials

**URL:** llms-txt#shopify-credentials

**Contents:**
- Supported authentication methods
- Related resources
- Using access token
- Using OAuth2
- Using API key
- Common issues
  - Enable custom app development
  - Forbidden credentials error

You can use these credentials to authenticate the following nodes with Shopify.

- [Shopify](../../app-nodes/n8n-nodes-base.shopify/)
- [Shopify Trigger](../../trigger-nodes/n8n-nodes-base.shopifytrigger/)

## Supported authentication methods

- Access token (recommended): For private apps/single store use. Can be created by regular admins.
- OAuth2: For public apps. Must be created by partner accounts.
- API key: Deprecated.

Refer to [Shopify's authentication documentation](https://shopify.dev/docs/apps/auth) for more information about the service.

## Using access token

To configure this credential, you'll need a [Shopify](https://shopify.com/) admin account and:

- Your **Shop Subdomain**
- An **Access Token**: Generated when you create a custom app.
- An **APP Secret Key**: Generated when you create a custom app.

To set up the credential, you'll need to create and install a custom app:

1. Enter your **Shop Subdomain**.

- Your subdomain is within the URL: `https://<subdomain>.myshopify.com`. For example, if the full URL is `https://n8n.myshopify.com`, the Shop Subdomain is `n8n`.

1. In Shopify, go to **Admin > Settings >** [**Apps and sales channels**](https://admin.shopify.com/settings/apps).

1. Select **Develop apps**.

1. Select **Create a custom app**.

Don't see this option?

If you don't see this option, your store probably doesn't have custom app development enabled. Refer to [Enable custom app development](#enable-custom-app-development) for more information.

1. In the modal window, enter the **App name**.

1. Select an **App developer**. The app developer can be the store owner or any account with the **Develop apps** permission.

1. Select **Create app**.

1. Select **Select scopes**. In the **Admin API access scopes** section, select the API scopes you want for your app.

- To use all functionality in the [Shopify](../../app-nodes/n8n-nodes-base.shopify/) node, add the `read_orders`, `write_orders`, `read_products`, and `write_products` scopes.
   - Refer to [Shopify API Access Scopes](https://shopify.dev/docs/api/usage/access-scopes) for more information on the available scopes.

1. Select **Install app**.

1. In the modal window, select **Install app**.

1. Open the app's **API Credentials** section.

1. Copy the **Admin API Access Token**. Enter this in your n8n credential as the **Access Token**.

1. Copy the **API Secret Key**. Enter this in your n8n credential as the **APP Secret Key**.

Refer to [Creating a custom app](https://help.shopify.com/en/manual/apps/app-types/custom-apps) and [Generate access tokens for custom apps in the Shopify admin](https://shopify.dev/docs/apps/build/authentication-authorization/access-token-types/generate-app-access-tokens-admin) for more information on these steps.

To configure this credential, you'll need a [Shopify partner](https://www.shopify.com/partners) account and:

- A **Client ID**: Generated when you create a custom app.
- A **Client Secret**: Generated when you create a custom app.
- Your **Shop Subdomain**

To set up the credential, you'll need to create and install a custom app:

Custom app development

Shopify provides templates for creating new apps. The instructions below only cover the elements necessary to set up your n8n credential. Refer to Shopify's [Build dev docs](https://shopify.dev/docs/apps/build) for more information on building apps and working with app templates.

1. Open your [Shopify Partner dashboard](https://partners.shopify.com/).
1. Select **Apps** from the left navigation.
1. Select **Create app**.
1. In the **Use Shopify Partners** section, enter an **App name**.
1. Select **Create app**.
1. When the app details open, copy the **Client ID**. Enter this in your n8n credential.
1. Copy the **Client Secret**. Enter this in your n8n credential.
1. In the left menu, select **Configuration**.
1. In n8n, copy the **OAuth Redirect URL** and paste it into the **Allowed redirection URL(s)** in the **URLs** section.
1. In the **URLs** section, enter an **App URL** for your app. The host entered here needs to match the host for the **Allowed redirection URL(s)**, like the base URL for your n8n instance.
1. Select **Save and release**.
1. Select **Overview** from the left menu. At this point, you can choose to **Test your app** by installing it to one of your stores, or **Choose distribution** to distribute it publicly.
1. In n8n, enter the **Shop Subdomain** of the store you installed the app to, either as a test or as a distribution.
   - Your subdomain is within the URL: `https://<subdomain>.myshopify.com`. For example, if the full URL is `https://n8n.myshopify.com`, the Shop Subdomain is `n8n`.

Shopify no longer generates API keys with passwords. Use the [Access token](#using-access-token) method instead.

To configure this credential, you'll need:

- An **API Key**
- A **Password**
- Your **Shop Subdomain**: Your subdomain is within the URL: `https://<subdomain>.myshopify.com`. For example, if the full URL is `https://n8n.myshopify.com`, the Shop Subdomain is `n8n`.
- *Optional:* A **Shared Secret**

Here are some common issues setting up the Shopify credential and steps to resolve or troubleshoot them.

### Enable custom app development

If you don't see the option to **Create a custom app**, no one's enabled custom app development for your store.

To enable custom app development, you must log in either as a store owner or as a user with the **Enable app development** permission:

1. In Shopify, go to **Admin > Settings >** [**Apps and sales channels**](https://admin.shopify.com/settings/apps).
1. Select **Develop apps**.
1. Select **Allow custom app development**.
1. Read the warning and information provided and select **Allow custom app development**.

### Forbidden credentials error

If you get a **Couldn't connect with these settings / Forbidden - perhaps check your credentials** warning when you test the credentials, this may be due to your app's [access scope](https://shopify.dev/docs/api/usage/access-scopes) dependencies. For example, the `read_orders` scope also requires `read_products` scope. Review the scopes you have assigned and the action you're trying to complete.

---

## Item linking errors

**URL:** llms-txt#item-linking-errors

**Contents:**
  - Fix for 'Info for expressions missing from previous node'
  - Fix for 'Multiple matching items for expression'

In n8n you can reference data from any previous node. This doesn't have to be the node just before: it can be any previous node in the chain. When referencing nodes further back, you use the expression syntax `$(node_name).item`.

Diagram of threads for different items. Due to the item linking, you can get the actor for each movie using `$('Get famous movie actors').item`.

Since the previous node can have multiple items in it, n8n needs to know which one to use. When using `.item`, n8n figures this out for you behind the scenes. Refer to [Item linking concepts](../item-linking-concepts/) for detailed information on how this works.

`.item` fails if information is missing. To figure out which item to use, n8n maintains a thread back through the workflow's nodes for each item. For a given item, this thread tells n8n which items in previous nodes generated it. To find the matching item in a given previous node, n8n follows this thread back until it reaches the node in question.

When using `.item`, n8n displays an error when:

- The thread is broken
- The thread points to more than one item in the previous node (as it's unclear which one to use)

To solve these errors, you can either avoid using `.item`, or fix the root cause.

You can avoid `.item` by using `.first()`, `.last()` or `.all()[index]` instead. They require you to know the position of the item that you’re targeting within the target node's output items. Refer to [Built in methods and variables | Output of other nodes](../../../../code/builtin/output-other-nodes/) for more detail on these methods.

The fix for the root cause depends on the exact error.

### Fix for 'Info for expressions missing from previous node'

If you see this error message:

> ERROR: Info for expression missing from previous node

There's a node in the chain that doesn't return pairing information. The solution here depends on the type of the previous node:

- Code nodes: make sure you return which input items the node used to produce each output item. Refer to [Item linking in the code node](../item-linking-code-node/) for more information.
- Custom or community nodes: the node creator needs to update the node to return which input items it uses to produce each output item. Refer to [Item linking for node creators](../item-linking-node-building/) for more information.

### Fix for 'Multiple matching items for expression'

This is the error message:

> ERROR: Multiple matching items for expression

Sometimes n8n uses multiple items to create a single item. Examples include the Summarize, Aggregate, and Merge nodes. These nodes can combine information from multiple items.

When you use `.item` and there are multiple possible matches, n8n doesn't know which one to use. To solve this you can either:

- Use `.first()`, `.last()` or `.all()[index]` instead. Refer to [Built in methods and variables | Output of other nodes](../../../../code/builtin/output-other-nodes/) for more detail on these methods.
- Reference a different node that contains the same information, but doesn't have multiple matching items.

---

## Kafka credentials

**URL:** llms-txt#kafka-credentials

**Contents:**
- Supported authentication methods
- Related resources
- Using client ID

You can use these credentials to authenticate the following nodes:

- [Kafka](../../app-nodes/n8n-nodes-base.kafka/)
- [Kafka Trigger](../../trigger-nodes/n8n-nodes-base.kafkatrigger/)

## Supported authentication methods

Refer to [Kafka's documentation](https://kafka.apache.org/documentation/) for more information about using the service.

If you're new to Kafka, refer to the [Apache Kafka Quickstart](https://kafka.apache.org/quickstart) for initial setup.

Refer to [Encryption and Authentication using SSL](https://kafka.apache.org/documentation/#security_ssl) for working with SSL in Kafka.

To configure this credential, you'll need a running Kafka environment and:

- A **Client ID**
- A list of relevant **Brokers**
- Username/password authentication details if your Kafka environment uses authentication

1. Enter the `CLIENT-ID` of the client or consumer group in the **Client ID** field in your credential.
1. Enter a comma-separated list of relevant **Brokers** for the credential to use in the format `<broker-service-name>:<port>`. Use the name you gave the broker when you defined it in the `services` list. For example, `kafka-1:9092,kafka-2:9092` would add the brokers `kafka-1` and `kafka-2` on port `9092`.
1. If your Kafka environment doesn't use SSL, turn off the **SSL** toggle.
1. If you've enabled authentication using SASL in your Kafka environment, turn on the **Authentication** toggle. Then add:
   1. The **Username**
   1. The **Password**
   1. Select the broker's configured **SASL Mechanism**. Refer to [SASL configuration](https://kafka.apache.org/documentation/#security_sasl_config) for more information. Options include:
      - `Plain`
      - `scram-sha-256`
      - `scram-sha-512`

---

## Strava credentials

**URL:** llms-txt#strava-credentials

**Contents:**
- Prerequisites
- Supported authentication methods
- Related resources
- Using OAuth2

You can use these credentials to authenticate the following nodes:

- [Strava](../../app-nodes/n8n-nodes-base.strava/)
- [Strava Trigger](../../trigger-nodes/n8n-nodes-base.stravatrigger/)

- Create a [Strava](https://strava.com) account.
- Create a Strava application in [**Settings > API**](https://www.strava.com/settings/api). Refer to [Using OAuth2](#using-oauth2) for more information.

## Supported authentication methods

Refer to [Strava's API documentation](https://developers.strava.com/docs/reference/) for more information about the service.

To configure this credential, you'll need:

- A **Client ID**: Generated when you [create a Strava app](https://developers.strava.com/docs/getting-started/#account).
- A **Client Secret**: Generated when you [create a Strava app](https://developers.strava.com/docs/getting-started/#account).

Use these settings for your Strava app:

- In n8n, copy the **OAuth Callback URL**. Paste this URL into your Strava app's **Authorization Callback Domain**.
- Remove the protocol (`https://` or `http://`) and the relative URL (`/oauth2/callback` or `/rest/oauth2-credential/callback`) from the **Authorization Callback Domain**. For example, if the OAuth Redirect URL was originally `https://oauth.n8n.cloud/oauth2/callback`, the **Authorization Callback Domain** would be `oauth.n8n.cloud`.
- Copy the **Client ID** and **Client Secret** from your app and add them to your n8n credential.

Refer to [Authentication](https://developers.strava.com/docs/authentication/) for more information about Strava's OAuth flow.

---

## SIGNL4 node

**URL:** llms-txt#signl4-node

**Contents:**
- Operations
- Templates and examples

Use the SIGNL4 node to automate work in SIGNL4, and integrate SIGNL4 with other applications. n8n supports sending and resolving alerts with SIGNL4.

On this page, you'll find a list of operations the SIGNL4 node supports and links to more resources.

Refer to [SIGNL4 credentials](../../credentials/signl4/) for guidance on setting up authentication.

- Alert
  - Send an alert
  - Resolve an alert

## Templates and examples

**Monitor a file for changes and send an alert**

[View template details](https://n8n.io/workflows/967-monitor-a-file-for-changes-and-send-an-alert/)

**Send weather alerts to your mobile phone with OpenWeatherMap and SIGNL4**

[View template details](https://n8n.io/workflows/966-send-weather-alerts-to-your-mobile-phone-with-openweathermap-and-signl4/)

**Send TheHive Alerts Using SIGNL4**

[View template details](https://n8n.io/workflows/1630-send-thehive-alerts-using-signl4/)

[Browse SIGNL4 integration templates](https://n8n.io/integrations/signl4/), or [search all templates](https://n8n.io/workflows/)

---

## Node base file

**URL:** llms-txt#node-base-file

The node base file contains the core code of your node. All nodes must have a base file. The contents of this file are different depending on whether you're building a declarative-style or programmatic-style node. For guidance on which style to use, refer to [Choose your node building approach](../../../plan/choose-node-method/).

These documents give short code snippets to help understand the code structure and concepts. For full walk-throughs of building a node, including real-world code examples, refer to [Build a declarative-style node](../../declarative-style-node/) or [Build a programmatic-style node](../../programmatic-style-node/).

You can also explore the [n8n-nodes-starter](https://github.com/n8n-io/n8n-nodes-starter) and n8n's own [nodes](https://github.com/n8n-io/n8n/tree/master/packages/nodes-base/nodes) for a wider range of examples. The starter contains basic examples that you can build on. The n8n [Mattermost node](https://github.com/n8n-io/n8n/tree/master/packages/nodes-base/nodes/Mattermost) is a good example of a more complex programmatic-style node, including versioning.

For all nodes, refer to the:

- [Structure of the node base file](structure/)
- [Standard parameters](standard-parameters/)

For declarative-style nodes, refer to the:

- [Declarative-style parameters](declarative-style-parameters/)

For programmatic-style nodes, refer to the:

- [Programmatic-style parameters](programmatic-style-parameters/)
- [Programmatic-style execute() method](programmatic-style-execute-method/)

---

## Yahoo IMAP credentials

**URL:** llms-txt#yahoo-imap-credentials

**Contents:**
- Prerequisites
- Set up the credential

Follow these steps to configure the IMAP credentials with a Yahoo account.

To follow these instructions, you must first generate an app password:

1. Log in to your Yahoo account [Security page](https://login.yahoo.com/account/security).
1. Select **Generate app password** or **Generate and manage app passwords**.
1. Select **Get Started**.
1. Enter an **App name** for your new app password, like `n8n credential`.
1. Select **Generate password**.
1. Copy the generated app password. You'll use this in your n8n credential.

Refer to Yahoo's [Generate and manage 3rd-party app passwords](https://help.yahoo.com/kb/generate-manage-third-party-passwords-sln15241.html) for more information.

## Set up the credential

To set up the IMAP credential with a Yahoo Mail account, use these settings:

1. Enter your Yahoo email address as the **User**.
1. Enter the app password you generated above as the **Password**.
1. Enter `imap.mail.yahoo.com` as the **Host**.
1. Keep the default **Port** number of `993`. Check with your email administrator if this port doesn't work.
1. Turn on the **SSL/TLS** toggle.
1. Check with your email administrator about whether to **Allow Self-Signed Certificates**.

Refer to [Set up IMAP for Yahoo mail account](https://help.yahoo.com/kb/sln4075.html) for more information.

---

## Mautic Trigger node

**URL:** llms-txt#mautic-trigger-node

**Contents:**
- Related resources

[Mautic](https://www.mautic.org/) is an open-source marketing automation software that helps online businesses automate their repetitive marketing tasks such as lead generation, contact scoring, contact segmentation, and marketing campaigns.

You can find authentication information for this node [here](../../credentials/mautic/).

Examples and templates

For usage examples and templates to help you get started, refer to n8n's [Mautic Trigger integrations](https://n8n.io/integrations/mautic-trigger/) page.

n8n provides an app node for Mautic. You can find the node docs [here](../../app-nodes/n8n-nodes-base.mautic/).

View [example workflows and related content](https://n8n.io/integrations/mautic/) on n8n's website.

---

## Box Trigger node

**URL:** llms-txt#box-trigger-node

**Contents:**
- Find your Box Target ID

[Box](https://www.box.com/) is a cloud computing company which provides file sharing, collaborating, and other tools for working with files uploaded to its servers.

You can find authentication information for this node [here](../../credentials/box/).

Examples and templates

For usage examples and templates to help you get started, refer to n8n's [Box Trigger integrations](https://n8n.io/integrations/box-trigger/) page.

## Find your Box Target ID

To get your Target ID in Box:

1. Open the file/folder that you would like to monitor.
1. Copy the string of characters after `folder/` in your URL. This is the target ID. For example, if the URL is `https://app.box.com/folder/12345`, then `12345` is the target ID.
1. Paste it in the **Target ID** field in n8n.

---

## SearXNG credentials

**URL:** llms-txt#searxng-credentials

**Contents:**
- Supported authentication methods
- Related resources
- Using API URL

You can use these credentials to authenticate the following nodes:

- [SearXNG Tool](../../cluster-nodes/sub-nodes/n8n-nodes-langchain.toolsearxng/)

## Supported authentication methods

Refer to [SearXNG's documentation](https://docs.searxng.org/index.html) for more information about the service.

To configure this credential, you'll need an instance of SearXNG running at an URL that's accessible from n8n:

- **API URL**: The URL of the SearXNG instance you want to connect to.

Refer to [SearXNG's Administrator documentation](https://docs.searxng.org/admin/index.html) for more information about running the service.

---

## Harvest node

**URL:** llms-txt#harvest-node

**Contents:**
- Operations
- Templates and examples
- What to do if your operation isn't supported

Use the Harvest node to automate work in Harvest, and integrate Harvest with other applications. n8n has built-in support for a wide range of Harvest features, including creating, updating, deleting, and getting clients, contacts, invoices, tasks, expenses, users, and projects.

On this page, you'll find a list of operations the Harvest node supports and links to more resources.

Refer to [Harvest credentials](../../credentials/harvest/) for guidance on setting up authentication.

- Client
  - Create a client
  - Delete a client
  - Get data of a client
  - Get data of all clients
  - Update a client
- Company
  - Retrieves the company for the currently authenticated user
- Contact
  - Create a contact
  - Delete a contact
  - Get data of a contact
  - Get data of all contacts
  - Update a contact
- Estimate
  - Create an estimate
  - Delete an estimate
  - Get data of an estimate
  - Get data of all estimates
  - Update an estimate
- Expense
  - Get data of an expense
  - Get data of all expenses
  - Create an expense
  - Update an expense
  - Delete an expense
- Invoice
  - Get data of an invoice
  - Get data of all invoices
  - Create an invoice
  - Update an invoice
  - Delete an invoice
- Project
  - Create a project
  - Delete a project
  - Get data of a project
  - Get data of all projects
  - Update a project
- Task
  - Create a task
  - Delete a task
  - Get data of a task
  - Get data of all tasks
  - Update a task
- Time Entries
  - Create a time entry using duration
  - Create a time entry using start and end time
  - Delete a time entry
  - Delete a time entry's external reference.
  - Get data of a time entry
  - Get data of all time entries
  - Restart a time entry
  - Stop a time entry
  - Update a time entry
- User
  - Create a user
  - Delete a user
  - Get data of a user
  - Get data of all users
  - Get data of authenticated user
  - Update a user

## Templates and examples

**Automated Investor Intelligence: CrunchBase to Google Sheets Data Harvester**

[View template details](https://n8n.io/workflows/4731-automated-investor-intelligence-crunchbase-to-google-sheets-data-harvester/)

**Process Shopify new orders with Zoho CRM and Harvest**

[View template details](https://n8n.io/workflows/1206-process-shopify-new-orders-with-zoho-crm-and-harvest/)

**Create a client in Harvest**

[View template details](https://n8n.io/workflows/494-create-a-client-in-harvest/)

[Browse Harvest integration templates](https://n8n.io/integrations/harvest/), or [search all templates](https://n8n.io/workflows/)

## What to do if your operation isn't supported

If this node doesn't support the operation you want to do, you can use the [HTTP Request node](../../core-nodes/n8n-nodes-base.httprequest/) to call the service's API.

You can use the credential you created for this service in the HTTP Request node:

1. In the HTTP Request node, select **Authentication** > **Predefined Credential Type**.
1. Select the service you want to connect to.
1. Select your credential.

Refer to [Custom API operations](../../../custom-operations/) for more information.

---

## Workflows environment variables

**URL:** llms-txt#workflows-environment-variables

File-based configuration

You can add `_FILE` to individual variables to provide their configuration in a separate file. Refer to [Keeping sensitive data in separate files](../../configuration-methods/#keeping-sensitive-data-in-separate-files) for more details.

| Variable                                    | Type    | Default                  | Description                                                                                                                                                                                |
| ------------------------------------------- | ------- | ------------------------ | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------ |
| `N8N_ONBOARDING_FLOW_DISABLED`              | Boolean | `false`                  | Whether to disable onboarding tips when creating a new workflow (true) or not (false).                                                                                                     |
| `N8N_WORKFLOW_ACTIVATION_BATCH_SIZE`        | Number  | `1`                      | How many workflows to activate simultaneously during startup.                                                                                                                              |
| `N8N_WORKFLOW_CALLER_POLICY_DEFAULT_OPTION` | String  | `workflowsFromSameOwner` | Which workflows can call a workflow. Options are: `any`, `none`, `workflowsFromAList`, `workflowsFromSameOwner`. This feature requires [Workflow sharing](../../../../workflows/sharing/). |
| `N8N_WORKFLOW_TAGS_DISABLED`                | Boolean | `false`                  | Whether to disable workflow tags (true) or enable tags (false).                                                                                                                            |
| `WORKFLOWS_DEFAULT_NAME`                    | String  | `My workflow`            | The default name used for new workflows.                                                                                                                                                   |

---

## Notion credentials

**URL:** llms-txt#notion-credentials

**Contents:**
- Prerequisites
- Supported authentication methods
- Related resources
- Using API integration token
  - Share Notion page(s) with the integration
- Using OAuth2
- Internal vs. public integrations

You can use these credentials to authenticate the following nodes:

- [Notion](../../app-nodes/n8n-nodes-base.notion/)
- [Notion Trigger](../../trigger-nodes/n8n-nodes-base.notiontrigger/)

Create a [Notion](https://notion.so) account with admin level access.

## Supported authentication methods

- API integration token: Used for internal integrations.
- OAuth2: Used for public integrations.

Not sure which integration type to use? Refer to [Internal vs. public integrations](#internal-vs-public-integrations) below for more information.

Refer to [Notion's API documentation](https://developers.notion.com/reference/intro) for more information about the service.

## Using API integration token

To configure this credential, you'll need:

- An **Internal Integration Secret**: Generated once you create a Notion integration.

To generate an integration secret, [create a Notion integration](https://developers.notion.com/docs/create-a-notion-integration#create-your-integration-in-notion) and grab the integration secret from the **Secrets** tab:

1. Go to your Notion [integration dashboard](https://www.notion.com/my-integrations).
1. Select the **+ New integration** button.
1. Enter a **Name** for your integration, for example `n8n integration`. If desired, add a **Logo**.
1. Select **Submit** to create your integration.
1. Open the **Capabilities** tab. Select these capabilities:
   - `Read content`
   - `Update content`
   - `Insert content`
   - `User information without email addresses`
1. Be sure to **Save changes**.
1. Select the **Secrets** tab.
1. Copy the **Internal Integration Token** and add it as your n8n **Internal Integration Secret**.

Refer to the [Internal integration auth flow setup documentation](https://developers.notion.com/docs/authorization#internal-integration-auth-flow-set-up) for more information about authenticating to the service.

### Share Notion page(s) with the integration

For your integration to interact with Notion, you must [give your integration page permission](https://developers.notion.com/docs/create-a-notion-integration#give-your-integration-page-permissions) to interact with page(s) in your Notion workspace:

1. Visit the page in your Notion workspace.
1. Select the triple dot menu at the top right of a page.
1. In **Connections**, select **Connect to**.
1. Use the search bar to find and select your integration from the dropdown list.

Once you share at least one page with the integration, you can start making API requests. If the page isn't shared, any API requests made will respond with an error.

Refer to [Integration permissions](https://developers.notion.com/docs/authorization#integration-permissions) for more information.

To configure this credential, you'll need:

- A **Client ID**: Generated once you configure a public integration.
- A **Client Secret**: Generated once you configure a public integration.

You must [create a Notion integration](https://developers.notion.com/docs/create-a-notion-integration#create-your-integration-in-notion) and set it to public distribution:

1. Go to your Notion [integration dashboard](https://www.notion.so/my-integrations).
1. Select the **+ New integration** button.
1. Enter a **Name** for your integration, for example `n8n integration`. If desired, add a **Logo**.
1. Select **Submit** to create your integration.
1. Open the **Capabilities** tab. Select these capabilities:
   - `Read content`
   - `Update content`
   - `Insert content`
   - `User information without email addresses`
1. Select **Save changes**.
1. Go to the **Distribution** tab.
1. Turn on the **Do you want to make this integration public?** control.
1. Enter your company name and website in the **Organization Information** section.
1. Copy the n8n **OAuth Redirect URL** and add it to as a **Redirect URI** in the Notion integration's **OAuth Domain & URLs** section.
1. Go to the **Secrets** tab.
1. Copy the **Client ID** and **Client Secret** and add them to your n8n credential.

Refer to Notion's [public integration auth flow setup](https://developers.notion.com/docs/authorization#public-integration-auth-flow-set-up) for more information about authenticating to the service.

## Internal vs. public integrations

**Internal** integrations are:

- Specific to a single workspace.
- Accessible only to members of that workspace.
- Ideal for custom workspace enhancements.

Internal integrations use a simpler authentication process (the integration secret) and don't require any security review before publishing.

**Public** integrations are:

- Usable across multiple, unrelated Notion workspaces.
- Accessible by any Notion user, regardless of their workspace.
- Ideal for catering to broad use cases.

Public integrations use the OAuth 2.0 protocol for authentication. They require a Notion security review before publishing.

For a more detailed breakdown of the two integration types, refer to Notion's [Internal vs. Public Integrations documentation](https://developers.notion.com/docs/getting-started#internal-vs-public-integrations).

---

## ConvertKit Trigger node

**URL:** llms-txt#convertkit-trigger-node

**Contents:**
- Events
- Related resources

[ConvertKit](https://www.convertkit.com/) is a fully featured email marketing platform. Use ConvertKit to build an email list, send email broadcasts, automate sequences, create segments, and build landing pages.

You can find authentication information for this node [here](../../credentials/convertkit/).

Examples and templates

For usage examples and templates to help you get started, refer to n8n's [ConvertKit Trigger integrations](https://n8n.io/integrations/convertkit-trigger/) page.

- Form subscribe
- Link click
- Product purchase
- Purchase created
- Purchase complete
- Sequence complete
- Sequence subscribe
- Subscriber activated
- Subscriber unsubscribe
- Tag add
- Tag Remove

n8n provides an app node for ConvertKit. You can find the node docs [here](../../app-nodes/n8n-nodes-base.convertkit/).

View [example workflows and related content](https://n8n.io/integrations/convertkit-trigger/) on n8n's website.

Refer to [ConvertKit's documentation](https://developers.kit.com/v4#introduction) for details about their API.

---

## Data structure

**URL:** llms-txt#data-structure

**Contents:**
- Data item processing

In n8n, all data passed between nodes is an array of objects. It has the following structure:

Skipping the `json` key and array syntax

From 0.166.0 on, when using the Function node or Code node, n8n automatically adds the `json` key if it's missing. It also automatically wraps your items in an array (`[]`) if needed. This is only the case when using the Function or Code nodes. When building your own nodes, you must still make sure the node returns data with the `json` key.

## Data item processing

Nodes can process multiple items.

For example, if you set the Trello node to `Create-Card`, and create an expression that sets `Name` using a property called `name-input-value` from the incoming data, the node creates a card for each item, always choosing the `name-input-value` of the current item.

For example, this input will create two cards. One named `test1` the other one named `test2`:

**Examples:**

Example 1 (unknown):
```unknown
[
	{
		// For most data:
		// Wrap each item in another object, with the key 'json'
		"json": {
			// Example data
			"apple": "beets",
			"carrot": {
				"dill": 1
			}
		},
		// For binary data:
		// Wrap each item in another object, with the key 'binary'
		"binary": {
			// Example data
			"apple-picture": {
				"data": "....", // Base64 encoded binary data (required)
				"mimeType": "image/png", // Best practice to set if possible (optional)
				"fileExtension": "png", // Best practice to set if possible (optional)
				"fileName": "example.png", // Best practice to set if possible (optional)
			}
		}
	},
]
```

Example 2 (unknown):
```unknown
[
	{
		name-input-value: "test1"
	},
	{
		name-input-value: "test2"
	}
]
```

---

## Templates and examples

**URL:** llms-txt#templates-and-examples

**Contents:**
- Templates
- Set up sample data using the Code node
- Removing duplicates from the current input
- Keep items where the value is new
- Keep items where the value is higher than any previous value
- Keep items where the value is a date later than any previous date

Here are some templates and examples for the [Remove Duplicates node](../).

The examples included in this section are a sequence. Follow from one to another to avoid unexpected results.

[Browse Templates and examples integration templates](https://n8n.io/integrations/remove-duplicates/), or [search all templates](https://n8n.io/workflows/)

## Set up sample data using the Code node

Create a workflow with some example input data to try out the Remove Duplicates node.

1. Add a Code node to the canvas and connect it to the Manual Trigger node.

1. In the Code node, set **Mode** to **Run Once for Each Item** and **Language** to **JavaScript**.

1. Paste the following JavaScript code snippet in the **JavaScript** field:

1. Add a Split Out node to the canvas and connect it to the Code node.

1. In the Split Out node, enter `data` in the **Fields To Split Out** field.

## Removing duplicates from the current input

1. Add a Remove Duplicates node to the canvas and connect it to the Split Out node. Choose **Remove items repeated within current input** as the **Action** to start.
1. Open the Remove Duplicates node and ensure that the **Operation** is set to **Remove Items Repeated Within Current Input**.
1. Choose **All fields** in the **Compare** field.
1. Select **Execute step** to run the Remove Duplicates node, removing duplicated data in the current input.

n8n removes the items that have the same data across all fields. Your output in table view should look like this:

| **id** | **name**      | **job**           | **last_updated**         |
| ------ | ------------- | ----------------- | ------------------------ |
| 1      | Taylor Swift  | Pop star          | 2024-09-20T10:12:43.493Z |
| 2      | Ed Sheeran    | Singer-songwriter | 2024-10-05T08:30:59.493Z |
| 3      | Adele         | Singer-songwriter | 2024-10-07T14:15:59.493Z |
| 4      | Bruno Mars    | Singer-songwriter | 2024-08-25T17:45:12.493Z |
| 5      | Billie Eilish | Singer-songwriter | 2024-09-10T09:30:12.493Z |
| 6      | Katy Perry    | Pop star          | 2024-10-08T12:30:45.493Z |
| 7      | Lady Gaga     | Pop star          | 2024-09-15T14:45:30.493Z |
| 8      | Rihanna       | Pop star          | 2024-10-01T11:50:22.493Z |

5. Open the Remove Duplicates node again and change the **Compare** parameter to **Selected Fields**.
1. In the **Fields To Compare** field, enter `job`.
1. Select **Execute step** to run the Remove Duplicates node, removing duplicated data in the current input.

n8n removes the items in the current input that have the same `job` data. Your output in table view should look like this:

| **id** | **name**     | **job**           | **last_updated**         |
| ------ | ------------ | ----------------- | ------------------------ |
| 1      | Taylor Swift | Pop star          | 2024-09-20T10:12:43.493Z |
| 2      | Ed Sheeran   | Singer-songwriter | 2024-10-05T08:30:59.493Z |

## Keep items where the value is new

1. Open the Remove Duplicates node and set the **Operation** to **Remove Items Processed in Previous Executions**.
1. Set the **Keep Items Where** parameter to **Value Is New**.
1. Set the **Value to Dedupe On** parameter to `{{ $json.name }}`.
1. On the canvas, select **Execute workflow** to run the workflow. Open the Remove Duplicates node to examine the results.

n8n compares the current input data to the items stored from previous executions. Since this is the first time running the Remove Duplicates node with this operation, n8n processes all data items and places them into the **Kept** output tab. The order of the items may be different than the order in the input data:

| **id** | **name**      | **job**           | **last_updated**         |
| ------ | ------------- | ----------------- | ------------------------ |
| 1      | Taylor Swift  | Pop star          | 2024-09-20T10:12:43.493Z |
| 1      | Taylor Swift  | Pop star          | 2024-09-20T10:12:43.493Z |
| 2      | Ed Sheeran    | Singer-songwriter | 2024-10-05T08:30:59.493Z |
| 2      | Ed Sheeran    | Singer-songwriter | 2024-10-05T08:30:59.493Z |
| 3      | Adele         | Singer-songwriter | 2024-10-07T14:15:59.493Z |
| 3      | Adele         | Singer-songwriter | 2024-10-07T14:15:59.493Z |
| 4      | Bruno Mars    | Singer-songwriter | 2024-08-25T17:45:12.493Z |
| 5      | Billie Eilish | Singer-songwriter | 2024-09-10T09:30:12.493Z |
| 6      | Katy Perry    | Pop star          | 2024-10-08T12:30:45.493Z |
| 7      | Lady Gaga     | Pop star          | 2024-09-15T14:45:30.493Z |
| 8      | Rihanna       | Pop star          | 2024-10-01T11:50:22.493Z |

Items are only compared against previous executions

The current input items are only compared against the stored items from previous executions. This means that items repeated within the current input aren't removed in this mode of operation. If you need to remove duplicate items within the current input *and* across executions, connect two Remove Duplicate nodes together sequentially. Set the first to use the **Remove Items Repated Within Current Input** operation and the second to use the **Remove Items Processed in Previous Executions** operation.

5. Open the Code node and uncomment (remove the `//` from) the line for "Tom Hanks."
1. On the canvas, select **Execute workflow** again. Open the Remove Duplicates node again to examine the results.

n8n compares the current input data to the items stored from previous executions. This time, the **Kept** tab contains the one new record from the Code node:

| **id** | **name**  | **job** | **last_updated**         |
| ------ | --------- | ------- | ------------------------ |
| 9      | Tom Hanks | Actor   | 2024-10-17T13:58:31.493Z |

The **Discarded** tab contains the items processed by the previous execution:

| **id** | **name**      | **job**           | **last_updated**         |
| ------ | ------------- | ----------------- | ------------------------ |
| 1      | Taylor Swift  | Pop star          | 2024-09-20T10:12:43.493Z |
| 1      | Taylor Swift  | Pop star          | 2024-09-20T10:12:43.493Z |
| 2      | Ed Sheeran    | Singer-songwriter | 2024-10-05T08:30:59.493Z |
| 2      | Ed Sheeran    | Singer-songwriter | 2024-10-05T08:30:59.493Z |
| 3      | Adele         | Singer-songwriter | 2024-10-07T14:15:59.493Z |
| 3      | Adele         | Singer-songwriter | 2024-10-07T14:15:59.493Z |
| 4      | Bruno Mars    | Singer-songwriter | 2024-08-25T17:45:12.493Z |
| 5      | Billie Eilish | Singer-songwriter | 2024-09-10T09:30:12.493Z |
| 6      | Katy Perry    | Pop star          | 2024-10-08T12:30:45.493Z |
| 7      | Lady Gaga     | Pop star          | 2024-09-15T14:45:30.493Z |
| 8      | Rihanna       | Pop star          | 2024-10-01T11:50:22.493Z |

Before continuing, clear the duplication history to get ready for the next example:

7. Open the Remove Duplicates node and set the **Operation** to **Clear Deduplication History**.
1. Select **Execute step** to clear the current duplication history.

## Keep items where the value is higher than any previous value

1. Open the Remove Duplicates node and set the **Operation** to **Remove Items Processed in Previous Executions**.
1. Set the **Keep Items Where** parameter to **Value Is Higher than Any Previous Value**.
1. Set the **Value to Dedupe On** parameter to `{{ $json.id }}`.
1. On the canvas, select **Execute workflow** to run the workflow. Open the Remove Duplicates node to examine the results.

n8n compares the current input data to the items stored from previous executions. Since this is the first time running the Remove Duplicates node after clearing the history, n8n processes all data items and places them into the **Kept** output tab. The order of the items may be different than the order in the input data:

| **id** | **name**      | **job**           | **last_updated**         |
| ------ | ------------- | ----------------- | ------------------------ |
| 1      | Taylor Swift  | Pop star          | 2024-09-20T10:12:43.493Z |
| 1      | Taylor Swift  | Pop star          | 2024-09-20T10:12:43.493Z |
| 2      | Ed Sheeran    | Singer-songwriter | 2024-10-05T08:30:59.493Z |
| 2      | Ed Sheeran    | Singer-songwriter | 2024-10-05T08:30:59.493Z |
| 3      | Adele         | Singer-songwriter | 2024-10-07T14:15:59.493Z |
| 3      | Adele         | Singer-songwriter | 2024-10-07T14:15:59.493Z |
| 4      | Bruno Mars    | Singer-songwriter | 2024-08-25T17:45:12.493Z |
| 5      | Billie Eilish | Singer-songwriter | 2024-09-10T09:30:12.493Z |
| 6      | Katy Perry    | Pop star          | 2024-10-08T12:30:45.493Z |
| 7      | Lady Gaga     | Pop star          | 2024-09-15T14:45:30.493Z |
| 8      | Rihanna       | Pop star          | 2024-10-01T11:50:22.493Z |
| 9      | Tom Hanks     | Actor             | 2024-10-17T13:58:31.493Z |

5. Open the Code node and uncomment (remove the `//` from) the lines for "Madonna" and "Bob Dylan."
1. On the canvas, select **Execute workflow** again. Open the Remove Duplicates node again to examine the results.

n8n compares the current input data to the items stored from previous executions. This time, the **Kept** tab contains a single entry for "Bob Dylan." n8n keeps this item because its `id` column value (15) is higher than any previous values (the previous maximum value was 9):

| **id** | **name**  | **job**     | **last_updated**         |
| ------ | --------- | ----------- | ------------------------ |
| 15     | Bob Dylan | Folk singer | 2024-09-24T08:03:16.493Z |

The **Discarded** tab contains the 13 items with an `id` column value equal to or less than the previous maximum value (9). Even though it's new, this table includes the entry for "Madonna" because its `id` value isn't larger than the previous maximum value:

| **id** | **name**      | **job**           | **last_updated**         |
| ------ | ------------- | ----------------- | ------------------------ |
| 0      | Madonna       | Pop star          | 2024-10-17T17:11:38.493Z |
| 1      | Taylor Swift  | Pop star          | 2024-09-20T10:12:43.493Z |
| 1      | Taylor Swift  | Pop star          | 2024-09-20T10:12:43.493Z |
| 2      | Ed Sheeran    | Singer-songwriter | 2024-10-05T08:30:59.493Z |
| 2      | Ed Sheeran    | Singer-songwriter | 2024-10-05T08:30:59.493Z |
| 3      | Adele         | Singer-songwriter | 2024-10-07T14:15:59.493Z |
| 3      | Adele         | Singer-songwriter | 2024-10-07T14:15:59.493Z |
| 4      | Bruno Mars    | Singer-songwriter | 2024-08-25T17:45:12.493Z |
| 5      | Billie Eilish | Singer-songwriter | 2024-09-10T09:30:12.493Z |
| 6      | Katy Perry    | Pop star          | 2024-10-08T12:30:45.493Z |
| 7      | Lady Gaga     | Pop star          | 2024-09-15T14:45:30.493Z |
| 8      | Rihanna       | Pop star          | 2024-10-01T11:50:22.493Z |
| 9      | Tom Hanks     | Actor             | 2024-10-17T13:58:31.493Z |

Before continuing, clear the duplication history to get ready for the next example:

7. Open the Remove Duplicates node and set the **Operation** to **Clear Deduplication History**.
1. Select **Execute step** to clear the current duplication history.

## Keep items where the value is a date later than any previous date

1. Open the Remove Duplicates node and set the **Operation** to **Remove Items Processed in Previous Executions**.
1. Set the **Keep Items Where** parameter to **Value Is a Date Later than Any Previous Date**.
1. Set the **Value to Dedupe On** parameter to `{{ $json.last_updated }}`.
1. On the canvas, select **Execute workflow** to run the workflow. Open the Remove Duplicates node to examine the results.

n8n compares the current input data to the items stored from previous executions. Since this is the first time running the Remove Duplicates node after clearing the history, n8n processes all data items and places them into the **Kept** output tab. The order of the items may be different than the order in the input data:

| **id** | **name**      | **job**           | **last_updated**         |
| ------ | ------------- | ----------------- | ------------------------ |
| 0      | Madonna       | Pop star          | 2024-10-17T17:11:38.493Z |
| 1      | Taylor Swift  | Pop star          | 2024-09-20T10:12:43.493Z |
| 1      | Taylor Swift  | Pop star          | 2024-09-20T10:12:43.493Z |
| 2      | Ed Sheeran    | Singer-songwriter | 2024-10-05T08:30:59.493Z |
| 2      | Ed Sheeran    | Singer-songwriter | 2024-10-05T08:30:59.493Z |
| 3      | Adele         | Singer-songwriter | 2024-10-07T14:15:59.493Z |
| 3      | Adele         | Singer-songwriter | 2024-10-07T14:15:59.493Z |
| 4      | Bruno Mars    | Singer-songwriter | 2024-08-25T17:45:12.493Z |
| 5      | Billie Eilish | Singer-songwriter | 2024-09-10T09:30:12.493Z |
| 6      | Katy Perry    | Pop star          | 2024-10-08T12:30:45.493Z |
| 7      | Lady Gaga     | Pop star          | 2024-09-15T14:45:30.493Z |
| 8      | Rihanna       | Pop star          | 2024-10-01T11:50:22.493Z |
| 9      | Tom Hanks     | Actor             | 2024-10-17T13:58:31.493Z |
| 15     | Bob Dylan     | Folk singer       | 2024-09-24T08:03:16.493Z |

5. Open the Code node and uncomment (remove the `//` from) the lines for "Harry Nilsson" and "Kylie Minogue."

1. On the canvas, select **Execute workflow** again. Open the Remove Duplicates node again to examine the results.

n8n compares the current input data to the items stored from previous executions. This time, the **Kept** tab contains a single entry for "Kylie Minogue." n8n keeps this item because its `last_updated` column value (`2024-10-24T08:03:16.493Z`) is later than any previous values (the previous latest date was `2024-10-17T17:11:38.493Z`):

| **id** | **name**      | **job**  | **last_updated**         |
| ------ | ------------- | -------- | ------------------------ |
| 11     | Kylie Minogue | Pop star | 2024-10-24T08:03:16.493Z |

The **Discarded** tab contains the 15 items with a `last_updated` column value equal to or earlier than the previous latest date (`2024-10-17T17:11:38.493Z`). Even though it's new, this table includes the entry for "Harry Nilsson" because its `last_updated` value isn't later than the previous maximum value:

| **id** | **name**      | **job**           | **last_updated**         |
| ------ | ------------- | ----------------- | ------------------------ |
| 10     | Harry Nilsson | Singer-songwriter | 2020-10-17T17:11:38.493Z |
| 0      | Madonna       | Pop star          | 2024-10-17T17:11:38.493Z |
| 1      | Taylor Swift  | Pop star          | 2024-09-20T10:12:43.493Z |
| 1      | Taylor Swift  | Pop star          | 2024-09-20T10:12:43.493Z |
| 2      | Ed Sheeran    | Singer-songwriter | 2024-10-05T08:30:59.493Z |
| 2      | Ed Sheeran    | Singer-songwriter | 2024-10-05T08:30:59.493Z |
| 3      | Adele         | Singer-songwriter | 2024-10-07T14:15:59.493Z |
| 3      | Adele         | Singer-songwriter | 2024-10-07T14:15:59.493Z |
| 4      | Bruno Mars    | Singer-songwriter | 2024-08-25T17:45:12.493Z |
| 5      | Billie Eilish | Singer-songwriter | 2024-09-10T09:30:12.493Z |
| 6      | Katy Perry    | Pop star          | 2024-10-08T12:30:45.493Z |
| 7      | Lady Gaga     | Pop star          | 2024-09-15T14:45:30.493Z |
| 8      | Rihanna       | Pop star          | 2024-10-01T11:50:22.493Z |
| 9      | Tom Hanks     | Actor             | 2024-10-17T13:58:31.493Z |
| 15     | Bob Dylan     | Folk singer       | 2024-09-24T08:03:16.493Z |

**Examples:**

Example 1 (unknown):
```unknown
let data =[];

   return {
     data: [
       { id: 1, name: 'Taylor Swift', job: 'Pop star', last_updated: '2024-09-20T10:12:43.493Z' },
       { id: 2, name: 'Ed Sheeran', job: 'Singer-songwriter', last_updated: '2024-10-05T08:30:59.493Z' },
       { id: 3, name: 'Adele', job: 'Singer-songwriter', last_updated: '2024-10-07T14:15:59.493Z' },
       { id: 4, name: 'Bruno Mars', job: 'Singer-songwriter', last_updated: '2024-08-25T17:45:12.493Z' },
       { id: 1, name: 'Taylor Swift', job: 'Pop star', last_updated: '2024-09-20T10:12:43.493Z' },  // duplicate
       { id: 5, name: 'Billie Eilish', job: 'Singer-songwriter', last_updated: '2024-09-10T09:30:12.493Z' },
       { id: 6, name: 'Katy Perry', job: 'Pop star', last_updated: '2024-10-08T12:30:45.493Z' },
       { id: 2, name: 'Ed Sheeran', job: 'Singer-songwriter', last_updated: '2024-10-05T08:30:59.493Z' },  // duplicate
       { id: 7, name: 'Lady Gaga', job: 'Pop star', last_updated: '2024-09-15T14:45:30.493Z' },
       { id: 8, name: 'Rihanna', job: 'Pop star', last_updated: '2024-10-01T11:50:22.493Z' },
       { id: 3, name: 'Adele', job: 'Singer-songwriter', last_updated: '2024-10-07T14:15:59.493Z' },  // duplicate
       //{ id: 9, name: 'Tom Hanks', job: 'Actor', last_updated: '2024-10-17T13:58:31.493Z' },
       //{ id: 0, name: 'Madonna', job: 'Pop star', last_updated: '2024-10-17T17:11:38.493Z' },
       //{ id: 15, name: 'Bob Dylan', job: 'Folk singer', last_updated: '2024-09-24T08:03:16.493Z'},
       //{ id: 10, name: 'Harry Nilsson', job: 'Singer-songwriter', last_updated: '2020-10-17T17:11:38.493Z' },
       //{ id: 11, name: 'Kylie Minogue', job: 'Pop star', last_updated: '2024-10-24T08:03:16.493Z'},
     ]
   }
```

---

## Booleans

**URL:** llms-txt#booleans

**Contents:**
  - toInt(): Number

A reference document listing built-in convenience functions to support data transformation in [expressions](../../../../glossary/#expression-n8n) for arrays.

JavaScript in expressions

You can use any JavaScript in expressions. Refer to [Expressions](../../../expressions/) for more information.

Convert a boolean to a number. `false` converts to `0`, `true` converts to `1`.

______________________________________________________________________

---

## Supported authentication methods

**URL:** llms-txt#supported-authentication-methods

**Contents:**
- Related resources
- Using API key

Refer to [Onfleet's API documentation](https://docs.onfleet.com/reference/introduction) for more information about the service.

To configure this credential, you'll need:

- An **API key**: To create an API key, log into your organization's administrator account. Select **Settings > API & Webhooks**, then select **+** to create a new key. Refer to Onfleet's [Creating an API key documentation](https://support.onfleet.com/hc/en-us/articles/360045763292-API) for more information.

---

## WordPress credentials

**URL:** llms-txt#wordpress-credentials

**Contents:**
- Prerequisites
- Supported authentication methods
- Related resources
- Using basic auth
  - Enable two-step authentication
  - Create an application password
  - Set up the credential

You can use these credentials to authenticate the following nodes:

- [WordPress](../../app-nodes/n8n-nodes-base.wordpress/)

- Create a [WordPress](https://wordpress.com/) account or deploy WordPress on a server.

## Supported authentication methods

Refer to [WordPress's API documentation](https://developer.wordpress.com/docs/api/) for more information about the service.

To configure this credential, you'll need:

- Your WordPress **Username**
- A WordPress application **Password**
- Your **WordPress URL**
- Decide whether to **Ignore SSL Issues**

Using this credential involves three steps:

1. [Enable two-step authentication](#enable-two-step-authentication).
1. [Create an application password](#create-an-application-password).
1. [Set up the credential](#set-up-the-credential).

Refer to the detailed instructions below for each step.

### Enable two-step authentication

To generate an application password, you must first enable Two-Step Authentication in WordPress. If you've already done this, [skip to the next section](#create-an-application-password).

1. Open your WordPress [profile](https://wordpress.com/me).
1. Select **Security** from the left menu.
1. Select **Two-Step Authentication**. The **Two-Step Authentication** page opens.
1. If Two-Step Authentication isn't enabled, you must enable it.
1. Choose whether to enable it using an authenticator app or SMS codes and follow the on-screen instructions.

Refer to WordPress's [Enable Two-Step Authentication](https://wordpress.com/support/security/two-step-authentication/) for detailed instructions.

### Create an application password

With Two-Step Authentication enabled, you can now generate an application password:

1. From the WordPress **Security >** [**Two-Step Authentication**](https://wordpress.com/me/security/two-step) page, select **+ Add new application password** in the **Application passwords** section.
1. Enter an **Application name**, like `n8n integration`.
1. Select **Generate Password**.
1. Copy the password it generates. You'll use this in your n8n credential.

### Set up the credential

Congratulations! You're now ready to set up your n8n credential:

1. Enter your WordPress **Username** in your n8n credential.
1. Enter the application password you copied above as the **Password** in your n8n credential.
1. Enter the URL of your WordPress site as the **WordPress URL**.
1. Optional: Use the **Ignore SSL Issues** to choose whether you want the n8n credential to connect even if SSL certificate validation fails (turned on) or whether to respect SSL certificate validation (turned off).

---

## Log streaming

**URL:** llms-txt#log-streaming

**Contents:**
- Set up log streaming
- Events
- Destinations

Log Streaming is available on all Enterprise plans.

Log streaming allows you to send events from n8n to your own logging tools. This allows you to manage your n8n monitoring in your own alerting and logging processes.

## Set up log streaming

To use log streaming, you have to add a streaming destination.

1. Navigate to **Settings** > **Log Streaming**.
1. Select **Add new destination**.
1. Choose your destination type. n8n opens the **New Event Destination** modal.
1. In the **New Event Destination** modal, enter the configuration information for your event destination. These depend on the type of destination you're using.
1. Select **Events** to choose which events to stream.
1. Select **Save**.

If you self-host n8n, you can configure additional log streaming behavior using [Environment variables](../hosting/configuration/environment-variables/logs/#log-streaming).

The following events are available. You can choose which events to stream in **Settings** > **Log Streaming** > **Events**.

- Workflow
  - Started
  - Success
  - Failed
- Node executions
  - Started
  - Finished
- Audit
  - User signed up
  - User updated
  - User deleted
  - User invited
  - User invitation accepted
  - User re-invited
  - User email failed
  - User reset requested
  - User reset
  - User credentials created
  - User credentials shared
  - User credentials updated
  - User credentials deleted
  - User API created
  - User API deleted
  - Package installed
  - Package updated
  - Package deleted
  - Workflow created
  - Workflow deleted
  - Workflow updated
- AI node logs
  - Memory get messages
  - Memory added message
  - Output parser get instructions
  - Output parser parsed
  - Retriever get relevant documents
  - Embeddings embedded document
  - Embeddings embedded query
  - Document processed
  - Text splitter split
  - Tool called
  - Vector store searched
  - LLM generated
  - Vector store populated
- Runner
  - Task requested
  - Response received
- Queue
  - Job enqueued
  - Job dequeued
  - Job completed
  - Job failed
  - Job stalled

n8n supports three destination types:

- A syslog server
- A generic webhook
- A Sentry client

---

## Spotify credentials

**URL:** llms-txt#spotify-credentials

**Contents:**
- Supported authentication methods
- Related resources
- Using OAuth2

You can use these credentials to authenticate the following nodes:

- [Spotify](../../app-nodes/n8n-nodes-base.spotify/)

## Supported authentication methods

Refer to [Spotify's Web API documentation](https://developer.spotify.com/documentation/web-api) for more information about the service.

Note for n8n Cloud users

Cloud users don't need to provide connection details. Select **Connect my account** to connect through your browser.

If you're [self-hosting](../../../../hosting/) n8n, you'll need a [Spotify Developer](https://developer.spotify.com/) account so you can create a Spotify app:

1. Open the [Spotify developer dashboard](https://developer.spotify.com/dashboard).
1. Select **Create an app**.
1. Enter an **App name**, like `n8n integration`.
1. Enter an **App description**.
1. Copy the **OAuth Redirect URL** from n8n and enter it as the **Redirect URI** in your Spotify app.
1. Check the box to agree to the Spotify Terms of Service and Branding Guidelines.
1. Select **Create**. The **App overview** page opens.
1. Copy the **Client ID** and enter it in your n8n credential.
1. Copy the **Client Secret** and enter it in your n8n credential.
1. Select **Connect my account** and follow the on-screen prompts to finish authorizing the credential.

Refer to [Spotify Apps](https://developer.spotify.com/documentation/web-api/concepts/apps) for more information.

---

## Bitbucket credentials

**URL:** llms-txt#bitbucket-credentials

**Contents:**
- Prerequisites
- Supported authentication methods
- Related resources
- Using API username/app password
- App password permissions

You can use these credentials to authenticate the following nodes:

- [Bitbucket Trigger](../../trigger-nodes/n8n-nodes-base.bitbuckettrigger/)

Create a [Bitbucket](https://www.bitbucket.com/) account.

## Supported authentication methods

- API username and app password

Refer to [Bitbucket's API documentation](https://developer.atlassian.com/cloud/bitbucket/rest/intro/#authentication) for more information about the service.

## Using API username/app password

To configure this credential, you'll need:

- A **Username**: Visible in your Bitbucket profile settings **Personal settings > Account settings**.
- An **App Password**: Refer to the Bitbucket instructions to [Create an app password](https://support.atlassian.com/bitbucket-cloud/docs/create-an-app-password/).

## App password permissions

Bitbucket API credentials will only work if the user account you generated the app password for has the appropriate privilege scopes for the selected app password permissions. The n8n credentials dialog will throw an error if the user account lacks the appropriate permissions for the selected scope, like `Your credentials lack one or more required privilege scopes`.

See the [Bitbucket App password permissions documentation](https://support.atlassian.com/bitbucket-cloud/docs/app-password-permissions/) for more information on working with these permissions.

---

## Quick Base credentials

**URL:** llms-txt#quick-base-credentials

**Contents:**
- Prerequisites
- Supported authentication methods
- Related resources
- Using API key

You can use these credentials to authenticate the following nodes:

- [Quick Base](../../app-nodes/n8n-nodes-base.quickbase/)

Create a [Quick Base](https://www.quickbase.com/) account.

## Supported authentication methods

Refer to [Quick Base's API documentation](https://developer.quickbase.com/auth/) for more information about the service.

To configure this credential, you'll need:

- A **Hostname**: The string of characters located between `https://` and `/db` in your Quick Base URL.
- A **User Token**: To generate a token, select your **Profile > My preferences > My User Information > Manage my user tokens**. Refer to [Creating and using user tokens](https://helpv2.quickbase.com/hc/en-us/articles/4570374095124-Creating-and-using-user-tokens) for detailed instructions.

---

## Raindrop node

**URL:** llms-txt#raindrop-node

**Contents:**
- Operations
- Templates and examples
- What to do if your operation isn't supported

Use the Raindrop node to automate work in Raindrop, and integrate Raindrop with other applications. n8n has built-in support for a wide range of Raindrop features, including getting users, deleting tags, and creating, updating, deleting and getting collections and bookmarks.

On this page, you'll find a list of operations the Raindrop node supports and links to more resources.

Refer to [Raindrop credentials](../../credentials/raindrop/) for guidance on setting up authentication.

- Bookmark
  - Create
  - Delete
  - Get
  - Get All
  - Update
- Collection
  - Create
  - Delete
  - Get
  - Get All
  - Update
- Tag
  - Delete
  - Get All
- User
  - Get

## Templates and examples

**Fetch a YouTube playlist and send new items Raindrop**

[View template details](https://n8n.io/workflows/1217-fetch-a-youtube-playlist-and-send-new-items-raindrop/)

**Create a collection and create, update, and get a bookmark in Raindrop**

[View template details](https://n8n.io/workflows/959-create-a-collection-and-create-update-and-get-a-bookmark-in-raindrop/)

**Save Mastodon Bookmarks to Raindrop Automatically**

[View template details](https://n8n.io/workflows/4800-save-mastodon-bookmarks-to-raindrop-automatically/)

[Browse Raindrop integration templates](https://n8n.io/integrations/raindrop/), or [search all templates](https://n8n.io/workflows/)

## What to do if your operation isn't supported

If this node doesn't support the operation you want to do, you can use the [HTTP Request node](../../core-nodes/n8n-nodes-base.httprequest/) to call the service's API.

You can use the credential you created for this service in the HTTP Request node:

1. In the HTTP Request node, select **Authentication** > **Predefined Credential Type**.
1. Select the service you want to connect to.
1. Select your credential.

Refer to [Custom API operations](../../../custom-operations/) for more information.

---

## Sendy credentials

**URL:** llms-txt#sendy-credentials

**Contents:**
- Prerequisites
- Supported authentication methods
- Related resources
- Using API Key

You can use these credentials to authenticate the following nodes:

- [Sendy](../../app-nodes/n8n-nodes-base.sendy/)

Host a [Sendy](https://sendy.co/get-started) application.

## Supported authentication methods

Refer to [Sendy's API documentation](https://sendy.co/api) for more information about the service.

To configure this credential, you'll need:

- A **URL**: The URL of your Sendy application.
- An **API Key**: Get your API key from your user profile > **Settings > Your API Key**.

---

## Typeform Trigger node

**URL:** llms-txt#typeform-trigger-node

[Typeform](https://www.typeform.com/) is an online software as a service company that specializes in online form building and online surveys. Its main software creates dynamic forms based on user needs.

You can find authentication information for this node [here](../../credentials/typeform/).

Examples and templates

For usage examples and templates to help you get started, refer to n8n's [Typeform Trigger integrations](https://n8n.io/integrations/typeform-trigger/) page.

---

## Hosting n8n on Google Cloud Run

**URL:** llms-txt#hosting-n8n-on-google-cloud-run

**Contents:**
- Before you begin: get a Google Cloud project
- Easy mode
- Durable mode
- Enable APIs and set env vars
- You may need to login first
- Setup your Postgres database
- Store sensitive data in Secret Manager
- Create a service account for Cloud Run
- Deploy the Cloud Run service
- Troubleshooting

This hosting guide shows you how to self-host n8n on Google Cloud Run, a serverless container runtime. If you're just getting started with n8n and don't need a production-grade deployment, you can go with the "easy mode" option below for deployment. Otherwise, if you intend to use this n8n deployment at-scale, refer to the "durable mode" instructions further down.

You can also enable access via OAuth to Google Workspace, such as Gmail and Drive, to use these services as n8n workflow tools. Instructions for granting n8n access to these services are at the end of of this documentation.

If you want to deploy to Google Kubernetes Engine (GKE) instead, you can refer to [these instructions](../google-kubernetes-engine/).

Self-hosting knowledge prerequisites

Self-hosting n8n requires technical knowledge, including:

- Setting up and configuring servers and containers
- Managing application resources and scaling
- Securing servers and applications
- Configuring n8n

n8n recommends self-hosting for expert users. Mistakes can lead to data loss, security issues, and downtime. If you aren't experienced at managing servers, n8n recommends [n8n Cloud](https://n8n.io/cloud/).

Latest and Next versions

n8n releases a new minor version most weeks. The `latest` version is for production use. `next` is the most recent release. You should treat `next` as a beta: it may be unstable. To report issues, use the [forum](https://community.n8n.io/c/questions/12).

Current `latest`: 1.118.2\
Current `next`: 1.119.0

## Before you begin: get a Google Cloud project

If you have not yet created a Google Cloud project, [do this first](https://developers.google.com/workspace/guides/create-project) (and ensure you have billing enabled on the project; even if your Cloud Run service runs for free you must have billing activated to deploy). Otherwise, navigate to the project where you want to deploy n8n.

This is the fastest way to deploy n8n on Cloud Run. For this deployment, n8n's data is in-memory so this is only recommended for demo purposes. **Anytime this Cloud Run service scales to zero or is redeployed, the n8n data will be lost.** Refer to the durable mode instructions below if you need a production-grade deployment.

If you have not yet created a Google Cloud project, [do this first](https://developers.google.com/workspace/guides/create-project) (and ensure you have billing enabled on the project; even if your Cloud Run service will run for free you must have billing enabled to activated to deploy). Otherwise, navigate to the project where you want to deploy n8n.

Open the Cloud Shell Terminal (on the Google Cloud console, either type "G" then "S" or click on the terminal icon on the upper right).

Once your session is open, you may need to run this command first to login (and follow the steps it asks you to complete):

You can also explicitly enable the Cloud Run API (even if you don't do this, it will ask if you want this enabled when you deploy):

(you can specify whichever region you prefer, instead of "us-west1")

Once the deployment finishes, open another tab to navigate to the Service URL. n8n may still be loading and you will see a "n8n is starting up. Please wait" message, but shortly thereafter you should see the n8n login screen.

Optional: If you want to keep this n8n service running for as long as possible to avoid data loss, you can also set manual scale to 1 to prevent it from autoscaling to 0.

This does not prevent data loss completely, such as whenever the Cloud Run service is re-deployed/updated. If you want truly persistant data, you should refer to the instructions below for how to attach a database.

The following instructions are intended for a more durable, production-grade deployment of n8n on Cloud Run. It includes resources such as a database for persistance and secret manager for sensitive data.

## Enable APIs and set env vars

Open the Cloud Shell Terminal (on the Google Cloud console, either type "G" then "S" or click on the terminal icon on the upper right) and run these commands in the terminal session:

You'll also want to set some environment variables for the remainder of these instructions:

## Setup your Postgres database

Run this command to create the Postgres DB instance (it will take a few minutes to complete; also ensure you update the root-password field with your own desired password):

Once complete, you can add the database that n8n will use:

Create the DB user for n8n (change the password value, of course):

You can save the password you set for this n8n-user to a file for the next step of saving the password in Secret Manager. Be sure to delete this file later.

## Store sensitive data in Secret Manager

While not required, it's absolutely recommended to store your sensitive data in Secrets Manager.

Create a secret for the database password (replace "/your/password/file" with the file you created above for the n8n-user password):

Create an encryption key (you can use your own, this example generates a random one):

Create a secret for this encryption key (replace "my-encryption-key" if you are supplying your own):

Now you can delete my-encryption-key and the database password files you created. These values are now securely stored in Secret Manager.

## Create a service account for Cloud Run

You want this Cloud Run service to be restricted to access only the resources it needs. The following commands create the service account and adds the permissions necessary to access secrets and the database:

## Deploy the Cloud Run service

Now you can deploy your n8n service:

Once the deployment finishes, open another tab to navigate to the Service URL. You should see the n8n login screen.

If you see a "Cannot GET /" screen this usually indicates that n8n is still starting up. You can refresh the page and it should eventually load.

## (Optional) Enabling Google Workspace services as n8n tools

If you want to use Google Workspace services (Gmail, Calendar, Drive, etc.) as tools in n8n, it's recommended to setup OAuth to access these services.

First ensure the respective APIs you want are enabled:

Re-deploy n8n on Cloud Run with the necessary OAuth callback URLs as environment variables:

Lastly, you must setup OAuth for these services. Visit `https://console.cloud.google.com/auth` and follow these steps:

1. Click "Get Started" if this button shows (when you have not yet setup OAuth in this Cloud project).
1. For "App Information", enter whichever "App Name" and "User Support Email" you prefer.
1. For "Audience", select "Internal" if you intend to only enable access to your user(s) within this same Google Workspace. Otherwise, you can select "External".
1. Enter "Contact Information".
1. If you selected "External", then click "Audience" and add any test users you need to grant access.
1. Click "Clients" > "Create client", select "Web application" for "Application type", enter your n8n service URL into "Authorized JavaScript origins", and "/rest/oauth2-credential/callback" into "Authorized redirect URIs" where your YOUR-N8N-URL is also the n8n service URL (e.g. `https://n8n-12345678.us-west1.run.app/rest/oauth2-credential/callback`). Make sure you download the created client's JSON file since it contains the client secret which you will not be able to see later in the Console.
1. Click "Data Access" and add the scopes you want n8n to have access for (e.g. to access Google Sheets, you need `https://googleapis.com/auth/drive.file` and `https://googleapis.com/auth/spreadsheets`)
1. Now you should be able to use these workspace services. You can test if it works by logging into n8n, add a Tool for the respective service and add its credentials using the information in the OAuth client JSON file from step 6.

**Examples:**

Example 1 (unknown):
```unknown
gcloud auth login
```

Example 2 (unknown):
```unknown
gcloud services enable run.googleapis.com
```

Example 3 (unknown):
```unknown
gcloud run deploy n8n \
    --image=n8nio/n8n \
    --region=us-west1 \
    --allow-unauthenticated \
    --port=5678 \
    --no-cpu-throttling \
    --memory=2Gi
```

Example 4 (unknown):
```unknown
gcloud run deploy n8n \
    --image=n8nio/n8n \
    --region=us-west1 \
    --allow-unauthenticated \
    --port=5678 \
    --no-cpu-throttling \
    --memory=2Gi \
    --scaling=1
```

---

## Mailjet node

**URL:** llms-txt#mailjet-node

**Contents:**
- Operations
- Templates and examples
- What to do if your operation isn't supported

Use the Mailjet node to automate work in Mailjet, and integrate Mailjet with other applications. n8n has built-in support for a wide range of Mailjet features, including sending emails, and SMS.

On this page, you'll find a list of operations the Mailjet node supports and links to more resources.

Refer to [Mailjet credentials](../../credentials/mailjet/) for guidance on setting up authentication.

- Email
  - Send an email
  - Send an email template
- SMS
  - Send an SMS

## Templates and examples

**Forward Netflix emails to multiple email addresses with GMail and Mailjet**

[View template details](https://n8n.io/workflows/2279-forward-netflix-emails-to-multiple-email-addresses-with-gmail-and-mailjet/)

**Send an email using Mailjet**

[View template details](https://n8n.io/workflows/520-send-an-email-using-mailjet/)

**Monitor SEO Keyword Rankings with LLaMA AI & Apify Google SERP Scraping**

[View template details](https://n8n.io/workflows/4301-monitor-seo-keyword-rankings-with-llama-ai-and-apify-google-serp-scraping/)

[Browse Mailjet integration templates](https://n8n.io/integrations/mailjet/), or [search all templates](https://n8n.io/workflows/)

## What to do if your operation isn't supported

If this node doesn't support the operation you want to do, you can use the [HTTP Request node](../../core-nodes/n8n-nodes-base.httprequest/) to call the service's API.

You can use the credential you created for this service in the HTTP Request node:

1. In the HTTP Request node, select **Authentication** > **Predefined Credential Type**.
1. Select the service you want to connect to.
1. Select your credential.

Refer to [Custom API operations](../../../custom-operations/) for more information.

---

## Git credentials

**URL:** llms-txt#git-credentials

**Contents:**
- Prerequisites
- Supported authentication methods
- Related resources
- Using basic auth

You can use these credentials to authenticate the following nodes:

- [Git](../../core-nodes/n8n-nodes-base.git/)

Create an account on [GitHub](https://github.com), [GitLab](https://about.gitlab.com/), or similar platforms for use with [Git](https://git-scm.com).

## Supported authentication methods

Refer to [Git's documentation](https://git-scm.com/doc) for more information about the service.

To configure this credential, you'll need:

- A **Username** for GitHub, GitLab, or a similar platform
- A **Password** for GitHub, GitLab, or a similar platform

---

## BambooHR node

**URL:** llms-txt#bamboohr-node

**Contents:**
- Operations
- Templates and examples

Use the BambooHR node to automate work in BambooHR, and integrate BambooHR with other applications. n8n has built-in support for a wide range of BambooHR features, including creating, deleting, downloading, and getting company reports, employee documents, and files.

On this page, you'll find a list of operations the BambooHR node supports and links to more resources.

Refer to [BambooHR credentials](../../credentials/bamboohr/) for guidance on setting up authentication.

- Company Report
  - Get a company report
- Employee
  - Create an employee
  - Get an employee
  - Get all employees
  - Update an employee
- Employee Document
  - Delete an employee document
  - Download an employee document
  - Get all employee document
  - Update an employee document
  - Upload an employee document
- File
  - Delete a company file
  - Download a company file
  - Get all company files
  - Update a company file
  - Upload a company file

## Templates and examples

**BambooHR AI-Powered Company Policies and Benefits Chatbot**

[View template details](https://n8n.io/workflows/2850-bamboohr-ai-powered-company-policies-and-benefits-chatbot/)

**Test Webhooks in n8n Without Changing WEBHOOK_URL (PostBin & BambooHR Example)**

[View template details](https://n8n.io/workflows/2869-test-webhooks-in-n8n-without-changing-webhookurl-postbin-and-bamboohr-example/)

**🛠️ BambooHR Tool MCP Server 💪 all 15 operations**

[View template details](https://n8n.io/workflows/5329-bamboohr-tool-mcp-server-all-15-operations/)

[Browse BambooHR integration templates](https://n8n.io/integrations/bamboohr/), or [search all templates](https://n8n.io/workflows/)

---

## Database environment variables

**URL:** llms-txt#database-environment-variables

**Contents:**
- PostgreSQL
- SQLite

File-based configuration

You can add `_FILE` to individual variables to provide their configuration in a separate file. Refer to [Keeping sensitive data in separate files](../../configuration-methods/#keeping-sensitive-data-in-separate-files) for more details.

By default, n8n uses SQLite. n8n also supports PostgreSQL. n8n [deprecated support for MySQL and MariaDB](../../../../1-0-migration-checklist/#mysql-and-mariadb) in v1.0.

This page outlines environment variables to configure your chosen database for your self-hosted n8n instance.

| Variable                   | Type                                | Default  | Description                                                                                        |
| -------------------------- | ----------------------------------- | -------- | -------------------------------------------------------------------------------------------------- |
| `DB_TYPE` /`_FILE`         | Enum string: `sqlite`, `postgresdb` | `sqlite` | The database to use.                                                                               |
| `DB_TABLE_PREFIX`          | \*                                  | -        | Prefix to use for table names.                                                                     |
| `DB_PING_INTERVAL_SECONDS` | Number                              | `2`      | The interval, in seconds, between pings to the database to check if the connection is still alive. |

| Variable                                         | Type    | Default     | Description                                                                                                                                                              |
| ------------------------------------------------ | ------- | ----------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------ |
| `DB_POSTGRESDB_DATABASE` /`_FILE`                | String  | `n8n`       | The name of the PostgreSQL database.                                                                                                                                     |
| `DB_POSTGRESDB_HOST` /`_FILE`                    | String  | `localhost` | The PostgreSQL host.                                                                                                                                                     |
| `DB_POSTGRESDB_PORT` /`_FILE`                    | Number  | `5432`      | The PostgreSQL port.                                                                                                                                                     |
| `DB_POSTGRESDB_USER` /`_FILE`                    | String  | `postgres`  | The PostgreSQL user.                                                                                                                                                     |
| `DB_POSTGRESDB_PASSWORD` /`_FILE`                | String  | -           | The PostgreSQL password.                                                                                                                                                 |
| `DB_POSTGRESDB_POOL_SIZE` /`_FILE`               | Number  | `2`         | Control how many parallel open Postgres connections n8n should have. Increasing it may help with resource utilization, but too many connections may degrade performance. |
| `DB_POSTGRESDB_CONNECTION_TIMEOUT` /`_FILE`      | Number  | `20000`     | Postgres connection timeout (ms).                                                                                                                                        |
| `DB_POSTGRESDB_IDLE_CONNECTION_TIMEOUT` /`_FILE` | Number  | `30000`     | Amount of time before an idle connection is eligible for eviction for being idle.                                                                                        |
| `DB_POSTGRESDB_SCHEMA` /`_FILE`                  | String  | `public`    | The PostgreSQL schema.                                                                                                                                                   |
| `DB_POSTGRESDB_SSL_ENABLED` /`_FILE`             | Boolean | `false`     | Whether to enable SSL. Automatically enabled if `DB_POSTGRESDB_SSL_CA`, `DB_POSTGRESDB_SSL_CERT` or `DB_POSTGRESDB_SSL_KEY` is defined.                                  |
| `DB_POSTGRESDB_SSL_CA` /`_FILE`                  | String  | -           | The PostgreSQL SSL certificate authority.                                                                                                                                |
| `DB_POSTGRESDB_SSL_CERT` /`_FILE`                | String  | -           | The PostgreSQL SSL certificate.                                                                                                                                          |
| `DB_POSTGRESDB_SSL_KEY` /`_FILE`                 | String  | -           | The PostgreSQL SSL key.                                                                                                                                                  |
| `DB_POSTGRESDB_SSL_REJECT_UNAUTHORIZED` /`_FILE` | Boolean | `true`      | If n8n should reject unauthorized SSL connections (true) or not (false).                                                                                                 |

| Variable                      | Type    | Default | Description                                                                                                                                                                                                                                                                                                                                                                                                               |
| ----------------------------- | ------- | ------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| `DB_SQLITE_POOL_SIZE`         | Number  | `0`     | Controls whether to open the SQLite file in [WAL mode](https://www.sqlite.org/wal.html) or [rollback journal mode](https://www.sqlite.org/lockingv3.html#rollback). Uses rollback journal mode when set to zero. When greater than zero, uses WAL mode with the value determining the number of parallel SQL read connections to configure. WAL mode is much more performant and reliable than the rollback journal mode. |
| `DB_SQLITE_VACUUM_ON_STARTUP` | Boolean | `false` | Runs [VACUUM](https://www.sqlite.org/lang_vacuum.html) operation on startup to rebuild the database. Reduces file size and optimizes indexes. This is a long running blocking operation and increases start-up time.                                                                                                                                                                                                      |

---

## Summarization Chain node

**URL:** llms-txt#summarization-chain-node

**Contents:**
- Node parameters
- Node Options
- Templates and examples
- Related resources

Use the Summarization Chain node to summarize multiple documents.

On this page, you'll find the node parameters for the Summarization Chain node, and links to more resources.

Choose the type of data you need to summarize in **Data to Summarize**. The data type you choose determines the other node parameters.

- **Use Node Input (JSON)** and **Use Node Input (Binary)**: summarize the data coming into the node from the workflow.
  - You can configure the **Chunking Strategy**: choose what strategy to use to define the data chunk sizes.
    - If you choose **Simple (Define Below)** you can then set **Characters Per Chunk** and **Chunk Overlap (Characters)**.
    - Choose **Advanced** if you want to connect a splitter sub-node that provides more configuration options.
- **Use Document Loader**: summarize data provided by a document loader sub-node.

You can configure the summarization method and prompts. Select **Add Option** > **Summarization Method and Prompts**.

Options in **Summarization Method**:

- **Map Reduce**: this is the recommended option. Learn more about [Map Reduce](https://js.langchain.com/v0.1/docs/modules/chains/document/map_reduce/) in the LangChain documentation.
- **Refine**: learn more about [Refine](https://js.langchain.com/v0.1/docs/modules/chains/document/refine/) in the LangChain documentation.
- **Stuff**: learn more about [Stuff](https://js.langchain.com/v0.1/docs/modules/chains/document/stuff/) in the LangChain documentation.

You can customize the **Individual Summary Prompts** and the **Final Prompt to Combine**. There are examples in the node. You must include the `"{text}"` placeholder.

## Templates and examples

**Scrape and summarize webpages with AI**

[View template details](https://n8n.io/workflows/1951-scrape-and-summarize-webpages-with-ai/)

**⚡AI-Powered YouTube Video Summarization & Analysis**

[View template details](https://n8n.io/workflows/2679-ai-powered-youtube-video-summarization-and-analysis/)

**AI Automated HR Workflow for CV Analysis and Candidate Evaluation**

[View template details](https://n8n.io/workflows/2860-ai-automated-hr-workflow-for-cv-analysis-and-candidate-evaluation/)

[Browse Summarization Chain integration templates](https://n8n.io/integrations/summarization-chain/), or [search all templates](https://n8n.io/workflows/)

Refer to [LangChain's documentation on summarization](https://js.langchain.com/docs/tutorials/summarization/) for more information about the service.

View n8n's [Advanced AI](../../../../../advanced-ai/) documentation.

---

## npm credentials

**URL:** llms-txt#npm-credentials

**Contents:**
- Prerequisites
- Supported authentication methods
- Related resources
- Using API access token

You can use these credentials to authenticate the following nodes:

- [npm](../../app-nodes/n8n-nodes-base.npm/)

Create an [npm](https://www.npmjs.com/) account.

## Supported authentication methods

Refer to [npm's external integrations documentation](https://docs.npmjs.com/integrations/integrating-npm-with-external-services) for more information about the service.

## Using API access token

To configure this credential, you'll need:

- An **Access Token**: Create an access token by selecting **Access Tokens** from your profile menu. Refer to [npm's Creating and viewing access tokens documentation](https://docs.npmjs.com/creating-and-viewing-access-tokens) for more detailed instructions.
- A **Registry URL**: If you're using a custom npm registry, update the **Registry URL** to that custom registry. Otherwise, keep the public registry value.

---

## ConvertKit credentials

**URL:** llms-txt#convertkit-credentials

**Contents:**
- Prerequisites
- Supported authentication methods
- Related resources
- Using API key

You can use these credentials to authenticate the following nodes:

- [ConvertKit](../../app-nodes/n8n-nodes-base.convertkit/)
- [ConvertKit Trigger](../../trigger-nodes/n8n-nodes-base.convertkittrigger/)

Create a [ConvertKit](https://convertkit.com/) account.

## Supported authentication methods

Refer to [ConvertKit's API documentation](https://developers.convertkit.com/#overview) for more information about the service.

To configure this credential, you'll need:

- An **API Secret**: Access your ConvertKit API key in [**Account Settings > Advanced**](https://app.convertkit.com/account_settings/advanced_settings). Add this key as the **API Secret** in n8n.

---

## Google Sheets

**URL:** llms-txt#google-sheets

**Contents:**
- Operations
- Templates and examples
- Related resources
- Common issues
- What to do if your operation isn't supported

Use the Google Sheets node to automate work in Google Sheets, and integrate Google Sheets with other applications. n8n has built-in support for a wide range of Google Sheets features, including creating, updating, deleting, appending, removing and getting documents.

On this page, you'll find a list of operations the Google Sheets node supports and links to more resources.

Refer to [Google Sheets credentials](../../credentials/google/) for guidance on setting up authentication.

- **Document**
  - [**Create**](document-operations/#create-a-spreadsheet) a spreadsheet.
  - [**Delete**](document-operations/#delete-a-spreadsheet) a spreadsheet.
- **Sheet Within Document**
  - [**Append or Update Row**](sheet-operations/#append-or-update-row): Append a new row, or update the current one if it already exists.
  - [**Append Row**](sheet-operations/#append-row): Create a new row.
  - [**Clear**](sheet-operations/#clear-a-sheet) all data from a sheet.
  - [**Create**](sheet-operations/#create-a-new-sheet) a new sheet.
  - [**Delete**](sheet-operations/#delete-a-sheet) a sheet.
  - [**Delete Rows or Columns**](sheet-operations/#delete-rows-or-columns): Delete columns and rows from a sheet.
  - [**Get Row(s)**](sheet-operations/#get-rows): Read all rows in a sheet.
  - [**Update Row**](sheet-operations/#update-row): Update a row in a sheet.

## Templates and examples

**Generate AI Viral Videos with Seedance and Upload to TikTok, YouTube & Instagram**

[View template details](https://n8n.io/workflows/5338-generate-ai-viral-videos-with-seedance-and-upload-to-tiktok-youtube-and-instagram/)

**Generate AI Videos with Google Veo3, Save to Google Drive and Upload to YouTube**

[View template details](https://n8n.io/workflows/4846-generate-ai-videos-with-google-veo3-save-to-google-drive-and-upload-to-youtube/)

**Scrape business emails from Google Maps without the use of any third party APIs**

[View template details](https://n8n.io/workflows/2567-scrape-business-emails-from-google-maps-without-the-use-of-any-third-party-apis/)

[Browse Google Sheets integration templates](https://n8n.io/integrations/google-sheets/), or [search all templates](https://n8n.io/workflows/)

Refer to [Google Sheet's API documentation](https://developers.google.com/sheets/api) for more information about the service.

For common questions or issues and suggested solutions, refer to [Common issues](common-issues/).

## What to do if your operation isn't supported

If this node doesn't support the operation you want to do, you can use the [HTTP Request node](../../core-nodes/n8n-nodes-base.httprequest/) to call the service's API.

You can use the credential you created for this service in the HTTP Request node:

1. In the HTTP Request node, select **Authentication** > **Predefined Credential Type**.
1. Select the service you want to connect to.
1. Select your credential.

Refer to [Custom API operations](../../../custom-operations/) for more information.

---

## Contentful node

**URL:** llms-txt#contentful-node

**Contents:**
- Operations
- Templates and examples

Use the Contentful node to automate work in Contentful, and integrate Contentful with other applications. n8n has built-in support for a wide range of Contentful features, including getting assets, content types, entries, locales, and space.

On this page, you'll find a list of operations the Contentful node supports and links to more resources.

Refer to [Contentful credentials](../../credentials/contentful/) for guidance on setting up authentication.

- Asset
  - Get
  - Get All
- Content Type
  - Get
- Entry
  - Get
  - Get All
- Locale
  - Get All
- Space
  - Get

## Templates and examples

**Generate Knowledge Base Articles with GPT & Perplexity AI for Contentful CMS**

[View template details](https://n8n.io/workflows/4012-generate-knowledge-base-articles-with-gpt-and-perplexity-ai-for-contentful-cms/)

**Convert Markdown Content to Contentful Rich Text with AI Formatting**

[View template details](https://n8n.io/workflows/4078-convert-markdown-content-to-contentful-rich-text-with-ai-formatting/)

**Get all the entries from Contentful**

[View template details](https://n8n.io/workflows/640-get-all-the-entries-from-contentful/)

[Browse Contentful integration templates](https://n8n.io/integrations/contentful/), or [search all templates](https://n8n.io/workflows/)

---

## Embeddings Ollama node

**URL:** llms-txt#embeddings-ollama-node

**Contents:**
- Node parameters
- Templates and examples
- Related resources

Use the Embeddings Ollama node to generate [embeddings](../../../../../glossary/#ai-embedding) for a given text.

On this page, you'll find the node parameters for the Embeddings Ollama node, and links to more resources.

You can find authentication information for this node [here](../../../credentials/ollama/).

Parameter resolution in sub-nodes

Sub-nodes behave differently to other nodes when processing multiple items using an expression.

Most nodes, including root nodes, take any number of items as input, process these items, and output the results. You can use expressions to refer to input items, and the node resolves the expression for each item in turn. For example, given an input of five `name` values, the expression `{{ $json.name }}` resolves to each name in turn.

In sub-nodes, the expression always resolves to the first item. For example, given an input of five `name` values, the expression `{{ $json.name }}` always resolves to the first name.

- **Model**: Select the model to use to generate the embedding. Choose from:
  - [all-minilm](https://ollama.com/library/all-minilm) (384 Dimensions)
  - [nomic-embed-text](https://ollama.com/library/nomic-embed-text) (768 Dimensions)

Learn more about available models in [Ollama's models documentation](https://ollama.ai/library).

## Templates and examples

**Local Chatbot with Retrieval Augmented Generation (RAG)**

[View template details](https://n8n.io/workflows/5148-local-chatbot-with-retrieval-augmented-generation-rag/)

**Bitrix24 AI-Powered RAG Chatbot for Open Line Channels**

[View template details](https://n8n.io/workflows/3094-bitrix24-ai-powered-rag-chatbot-for-open-line-channels/)

**Chat with Your Email History using Telegram, Mistral and Pgvector for RAG**

[View template details](https://n8n.io/workflows/3763-chat-with-your-email-history-using-telegram-mistral-and-pgvector-for-rag/)

[Browse Embeddings Ollama integration templates](https://n8n.io/integrations/embeddings-ollama/), or [search all templates](https://n8n.io/workflows/)

Refer to [Langchain's Ollama embeddings documentation](https://js.langchain.com/docs/integrations/text_embedding/ollama/) for more information about the service.

View n8n's [Advanced AI](../../../../../advanced-ai/) documentation.

---

## API authentication

**URL:** llms-txt#api-authentication

**Contents:**
- API Scopes
- Create an API key
- Call the API using your key

n8n uses API keys to authenticate API calls.

The n8n API isn't available during the free trial. Please upgrade to access this feature.

Users of [enterprise instances](https://n8n.io/enterprise/) can limit which resources and actions a key can access with scopes. API key scopes allow you specify the exact level of access a key needs for its intended purpose.

Non-enterprise API keys have full access to all the account's resources and capabilities.

1. Log in to n8n.
1. Go to **Settings** > **n8n API**.
1. Select **Create an API key**.
1. Choose a **Label** and set an **Expiration** time for the key.
1. If on an enterprise plan, choose the **Scopes** to give the key.
1. Copy **My API Key** and use this key to authenticate your calls.

## Call the API using your key

Send the API key in your API call as a header named `X-N8N-API-KEY`.

For example, say you want to get all active workflows. Your curl request will look like this:

---

## Pushover credentials

**URL:** llms-txt#pushover-credentials

**Contents:**
- Prerequisites
- Supported authentication methods
- Related resources
- Using API Key

You can use these credentials to authenticate the following nodes:

- [Pushover](../../app-nodes/n8n-nodes-base.pushover/)

Create a [Pushover](https://pushover.net) account.

## Supported authentication methods

Refer to [Pushover's API documentation](https://pushover.net/api) for more information about authenticating with the service.

To configure this credential, you'll need:

- An **API Key**: Generated when you [register an application](https://pushover.net/apps/build). Refer to [Application Registration](https://pushover.net/api#registration) for more information.

---

## DHL credentials

**URL:** llms-txt#dhl-credentials

**Contents:**
- Supported authentication methods
- Related resources
- Using API key

You can use these credentials to authenticate the following nodes:

- [DHL](../../app-nodes/n8n-nodes-base.dhl/)

## Supported authentication methods

Refer to [DHL's Developer documentation](https://support-developer.dhl.com/support/home) for more information about the service.

To configure this credential, you'll need a [DHL Developer](https://developer.dhl.com/user/register) account and:

To get an API key, create an app:

1. In the DHL Developer portal, select the user icon to open your [User Apps](https://developer.dhl.com/user/apps).
1. Select **+ Create App**.
1. Enter an **App name**, like `n8n integration`.
1. Enter a **Machine name**, like `n8n_integration`.
1. In **SELECT APIs**, select **Shipment Tracking - Unified**. The API is added to the **Add API to app** section.
1. In the **Add API to app** section, select the **+** next to the **Shipment Tracking - Unified** API.
1. Select **Create App**. The **Apps** page opens, displaying the app you just created.
1. Select the app you just created to view its details.
1. Select **Show key** next to **API Key**.
1. Copy the **API Key** and enter it in your n8n credential.

Refer to [How to create an app?](https://support-developer.dhl.com/support/solutions/articles/47001177011-how-to-create-an-app-) for more information.

---

## Pinecone Vector Store node

**URL:** llms-txt#pinecone-vector-store-node

**Contents:**
- Node usage patterns
  - Use as a regular node to insert, update, and retrieve documents
  - Connect directly to an AI agent as a tool
  - Use a retriever to fetch documents
  - Use the Vector Store Question Answer Tool to answer questions
- Node parameters
  - Operation Mode
  - Rerank Results
  - Get Many parameters
  - Insert Documents parameters

Use the Pinecone node to interact with your Pinecone database as [vector store](../../../../../glossary/#ai-vector-store). You can insert documents into a vector database, get documents from a vector database, retrieve documents to provide them to a retriever connected to a [chain](../../../../../glossary/#ai-chain), or connect directly to an [agent](../../../../../glossary/#ai-agent) as a [tool](../../../../../glossary/#ai-tool). You can also update an item in a vector database by its ID.

On this page, you'll find the node parameters for the Pinecone node, and links to more resources.

You can find authentication information for this node [here](../../../credentials/pinecone/).

Parameter resolution in sub-nodes

Sub-nodes behave differently to other nodes when processing multiple items using an expression.

Most nodes, including root nodes, take any number of items as input, process these items, and output the results. You can use expressions to refer to input items, and the node resolves the expression for each item in turn. For example, given an input of five `name` values, the expression `{{ $json.name }}` resolves to each name in turn.

In sub-nodes, the expression always resolves to the first item. For example, given an input of five `name` values, the expression `{{ $json.name }}` always resolves to the first name.

## Node usage patterns

You can use the Pinecone Vector Store node in the following patterns.

### Use as a regular node to insert, update, and retrieve documents

You can use the Pinecone Vector Store as a regular node to insert, update, or get documents. This pattern places the Pinecone Vector Store in the regular connection flow without using an agent.

You can see an example of this in scenario 1 of [this template](https://n8n.io/workflows/2165-chat-with-pdf-docs-using-ai-quoting-sources/).

### Connect directly to an AI agent as a tool

You can connect the Pinecone Vector Store node directly to the tool connector of an [AI agent](../n8n-nodes-langchain.agent/) to use a vector store as a resource when answering queries.

Here, the connection would be: AI agent (tools connector) -> Pinecone Vector Store node.

### Use a retriever to fetch documents

You can use the [Vector Store Retriever](../../sub-nodes/n8n-nodes-langchain.retrievervectorstore/) node with the Pinecone Vector Store node to fetch documents from the Pinecone Vector Store node. This is often used with the [Question and Answer Chain](../n8n-nodes-langchain.chainretrievalqa/) node to fetch documents from the vector store that match the given chat input.

An [example of the connection flow](https://n8n.io/workflows/1960-ask-questions-about-a-pdf-using-ai/) would be: Question and Answer Chain (Retriever connector) -> Vector Store Retriever (Vector Store connector) -> Pinecone Vector Store.

### Use the Vector Store Question Answer Tool to answer questions

Another pattern uses the [Vector Store Question Answer Tool](../../sub-nodes/n8n-nodes-langchain.toolvectorstore/) to summarize results and answer questions from the Pinecone Vector Store node. Rather than connecting the Pinecone Vector Store directly as a tool, this pattern uses a tool specifically designed to summarizes data in the vector store.

The [connections flow](https://n8n.io/workflows/2705-chat-with-github-api-documentation-rag-powered-chatbot-with-pinecone-and-openai/) in this case would look like this: AI agent (tools connector) -> Vector Store Question Answer Tool (Vector Store connector) -> Pinecone Vector store.

This Vector Store node has five modes: **Get Many**, **Insert Documents**, **Retrieve Documents (As Vector Store for Chain/Tool)**, **Retrieve Documents (As Tool for AI Agent)**, and **Update Documents**. The mode you select determines the operations you can perform with the node and what inputs and outputs are available.

In this mode, you can retrieve multiple documents from your vector database by providing a prompt. The prompt will be embedded and used for similarity search. The node will return the documents that are most similar to the prompt with their similarity score. This is useful if you want to retrieve a list of similar documents and pass them to an agent as additional context.

#### Insert Documents

Use Insert Documents mode to insert new documents into your vector database.

#### Retrieve Documents (As Vector Store for Chain/Tool)

Use Retrieve Documents (As Vector Store for Chain/Tool) mode with a vector-store retriever to retrieve documents from a vector database and provide them to the retriever connected to a chain. In this mode you must connect the node to a retriever node or root node.

#### Retrieve Documents (As Tool for AI Agent)

Use Retrieve Documents (As Tool for AI Agent) mode to use the vector store as a tool resource when answering queries. When formulating responses, the agent uses the vector store when the vector store name and description match the question details.

#### Update Documents

Use Update Documents mode to update documents in a vector database by ID. Fill in the **ID** with the ID of the embedding entry to update.

Enables [reranking](../../../../../glossary/#ai-reranking). If you enable this option, you must connect a reranking node to the vector store. That node will then rerank the results for queries. You can use this option with the `Get Many`, `Retrieve Documents (As Vector Store for Chain/Tool)` and `Retrieve Documents (As Tool for AI Agent)` modes.

### Get Many parameters

- **Pinecone Index**: Select or enter the Pinecone Index to use.
- **Prompt**: Enter your search query.
- **Limit**: Enter how many results to retrieve from the vector store. For example, set this to `10` to get the ten best results.

### Insert Documents parameters

- **Pinecone Index**: Select or enter the Pinecone Index to use.

### Retrieve Documents (As Vector Store for Chain/Tool) parameters

- **Pinecone Index**: Select or enter the Pinecone Index to use.

### Retrieve Documents (As Tool for AI Agent) parameters

- **Name**: The name of the vector store.
- **Description**: Explain to the LLM what this tool does. A good, specific description allows LLMs to produce expected results more often.
- **Pinecone Index**: Select or enter the Pinecone Index to use.
- **Limit**: Enter how many results to retrieve from the vector store. For example, set this to `10` to get the ten best results.

### Parameters for **Update Documents**

### Pinecone Namespace

Another segregation option for how to store your data within the index.

Available in **Get Many** mode. When searching for data, use this to match with metadata associated with the document.

This is an `AND` query. If you specify more than one metadata filter field, all of them must match.

When inserting data, the metadata is set using the document loader. Refer to [Default Data Loader](../../sub-nodes/n8n-nodes-langchain.documentdefaultdataloader/) for more information on loading documents.

Available in **Insert Documents** mode. Deletes all data from the namespace before inserting the new data.

## Templates and examples

**Ask questions about a PDF using AI**

[View template details](https://n8n.io/workflows/1960-ask-questions-about-a-pdf-using-ai/)

**Chat with PDF docs using AI (quoting sources)**

[View template details](https://n8n.io/workflows/2165-chat-with-pdf-docs-using-ai-quoting-sources/)

**RAG Chatbot for Company Documents using Google Drive and Gemini**

[View template details](https://n8n.io/workflows/2753-rag-chatbot-for-company-documents-using-google-drive-and-gemini/)

[Browse Pinecone Vector Store integration templates](https://n8n.io/integrations/pinecone-vector-store/), or [search all templates](https://n8n.io/workflows/)

Refer to [LangChain's Pinecone documentation](https://js.langchain.com/docs/integrations/vectorstores/pinecone/) for more information about the service.

View n8n's [Advanced AI](../../../../../advanced-ai/) documentation.

### Find your Pinecone index and namespace

Your Pinecone index and namespace are available in your Pinecone account.

---

## Rapid7 InsightVM credentials

**URL:** llms-txt#rapid7-insightvm-credentials

**Contents:**
- Prerequisites
- Supported authentication methods
- Related resources
- Using API key

You can use these credentials to authenticate when using the [HTTP Request node](../../core-nodes/n8n-nodes-base.httprequest/) to make a [Custom API call](../../../custom-operations/).

Create a [Rapid7 InsightVM](https://www.rapid7.com/products/insightvm/) account.

## Supported authentication methods

Refer to [Rapid7 InsightVM's API documentation](https://help.rapid7.com/insightvm/en-us/api/integrations.html) for more information about the service.

This is a credential-only node. Refer to [Custom API operations](../../../custom-operations/) to learn more. View [example workflows and related content](https://n8n.io/integrations/rapid7-insight-platform/) on n8n's website.

To configure this credential, you'll need a [Rapid7 InsightVM](https://www.rapid7.com/products/insightvm/) account and:

- A **URL**: The API endpoint URL where the resource or data you are requesting lives. You can find more information about the expected format in the [endpoint section of the Rapid7's API overview](https://docs.rapid7.com/insight/api-overview/#endpoint).
- An **API Key**: Refer to [Rapid7's Managing Platform API Keys documentation](https://docs.rapid7.com/insight/managing-platform-api-keys/) to create an API key.

Refer to [Rapid7 InsightVM's API documentation](https://help.rapid7.com/insightvm/en-us/api/integrations.html) for more information about authenticating to the service.

---

## Google Calendar Trigger node

**URL:** llms-txt#google-calendar-trigger-node

**Contents:**
- Events
- Related resources

[Google Calendar](https://www.google.com/calendar/) is a time-management and scheduling calendar service developed by Google.

You can find authentication information for this node [here](../../credentials/google/).

Examples and templates

For usage examples and templates to help you get started, refer to n8n's [Google Calendar Trigger integrations](https://n8n.io/integrations/google-calendar-trigger/) page.

- **Event Cancelled**
- **Event Created**
- **Event Ended**
- **Event Started**
- **Event Updated**

[Browse Google Calendar Trigger integration templates](https://n8n.io/integrations/google-calendar-trigger/), or [search all templates](https://n8n.io/workflows/)

n8n provides an app node for Google Calendar. You can find the node docs [here](../../app-nodes/n8n-nodes-base.googlecalendar/).

View [example workflows and related content](https://n8n.io/integrations/google-calendar-trigger/) on n8n's website.

Refer to [Google Calendar's documentation](https://developers.google.com/calendar/api/v3/reference) for details about their API.

---

## n8n displays "Today's date is <unix timestamp>"

**URL:** llms-txt#n8n-displays-"today's-date-is-<unix-timestamp>"

---

## n8n Docs

**URL:** llms-txt#n8n-docs

> Documentation for n8n, a workflow automation platform.

Documentation for n8n, a workflow automation platform. This file helps LLMs understand and use the documentation more effectively.

---

## KoboToolbox node

**URL:** llms-txt#kobotoolbox-node

**Contents:**
- Operations
- Templates and examples
- Options
  - Query Options
  - Submission options
- What to do if your operation isn't supported

Use the KoboToolbox node to automate work in KoboToolbox, and integrate KoboToolbox with other applications. n8n has built-in support for a wide range of KoboToolbox features, including creating, updating, deleting, and getting files, forms, hooks, and submissions.

On this page, you'll find a list of operations the KoboToolbox node supports and links to more resources.

Refer to [KoboToolbox credentials](../../credentials/kobotoolbox/) for guidance on setting up authentication.

- File
  - Create
  - Delete
  - Get
  - Get Many
- Form
  - Get
  - Get Many
    - Redeploy
- Hook
  - Get
  - Get Many
  - Logs
  - Retry All
  - Retry One
- Submission
  - Delete
  - Get
  - Get Many
  - Get Validation Status
  - Update Validation Status

## Templates and examples

[Browse KoboToolbox integration templates](https://n8n.io/integrations/kobotoolbox/), or [search all templates](https://n8n.io/workflows/)

The Query Submission operation supports query options:

- In the main section of the **Parameters** panel:
  - **Start** controls the index offset to start the query from (to use the API pagination logic).
  - **Limit** sets the maximum number of records to return. Note that the API always has a limit of 30,000 returned records, whatever value you provide.
- In the **Query Options** section, you can activate the following parameters:
  - **Query** lets you specify filter predicates in MongoDB's JSON query format. For example: `{"status": "success", "_submission_time": {"$lt": "2021-11-01T01:02:03"}}` queries for all submissions with the value `success` for the field `status`, and submitted before November 1st, 2021, 01:02:03.
  - **Fields** lets you specify the list of fields you want to fetch, to make the response lighter.
  - **Sort** lets you provide a list of sorting criteria in MongoDB JSON format. For example, `{"status": 1, "_submission_time": -1}` specifies a sort order by ascending status, and then descending submission time.

More details about these options can be found in the [Formhub API docs](<https://github.com/SEL-Columbia/formhub/wiki/Formhub-Access-Points-(API)#api-parameters>)

### Submission options

All operations that return form submission data offer options to tweak the response. These include:

- Download options lets you download any attachment linked to each particular form submissions, such as pictures and videos. It also lets you select the naming pattern, and the file size to download (if available - typically for images).
- Formatting options perform some reformatting as described in [About reformatting](#about-reformatting).

#### About reformatting

The default JSON format for KoboToolbox submission data is sometimes hard to deal with, because it's not schema-aware, and all fields are therefore returned as strings.

This node provides a lightweight opinionated reformatting logic, enabled with the **Reformat?** parameter, available on all operations that return form submissions: the submission query, get, and the attachment download operations.

When enabled, the reformatting:

- Reorganizes the JSON into a multi-level hierarchy following the form's groups. By default, question grouping hierarchy is materialized by a `/` character in the field names, for example `Group1/Question1`. With reformatting enabled, n8n reorganizes these into `Group1.Question1`, as nested JSON objects.
- Renames fields to trim `_` (not supported by many downstream systems).
- Parses all geospatial fields (Point, Line, and Area question types) into their standard GeoJSON equivalent.
- Splits all fields matching any of the **Multiselect Mask** wildcard masks into an array. Since the multi-select fields appear as space-separated strings, they can't be guessed algorithmically, so you must provide a field naming mask. Format the masks as a comma-separated list. Lists support the `*` wildcard.
- Converts all fields matching any of the **Number Mask** wildcard masks into a JSON float.

Here's a detailed example in JSON:

With reformatting enabled, and the appropriate masks for multi-select and number formatting (for example, `Crops_*` and `*_sqm` respectively), n8n parses it into:

## What to do if your operation isn't supported

If this node doesn't support the operation you want to do, you can use the [HTTP Request node](../../core-nodes/n8n-nodes-base.httprequest/) to call the service's API.

You can use the credential you created for this service in the HTTP Request node:

1. In the HTTP Request node, select **Authentication** > **Predefined Credential Type**.
1. Select the service you want to connect to.
1. Select your credential.

Refer to [Custom API operations](../../../custom-operations/) for more information.

**Examples:**

Example 1 (unknown):
```unknown
{
  "_id": 471987,
  "formhub/uuid": "189436bb09a54957bfcc798e338b54d6",
  "start": "2021-12-05T16:13:38.527+02:00",
  "end": "2021-12-05T16:15:33.407+02:00",
  "Field_Details/Field_Name": "Test Fields",
  "Field_Details/Field_Location": "-1.932914 30.078211 1421 165",
  "Field_Details/Field_Shape": "-1.932914 30.078211 1421 165;-1.933011 30.078085 0 0;-1.933257 30.078004 0 0;-1.933338 30.078197 0 0;-1.933107 30.078299 0 0;-1.932914 30.078211 1421 165",
  "Field_Details/Crops_Grown": "maize beans avocado",
  "Field_Details/Field_Size_sqm": "2300",
  "__version__": "veGcULpqP6JNFKRJbbMvMs",
  "meta/instanceID": "uuid:2356cbbe-c1fd-414d-85c8-84f33e92618a",
  "_xform_id_string": "ajXVJpBkTD5tB4Nu9QXpgm",
  "_uuid": "2356cbbe-c1fd-414d-85c8-84f33e92618a",
  "_attachments": [],
  "_status": "submitted_via_web",
  "_geolocation": [
    -1.932914,
    30.078211
  ],
  "_submission_time": "2021-12-05T14:15:44",
  "_tags": [],
  "_notes": [],
  "_validation_status": {},
  "_submitted_by": null
}
```

Example 2 (unknown):
```unknown
{
  "id": 471987,
  "formhub": {
    "uuid": "189436bb09a54957bfcc798e338b54d6"
  },
  "start": "2021-12-05T16:13:38.527+02:00",
  "end": "2021-12-05T16:15:33.407+02:00",
  "Field_Details": {
    "Field_Name": "Test Fields",
    "Field_Location": {
      "lat": -1.932914,
      "lon": 30.078211
    },
    "Field_Shape": {
      "type": "polygon",
      "coordinates": [
        {
          "lat": -1.932914,
          "lon": 30.078211
        },
        {
          "lat": -1.933011,
          "lon": 30.078085
        },
        {
          "lat": -1.933257,
          "lon": 30.078004
        },
        {
          "lat": -1.933338,
          "lon": 30.078197
        },
        {
          "lat": -1.933107,
          "lon": 30.078299
        },
        {
          "lat": -1.932914,
          "lon": 30.078211
        }
      ]
    },
    "Crops_Grown": [
      "maize",
      "beans",
      "avocado"
    ],
    "Field_Size_sqm": 2300
  },
  "version": "veGcULpqP6JNFKRJbbMvMs",
  "meta": {
    "instanceID": "uuid:2356cbbe-c1fd-414d-85c8-84f33e92618a"
  },
  "xform_id_string": "ajXVJpBkTD5tB4Nu9QXpgm",
  "uuid": "2356cbbe-c1fd-414d-85c8-84f33e92618a",
  "attachments": [],
  "status": "submitted_via_web",
  "geolocation": {
    "lat": -1.932914,
    "lon": 30.078211
  },
  "submission_time": "2021-12-05T14:15:44",
  "tags": [],
  "notes": [],
  "validation_status": {},
  "submitted_by": null
}
```

---

## HELP n8n_scaling_mode_queue_jobs_failed Total number of jobs failed across all workers in scaling mode since instance start.

**URL:** llms-txt#help-n8n_scaling_mode_queue_jobs_failed-total-number-of-jobs-failed-across-all-workers-in-scaling-mode-since-instance-start.

---

## n8n node linter

**URL:** llms-txt#n8n-node-linter

**Contents:**
- Setup
- Usage
  - Linting
  - Exceptions

n8n's node linter, [`eslint-plugin-n8n-nodes-base`](https://github.com/ivov/eslint-plugin-n8n-nodes-base), statically analyzes ("lints") the source code of n8n nodes and credentials in the official repository and in community packages. The linter detects issues and automatically fixes them to help you follow best practices.

`eslint-plugin-n8n-nodes-base` contains a [collection of rules](https://github.com/ivov/eslint-plugin-n8n-nodes-base#ruleset) for node files (`*.node.ts`), resource description files (`*Description.ts`), credential files (`*.credentials.ts`), and the `package.json` of a community package.

If using the [n8n node starter](https://github.com/n8n-io/n8n-nodes-starter): Run `npm install` in the starter project to install all dependencies. Once the installation finishes, the linter is available to you.

If using VS Code, install the [ESLint VS Code extension](https://marketplace.visualstudio.com/items?itemName=dbaeumer.vscode-eslint). For other IDEs, refer to their ESLint integrations.

Don't edit the configuration file

[`.eslintrc.js`](https://github.com/n8n-io/n8n-nodes-starter/blob/master/.eslintrc.js) contains the configuration for `eslint-plugin-n8n-nodes-base`. Don't edit this file.

You can use the linter in a community package or in the main n8n repository.

In a community package, the linter runs automatically after installing dependencies and before publishing the package to npm. In the [main n8n repository](https://github.com/n8n-io/n8n), the linter runs automatically using GitHub Actions whenever you push to your pull request.

In both cases, VS Code lints in the background as you work on your project. Hover over a detected issue to see a full description of the linting and a link to further information.

You can also run the linter manually:

- Run `npm run lint` to lint and view detected issues in your console.
- Run `npm run lintfix` to lint and automatically fix issues. The linter fixes violations of rules [marked as automatically fixable](https://github.com/ivov/eslint-plugin-n8n-nodes-base#ruleset).

Both commands can run in the root directory of your community package, or in `/packages/nodes-base/` in the main repository.

Instead of fixing a rule violation, you can also make an exception for it, so the linter doesn't flag it.

To make a lint exception from VS Code: hover over the issue and click on `Quick fix` (or `cmd+.` in macOS) and select **Disable {rule} for this line**. Only disable rules for a line where you have good reason to. If you think the linter is incorrectly reporting an issue, please [report it in the linter repository](https://github.com/ivov/eslint-plugin-n8n-nodes-base/issues).

To add a lint exception to a single file, add a code comment. In particular, TSLint rules may not show up in VS Code and may need to be turned off using code comments. Refer to the [TSLint documentation](https://palantir.github.io/tslint/usage/rule-flags/) for more guidance.

---

## Venafi TLS Protect Cloud node

**URL:** llms-txt#venafi-tls-protect-cloud-node

**Contents:**
- Operations
- Templates and examples
- Related resources
- What to do if your operation isn't supported

Use the Venafi TLS Protect Cloud node to automate work in Venafi TLS Protect Cloud, and integrate Venafi TLS Protect Cloud with other applications. n8n has built-in support for a wide range of Venafi TLS Protect Cloud features, including deleting and downloading certificates, as well as creating certificates requests.

On this page, you'll find a list of operations the Venafi TLS Protect Cloud node supports and links to more resources.

Refer to [Venafi TLS Protect Cloud credentials](../../credentials/venafitlsprotectcloud/) for guidance on setting up authentication.

- Certificate
  - Delete
  - Download
  - Get
  - Get Many
  - Renew
- Certificate Request
  - Create
  - Get
  - Get Many

## Templates and examples

[Browse Venafi TLS Protect Cloud integration templates](https://n8n.io/integrations/venafi-tls-protect-cloud/), or [search all templates](https://n8n.io/workflows/)

Refer to [Venafi's REST API documentation](https://docs.venafi.cloud/api/vaas-rest-api/) for more information on this service.

- A [trigger node](../../trigger-nodes/n8n-nodes-base.venafitlsprotectcloudtrigger/) for Venafi TLS Protect Cloud.
- A [node](../n8n-nodes-base.venafitlsprotectdatacenter/) for Venafi TLS Protect Datacenter.

## What to do if your operation isn't supported

If this node doesn't support the operation you want to do, you can use the [HTTP Request node](../../core-nodes/n8n-nodes-base.httprequest/) to call the service's API.

You can use the credential you created for this service in the HTTP Request node:

1. In the HTTP Request node, select **Authentication** > **Predefined Credential Type**.
1. Select the service you want to connect to.
1. Select your credential.

Refer to [Custom API operations](../../../custom-operations/) for more information.

---

## Hosting n8n on Amazon Web Services

**URL:** llms-txt#hosting-n8n-on-amazon-web-services

**Contents:**
- Hosting options
- Prerequisites
- Create a cluster
- Clone configuration repository
- Configure Postgres
  - Configure volume for persistent storage
  - Postgres environment variables
- Configure n8n
  - Create a volume for file storage
  - Pod resources

This hosting guide shows you how to self-host n8n with Amazon Web Services (AWS). It uses n8n with Postgres as a database backend using Kubernetes to manage the necessary resources and reverse proxy.

AWS offers several ways suitable for hosting n8n, including EC2 (virtual machines), and EKS (containers running with Kubernetes).

This guide uses [EKS](https://aws.amazon.com/eks/) as the hosting option. Using Kubernetes requires some additional complexity and configuration, but is the best method for scaling n8n as demand changes.

The steps in this guide use a mix of the AWS UI and [the eksctl CLI tool for EKS](https://eksctl.io).

While not mentioned in the documentation for eksctl, you also need to [install the AWS CLI tool](https://docs.aws.amazon.com/cli/latest/userguide/getting-started-install.html), and [configure authentication of the tool](https://docs.aws.amazon.com/cli/latest/userguide/cli-configure-quickstart.html).

Self-hosting knowledge prerequisites

Self-hosting n8n requires technical knowledge, including:

- Setting up and configuring servers and containers
- Managing application resources and scaling
- Securing servers and applications
- Configuring n8n

n8n recommends self-hosting for expert users. Mistakes can lead to data loss, security issues, and downtime. If you aren't experienced at managing servers, n8n recommends [n8n Cloud](https://n8n.io/cloud/).

Latest and Next versions

n8n releases a new minor version most weeks. The `latest` version is for production use. `next` is the most recent release. You should treat `next` as a beta: it may be unstable. To report issues, use the [forum](https://community.n8n.io/c/questions/12).

Current `latest`: 1.118.2\
Current `next`: 1.119.0

Use the eksctl tool to create a cluster specifying a name and a region with the following command:

This can take a while to create the cluster.

Once the cluster is created, eksctl automatically sets the kubectl context to the cluster.

## Clone configuration repository

Kubernetes and n8n require a series of configuration files. You can clone these from [this repository](https://github.com/n8n-io/n8n-hosting). The following steps tell you what each file does, and what settings you need to change.

Clone the repository with the following command:

And change directory:

## Configure Postgres

For larger scale n8n deployments, Postgres provides a more robust database backend than SQLite.

### Configure volume for persistent storage

To maintain data between pod restarts, the Postgres deployment needs a persistent volume. The default AWS storage class, [gp3](https://docs.aws.amazon.com/ebs/latest/userguide/general-purpose.html#gp3-ebs-volume-type), is suitable for this purpose. This is defined in the `postgres-claim0-persistentvolumeclaim.yaml` manifest.

### Postgres environment variables

Postgres needs some environment variables set to pass to the application running in the containers.

The example `postgres-secret.yaml` file contains placeholders you need to replace with values of your own for user details and the database to use.

The `postgres-deployment.yaml` manifest then uses the values from this manifest file to send to the application pods.

### Create a volume for file storage

While not essential for running n8n, using persistent volumes helps maintain files uploaded while using n8n and if you want to persist [manual n8n encryption keys](../../../configuration/environment-variables/deployment/) between restarts, which saves a file containing the key into file storage during startup.

The `n8n-claim0-persistentvolumeclaim.yaml` manifest creates this, and the n8n Deployment mounts that claim in the `volumes` section of the `n8n-deployment.yaml` manifest.

[Kubernetes](https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/) lets you specify the minimum resources application containers need and the limits they can run to. The example YAML files cloned above contain the following in the `resources` section of the `n8n-deployment.yaml` file:

This defines a minimum of 250mb per container, a maximum of 500mb, and lets Kubernetes handle CPU. You can change these values to match your own needs. As a guide, here are the resources values for the n8n cloud offerings:

- **Start**: 320mb RAM, 10 millicore CPU burstable
- **Pro (10k executions)**: 640mb RAM, 20 millicore CPU burstable
- **Pro (50k executions)**: 1280mb RAM, 80 millicore CPU burstable

### Optional: Environment variables

You can configure n8n settings and behaviors using environment variables.

Create an `n8n-secret.yaml` file. Refer to [Environment variables](../../../configuration/environment-variables/) for n8n environment variables details.

The two deployment manifests (`n8n-deployment.yaml` and `postgres-deployment.yaml`) define the n8n and Postgres applications to Kubernetes.

The manifests define the following:

- Send the environment variables defined to each application pod
- Define the container image to use
- Set resource consumption limits
- The `volumes` defined earlier and `volumeMounts` to define the path in the container to mount volumes.
- Scaling and restart policies. The example manifests define one instance of each pod. You should change this to meet your needs.

The two service manifests (`postgres-service.yaml` and `n8n-service.yaml`) expose the services to the outside world using the Kubernetes load balancer using ports 5432 and 5678 respectively by default.

## Send to Kubernetes cluster

Send all the manifests to the cluster by running the following command in the `n8n-kubernetes-hosting` directory:

You may see an error message about not finding an "n8n" namespace as that resources isn't ready yet. You can run the same command again, or apply the namespace manifest first with the following command:

n8n typically operates on a subdomain. Create a DNS record with your provider for the subdomain and point it to a static address of the instance.

To find the address of the n8n service running on the instance:

1. Open the **Clusters** section of the **Amazon Elastic Kubernetes Service** page in the AWS console.
1. Select the name of the cluster to open its configuration page.
1. Select the **Resources** tab, then **Service and networking** > **Services**.
1. Select the **n8n** service and copy the **Load balancer URLs** value. Use this value suffixed with the n8n service port (5678) for DNS.

This guide uses HTTP connections for the services it defines, for example in `n8n-deployment.yaml`. However, if you click the **Load balancer URLs** value, EKS takes you to an "HTTPS" URL which results in an error. To solve this, when you open the n8n subdomain, make sure to use HTTP.

If you need to delete the setup, you can remove the resources created by the manifests with the following command:

- Learn more about [configuring](../../../configuration/environment-variables/) and [scaling](../../../scaling/overview/) n8n.
- Or explore using n8n: try the [Quickstarts](../../../../try-it-out/).

**Examples:**

Example 1 (unknown):
```unknown
eksctl create cluster --name n8n --region <your-aws-region>
```

Example 2 (unknown):
```unknown
git clone https://github.com/n8n-io/n8n-hosting.git
```

Example 3 (unknown):
```unknown
cd n8n-hosting/kubernetes
```

Example 4 (unknown):
```unknown
…
spec:
  storageClassName: gp3
  accessModes:
    - ReadWriteOnce
…
```

---

## add more, one per line, e.g.:

**URL:** llms-txt#add-more,-one-per-line,-e.g.:

---

## Facebook Trigger Instagram object

**URL:** llms-txt#facebook-trigger-instagram-object

**Contents:**
- Trigger configuration
- Related resources

Use this object to receive updates when someone comments on the Media objects of your app users; @mentions your app users; or when Stories of your app users expire. Refer to [Facebook Trigger](../) for more information on the trigger itself.

You can find authentication information for this node [here](../../../credentials/facebookapp/).

Examples and templates

For usage examples and templates to help you get started, refer to n8n's [Facebook Trigger integrations](https://n8n.io/integrations/facebook-trigger/) page.

## Trigger configuration

To configure the trigger with this Object:

1. Select the **Credential to connect with**. Select an existing or create a new [Facebook App credential](../../../credentials/facebookapp/).
1. Enter the **APP ID** of the app connected to your credential. Refer to the [Facebook App credential](../../../credentials/facebookapp/) documentation for more information.
1. Select **Instagram** as the **Object**.
1. **Field Names or IDs**: By default, the node will trigger on all the available events using the `*` wildcard filter. If you'd like to limit the events, use the `X` to remove the star and use the dropdown or an expression to select the updates you're interested in. Options include:
   - **Comments**: Notifies you when anyone comments on an IG Media owned by your app's Instagram user.
   - **Messaging Handover**
   - **Mentions**: Notifies you whenever an Instagram user @mentions an Instagram Business or Creator Account in a comment or caption.
   - **Messages**: Notifies you when anyone messages your app's Instagram user.
   - **Messaging Seen**: Notifies you when someone sees a message sent by your app's Instagram user.
   - **Standby**
   - **Story Insights**: Notifies you one hour after a story expires with metrics describing interactions on a story.
1. In **Options**, turn on the toggle to **Include Values**. This Object type fails without the option enabled.

Refer to [Webhooks for Instagram](https://developers.facebook.com/docs/graph-api/webhooks/getting-started/webhooks-for-instagram) and Meta's [Instagram](https://developers.facebook.com/docs/graph-api/webhooks/reference/instagram/) Graph API reference for more information.

---

## MSG91 node

**URL:** llms-txt#msg91-node

**Contents:**
- Operations
- Templates and examples
- Find your Sender ID

Use the MSG91 node to automate work in MSG91, and integrate MSG91 with other applications. n8n supports sending SMS with MSG91.

On this page, you'll find a list of operations the MSG91 node supports and links to more resources.

Refer to [MSG91 credentials](../../credentials/msg91/) for guidance on setting up authentication.

## Templates and examples

[Browse MSG91 integration templates](https://n8n.io/integrations/msg91/), or [search all templates](https://n8n.io/workflows/)

## Find your Sender ID

1. Log in to your MSG91 dashboard.
1. Select **Sender Id** in the left panel.
1. If you don't already have one, select **Add Sender Id +**, fill in the details, and select **Save Sender Id**.

---

## Microsoft credentials

**URL:** llms-txt#microsoft-credentials

**Contents:**
- Prerequisites
- Supported authentication methods
- Related resources
- Using OAuth2
  - Register an application
  - Generate a client secret
  - Service-specific settings
- Common issues
  - Need admin approval

You can use these credentials to authenticate the following nodes:

- [Microsoft Dynamics CRM](../../app-nodes/n8n-nodes-base.microsoftdynamicscrm/)
- [Microsoft Excel](../../app-nodes/n8n-nodes-base.microsoftexcel/)
- [Microsoft Graph Security](../../app-nodes/n8n-nodes-base.microsoftgraphsecurity/)
- [Microsoft OneDrive](../../app-nodes/n8n-nodes-base.microsoftonedrive/)
- [Microsoft Outlook](../../app-nodes/n8n-nodes-base.microsoftoutlook/)
- [Microsoft SharePoint](../../app-nodes/n8n-nodes-base.microsoftsharepoint/)
- [Microsoft Teams](../../app-nodes/n8n-nodes-base.microsoftteams/)
- [Microsoft Teams Trigger](../../trigger-nodes/n8n-nodes-base.microsoftteamstrigger/)
- [Microsoft To Do](../../app-nodes/n8n-nodes-base.microsofttodo/)

- Create a [Microsoft Azure](https://azure.microsoft.com/) account.
- Create at least one user account with access to the appropriate service.
- If a corporate Microsoft Entra account manages the user account, the administrator account has enabled the option “User can consent to apps accessing company data on their behalf” for this user (see the [Microsoft Entra documentation](https://learn.microsoft.com/en-us/entra/identity/enterprise-apps/grant-admin-consent)).

## Supported authentication methods

Refer to the linked Microsoft API documentation below for more information about each service's API:

- Dynamics CRM: [Web API](https://learn.microsoft.com/en-us/power-apps/developer/data-platform/webapi/overview)
- Excel: [Graph API](https://learn.microsoft.com/en-us/graph/api/resources/excel)
- Graph Security: [Graph API](https://learn.microsoft.com/en-us/graph/api/overview)
- OneDrive: [Graph API](https://learn.microsoft.com/en-us/onedrive/developer/rest-api/)
- Outlook: [Graph API](https://learn.microsoft.com/en-us/graph/api/resources/mail-api-overview) and [Outlook API](https://learn.microsoft.com/en-us/outlook/rest/reference)
- Teams: [Graph API](https://learn.microsoft.com/en-us/graph/api/resources/teams-api-overview)
- To Do: [Graph API](https://learn.microsoft.com/en-us/graph/todo-concept-overview)

Note for n8n Cloud users

Cloud users don't need to provide connection details. Select **Connect my account** to connect through your browser.

Some Microsoft services require extra information for OAuth2. Refer to [Service-specific settings](#service-specific-settings) for more guidance on those services.

For self-hosted users, there are two main steps to configure OAuth2 from scratch:

1. [Register an application](#register-an-application) with the Microsoft Identity Platform.
1. [Generate a client secret](#generate-a-client-secret) for that application.

Follow the detailed instructions for each step below. For more detail on the Microsoft OAuth2 web flow, refer to [Microsoft authentication and authorization basics](https://learn.microsoft.com/en-us/graph/auth/auth-concepts).

### Register an application

Register an application with the Microsoft Identity Platform:

1. Open the [Microsoft Application Registration Portal](https://aka.ms/appregistrations).
1. Select **Register an application**.
1. Enter a **Name** for your app.
1. In **Supported account types**, select **Accounts in any organizational directory (Any Azure AD directory - Multi-tenant) and personal Microsoft accounts (for example, Skype, Xbox)**.
1. In **Register an application**:
   1. Copy the **OAuth Callback URL** from your n8n credential.
   1. Paste it into the **Redirect URI (optional)** field.
   1. Select **Select a platform** > **Web**.
1. Select **Register** to finish creating your application.
1. Copy the **Application (client) ID** and paste it into n8n as the **Client ID**.

Refer to [Register an application with the Microsoft Identity Platform](https://learn.microsoft.com/en-us/graph/auth-register-app-v2) for more information.

### Generate a client secret

With your application created, generate a client secret for it:

1. On your Microsoft application page, select **Certificates & secrets** in the left navigation.
1. In **Client secrets**, select **+ New client secret**.
1. Enter a **Description** for your client secret, such as `n8n credential`.
1. Select **Add**.
1. Copy the **Secret** in the **Value** column.
1. Paste it into n8n as the **Client Secret**.
1. If you see other fields in the n8n credential, refer to [Service-specific settings](#service-specific-settings) below for guidance on completing those fields.
1. Select **Connect my account** in n8n to finish setting up the connection.
1. Log in to your Microsoft account and allow the app to access your info.

Refer to Microsoft's [Add credentials](https://learn.microsoft.com/en-us/graph/auth-register-app-v2#add-credentials) for more information on adding a client secret.

### Service-specific settings

The following services require extra information for OAuth2:

Dynamics OAuth2 requires information about your Dynamics domain and region. Follow these extra steps to complete the credential:

1. Enter your Dynamics **Domain**.
1. Select the Dynamics data center **Region** you're within.

Refer to the [Microsoft Datacenter regions documentation](https://learn.microsoft.com/en-us/power-platform/admin/new-datacenter-regions) for more information on the region options and corresponding URLs.

#### Microsoft (general)

The general Microsoft OAuth2 also requires you to provide a space-separated list of **Scope**s for this credential.

Refer to [Scopes and permissions in the Microsoft identity platform](https://learn.microsoft.com/en-us/entra/identity-platform/scopes-oidc) for a list of possible scopes.

Outlook OAuth2 supports the credential accessing a user's primary email inbox or a shared inbox. By default, the credential will access a user's primary email inbox. To change this behavior:

1. Turn on **Use Shared Inbox**.
1. Enter the target user's UPN or ID as the **User Principal Name**.

SharePoint OAuth2 requires information about your SharePoint **Subdomain**.

To complete the credential, enter the **Subdomain** part of your SharePoint URL. For example, if your SharePoint URL is `https://tenant123.sharepoint.com`, the subdomain is `tenant123`.

SharePoint requires the following permissions:

Application permissions:

- `Sites.Read.All`
- `Sites.ReadWrite.All`

Delegated permissions:

- `SearchConfiguration.Read.All`
- `SearchConfiguration.ReadWrite.All`

Here are the known common errors and issues with Microsoft OAuth2 credentials.

### Need admin approval

When attempting to add credentials for a Microsoft360 or Microsoft Entra account, users may see a message when following the procedure that this action requires admin approval.

This message will appear when the account attempting to grant permissions for the credential is managed by a Microsoft Entra. In order to issue the credential, the administrator account needs to grant permission to the user (or "tenant") for that application.

The procedure for this is covered in the [Microsoft Entra documentation](https://learn.microsoft.com/en-us/entra/identity/enterprise-apps/grant-admin-consent).

---

## Facebook Trigger Permissions object

**URL:** llms-txt#facebook-trigger-permissions-object

**Contents:**
- Trigger configuration
- Related resources

Use this object to receive updates when a user grants or revokes a permission for your app. Refer to [Facebook Trigger](../) for more information on the trigger itself.

You can find authentication information for this node [here](../../../credentials/facebookapp/).

Examples and templates

For usage examples and templates to help you get started, refer to n8n's [Facebook Trigger integrations](https://n8n.io/integrations/facebook-trigger/) page.

## Trigger configuration

To configure the trigger with this Object:

1. Select the **Credential to connect with**. Select an existing or create a new [Facebook App credential](../../../credentials/facebookapp/).
1. Enter the **APP ID** of the app connected to your credential. Refer to the [Facebook App credential](../../../credentials/facebookapp/) documentation for more information.
1. Select **Permissions** as the **Object**.
1. **Field Names or IDs**: By default, the node will trigger on all the available events using the `*` wildcard filter. If you'd like to limit the events, use the `X` to remove the star and use the dropdown or an expression to select the updates you're interested in.
1. In **Options**, choose whether to turn on the toggle to **Include Values**. When turned on, the node includes the new values for the changes.

Refer to Meta's [Permissions](https://developers.facebook.com/docs/graph-api/webhooks/reference/permissions/) Graph API reference for more information.

---

## Fortinet FortiGate credentials

**URL:** llms-txt#fortinet-fortigate-credentials

**Contents:**
- Prerequisites
- Supported authentication methods
- Related resources
- Using API access token

You can use these credentials to authenticate when using the [HTTP Request node](../../core-nodes/n8n-nodes-base.httprequest/) to make a [Custom API call](../../../custom-operations/).

Create a [Fortinet FortiGate](https://www.fortinet.com/) account.

## Supported authentication methods

Refer to [Fortinet FortiGate's API documentation](https://docs.fortinet.com/document/fortigate/7.4.3/administration-guide/940602/using-apis) for more information about the service.

This is a credential-only node. Refer to [Custom API operations](../../../custom-operations/) to learn more. View [example workflows and related content](https://n8n.io/integrations/fortinet-fortigate/) on n8n's website.

## Using API access token

To configure this credential, you'll need:

- An API **Access Token**: To generate an access token, create a [REST API administrator](https://docs.fortinet.com/document/fortigate/7.4.3/administration-guide/399023/rest-api-administrator).

Refer to the [Fortinet FortiGate Using APIs documentation](https://docs.fortinet.com/document/fortigate/7.4.3/administration-guide/940602/using-apis) for more information about token-based authentication in FortiGate.

---

## Summarize

**URL:** llms-txt#summarize

**Contents:**
- Node parameters
  - Fields to Summarize
  - Fields to Split By
- Node options
  - Continue if Field Not Found
  - Disable Dot Notation
  - Output Format
- Ignore items without valid fields to group by
- Templates and examples
- Related resources

Use the Summarize node to aggregate items together, in a manner similar to Excel pivot tables.

### Fields to Summarize

Use these fields to define how you want to summarize your input data.

- **Aggregation**: Select the aggregation method to use on a given field. Options include:
  - **Append**: Append
    - If you select this option, decide whether you want to **Include Empty Values** or not.
  - **Average**: Calculate the numeric average of your input data.
  - **Concatenate**: Combine together values in your input data.
    - If you select this option, decide whether you want to **Include Empty Values** or not.
    - **Separator**: Select the separator you want to insert between concatenated values.
  - **Count**: Count the total number of values in your input data.
  - **Count Unique**: Count the number of unique values in your input data.
  - **Max**: Find the highest numeric value in your input data.
  - **Min**: Find the lowest numeric value in your input data.
  - **Sum**: Add together the numeric values in your input data.
- **Field**: Enter the name of the field you want to perform the aggregation on.

### Fields to Split By

Enter the name of the input fields that you want to split the summary by (similar to a group by statement). This allows you to get separate summaries based on values in other fields.

For example, if our input data contains columns for `Sales Rep` and `Deal Amount` and we're performing a **Sum** on the `Deal Amount` field, we could split by `Sales Rep` to get a **Sum** total for each Sales Rep.

To enter multiple fields to split by, enter a comma-separated list.

### Continue if Field Not Found

By default, if a **Field to Summarize** isn't in any items, the node throws an error. Use this option to continue and return a single empty item (turned on) instead or keep the default error behavior (turned off).

### Disable Dot Notation

By default, n8n enables dot notation to reference child fields in the format `parent.child`. Use this option to disable dot notation (turned on) or to continue using dot (turned off).

Select the format for your output format. This option is recommended if you're using **Fields to Split By**

- **Each Split in a Separate Item**: Use this option to generate a separate output item for each split out field.
- **All Splits in a Single Item**: Use this option to generate a single item that lists the split out fields.

## Ignore items without valid fields to group by

Set whether to ignore input items that don't contain the **Fields to Split By** (turned on) or not (turned off).

## Templates and examples

**Scrape and summarize webpages with AI**

[View template details](https://n8n.io/workflows/1951-scrape-and-summarize-webpages-with-ai/)

**⚡AI-Powered YouTube Video Summarization & Analysis**

[View template details](https://n8n.io/workflows/2679-ai-powered-youtube-video-summarization-and-analysis/)

**🤖 AI Powered RAG Chatbot for Your Docs + Google Drive + Gemini + Qdrant**

[View template details](https://n8n.io/workflows/2982-ai-powered-rag-chatbot-for-your-docs-google-drive-gemini-qdrant/)

[Browse Summarize integration templates](https://n8n.io/integrations/summarize/), or [search all templates](https://n8n.io/workflows/)

Learn more about [data structure and data flow](../../../../data/) in n8n workflows.

---

## AlienVault credentials

**URL:** llms-txt#alienvault-credentials

**Contents:**
- Prerequisites
- Supported authentication methods
- Related resources
- Using API key

You can use these credentials to authenticate when using the [HTTP Request node](../../core-nodes/n8n-nodes-base.httprequest/) to make a [Custom API call](../../../custom-operations/).

Create an [AlienVault](https://otx.alienvault.com) account.

## Supported authentication methods

Refer to [AlienVault's documentation](https://otx.alienvault.com/api) for more information about the service.

This is a credential-only node. Refer to [Custom API operations](../../../custom-operations/) to learn more. View [example workflows and related content](https://n8n.io/integrations/alienvault/) on n8n's website.

To configure this credential, you'll need:

- An **OTX Key**: Once you have an AlienVault account, the **OTX Key** displays in your **Settings**.

---

## Google Calendar Calendar operations

**URL:** llms-txt#google-calendar-calendar-operations

**Contents:**
- Availability
  - Options

Use this operation to check availability in a calendar in Google Calendar. Refer to [Google Calendar](../) for more information on the Google Calendar node itself.

Use this operation to check if a time-slot is available in a calendar.

Enter these parameters:

- **Credential to connect with**: Create or select an existing [Google Calendar credentials](../../../credentials/google/).
- **Resource**: Select **Calendar**.
- **Operation**: Select **Availability**.
- **Calendar**: Choose a calendar you want to check against. Select **From list** to choose the title from the dropdown list or **By ID** to enter a calendar ID.
- **Start Time**: The start time for the time-slot you want to check. By default, uses an expression evaluating to the current time (`{{ $now }}`).
- **End Time**: The end time for the time-slot you want to check. By default, uses an expression evaluating to an hour from now (`{{ $now.plus(1, 'hour') }}`).

- **Output Format**: Select the format for the availability information:
  - **Availability**: Returns if there are already events overlapping with the given time slot or not.
  - **Booked Slots**: Returns the booked slots.
  - **RAW**: Returns the RAW data from the API.
- **Timezone**: The timezone used in the response. By default, uses the n8n timezone.

Refer to the [Freebusy: query | Google Calendar](https://developers.google.com/calendar/api/v3/reference/freebusy/query) API documentation for more information.

---

## Set up your development environment

**URL:** llms-txt#set-up-your-development-environment

**Contents:**
- Requirements
- Editor setup

This document lists the essential dependencies for developing a node, as well as guidance on setting up your editor.

To build and test a node, you need:

- Node.js and npm. Minimum version Node 18.17.0. You can find instructions on how to install both using nvm (Node Version Manager) for Linux, Mac, and WSL (Windows Subsystem for Linux) [here](https://github.com/nvm-sh/nvm). For Windows users, refer to Microsoft's guide to [Install NodeJS on Windows](https://docs.microsoft.com/en-us/windows/dev-environment/javascript/nodejs-on-windows).
- A local instance of n8n. You can install n8n with `npm install n8n -g`, then follow the steps in [Run your node locally](../../test/run-node-locally/) to test your node.
- When [building verified community nodes](../../../community-nodes/build-community-nodes/), you must use the [`n8n-node` tool](../n8n-node/) to create and test your node.

You should also have [git](https://git-scm.com/) installed. This allows you to clone and use the [n8n-node-starter](https://github.com/n8n-io/n8n-nodes-starter).

n8n recommends using [VS Code](https://code.visualstudio.com/) as your editor.

Install these extensions:

- [ESLint](https://marketplace.visualstudio.com/items?itemName=dbaeumer.vscode-eslint)
- [EditorConfig](https://marketplace.visualstudio.com/items?itemName=EditorConfig.EditorConfig)
- [Prettier](https://marketplace.visualstudio.com/items?itemName=esbenp.prettier-vscode)

By using VS Code and these extensions, you get access to the n8n node linter's warnings as you code.

---

## Matrix node

**URL:** llms-txt#matrix-node

**Contents:**
- Operations
- Templates and examples

Use the Matrix node to automate work in Matrix, and integrate Matrix with other applications. n8n has built-in support for a wide range of Matrix features, including getting current user's account information, sending media and messages to a room, and getting room members and messages.

On this page, you'll find a list of operations the Matrix node supports and links to more resources.

Refer to [Matrix credentials](../../credentials/matrix/) for guidance on setting up authentication.

- Account
  - Get current user's account information
- Event
  - Get single event by ID
- Media
  - Send media to a chat room
- Message
  - Send a message to a room
  - Gets all messages from a room
- Room
  - New chat room with defined settings
  - Invite a user to a room
  - Join a new room
  - Kick a user from a room
  - Leave a room
- Room Member
  - Get all members

## Templates and examples

**Manage room members in Matrix**

[View template details](https://n8n.io/workflows/724-manage-room-members-in-matrix/)

**Weekly Coffee Chat (Matrix Version)**

[View template details](https://n8n.io/workflows/854-weekly-coffee-chat-matrix-version/)

**🛠️ Matrix Tool MCP Server 💪 all 11 operations**

[View template details](https://n8n.io/workflows/5185-matrix-tool-mcp-server-all-11-operations/)

[Browse Matrix integration templates](https://n8n.io/integrations/matrix/), or [search all templates](https://n8n.io/workflows/)

---

## Mapping in the expressions editor

**URL:** llms-txt#mapping-in-the-expressions-editor

**Contents:**
- Access the linked item in a previous node's output
  - Access the linked item in the current node's input

These examples show how to access linked items in the expressions editor. Refer to [expressions](../../../code/expressions/) for more information on expressions, including built in variables and methods.

For information on errors with mapping and linking items, refer to [Item linking errors](../data-item-linking/item-linking-errors/).

## Access the linked item in a previous node's output

When you use this, n8n works back up the item linking chain, to find the parent item in the given node.

As a longer example, consider a scenario where a node earlier in the workflow has the following output data:

To extract the name, use the following expression:

### Access the linked item in the current node's input

In this case, the item linking is within the node: find the input item that the node links to an output item.

As a longer example, consider a scenario where the current node has the following input data:

To extract the name, you'd normally use drag-and-drop [Data mapping](../), but you could also write the following expression:

**Examples:**

Example 1 (unknown):
```unknown
// Returns the linked item
{{$("<node-name>").item}}
```

Example 2 (unknown):
```unknown
[
  {
    "id": "23423532",
    "name": "Jay Gatsby",
  },
  {
    "id": "23423533",
    "name": "José Arcadio Buendía",
  },
  {
    "id": "23423534",
    "name": "Max Sendak",
  },
  {
    "id": "23423535",
    "name": "Zaphod Beeblebrox",
  },
  {
    "id": "23423536",
    "name": "Edmund Pevensie",
  }
]
```

Example 3 (unknown):
```unknown
{{$("<node-name>").item.json.name}}
```

Example 4 (unknown):
```unknown
// Returns the linked item
{{$input.item}}
```

---

## Data mapping

**URL:** llms-txt#data-mapping

Data mapping means referencing data from previous nodes.

This section contains guidance on:

- Mapping data in most scenarios: [Data mapping in the UI](data-mapping-ui/) and [Data mapping in expression](data-mapping-expressions/)
- How to handle [item linking](data-item-linking/) when using the Code node or building your own nodes.

---

## Google Gemini(PaLM) credentials

**URL:** llms-txt#google-gemini(palm)-credentials

**Contents:**
- Prerequisites
- Supported authentication methods
- Related resources
- Using Gemini(PaLM) API key

You can use these credentials to authenticate the following nodes:

- [Embeddings Google Gemini](../../cluster-nodes/sub-nodes/n8n-nodes-langchain.embeddingsgooglegemini/)
- [Google Gemini](../../app-nodes/n8n-nodes-langchain.googlegemini/)
- [Google Gemini Chat Model](../../cluster-nodes/sub-nodes/n8n-nodes-langchain.lmchatgooglegemini/)
- [Embeddings Google PaLM](../../cluster-nodes/sub-nodes/n8n-nodes-langchain.embeddingsgooglepalm/)

- Create a [Google Cloud](https://cloud.google.com/) account.
- Create a [Google Cloud Platform project](https://developers.google.com/workspace/marketplace/create-gcp-project).

## Supported authentication methods

- Gemini(PaLM) API key

Refer to [Google's Gemini API documentation](https://ai.google.dev/gemini-api/docs) for more information about the service.

View n8n's [Advanced AI](../../../../advanced-ai/) documentation.

## Using Gemini(PaLM) API key

To configure this credential, you'll need:

- The API **Host** URL: Both PaLM and Gemini use the default `https://generativelanguage.googleapis.com`.
- An **API Key**: Create a key in [Google AI Studio](https://aistudio.google.com/apikey).

Custom hosts not supported

The related nodes don't yet support custom hosts or proxies for the API host and must use `https://generativelanguage.googleapis.com`.

To create an API key:

1. Go to the API Key page in Google AI Studio: <https://aistudio.google.com/apikey>.
1. Select **Create API Key**.
1. You can choose whether to **Create API key in new project** or search for an existing Google Cloud project to **Create API key in existing project**.
1. Copy the generated API key and add it to your n8n credential.

---

## LangChain in n8n

**URL:** llms-txt#langchain-in-n8n

n8n provides a collection of nodes that implement LangChain's functionality. The LangChain nodes are configurable, meaning you can choose your preferred agent, LLM, memory, and so on. Alongside the LangChain nodes, you can connect any n8n node as normal: this means you can integrate your LangChain logic with other data sources and services.

- [Learning resources](../langchain-learning-resources/): n8n's documentation for LangChain assumes you're familiar with AI and LangChain concepts. This page provides links to learning resources.
- [LangChain concepts and features in n8n](../langchain-n8n/): how n8n represents LangChain concepts and features.

---

## ProfitWell node

**URL:** llms-txt#profitwell-node

**Contents:**
- Operations
- Templates and examples

Use the ProfitWell node to automate work in ProfitWell, and integrate ProfitWell with other applications. n8n supports getting your company's account settings and retrieving financial metrics from ProfitWell.

On this page, you'll find a list of operations the ProfitWell node supports and links to more resources.

Refer to [ProfitWell credentials](../../credentials/profitwell/) for guidance on setting up authentication.

- Company
  - Get your company's ProfitWell account settings
- Metric
  - Retrieve financial metric broken down by day for either the current month or the last

## Templates and examples

[Browse ProfitWell integration templates](https://n8n.io/integrations/profitwell/), or [search all templates](https://n8n.io/workflows/)

---

## BambooHR credentials

**URL:** llms-txt#bamboohr-credentials

**Contents:**
- Prerequisites
- Supported authentication methods
- Related resources
- Using API Key

You can use these credentials to authenticate the following node:

- [BambooHR](../../app-nodes/n8n-nodes-base.bamboohr/)

Create a [BambooHR](https://www.bamboohr.com/) account.

## Supported authentication methods

Refer to [BambooHR's API documentation](https://documentation.bamboohr.com/docs/getting-started) for more information about the service.

To configure this credential, you'll need:

- Your BambooHR **Subdomain**: the part between `https://` and `.bamboohr.com`
- A BambooHR **API Key**: Refer to the [Authentication section of BambooHR's Getting Started API documentation](https://documentation.bamboohr.com/docs/getting-started#authentication) for instructions on generating an API key.

---

## Gmail IMAP credentials

**URL:** llms-txt#gmail-imap-credentials

**Contents:**
- Prerequisites
  - Enable 2-step Verification
  - Generate an app password
- Set up the credential

Follow these steps to configure the IMAP credentials with a Gmail account.

To follow these instructions, you must first:

1. [Enable 2-step Verification](#enable-2-step-verification) on your Gmail account.
1. [Generate an app password](#generate-an-app-password).

### Enable 2-step Verification

To enable 2-step Verification:

1. Log in to your [Google Account](https://myaccount.google.com/).
1. Select **Security** from the left navigation.
1. Under **How you sign in to Google**, select **2-Step Verification**.
   - If 2-Step Verification is already enabled, skip to the next section.
1. Select **Get started**.
1. Follow the on-screen steps to configure 2-Step Verification.

Refer to [Turn on 2-step Verification](https://support.google.com/accounts/answer/185839) for more information.

If you can't turn on 2-step Verification, check with your email administrator.

### Generate an app password

To generate an app password:

1. In your Google account, go to [App passwords](https://myaccount.google.com/apppasswords).
1. Enter an **App name** for your new app password, like `n8n credential`.
1. Select **Create**.
1. Copy the generated app password. You'll use this in your n8n credential.

Refer to Google's [Sign in with app passwords documentation](https://support.google.com/accounts/answer/185833?hl=en) for more information.

## Set up the credential

To set up the IMAP credential with a Gmail account, use these settings:

1. Enter your Gmail email address as the **User**.
1. Enter the app password you generated above as the **Password**.
1. Enter `imap.gmail.com` as the **Host**.
1. For the **Port**, keep the default port number of `993`. Check with your email administrator if this port doesn't work.
1. Turn on the **SSL/TLS** toggle.
1. Check with your email administrator about whether to **Allow Self-Signed Certificates**.

Refer to [Add Gmail to another client](https://support.google.com/mail/answer/7126229?hl=en) for more information. You may need to **Enable IMAP** if you're using a personal Google account before June 2024.

---

## Monica CRM node

**URL:** llms-txt#monica-crm-node

**Contents:**
- Operations
- Templates and examples

Use the Monica CRM node to automate work in Monica CRM, and integrate Monica CRM with other applications. n8n has built-in support for a wide range of Monica CRM features, including creating, updating, deleting, and getting activities, calls, contracts, messages, tasks, and notes.

On this page, you'll find a list of operations the Monica CRM node supports and links to more resources.

Refer to [Monica CRM credentials](../../credentials/monicacrm/) for guidance on setting up authentication.

- Activity
  - Create an activity
  - Delete an activity
  - Retrieve an activity
  - Retrieve all activities
  - Update an activity
- Call
  - Create a call
  - Delete a call
  - Retrieve a call
  - Retrieve all calls
  - Update a call
- Contact
  - Create a contact
  - Delete a contact
  - Retrieve a contact
  - Retrieve all contacts
  - Update a contact
- Contact Field
  - Create a contact field
  - Delete a contact field
  - Retrieve a contact field
  - Update a contact field
- Contact Tag
  - Add
  - Remove
- Conversation
  - Create a conversation
  - Delete a conversation
  - Retrieve a conversation
  - Update a conversation
- Conversation Message
  - Add a message to a conversation
  - Update a message in a conversation
- Journal Entry
  - Create a journal entry
  - Delete a journal entry
  - Retrieve a journal entry
  - Retrieve all journal entries
  - Update a journal entry
- Note
  - Create a note
  - Delete a note
  - Retrieve a note
  - Retrieve all notes
  - Update a note
- Reminder
  - Create a reminder
  - Delete a reminder
  - Retrieve a reminder
  - Retrieve all reminders
  - Update a reminder
- Tag
  - Create a tag
  - Delete a tag
  - Retrieve a tag
  - Retrieve all tags
  - Update a tag
- Task
  - Create a task
  - Delete a task
  - Retrieve a task
  - Retrieve all tasks
  - Update a task

## Templates and examples

[Browse Monica CRM integration templates](https://n8n.io/integrations/monica-crm/), or [search all templates](https://n8n.io/workflows/)

---

## Reddit node

**URL:** llms-txt#reddit-node

**Contents:**
- Operations
- Templates and examples
- What to do if your operation isn't supported

Use the Reddit node to automate work in Reddit, and integrate Reddit with other applications. n8n has built-in support for a wide range of Reddit features, including getting profiles, and users, retrieving post comments and subreddit, as well as submitting, getting, and deleting posts.

On this page, you'll find a list of operations the Reddit node supports and links to more resources.

Refer to [Reddit credentials](../../credentials/reddit/) for guidance on setting up authentication.

This node can be used as an AI tool

This node can be used to enhance the capabilities of an AI agent. When used in this way, many parameters can be set automatically, or with information directed by AI - find out more in the [AI tool parameters documentation](../../../../advanced-ai/examples/using-the-fromai-function/).

- Post
  - Submit a post to a subreddit
  - Delete a post from a subreddit
  - Get a post from a subreddit
  - Get all posts from a subreddit
  - Search posts in a subreddit or in all of Reddit.
- Post Comment
  - Create a top-level comment in a post
  - Retrieve all comments in a post
  - Remove a comment from a post
  - Write a reply to a comment in a post
- Profile
  - Get
- Subreddit
  - Retrieve background information about a subreddit.
  - Retrieve information about subreddits from all of Reddit.
- User
  - Get

## Templates and examples

**Analyze Reddit Posts with AI to Identify Business Opportunities**

[View template details](https://n8n.io/workflows/2978-analyze-reddit-posts-with-ai-to-identify-business-opportunities/)

**Extract Trends, Auto-Generate Social Content with AI, Reddit, Google & Post**

[View template details](https://n8n.io/workflows/3560-extract-trends-auto-generate-social-content-with-ai-reddit-google-and-post/)

[View template details](https://n8n.io/workflows/1895-reddit-ai-digest/)

[Browse Reddit integration templates](https://n8n.io/integrations/reddit/), or [search all templates](https://n8n.io/workflows/)

## What to do if your operation isn't supported

If this node doesn't support the operation you want to do, you can use the [HTTP Request node](../../core-nodes/n8n-nodes-base.httprequest/) to call the service's API.

You can use the credential you created for this service in the HTTP Request node:

1. In the HTTP Request node, select **Authentication** > **Predefined Credential Type**.
1. Select the service you want to connect to.
1. Select your credential.

Refer to [Custom API operations](../../../custom-operations/) for more information.

---

## Timezone and localization environment variables

**URL:** llms-txt#timezone-and-localization-environment-variables

File-based configuration

You can add `_FILE` to individual variables to provide their configuration in a separate file. Refer to [Keeping sensitive data in separate files](../../configuration-methods/#keeping-sensitive-data-in-separate-files) for more details.

| Variable             | Type   | Default            | Description                                                                                                                                                                                                                                                                                                                                                    |
| -------------------- | ------ | ------------------ | -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| `GENERIC_TIMEZONE`   | \*     | `America/New_York` | The n8n instance timezone. Important for schedule nodes (such as Cron).                                                                                                                                                                                                                                                                                        |
| `N8N_DEFAULT_LOCALE` | String | `en`               | A locale identifier, compatible with the [Accept-Language header](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Accept-Language). n8n doesn't support regional identifiers, such as `de-AT`. When running in a locale other than the default, n8n displays UI strings in the selected locale, and falls back to `en` for any untranslated strings. |

---

## Node user interface elements

**URL:** llms-txt#node-user-interface-elements

**Contents:**
- String
  - Support drag and drop for data keys
- Number
- Collection
- DateTime
- Boolean
- Color
- Options
- Multi-options
- Filter

n8n provides a set of predefined UI components (based on a JSON file) that allows users to input all sorts of data types. The following UI elements are available in n8n.

String field for inputting passwords:

String field with more than one row:

### Support drag and drop for data keys

Users can drag and drop data values to map them to fields. Dragging and dropping creates an [expression](../../../../../glossary/#expression-n8n) to load the data value. n8n supports this automatically.

You need to add an extra configuration option to support dragging and dropping data keys:

- `requiresDataPath: 'single'`: for fields that require a single string.
- `requiresDataPath: 'multiple'`: for fields that can accept a comma-separated list of string.

The [Compare Datasets node code](https://github.com/n8n-io/n8n/blob/master/packages/nodes-base/nodes/CompareDatasets/CompareDatasets.node.ts) has examples.

Number field with decimal points:

Use the `collection` type when you need to display optional fields.

The `dateTime` type provides a date picker.

The `boolean` type adds a toggle for entering true or false.

The `color` type provides a color selector.

The `options` type adds an options list. Users can select a single value.

The `multiOptions` type adds an options list. Users can select more than one value.

Use this component to evaluate, match, or filter incoming data.

This is the code from n8n's own If node. It shows a filter component working with a [collection](#collection) component where users can configure the filter's behavior.

## Assignment collection (drag and drop)

Use the drag and drop component when you want users to pre-fill name and value parameters with a single drag interaction.

You can see an example in n8n's [Edit Fields (Set) node](https://github.com/n8n-io/n8n/tree/0faeab1228e26d69a2a93bdb2f89523cca1e4036/packages/nodes-base/nodes/Set/v2):

Use the `fixedCollection` type to group fields that are semantically related.

The resource locator element helps users find a specific resource in an external service, such as a card or label in Trello.

The following options are available:

- ID
- URL
- List: allows users to select or search from a prepopulated list. This option requires more coding, as you must populate the list, and handle searching if you choose to support it.

You can choose which types to include.

Refer to the following for live examples:

- Refer to [`CardDescription.ts`](https://github.com/n8n-io/n8n/blob/master/packages/nodes-base/nodes/Trello/CardDescription.ts) and [`Trello.node.ts`](https://github.com/n8n-io/n8n/blob/master/packages/nodes-base/nodes/Trello/Trello.node.ts) in n8n's Trello node for an example of a list with search that includes `searchFilterRequired: true`.
- Refer to [`GoogleDrive.node.ts`](https://github.com/n8n-io/n8n/blob/master/packages/nodes-base/nodes/Google/Drive/GoogleDrive.node.ts) for an example where users can browse the list or search.

If your node performs insert, update, or upsert operations, you need to send data from the node in a format supported by the service you're integrating with. A common pattern is to use a Set node before the node that sends data, to convert the data to match the schema of the service you're connecting to. The resource mapper UI component provides a way to get data into the required format directly within the node, rather than using a Set node. The resource mapper component can also validate input data against the schema provided in the node, and cast input data into the expected type.

Mapping is the process of setting the input data to use as values when updating row(s). Matching is the process of using column names to identify the row(s) to update.

Refer to the [Postgres node (version 2)](https://github.com/n8n-io/n8n/tree/master/packages/nodes-base/nodes/Postgres/v2) for a live example using a database schema.

Refer to the [Google Sheets node (version 2)](https://github.com/n8n-io/n8n/tree/master/packages/nodes-base/nodes/Google/Sheet/v2) for a live example using a schema-less service.

### Resource mapper type options interface

The `typeOptions` section must implement the following interface:

### Resource mapper method

This method contains your node-specific logic for fetching the data schema. Every node must implement its own logic for fetching the schema, and setting up each UI field according to the schema.

It must return a value that implements the `ResourceMapperFields` interface:

Refer to the [Postgres resource mapping method](https://github.com/n8n-io/n8n/blob/master/packages/nodes-base/nodes/Postgres/v2/methods/resourceMapping.ts) and [Google Sheets resource mapping method](https://github.com/n8n-io/n8n/blob/master/packages/nodes-base/nodes/Google/Sheet/v2/methods/resourceMapping.ts) for live examples.

The HTML editor allows users to create HTML templates in their workflows. The editor supports standard HTML, CSS in `<style>` tags, and expressions wrapped in `{{}}`. Users can add `<script>` tags to pull in additional JavaScript. n8n doesn't run this JavaScript during workflow execution.

Refer to [`Html.node.ts`](https://github.com/n8n-io/n8n/blob/master/packages/nodes-base/nodes/Html/Html.node.ts) for a live example.

Display a yellow box with a hint or extra info. Refer to [Node UI design](../../../plan/node-ui-design/) for guidance on writing good hints and info text.

There are two types of hints: parameter hints and node hints:

- Parameter hints are small lines of text below a user input field.
- Node hints are a more powerful and flexible option than [Notice](#notice). Use them to display longer hints, in the input panel, output panel, or node details view.

### Add a parameter hint

Add the `hint` parameter to a UI element:

Define the node's hints in the `hints` property within the node `description`:

### Add a dynamic hint to a programmatic-style node

In programmatic-style nodes you can create a dynamic message that includes information from the node execution. As it relies on the node output data, you can't display this type of hint until after execution.

For a live example of a dynamic hint in a programmatic-style node, view the [Split Out node code](https://github.com/n8n-io/n8n/blob/master/packages/nodes-base/nodes/Transform/SplitOut/SplitOut.node.ts#L266).

**Examples:**

Example 1 (unknown):
```unknown
{
	displayName: Name, // The value the user sees in the UI
	name: name, // The name used to reference the element UI within the code
	type: string,
	required: true, // Whether the field is required or not
	default: 'n8n',
	description: 'The name of the user',
	displayOptions: { // the resources and operations to display this element with
		show: {
			resource: [
				// comma-separated list of resource names
			],
			operation: [
				// comma-separated list of operation names
			]
		}
	},
}
```

Example 2 (unknown):
```unknown
{
	displayName: 'Password',
	name: 'password',
	type: 'string',
	required: true,
	typeOptions: {
		password: true,
	},
	default: '',
	description: `User's password`,
	displayOptions: { // the resources and operations to display this element with
		show: {
			resource: [
				// comma-separated list of resource names
			],
			operation: [
				// comma-separated list of operation names
			]
		}
	},
}
```

Example 3 (unknown):
```unknown
{
	displayName: 'Description',
	name: 'description',
	type: 'string',
	required: true,
	typeOptions: {
		rows: 4,
	},
	default: '',
	description: 'Description',
	displayOptions: { // the resources and operations to display this element with
		show: {
			resource: [
				// comma-separated list of resource names
			],
			operation: [
				// comma-separated list of operation names
			]
		}
	},
}
```

Example 4 (unknown):
```unknown
{
	displayName: 'Amount',
	name: 'amount',
	type: 'number',
	required: true,
	typeOptions: {
		maxValue: 10,
		minValue: 0,
		numberPrecision: 2,
	},
	default: 10.00,
	description: 'Your current amount',
	displayOptions: { // the resources and operations to display this element with
		show: {
			resource: [
				// comma-separated list of resource names
			],
			operation: [
				// comma-separated list of operation names
			]
		}
	},
}
```

---

## Find your container ID

**URL:** llms-txt#find-your-container-id

---

## Schedule Trigger node

**URL:** llms-txt#schedule-trigger-node

**Contents:**
- Node parameters
  - Seconds trigger interval
  - Minutes trigger interval
  - Hours trigger interval
  - Days trigger interval
  - Weeks trigger interval
  - Months trigger interval
  - Custom (Cron) interval
- Templates and examples
- Common issues

Use the Schedule Trigger node to run workflows at fixed intervals and times. This works in a similar way to the Cron software utility in Unix-like systems.

You must activate the workflow

If a workflow uses the Schedule node as a trigger, make sure that you save and activate the workflow.

The node relies on the timezone setting. n8n uses either:

1. The workflow timezone, if set. Refer to [Workflow settings](../../../../workflows/settings/) for more information.
1. The n8n instance timezone, if the workflow timezone isn't set. The default is `America/New York` for self-hosted instances. n8n Cloud tries to detect the instance owner's timezone when they sign up, falling back to GMT as the default. Self-hosted users can change the instance setting using [Environment variables](../../../../hosting/configuration/environment-variables/timezone-localization/). Cloud admins can change the instance timezone in the [Admin dashboard](../../../../manage-cloud/set-cloud-timezone/).

Add **Trigger Rules** to determine when the trigger should run.

Use the **Trigger Interval** to select the time interval unit of measure to schedule the trigger for. All other parameters depend on the interval you select. Choose from:

- [Seconds trigger interval](#seconds-trigger-interval)
- [Minutes trigger interval](#minutes-trigger-interval)
- [Hours trigger interval](#hours-trigger-interval)
- [Days trigger interval](#days-trigger-interval)
- [Weeks trigger interval](#weeks-trigger-interval)
- [Months trigger interval](#months-trigger-interval)
- [Custom (Cron) interval](#custom-cron-interval)

You can add multiple **Trigger Rules** to run the node on different schedules.

Refer to the sections below for more detail on configuring each **Trigger Interval**. Refer to [Templates and examples](#templates-and-examples) for further examples.

### Seconds trigger interval

- **Seconds Between Triggers**: Enter the number of seconds between each workflow trigger. For example, if you enter `30` here, the trigger will run every 30 seconds.

### Minutes trigger interval

- **Minutes Between Triggers**: Enter the number of minutes between each workflow trigger. For example, if you enter `5` here, the trigger will run every 5 minutes.

### Hours trigger interval

- **Hours Between Triggers**: Enter the number of hours between each workflow trigger.
- **Trigger at Minute**: Enter the minute past the hour to trigger the node when it runs, from `0` to `59`.

For example, if you enter `6` **Hours Between Triggers** and `30` **Trigger at Minute**, the node will run every six hours at 30 minutes past the hour.

### Days trigger interval

- **Days Between Triggers**: Enter the number of days between each workflow trigger.
- **Trigger at Hour**: Select the hour of the day to trigger the node.
- **Trigger at Minute**: Enter the minute past the hour to trigger the node when it runs, from `0` to `59`.

For example, if you enter `2` **Days Between Triggers**, **9am** for **Trigger at Hour**, and `15` **Trigger at Minute**, the node will run every two days at 9:15am.

### Weeks trigger interval

- **Weeks Between Triggers**: Enter the number of weeks between each workflow trigger.
- **Trigger on Weekdays**: Select the day(s) of the week you want to trigger the node.
- **Trigger at Hour**: Select the hour of the day to trigger the node.
- **Trigger at Minute**: Enter the minute past the hour to trigger the node when it runs, from `0` to `59`.

For example, if you enter `2` **Weeks Between Triggers**, **Monday** for **Trigger on Weekdays**, **3pm** for **Trigger at Hour**, and `30` **Trigger at Minute**, the node will run every two weeks on Monday at 3:30 PM.

### Months trigger interval

- **Months Between Triggers**: Enter the number of months between each workflow trigger.
- **Trigger at Day of Month**: Enter the day of the month the day should trigger at, from `1` to `31`. If a month doesn't have this day, the node won't trigger. For example, if you enter `30` here, the node won't trigger in February.
- **Trigger at Hour**: Select the hour of the day to trigger the node.
- **Trigger at Minute**: Enter the minute past the hour to trigger the node when it runs, from `0` to `59`.

For example, if you enter `3` **Months Between Triggers**, `28` **Trigger at Day of Month**, **9am** for **Trigger at Hour**, and `0` **Trigger at Minute**, the node will run each quarter on the 28th day of the month at 9:00 AM.

### Custom (Cron) interval

Enter a custom cron **Expression** to set the schedule for the trigger.

To generate a Cron expression, you can use [crontab guru](https://crontab.guru). Paste the Cron expression that you generated using crontab guru in the **Expression** field in n8n.

| Type                | Cron Expression    | Description                                                  |
| ------------------- | ------------------ | ------------------------------------------------------------ |
| Every X Seconds     | `*/10 * * * * *`   | Every 10 seconds.                                            |
| Every X Minutes     | `*/5 * * * *`      | Every 5 minutes.                                             |
| Hourly              | `0 * * * *`        | Every hour on the hour.                                      |
| Daily               | `0 6 * * *`        | At 6:00 AM every day.                                        |
| Weekly              | `0 12 * * 1`       | At noon every Monday.                                        |
| Monthly             | `0 0 1 * *`        | At midnight on the 1st of every month.                       |
| Every X Days        | `0 0 */3 * *`      | At midnight every 3rd day.                                   |
| Only Weekdays       | `0 9 * * 1-5`      | At 9:00 AM Monday through Friday.                            |
| Custom Hourly Range | `0 9-17 * * *`     | Every hour from 9:00 AM to 5:00 PM every day.                |
| Quarterly           | `0 0 1 1,4,7,10 *` | At midnight on the 1st of January, April, July, and October. |

Using variables in the Cron expression

While variables can be used in the scheduled trigger, their values only get evaluated when the workflow is activated. If you alter a variable's value in the settings after a workflow is activated, the changes won't alter the cron schedule. To re-evaluate the variable, set the workflow to **Inactive** and then back to **Active** again

#### Why there are six asterisks in the Cron expression

The sixth asterisk in the Cron expression represents seconds. Setting this is optional. The node will execute even if you don't set the value for seconds.

| (\*)     | \*     | \*   | \*           | \*    | \*                   |
| -------- | ------ | ---- | ------------ | ----- | -------------------- |
| (second) | minute | hour | day of month | month | day of week(Sun-Sat) |

## Templates and examples

[Browse Schedule Trigger integration templates](https://n8n.io/integrations/schedule-trigger/), or [search all templates](https://n8n.io/workflows/)

For common questions or issues and suggested solutions, refer to [Common Issues](common-issues/).

---

## Xero node

**URL:** llms-txt#xero-node

**Contents:**
- Operations
- Templates and examples
- Related resources
- What to do if your operation isn't supported

Use the Xero node to automate work in Xero, and integrate Xero with other applications. n8n has built-in support for a wide range of Xero features, including creating, updating, and getting contacts and invoices.

On this page, you'll find a list of operations the Xero node supports and links to more resources.

Refer to [Xero credentials](../../credentials/xero/) for guidance on setting up authentication.

- Contact
  - Create a contact
  - Get a contact
  - Get all contacts
  - Update a contact
- Invoice
  - Create a invoice
  - Get a invoice
  - Get all invoices
  - Update a invoice

## Templates and examples

**Get invoices from Xero**

[View template details](https://n8n.io/workflows/543-get-invoices-from-xero/)

**Integrate Xero with FileMaker using Webhooks**

[View template details](https://n8n.io/workflows/2499-integrate-xero-with-filemaker-using-webhooks/)

**Automate Invoice Processing with Gmail, OCR.space, Slack & Xero**

[View template details](https://n8n.io/workflows/9905-automate-invoice-processing-with-gmail-ocrspace-slack-and-xero/)

[Browse Xero integration templates](https://n8n.io/integrations/xero/), or [search all templates](https://n8n.io/workflows/)

Refer to [Xero's API documentation](https://developer.xero.com/documentation/api/accounting/overview) for more information about the service.

## What to do if your operation isn't supported

If this node doesn't support the operation you want to do, you can use the [HTTP Request node](../../core-nodes/n8n-nodes-base.httprequest/) to call the service's API.

You can use the credential you created for this service in the HTTP Request node:

1. In the HTTP Request node, select **Authentication** > **Predefined Credential Type**.
1. Select the service you want to connect to.
1. Select your credential.

Refer to [Custom API operations](../../../custom-operations/) for more information.

---

## Google Sheets Trigger node common issues

**URL:** llms-txt#google-sheets-trigger-node-common-issues

**Contents:**
- Stuck waiting for trigger event
- Date and time columns are rendering as numbers

Here are some common errors and issues with the [Google Sheets Trigger node](../) and steps to resolve or troubleshoot them.

## Stuck waiting for trigger event

When testing the Google Sheets Trigger node with the **Execute step** or **Execute workflow** buttons, the execution may appear stuck and unable to stop listening for events. If this occurs, you may need to exit the workflow and open it again to reset the canvas.

Stuck listening events often occur due to issues with your network configuration outside of n8n. Specifically, this behavior often occurs when you run n8n behind a reverse proxy without configuring websocket proxying.

To resolve this issue, check your reverse proxy configuration (Nginx, Caddy, Apache HTTP Server, Traefik, etc.) to enable websocket support.

## Date and time columns are rendering as numbers

Google Sheets can render dates and times a few different ways.

The [**serial number** format](https://developers.google.com/sheets/api/reference/rest/v4/DateTimeRenderOption), popularized by Lotus 1-2-3 and used my types of spreadsheet software, represents dates as a decimal number. The whole number component (the part left of the decimal) represents the number of days since December 30, 1899. The decimal portion (the part right of the decimal) represents time as a portion of a 24-hour period (for example, `.5` represents noon).

To use a different format for date and time values, adjust the format in your Google Sheet Trigger node. This is available when **Trigger On** is set to **Row Added**:

1. Open the Google Sheet Trigger node on your canvas.
1. Select **Add option**.
1. Select **DateTime Render**.
1. Change **DateTime Render** to **Formatted String**.

The Google Sheets Trigger node will now format date, time, datetime, and duration fields as strings according to their number format.

The number format depends on the spreadsheet's locale settings. You can change the local by opening the spreadsheet and selecting **File > Settings**. In the **General** tab, set **Locale** to your preferred locale. Select **Save settings** to adjust the value.

---

## Configuration

**URL:** llms-txt#configuration

**Contents:**
- Set environment variables by command line
  - npm
  - Docker
- Docker Compose file
- Keeping sensitive data in separate files

You can change n8n's settings using environment variables. For a full list of available configurations see [Environment Variables](../environment-variables/).

## Set environment variables by command line

For npm, set your desired environment variables in terminal. The command depends on your command line.

In Docker you can use the `-e` flag from the command line:

## Docker Compose file

In Docker, you can set your environment variables in the `n8n: environment:` element of your `docker-compose.yaml` file.

## Keeping sensitive data in separate files

You can append `_FILE` to individual environment variables to provide their configuration in a separate file, enabling you to avoid passing sensitive details using environment variables. n8n loads the data from the file with the given name, making it possible to load data from [Docker-Secrets](https://docs.docker.com/engine/swarm/secrets/) and [Kubernetes-Secrets](https://kubernetes.io/docs/concepts/configuration/secret/).

Refer to [Environment variables](../environment-variables/) for details on each variable.

While most environment variables can use the `_FILE` suffix, it's more beneficial for sensitive data such as [credentials](../../../glossary/#credential-n8n) and database configuration. Here are some examples:

**Examples:**

Example 1 (unknown):
```unknown
export <variable>=<value>
```

Example 2 (unknown):
```unknown
set <variable>=<value>
```

Example 3 (unknown):
```unknown
$env:<variable>=<value>
```

Example 4 (unknown):
```unknown
docker run -it --rm \
 --name n8n \
 -p 5678:5678 \
 -e N8N_TEMPLATES_ENABLED="false" \
 docker.n8n.io/n8nio/n8n
```

---

## Get the static data of the node

**URL:** llms-txt#get-the-static-data-of-the-node

nodeStaticData = _getWorkflowStaticData('node')

---

## AWS SES node

**URL:** llms-txt#aws-ses-node

**Contents:**
- Operations
- Templates and examples
- What to do if your operation isn't supported

Use the AWS SES node to automate work in AWS SES, and integrate AWS SES with other applications. n8n has built-in support for a wide range of AWS SES features, including creating, getting, deleting, sending, updating, and adding templates and emails.

On this page, you'll find a list of operations the AWS SES node supports and links to more resources.

Refer to [AWS SES credentials](../../credentials/aws/) for guidance on setting up authentication.

This node can be used as an AI tool

This node can be used to enhance the capabilities of an AI agent. When used in this way, many parameters can be set automatically, or with information directed by AI - find out more in the [AI tool parameters documentation](../../../../advanced-ai/examples/using-the-fromai-function/).

- Custom Verification Email
  - Create a new custom verification email template
  - Delete an existing custom verification email template
  - Get the custom email verification template
  - Get all the existing custom verification email templates for your account
  - Add an email address to the list of identities
  - Update an existing custom verification email template.
- Email
  - Send
  - Send Template
- Template
  - Create a template
  - Delete a template
  - Get a template
  - Get all templates
  - Update a template

## Templates and examples

**Create screenshots with uProc, save to Dropbox and send by email**

[View template details](https://n8n.io/workflows/857-create-screenshots-with-uproc-save-to-dropbox-and-send-by-email/)

**Send an email using AWS SES**

[View template details](https://n8n.io/workflows/507-send-an-email-using-aws-ses/)

**Auto-Notify on New Major n8n Releases via RSS, Email & Telegram**

[View template details](https://n8n.io/workflows/736-auto-notify-on-new-major-n8n-releases-via-rss-email-and-telegram/)

[Browse AWS SES integration templates](https://n8n.io/integrations/aws-ses/), or [search all templates](https://n8n.io/workflows/)

## What to do if your operation isn't supported

If this node doesn't support the operation you want to do, you can use the [HTTP Request node](../../core-nodes/n8n-nodes-base.httprequest/) to call the service's API.

You can use the credential you created for this service in the HTTP Request node:

1. In the HTTP Request node, select **Authentication** > **Predefined Credential Type**.
1. Select the service you want to connect to.
1. Select your credential.

Refer to [Custom API operations](../../../custom-operations/) for more information.

---

## Facebook Trigger Link object

**URL:** llms-txt#facebook-trigger-link-object

**Contents:**
- Trigger configuration
- Related resources

Use this object to receive updates about links for rich previews by an external provider. Refer to [Facebook Trigger](../) for more information on the trigger itself.

You can find authentication information for this node [here](../../../credentials/facebookapp/).

Examples and templates

For usage examples and templates to help you get started, refer to n8n's [Facebook Trigger integrations](https://n8n.io/integrations/facebook-trigger/) page.

## Trigger configuration

To configure the trigger with this Object:

1. Select the **Credential to connect with**. Select an existing or create a new [Facebook App credential](../../../credentials/facebookapp/).
1. Enter the **APP ID** of the app connected to your credential. Refer to the [Facebook App credential](../../../credentials/facebookapp/) documentation for more information.
1. Select **Link** as the **Object**.
1. **Field Names or IDs**: By default, the node will trigger on all the available events using the `*` wildcard filter. If you'd like to limit the events, use the `X` to remove the star and use the dropdown or an expression to select the updates you're interested in.
1. In **Options**, turn on the toggle to **Include Values**. This Object type fails without the option enabled.

Refer to Meta's [Links](https://developers.facebook.com/docs/workplace/reference/webhooks/#links) Workplace API reference for more information.

---

## IMAP credentials

**URL:** llms-txt#imap-credentials

**Contents:**
- Prerequisites
- Supported authentication methods
- Related resources
- Using user account
  - Provider instructions
  - My provider isn't listed

You can use these credentials to authenticate the following nodes:

- [IMAP Email](../../core-nodes/n8n-nodes-base.emailimap/)

Create an email account on a service with IMAP support.

## Supported authentication methods

Internet Message Access Protocol (IMAP) is a standard protocol for receiving email. Most email providers offer instructions on setting up their service with IMAP; refer to your provider's IMAP instructions.

## Using user account

To configure this credential, you'll need:

- A **User** name: The email address you're retrieving email for.
- A **Password**: Either the password you use to check email or an app password. Your provider will tell you whether to use your own password or to generate an app password.
- A **Host**: The IMAP host address for your email provider, often formatted as `imap.<provider>.com`. Check with your provider.
- A **Port** number: The default is port `993`. Use this port unless your provider or email administrator tells you to use something different.

Choose whether to use **SSL/TLS** and whether to **Allow Self-Signed Certificates**.

### Provider instructions

Refer to the quickstart guides for these common email providers.

Refer to [Gmail](gmail/).

Refer to [Outlook.com](outlook/).

Refer to [Yahoo](yahoo/).

### My provider isn't listed

If your email provider isn't listed here, search for their `IMAP settings` or `IMAP instructions`.

---

## Release notes pre 1.0

**URL:** llms-txt#release-notes-pre-1.0

**Contents:**
- How to update n8n
- Semantic versioning in n8n
- n8n@0.237.0
  - Contributors
- n8n@0.236.3
  - Contributors
- n8n@0.236.2
- n8n@0.236.1
- n8n@0.236.0
  - New nodes

Features and bug fixes for n8n before the release of 1.0.0.

You can also view the [Releases](https://github.com/n8n-io/n8n/releases) in the GitHub repository.

Latest and Next versions

n8n releases a new minor version most weeks. The `latest` version is for production use. `next` is the most recent release. You should treat `next` as a beta: it may be unstable. To report issues, use the [forum](https://community.n8n.io/c/questions/12).

Current `latest`: 1.118.2\
Current `next`: 1.119.0

The steps to update your n8n depend on which n8n platform you use. Refer to the documentation for your n8n:

- [Cloud](../../manage-cloud/update-cloud-version/)
- Self-hosted options:
  - [npm](../../hosting/installation/npm/)
  - [Docker](../../hosting/installation/docker/)

## Semantic versioning in n8n

n8n uses [semantic versioning](https://semver.org/). All version numbers are in the format `MAJOR.MINOR.PATCH`. Version numbers increment as follows:

- MAJOR version when making incompatible changes which can require user action.
- MINOR version when adding functionality in a backward-compatible manner.
- PATCH version when making backward-compatible bug fixes.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@0.236.3...n8n@0.237.0) for this version.\
**Release date:** 2023-08-17

This is a bug fix release.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

[Jordan Hall](https://github.com/Jordan-Hall)\
[Xavier Calland](https://github.com/xavier-calland)

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@0.236.2...n8n@0.236.3) for this version.\
**Release date:** 2023-07-18

This is a bug fix release.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

[Romain Dunand](https://github.com/airmoi)\
[noctarius aka Christoph Engelbert](https://github.com/noctarius)

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@0.236.1...n8n@0.236.2) for this version.\
**Release date:** 2023-07-14

This is a bug fix release.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@0.236.0...n8n@0.236.1) for this version.\
**Release date:** 2023-07-12

This is a bug fix release.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@0.235.0...n8n@0.236.0) for this version.\
**Release date:** 2023-07-05

This release contains new nodes, node enhancements, and bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

This release includes a [crowd.dev](https://www.crowd.dev/) node and crowd.dev Trigger node. crowd.dev is a tool to help you understand who is engaging with your open source project.

[crowd.dev node documentation](../../integrations/builtin/app-nodes/n8n-nodes-base.crowddev/).

[Alberto Pasqualetto](https://github.com/albertopasqualetto)\
[perseus-algol](https://github.com/perseus-algol)\
[Romeo Balta](https://github.com/romeobalta)\
[ZergRael](https://github.com/ZergRael)

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@0.234.0...n8n@0.234.1) for this version.\
**Release date:** 2023-07-05

This is a bug fix release.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@0.234.0...n8n@0.235.0) for this version.\
**Release date:** 2023-06-28

This release contains new features, new nodes, node enhancements, and bug fixes.

This version is (as of 4th July 2023) considered unstable. n8n recommends against upgrading.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

[Marten Steketee](https://github.com/Marten-S)\
[Sandra Ashipala](https://github.com/sandramsc)

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@0.233.1...n8n@0.234.0) for this version.\
**Release date:** 2023-06-22

This release contains new features, new nodes, node enhancements, and bug fixes.

This version is (as of 4th July 2023) considered unstable. n8n recommends upgrading directly to 0.234.1.

Irreversible database migration

This version contains a database migration that changes credential and workflow IDs to use nanoId strings, This migration may take a while to complete in some environments. This change doesn't break anything using the older numeric IDs.

If you upgrade to 0.234.0, you can't roll back to an earlier version.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

The Debug Helper node can be used to trigger different error types or generate random datasets to help test n8n workflows.

[Debug Helper node documentation](../../integrations/builtin/core-nodes/n8n-nodes-base.debughelper/).

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@0.233.0...n8n@0.233.1) for this version.\
**Release date:** 2023-06-19

This is a bug fix release.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@0.232.0...n8n@0.233.0) for this version.\
**Release date:** 2023-06-14

This is a bug fix release.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@0.231.1...n8n@0.232.0) for this version.\
**Release date:** 2023-06-07

This release contains new features, new nodes, node enhancements, and bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

This release includes a new trigger node for Postgres, which allows you to listen to events, as well as listen to custom channels. Refer to [Postgres Trigger](../../integrations/builtin/trigger-nodes/n8n-nodes-base.postgrestrigger/) for more information.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@0.231.2...n8n@0.231.3) for this version.\
**Release date:** 2023-06-17

This is a bug fix release.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@0.231.1...n8n@0.231.2) for this version.\
**Release date:** 2023-06-14

This is a bug fix release.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@0.231.0...n8n@0.231.1) for this version.\
**Release date:** 2023-06-06

This is a bug fix release.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@0.230.2...n8n@0.231.0) for this version.\
**Release date:** 2023-05-31

This release contains bug fixes and new features.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

Notable new features.

#### Resource mapper UI component

This release includes a new UI component, the resource mapper. This component is useful for node creators. If your node does insert, update, or upsert operations, you need to send data from the node in a format supported by the service you're integrating with. Often it's necessary to use a Set node before a node that sends data, to get the data to match the schema of the service you're connecting to. The resource mapper UI component provides a way to get data into the required format directly within the node.

Refer to [Node user interface elements | Resource mapper](../../integrations/creating-nodes/build/reference/ui-elements/#resource-mapper) for guidance for node builders.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@0.230.2...n8n@0.230.3) for this version.\
**Release date:** 2023-06-05

This is a bug fix release.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@0.230.1...n8n@0.230.2) for this version.\
**Release date:** 2023-05-25

This is a bug fix release.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@0.230.0...n8n@0.230.1) for this version.\
**Release date:** 2023-05-25

This is a bug fix release.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@0.229.0...n8n@0.230.0) for this version.\
**Release date:** 2023-05-24

This release contains new features, new nodes, node enhancements, and bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

Save metadata for workflow executions. You can then search by this data in the **Executions** list.

[Execution Data node documentation](../../integrations/builtin/core-nodes/n8n-nodes-base.executiondata/).

The LDAP node allows you to interact with your LDAP servers from your n8n workflows.

[LDAP node documentation](../../integrations/builtin/core-nodes/n8n-nodes-base.ldap/).

Integrate n8n with [LoneScale](https://www.lonescale.com/), a buying intents data platform.

[LoneScale node documentation](../../integrations/builtin/app-nodes/n8n-nodes-base.lonescale/).

[Bram Kn](https://github.com/bramkn)\
[pemontto](https://github.com/pemontto)\
[Yann Aleman](https://github.com/SanYann)

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@0.228.0...n8n@0.229.0) for this version.\
**Release date:** 2023-05-17

This release contains bug fixes, improves UI copy and error messages in some nodes, and other node enhancements.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

### Node enhancements

The Google Ads node now supports v13.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@0.228.1...n8n@0.228.2) for this version.\
**Release date:** 2023-05-15

This is a bug fix release.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@0.228.0...n8n@0.228.1) for this version.\
**Release date:** 2023-05-11

This is a bug fix release.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@0.227.0...n8n@0.228.0) for this version.\
**Release date:** 2023-05-11

This release contains new features, node enhancements, and bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

This release introduces the [npm](../../integrations/builtin/app-nodes/n8n-nodes-base.npm/) node. This is a new core node. It provides a way to query an npm registry within your workflow.

[Adam Charnock](https://github.com/adamcharnock)

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@0.227.0...n8n@0.227.1) for this version.\
**Release date:** 2023-05-15

This is a bug fix release.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@0.226.2...n8n@0.227.0) for this version.\
**Release date:** 2023-05-03

This release contains new features, node enhancements, and bug fixes.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

### Node enhancements

- An overhaul of the Microsoft Excel 365 node, improve the UI making it easier to configure, improve error handling, and fix issues.

This release deprecates the following:

- The `EXECUTIONS_PROCESS` environment variable.
- Running n8n in own mode. Main mode is now the default. Use [Queue mode](../../hosting/scaling/queue-mode/) if you need full execution isolation.
- The `WEBHOOK_TUNNEL_URL` flag. Replaced by `WEBHOOK_URL`.
- Support for MySQL and MariaDB as n8n backend databases. n8n will remove support completely in version 1.0. n8n recommends using PostgreSQL instead.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@0.226.1...n8n@0.226.2) for this version.\
**Release date:** 2023-05-03

This is a bug fix release.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@0.226.0...n8n@0.226.1) for this version.\
**Release date:** 2023-05-02

This is a bug fix release.

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@0.225.2...n8n@0.226.0) for this version.\
**Release date:** 2023-04-26

This release contains new features, node enhancements, and bug fixes.

Please note that this version contains a breaking change to `extractDomain` and `isDomain`. You can read more about it [here](https://github.com/n8n-io/n8n/blob/master/packages/cli/BREAKING-CHANGES.md#02260).

For full release details, refer to [Releases](https://github.com/n8n-io/n8n/releases) on GitHub.

- A new command to get information about licenses for self-hosted users:

### Node enhancements

- Nodes that use SQL, such as the PostgresSQL node, now have a better SQL editor for writing custom queries.
- An overhaul of the Google BigQuery node to support executing queries, improve the UI making it easier to configure, improve error handling, and fix issues.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@0.225.1...n8n@0.225.2) for this version.\
**Release date:** 2023-04-25

This is a bug fix release.

- Core: Upgrade google-timezones-json to use the correct timezone for Sao Paulo.
- Code Node: Update vm2 to address [CVE-2023-30547](https://github.com/advisories/GHSA-ch3r-j5x3-6q2m).

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@0.225.0...n8n@0.225.1) for this version.\
**Release date:** 2023-04-20

This is a bug fix release.

- Editor: Clean up demo and template callouts from workflows page.
- Editor: Fix memory leak in Node Detail View by correctly unsubscribing from event buses.
- Editor: Settings sidebar should disconnect from push when navigating away.
- Notion Node: Update credential test to not require user permissions.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@0.224.1...n8n@0.225.0) for this version.\
**Release date:** 2023-04-19

This release introduces [Variables](../../code/variables/). You can now create variables that allows you to store and reuse values in n8n workflows. This is the first phase of a larger project to support [Environments](../../source-control-environments/) in n8n.

- Core: Add support for Google Service account authentication in the HTTP Request node.
- GitLab Node: Add **Additional Parameters** for the file list operation.
- MySQL Node: This node has been overhauled.

- Core: Fix broken API permissions in public API.
- Core: Fix paired item returning wrong data.
- Core: Improve SAML connection test result views.
- Core: Make getExecutionId available on all nodes types.
- Core: Skip SAML onboarding for users with first- and lastname.
- Editor: Add padding to prepend input.
- Editor: Clean up demo/video experiment.
- Editor: Enterprise features missing with user management.
- Editor: Fix moving canvas on middle click preventing lasso selection.
- Editor: Make sure to redirect to blank canvas after personalisation modal.
- Editor: Fix an issue that was preventing typing certain characters in the UI on devices with touchscreen.
- Editor: Fix n8n-checkbox alignment.
- Code Node: Handle user code returning null and undefined.
- GitHub Trigger Node: Remove content_reference event.
- Google Sheets Trigger Node: Return actual error message.
- HTTP Request Node: Fix `itemIndex` in HTTP Request errors.
- NocoDB Node: Fix for updating or deleting rows with not default primary keys.
- OpenAI Node: Update models to only show those supported.
- OpenAI Node: Update OpenAI Text Moderate input placeholder text.

[Bram Kn](https://github.com/bramkn)\
[Eddy Hernandez](https://github.com/eddywashere)\
[Filipe Dobreira](https://github.com/filp)\
[Jimw383](https://github.com/Jimw383)

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@0.224.2...n8n@0.224.4) for this version.\
**Release date:** 2023-04-24

This is a bug fix release.

- Core: Upgrade google-timezones-json to use the correct timezone for Sao Paulo.
- Code Node: Update vm2 to address [CVE-2023-30547](https://github.com/advisories/GHSA-ch3r-j5x3-6q2m).

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@0.224.1...n8n@0.224.2) for this version.\
**Release date:** 2023-04-20

This is a bug fix release.

- Core: Fix paired item returning wrong data.
- Core: Make getExecutionId available on all nodes types.
- Editor: Fix memory leak in Node Detail View by correctly unsubscribing from event buses.
- Editor: Fix moving canvas on middle click preventing lasso selection.
- Editor: Settings sidebar should disconnect from push when navigating away.
- Google Sheets Trigger Node: Return actual error message.
- HTTP Request Node: Fix `itemIndex` in HTTP Request errors.
- Notion Node: Update credential test to not require user permissions.

[Filipe Dobreira](https://github.com/filp)

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@0.224.0...n8n@0.224.1) for this version.\
**Release date:** 2023-04-14

This is a bug fix release.

- Core: Fix broken API permissions in public API.
- Editor: Fix an issue that was preventing typing certain characters in the UI on devices with touchscreen.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@0.223.0...n8n@0.224.0) for this version.\
**Release date:** 2023-04-12

This release contains a new node, updates, and bug fixes.

This release introduces the [TOTP](../../integrations/builtin/core-nodes/n8n-nodes-base.totp/) node. This is a new core node. It provides a way to generate a TOTP (time-based one-time password) within your workflow.

- Code Node: Update vm2 to address CVE-2023-29017.
- Core: App shouldn't crash with a custom REST endpoint.
- Core: Do not execute workflowExecuteBefore hook when resuming executions from a waiting state.
- Core: Fix issue where sub workflows would display as running forever after failure to start.
- Core: Update xml2js to address CVE-2023-0842.
- Editor: Drop mergeDeep in favor of lodash merge.
- HTTP Request Node: Restore detailed error message.

[Loganaden Velvindron](https://github.com/loganaden)

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@0.222.1...n8n@0.223.0) for this version.\
**Release date:** 2023-04-05

This release contains new features and bug fixes.

Please note that this version contains a breaking change. The minimum Node.js version is now v16. You can read more about it [here](https://github.com/n8n-io/n8n/blob/master/packages/cli/BREAKING-CHANGES.md#02230).

- Core: Convert `eventBus` controller to decorator style and improve permissions.
- Core: Prevent non owners password reset when SAML is enabled (this is preparation for an upcoming feature).
- Core: Read ephemeral license from environment and clean up `ee` flags.
- Editor: Allow tab to accept completion.
- Editor: Enable saving workflow when node details view is open.
- Editor: SSO onboarding (this is preparation for an upcoming feature).
- Editor: SSO setup (this is preparation for an upcoming feature).

### Node enhancements

- Filter Node: Show discarded items.
- HTTP Request Node: Follow redirects by default.
- Postgres Node: Overhaul node.
- ServiceNow Node: Add support for work notes when updating an incident.
- SSH Node: Hide the private key within the SSH credential.

- Add droppable state for booleans when mapping.
- Compare Datasets Node: Fuzzy comparen't comparing keys missing in one of the inputs.
- Compare Datasets Node: Fix support for dot notation in skip fields.
- Core: Deactivate active workflows during import.
- Core: Stop marking duplicates as circular references in `jsonStringify`.
- Core: Stop using `util.types.isProxy` for tracking of augmented objects.
- Core: Fix curl import error when no data.
- Core: Handle Date and RegExp correctly in `jsonStringify`.
- Core: Handle Date and RegExp objects in `augmentObject`.
- Core: Prevent `augmentObject` from creating infinitely deep proxies.
- Core: Service account private key as a password field.
- Core: Update lock file.
- Core: Waiting workflows not stopping.
- Date & Time Node: Add info box at top of date and time explaining expressions.
- Date & Time Node: Convert Luxon DateTime object to ISO.
- Editor: Add `$if`, `$min`, `$max` to root expression autocomplete.
- Editor: Curb overeager item access linting.
- Editor: Disable Grammarly in expression editors.
- Editor: Disable password reset on desktop with no user management.
- Editor: Fix connection lost hover text not showing.
- Editor: Fix issue preventing execution preview loading when in an Iframe.
- Editor: Fix mapping with special characters.
- Editor: Prevent error from showing-up when duplicating unsaved workflow.
- Editor: Prevent NDV schema view pagination.
- Editor: Support backspacing with modifier key.
- Google Sheets Node: Fix insertOrUpdate cell update with object.
- HTML Extract Node: Support for dot notation in JSON property.
- HTTP Request Node: Fix AWS credentials to stop removing URL parameters for STS.
- HTTP Request Node: Refresh token properly on never fail option.
- HTTP Request Node: Support for dot notation in JSON body.
- LinkedIn Node: Update the version of the API.
- Redis Node: Fix issue with hash set not working as expected.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@0.222.2...n8n@0.222.3) for this version.\
**Release date:** 2023-04-14

This is a bug fix release.

- Core: Fix broken API permissions in public API.
- Editor: Fix an issue that was preventing typing certain characters in the UI on devices with touchscreen.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@0.222.1...n8n@0.222.2) for this version.\
**Release date:** 2023-04-11

This is a bug fix release.

- Code node: Update vm2 to address CVE-2023-29017.
- Core: Update xml2js to address CVE-2023-0842.

[Loganaden Velvindron](https://github.com/loganaden)

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@0.222.0...n8n@0.222.1) for this version.\
**Release date:** 2023-04-04

This is a bug fix release.

- AWS SNS Node: Fix an issue with messages failing to send if they contain certain characters.
- Core: `augmentObject` should clone Buffer/Uint8Array instead of wrapping them in a proxy.
- Core: `augmentObject` should use existing property descriptors whenever possible.
- Core: Fix the issue of nodes not loading when run using npx.
- Core: Improve Axios error handling in nodes.
- Core: Password reset should pass in the correct values to external hooks.
- Core: Prevent `augmentObject` from creating infinitely deep proxies.
- Core: Use table-prefixes in queries in import commands.
- Editor: Fix focused state in Code node editor.
- Editor: Fix loading executions in long execution list.
- Editor: Show correct status on canceled executions.
- Gmail Node: Gmail Luxon object support, fix for timestamp.
- HTTP Request Node: Detect mime-type from streaming responses.
- HubSpot Trigger Node: Developer API key is required for webhooks.
- Set Node: Convert string to number.

View the [commits](https://github.com/n8n-io/n8n/compare/n8n@0.221.2...n8n@0.222.0) for this version.\
**Release date:** 2023-03-30

This release contains new features, including custom filters for the executions list, and a new node to filter items in your workflows.

Upgrade directly to 0.222.1.

This release introduces improvements to the execution lists. You can now save [Custom execution data](../../workflows/executions/custom-executions-data/), and use it to filter both the [All executions](../../workflows/executions/all-executions/) and [Single workflow executions](../../workflows/executions/single-workflow-executions/) lists.

- Add test overrides.
- Core: Improve LDAP/SAML toggle and tests.
- Core: Limit user invites when SAML is enabled.
- Core: Make OAuth2 error handling consistent with success handling.
- Editor: Fix ResourceLocator dropdown style.

This release introduces the [Filter](../../integrations/builtin/core-nodes/n8n-nodes-base.filter/) node. The node allows you to filter items based on a condition. If the item meets the condition, the Filter node passes it on to the next node in the Filter node output. If the item doesn't meet the condition, the Filter node omits the item from its output.

- Core: Assign `properties.success` earlier to set `executionStatus` correctly.
- Core: Don't mark duplicates as circular references in `jsonStringify`.
- Core: Don't use `util.types.isProxy` for tracking of augmented objects.
- Core: Ensure that all non-lazy-loaded community nodes get post-processed correctly.
- Core: Force-upgrade decode-uri-component to address CVE-2022-38900.
- Core: Force-upgrade http-cache-semantics to address CVE-2022-25881.
- Core: Handle `Date` and `RegExp` correctly in `jsonStringify`.
- Core: Handle `Date` and `RegExp` objects in `augmentObject`.
- Core: Improve Axios error handling in nodes.
- Core: Improve community nodes loading.
- Core: Initialize queue in the webhook server as well.
- Core: Persist `CurrentAuthenticationMethod` setting change.
- Core: Remove circular references from Code and push message.
- Core: Require authentication on icons and nodes/credentials types static files.
- Core: Return SAML service provider URls with configuration.
- Core: Service account private key should display as a password field.
- Core: Upgrade Luxon to address CVE-2023-22467.
- Core: Upgrade simple-git to address CVE-2022-25912.
- Core: Upgrade SQLite3 to address CVE-2022-43441.
- Core: Upgrade Convict to address CVE-2023-0163.
- Core: Waiting workflows not stopping.
- Editor: Fix connection lost hover text not showing.
- Editor: Fix issue preventing execution preview loading when in an iframe.
- Editor: Use credentials when fetching node and credential types.
- Google Sheets Node: Fix `insertOrUpdate` cell update with object.
- HTTP Request Node: Add streaming to binary response.
- HTTP Request Node: Fix AWS credentials to automatically deconstruct the URL.
- HTTP Request Node: Fix AWS credentials to st