---
name: agent-md-generator
description: 交互式生成 GitHub Copilot agents.md 文件的工作流。当用户请求创建代理、构建自定义 Copilot 代理、生成 agents.md 或需要帮助配置 GitHub Copilot 自定义代理时使用。触发短语包括"创建代理"、"生成 agent.md"、"做一个文档代理"、"生成测试代理"等涉及 GitHub Copilot 代理配置的请求。
---

# Agent.md 生成器

通过交互式提问生成高质量的 GitHub Copilot agents.md 文件。

## 工作流程概览

1. **识别代理类型** - 确定代理的用途
2. **收集项目上下文** - 获取技术栈和目录结构
3. **定义命令** - 确定可执行命令
4. **建立边界** - 设置明确的行为规则
5. **生成文件** - 创建 agents.md 文件

## 交互式提问流程

### 阶段一：代理身份

首先询问这些问题（每条消息 1-2 个问题，避免信息过载）：

**必要问题：**
- "这个代理应该处理什么具体任务？"（如：编写测试、文档、代码检查）
- "代理应该扮演什么角色？"（如：QA 工程师、技术写作人员）

**如果用户不确定，建议以下代理类型：**
- `docs-agent` - 技术文档编写
- `test-agent` - 单元测试/集成测试
- `lint-agent` - 代码风格和格式化
- `api-agent` - API 端点开发
- `security-agent` - 安全分析
- `dev-deploy-agent` - 构建和部署

### 阶段二：项目上下文

**技术栈：**
- "你的技术栈是什么？（框架、语言、版本）"
- 示例："React 18 + TypeScript + Vite + Tailwind CSS"

**目录结构：**
- "你的项目结构是怎样的？哪些目录与此代理相关？"
- 重点关注：源代码位置、测试位置、文档位置、配置文件

### 阶段三：命令

**收集代理可使用的可执行命令：**
- "代理应该运行哪些命令？（构建、测试、检查等）"
- "请包含具体的参数和选项，而不仅仅是工具名称"

需要询问的命令示例：
- 构建：`npm run build`、`cargo build`
- 测试：`npm test`、`pytest -v`、`go test ./...`
- 检查：`npm run lint --fix`、`prettier --write`
- 文档：`npm run docs:build`、`markdownlint docs/`

### 阶段四：边界

**收集三层边界规则：**

询问："代理应该始终做什么、需要先询问什么、永远不能做什么？"

- **始终执行**：代理应自动执行的操作
- **先询问**：需要用户确认的操作
- **永不执行**：严格禁止的操作

常见边界示例：
- 永不提交密钥或 API 密钥
- 永不修改 `node_modules/` 或 `vendor/`
- 修改数据库模式前先询问
- 添加依赖前先询问

### 阶段五：代码风格（可选）

如果用户需要代码风格指导：
- "你能提供一个展示你首选风格的代码示例吗？"
- "你遵循什么命名规范？"

## 生成模板

在 `.github/agents/{agent-name}.md` 生成 agents.md 文件：

```markdown
---
name: {agent_name}
description: {一句话描述}
---

你是这个项目的专业{角色}。

## 你的职责
- 你专注于{专业领域}
- 你理解{领域知识}
- 你的输出：{预期输出}

## 项目知识
- **技术栈：** {带版本的技术栈}
- **目录结构：**
  - `{目录1}/` - {用途}
  - `{目录2}/` - {用途}

## 可用命令
- **{命令类别}：** `{命令}` ({描述})

## 代码规范
{如果提供了代码风格示例}

## 边界
- 始终执行：{始终执行的规则}
- 先询问：{需要询问的规则}
- 永不执行：{禁止的规则}
```

## 质量检查清单

生成前验证：
- [ ] 定义了具体角色（不是"有用的助手"）
- [ ] 技术栈包含版本号
- [ ] 命令包含参数/选项
- [ ] 三层边界清晰明确
- [ ] 文件路径明确
- [ ] 如果风格重要，至少有一个代码示例

## 输出

将生成的文件保存到 `.github/agents/{agent-name}.md`，并向用户提供：
1. 完整的文件内容
2. 审查和调整命令的说明
3. 建议在 Copilot 中使用 `@{agent-name}` 测试
