# API Registry 格式规范

## 文件结构

```markdown
# API Registry

## Environment
环境变量表格

## Endpoints
接口定义列表
```

## Environment 格式

使用 Markdown 表格定义环境变量:

```markdown
## Environment
| Name | Value | Description |
|------|-------|-------------|
| BASE_URL | https://api.example.com | API 基础地址 |
| TOKEN | Bearer eyJ... | 认证令牌 |
| API_KEY | sk-xxx | API 密钥 |
```

## Endpoint 格式

每个接口用三级标题定义:

```markdown
### [METHOD] /path - 接口名称
- Status: pending | tested | failed | blocked | deprecated
- Depends: none | METHOD /path, METHOD /path
- Last tested: YYYY-MM-DD (仅 tested/failed 时需要)
- Notes: 可选备注

**Request:**
http METHOD $BASE_URL/path Authorization:$TOKEN \
  param1=value1 \
  param2=value2

**Expected:** HTTP状态码, 响应描述

**Actual:** (测试后填写) HTTP状态码, 实际结果

---
```

## 依赖声明

Depends 字段声明接口依赖:

- `none` - 无依赖，可独立执行
- `POST /users` - 依赖单个接口
- `POST /users, GET /users/{id}` - 依赖多个接口

依赖表示逻辑先决条件，如删除用户依赖先创建用户。

## 完整示例

```markdown
# API Registry

## Environment
| Name | Value |
|------|-------|
| BASE_URL | https://api.example.com/v1 |
| TOKEN | Bearer eyJhbGciOiJIUzI1NiJ9... |

## Endpoints

### [POST] /auth/login - 用户登录
- Status: tested
- Depends: none
- Last tested: 2024-01-15

**Request:**
http POST $BASE_URL/auth/login \
  email="admin@example.com" \
  password="secret"

**Expected:** 200, 返回 { token, user }

**Actual:** 200, 正常返回

---

### [GET] /users - 获取用户列表
- Status: tested
- Depends: POST /auth/login
- Last tested: 2024-01-15

**Request:**
http GET $BASE_URL/users Authorization:$TOKEN

**Expected:** 200, 返回用户数组

**Actual:** 200, 返回 42 个用户

---

### [POST] /users - 创建用户
- Status: pending
- Depends: POST /auth/login

**Request:**
http POST $BASE_URL/users Authorization:$TOKEN \
  name="新用户" \
  email="new@example.com" \
  role="member"

**Expected:** 201, 返回新用户对象

---

### [GET] /users/{id} - 获取单个用户
- Status: pending
- Depends: POST /users

**Request:**
http GET $BASE_URL/users/1 Authorization:$TOKEN

**Expected:** 200, 返回用户对象

---

### [DELETE] /users/{id} - 删除用户
- Status: blocked
- Depends: POST /users
- Notes: 等待 POST /users 测试通过

**Request:**
http DELETE $BASE_URL/users/1 Authorization:$TOKEN

**Expected:** 204, 无返回体
```

## 维护规则

1. 新接口默认 `Status: pending`
2. 测试通过后更新为 `tested` 并填写 `Last tested` 和 `Actual`
3. 测试失败更新为 `failed` 并在 Notes 记录原因
4. 依赖未满足时标记为 `blocked`
5. 接口废弃时标记为 `deprecated`
