---
name: building-a-promotion-case
description: Help users get promoted at work. Use when someone is preparing for a promotion conversation, building their case for advancement, trying to understand what's blocking their promotion, or figuring out how to get to the next level in their career.
---

# Building a Promotion Case

Help the user build a compelling case for promotion using strategies from 17 product leaders.

## How to Help

When the user asks for help with getting promoted:

1. **Diagnose the situation** - Ask about their current role, target role, and relationship with their manager
2. **Identify blockers** - Help determine if the issue is visibility, advocacy, role availability, or skill gaps
3. **Build the case** - Help frame the promotion as solving a company problem, not a personal milestone
4. **Coach on tactics** - Share specific approaches for conversations and demonstrating readiness

## Core Principles

### Focus on impact, not promotion
Ian McAllister: "I never talked to my manager about promotion. I just focused on growing my book of business. The result was I got promoted several times." Optimize for impact—promotions follow.

### Promotions recognize, they don't develop
Christian Idiodi: "I'm promoting you to do the job, not to learn the job." You need to already be performing at the next level before the title comes. Practice "director things" before you're a director.

### Frame it as solving their problem
Claire Vo: "The conversation needs to be about what you being in a different position does for the company. Instead of 'I want to be a director,' say 'You have nine direct reports—you need leverage here.'"

### Use the Magic Loop
Ethan Evans: "(1) Do your current job well. (2) Ask your boss how you can help. (3) Do what they ask. (4) Say 'Is there work that helps you AND helps me reach my goal?' (5) Repeat." Build partnership, not pressure.

### Visibility is prerequisite
Jeffrey Pfeffer: "No one is going to promote you if they don't know who you are. Competence alone is insufficient. You must have visibility to match your substance."

### Build a superpower reputation
Jiaona Zhang: "Be known for something specific—complex launches, technical depth, regulatory expertise. When you're known for excellence, responsibility flows to you naturally."

### Practice manager skills as an IC
Julie Zhuo: "You don't need the title to do manager tasks. Mentor an intern. Lead a process. Be an onboarding buddy. Prove competency before asking for the role."

### Future-frame the conversation
Jackie Bavaro: "Say 'I'd like to grow into X at some point in the future. What should I work on now so I'll be ready?' This brings your manager onto your side instead of making them defensive."

### Diagnose what's actually blocking you
Nikhyl Singhal: Four common blockers: (1) Lack of advocacy—no one is championing you. (2) Role doesn't exist at your company. (3) Impatience—you're not ready yet. (4) Development gap you're not seeing.

### Excel at your current job first
Tamar Yehoshua: "You're not going to get the next job unless you do really well at the one you're in. Knock it out of the park. Master the table stakes before reaching for more."

## Questions to Help Users

- "Are you already performing at the next level, or still learning those skills?"
- "Does your manager know you want this? Have you explicitly discussed it?"
- "Who would advocate for you in a promotion meeting?"
- "What specific business problem would your promotion solve?"
- "Is the role you want even available at your company?"

## Common Mistakes to Flag

- **Asking too early** - You should already be doing the job before asking for the title
- **Making it about you** - "I deserve this" loses to "Here's what I'll do for the company"
- **Pleasing your manager vs. impact** - Optimizing for what your boss wants isn't the same as creating business impact
- **Conflating promotion with career** - A promotion is a company-specific level; a career is a long-term arc
- **Passive waiting** - "My work speaks for itself" works less often than you think

## Deep Dive

For all 22 insights from 17 guests, see `references/guest-insights.md`

## Related Skills

- Managing Up
- Finding Mentors & Sponsors
- Career Transitions
- Negotiating Offers
