# Building a Promotion Case - All Guest Insights

*17 guests, 22 mentions*

---

## Christian Idiodi
*Christian Idiodi*

> "I am promoting you to do the job, not to learn the job. You're going to work with me over the next couple of months to do those things because I am promoting you to do the job, not to learn the job."

**Insight:** Promotions should be a recognition of work already being performed at the next level, rather than a chance to start learning that level's skills.

**Tactical advice:**
- Practice 'VP things' or 'Director things' before you actually have the title.
- Managers should create a safe environment for reports to practice leadership tasks (like interviewing or strategy) before the official promotion.
- Use 'Group Product Manager' roles to let individual contributors test management with one report before giving them a full team.

*Timestamp: 01:07:17*


## Chris Hutchins
*Chris Hutchins*

> "the people that I've had work for me or I've worked alongside that seem to always be the outperformers, are always the people that are just solely focused on having the most impact on the company. I think the thing I learned... is when you focus too much at a company about like, 'Ooh, I want the promotion' you get caught up in this world where you're like, 'If I want the promotion, I need to do what my boss wants.'"

**Insight:** Prioritizing company impact over pleasing a manager is the most reliable path to high performance and advancement.

**Tactical advice:**
- Focus on impact as your primary metric for success
- Avoid optimizing work solely based on a manager's immediate preferences

*Timestamp: 00:18:55*


## Claire Vo
*Claire Vo*

> "know what you want out of your career, be clear and ask for it, and then make it easy for your boss or whoever can support or champion you to get you from here to there."

**Insight:** Career advancement requires clarity of goals and making the promotion an easy decision for leadership by solving organizational problems.

**Tactical advice:**
- Define exactly what you want your next role to be
- Align your promotion case with solving a specific company problem
- Understand the talent calendar and promotion cycles of your organization

*Timestamp: 00:06:08*

---

> "I think the second thing is really the conversation needs to be about what you being in a different position does for the company and why the company needs it. Often the conversation is, 'I want to be promoted because I want to be a director of PM, because I want to become a manager, because I need direct reports.' Instead of saying, 'Look, your span of control, you have nine direct reports, you need leverage here.'"

**Insight:** Frame promotion requests as solutions to organizational bottlenecks rather than personal career milestones.

**Tactical advice:**
- Identify where your manager needs leverage and propose a role that provides it
- Prove you are good at organization design before asking for management roles

*Timestamp: 00:11:00*


## Ethan Evans
*Ethan Evans 2.0*

> "The basic idea of The Magic Loop is five steps and they're very easy. The first one is you have to be doing your current job well... Then step two is ask your boss how you can help... Step three is whatever they say, do it... the fourth step is where the magic comes in. You go back to your manager and say, 'Hey, I'm really enjoying working with you. I'm wondering is there some way I could help you that would also help me reach my goal?'"

**Insight:** The Magic Loop is a five-step partnership framework designed to align your work with your manager's needs to secure promotions and career growth.

**Tactical advice:**
- Ensure you are performing at a solid level before asking for more
- Proactively ask your manager 'What can I do to help you?'
- Execute on the manager's requests, even if they are maintenance tasks, to build trust
- Explicitly state your career goals (promotion, raise, or skill) and ask for work that bridges your goal with their needs
- Repeat the loop to maintain a continuous growth trajectory

*Timestamp: 00:05:40*

---

> "The difference between a senior manager and a director is how you lead and the work you're doing. And you can get as far as senior manager by being really strong in your function and being really good at getting things done. As a director, and as a VP beyond that, it becomes much more about influence, coordination with others, and letting go of being in all the details yourself."

**Insight:** Advancing to executive levels requires shifting from functional execution to strategic influence and delegation.

**Tactical advice:**
- Practice 'next level' skills like strategic project leadership before you have the title
- Focus on influence and cross-functional coordination rather than just functional depth
- Let go of being involved in every detail to demonstrate executive readiness

*Timestamp: 00:24:29*


## Ian McAllister
*Ian McAllister*

> "If you simply wake up every day trying to have the biggest impact you can... that's a really good guiding light. And I remember in my first 10 years at Amazon... I never talked to my manager about it and I wasn't bringing it up. I was just focused on taking my book of business and making it bigger. And then the net result was I was promoted several times."

**Insight:** Focusing exclusively on business impact rather than the promotion process itself is often the most effective path to advancement.

**Tactical advice:**
- Focus on growing your 'book of business' rather than discussing promotion
- Optimize for impact as the primary indicator for career growth

*Timestamp: 00:26:38*


## Jackie Bavaro
*Jackie Bavaro*

> "Have a conversation with your manager and say, 'I would really like at some point in the future to grow into whatever this goal is... What do you suggest that I work on now so that I'll be ready when the opportunity comes up?'... I'm framing it in the future so that it's not threatening. It's not like going to put my manager on the defensive... And then it brings them onto your side."

**Insight:** Framing promotion goals as future-dated growth opportunities makes managers allies rather than gatekeepers.

**Tactical advice:**
- Ask: 'What do you suggest I work on now so I'll be ready when the opportunity comes up?'
- Focus feedback requests specifically on the skills needed for the next level

*Timestamp: 36:41*


## Jeffrey Pfeffer
*Jeffrey Pfeffer*

> "The reason why you should pay attention to this is because it leads to a lot of good things, salary, getting promoted, being happy in your career, being less stressed."

**Insight:** Political and power skills are directly correlated with tangible career outcomes like salary increases and promotions.

**Tactical advice:**
- Master political skills to improve your chances of advancement and higher compensation.

*Timestamp: 00:00:02*

---

> "There are many ways to get promoted, but I will guarantee you one thing, no one is going to promote Lenny if they don't know who the hell you are. So it is not sufficient for them to know who you are. They have to know that you're smart and personable and have whatever skills you've got, but they have to know you."

**Insight:** Visibility and brand recognition within an organization are prerequisites for promotion; competence alone is insufficient.

**Tactical advice:**
- Differentiate yourself so that decision-makers are aware of your existence and your specific skills.
- Ensure you have visibility to match your substance.

*Timestamp: 00:16:52*


## Jiaona Zhang
*Jiaona Zhang*

> "I think it's really important to become really good at and also known for something. You could be known for shepherding like the most complex launches because you're just so good at quarterbacking. Working with go-to--market teams and cross-functional stakeholders that could be like your thing. You could be known for working on the most technically complex problems, find something that you can be really, really good at. And the reason I give that advice is because when you do that, you can crush the projects that you get because you're making a name for yourself, reputation, and then you are giving more responsibility. People tend to flock and give responsibility to the people that are known for being excellent at something."

**Insight:** Accelerate your career by developing a 'superpower' or reputation for a specific type of excellence, which naturally attracts more responsibility and trust from leadership.

**Tactical advice:**
- Identify a specific niche to be excellent at (e.g., complex launches, technical depth, or regulatory complexity)
- Build a reputation for 'getting shit done' to earn more responsibility
- Flex your core strengths as you transition from IC to management

*Timestamp: 00:00:00*


## Julie Zhuo
*Julie Zhuo*

> "A lot of these things you don't need to have the official title to do. You can do a lot of it in that capacity as an IC... If you're a part of a company that's growing and has a summer internship program, awesome. Can you go in and sign up and mentor and intern and manage an intern."

**Insight:** Build a case for a management promotion by performing 'manager-lite' tasks as an individual contributor to prove competency.

**Tactical advice:**
- Volunteer to be an onboarding buddy for new hires
- Ask to lead specific processes, like restructuring a team meeting
- Mentor interns to practice people management skills before having direct reports

*Timestamp: 00:59:19*


## Laura Schaffer
*Laura Schaffer*

> "The problem with it is that you're limited to what your manager's ability is to advocate for you, to promote you. And you're also limited by the explicit trajectory of your role at that company and where the there's room for that or not at the company... The method that I use tries to take that power back a little bit."

**Insight:** Relying solely on a manager's advocacy for promotion is risky; you must proactively build your own internal brand and trajectory.

**Tactical advice:**
- Stay close to the customer to gain unique insights that executives lack
- Bring insights to life by aligning them with North Star metrics
- Build a brand as the person who 'just knows' the customers to create cross-team opportunities

*Timestamp: 00:06:52*


## Manik Gupta
*Manik Gupta*

> "I'm a big fan of looking at both the what and the how. So what did they accomplish and how did they accomplish... On the what... it's really about real demonstrated impact. An ideal example is someone who had a strong product hypothesis, they rallied a bunch of people around them... On the how, I just love people who are able to create both energy and create clarity... Then the last thing I would say is followership. Really important for PMs. Do people want to work with them?"

**Insight:** Promotion readiness is evaluated through a combination of objective impact, the ability to generate organizational clarity, and 'followership'—the degree to which others want to work with the individual.

**Tactical advice:**
- Demonstrate an end-to-end product cycle from hypothesis to measurable impact.
- Focus on becoming a source of clarity and energy for the cross-functional team.

*Timestamp: 00:45:01*


## Matt LeMay
*Matt LeMay*

> "I have a friend who does resume coaching, and I showed her my resume a couple of years ago. And she said, 'I love your resume except for one thing. Why do you write like a little girl? Say what you did, say what your contributions were. Don't say 'I helped. I may have maybe helped people do this'. Say the impact. Put the number on it.'"

**Insight:** When documenting your career achievements, replace passive language with specific, quantified impact to demonstrate your value to the business.

**Tactical advice:**
- Avoid using 'helped' or 'contributed to' in favor of direct impact statements.
- Quantify your results with specific numbers and business outcomes.

*Timestamp: 00:10:40*


## Nikhyl Singhal
*Nikhyl Singhal*

> "I think that the biggest one in workplace is focusing career and promotion together. I think that there's perhaps a light connection between promotion and career addition, but I feel like too many people are, the moment we talk about career, they're like, 'Well, let me talk to you. I want to have a career talk with you.' And I said, 'Sure, why don't you find some time?' We sit down together and they're like, 'Well, what do you think I need to do to get to promotion?'"

**Insight:** Promotion is a company-specific system for leveling, whereas a career is a long-term personal arc; don't conflate the two.

**Tactical advice:**
- Distinguish between 'promotion talks' (short-term leveling) and 'career talks' (long-term growth)
- Evaluate if a promotion is actually in service of your 'job after next'

*Timestamp: 00:09:17*

---

> "I think that the answer of what you do is correlated with what's the real reason. And I think that there may be, I'll suggest four kind of common things I've seen that really hold people back... One is that you just don't have advocacy... The second that's very common now... is the next role doesn't exist... The third is when you are being impatient... And then the fourth one... is really, there is a development area but it isn't quite connected to the individual."

**Insight:** Failure to get promoted usually stems from one of four areas: lack of advocacy, lack of role availability, personal impatience, or unaddressed development gaps.

**Tactical advice:**
- Identify if you have an advocate who 'sees the magic' in your work
- Assess if the organizational structure actually has a vacancy at the next level
- Seek 'ground truth' feedback to identify development areas you might be dismissing

*Timestamp: 00:26:25*


## Petra Wille
*Petra Wille*

> "Getting promoted is way harder if you're not good in telling stories and rallying the team behind the shared goal and all these kind of things, and you usually achieve this through good storytelling techniques. And in some teams, I've seen the product person not being really, really good at it, but then the whole team helped creating these stories and stuff like this. So you definitely could compensate to some extent, but I would consider it a bit of a career staller if you don't get to a decent level of storytelling and to a decent level of public speaking."

**Insight:** Storytelling and public speaking are critical competencies for advancing to leadership roles and rallying teams.

**Tactical advice:**
- Master storytelling techniques to rally teams behind shared goals
- Develop public speaking skills to avoid career plateaus

*Timestamp: 00:00:00*


## Shweta Shriva
*Shweta Shriva*

> "I'm going to say something that might sound a little cheeky, but I think the way to get promoted is to not want it too badly. It is about you have to focus on the impact. It's about having an impact and then doing what is right for the business. So not sort of optimizing things for your promotion... focus on the impact."

**Insight:** Promotions should be treated as a byproduct of business impact and skill development rather than the primary goal of self-optimization.

**Tactical advice:**
- Focus on creating the right outcomes for the business rather than maneuvering for a title.
- Improve your core product management skillset to naturally qualify for higher levels.
- Seek out challenging, high-visibility projects that stretch your current skills.

*Timestamp: 33:28*


## Paige Costello
*Paige Costello*

> "If you're present in your job, and you actually have fun with it and solve the problems, people will come out of the woodwork, say, 'You're great, and tell your boss you should be promoted.' You don't need to ask for a promotion. Your outcomes should speak for themselves."

**Insight:** The strongest promotion case is built on high-quality outcomes and solving problems that make others advocate for you organically.

**Tactical advice:**
- Focus on solving high-impact problems that lead others to advocate for your advancement.
- Prioritize raw connection to the work and team over explicit promotion-seeking.

*Timestamp: 00:48:17*


## Tamar Yehoshua
*Tamar Yehoshua*

> "One of the things that I think is overlooked is do a really good job at whatever your job is at that point. People have a tendency ... Especially product managers are very ambitious and they want to get to the next level and they're always eyeing the next job, but you're not going to get the next job unless you do really well at the job that you're in. Knock it out of the park."

**Insight:** The most effective way to advance is to achieve excellence in your current role rather than focusing prematurely on the next one.

**Tactical advice:**
- Master the 'table stakes' of your current role: technical knowledge, product understanding, and metrics.

*Timestamp: 00:02:47*

---

> "Are you helping the business move forward? So it's not about I achieve what I was asked to do, but did you build something that people actually used? It's not about just launching something and did you do the right thing for the company? And that is different. It's a different mindset."

**Insight:** Promotion-worthy performance is defined by business impact and doing the right thing for the company, not just completing assigned tasks.

**Tactical advice:**
- Focus on whether your work is actually being used by customers, not just the act of launching.
- Be willing to suggest shutting down unproductive teams or projects, even if you were meant to lead them.

*Timestamp: 00:10:00*


