---
name: building-sales-team
description: Help users build and scale their sales organization. Use when someone is hiring their first salespeople, deciding when to bring on sales leadership, structuring sales compensation, or transitioning from founder-led sales.
---

# Building Sales Team

Help the user build and scale a high-performing sales organization using frameworks from 14 product leaders who have built sales teams from zero to scale.

## How to Help

When the user asks for help with building a sales team:

1. **Understand their stage** - Ask about current revenue, deal size, sales motion (inbound vs outbound), and whether founders are still closing deals
2. **Identify the trigger** - Determine if they have a repeatable sales motion with a measurable win rate before recommending hires
3. **Match the profile to the motion** - Help them find the right sales archetype for their specific buyer and channel
4. **Structure for validation** - Guide them on hiring in pairs, compensation structures, and when to add management

## Core Principles

### Prove repeatability before hiring
Pete Kazanjy: "You can reliably, at a pretty okay win rate, so maybe 15% or 20% or 25%, turn first meetings into eventual customers." Wait until founders achieve a statistically significant win rate (50-100 at-bats) before hiring salespeople.

### Always hire in pairs
Jason Lemkin: "You need to hire one rep and you've got to hire two because otherwise, there's no A-B test. You have to A-B test humans." Hiring two reps simultaneously creates a baseline for performance and validates that your process works regardless of individual talent.

### Delay sales hires until Series A
Jen Abel: "Seed is all about experimentation and proving out that experiment, and then obviously series A is about exploiting that learning." The founder must close deals personally to learn the market before delegating.

### Match profiles to your motion
Annie Pearl: "In those early days, it's more inbound in nature, and so the type of sales reps you might need are not necessarily going to be outbound, heavy hunting sales reps." Hire "grower" profiles for PLG/inbound, "hunter" profiles for outbound.

### Look for founder-like sellers
Jen Abel: "I always say you need people that can cosplay a founder, which is selling the vision, getting through walls to get the deal done." Early sales hires should be product-obsessed "pirates and romantics" who can adapt deal structures.

### Sales hires must pass the PM test
Jeanne Grosser: "If you are an account executive in my org and I put you in front of 10 engineers at our company, it should take them 10 minutes to figure out you aren't a product manager." In technical companies, sales must have deep product knowledge.

### Don't hire a VP too early
Jason Lemkin: "You need two sales reps hitting quota closing deals before you're ready to hire a manager for them. Almost all VPs of sales, their job is to take you from rep three to 300."

### Pilot PLS separately from quota pressure
Elena Verna: "Attach to yourself a pilot AE, so account executive, or an SDR and see how that works... not under pressure of top-down quota relief." Experiment with product-led sales outside the traditional sales engine.

## Questions to Help Users

- "What's your current win rate from first meeting to closed deal?"
- "Are you selling to arms-length prospects or mostly warm intros?"
- "What's your average deal size and sales cycle length?"
- "Is your motion primarily inbound or outbound?"
- "Do you have two reps hitting quota consistently?"
- "Who is your target buyer persona - department head or C-level?"

## Common Mistakes to Flag

- **Hiring sales before founder-led repeatability** - If the founder can't close deals consistently, salespeople won't either
- **Hiring a VP of Sales first** - Start with two pioneer AEs, not a manager who hasn't sold in years
- **Mismatching sales profile to motion** - Oracle reps selling to CIOs won't work if you're selling to RevOps managers
- **Single-point-of-failure hiring** - One rep succeeding could be luck; two reps validates the process
- **Ignoring the 50% failure rate** - Half of early sales hires don't work out, so plan accordingly

## Deep Dive

For all 22 insights from 14 guests, see `references/guest-insights.md`

## Related Skills

- Founder Sales
- Enterprise Sales
- Partnership & BD
- Product-Led Sales Strategy
