# Building Sales Team - All Guest Insights

*14 guests, 22 mentions*

---

## Annie Pearl
*Annie Pearl*

> "In those early days, it's more inbound in nature, and so the type of sales reps you might need are not necessarily going to be outbound, heavy kind of hunting sales reps... making sure that the profile, the folks you're bringing on early match that target buyer in addition to match the motion around how you're going to be acquiring customers."

**Insight:** Early sales hires in a PLG company should match the current inbound motion and the specific target buyer (e.g., department heads vs. CIOs).

**Tactical advice:**
- Hire 'grower' profiles rather than 'hunter' profiles for early inbound-heavy PLG motions.
- Match the sales rep's background to the target buyer (e.g., don't hire Oracle reps used to CIOs if you are selling to RevOps).

*Timestamp: 00:27:17*


## Archie Abrams
*Archie Abrams*

> "We shouldn't force the merchant to choose, do you want to talk to sales? You want to do self-service? Should give them the options, whatever path that they want to go on. And so a lot of that has been building into the self-service journey over to sales and then from sales into self-service."

**Insight:** Successful PLG-to-Enterprise transitions require 'hybrid journeys' where users can move fluidly between self-service and sales-led motions.

**Tactical advice:**
- Avoid siloing the sales and self-service funnels; provide 'talk to sales' options within the product onboarding.
- Rebuild LTV and attribution models to account for users who start in self-service but close via sales.

*Timestamp: 01:03:05*


## Ben Horowitz
*Ben Horowitz*

> "you're going to have to hire somebody who knows sales... there's a lot of knowledge in how to build a worldwide sales organization; maybe knowledge of customers, territories, territory splitting, rep profiles. There's just a litany of stuff that you really can only learn by doing trial and error"

**Insight:** Specialized functions like sales require experienced leadership to avoid costly trial-and-error mistakes.

**Tactical advice:**
- Hire for specific domain knowledge in territory management and rep profiling
- Don't assume a smart generalist (like a PhD) can reinvent specialized operational functions efficiently

*Timestamp: 00:39:08*


## Elena Verna
*Elena Verna 2.0*

> "Attach to yourself a pilot AE, so account executive, or an SDR and see how that works. You kind of separate yourself from the mothership of the sales engine and you actually prototype this separately in a little bit of a vacuum, not under pressure of them top-down quota relief."

**Insight:** When starting a PLS motion, use a small pilot team to experiment outside the traditional sales quota system.

**Tactical advice:**
- Don't hire salespeople until you feel organic demand (hand-raisers) from the product
- Start with a blend of SDR and AE roles before specializing
- Consider using support or customer success teams to close early deals before hiring dedicated sales

*Timestamp: 00:52:05*

---

> "If your money collection is going to happen through sales team primarily, then you absolutely should be hiring sales way before growth. In fact, in the sales led companies, growth teams are not necessarily needed even that much."

**Insight:** In B2B SaaS, the hiring order depends on the primary monetization motion: sales-led companies should prioritize sales hires over growth.

**Tactical advice:**
- Hire sales first if the product requires human-led activation, monetization, and retention.
- Hire growth first only if you are starting with a self-serve monetization model.

*Timestamp: 00:12:42*


## Geoffrey Moore
*Geoffrey Moore*

> "Enterprise salespeople are not good chasm crossers because they're used to doing horizontal coverage model... You want somebody that looks more like a sales engineer than a salesperson. You want somebody very diagnostic, very committed to the integrity of the problem solution framework."

**Insight:** The sales profile needed to cross the chasm is more technical and diagnostic than a traditional enterprise account executive.

**Tactical advice:**
- Hire 'sales engineer' types for early pragmatic sales rather than high-volume horizontal sellers.
- Prioritize domain expertise and diagnostic skills over traditional sales 'closing' techniques.

*Timestamp: 01:13:12*


## Jason M Lemkin
*Jason M Lemkin*

> "You need to hire one rep and you've got to hire two because otherwise, there's no A-B test. You have to A-B test humans. You've got to hire two as hard as it is, and there's just one cheat code to those first two."

**Insight:** Hire two sales reps simultaneously to create a baseline for performance and ensure the sales process is repeatable rather than dependent on one individual.

**Tactical advice:**
- Hire two reps at the same time to A-B test performance
- Look for 'pirates and romantics' who are product savants in the early days

*Timestamp: 00:14:26*

---

> "You need two sales reps hitting quota closing deals before you're ready to hire a manager for them. Almost all VPs of sales, their job is to take you from rep three to 300."

**Insight:** Do not hire a VP of Sales until you have at least two individual contributors successfully hitting their quotas.

**Tactical advice:**
- Wait until two reps are hitting quota before hiring a VP
- Hire a 'stretch' VP who was previously a director rather than a seasoned veteran

*Timestamp: 00:19:14*

---

> "In sales, I'm actually not sure what the tip of heuristic is in product... But the thing about sales is there's no efficiency... it's rules of eight. Eight SDRs, outbound reps need one manager, eight AEs, eight sales execs need a director above them."

**Insight:** Sales organizations scale effectively using a 'rule of eight' for management spans of control.

**Tactical advice:**
- Maintain a 1:8 ratio of managers to individual contributors
- Hire a director once you have eight scaled AEs

*Timestamp: 01:00:03*


## Jen Abel
*Jen Abel*

> "I have this theory that maybe you shouldn't hire any salespeople until series A, right? Because seed is all about experimentation and proving out that experiment, and then obviously series A is about exploiting that learning."

**Insight:** Hiring sales talent too early can be detrimental because the seed stage requires the founder's ability to experiment and learn directly from the market.

**Tactical advice:**
- Wait until the sales motion is repeatable and the 'experiment' is proven before hiring non-founder sales staff.

*Timestamp: 00:37:33*

---

> "I always say you need people that can cosplay a founder, which is selling the vision, getting them excited, running through a wall to get the deal done and getting creative on ... None of my deals look exactly the same, every deal looks different and that's okay because every organization has slightly different opportunities."

**Insight:** The best early sales hires are those who can 'cosplay the founder' by selling vision and creatively structuring deals rather than just following a playbook.

**Tactical advice:**
- Look for hires with founder experience or deep product/engineering backgrounds rather than just traditional sales experience.
- Hire two salespeople at once to compare performance, given the high failure rate (50%+).

*Timestamp: 00:51:27*

---

> "It's usually 50/50. So it's 50% OTE. So it's 50% base salary, 50% OTE... In technology, it could be anywhere between eight and 12%. So rounds out around 10%."

**Insight:** Standard enterprise sales compensation is a 50/50 split between base salary and on-target earnings (OTE), with commissions around 10%.

**Tactical advice:**
- Structure incentives so salespeople see the potential for high earnings, which drives enthusiasm.

*Timestamp: 00:57:53*


## Melissa Tan
*Melissa Tan*

> "We would hire a ton of really smart people that had never done sales and had them do sales. There are a lot of disadvantages to that, but I do think it led to a ton of innovation. That's how we got our very innovative go-to market motions because a lot of those people then moved into different functions at the company."

**Insight:** Hiring high-potential non-experts for early sales roles can foster innovation and build deep user empathy that benefits other departments later.

**Tactical advice:**
- Hire 'first principles thinkers' rather than just experienced sales reps for early motions
- Use early sales roles as a training ground for future product and growth leaders

*Timestamp: 00:00:00*


## Merci Grace
*Merci Grace*

> "The point at which you should start to hire someone else to do that is when you, as the founder, absolutely cannot meet the demand... And then the other time to do that, apart from just being maxed out, is when you are moving in to and usually up to a customer that both wants and expects to meet with a salesperson."

**Insight:** Hire your first salesperson when founder capacity is reached or when the target customer segment requires a human touch to close deals.

**Tactical advice:**
- Wait to hire sales until the founder is physically unable to handle the lead volume.
- Listen for customer signals that they expect a formal sales process before buying.

*Timestamp: 43:01*


## Pete Kazanjy
*Pete Kazanjy*

> "Generally speaking, it is to contingent on your sales motion, but it's going to be that you can reliably, at a pretty okay win rate, so maybe 15% or 20% or 25%, turn first meetings into eventual customers and do that in a reliable fashion. It's not like, "I engaged 10 arms-length parties and I got two customers closed." It's like, "Hey, that's great. That's a good start. 5X that, 10X that.""

**Insight:** The right time to hire the first salesperson is when the founder achieves a repeatable 15-25% win rate over 50-100 at-bats.

**Tactical advice:**
- Measure your win rate from first meeting to closed deal
- Ensure you are selling to 'arms-length' prospects, not just friends or family, before hiring
- Wait until the sales motion is statistically significant and repeatable

*Timestamp: 00:15:10*

---

> "Generally, what you want to do is you probably don't want to start with a VP of sales to start... what you want to do is you want to hire a couple early-stage pioneer sellers to take that sales motion. The downside of seeking to hire a VP of sales... is that person hasn't been selling for a hot second."

**Insight:** Avoid hiring a VP of Sales as the first hire; instead, hire two 'pioneer' Account Executives who are willing to do the gritty work.

**Tactical advice:**
- Hire two sellers simultaneously to compare performance and avoid single-point-of-failure bias
- Look for 'deputies' or early sellers from successful companies in your space
- Target candidates who have sold to the same persona at a similar price point

*Timestamp: 00:40:33*


## Sahil Mansuri
*Sahil Mansuri*

> "What we haven't done is built a modern technical sales compensation plan that actually aligns the needs and incentives of the business, the customer and the rep... I think that setting up a longer horizon where if the customer you sign up today ends up renewing tomorrow, the rep should get a kicker on it."

**Insight:** Modernize sales compensation by rewarding long-term retention and customer value rather than just top-line new business.

**Tactical advice:**
- Align incentives between the customer, the business, and the rep
- Incorporate 'kickers' or bonuses for customer renewals into the AE comp plan
- Measure and reward reps based on the renewal rates of the customers they sign

*Timestamp: 00:31:31*


## Sri Batchu
*Sri Batchu*

> "we've had this team for almost two years now that that's been working on sales automation and data to just make our sales teams more efficient."

**Insight:** Modern sales teams can be significantly more efficient by embedding growth engineering and AI to automate prospecting and messaging.

**Tactical advice:**
- Embed growth engineers within the sales organization to build custom automation tools
- Use AI to prioritize leads and draft potential responses for sales reps

*Timestamp: 00:11:10*


## Varun Mohan
*Varun Mohan*

> "We hired our VP of sales over a year ago actually. And the go-to-market team is now over 80 people inside the company... if you want to sell to the Fortune 500, it is very hard to do that purely by swiping a credit card."

**Insight:** Even for highly technical products, enterprise adoption requires a robust, human-led sales motion.

**Tactical advice:**
- Hire a sales leader early if the target market includes large, security-conscious enterprises
- Build a sales process that addresses enterprise-specific needs like security, compliance, and personalization

*Timestamp: 00:35:40*


## Jeanne Grosser
*Jeanne Grosser*

> "The litmus test I have always given my sales team is if you are an account executive in my org and I put you in front of 10 engineers at our company, it should take them 10 minutes to figure out you aren't a product manager."

**Insight:** High-performing sales teams in technical companies must possess deep product knowledge and a PM-like mindset.

**Tactical advice:**
- Hire sales profiles that can pass for product managers in front of engineering teams.

*Timestamp: 00:01:23*

---

> "SDR is typically in charge of generating pipeline... account executives are closers. It's their job to take somebody from, 'Okay, hey, I'm interested in learning about your solution, I have a legitimate problem. I potentially could make a decision,' to, 'I now believe that your product is the best in the market for me and I'm willing to pay for it.'"

**Insight:** The sales organization is divided between pipeline generation (SDRs) and deal closing (AEs).

**Tactical advice:**
- Differentiate between inbound SDRs (qualifying leads) and outbound SDRs (generating interest).

*Timestamp: 00:24:01*

---

> "I strongly believe that sales is a skill and so you want salespeople with actual sales experience in your organization, but I think there's value in pairing them with more nontraditional backgrounds, in particular consulting or banking background. Those folks are really good at more quantitative and analytical aspects of sales."

**Insight:** A diverse sales team mixing traditional AEs with former consultants/bankers creates a more analytical and consultative culture.

**Tactical advice:**
- Hire a mix of traditional sales experience and analytical backgrounds like consulting or banking.

*Timestamp: 01:20:44*


