---
name: building-team-culture
description: Help users build and maintain strong team culture. Use when someone is defining team values, creating psychological safety, onboarding to a new team, navigating cultural change, or building distributed team norms.
---

# Building Team Culture

Help the user build and sustain high-performing team culture using frameworks from 138 product leaders who have shaped cultures at companies from startups to Google and Airbnb.

## How to Help

When the user asks for help with team culture:

1. **Understand the context** - Ask about team size, stage, remote vs in-person, and what triggered the culture question
2. **Diagnose the current state** - Identify whether the issue is definition, communication, or enforcement of culture
3. **Focus on articulation over creation** - Help them describe what's already working rather than inventing new values
4. **Design for decentralized decisions** - Ensure culture can guide behavior when leadership isn't present

## Core Principles

### Articulate, don't create
Dharmesh Shah: "Culture actually already exists... what I'm really trying to do is kind of describe the culture that's there. It's not creating culture, it's articulating the culture." Document the attributes of people who make others happy and successful.

### Culture is for when the boss isn't around
Chip Conley: "Culture is what happens around here when the boss is not around. The more distributed a company, the more culture is important." Use culture as a decentralized decision-making guide, especially for remote teams.

### Replace management with coaching
Cam Adams: "We don't really have managers, but everyone at Canva has a coach. They're constantly working with you to look at your skills, but also when it might be time to move on to the next level." Coaches focus on skill development and career trajectory, not task oversight.

### Earn trust before inflicting change
Katie Dill: "It can be hard to bring feedback forward like that. So it was an extremely valuable learning experience. I took from that to then immediately shift how I was operating." Prioritize listening over "coming in swinging" when joining a new team.

### Challenge sacred cows to cure stagnation
Kayvon Beykpour: "We wanted to change the lack of ambition, the lack of creativity, the lack of customers feeling that the product had changed at all." Identify and challenge cultural artifacts that prevent product evolution.

### Use culture as a talent magnet
Chip Conley: Culture attracts the right people and repels the wrong ones. Prioritize in-person gatherings for remote teams to reinforce cultural cues that can't be transmitted digitally.

### Make culture a living document
Dharmesh Shah: Create a "Culture Code" that acts as an operating system for the company. Update it as you learn what actually works versus what sounds good.

### Psychological safety enables feedback
Katie Dill: Building trust through active listening and empathy is the foundation for organizational change. Teams won't give honest feedback if they don't feel safe.

## Questions to Help Users

- "What behaviors do you see in your highest performers that you wish everyone exhibited?"
- "When has someone made a decision you disagreed with but couldn't fault their reasoning?"
- "What happens when someone fails publicly on your team?"
- "How do new hires learn 'how things work around here'?"
- "What decision would be made differently if you weren't in the room?"

## Common Mistakes to Flag

- **Inventing aspirational values** - Culture documents should describe what already works, not what you wish were true
- **Values without behaviors** - "We value innovation" is meaningless without specific examples of what that looks like in practice
- **Over-engineering for small teams** - Startups need shared understanding, not formal culture playbooks
- **Ignoring the distributed challenge** - Remote teams need explicit cultural transmission that co-located teams get implicitly
- **Leadership-culture mismatch** - Functional orgs require active leadership tiebreaking; if the CEO is hands-off, culture can't fill the gap

## Deep Dive

For all 212 insights from 138 guests, see `references/guest-insights.md`

## Related Skills

- Writing Job Descriptions
- Conducting Interviews
- Evaluating Candidates
- Onboarding New Hires
