---
name: coaching-pms
description: Help users develop and coach product managers. Use when someone is managing PMs, creating development plans, running performance reviews, or trying to level up their PM team's capabilities.
---

# Coaching Product Managers

Help the user develop and coach product managers using frameworks from 3 product leaders who have scaled PM organizations at top companies.

## How to Help

When the user asks for help with coaching PMs:

1. **Define "good" in context** - Establish what a successful PM looks like for their specific company and stage
2. **Assess current state** - Help diagnose where the PM is today across key competencies
3. **Create a shared vision** - Align on what growth looks like for both the PM and the organization
4. **Build a development plan** - Design specific actions, feedback loops, and timelines

## Core Principles

### Define good before coaching
Petra Wille: "Step number one is really having a solid definition of what a good product person looks like in your context." Create explicit competency frameworks before attempting to develop anyone.

### Use Bloom's Taxonomy for diagnosis
Bangaly Kaba: "Bloom Taxonomy describes what's the different levels or order of critical thinking... knowledge, comprehension, application, analysis, synthesis, and evaluation." Assess where PMs fall on the learning ladder to target development appropriately.

### Coaching is the primary leadership job
Marty Cagan: "Sundar at Google has been saying that the number one thing they look for in their leaders is a good coach." Top companies (Google, Apple, Microsoft) prioritize coaching ability over domain expertise in their leaders.

### Follow the 5-step framework
Petra Wille outlines a specific development process:
1. Definition of Good - What does success look like here?
2. Current Assessment - Where is the PM today?
3. Shared Vision - Where do they want to be?
4. Development Plan - What specific actions will get them there?
5. Follow-up - How will you track and support progress?

## Questions to Help Users

- "What does a 'great' PM look like at your company specifically?"
- "Which competencies are most critical for your current stage?"
- "Where is this PM on the knowledge-to-evaluation spectrum?"
- "What's the biggest gap between their current state and your needs?"
- "How much of your time as a leader goes to coaching versus doing?"

## Common Mistakes to Flag

- **Coaching without a competency model** - Development is aimless without a clear definition of good
- **Treating all PMs the same** - Junior PMs need different coaching than senior PMs
- **Focusing on weaknesses only** - Great coaching amplifies strengths while managing around weaknesses
- **Delegating coaching to HR** - PM development must come from PM leaders who understand the craft
- **Skipping the follow-up** - Development plans without accountability rarely produce results

## Deep Dive

For all 3 insights from 3 guests, see `references/guest-insights.md`

## Related Skills

- Running Effective 1:1s
- Having Difficult Conversations
- Delegating Work
- Managing Up
