---
name: community-building
description: Help users build and grow product communities. Use when someone is starting a community, scaling an ambassador program, driving community-led growth, or choosing between user, developer, or partner communities.
---

# Community Building

Help the user build and scale communities using frameworks from 18 product leaders who have built communities at Notion, Figma, WordPress, and more.

## How to Help

When the user asks for help with community building:

1. **Identify the community type** - Clarify if they need a user community, agency community, or partner community
2. **Find the atomic unit of sharing** - Determine what community members would naturally want to show off
3. **Start with listening** - Understand why early members are there before imposing structure
4. **Design for healthy growth** - Help them avoid scaling too fast and diluting quality

## Core Principles

### Build a movement, not just a product
Matt Mullenweg: "Don't just build a product, build a movement... we give people something to believe in, a philosophy, a worldview." The most successful communities unite around a shared mission, not just utility.

### Community drives enterprise de-risking
Camille Ricketts: "Your community helps you achieve such ubiquity and such name recognition that it actually allows you to start moving upmarket into the enterprise." Widespread community adoption signals safety to enterprise buyers.

### Go where the community already is
Claire Butler: "Dylan identified immediately that Twitter was the place where that existed... he built this tool or this scraper where he identified a couple influencers in the design community." Map the social graph of influencers to find key entry points.

### Find your atomic unit of sharing
Camille Ricketts: "Community lends itself particularly well if you have something that your product creates that people want to share because it exhibits something about themselves." Templates, workspaces, and creations drive organic community content.

### Community amplifies word of mouth
Elena Verna: "Community is really important here because you need to bring people together as they're exploring... Community also amplifies that word of mouth." Launch Discord early to allow users to share and help each other.

### Start small with the most vocal
Camille Ricketts: "The initial base of the ambassadors program was just 20 people and they were the 20 people who we happened to see be the most vocal already." Identify organic supporters before creating formal programs.

### Listen before structuring
Camille Ricketts: "I would recommend highly not necessarily coming in with preconceived notions about what a community needs to look like... a lot of listening of the people who are actually participating." Conduct 1:1 calls with early members to understand their needs.

### Protect quality over growth
Camille Ricketts: "Don't dilute the impact of what it is that you're trying to do in order to show growth. Make sure that you are learning what individuals really want." Implement application processes and cohort-based onboarding to maintain intimacy.

## Questions to Help Users

- "What would members naturally want to share or show off?"
- "Where does your target audience already gather online?"
- "Who are your 20 most vocal organic supporters right now?"
- "What problem does the community solve that the product alone doesn't?"
- "Is your goal user community, agency community, or partner community?"
- "What would make this community feel like home to members?"

## Common Mistakes to Flag

- **Scaling too fast** - Growing before establishing norms creates the "auditorium effect" where no one speaks
- **Forcing a platform** - Building on Slack when your users live on Discord (or vice versa)
- **Over-monetizing early** - Prioritize ubiquity and word-of-mouth over extracting revenue
- **Treating community as marketing** - Community requires genuine value creation, not promotional content
- **Hiring non-practitioners** - Advocates must be respected members of the community, not just marketers

## Deep Dive

For all 30 insights from 18 guests, see `references/guest-insights.md`

## Related Skills

- Positioning & Messaging
- Brand Storytelling
- Launch Marketing
- Content Marketing
