# Community Building - All Guest Insights

*18 guests, 30 mentions*

---

## Alex Komoroske
*Alex Komoroske*

> "I created a secret group that I called Navel Gazers... you set the norms very explicitly and say, 'This is a collaborative debate environment. This is only yes, and.'... This sounds by the way very non-rigorous... It turns out there's limited amounts of time and so people will choose to build on the things they find most interesting."

**Insight:** Internal 'Nerd Clubs' or strategy salons create high-value insights by using 'yes, and' norms to filter for the most resonant ideas in a low-stakes environment.

**Tactical advice:**
- Start with a small 'seed crystal' of highly engaged people to establish norms before scaling.
- Use 'I wonder' statements to offer critiques without triggering defensive reactions.
- Actively facilitate by encouraging people to share their ideas in the group and providing positive reinforcement (emojis, notes).

*Timestamp: 00:49:17*


## Camille Ricketts
*Camille Ricketts*

> "it's when your community helps you achieve such ubiquity and such name recognition that it actually allows you to start moving upmarket into the enterprise. And I know that might be very specific to enterprise oriented companies, but that's how we defined it at Notion was the fact that so many people were talking about this, sharing what they had built about it, honestly starting businesses of their own around it to formalize the relationship with teams that I think it de-risked Notion as a choice for a lot of companies"

**Insight:** Community-led growth creates ubiquity and name recognition that de-risks the product for enterprise buyers.

**Tactical advice:**
- Focus on achieving ubiquity to move upmarket
- Encourage users to build their own businesses or formalize relationships around your product

*Timestamp: 00:13:09*

---

> "I think that community lends itself particularly well if you have something that your product creates that people want to share because it exhibits something about themselves. So at Notion it was templates or even people just creating their own workspaces and being really excited to show them off. So Notion really benefited from being a creative product, but the same is true of Figma or Canva or any of these where showing people what it is that you've created is an aspirational thing to do."

**Insight:** Community thrives when a product has an 'atomic unit of sharing' that allows for self-expression or aspirational display.

**Tactical advice:**
- Identify the 'atomic unit of sharing' in your product
- Enable users to show off their creations to signal expertise or organization

*Timestamp: 00:20:19*

---

> "I would really urge people to sit down and really think carefully what is going to be more conducive to our long-term success? Is it going to be that ubiquity or is it going to be revenue now? And I think if we look at a lot of the companies that have been just wildly successful from the start, they're people who have pushed off maybe monetizing every little thing if it's going to really put a damper on that type of enthusiasm and momentum"

**Insight:** Prioritize long-term ubiquity and word-of-mouth momentum over immediate monetization of every feature.

**Tactical advice:**
- Evaluate if organic word-of-mouth is more valuable than short-term revenue
- Avoid over-monetizing early if it dampens community enthusiasm

*Timestamp: 00:27:45*

---

> "I would recommend highly not necessarily coming in with preconceived notions about what a community needs to look like. ... I think that some communities get built where people are like, okay, well we have this community and it's going to be this and this and this... As opposed to I think a lot of listening of the people who are actually participating."

**Insight:** Avoid rigid, preconceived structures for community; instead, listen to active participants to shape the experience.

**Tactical advice:**
- Conduct one-on-one or small group Zoom calls with early members to ask why they are there
- Follow the lead of the community rather than forcing a specific format

*Timestamp: 00:26:21*

---

> "The initial base of the ambassadors program which started back in 2019 was just 20 people and they were the 20 people who we happened to see be the most vocal already across Twitter and a couple of other social media platforms because they had that shared quality of wanting to be really vocal and expressive about their experience with the product."

**Insight:** Start an ambassador program small with the most vocal organic supporters rather than a large, unvetted group.

**Tactical advice:**
- Identify the most vocal users on social media for your initial cohort
- Start with a small, manageable group (e.g., 20 people) to build core relationships

*Timestamp: 00:38:10*

---

> "not trying to hit a number early on. So don't dilute the impact of what it is that you're trying to do in order to show growth. I think that that's very important to protect yourself early on. So making sure that you are learning what individuals really want out of this and making them feel like they're very seen and very heard."

**Insight:** Protect the quality of the community by avoiding growth targets that might dilute the experience early on.

**Tactical advice:**
- Prioritize making individual members feel seen and heard over total member count
- Share community wins and stories internally to inspire the company

*Timestamp: 00:41:50*

---

> "not growing it so big so fast. One thing that we actually thought about pretty carefully was what a rate of healthy growth would be. So there actually is an application process for joining the ambassadors. ... I think it's because you don't really have a sense of who else is there with you. So helping to defray those concerns I think is a good course of action."

**Insight:** A healthy growth rate and an application process prevent the 'auditorium effect' where members feel too intimidated to speak.

**Tactical advice:**
- Implement a light application process to manage the intake of new members
- Induct new members in small monthly cohorts to allow for proper welcoming

*Timestamp: 00:43:12*


## Chris Hutchins
*Chris Hutchins*

> "he went on Twitter and he looked for every single person that asked a question about wine and he at replied them back... go find everyone that's asking questions about [your topic] and answer their questions with strong, good answers."

**Insight:** Early community growth is built through manual, high-value interactions answering specific user questions on social platforms.

**Tactical advice:**
- Search social platforms for users asking questions related to your expertise
- Provide helpful, non-promotional answers to build authority and attract followers

*Timestamp: 00:46:32*


## Claire Butler
*Claire Butler*

> "Dylan really identified immediately that Twitter was the place where that existed... he built this tool or this scraper where he identified a couple influencers in the design community... he figured out who followed them and who followed those people and also the influence that these people had over other people, and made this massive node graph."

**Insight:** Identify where your target community already lives and map their influence patterns to find the most effective entry points.

**Tactical advice:**
- Go to where the community already is rather than trying to force them to a new platform
- Map the social graph of influencers to identify key nodes for feedback and outreach

*Timestamp: 00:45:00*

---

> "The first person I hired was actually a designer advocate... that designer advocacy positions actually scaled with Figma, and we still have it today. It's extreme. I think it's the magic dust, we call it, that we sprinkle on go-to-market to make a lot of our go-to-market function work."

**Insight:** Hiring respected practitioners as advocates is a critical 'magic dust' for building authentic community relationships and technical credibility.

**Tactical advice:**
- Hire advocates from within the existing user base who are passionate about the tool
- Embed advocates in marketing, sales, and product feedback loops

*Timestamp: 00:35:32*


## Crystal W
*Crystal W*

> "we almost create this artificial friction to help differentiate how deeply a user wants something or needs something. And if the user doesn't fill out that questionnaire, maybe they're actually looking for something else."

**Insight:** Intentional friction, such as detailed questionnaires, can effectively filter for high-intent community members.

**Tactical advice:**
- Use 'hand-raiser' approaches to identify specific user needs
- Leave 'breadcrumbs' in the app to track how deeply a user wants to engage with a community

*Timestamp: 00:35:57*


## Elena Verna
*Elena Verna 4.0*

> "Community. I think community is really important here because you need to bring people together as they're exploring these capabilities... Community also amplifies that word of mouth. It amplifies all of the social posting."

**Insight:** In emerging categories, community serves as a support layer for users exploring new capabilities and as a distribution amplifier.

**Tactical advice:**
- Launch a Discord community early to allow users to share what they've built and help each other.
- Create an ambassador program to empower the most active community members.

*Timestamp: 00:50:38*

---

> "At Nero, we were first trying to stand up community... I went and I started talking to a bunch of people that have done communities... She's like, 'Well, are you talking about a user community or an agency community or a partner community?'... She would applying it to me in a structural way for me to grasp my head around it and then implement something that had much better results."

**Insight:** When building a community, distinguish between user, agency, and partner segments to determine which will drive the fastest business results.

**Tactical advice:**
- Consider starting with agency or partner communities if you need to show traction within a short timeframe (e.g., 12 months).
- Seek structural advice from community experts to avoid treating community building as a slow 'find PMF' process.

*Timestamp: 00:37:23*


## Janna Bastow
*Janna Bastow*

> "Honestly, it wasn't so much that we set out to build a community, it was that we got together with some product people with the idea that we didn't know what we were doing. And so we figured if we got together with some other product people and started chatting it through, we'd all learn together. And so it was just the sense of sharing and collaborating and learning from each other and just keeping it as grassroots as possible as it grew."

**Insight:** Successful communities often start as grassroots efforts focused on mutual learning and consistent presence.

**Tactical advice:**
- Maintain consistency by holding events at regular intervals (e.g., monthly meetups, annual conferences)
- Empower community members to curate content and find speakers to expand the network beyond the founders' reach

*Timestamp: 06:23*


## Julia Schottenstein
*Julia Schottenstein*

> "We have a dbt Slack community of 50,000 and all of our employees are in that Slack channel regularly and can feel when we mess up or we don't quite deliver an experience that we're proud of, you will just see dozens of people trying to jump on board and try to make it better."

**Insight:** High-growth communities require employees to be active participants who can 'feel' the user's pain when the product falls short.

**Tactical advice:**
- Ensure employees are active in the community Slack to maintain a tight feedback loop.
- Hire from the community to ensure employees have a natural ownership of the product experience.

*Timestamp: 00:50:51*


## Laura Modi
*Laura Modi*

> "Airbnb is nothing without its hosts, nothing. If anything, Airbnb's product was its hosts. So there was a moment... where that narrative was building up more and more and we realized that there was a need to have a central team, which we called Hospitality, dedicated to equipping and recognizing and holding this product of our hosts accountable to their job."

**Insight:** In supply-driven marketplaces, the supply side is the actual product and requires a dedicated team to manage and empower it.

**Tactical advice:**
- Create a central team dedicated to equipping and recognizing your community members.
- Hold community members accountable to their role as the 'product' of the company.

*Timestamp: 00:06:26*


## Matt Mullenweg
*Matt Mullenweg*

> "If there's something unique I have for your audience, I would say it's don't just build a product, build a movement. And to the extent that we've been successful, I think it's that we give people something to believe in, a philosophy, a worldview."

**Insight:** The most successful communities are built around a shared philosophy or movement rather than just product utility.

**Tactical advice:**
- Define a clear worldview or philosophy that users can align with
- Shift focus from building features to building a 'movement'

*Timestamp: 00:35:48*

---

> "So, those sorts of things bring a little art and soul and some fun into it as well. It doesn't have to be serious all the time. I think they can give something to believe in and work on and aim towards that's more than just a paycheck or more than just the utility, the base utility of the software."

**Insight:** Infusing a product with 'soul'—such as naming releases after jazz musicians—creates emotional resonance that sustains a community beyond functional needs.

**Tactical advice:**
- Incorporate non-utilitarian elements (art, naming conventions, rituals) to give the community 'soul'
- Create opportunities for community members to contribute beyond just code (e.g., events, documentation, support)

*Timestamp: 00:36:44*


## Meltem Kuran
*Meltem Kuran*

> "Those cheaper channels are often places where people are just trying to get an answer to their question. So whether that be search engine optimization through the articles that you write for people, looking onto Reddit where people are asking these questions in communities, forming partnerships with other groups that are trying to answer these questions, existing communities where other business leaders are connecting with each other and looking at their peers to find answers to shared problems that they're having, or places like Quora."

**Insight:** Early growth can be driven by providing genuine value in existing communities where users are actively seeking solutions.

**Tactical advice:**
- Identify communities (Reddit, Quora, Slack) where your target audience asks specific questions.
- Set up keyword alerts to track relevant conversations in real-time.

*Timestamp: 00:06:56*

---

> "The value-add way would be explaining what the solution to that problem is. Because the reality is there are a lot of people out there who can probably solve this, and then providing your solution, but answer their question first, and then let them decide if they want to come with you or go with someone else. But the whole point of someone asking a question isn't to be sold a solution. It's like, 'I just need an answer.' So genuinely treat this person like a friend of yours, answer their question."

**Insight:** Community engagement must be helpful and non-promotional to be effective and avoid being banned.

**Tactical advice:**
- Answer the user's question completely before mentioning your product.
- Avoid automated responses; use real team members to build trust.

*Timestamp: 00:13:25*


## Petra Wille
*Petra Wille*

> "A product community of practice could be a big part of that. So that is one impact. Then the other impact, there's less people development on the desk of the product lead if there is a good product community of practice. So product leads, your life will get so much easier if there is a product community of practice. And it's actually a pretty cheap way of doing people development because trainings are expensive, conference tickets are expensive, getting external product coach, expensive. But helping people to learn from each other by making room for that and giving them a bit of time to reflect and to share what they're learning, that's rather cheap."

**Insight:** Internal communities of practice are cost-effective tools for continuous learning, peer coaching, and employee retention.

**Tactical advice:**
- Create dedicated time for team members to share reflections and learnings
- Use a 'community canvas' to define purpose, values, and success metrics
- Distribute community leadership roles to ensure sustainability

*Timestamp: 00:56:31*


## Sriram and Aarthi
*Sriram and Aarthi*

> "Find the niche, start really small and find the niche... don't start to build this super scaled community. Start with few people who are passionate about a particular problem and want to get together kind of thing."

**Insight:** Successful communities start with small, passionate niches rather than attempting to scale immediately.

**Tactical advice:**
- Identify a specific, narrow problem or interest to anchor the initial community.
- Think about monetization early so it becomes a 'weapon' rather than a 'crutch' later.

*Timestamp: 00:31:38*

---

> "I like to think of things like a dinner party or church... as the host, you have to curate the original set of people and you need a mix... you need a mix of different kinds of energy and that's almost an alchemy."

**Insight:** A community host must curate a diverse mix of personalities (the boisterous, the quiet, the thoughtful) to create the right 'vibe'.

**Tactical advice:**
- Explicitly define the 'rules of the party' (e.g., formal vs. casual).
- Actively facilitate introductions to make new members feel comfortable.
- Establish rituals (like a recurring weekly meeting) to build intimacy.

*Timestamp: 00:33:24*


## Upasna Gautam
*Upasna Gautam*

> "The goal of it is to increase the awareness and education of product thinking and product management in newsrooms... making the resources more readily available, especially for those smaller newsrooms that don't have the money to hire tech talent."

**Insight:** Building a professional community (like the News Product Alliance) can help standardize a discipline in an industry where it is still in its infancy.

**Tactical advice:**
- Create mentorship networks to match experienced leaders with those new to the role
- Provide industry-specific frameworks (like PRDs for newsrooms) to lower the barrier to entry

*Timestamp: 44:16*


## Yuhki Yamashata
*Yuhki Yamashata*

> "there's something controversial about this idea that everyone can see what you're doing... that is signal that you're part of this revolution and you're trying to change something. And when it equips your customers or user base with that, then I think that's something that they can really get behind and champion. So it's not just that they're championing for a tool, they're also championing for a new way of working."

**Insight:** Successful community-led growth comes from equipping users with a 'revolution' or a new philosophy of work, not just a tool.

**Tactical advice:**
- Identify and empower 'champions' within organizations
- Create local chapters (e.g., 'Friends of Figma') to foster human connections between users
- Lean into 'narrative tension' or controversial product stances to build a loyal following

*Timestamp: 00:57:27*


## Dylan Field
*Dylan Field*

> "I constructed this list of, 'Here are the most central designers in the graph', but also then I looked at their work. And the ones that I was really inspired by as a total fanboy, and someone who wanted to learn as much as I could about design, was inspired by these folks, the ones I was inspired by I reached out to and said, 'Hey, can I buy you a coffee?'"

**Insight:** Build a community by identifying central nodes in a network and engaging them through genuine curiosity and a desire for feedback.

**Tactical advice:**
- Use social network analysis to identify influential figures in your target community
- Reach out to community 'heroes' for feedback rather than just promotion

*Timestamp: 31:01*


## Nickey Skarstad
*Nickey Skarstad*

> "I actually joined them on their community team. So I worked as a forums moderator, and then as a seller education specialist. Yeah. Spent a couple years doing that. And then through that process became sort of one of the internal voices that had a really good understanding of how their customer, one of their core customers, their sellers, were actually using their product."

**Insight:** Starting in community roles provides a deep, foundational understanding of the customer that can transition effectively into product management.

**Tactical advice:**
- Use community moderation to identify core customer pain points
- Leverage internal 'voice of the customer' status to transition into product roles

*Timestamp: 00:04:38*

---

> "Etsy was out there building in public... because they had such a passionate, involved, engaged early community that they could not just ship things and have them land well if they did not involve their community early. So they were doing prototyping, beta testing, and basically getting people to try things and give feedback on things."

**Insight:** Engaging a passionate community early through 'building in public' and beta testing ensures product launches land successfully.

**Tactical advice:**
- Involve the community in early prototyping and beta testing
- Use community feedback to evangelize the product and teach others how to use it

*Timestamp: 00:20:58*


## Varun Parmar
*Varun Parmar*

> "I think the other accelerant in all of this is the templates that we have, in particular the role that Miroverse plays in all of this... It actually got indexed by Google... that was another sort of acquisition channel top of funnel that actually drew a lot of users to it."

**Insight:** A community-driven template gallery (like Miroverse) acts as both a retention tool and a powerful SEO acquisition engine.

**Tactical advice:**
- Enable users to publish their own workflows as public templates to drive organic search traffic.
- Leverage community-created content to solve niche use cases that the core product team hasn't addressed.

*Timestamp: 01:13:07*


