---
name: competitive-analysis
description: Help users understand and respond to competition. Use when someone is positioning against competitors, evaluating market threats, running competitive war games, or deciding how much to focus on competitors versus customers.
---

# Competitive Analysis

Help the user understand competitive dynamics using frameworks from 49 product leaders who have navigated competition at companies from startups to Netflix and Google.

## How to Help

When the user asks for help with competitive analysis:

1. **Expand the competitive set** - Identify not just direct competitors but the status quo and workarounds
2. **Understand the true threat** - Determine if the competition is features, distribution, or fundamental business model
3. **Find asymmetries** - Help them identify unique advantages competitors cannot easily copy
4. **Design the right response** - Balance competitive awareness with customer obsession

## Core Principles

### Compete against the status quo
April Dunford: "Most folks will discount the status quo, but they shouldn't because in B2B we lose about 40% of our deals to 'no decision,' which actually means we lost to the spreadsheet, we lost to pen and paper." Position specifically against current workarounds, not just competitors.

### Define competitive alternatives first
April Dunford: "The first step in a good positioning exercise is to really understand, what do we have to position against? What do I have to beat in order to win a deal?" Look beyond direct competitors to anything customers would do if your product didn't exist.

### Understand industry economics deeply
Hamilton Helmer: "Understanding whether or not there is a type of power in place is hard... the hard part is industry economics, what really are the economic relationships." Surface-level competitive analysis misses the structural forces that determine winners.

### Ground everything in external reality
Shaun Clowes: "In everything always talk from the customer's perspective, from the market's perspective, from the competitor's perspective. The very small number of PMs do that." Great PMs differentiate by grounding work in market realities, not internal politics.

### Include the analog alternative
Bret Taylor: "Why use this instead of Yahoo Yellow Pages? But more than anything else, why use this instead of the Yellow Pages?" Compete against the traditional, non-digital way users solve the problem.

### Competition includes workarounds
Jake Knapp: "What's the competition for solving that problem? How do they solve it today? And what are the alternatives? What are the workarounds?" Look beyond direct startup competitors to manual processes and existing habits.

### Don't blindly copy competitors
Elena Verna: "Knowing what your competition is doing is extremely important... But blatantly copying all of these best tactics or flows because they're doing better than us - that's where things really go wrong." Use competitors for inspiration, not replication.

### Beware competitive myopia
Tanguy Crusson: "Your competitor, if you think of what they do as an iceberg, the top side is what they've shipped in terms of features, but it's based on all this stuff they've built in terms of research." You only see their past output, not their underlying strategy.

## Questions to Help Users

- "What would your customer do if your product didn't exist?"
- "What percentage of deals do you lose to 'no decision'?"
- "What's the weakness in your competitor's greatest strength?"
- "Is your advantage in features, distribution, or business model?"
- "How would a competitor describe your positioning?"
- "What market 'current' are you riding or fighting against?"

## Common Mistakes to Flag

- **Ignoring the status quo** - 40% of B2B deals are lost to doing nothing, not to competitors
- **Feature-by-feature comparison** - Distribution moats often matter more than feature sets
- **Fast-following without context** - Competitor features reflect year-old thinking, not current strategy
- **Assuming data creates moats** - Data advantages often diminish once competitors reach scale
- **Over-indexing on competitors** - Great for market awareness, dangerous for product roadmap

## Deep Dive

For all 63 insights from 49 guests, see `references/guest-insights.md`

## Related Skills

- Writing North Star Metrics
- Defining Product Vision
- Prioritizing Roadmap
- Setting OKRs & Goals
