---
name: conducting-interviews
description: Help users conduct effective hiring interviews. Use when someone is designing an interview loop, crafting interview questions, evaluating candidates in real-time, or building a structured interview process.
---

# Conducting Interviews

Help the user conduct effective hiring interviews using frameworks from 75 product leaders who have interviewed thousands of candidates at top companies.

## How to Help

When the user asks for help with conducting interviews:

1. **Understand the role** - Ask what position they're hiring for and what competencies matter most
2. **Design the structure** - Help create a consistent, behavioral-based interview process
3. **Craft the questions** - Suggest questions that reveal actual capability, not rehearsed answers
4. **Evaluate effectively** - Guide them on separating signal from noise and avoiding common biases

## Core Principles

### Use behavioral-based interviewing
Bill Carr: "We created a set of objective criteria that would be used and an interview methodology that would be used in every interview, which was the objective criteria would be our leadership principles, and the methodology would be behavioral based interviewing." Ask for specific past examples, not hypotheticals.

### Look past polished delivery
Jackie Bavaro: "Some people sounded really good because they'd say, 'Well, I'll tell you three things. Number one, number two, number three.' And then when I paid attention to my notes, I'd be like, 'Wait, their three ideas weren't actually good ideas.'" Evaluate substance over structure.

### Drill six levels deep
Joe Hudson (on Elon's approach): "You ask them six levels down. You improved sales. How did you do that, exactly? Well, we improved the pipeline. How'd you do that, exactly?" True expertise is revealed by drilling into the technical and process-oriented 'how'.

### Ask how they prepared
Austin Hay: "I like to ask people how they prepared for the interview. You're really asking how does the person think? How did they plan? How did they take things seriously or not?" Preparation style reveals planning depth and systems thinking.

### End with 'anything else?'
Christopher Lochhead: "At the very end you say, 'Hey, Susan, before we wrap, is there anything else?' And often, the most important thing for that person to communicate comes out then." The formal structure ending unlocks authenticity.

### Test failure and learning
Annie Pearl: "Talk me through your biggest product flop. What happened and what did you do about it?... The rawer the answer in terms of how bad it was and why, the better." Look for brutal honesty and genuine learning.

### Simulate working together
Noam Lovinsky: "I generally like interview questions that allow us to kind of do some work together... getting into the details and really watching each other exercise our craft is really important." Collaborative exercises reveal true capability.

### Use the PEARL framework
Jackie Bavaro: "Problem, Epiphany, Action, Result and Learning. What's the problem that you thought was worth solving? What's your epiphany? What's the insight that you had?" This structure ensures candidates demonstrate unique insight, not just activity.

## Questions to Help Users

- "What competencies are most critical for this specific role?"
- "Are you testing for skills that can be rehearsed or genuine capability?"
- "How will you distinguish between confident delivery and quality thinking?"
- "What signals true ownership versus 'we' statements that hide contribution?"
- "How are you calibrating across multiple interviewers?"

## Common Mistakes to Flag

- **Performative interviews** - Rewarding rehearsed STAR responses over actual capability
- **Not probing deeply enough** - Accepting surface answers without drilling into specifics
- **High-volume fatigue** - Scheduling back-to-back interviews that degrade judgment
- **Hypothetical questions** - Testing what candidates say they would do instead of what they have done
- **Skipping the 'failure' question** - Missing the chance to test self-awareness and growth mindset

## Deep Dive

For all 91 insights from 75 guests, see `references/guest-insights.md`

## Related Skills

- Writing Job Descriptions
- Evaluating Candidates
- Onboarding New Hires
- Building Team Culture
