# Conducting Interviews - All Guest Insights

*75 guests, 91 mentions*

---

## Annie Duke
*Annie Duke*

> "Can you explain to me what that means? In the abstract, what are the things that you're looking for in someone that you want to fill that role? And we can then excavate that, right? And make what is implicit... let's make that explicit. So we can make that explicit, we can turn it into a decision rubric, we can create a structured interview process out of that."

**Insight:** Improving hiring success requires transforming vague 'gut feelings' about candidates into structured rubrics and explicit criteria.

**Tactical advice:**
- Define the specific traits of a successful hire in the abstract before meeting candidates.
- Build a structured interview process based on these explicit criteria.

*Timestamp: 00:21:00*


## Annie Pearl
*Annie Pearl*

> "Talk me through your biggest product flop. What happened and what did you do about it?... I think the rawer the answer in terms of how bad it was and why, the better."

**Insight:** Asking about product failures reveals a candidate's honesty, self-awareness, and ability to learn from mistakes.

**Tactical advice:**
- Look for 'brutal honesty' and raw details about why a project failed.
- Evaluate how the candidate handled the aftermath of the failure.

*Timestamp: 00:59:15*


## Austin Hay
*Austin Hay*

> "I like to ask people how they prepared for the interview. This is not, I can't take credit for this. My wife told me about, gave me this idea and I loved it. I think it was a16z partner. But I love the question because when you ask, hey, how did you prepare? You're really asking how does the person think? How did they plan? How did they take things seriously or not? What did they read? What did they do?"

**Insight:** Asking how a candidate prepared reveals their planning process, seriousness, and systems-thinking capabilities.

**Tactical advice:**
- Ask candidates 'How did you prepare for this interview?' to see their research and planning depth.
- Look for complex, interesting answers that indicate a high-level thinker.

*Timestamp: 01:01:17*

---

> "Tell me about the most difficult or challenging thing you've overcome in the last year in your life. It doesn't have to be work related, it could be personal. And I think it's a great way to just reset the atmosphere, make people dig a little bit deeper into who they are and be more vulnerable."

**Insight:** Vulnerability-based questions help reset the interview atmosphere and reveal the candidate's true character and resilience.

**Tactical advice:**
- Ask about personal or professional challenges from the last year to gauge resilience.
- Use vulnerability to build a deeper connection and calm the candidate's nerves.

*Timestamp: 01:15:09*


## Barbra Gago
*Barbra Gago*

> "I like asking what someone's top 10 accomplishments are. They hate it because it's like, 'Oh, God. Ugh.' But it's really interesting to understand the level of quantitative versus qualitative in their accomplishments, what they value. And also if it's a, 'Oh, I ran a hundred miles or I have a great family,' whatever it is, it's really interesting to get to know somebody and also what they value."

**Insight:** Asking for a high volume of accomplishments reveals a candidate's balance between professional and personal values and their ability to think quantitatively.

**Tactical advice:**
- Ask candidates to list their top 10 accomplishments
- Evaluate the mix of quantitative and qualitative achievements
- Look for personal values reflected in their chosen accomplishments

*Timestamp: 53:17*


## Bill Carr
*Bill Carr*

> "We created a set of objective criteria that would be used and an interview methodology that would be used in every interview, which was the objective criteria would be our leadership principles, and the methodology would be behavioral based interviewing."

**Insight:** Standardized, behavioral-based interviewing mapped to core values is the most effective way to evaluate candidates.

**Tactical advice:**
- Use behavioral-based interviewing (asking for specific past examples)
- Map every interview question to a specific leadership principle or objective criterion

*Timestamp: 01:17:33*

---

> "I have to always clarify this, by this I mean not some award you won or some promotion you got, I mean something you built, or some product, some process, some organization you built... And I could basically then, once they get into that example, ask a lot of probing and follow-up questions and I could fill an entire hour interview just sticking with this one example."

**Insight:** Deep-diving into a single significant accomplishment using the STAR method reveals more than surface-level questions.

**Tactical advice:**
- Ask candidates about their most significant professional accomplishment
- Use the STAR method (Situation, Task, Action, Result) to probe deeply into one example for an entire hour

*Timestamp: 01:28:52*


## Boz
*Boz*

> "One of the most important things that I always ask people is what people who've worked with them would say are their greatest strengths and weaknesses."

**Insight:** Interviewing should focus on a candidate's self-awareness and how their 'superpowers' align with the team's needs.

**Tactical advice:**
- Ask candidates to contextualize their performance through the eyes of their teammates.
- Prioritize identifying a candidate's 'superpower' over just cataloging their weaknesses.

*Timestamp: 01:32:25*


## Camille Hearst
*Camille Hearst*

> "I like to ask people to tell me about something they're really proud of that they accomplished and take me through the process and talk to me about why they're proud of it. I find you can learn so much about a person's motivations, about their work ethic, about what they care about, what good looks like to them..."

**Insight:** Asking candidates to detail an accomplishment they are proud of reveals their internal standards, motivations, and definition of 'good.'

**Tactical advice:**
- Ask candidates to walk through the process of a proud accomplishment
- Listen for what the candidate defines as success to gauge cultural and role fit

*Timestamp: 00:58:58*


## Christian Idiodi
*Christian Idiodi*

> "I always give them a problem to solve. That is probably my favorite question... 'Hey Lenny, I have a friend. He's been legally deaf or hearing impaired his whole life, and he just got a new job that requires him to wake up significantly earlier than he normally does. And as you can imagine, traditional alarm clocks will not do it... Walk me through how you go about tackling this or solving this.'"

**Insight:** Assess product candidates by giving them a live, unconventional problem to solve to observe their thinking process, empathy, and collaborative instincts.

**Tactical advice:**
- Use live problem-solving instead of take-home assignments to see how candidates handle ambiguity.
- Look for 'intellectual curiosity' and whether the candidate asks clarifying questions about the user's context.
- Evaluate if the candidate instinctively suggests collaborating with design and engineering.

*Timestamp: 01:25:02*


## Christopher Lochhead
*Christopher Lochhead*

> "Before we wrap, is there anything else? ... the interesting thing about that question, you can spend three hours with somebody... And at the very end you say, 'Hey, Susan, before we wrap, is there anything else?' And often, Lenny, the most important thing for that person to communicate comes out then."

**Insight:** The most critical information often surfaces when the formal structure of a conversation ends.

**Tactical advice:**
- Always end interviews or important meetings with 'Is there anything else?'

*Timestamp: 01:40:18*

---

> "My first favorite is, so Lenny, are you legendary? ... I want to get a read on that person and how they respond to a purposely provocative question about themselves."

**Insight:** Provocative questions reveal a candidate's self-perception and ability to handle ambiguity.

**Tactical advice:**
- Ask 'Are you legendary?' to test a candidate's confidence and reaction to provocation.

*Timestamp: 01:42:01*


## Claire Hughes Johnson
*Claire Hughes Johnson*

> "I think interviewing is not a skill that comes naturally. People think it does. It does not... I really recommend... and my book has examples of rubrics, questions you can use. How do you really get at... Because it's hard to really evaluate someone in 30 minutes or 45 minutes."

**Insight:** Interviewing is a learned skill that requires structured tools like rubrics and specific questions to be effective.

**Tactical advice:**
- Train the team on interviewing techniques rather than assuming they know how to do it
- Use standardized rubrics to evaluate candidates consistently
- Prepare specific questions designed to uncover the capabilities needed for the role

*Timestamp: 00:25:49*


## Christopher Miller
*Christopher Miller*

> "I would say the other question I really like to ask is, if the people that you most recently worked with were in a room and you weren't there, how would they talk about you?"

**Insight:** Asking candidates to simulate peer feedback reveals their level of self-awareness and emotional intelligence (EQ).

**Tactical advice:**
- Use 'third-party perspective' questions to evaluate a candidate's self-awareness
- Look for honest, introspective answers that acknowledge 'rough edges' or areas for growth

*Timestamp: 01:21:12*


## Claire Vo
*Claire Vo*

> "I like to ask candidates how they would improve our business model. I think so many PMs come in with a point of view of the product... but don't actually understand the underlying mechanisms of how we make money."

**Insight:** Evaluate a candidate's seniority by testing their understanding of unit economics and business leverage points.

**Tactical advice:**
- Ask candidates to hypothesize about unit economics or COGS
- Look for candidates who can identify points of leverage along the entire value chain
- Test if the candidate has a mental model for how the business actually makes money

*Timestamp: 01:21:31*


## Crystal W
*Crystal W*

> "I actually look for that first principle bias. So I'll give people case studies of here's what we see, how do you know that this is true? And then I have them set up an experiment design. I want to see that they are sampling randomly."

**Insight:** Use experiment design case studies to evaluate a candidate's analytical rigor and research process.

**Tactical advice:**
- Provide take-home case studies (approx. 4 hours of work) rather than live sessions
- Ask candidates to explain their research process and how they used external resources to solve the problem

*Timestamp: 00:54:01*


## Dhanji R. Prasanna
*Dhanji R. Prasanna*

> "We're starting to do that now. So traditionally we would just use CoderPad or something like that to wipe boards or a problem... But now we're looking at can you use Vibe code to build something? How comfortable are you with these tools or how are you thinking about evolving with them as well?"

**Insight:** Modern interview loops should incorporate AI tools to reflect how work is actually performed.

**Tactical advice:**
- Allow candidates to use AI assistants or 'vibe coding' during technical assessments
- Focus the evaluation on the candidate's critical mindset and problem-understanding rather than just syntax

*Timestamp: 00:47:33*


## Deb Liu
*Deb Liu*

> "Show your passion around the product itself, around the use case, around the customer. Show who you are and why you care. I think sometimes people just say, 'I want a product job.' But you have to be able to fall in love with the problem. You have to fall in love, not with the product, but I said the problem, right? The use case. What problem are you trying to solve? And if you can do that, you can be a great product manager even without a lot of experience."

**Insight:** In PM interviews, demonstrating a deep obsession with the customer problem and the use case is more valuable than having a perfect technical playbook.

**Tactical advice:**
- Focus interview answers on the 'problem space' rather than just the solution
- Demonstrate passion for the specific customer cohort the company serves

*Timestamp: 00:10:41*


## Eeke de Milliano
*Eeke de Milliano*

> "To what do you attribute your success? And you can't say luck... I always kind of wanted to know, 'How self aware are you, and how curious are you?'"

**Insight:** Asking candidates to explain their success without citing luck reveals their level of self-awareness and first-principles thinking.

**Tactical advice:**
- Ask: 'To what do you attribute your success? (No luck allowed)'
- Look for evidence of reflection and understanding of their own impact

*Timestamp: 01:00:27*


## Eric Ries
*Eric Ries*

> "My favorite interview question of all time is to ask people to describe a best practice that they learned in their career... and then you'd be like, 'Great. Tell me a situation where that best practice would not be applicable.'"

**Insight:** Testing a candidate's understanding of the limitations of 'best practices' reveals their depth of experience and critical thinking.

**Tactical advice:**
- Ask for a specific best practice the candidate learned
- Ask for a scenario where that practice fails or is inappropriate

*Timestamp: 02:01:03*


## Ethan Evans
*Ethan Evans 2.0*

> "I think my favorite interview question is, 'Tell me about a time where you needed to disagree with your management, where you needed to stand up or fight for a position against higher leadership or people in power.'"

**Insight:** Testing for the ability to challenge authority is critical for hiring leaders who possess 'backbone' and can 'disagree and commit.'

**Tactical advice:**
- Use behavioral questions to probe for instances where a candidate stood their ground against leadership
- Look for candidates who can balance having a strong opinion with the ability to commit once a decision is made

*Timestamp: 01:15:03*


## Gibson Biddle
*Gibson Biddle*

> "If you're early in your career, ask if you could be on interview teams, even if you're not hiring, because then you're starting to practice something that's really important as you want to grow your career later, which is it's really hiring and recruiting people."

**Insight:** Early-career PMs should join interview loops to develop the critical leadership skill of talent evaluation.

**Tactical advice:**
- Volunteer for interview teams even when not the hiring manager
- Observe how senior leaders evaluate candidates for leadership and culture fit

*Timestamp: 49:19*


## Gina Gotthilf
*Gina Gotthilf*

> "Why do you want to work here is what I really like to ask because it tells me a lot... I want to know if this person knows what it is that we do, if they did a minimum level of research and if they connect with our mission because we're going to talk about mission a lot and I don't want them to gloss over it."

**Insight:** The 'Why here?' question filters for candidates who have done their research and possess genuine mission alignment.

**Tactical advice:**
- Ask 'Why do you want to work here?' to gauge research depth and mission connection.

*Timestamp: 01:25:57*

---

> "What are you world-class at and how do you know that you're at that? And the second part is almost more important... It tells me if people actually care about metrics, and I don't care what the metrics are, but just how do you know this to be true? It has to be more than like, 'Oh, because my boss loves me,' or 'Because my mom told me,'... I want to hear, 'I'm proud of having accomplished this.' And maybe if you have some numbers to show, that's also really important."

**Insight:** Asking for evidence of 'world-class' skill reveals whether a candidate is data-driven and results-oriented.

**Tactical advice:**
- Ask candidates what they are world-class at and require specific evidence or metrics to back it up.

*Timestamp: 01:26:41*


## Gokul Rajaram
*Gokul Rajaram*

> "What is the accomplishment, career accomplishment you're most proud of? Because it tells you how they measure their impact. Tells you a lot about what they care about, how they measure their impact."

**Insight:** Asking about a candidate's proudest accomplishment reveals their values, their definition of impact, and their level of team-orientation.

**Tactical advice:**
- Listen for whether the candidate emphasizes personal glory or team success
- Probe into how they define and measure the 'impact' of that accomplishment

*Timestamp: 01:00:56*


## Heidi Helfand
*Heidi Helfand*

> "I always like to ask people, 'Well, why do you want to join our company? What is it about working with us that would be exciting for you? Why our company as opposed to another one?'"

**Insight:** Assessing a candidate's specific motivation for joining your company reveals their level of research and alignment with the mission.

**Tactical advice:**
- Ask candidates why they chose your company over competitors
- Look for specific mentions of recent product launches or company news in their answer

*Timestamp: 01:02:27*


## Inbal S
*Inbal S*

> "What is the most innovative thing you have done and why do you think it's innovative? And it's really interesting that there are some people that think they need to answer about the biggest invention that they've done, and there are some people that are very vulnerable and they talk about something very personal that they have innovated. It shows a lot of their character."

**Insight:** Asking about innovation reveals a candidate's vulnerability and their personal definition of creativity.

**Tactical advice:**
- Ask candidates to define why they consider a specific action innovative

*Timestamp: 47:22*

---

> "Give me an example in a time where you had a disagreement with your manager... what did you do about it and how did you go? Because it showcase a lot about your character and are you willing to stand your ground and push up when you need to?"

**Insight:** Conflict stories reveal a candidate's communication skills and their ability to manage up effectively.

**Tactical advice:**
- Look for evidence of 'standing your ground' and 'pushing up' during disagreements

*Timestamp: 47:22*


## Jackie Bavaro
*Jackie Bavaro*

> "And immediately I noticed there was this real difference in how people would answer the questions. And some people didn't seem to understand what the question was trying to get at. And some people sounded really good because they'd say, 'Well, I'll tell you three things. Number one, number two, number three.' And then when I paid attention to my notes, I'd be like, 'Wait, their three ideas weren't actually good ideas. They just sounded like they knew what they were doing.'"

**Insight:** Interviewers should look past structured communication styles to evaluate the actual quality of the candidate's ideas.

**Tactical advice:**
- Pay close attention to the substance of 'numbered' lists in answers
- Distinguish between confident delivery and high-quality product thinking

*Timestamp: 05:08*

---

> "That's how I feel about this interviewing. Is that the reason that some people don't do as well as they could on interviews is just because a lot of these interview questions are trick questions. When they say, 'Oh, how would you design a bathroom?' I used to think that meant, 'What do you want in a bathroom?' And that's not what it means at all. It means 'Who is the best customer for a bathroom? What would they want?' But if you haven't been trained in this, you wouldn't know."

**Insight:** Product design interview questions are often tests of user-centric methodology rather than personal preference.

**Tactical advice:**
- Start design questions by identifying the target customer
- Focus on user needs rather than personal feature requests

*Timestamp: 07:13*

---

> "I love to ask, 'Tell me about a recent project that you're proud of.' I feel like a lot of interviews don't give people enough chance to shine, to talk about something that they did really, really well and hear about what made it so good and what are they proud of, and how did they achieve those amazing results."

**Insight:** Behavioral questions should allow candidates to showcase their peak performance and specific contributions.

**Tactical advice:**
- Ask candidates to discuss projects they are genuinely proud of
- Look for the 'why' behind their pride to understand their values

*Timestamp: 46:26*

---

> "I have a framework for this. The pearl framework for answering questions like this is problem, epiphany, action, result and learning. It's a little bit like the star framework, but I want it all like, 'What's the problem that you thought was worth solving, a problem that I think is big enough? What's your epiphany? What's the insight that you had? Do you notice something that nobody else did and how valuable was it?'"

**Insight:** The PEARL framework (Problem, Epiphany, Action, Result, Learning) is a superior way to structure behavioral interview answers.

**Tactical advice:**
- Highlight the unique insight or 'epiphany' that drove the project
- Ensure every story concludes with a specific growth or learning point

*Timestamp: 47:15*


## Jason Feifer
*Jason Feifer*

> "My favorite strategy for interviewing people is to throw a theory at them... I'll make a connection in my head and I'll say, 'I want to run a theory by you. Do you think that the reason why you are really interested in this or you made that decision is actually because of this other thing that you told me a little bit about?'... It forces people to think in real time in front of you."

**Insight:** Using 'theory-based' questions encourages interviewees to move past rehearsed talking points and provide more authentic, real-time insights.

**Tactical advice:**
- Practice active listening to connect disparate points made by the interviewee into a cohesive theory.
- Ask the 'thing they haven't been asked' to break through the polish of experienced speakers.

*Timestamp: 01:30:19*


## Jason M Lemkin
*Jason M Lemkin*

> "What do you want to do your first 30 days? ... In B2B, if I don't hear from the VP of sales or the VP of product that I'm going to go meet customers, out, I'm out."

**Insight:** Use the 'first 14 days' question to identify leaders who are customer-obsessed rather than process-obsessed.

**Tactical advice:**
- Ask candidates what they plan to do in their first two weeks
- Filter for candidates who prioritize joining customer calls immediately

*Timestamp: 00:30:21*

---

> "Give them time. And I don't like to judge too harshly, but whether it's the first interview or the second, they got to sell you this pen. But it's not 'Sell me this pen,' it's 'Sell me this app.'"

**Insight:** Require sales candidates to perform a live demo of your product to prove they have researched the value proposition and can handle the 'middle' of the sale.

**Tactical advice:**
- Have candidates perform a demo of your actual product
- Check if they have watched your explainer videos or webinars beforehand

*Timestamp: 00:35:30*


## Jeremy Henrickson
*Jeremy Henrickson*

> "My favorite one is 'What questions do you have for me?' by far... it is again indicative of these things that people have thought through or not thought through or the depth that they're thinking or their interest in engagement in the role."

**Insight:** The quality and insightfulness of a candidate's questions are often the strongest signal of their potential and engagement.

**Tactical advice:**
- Ask 'What questions do you have for me?' early in the interview process to gauge preparation
- Look for questions that push the interviewer to think or reveal a deep understanding of the business

*Timestamp: 00:57:01*


## Jessica Livingston
*Jessica Livingston*

> "I would be in charge of the stopwatch that would time us. And I'd say, 'Okay, our time's up.' ... I would observe. Paul, Robert and Trevor, my co-founders would be asking them all sorts of questions about their product and their technology... I would usually remain pretty silent. And so I don't think people even really noticed me. But I would be just watching them and sort of trying to observe as much as I could"

**Insight:** Having a dedicated observer who is not leading the technical questioning allows for better detection of social and behavioral cues.

**Tactical advice:**
- Assign one interviewer to focus solely on observing dynamics and non-verbal cues
- Use a strict timer to keep interviews focused and efficient

*Timestamp: 00:10:06*

---

> "The 10 minutes is kind of as long as you need, in most cases. Because we found when they were longer, like 20 minutes, you'd know in 10 minutes and be twiddling your thumbs trying to get through the interview for the next 10 minutes. So we kept them short so we could interview more people."

**Insight:** Short, high-intensity interviews are often sufficient to make a high-level judgment on talent and fit.

**Tactical advice:**
- Keep initial screening interviews to 10 minutes to maximize volume and maintain focus

*Timestamp: 00:46:48*


## Joe Hudson
*Joe Hudson*

> "One of the things that Elon Musk has said that I found it very valuable in my time, is that if you really want to interview somebody and they claim that they've done something, you ask them six levels down. You improved sales. How did you do that, exactly? Well, we improved the pipeline. How'd you do that, exactly? Oh, well, we made the pipeline more measurable by having things that could be. How did you know? What were the seven stages of the pipeline and what made you pick them? You go six levels down and you can really understand if somebody was the person who solved the problem or if they're the person who is claiming that they solved the problem."

**Insight:** True expertise and ownership are revealed by drilling deep into the technical and process-oriented 'how' of a candidate's past achievements.

**Tactical advice:**
- Ask 'How did you do that exactly?' repeatedly to reach six levels of depth in a candidate's explanation.

*Timestamp: 00:53:06*


## Jiaona Zhang
*Jiaona Zhang*

> "I do like to do behavioral questions... Good answers are people who put structure and a way forward through the ambiguity. That's what you look for. You want your PM to not just be like, 'Oh no, we're swimming in ambiguity,' but actually put a path forward."

**Insight:** Use behavioral questions to evaluate how candidates navigate ambiguity and whether they can impose structure on complex problems.

**Tactical advice:**
- Ask behavioral questions focused on past ambiguous situations
- Look for candidates who seek input and iterate on their path
- Evaluate the candidate's ability to create a structured way forward

*Timestamp: 01:00:53*


## John Cutler
*John Cutler*

> "Imagine I'm interviewing a person you worked with. Now answer in there, tell me about of the same situation... what was that story from the perspective of one of the people you worked with? I think it can show some really interesting self awareness."

**Insight:** Asking candidates to narrate a situation from a colleague's perspective is a powerful way to gauge their self-awareness and empathy.

**Tactical advice:**
- Ask candidates: 'If I interviewed your teammate about this project, how would they describe your role and the challenges you faced?'

*Timestamp: 01:37:55*


## Jonathan Lowenhar
*Jonathan Lowenhar*

> "We think that there is a culture interview, there is a functional interview, and there is a technical interview, but they're designed to get at these notions of have they actually done this kind of work before? Have they been pulled or pushed in their career and are they your kind of human?"

**Insight:** Structure the interview loop into three distinct stages: culture, functional, and technical.

**Tactical advice:**
- Use the culture interview to ensure the candidate represents the company's core values.
- Use functional and technical interviews to verify they have successfully performed the required work previously.

*Timestamp: 00:52:13*

---

> "Just to ask the simple question even in the cover letter, of your last ex-bosses, how many would get on the phone and say, you're amazing? If there's any equivocation in the answer, great, move on."

**Insight:** A candidate's confidence in their former managers' references is a powerful proxy for performance.

**Tactical advice:**
- Ask candidates early in the process how many former bosses would give them a glowing reference.
- Filter out candidates who hesitate or provide equivocal answers regarding past manager feedback.

*Timestamp: 00:55:11*


## Judd Antin
*Judd Antin*

> "Think of a topic that you had to explain lately that was the most complex, and then explain it to me like I'm five... I want to see if somebody can break a complex problem down in a really simple way, and give me an intuition for it in a short amount of time."

**Insight:** The ability to simplify complex concepts is a critical trait for high-level leadership and effective communication.

**Tactical advice:**
- Ask candidates to explain a complex topic to a five-year-old to test for clarity and communication skills.

*Timestamp: 01:10:19*


## Kayvon Beykpour
*Kayvon Beykpour*

> "The thing that I find is both very illustrative and helpful is just asking people to talk about something they worked on that failed and talk about something they built that succeeded as well. But I think you just learn a lot about self-reflection and their passions."

**Insight:** Asking about failure reveals a candidate's capacity for self-reflection, risk-taking, and learning.

**Tactical advice:**
- Ask candidates to detail a project they cared about that failed and what they learned from it.

*Timestamp: 01:23:58*


## Karri Saarinen
*Karri Saarinen*

> "I often think ask people that... Ask about their projects and I try to go deeper. It's like why was this decision made? Why do you think the decision was made? And I might ask, 'Do you think it was the right decision or did you agree on it?'"

**Insight:** Probing the 'why' behind past decisions reveals a candidate's product sensibility and critical thinking skills.

**Tactical advice:**
- Ask candidates to critique decisions made at their previous companies to test for independent judgment.
- Look for candidates who can articulate the rationale behind their work beyond just 'I was told to build it.'

*Timestamp: 01:06:30*


## Kim Scott
*Kim Scott*

> "The question that I like to ask is just tell me the story of your career... I always learn a lot about people from how they tell the story of their life and their career... I learn how the person approaches setbacks from a story... I learn whether a person is able to identify mistakes they made."

**Insight:** Asking for a career narrative reveals a candidate's self-awareness, resilience, and actual contributions.

**Tactical advice:**
- Ask 'Tell me the story of your career' as an open-ended prompt.
- Double-click on specific accomplishments to verify the candidate's actual role and depth of knowledge.
- Look for the candidate's ability to admit and learn from past mistakes.

*Timestamp: 01:19:22*


## Kunal Shah
*Kunal Shah*

> "I like to ask a hypothetical second order thinking question. For example, if everybody who has taken a COVID vaccine dies tonight, what happens in 12 months from now? Can you explain the world- from what happens to money, what happens to law? What happens to countries? What happens to the military? What happens to the stock market? What happens to the order of things?"

**Insight:** Use extreme hypothetical scenarios to evaluate a candidate's ability to predict downstream consequences and leaps in logic.

**Tactical advice:**
- Ask 'what if' questions about absurd or extreme scenarios to test second-order thinking.
- Evaluate the range of domains the candidate considers (e.g., law, finance, social order) in their response.
- Look for the ability to judge the 'butterfly effect' of an event.

*Timestamp: 01:12:11*


## Kristen Berman
*Kristen Berman*

> "interviews, actually we know, don't predict job performance. So, very little to no evidence would say interviews will predict how I perform on the job... We use skill assessments and trials as ways to predict job performance, but interviews are good at predicting affinity and culture fit."

**Insight:** Traditional interviews are poor predictors of job performance and should be used primarily for assessing culture fit, while skill assessments handle performance prediction.

**Tactical advice:**
- Use skill assessments and trials for performance evaluation.
- Use interviews primarily for affinity and culture fit.

*Timestamp: 54:19*

---

> "one of my favorite questions is just, what is a personality trait that defines you? So, really, one that you are filled with strength, but that also can be seen as something you're working to improve."

**Insight:** Asking about a defining personality trait that is both a strength and a weakness reveals a candidate's self-awareness and core character.

**Tactical advice:**
- Ask candidates for a personality trait that is both a strength and a weakness.

*Timestamp: 54:43*


## Lane Shackleton
*Lane Shackleton*

> "One is teach me something that I don't already know. I think it's just an awesome way of seeing if someone's going to lean in and really figure out what you don't know and then how passionate they are about pitching what they do know I think is really fun."

**Insight:** Ask candidates to teach you something new to evaluate their communication range and passion.

**Tactical advice:**
- Ask the candidate to explain a topic to a grandparent and then to a technical expert to test their communication range.

*Timestamp: 01:23:22*


## Laura Modi
*Laura Modi*

> "Teach me something. Actually, we just talked about that today. Teach me something. Yeah. I love getting someone to, not related to work, not related to their job, something in your life, something you find interesting, just teach me about it."

**Insight:** Asking a candidate to teach you something reveals their communication skills and passion.

**Tactical advice:**
- Ask candidates to teach you a non-work-related topic during the interview.
- Evaluate their ability to simplify complex foundations (e.g., cooking a steak or Latin) as an indicator of their explanatory power.

*Timestamp: 00:55:57*


## Luc Levesque
*Luc Levesque*

> "Teach me something about growth that I don't already know. Because... it really gives you a sense of what this person thinks is the top of the stack in terms of the smartest thing they know. Whether you know it or not is irrelevant. But sometimes you actually do end up learning some stuff."

**Insight:** Asking a candidate to teach you something reveals the depth of their expertise and their ability to communicate complex concepts.

**Tactical advice:**
- Use the 'Teach me something' prompt to gauge a candidate's mastery of their craft
- Evaluate the uniqueness and depth of the insight the candidate chooses to share

*Timestamp: 01:14:06*


## Marily Nika
*Marily Nika*

> "I love to ask people, how would you explain a database to a three year old? ... it's so important to be able to explain things in a simple ring and have the storytelling to convince a kid and really explain technical terms to non-technical people."

**Insight:** A key PM skill is the ability to simplify complex technical concepts for non-technical stakeholders.

**Tactical advice:**
- Use the 'explain to a three-year-old' framework to test a candidate's communication and storytelling skills.
- Evaluate if a PM can translate technical jargon into simple, relatable analogies.

*Timestamp: 00:45:57*


## Matt MacInnis
*Matt MacInnis*

> "Every product person at every seniority level is given the same case study. And the case study is extraordinarily difficult. It requires you to think about many, many dimensions simultaneously, to think about data propagation issues. It gets quite technical."

**Insight:** Using a single, extremely difficult case study for all levels allows you to see the ceiling of a candidate's ability.

**Tactical advice:**
- Give the same complex prompt to everyone from junior PMs to VPs.
- Evaluate how many 'corners' they can see around and how they handle new, conflicting information.

*Timestamp: 00:37:37*


## Melissa Perri + Denise Tilles
*Melissa Perri + Denise Tilles*

> "When was the last time you changed your mind about something really important and why?"

**Insight:** This question assesses a candidate's learning mindset, self-awareness, and ability to evolve based on new information.

**Tactical advice:**
- Ask candidates about a time they changed their mind to evaluate intellectual humility

*Timestamp: 01:11:49*

---

> "Tell me about a time that you failed and what happened."

**Insight:** The goal of the failure question is to see if the candidate can objectively analyze a mistake and extract a lesson without over-spinning it into a positive.

**Tactical advice:**
- Look for candidates who can describe a failure and the specific lesson learned without excessive 'spinning'

*Timestamp: 01:12:06*


## Meltem Kuran
*Meltem Kuran*

> "What would your siblings say about you? It's very telling. If they have siblings, if they don't, I will say, what will your parents say about you? But it's very telling what you think other people think of you... I look for sincerity and self-awareness."

**Insight:** Asking about a candidate's reputation with family reveals their level of self-awareness and humility.

**Tactical advice:**
- Use the 'sibling question' to look for honest, non-bullshit answers that show the candidate can see themselves objectively.

*Timestamp: 01:07:28*


## Melissa Tan
*Melissa Tan*

> "I always have a presentation component to the interview process that checks for prepared thinking communication. And I recommend a prep call between the two of us before that presentation. And I actually will give feedback on the presentation. And what this gives me signal is what is it actually going to be like to work together?"

**Insight:** Adding a preparation call to the presentation stage allows you to test how a candidate receives and incorporates feedback in a real-world scenario.

**Tactical advice:**
- Include a presentation component in the final round
- Schedule a 1:1 prep call with the candidate before their presentation
- Provide specific feedback or data during the prep call to see how they adapt their work

*Timestamp: 00:44:12*

---

> "Usually hiring manager screen, and I actually do the live problem solving at this screen. I actually think it weeds out the most people... I sometimes would say, 'Hey, do you have your laptop? Can you pull up our pricing page? Curious to get your thoughts, what would you want to change?'"

**Insight:** Conducting live problem-solving on the company's actual product during the initial screen quickly identifies candidates with strong critical thinking skills.

**Tactical advice:**
- Ask candidates to pull up the live product during the interview
- Ask 'why' repeatedly to uncover their underlying mental models
- Focus on how they approach the problem rather than just the final answer

*Timestamp: 00:45:05*


## Nabeel S. Qureshi
*Nabeel S. Qureshi*

> "For the longest time, they had... a founder had to interview you in order for you to receive an offer... With Stephen, it would be, you'd be chatting about philosophy for an hour and a half and it would very much just be like he would pick a topic out of thin air. It was impossible to prepare for, and then he would just go very, very deep and try and test the limits of your understanding."

**Insight:** Founder-led 'vibe checks' that test the limits of a candidate's reasoning and intellectual depth are more effective than standard prep-able questions.

**Tactical advice:**
- Involve founders in the final stage to ensure cultural and intellectual alignment.
- Use deep-dive discussions on non-work topics (like philosophy) to test how a candidate thinks under pressure.

*Timestamp: 00:09:33*


## Nilan Peiris
*Nilan Peiris*

> "what is it that most frustrates you about... instead of why you're leaving, what frustrates you the most about where you're working right now? ... what's more interesting is they've been unable to fix it. And so, in asking this question, and probing, you kind of get quite good at getting a sense of what is their limit, what's the thing they found, and what did they get stuck with?"

**Insight:** Asking about current frustrations reveals a candidate's professional 'limit' and their ability to navigate and fix broken systems.

**Tactical advice:**
- Ask candidates what frustrates them most about their current company to see what they are 'running away from'
- Probe into why the candidate was unable to fix the problem they identified
- Evaluate if the candidate's frustrations will repeat in your company's environment

*Timestamp: 01:11:28*


## Noam Lovinsky
*Noam Lovinsky*

> "I generally like interview questions that allow us to kind of do some work together... 'Given where technology is at, if we were to rebuild email, how might we do that?' I just feel like getting into it and getting into the details and really watching each other exercise our craft I think is really important."

**Insight:** Use collaborative problem-solving exercises rather than behavioral questions to evaluate a candidate's actual product craft and collaboration style.

**Tactical advice:**
- Use open-ended 'rebuild' prompts to see how candidates think about technology shifts
- Focus on working through a product problem together to assess real-time collaboration

*Timestamp: 01:05:32*


## Paul Millerd
*Paul Millerd*

> "I'm always curious about, what makes you come alive? I want to work with people that are alive, and connected, and inspired... I'm always looking for that energy first and skills second."

**Insight:** For creative or unconventional roles, a candidate's intrinsic energy and alignment with the work are more important than their technical resume.

**Tactical advice:**
- Ask candidates 'What makes you come alive?' to gauge intrinsic motivation
- Prioritize 'energy' and 'aliveness' over a traditional skills checklist

*Timestamp: 00:57:25*


## Richard Rumelt
*Richard Rumelt*

> "I like to ask people about, what have you done that was hard that you're proud of? What have you done that was difficult? And what was it and why was it difficult and how did you get it done?"

**Insight:** Asking about difficult past achievements reveals a candidate's problem-solving ability and persistence.

**Tactical advice:**
- Use the interview question: 'What have you done that was hard that you're proud of?' to evaluate strategic thinking.

*Timestamp: 01:37:14*


## Ramesh Johari
*Ramesh Johari*

> "I like to ask people is, 'Okay, now imagine everything works out, all the challenges you're facing work out, all your plans work out, everything hits the top end of your vision for what this could be. What do you imagine is the impact of having done that? Who's being impacted by that? Why is that a big deal that happened?'"

**Insight:** Asking candidates to visualize total success reveals their long-term strategic thinking and their understanding of the broader impact of their work.

**Tactical advice:**
- Use the 'everything works out' prompt to test a candidate's vision and ability to see beyond immediate tasks.

*Timestamp: 01:15:00*


## Ryan J. Salva
*Ryan J. Salva*

> "I ask them to teach me something new in one minute. Usually I'll pull up my phone and I'll start the timer. I'll give them a second to think about it and start the timer. They're graded on three different criteria. One is completeness. Did they actually finish the lesson inside of one minute? Two is complexity. ... And then last is really clarity. ... Did they convey the idea fully and wholly?"

**Insight:** A 'teach me something in one minute' test effectively evaluates a candidate's communication clarity, ability to synthesize complex info, and time management.

**Tactical advice:**
- Use a one-minute teaching exercise to test communication skills
- Grade candidates on completeness, complexity of the topic, and clarity of explanation

*Timestamp: 01:00:55*


## Sachin Monga
*Sachin Monga*

> "I have found that there's not one question that will get me the signal I actually want given how diverse the candidate's experiences might be... we just need people who can run through walls to accomplish big goals. Maybe grit and endurance in some ways and drive are the words I would throw out there."

**Insight:** Tailor interview questions to the candidate's specific background to accurately assess 'grit' and the ability to execute in high-growth environments.

**Tactical advice:**
- Focus on identifying 'grit' and 'drive' rather than relying on standardized questions.
- Adjust the interview context based on whether the candidate is coming from a large corporation or a startup.

*Timestamp: 00:58:16*


## Shishir Mehrotra
*Shishir Mehrotra*

> "A group of scientists have invented a teleportation device... they've decided that they will answer only two of your questions and after that they expect a plan. What two questions do you ask? ...all of a sudden the sharp product managers, engineers, so basically every role, they very quickly find what are the one or two eigenquestions on this topic."

**Insight:** Using abstract, low-stakes scenarios (like a teleportation device) can reveal a candidate's ability to identify core strategic questions.

**Tactical advice:**
- Use 'neutral court' questions (abstract scenarios) to test first-principles thinking.
- Limit the number of questions a candidate can ask to force them to prioritize the most important information.

*Timestamp: 00:59:40*

---

> "At the beginning of the loop, the person presents... about half the time is spent on them presenting whatever they want. They can talk about themselves. They can teach us something and then another half is we've given them a prompt... I want you to upper bound us. I want you to tell us what's really amazing here."

**Insight:** Presentations allow candidates to 'upper bound' their potential by showing their best work in an 'away court' (their own territory).

**Tactical advice:**
- Include a presentation component in the interview loop where the candidate chooses the topic.
- Balance interviews between 'home court' (your company's problems), 'away court' (the candidate's past work), and 'neutral court' (abstract puzzles).

*Timestamp: 01:21:58*


## Tanguy Crusson
*Tanguy Crusson*

> "When people describe an experience, you ask them the name of the person that they worked with back then. And you ask them, 'So when I call this person after our call, what do you think they're going to say about that?'... people are unable to project and invent on the spot something from the lens of another person talking about them."

**Insight:** Use the 'threat of a reference check' to force candidates to provide more authentic, less scripted answers.

**Tactical advice:**
- Ask candidates what their specific former manager (by name) would say about their performance

*Timestamp: 01:44:32*


## Tom Conrad
*Tom Conrad*

> "I tell people that almost every interview question should start with, 'Tell me about a time in your career when...' to give them permission or to set their expectation that I'm asking them to tell me about something they've actually done that is relevant to the topic that I'm probing."

**Insight:** Behavioral interviewing grounded in past actions is more effective than asking candidates to speculate on hypothetical problems.

**Tactical advice:**
- Use the 'Tell me about a time...' prompt to elicit specific examples of past behavior
- Avoid asking candidates to solve your current business problems in a vacuum

*Timestamp: 01:33:59*

---

> "I ask almost everybody, 'Imagine that you had a really great day at work. What was it that you did on that day?' Because what I'm trying to figure out is left to their own devices, what do they go to naturally because it rewards them?"

**Insight:** Understanding what naturally energizes a candidate helps identify their 'highest and best use' within the organization.

**Tactical advice:**
- Ask candidates to describe their ideal 'great day' to uncover intrinsic motivations
- Align role responsibilities with the tasks that provide the candidate a natural reward mechanism

*Timestamp: 01:34:15*


## Upasna Gautam
*Upasna Gautam*

> "What's something that would not exist without your initiative?"

**Insight:** This question helps identify candidates with high agency who can drive impact without explicit direction.

**Tactical advice:**
- Look for specific, tangible examples of ownership in the candidate's response

*Timestamp: 53:21*


## Varun Mohan
*Varun Mohan*

> "We are okay with people using the tools because I think one of the worst things is like, if someone comes here and doesn't like using these tools... we do want to see how they think on their feet and hopefully they're not just taking what we're saying, putting it in a voice translator and sticking it into ChatGPT and getting the answer out."

**Insight:** Modern technical interviews should allow AI tools but focus on evaluating the candidate's first-principles thinking and problem-solving process.

**Tactical advice:**
- Allow candidates to use AI coding assistants during interviews
- Include whiteboard or live discussion components to verify the candidate's underlying logic

*Timestamp: 00:33:25*


## Vikrama Dhiman
*Vikrama Dhiman*

> "I'll typically pick up a product that they use most often and then I will be like, 'Okay, what if this product were to do this? Then what do you think, it makes sense? Don't think it makes sense? What about this? Okay, how would it evolve in six months? What would happen in 12 months and so on?'"

**Insight:** Use live brainstorming on familiar products to evaluate a candidate's ability to reason through goals, users, and trade-offs.

**Tactical advice:**
- Ask candidates to brainstorm choices for a product they use frequently
- Evaluate if the candidate is obsessed with the feature or the value it enables
- Check if the candidate can abstract out to overall goals and user segments

*Timestamp: 01:04:13*


## Vijay
*Vijay*

> "One of the questions I ask in the behavioral interview at the start is, walk me through the story of you from college to now... interesting to see where people spend most of their time talking and where they don't, and also how they describe the other people on that journey."

**Insight:** Use a chronological 'story of you' question to evaluate a candidate's self-awareness, priorities, and how they view collaborators.

**Tactical advice:**
- Ask candidates to walk through their career journey from college to the present
- Observe which roles they emphasize and how they characterize former colleagues

*Timestamp: 43:43*


## Yuhki Yamashata
*Yuhki Yamashata*

> "one of my favorite interview questions is asking, 'describe to me a time when you're part of controversial product decision, and what did you do,' and all those things. And I think it's really revealing because if they can set up this conflict and understand why this problem was really important and represent both sides in such that you can understand why that conflict existed in the first place, then they can do it in this even-keeled way, where you realize that they can take on these different perspectives."

**Insight:** Use questions about controversial decisions to evaluate a candidate's ability to synthesize multiple perspectives and tell a compelling narrative.

**Tactical advice:**
- Ask candidates to describe a controversial product decision
- Evaluate if the candidate can represent both sides of a conflict fairly
- Test for 'imagination' by asking candidates to predict the outcome of a hypothetical experiment

*Timestamp: 00:49:17*


## Zoelle Egner
*Zoelle Egner*

> "I like to ask anyone who's going to be in a customer facing role... to solve an unfamiliar problem using Zapier... I basically lay out for them a problem that I, as the customer want to solve, and have them build it for me live."

**Insight:** Live problem-solving with unfamiliar tools reveals how a candidate handles pressure and learns on the fly.

**Tactical advice:**
- Give candidates a real-world customer problem to solve during the interview
- Allow candidates to use the internet to research solutions live
- Observe the candidate's reaction to unfamiliar situations and their learning process

*Timestamp: 01:09:29*


## Brendan Foody
*Brendan Foody*

> "We'll give people interviews where we say, 'Use whatever tools are available to build a website and let's see what product you're able to build in an hour.'"

**Insight:** Modern interviews should assess a candidate's ability to leverage AI tools to achieve outcomes rather than testing manual skills that are now automated.

**Tactical advice:**
- Allow candidates to use AI tools like ChatGPT or Cursor during technical assessments
- Focus the interview on the quality of the product built within a short time frame

*Timestamp: 00:21:16*


## Andrew Wilkinson
*Andrew Wilkinson*

> "To a man with a hammer, everything looks like a nail... I want to be nodding along. I want to go, that's exactly what I would do or that's way smarter than my idea. And then I just leave them alone because I've found that anytime I try and pull them in a certain direction or coach them or whatever, it just doesn't work."

**Insight:** Interviewing for senior roles should focus on finding natural alignment between the candidate's 'default' strategy and the business's actual needs.

**Tactical advice:**
- Identify the candidate's 'hammer' (their go-to strategy, like enterprise sales) and ensure it matches the business's 'nail.'
- Listen for whether the candidate's proposed plan makes you 'nod along' or feel they are smarter than you.
- Screen for 'bad actors' like narcissists or difficult personalities who create 'people problems.'

*Timestamp: 00:39:39*


## Ebi Atawodi
*Ebi Atawodi*

> "Two questions. If they're a people manager, what is your leadership philosophy? The amount of leaders who have never thought about that is quite scary. And if you're just pure product chops, tell me your favorite product, product you're most passionate about, and why."

**Insight:** Interviewing for product roles should focus on a candidate's ability to articulate a clear philosophy and their natural storytelling/empathy for products.

**Tactical advice:**
- Ask people managers for their specific leadership philosophy
- Ask product candidates to describe a product they are passionate about to evaluate their storytelling and problem-solving sense

*Timestamp: 01:33:06*


## Farhan Thawar
*Farhan Thawar*

> "We have this interview step called the life story where we try to figure out if, are all the experiences you've had up until now actually going to be... Does it show that you are a curious person with range? ... Your resume should be a why, like why did you go from this company to this?"

**Insight:** Use 'life story' interviews to uncover the motivations behind career transitions and assess a candidate's curiosity and range.

**Tactical advice:**
- Ask candidates 'why' they made specific moves between companies rather than just 'what' they did
- Look for evidence of 'range' and generalist problem-solving abilities in past experiences

*Timestamp: 01:07:27*


## Paige Costello
*Paige Costello*

> "I like to ask, 'Tell me about a time something went wrong. What was it? What did you do about it? Yada, yada.'... evaluating people's mindset, and the way they talk about it, and the way they relate to evaluating the situation."

**Insight:** Use behavioral questions about failure to assess a candidate's mindset, self-awareness, and problem-solving approach under pressure.

**Tactical advice:**
- Ask candidates to describe a specific product or team failure.
- Listen for how they evaluate the situation and what actions they took to rectify it.

*Timestamp: 00:56:49*


## Sanchan Saxena
*Sanchan Saxena*

> "We actually gave you a work challenge. We said, 'This is the problem you're facing. How are you going to solve it?' ... We want to see the depth of thinking. They don't know the right answer because they don't have the right data. That's okay. But they at least need to show us how they approach the problem."

**Insight:** Use real-world work challenges instead of standard presentations to see a candidate's true problem-solving depth.

**Tactical advice:**
- Present a current, unsolved company problem as an interview prompt
- Ask candidates to specify the exact role they played in past projects versus what the team did
- Focus on the 'why' behind career choices rather than just the 'what'

*Timestamp: 00:55:08*


## Scott Belsky
*Scott Belsky*

> "I like asking about something people have learned about themselves that reveal the limitation in how they work. It's a way to test introspection... I also like the question, like, 'Do you consider yourself lucky?'"

**Insight:** Effective interview questions should test for a candidate's introspection, self-awareness of limitations, and humility regarding their success.

**Tactical advice:**
- Ask candidates what they have learned about their own limitations to gauge introspection
- Ask 'Do you consider yourself lucky?' to assess a candidate's security and perspective on their career

*Timestamp: 00:58:05*


## Will Larson
*Will Larson*

> "When I was at Uber, some days I would do six interviews back to back. I would just be in a conference room and at some point you can't even remember who you're talking to because you talk to so many people, one after another after another. You just have some scrambled notes you're trying to decode afterwards."

**Insight:** High-volume interviewing leads to cognitive fatigue and poor data retention, making it difficult to evaluate candidates accurately.

**Tactical advice:**
- Avoid scheduling more than a few interviews back-to-back to maintain focus
- Take detailed notes during the session to avoid 'scrambled' recollections later

*Timestamp: 00:05:02*


## Casey Winters
*Casey Winters_*

> "The whole thing's gotten so performative. It's like interviewing is handing out Oscars..."

**Insight:** PM interviews reward rehearsed answers over actual job capability.

**Tactical advice:**
- Give real scenarios
- Skip practiced STAR responses

*Timestamp: 00:22:14*


## David Singleton
*David Singleton*

> "We put everyone through a very consistent process... nothing is a trick question."

**Insight:** Use structured loops with exercises that simulate real work.

**Tactical advice:**
- Create consistent interview loops
- Allow normal resources

*Timestamp: 00:14:32*


## Jag Duggal
*Jag Duggal*

> "Call 10 customers. Pick up the phone yourself. Don't ask a researcher."

**Insight:** Direct calls to 10 customers yield faster, richer insights than formal surveys.

**Tactical advice:**
- Call customers directly
- Listen for tone and emotion

*Timestamp: 00:26:27*


## Sam Schillace
*Sam Schillace*

> "How many zeros at the end of 100 factorial? I want to see how people react to impossible problems."

**Insight:** Best questions reveal how candidates react to seemingly impossible problems.

**Tactical advice:**
- Design questions that seem impossible
- Watch for engagement vs retreat

*Timestamp: 01:19:32*


