# Conducting User Interviews - All Guest Insights

*43 guests, 64 mentions*

---

## Adriel Frederick
*Adriel Frederick*

> "Don't use the data alone to figure out who the marginal user is. It'll give you a clue where they are and what might be wrong, will give you some hints. It's not going to give you the answer. You have to go watch them to find the answer."

**Insight:** Observational research reveals 'orthogonal' problems that are invisible in data funnels.

**Tactical advice:**
- Watch users use the product in person to identify where their mental models (e.g., using nicknames vs. legal names) conflict with product design.
- Use data to identify *where* to look, but use interviews and observation to find the *why*.

*Timestamp: 00:51:30*


## Bangaly Kaba
*Bangaly Kaba*

> "We were literally on the ground in India every three months took a team of engineers with me. I'm talking like we're in Delhi in people's homes and Mumbai, and we went to go investigate what was going on, watch people make friends, watch them use people you may know."

**Insight:** Directly observing users in their own environment reveals cultural nuances and mental models that data cannot capture.

**Tactical advice:**
- Watch users perform core tasks to see where their mental model (e.g., searching by photos) differs from the product's design (e.g., searching by name).
- Identify non-Western paradigms in user behavior to localize product features effectively.

*Timestamp: 01:27:14*


## Bob Moesta
*Bob Moesta*

> "The first thing we do is we try to extract the story from the customer. And it doesn't have to be my product, it could be somebody else's product if I haven't built it yet. It's like, what are people going to fire when they hire me?"

**Insight:** Interviews should focus on the 'story' of why a user switched from an old solution to a new one.

**Tactical advice:**
- Interview people who have recently purchased or switched products to understand the 'causation' of their move.
- Ask about what the user will 'fire' in order to 'hire' your new product.

*Timestamp: 00:18:39*

---

> "I only talk to people who have already tried to make the progress... I need to talk to people who did something and tried and though they might've failed, what made them try?"

**Insight:** Avoid interviewing people about what they 'might' do; only interview those who have taken action or attempted to solve a problem.

**Tactical advice:**
- Filter for interviewees who have already spent time or money trying to solve the problem.
- Ignore 'bitching' (complaining) and look for 'switching' (actual behavior change).

*Timestamp: 00:28:09*

---

> "The other tip I have is to not have a discussion guide. It drives people crazy because everybody wants to ask the same set of questions, but the problem happens is when you ask the same set of questions, you actually don't follow the ones that actually have the most meaningful information in it"

**Insight:** Rigid discussion guides prevent interviewers from following the most valuable conversational threads.

**Tactical advice:**
- Use the 'Four Forces' (push, pull, anxiety, habit) as a mental framework instead of a script.
- Use 'bracketing' (offering two extremes) to help users articulate feelings they can't quite name.

*Timestamp: 00:30:18*


## Christine Itwaru
*Christine Itwaru*

> "Speaking as a former PM, I would not ever give up spending time with customers and watching their pain. That's how I fell in love with product was I saw my internal customer 12 years back now fighting with the keyboard, fighting with the mouse, and I was just like, 'Oh, my gosh. What's this guy doing?'"

**Insight:** Directly observing customer struggle is the foundational experience for building product empathy and identifying real problems.

**Tactical advice:**
- Watch customers use the product in their natural environment to see where they fight with the interface
- Prioritize direct observation over second-hand reports to understand the 'pain' acutely

*Timestamp: 00:00:00*

---

> "I cannot see product managers saying, 'I don't want to be a part of that conversation.' Then you know what? I'm going to say it then don't be in product."

**Insight:** Direct customer interaction is a non-negotiable core responsibility of a product manager that should never be offloaded to operations.

**Tactical advice:**
- Ensure PMs maintain a direct line to customers even when support or ops teams exist
- Use customer conversations as the primary tool for problem discovery

*Timestamp: 00:28:50*


## Chris Hutchins
*Chris Hutchins*

> "I would start pretending that the product existed in the interviews. Only to find out, at the end, people was like, 'Oh, it's not out yet.' And they're like, 'What I want to use...' You could really feel the like, 'No, no, no, no, this has to be out. I want to start using it.'"

**Insight:** Pretending a product is already live during interviews can reveal the true depth of user desire and urgency.

**Tactical advice:**
- Use clickable, full prototypes to simulate a real experience
- Observe emotional reactions when users realize they cannot yet access the product

*Timestamp: 00:10:12*


## Chip Conley
*Chip Conley*

> "I just said, 'Listen, let's get some older people who are hosts in here to see how well they will be versed in managing their listing purely on mobile.'"

**Insight:** User research must include diverse demographic segments to prevent biased product decisions (like going mobile-only).

**Tactical advice:**
- Proactively recruit users from underrepresented age groups to test major strategic shifts

*Timestamp: 00:09:47*

---

> "I actually went into the homes of these hosts all around the world... I think I was lucky because Brian did less of that than he did with other people."

**Insight:** Direct, in-person observation of customers in their own environment provides credibility that data alone cannot offer.

**Tactical advice:**
- Conduct 'world tours' or home visits to gain deep qualitative empathy for the user

*Timestamp: 00:15:05*


## Christopher Miller
*Christopher Miller*

> "we spent a lot of time talking to users directly, and a lot of guerrilla user research techniques. Literally, sometimes going outside and just talking to runners in passing to understand what were the challenges in finding motivation"

**Insight:** Direct, unmediated access to users is essential for understanding the 'why' behind the data.

**Tactical advice:**
- Use 'guerrilla' research methods to talk to users in their natural environment
- Focus interviews on understanding the emotional and motivational drivers of behavior

*Timestamp: 00:24:17*

---

> "I usually tend to really enjoy my conversations with people who decided not to use HubSpot and to really try to unpack what drove that decision. Was it as calculated, as I think sometimes we can all maybe assume... And then you often learn that they're sometimes kind of emotional, really instinctual and visceral"

**Insight:** Interviewing lost prospects or churned users reveals emotional and brand-related barriers that usage data cannot capture.

**Tactical advice:**
- Prioritize interviews with people who chose a competitor or 'non-consumption'
- Ask questions that probe the emotional state of the user during their decision-making process

*Timestamp: 00:27:40*


## David Placek
*David Placek*

> "We do consumer research or customer research at that stage... putting the names in a series of drills... seeing how these names fire their imagination. And that's the most important thing in research, not is the name popular, are they comfortable with it, does it fit to concept."

**Insight:** User research for names should focus on imagination and expectation rather than popularity or 'fit'.

**Tactical advice:**
- Ask users what they expect from a product with a certain name rather than if they 'like' the name
- Test if a name creates a 'predisposition to consider' the product

*Timestamp: 00:51:44*


## Dalton Caldwell
*Dalton Caldwell*

> "You have to get out in the world and talk to people in person. And you can't just hide behind your keyboard and call that talking to customers. Right? I think a lot of folks, the inclinations are to build a landing page and buy some Instagram ads and try to get people to sign up for something. And again, maybe that's something, but I think a lot of the reason people do that is they're just shy and they don't want to put themselves out there because it's a little awkward to go talk to people."

**Insight:** Effective user research requires physical, in-person interaction to overcome the 'keyboard' bias and social anxiety of early discovery.

**Tactical advice:**
- Prioritize in-person physical meetings over digital proxies like landing pages or ads
- Power through the social awkwardness of talking to strangers about your idea
- Avoid using 'customer validation' as a euphemism for just running ads

*Timestamp: 00:41:49*

---

> "I think it's look at your calendar and there should be 20 or 30% of your time that the calendar says something like customer meeting, customer call, meeting with who, meeting with this person. And when the calendar is not that or it's all... Again, what you're actually doing is just buying ads to try to validate your idea, I don't think that's talking to customers."

**Insight:** A founder's commitment to user research should be reflected in their calendar, ideally occupying 20-30% of their time.

**Tactical advice:**
- Audit your calendar to ensure 20-30% of time is spent on direct customer calls or meetings
- Differentiate between 'staring at analytics' and having actual conversations

*Timestamp: 00:43:17*


## Dmitry Zlokazov
*Dmitry Zlokazov*

> "When you delegate such an important thing as customer research and collecting their feedback to someone, you will get a refined filtered version. You won't get these nuances of how people describe things, which emotions they feel like and so on, and where they think stuck. It's very easy to lose all those important bytes of information in this process. So I'm a strong believer that it's very important to have direct communication channel to customers."

**Insight:** Product owners should conduct their own research to avoid losing critical nuances that occur when feedback is filtered through intermediaries.

**Tactical advice:**
- Avoid delegating customer research to maintain a direct connection to user emotions and pain points
- Build internal tools that allow product owners to launch surveys or interviews in a few clicks

*Timestamp: 00:23:52*


## Geoffrey Moore
*Geoffrey Moore*

> "Just like going to a doctor, you don't want the doctor to come and say, 'Hey, can I show you a movie of the operation I just did?'... What I would like to do is talk to you about this pain I have in my side. And then when the doctor asks you good questions about it, you go, 'Ah, this is a good doctor. I'm going to trust this.'"

**Insight:** User discovery should mirror a medical diagnosis, where the interviewer's credibility is built through the quality of their questions.

**Tactical advice:**
- Focus the interview entirely on the user's 'pain' before mentioning your solution.
- Build trust by asking deep, industry-specific questions that show you understand their context.

*Timestamp: 00:13:00*


## Gustaf Alstromer
*Gustaf Alstromer*

> "The problem is, which anyone who hasn't done sales before that joined YC, they realize this, is that if you take the average customer group in the world, 90% are not early adopters... Those 10 percents are the early adopters. They're The ones that you actually want to reach. But that means you have to reach 10 to find one."

**Insight:** Finding the right users to interview requires high-volume outreach to filter for the 10% who are early adopters.

**Tactical advice:**
- Expect a 90% rejection or indifference rate when seeking discovery interviews
- Target the 10% of users who are willing to take risks on new solutions

*Timestamp: 00:24:25*

---

> "I think people just have this fear that, 'If I get a lot of rejection, that means everything is bad.' But the rejection should be put in context to the early adopter idea and that most people who don't care are not early adopters... you just need to overcome that fear and just learn that there's nothing that's really that bad that can happen when people don't use the service."

**Insight:** Indifference is more common than hatred; rejection is a natural part of the discovery process, not a sign of total failure.

**Tactical advice:**
- Internalize that users are busy and their lack of response is usually indifference, not a permanent rejection of the idea

*Timestamp: 00:30:37*

---

> "The best way for you to figure out what is the intensity of the problem is not to ask them but to watch them or to watch them solve the thing that they do... have them screen share, have them walk you through their daily workflow about the area where you're doing some discovery. That is the best thing."

**Insight:** Observational research is superior to verbal feedback because users often don't realize how much pain they are in.

**Tactical advice:**
- Use screen sharing to watch users perform their current manual workflows
- Look for 'invisible' pain points like repetitive Excel tasks that users have normalized

*Timestamp: 00:32:15*


## Jackson Shuttleworth
*Jackson Shuttleworth*

> "We did some UXR in India many years ago... the idea of keeping a flame lit to show your commitment to something makes less sense... it was a metaphor for a mechanic, and when we redesigned it... we actually focused the design on the screen to show your number going up."

**Insight:** Global user research can reveal cultural disconnects in core product metaphors.

**Tactical advice:**
- Test product metaphors (like the 'flame') in different cultural contexts to ensure they are universally understood.

*Timestamp: 00:41:15*


## Jake Knapp + John Zeratsky
*Jake Knapp + John Zeratsky 2.0*

> "These conversations with customers are so much more fruitful and pointed when you've got the context of I know exactly what my hypothesis is and you have prototypes to show them."

**Insight:** Customer discovery is significantly more effective when testing a concrete hypothesis with a prototype rather than having open-ended conversations.

**Tactical advice:**
- Always bring a prototype to a customer interview to ground the feedback in reality.
- Use a scorecard to track if the customer fits the profile, has the problem, and reacts positively to the differentiation.

*Timestamp: 01:24:11*


## Jeff Weinstein
*Jeff Weinstein*

> "The moment the customer felt compelled enough to go out of their way to talk about some problem, that's a unbelievable gift. I will leave a meeting to just get one message back to them. If you're text message friendly with five or 10 of those, you are going to have so much direct signal that is infectious."

**Insight:** Direct, high-speed communication with a small group of highly engaged customers provides more valuable signal than large-scale aggregate data.

**Tactical advice:**
- Respond to customer feedback with extreme speed to build a 'secret portal' of trust.
- Aim to be 'text message friendly' with 5-10 ambitious, technical customers.

*Timestamp: 00:00:04*

---

> "You have to carefully listen and not pitch your customer... people don't want to be pitched. I'm sometimes on a UXR call... and the first thing that they start talking about when we get on the call is, 'Hi, I'm the CEO of X, Y, and Z company. We do one, two, and three. I want to show you a demo.' It's like, 'Hold up, I'm a customer. I have...' What a wasted opportunity you've just done here."

**Insight:** Pitching during a research call anchors the customer and prevents them from sharing their actual burning problems.

**Tactical advice:**
- Avoid starting calls with a company intro or demo.
- Use silence to allow the customer to open up about their top-of-mind issues.

*Timestamp: 00:21:34*

---

> "I'll prompt our customers, I'll say, 'Hey, do you mind just opening up your email? What's in there?' Or, 'If you weren't talking to me right now, what would you be working on?' Or, 'Hey, last week, what grinds your gears? What are you not looking forward to?' Or magic wand, 'What do you wish you could just have off your plate immediately?'"

**Insight:** Specific, open-ended prompts about a customer's daily life reveal the 'first problem' they are desperate to solve.

**Tactical advice:**
- Ask customers what they would be doing if they weren't on the call with you.
- Ask customers to show you their inbox to see real-world friction points.

*Timestamp: 00:23:17*

---

> "I will have them practice charging me. I'll just say, 'Hey, I'm just a friend. I'm trying to help you out... send me an invoice or a payment link for $1 right now, right now. That way, when it comes time to actually charge your first customer, it won't be your first time.'"

**Insight:** The gap between 'willingness to pay' and actually 'paying' is massive; forcing a $1 transaction validates the product's core utility.

**Tactical advice:**
- Ask potential customers to send you a $1 invoice during the interview to test the payment flow and their commitment.

*Timestamp: 00:44:09*


## Jen Abel
*Jen Abel*

> "I would be very open and honest with where you are. Hey, I'm an early stage startup. We have a lot to learn. Can we kind of gain your insight into how this problem is manifesting on your side?"

**Insight:** Vulnerability and honesty about being early-stage encourages prospects to provide raw, honest feedback rather than polite platitudes.

**Tactical advice:**
- Ask prospects to 'walk through what's living in your head' to understand their visualization of the solution.
- Avoid generic questions like 'what keeps you up at night' in favor of specific questions about problem manifestation.

*Timestamp: 00:31:15*


## Jess Lachs
*Jess Lachs*

> "The team, data scientists included, just sat and made phone calls. ... that's where qualitative research is superior to quantitative research, it's asking for the context, to actually talking to people to figure out what was the motivation, what worked, what didn't for them."

**Insight:** When quantitative data fails to explain 'why' a feature didn't work, data teams should pivot to direct customer conversations.

**Tactical advice:**
- Have data scientists conduct phone interviews with customers to understand the motivation behind the numbers.
- Use qualitative insights from these calls to inform the next iteration of product testing.

*Timestamp: 00:42:16*


## Judd Antin
*Judd Antin*

> "One of my big mantras was, 'We don't validate, we falsify. We are looking to be wrong.' Many PMs, many designers are not in that place. They do not want to be wrong. They're looking to validate, and that's user-centered performance."

**Insight:** Research should be approached with a mindset of falsification—seeking to be proven wrong—rather than seeking validation for existing ideas.

**Tactical advice:**
- Adopt a 'falsify, don't validate' mindset during discovery.
- Avoid 'check-the-box' research at the end of a product cycle that is only intended to signal customer obsession.

*Timestamp: 00:00:00*

---

> "A researcher who's going to ask customers what they want is a bad researcher. You need a different researcher. I've never done that in my career. No one on my team has ever run a study that's like that."

**Insight:** Effective user research focuses on understanding behaviors and problems rather than asking users to design the solution.

**Tactical advice:**
- Do not ask users directly what features they want built.
- Focus interviews on understanding the user's context and pain points.

*Timestamp: 00:42:41*


## Keith Coleman & Jay Baxter
*Keith Coleman & Jay Baxter*

> "We showed those to people across the political spectrum. We saw, hey, people really like these. Whether they're on the right or left, they seem very open to reading these community notes even when they're critical to people of their own side."

**Insight:** Testing prototypes with highly polarized user groups can reveal surprising areas of common ground and validate product viability.

**Tactical advice:**
- Recruit research participants from opposing ideological or user groups to test for neutrality
- Use unmoderated studies (like usertesting.com) to gather early feedback on controversial concepts

*Timestamp: 01:06:35*


## Kevin Aluwi
*Kevin Aluwi*

> "I think I just wanted to understand what that role was like to build a lot more empathy towards the job and make sure that our product was catered towards what those needs were... this is eventually what led to, I think a lot of the support I gave to our driver teams when they were pushing for, Hey, we need more waiting fees, we need to add multiple stops in order to make sure that hey, a lot of this extra work was actually compensated."

**Insight:** Immersive user research (dogfooding) is essential for building the empathy required to advocate for critical user-centric features.

**Tactical advice:**
- Personally perform the service or use the product in real-world conditions to build empathy
- Use first-hand experience to identify 'hidden' pain points that require product solutions, such as uncompensated labor

*Timestamp: 00:42:12*


## Kevin Yien
*Kevin Yien*

> "PMs need direct exposure to raw material. End of story. And so that's where I think you just need to constantly be talking to or interacting with whoever is your customer... you can set up workflows either via Zapier or something else to say, 'Who was the customer? Pull their email, put that into a sequence, drop in my Calendly' and you just have interviews showing up automatically on your calendar."

**Insight:** Automating the sourcing of user interviews ensures PMs maintain a constant pulse on the customer without the manual overhead of recruiting.

**Tactical advice:**
- Use tools like Gong to alert you when specific keywords are mentioned in sales calls.
- Automate outreach to those customers via Zapier and customer.io to book research sessions.
- Use userinterviews.com for targeted B2B participant sourcing.

*Timestamp: 00:54:17*


## Madhavan Ramanujam
*Madhavan Ramanujam*

> "If you go and ask someone, 'How much should I charge for this product?' You're actually going to get garbage back... People are absolutely meaningless, relatively super smart."

**Insight:** Direct questions about price yield poor data; relative and indirect questions are more effective.

**Tactical advice:**
- Use relative indexing: Ask how much value your product provides compared to a known anchor (e.g., Salesforce)
- Ask for three price points: Acceptable, Expensive, and Prohibitively Expensive
- Always ask 'Why' after a price response to understand the underlying value perception

*Timestamp: 00:24:15*


## Marty Cagan
*Marty Cagan*

> "I tell this to user researchers at the companies that I coach, if the product manager and the designer are not available to be there during their products test, cancel the test. They need to be there. This is what makes them useful to their team."

**Insight:** Direct observation of user testing is essential for PMs and designers; delegated research reports are insufficient.

**Tactical advice:**
- Ensure the PM and Designer are present for every user test
- Avoid relying on research reports delivered in isolation by researchers

*Timestamp: 00:33:48*

---

> "The first is they have to really get to know the users and customers. They have to be considered pretty much one of the experts on the users and customers. I remember when I was an engineer wanting to become a product manager, the person coaching me said explicitly that I was not allowed to make any decisions for the team until after I visited 30 customers."

**Insight:** A PM's authority to make decisions is earned through deep, direct knowledge of the customer.

**Tactical advice:**
- Aim to visit or interview a significant number of customers (e.g., 30) before making major product decisions
- Develop expertise on the user that exceeds other members of the team

*Timestamp: 00:39:49*

---

> "I know that I was not allowed to take the product manager role until I had visited 30 customers in person, 15 in the US, 15 in Europe. That was just the person who was coaching me. That was their rule. And all I know is those 30 customers changed my life because I thought I knew our customers and I really didn't."

**Insight:** Direct, extensive customer interaction is essential for a product manager to move beyond superficial assumptions about user needs.

**Tactical advice:**
- Aim for a high volume of customer visits (e.g., 30) before feeling confident in a PM role.
- Ensure a mix of geographic locations to get a diverse perspective on customer needs.

*Timestamp: 00:24:09*


## Melissa Perri + Denise Tilles
*Melissa Perri + Denise Tilles*

> "It's also about finding participants who want to opt into research. So making sure that you have customers aware that, 'Hey, we might contact you to do customer interviews. This is why. Do you want to participate in alphas and betas? If so, this is what it entails.'"

**Insight:** Building a pre-vetted database of research participants streamlines the discovery process for product managers.

**Tactical advice:**
- Build a participant database of customers who have opted into research
- Clearly define the expectations and cadence for customers participating in alphas or betas

*Timestamp: 00:16:22*


## Merci Grace
*Merci Grace*

> "Once a month, ideally, you should just have some sort of a schedule for yourself where if you're at a larger company and you have a user researcher who can recruit people for you, that's great, but if not, just go find people who either fit the demographic for your user or even are your user and have them sign up for an account and walking through it."

**Insight:** Regular, direct observation of users signing up for the product is essential to maintain empathy and identify friction.

**Tactical advice:**
- Schedule at least one session a month to watch a real person sign up and use the product.
- Focus on the user's tone of voice and facial expressions during the process.

*Timestamp: 31:26*


## Mihika Kapoor
*Mihika Kapoor*

> "Something that I find incredibly useful is to not just ask users of your product what they think about your product, but to ask non-users about your product, why they're not using your product. And actually I think that those are the most insightful conversations."

**Insight:** Interviewing non-users provides critical insights into market perceptions and barriers to adoption that current users cannot provide.

**Tactical advice:**
- Join sales calls to hear customer pain points firsthand and cross-pollinate them into the roadmap
- Ask non-users why they haven't adopted the product to identify marketing or perception gaps
- Create Loom videos of internal product usage to inspire and evangelize new use cases to customers

*Timestamp: 00:43:03*


## Nabeel S. Qureshi
*Nabeel S. Qureshi*

> "You would spend maybe Monday to Thursday and you would actually go into the building where the customer worked and you would work alongside them. You would literally get a desk there... you learn to live and breathe the customer's problems and you learn to speak their language."

**Insight:** True customer empathy comes from physical immersion in the user's environment rather than occasional interviews.

**Tactical advice:**
- Sit physically next to users to observe their workflows in real-time.
- Learn the specific industry jargon and 'memes' to build trust and understanding.

*Timestamp: 00:19:35*

---

> "Monday, you go in. You do your meetings. Monday night, you build something. Tuesday, you show it to somebody. Tuesday, you get the feedback. Tuesday night, you iterate on it. Wednesday, you show it to somebody. Wednesday night, you iterate on it. So, you get four of these, five of these cycles every single week."

**Insight:** Accelerate product development by running daily feedback and iteration loops directly with the customer.

**Tactical advice:**
- Show work-in-progress daily to get immediate course correction.
- Iterate overnight on feedback received during the day to maintain momentum.

*Timestamp: 00:24:43*


## Nan Yu
*Nan Yu*

> "My goal is to feel bad in the same way that customers feel bad. They come to us with a request, 'Hey, we want X,' and it's like there's something motivating it... What is the actual emotional valence that is motivating whatever you're telling me?"

**Insight:** Effective user discovery involves digging past feature requests to find the underlying negative emotion or 'pain' the user is experiencing.

**Tactical advice:**
- Ask questions from unexpected angles to uncover the root motivation.
- Look for the 'emotional hooks'—the specific moments where a user feels frustrated or unsuccessful.

*Timestamp: 00:31:10*

---

> "You can ask people directly like, 'How do you feel?' And they're not necessarily going to tell you, but if you have a long enough and deep enough conversation with them, you start to level with them, and you're starting to see stuff from their perspective."

**Insight:** Building deep empathy requires long conversations that move beyond analytical 'jobs to be done' into personal perspective.

**Tactical advice:**
- Spend enough time with a user to get them to open up about specific 'bad moments' (e.g., a missed deadline).
- Use the user's specific story to inform the mental model of the problem.

*Timestamp: 00:32:10*


## Noam Lovinsky
*Noam Lovinsky*

> "Imagine building a startup, like a product from day one and not being able to sit right next to your customer and being like, 'Show me how you do this or show me how you do that.' It's incredibly hard. You're looking for such faint signal. The idea that you would try to get it through layers of indirection and games of telephone is crazy."

**Insight:** Direct, unmediated access to customers is essential for 0-to-1 product development to avoid losing signal through organizational 'games of telephone.'

**Tactical advice:**
- Remove legal or organizational barriers that prevent PMs from talking directly to users
- Observe users in their natural environment rather than relying on third-party reports

*Timestamp: 00:42:48*


## Paul Adams
*Paul Adams*

> "What I used to do with people was map out their social network, all the people in it, their family, their friends, how they communicate. We'd map on all the channels, we'd talk about what worked well, what didn't. And, we did this with dozens and dozens of people over the course of maybe 18 months. And the same pattern emerged every single time."

**Insight:** Mapping exercises during interviews can reveal deep-seated behavioral patterns that tactical usability studies might miss.

**Tactical advice:**
- Use visual mapping (e.g., social networks or workflows) during interviews to identify recurring patterns.

*Timestamp: 00:10:00*


## Ravi Mehta
*Ravi Mehta*

> "We identified something quantitatively that was really interesting... Our assumptions about why that use case was that use case were wrong. And when we ended up talking to users, we had some really surprising and fun conversations as a result, and we were also able to recalibrate and understand what those people were solving for."

**Insight:** Quantitative data identifies 'what' is happening, but user interviews are required to understand the 'why' behind extreme user behavior.

**Tactical advice:**
- Identify 'power users' or 'whales' in your data and conduct targeted usability studies with them.
- Ask users what they are 'framing' the cost of your product against to understand their mental model of value.

*Timestamp: 00:37:48*


## Shaun Clowes
*Shaun Clowes*

> "Once you interview between 7 and 14 people, you stop learning new things. Less than 7, you don't learn enough, more than 14, you start learning anything new. And so if you interviewed two people, you probably don't have enough data. If you interviewed 22, you probably had too much, so they don't even right size their efforts."

**Insight:** Effective user research requires 'right-sizing' the number of interviews to reach the point of diminishing returns without wasting resources.

**Tactical advice:**
- Aim for 7 to 14 interviews per research goal to reach thematic saturation.

*Timestamp: 00:14:23*

---

> "Then they go into these conversations asking leading questions, which really are designed to get the customer to say what they already want to be true, which is so they haven't done enough research or they've done too much and then they've blown up all of the results before they've even heard anything."

**Insight:** Leading questions invalidate user research by creating confirmation bias rather than genuine discovery.

**Tactical advice:**
- Avoid leading questions that prompt the customer to agree with your existing hypotheses.

*Timestamp: 00:14:48*


## Tanguy Crusson
*Tanguy Crusson*

> "Lighthouse Users Program... we work with 10 and we prove that the problems that they had are the things that we solved... put these people in front of the whole team, not just the PMs, PM, designer, engineering. We meet on Zoom, we chat, we work with the same ones over months to build a product. They are with us on Slack."

**Insight:** Deep, longitudinal relationships with a small group of 'Lighthouse' users are more valuable for 0-to-1 than broad, anonymous research.

**Tactical advice:**
- Recruit 10 specific users to co-create the product over several months
- Involve engineers directly in user calls to build 'product engineers' who empathize with specific customers
- Set up shared Slack channels with early users for a direct feedback loop

*Timestamp: 01:23:56*


## Teresa Torres
*Teresa Torres*

> "I think interviewing is a grossly underestimated skill. Grossly underestimated skill. So that's the first thing is that if you're not collecting rich stories in your interviews, it's going to be really hard to identify opportunities."

**Insight:** The primary goal of a user interview is to collect specific stories rather than general facts or opinions.

**Tactical advice:**
- Avoid asking direct questions out of context (e.g., 'What do you like to watch?')
- Ask for specific instances (e.g., 'Tell me about the last time you watched a movie')
- Ground the interview in behavior to get reliable data

*Timestamp: 15:54*

---

> "The most common strategy is to allow your customers to opt in while they're using your product or service... instead of saying, 'Would you recommend our product or service to a friend or colleague?' it says, 'Do you have 20 minutes to talk to us?' If they say yes, you send them some scheduling software, they pick a time on your calendar, and voila."

**Insight:** Automating the recruitment process is essential for maintaining a continuous interviewing habit without administrative overhead.

**Tactical advice:**
- Embed interview invites directly in the product flow
- Use scheduling software (like Calendly) to let users pick times automatically
- For B2B, define triggers for sales/support teams to schedule interviews on your behalf

*Timestamp: 27:18*

---

> "I teach in our interviewing class, you really don't have to think about what to ask. You could run an entire interview by asking them one question... 'Tell me about the last time you watched something on a streaming entertainment service.'... All I have to do is just be curious about your experience. What I'm doing with my questions is just helping you tell the timeline."

**Insight:** A great interview feels like a natural conversation where the interviewer acts as a curious guide helping the user recount a timeline.

**Tactical advice:**
- Start with one broad story-based question
- Use 'What happened next?' to move the story forward
- Summarize what you heard to show you are listening and bring them back to specific moments

*Timestamp: 37:00*


## Todd Jackson
*Todd Jackson*

> "We refer to it as dollar-driven discovery. We get very specific about not just the normal way of doing customer conversations and customer discovery, but how do you find that a customer is willing to pay money for this thing and a lot of money?"

**Insight:** Effective discovery must move beyond polite conversation to 'dollar-driven' validation to avoid being 'friend-zoned' by potential customers.

**Tactical advice:**
- Ask 'What is a fair price?', 'What would be an expensive price?', and 'What would be a prohibitively expensive price?' to find the true willingness to pay.
- Look for 'wow statements' or requests for follow-up meetings as high-signal indicators of interest.
- Ask 'Where would a budget for this come from?' to identify if there is an existing line item or if you are displacing another tool.

*Timestamp: 00:14:11*

---

> "I need your help. It is very important to me that this company succeeds and does not fail. So I don't want you to be nice to me. I want you to tell me is Persona a necessity for your company? If we went away, how painful would that be? If a competitor came along that charged half as much as us, would you switch to them?"

**Insight:** Directly asking customers for brutal honesty about the product's criticality helps founders avoid the 'friend zone' trap.

**Tactical advice:**
- Explicitly ask customers if they would switch to a cheaper competitor to test if your product is a 'necessity' or a 'nice-to-have'.

*Timestamp: 00:37:00*


## Tim Holley
*Tim Holley*

> "Back in the day, we were doing studio visits with sellers. We were going to their workshops, we were going to their homes. We were seeing how they make items, we were seeing how they package and ship them out. We were bringing them into the office when we were running hack weeks to say, 'Hey, we've got this crazy idea. Is this interesting?'"

**Insight:** Deep immersion in the user's physical environment builds a rich understanding of their workflow and constraints.

**Tactical advice:**
- Conduct 'studio visits' or site visits to see users in their natural environment.
- Involve users directly in the product development process, such as during hack weeks.

*Timestamp: 00:19:30*


## Uri Levine
*Uri Levine*

> "If you speak with a hundred people, but if you actually speak with 20 people that you don't know, you will get validated whether or not this problem is real or not."

**Insight:** Validation requires getting out of your comfort zone and speaking to strangers to confirm the problem's reality.

**Tactical advice:**
- Speak with at least 20 people you don't know to validate a problem.
- Listen for whether they describe the problem in their own words or just acknowledge yours.

*Timestamp: 00:09:30*


## Yuriy Timen
*Yuriy Timen*

> "Getting to know your customer always pays off. So it's user interviews and getting to know your market, your customers, and your prospects always pays off. Customer research, inside surveying, interviewing panels incredibly useful. And I found that to be very especially early stages. The amount of clarity at momentum that it can create inside of a seed Series A up to Series B company when you first do some proper research push."

**Insight:** Customer research and user interviews are the highest ROI activities for creating team alignment and strategic clarity.

**Tactical advice:**
- Conduct a 'proper research push' including interviews and panels to galvanize the team around a shared purpose.

*Timestamp: 00:54:07*


## Zoelle Egner
*Zoelle Egner*

> "Literally had a Slack integration that we pulled in a whole bunch of information about anyone who signed up for Airtable... and literally would sit there and had a little button in each of the records that came in that would allow us to email them immediately... 'Hey, we'd really love to get your feedback.'"

**Insight:** Proactive, immediate outreach to new signups helps build mental models of successful user personas.

**Tactical advice:**
- Integrate signup data into a real-time feed (e.g., Slack) for immediate outreach
- Target specific titles or companies for high-touch feedback sessions
- Use early conversations to help users build their first 'durable' workflow

*Timestamp: 00:42:21*

---

> "The simplest way to do this is to write a template email for yourself... 'I would really love to hear about your experience so far and get your feedback. Do you have 10 minutes to talk on the phone?' I know it is important that it's on the phone and not a survey because you get way more instinct from unstructured conversation."

**Insight:** Unstructured phone conversations provide deeper insights than structured surveys.

**Tactical advice:**
- Automate the process of finding and emailing users for feedback
- Prioritize phone calls over surveys to capture nuance and instinct
- Commit to a weekly or monthly quota of customer conversations

*Timestamp: 01:06:37*


## Dylan Field
*Dylan Field*

> "I ran him through the user study, I knew we'd need a bottle of wine to finish and it took hours. The type of sentence in Figma was so slow... Payam wrote a very long doc for us about all the things that he wanted to see in Figma after we did a user research study with him."

**Insight:** High-intensity, long-form user studies with early adopters can provide a comprehensive roadmap of necessary improvements.

**Tactical advice:**
- Conduct deep-dive user studies that allow for hours of observation and feedback
- Encourage power users to document their friction points in detail after a session

*Timestamp: 34:27*


## Paige Costello
*Paige Costello*

> "Become best friends with a researcher, and spend time watching customers use the product firsthand because what they maybe report on or are trying to do a study about might be very different from what you observe, but you really just need that front row seat with customers."

**Insight:** Direct observation of customers is the fastest way to build credibility and understand real-world product usage versus internal assumptions.

**Tactical advice:**
- Partner closely with UX researchers to gain direct access to customers.
- Watch customers use the product firsthand rather than just reading summary reports.

*Timestamp: 00:24:59*


## Peter Deng
*Peter Deng*

> "I still remember distinctly flying down to LA with Kevin Systrom to go do a user research study... there's no substitute for that... you can't empathize with the summary. You have to be in the room fully immersed, no phones, just actually hearing the words and the intonation."

**Insight:** True empathy cannot be outsourced to AI summaries; leaders must be physically or mentally present in the room to hear the nuances of user feedback.

**Tactical advice:**
- Participate in user research sessions personally rather than reading summaries
- Observe users in their natural environment (e.g., driving for Uber) to feel their pain points

*Timestamp: 01:32:44*


## Scott Belsky
*Scott Belsky*

> "The most humbling moments for me as a product leader have always been shoulder to shoulder to customers. Watching them actually go about their day, not just use my product but go about their day because what you end up getting is context for a lot of data that you're missing."

**Insight:** Observing users in their natural environment provides critical context and reveals data points that analytics alone cannot capture.

**Tactical advice:**
- Watch users go about their entire daily routine, not just the moments they use your product
- Identify the external distractions (meetings, pings, family) that compete for the user's attention

*Timestamp: 00:13:41*


