---
name: content-marketing
description: Help users build content marketing strategies. Use when someone is starting a blog, building SEO, creating thought leadership content, or deciding on content formats and distribution channels.
---

# Content Marketing

Help the user build effective content marketing using frameworks from 23 product leaders who have built content engines at companies like Notion, First Round, and The Pragmatic Engineer.

## How to Help

When the user asks for help with content marketing:

1. **Identify the goal** - Determine if content is for SEO, brand building, lead generation, or thought leadership
2. **Find content-market fit** - Help them identify the specific anxieties or needs their content will solve
3. **Choose the right format** - Match content format to the creator's strengths and audience preferences
4. **Design for consistency** - Build a sustainable publishing cadence before chasing virality

## Core Principles

### Validate search demand first
Meltem Kuran: "If people aren't asking this question to Google, you can write all the content you want, it doesn't matter, nobody's going to find it." Verify that people are actually searching for the topic before investing in creation.

### Create content-market fit
Camille Ricketts: "The way that you think about product market fit, you have to think about content market fit... What is it that they need to get promoted? What is it that they need to avoid failure?" Treat content as a product that solves specific professional anxieties.

### Content must be a painkiller
Camille Ricketts: "Painkillers always win. Can your content be a painkiller? Can it help people out of situations that are causing them a lot of pain?" Focus on solving specific pain points rather than providing general 'vitamins.'

### Go direct with a human voice
Lulu Cheng Meservey: "Going direct means that the founder or executive has to be speaking from themselves. First person, speaking in a human voice authentically. You see them make mistakes, you see them be vulnerable." Corporate accounts fail; personality wins.

### End the Google search
Meltem Kuran: "The main thing to think about is, is the Google search over? If someone reads your content, are they going back to Google to continue reading more or is the Google search over?" Write content that fully satisfies user intent.

### Invest in evergreen assets
Julian Shapiro: "I'm spending as many hours going back and rewriting old blog posts as I am writing new ones. I consider everything I write to be evergreen." Regularly update old content rather than chasing news cycles.

### Consistency beats production value
Sriram and Aarthi: "The most important thing is just get started and do something every single day... it builds muscle, it gets you familiar with the medium." Daily reps matter more than polish when starting out.

### AI-assisted, not AI-generated
Ethan Smith: "The future of content is clearly AI-assisted. Clearly, you and I will be using AI to help us write, so it's not no AI at all, but it's not 100% generated with AI." Human expertise provides the 'information gain' that search engines reward.

## Questions to Help Users

- "Are people actually searching for this topic on Google?"
- "What specific professional anxiety does this content solve?"
- "Is this content a painkiller or a vitamin?"
- "Who is the human face/voice behind this content?"
- "Would you enjoy creating this even if it didn't drive traffic?"
- "Can you commit to this format for at least a year?"

## Common Mistakes to Flag

- **Writing for no demand** - Creating content nobody is searching for
- **Keyword stuffing over intent** - Optimizing for search terms without actually answering the question
- **Corporate voice** - Publishing from faceless brand accounts instead of named humans
- **Inconsistent publishing** - Chasing virality instead of building sustainable cadence
- **100% AI generation** - Missing the 'information gain' that requires human expertise

## Deep Dive

For all 35 insights from 23 guests, see `references/guest-insights.md`

## Related Skills

- Positioning & Messaging
- Brand Storytelling
- Launch Marketing
- Community Building
