# Content Marketing - All Guest Insights

*23 guests, 35 mentions*

---

## Ada Chen Rekhi
*Ada Chen Rekhi*

> "I know a lot of people have talked about doing a LinkedIn 30. So 30 days of posting something on LinkedIn in terms of content every day for 30 days straight, and just getting past that barrier of sharing."

**Insight:** Consistency in content creation is a 'vegetable'—a difficult task that requires repeated exposure to overcome the initial discomfort and lack of skill.

**Tactical advice:**
- Commit to a 'LinkedIn 30' to force the habit of sharing insights.
- Write for an 'audience of one' to make the process feel more authentic and less like self-promotion.
- Focus on crystallizing a thought that is useful to you rather than chasing viral metrics.

*Timestamp: 01:04:14*


## Andy Raskin
*Andy Raskin_*

> "What I find is like, yeah, there's this a while where you're writing and it feels like you're talking to nobody and then gradually it grows and you'll have these peaks, but then over time is where the magic is."

**Insight:** Content marketing success is a result of long-term consistency punctuated by high-impact 'peaks.'

**Tactical advice:**
- Focus on long-term consistency rather than expecting immediate 'boom' results.
- Use platforms like Medium or LinkedIn to build an audience without intermediaries.

*Timestamp: 00:18:14*


## Barbra Gago
*Barbra Gago*

> "And then tactically, it's a lot of content marketing and a lot of thought leadership. When you're building a category, you need to make sure that there is a category that's validated by analysts and directory sites and things like that... And then of course, getting a lot of content around because when you're generating a new category, you're also needing to educate buyers that there is a category that they can now budget for and why they should allocate budget for that."

**Insight:** Content marketing in category creation serves as an educational tool to justify new budget allocations for buyers.

**Tactical advice:**
- Produce high volumes of content to educate the market on the new category
- Use content to explain why a new budget line item is necessary

*Timestamp: 23:15*


## Ben Williams
*Ben Williams*

> "We have a side car product called Snyk Advisor. Snyk Advisor, it's basically a service that developers use to search and find open source packages when they're considering integrating some within their software applications... anyone searching on Google for a package that does X, Y, Z or a specific package by name, Snyk Advisor will be right up there in terms of the search results."

**Insight:** Programmatic SEO assets that provide utility (like a package health score) can drive massive top-of-funnel acquisition.

**Tactical advice:**
- Build programmatic SEO assets that index high-intent search terms
- Provide free utility or data (like security scores) to attract users from search engines

*Timestamp: 00:23:44*


## Camille Hearst
*Camille Hearst*

> "One of the things that I've seen that I don't know if people realize is consistency and predictability of content creation... there is something to churning out consistent quality work and putting it out there for your audience to consume and respond and react to that goes a long way. It's almost like the 10,000 hours."

**Insight:** Predictable and consistent output is the most critical factor for long-term audience growth and creator success.

**Tactical advice:**
- Maintain a consistent schedule to build audience habits
- Focus on 'churning out' work to reach the '10,000 hours' of mastery

*Timestamp: 00:20:08*


## Cam Adams
*Cam Adams*

> "He set up a whole team of people who looked at people's motivations and the top jobs to be done that Canva could service. He then mapped that through the entire experience of going into Google, typing a search query, getting that search query, seeing that it was a great result, firstly getting to the top result, but then also the experience after they landed on Canva."

**Insight:** Effective SEO strategy maps user intent (Jobs to be Done) directly to a seamless product entry point.

**Tactical advice:**
- Identify high-volume 'Jobs to be Done' (e.g., 'Halloween poster') and create dedicated landing pages
- Ensure the post-click experience takes the user directly into a relevant template to fulfill the search promise

*Timestamp: 00:45:51*


## Camille Ricketts
*Camille Ricketts*

> "The way that you think about product market fit, you have to think about content market fit. So even though content feels like it's running adjacent to the actual product that you're putting out there, you still have to think about who is my audience? ... What is it that they need to get promoted? What is it that they need to avoid failure? What is it that causes them a great deal of anxiety in the day-to-day of their lives or their work? And can you create some type of content product that is going to address this for them?"

**Insight:** Content marketing requires 'content market fit,' which means creating content that solves specific emotional or professional anxieties for the target audience.

**Tactical advice:**
- Identify the specific professional needs of your audience (e.g., getting promoted, avoiding failure)
- Treat content as a product that addresses user anxieties

*Timestamp: 00:00:00*

---

> "painkillers always win. So can your content be a painkiller? Can it help people out of situations that are causing them a lot of pain? Can it help people stop being so confused or can it make them even feel less alone in their experience?"

**Insight:** High-value content acts as a 'painkiller' by solving confusion or normalizing difficult professional experiences.

**Tactical advice:**
- Focus content on solving specific 'pain' points rather than just providing 'vitamins' (general info)
- Share failures or suboptimal situations to help the audience feel less alone

*Timestamp: 00:51:54*

---

> "It would take eight hours to just write the thing. And that's after you had done all of the prep work of making sure that your interviewee was feeling really anchored and understanding a topic that you were both really excited about and making sure you were mining all of the tactical gems from that conversation."

**Insight:** High-quality content requires significant time investment—often 8+ hours of writing after extensive research and interviewing.

**Tactical advice:**
- Spend time 'mining' tactical gems from interviews rather than just transcribing
- Allocate significant time (8-10 hours) for the actual writing and synthesis process

*Timestamp: 00:54:58*


## Chris Hutchins
*Chris Hutchins*

> "make clips of your podcast and you could put those clips on these channels that do have that built in distribution... TikTok, YouTube, Instagram Reels... brand awareness for me."

**Insight:** Leverage short-form video platforms with built-in discovery engines to drive brand awareness for long-form content.

**Tactical advice:**
- Create high-quality clips of long-form content for TikTok and Reels
- Use these platforms for brand awareness even if direct attribution to downloads is low

*Timestamp: 00:47:59*


## Christopher Miller
*Christopher Miller*

> "One of the channels that we're spending some time experimenting with is this concept of microapps... Website Grader... you put in your domain, and it crawled your site, and then gave you a set of recommendations... It was definitely a one trick pony. But what it did was it created an interesting conversation"

**Insight:** Microapps and free tools act as high-intent lead magnets that provide immediate value while demonstrating the need for the core product.

**Tactical advice:**
- Build 'one-trick pony' tools (e.g., graders, generators) that solve a specific, narrow problem
- Use the output of a free tool to transition the user into a conversation about the full product suite

*Timestamp: 01:13:15*


## Claire Butler
*Claire Butler*

> "I got him to make technical content and that, I think, went to number one on Hacker News... I remember one of my bars were deciding if something would hit this or not... "Did I understand it?" And if I understood it, it was probably too basic, or if I could have written it myself, it was probably too basic."

**Insight:** To build credibility with technical users, content must be deep, technical, and written by practitioners rather than generalist marketers.

**Tactical advice:**
- Set a high bar for technical depth: if a non-technical marketer can write it, it's too basic
- Leverage engineers and designers to write about the 'how' and the craft behind the product

*Timestamp: 00:34:08*


## Emilie Gerber
*Emilie Gerber*

> "The standard press release format, it's so formulaic, and I think it actually encourages that more marketing speak. The benefit is that you're getting all the news details in one place... However, you can do the exact same thing in a blog post."

**Insight:** Blog posts are often superior to traditional press releases because they allow for better tone, shareability, and SEO.

**Tactical advice:**
- Use a first-person blog post instead of a formal press release for announcements
- Include all news elements in the blog post to serve as a resource for reporters

*Timestamp: 01:04:21*

---

> "If you're going to do that [social strategy], have an exec that you're also trying a social strategy with. Don't just do the plain corporate channels. Corporate channels, it's very hard to build a following... When you have an executive, you're following a personality."

**Insight:** Social media impact is driven by executive personalities rather than corporate brand accounts.

**Tactical advice:**
- Prioritize executive social presence over corporate brand channels
- Focus on building a personality and tone for the executive spokesperson

*Timestamp: 01:13:07*


## Ethan Smith
*Ethan Smith*

> "The future of content is clearly AI-assisted. Clearly, you and I will be using AI to help us write, so it's not no AI at all, but it's not 100% generated with AI."

**Insight:** Effective content strategy uses AI for assistance while maintaining human-in-the-loop oversight to avoid search engine penalties and 'model collapse.'

**Tactical advice:**
- Use AI to draft or structure content but ensure human experts provide the final polish and unique insights.
- Avoid 100% automated content generation as it lacks 'information gain' and is easily detected by search algorithms.

*Timestamp: 00:52:38*

---

> "One concept would be information gain. So did you say something that somebody else didn't say? Two is how typical are you? Are you so typical that I think that you're a rewritten version of somebody else's content?"

**Insight:** High-quality content is defined by its uniqueness and the addition of new information to the existing web ecosystem.

**Tactical advice:**
- Conduct original research to ensure your content provides 'information gain.'
- Avoid 'typicality' by including domain expertise and unique perspectives that AI cannot easily replicate.

*Timestamp: 00:26:50*


## Gergely
*Gergely*

> "I started a blog six years before... I said, 'I'm going to start a blog, it'll be about software engineering and I'll call it The Pragmatic Engineer.'... I said, 'I'm going to do what Jeff Atwood said. I'm going to publish... every two weeks I'm going to publish an article, and I'll do it for a year.'"

**Insight:** Long-term consistency in publishing high-quality content is the foundation for building a massive audience and distribution channel.

**Tactical advice:**
- Commit to a regular publishing cadence (e.g., every two weeks) for at least a year to build momentum.
- Focus on a specific niche (e.g., pragmatic software engineering) rather than general topics to attract a dedicated following.

*Timestamp: 00:55:56*

---

> "I announced my newsletter, I told people, 'I'm going to go full time on this.' I had maybe 10,000 Twitter followers and, I don't know, maybe 1,000 on LinkedIn... What I didn't tell is that there was at least six years of accidental work behind this."

**Insight:** A 'fairytale' launch is usually the result of years of prior audience building and reputation management on social platforms.

**Tactical advice:**
- Build a presence on platforms like Twitter and LinkedIn years before you intend to monetize them.
- Use a personal blog as a long-term repository for insights that can eventually be converted into a newsletter or book.

*Timestamp: 00:54:57*


## Gokul Rajaram
*Gokul Rajaram*

> "My rule of thumb is when they do a search for you on Google, if your LinkedIn profile is the first thing that comes up, you've probably done something wrong. What should come up is an article you wrote. Is a tweet you published."

**Insight:** Building a personal brand through published content is essential for establishing expertise and generating 'deal flow' for your career or investments.

**Tactical advice:**
- Write and publish non-obvious insights about your specific domain (e.g., payments, risk, crypto)
- Aim to have your own content outrank your social profiles in search results

*Timestamp: 00:56:02*


## Julian Shapiro
*Julian Shapiro*

> "Generally speaking, threads, despite everything I've said, are the primary way to get followers. There's a reason why people do threads as opposed to single tweets is because when people get exposure to a thread, they're basically getting exposure to the length of thoughts equivalent to you having sent a newsletter edition or a blog post in many cases."

**Insight:** Threads are the most effective growth mechanism on Twitter because they demonstrate a creator's ability to provide consistent, high-quality depth.

**Tactical advice:**
- Use long-form threads (up to 30 tweets) to prove consistency of thought
- Use clickbaity opening tweets to trigger the initial click
- Port followers from your website or newsletter to provide an initial sample audience

*Timestamp: 08:52*

---

> "I'm spending as many hours going back and rewriting old blog posts and handbooks as I am writing ones. If you come back to anything I've written over the course of a year or year and a half, it'll be updated, because I consider everything I write to be evergreen."

**Insight:** Treating content as living, evergreen assets rather than one-off posts builds long-term SEO value and authority.

**Tactical advice:**
- Avoid writing about newsy trends that expire quickly
- Regularly update old content to keep it relevant and accurate
- Use handbooks as a middle ground between newsletters and books for better UX and SEO

*Timestamp: 12:55*


## Laura Modi
*Laura Modi*

> "We wanted to become the content leaders in that, with the hypothesis... that if we win on content and as a thought leader, that will drive back to Bobbie. And today... if you do a cursory Google search for something like 'How long does formula last?' Milk Drunk is showing up between the CDC and the bum on the first page of Google."

**Insight:** Investing in educational content and SEO builds long-term authority that converts into commerce.

**Tactical advice:**
- Create a separate content platform (e.g., a blog) to address customer education needs.
- Focus on high-intent SEO keywords that establish your brand as a thought leader.

*Timestamp: 00:48:15*


## Lulu Cheng Meservey
*Lulu Cheng Meservey*

> "Going direct... means that the founder or executive for some very senior person has to be speaking from themselves. First person, may be first person plural, and speaking in a human voice authentically. You see them make mistakes, you see them be vulnerable, and they have to become an ambassador to the community."

**Insight:** Modern content strategy requires a human face and voice rather than a faceless corporate entity to build trust.

**Tactical advice:**
- Identify the spokesperson's dominant communication style (long-form, video, audio, or short-form).
- Invest heavily in one primary channel that fits the spokesperson's natural strengths before expanding.
- Avoid ghost-writing that sounds corporate; maintain a human, vulnerable tone.

*Timestamp: 00:42:58*

---

> "LinkedIn is super underutilized because it gets a ton of eyeballs in time, but most of the content sucks... the ratio of your competitive set of interesting content versus how much time and attention people spend on there is excellent."

**Insight:** LinkedIn offers a high ROI for quality content because the platform has high engagement but low-quality competition.

**Tactical advice:**
- Post genuinely interesting and useful content on LinkedIn to stand out against generic corporate updates.
- Use LinkedIn specifically for career-related or professional audience targeting.

*Timestamp: 00:48:14*

---

> "Step one would be assessing what are you good at and what do you enjoy... Step two is setting up your account on those channels... And then you start building your audience. And when you start if you're actually starting from zero, get some pipeline of content ready... get a week or two of posts ready to go."

**Insight:** Building an audience requires matching the medium to the creator's personality and maintaining a consistent content pipeline.

**Tactical advice:**
- Prepare 1-2 weeks of content before launching a new channel to build momentum.
- Prioritize consistency over trying to go viral with every single post.
- Focus on providing value to a specific audience rather than chasing 'low-value' viral likes.

*Timestamp: 00:54:03*


## Meltem Kuran
*Meltem Kuran*

> "I'm a huge fan of SEO, happy to discuss that later, but if people aren't asking this question to Google, you can write all the content you want, it doesn't matter, nobody's going to find it."

**Insight:** SEO content is only effective if it targets existing search demand and active questions.

**Tactical advice:**
- Verify that people are actually asking the question on Google before writing content.

*Timestamp: 00:09:36*

---

> "The biggest mistake people make is they will just shove keywords. They're like, 'Okay, these are the keywords people are searching for, I need to make sure I mention it five times.' Obviously do that, make sure that the content that you wrote answers the question. But the main thing to think about it is, is the Google search over? If someone reads your content, if they typed in something to Google, and then they read the article that you've published, are they going back to Google to continue reading more or is the Google search over?"

**Insight:** The ultimate goal of SEO content is to satisfy the user's intent so completely that they stop searching.

**Tactical advice:**
- Focus on 'ending the search' rather than just keyword density.
- Write content that answers the primary question and the likely follow-up questions.

*Timestamp: 00:16:40*

---

> "We have this framework that we call the traffic light system. Essentially we go, whenever the team is going to do a content series, they will go and find up to 700 keywords... And then those set of keywords get ranked by highest volume to the lowest volume... And then you go one by one... and say, what is the intent of someone searching this keyword?"

**Insight:** Prioritize content creation based on a combination of search volume and conversion intent.

**Tactical advice:**
- Rank keywords by volume and then categorize by intent (Green: high intent/ready to buy, Yellow: mixed intent, Red: no intent).
- Execute from Green highest volume down to Yellow, often ignoring Red entirely.

*Timestamp: 00:18:42*

---

> "We use Clearscope, we love it... those tools will give you a score to say you're an A plus or you're a C minus, you need to make your language less sophisticated, currently it's at university level and we need it to be at fourth grade reading level."

**Insight:** Use optimization tools to ensure content is accessible and technically sound for search engines.

**Tactical advice:**
- Aim for a low reading level (e.g., 4th or 5th grade) to ensure clarity and accessibility.

*Timestamp: 00:21:38*


## Paul Millerd
*Paul Millerd*

> "Podcast is the ultimate long game, so you need to find some intrinsic connection to what you're actually doing. If you don't love the conversations or the format you're doing, don't do it."

**Insight:** Sustainability in content creation depends on intrinsic enjoyment of the format rather than immediate financial or growth metrics.

**Tactical advice:**
- Choose a content format (podcast, newsletter) that you would enjoy doing even if it lost money
- Commit to a 'long game' mindset for podcasting growth

*Timestamp: 01:00:36*


## Ray Cao
*Ray Cao*

> "Number one thing is that you have to really be unfiltered. I mean, you don't really need to be perfect on this platform. I mean that's the beauty of it. You can be yourself, you can really share the things that you like."

**Insight:** Authenticity and 'unfiltered' content perform better on modern social platforms than polished, perfect production.

**Tactical advice:**
- Focus on being relatable and showing a 'different side' of the brand or person.
- Embrace the community culture by listening to user behaviors before creating.

*Timestamp: 00:49:47*


## Sriram and Aarthi
*Sriram and Aarthi*

> "The most important thing... is just get started and do something every single day... it builds muscle, it gets you familiar with the medium and you start understanding what works in that medium and what doesn't and you start building reps."

**Insight:** Consistency and 'reps' are more important than high-production value when starting content creation.

**Tactical advice:**
- Post content every single day to build the creative muscle.
- Focus on being authentic and relatable rather than just projecting an expert persona.
- Share niche expertise you've actually practiced rather than 'LARPing' as an expert in broad topics.

*Timestamp: 00:40:30*


## Yuriy Timen
*Yuriy Timen*

> "I think with SEO, it's like the first pillar I would say is, do you have a unique angle... Do you have a unique programmatic angle, right? For instance, Canva did dealt with templates... do you have a unique data angle?"

**Insight:** Successful SEO strategy requires a unique angle, typically editorial, programmatic (templates), or proprietary data.

**Tactical advice:**
- Audit the SEO landscape for 'how-to' searches to find editorial gaps.
- Identify programmatic opportunities like templates or landing pages for long-tail keywords.
- Leverage proprietary user data to create unique search experiences.

*Timestamp: 00:18:54*

---

> "SEO is now becoming more attractive because once you got your burn under control and you're thinking, "Okay, we saved all this money by reducing our paid budget. We're cutting it entirely. How do we put some of those resources back to work?" And all of a sudden SEO starts looking a lot more lucrative because it's almost like you took the urgency of grow at any cost in the next six months, you took that out of the equation."

**Insight:** Market downturns favor SEO over paid acquisition because the pressure for immediate (but expensive) returns is replaced by a need for sustainable burn.

**Tactical advice:**
- Shift resources from paid media to SEO when extending runway becomes the priority over short-term growth spikes.

*Timestamp: 00:45:00*


## Zoelle Egner
*Zoelle Egner*

> "Make sure that you have also set up a process to take the insights that your customer success people are coming up with and turn them into as much content as you can... we would talk to a bunch of customers and then customer success would have helped them build bases, and then we would create templates."

**Insight:** Customer success interactions are a primary source for high-value, scalable content and templates.

**Tactical advice:**
- Create a 'conveyor belt' to turn individual customer solutions into generic templates
- Use real-world workflows as the basis for blog posts and educational resources
- Share templates with smaller customers to scale support without increasing headcount

*Timestamp: 00:49:42*


