---
name: cross-functional-collaboration
description: Help users work effectively across functions. Use when someone is navigating PM-engineering relationships, resolving cross-team conflicts, building product trios, or improving handoffs between design, engineering, and product.
---

# Cross-functional Collaboration

Help the user work effectively across functions using frameworks from 57 product leaders who have built high-performing cross-functional teams at companies from Linear to Airbnb.

## How to Help

When the user asks for help with cross-functional collaboration:

1. **Diagnose the friction** - Identify whether the issue is role clarity, communication patterns, or structural
2. **Clarify expectations** - Help define what each function expects from the others
3. **Design the right structure** - Recommend team composition and meeting rhythms
4. **Build relationships** - Emphasize the human elements that make collaboration work

## Core Principles

### Share credit generously
Camille Fournier: "Engineers sometimes think that they don't get the credit for their work because the PM takes all the glory. So making every effort to be credit sharing and inclusive of the engineering team." Let engineers present their own work to executives and customers.

### Use 'Yes, and' thinking
Adam Grenier: "If you approach it with that 'Yes, and,' it's often still true. Both of these things can be true at once. You could have a different goal than I have." Validate different team goals simultaneously rather than creating false dichotomies.

### Write expectations for each other
Nikita Miller: "Have PM, Design, Engineering, and Data leaders write down expectations for their counterparts. Create a 'contract' between roles to clarify shared responsibilities." Revisit these definitions every 3-6 months.

### Include engineers in discovery
Christine Itwaru: "Early on, we started bringing in engineers to customer meetings more and more. When we started doing it, the response from the engineering team was great." Direct customer exposure builds technical empathy.

### Don't play telephone
Camille Fournier: "If you put yourself in this in-between position and you're playing telephone between stakeholders and engineers, that is very annoying and it's a waste of time for everyone." Connect stakeholders directly to engineers when technical depth is needed.

### Work directly with engineers daily
Marty Cagan: "If you're not working every day with a set of engineers on solving problems, you are not a product manager." Remove intermediaries like 'product owners' who act as mediators.

### Build real relationships
Ebi Atawodi: "Do you know your engineering manager's birthday? Do you know their work anniversary? Do you know why they're doing the job they're doing?" Strong partnerships are built on personal human connection.

### Code is the common language
Amjad Masad: "The common language that everyone shares is code. What if the language becomes actually working prototypes and working applications?" Use functional prototypes rather than static mocks to reduce handoff friction.

### Embrace the 'product trio'
Teresa Torres: "The trio is the product manager, the designer, and the software engineer. If you've never worked in a well-functioning trio, this breaks people's brains." Resolve disagreements by seeking more data or better options, not by pulling rank.

## Questions to Help Users

- "What does each function expect from the others - have you written it down?"
- "Are engineers involved in customer discovery or just receiving specs?"
- "When there's a conflict, who is the tiebreaker and how quickly do they act?"
- "Do you know the personal career goals of your engineering and design partners?"
- "Are you acting as a translator or connecting stakeholders directly to engineers?"

## Common Mistakes to Flag

- **Credit hoarding** - PMs taking glory for work engineers built
- **Playing telephone** - Acting as an unnecessary intermediary between stakeholders and engineers
- **Excluding engineers from ideation** - Treating them as resources rather than creative partners
- **Unclear role boundaries** - Not defining who owns what leads to everything falling on the PM
- **Ignoring the human element** - Strong collaboration requires knowing your partners as people

## Deep Dive

For all 72 insights from 57 guests, see `references/guest-insights.md`

## Related Skills

- Running Effective 1:1s
- Having Difficult Conversations
- Delegating Work
- Managing Up
