# Cross-functional Collaboration - All Guest Insights

*57 guests, 72 mentions*

---

## Alex Hardimen
*Alex Hardimen*

> "Cross-functional missions at the Times... include a lot of the same skill sets that you would find at a tech company, PMs, engineers, designers, data scientists, researchers, product marketers. But the big difference is we also have editors, if it's a product space that directly shapes our journalism."

**Insight:** In content-heavy organizations, cross-functional teams should include subject matter experts (like editors) directly in the product mission.

**Tactical advice:**
- Embed subject matter experts (editors) within product missions
- Ensure editors have a 'product-minded' perspective

*Timestamp: 00:23:21*

---

> "Product managers at the Times really need to understand the blend of art and science. They really need to value expert editorial judgment as they're also looking at individual KPIs, customer research and insights, et cetera."

**Insight:** Effective collaboration in creative industries requires balancing data-driven KPIs with expert human judgment.

**Tactical advice:**
- Value expert editorial judgment alongside data
- Balance the 'art' of the product with the 'science' of metrics

*Timestamp: 01:02:21*


## Alexander Embiricos
*Alexander Embiricos*

> "Our designers... have an entire vibe coded side prototype of the Codex app... if we like it, they'll vibe engineer that prototype into an actual PR to land. And then depending on their comfort with the code base... they'll land it themselves or they'll get close and then an engineer can help them land the PR."

**Insight:** AI is 'compressing the talent stack,' allowing designers and PMs to contribute directly to production code through AI-assisted 'vibe coding.'

**Tactical advice:**
- Enable designers to build functional prototypes using AI agents
- Create a workflow where non-engineers can submit PRs that engineers then 'polish' or validate

*Timestamp: 00:46:24*


## Adam Grenier
*Adam Grenier*

> "If you approach it with that "Yes, and...", it's often still true. It's like, oh, both of these things can be true at once. You could have a different goal than I have, or you have a system problem local to you that is important to you and it's not important to me. That's okay, both things can exist. So, now that we accept both and can work off of each other, we're more likely to build both a better rapport and energy among ourselves because we're not just saying, "No, no, no, no, you're wrong.""

**Insight:** Adopting an improv-based 'Yes, and' mindset helps resolve cross-functional friction by validating different team goals simultaneously.

**Tactical advice:**
- Acknowledge that conflicting goals between teams can both be valid
- Avoid flat denials of other teams' perspectives to maintain rapport and progress

*Timestamp: 00:10:24*

---

> "If you are CMO and your product leader aren't married at the hip, you're just missing out on just tons of opportunity, and the likelihood of things actually working very well consistently and compounding on each other."

**Insight:** In product-led companies, marketing and product must be deeply integrated rather than operating as separate silos.

**Tactical advice:**
- Ensure marketing leadership and product leadership are 'married at the hip' in planning and execution
- Treat product and marketing as one integrated system rather than two different things

*Timestamp: 00:43:37*

---

> "Honestly, I think learn product development. Go learn agile product development... understanding those skills and those systems will, one, I think make you think differently about how to run your marketing team and, two, make you exponentially better at working with your product organization."

**Insight:** Marketing leaders can improve collaboration by mastering the frameworks and language used by product teams, such as Agile and sprints.

**Tactical advice:**
- Take courses in product-led growth or agile development
- Apply product development cycles (sprints) to marketing initiatives

*Timestamp: 00:50:02*


## Alisa Cohn
*Alisa Cohn*

> "Personal Operating Manual. And it helps prompt you to talk about working style together... What communication style do you like the best? How do you like to work? Do you like large uninterrupted blocks? Do you like meetings here and there? When I'm trying to get a hold of you for something important, what's the best way to do that?"

**Insight:** Sharing a 'Personal Operating Manual' reduces friction in collaboration by making implicit preferences explicit.

**Tactical advice:**
- Define your preferred communication channels for different levels of urgency
- Share your 'pet peeves' and what earns a 'gold star' with you
- Clarify your delegation style (e.g., 'check in weekly' vs. 'tell me when it's done')

*Timestamp: 01:15:21*


## Aishwarya Naresh Reganti + Kiriti Badam
*Aishwarya Naresh Reganti + Kiriti Badam*

> "A lot of old contracts and handoffs between traditional roles, like say PMs and engineers and data folks has now been broken and people are really getting adapted to this new way of working together and kind of owning the same feedback loop in a way. Because previously, I feel like PMs and engineers and all of these folks had their own feedback loops to optimize. And now you need to be probably sitting in the same room. You're probably looking at agent traces together."

**Insight:** AI products require a tighter, unified feedback loop between PMs, engineers, and data scientists, replacing traditional siloed handoffs.

**Tactical advice:**
- Have PMs and engineers review agent traces together to decide on desired product behavior.
- Unify feedback loops across functions to optimize for the same end-user outcome.

*Timestamp: 00:06:57*


## Amjad Masad
*Amjad Masad*

> "One of the things that I think is sort of hard about tech companies is these silos between designers, product managers, and engineers... the common language that everyone shares is code. Ultimately in software tech companies, everything that we're talking about need to eventually flush out in terms of code. And so what if the language becomes actually working prototypes and working applications?"

**Insight:** Code and working prototypes are becoming the 'universal language' that breaks down silos between design, product, and engineering.

**Tactical advice:**
- Use tools that translate design (like Figma) directly into code to reduce handoff friction.
- Communicate product ideas through functional prototypes rather than static mocks or text documents.

*Timestamp: 00:42:30*

---

> "You got to be fluid because again, when designers can code and engineers can design, I mean it really becomes, you can't have a lot of structure around that. So you want to build a culture and you want to build an environment or milieu that is really, really flexible, which is uncomfortable for a lot of people."

**Insight:** The rise of 'hybrid' roles (designers who code, engineers who design) requires a more fluid, less structured organizational culture.

**Tactical advice:**
- Encourage designers to attend engineering reviews and vice versa.
- Hire for 'design-engineers' who can operate across the full product spectrum.

*Timestamp: 00:58:30*


## Annie Pearl
*Annie Pearl*

> "I've certainly seen organizations or been in organizations where the product team doesn't necessarily want to be bothered by sales, but I sort of flip that on the head and say sales and sort of the go-to-market teams in general could be your biggest asset to helping you get your job done well."

**Insight:** Sales teams are a primary asset for product managers to gain customer empathy and scale their understanding of user problems.

**Tactical advice:**
- Spend time in the field with sales to understand the 'why' behind customer requests.
- Use sales feedback to identify solutions that solve problems for a broad swath of customers rather than building one-off requests.

*Timestamp: 00:29:37*


## April Dunford
*April Dunford 2.0*

> "If I've got product, marketing, and sales together in the room working on defining what our differentiated value is, then I'm going to get all the good juice out of the product team that deeply understands the product... and then I'm also going to have all the juice from the sales team that understands what the common objections are."

**Insight:** Positioning and sales pitches are most effective when they are co-created by product, marketing, and sales to ensure technical accuracy and market relevance.

**Tactical advice:**
- Form a cross-functional team to define differentiated value.
- Ensure product teams share the 'why' behind features with the sales team.
- Use sales' frontline experience to identify the most common customer objections during the positioning process.

*Timestamp: 00:37:43*


## Asha Sharma
*Asha Sharma*

> "I really believe in the concept of the full stack builder... I think it's all about the loop, not the lane here. And so I think that whatever function you are, you have to be obsessed with trying to understand the efficiency or the cost of the product, the actual rewards or system design that you're going after, the actual UI, UX."

**Insight:** The AI era demands 'polymath' builders who operate across traditional functional silos to increase velocity.

**Tactical advice:**
- Encourage PMs, engineers, and designers to understand the full 'loop' of the product, including system design and cost
- Minimize handoffs between functions to maintain high metabolism and throughput

*Timestamp: 13:15*


## Archie Abrams
*Archie Abrams*

> "It's intentionally meant to be almost at odds, and that's part of the structure of how we want to work. ... It might be, 'Hey, we're going to move the button. Hey let's run the test,' but see the short-term lift. You know we're going to monitor it long term. You know when we ship it, it's going to be high quality, high quality polish. And you trust us to make those trade-offs."

**Insight:** Healthy tension between Growth (speed/metrics) and Core Product (quality/vision) is a structural advantage if built on a foundation of mutual trust.

**Tactical advice:**
- Allow Growth teams to experiment on core surfaces provided they adhere to established quality and polish standards.
- Use long-term monitoring as a 'safety net' to resolve disagreements between short-term metric gains and long-term product integrity.

*Timestamp: 00:54:41*


## Bob Baxley
*Bob Baxley*

> "I think that design is most successful at impacting what ships at the end if design is considered phase zero of the engineering process, rather than a by product or a part of the product process."

**Insight:** Integrating design directly into the engineering workflow ensures technical feasibility and higher shipping quality.

**Tactical advice:**
- Identify 'creative technologists' in engineering who can sit with the ambiguity of early-stage design discussions.

*Timestamp: 00:26:38*

---

> "I'm like, you guys tell us what you need us to do, what the features need to be, when they need to be delivered, what the issues are, and then give us the time and space to come up with a solution to those problems."

**Insight:** Healthy collaboration requires clear boundaries where Product defines the 'what' and 'why' while Design owns the 'how.'

**Tactical advice:**
- Respect functional boundaries: PMs drive the roadmap, Designers drive the UI solution.

*Timestamp: 00:24:43*


## Cam Adams
*Cam Adams*

> "For us, product managers are really connectives. They connect the team, ideas, data, a whole bunch of different things, and it's very messy. There's no exact recipe for how to do it, but connecting these disparate areas and moving the team and the technology and our customers to a new place, a new vision is essentially what product managers do"

**Insight:** The primary role of a PM is to act as the connective tissue between disparate functions and constraints.

**Tactical advice:**
- Focus on reorienting the team around new constraints as they arise weekly
- Bridge the gap between marketing timelines and engineering shipping dates

*Timestamp: 00:27:00*


## Camille Fournier
*Camille Fournier*

> "Engineers sometimes think that they don't get the credit for their work because the PM takes all the glory and all the credit for the project that they really worked very hard on, right? So making every effort to be credit sharing and inclusive of the engineering team and giving them the opportunity to speak about their contributions when it makes sense."

**Insight:** PMs often annoy engineers by hoarding credit; the solution is to be inclusive and let engineers present their own work.

**Tactical advice:**
- Share credit explicitly with the engineering team
- Give engineers the opportunity to speak about their contributions to executives or customers

*Timestamp: 00:03:26*

---

> "When you act like they don't matter and you don't care about them and it's just like, I don't care, just like tell me when you can get this done or why is it going to take so long? My god, this just seems like such a little thing. It just shows a real lack of empathy for the work that engineers are doing and I think it really can be very off-putting."

**Insight:** A lack of empathy for technical details is a major friction point between PMs and engineers.

**Tactical advice:**
- Show respect for the complexity of engineering work even if you don't understand every detail
- Be patient when engineers explain technical constraints

*Timestamp: 00:04:05*

---

> "If you are being asked questions that you cannot answer because you just don't know or because that's something that involves a level of technical detail that only the engineers have... and you put yourself in this in-between position... I think that is very annoying and frankly, it's a waste of time for everyone."

**Insight:** PMs acting as a 'middle-person' or playing 'telephone' between stakeholders and engineers wastes time and causes translation errors.

**Tactical advice:**
- Connect stakeholders directly to engineers when technical depth is required
- Avoid defaulting to 'let me get back to you' if it happens too frequently

*Timestamp: 00:07:08*

---

> "When you take the people that are part of the project team out of the creative loop entirely, they're going to find that creative outlet somewhere else and it's actually kind of bad for the product."

**Insight:** Excluding engineers from product ideation leads them to over-engineer technical solutions as a substitute creative outlet.

**Tactical advice:**
- Involve engineers in the creative loop and product discovery
- Don't hoard all the product ideas for yourself

*Timestamp: 00:08:30*


## Brian Chesky
*Brian Chesky*

> "I've always said that the health of an organization, one simple heuristic is how close is engineering and marketing? ... you really want them being enjoined at the hip and you want engineers to be thinking about maybe how to talk about the products that they're building."

**Insight:** Tight integration between engineering and marketing ensures products are built with distribution and customer communication in mind.

**Tactical advice:**
- Ensure engineering and marketing are 'joined at the hip'
- Encourage engineers to think about product storytelling

*Timestamp: 00:11:30*


## Chip Huyen
*Chip Huyen*

> "It just be able to bring product team and engineering team, even marketing team like user acquisition, very close to each other... people are structuring, so that's more communications between previously very distinct functions."

**Insight:** AI development requires tighter integration between functions because technical evals must reflect user behavior and marketing promises.

**Tactical advice:**
- Ensure product and engineering teams co-own the metrics and evaluation frameworks
- Include marketing/user acquisition insights when designing AI guardrails and personas

*Timestamp: 00:58:44*


## Chandra Janakiraman
*Chandra Janakiraman*

> "The way to start this... is to actually form a strategy working group. This is an important concept. So the strategy working group is sort of a small team. It typically consists of engineering, product design and data at a minimum."

**Insight:** Strategy is more likely to be accepted and effective if it is co-created by a cross-functional core team rather than a solo PM.

**Tactical advice:**
- Form a core working group of Product, Engineering, Design, and Data leads
- Assign specific preparation tasks to each functional lead based on their expertise

*Timestamp: 00:18:51*


## Christine Itwaru
*Christine Itwaru*

> "Early on, we started bringing in engineers to customer meetings more and more... it's so simple and it's so effective. When we started doing it, the response from the engineering team was great and then also it helped us dig into a different side of the customer while we were on call sometimes."

**Insight:** Directly involving engineers in customer calls builds technical empathy and uncovers insights that PMs might miss.

**Tactical advice:**
- Invite engineers to join customer discovery calls as observers
- Encourage engineers to engage with customers to increase their confidence and understanding of user pain

*Timestamp: 01:02:15*


## Claire Vo
*Claire Vo*

> "I'm using CPTO for short code of running product and engineering design functionally together. There should be no debates over what's best for product or what's best for engineering... What is best for the organization?"

**Insight:** Combining product and engineering under one leader eliminates functional friction and optimizes for business outcomes rather than departmental goals.

**Tactical advice:**
- Adopt a 'no lanes' principle where roles are fluid
- Encourage engineers to write specs and PMs to understand architecture
- Optimize for the whole organization rather than individual functions

*Timestamp: 00:46:51*


## Dan Shipper
*Dan Shipper*

> "Nityesh... built a Claude Code command that just uses that prompt, and checks through the entire code base for all the copy edits, and then creates a pull request on GitHub, and then sends the pull request to Kate... suddenly your engineering team is writing marketing copy in the style you want."

**Insight:** AI can bridge functional gaps by embedding one department's 'taste' or 'style' into another department's technical workflow.

**Tactical advice:**
- Codify editorial style guides into prompts that engineers can run against the codebase to automate copy reviews

*Timestamp: 00:34:33*


## Dylan Field
*Dylan Field*

> "The best PMs, I think again, create those frameworks that bring everyone else along and those frameworks also have a point of view and a strategy associated with them. So you're able to take the strategy, take the point of view, wrap it all up in a framework, and then make it so that everyone knows what the destination is and how to get there."

**Insight:** PMs facilitate collaboration by synthesizing strategy into clear frameworks that align engineering and design on a shared destination.

**Tactical advice:**
- Develop a point of view and strategy before attempting to align the team
- Wrap strategy into a framework that clearly defines the 'destination' for all functions

*Timestamp: 22:20*

---

> "The trend that we've been seeing for the past five years is the trend that is going to accelerate in the next five years, and that's a shift in emerging of roles... We're all product builders and some of us are specialized in our particular area."

**Insight:** The future of product development involves the merging of roles into a unified 'Product Builder' identity.

**Tactical advice:**
- Encourage non-designers to engage in design tasks like prototyping or brand exploration
- Hire for 'high judgment' and generalist abilities alongside deep specialization

*Timestamp: 01:06:06*


## Elena Verna
*Elena Verna 2.0*

> "In the product-led sales, product acquires and activates a customer and product creates pipeline for sales... the collaboration here is between product and sales, but that means the product has to take on accountability over pipeline."

**Insight:** Product-led sales requires Product to move beyond 'feature factory' mode and take accountability for the sales pipeline.

**Tactical advice:**
- Establish a handshake between Product and Sales regarding PQA (Product Qualified Account) definitions
- Align product leadership behind monetization KPIs like free-to-paid conversion or PQA volume

*Timestamp: 00:55:19*


## Emily Kramer
*Emily Kramer*

> "It's like how do you get the marketing to product handoff right? And if it means you have someone that owns onboarding, it's in a hybrid role, then great. If it means there's a committee sort of situation with one person at the DRI, that's great too. So I think my answer is, I don't think there's one way to structure it, it's just highly dependent on the company overall. And I think you need both skill sets."

**Insight:** In PLG companies, the 'marketing-to-product handoff' is as critical as the 'marketing-to-sales handoff' in traditional models.

**Tactical advice:**
- Ensure the signup flow and onboarding experience feel consistent with the marketing messaging.
- Coordinate transactional product emails with marketing drip campaigns to avoid overwhelming the user.

*Timestamp: 00:35:24*


## Gaurav Misra
*Gaurav Misra*

> "We'll first design something without even having any idea of what or why we're doing it, but we'll design a bunch of different things and then we'll sit down with the PMs and look at the designs and just go over one and the next."

**Insight:** Reversing the traditional PM-to-Design flow can lead to discovering unique product opportunities that metrics-first approaches miss.

**Tactical advice:**
- Try 'Design-first' sessions where designers explore visual possibilities before a formal spec is written.
- Have PMs and Designers review visual explorations together to spark new roadmap ideas based on what is visually possible.

*Timestamp: 00:26:17*


## Howie Liu
*Howie Liu*

> "I just think that that concept of collapsing roles, everybody needs to become more full stack to do the ... being more outcome-oriented... I just think it's a new operating mentality overall for every AI native company"

**Insight:** Collapse traditional role silos to create 'full-stack' operators who can drive outcomes with fewer dependencies.

**Tactical advice:**
- Encourage PMs to become 'hybrid PM prototypers' with design sensibilities
- Expect engineers to think about product and business requirements
- Train AEs to be 'SE fluent' so they can demo products without dependencies

*Timestamp: 01:11:21*


## Jiaona Zhang
*Jiaona Zhang*

> "One of the biggest things we've been tweaking is like how do we do more of a tech spike at the beginning to be like, 'Do we have a good sense of how difficult this is going to be? The unknowns? ... another problem could be like, 'Hey, it's just so difficult to work with cross-functional partners and doing a little tweak in the process where you bring them in a kickoff meeting.'"

**Insight:** Improve execution by involving engineering early via tech spikes and ensuring all stakeholders are aligned during a formal kickoff.

**Tactical advice:**
- Run tech spikes early to identify technical unknowns and difficulty
- Use kickoff meetings to align cross-functional partners and improve team dynamics
- Adjust collaboration processes based on the specific friction points of the team

*Timestamp: 01:03:40*


## Jonathan Becker
*Jonathan Becker*

> "Performance marketing and brand marketing in a lot of organizations are two different things. And the designers that occupy brand teams bandwidth and whatnot often don't have a sense of how paid acquisition works. And so one of the pitfalls of working with certain companies or the mistake that they make is the design team will hand off a file full of random assets for paid acquisition without any sense of how the channel works."

**Insight:** Performance and brand teams must be integrated to ensure creative assets are optimized for specific ad channel mechanics.

**Tactical advice:**
- Ensure design teams understand the specific requirements of paid acquisition channels
- Create a feedback loop where performance data drives creative iteration

*Timestamp: 00:34:48*


## Judd Antin
*Judd Antin*

> "The solution is simple but not easy to me. It's that we need to restructure the way we make products in a way which integrates research much more fully. It looks like consistent relationships in which researchers, and the work, and the insights they provide are a part of the process from beginning to end."

**Insight:** Research should be an integrated partner throughout the product lifecycle, not a reactive service function called in at the end.

**Tactical advice:**
- Integrate researchers into a unified, lean product process from the start.
- Move away from treating research as a 'service discipline' that only validates finished designs.

*Timestamp: 00:14:51*


## Julie Zhuo
*Julie Zhuo 2.0*

> "We need to dissolve the boundaries of these traditional roles... we can drop all of these different role distinctions and call ourselves builders. I think that's sort of the most general purpose way of thinking about what we can all be."

**Insight:** AI allows individuals to take on tasks outside their traditional roles, leading to smaller, more versatile teams of 'builders'.

**Tactical advice:**
- Encourage team members to use AI to supplement skills outside their core discipline (e.g., engineers doing data analysis).

*Timestamp: 00:15:34*


## Katie Dill
*Katie Dill*

> "We have design and engineering and our product partners and product marketing work really, really closely on this. Actually, it's one of the few teams where all of these things report, well, not all of them, but most of those functions report into one place. So, engineering and design actually all report up into the design organization when they work on the website. Together, quite literally, as we were talking about earlier, if we were physically together, they would be sitting side by side and they're batting ideas back and forth."

**Insight:** Tight integration between design and engineering, sometimes even reporting into the same org, accelerates the quality of execution.

**Tactical advice:**
- Have engineers and designers sit side-by-side to enable rapid iteration cycles
- Consider unified reporting lines for high-craft surfaces like the company website

*Timestamp: 00:27:49*


## Kayvon Beykpour
*Kayvon Beykpour*

> "One of my biggest points of feedback and points of consternation was the structure of the company in that we had a functional organizational model... the combination of that model and the type of leader that Jack was wasn't working in my view. I think if you're going to have a functional organization, you need to have a GM or a CEO who's extremely leaned-in to tiebreak and resolve conflict."

**Insight:** Functional organizations require highly active leadership to resolve the inevitable deadlocks between opinionated heads of product, engineering, and design.

**Tactical advice:**
- If using a functional model, ensure there is a clear, 'leaned-in' tiebreaker to prevent consensus-driven stagnation.

*Timestamp: 00:12:23*


## Ken Norton
*Ken Norton*

> "The people side of this is such an incredible aspect of what product management is. What I find... is people realizing that when they're put in a position where they're expected to have impact and realizing that they haven't developed the skills, they haven't developed the capability to actually be able to manage and work through all these people."

**Insight:** Senior product leadership is almost entirely about people management and cross-functional influence rather than technical product work.

**Tactical advice:**
- Recognize that you are a leader from day one, even without formal authority
- Practice leading without authority early in your career to sharpen collaboration skills

*Timestamp: 00:44:47*


## Karri Saarinen
*Karri Saarinen*

> "I think a lot of that, this craft for us happens when we give the project team this ownership and the project team is just engineering and design. Then, when they start building that feature they start seeing these opportunities that this thing could be better."

**Insight:** High-quality execution occurs when small, autonomous teams of engineers and designers have full ownership of a feature without excessive middle management.

**Tactical advice:**
- Form project teams consisting only of engineering and design to increase ownership.
- Empower engineers to identify and fix UX 'paper cuts' during the implementation phase.

*Timestamp: 00:15:11*

---

> "Yes, for every project there's a project lead. That lead can be engineer or designer. It's not a formal role or it's not based on your whatever level... It's more like an assignment that now you are responsible getting the project started and working together with the team, figuring it out, and then communicating changes or communicating how that progress happens."

**Insight:** Project leadership should be a fluid assignment based on the project's needs rather than a fixed management title.

**Tactical advice:**
- Assign a 'Project Lead' for every initiative, regardless of whether they are an engineer or designer.
- Task the lead with scoping, progress communication, and cross-functional alignment.

*Timestamp: 00:19:35*


## Kevin Weil
*Kevin Weil*

> "The best products are going to be ENG product design and research working together as a single team to build novel things. So that's actually how we're trying to operate with basically anything that we build."

**Insight:** Effective AI development requires breaking down the silos between research and product engineering to create a continuous feedback loop.

**Tactical advice:**
- Embed researchers directly into product teams
- Ensure researchers, engineers, and PMs collaborate on fine-tuning and eval creation

*Timestamp: 00:47:17*


## Kevin Yien
*Kevin Yien*

> "PM should be doing everything in their power to draw the perimeter of the space, of the problem space. And it's within that, eng, design, everyone else that you're working with, they can go as crazy as they want, push up against the bounds and it's fill the box to its maximum capacity."

**Insight:** The PM's role is to define the constraints (the perimeter) so that engineers and designers can maximize their creative potential within a safe space.

**Tactical advice:**
- Apply as many reasonable constraints as possible to remove unnecessary decisions for the team.
- Embrace 'murky overlaps' between roles rather than strict, siloed swim lanes.

*Timestamp: 00:21:03*


## Marily Nika
*Marily Nika*

> "You will need to get comfortable with having a partner that's a research scientist and you will need to understand that these people can produce a smart model. They'll be able to do some automation, some personalization, some recommendations on. In a lot of people, truly uncomfortable, a lot of people don't know how to approach the researchers."

**Insight:** Successful AI PMs must learn to bridge the gap between product goals and the experimental nature of research science.

**Tactical advice:**
- Shadow research scientists to understand their workflow and the constraints of model building.
- Learn to manage the uncertainty inherent in research-heavy projects.

*Timestamp: 00:09:35*


## Maggie Crowley
*Maggie Crowley*

> "You can't be a good PM if you're not willing to do the hard boring unglamorous work of customer support, sales, marketing, writing, copy, project management, you have to do that stuff."

**Insight:** PMs must act as the 'gap fillers' for the team, taking on any task necessary to ensure the product's success.

**Tactical advice:**
- Join sales calls to support the go-to-market effort
- Help with customer support or implementation to understand user pain
- Take responsibility for 'unowned' tasks like writing copy or QA

*Timestamp: 00:08:43*


## Marty Cagan
*Marty Cagan*

> "Second, product manager needs unencumbered access to the engineers. If you're not working every day with a set of engineers on solving problems, you are not a product manager. So again, there's these helpful people called product owners or project managers or all kinds of different variations where they think their job is to interface with the developers and to play a mediator role."

**Insight:** Innovation requires daily, direct collaboration between PMs and engineers without intermediaries.

**Tactical advice:**
- Work directly with engineers every day on problem-solving
- Remove project managers or 'product owners' who act as mediators between PMs and Eng

*Timestamp: 00:50:47*


## Melissa Tan
*Melissa Tan*

> "We created a flying formation when we were first starting the growth team at Webflow... product growth is accountable for all the metrics downstream of signups. Growth marketing is accountable for signups. They're also driving or have goals around CAC."

**Insight:** A 'flying formation' document defines clear boundaries and operating rhythms between growth, marketing, and product teams.

**Tactical advice:**
- Document which team owns which specific stage of the user funnel
- Establish a weekly meeting to review shared metrics across functions
- Define quarterly planning cadences where teams identify collaborative projects

*Timestamp: 00:55:50*


## Nan Yu
*Nan Yu*

> "You're taking the building side of the organization and the selling side of the organization and bringing it together. You're taking all of the commercial motivations and goals of the company and making sure that what you build actually solves for those goals... it's the PM in the middle, and then you have engineering, product design, and then sales, marketing, product management on the other side."

**Insight:** The PM's role is to bridge the 'Double Triangle'—connecting the builders (Eng/Design) with the sellers (Sales/Marketing).

**Tactical advice:**
- Act as the connective tissue between commercial goals and technical possibilities.
- Ensure the product team understands the 'native language' of the customer to help marketing and sales.

*Timestamp: 01:01:18*


## Nikita Miller
*Nikita Miller*

> "The exercise that I often do is I generally have an idea of what I think the roles and responsibilities are and the expectations across these four roles, but the exercise especially with leaders in an org is to have them sit down and write them for each other."

**Insight:** Alignment is best achieved when cross-functional leaders define their expectations of one another rather than just their own roles.

**Tactical advice:**
- Have PM, Design, Engineering, and Data leaders write down expectations for their counterparts
- Create a 'contract' between roles to clarify shared responsibilities
- Revisit these definitions every 3-6 months or when execution friction arises

*Timestamp: 17:29*

---

> "I as a product manager, I write what I think my role is and also what I think what my expectations of my counterparts are and they do the same, and then we review it together."

**Insight:** A collaborative review of role expectations prevents the 'everything falls on the PM' trap.

**Tactical advice:**
- Differentiate between IC expectations and manager expectations within the triad
- Identify shared responsibilities, such as who leads evangelism or experiment analysis

*Timestamp: 19:11*

---

> "if you have someone that's dedicated to a zone or an area of the product, then it's much easier for them to spot patterns as opposed to attempting to understand what's happening every time a ticket comes in."

**Insight:** Embedding data scientists directly into product teams (the 'quartet') reduces friction and improves domain expertise compared to a centralized model.

**Tactical advice:**
- Embed data analysts or scientists into specific product squads to avoid them becoming a bottleneck

*Timestamp: 22:45*


## Ryan Singer
*Ryan Singer*

> "You bring that person together with the product person who deeply understands the backstory... And then a designer in the room and they’re whiteboarding and wrestling with each other to get to what’s a version of this thing that we believe in that’s real that we can actually finish in that time."

**Insight:** Effective shaping requires the simultaneous presence of product, design, and engineering expertise to resolve conflicts in real-time.

**Tactical advice:**
- Include a 'grumpy old plumber' (senior engineer) in shaping sessions to identify technical 'time bombs' early.
- Use live whiteboarding sessions to 'wrestle' with ideas until they are both technically feasible and valuable.

*Timestamp: 00:34:12*


## Seth Godin
*Seth Godin*

> "I discovered that the engineers, the development team, they had a lot of people vying for their time. And if I didn't figure out how to get them to give me way more than my fair share of development, I wasn't going to have any products to make next Christmas and then I was going to be out of a job."

**Insight:** Success as a product manager often depends on influencing teams you don't formally manage to prioritize your projects.

**Tactical advice:**
- Find creative ways to earn the attention and loyalty of the engineering team.
- Ensure you have a clear plan to secure development resources before deadlines approach.

*Timestamp: 11:46*


## Teresa Torres
*Teresa Torres*

> "The trio is the product manager, the designer, and the software engineer. If you've never worked in a well-functioning trio, this breaks people's brains, because they say, 'Well, what are we going to do when we disagree?' You're going to find an option where you don't disagree."

**Insight:** True collaboration involves a 'product trio' working from a shared understanding rather than siloed decision-making.

**Tactical advice:**
- Include PM, Design, and Engineering in the discovery process together
- Resolve disagreements by seeking more data or better options rather than pulling rank

*Timestamp: 33:37*


## Tim Holley
*Tim Holley*

> "we've evolved that to five legs of the stool... product eng design and we've got our insights partners. So research and analytics, and we've got our marketing partners really working in a tight team to build the best products possible... treating that as the core leadership team I think is really valuable."

**Insight:** Expanding the traditional 'three-legged stool' to include research, analytics, and marketing ensures all constraints are considered early.

**Tactical advice:**
- Include research, analytics, and marketing as core members of the squad leadership team.
- Avoid the 'PM as mini-CEO' model in favor of collaborative decision-making.

*Timestamp: 00:55:31*


## Upasna Gautam
*Upasna Gautam*

> "I've made it a point to bring in my tech lead and engineers along for this product discovery ride... When our engineers are able to understand our journalists' needs at the same level as we are, they're able to define the how to do it with so much greater clarity and precision."

**Insight:** Involving engineers early in the discovery process improves technical feasibility and solution design.

**Tactical advice:**
- Embed tech leads in user testing sessions and design jams
- Treat engineers as partners in the 'why' and 'what,' not just resources for the 'how'

*Timestamp: 21:46*


## Vijay
*Vijay*

> "We said, 'Hey, we can actually do the next three months of projects about any design,' which was a kind of controversial thing to say, 'but we're doing this so that you can take three months with a set of designers and go think about the system architecture of the product, and we'll wait for that to be done before we do any architectural things that might impact the architecture.'"

**Insight:** To achieve high-quality design, decouple designers from tactical execution for a set period to allow for deep architectural thinking.

**Tactical advice:**
- Give design teams 'breathing room' by running engineering-only tactical sprints
- Dedicate specific time blocks for designers to work on system architecture without the pressure of immediate feature delivery

*Timestamp: 16:15*


## Yuhki Yamashata
*Yuhki Yamashata*

> "I really see it as this partnership to enable that much as possible. And I think that's what, to me, product growth looks like at Figma, is that. ...the face of Figma is not the sales team, but in fact, it's the internal designer. And so that's the mental model that I think we've been using it. We're fortunate enough to have people inside companies who are so passionate to want to play that role. And so when you take that lens on, then you start to understand, okay, how can we help set this person up for success?"

**Insight:** Product and Sales should collaborate to turn internal users into 'superheroes' who can effectively evangelize the product within their own companies.

**Tactical advice:**
- Equip sales teams with product roadmaps to share with champions
- Focus sales efforts on empowering the internal advocate rather than just selling to the buyer
- Ensure sales teams have high product credibility to hold their own with expert users

*Timestamp: 00:53:47*


## Garrett Lord
*Garrett Lord*

> "We pick the best person who's most capable of driving an initiative forward, regardless of the function to be the DRI. We're a lot more metrics-oriented."

**Insight:** Effective cross-functional execution relies on assigning Direct Responsible Individuals (DRIs) based on capability rather than functional hierarchy.

**Tactical advice:**
- Assign project leads based on who is most capable of driving the specific outcome
- Maintain a flat structure where functional roles don't dictate project ownership

*Timestamp: 00:52:00*


## Ebi Atawodi
*Ebi Atawodi*

> "Do you know your engineering manager's birthday? It's the day they showed up in the world. It's the most important day for them... Do you know their work anniversary? Do you know why they're doing the job they're doing or what they want to be?"

**Insight:** Strong cross-functional partnerships are built on personal human connection and understanding the motivations of your partners.

**Tactical advice:**
- Learn your engineering manager's birthday and work anniversary
- Understand your partner's career goals (e.g., do they want to be a VP or start a company?) to better support them

*Timestamp: 01:24:36*


## Jeanne Grosser
*Jeanne Grosser*

> "I also believe that the best go-to-market orgs on the planet are equal parts revenue driving and R&D... if we can do an excellent job of translating all of that feedback into signal and then feeding that into the road map, we can be actually an extension of the product management org."

**Insight:** Sales should function as an R&D arm, providing high-fidelity customer signals to the product team.

**Tactical advice:**
- Train sales teams to discern signal from noise to provide actionable feedback for the product roadmap.

*Timestamp: 01:10:59*


## Keith Yandell
*Keith Yandell*

> "They will apply a first principles product mindset to their understanding of the law, and they will push the lawyers to make sure that they're not being overly conservative, which sometimes they can be."

**Insight:** Product leaders should learn the basics of legal and regulatory constraints to push back on over-conservatism using first principles.

**Tactical advice:**
- Develop a general understanding of the regulations affecting your specific consumer or SaaS business
- Engage with legal teams with curiosity to understand the 'why' behind constraints

*Timestamp: 53:51*


## Naomi Gleit
*Naomi Gleit*

> "A PM is a conductor. It's as though the team that you are a PM on is an orchestra. There are many different functions in your team that includes legal policy, comms, data analytics, engineering, design... your job is to make sure everyone's playing their part correctly, every section in the orchestra is playing their part, but at the same time, they're playing together"

**Insight:** The PM's role is to orchestrate diverse functions to ensure they work in harmony and at the correct tempo without being the 'star' of the show.

**Tactical advice:**
- Focus on keeping the team in sync and at the right cadence rather than doing the functional work yourself
- Ensure every function (legal, policy, eng, etc.) understands how their part fits into the whole

*Timestamp: 00:45:52*


## Nickey Skarstad
*Nickey Skarstad*

> "Slack has this really great feature called huddles where you can just quickly get on. It's just audio. So there's no video. And you can just have a 30 second conversation. It's good for standups and things like that... trying to be asynchronous, using Slack, making sure you're following up in very visible ways where people can see."

**Insight:** Remote collaboration requires intentional use of lightweight, asynchronous, and audio-only tools to replace 'water cooler' moments.

**Tactical advice:**
- Use Slack Huddles for quick, low-friction standups or syncs
- Prioritize asynchronous updates to avoid 'Zoom fatigue'

*Timestamp: 00:55:21*


## Scott Belsky
*Scott Belsky*

> "One of my obsessions has been bringing design earlier into the process of product development... Having the designer hear these things and contribute gives them a golden gut as they are then sitting down later and going through possible interfaces to solve the problem."

**Insight:** Involving designers in early-stage research and strategy discussions builds the intuition they need to make superior interface decisions later.

**Tactical advice:**
- Bring designers into the room for customer research and high-level value proposition debates
- Collapse functional boundaries so designers have the same context as product managers from day one

*Timestamp: 00:35:18*


## Tamar Yehoshua
*Tamar Yehoshua*

> "Make sure you go somewhere where you have a good engineering partner. Because if you have great ideas of what to build but you can't get them built, then you go nowhere. So that has to be part of your evaluation criteria that you meet and value your engineering partner before you join. And then I think what's really important is that you're aligned. You understand your roles and responsibilities and where you're going to divide and conquer and where you're going to be aligned. You don't want any of this ... Like people in the organization, they ask mom, they asked dad and they got different opinions and playing one against the other. That doesn't work."

**Insight:** Success depends on a strong, aligned partnership with engineering where roles are clear and leadership presents a united front.

**Tactical advice:**
- Evaluate the engineering partner as part of your job interview criteria.
- Explicitly define which leader drives which domain to avoid 'mom and dad' syndrome.
- Conduct all major reviews (OKRs, exec reviews) together to ensure alignment.

*Timestamp: 00:00:00*

---

> "If somebody would ask me something that it was in Cal's domain, I'd be like, 'Did you talk to Cal?' I would never try and go around him. So we were very clear on, you're going to drive this, I'm going to drive this. And if it was unclear, we'd talk and we would say, 'Okay. Who's going to take this one?'"

**Insight:** Maintaining respect for a partner's domain prevents organizational confusion and builds trust.

**Tactical advice:**
- Redirect questions that fall into your partner's domain back to them.
- Discuss ambiguous ownership areas privately to decide who will lead.

*Timestamp: 00:39:29*


## Varun Parmar
*Varun Parmar*

> "We call our org, it's called AMPED, A-M-P-E-D. This is actually going back to our earlier point... removing barriers or silos cross-functionally. AMPED stands for analytics, marketing, product, engineering and design."

**Insight:** True product organizations should include marketing and analytics as core members, not just supporting functions.

**Tactical advice:**
- Embed product marketing deeply within product 'streams' to ensure positioning is considered during early development.
- Define the 'product org' as a multi-disciplinary unit (AMPED) rather than just PMs, designers, and engineers.

*Timestamp: 00:17:46*

---

> "My fundamental approach to solving that is to ensure that the product leads who are working on these capabilities can instantly raise their hand and call out that there are challenges that they are running into. Then the job of the leadership team... is to essentially go and quickly resolve those issues."

**Insight:** The primary role of product leadership is to act as a rapid-response unit for unblocking teams.

**Tactical advice:**
- Create a culture where raising a hand for help is seen as a strength, not a failure.
- Focus leadership time on resolving organizational, technical, or priority roadblocks identified by feature teams.

*Timestamp: 00:34:52*


## Will Larson
*Will Larson*

> "My biggest advice to both the EMs and the PMs, is before you try to solve the conflict, it's like pushing to ship this feature, pushing to change the approach. Just make sure you actually understand what they care about... if you really deeply understand what everyone wants, there's usually a compromised solution that gives everyone exactly what they want."

**Insight:** Effective collaboration between engineering and product requires deep empathy for the other's constraints before attempting to resolve conflicts.

**Tactical advice:**
- Dig deeper into the 'true needs' of your partner, which are often not what they are explicitly saying
- Avoid the 'victim/villain' mindset when peers make decisions you disagree with

*Timestamp: 00:43:17*

---

> "I think this idea that same perf rating for both drives a level of one pain, but the right perspective... you all get graded the same score based on your ability to evaluate and solve for the entire set of constraints, not just your functional constraints."

**Insight:** Shared performance ratings for EM/PM pairs force alignment on business outcomes rather than functional silos.

**Tactical advice:**
- Calibrate performance reviews for EM and PM peers together
- Grade leaders on their ability to solve for the entire set of business constraints

*Timestamp: 00:44:56*


