---
name: defining-product-vision
description: Help users create compelling product visions. Use when someone is writing a vision statement, defining a long-term product direction, aligning teams on the future state, or distinguishing vision from strategy.
---

# Defining Product Vision

Help the user create compelling product visions using frameworks from 101 product leaders who have defined visions at companies from Notion to Airbnb to the New York Times.

## How to Help

When the user asks for help with product vision:

1. **Clarify the scope** - Determine if they need a vision (long-term aspiration), strategy (how to win), or roadmap (what to build)
2. **Focus on the user's future** - Help them describe the world 5-10 years out, not the product features
3. **Test for specificity** - Push back on vague taglines that don't change behavior
4. **Make it visual** - Encourage prototypes and concrete artifacts over abstract documents

## Core Principles

### Vision is not a tagline
Melissa Perri: "I once asked all the executive team at a healthcare company, what's the vision for this company? And they said, to be the backbone of healthcare. And I said, what does that mean? And they couldn't elaborate." A vision must be a concrete description of what the company will manifest in 5-10 years.

### Four criteria for strong vision
Ebi Atawodi: "It has to be lofty, it has to be realistic, it has to be devoid of any tech or limitations of today, and it has to be grounded in a very clear and potent problem." Balance aspiration with attainability while ignoring current technical constraints.

### Hide radical vision in familiar utility
Ivan Zhao (Notion): "Our realization is actually let's hide our vision, which is everybody can create their software, in the form factor that people do care. So what kind of tool do people use every day? Productivity software." Package a radical long-term vision inside a familiar, high-utility form factor.

### Vision describes the user's world, not your product
Ben Williams: "The vision is the nirvana state that you aim to enable for your users and customers in five to 10 years... It should not mention your company, your product, or anything solution related at all." Prefix vision statements with 'In the future...' to maintain long-term focus.

### Move from 'what' to 'why'
Chip Conley: "Ultimately, we came up with the idea that we were in the belong anywhere business. Airbnb was not in home sharing, we were in belonging anywhere." A powerful vision moves beyond the functional 'what' to the emotional 'why.'

### Use visual artifacts
Cam Adams (Canva): "We need mock-ups. We need prototypes. You need to get that idea out of your head and present it in a visual form that helps you talk about and communicate about it." Communicate vision through tangible prototypes, not just abstract documents.

### Vision guides decentralized decisions
Ami Vora: "If we all agree that the feeling of something should be, I'm sitting in Dolores Park with my friends on a sunny Saturday, then people will just naturally build something that feels more consistent." Use emotional metaphors to create a shared understanding that guides decisions without micromanagement.

### Strategy forces choice
Chandra Janakiraman: "Product strategy sits between the mission and vision and the plan... It forces choice to deploy scarce resources to generate maximum impact." Strategy is the connective tissue between the aspirational vision and the tactical roadmap.

## Questions to Help Users

- "If you can't elaborate on your vision in specific terms, is it actually a vision or just a tagline?"
- "What does the world look like in 5-10 years if you succeed?"
- "What user problem is so potent that it makes you 'batshit crazy' that it still exists?"
- "Can someone on your team make a good decision using only your vision as a guide?"
- "What would your product look like if you didn't have today's technical constraints?"
- "What's the emotional state you want users to feel?"

## Common Mistakes to Flag

- **Vague taglines** - "Be the backbone of healthcare" without specific elaboration
- **Feature lists as vision** - Describing what you'll build, not what user's lives will be like
- **Mentioning the product** - Vision should describe the user's world, not the solution
- **Ignoring current constraints** - Good vision transcends today's technology limitations
- **No behavioral change** - If the vision doesn't change team priorities, it's not useful

## Deep Dive

For all 143 insights from 101 guests, see `references/guest-insights.md`

## Related Skills

- Writing North Star Metrics
- Prioritizing Roadmap
- Setting OKRs & Goals
- Competitive Analysis
