---
name: delegating-work
description: Help users delegate effectively. Use when someone is struggling to let go of tasks, deciding what to delegate, building team autonomy, or balancing being hands-on vs hands-off.
---

# Delegating Work

Help the user delegate effectively using frameworks from 38 product leaders who have scaled themselves and their organizations.

## How to Help

When the user asks for help with delegating:

1. **Diagnose the blocker** - Determine if they're holding on due to identity, control, or lack of trust
2. **Identify what to delegate** - Use energy audits and the Eisenhower Matrix to find candidates
3. **Match delegation style to context** - Help them calibrate between autonomy and involvement
4. **Design for success** - Set up the delegation with context, parameters, and feedback loops

## Core Principles

### Context, not control
Ray Cao: "The number one thing is context, not control. That's the reason why we're always encouraging people to see themselves as a business owner." Provide all necessary information so employees can 'connect the dots' themselves rather than waiting for instructions.

### Refuse to rule
Boz: "One of the most powerful things we do is refuse to rule. Someone will bring me a thing. I'll be like, 'Nope, but look, I think you've got it.'" Intentionally step back when the team is struggling with the 'right' problems to build their autonomy.

### Give away your Legos
Cam Adams: "Finding joy in the other things of building a team, passing on your experience, helping other people do great writing or great product building is really what giving away your Lego is about." Find fulfillment in enabling others to succeed rather than holding onto tasks for personal identity.

### Being in details is not micromanagement
Brian Chesky: "There's a difference between micromanagement, which is like telling people exactly what to do, and being in the details. If you don't know the details, how do you know people are doing a good job?" Deep involvement ensures quality; micromanagement prescribes every action.

### Don't delegate your superpower
Brian Chesky (citing Ben Horowitz): "A lot of people tell product led founders to step away and delegate their product to other people, but suddenly they've delegated away the thing they're best at. The thing that is hardest for them to replace." Retain direct involvement in your core competency.

### Doer to editor transition
Fareed Mosavat: "You have to shift from, 'My job is to do the work,' to, 'My job is to make the work better. My job is to plus the work, to review the work.'" The transition to management requires becoming an editor, not just a delegator.

### Use selective micromanagement
Ravi Mehta: "If you don't feel confident in the direction that your team is moving, the right answer is not to be hands-off. The right answer is to micromanage, but do it in a very tactical and a very temporary way." Know when to step in deeply and when to pull back.

### Six-month calibration test
Peter Deng: "In 6 months, if I'm telling you what to do, I've hired the wrong person. The meta goal becomes, are we calibrating enough? Are we getting into a spot where you're the one telling me what needs to be done?" Effective delegation means the report drives the work within six months.

## Questions to Help Users

- "What tasks are you holding onto because of identity rather than necessity?"
- "If you did an energy audit, which calendar items would be red (draining)?"
- "Does this task need to be done, can someone else do it, or can you change the methodology?"
- "Are you giving context and parameters, or prescribing every step?"
- "In six months, will this person be telling you what to do, or still waiting for direction?"

## Common Mistakes to Flag

- **Delegating your superpower** - Giving away the core competency that's hardest to replace
- **All-or-nothing thinking** - Believing you must either micromanage or be completely hands-off
- **Delegating without context** - Expecting results without giving the information needed to succeed
- **Failing to teach** - Not investing time upfront to train people, then being overwhelmed
- **Overdelegating early** - Hiring senior executives too soon when founders should stay in the weeds

## Deep Dive

For all 46 insights from 38 guests, see `references/guest-insights.md`

## Related Skills

- Running Effective 1:1s
- Having Difficult Conversations
- Managing Up
- Running Decision Processes
