# Delegating Work - All Guest Insights

*38 guests, 46 mentions*

---

## Ben Horowitz
*Ben Horowitz*

> "managerial leverage means it is very simple... If I am kind of pushing you to kind of move your organization forward, then that's no leverage. What's leverage is if you're telling me what you should do and how you can push the company forward, that's leverage, then I'm getting more than I'd have if you weren't there"

**Insight:** True delegation (leverage) occurs when a report drives their own department's progress without constant prompting from the leader.

**Tactical advice:**
- Evaluate reports based on whether they are bringing ideas to you or waiting for your direction
- Consider a change if you find yourself constantly asking 'why aren't we doing this?'

*Timestamp: 00:27:08*


## Boz
*Boz*

> "One of the most powerful things we do is refuse to rule. Someone will bring me a thing. A lot of times we feel obligated to weigh in and help. I'll be like, 'Nope, but look, I think you've got it. I think the challenges you're facing are the right challenges.'"

**Insight:** Effective delegation involves intentionally stepping back when the team is struggling with the 'right' problems to build their autonomy.

**Tactical advice:**
- Explicitly tell reports when you are 'refusing to rule' to empower their decision-making.
- Differentiate between 'on assignment' work (low flexibility) and 'high flexibility' areas.

*Timestamp: 00:15:09*

---

> "Mark, we joke inside of Meta, to this day, we call it the eye of Sauron. When Mark has determined that the thing that you're working on is the most important thing, there is no detail too small for him to notice."

**Insight:** Leaders should oscillate between high-level strategy and deep-detail involvement based on the criticality of the project.

**Tactical advice:**
- Identify the 'hinge' upon which success or failure happens and go deep into those specific 'weeds'.
- Use the 'Eye of Sauron' approach selectively for the company's most vital priorities.

*Timestamp: 00:31:17*


## Cam Adams
*Cam Adams*

> "I run everyone through the culture of Canva. One of those sections is on giving away your Lego, finding joy in the other things of building a team, passing on your experience, helping other people do great writing or great product building or great engineering."

**Insight:** Delegation is about finding fulfillment in enabling others to succeed and scale rather than holding onto tasks for personal identity.

**Tactical advice:**
- View scaling as a multiplier where you must change your own role to handle increased complexity
- Pass on experience to help others achieve high-quality output in writing, product, or engineering

*Timestamp: 00:00:12*

---

> "Finding joy in the other things of building a team, passing on your experience, helping other people do great writing or great product building or great engineering is really what giving away your Lego is about. And we still encourage everyone to do that, to think about those moments where they need to level up in their impact, how they can bring their team along with them, how they can pass on their experience and help everyone really have a tremendous impact with the skills that they have."

**Insight:** True leadership growth requires transitioning from individual execution to coaching and system-building.

**Tactical advice:**
- Identify pivot points where you need to move from a contributor role to a coach role
- Focus on building systems and processes that allow the work to scale beyond your own capacity

*Timestamp: 00:18:56*


## Camille Fournier
*Camille Fournier*

> "I also think people don't delegate enough. So, if you don't delegate, then you get overwhelmed because your team doesn't know how to do anything, because you haven't bothered to spend the time delegating, which actually takes more time initially, usually, you have to teach people whatever it is that you're trying to get them to do."

**Insight:** Failure to delegate prevents leadership scaling and stunts team growth.

**Tactical advice:**
- Invest time upfront to teach others tasks so you can offload them later
- Delegate to empower team members and give them opportunities to show their capabilities

*Timestamp: 00:47:37*


## Brian Chesky
*Brian Chesky*

> "There's this negative term called micromanagement. I think there's a difference between micromanagement, which is like telling people exactly what to do, and being in the details. Being in the details is what every responsible company's board does to the CEO. That doesn't mean the board is telling them what to do. But if you don't know the details, how do you know people are doing a good job?"

**Insight:** Effective leadership requires deep involvement in details to ensure quality and accountability, rather than blind delegation.

**Tactical advice:**
- Distinguish between micromanagement and being in the details
- Use detail-oriented reviews to verify performance

*Timestamp: 00:00:00*

---

> "I remember reading a blog post by Ben Horowitz saying that a lot of people tell product led founders or engineering led founders to step away and delegate their product to other people, but suddenly they've delegated away the thing they're best at. The thing that is hardest for them to replace."

**Insight:** Founders should avoid delegating their core competency, especially product leadership, as it is the hardest value to replace.

**Tactical advice:**
- Retain direct involvement in the company's core competency (e.g., product)
- Avoid delegating the 'thing you are best at' just because of growth

*Timestamp: 00:16:59*


## Carole Robin
*Carole Robin*

> "Leaders often believe... that they have to have all the answers... I believe a leader's job is to ensure the best answer is found. It doesn't matter whether it comes from me or anywhere else in the organization."

**Insight:** Effective delegation involves letting go of the need to be the primary problem-solver.

**Tactical advice:**
- Resist the urge to give immediate advice; instead, act as a 'thought partner'.
- Ask questions to help the other person explore options rather than providing the solution.

*Timestamp: 01:10:49*

---

> "The worst thing a leader can do is make an organization too dependent on them. If you care about building a sustainable long-term organization and a legacy, then it behooves you not to make the organization very dependent on you."

**Insight:** True leadership is measured by the organization's ability to function effectively in the leader's absence.

**Tactical advice:**
- Slowly transfer responsibilities to team members to build their capacity.
- Avoid 'monkeys on your back' by keeping the responsibility for solutions with the person doing the work.

*Timestamp: 01:21:54*


## Daniel Lereya
*Daniel Lereya*

> "Don't be afraid again to let go of things that you think are superpowers... Many times your superpowers that brought you to this point and made you successful, many times you think that if you let it go you won't be successful and it's frightening."

**Insight:** Scaling as a leader requires abandoning the very skills (like attention to every detail) that made you successful at smaller scales.

**Tactical advice:**
- Identify 'superpowers' that have become bottlenecks as the team grows
- Shift from being the person who knows every detail to the person who provides the bottom-line summary

*Timestamp: 01:01:30*


## Dalton Caldwell
*Dalton Caldwell*

> "I think that the advice that he's referencing here is just how important it is to not overdelegate and for the founders to stay close to things, as well as watch out for the trap of hiring super senior people with fancy resumes, really early in a startup. I think that's what he's referencing there. And again, this is definitely one of those very basic things that we find ourselves repeating a lot where they're like, 'Yeah, yeah, I get it. Don't overdelegate. We get it, Dalton.' And then two years later they're like, 'Wow, we overdelegated. We need to go clean that up.'"

**Insight:** Early-stage founders often fail by delegating core responsibilities too early or hiring senior executives who are disconnected from the 'weeds.'

**Tactical advice:**
- Avoid hiring senior executives with 'shiny resumes' from big tech in the very early stages
- Stay deeply involved in the details of product and customer interaction
- Resist the urge to scale the team just because you raised money

*Timestamp: 00:32:35*


## Drew Houston
*Drew Houston*

> "The first way that companies die is from founders not letting go... But then the second way that companies kill themselves is the founders get too far away."

**Insight:** Effective leadership requires balancing the need to scale through delegation with the need to stay close to the product details.

**Tactical advice:**
- Avoid the 'Product-CEO Paradox' by recognizing when you have leaned out too far from the core product.
- Don't allow delegation to become an excuse for executives to evade accountability.

*Timestamp: 00:52:23*


## Donna Lichaw
*Donna Lichaw*

> "When you're hiring super senior, whip smart executives to work for you, they don't want to be told what to do, they want to have a grand vision that they're excited about... Give us a vision, give us problems to solve and let us do it for you."

**Insight:** Effective delegation for senior talent involves providing a clear vision and problems to solve rather than prescriptive tasks.

**Tactical advice:**
- Shift from telling senior hires what to do to giving them high-level problems and empowering them to define the strategy.

*Timestamp: 00:19:35*


## Dmitry Zlokazov
*Dmitry Zlokazov*

> "The ideal position for any product owner is to be fully autonomous. And again, it doesn't mean that you will never be challenged, but if when you're challenged, you can show all the logic behind decisions you've made behind the roadmap. And even if metrics are not yet there, you will still let's say have this credit of trust to keep building things the way you want to build them."

**Insight:** Autonomy is earned through the ability to demonstrate rigorous logic and clear decision-making frameworks.

**Tactical advice:**
- Grant autonomy to product owners who can clearly articulate the logic behind their roadmaps
- Use 'credit of trust' to allow teams to continue building even before metrics have fully materialized

*Timestamp: 00:37:21*


## Dharmesh Shah
*Dharmesh Shah*

> "I don't want to have any direct reports... I have learned that I suck at management. I'm a reasonably smart person. I think I could become passively okay at management with some training... I don't want to spend any years of my life becoming passively okay at something. I would rather take those same calories and take the things that I'm good at"

**Insight:** Extreme delegation involves recognizing that you should not manage people if it is not a core strength, even as a founder.

**Tactical advice:**
- Design your role to focus on 'high upside' activities while delegating the 'mechanics' of management to those who enjoy it.

*Timestamp: 00:17:04*


## Dylan Field
*Dylan Field 2.0*

> "There are I think a lot of people who when you put them on the thing that they are super interested and fired up about will outperform your wildest imagination of what's possible. Put in the wrong effort where they're not motivated, yeah, they will be fine. If you can actually understand what people care about and then map them with their interests to the right projects, it is just so helpful."

**Insight:** Maximize team performance by mapping individual interests and passions to specific projects.

**Tactical advice:**
- Regularly learn and understand what individual team members care about
- Align project assignments with the personal interests of the staff

*Timestamp: 00:12:51*


## Fareed Mosavat
*Fareed Mosavat*

> "You have to shift from doer to editor is the way I think about it. You have to shift from, 'My job is to do the work,' to, 'My job is to make the work better. My job is to plus the work, to review the work, to help other people solve problem.'"

**Insight:** The transition from IC to manager requires a fundamental shift from executing tasks to improving and scaling the output of others.

**Tactical advice:**
- Adopt a 'lazy' mindset: look for the least amount of work you can do to make a project as good as possible
- Avoid the 'manager death spiral' by resisting the urge to keep the most interesting or high-leverage projects for yourself
- Assess each team member's expertise to determine the appropriate level of directive vs. coaching input needed

*Timestamp: 00:37:24*


## Jeffrey Pfeffer
*Jeffrey Pfeffer*

> "oftentimes I can find other people to do the work I was doing. So instead of basically spending time doing my job, I networked first within Netscape."

**Insight:** High-level networking and power acquisition often involve finding others to execute tactical tasks, freeing you for strategic relationship building.

**Tactical advice:**
- Identify tasks that can be handled by others to prioritize high-leverage networking and power-building activities.

*Timestamp: 00:34:14*


## Jerry Colonna
*Jerry Colonna*

> "How can you hire people whom you expect to make decisions without running them through you if you can't tolerate them making a decision that you disagree with? You want to build a scaled leadership team, you have to be willing to have them make boneheaded decisions."

**Insight:** Effective delegation requires leaders to tolerate mistakes and relinquish the need for total agreement on every outcome.

**Tactical advice:**
- Accept that team members will occasionally make 'boneheaded' decisions as a cost of scaling.
- Identify if your own inability to tolerate disagreement is creating a decision-making bottleneck.

*Timestamp: 01:18:37*


## Jeremy Henrickson
*Jeremy Henrickson*

> "It's very, very tempting to float up here as a leader and say, 'Hey, you take that hill over there. You guys do this over here.' When in fact, where you really learn where the challenges are, or the problems or the successes is by just being there with the people in the trenches on one of the things, whichever one seems hardest or most complicated."

**Insight:** Effective leadership requires 'diving deep' into the most complex problems rather than just delegating from a high level.

**Tactical advice:**
- Identify the hardest or most complicated project and spend time in the trenches with that team
- Use detailed exercises to learn where the actual challenges and successes are

*Timestamp: 00:00:00*


## Jessica Hische
*Jessica Hische*

> "When I hire people to help me do a thing, it's because there is this implicit trust in what they do and that that's why I want to work with them... I'm just like, 'Hey, this is your thing. You're the expert. What do you think? Let me give you the parameters and the things that we have to think about. Because you know more about wood resources, and you know more about the cabinet spacing, and whatever, you tell me what you think is going to work best based on all these things that I laid out for you.'"

**Insight:** True delegation involves providing clear parameters and then deferring to the expert's judgment on the execution details.

**Tactical advice:**
- Hire based on vision and then avoid micromanaging the expert's process.
- Provide the 'parameters' (constraints) but let the expert provide the 'answers'.

*Timestamp: 01:16:28*


## Kunal Shah
*Kunal Shah*

> "Founders often start in control, very micromanaging, just driving the ship. And then as the company grows, they delegate and empower and then things start to slow down and then they come back, play the Shiva and take control again... the universe goes through the exact same phases. So if you study Indian mythology, you'll see that there's a Brahma, Vishnu, Mahesh cycles and every yugg As it’s called, goes through these three phases all the time."

**Insight:** Leadership involves a natural cycle of creation, sustenance, and creative destruction where founders must oscillate between delegation and direct control.

**Tactical advice:**
- Recognize when delegation has led to stagnation or 'slow' company dynamics.
- Be prepared to step back into direct control (the 'Shiva' phase) to drive necessary destruction and rebirth.

*Timestamp: 00:38:00*


## Laura Modi
*Laura Modi*

> "The power of a support system to be able to do what you do, I mean, you are an extension, my leverage, my everything... everyone should not only know the power and leverage of their person, but the level of appreciation and celebration you need to have for them is just huge."

**Insight:** High-level execution requires a support system that acts as a force multiplier for the leader.

**Tactical advice:**
- Hire an Executive Assistant (EA) based on chemistry and mutual care.
- Treat support staff as an extension of your own leverage and celebrate them publicly.

*Timestamp: 00:37:25*


## Matt Mochary
*Matt Mochary*

> "The key is to go and look at your day. It's not that you figure out what it is and do more of that, it's that you figure out what it isn't and eliminate that and then naturally, you'll be drawn toward what it is that you love."

**Insight:** Delegation should be driven by an 'energy audit' to remove tasks that drain your life force, even if you are excellent at them.

**Tactical advice:**
- Perform an energy audit by marking calendar events as 'green' (energy-giving) or 'red' (energy-draining) for two weeks.
- For every 'red' task, ask: Does this need to be done? Can someone else do it? Or can the methodology be changed to make it 'exquisite'?

*Timestamp: 01:04:10*


## Maya Prohovnik
*Maya Prohovnik*

> "The one other one I refer to often is I love the Eisenhower Matrix, which is also known as the four Ds. So it's do, defer, delegate, delete... I write everything down at the end of every day, I go through and I either do delegate, defer, delete, and it really helps you clear a lot of stuff out of your brain."

**Insight:** Using a structured framework to categorize tasks helps leaders decide what to handle personally and what to offload.

**Tactical advice:**
- Apply the Eisenhower Matrix (Do, Defer, Delegate, Delete) to daily task lists
- Review and categorize all pending items at the end of every workday to clear mental space

*Timestamp: 00:51:58*


## Melanie Perkins
*Melanie Perkins*

> "And so you kind of wear a hundred hats and then you have to be able to give away those hats to other people that can then do that way better than yourself."

**Insight:** Scaling as a leader requires the constant 'giving away of hats' to specialists who can outperform the founder.

**Tactical advice:**
- Identify areas where you are currently wearing a 'hat' that a specialist could handle more effectively

*Timestamp: 00:31:11*


## Molly Graham
*Molly Graham*

> "You have to grow as fast as your company is growing if you really want to take advantage, both learning to give away what you've gotten good at and move on to the next shiny pile of Legos."

**Insight:** To keep pace with a rapidly scaling company, leaders must constantly hand off tasks they have mastered to make room for new, larger challenges.

**Tactical advice:**
- Give away your job every few weeks to stay on top of the growth pile.
- Recognize that territorial emotions (fear, protectiveness) are normal when passing off work, but they should not stop the delegation process.
- If an emotional reaction to a change or delegation lasts longer than two weeks, it is a real issue to address; otherwise, treat it as temporary 'Bob' (the monster) emotions.

*Timestamp: 00:14:03*


## Nikhyl Singhal
*Nikhyl Singhal*

> "Your challenge is going to be to share the steering wheel with the person or the set of people you are managing... I think it's more like the sidecar on the motorcycle, where person's driving the motorcycle and I'm on the sidecar and whether I like it or not, I'm attached, but I have this relatively specific role of giving counsel."

**Insight:** Effective delegation is about 'sharing the steering wheel' and acting as a counselor in the 'sidecar' rather than just letting go or micromanaging.

**Tactical advice:**
- Adopt the 'sidecar' model: let the report drive while you provide constant counsel
- Earn the right to manage by being invited in to help with specific problems

*Timestamp: 00:37:39*


## Paul Millerd
*Paul Millerd*

> "I have contractors, but I hire contractors for very specific roles. And I create systems such that we can do it asynchronously. And of course, I'll have conversations with them if they want to jump on a call. But I optimize for people that want asynchronous and work on those specific things."

**Insight:** To avoid turning your solo venture back into a management-heavy job, delegate via asynchronous systems and highly specific roles.

**Tactical advice:**
- Hire for specific, narrow roles rather than generalists
- Build asynchronous workflows to protect your creative time from meetings

*Timestamp: 00:47:37*


## Rachel Lockett
*Rachel Lockett*

> "He realized he was the blocker on every decision, every business decision, every product decision... he decided to create squads... shifting from the role of deciding on everything to coaching."

**Insight:** Scaling requires moving from individual decision-making to building systems and coaching others to lead.

**Tactical advice:**
- Create small autonomous pods or squads with clear KPIs.
- Shift from 'decider' to 'coach' in product reviews.

*Timestamp: 00:24:55*


## Ravi Mehta
*Ravi Mehta*

> "Your ideal goal is to lead in a scalable way, which means you feel really confident about the direction of your team and your team has the autonomy to move in that direction. There's another really effective way of leading, which is selective micromanagement, which if you don't feel confident in the direction that your team is moving, the right answer is not to be hands-off and to let them go in that wrong direction. The right answer is to micromanage, but do it in a very tactical and a very temporary way so that you can help them understand what is the right direction moving forward so that you can then pull back."

**Insight:** Effective leadership requires a 'dynamic range' between granting full autonomy and stepping in with selective micromanagement when a team loses direction.

**Tactical advice:**
- Use selective micromanagement as a temporary tool to realign a team's direction.
- Transition back to scalable leadership once the team understands the necessary frameworks and direction.
- Focus on teaching the team the frameworks you use to make decisions so they can eventually outperform your own thinking.

*Timestamp: 00:00:00*


## Rahul Vohra
*Rahul Vohra*

> "What I did is, I hired a really great president, I went from eight direct reports to two, and the amount of time that I spend on product design, technology and marketing went up from six to 7% to about 60% to 70% of my week."

**Insight:** Founders should delegate operational management to a President or COO to reclaim time for their 'zone of genius.'

**Tactical advice:**
- Hire a President to handle operations, management, and executive accountability.
- Reduce direct reports to focus on high-leverage areas like product and design.

*Timestamp: 00:19:35*


## Ray Cao
*Ray Cao*

> "The number one thing is context, no control. That's the reason why we're always encouraging people to see themselves as a business owner."

**Insight:** Empower employees by providing full context and treating them as business owners rather than giving specific instructions.

**Tactical advice:**
- Provide all necessary information to employees so they can 'connect the dots' themselves.
- Encourage employees to think beyond their specific job descriptions.

*Timestamp: 00:00:07*

---

> "Context, no control. That means you actually can go above and beyond to really think about your whole business problem as your own problem and your piece is maybe one part of it to solve the puzzle, but how do you actually solve the puzzle by connecting all the dots together, we're encouraging all the people to think like that way and by that I think we kind of mentally break out those walls."

**Insight:** Breaking down organizational silos requires giving employees the context to see the full business picture.

**Tactical advice:**
- Encourage 'proactive thinking' where employees consider the whole business problem.
- Use 'reactive doing' to ensure that while people think broadly, they still collaborate with the actual owners of a task.

*Timestamp: 00:16:49*

---

> "It is very important that the leader at any level needs to be situational. You cannot always down to the wheat and you cannot really distance yourself from the reality. So you need to find the balance to really get engaged and also see yourself out there to getting, I would say, getting deeper into the problems, to identify the problems, and then you're able to perform even better."

**Insight:** Effective delegation requires situational leadership—knowing when to dive into details and when to stay high-level.

**Tactical advice:**
- Avoid becoming a 'pure people manager' who is distanced from the market reality.
- Periodically 'get into the weeds' to identify problems firsthand.

*Timestamp: 00:39:32*


## Ryan Hoover
*Ryan Hoover*

> "Delegation is- is a classic founder challenge. You know, I- I'm just generally a controlling person. That's something I'm working on. And it's really hard sometimes when I have such strong opinions, and I'm very particular about certain things, uh, fully delegate and fully trust everybody... what I should've done is, you know, up until shortly before I left, I was editing the newsletter every morning, for example, like every morning. I mean that's just kinda silly, you know, to be doing that so many years later after starting."

**Insight:** Founders must overcome the urge to control every detail to allow the company and themselves to scale.

**Tactical advice:**
- Identify repetitive tasks (like editing a daily newsletter) that should be handed off to the team.
- Recognize that you are not the best person at everything and trust the skills of the team you hired.

*Timestamp: 00:34:30*


## Ryan Singer
*Ryan Singer*

> "Instead, we want to have a whole idea, give it to a team so they see the whole, they really understand it, right? And then they can come up with their tasks and they can figure out how to track that and break it into pieces so they can actually take more responsibility."

**Insight:** Empower teams by giving them a complete, shaped concept rather than a list of granular tickets.

**Tactical advice:**
- Trust the builders to define their own implementation tasks based on a well-shaped idea.
- Avoid the 'paper shredder' approach of pre-assigning small tickets to individuals.

*Timestamp: 00:23:13*

---

> "In the shape-up world, you have a single idea that was shaped... Go make your own tasks, because you’re the professionals... The contractors, if you’re building a house, they have to know the plans, but you don’t have to tell them, 'Now take the hammer and go over here.'"

**Insight:** Professional builders should be responsible for the 'how' of implementation once the 'what' is clearly defined.

**Tactical advice:**
- Provide the 'architectural plans' (the shaped idea) and let the team manage the 'construction' (the tasks).
- Use a 'nine boxes' exercise at kickoff to help the team visualize the major implementation scopes.

*Timestamp: 01:04:24*


## Tom Conrad
*Tom Conrad*

> "I see my job as CEO is to try to surf that edge of I'm really in the details... but not overplay my hand with respect to dictating outcomes. The one thing you'll always have as CEO is, no matter how much you tell the team that when I swing by their virtual desk and say, 'I've been thinking about this little detail that's not important right now, but what do you think?' It's like nine out of 10 times, that person is going to go and start working on that thing."

**Insight:** Leaders must balance deep detail-orientation with the awareness that their casual suggestions are often interpreted as mandatory directives.

**Tactical advice:**
- Explicitly label feedback as 'FYI' or 'suggestion' to avoid accidental prioritization
- Maintain deep context without overriding the team's decision-making autonomy

*Timestamp: 01:04:10*


## Wes Kao
*Wes Kao 2.0*

> "CEDAF stands for the C is comprehension... E is excitement... D is for de-risk... A is for align... and F is feedback."

**Insight:** Successful delegation requires ensuring the recipient understands the task, is motivated, and has a tight feedback loop.

**Tactical advice:**
- Comprehension: Ensure they have all logins and context needed
- De-risk: Have the person do a small sample (e.g., 10 rows of a spreadsheet) before doing the whole task
- Feedback: Shorten the feedback loop by checking in after one day instead of one week

*Timestamp: 01:11:06*


## Andrew Wilkinson
*Andrew Wilkinson*

> "I think they really need to lean into what I call lazy leadership, which is how do I get away from the things I hate as quickly as humanly possible? How do I be Teflon for tasks?"

**Insight:** Effective leadership involves identifying your 'superpower' and aggressively delegating everything else to avoid being trapped in a 'job' rather than a business.

**Tactical advice:**
- Identify your highest and best use (e.g., sales or design) and focus exclusively on that.
- Scale the business until you can hire employees to handle the operational tasks you dislike.
- Aim to be 'Teflon for tasks'—letting low-value work slide off you to others.

*Timestamp: 00:11:26*

---

> "I've also found people will shoot themselves in the foot. If I tell them an idea in a board meeting and I say, 'I really need you to try this,' it never works because usually they sandbag it... They want their idea to work. And so I've learned not to do that."

**Insight:** Micromanaging or forcing ideas on leaders leads to poor execution; true delegation requires letting the person in charge own the strategy.

**Tactical advice:**
- Avoid 'pulling' CEOs in a specific direction or coaching them to do things your way.
- Hire leaders whose natural instincts already align with your vision so you can leave them alone.
- Recognize that people will rarely put their heart into an idea that isn't their own.

*Timestamp: 00:41:06*


## Paige Costello
*Paige Costello*

> "I would go to my meetings with a stack of Post-Its, and I would write what I wish I was saying on Post-Its and see if someone else would say it first... you've got to police yourself because no one else will do it because no matter how accessible you think you are, other people know that you're the boss."

**Insight:** Leaders should practice restraint in meetings to allow their team to step up and find answers themselves, fostering agency and growth.

**Tactical advice:**
- Write down your thoughts on Post-Its during meetings instead of speaking immediately.
- Wait to see if a team member provides the answer or insight before you do.

*Timestamp: 00:49:16*


## Peter Deng
*Peter Deng*

> "In 6 months, if I'm telling you what to do, I've hired the wrong person... it helps me and the person operate on a different level where the goal is not, did you hit this OKR? The Meta goal becomes, are we calibrating enough? Are we actually getting into a spot where in 6 months you're the one telling me what needs to be done?"

**Insight:** Effective delegation is achieved when the report becomes the driver of the work through continuous calibration with the manager.

**Tactical advice:**
- Shift the focus of 1:1s from task status to calibration of judgment
- Empower reports to tell the manager what needs to be done within six months of hiring

*Timestamp: 01:03:07*


## Casey Winters
*Casey Winters_*

> "I need to let these experts own these areas - that's actually the opposite of what you want."

**Insight:** Founders should stay directive until hires prove they can make better decisions.

**Tactical advice:**
- Don't delegate too early
- Watch for readiness signals

*Timestamp: 00:28:26*


