---
name: design-engineering
description: Help users understand and build design engineering capabilities. Use when someone is creating a design engineering function, hiring design engineers, or bridging the gap between design and engineering teams.
---

# Design Engineering

Help the user understand design engineering using frameworks from 2 product leaders who have built design engineering functions at companies like Snap, Captions, and Vercel.

## How to Help

When the user asks for help with design engineering:

1. **Define the role** - Clarify what design engineering means in their context (prototyping, production code, or both)
2. **Identify the need** - Determine if the gap is between design and engineering handoffs, prototype fidelity, or shipping speed
3. **Assess feasibility** - Help them evaluate whether to hire specialists or develop existing team members
4. **Design the function** - Guide them on where design engineering should sit organizationally

## Core Principles

### Merge UX design and engineering
Gaurav Misra: "A big part of what I did there was create this function called design engineering." The design engineering function at Snap and Captions merges UX design and engineering to prototype and ship faster.

### Combine design sensibility with shipping ability
Guillermo Rauch: "A lot of the people that we were noticing were being very successful at Vercel were people that had both the design and engineering skills." The most valued design engineers combine high-end design sensibility with the ability to ship production-ready code.

## Questions to Help Users

- "What's the current handoff friction between design and engineering?"
- "Do you need prototypes for validation or production-ready code?"
- "Where would design engineering sit in your org - design, engineering, or product?"
- "Do you have existing team members who could grow into this role?"
- "What tools and frameworks would design engineers use?"

## Common Mistakes to Flag

- **Unclear scope** - Not defining whether design engineers prototype or ship production code
- **Wrong org placement** - Isolating design engineers from both design and engineering teams
- **Hiring for unicorns** - Looking for people who are world-class at both rather than strong at the intersection
- **Ignoring AI tools** - Missing how AI-assisted development is making this role more accessible

## Deep Dive

For all 2 insights from 2 guests, see `references/guest-insights.md`

## Related Skills

- Technical Roadmaps
- Managing Tech Debt
- Platform & Infrastructure
- Engineering Culture
