---
name: design-systems
description: Help users build and scale design systems. Use when someone is creating a component library, establishing design tokens, scaling brand consistency, or deciding when to invest in a design system.
---

# Design Systems

Help the user build and scale design systems using frameworks from 4 product leaders who have built design systems at companies like Figma and Airbnb.

## How to Help

When the user asks for help with design systems:

1. **Assess the need** - Determine if they need consistency, speed, or both, and whether they're at the right stage for a design system
2. **Define the scope** - Clarify whether they need a component library, design tokens, documentation, or all three
3. **Design for adoption** - Help them make the system easy enough that non-designers can use it correctly
4. **Plan for evolution** - Guide them on how to maintain and evolve the system over time

## Core Principles

### Separate concept from production
Bob Baxley: "Once we locked down on the block frames, we could send it to an agency and they could do the full high-res comps in a day, because they knew exactly what they were doing." Use low-fidelity 'block brain diagrams' to lock down conceptual logic, then apply the design system for rapid high-fidelity output.

### Design systems drive enterprise expansion
Claire Butler: "Design systems are one of the main reasons you upgrade from pro to org or enterprise. That became just the key thing we leaned in on." Design systems practitioners are key internal champions for organizational scaling.

### Assets should teach their own usage
Jessica Hische: "My goal always when designing a logo is to design a logo that's so easy to use that you don't have to be an extremely skilled designer to design well with it." Design assets that 'teach' the user how to apply them through their inherent structure, prioritizing ease of use over complexity.

### Flat design is evolving
Brian Chesky: "I think flat design is over or ending. We're going to move back into a world with color, texture, dimensionality, more haptic feedback." Interface design is shifting from flat aesthetics to more dimensional, tactile, and AI-enhanced experiences.

## Questions to Help Users

- "What's the biggest inconsistency problem you're facing today?"
- "Who will be using this design system - designers only, or engineers too?"
- "How will you measure adoption and success of the design system?"
- "Do you have the resources to maintain and evolve the system over time?"
- "What's the smallest viable version you could ship first?"

## Common Mistakes to Flag

- **Building too early** - Creating a design system before you have enough patterns to systematize
- **Over-engineering** - Building complex systems that require expert designers to use correctly
- **No ownership** - Creating a design system without dedicated resources to maintain it
- **Ignoring adoption** - Building a beautiful system that no one actually uses
- **Static systems** - Treating the design system as 'done' rather than continuously evolving

## Deep Dive

For all 4 insights from 4 guests, see `references/guest-insights.md`

## Related Skills

- Running Design Reviews
