# Design Systems - All Guest Insights

*4 guests, 4 mentions*

---

## Bob Baxley
*Bob Baxley*

> "Once we locked down on the block frames, we could send it to an agency and they could do the full high-res comps in a day, because they knew exactly what they were doing. And so the PMs were always like, what the hell happened overnight?"

**Insight:** A robust design system allows teams to separate conceptual 'heavy lifting' from visual production, enabling rapid high-fidelity output.

**Tactical advice:**
- Use 'block brain diagrams' (low-fidelity wireframes) to lock down conceptual logic before applying the design system.

*Timestamp: 01:14:42*


## Brian Chesky
*Brian Chesky*

> "I'd like to make the announcement that I think flat design is over or ending. I think if you remember the 2000s was dominated by skeuomorphism. The 2010s have been dominated with the launch of iOS seven by flat design. And I think we're going to move back into a world with color, texture, dimensionality, more haptic feedback"

**Insight:** Interface design is shifting from flat aesthetics to more dimensional, tactile, and AI-enhanced experiences.

**Tactical advice:**
- Explore dimensionality and texture in UI design
- Leverage AI for more sophisticated interface elements

*Timestamp: 00:42:25*


## Claire Butler
*Claire Butler*

> "Design systems are one of the main reasons you upgrade from pro to org or enterprise... that became just the key thing we leaned in on. And that's bottoms up specific, because the people making the design systems are not like the VP, still."

**Insight:** Design systems are a primary driver for enterprise upgrades and serve as the operational 'hook' for organizational scaling.

**Tactical advice:**
- Identify the operational blocker to adoption (like design systems) and turn it into a core feature
- Target design systems practitioners as key internal champions for enterprise expansion

*Timestamp: 01:14:30*


## Jessica Hische
*Jessica Hische*

> "My goal always when designing a logo is to design a logo that's so easy to use that you don't have to be an extremely skilled designer to design well with it. That's my number one goal, because I know not everybody is going to be at a stage where they have an internal brand team or a designer that's a rock star designer that can work with really complicated assets and make them look good. I just want the assets to teach you themselves, by just how they exist, how to use it."

**Insight:** A successful brand system should be intuitive enough that non-designers can use the assets correctly without a massive brand book.

**Tactical advice:**
- Design assets that 'teach' the user how to apply them through their inherent structure.
- Prioritize ease of use over complexity to ensure the brand remains consistent as the company scales.

*Timestamp: 00:41:43*


