---
name: designing-growth-loops
description: Help users design and optimize growth loops. Use when someone is building viral mechanics, designing referral programs, creating product-led acquisition, or figuring out how to make their product grow itself.
---

# Designing Growth Loops

Help the user design effective growth loops using frameworks from 54 product leaders who have built viral and product-led growth engines at companies from Dropbox to LinkedIn to Calendly.

## How to Help

When the user asks for help with growth loops:

1. **Identify the loop type** - Determine if they need viral, paid, content, or product-led acquisition loops
2. **Assess prerequisites** - Check if they have the LTV, network effects, or product stickiness to support the loop
3. **Find the natural sharing moment** - Help them identify where users would naturally want to bring others in
4. **Design for compounding** - Ensure the loop feeds back into itself for sustainable growth

## Core Principles

### One dominant loop matters most
Luc Levesque: "It's usually just one loop that you need to get right. Most successful companies scale primarily through one dominant, well-executed growth loop." Focus on identifying and dominating one primary channel before diversifying.

### Viral growth is a learnable science
Nikita Bier: "With certainty, if you're good at your job, you can make an app grow and go viral. Over the years of building all these apps, I've accrued all these growth hacks that still nobody knows about." Develop a library of growth tactics based on platform-specific mechanisms.

### LTV unlocks paid loops
Yuriy Timen: "If you have really healthy LTVs, then there is a big opportunity to play paid and lean into paid growth loops." Calculate if single-player LTVs are high enough to support sustainable paid acquisition.

### Product-led acquisition has zero marginal cost
Julian Shapiro: "By me trying to use PayPal in its everyday intention, I'm automatically enticing someone else to become a PayPal customer." PLA is the most scalable channel because it's entirely within the company's control.

### Innovation over optimization in fast markets
Elena Verna: "I feel like only 30 to 40% of what I've learned transfers here because we need to invest in such bigger bets and innovate and create new growth loops." In fast-moving AI categories, shift from 95% optimization to 95% innovation.

### Word-of-mouth requires frequency
Uri Levine: "Word-of-mouth you can only have if you have high frequency of use. If you're using Waze every day, then every day you have an opportunity to tell someone else." Sustainable word-of-mouth is tied to how often users engage with the product.

### Map the loops qualitatively and quantitatively
Ben Williams: "Being able to identify the various micro and macro loops, how they're all connected, being able to document them in a qualitative model provides a shared understanding and guides intentional investment."

### 40-50% organic is the healthy ratio
Gokul Rajaram: "A good metric is that 40 to 50% of your new customers should ideally come from organic channels. If 90% come from paid, at some point the music is going to stop."

## Questions to Help Users

- "What's the natural moment when users would want to bring others in?"
- "Does your product become more valuable when more people use it?"
- "What percentage of your growth is organic vs paid?"
- "What's your customer LTV and payback period?"
- "Is there an action users take that automatically exposes your product to others?"
- "Can you identify where users already share your product organically?"

## Common Mistakes to Flag

- **Paid acquisition on freemium** - Consumer subscriptions relying on paid acquisition will predictably fail
- **Manufacturing network effects** - Network effects are usually inherent; hard to add as an afterthought
- **Diversifying too early** - Early-stage companies should focus on one working engine
- **Single-channel dependency** - Late-stage companies with 90%+ reliance on one channel are at extreme risk
- **Referral programs without organic WOM** - Referrals amplify existing word-of-mouth; they can't create it

## Deep Dive

For all 84 insights from 54 guests, see `references/guest-insights.md`

## Related Skills

- Measuring Product-Market Fit
- Pricing Strategy
- Retention & Engagement
- Marketplace Liquidity Management
