# Designing Growth Loops - All Guest Insights

*54 guests, 84 mentions*

---

## Adam Fishman
*Adam Fishman*

> "Growth loop modeling. So really understanding how you grow and where you should be spending your time. What acquires users? What retains them? What monetizes them?"

**Insight:** Effective growth strategy requires a deep understanding of the specific loops that drive acquisition, retention, and monetization.

**Tactical advice:**
- Model the specific loops of your business to identify where to spend time
- Use growth models to inform capital allocation and forecasting

*Timestamp: 00:21:25*


## Albert Cheng
*Albert Cheng*

> "We invested actually in some time to essentially add screenshot tracking... we were able to basically articulate and say, 'Okay, streak milestones is the obvious one.'... we staffed those moments with illustrators and animators and created these really delightful experiences around them, and that worked amazingly well."

**Insight:** Identify where users are already organically sharing (e.g., via screenshots) and invest in making those specific moments more delightful and shareable.

**Tactical advice:**
- Track where users take screenshots in your app to identify organic viral triggers.
- Invest in high-quality illustrations and animations for 'shareable' milestones like streaks or leaderboard wins.

*Timestamp: 01:03:16*


## Adam Grenier
*Adam Grenier*

> "The exploring emerging channels framework that I'll take... has three core ingredients... understanding if there is an overlap between what the customers need is, what your company's goals are, and what the channel actually does really well."

**Insight:** Successful acquisition channel selection requires a three-way fit between customer needs, business goals, and the inherent strengths of the medium.

**Tactical advice:**
- Evaluate if the channel's medium (e.g., audio, video) matches your product's storytelling needs
- Prioritize channels where the 'strength of the medium' aligns with your growth goals

*Timestamp: 00:14:38*

---

> "I like to spend a lot of time thinking about how they monetize. What is the monetization strategy of the channel? And the reason is because if you, as a business, can match or support their monetization strategy, it actually gives you a really interesting leg up with that channel."

**Insight:** Aligning your marketing approach with a platform's monetization goals makes you a more valuable partner and can grant you early access to new features.

**Tactical advice:**
- Research how a new platform plans to make money before testing it
- Position your company as a 'case study' for the platform's emerging ad products

*Timestamp: 00:21:37*

---

> "Generally I wouldn't let anything bleed past a quarter. You can probably get some good signal in a month or less, what I would call fishing. It wouldn't be like you're just putting bait in the water to figure out where the fish are, not necessarily getting statistically significant repeatable solutions."

**Insight:** Testing new channels should be time-boxed to a quarter, with initial 'fishing' for signals taking a month or less.

**Tactical advice:**
- Use a one-month 'fishing' period to look for directional momentum
- Avoid spending more than one quarter on a new channel if it doesn't show repeatable potential

*Timestamp: 00:27:33*


## Annie Pearl
*Annie Pearl*

> "Seventy percent of our signups come through that viral loop that you referred to. And then, of those signups, then they're usually solo users and then they start to invite team members in and then the team starts using Calendly and then usually the head of that team either inbounds to us or we have some sort of PQL data."

**Insight:** Calendly's growth is driven by a viral loop where recipients of booking links become users, eventually leading to team-based expansion.

**Tactical advice:**
- Optimize the experience for the 'recipient' of the service to drive viral adoption.
- Use PQL (Product Qualified Lead) data to identify when a solo user's team usage warrants a sales reach-out.

*Timestamp: 00:25:39*


## Archie Abrams
*Archie Abrams*

> "We constantly will relook at an experiment a year later, see that the way the GMV curve for the distribution was different than we might've originally thought. And that'll actually change what we do from that previous experiment. And so there's a lot of longterm monitoring of experiments over these very long time horizons to both inform what those input metrics are and more importantly hold ourselves accountable to, did we actually move what we cared about, which is that longterm GMV, in the right way?"

**Insight:** Short-term experiment results are often misleading; true growth impact must be validated through long-term holdouts and cohort monitoring over 12+ months.

**Tactical advice:**
- Implement automated 'pings' to re-evaluate experiment results at 3, 6, 9, and 12-month intervals.
- Use long-term holdouts to distinguish between true incremental growth and 'pull-forward' effects.

*Timestamp: 00:12:37*

---

> "What we really care about is incrementality. So incrementality is kind of the gold standards... Incrementality test is basically don't show ads on meta for certain number of people. Show it to the other set, see what the lift is and the outcome."

**Insight:** Causal incrementality testing is superior to multi-touch attribution for understanding the true driver of growth outcomes.

**Tactical advice:**
- Run 'ghost ad' or 'holdout' tests by withholding marketing spend from a control group to measure true lift.
- Prioritize incrementality measurement over attribution modeling when making budget allocation decisions.

*Timestamp: 01:05:26*


## Bangaly Kaba
*Bangaly Kaba*

> "Really figuring out how do you build compounding growth loops where it's not just one way of acquiring people, but you're building two and three and four ways that layer onto each other that help you to really supercharge your engine of acquiring people."

**Insight:** Supercharge growth by layering multiple acquisition engines (e.g., invites, SEO, partnerships) so they compound each other.

**Tactical advice:**
- Use celebrity partnerships to set platform norms and drive media mentions that fuel SEO.
- Build a web presence for mobile apps to create canonical SEO tables and capture search traffic.

*Timestamp: 01:10:04*


## Ben Williams
*Ben Williams*

> "Being able to identify the various micro and macro loops, how they're all connected, being able to document them in a qualitative model to communicate a shared understanding of how you grow, it's really powerful."

**Insight:** Mapping growth through qualitative and quantitative loop models provides a shared understanding and guides intentional investment.

**Tactical advice:**
- Document micro and macro loops in a qualitative model
- Augment qualitative models with quantitative data to guide quarterly focus

*Timestamp: 00:00:00*

---

> "Snyk, for example, believed very early that we could build out powerful content loops via fixed pull requests that we raise on GitHub. New users, they'll sign up for Snyk, they'll connect their GitHub accounts, Snyk will scan their code, will find vulnerabilities, will automatically create Snyk-branded pull requests to fix those vulnerabilities. Other devs in the repo will see and interact with those PRs, and some of them will follow links to Snyk, create accounts and some of them will connect their own repos, and so the loop continues."

**Insight:** Integrating growth loops directly into the user's existing workflow (like GitHub PRs) creates a powerful acquisition and engagement engine.

**Tactical advice:**
- Design loops that provide immediate value while exposing the product to new users
- Use company-generated, company-distributed content loops to drive viral growth

*Timestamp: 00:21:28*

---

> "The best way I've found to articulate a growth strategy that fulfills the promise of usefully guiding the team's execution, it's the loop based model... Being able to identify the various micro and macro loops, how they're all connected, being able to document them in a qualitative model to communicate a shared understanding of how you grow. It's really powerful."

**Insight:** A loop-based strategy helps identify the biggest constraints in the growth model and balances investments accordingly.

**Tactical advice:**
- Identify and connect micro and macro loops to form a cohesive growth strategy
- Use data to identify which part of the loop is the current biggest constraint

*Timestamp: 00:57:34*


## Benjamin Lauzier
*Benjamin Lauzier*

> "Pick the hardest side is my advice. And then, how some companies do this, again, I think there's a lot of different ways to do this, but a common advice is find a way to jumpstart one side. Find a way to hack one side, play one player mode is what it's also called sometimes, but try to find a way to tap into existing channels that have one side of your marketplace already latent."

**Insight:** To kickstart a marketplace, identify the 'hard side' and use 'single-player mode' or external channel hacks to simulate the other side.

**Tactical advice:**
- Identify which side (supply or demand) is harder to acquire and focus growth efforts there.
- Tap into existing platforms (like Craigslist or Yellow Pages) to source the 'easier' side manually.

*Timestamp: 00:09:38*

---

> "What we did is leveraging this community and building essentially a soft onboarding supply engine where we would pay our best drivers $35 per mentor session... the mentors were our very best drivers, and they were evangelists for the brand. So, what they did was they would share personal tips on when and where to drive."

**Insight:** Leveraging high-quality existing supply to onboard and mentor new supply creates a scalable, high-trust activation loop.

**Tactical advice:**
- Identify top-performing users to act as mentors or ambassadors.
- Incentivize mentors to provide social proof and tactical advice that corporate marketing cannot replicate.

*Timestamp: 00:49:34*

---

> "We built a team of hundreds of account executives, and their job was just pick up the phone and call those drivers. And so, we had the same aha moment of like could we get some of our best drivers to do that for us... we called them recruiters. And so, as a recruiter, as a driver, you could just, if this was quiet on the road, you could just hop on your phone and you would have a mini sales dashboard where you could claim leads."

**Insight:** Turning existing supply into a distributed sales force can outperform professional sales teams due to peer-to-peer relatability.

**Tactical advice:**
- Create a 'sales dashboard' for power users to claim and convert dropped-off leads.
- Pay a bounty for successful activations to turn low-utilization time into productive growth work.

*Timestamp: 00:51:58*


## Brian Balfour
*Brian Balfour*

> "The criteria I would think about is... one, the better signal is retention and depth of engagement... Number two is, there's some element of user quality and ability to monetize... The third thing to look at is... analyze what the value exchange is. What are they giving you to incentivize you to develop on their platform?"

**Insight:** Selecting a growth channel requires evaluating the 'value exchange' and the quality of users rather than just the total scale of the platform.

**Tactical advice:**
- Evaluate the 'value exchange' of a new platform (what distribution are they giving in exchange for your data/content?).
- Prioritize platforms where users have a higher propensity to pay (e.g., iOS vs. Android market share dynamics).

*Timestamp: 00:57:06*


## Casey Winters
*Casey Winters*

> "The goal of your Kindle strategies, these like non-scalable hacks, they only exist to unlock the fire strategies, to unlock the things that could take you to millions of users."

**Insight:** Early, non-scalable growth tactics (Kindle strategies) should be viewed as temporary tools to reach the point where scalable loops (Fire strategies) can take over.

**Tactical advice:**
- Use 'Kindle' strategies (hacks) only to reach the point where 'Fire' strategies (scalable loops) can be ignited
- Hire full-time growth roles only after a scalable 'Fire' strategy has been identified

*Timestamp: 51:24*

---

> "If your plan is paid acquisition on top of freemium, I'd pivot right now."

**Insight:** Consumer subscriptions relying on paid acquisition will predictably fail.

**Tactical advice:**
- Build social mechanics
- Model retention economics

*Timestamp: 01:12:26*


## Christopher Miller
*Christopher Miller*

> "At the highest level, it's like taking a go-to-market approach where your product job is to grow revenue and you use humans as a backstop and not the other way around."

**Insight:** Product-led growth (PLG) is a strategy where the product is the primary driver of acquisition and expansion, with humans supporting the process rather than leading it.

**Tactical advice:**
- Identify stages in the customer journey where humans are currently required and attempt to automate them
- Use humans as a 'backstop' for complex issues like security reviews or data migrations while keeping the core path self-service

*Timestamp: 01:01:52*

---

> "One of the principles that guides our thinking and our strategy is give value before you extract value... we intentionally put out a lot of free software. And the idea is that this software is not sort of gimmicky... if they're engaging with it deeply enough, they're going to run into the limits of what that value is."

**Insight:** A successful growth flywheel is built on providing genuine, sustainable value for free before asking for a financial commitment.

**Tactical advice:**
- Design free tools that solve a real problem for small users without immediate expiration
- Set usage limits or feature gates at the point where a user has already realized significant value

*Timestamp: 01:09:00*


## Crystal W
*Crystal W*

> "Step one, you have constraints. Similar to our sandbox example of everything in the world that's orange versus everything in a construction site, you have to think about the physics of the current market, the product, the model and the channels that you're using."

**Insight:** Growth strategy must be rooted in the 'physics' of the specific market, product, and existing user behaviors.

**Tactical advice:**
- Identify underutilized levers within your existing model (e.g., using service providers as a sales force)
- Change only one small variable at a time to avoid disrupting the entire system
- Leverage real-world physical presence (like branded uniforms) as a low-cost acquisition channel

*Timestamp: 00:29:16*


## Dan Hockenmaier
*Dan Hockenmaier*

> "The most basic example of this would be virality. Your existing customers are referring new customers and those go on to refer new customers. Based on that coefficient, it has a lot to do with how fast your business grows. And similarly with paid marketing, as you generate contribution margin, you can reinvest that and grow and actually if you link those two up explicitly, it makes it really clear why thinking about something like payback period is a much better measure of paid marketing performance than LTV to CAC because the speed at which you get enough money back to then go acquire another customer has much more bearing on how fast your business can grow"

**Insight:** Growth loops, such as virality or reinvesting margin into paid acquisition, are more accurately measured by payback period than LTV/CAC because speed of reinvestment drives compounding growth.

**Tactical advice:**
- Link contribution margin generation directly to acquisition spend in your model
- Prioritize payback period over LTV/CAC to understand growth velocity

*Timestamp: 00:09:17*


## Deb Liu
*Deb Liu*

> "Growth is a game of inches... it's really about finding the aha moments, the opportunities. And sometimes opportunities are things that seem really silly... it's really taking the core engine and actually wrapping it around the user interface around the experience, around the flows so that people can get to it faster."

**Insight:** Growth is often an optimization layer on top of a working product, achieved through the accumulation of small, iterative improvements rather than single large features.

**Tactical advice:**
- Maintain a high-volume list of growth hypotheses (e.g., 100 ideas) and sprint through them
- Focus on reducing friction in user flows to help customers reach the 'aha moment' faster

*Timestamp: 00:46:34*


## Drew Houston
*Drew Houston*

> "And then we also figured out these viral motions around our referral program, and shared folders. And so Dropbox started expanding virally for the first several years... we applied that same engineering mentality to these viral loops."

**Insight:** Apply an engineering mindset to viral growth loops, treating them as systems to be optimized rather than just marketing tactics.

**Tactical advice:**
- Use referral programs and shared folders to drive organic expansion.
- Study epidemiology to understand how viruses spread as a parallel for consumer internet growth.

*Timestamp: 00:12:40*


## Elena Verna
*Elena Verna 4.0*

> "I feel like only 30 to 40% of what I've learned in the last 15 to 20 years of being in growth transfers here because we just need to invest in such bigger bets, and innovate, and create new growth loops here, everybody and their mother is starting a vibe coding business nowadays, and we need to figure out how to be ahead of them."

**Insight:** In fast-moving AI categories, growth requires constant innovation of new loops rather than incremental optimization of existing ones.

**Tactical advice:**
- Shift focus from 95% optimization to 95% innovation in growth strategies.
- Invest in 'bigger bets' that reinvent the solution rather than tweaking the current journey.

*Timestamp: 00:00:14*

---

> "The only way to create a word of mouth loop is just to blow their socks off."

**Insight:** Word of mouth in AI is driven by extreme product delight that empowers users to feel like they have superpowers.

**Tactical advice:**
- Prioritize 'wow moments' over 'aha moments' to trigger immediate social sharing.

*Timestamp: 00:01:25*

---

> "This is product-led growth... to the max, supercharged. Yes, because you're literally using your product to drive that awareness by giving it away to the agents in your ecosystem that will do that distribution for you."

**Insight:** Supercharged PLG involves using the product itself as the primary marketing vehicle by removing all barriers to entry.

**Tactical advice:**
- Identify 'agents' in the ecosystem (like hackathon organizers) and empower them with free product access to handle distribution.

*Timestamp: 00:58:58*

---

> "As a growth team, your number one priority is to create your own or your earned channel. Channel that you've earned and that nobody else can compete in but you... It really goes into the concept of product-led growth acquisition, which means you're relying on virality, on word of mouth, on user-generated content."

**Insight:** Prioritize 'earned' channels like virality and user-generated content over 'rented' channels like paid search to build a defensible growth engine.

**Tactical advice:**
- Invest in user-generated content (UGC) libraries, such as templates or case studies, to drive organic acquisition.
- Optimize both the 'sender' and 'recipient' experience in sharing loops to maximize viral coefficient.

*Timestamp: 00:43:57*

---

> "Not overlaying every single way that you can grow through product, through marketing and through sales as an evolution. Is a huge mistake that a lot of growth teams fail to iterate on and innovate on."

**Insight:** Sustainable growth requires continuously layering new growth models (PLG, SLG, MLG) to find the next S-curve before the current one plateaus.

**Tactical advice:**
- Introduce a new growth loop or channel every 18 months to diversify the growth engine.
- Allocate 20-25% of the growth team's annual time to exploring new, unproven growth loops.
- Allow new growth loops 6-18 months to show results before applying strict revenue expectations.

*Timestamp: 00:51:10*

---

> "Growth loops... action, reaction that generates another action and it's a self-contained flywheel they can spin."

**Insight:** Thinking in loops rather than funnels is essential for creating a self-sustaining growth engine.

**Tactical advice:**
- Map out the 'action-reaction' cycle of your product to identify potential flywheels.

*Timestamp: 01:15:32*


## Geoffrey Moore
*Geoffrey Moore*

> "Where product-led growth plays really interestingly, is in the land and expand phases of the market... product-led growth, which is really good at is expand because it prompts the user to get more involved. And that's classically a Main Street play."

**Insight:** Product-led growth (PLG) is most effective for expansion and low-risk adoption rather than crossing high-risk chasms.

**Tactical advice:**
- Use PLG to drive 'expand' motions where the next purchase has low risk.
- Recognize that PLG often requires a sales team overlay to secure enterprise-level 'chasm' deals.

*Timestamp: 01:12:15*


## Gergely
*Gergely*

> "There was a tipping point in April where the newsletter was growing... This was when Substack introduced recommendations, which has been a massive growth engine, and I guess being one of the top publications, I benefited from it."

**Insight:** Platform-native recommendation systems can create powerful, automated growth flywheels for high-performing content.

**Tactical advice:**
- Leverage platform-specific features (like Substack Recommendations) to tap into cross-pollination between similar audiences.

*Timestamp: 00:08:26*


## Gokul Rajaram
*Gokul Rajaram*

> "A good metric is that 40 to 50% of your new customers should ideally come from organic channels and 50% from paid. If 90% come from paid, that means at some point that the music is going to stop."

**Insight:** Sustainable growth requires a high percentage of organic acquisition driven by product remarkability rather than over-reliance on paid media.

**Tactical advice:**
- Monitor the ratio of organic vs. paid customer acquisition
- Ensure the product is 'remarkable' enough that users naturally talk about it

*Timestamp: 00:17:16*


## Grant Lee
*Grant Lee*

> "All the initial influencers, I onboarded manually myself. I would jump on a call with each one of them so that they understood what Gamma represented, how to use the product. You want to be able to have them tell you story but in their voice. I think a lot of people think influencer marketing and they'll think these big trendy creators, people that have a million followers. This is the wrong approach. You basically give them a script to read, immediately feels like an ad. That product is not connected really to them in any way. You're much better doing the hard thing, which is hard to scale, finding the thousands of micro influencers that have an audience where your product maybe is actually useful."

**Insight:** Build a sustainable growth engine by manually onboarding micro-influencers who can authentically share the product in their own voice.

**Tactical advice:**
- Avoid large creators with generic scripts; focus on micro-influencers with high trust.
- Manually onboard early influencers to ensure they deeply understand the product's value.
- Target 'echo chambers' like specific professions (e.g., educators) where word-of-mouth spreads naturally.

*Timestamp: 00:00:25*

---

> "When you're early on, your mindset should almost be like you're trying to create a word of mouth machine. If you can get that part right, everything else becomes significantly easier. And if you have any, and I think this applies to both prosumer, B2C, as well as even B2B products, if you have a B2B product, even if you're not telling all of your friends, you should be telling colleagues where that product is relevant."

**Insight:** Prioritize building a 'word-of-mouth machine' as the core growth engine before investing in paid acquisition.

**Tactical advice:**
- Monitor if a healthy chunk of leads comes from organic recommendations.
- Focus on removing friction in the 'create and share' loop to enable natural virality.

*Timestamp: 00:13:38*


## Hamilton Helmer
*Hamilton Helmer*

> "We laugh whenever we hear somebody say they have a flywheel, which gives you the idea of network economies. There are often flywheels, the ones that really are material, are rare. The key thing here is materiality, not whether the flywheel exists, but whether the effect is strong enough to really tilt returns."

**Insight:** A growth loop or flywheel only provides strategic power if its impact is material enough to significantly alter the company's economic returns.

**Tactical advice:**
- Measure the actual economic impact of your network effects to see if they are 'material' or just 'modest' improvements.

*Timestamp: 00:24:39*


## Gustaf Alstromer
*Gustaf Alstromer*

> "I've seen a lot, and this is when I had to reset my thinking coming from a growth team joining YC, is you can't start a startup ethic with a growth team mindset because that is just scalable things all the time. And really what you need to go back to is doing things that don't scale and unscale your way of thinking about customers."

**Insight:** Scalable growth loops are for later stages; early startups must focus on unscalable, manual customer acquisition.

**Tactical advice:**
- Avoid applying 'growth team' tactics (optimization, loops) before finding product-market fit through manual effort

*Timestamp: 00:57:27*


## Hari Srinivasan
*Hari Srinivasan*

> "Damian, who leads our growth team... starts talking a lot about thinking in loops. How do you make sure that when you're building something you can have the fuel in order to cascade and grow?"

**Insight:** Focus on building sustainable product loops that provide the 'fuel' for continuous growth rather than one-off features.

**Tactical advice:**
- Design features that naturally feed back into user acquisition or engagement cycles

*Timestamp: 00:48:00*


## Ivan Zhao
*Ivan Zhao*

> "We call our internal strategy called B2C2B. All those consumers, personal user use Notion for the most simple way you can use a computer or your phone, which is note-taking or document-sharing. And then they realize, 'Oh, Notion can do more of that.'... Then they bring Notion to work. Half our B2B customers coming from prior personal users."

**Insight:** A B2C2B loop relies on a high-volume personal use case (like note-taking) to act as a Trojan horse for enterprise adoption.

**Tactical advice:**
- Identify a 'top of funnel' use case with over 1 billion potential users (e.g., notes, calendar, email).
- Ensure the transition from personal use to team use is seamless as the user discovers more complex features.

*Timestamp: 00:56:28*


## Julian Shapiro
*Julian Shapiro*

> "Product-led acquisition, meaning the use of the product grows the product. For example, if I'm using PayPal and I'm sending $1,000 to somebody else, there is no way they will not create a PayPal account to accept the $1,000. By me trying to use PayPal in its everyday intention and me getting value out of it to settle a debt, I'm automatically enticing someone else, very strongly so, to also become a PayPal customer."

**Insight:** Product-led acquisition (PLA) is the most scalable growth channel because it has zero marginal cost and is entirely within the company's control.

**Tactical advice:**
- Identify if the product can facilitate 'settling debts' (money, NFTs, etc.) where the recipient must join to claim value
- Introduce chat or social features that require inviting others to partake in a conversation
- Use 'billboarding' by placing branding on the product's output (e.g., 'Sent via Hotmail' or 'Powered by Calendly')

*Timestamp: 13:51*

---

> "If you have a marketplace like eBay or some marketplace for selling collectible shoes or something where you're encouraging users to create beautiful content of the items being sold, like these cool landing pages that show off the products, and they share it elsewhere, then that's an example of users making content they're sharing off platform that is useful for their own followers."

**Insight:** User-generated content (UGC) acts as a growth loop when users are incentivized to share their on-platform creations with their off-platform audiences.

**Tactical advice:**
- Ask if users use the product to make content in any form
- Make the sharing pages as appealing and easy to consume as possible
- Encourage public conversations (like Quora or Reddit) to increase SEO surface area

*Timestamp: 26:05*


## Laura Modi
*Laura Modi*

> "We should not be paying for every customer and we should be very careful that people aren't getting hooked on the drug that is paid marketing or performance marketing... D2C is not dead. How you drive people to D2C, how you acquire customers, how you build sustainable businesses, that needs to change."

**Insight:** Sustainable D2C growth requires moving away from a total reliance on paid performance marketing.

**Tactical advice:**
- Prioritize content and community over commerce to drive organic acquisition.
- Avoid the 'drug' of paid marketing by building long-term SEO and thought leadership.

*Timestamp: 00:46:17*


## Lauryn Isford
*Lauryn Isford*

> "The first step is join, the second is evaluate, the third is upgrade, and the fourth is expand. This funnel represents the journey of a customer in a PLG product as they advance and develop in their lifetime of using the product... expansion drives net dollar retention, it drives brand awareness, it drives more usage in more pockets of the company, it is awesome for renewal rates if you're working with enterprise contracts, and ultimately then also brings new referrals into the product that loop all the way back to the beginning at join."

**Insight:** The PLG funnel (Join, Evaluate, Upgrade, Expand) functions as a loop where expansion within an organization fuels new user acquisition.

**Tactical advice:**
- Map the growth strategy across the four stages: Join, Evaluate, Upgrade, and Expand
- Focus on expansion within existing accounts to drive net dollar retention and referrals
- Identify specific product triggers that move users from the 'Evaluate' stage to 'Upgrade'

*Timestamp: 00:51:35*


## Luc Levesque
*Luc Levesque*

> "The right growth advisor can have literally company changing impact where they're either building or helping to ideate or helping to implement a growth loop that literally changes the company. As we know, you need a great product and you need a great growth loop. And it's usually just one loop that you need to get right."

**Insight:** Most successful companies scale primarily through one dominant, well-executed growth loop.

**Tactical advice:**
- Focus on identifying and dominating one primary growth channel rather than diversifying too early
- Look for advisors who have deep experience in the specific loop (SEO, Viral, Paid) relevant to your product

*Timestamp: 00:23:15*

---

> "I've always thought of LinkedIn as just such a great example of this where you have this viral loop where if you recall when it was just starting, everybody was getting these invites from LinkedIn... the byproduct is when people join, they create this beautiful lightning page, which is your profile that gets indexed. It's kind of like a viral loop feeding an SEO loop that continues to grow."

**Insight:** The most powerful growth engines combine different types of loops, such as a viral acquisition loop feeding an SEO content loop.

**Tactical advice:**
- Design product flows where user acquisition naturally creates indexable content
- Look for ways to make the byproduct of one loop (e.g., registration) the fuel for another (e.g., SEO pages)

*Timestamp: 00:44:40*


## Melissa Tan
*Melissa Tan*

> "The signal is that is a good motion for you is if the product is really intuitive to onboard onto. There's a low learning curve so you don't need a human to onboard the user. Also, if there's a viral component to it, that is really what can take."

**Insight:** Product-led growth loops require a low-friction onboarding experience and inherent virality to scale without human intervention.

**Tactical advice:**
- Evaluate if the product can be onboarded without a salesperson
- Identify viral triggers within the core product workflow
- Monitor for 'bottom-up' adoption signals from enterprise users in self-serve data

*Timestamp: 00:12:12*


## Merci Grace
*Merci Grace*

> "It's a lot easier to get someone to send more invites than it is to get someone who's a little shy to even send one. So I thought it was much easier to get those people to share the product with bigger groups of folks than it would be to get someone who's just not like that."

**Insight:** Growth strategies should focus on empowering 'social' personas who are naturally inclined to invite others.

**Tactical advice:**
- Identify and target the 'connector' persona within your user base to drive referrals.

*Timestamp: 23:16*

---

> "You need to have invites early and often so that you catch people who want to share it, are social people. And then for the people who would never participate in that, they can ignore it or skip it. But that doesn't mean that it shouldn't be all over the entire product."

**Insight:** Don't let the feedback of non-sharers prevent you from placing invite prompts where social users can find them.

**Tactical advice:**
- Place invite screens early in the onboarding flow, even if some users find it premature.
- Make invites optional but ubiquitous throughout the product.

*Timestamp: 24:17*


## Nikita Bier
*Nikita Bier*

> "With certainty, if you're good at your job, you can make an app grow and go viral. Over the years of building all these apps, I've accrued all these growth hacks that still nobody knows about."

**Insight:** Viral growth is a repeatable science that can be mastered through specific tactical mechanisms.

**Tactical advice:**
- Develop a library of growth hacks based on platform-specific mechanisms

*Timestamp: 00:01:48*

---

> "We found that as a user got older from age 13 to 18, the number of people that they invite to an app just declines almost exponentially."

**Insight:** Virality is significantly easier to achieve with younger cohorts because their invitation rate is much higher.

**Tactical advice:**
- Target users aged 13-18 if you want to achieve organic network effects without ad spend

*Timestamp: 00:10:55*

---

> "To be convinced to download an app, you need to see it... three times or so. So you basically need to saturate an area with every kind of marketing you can."

**Insight:** Density and frequency of exposure are required to trigger mass adoption in a specific community.

**Tactical advice:**
- Saturate a specific geographic area or community with multiple marketing touchpoints simultaneously
- Use targeted ads and social media follows to create an illusion of ubiquity

*Timestamp: 00:29:37*

---

> "I have a whole laundry list of iOS mechanisms that people use for a certain way today, but you could invert them... Contact sync is a great example because you sync your contacts and then it finds all the friends and then ranks the people who are not on the app yet but have a bunch of friends on it."

**Insight:** High-growth apps leverage existing platform APIs in non-traditional ways to reduce friction for user connection.

**Tactical advice:**
- Use contact sync to identify and rank non-users with the highest number of existing connections on the platform

*Timestamp: 01:30:59*


## Oji Udezue
*Oji Udezue*

> "Virality is really when the word of mouth of a product is high quality... It's when customers market your product. And that is incredibly powerful, but also that's incredibly actionable."

**Insight:** True virality is 'customer augmented marketing' where the product's value is so high that users naturally promote it, reducing marketing spend.

**Tactical advice:**
- Build a great product that solves a sharp problem as the bedrock before applying viral tactics.
- Distinguish between 'synthetic virality' (referral loops) and 'bedrock virality' (word of mouth driven by workflow compression).

*Timestamp: 00:50:36*

---

> "Network effects is when you create value for passive members by other people joining the network... Network effects is a feature by itself, and it's the most powerful feature."

**Insight:** Network effects create a 'critical mass' that makes a product extremely difficult to displace, even by well-funded competitors.

**Tactical advice:**
- Identify if your product creates value for existing users when new users join (e.g., file formats, communication networks).
- Understand that a network effect business can survive even if the revenue model is under attack, as long as the activity spiral remains.

*Timestamp: 00:46:12*


## Noam Lovinsky
*Noam Lovinsky*

> "I think that one channel growth company is always a no-no. ... we just went back to first principles on a lot of that and also just kind of reformed a team around that and basically got an amazing team together. ... we already had really good showing in SEO and really good patriarch and SEO helped to bolster things like SEM and then eventually Facebook as well."

**Insight:** Avoid over-reliance on a single growth channel by diversifying into paid, organic, and referral loops to prevent catastrophic failure if one channel dries up.

**Tactical advice:**
- Audit growth channel concentration to identify single points of failure
- Use established channels (like SEO) to provide data and momentum for testing new channels (like SEM)

*Timestamp: 00:22:44*


## Patrick Campbell
*Patrick Campbell*

> "Customers who convert from freemium and become paid customers, their retention is typically about 10 to 20% higher than those who converted from a free trial or converted from a traditional sales process."

**Insight:** Freemium creates a 'pool' of leads in the middle of the funnel who convert on their own timeline, leading to higher satisfaction and better long-term retention.

**Tactical advice:**
- Use freemium as a way to build a pool of users who are already aware of and using the product
- Invest in 'inbound media' (podcasts, video series) to keep leads engaged in the middle of the funnel
- Allow customers to convert based on their own timing rather than artificial trial deadlines

*Timestamp: 01:02:07*


## Richard Rumelt
*Richard Rumelt*

> "The power that new business models are exploiting is the power of the user base. What we called years ago, network effects, where the more users you have, the more useful a product is."

**Insight:** Network effects create a powerful asymmetry where the size of the user base directly increases product value.

**Tactical advice:**
- Analyze if your product has potential for network effects where more users make it more useful for everyone.

*Timestamp: 00:35:02*


## Ramesh Johari
*Ramesh Johari*

> "The choice you're facing is, how do I take advantage of having that one side scaled to attract the other side? ... Uber... would just hand out coupons for free rides at events, parties, things like that, to take people home. And that was a way of saying, 'Hey, we're subsidizing the drivers in the city. That's our scaled side. Now we're going to use that subsidized driver base to attract riders.'"

**Insight:** Kickstart a marketplace flywheel by using scaled liquidity on one side to subsidize and attract the other side.

**Tactical advice:**
- Identify which side of the market is easier to scale first and use it as a 'subsidy' to attract the harder-to-get side.

*Timestamp: 00:24:05*


## Rahul Vohra
*Rahul Vohra*

> "It is word of mouth. It is the virality you can't measure that isn't a mechanic that isn't in a feature. It is when one user spontaneously tells another user about your product."

**Insight:** True virality is driven by unmeasurable word-of-mouth rather than just engineered viral mechanics.

**Tactical advice:**
- Focus on creating a product that people spontaneously tell others about.
- Recognize that most viral features have a decay rate and won't sustain growth alone.

*Timestamp: 00:09:10*


## Sachin Monga
*Sachin Monga*

> "What if we just ask writers, who do you recommend? What if we just put that in the subscribe flow and just made it as simple as possible?... It created this goodwill viral loop, which was really interesting to see play out."

**Insight:** Growth loops can be powered by 'goodwill' where supply-side users recommend each other, creating a decentralized discovery network.

**Tactical advice:**
- Look for organic user behaviors (like guest posting or cross-linking) and productize them into simple flows.
- Insert recommendation prompts at high-intent moments, such as immediately after a user subscribes.

*Timestamp: 00:26:05*


## Sarah Tavel
*Sarah Tavel*

> "The biggest thing that you can do is a network effect. The more I pin something on Pinterest, the better the experience for every user on Pinterest. Every time I add a pin to a board, I'm creating a new edge in Pinterest Graph, that Pinterest then uses to create recommendations and enrich their understanding of all those objects on Pinterest."

**Insight:** Network effects are the strongest growth loops because user actions automatically improve the product for others.

**Tactical advice:**
- Convert user 'kinetic energy' (clicks/taps) into data that improves the experience for the whole network

*Timestamp: 00:14:55*

---

> "How do you get it so that, as your users use the product, they want to share it with other people? They create metadata that you can then use for SEO. You have collaborative experiences that pull other people in. There's all different things you can do here. And then, there's also things that you can do to re-engage a user."

**Insight:** Effective growth loops leverage user activity to acquire new users or re-engage dormant ones without manual intervention.

**Tactical advice:**
- Build features where users naturally invite others into a collaborative experience
- Use automated notifications triggered by one user's action to pull another user back in

*Timestamp: 00:15:42*

---

> "I think every marketplace has to figure out what I call tipping loops. And there's two types of tipping loops that work together symbiotically to help a marketplace scale. The first are the growth loops."

**Insight:** Marketplace scaling requires growth loops where one side of the market (supply or demand) naturally brings in the other.

**Tactical advice:**
- Identify 'seller-to-buyer' loops where suppliers invite their own customers to the platform
- Incentivize referrals to turn existing participants into acquisition channels

*Timestamp: 01:04:10*


## Sean Ellis
*Sean Ellis*

> "A referral program where we have incentives on both sides is the best way to go. ... it's a great accelerant when it's already working, but it can't fix it if people don't want to talk about your product."

**Insight:** Referral loops are most effective when they amplify existing organic word-of-mouth rather than trying to manufacture it.

**Tactical advice:**
- Implement double-sided incentives (rewarding both the referrer and the referee).
- Only invest heavily in referral programs once you have a baseline of organic word-of-mouth.

*Timestamp: 01:12:47*


## Seth Godin
*Seth Godin*

> "If you don't build the network effect into what you are making, you are almost certainly going to fail... The question is, will this work better for my users if they tell other people about it? And if the answer is no, then why would they tell other people about it?"

**Insight:** Sustainable growth is driven by products that inherently provide more value to the user when they bring others into the system.

**Tactical advice:**
- Evaluate if the product's utility increases as the user's network joins.
- Design features that incentivize word-of-mouth by making the user's life better when they share.

*Timestamp: 15:14*


## Shishir Mehrotra
*Shishir Mehrotra*

> "The Black Loop is someone comes in, they make a doc, they share with a group of people, some subset of the people turn around and make another doc, and the process repeats itself over and over again. The blue loop is someone comes in, makes a doc, and instead of sharing it with a team or with the collaborators, they publish it to the world."

**Insight:** Growth can be driven by internal collaboration loops (Black Loops) and external publishing/content loops (Blue Loops).

**Tactical advice:**
- Identify if your product has a 'collaboration' loop versus a 'publishing' loop.
- Design loops that allow users to solve problems and then share those solutions to attract new users.

*Timestamp: 00:09:25*


## Shaun Clowes
*Shaun Clowes*

> "Growth organizations are in this interesting space, they're in between everybody else. They're in everybody else's sandpit in a little bit, in a little way, and they're kind of at the edge of everybody's full-time job and they are very valuable, but they can be complicated because of all those relationships."

**Insight:** Growth teams succeed by navigating cross-functional boundaries and operationalizing experiments that sit between product, marketing, and sales.

**Tactical advice:**
- Focus on the 'connective tissue' between departments to find growth opportunities that traditional silos miss.

*Timestamp: 00:49:27*

---

> "For really sophisticated companies, the people who really nail this, it's about making both motions work together. If you can get a PLG motion work to feed your sales team and a sales team motion work to feed your PLG funnel when the sales leads aren't ready yet and you can get those motions into playing with each other, you can make a lot of money."

**Insight:** The most resilient B2B businesses combine product-led growth and enterprise sales into a single, reinforcing flywheel.

**Tactical advice:**
- Design loops where self-serve users become leads for sales, and sales-rejected leads are nurtured back into self-serve funnels.

*Timestamp: 00:53:52*


## Sri Batchu
*Sri Batchu*

> "one of the things that they did is what I call cap table as a growth strategy where they did a great job of getting a large number of early stage founders and other influential operators and advisors onto the cap table at the company."

**Insight:** Using your cap table as an acquisition channel by recruiting influential founders as investors can seed initial high-quality customers and word-of-mouth.

**Tactical advice:**
- Target early-stage founders and influential operators for the cap table to act as initial customers
- Leverage investor networks for introductions, but prioritize the 'customer-investor' feedback loop

*Timestamp: 00:07:15*


## Sriram and Aarthi
*Sriram and Aarthi*

> "When you have a new network, think of it as a new country, you want the high status people and high status mean they're interesting, people want to be where they are... And there's exactly an interesting corollary that they're often underserved by other existing platforms."

**Insight:** Bootstrapping a social network requires attracting high-status individuals who are underserved by current platforms.

**Tactical advice:**
- Identify 'high-status' users who are not yet dominant on existing platforms.
- Create a platform that rewards a different set of skills (e.g., audio vs. video vs. text) to attract new talent.

*Timestamp: 00:10:56*


## Tomer Cohen
*Tomer Cohen 2.0*

> "We have a growth agent... LinkedIn has a very unique... we've kind of funneled all of our unique loops, our funnels, our tests of the past, everything into this growth agent, and now you can basically rock your respect for it, your idea for it. And it would not just allow you to do it better. It would actually critique how good is your idea."

**Insight:** A growth agent trained on historical experiment data can critique new ideas and identify the highest-leverage growth opportunities.

**Tactical advice:**
- Codify historical growth experiments and funnels into an AI agent
- Use AI to critique the growth potential of new product specs

*Timestamp: 00:19:53*


## Tim Holley
*Tim Holley*

> "on the seller side... it costs 20 cents to list an item... we really leaned into that as the currency for the seller referral program... If I refer them, they'll get some listing credits. It'll be easier for them to open their shop. And then when I need to list more items, I also have credits that I can apply."

**Insight:** Using internal platform currency as a referral incentive reduces friction for new users and rewards existing ones without direct cash outlay.

**Tactical advice:**
- Identify a low-cost, high-value internal 'currency' to use for referrals.
- Target referral programs at specific communities where word-of-mouth is already happening.

*Timestamp: 00:41:15*


## Uri Levine
*Uri Levine*

> "Word-of-mouth you can only have if you have high frequency of use... If you're using Waze every day, then every day you have an opportunity to tell someone else. So word-of-mouth, even though that everyone would like that, it's only going to happen if you have high frequency of use."

**Insight:** Sustainable word-of-mouth growth is fundamentally tied to how often users engage with the product.

**Tactical advice:**
- Focus on high frequency of use to trigger organic word-of-mouth.
- If frequency is low, rely on 'coolness' or unique experiences to drive referrals.

*Timestamp: 00:32:14*


## Yuriy Timen
*Yuriy Timen*

> "If you have really healthy LTVs... then there is a big opportunity to play paid and lean into paid growth loops and paid acquisition loops."

**Insight:** High customer lifetime value (LTV) is the primary prerequisite for scaling paid acquisition loops.

**Tactical advice:**
- Calculate if single-player LTVs are high enough (e.g., hundreds of dollars) to support paid loops.

*Timestamp: 00:11:26*

---

> "The first thing you look for is that, is there inherent product network effects? It's something that it's either there, or isn't from inception from my experience. I think it's very difficult to manufacture. You'd only study when... It's very hard to manufacture product network effects if they aren't there from the get go."

**Insight:** Network effects are usually inherent to the product's core utility and are difficult to add as an afterthought.

**Tactical advice:**
- Identify if utility increases for existing users as new users join (e.g., marketplaces or collaboration tools) before trying to build viral loops.

*Timestamp: 00:13:47*

---

> "I think that surprising thing to people probably is that it's also the case with some later stage companies. It's not just early stage companies that are kind of one trick pulleys. Sometimes it's later stage companies as well."

**Insight:** Even large, successful companies often rely on a single dominant growth engine (80/20 rule).

**Tactical advice:**
- Identify the primary growth engine and maximize it before diversifying too early.
- Monitor the risk of over-reliance on a single channel (e.g., Google algorithm updates or Meta ad costs).

*Timestamp: 00:39:35*

---

> "I actually have to talk them out, focusing on diversification too early. Contrast that with some later stage companies for who are... At scale, I know 50 plus million ARR, 90 plus percent reliant on a single acquisition channel, which just mire with risk and diversification is a blind spot for them."

**Insight:** Early-stage companies should focus on one working engine, while late-stage companies must aggressively diversify to mitigate platform risk.

**Tactical advice:**
- For early-stage: Put all energy into the one tactic accounting for 80%+ of acquisition.
- For late-stage: Carve out resources to explore new channels once the primary engine is at scale.

*Timestamp: 00:41:17*


## Zoelle Egner
*Zoelle Egner*

> "We knew if we can get to the right people and we can connect the dots to them to the correct use case... they'll be able to go to their friends and say, 'Hey, I'm using Airtable as a content calendar, but you have a UX research problem. And I understand Airtable enough that I can help you build a system. And now I'm a superhero internally.'"

**Insight:** Internal virality is driven by empowering 'champions' to solve problems for their colleagues, making the champion look like a 'superhero.'

**Tactical advice:**
- Identify 'tinkerer' personas who enjoy building systems for others
- Provide champions with the tools to easily replicate their success for other departments
- Focus on 'inside-of-company' virality to scale from small teams to entire organizations

*Timestamp: 00:41:32*


## Hila Qu
*Hila Qu*

> "PLG motion is perfect for lowering the barrier for more people to try, broader the reach. It's a kind of volume kind of game. And then the sales motion, you can have very targeted list of big customers you go after, you close them and it's a big order."

**Insight:** Product-led growth (PLG) serves as a high-volume acquisition engine that complements a targeted sales motion.

**Tactical advice:**
- Use PLG to lower barriers to entry and broaden reach
- Combine PLG with a sales motion for high-value enterprise targets

*Timestamp: 00:05:25*

---

> "The biggest difference from SLG and PLG is that the sales funnel traditionally work like something... Product-led funnel is different. It's much more similar to B2C. Basically you can still have people visit your website and they sign up for free version or free account or free trial. The most important thing, the biggest difference, is now you want them to use the product."

**Insight:** The core of a PLG funnel is product usage rather than just lead interaction with marketing materials.

**Tactical advice:**
- Focus on product usage as the leading indicator for success
- Allow users to access the product before signing a contract

*Timestamp: 00:25:12*

---

> "A product-led acquisition is a great place to invest, if you have a collaboration workflow, you have some inherent, internal viral components in your products. Think about Figma, think about Calendarly even, right? It can spread. This product is so easy. You can build something to allow it to spread on its own."

**Insight:** Products with collaborative workflows have inherent viral loops that can be optimized for acquisition.

**Tactical advice:**
- Identify internal viral components in collaborative products
- Build features that allow the product to spread through user invitations

*Timestamp: 00:51:18*


## Jeanne Grosser
*Jeanne Grosser*

> "PLG makes sense for a lot of companies at the outset... The thing that folks get wrong is it does typically have a ceiling. So people are generally not going to give you $1 million via self-serve flow. So at some point if you want to sustain growth rates, you're going to have to have your deal sizes get bigger and bigger."

**Insight:** Product-led growth is effective for early scale but eventually requires a sales layer to capture large enterprise deals.

**Tactical advice:**
- Layer in sales before the PLG ceiling hits to maintain growth rates.

*Timestamp: 01:14:28*


## Peter Deng
*Peter Deng*

> "One of the first things I did was always to build a growth team... when you hire the right person, they start asking all the right questions because... they are so into this experimentation side, it actually is this really easy thing to do is when you start building a growth team, it just begets all of the right questions being asked."

**Insight:** A growth team acts as a catalyst for organizational rigor by forcing instrumentation and data-driven experimentation.

**Tactical advice:**
- Hire a growth leader to drive the logging of key metrics and systematic analysis
- Use growth experimentation to uncover hidden product frictions

*Timestamp: 00:44:19*


## Carilu Dietrich
*Carilu Dietrich*

> "In order to get hypergrowth, you have to have organic, inbound, and viral word of mouth."

**Insight:** Hypergrowth requires viral mechanics - paid acquisition alone cannot achieve it.

**Tactical advice:**
- Build natural viral points
- Create user group communities

*Timestamp: 00:25:08*


