---
name: energy-management
description: Help users manage their energy for sustained performance. Use when someone is feeling burned out, trying to find their zone of genius, scheduling for productivity, or identifying what drains vs energizes them.
---

# Energy Management

Help the user manage their energy for sustained performance using frameworks from 5 product leaders who have optimized their personal productivity and avoided burnout.

## How to Help

When the user asks for help with energy management:

1. **Diagnose the current state** - Help them identify what's draining vs energizing them
2. **Audit their calendar** - Review how they're spending time and categorize by energy impact
3. **Design for their superpowers** - Help them spend more time in their zone of genius
4. **Create sustainable rhythms** - Build routines that protect energy over time

## Core Principles

### Schedule for energy, not just time
Anneka Gupta: "Being able to manage my energy levels and figuring out how to schedule my time for my energy has really allowed me also to figure out how to have that abundant mindset in all situations." Manage mental and emotional energy, not just calendar slots.

### Identify energy drivers and drains
Bob Moesta: "Think of moments where you actually go into a situation and you get energy from it. At the same time, those moments where you go in and you get the life sucked out of you - that's an experience." Use this framework to identify what to pursue and what to delegate.

### Audit your calendar by energy impact
Claire Vo: "Categorize the way you're spending your time into those buckets, and then put the bottom buckets away. Just focus on that top bucket and go, 'How can I be here more?'" Find your 'zone of genius' work and delegate energy-zapping tasks.

### Use superpowers to create energy
Donna Lichaw: "If you subscribe to this idea of managing your energy, not your time, this will help you do that. If you're using your superpowers, you will have more energy." Working in your strengths generates energy rather than depleting it.

### Pay attention to post-activity energy
Paul Millerd: "Pay really close attention to what gives you energy after you do the thing. Say you have a call. Did that give you energy or did that sap you of energy?" Track what energizes vs saps you after every interaction or task to guide career direction.

## Questions to Help Users

- "What activities give you energy after you do them?"
- "What's on your calendar this week that you're dreading?"
- "If you categorized your work by energy impact, what would be in the 'zone of genius' bucket?"
- "Are you using your superpowers regularly, or mostly doing things that drain you?"
- "What could you delegate to create space for energy-giving work?"

## Common Mistakes to Flag

- **Ignoring energy signals** - Pushing through energy drains without addressing the root cause
- **Optimizing only for time** - Filling calendars efficiently without considering energy impact
- **Avoiding delegation** - Holding onto draining tasks because 'it's faster if I do it'
- **No recovery time** - Scheduling back-to-back draining activities without breaks
- **Treating all tasks equally** - Not distinguishing between work that energizes vs depletes

## Deep Dive

For all 5 insights from 5 guests, see `references/guest-insights.md`

## Related Skills

- Running Effective 1:1s
- Having Difficult Conversations
- Delegating Work
- Managing Up
