---
name: engineering-culture
description: Help users build strong engineering culture. Use when someone is improving developer experience, fostering technical excellence, designing engineering practices, or scaling an engineering organization.
---

# Engineering Culture

Help the user build strong engineering culture using frameworks from 19 product leaders who have built high-performing engineering organizations.

## How to Help

When the user asks for help with engineering culture:

1. **Diagnose the current state** - Understand their team size, practices, and pain points
2. **Identify the bottleneck** - Determine if the issue is DevEx, org structure, talent, or process
3. **Design for the right outcomes** - Focus on speed, stability, and developer satisfaction
4. **Balance structure with autonomy** - Help calibrate how much process is needed

## Core Principles

### DevOps is capabilities, not tools
Nicole Forsgren: "DevOps is not a toolchain you buy. Marketing teams labeled toolchains DevOps because they wanted your money. DevOps is a set of capabilities - technical capabilities, architectural capabilities, cultural capabilities, and lean management practices." Focus on integrated capabilities, not just implementing specific tools.

### Conway's Law is powerful
Dhanji R. Prasanna: "Conway's Law can be really, really powerful. You ship your org structure. What you're organized as in terms of teams and collaborating groups matters a lot to what you build." Organizational structure directly dictates architecture and product quality.

### Engineers are becoming architects
Scott Wu: "We've thought about Devin as really allowing engineers to go from bricklayer to architect. A lot of it is just getting to the point where you can do the high-level directing and specify things exactly how you want." The future of engineering involves shifting humans from manual coding to architectural oversight.

### DevEx is the foundation
Nicole Forsgren: "Developer Experience is what it's like to build software, day to day. The friction they face, the workflows they have to go through. It's important because when DevEx is poor, everything else just isn't going to help." Flow state, cognitive load, and feedback loops are the three pillars.

### Optimize for clock speed
Albert Cheng: "The product experience of Duolingo actually changes multiple times per day for each user. They care a lot about the clock speed of the company." High-performance engineering culture is built around extreme experimentation frequency.

### Require all functions to touch code
Brandon Chu: "All project management was just in GitHub, just commenting on PRs, and even marketers in order to upload a blog post, you'd have to commit and deploy it." Build technical culture by requiring all functions to engage directly with engineering tools.

### High talent density reduces process need
Michael Truell: "We've been able to get away with not a ton of process yet on the engineering front by hiring people who are really excellent, level-headed, people who are less focused on external validation, more focused on building something really great." Hire for disposition to reduce organizational overhead.

### Pair programming is underutilized
Farhan Thawar: "Pair programming is the most underutilized management tool in engineering, bar none. The throughput limiter is not hands-on keyboard. It's where is the good elegant solution?" Use pairing for knowledge transfer and finding elegant solutions.

## Questions to Help Users

- "What's the biggest friction point in your developers' daily workflow?"
- "How does your org structure map to your product architecture?"
- "How much time do engineers spend in flow state vs in meetings?"
- "What's your team's 'clock speed' - how often can you ship and test changes?"
- "Do non-engineering roles understand the deployment workflow?"

## Common Mistakes to Flag

- **Buying tools instead of building capabilities** - Expecting a DevOps toolchain to fix cultural problems
- **Ignoring Conway's Law** - Org structure that doesn't match desired product architecture
- **Neglecting DevEx** - Poor developer experience undermines all other investments
- **Over-processing high-talent teams** - Adding unnecessary bureaucracy to excellent teams
- **Code quality over customer value** - Prioritizing perfect architecture over solving user problems

## Deep Dive

For all 23 insights from 19 guests, see `references/guest-insights.md`

## Related Skills

- Technical Roadmaps
- Managing Tech Debt
- Platform & Infrastructure
- Design Engineering
