---
name: enterprise-sales
description: Help users navigate enterprise sales. Use when someone is closing large deals, managing complex buying committees, handling procurement, or converting PLG users to enterprise contracts.
---

# Enterprise Sales

Help the user navigate enterprise sales using frameworks from 9 product leaders who have closed large enterprise deals at companies from Stripe to Superhuman.

## How to Help

When the user asks for help with enterprise sales:

1. **Identify the stage** - Determine if they're prospecting, in discovery, navigating procurement, or closing
2. **Map the buying committee** - Help them identify the champion, economic buyer, and other stakeholders
3. **Address indecision** - Focus on overcoming customer fear of messing up, not just building FOMO
4. **Navigate procurement** - Guide them through the administrative and compliance requirements

## Core Principles

### 40-60% of deals die to indecision
Matt Dixon: "Our analysis showed that anywhere between 40 and 60% of the average salesperson's qualified pipelines will be ultimately marked as closed loss, no decision." Most deals are lost not to competitors, but to customer inertia and fear.

### Identify and arm the champion
April Dunford: "Typically we have between five and seven people involved in what we call making the decision. By far the most important persona is what we call the champion - this person's job is to get consensus and champion the deal across everybody." Arm them with materials for IT, Legal, and the Economic Buyer.

### FOMU beats FOMO
Matt Dixon: "The omission bias is the fact that people don't want to be blamed for making decisions that lead to a loss. People are okay with missing out. They are not okay with messing up and being blamed." Address Fear of Messing Up, not just Fear of Missing Out.

### Make procurement's job easy
Jen Abel: "When you get to procurement, you're going to have to do all the work. Make their job easy. Give me the forms that you need to fill out. I'll fill them out for you." Proactively handle the administrative burden to avoid being sidelined.

### POCs are for business cases, not demos
Madhavan Ramanujam: "The POC should be framed as the entire goal of the POC is to create a business case, period, full stop. It is not to demonstrate product functionality." Treat POCs as collaborative exercises to build ROI models.

### PLG to enterprise is an escalator
Elena Verna: "Product-led sales converts the usage that you've generated via self-serve into a sales opportunity and it attaches a salesperson to close a much larger contract." Identify the escalator from individual use case to enterprise-level solution.

### Under-promise, over-deliver
Matt Dixon: "What great salespeople do is they know that while they'll stand by those claims, they try to under-promise and over-deliver. Build your business case around a 5X improvement, then let's set up to over-deliver against that." Build cases around conservative, 100% achievable numbers.

### Use the JOLT method
Matt Dixon outlines four steps to overcome indecision: Judge the level of indecision, Offer a firm recommendation, Limit exploration by building trust, Take risk off the table by de-risking the deal.

## Questions to Help Users

- "Who is the champion inside the account and what do they need to succeed?"
- "What would cause this deal to die to 'no decision'?"
- "What's the buyer's biggest fear about messing up?"
- "Have you identified the final signatory and what they care about?"
- "Are you building the business case collaboratively or presenting it?"
- "What can you do to de-risk this decision for the buyer?"

## Common Mistakes to Flag

- **Relying on FOMO alone** - Dialing up urgency without addressing the fear of being blamed for failure
- **Ignoring the champion** - Selling to the economic buyer directly instead of arming an internal advocate
- **Passive procurement** - Waiting for buyers to navigate internal processes instead of doing it for them
- **Demo-focused POCs** - Treating proof of concepts as technical tests instead of business case exercises
- **Best-case projections** - Building business cases around optimistic numbers that set up for disappointment

## Deep Dive

For all 25 insights from 9 guests, see `references/guest-insights.md`

## Related Skills

- Founder Sales
- Building Sales Team
- Partnership & BD
- Product-Led Sales Strategy
