# Enterprise Sales - All Guest Insights

*9 guests, 25 mentions*

---

## Andy Raskin
*Andy Raskin_*

> "I think it does really play well in this enterprise sales context because also we have a group buyer there. So it's not just one person who's doing some research. This whole group has to have a uniting story."

**Insight:** Enterprise sales require a high-level narrative to align diverse stakeholders within a buying committee.

**Tactical advice:**
- Use a strategic narrative to provide 'air cover' for sales teams in complex deals.

*Timestamp: 00:44:16*


## April Dunford
*April Dunford*

> "typically we have between five and seven people are involved in what we call making the decision for what gets bought. ... So by far the most important persona that matters is that one. We call this the champion in the account because this person, their job is to get consensus and champion the deal across everybody, including their boss, who's the actual economic buyer, the person that writes the check."

**Insight:** In complex B2B deals, the primary goal is identifying and arming a 'champion' who can navigate the internal buying committee.

**Tactical advice:**
- Identify the 'champion' who will drive consensus internally
- Arm the champion with materials to sell to IT, Legal, and the Economic Buyer

*Timestamp: 00:54:24*

---

> "In B2B, typical purchase process, we have five to seven people involved in making the deal happen... it is on you to arm that champion to handle all the objections potentially of all the other groups."

**Insight:** In complex sales, your primary job is to equip your internal champion with the specific information needed to overcome objections from other stakeholders like IT, legal, or finance.

**Tactical advice:**
- Identify the 'champion' who is tasked with the research and shortlisting.
- Provide the champion with specific collateral for other departments (e.g., SOC 2 compliance for IT, ROI calculators for the boss).
- Anticipate common objections from purchasing or security based on previous deals and address them proactively.

*Timestamp: 00:31:49*


## Claire Butler
*Claire Butler*

> "Microsoft was like, "Wait a minute. We need to organize this. We need security. We need account management. We need procurement involved."... they wanted us to have this enterprise product, because they had these requirements and they wanted to have a better control over it, because it was just popping up within the organization without their control."

**Insight:** In a bottom-up model, enterprise sales often begins when a large organization demands control and security for existing organic usage.

**Tactical advice:**
- Use organic adoption 'clusters' as the lead-in for enterprise conversations
- Focus enterprise product features on administrative control, security, and procurement requirements

*Timestamp: 00:26:55*


## Elena Verna
*Elena Verna 2.0*

> "Product-led sales converts the usage that you've generated via self-serve into a sales opportunity and it attaches a salesperson to close a much larger contract, which can be 15, 20, a hundred thousand dollars in order to bring an enterprise-level solution to a company that has already been using it in a self-serve manner."

**Insight:** Product-led sales acts as a bridge to convert individual self-serve usage into high-value enterprise contracts.

**Tactical advice:**
- Identify the 'escalator' from an individual use case to an enterprise-level solution
- Use sales to tell the story of organizational value that the product alone may fail to communicate

*Timestamp: 00:09:15*

---

> "90% of product-led sales is converting the usage into an opportunity by finding a buyer outside, by finding the decision-maker outside. This is where marketing and sales are so crucial in the process. Connecting that decision-maker to the usage and then driving an opportunity through sales funnel all the way to closed one deal."

**Insight:** Most PLS opportunities require finding an external buyer and connecting them to existing internal product usage.

**Tactical advice:**
- Differentiate between Product Qualified Accounts (PQA) and Product Qualified Leads (PQL)
- Use marketing to bring in MQLs (Marketing Qualified Leads) to connect with active PQAs

*Timestamp: 00:20:08*

---

> "One of the most important things is to create network effects within the company... any new sign-up that happens from the company that already has an account in my system should be presented with an option to join that account, not just create a brand new account."

**Insight:** Consolidating individual users into a single company account is critical for identifying enterprise sales opportunities.

**Tactical advice:**
- Implement 'push' and 'pull' mechanisms to get users into shared company accounts
- Look for a 'magic number' of users (often 7+) as a signal for enterprise readiness

*Timestamp: 00:43:06*


## Jen Abel
*Jen Abel*

> "When you get to procurement, you're going to have to do all the work. Make their job easy. ... Give me the forms that you need to fill out. I'll fill them out for you, and you can do it yourself."

**Insight:** Procurement is a professional buying function that requires the seller to handle the administrative burden to avoid being sidelined.

**Tactical advice:**
- Proactively offer to fill out procurement forms for the buyer.
- Differentiate clearly from 'preferred vendors' to avoid being told to use an existing solution.
- Truncate contracts into separate service and technology agreements to bypass IT due diligence backups.

*Timestamp: 00:52:05*

---

> "Know who the signature is, because if they don't know what they're looking at, they're going to kick it out and you're going to lose your queue spot."

**Insight:** Identifying the final signatory (CFO, Legal, etc.) early is critical to prevent deals from stalling at the very last step.

**Tactical advice:**
- Ask the procurement lead exactly who the signatory is and what they care about.
- Provide the buyer with a few bullet points specifically designed for the signatory to explain the value.

*Timestamp: 00:59:32*

---

> "I say the mid-market doesn't exist because what is a mid-market hire? It's either low end enterprise or upper end SMB, and if you bleed those two games you're going to lose. They're so distinctly different."

**Insight:** The 'mid-market' is a dangerous middle ground; companies should instead commit to either the SMB or Enterprise sales model to avoid hiring and strategy mismatches.

**Tactical advice:**
- Define whether you are targeting the upper end of SMB or the lower end of Enterprise.
- Avoid hybrid sales approaches that attempt to bridge SMB and Enterprise tactics.

*Timestamp: 00:07:04*

---

> "Early adopters are those logos because they have to continue to stay at the number one spot. So they'll take tons of swings to continue to stay in the ... Staying in the number one spot is the hardest part. So those number one logos are like if you can give me just a slight bit of alpha, just a tiny bit, that's where I get promoted, that's where I get the pat on the back because we are the world's leader in our industry and we cannot be disrupted there."

**Insight:** Tier 1 market leaders are often better early adopters than smaller companies because they are highly motivated to maintain their lead through innovation.

**Tactical advice:**
- Target industry leaders (e.g., Walmart, McDonald's) early to gain massive proof of concept.
- Pitch 'alpha' or a competitive edge that helps the executive maintain their market-leading position.

*Timestamp: 00:08:30*

---

> "It's more of an art. It's all about deal crafting. It is a relationship you're building with someone. If they know they can call on you, people will turn over rocks for you."

**Insight:** Enterprise sales is a creative process of relationship building and custom deal structuring rather than a rigid, repeatable science.

**Tactical advice:**
- Build direct relationships that allow for communication via text rather than just email.
- Co-author the deal structure with the client to ensure it's a 'win' they can defend internally.

*Timestamp: 00:00:52*

---

> "If they have a very immature way of understanding the problem or they've never purchased technology to solve it to some extent... selling them as service, even though the technology is powering it on the backend is the fastest way to get your foot in the door."

**Insight:** Selling services is often the easiest way to enter an enterprise because it fits their existing procurement habits and builds trust for future software adoption.

**Tactical advice:**
- Bundle technology with services to reach a higher ACV (75K-150K).
- Use software to power the service behind the scenes to prove value before upselling the platform.

*Timestamp: 00:40:13*


## Madhavan Ramanujam
*Madhavan Ramanujam 2.0*

> "The POC should be framed as the entire goal of the POC is to create a business case, period, full stop. It is not to demonstrate product functionality fit within your customer environment's ability to integrate. All of that stuff is a consequence of the business case."

**Insight:** Proof of Concepts (POCs) should be treated as collaborative exercises to build a business case and ROI model, not just technical tests.

**Tactical advice:**
- Frame POCs as a 30-day pilot for co-creating an ROI model
- Charge for POCs to qualify leads and ensure buyer seriousness

*Timestamp: 00:31:43*

---

> "The right way to think about an ROI model is to actually co-create it with your customers from day one, which means agree and validate on the assumptions and the inputs... If you have done that process and the customer agrees on all the inputs, they're very unlikely to push back on the output of an ROI model."

**Insight:** ROI models are only effective if the customer validates the underlying assumptions and inputs during the sales process.

**Tactical advice:**
- Co-create ROI models by asking customers for inputs like current process time and headcount
- Focus on three ROI buckets: incremental gains, cost savings, and opportunity costs

*Timestamp: 00:19:22*


## Rahul Vohra
*Rahul Vohra*

> "Outlook users are also used to certain safeguards, like if you've used Outlook in an enterprise, warnings when a recipient is external to your domain or what Outlook users might know as sensitivity labels... it truly is a multi-threaded sale with multiple stakeholders."

**Insight:** Enterprise sales require addressing the specific security, compliance, and administrative needs of IT stakeholders, not just the end-users.

**Tactical advice:**
- Build support for enterprise standards like Microsoft Intune for mobile management.
- Implement features specifically for IT/Admin stakeholders, such as sensitivity labels and external recipient indicators.

*Timestamp: 01:17:00*


## Jeanne Grosser
*Jeanne Grosser*

> "Forward-deployed engineering, which on some level is kind of a rebrand of professional services but kind of not. And a big part of that is, hey, how do I actually get into your environment, ride alongside you better understand what you're trying to do and then help you actually bring the technology to life and learn a lot along the way."

**Insight:** Modern enterprise sales requires deeply embedded technical consultation to help customers implement complex technology.

**Tactical advice:**
- Use forward-deployed engineers to ride alongside customers and identify generalizable product needs.

*Timestamp: 00:08:55*

---

> "What we started to do at Stripe was that first session was a whiteboarding session, and we would actually get together and have you draw your architecture for payments and all the other things that were under the hood to enable you to take money and drive customer outcomes. And through that we would learn a ton about what was in your stack... But the customer also learned a lot themselves because in many cases they'd never drawn their architecture diagram."

**Insight:** Interactive whiteboarding sessions provide more value to the customer than standard discovery calls.

**Tactical advice:**
- Replace standard discovery calls with collaborative whiteboarding sessions to map customer architecture.

*Timestamp: 00:49:03*


## Matt Dixon
*Matt Dixon*

> "our analysis showed that anywhere between 40 and 60% of the average salesperson's qualified pipelines... will be ultimately marked as closed loss, no decision."

**Insight:** A significant majority of qualified sales opportunities are lost not to competitors, but to customer indecision and the choice to do nothing.

**Tactical advice:**
- Recognize that 40-60% of deals in the pipeline may evaporate due to customer ghosting or inaction.

*Timestamp: 08:53*

---

> "The omission bias is, if you get down to it, is the fact that people don't want to be blamed for making decisions that lead to a loss... people are okay with missing out. They are not okay with messing up and being blamed"

**Insight:** Customers suffer from omission bias, where the fear of being personally blamed for a bad decision (FOMU) outweighs the fear of missing out on benefits (FOMO).

**Tactical advice:**
- Address the 'Fear of Messing Up' (FOMU) rather than just dialing up the 'Fear of Missing Out' (FOMO).
- Focus on instilling confidence that the customer will look like a hero, not a fool.

*Timestamp: 16:06*

---

> "The first thing is we've got to judge their level of indecision... The second thing is we've got to offer a recommendation. The third thing is we've got to get them to start trusting us and we call it limit the exploration, and the T is we've got to de-risk the deal."

**Insight:** The JOLT method provides a four-step framework to overcome customer indecision: Judge, Offer, Limit, and Take risk off the table.

**Tactical advice:**
- Judge the level of indecision to determine the specific blocker.
- Offer a firm recommendation to share the burden of the decision.
- Limit exploration by building trust and demonstrating expertise.
- De-risk the deal by creating safety nets and setting realistic expectations.

*Timestamp: 26:30*

---

> "We found a technique... called pings and echoes that high performers use... a salesperson will try to articulate but in a non, not to out the customer, but to get confirmation or refutation, if you will, that what they've articulated is actually a concern for their buyer."

**Insight:** High performers use 'pings'—probing statements about common customer concerns—to surface hidden indecision without embarrassing the buyer.

**Tactical advice:**
- Use phrases like 'At this point, most customers like you are worried about X' to see if the customer 'echoes' that concern.
- Frame the ping as a way to be of service rather than a direct interrogation.

*Timestamp: 29:55*

---

> "you've got to shift your posture from asking the customer what they want and just diagnosing their needs, to actually recommending to them what they should do."

**Insight:** To overcome choice overload, salespeople must move from being order-takers to active recommenders, utilizing the 'delegation effect' to share the risk of the decision.

**Tactical advice:**
- Narrow down choices to a manageable set (e.g., three options).
- Explicitly recommend a specific path (e.g., 'I would go with the middle one') to reduce the buyer's personal risk.

*Timestamp: 36:00*

---

> "The first one is you've got to establish some trust... they are brutally transparent with customers about like, 'Hey, I know you were interested in this capability. I got to be honest, we get mixed reviews on that.'"

**Insight:** Building trust requires radical transparency about product limitations, which signals to the customer that you are an advocate for their success, not just a seller.

**Tactical advice:**
- Be honest about features that are 'early' or 'have kinks'.
- Admit when a competitor is better suited for a specific use case to build long-term credibility.

*Timestamp: 40:05*

---

> "What great salespeople do though is they know that while they'll stand by those claims... they try to kind of under-promise and over-deliver... 'What I'd rather we do is build your business case around a 5X improvement... Then, let's set up to over-deliver against that'"

**Insight:** De-risking a deal involves resetting expectations to a 'safe' baseline to ensure the customer doesn't face internal backlash if results aren't perfect.

**Tactical advice:**
- Build business cases around conservative, 100% achievable numbers rather than best-case scenarios.
- Position professional services or implementation support as an 'insurance policy' against failure.

*Timestamp: 42:16*


