---
name: evaluating-candidates
description: Help users make better hiring decisions. Use when someone is evaluating job candidates, making hiring decisions, conducting reference checks, reviewing work samples or take-homes, calibrating their hiring bar, or deciding between finalists.
---

# Evaluating Candidates

Help the user make stronger hiring decisions using battle-tested frameworks from 94 product leaders.

## How to Help

When the user asks for help evaluating candidates:

1. **Understand their context** - Ask what stage they're at (screening resumes, reviewing work samples, conducting references, making final decisions) and what role they're hiring for
2. **Apply relevant principles** - Use the frameworks below to help them think through the decision
3. **Challenge their assumptions** - Push back on shortcuts like pedigree bias or gut-feel-only decisions
4. **Help them structure the process** - Suggest interview questions, reference check approaches, or evaluation rubrics based on the principles

## Core Principles

### Reference checks trump interviews
Shishir Mehrotra: "I generally value the reference check over interview signals. Those people worked with this person for years—what you get from 30 minutes of interviewing doesn't compare." Prioritize references in final decisions, and dig deep with people who've worked closely with the candidate.

### Hire for team balance, not unicorns
Adam Fishman: "The goal is not to find someone who's 11/10 on everything—that person doesn't exist. Create a well-rounded team by hiring to fill gaps in your portfolio." Before opening a role, map your team's current strengths and weaknesses.

### Use paid work trials
Elena Verna: "We do 2-3 day paid work trials to see candidates in action—how they handle chaos and lack of clarity. This company is not for everybody." Work trials reveal what interviews cannot: how someone actually operates.

### Prioritize agency over experience
Albert Cheng: "High agency and 'clock speed' are better predictors than deep experience. Sometimes experience is a crutch, especially when the ground is shifting fast." Look for candidates who took initiative outside formal channels.

### Structure first, intuition after
Annie Duke: "If you use intuition after a structured evaluation—not before—you drastically improve your hit rate." Complete your rubric before letting gut feel influence the decision.

### Look for world-class strengths, not lack of weaknesses
Ben Horowitz: "We're investing in strength, not lack of weakness. Does this person have a world-class strength that can beat anybody? Surround them with people who cover their gaps."

### Test for comfort with chaos
Adam Grenier: "Comfort with chaos and willingness to do things they haven't done in 15 years are huge signals. People from traditional environments often can't handle startup unpredictability."

### Identify the T-shape
Adam Grenier: "Every senior hire has a T-shaped career. Find their deep expertise (the vertical), then ask how they'll cover areas where they're weaker."

### Watch behavior outside the interview
Albert Cheng: "High agency shows up outside formal interviews—the questions they ask, whether they've actually tried your product, the energy in their scheduling emails."

### Avoid pedigree shortcuts
Austin Hay: "School prestige or resume gaps are bad shortcuts. Investigate gaps—they may represent intense self-directed learning."

### Use the Bar Raiser model
Bill Carr (Amazon): "Have someone outside the hiring manager's chain run the debrief meeting with veto power. This counteracts urgency bias and keeps the bar high."

### Hire for person-product fit
Brian Tolkin: "Match the candidate's specific background to the product's needs. A technical product needs a technical PM. Avoid hiring generalists for roles where specific context drives success."

### Force stack-ranking
Bangaly Kaba: "Ask candidates to stack-rank five skills from strongest to weakest. It reveals self-awareness and opens deeper conversation about their actual capabilities."

### Mission alignment retains talent
Benjamin Mann (Anthropic): "People stay when they're mission-oriented. They get offers from Meta but don't leave because their best case here is affecting humanity's future."

## Questions to Help Users

Use these to diagnose where they need help:

- "What stage of the process are you in?"
- "What does your current team lack that this person needs to bring?"
- "Have you done reference checks yet? What did you learn?"
- "Did you use a structured rubric, or are you going on gut feel?"
- "Have you seen them actually work, or only interviewed them?"
- "What's their world-class strength?"

## Deep Dive

For all 151 insights from 94 guests, see `references/guest-insights.md`

## Related Skills

- Writing Job Descriptions
- Conducting Interviews
- Onboarding New Hires
- Building Team Culture
