# Evaluating Candidates - All Guest Insights

*94 guests, 151 mentions*

---

## Adam Fishman
*Adam Fishman*

> "The goal of the competency model is not to find a unicorn human being that is an 11 out of 10 on every one of these things, because frankly, that person doesn't exist... The goal is to create a well-rounded team so that you're hiring and balancing skills across your team and that you don't have any gaps in your portfolio."

**Insight:** Hire for team balance and complementary skills rather than searching for a single candidate who excels in every competency.

**Tactical advice:**
- Identify specific skill gaps in the current team before opening a role
- Evaluate candidates against a balanced portfolio of execution, strategy, and communication

*Timestamp: 00:15:18*

---

> "I tend to skew more towards internal hire to be perfectly honest, because I believe in creating opportunity inside a company... I also believe that helping people transition into new roles is a way to get more people into the practice. One of the benefits that you get from that is a lot of time they have one of those competencies really nailed already. Could be like customer knowledge."

**Insight:** Internal hires are often lower risk and faster to produce results because they already possess deep institutional and customer knowledge.

**Tactical advice:**
- Look for internal candidates with high execution and customer knowledge to transition into growth roles
- Invest in outside education or advisors to bridge the gap for internal transfers who lack specific growth strategy experience

*Timestamp: 00:32:44*


## Albert Cheng
*Albert Cheng*

> "I saw some of the highest performers just being people that had very high agency, had that clock speed, had that energy, but they didn't necessarily need to have deep experience on that matter. Sometimes experience could be a crutch, especially in this world where the grounds are shifting so fast with AI."

**Insight:** In fast-moving environments, high agency and 'clock speed' (processing/execution speed) are better predictors of success than deep domain experience.

**Tactical advice:**
- Prioritize high agency and energy over years of experience in shifting industries like AI.
- Look for candidates who can intentionally discard old habits.

*Timestamp: 00:01:00*

---

> "A lot of it actually happens outside of the interview process interestingly. So a lot of it is the types of questions they asked, 'Have they actually tried your product and gone deep into it?' A lot of it is, it's the references, it's the communication that they have to even set up your interview, it's the energy they bring into the conversation."

**Insight:** High agency is often revealed through a candidate's proactive behavior and communication outside of formal interview questions.

**Tactical advice:**
- Evaluate the quality and depth of the candidate's questions about the product.
- Observe the candidate's communication style and energy during the scheduling and logistics phase.

*Timestamp: 01:09:49*


## Adam Grenier
*Adam Grenier*

> "Anything let's say C or below, comfortable with chaos and willingness to go do something they have not done for probably 15 years are two huge signals for me, because every company I've been part of at every scale now... that's the thing that a lot of people coming from more traditional marketing environments into startup worlds, it's a pace and just the unpredictability and change."

**Insight:** When hiring for early-stage startups, the ability to handle chaos and perform 'in the weeds' work is more critical than seniority.

**Tactical advice:**
- Test candidates for their comfort level with high rates of unpredictability
- Look for senior leaders who are still willing to execute tactical tasks (e.g., writing emails, checking ad data)

*Timestamp: 00:51:53*

---

> "Every marketer is going to have a T-shaped career... find out their T, find out their strength, and then spend time figuring out how they make up for those other things."

**Insight:** Evaluating senior candidates requires identifying their core 'T-shaped' expertise and assessing how they manage their relative weaknesses.

**Tactical advice:**
- Identify the candidate's primary deep skill (the vertical bar of the T)
- Ask how they plan to hire or adapt to cover the areas where they are not experts

*Timestamp: 00:53:41*


## Annie Duke
*Annie Duke*

> "And then what he found was after you've gone through that process, if you then use your intuition after having done that, not before, that then you actually can really drastically improve your hit rate on hiring."

**Insight:** Intuition is most valuable in hiring when applied *after* a structured evaluation process, not as the primary filter.

**Tactical advice:**
- Complete the structured rubric and interview loop before allowing 'intuition' to influence the final decision.
- Use structured data to move hiring hit rates from 50% to 65%.

*Timestamp: 00:22:04*


## Anton Osika
*Anton Osika*

> "If I'm putting together a product team today, I would really obsess about getting as many skill sets as possible for each person I hire."

**Insight:** In the AI era, prioritize hiring generalists who can cover multiple functional skill sets.

**Tactical advice:**
- Look for candidates with a 'generalist brain' who can quickly learn new skills
- Prioritize raw cognitive capability as a primary hiring signal

*Timestamp: 00:00:51*

---

> "I pretty much always have people join the work simulation for at least a day, often a full week."

**Insight:** Use extended work simulations to verify technical skills and cultural fit before making a final hiring decision.

**Tactical advice:**
- Implement work trials lasting from one day to a full week
- Observe how candidates think through unorthodox problems they haven't seen before

*Timestamp: 00:44:13*


## Arielle Jackson
*Arielle Jackson*

> "Tell me about a project you're proud of. Tell me about a project you're proud of, is just really open-ended and get to hear a lot about a lot of things that way. And then maybe runner up is tell me about a campaign you recently come across that you were not involved with that you thought was cool."

**Insight:** Open-ended questions about past pride and external observations reveal a candidate's values and taste.

**Tactical advice:**
- Ask candidates to detail a project they are proud of to see what they prioritize
- Ask about external campaigns to gauge their marketing 'eye' and awareness

*Timestamp: 01:19:35*


## Ayo Omojola
*Ayo Omojola*

> "I had this belief that sort of these people that I had seen, many of whom have now gone on to start companies that are doing quite well, would be incredible value add... I'd be like, 'If you've been a founder before, even if your startup has failed, please apply to this.'"

**Insight:** Hiring former founders provides a high-output, 'bullshit-free' team dynamic, though it comes with higher attrition risks.

**Tactical advice:**
- Look for non-traditional candidates who are often screened out by standard big-tech algorithms.
- Explicitly invite former founders to apply in job descriptions.
- Be prepared for these hires to challenge organizational inefficiencies and likely leave within 2-3 years to start their next venture.

*Timestamp: 23:04*


## Austin Hay
*Austin Hay*

> "The first thing that I always gravitate towards is just intellectual curiosity. And I know that's very, maybe a little bit overrated, but I think you can tell pretty quickly if somebody's just interested in the world and learning things. And the thing about third party tools is you are constantly learning. You'll never be an expert in everything because there's way too many tools to be an expert on"

**Insight:** In rapidly evolving technical fields, intellectual curiosity is more valuable than static expertise in specific tools.

**Tactical advice:**
- Prioritize candidates who demonstrate a high interest in learning new systems quickly.
- Look for 'engineering scrappiness'—the ability to read API docs and make requests even without a CS degree.

*Timestamp: 00:58:02*

---

> "I look less for red flags and more for false identifiers on the resume application that may shortcut me towards the decision. Another one is just school people just look at your school where you went to undergrad or grad and they kind of make a decision one way or the other. And I feel like that's also can be a really bad shortcut."

**Insight:** Avoid using educational prestige or resume gaps as shortcuts for evaluation, as they often mask high-potential candidates.

**Tactical advice:**
- Investigate resume gaps; they may represent periods of intense self-directed learning or personal growth.
- Ignore school pedigree in favor of demonstrated skills and curiosity.

*Timestamp: 01:03:39*


## Bangaly Kaba
*Bangaly Kaba*

> "I'm going to give you five skills and I want you to stack-rank them for me. One to five. So one being the one you're strongest at and five being the one you're relatively weakest at."

**Insight:** Forcing candidates to stack-rank their skills reveals self-awareness and allows for a deeper conversation about their specific strengths and weaknesses.

**Tactical advice:**
- Ask candidates to stack-rank five specific skills required for the role.
- Dig into the reasons behind their #2 and #5 rankings to understand their self-perception and past context.

*Timestamp: 01:33:41*


## Ben Williams
*Ben Williams*

> "The devs that really thrive in a growth context are the ones that are motivated by moving quickly, iterating to create measurable impact. They're not attached to their work. They embrace imperfection as part of the process. They happily discard their code, their ideas even. They're curious and they're always looking for ways to be closer to their users."

**Insight:** Growth engineers require a specific mindset: a lack of attachment to code and a motivation for measurable impact over technical depth.

**Tactical advice:**
- Test for a candidate's willingness to discard code or ideas in favor of learning
- Look for engineers who prioritize speed and iteration over perfect architecture

*Timestamp: 00:48:17*


## Benjamin Mann
*Benjamin Mann*

> "At Anthropic, I think we've been maybe much less affected than many of the other companies in the space because people here are so mission oriented and they stay because... They get these offers and then they say, 'Well, of course I'm not going to leave because my best case scenario at Meta is that we make money and my best case at Anthropic is we affect the future of humanity and try to make AI flourish and human flourishing go well.'"

**Insight:** Mission-alignment is a critical filter for retaining top talent in high-competition environments where competitors can offer significantly higher compensation.

**Tactical advice:**
- Prioritize candidates who are mission-oriented over those primarily motivated by financial upside
- Frame the role's impact in terms of societal benefit to differentiate from larger, profit-focused incumbents

*Timestamp: 00:05:23*


## Ben Horowitz
*Ben Horowitz*

> "You don't make people great. You find people that make you great, that make the company great, that you learned from, not the other way around."

**Insight:** At the executive level, you should hire people who possess expertise you lack rather than trying to develop them from scratch.

**Tactical advice:**
- Hire for world-class expertise in functions you don't personally understand (e.g., CFO, HR)
- Look for candidates who can teach you and push the company forward independently

*Timestamp: 00:25:27*

---

> "Judge people on what they can do, coach people on what they can do, help them take their strengths and use them as opposed to over focus on their weaknesses... we're investing in strength, not lack of weakness. I want to know how good, are they world-class? Do they have a world-class strength? And can that beat anybody?"

**Insight:** Successful hiring focuses on finding exceptional strengths that can win, rather than looking for a lack of flaws.

**Tactical advice:**
- Identify a candidate's 'world-class strength' and determine if it can beat the competition
- Surround flawed but high-strength individuals with people who can mitigate their weaknesses

*Timestamp: 00:53:10*


## Bob Moesta
*Bob Moesta 2.0*

> "I'm actually using the book as... If you want to apply for a job with me, we got to go through the process. And so basically they have to come to me and tell me their energy drivers and drains. They have to tell me what they're good at and what they suck at. They have to be able to tell me their past couple jobs of what's going on."

**Insight:** Evaluating candidates based on their self-awareness of energy drivers and weaknesses leads to better long-term fit than skill-matching alone.

**Tactical advice:**
- Ask candidates to identify their 'bottom five' strengths or areas that drain their energy.
- Look for honesty about what a candidate 'sucks at' as a sign of professional maturity and fit.

*Timestamp: 01:06:46*


## Bill Carr
*Bill Carr*

> "On every interview loop there's one person, who is not the hiring manager, who doesn't report to the hiring manager, who's not the recruiting manager... and they are on the interview loop and they're a Bar Raiser, which means when we get to the debrief meeting, they will run that meeting, not the hiring manager, not the recruiter, they will run the meeting."

**Insight:** The Bar Raiser program ensures hiring standards remain high by using an objective third party to facilitate the decision.

**Tactical advice:**
- Appoint a Bar Raiser who is outside the hiring manager's reporting line
- Give the Bar Raiser veto power to counteract 'urgency bias' in hiring
- Have the Bar Raiser lead the candidate debrief meeting to ensure objective criteria are used

*Timestamp: 01:16:21*


## Brian Tolkin
*Brian Tolkin*

> "It's not really about is this person good or bad or whatever, it's is this person's skillset and context to the problem that is really needed... how can we be a little bit more thoughtful about what the actual skillset needs off this type of team?"

**Insight:** Hire for 'person-product fit' by matching a candidate's specific background (technical, ops, or design) to the unique requirements of the product area.

**Tactical advice:**
- Identify if the specific product challenge requires a technical, operational, or design-heavy PM
- Avoid hiring generalists for niche roles where specific context is the primary driver of success

*Timestamp: 01:04:13*


## Chip Conley
*Chip Conley*

> "We are moving out of the era of the specialists and into the era of the generalists... I would also say, are they a generalist when they're a problem solver?"

**Insight:** In the AI era, generalists who can think broadly and solve diverse problems are becoming more valuable than narrow specialists.

**Tactical advice:**
- Look for 'range' and generalist problem-solving abilities during interviews

*Timestamp: 00:36:23*

---

> "What are three to five adjectives that define this culture? What's the biggest problem in this culture... Is it ever going to get fixed? How could I come in and maybe help that?"

**Insight:** Evaluating a company's culture during an interview requires asking pointed questions about endemic problems and alignment.

**Tactical advice:**
- Ask multiple interviewers for the same cultural adjectives to check for alignment
- Inquire about the 'biggest problem' in the culture to see if leadership is self-aware

*Timestamp: 00:52:14*


## Crystal W
*Crystal W*

> "I would hire someone who is willing to take intro to statistics course. And it doesn't matter if they've had the experience to go wild or not. I think it really is, can they focus on the right opportunity rather than the most flashy thing?"

**Insight:** Prioritize statistical literacy and first-principles thinking over years of experience when hiring for growth roles.

**Tactical advice:**
- Screen for an understanding of sampling, selection bias, and probability
- Look for candidates who prioritize opportunity cost over 'flashy' features

*Timestamp: 00:53:24*


## Dalton Caldwell
*Dalton Caldwell*

> "I think evidence that they actually have thought about it. As per I said earlier, that they've done research, that they have opinions, that they care about it. Right? Sometimes when people answer questions, you can just tell that it's really superficial, and they haven't put much care or soul into their answers."

**Insight:** When evaluating founders or early hires, prioritize depth of thought, specific opinions, and genuine care over superficial or rehearsed answers.

**Tactical advice:**
- Look for evidence of deep research into the problem space
- Test for strong, well-reasoned opinions rather than generic statements
- Differentiate between 'superficial' answers and those with 'soul' and care

*Timestamp: 01:15:05*


## Dr. Fei Fei Li
*Dr. Fei Fei Li*

> "I'm an intellectually very fearless person, and I have to say when I hire young people, I look for that because I think that's a very important quality if one wants to make a difference, is that when you want to make a difference, you have to accept that you're creating something new or you're diving into something new."

**Insight:** Intellectual fearlessness is a critical trait for talent in high-innovation fields where the path is unproven.

**Tactical advice:**
- Look for candidates who are willing to dive into new, unproven areas without over-analyzing failure cases.
- Prioritize passion and mission alignment over minute job details during the hiring process.

*Timestamp: 01:05:25*


## Dhanji R. Prasanna
*Dhanji R. Prasanna*

> "We're very much looking for people that are embracing these tools and that are eager to try and learn from it. ... I'm much more keen on looking for that college grad who just really is eager to learn about these tools and open to it, or even the veteran who has embraced these tools and figured it out."

**Insight:** Prioritize a 'learning mindset' and openness to AI over specific legacy technical skills.

**Tactical advice:**
- Look for candidates who demonstrate curiosity about how AI can optimize their specific tasks
- Value the ability to adapt to changing workflows over deep expertise in a static set of skills

*Timestamp: 00:46:14*


## Drew Houston
*Drew Houston*

> "The seniority gap is really rough... what you do in response typically is, you promote a lot of people internally... But it's a problem because suddenly people are solving problems through trial and error... you want to keep it roughly in balance... 50-50, whatever."

**Insight:** A 'seniority gap' occurs when internal promotions outpace the company's access to experienced external talent, leading to trial-and-error management.

**Tactical advice:**
- Maintain a balance (roughly 50/50) between high-potential internal promotes and experienced external hires.
- Pair high-potential talent with 'been there, done that' leaders to accelerate the aggregate learning rate of the company.

*Timestamp: 01:18:29*


## Dmitry Zlokazov
*Dmitry Zlokazov*

> "Everyone is striving for talented, skillful, smart people. Revolut values way more raw intellect and this unquenched hunger to build things rather than experience."

**Insight:** Prioritize raw cognitive ability and a drive to build over years of industry experience.

**Tactical advice:**
- Look for 'unquenched hunger' to build things
- Value raw intellect over specific domain experience

*Timestamp: 00:00:00*

---

> "Unfortunately, professionals with a lot of years of experience from established companies, they don't have this strong urge to change status quo, which by the way will require toil, tears, and sweat. And that's why even if a candidate doesn't have a lot of years of experience, but they love building things, they've done it, they worked with engineers maybe by the way, maybe in their own startup or one of the best profiles that I've seen is a tech co-founder."

**Insight:** Experienced professionals from large companies may lack the 'hunger' required for high-growth environments; former founders often make the best PMs.

**Tactical advice:**
- Target former tech co-founders as high-potential product hires
- Screen for candidates who have a history of building things from scratch with small teams

*Timestamp: 00:26:46*

---

> "One of the great sources is actually looking into products and apps that we love ourselves. So if someone built a great product, then it's likely a high performer. So usually we provide some great products in specific areas that are more important for us to the sourcing team and they just try to source targeting those companies."

**Insight:** Source candidates by identifying high-quality products you admire and finding the people who built them.

**Tactical advice:**
- Identify apps or products with exceptional UX and target their product teams
- Direct sourcing teams to focus on specific companies known for product excellence

*Timestamp: 00:29:14*


## Edwin Chen
*Edwin Chen*

> "we have to build all of this technology in order to measure it, like thousands of signals on all of our workers, thousands of signals on every project, every task. We know at the end of the day, if you are good at writing poetry versus good at writing essays versus great at writing technical documentation... We are looking at your keyboard strokes. We are looking how fast you answer things. We are using reviews, we are using code standards"

**Insight:** Evaluating talent for complex tasks requires granular, data-driven tracking of performance signals rather than just checking boxes.

**Tactical advice:**
- Track behavioral signals (speed, keystrokes, patterns) to identify true expertise
- Segment talent based on specific vertical performance (e.g., poetry vs. technical docs)

*Timestamp: 00:10:34*


## Elena Verna
*Elena Verna 4.0*

> "But second of all, we do a lot of trials for people. So trial work to see them in action for a couple of days. We pay them as part of the work trial. We have some probation periods that we start people on, because this company is not for everybody."

**Insight:** Paid work trials are the most effective way to screen for the high-velocity, high-agency talent required in AI startups.

**Tactical advice:**
- Implement 2-3 day paid work trials to observe how candidates handle chaos and lack of clarity.
- Screen for 'fire in the belly' and passion rather than just big-company logos on a resume.

*Timestamp: 00:41:54*

---

> "It's also interesting that there's a really high demand for ex-founders now, for those people that truly have a lot of agency and high autonomy... the failed startup founders are now hot demand for a lot of these AI companies."

**Insight:** Ex-founders are ideal hires for AI companies because they possess the necessary high agency and ability to generalize across roles.

**Tactical advice:**
- Prioritize hiring former founders who can operate autonomously without needing corporate structure.

*Timestamp: 01:27:32*

---

> "There is a huge misconception in the field that in order to get growth going, you need a growth team. To figure out your product market fit and how to distribute it, it's not something that you can outsource to somebody."

**Insight:** Startups should delay hiring a growth team until the founding team has established product-market fit and a distribution baseline.

**Tactical advice:**
- Wait until the company reaches a milestone like $1M to $10M in ARR before building a dedicated growth team.
- Ensure the founder leads the first wave of growth rather than outsourcing it to a new hire.

*Timestamp: 00:08:34*

---

> "If you have the overall business slowing down, your head of growth is destined to fail because the reason business is slowing down is much deeper than not having a growth team."

**Insight:** Hiring a 'shiny' head of growth cannot fix fundamental product-market fit issues or a declining business trajectory.

**Tactical advice:**
- Address core product and marketing issues before hiring growth leadership to avoid setting them up for failure.
- Look for signs of a plateau or 'signs of life' in specific pockets before investing in a growth team to accelerate results.

*Timestamp: 00:15:16*


## Eeke de Milliano
*Eeke de Milliano*

> "I really like to balance product teams with homegrown product managers, who really get the product... with product managers who've come from other companies, and have done it, and can bring a little bit more of that product manager rigor... I always push the leads to hire people who don't look like them."

**Insight:** Build a 'talent portfolio' by balancing internal 'culture carriers' with external hires who bring different professional rigors.

**Tactical advice:**
- Chart the team's collective strengths and weaknesses every six months
- Hire specifically to fill the 'weakness' gaps in the team's portfolio

*Timestamp: 00:57:04*


## Elizabeth Stone
*Elizabeth Stone*

> "At Netflix we try really hard to say we're looking for the new perspective or the person who's actually going to make us stronger as a team. So thinking about additive skills, additive perspectives, people who are going to push our thinking on something."

**Insight:** High-bar hiring focuses on 'culture add' and perspective-shifting rather than just checking boxes for existing skill sets.

**Tactical advice:**
- Look for candidates who bring additive skills that the current team lacks
- Evaluate if a candidate will push the team's thinking rather than just fitting into a box

*Timestamp: 00:40:20*

---

> "I'm usually looking for the person who would be better in my role than I am in my role. So I often ask people what would their priorities be, what would they do differently if they had my job."

**Insight:** A key indicator of a high-level candidate is their ability to think strategically about the interviewer's own role and priorities.

**Tactical advice:**
- Ask candidates what they would change or prioritize if they were in your position
- Hire people who have the potential to be better at your job than you are

*Timestamp: 01:09:29*


## Emilie Gerber
*Emilie Gerber*

> "Find out what month one looks like with them. If month one is them just doing intake calls and learning about the company... you're not going to necessarily want to partner with an agency that needs a three-month ramp up cycle."

**Insight:** When hiring a PR agency, evaluate their speed to action and 'month one' deliverables.

**Tactical advice:**
- Ask for a tactical breakdown of the first 30 days of the engagement
- Avoid agencies that require long ramp-up periods before starting outreach

*Timestamp: 01:20:19*

---

> "Ask them for a couple recent blogs or releases, whatever they tend to go for, and read those. And, of course, wins too. You want to see what kind of stories they're getting, but that's a little more obvious."

**Insight:** Reviewing recent writing samples is a critical step in evaluating a PR agency's quality.

**Tactical advice:**
- Request recent blog or press release samples to check for jargon
- Meet the actual team members who will be doing the day-to-day work

*Timestamp: 01:21:14*


## Emily Kramer
*Emily Kramer*

> "I think having the right business model experience is almost more important than having industry experience or experience with that audience. And I think often people are like, I need someone who is marketed to HR or marketed to construction or that specific. And my response is you, you're going to really narrow your set up people with that, and also it doesn't matter as much because great marketers learn the audience and learn the product quickly."

**Insight:** Prioritize candidates with experience in your specific business model (e.g., PLG vs. Enterprise) over those with specific industry or audience experience.

**Tactical advice:**
- Screen for experience with your specific go-to-market motion (top-down vs. bottom-up).
- Don't over-index on industry-specific backgrounds as great marketers can learn new audiences quickly.

*Timestamp: 00:08:05*

---

> "You want the first marketer to be an expert in one of those three areas that I mentioned, product marketing, content marketing, growth marketing. And you want them to be proficient in another one, the second T. But you want them to be able to set strategy and know how to hire contractors across all of them. And so the promise land of hiring a first marketer, they are a pie shape marketer."

**Insight:** The ideal first marketing hire is a 'pie-shaped' generalist with deep expertise in two core areas and the strategic ability to manage the rest.

**Tactical advice:**
- Look for 'pie-shaped' profiles (expertise in 2 areas, strategic knowledge in others) rather than T-shaped (expertise in only 1).
- Evaluate their ability to hire and manage specialized contractors for areas where they aren't experts.

*Timestamp: 00:19:21*

---

> "I think I want to see that they've worked on a team that's early enough where they are not siloed into their specific role. Because what happens at leader stage companies or at public companies is when you're a product marketer, you don't see what's going on in the rest of marketing at all."

**Insight:** Avoid hiring early marketers from large, siloed organizations; look for those who have seen the 'foundation' being built.

**Tactical advice:**
- Look for candidates from growth-stage companies who had exposure to multiple marketing functions.
- Verify they are 'doers' who are comfortable building from scratch rather than just managing existing systems.

*Timestamp: 00:24:10*


## Eric Simons
*Eric Simons*

> "For us, and even if the folks were hiring us, hiring people that don't care about the titles, and they don't care about... they really are motivated by just working on cool things, and are chucking their ego at the door."

**Insight:** Look for candidates who prioritize the product and mission over personal ego or corporate hierarchy.

**Tactical advice:**
- Screen for intrinsic motivation and a lack of ego
- Look for candidates within your existing user community who already understand the product

*Timestamp: 00:37:42*


## Ethan Evans
*Ethan Evans 2.0*

> "The biggest thing I see particularly at higher levels is people talk about what they have done but not why it mattered. They don't talk about the impact. See, a leader is not hiring someone to just do work. They're hiring someone because they have a problem or a need."

**Insight:** Top candidates distinguish themselves by focusing on the business impact and problem-solving results of their actions rather than just listing tasks.

**Tactical advice:**
- Frame your experience around the specific problems you solved for past employers
- Quantify or describe the impact your work had on the business or customer
- Demonstrate an understanding of the business context behind your functional work

*Timestamp: 00:37:32*


## Geoff Charles
*Geoff Charles*

> "We look for people who have a very strong desire to have impact... I look for people who can think deeply, so I'll go super deep into a decision, a tradeoff that they had to make."

**Insight:** Prioritize a candidate's hunger for impact and depth of thought over specific domain experience.

**Tactical advice:**
- Ask 'What is the hardest thing you've ever done?' to gauge agency and grit.
- Drill deep into a single past decision to understand the candidate's first-principles thinking process.
- Look for candidates who are leaving previous roles because the pace was too slow.

*Timestamp: 01:06:02*


## Gibson Biddle
*Gibson Biddle*

> "When I'm interviewing any of those kinds of candidates, I am looking for leadership skills. Can they do inspired communication of a vision? I do look for product strategy skills... I look for people who are proactive, results oriented."

**Insight:** For senior product roles, prioritize leadership traits like vision communication and proactivity over purely technical skills.

**Tactical advice:**
- Screen for 'inspired communication' of a vision
- Look for 'proactive, results-oriented' behavior in past experiences
- Assess if the candidate views culture as a tool for leadership

*Timestamp: 50:07*


## Gokul Rajaram
*Gokul Rajaram*

> "The first PM at every company has been someone who's either been an analyst or an engineer or a designer who's worked there already and they just move from their role to being a PM. Why? Because many cases, the role of the PM is actually to be the liaison between the founder, founders and the engineering team."

**Insight:** The ideal first PM is often an internal hire who already possesses the trust of the founders and the engineering team.

**Tactical advice:**
- Look for internal candidates with high curiosity, customer centricity, and communication skills to transition into the first PM role
- Hire the first PM when you reach 8-10 engineers to ensure the team is properly 'cared for and fed'

*Timestamp: 00:25:43*

---

> "Look at best of class companies or companies that are best of class at that function in the similar space... You don't hire the person, the head of marketing at these companies. You hire the person who's reporting to them, the lieutenant."

**Insight:** To hire high-quality leaders, identify companies that excel in a specific function and recruit their rising 'lieutenants' rather than the department head.

**Tactical advice:**
- Map out the org charts of best-in-class companies using LinkedIn
- Target the 'up and coming' talent who have seen scale but are ready for a step up in responsibility

*Timestamp: 00:37:31*

---

> "A founder of a young company should spend I think two hours a day hiring... one hour a day doing the reach outs... The second hour should be devoted to actually meeting one or two people on a daily basis."

**Insight:** Consistent, daily time-boxing is required for founders to build a high-quality talent pipeline.

**Tactical advice:**
- Spend one hour on 'low-energy' sourcing/outreach and one hour on 'high-energy' interviews
- Use the weekend to catch up on additional recruiting meetings if necessary

*Timestamp: 00:39:07*


## Graham Weaver
*Graham Weaver*

> "The thing that we probably believe to be true that not that many people agree with us on is that the management team is really where we think all the alpha comes from. You can't get the industry wrong... but you also don't have to be perfect on the industry. You have to have a good enough industry and then a world-class management team."

**Insight:** In high-stakes business, the quality of the leadership team is the primary driver of success, outweighing perfect industry selection.

**Tactical advice:**
- Prioritize evaluating the management team's potential over perfect market timing
- Build internal programs to train and develop young talent into CEOs

*Timestamp: 01:08:53*


## Gustaf Alstromer
*Gustaf Alstromer*

> "First of all, we made sure we hired people that were really excited to be there, right? They wanted to build Airbnb and they were really excited to work on Airbnb. That was the most important thing. Of course people had other offers, but I think you can figure out from those offers are you excited to be here or not."

**Insight:** Candidate excitement and mission-alignment are better predictors of early startup success than just technical pedigree.

**Tactical advice:**
- Assess excitement by comparing your offer against other competing offers the candidate has

*Timestamp: 00:07:50*


## Hari Srinivasan
*Hari Srinivasan*

> "We made a pretty big push in something we call skills-first hiring. This was the idea that we could translate people's experiences into a set of skills, and by that we could help them really start balancing the marketplace with a much different system."

**Insight:** Shift from title-based hiring to skills-based evaluation to broaden the talent pool and find non-obvious candidates.

**Tactical advice:**
- Translate candidate experiences into a discrete set of skills
- Identify transferable skills between seemingly unrelated industries (e.g., hospitality to customer service)

*Timestamp: 00:00:24*

---

> "I do like to ask people what the most complex thing they ever built was. I just love to understand mostly, what do they gravitate to? Is there something you gravitate to? And two, are they able to simplify it? I think those are two really important skills."

**Insight:** Evaluate candidates based on their ability to navigate complexity and their capacity to simplify difficult concepts.

**Tactical advice:**
- Ask candidates to describe the most complex thing they've built
- Look for candidates who can explain the cause-and-effect relationships in non-linear systems

*Timestamp: 00:58:06*


## Jason Droege
*Jason Droege*

> "I just interview for three things... are you a curious problem solver and can you articulate that verbally? Can you work across people? Are you humble enough to work across and are you a good leader?"

**Insight:** In fast-moving markets, interviewing for core traits like problem-solving and humility is more effective than checking specific experience boxes.

**Tactical advice:**
- Test for verbal articulation of problem-solving processes
- Evaluate humility and the ability to collaborate across different functions

*Timestamp: 01:09:31*


## Jason Fried
*Jason Fried*

> "One of the things that we do during the interview process for designers specifically and product people... is they do a project for us at the end. So the last five finalists will do a project for us. We'll pay them to do the project, they'll have a week to do it, they'll do it, and then I'll critique it with them. Even if I love it, I will push back in certain areas."

**Insight:** Use paid, real-world work samples followed by a live critique to evaluate a candidate's taste, execution, and ability to handle feedback.

**Tactical advice:**
- Pay finalists to complete a one-week project
- Conduct a live critique of the work sample to see how the candidate riffs on ideas
- Ask 'If you had another couple days, what would you do with this?' to test their vision and instincts

*Timestamp: 00:52:18*


## Jason M Lemkin
*Jason M Lemkin*

> "Those first couple reps have to be people you would buy your own product from. That's it... when you go out as a first time founder and interview 30 reps... wait and interview 30 sales reps."

**Insight:** The ultimate test for an early sales hire is whether the founder would personally feel compelled to buy the product from them.

**Tactical advice:**
- Interview at least 30 candidates to find the right fit
- Prioritize candidates who can describe the customer's problem better than the founder

*Timestamp: 00:15:13*

---

> "One hint more than anything else, trust... got to hire someone whose last product was harder to sell. This is so important. This is a recipe for utter disaster. If you've, take someone in sales and their last product was easier to sell, they will have none of the skills to sell your product."

**Insight:** Hire sales reps who are moving from a more difficult or technical sales environment to your product, as they will find your motion easier to execute.

**Tactical advice:**
- Look for reps coming from more technical or competitive products
- Avoid hiring reps whose previous product was significantly easier to sell

*Timestamp: 00:54:44*


## Jason Shah
*Jason Shah*

> "What is a risk you regret not taking, why, and what did you learn about yourself?"

**Insight:** Asking about regretted risks reveals a candidate's growth mindset and their psychological approach to problem-solving.

**Tactical advice:**
- Look for 'vocally self-critical' answers that show reflection without unproductive self-flagellation.

*Timestamp: 01:08:02*


## Jeff Weinstein
*Jeff Weinstein*

> "The candidate poll must match where you want the team to go. It's not a down funnel problem, it is an up funnel problem. And where you have to just make sure that for each role you're comfortable with the distribution of people and backgrounds in your candidate pool."

**Insight:** Building a diverse and effective team requires intentionality at the very top of the recruiting funnel, not just at the hiring decision stage.

**Tactical advice:**
- Monitor the diversity of the candidate pool for every role before proceeding to interviews.

*Timestamp: 01:56:36*


## Jeremy Henrickson
*Jeremy Henrickson*

> "An important part of the case study is that it's actually too complex for people to have all of the answers upfront... seeing how people react to that is really indicative of how deeply they understand a new problem or how quickly or how mentally agile they are."

**Insight:** Use complex, ambiguous case studies to test a candidate's mental agility and ability to handle shifting information.

**Tactical advice:**
- Design case studies that are too large to solve perfectly in the allotted time
- Change an assumption mid-interview to see how the candidate adapts their logic

*Timestamp: 00:53:00*


## Jess Lachs
*Jess Lachs*

> "I really look for that curiosity and that self-motivation to do it without being told. ... The person that has that curiosity, something seems off, something doesn't really make sense and goes and proactively looks into what that is."

**Insight:** Curiosity is a non-negotiable trait for top data talent as it drives proactive insight discovery.

**Tactical advice:**
- Test for curiosity by presenting a case with a subtle anomaly to see if the candidate notices and investigates.
- Ask for specific examples where a candidate noticed something 'off' in data and pursued it without being prompted.

*Timestamp: 00:24:31*

---

> "Seeing how people react to being told they're wrong is a really important signal in my opinion. Seeing how people respond, how they're able to take new information and pivot, how they're able to make a decision."

**Insight:** A candidate's ability to handle feedback and pivot their thinking is a key indicator of their future performance in ambiguous environments.

**Tactical advice:**
- Intentionally challenge a candidate's assumption during a case study to observe their reaction.
- Push candidates to make a definitive 'call' or decision even when they lack perfect information.

*Timestamp: 00:27:56*


## Jessica Livingston
*Jessica Livingston*

> "I would look at, do the co-founders get along? Are these people committed? And if a founder would get defensive, that was always a bad sign."

**Insight:** Co-founder dynamics and defensiveness are critical indicators of a startup's potential for success or failure.

**Tactical advice:**
- Observe if co-founders interrupt each other or finish each other's sentences
- Watch for defensive reactions to questioning as a sign of a closed mind

*Timestamp: 00:00:24*

---

> "I would look at other things about founders. When we'd have these 10-minute interviews, I would look at, do the co-founders get along? Are these people committed? Do they really know about their product? Do they care? Are they going to quit their job? Or are they telling us that they are going to quit their job, but really aren't? All these little social cues that I'd try to pick up on."

**Insight:** Evaluating founders requires looking beyond technical skills to assess commitment, domain expertise, and interpersonal dynamics.

**Tactical advice:**
- Verify if founders are actually prepared to quit their current jobs
- Assess if founders have a deep connection to the problem they are solving

*Timestamp: 00:08:13*

---

> "If a founder would get defensive, that was always a bad sign, always a bad sign. The best founders would say, 'Gosh, I have thought about it and here's what I figured out.' Or, they just have this almost a tennis match and a conversation rather than closing up and feeling like, oh, this person's interrogating me. You could just sort of, the open-mindedness, the flexible-mindedness of people was really important."

**Insight:** The ability to engage in a spirited debate without becoming defensive is a hallmark of a successful, flexible-minded founder.

**Tactical advice:**
- Test for open-mindedness by questioning the founder's core assumptions
- Look for founders who treat questioning as a 'tennis match' of ideas

*Timestamp: 00:16:33*

---

> "One founder, once we asked a question and one person started to respond and the other founder put his arm in front of him and said, 'I'll answer that question.' And it was just so weird that he wouldn't let his co-founder speak. We'd have situations where we'd call people like hackers in a cage, where it's kind of obvious there'd be a business founder, business person, who had clearly convinced a programmer to join the team. They were given, the programmer was given, very little equity and just we called them programmers in a cage, like hackers in a cage."

**Insight:** Imbalanced power dynamics or equity structures between co-founders are significant red flags.

**Tactical advice:**
- Check for massive gaps in equity allocation (e.g., 99% vs 1%)
- Observe if one founder physically or verbally suppresses the other during the interview

*Timestamp: 00:17:39*

---

> "Earnestness is one of the most important because earnest, sort of to me, is bucketed with authenticity. And to be a successful startup founder, you have to care so much about the problem you're trying to solve, the users you're serving and being earnest about it is so key to success."

**Insight:** Authentic passion for the problem and the user is a better predictor of success than following trends for 'easy money.'

**Tactical advice:**
- Look for founders who are fixing their own problem in a broken industry
- Identify if a founder is honest about what they don't know

*Timestamp: 00:30:45*

---

> "Confidence means you can say, 'I've thought about that and I don't know the answer.' That's confidence. And they'll say, 'But here's what I do to try to figure it out. Here are my plans to address that.'"

**Insight:** True confidence is the ability to admit ignorance while demonstrating a plan to find the solution.

**Tactical advice:**
- Distinguish between defensive posturing and genuine confidence
- Ask difficult questions to see if the candidate can admit they don't know the answer

*Timestamp: 00:33:03*

---

> "I love co-founders that have a history together; either they went to school together, they went to college together, work together, maybe they're siblings. Because when you have a long-term relationship, you trust each other and you know each other's weaknesses, and you're usually on the same page with your aspirations and everything. It's really scary when two founders get together just to start the startup and don't have any history."

**Insight:** A shared history between co-founders provides a foundation of trust necessary to survive the difficulties of a startup.

**Tactical advice:**
- Prioritize teams with a long-term pre-existing relationship
- Be wary of 'arranged' co-founder relationships formed solely to start a company

*Timestamp: 00:36:01*


## John Cutler
*John Cutler*

> "I was just reading that working backwards book about Amazon and they're in this chapter about basically their bar raisers thing and I share it with my partner who's the head of HR at a company. She's like, 'Yeah, this is sort of common sense hiring. They're just talking about de-biasing the hiring and having standards and having those linked into the jobs and just not rushing it.'"

**Insight:** High-performing hiring processes focus on de-biasing decisions through standardized 'bar raisers' and explicit job-linked standards.

**Tactical advice:**
- Implement a 'bar raiser' system to maintain hiring standards across different teams.
- Link evaluation standards directly to the specific requirements of the job description.

*Timestamp: 00:38:41*


## Jonathan Becker
*Jonathan Becker*

> "If you're making your first hire, you probably want them to have the ingenuity and capability to solve a lot of the problems that you're going to run into within the context of tracking, attribution, data visualization, and then campaign management. Number one, do they have a technical background?"

**Insight:** The best performance marketing hires often come from technical backgrounds like math, physics, or engineering rather than traditional marketing.

**Tactical advice:**
- Prioritize candidates with technical aptitudes in math, finance, or full-stack engineering
- Look for candidates who can solve tracking and data visualization problems independently

*Timestamp: 01:18:22*

---

> "I'll ask the question of, 'How many windows are there in New York City?'... One is can they think on their feet? I'm not actually looking for the correct answer... also from a client services point of view, I'm trying to see whether in a scenario where I've asked them something that they obviously probably weren't prepared for... they can compose themselves in a difficult situation."

**Insight:** Fermi problems (logic questions) are useful for testing a candidate's ability to decompose complex problems and maintain composure under pressure.

**Tactical advice:**
- Use logic-based thought experiments to test mental arithmetic and problem-solving frameworks
- Observe the candidate's emotional reaction to unexpected or 'weird' questions to gauge professional composure

*Timestamp: 01:19:29*


## Jonathan Lowenhar
*Jonathan Lowenhar*

> "You should hire people who have already done the thing you need to have done next."

**Insight:** Prioritize candidates with a proven track record of solving the specific problems your company will face in the next 12 months.

**Tactical advice:**
- Look for evidence of the specific outcomes you need in the candidate's past roles.
- Avoid 'gambling' on big-name resumes (e.g., Meta, Salesforce) without verifying specific relevant achievements.

*Timestamp: 00:51:18*

---

> "If you were an outstanding performer in Job A, it is a high likelihood that in job B, someone associated with you in job A is going to pull you into the next thing and then pull you into the next thing and pull you into the next thing and you'll never do a job search 'cause you were great."

**Insight:** High-performers are typically 'pulled' into new roles by former colleagues rather than having to 'push' themselves through job searches.

**Tactical advice:**
- Look for a career history where the candidate was repeatedly recruited by former managers or peers.
- Identify if the candidate has a history of creating 'raving fans' among their previous employers.

*Timestamp: 00:52:13*

---

> "We think there are three types of executives that startups end up hiring over time. We call them the architect, the optimizer, and the scaler."

**Insight:** Executive hires fall into three distinct archetypes based on the company's current stage and needs.

**Tactical advice:**
- Hire an 'Architect' when you need to build a playbook from scratch alongside the founder.
- Hire an 'Optimizer' when you need to find efficiency and performance in an existing playbook (scaling from a few to ~15 people).
- Hire a 'Scaler' when you need to find massive leverage and 10x the organization.

*Timestamp: 00:57:07*


## Judd Antin
*Judd Antin*

> "I've interviewed hundreds or thousands of researchers, and the way I usually approach that is you want a researcher who's got a Swiss army knife... give... a researcher, a pretty juicy, open-ended research question, and you want to see how they handle it, and a good answer is usually multi-method."

**Insight:** The best researchers possess a 'Swiss army knife' of diverse methodologies rather than relying on a single tool.

**Tactical advice:**
- Test candidates with open-ended research problems to see if they suggest multi-method approaches.
- Look for the 'five tools': generative research, evaluative research, survey design, applied statistics, and technical data skills (SQL/Prompt Engineering).

*Timestamp: 00:20:05*


## Julie Zhuo
*Julie Zhuo*

> "Designers want to work with people who care about design... The first thing you could do is demonstrate a commitment to design. Make yourself out to be someone who cares about design... go and study it. Go and interview designers that work at companies. Go and try and follow the top designers on Twitter."

**Insight:** To attract and evaluate top design talent, non-designers must immerse themselves in design culture and learn the 'nomenclature' of the discipline.

**Tactical advice:**
- Learn the specific tools and language designers use to speak to them in a common language
- Demonstrate design commitment by investing in high-quality marketing sites or early product V1s

*Timestamp: 01:01:26*

---

> "If we were going to create a team and we're going to have a couple engineers and none of them are very good at thinking through product requirements or what the user angle is, we probably do need to supplement the team with somebody with that skill set."

**Insight:** When hiring for lean teams, evaluate the collective skill set of the team to identify specific gaps rather than just hiring for standard roles.

**Tactical advice:**
- Identify missing skills (e.g., product thinking, user empathy) within an existing team before hiring.

*Timestamp: 00:19:30*


## Katie Dill
*Katie Dill*

> "The key, I think, to keep in mind is it's easier to teach tools and process than it is taste and character, so I would certainly pay a lot of attention to that. Their hit rate for great judgment and great taste, and how they've honed that, even if they're not very experienced, just to see do they have that natural inclination for great things."

**Insight:** Prioritize innate taste and character over technical tool proficiency during the hiring process.

**Tactical advice:**
- Look for a 'natural inclination for great things' even in less experienced candidates
- Evaluate 'hit rate' for judgment in past work

*Timestamp: 01:12:00*

---

> "Tell me what work you are most proud of. And the reason I ask that is because it helps me understand their taste and their judgment, what motivates them, what work they view as good and as a good outcome. It also helps me understand a little bit about what they like to do and where their gravity pulls them."

**Insight:** Asking candidates what they are most proud of reveals their internal quality bar and motivations.

**Tactical advice:**
- Use the 'most proud of' question to gauge what a candidate considers a 'good outcome'

*Timestamp: 01:26:01*


## Ken Norton
*Ken Norton*

> "I actually feel like maybe the pendulum shifted way too far now where it's the interview process is so structured. Everyone's doing all these mock. They know exactly what questions they're going to get. It's SAT prep. Everyone's ready. But we've missed out with can they do the job? Because it's like they can pass the interview, but can they do the job?"

**Insight:** Modern structured interviews often measure a candidate's ability to prepare for the test rather than their actual ability to perform the role.

**Tactical advice:**
- Focus on 'intangibles' and the 'art' of the role rather than just technical science
- Evaluate if the candidate can actually work with and inspire engineers and designers
- Look for evidence of leadership without formal authority

*Timestamp: 01:06:53*

---

> "I think a great question... is how does the company define a product team? Because it answers so much. It says so much about culture, collaboration, decision-making, the role of product management. If there's one question and you could figure out what is this culture like, it would be asking that."

**Insight:** The definition of a 'product team' is a primary indicator of a company's organizational health and PM role clarity.

**Tactical advice:**
- Ask candidates (or have candidates ask) how the company defines a product team to reveal culture and decision-making norms

*Timestamp: 01:10:00*

---

> "I think another great question for candidates is to ask them to pick an example of something they've shipped recently and just talk about how it came to be. How did the bill become a law? Was it somebody in sales yelled and it got added to the backlog and it was the next thing? Is it a group of people together understanding customer user needs through discovery and ideating and trying some things and testing it?"

**Insight:** Tracing the lifecycle of a feature reveals the true power dynamics and operational reality of a product organization.

**Tactical advice:**
- Ask candidates to walk through 'how the bill became a law' for a recent feature to understand their environment and empowerment level

*Timestamp: 01:10:30*


## Keith Coleman & Jay Baxter
*Keith Coleman & Jay Baxter*

> "I and the team interviewed every single person that joined the team and we were like, 'We want that person on the team. They want to be on the team.' And so people are totally bought in to the goal, mission, the way the team works, the other people they're going to be working with."

**Insight:** Early-stage or high-impact teams should have the core team personally interview every hire to ensure total mission alignment and cultural fit.

**Tactical advice:**
- Have the founding team interview every single candidate personally
- Prioritize candidates who are 'bought in' to the specific mission and way of working

*Timestamp: 00:57:10*


## Karri Saarinen
*Karri Saarinen*

> "We've been taking very slow steps on it that in almost the first year we didn't hire anyone... We never more than doubled in a year. And that's been our guideline that we shouldn't more than double."

**Insight:** Limiting headcount growth preserves team quality and prevents the chaos associated with rapid scaling.

**Tactical advice:**
- Set a hard cap on hiring (e.g., never more than doubling in a year) to maintain culture.
- Prioritize high-caliber generalists over a large number of average specialists.

*Timestamp: 00:57:43*

---

> "We do with all of the employees, we've been doing a paid work trial... they basically come as a mini contractor to the company, and we give them a very usually fairly vague problem statements. If you're an engineer, it's like, hey, there's this feature that needs to be built. How would you build it? Then go build it."

**Insight:** A paid work trial is the most effective way to evaluate how a candidate actually operates in a startup environment.

**Tactical advice:**
- Implement a multi-day paid work trial as the final step in the hiring process.
- Give candidates access to the real codebase and Slack to see how they collaborate and handle ambiguity.

*Timestamp: 01:02:27*


## Kevin Weil
*Kevin Weil*

> "High agency is something that we really look for, people that are not going to come in and wait for everyone else to allow them to do something, they're just going to see a problem and go do it... people that are happy with ambiguity."

**Insight:** In fast-moving AI environments, high agency and comfort with ill-formed problems are more critical than traditional role definitions.

**Tactical advice:**
- Screen for candidates who can execute without a defined roadmap
- Look for 'product-focused' engineers who can make autonomous decisions

*Timestamp: 00:50:55*


## Kevin Yien
*Kevin Yien*

> "When you get to offer stage, I send an email with no more than eight bullet points and I say all the terrible things that are probably going to reinforce their fears. If you can tell them that upfront and they can read that whole email and still be equally excited to join you, find yourself a A+ hire."

**Insight:** The 'unsell email' ensures long-term retention by front-loading the most difficult aspects of a role before the candidate signs.

**Tactical advice:**
- Collect a candidate's fears and anxieties throughout the interview process.
- Send a candid email at the offer stage detailing the 'gnarly' realities of the job.
- Use the candidate's reaction to the 'unsell' as a final signal of fit.

*Timestamp: 00:48:44*


## Kunal Shah
*Kunal Shah*

> "Maybe all of our interviews should be about giving a task that they can only perform if they are very good at AI. And no matter what the job is, you make that the minimum criteria that if they cannot use that, leverage that, they'll become a liability in 5 years anyways."

**Insight:** AI proficiency should be a non-negotiable baseline for all new hires to prevent future talent liability.

**Tactical advice:**
- Incorporate an AI-specific task into the interview process for every role.
- Test if candidates can leverage AI tools to solve standard job problems more efficiently.

*Timestamp: 00:32:01*


## Lane Shackleton
*Lane Shackleton*

> "I also recently wrote a post about my favorite ref check question, which I think I would love to learn other people's favorite ref check questions."

**Insight:** Reference checks are a critical skill for evaluating the true performance of a candidate.

**Tactical advice:**
- Develop a go-to list of specific reference check questions to uncover hidden traits.

*Timestamp: 01:24:20*


## Laura Modi
*Laura Modi*

> "I think sometimes putting the most unlikely people who have an ounce of naivety to what it takes to win and succeed are the ones that are going to drive the biggest impact."

**Insight:** Hiring 'unlikely' candidates with fresh perspectives can lead to more innovation than hiring industry veterans.

**Tactical advice:**
- Look for generalists who aren't bound by 'the way things have always been done.'
- Consider candidates from completely different industries (e.g., hiring a news anchor for marketing).

*Timestamp: 00:41:15*

---

> "I definitely look for people who have the ability to make decisions and move fast and not get worried about the outcome. That is the biggest learning in a startup. The secret is momentum and just keeping momentum... I look for just optimistic doers."

**Insight:** In startups, the ability to maintain momentum is more valuable than the desire for perfection.

**Tactical advice:**
- Screen for 'optimistic doers' who are willing to roll up their sleeves.
- Watch for red flags like candidates who are overly concerned with 'lanes' or say 'I don't do that.'

*Timestamp: 00:44:15*


## Lauren Ipsen
*Lauren Ipsen*

> "Regardless of whether or not you're hiring, you should always be keeping a pulse on the market. That is the most important thing. And I think that should be the case for both candidates and folks that are hiring. Like, you never want to put yourself in a position where you have no idea what good looks like, whether that's from a company standpoint or from a candidate standpoint."

**Insight:** Continuous market benchmarking is essential to understand what high-quality talent looks like before you actually need to hire.

**Tactical advice:**
- Chat with 'benchmark' candidate profiles even when not hiring to understand the bar.
- Keep a pulse on which companies are thriving and which individuals are building great things.

*Timestamp: 00:00:00*

---

> "I think especially for founders that haven't hired for this caliber of talent in the past, it's really easy to be distracted by shiny objects and look at huge names. You want to find the CPOs of Google and YouTube or what have you because that seems like it would be such an incredible opportunity for brand recognition. And to an extent, it is. But the fact of the matter is, oftentimes those individuals are pretty far from the work and have a great team of executors that they've put into place that are actually the ones that are in the weeds."

**Insight:** Avoid the 'shiny object' trap of hiring big-name executives who may be too far removed from the tactical work required at an early-stage company.

**Tactical advice:**
- Look for candidates who are closer to the work and have a 'chip on their shoulder' to prove themselves.
- Prioritize 'innovative AB testing' profiles over purely operational or camaraderie-focused leaders for pre-IPO stages.

*Timestamp: 00:09:59*

---

> "I would say the general advice is who is going to be best for this specific role at this specific time, not necessarily who is the best talent in the world or in the market. Those are two very, very different questions to ask."

**Insight:** Hire for the specific needs and stage of your company rather than chasing the objectively 'best' talent in the market.

**Tactical advice:**
- Evaluate if a candidate's recent experience (e.g., team building vs. shipping) matches your current 12-18 month needs.

*Timestamp: 00:12:27*

---

> "It is important to dig pretty deep and ask the hard questions. ... Why would I not hire this person? What are their biggest weaknesses? And then if they give you the typical, 'Oh, if they work too hard,' it's like, no, tell me more. What are their actual weaknesses? What are things that we should be really cognizant of? Would you hire this person again? Would you report to this person?"

**Insight:** Effective reference checks require probing beyond surface-level praise to find genuine weaknesses and behavioral red flags.

**Tactical advice:**
- Ask references: 'Why would I NOT hire this person?'
- Ask: 'Would you report to this person?'
- Pay close attention to slight pauses or hesitations in the reference's voice.

*Timestamp: 00:48:11*

---

> "Back channel references I think will always provide a greater source of truth than provided. It's similar to an Instagram Reel as opposed to the photos you're tagged in. That's the way I think of it. It's like this is what you want the world to see or think of you as, and then these are what your peers and your direct reports and the people around you actually say about the work that you did during this time."

**Insight:** Back-channel references are more reliable than provided references because they reveal the candidate's uncurated professional reputation.

**Tactical advice:**
- Prioritize back-channeling through your own network over calling the candidate's list of references.
- Look for impact that cross-functional leaders and direct reports can specifically speak to.

*Timestamp: 00:49:04*


## Luc Levesque
*Luc Levesque*

> "I'm looking for what I call signs of excellence. So I want to know the top people generally have done multiple amazing things in their life, repeated success, not just once. Maybe it was work related, maybe not work related."

**Insight:** The best predictor of future performance is a history of repeated excellence across different areas of life.

**Tactical advice:**
- Look for at least three 'signs of excellence' in a candidate's history
- Identify non-work achievements that demonstrate grit, drive, and the ability to succeed

*Timestamp: 00:15:39*

---

> "One of them is when somebody's boss leaves the company and then comes back to poach them, that is such a strong signal because if you think of what just happened, the leader who knows exactly how good this person you're talking to is... they would never do that unless this person was really, really good."

**Insight:** Being poached by a former manager is one of the highest-fidelity signals of a candidate's quality.

**Tactical advice:**
- Check if a candidate has been recruited by former managers to new companies
- Weight the 'poaching signal' heavily as it implies a high reputational risk taken by the hiring manager

*Timestamp: 00:16:37*


## Logan Kilpatrick
*Logan Kilpatrick*

> "Finding people who are high agency and work with urgency, if I was hiring five people today, those are some of the top two characteristics that I would look for in people because you can take on the world if you have people who have high agency and not needing to get 50 people's different consensus."

**Insight:** Prioritize high agency and urgency over consensus-seeking when hiring for fast-moving environments.

**Tactical advice:**
- Look for candidates who solve problems immediately upon hearing customer challenges rather than waiting for permission.
- Identify 'high agency' as the ability to push toward a solution without needing extensive external validation.

*Timestamp: 00:00:00*


## Matt MacInnis
*Matt MacInnis*

> "One of the frameworks that I use for this is SPOTAC... it's that people are smart, passionate, optimistic, tenacious, adaptable, and kind. Those five things. Six, can't even count... The framework is super useful to evaluating people."

**Insight:** The SPOTAC framework provides a structured way to decode intuition about a candidate's core attributes.

**Tactical advice:**
- Evaluate candidates against the SPOTAC criteria: Smart, Passionate, Optimistic, Tenacious, Adaptable, Kind.
- Look for 'optimism' by checking if they talk about being a victim of their previous company's performance.

*Timestamp: 00:35:54*


## Mayur Kamat
*Mayur Kamat*

> "At Agoda, we used to pay a psychologist $5,000 for every single PM we interview... it would be a six-hour psych assessment and they would tell me what your strengths are, not just that it would be an IQ component."

**Insight:** Scientific psychometric testing can identify cognitive strengths and personality quadrants (dominance vs. warmth) more accurately than standard interviews.

**Tactical advice:**
- Use structured psychometric assessments to identify a candidate's numerical, verbal, and pattern recognition abilities.
- Look for 'Quadrant 4' candidates: those with high dominance and high warmth.

*Timestamp: 00:36:00*


## Meltem Kuran
*Meltem Kuran*

> "Early on one of the first questions I would ask people is, what are the KPIs that you're willing to commit to? So if someone's only willing to commit to lead numbers, that's not good enough. They need to be able to commit to closed one revenue KPRs to really show that they care about the business's bottom line."

**Insight:** Early growth hires must be willing to take accountability for revenue, not just top-of-funnel metrics.

**Tactical advice:**
- Ask candidates what KPIs they have committed to in the past and what they believe they should be measured on.

*Timestamp: 00:47:30*

---

> "A really good way to also test for that is, this is more on the case study process, but asking someone to come up with a strategy with $0, with $10,000 and maybe a hundred thousand dollars to see if they're going to be able to scale with you. And to see how are they thinking about with different levels of spend and what are they willing to commit to at different levels of spend."

**Insight:** Use multi-tiered budget scenarios in case studies to evaluate a candidate's resourcefulness and scalability.

**Tactical advice:**
- Test how candidates prioritize channels when resources are zero versus when they are abundant.

*Timestamp: 00:50:06*


## Melissa Perri
*Melissa*

> "When you get into needing a CPO, it's like, hey, we actually have to pull together a product strategy that's all encompassing. We have to have great communication between product and the executive team."

**Insight:** When hiring a Chief Product Officer, prioritize candidates who can bridge the gap between technical execution and executive-level communication.

**Tactical advice:**
- Look for leaders who can translate product roadmaps into revenue projections for the board.
- Evaluate if the candidate can manage a complex portfolio across multiple products and geographies.

*Timestamp: 10:18*


## Michael Truell
*Michael Truell*

> "Core to how we interview too, is actually, we have people onsite for two days, and do a project with us, a work test project. And that has worked really well, that increasingly you're finding that... It gives you two days of seeing a real work product, and it doesn't have to be incredibly time-enhancing other teams from time."

**Insight:** A multi-day, on-site work test project provides a much more accurate signal of a candidate's actual output and cultural fit than standard interviews.

**Tactical advice:**
- Use a canned list of real-world projects rather than using candidate time for actual company IP.
- Spread the evaluation over two days to see how the candidate handles end-to-end tasks and team interaction.
- Use the time to evaluate 'disposition'—intellectual honesty, curiosity, and level-headedness.

*Timestamp: 00:55:12*


## Merci Grace
*Merci Grace*

> "For a standard PM role, I always make people do work... I really use that as a way to see into how someone thinks, the quality of the solutions that they bring, how they communicate. There's just so much bundled up in giving someone an actual problem, ideally to pick, not one that's assigned to them."

**Insight:** Work samples are the most effective way to evaluate a candidate's problem-solving, technical intuition, and communication skills.

**Tactical advice:**
- Use take-home assignments or work samples for all PM hires.
- Give candidates a choice of 3 different problems to solve to see what they gravitate toward.

*Timestamp: 47:57*

---

> "Whether someone was able to tell a compelling story was huge, especially at Slack, which was a very product-driven company, a very narrative-driven company. If you were going to present data, it needed to be within a very specific context. And it wasn't a company where the number always won. It was a company where the story always won."

**Insight:** In narrative-driven cultures, a candidate's ability to frame data within a compelling story is as important as their analytical skills.

**Tactical advice:**
- Evaluate candidates on their ability to structure a narrative around their product decisions.

*Timestamp: 50:21*


## Nabeel S. Qureshi
*Nabeel S. Qureshi*

> "I feel like they screened really hard for a few traits in particular. One is like very independent-minded people who weren't afraid to push back. Two is people with broader intellectual interests... And then yeah, I think three is just people who are very intensely competitive."

**Insight:** Screen for independent thinking, intellectual curiosity, and a high drive for winning rather than just standard technical skills.

**Tactical advice:**
- Look for candidates who question the frame of the interview and think for themselves.
- Identify people with broad interests outside of their core professional function.
- Prioritize an intensely competitive 'win at all costs' mentality for high-growth environments.

*Timestamp: 00:08:55*

---

> "You ask questions like, what's the hardest you've ever worked to get something done and why? And that does differentiate a lot of people, a lot of people don't actually have a great answer to that."

**Insight:** Use behavioral questions to identify 'animals'—people with the grit and motivation to go the extra 20% to achieve an outcome.

**Tactical advice:**
- Ask for specific examples of extreme effort to gauge intrinsic motivation.
- Filter for mission alignment by finding people with personal or 'private' reasons to care about the problem space.

*Timestamp: 01:02:29*


## Nick Turley
*Nick Turley*

> "We try to maximize the number of empowered people who can ship... people who can make stuff happen. And then you can add ammunition around them, which is people helping those people. ... we try to maximize the number of empowered people who can ship because that's how you have a small team and still get the ton done."

**Insight:** Prioritize hiring 'barrels'—individuals who can independently drive projects to completion—to maintain a high-output, lean team.

**Tactical advice:**
- Identify 'barrels' (owners) versus 'ammunition' (support) during the interview process
- Test for curiosity and first-principles thinking over specific domain knowledge in emerging fields

*Timestamp: 01:07:08*


## Oji Udezue
*Oji Udezue*

> "Bridgewater thinks of people in three dimensions, their skills, their attributes, and their values. Most organizations think about people in terms of just their skills. But it makes sense that people have attributes and values"

**Insight:** A comprehensive candidate evaluation must look beyond technical skills to include inherent attributes (e.g., boldness) and core values.

**Tactical advice:**
- Write job descriptions that explicitly list the required attributes and values, not just the skills.
- Ask candidates to introduce themselves and describe what they are truly great at to gauge their self-awareness and communication style.

*Timestamp: 01:03:38*


## Patrick Campbell
*Patrick Campbell*

> "We would pull all of this forward into the interview process and talk about it and basically say like, 'Hey, if this is not how you think, that's okay. We're not better than you, you're not better than us, it's just this is how we do things here.'"

**Insight:** Being radically transparent about company culture and trade-offs during interviews prevents costly hiring mismatches by allowing candidates to opt out early.

**Tactical advice:**
- Discuss cultural trade-offs and specific behavioral expectations during the interview process
- Prioritize cultural alignment over the urgency of filling a technical role
- Use final interviews as a 'culture check' to ensure candidates understand the company's unique way of working

*Timestamp: 00:11:07*


## Paul Adams
*Paul Adams*

> "Here's an amazing question I got given recently... for referral calls... "What feedback will I be giving this person in their first performance review?" It's an amazing question, because the person can't dodge it. There's an answer. And, it's incredibly enlightening."

**Insight:** Reference checks are more effective when they ask for specific, future-dated performance feedback rather than general praise.

**Tactical advice:**
- Ask references: 'What feedback will I be giving this person in their first performance review?'

*Timestamp: 01:14:13*


## Pete Kazanjy
*Pete Kazanjy*

> "I'm a big fan of doing screens, so we actually have a written screen that we do with folks, where it's the Google Doc that has a dozen or so biographical questions that we allow people to answer. You'd be shocked at how well it screens people, 57% people won't do it."

**Insight:** A written biographical screen is a high-leverage way to filter for candidate effort, communication skills, and attention to detail.

**Tactical advice:**
- Send a Google Doc with ~12 biographical questions (e.g., 'Tell me about something you built that you're proud of')
- Use the screen to filter out candidates with 'low levels of give a shit'
- Check for typos and the ability to structure a narrative with a beginning, middle, and end

*Timestamp: 00:57:12*


## Phyl Terry
*Phyl Terry*

> "If you want to get references... you want to say, 'I'm about to hire Lenny. Okay, if it would be a huge mistake if I didn't bring him on, if you think he's amazing, then call me back. Otherwise, don't bother.' And that gets around all the legal blah, blah, blah, blah, blah, and it's just it cuts through."

**Insight:** Use a 'negative response' reference check to identify truly exceptional candidates and bypass standard corporate platitudes.

**Tactical advice:**
- Leave a voicemail or send an email to a reference with a high bar for a callback.
- Only proceed if the reference proactively reaches out to confirm the candidate's excellence.

*Timestamp: 01:43:19*


## Rachel Lockett
*Rachel Lockett*

> "I ask them, 'Would you enthusiastically rehire this person for the same role?' Which is the question we always asked at Stripe. And when the answer is no to that... this is not going to work."

**Insight:** The 'enthusiastic rehire' question is a binary litmus test for maintaining a high talent bar.

**Tactical advice:**
- Regularly ask yourself if you would enthusiastically rehire each team member for their current role.

*Timestamp: 01:28:01*


## Ray Cao
*Ray Cao*

> "Curiosity is a very important quality when I'm actually talking to my interviewers because I want to see that they are naturally curious to new things. They want to learn more about the new things and don't really get stuck with their own things. That's one thing. And the other thing is the discipline... One of the good example that is the ability to prioritize because I don't believe one thing is everybody can do everything."

**Insight:** Look for candidates who possess natural curiosity, high discipline, and the ability to prioritize in a chaotic environment.

**Tactical advice:**
- Test for curiosity by seeing if candidates are naturally interested in learning things outside their immediate scope.
- Evaluate a candidate's ability to prioritize as a core competency for fast-moving environments.

*Timestamp: 00:20:05*

---

> "The first mistake I made was... we're trying to grow too fast and sometimes as a hiring manager I have to compromise the standard we're trying to hire. So that's the mistakes I think I made first and I think nobody should repeat that mistake is you need to always run for the quality rather than the quantity."

**Insight:** Never compromise hiring standards for the sake of speed, as the wrong hires will eventually slow the team down.

**Tactical advice:**
- Prioritize candidate quality over hiring quantity, even under high growth pressure.

*Timestamp: 00:36:00*


## Ryan Hoover
*Ryan Hoover*

> "It might be less about me evaluating the- the- the market need for this particular idea, but it's what's the thought process and how did this founder come to these product ideas and these insights. And so, I think having a product management background is helpful for that."

**Insight:** When evaluating early-stage founders, the quality of their product thinking and insight-gathering process is more important than the current idea.

**Tactical advice:**
- Ask founders to walk through the 'thought process' of how they arrived at their specific product insights.

*Timestamp: 00:30:06*


## Shishir Mehrotra
*Shishir Mehrotra*

> "I generally value the reference check over interview signals. If I had to stack rank in interviews, what is the best signal? The reference check is the top of the list. Those people, they worked with this person sometimes for years, their knowledge, what you're going to get out of 30 minutes of artificial scenarios it's just like never going to compare what a good reference check will give you."

**Insight:** Reference checks are the highest quality signal in hiring because they reflect years of actual work rather than short, artificial interview scenarios.

**Tactical advice:**
- Prioritize reference checks over interview performance in the final decision.
- Look for signals from people who have worked with the candidate for years.

*Timestamp: 00:00:00*

---

> "Gusto does this thing in their hiring calls. So you get an offer from Gusto and apparently when you get on the offer call of congratulations, you got an offer, instead of just meeting the recruiter, which is what most companies do, they have the entire group of people that interviewed you join the call and they all say something about why you're amazing and you should join Gusto."

**Insight:** Using the offer call as a ritual to reinforce the candidate's value and build immediate team connection.

**Tactical advice:**
- Have the full interview panel join the offer call to share specific reasons why they want the candidate to join.

*Timestamp: 00:33:34*

---

> "We ended up settling on this one called PSHE, and it comes from old mentor of mine, Quentin Clark... And it stands for Problem, Solution, How, Execution, PSHE... If you're a junior product manager, what happens? You get handed a problem. You get handed a solution. You get handed the how... and all you have to do is execute... At some point you're senior enough that you tell us the problems and you say, 'Hey. I know you told me to go work on activation, but actually I think our issue is brand,'"

**Insight:** The PSHE framework evaluates seniority based on whether a person identifies the problem, the solution, the methodology, or just the execution.

**Tactical advice:**
- Evaluate candidates based on where they fall on the PSHE (Problem, Solution, How, Execution) spectrum.
- Recognize that seniority is often defined by the ability to move from 'Execution' to 'Problem' identification.

*Timestamp: 01:10:01*

---

> "I try really hard to do is to draw contrasts... I'll say things like, 'When you think about this person, and I'll give you four different personas. Someone who's regularly coming up with the problems that the team should be focused on. Someone who given a set of problems is constantly solving them in this really creative way. The person that is just really good at getting a team moving. Or the person who can take a playbook and execute it with high precision and high quality and stuff.'"

**Insight:** Effective reference checking involves providing contrasting personas to help the reference provide an unbiased, descriptive assessment of the candidate's true strengths.

**Tactical advice:**
- Use contrasting personas during reference calls to avoid leading questions.
- Ask references: 'What questions should I have asked that I didn't?'
- Ask: 'How excitedly would you hire this person again?'

*Timestamp: 01:18:30*


## Shweta Shriva
*Shweta Shriva*

> "Especially at the senior levels, I always ask them, when was one time that you failed and what did you learn from it? I've seen that folks who has either say that they've never failed or they're trying a success story as a failure story are usually, they're disingenuous or have not had the depth of experience."

**Insight:** Use the 'failure' question to assess a candidate's seniority, self-awareness, and genuine depth of experience.

**Tactical advice:**
- Ask candidates for a specific instance of failure and the resulting lessons learned.
- Be wary of candidates who provide 'success stories' disguised as failures or claim they have never failed.

*Timestamp: 37:53*


## Tom Conrad
*Tom Conrad*

> "Every single time I've taken a job where it turned out that I was working with people who had a different set of values or working styles than I had, I knew. You tell yourself that, at least in my case, I tell myself a story about why the thing I suspect might be the case isn't the case. But you do this in your personal life all the time."

**Insight:** Instinctual reactions to people during the interview process are often accurate indicators of cultural and values alignment.

**Tactical advice:**
- Trust your gut feeling when assessing cultural fit
- Don't ignore red flags by rationalizing them away during the hiring process

*Timestamp: 00:13:03*


## Tim Holley
*Tim Holley*

> "I'm a big fan of case studies, live case studies. I think you learn a whole boatload about how someone thinks on the fly, how they react to constraints... The other one I like to ask is around something that people have taught themselves, tried to get at a growth mindset."

**Insight:** Live case studies and questions about self-taught skills reveal a candidate's ability to handle constraints and their growth mindset.

**Tactical advice:**
- Use live case studies to observe real-time problem-solving.
- Ask candidates what they have recently taught themselves to gauge curiosity.

*Timestamp: 01:07:58*


## Uri Levine
*Uri Levine*

> "Every time that you hire someone new, mark your calendars for 30 days down the road and ask yourself one question, knowing what I know today, would I hire this person? If the answer is no, fire them immediately."

**Insight:** The first 30 days provide enough information to validate a hiring decision; if you wouldn't re-hire them with that knowledge, the fit is wrong.

**Tactical advice:**
- Set a calendar reminder for 30 days after every new hire to evaluate them.
- Ask: 'Knowing what I know today, would I hire this person?'

*Timestamp: 00:00:23*

---

> "Assuming XYZ person is going to leave, how sore are you going to feel?" And you will be surprised that they are going to tell you, "Oh, it's not a big deal." This is your confirmation."

**Insight:** Use the 'keeper test' with top performers to confirm if an underperformer should be let go.

**Tactical advice:**
- Ask top-performing team members how they would feel if a specific candidate left to get confirmation on their performance.

*Timestamp: 00:58:08*

---

> "Speak with the reference... Would you hire him? Or would you hire her, right? So essentially at the end of the day you want to nail it into yes or no."

**Insight:** The most effective reference check question is a simple binary 'would you hire them again?'

**Tactical advice:**
- Ask references: 'Would you hire this person again?'
- If they say yes, ask 'Why didn't you?' to test their sincerity.

*Timestamp: 01:03:02*


## Varun Mohan
*Varun Mohan*

> "I want the company to almost be like this dehydrated entity. Every hire is like a little bit of water, and we only go back and hire someone when we're back to being dehydrated."

**Insight:** Hire only when the team is genuinely 'underwater' to maintain a lean, high-output culture.

**Tactical advice:**
- Wait for existing team members to explicitly signal they are at capacity before opening a role
- Treat every hire as a precious resource rather than a default growth metric

*Timestamp: 00:00:16*

---

> "We only hire for a role if we're actually underwater for that function... I actually think this is a feature. When you hire for a role and you already have enough people there, you get a lot of weird politics that ultimately ends up happening. And it's not because people are bad people... they will go out and manufacture some other thing that they should go work on."

**Insight:** Over-hiring leads to manufactured work and internal politics as employees seek to prove their impact.

**Tactical advice:**
- Avoid hiring ahead of the curve to prevent the creation of low-value 'busy work'
- Use under-staffing as a forcing function for ruthless prioritization

*Timestamp: 00:24:40*

---

> "One of the biggest dog whistles I hear is, when I ask people how hard are you willing to work, some people actually ultimately say, 'Hey, I work very smart.' And I basically ask them a question, 'If we have many smart people at our company that also work hard, what's the differentiator going to be? Are you just going to pull them down?'"

**Insight:** In highly competitive fields, 'working smart' is a baseline; the differentiator is combining intelligence with high effort.

**Tactical advice:**
- Screen for candidates who are willing to work hard and are passionate about the mission
- Filter out candidates who use 'working smart' as an excuse to avoid high-intensity environments

*Timestamp: 00:31:01*


## Brendan Foody
*Brendan Foody*

> "If you are very patient, there's always some trade-off between speed and quality when hiring. And I remember especially for our first 10 people, we were just so patient and disciplined about finding some of the best people in the world."

**Insight:** For the initial founding team, prioritize extreme patience and talent density over speed to establish a high-quality baseline for the organization.

**Tactical advice:**
- Be disciplined and patient when hiring the first 10 employees
- Prioritize 'extraordinary backgrounds' and former founders for early-stage hires

*Timestamp: 00:49:37*

---

> "Speed becomes more important once you find the market opportunity, the market vacuum. ... once you know that there's so much more demand than you can handle, that's when you want to step on the gas and optimize for speed in a lot of ways."

**Insight:** The hiring strategy should shift from quality-at-all-costs to speed once a clear market vacuum and overwhelming demand are identified.

**Tactical advice:**
- Transition to rapid hiring once product-market fit and high demand are confirmed
- Accept higher variance in hiring to achieve necessary growth speed during scaling

*Timestamp: 00:51:37*


## Andrew Wilkinson
*Andrew Wilkinson*

> "The kind of heuristic I have is if I ever think, should I fire this person even once, I should fire them immediately. It has always been a signal, at least for me, that when someone's a superstar, I can't imagine firing them."

**Insight:** Doubt is a powerful signal in hiring; if you are questioning a candidate's long-term fit, they are likely not the 'superstar' you need.

**Tactical advice:**
- Trust your gut signal: if you think about firing someone once, the relationship is likely already failing.
- Hire for immediate needs and proven experience rather than just 'potential.'
- Don't assume you can 'mentor' or 'coach' a poor fit into becoming a great employee.

*Timestamp: 00:38:12*


## Hila Qu
*Hila Qu*

> "When I interview a growth PM or analyst, I will always ask, 'What is a experiment you launched that has a very unexpected result? And what did you do after that?'"

**Insight:** Strong growth candidates are identified by their ability to learn from failed or unexpected experiments.

**Tactical advice:**
- Ask candidates about unexpected results to gauge the depth of their analytical thinking
- Evaluate how a candidate handles failure and what actions they take following a learning

*Timestamp: 01:28:24*


## Farhan Thawar
*Farhan Thawar*

> "Interviews are not a good predictor of performance. We know this. We know this from studies... what I really like to do is use this race car analogy. If I told you, 'Hey, I want to go hire the best race car driver,' there's not really that many questions you could ask them except for put them in the car."

**Insight:** Prioritize job trials and real work samples over traditional interviews, as they are better predictors of actual job performance.

**Tactical advice:**
- Use the first 30, 60, or 90 days as a high-stakes evaluation period to confirm fit
- Implement internship programs as long-term 'job trials' to observe real work product over months

*Timestamp: 01:03:28*


## Josh Miller
*Josh Miller*

> "Our goal of interviews is to convince people not to join The Browser Company. If I have an interview with someone, I don't pitch them and say, 'What do you want to ask me? Anything you want? I'll be super honest, most people shouldn't want to work here.'"

**Insight:** Use the interview process to actively 'anti-sell' the company to ensure only those with extreme alignment and resilience join.

**Tactical advice:**
- Be brutally honest about the downsides and difficulties of the role
- Focus on finding people who view the company as the place where they will do the defining work of their career

*Timestamp: 00:31:43*


## Keith Yandell
*Keith Yandell*

> "The fact we were willing to go all the way down the path and have someone super qualified but didn't meet the culture bar, for him was what pushed him over the edge to join the company."

**Insight:** Maintaining a strict culture bar, even for highly qualified candidates, serves as a powerful recruiting tool for other high-performers.

**Tactical advice:**
- Prioritize cultural alignment over technical qualification if a candidate is perceived as a 'jerk' or 'aloof'
- Use specific company requirements (like delivery shifts) as a governor to filter for humility and customer obsession

*Timestamp: 06:06*

---

> "If you want to achieve a 10x outcome, hiring someone that's an expert in the field, it's maybe unlikely you're going to achieve that 10x outcome, because they're likely to do things the way things have always been done."

**Insight:** Hiring generalists rather than specialists can lead to more innovative, 10x outcomes because they aren't beholden to industry norms.

**Tactical advice:**
- Look for 'Range' in candidates—people who have excelled in fields outside of the specific role
- Hire leaders who are comfortable admitting they aren't subject matter experts to empower their teams

*Timestamp: 14:38*


## Peter Deng
*Peter Deng*

> "In 6 months, if I'm telling you what to do, I've hired the wrong person. It helps me and the person operate on a different level where the goal is not, did you hit this OKR? The Meta goal becomes, are we calibrating enough? Are we actually getting into a spot where in 6 months you're the one telling me what needs to be done?"

**Insight:** Hire for extreme autonomy where the report eventually directs the manager through calibration rather than task-taking.

**Tactical advice:**
- Use the '6-month rule' as a high bar for hiring decisions
- Communicate this expectation early to set a growth trajectory

*Timestamp: 00:01:03*

---

> "I think there are five different types of product managers... Number one is the consumer PM... half designer, half product person... Another type... is the growth PM... half data scientist, half product person... The third type is what I call the GM PM or the business PM... half MBA, half product person... Another one... is the platform PM... deeply wired to build tools for other people... The last one... research PM. These are half researcher, half engineer, half product person."

**Insight:** Identify which of the five PM archetypes a candidate spikes in to ensure the right fit for the specific business need.

**Tactical advice:**
- Evaluate candidates based on their primary and secondary archetypes
- Match the PM archetype to the specific market or product stage (e.g., Platform PM for internal tools)

*Timestamp: 00:51:19*

---

> "The question I asked has been the same one I've asked for years... think about one of the biggest mistakes you've made, truly, the more painful the better. And tell me what the mistake was. Describe to me the situation, and tell me actually how you actually think differently now, work differently as a result."

**Insight:** Assess growth mindset by evaluating a candidate's ability to be vulnerable, self-reflective, and learn from significant failures.

**Tactical advice:**
- Ask for a specific, painful mistake to test for authenticity and vulnerability
- Look for how the mistake transformed into a core operating principle

*Timestamp: 01:12:05*


## Sanchan Saxena
*Sanchan Saxena*

> "Bring in people who know content and teach them process, as opposed to bringing in people who know process and trying to teach them content, because that's a bloody hard thing to do."

**Insight:** Prioritize 'content' experts (those who know what to build and why) over 'process' experts when hiring for startups.

**Tactical advice:**
- Evaluate if a candidate knows 'what to do when' rather than just 'how to run a process'
- Look for leaders who can still 'crawl up their sleeves' and do the work if their team disappeared

*Timestamp: 00:53:24*


## Scott Wu
*Scott Wu*

> "We had a candidate who came and interviewed, he was a junior at MIT... we gave him an interview, and he did way better than almost any of the full-time candidates that we had ever talked to. And so, we said, hey, what do you think about taking some time off of school and working with us and building out Devin?"

**Insight:** Identify and pursue exceptional talent based on raw performance in interviews rather than traditional credentials or seniority.

**Tactical advice:**
- Be prepared to offer non-traditional roles or paths (like leaving school) to 'outlier' candidates who outperform senior peers
- Prioritize interview performance over resume milestones

*Timestamp: 01:17:57*

---

> "And so, we actually worked with him and basically hand wrote all of his rejection responses to each of the other companies, and worked with him on it to say, here's how you should say it in a way that's going to come off as that you really did appreciate the time with them"

**Insight:** Closing top candidates requires going beyond the offer to help them navigate the personal and professional complexities of joining your team.

**Tactical advice:**
- Help candidates manage their exit from other processes or current roles to build trust and rapport
- Offer personal assistance with difficult career conversations to demonstrate commitment to the candidate's success

*Timestamp: 01:20:45*


## Timothy Davis
*Timothy Davis*

> "I can teach anyone how to do Google ads. I can teach anyone how to do Meta ads. That is not the hard part. It is the data part that is the hard part because there is so much noise going on in those accounts... what is the signal and what is the noise?"

**Insight:** Prioritize a candidate's ability to distinguish meaningful data signals from background noise over platform-specific technical knowledge.

**Tactical advice:**
- Ask candidates to optimize an account based on a raw data dump during the interview
- Evaluate if the candidate focuses on the primary goal (e.g., conversions) rather than vanity metrics like impressions or reach

*Timestamp: 00:41:07*


## Carilu Dietrich
*Carilu Dietrich*

> "How many people have you fired? And tell me about each of the experiences."

**Insight:** Asking about firing experience reveals management tenure and humanity.

**Tactical advice:**
- Ask about firing experience
- Listen for compassion

*Timestamp: 01:01:11*


