# Finding Mentors & Sponsors - All Guest Insights

*19 guests, 23 mentions*

---

## Ada Chen Rekhi
*Ada Chen Rekhi*

> "If you're thinking about getting a coach... talk to two or three different coaches. And really get a sense of their vibe and how well you get to know them... half of people that founder their coach literally went with the first coach that they talked to."

**Insight:** Coaching is most effective when there is a strong personal connection and 'vibe' rather than just matching credentials.

**Tactical advice:**
- Interview multiple coaches before committing to one.
- Use coaches for hyper-growth phases, sensitive interpersonal conflicts, or specific skill acceleration.
- Consider 'niche' coaches for short-term goals like fundraising pitches or writing.

*Timestamp: 00:48:02*


## Ami Vora
*Ami Vora*

> "I think we tell women things like, you need to find a mentor and you need to find a sponsor, and that's just another set of hoops... I had the extreme generosity of so many wonderful leaders who helped me on my way, but I didn't feel like I had this mentor... I had everything I needed, people were so kind and generous, but I didn't recognize it that way because we talk about it differently."

**Insight:** Mentorship can be a collection of insights from many leaders rather than a single formal 'oracle' relationship.

**Tactical advice:**
- Build 'emulators' of different leaders in your head to load their specific skillsets (e.g., 'What would Boz do here?').
- Don't feel pressured to find one perfect mentor who matches your exact life path.

*Timestamp: 00:54:01*


## Bangaly Kaba
*Bangaly Kaba*

> "It's actually better to have a stable of mentors. You want to have three or four. And ideally, what you do is you meet with each one of them once a month on a different Friday of the month."

**Insight:** Build a 'stable' of multiple mentors to ensure consistent support and diverse perspectives even if one is unavailable.

**Tactical advice:**
- Schedule meetings with different mentors on different Fridays of the month.
- Ask for mentors by describing a specific challenge you are trying to solve rather than asking for general mentorship.

*Timestamp: 00:20:09*


## Bret Taylor
*Bret Taylor*

> "When you ask for advice, don't just ask what to do but why. Be an obnoxious two-year-old kid, why? Why? Why? Why? And really try to understand the framework that someone is using to give you advice."

**Insight:** To get value from mentors, you must deconstruct their advice into the underlying frameworks to avoid misapplying their specific anecdotes.

**Tactical advice:**
- Ask 'why' repeatedly to uncover the first principles behind a mentor's suggestion
- Ask 'who should I talk to get good advice?' to find consensus among experts

*Timestamp: 00:29:26*


## Christian Idiodi
*Christian Idiodi*

> "You're going to find the loudest, most influential person in your organization, the person that everybody knows, knows everything, is in every meeting and stuff, and you're going to ask them to teach you. You're going to challenge them. And if they don't have the time to teach you, you're going to volunteer to help them."

**Insight:** Proactively seek mentorship from the most competent people in the company to gain both their knowledge and their social capital.

**Tactical advice:**
- Ask to sit in on a leader's meetings for a week just to observe.
- Offer to help a mentor with their tasks in exchange for the opportunity to learn their decision-making process.

*Timestamp: 00:09:15*


## Chip Conley
*Chip Conley*

> "Brian would go to experts and say to the expert, 'I don't know what the hell I'm doing.' He did that with me when it came to hospitality. I appreciated that a guy who had a lot of hubris... could also have the humility to say, 'I want to learn more about this.'"

**Insight:** The most effective way to find and learn from mentors is to admit what you don't know, regardless of your seniority.

**Tactical advice:**
- Approach experts with a growth mindset and radical honesty about your knowledge gaps

*Timestamp: 00:12:30*

---

> "Maybe that's what a mentor can be is a confidant, someone who gives you confidence and helps by asking questions, helps you as the younger mentee find your roadmap to success."

**Insight:** Mentorship is less about giving answers and more about providing the confidence and questions that help a mentee find their own path.

**Tactical advice:**
- Act as a 'confidant' by building the mentee's confidence through inquiry

*Timestamp: 00:26:11*

---

> "One of the things I loved at Airbnb... where I had something to teach them and they had something to teach me... mutual mentorships."

**Insight:** Modern mentorship should be intergenerational and reciprocal, where both parties exchange different types of knowledge (e.g., technical vs. management).

**Tactical advice:**
- Seek 'mutual mentorships' where you trade skills with someone from a different generation or background

*Timestamp: 00:37:02*


## Christopher Miller
*Christopher Miller*

> "Mentors are great, don't get me wrong... but when I think about the people in my life, who... the time that they donated to me... I would actually describe those folks as being sponsors and advocates, people who were willing to put up capital, whether that's professional, social capital to bet on you."

**Insight:** Career acceleration depends more on finding sponsors who will bet their professional capital on you than on traditional mentors.

**Tactical advice:**
- Differentiate between mentors (advice-givers) and sponsors (opportunity-creators)
- Build trust with potential sponsors by being coachable and delivering results on their behalf

*Timestamp: 00:30:15*

---

> "putting ego aside and embracing not knowing stuff and embracing not being good at stuff, and not feeling self-conscious about that and letting the desire to be the best at something or at least be great at something overpower the fear of being inadequate at something."

**Insight:** Attracting high-level sponsors requires a combination of extreme humility and an intense desire to be coached.

**Tactical advice:**
- Explicitly ask for hard feedback and respond with gratitude rather than defensiveness
- Show sponsors that you are a high-ROI investment by quickly applying their feedback

*Timestamp: 00:32:02*


## Deb Liu
*Deb Liu*

> "I'm in a lean-in group and we are just like, we support each other. I'm in a coaching circle in YPO, so that's a group of CEOs. And I'm in a number of these coaching circles, which give you an opportunity to learn from each other and to get pure coaching. And I think that's a great place to start, especially early in your career when you're seeing the same people making the same mistakes."

**Insight:** Peer coaching circles provide a scalable and accessible alternative to traditional 1:1 mentorship, allowing for shared learning and support.

**Tactical advice:**
- Join or form a 'coaching circle' with peers at a similar career stage to share challenges
- Use peer groups to validate whether a challenge is personal or situational

*Timestamp: 01:03:54*


## Elena Verna
*Elena Verna 3.0*

> "Don't think that you have unique problems. You don't... Your problem has been solved by somebody. Or at least that there's a lot of failures on the problem that you should be learning from. And number one thing that whenever you have an initiative or whenever you have a metric that you need to go and move, to not start from scratch, ever."

**Insight:** Most growth problems are not unique; seeking advice from those who have solved them before is the fastest way to avoid wasted cycles.

**Tactical advice:**
- Reach out to peers at other companies via LinkedIn or X to ask how they solved specific growth challenges.
- Hire advisors to provide structural frameworks for new initiatives (e.g., community building).

*Timestamp: 00:34:02*

---

> "Not hiring advisors is something that I do not recommend for you to do. You can get access to anybody for one hour a week. Yeah, you'll have to pay them... but hiring advisors is the biggest career amplification and your business amplification can possibly do."

**Insight:** Advisors provide a critical external input that helps pattern-match and prevents teams from 'winging it' in isolation.

**Tactical advice:**
- Conduct a paid workshop with a potential advisor to see their problem-solving style before committing to a retainer.
- Evaluate advisor value on a monthly basis rather than assuming a long-term fixed engagement.
- Hire advisors as contractors to gain access to specific expertise for just one hour a week.

*Timestamp: 01:01:10*


## Fareed Mosavat
*Fareed Mosavat*

> "I think of this as sponsorship, not mentorship. I don't necessarily find that in my career. I've had a lot of managers where I'm like, "Wow, their day-to-day help was super awesome at helping me be a better leader." ... But what I do have is a couple examples of people who deeply trusted me to solve big problems... it's about creating trust and knowing that you have a sponsor there, someone who's going to go to bat for you."

**Insight:** Sponsorship is more critical than mentorship for career acceleration because it involves leaders trusting you with high-stakes opportunities and advocating for your advancement.

**Tactical advice:**
- Focus on building deep trust with leaders by solving their most important problems
- Communicate your work in a way that demonstrates you are ready for the next level of responsibility
- Identify leaders who have the influence to 'go to bat' for you in organizational decisions

*Timestamp: 00:25:00*


## Gibson Biddle
*Gibson Biddle*

> "The first rule of thumb is, don't ask a person to be your mentor. That's really awkward. First, identify them. Say, this is a person I think that could be helpful to me. And then, find ways to be helpful. Everybody needs help."

**Insight:** Build mentorship relationships organically by offering value to the mentor first rather than making a formal request.

**Tactical advice:**
- Identify mentors who can help you 'see around corners'
- Offer specific help to potential mentors (e.g., explaining new tech like Discord or building a simple website)
- Build a 'Personal Board of Directors' consisting of both peers and senior mentors

*Timestamp: 41:55*


## Graham Weaver
*Graham Weaver*

> "The equivalent of that in your life is an executive coach... Number one, make space to ask yourself the big questions in life about your career, your relationships, your health... And then part two is that person can hold you accountable."

**Insight:** Executive coaching provides the necessary external accountability and dedicated space to move out of 'autopilot' mode.

**Tactical advice:**
- Hire a coach to act as a 'personal trainer' for your life and career
- Use a structured weekly form to report on goals, past actions, and intended outcomes before every meeting
- If a coach is unaffordable, find a like-minded peer for mutual weekly accountability walks

*Timestamp: 00:38:25*


## Jeffrey Pfeffer
*Jeffrey Pfeffer*

> "get a personal board of directors like they talk about in the Wall Street Journal. In other words, get people who will give you advice, give you social support, and hold you accountable."

**Insight:** A structured group of advisors (a personal board) provides the necessary guidance, emotional support, and accountability for career growth.

**Tactical advice:**
- Assemble a 'personal board of directors' to provide diverse perspectives and hold you accountable to your development goals.

*Timestamp: 01:17:28*


## Jules Walter
*Jules Walter*

> "make the smallest ask possible, which is the opposite of what 95% of people do. 95% of people is like, 'Hey, I've never met you... Can we set up a call?' That's like a big ask. What I do... reached out in the evening and I was like, 'Hey, thanks so much for speaking today... Is there an example of product that you think was created with this approach?' Something he could answer in literally two minutes via email?"

**Insight:** Secure high-level mentors by starting with tiny, specific email requests that require minimal effort to answer, then building the relationship through follow-ups.

**Tactical advice:**
- Start with a specific question that can be answered in under two minutes via email.
- Always circle back to the mentor to show exactly how you applied their advice and what the result was.
- Look for mentors who are not only experts but also possess the ability to explain their process clearly.
- Reciprocate by asking mentors what problems they are currently facing and offering your help.

*Timestamp: 00:58:29*


## Manik Gupta
*Manik Gupta*

> "The first one is really about people. It's about surrounding yourself with the best people you can find... The important thing when you look back is how much luck played a big part, and of course the risk that somebody took played a big part... If you're create enough opportunities, especially early on in your career as you asked, around hanging around people who are doing interesting things and they're doing things which really are different, or they're doing things in a different manner and it's exciting, the right things will happen."

**Insight:** Career success is often a byproduct of intentionally surrounding yourself with high-performing 'superstars' and maintaining those relationships over the long term.

**Tactical advice:**
- Identify 'A plus' people early in your career and find ways to work in their orbit.
- Play the long game by sticking with talented individuals across multiple career moves to build shared trust.

*Timestamp: 00:05:16*


## Melissa Tan
*Melissa Tan*

> "Never ask someone to be your mentor... the more it can be organic where you talk to somebody, you have actual advice that you want... reach out when you actually have a problem. People that want to help others are just going to, if they have the time, they'll say yes."

**Insight:** Mentorship is most effective when built organically through specific advice requests rather than formal titles.

**Tactical advice:**
- Reach out with a specific, actionable problem rather than a general request
- Avoid using the word 'mentor' in early interactions to reduce pressure
- Nurture relationships by following up on how their advice was implemented

*Timestamp: 00:26:57*


## Nikhyl Singhal
*Nikhyl Singhal*

> "I think that learning is changing... there's community, which I think whether it's within your company or outside of company, I think is the answer that we'll see more and more. I think community as a way of creating safety, having authentic conversations, feeling that you're not alone, that others are going through the same thing, and then sharing best practices is so powerful."

**Insight:** Modern mentorship is evolving into peer communities that provide safety and shared experiences for 'lonely' leadership roles.

**Tactical advice:**
- Join or build a small, high-trust community of peers in similar roles
- Use community to validate that your challenges are systemic rather than personal failures

*Timestamp: 00:45:37*


## Paul Millerd
*Paul Millerd*

> "Reach out to somebody, sort of like a podcast, that's ahead of you on a similar path, and just send them a message and say, really thoughtful message. Say, 'Hey, you're on a path a few years ahead of me. I'm really curious about this. I don't have people in my life that have done things like this. Can I just pick your brain? If we can't jump on a call, can I send you a list of questions?'"

**Insight:** Cold outreach to 'path experts' is more effective when you offer a low-friction option like written questions.

**Tactical advice:**
- Identify people 2-3 years ahead of you on your desired path
- Offer to send written questions instead of requesting a live call to increase response rates

*Timestamp: 00:24:15*


## Phyl Terry
*Phyl Terry*

> "One of the ways that everyone listening to this podcast today can get a mentor, you can get what I call a dead or distant mentor. Warren Buffett is my mentor, he just doesn't know it... I mean really study. If you really study Jobs, you have to come to 1997... if you really study that moment and study what Jobs did, it can inform your decisions and actions."

**Insight:** Utilize 'dead or distant mentors' by deeply studying the historical decisions and philosophies of world-class leaders to guide your own professional judgment.

**Tactical advice:**
- Select a leader you respect and study their specific actions during critical career moments.
- Read primary sources (talks, letters, original interviews) rather than just biographies.
- Apply their frameworks to your current professional challenges as if they were advising you.

*Timestamp: 01:34:54*


