# Founder Sales - All Guest Insights

*16 guests, 28 mentions*

---

## April Dunford
*April Dunford 2.0*

> "40 to 60% of B2B purchase processes end in no decision. If you scratch on that data, the majority of those aren't saying, 'Well, I'm not making a decision to buy something new because the old thing we were doing is better.'... the majority of those is they couldn't figure out how to make a choice confidently."

**Insight:** The primary competitor in B2B sales is often customer indecision and the fear of making a high-stakes mistake rather than other software vendors.

**Tactical advice:**
- Focus on helping the buyer make a choice confidently rather than just pitching features.
- Act as a guide to help the buyer navigate the market and understand their options.
- Recognize that 'no decision' is the safest risk-free path for a buyer who is overwhelmed.

*Timestamp: 00:00:00*

---

> "If a customer is indecisive, throwing FOMO into the mix makes it worse. So they're less likely to close the deal if you throw that in. And the idea is that they're already stressed out and you're just putting more stress on them by pressuring them."

**Insight:** Using fear of missing out (FOMO) can backfire with indecisive buyers by increasing their paralysis; instead, focus on de-risking the decision.

**Tactical advice:**
- Avoid high-pressure FOMO tactics with paralyzed or indecisive prospects.
- Offer tools to help the customer buy, such as money-back guarantees or implementation support.
- Break large deals into smaller, less intimidating pieces to reduce perceived risk.

*Timestamp: 00:26:49*


## Bob Moesta
*Bob Moesta*

> "Instead of trying to base the sales process on how we want to sell, we need to actually design the sales process on how they want to buy. And it seems like it's the same thing, but they're actually really, really different things."

**Insight:** Sales processes should be engineered to match the buyer's natural decision-making timeline rather than the company's internal sales targets.

**Tactical advice:**
- Map the buyer's timeline through six phases: first thought, passive looking, active looking, deciding, first use, and ongoing use.
- Tailor demos to the specific phase the buyer is in (e.g., educational stories for passive looking vs. trade-off choices for deciding).

*Timestamp: 00:14:24*


## Bret Taylor
*Bret Taylor*

> "To be a great founder, you really need to be able to not have such a ossified view of your identity... you have to sell investors... candidates... customers."

**Insight:** Founding is fundamentally a sales role; you must sell the vision to investors, talent, and customers alike.

**Tactical advice:**
- Adopt a flexible identity that embraces sales as a core responsibility of building

*Timestamp: 00:14:17*


## Dalton Caldwell
*Dalton Caldwell*

> "The Collison Install is what often happens with customers, is that they say, 'Yes, I want you buy your product.' And then they do not implement it, they just go quiet. There's no implementation and this is very bad if you're selling software to someone... they would just install Stripe into the customer's website... they basically would not go away until you finish the implementation of Stripe."

**Insight:** Early sales success requires 'white glove' service to ensure the customer actually implements and uses the product after the initial 'yes.'

**Tactical advice:**
- Don't consider a sale finished until the product is fully implemented
- Offer to manually install or set up the software for the customer to ensure activation
- Be persistent and available to help customers through the 'last mile' of implementation

*Timestamp: 00:45:53*

---

> "I think if you find people that are really excited and you do line up customers, that is a great green light that it is time to do a startup, right? That can get you down the path... Build it once you have some conviction and then you're like, 'Oh, I think I would have a customer. I think that at least one person would use this thing I want to build.'"

**Insight:** Founders should attempt to pre-sell or validate demand with at least one customer before committing to building the full product.

**Tactical advice:**
- Try to pre-sell the solution before writing significant code
- Look for 'green lights' from potential customers to build conviction

*Timestamp: 01:11:20*


## Geoffrey Moore
*Geoffrey Moore*

> "Shut the God damn laptop. Just don't open it and start with... 'We're here because we've been working with some people in your industry and we understand there's this really serious problem... and we believe that your company might have it, is that true?'"

**Insight:** Early sales to pragmatists should be diagnostic and focused entirely on the customer's pain rather than product demos.

**Tactical advice:**
- Avoid opening your laptop or giving a demo in the initial diagnostic meeting.
- Ask probing questions to let the customer 'self-diagnose' their problem.

*Timestamp: 00:42:35*

---

> "Your goal in that call is to get them to talk as much as possible and for you to take notes. And by the way, this is a place where you probably still want to remember to use a pen because you actually want them to see you writing down their words, because that means, 'Okay, he's listening.'"

**Insight:** Active listening and physical note-taking build trust with pragmatic buyers who feel their problems are unique.

**Tactical advice:**
- Use a physical pen and paper so the customer can see you are capturing their specific words.
- Maximize the customer's 'talk time' during the discovery phase.

*Timestamp: 00:48:00*


## Gustaf Alstromer
*Gustaf Alstromer*

> "The problem is, which anyone who hasn't done sales before that joined YC, they realize this, is that if you take the average customer group in the world, 90% are not early adopters... Those 10 percents are the early adopters. They're The ones that you actually want to reach. But that means you have to reach 10 to find one."

**Insight:** Founder-led sales is a numbers game of filtering for early adopters who are willing to take a chance on a new product.

**Tactical advice:**
- Conduct high-volume outreach to find the small percentage of users with high problem intensity

*Timestamp: 00:24:25*


## Jen Abel
*Jen Abel*

> "Founder led sales is really that first milestone that a startup goes through on the commercial side, which is, how do I go out and get my first few customers? ... the founder is the product."

**Insight:** In the early stages, the founder's novel insight and subject matter expertise are the primary drivers of interest before a brand or product is fully established.

**Tactical advice:**
- Leverage the founder's status as the highest order in the hierarchy to gain market access.
- Use the founder's ability to see 'budding moments' in conversations to refine the product vision.

*Timestamp: 00:03:29*

---

> "If you can focus the messaging in a way that speaks to something that has a bit of shock value, or is counterintuitive, you'll get them to continue reading. ... relevancy. I think that matters even more so than personalization right now."

**Insight:** Effective cold outreach relies on immediate relevancy and a counterintuitive hook rather than generic personalization.

**Tactical advice:**
- Keep outreach emails to 3-4 sentences max so they don't require scrolling on mobile.
- Focus the message on the problem being solved rather than the solution.
- Use a 'shock value' or counterintuitive line to make the recipient pause.

*Timestamp: 00:13:20*

---

> "Before you buy any tool, don't even think about tools. ... Can you manually find 30 people that you want to spend 15 to 20 minutes writing a rock solid note to?"

**Insight:** Manual lead generation and outreach are necessary to identify the correct parameters and messaging before attempting to scale with automation tools.

**Tactical advice:**
- Manually research 30 prospects to identify commonalities like team size, industry, or role duration.
- Test messaging manually to see which roles and problems yield the highest response rates.

*Timestamp: 00:23:28*

---

> "Founder led sales is not about revenue on day one. It is about learning as fast as humanly possible to get to that pulse, so that you can earn the right to sell."

**Insight:** The primary goal of early founder-led sales is market research and learning, not immediate revenue generation.

**Tactical advice:**
- Treat early sales calls as research sessions to collect intel on how the market perceives the problem.
- Be vulnerable about being an early-stage startup to elicit more honest feedback from prospects.

*Timestamp: 00:35:47*

---

> "Get the second call booked on the first call. Pull up calendars. Look at calendars. Who else should be invited?"

**Insight:** Maintaining momentum requires securing the next meeting while still on the current call.

**Tactical advice:**
- Ask to pull up calendars at the end of the first call.
- Identify other stakeholders who should be included in the next session.

*Timestamp: 00:42:25*

---

> "It's qualification. Qualification because if you spend your time on the wrong leads, that equates to a zero. ... it's never a bottom of funnel problem. It's always qualification."

**Insight:** Most sales failures are actually failures of qualification at the top of the funnel rather than closing issues at the bottom.

**Tactical advice:**
- Verify if the prospect is measuring or managing the problem today before proceeding.
- Stop chasing leads that are 'just being nice' but have no intent to buy.

*Timestamp: 01:10:25*

---

> "I don't use a tool. The thing about AI tools is they're all pulling from the same databases. I want to email someone not in the database that's getting hit by a million folks. I want to take a back door in, not the front door where everyone else is trick or treating."

**Insight:** Manual, highly personalized outreach is more effective for high-value enterprise deals than automated AI-driven tools that use the same saturated databases.

**Tactical advice:**
- Use visual cues from LinkedIn (e.g., how long they've been in a role) to customize notes.
- Send manual, one-sentence emails that feel human and different from automated spam.

*Timestamp: 01:01:18*


## Jonathan Lowenhar
*Jonathan Lowenhar*

> "Sales. And this is the codification of a playbook. How are we having the conversation? How are we doing discovery? How are we handling objections? How are we doing demo? How are we moving to close?"

**Insight:** The goal of early sales is to codify the founder's 'magic' into a repeatable playbook for others to follow.

**Tactical advice:**
- Document the specific discovery questions that lead to successful qualifications.
- Create a standard process for handling common objections and running demos.
- Ensure the playbook is structured enough for 'non-founder' account executives to execute.

*Timestamp: 01:03:37*


## Marty Cagan
*Marty Cagan 2.0*

> "If they're a real product manager and they're worried about value and viability, that is the founder's job. So the founder should be doing that and needs to be doing that, and it usually causes conflict if they bring in a real product manager too soon."

**Insight:** In the early stages, the founder must own the 'value and viability' functions to avoid organizational conflict.

**Tactical advice:**
- Founders should act as the primary product person until the team reaches roughly 20-25 engineers.
- Avoid hiring a PM too early if the founder is still the primary driver of product value and business viability.

*Timestamp: 01:15:53*


## Pete Kazanjy
*Pete Kazanjy*

> "The point is is that you can't outsource that behavior, the founder's got to do that stuff. A lot of people ask me that question, "Well, I suck at sales," or, "I'm afraid to talk to people," or, "Interfacing with non-friendly parties makes me uncomfortable." The way to think about it is... it's going to be way easier for you to get good, or minimally viable good, at selling by having interactions with non-friendly parties and having commercial conversations and asking for money in exchange for the value delivery."

**Insight:** Founders cannot outsource early sales because they need the direct feedback loop to validate the product and message.

**Tactical advice:**
- Do not hire a VP of Sales until you have closed the first couple dozen customers yourself
- Use early sales calls as customer development to refine the product-market fit
- Focus on becoming 'minimally viable' at selling rather than a master

*Timestamp: 00:11:11*

---

> "One, it's going to help you with your product development because you're not going to have that abstracted, for sure, two, you're going to be the person who's going to figure out how to talk about it in an effective way, and then three, it's going to make it such that you can package that up such that other human... Because that's the way that B2B startups scale... by adding more salespeople who then have customer-facing meetings with prospects."

**Insight:** Founder-led sales serves three purposes: product refinement, discovering the pitch, and creating the 'source code' for future hires.

**Tactical advice:**
- Document your discovery questions, slides, and scripts as you sell
- Identify the repeatable 'while loop' in your sales process before hiring others

*Timestamp: 00:13:55*


## Raaz Herzberg
*Raaz Herzberg*

> "We ended up selling before we had a seller's team. We ended up, almost in some ways, always being behind, right? Okay, I'm closing contracts with people, I haven't hired my first salespersons... if you can't do it one time end to end, and you're the core, core group, the chances of just bringing somebody from the outside to solve that problem, it's wishful."

**Insight:** Founders must personally close the first few million in ARR to ensure the sales motion is repeatable before hiring a sales team.

**Tactical advice:**
- Do not hire a salesperson to fix a message that isn't landing; the core team must prove it works first.
- Aim to reach a couple million in ARR through founder-led sales before building a formal sales org.

*Timestamp: 00:21:23*


## Robby Stein
*Robby Stein*

> "My co-founder and I just basically got the contact of Scooter Braun... we literally went immediately to the airport. I just remember just basically going straight to the airport, flying to LA meeting with him... Intense urgency usually wins over thinking about it for a long time."

**Insight:** Early-stage success often requires extreme scrappiness and immediate action to secure high-leverage partnerships.

**Tactical advice:**
- Use 'intense urgency' to close deals—if a meeting is offered for tomorrow, get on a plane immediately.
- Target 'tastemakers' or influential users early to solve the cold start problem.

*Timestamp: 01:19:00*


## Sahil Mansuri
*Sahil Mansuri*

> "Stop using email. Email is where deals go to die. Text message is where deals get done... I don't take the introer off the thread... It holds the person's feet to the fire to actually show up for the meeting."

**Insight:** High-stakes sales require high-touch communication like text messaging and leveraging social pressure from mutual connections.

**Tactical advice:**
- Request introductions via text message instead of email
- Keep the introducer on the text thread to ensure accountability for the meeting
- Follow up persistently (up to 9 weeks) if a warm lead goes quiet

*Timestamp: 00:56:03*

---

> "I personally work with Microsoft. So I have a little bit of insight in this. Here's what your employees think about you. Here's what Mark's approval rating looks like versus others, et cetera, et cetera.' This whole research report, I kind of broke out some highlights, a couple screenshots, attached the report and said, 'Hey, I'd love to discuss this with you sometime.'"

**Insight:** Close major accounts by providing deep, customized research that changes the prospect's perspective on their own business.

**Tactical advice:**
- Conduct deep sentiment analysis or data research on the prospect's company
- Use high-leverage subject lines (e.g., 'Mark's approval rating')
- Target the highest-level executive with insights they can't get elsewhere

*Timestamp: 01:03:18*


## Sri Batchu
*Sri Batchu*

> "My view is you start off with founder-led sales, the early team needs to know how to actually sell."

**Insight:** B2B growth should begin with the founders and early team personally handling sales to understand the customer before scaling.

**Tactical advice:**
- Ensure the early team knows how to sell before hiring dedicated sales staff
- Use founder-led sales as the foundation for understanding customer needs

*Timestamp: 00:00:00*


## Todd Jackson
*Todd Jackson*

> "I tend to gravitate towards the, 'I want to sell it before I build it,' because I really want the signal from customers and I want that to be the guide and the oxygen that drives what I'm building."

**Insight:** Selling the vision or mock-ups before building the full product provides the necessary signal to ensure the product satisfies the other three Ps (Persona, Problem, Promise).

**Tactical advice:**
- Use Figma mock-ups to secure the first 5-10 customers before writing extensive code.
- Determine the 'fidelity' required for a demo based on the product type (e.g., mock-ups for workflow tools vs. real data for analytics tools).

*Timestamp: 00:34:25*


## Jeanne Grosser
*Jeanne Grosser*

> "Wait until you're around a million in ARR. When you have a repeatable process... as a founder you want to stay deeply connected to customers and get it to a scale and get it to a point where you use the word, there's some repeatability there."

**Insight:** Founders should lead sales until they reach roughly $1M ARR and have a documented, repeatable ICP.

**Tactical advice:**
- Don't hand over sales until you can define an ICP (e.g., 'startups with <100 employees building SaaS').

*Timestamp: 00:29:05*

---

> "Excellent salespeople typically will talk well under half the time in a conversation because they're out asking questions, probing often helping a customer arrive at conclusions on their own. And so learning how to do five why's, go deep rather than immediately going into problem solving mode."

**Insight:** Effective sales discovery is about deep listening and probing rather than immediate problem-solving.

**Tactical advice:**
- Use the 'five whys' technique and ask questions about the customer's questions to uncover deeper pain.

*Timestamp: 00:54:39*


