---
name: fundraising
description: Help founders raise capital and build investor relationships. Use when someone is preparing a pitch deck, deciding whether to raise venture capital, meeting with investors, or asking about fundraising strategy.
---

# Fundraising Strategy

Help the user navigate the fundraising process using insights from 2 product leaders.

## How to Help

When the user asks for help with fundraising:

1. **Question the assumption** - Before diving into tactics, ask whether they should raise at all. Understand their goals and whether venture capital is the right path
2. **Understand their stage** - Ask what round they're raising, how much traction they have, and what their strongest proof point is
3. **Help craft the pitch** - Focus on leading with their strongest point and building a compelling narrative
4. **Prepare for the process** - Set expectations about rejection rates and help them build resilience for the "dance of 100 nos"

## Core Principles

### Lead with your strongest point on slide one
Uri Levine: "Most people are missing the most important slide of their presentation is the first slide... This is the place that you're going to put your strongest point." Investors form impressions in the first minute. Don't bury your best evidence. If you have incredible traction, lead with it. If you have a unique insight, lead with that.

### Challenge whether you should raise at all
Ryan Hoover: "I do spend time challenging founders sometimes when they're thinking about raising... to not raise." The venture path creates a "treadmill" of growth expectations. Before optimizing your pitch, honestly assess whether venture capital aligns with your goals, timeline, and the nature of your business.

### Prepare for the "dance of 100 nos"
Fundraising is a numbers game. Most investors will say no, and that's normal. The psychology of repeated rejection requires preparation and resilience. Don't take early nos as signal about your company's viability.

## Questions to Help Users

- "What's your strongest proof point right now - traction, team, insight, or market?"
- "Why are you raising venture capital specifically? Have you considered alternatives?"
- "What's on your first slide? Is it your strongest point?"
- "How many investors have you talked to? What patterns are you seeing in their feedback?"
- "What's your target raise and how did you arrive at that number?"

## Common Mistakes to Flag

- **Burying the lede** - Putting your strongest evidence on slide 5 instead of slide 1. Investors decide early
- **Raising by default** - Assuming venture capital is the only path without considering bootstrapping or alternative funding
- **Underestimating rejection** - Not preparing psychologically for 50-100 nos before getting a yes
- **Weak opening** - Starting with problem/solution when you have strong traction that would be more compelling

## Deep Dive

For all 2 insights from 2 guests, see `references/guest-insights.md`

## Related Skills

- Giving Presentations
- Founder Sales
- Negotiating Offers
- Startup Ideation
