---
name: giving-presentations
description: Help users create and deliver compelling presentations. Use when someone is preparing a talk, building a slide deck, dealing with presentation anxiety, practicing for a keynote, or asking how to be more engaging when presenting.
---

# Giving Presentations

Help the user create and deliver compelling presentations using techniques from 19 product leaders.

## How to Help

When the user asks for help with presentations:

1. **Understand the context** - Ask about the audience, the stakes, the format (keynote, board meeting, all-hands), and how much time they have
2. **Start with narrative, not slides** - Help them identify the one thing they want the audience to remember before touching slide software
3. **Structure for engagement** - Guide them to use contrast, story, and state changes to maintain attention
4. **Prepare for delivery** - Coach on rehearsal techniques, managing nerves, and physical presence

## Core Principles

### Start with the arrow, then build the bow
Tristan de Montebello: "Stop focusing as much on what you want to say and focus more on what you want your audience to remember. We call it the bow and arrow technique because you can only remember one thing out of a talk... The one thing is your arrow." Define a single sentence that represents the only thing you want remembered. Select anecdotes and data (the bow) that provide the tension to launch that arrow.

### Use "what is vs. what could be" contrast
Nancy Duarte: "This motion of traversing between what is, what could be, what is, what could be... makes people leave their current state and long for this future state." Structure your narrative to alternate between the current flawed reality and the ideal future. End with "new bliss" - the world with your idea adopted.

### Make the title the takeaway
Andy Raskin: "Replace 'The Team' with 'Our team is veterans of whatever industry.' Every single slide it's a takeaway, not a label." Slide titles should be descriptive conclusions, not generic category labels. The audience should understand the point without reading the body.

### The audience is the hero, you are the mentor
Nancy Duarte: "In myths and movies, the mentor comes alongside the hero. The presenter should come alongside the audience and help them get unstuck or bring a magical tool." Treat the audience as the protagonist on a journey. Your job is to give them tools, not show off your expertise.

### Schedule state changes every 3-5 slides
Wes Kao: "Every three to five slides, put in a state change. We want to turn audience engagement from an art into a science." Insert interactive elements at regular intervals. Ask the audience to guess a data point before revealing it to increase engagement.

### De-risk with pre-meetings and role-play
Casey Winters: "You want to de-risk that meeting not make it a big success or fail moment... have pre-meetings with key individuals so they're less surprised." Role-play the presentation by impersonating specific stakeholders and their likely objections. Surface concerns before the formal review.

### Look up when thinking, not down
Tristan de Montebello: "If you're looking down on Zoom, it looks like you're looking at your phone. If instead you think up, you actually look thoughtful by default." Direct your gaze upward when gathering thoughts. Place a "Think Up" post-it note on your monitor as a reminder.

### Reframe anxiety as excitement
Matt Abrahams: "When you feel those symptoms of anxiety, say 'This is exciting. I get to share my point of view.' By seeing it as more positive, it causes us to relax." Anxiety and excitement share the same physiological response. Labeling the arousal as excitement improves performance.

### Use the 1:2 breathing ratio
Matt Abrahams: "Your exhale should be twice as long as your inhale. Take a three count in, take a six count out." The physiological relaxation response is triggered during the exhale. Use a double-inhale to fully expand lungs before the long exhale.

### Stay in character from start to finish
Tristan de Montebello: "Don't share your insecurities. Stay in character from beginning all the way through past the ending. Audiences rarely notice internal nervousness unless you leak it." Do not apologize for minor verbal slips or admit to being nervous. Use the internal cue "stay in it" to maintain composure.

### Master the material so you don't need notes
Jeffrey Pfeffer: "I never appeared before Congress with notes. I wanted them to believe, which was true, that I was in complete control and mastery of the material." Presenting without notes signals authority. Master your material so thoroughly that you can maintain eye contact throughout.

### Use the Accordion Method to internalize, not memorize
Tristan de Montebello: "Practice your talk with strict time constraints, starting at 3 minutes and working down to 30 seconds. Once you reach the essence, expand it back up." This helps you internalize key pillars rather than memorizing a word-for-word script, which can lead to catastrophic failure if you lose your place.

## Questions to Help Users

- "What's the one thing you want the audience to remember after your presentation?"
- "Who is your audience and what do they care about?"
- "What's the contrast between 'what is' and 'what could be' in your story?"
- "Have you rehearsed this talk out loud? How many times?"
- "What are the most likely objections or questions you'll get?"
- "Where in your deck do you have state changes or interactive moments?"

## Common Mistakes to Flag

- **Starting with slides instead of narrative** - Open a notes app first, not PowerPoint. Define your story points before designing visuals
- **Generic slide titles** - "The Problem" tells the audience nothing. "Our customers waste 4 hours per week on manual data entry" tells them everything
- **No state changes** - A 30-slide monologue will lose the audience. Build in interaction every 3-5 slides
- **Over-rehearsing word-for-word** - This can cause catastrophic failure if you lose your place. Internalize key pillars instead of memorizing scripts
- **Leaking insecurity** - Saying "I'm nervous" or "I don't know if this makes sense" breaks character and signals uncertainty

## Deep Dive

For all 40 insights from 19 guests, see `references/guest-insights.md`

## Related Skills

- Written Communication
- Stakeholder Alignment
- Running Effective Meetings
- Fundraising
