# Giving Presentations - All Guest Insights

*19 guests, 40 mentions*

---

## Andy Raskin
*Andy Raskin_*

> "Make the title the takeaway of the slide so that the person looking at it has to do zero work to take away. So example, you'll sometimes see, 'The problem,' or, 'The team.' Replace, 'The team,' with, 'Our team is veterans of whatever industry,' or every single slide it's a takeaway, not a label."

**Insight:** Slide titles should be descriptive conclusions, not generic category labels.

**Tactical advice:**
- Replace generic slide titles (e.g., 'The Team') with the specific takeaway (e.g., 'Our team has 20 years of industry experience').

*Timestamp: 01:00:41*


## Casey Winters
*Casey Winters*

> "You want to de-risk that meeting not make it a big success or fail moment... I try to run through it with the team, pretending to be the other members of the audience that are going to be there... The other thing that I push a lot of my team to do is have pre-meetings with some of those key individuals, so that they're going to be less surprised in the meeting."

**Insight:** High-stakes presentations should be de-risked through role-playing and pre-alignment meetings to ensure there are no surprises.

**Tactical advice:**
- Role-play the presentation by impersonating specific stakeholders and their likely objections
- Hold pre-meetings with key individuals to surface and address concerns before the formal review

*Timestamp: 11:33*

---

> "If you haven't thought through all the questions that might be asked from the document that you're sharing or the presentation you're about to present, you're not prepared enough, right. You need to know the entire universe of how that meeting can go."

**Insight:** Preparation for a presentation is complete only when you have anticipated and prepared data for every possible question that could arise.

**Tactical advice:**
- Prepare a 'universe' of potential questions and have the supporting data ready in front of you
- Learn from mistakes in past meetings to identify which data points executives typically use to validate context

*Timestamp: 16:17*


## Dharmesh Shah
*Dharmesh Shah*

> "I have custom software that I've written that will say, 'Okay, here are the points at which the audience laughed.' Actually audibly laughed. That's the only way it counts. And this actually... and it comes down to this metric that standup comedians use called LPM laughs per minute."

**Insight:** High-stakes public speaking can be improved by quantitatively measuring audience engagement through 'laughs per minute' (LPM).

**Tactical advice:**
- Transcribe practice runs and map out exactly where the audience laughs.
- Aim for a minimum LPM (e.g., 1.25 for business talks) to maintain attention.
- Shorten segments where there are long gaps between laughs.

*Timestamp: 00:10:15*

---

> "when you're telling the story, whatever the funny bit is, those have to literally be the last words of that particular segment. So once you deliver it, then you have to stop talking. And the reason you have to stop talking is the audience needs about a half a second to react, and then they want the permission to laugh."

**Insight:** Timing and silence are as important as the content when using humor in presentations.

**Tactical advice:**
- Place the punchline at the very end of the sentence.
- Pause immediately after a funny point to give the audience permission to laugh.

*Timestamp: 00:12:14*


## Grant Lee
*Grant Lee*

> "One idea at a time, this notion of you give them one egg, someone can catch it, give them too many eggs, they're going to drop it. So don't try to throw too many concepts all at once. Keep it simple. People will appreciate it. And so with every sort of presentation, break it down into the core concepts, try to make sure you're covering one at a time."

**Insight:** Maximize audience retention by presenting only one core concept at a time.

**Tactical advice:**
- Break presentations down into distinct, simple core concepts.
- Avoid overwhelming the audience with too many ideas simultaneously.

*Timestamp: 01:52:00*


## Janna Bastow
*Janna Bastow*

> "One of the things that Mind the Product has been able to provide to speakers is a speaker coach... She helped with posture. She helped with delivery. She helped with even just phrasing of words. Just making sure that everything landed in particular ways. And one of the things she did was make me listen to it and play it back."

**Insight:** Professional coaching and self-review are essential for elevating a presentation to a high standard.

**Tactical advice:**
- Record yourself and listen to the playback to improve delivery
- Practice the talk until you can do it flawlessly in everyday situations like the shower or walking

*Timestamp: 14:06*

---

> "One of the things that I've stopped doing is I used to sit down with a PowerPoint and start writing my deck in PowerPoint or Slides, now. What I now do is I start with my story points. I start with my narratives. I try to figure out what I'm actually trying to say, and then I fit it into the deck."

**Insight:** Develop the narrative and story points before opening slide software to ensure the deck supports the message rather than dictating it.

**Tactical advice:**
- Start with story points and narrative structure before creating slides

*Timestamp: 16:06*

---

> "One of the other things that actually really does work is the power pose, standing with your hands on your hips and it really does... help boost your confidence and make you feel better as you're getting ready to stand on stage."

**Insight:** Physical preparation, such as power posing and stage familiarization, can significantly reduce performance anxiety.

**Tactical advice:**
- Use a 'power pose' (hands on hips) before going on stage to boost confidence
- Walk the stage during tech checks to get comfortable with the physical space
- Find 'fans' in the audience—people who are nodding and smiling—and deliver the talk to them

*Timestamp: 16:51*


## Jeffrey Pfeffer
*Jeffrey Pfeffer*

> "Steve Jobs couldn't convince you to buy water if you were dying of thirst. He could not give a presentation to save his life. And Regis McKenna and his team took Steve Jobs under their wing and created Steve Jobs, a man who could sell anything to anybody. These are skills. This is not about personality."

**Insight:** Exceptional presentation and persuasion skills are learned behaviors that can be developed through coaching and practice, regardless of natural personality.

**Tactical advice:**
- Seek professional coaching to transform presentation abilities.
- Treat public speaking as a masterable skill rather than an innate trait.

*Timestamp: 00:46:39*

---

> "I never appeared before Congress with notes. I wanted them to believe, which was by the way, true, that I was in complete control and complete mastery of the material, and that I did not need notes or a bunch of assistants around me to help me."

**Insight:** Presenting without notes signals total mastery of the subject matter and projects a higher level of authority and power.

**Tactical advice:**
- Master your material so thoroughly that you do not require notes during high-stakes presentations.
- Use eye contact instead of looking down at scripts to project sincerity and control.

*Timestamp: 00:48:26*


## Jonny Miller
*Jonny Miller*

> "I gave a TEDx talk a few years ago and I was like my entire body, I was just terrified. And I did in 15 minutes of this breathing practice before and walked on stage almost cool as a cucumber. It's very effective."

**Insight:** Physiological 'bottom-up' breathing techniques are more effective than mental reframing for managing pre-presentation anxiety.

**Tactical advice:**
- Perform 15 minutes of dedicated breathing practice immediately before a high-stakes presentation
- Focus on changing the physical state of the body to naturally shift the mind's narrative

*Timestamp: 00:11:29*


## John Mark Nickels
*John Mark Nickels*

> "I love her book Resonate... she said what all these things do is they alternate tension between the world as it is and the world as it might be. And it's like, here's that beautiful future of transportation, San Francisco, blah, blah, blah, but here's why it sucks today, all these problems and this and that, but here's how it could look in a few years. And then you're creating that tension and the audience at the end is like sweaty palms."

**Insight:** Effective presentations create resonance by constantly alternating between the current 'flawed' reality and the 'ideal' future state.

**Tactical advice:**
- Structure your narrative to highlight the gap between 'what is' and 'what could be'
- Use tension to build emotional investment from the audience

*Timestamp: 01:08:17*


## Maggie Crowley
*Maggie Crowley*

> "I start with an outline on paper and then I draw little boxes for the slides and I write out the headline of the slides. And then once I have a tight outline... then I sketch out how I want the slides to go."

**Insight:** High-quality presentations are built from a logical outline and clear headlines before any visual design begins.

**Tactical advice:**
- Draft the presentation outline on paper first
- Write the headline for every slide before designing them
- Sketch slide layouts manually before moving to software

*Timestamp: 01:13:15*


## Matt Abrahams
*Matt Abrahams*

> "Visualization is a really useful technique and you see yourself not just in the moment of speaking, but getting up to the stage, seeing it being well received, thinking about how you step off the stage. We see athletes do this kind of thing all the time, and there's good research to say that this desensitizes people."

**Insight:** Visualization acts as a mental dress rehearsal that desensitizes the speaker to the environment and audience response.

**Tactical advice:**
- Visualize the specific room and the people you will be speaking to
- Envision the entire sequence from walking on stage to stepping off
- Use virtual reality tools or photos of the venue to make the visualization more concrete

*Timestamp: 00:08:39*

---

> "Strive for connection over perfection by daring to be dull. Just answer the question. Just give the feedback. Just be engaged in the small talk. By doing that, you dial down the volume of self-evaluation, freeing up resources that can be used to really help you succeed."

**Insight:** Lowering the internal standard for 'perfection' reduces cognitive load and allows for better audience connection.

**Tactical advice:**
- Give yourself permission to be 'dull' to free up cognitive bandwidth
- Focus on the immediate task (answering the question) rather than judging your performance

*Timestamp: 00:12:04*

---

> "When you feel those symptoms of anxiety, rather than seeing it as negative, say, 'This is exciting. I get to share my point of view. I get to demonstrate my value.' And in so doing by seeing it as more positive, it causes us by definition to relax."

**Insight:** Anxiety and excitement share the same physiological response; labeling the arousal as 'excitement' improves performance.

**Tactical advice:**
- Reframe physical symptoms (fast heart rate, sweating) as signs of excitement
- Identify specific exciting elements of the speaking opportunity to lean into

*Timestamp: 00:15:06*

---

> "I have a rule of thumb, I jokingly call it a rule of lung. You want your exhale to be twice as long as your inhale. So if you take a three count in, even if you sneak in a little extra air as we were talking about, take a six count out."

**Insight:** The physiological relaxation response is triggered primarily during the exhale, not the inhale.

**Tactical advice:**
- Use a 1:2 ratio for breathing (e.g., 3 seconds in, 6 seconds out)
- Incorporate a 'double inhale' to fully expand the lungs before the long exhale

*Timestamp: 00:27:12*

---

> "I have an acronym. It works. It's called WHAT. W-H-A-T. The W stands for why are we here? ... The H is how are you connected to the event? ... The A stands for anecdote. Tell a story or a quick example that is relevant and accessible to everybody. ... And then ultimately the last part is the gratitude, the thank you."

**Insight:** A successful toast or tribute follows a structured narrative that connects the speaker to the occasion through a brief, relevant story.

**Tactical advice:**
- State the purpose of the gathering (Why)
- Establish your relationship to the person or event (How)
- Share a concise, non-insider story (Anecdote)
- End with a clear expression of thanks or a salute (Thanks)

*Timestamp: 00:57:16*

---

> "I have yet another structure... It's called ADD for adding value. You answer the question cleanly and concisely. You then give an example to reinforce the answer, and then you explain the relevance or significance of the answer so people know it."

**Insight:** Effective Q&A requires connecting the dots for the audience rather than assuming they understand the significance of your answer.

**Tactical advice:**
- Answer the question directly and concisely
- Provide a detailed example to ground the answer
- Describe the relevance to explain why the answer matters to the listener

*Timestamp: 01:04:15*


## Matthew Dicks
*Matthew Dicks*

> "98% of your nervousness is actually before you begin speaking. Once you begin speaking, almost all of your nervousness falls away... preparation is going to reduce your level of nervousness. One of the best ways to prepare for it is to record it and listen to it."

**Insight:** Public speaking anxiety is mostly a pre-performance issue that can be mitigated through auditory familiarity with the material.

**Tactical advice:**
- Record your presentation and listen to it passively while doing other tasks.
- Focus on memorizing transitions between 'scenes' rather than the entire script.
- Practice 'bouncing' between the main points of the talk to ensure you know the sequence.

*Timestamp: 01:19:26*

---

> "I say it stakes, it's surprise, it's suspense, and it's humor. Those are the ways that you're going to hold people and keep them listening. And if you're not engaged in one of those four things while you're speaking, people are not listening to you anymore."

**Insight:** Presentations must be entertaining to be effective, relying on four specific engagement drivers.

**Tactical advice:**
- Audit your presentation to ensure it contains stakes, surprise, suspense, or humor at all times.
- Use 'nostalgia' as a safe and effective way to inject humor into business talks.

*Timestamp: 00:49:07*


## Maya Prohovnik
*Maya Prohovnik*

> "Reframing that anxiety to understand that the thing your body is doing is surging you with adrenaline to help you. And so letting that feeling wash over you instead of fighting it, I think has been so effective for me... I rehearse probably at least 10 times all the way through once the speaker notes are final."

**Insight:** Successful public speaking relies on reframing physiological stress as helpful energy and committing to rigorous rehearsal.

**Tactical advice:**
- Reframe stage fright as a helpful adrenaline surge
- Rehearse the full presentation at least 10 times
- Make frequent eye contact to appear natural even when using speaker notes
- Incorporate personal stories and humor to show genuine passion

*Timestamp: 00:55:32*


## Melissa Perri + Denise Tilles
*Melissa Perri + Denise Tilles*

> "I love product ops because when we prepare for board meetings, I know there's a certain set of information that I'm going to have to put together for this board meeting, and then when we go do it manually, it becomes obsolete by the time the board meeting's over."

**Insight:** Automating the data collection for recurring high-stakes presentations like board meetings prevents 'data obsolescence' and saves leadership time.

**Tactical advice:**
- Create repeatable data pipelines for board meeting slides to ensure information is always current

*Timestamp: 00:35:21*


## Mike Maples Jr
*Mike Maples Jr*

> "Slide one, you say what you do as if I literally know nothing... the second thing that I say to people is, I think your second slide ought to be, here's the thing we know that's not obvious... then slide three is what, if any, proof points do we have?"

**Insight:** A high-impact pitch deck should lead with a simple description of the product followed immediately by a non-obvious insight.

**Tactical advice:**
- Slide 1: State exactly what you do in plain language (e.g., 'We let you rent an extra room in your house')
- Slide 2: Share your 'earned secret' or non-obvious insight about the future
- Slide 3: Provide proof points that validate the insight
- Avoid 'Franken-decks' that try to answer every possible objection from non-believers

*Timestamp: 01:22:10*


## Nancy Duarte
*Nancy Duarte*

> "The ability to just have that contrast as a framework in your brain during a meeting, on a phone call, any moment of influence, like literally it works. It works in any format."

**Insight:** The 'what is vs. what could be' framework is effective for any form of persuasive communication, not just formal stage presentations.

**Tactical advice:**
- Use contrast as a mental model for meetings and calls
- Frame the current reality against a better future state

*Timestamp: 00:00:00*

---

> "Your audience is the hero. That was in my TED talk from 2011. I would say it's infuse your talk with story. And I would say it is asking yourself, can they see what I'm saying?"

**Insight:** Effective presentations require an empathy-centric approach where the audience's needs are prioritized over the presenter's ego.

**Tactical advice:**
- Treat the audience as the hero and yourself as the mentor
- Incorporate story structures
- Ensure every point has a visual component

*Timestamp: 00:17:11*

---

> "In myths and movies, the mentor comes alongside the hero. In other words, the presenter should come alongside the audience and help them get unstuck or bring a magical tool."

**Insight:** The presenter's role is to act as a mentor (like Obi-Wan Kenobi) providing tools for the audience's journey.

**Tactical advice:**
- Identify the audience's internal conflict and provide a tool to soothe it
- Acknowledge the difficulty of the action you are asking the audience to take

*Timestamp: 00:19:32*

---

> "This motion of traversing between what is, what could be, what's is, what could be, what is, what could be, that sense of longing for the future, it makes people leave their current state or the status quo or our current reality and makes them long for this future state by using contrast."

**Insight:** A 'sparkline' structure that alternates between the current problem and the potential solution creates the emotional tension necessary for persuasion.

**Tactical advice:**
- Establish the 'what is' (status quo) first
- Repeatedly contrast the current state with 'what could be'
- End with a 'new bliss'—the world with your idea adopted

*Timestamp: 00:27:37*

---

> "The concept that each slide should make one point... your whole presentation should be grounded in what we call the audience journey, which is the big idea where you're trying to move them from where you're trying to move them to."

**Insight:** Presentations should be organized around a single 'Big Idea' with each slide supporting exactly one point of that narrative.

**Tactical advice:**
- Define your point of view and what is at stake if the audience rejects it
- Limit each slide to one core idea
- Avoid using old slides from repositories unless they are modified for the specific audience

*Timestamp: 00:41:35*

---

> "I take a deep, deep breath and then I take that one while my lungs are full, I take another gulp of breath and I have to let it out real slow."

**Insight:** Managing presentation nerves is a chemical and physical process that can be controlled through specific breathing techniques.

**Tactical advice:**
- Use a 'double-inhale' breathing pattern to calm the nervous system
- Find a quiet, dark space before going on stage to focus
- Watch funny videos right before presenting to shift body chemistry from anxiety to laughter

*Timestamp: 01:00:38*


## Paul Adams
*Paul Adams*

> "I just froze. I couldn't remember what I was supposed to say. It was the first ever time in my life I'd rehearsed the talk word for word. Usually, I have talking points, and things get mixed around, and it's informal. This was media trained, "Do not say the wrong thing." Kind of talk."

**Insight:** Over-rehearsing a script word-for-word can lead to catastrophic failure if you lose your place; using informal talking points is often more resilient.

**Tactical advice:**
- Use talking points rather than a word-for-word script to remain adaptable on stage.

*Timestamp: 00:05:34*


## Petra Wille
*Petra Wille*

> "The easiest way is to get in front of really small and super friendly audiences. So that is, I think, the first starting point. And I don't know where that is. That could be your team, that's a super small audience, usually five to 10 people, or maybe you pine with your company of 80 people or 120 people, maybe the company all-hands is already something where you could actually speak."

**Insight:** Build public speaking confidence by starting with small, low-stakes audiences and gradually increasing scale.

**Tactical advice:**
- Practice speaking in front of your immediate team or local meetups first
- Seek feedback from peers for harsh critique and strangers for unbiased gaps
- Identify 'friendly faces' in the front row to maintain energy

*Timestamp: 00:41:20*

---

> "I think the two things that work well, it's either the Superman pose, so that is one thing. If you're standing like this looking straightly up, that is one thing that helps many people. It's not my preferred one. And then the other one is a bit of the gorilla thing, just like tapping here... that bumps your energy level, so to say."

**Insight:** Physical 'power poses' or sensory anchors can help manage pre-presentation anxiety.

**Tactical advice:**
- Use the 'Superman pose' backstage to build confidence
- Try tapping the thymus (chest) to boost energy levels before entering the stage

*Timestamp: 00:43:33*


## Tristan de Montebello
*Tristan de Montebello*

> "When I am trying to gather my thoughts or think, people tend to look down. And if you're looking down on Zoom, it's three times as bad because it looks like you're looking at your phone or looking at notes if you had any, but even when you're in person, it doesn't look very confident. If instead you switch that up and you start thinking up. I think up into the right, but you can think in any direction you want, but as long as you're looking up, you actually look thoughtful by default."

**Insight:** Looking upward while pausing to think projects confidence and thoughtfulness, whereas looking down signals uncertainty.

**Tactical advice:**
- Avoid looking down when gathering thoughts during a presentation or meeting
- Direct your gaze upward to appear more confident and avoid being interrupted
- Place a 'Think Up' post-it note on your monitor as a visual reminder

*Timestamp: 00:16:56*

---

> "Anticipate that as you get to the end of anything you're saying, you're going to naturally start regaining consciousness and you're going to start being a little bit more self-aware, and some of those uncertainties are going to pop up. Know that it's coming and make sure you land the plane. So what that looks like is, either you just make your ending sound like an ending and then leave it at that, or you can prompt your brain. You can use summary prompts, this is incredibly powerful."

**Insight:** Speakers often lose momentum at the end of a point; finishing with high energy and clear summary prompts ensures the message lands effectively.

**Tactical advice:**
- Use summary prompts like 'In summary,' 'So my point here is,' or 'What I want you to remember' to trigger your brain to close the thought
- Avoid trailing off or expressing doubts like 'I don't know if that makes sense' at the end of a statement
- Maintain 'gas' on the delivery until the very last word is spoken

*Timestamp: 00:19:53*

---

> "The solution is just, don't share your insecurities. Put your best foot forward and stay in it the whole time. Stay in character from beginning all the way through past the ending, because you go all the way through your speech, then you got to end strong, which is a form of staying in character, and then let it be. And that's so important, just let it be and you're going to notice something incredible. If you're the type of person who would break character a lot, start staying in character, and the cue use for myself is, stay in it."

**Insight:** Audiences rarely notice internal nervousness unless the speaker 'leaks' it by breaking character or apologizing for mistakes.

**Tactical advice:**
- Commit to 'staying in character' as a confident speaker even when you feel internal turbulence
- Do not apologize for minor verbal slips or admit to being nervous mid-speech
- Use the internal cue 'stay in it' to maintain composure during difficult moments

*Timestamp: 00:24:33*

---

> "The Accordion Method is saying... I'm going to take everything out of my living room except the most essential pieces that make my living room... And as I look at that, I'm going to have clarity on the vision I want for my living room. And then very slowly, very intentionally, I'm going to go take certain elements that were already there that I might want to bring back in, and I'm going to bring new elements that now I see make sense."

**Insight:** Preparing a talk by iteratively compressing and expanding the time limit helps internalize the core message rather than just memorizing a script.

**Tactical advice:**
- Practice your talk with strict time constraints, starting at 3 minutes and working down to 30 seconds
- Once you reach the 30-second 'essence' of the talk, expand it back up to the original length
- Focus on internalizing key pillars and bookmarks rather than memorizing a word-for-word script

*Timestamp: 01:27:14*

---

> "The bow and arrow starts with a... mindset shift that most of us are in the weeds... we tend to focus more on what we want to say than what we want our audience to remember. The mindset shift here is stop focusing as much on what you want to say and focus more on what you want your audience to remember. We call it the bow and arrow technique because we think you can only remember one thing out of a talk... The one thing is your arrow."

**Insight:** Effective presentations are built around a single 'arrow' (the one key takeaway) supported by the 'bow' (data, stories, or anecdotes).

**Tactical advice:**
- Define a single sentence that represents the only thing you want the audience to remember
- Select specific anecdotes or data points (the 'bow') that provide the tension and weight needed to launch that 'arrow'
- Ensure every slide has its own 'one thing' or 'arrow' clearly identified in the title

*Timestamp: 01:38:05*


## Wes Kao
*Wes Kao*

> "anytime he does a presentation now, every three to five slides, he'll put in a state change. So the idea of every three to five minutes, every three to five slides, go ahead and put in a stage change. We really want to turn this from an art into a science, as much as possible, audience engagement."

**Insight:** Audience engagement in presentations can be systematized by scheduling interactive elements at regular intervals.

**Tactical advice:**
- Insert an interactive element or state change every 3 to 5 slides.
- Ask the audience to guess a data point before revealing it to increase internalization.

*Timestamp: 00:25:17*


