---
name: having-difficult-conversations
description: Help users navigate tough feedback, performance conversations, and conflict. Use when someone needs to give hard feedback, have a performance conversation, fire someone, address conflict with a colleague, or deliver disappointing news like a denied promotion.
---

# Having Difficult Conversations

Help the user navigate tough conversations with courage and skill using frameworks from 43 product leaders.

## How to Help

When the user asks for help with a difficult conversation:

1. **Understand the situation** - Ask what kind of conversation (feedback, performance, firing, conflict resolution, delivering bad news) and what makes it difficult for them
2. **Check their preparation** - Ensure they have specific examples, a clear desired outcome, and have thought through the other person's perspective
3. **Choose the right framework** - Match the situation to the appropriate structure (SBI, CORE, NVC, or Radical Candor)
4. **Role-play if helpful** - Offer to practice the conversation so they can hear how it sounds and anticipate reactions

## Core Principles

### Radical Candor: Care personally AND challenge directly
Kim Scott: "Radical Candor is what happens when you care personally and challenge directly at the same time." Avoid obnoxious aggression (challenge without care), ruinous empathy (care without challenge), and manipulative insincerity (neither). Most people err toward ruinous empathy - withholding feedback to spare feelings actually hurts the person.

### Use the Situation-Behavior-Impact framework
Paige Costello: "Situation, behavior, impact. The situation is on Tuesday in that meeting at 3:00. Behavior, you interrupted me while I was saying this thing. Impact, made me feel like you weren't listening." Keep it objective and specific. Describe what a camera would have recorded, not your interpretation of their motives.

### Distinguish feelings from attributions
Carole Robin: "'I feel that you don't care' and 'I feel you're being insensitive' are not feelings. That's where we make our biggest mistakes." Use actual emotion words (hurt, disappointed, anxious) not "I feel that" or "I feel like" which introduce stories and accusations.

### Stay on your side of the net
Carole Robin: "Stick with the two realities you know - your intent and their behavior. We get in trouble the minute we think we know the other person's reality." Only speak to what you observed and how it impacted you. Don't assume their motives.

### Address pinches before they become crunches
Carole Robin: "Address it while it's still small and then it won't get big." Small interpersonal irritations escalate into major conflicts when ignored. Notice when you're becoming activated and speak up early.

### Deliver termination news personally, never by email
Matt Mochary: "The biggest marker between a botched layoff and a successful layoff is whether they heard it from their manager in a one-on-one." Always deliver termination news in a private 1:1 meeting. Ensure the setting allows them to express emotions privately.

### Give warning before the firing conversation
Alisa Cohn: "I need you to fix this within the next 30 days. Otherwise, we're going to have to part ways." Before firing someone, you must have a "crystal clear" conversation where consequences are explicitly stated. Use the phrase "part ways" or "not have a future together" so there's no ambiguity.

### Separate the decision from the implementation
Matt Mochary: "Decision is one thing, implementation is completely separate. If you let them go kindly, become their agent - help them find their next job actively." The business decision may be necessary; the implementation should be compassionate. Reach out to your network to help them land somewhere that fits.

### Provide hope when delivering bad news
Alisa Cohn: "Hope for the future is so important. 'I know this is challenging to hear, not going to promote you, but I want you to know I'm committed to your success here.'" When denying a promotion or delivering disappointment, acknowledge the difficulty, express commitment to their career, and offer specific support.

### Ask "What did you hear me say?"
Carole Robin: "One of the most powerful things you can do when somebody responds unexpectedly is ask 'What did you hear me say?'" Repair conversations by checking for misaligned perceptions. Validate their reaction based on what they heard, even if it wasn't what you intended.

### Withholding feedback is selfish
Matt MacInnis: "The most selfish thing you can do is withhold feedback from someone. You're optimizing for your own comfort." Reframe difficult feedback as an unselfish act of service. Give it immediately when you observe something that could help them improve.

### Use "nevertheless" to close debate
Annie Duke: "'I hear you and understand. Nevertheless, this is what's going to happen.' Validate the perspective, then use 'nevertheless' to transition to the final decision without inviting further debate."

## Questions to Help Users

- "What specific behavior do you need to address? What did a camera record?"
- "What's the outcome you're hoping for from this conversation?"
- "Have you given this feedback before? Was it crystal clear what would happen if things didn't change?"
- "What's making this conversation difficult for you? What are you afraid of?"
- "How might the other person perceive this situation differently?"
- "What's your relationship foundation with this person - do they know you care about them?"

## Common Mistakes to Flag

- **Ruinous empathy** - Being so "nice" that you never deliver the hard truth. This hurts them more in the long run
- **"I feel that..." phrasing** - This introduces accusations disguised as feelings. Use actual emotions: hurt, anxious, frustrated
- **Assuming intent** - You don't know why they did what they did. Only speak to behavior and impact
- **Saving feedback for reviews** - Feedback should be immediate and ongoing, not saved for quarterly conversations
- **Firing without prior warning** - The actual firing should be a brief confirmation, not a surprise. They should have heard the "crystal clear" warning first
- **Email or group announcements for terminations** - Always deliver personally in a private 1:1

## Deep Dive

For all 78 insights from 43 guests, see `references/guest-insights.md`

## Related Skills

- Running Effective 1:1s
- Coaching PMs
- Managing Up
- Onboarding New Hires
