# Having Difficult Conversations - All Guest Insights

*43 guests, 78 mentions*

---

## Ada Chen Rekhi
*Ada Chen Rekhi*

> "It's so unsafe for your manager to turn to a young woman on the team and say, 'Here, let me give you feedback on your physical appearance, and how it affects your competence and how you're perceived in the workforce.' That the vast majority of them will just never do it because there's no winning... but then that person never learns the rules of the game."

**Insight:** Managers often avoid giving sensitive but critical feedback on presence and perception, which can stall a high-performer's career.

**Tactical advice:**
- Connect the dots for the recipient between their presentation/behavior and how it affects their perceived competence.
- Focus feedback on controllable elements that can be actioned immediately.
- Build deep trust first so that 'Radical Candor' is received as helpful rather than an attack.

*Timestamp: 00:55:54*


## Alexander Embiricos
*Alexander Embiricos*

> "The number one company value from my startup... was to be kind and candid... we, as founders, realized that we often would be nice and it wasn't actually the right thing to do. We would delay the difficult conversations and we were not candid... think of being candid as an act of kindness."

**Insight:** Radical candor is an act of kindness because it prevents the long-term damage caused by delaying necessary feedback.

**Tactical advice:**
- Frame difficult feedback as an act of kindness to the recipient
- Avoid 'being nice' as a justification for avoiding candid performance conversations

*Timestamp: 01:20:46*


## Alisa Cohn
*Alisa Cohn*

> "Hope for the future is so important. I know this is going to be challenging for you to hear, not going to promote you, but I want you to know this. It's really important to me that you're able to succeed in your career here, and so I want to continue to help you find opportunities to build your skills and to advance."

**Insight:** When delivering disappointing news like a denied promotion, it is crucial to provide a sense of hope and a path for future growth.

**Tactical advice:**
- Acknowledge the difficulty of the news immediately
- Express commitment to the employee's long-term career success
- Offer specific support for skill-building and advancement

*Timestamp: 00:00:10*

---

> "No one wants to make anybody upset, but through that upset on the other side of that, can often be a whole new possibility and a whole new revelation, and actually a lot of joy and freedom. I think that we forget about all the other possibilities that come out of difficult conversations and we just land on these really uncomfortable parts."

**Insight:** Reframing difficult conversations as opportunities for growth and clarity helps overcome the fear of upsetting others.

**Tactical advice:**
- Identify the specific fear or meaning you are attaching to the conversation
- Focus on the potential positive outcomes and 'freedom' on the other side of the conflict

*Timestamp: 00:07:51*

---

> "Matilda, I want to chat with you about the way you're interacting with your peers. So what I'm hearing from them is that you're missing deadlines on a regular basis and not letting them know you're missing the deadlines, and that also you're not fully keeping your team up to speed. And so they're kind of confused running around. Now, we both know that the most important way you can be successful here and also achieve your goals is to make sure that you are working with your peers in a way that's consistent and that they can count on you and you can count on them."

**Insight:** Effective performance feedback should be based on observable facts and shared goals rather than personal judgment.

**Tactical advice:**
- Use the phrase 'What I'm hearing' to cite multiple sources of feedback
- Use 'We both know' to align the feedback with the employee's own goals for success
- Keep the tone even-keeled and matter-of-fact

*Timestamp: 00:12:55*

---

> "Matilda, part of your job is to be able to create these documents and I appreciate that you do them on time. What I've observed is that they can often be not as structured as I'd like them to be and they also lack a conclusion. So what I'd love you to do is look at these three or four examples of some folks who are doing them really well and see if you can model your writing on theirs."

**Insight:** When giving feedback on specific skills like writing, provide clear examples of excellence for the employee to model.

**Tactical advice:**
- Start with 'What I've observed' to keep the feedback objective
- Provide specific examples of high-quality work to serve as a benchmark
- Connect the skill level to the perception of their professional thinking

*Timestamp: 00:17:43*

---

> "Let's pause for a second because I'm feeling the energy has changed and I can see that you're getting a little bit heated by what I'm saying and I want you to know that I have no intention of upsetting you. I just want to be able to talk to you about the things that are going to help you in your career."

**Insight:** If a conversation becomes defensive or emotional, pausing to reset the intention can prevent it from escalating into a fight.

**Tactical advice:**
- Call out the change in 'energy' or 'temperature' neutrally
- Reiterate that the goal is to help the person's career
- Offer a break to digest the information if necessary

*Timestamp: 00:24:25*

---

> "Matilda, I know this is going to be challenging for you to hear. I know you were hoping to get that promotion, but I want to let you know that we are going to actually be looking for an external candidate. I want to give you a few thoughts about why. First of all, in discussing this with my peers, I'm realizing that we need someone who has done this role multiple times in the past and has that experience."

**Insight:** When denying a promotion, be direct, explain the specific criteria used for the decision, and maintain the employee's dignity.

**Tactical advice:**
- Don't 'bury the lead'—deliver the news early in the meeting
- Explain the business rationale (e.g., need for specialized external experience)
- Mirror back their perspective to show they have been heard

*Timestamp: 00:25:24*

---

> "I need you to know that this is very important. I need you to fix this within the next 30 days. Otherwise, I'm sorry to say, we're going to have to find a way to part ways because I can't keep this going with you. I know you have it in you to change. I value all you bring to the table, but if you don't fix these things, we're not going to have a future together."

**Insight:** Before firing someone, you must have a 'crystal clear' conversation where the consequences of failing to improve are explicitly stated.

**Tactical advice:**
- State clearly that the issue is a 'deal breaker'
- Set a specific timeframe for improvement (e.g., 30 days)
- Explicitly use the phrase 'part ways' or 'not have a future together' so there is no ambiguity

*Timestamp: 00:32:23*

---

> "Matilda, we talked about this multiple times. The last time we had this conversation, I told you I needed you to make these changes. You haven't made these changes and we're going to part ways. So I have here, Sarah from HR or whatever, and we're going to talk through the logistics of that."

**Insight:** The actual firing conversation should be a brief confirmation of previous discussions rather than a new debate.

**Tactical advice:**
- Reference the previous 'crystal clear' warnings
- State the decision as final and move quickly to logistics
- Involve HR for the formal termination process

*Timestamp: 00:35:05*


## Annie Duke
*Annie Duke*

> "I hear what you're saying and I understand. Nevertheless, this is what's going to happen. And obviously, the words that you can use for that might be different... I heard you and your input, trust me, was incorporated into the decision, nevertheless, this is the path we're going to take."

**Insight:** The word 'nevertheless' allows leaders to acknowledge dissenting opinions while maintaining the authority to move forward with a decision.

**Tactical advice:**
- Validate the other person's perspective ('I hear you').
- Use 'nevertheless' to transition to the final decision without inviting further debate.

*Timestamp: 00:18:56*


## Anneka Gupta
*Anneka Gupta*

> "I try to let myself just feel the things that I'm going to feel. ... Then once that's passed, whether that's a few hours or a few days, don't react. Don't try to say, "Oh, I don't believe this." Listen. And then ask myself, okay, well where is this feedback coming from? Why am I getting this feedback?"

**Insight:** When receiving hard feedback, separate the physiological emotional response from the analytical process of understanding the feedback's validity.

**Tactical advice:**
- Wait several hours or days before responding to negative feedback to allow emotions to settle.
- Approach feedback with curiosity by asking peers for additional context or flavor on the critique.

*Timestamp: 00:43:07*

---

> "I will say this very directly to people, I care so much about you and I'm giving you this feedback because I want you to be successful and I want you to be able to reach the pinnacle of what I know you can accomplish. ... then it makes the other person much more receptive to hearing whatever you have to say."

**Insight:** Effective hard feedback requires a foundation of deep personal care combined with radical directness.

**Tactical advice:**
- Explicitly state your positive intent and belief in the person's potential before delivering the critique.
- Frame feedback as 'how you are being perceived' rather than an objective truth about the person's character.

*Timestamp: 00:47:10*


## Ben Horowitz
*Ben Horowitz*

> "I'd say I just sit them down and I would say, 'Look, you're a really good director of engineering because you do a great job at managing the team, get the products out, all that. But you're not really a CTO because to be a CTO, you have to be effective with other parts of the organization... if you want to get good at that, I'll help you. I'll work with you on it, but if you don't, I'm going to have to hire a CTO at some point because obviously I need that.'"

**Insight:** Frame difficult feedback around the requirements of the role and the individual's effectiveness rather than personal attacks.

**Tactical advice:**
- Be specific about how a behavior (e.g., making someone cry) reduces professional effectiveness
- Offer a path to improvement while being clear about the consequences of not changing

*Timestamp: 00:16:09*

---

> "you've got to be able to tell them the truth in a way that you probably don't tell most of your friends the truth... all the most important things I've said are things that I've said to CEOs that they did not want to hear. And that's what the leadership is about."

**Insight:** Effective leadership requires prioritizing the truth over being liked in the short term.

**Tactical advice:**
- Prioritize being respectful over being 'friendly' when delivering hard truths
- Focus on the long-term health of the company rather than immediate social comfort

*Timestamp: 00:18:22*


## Boz
*Boz*

> "Being kind isn't that. Being kind is like, 'Hey, how can I deliver this feedback in a way that is actually productive and helpful, in a way that is going to help them and not cause them just to feel bad and helpless?'"

**Insight:** Kindness in feedback is about being productive and helpful, whereas 'niceness' is often just avoiding the discomfort of truth.

**Tactical advice:**
- Distinguish between 'nice' (patronizing/half-truths) and 'kind' (direct/helpful feedback).
- Recognize when 'identity threat' is making you defensive during a disagreement.

*Timestamp: 00:50:50*

---

> "She could have the most profound disagreement with somebody in the world... and she would respond. She would say, 'Fascinating. You have to tell me more about why you think that.'"

**Insight:** Approaching profound disagreements with genuine curiosity rather than defensiveness can de-escalate conflict and lead to better outcomes.

**Tactical advice:**
- Use the phrase 'Fascinating, tell me more' when you encounter a viewpoint that seems 'crazy wrong'.
- Embrace curiosity as a tool to bridge the 'schism' between different mental models.

*Timestamp: 01:27:38*


## Bret Taylor
*Bret Taylor*

> "She pulled me into a room and gave me talking to a little bit about holding my team to as high of a standard as I have. If someone wasn't meeting my expectations, what was my plan to manage them out of the company..."

**Insight:** Leadership requires the courage to have hard conversations about performance and managing out those who don't meet the bar.

**Tactical advice:**
- Hold the team to the same high standards you hold for yourself
- Have a clear plan for managing out underperformers rather than compensating for them

*Timestamp: 00:16:10*


## Carole Robin
*Carole Robin*

> "I feel that you don't care and I feel you're being insensitive are not feelings, and that's where we make our biggest mistakes when it comes to feedback."

**Insight:** Effective feedback requires distinguishing between actual emotions and attributions or labels disguised as feelings.

**Tactical advice:**
- Avoid using 'I feel that' or 'I feel like' as they usually lead to attributions rather than emotions.
- Use a specific vocabulary of feelings (e.g., hurt, afraid, disappointed) to express impact.

*Timestamp: 00:00:12*

---

> "Stay on your side of the net... stick with the two realities you know because we get in trouble the minute we start thinking we know the other person's reality."

**Insight:** In any interaction, you only know your own intent and the other person's behavior; you do not know their internal reality or intent.

**Tactical advice:**
- Only speak to the behavior you observed and the impact it had on you.
- Avoid assuming the other person's motives or intentions.

*Timestamp: 00:45:09*

---

> "The formula is when you do insert behavior, I feel pull out the vocabulary of feelings and I'm telling you this because, or I'm hoping the outcome of you knowing this is."

**Insight:** A structured feedback loop helps prevent defensiveness by focusing on objective behavior and personal impact.

**Tactical advice:**
- State the specific behavior: 'When you do [X]...'
- State the feeling: 'I feel [Y]...'
- State the purpose: 'I'm telling you this because [Z]...'

*Timestamp: 00:49:11*

---

> "Address it while it's still small and then it won't get big. That's why we call it talk about a pinch before it becomes a crunch."

**Insight:** Small interpersonal irritations ('pinches') should be addressed immediately to prevent them from escalating into major conflicts ('crunches').

**Tactical advice:**
- Notice when you are becoming 'activated' or irritated by small behaviors.
- Substitute 'it' for 'I/You/We' to determine if a conversation is worth having (e.g., 'We are worth it').

*Timestamp: 00:42:04*

---

> "What did you hear me say? One of the most powerful things you can do when somebody responds in a way that feels very unexpected and out of whack with what you just said is go back to, 'What did you hear me say?'"

**Insight:** Repairing a conversation often requires checking for misaligned perceptions of what was actually communicated.

**Tactical advice:**
- Ask 'What did you hear me say?' to uncover misinterpretations.
- Validate the other person's reaction based on what they heard, even if it wasn't what you intended.

*Timestamp: 01:05:04*


## Claire Hughes Johnson
*Claire Hughes Johnson*

> "Say the thing you think you cannot say... I think that I've come to believe that often your biggest strength, one, is also your weakness, but two, is something that you don't know is a big strength because it's almost like breathing."

**Insight:** Leaders should practice radical transparency by voicing the observations they are tempted to filter out.

**Tactical advice:**
- Identify the 'left-hand column' of internal thoughts you are filtering out
- Voice uncomfortable observations to open up doors for others to speak

*Timestamp: 00:33:03*

---

> "One is, ask a question. Right? A question is not threatening... The next trick is you own it. This is your observation, this is your perception. This is not a judgment. I am not saying, 'Lenny, I think you really botched that interview.' That's not useful. If I said, 'Lenny, you know what? I wonder if you missed an opportunity in that interview.'"

**Insight:** Difficult feedback is best delivered as a non-judgmental observation or a curious question that the speaker 'owns' as their personal perception.

**Tactical advice:**
- Ask a question to open a difficult topic without being threatening
- Own the observation by framing it as 'my experience' or 'I noticed' rather than an objective truth
- Detoxify your internal commentary before speaking it out loud

*Timestamp: 00:35:47*


## Claire Butler
*Claire Butler*

> "Radical Candor and Dare to Lead, to be honest, are the ones I recommend the most. Because I do a lot of coaching new managers and helping them learn how to manage. And those are the first two I start with, because they're so good."

**Insight:** Foundational management frameworks like Radical Candor are essential for teaching new managers how to handle feedback and hard conversations.

**Tactical advice:**
- Use Radical Candor as a primary resource for training new managers in feedback

*Timestamp: 01:25:44*


## Claire Vo
*Claire Vo*

> "I called both of them individually and I said, 'The way you are operating is not meeting our leadership expectations. If you do not change, you cannot be part of this organization anymore. I believe you can operate differently. I do.'"

**Insight:** Radical candor and clear expectations are kinder than vague feedback when performance or behavior is failing.

**Tactical advice:**
- Normalize feedback by taking the 'temperature' out of the room
- State clearly that questioning ideas is not questioning innate talent
- Give feedback that is 'clear and kind' by being direct about the consequences of no change

*Timestamp: 00:30:47*


## Drew Houston
*Drew Houston*

> "You love good relationships with people, but you don't want to make them unhappy so you don't tell them the truth basically about things that are difficult to hear... the company's conflict avoidant, so we're not telling the truth and then making a bunch of predictable mistakes."

**Insight:** Conflict avoidance in leadership creates an organizational culture that fails to address obvious mistakes.

**Tactical advice:**
- Use personality frameworks like the Enneagram to identify personal tendencies toward conflict avoidance.
- Consciously override the instinct to protect relationships at the expense of the truth.

*Timestamp: 00:45:49*


## Elizabeth Stone
*Elizabeth Stone*

> "Where if I'm asking myself the question, 'If this person on my team came to me and said, "I'm leaving today. I have a different opportunity and I would like to take it," would I do everything I could to keep them at Netflix?' If not, then I should be having that tough conversation about, 'Should you really be here? Are you in the right role?'"

**Insight:** The 'Keepers Test' is a mental framework used to identify when a difficult performance conversation or termination is necessary.

**Tactical advice:**
- Regularly ask yourself if you would fight to keep each team member if they resigned
- Initiate difficult conversations immediately if the answer to the Keepers Test is 'no'

*Timestamp: 00:31:10*

---

> "When something's not meeting expectations or really showing up as excellence, I think it's a combination of both giving the feedback on that and being direct about it and being specific about what would it take to get this to the bar that I am expecting... And then the third and probably most important thing is help them fill that gap."

**Insight:** Effective performance feedback requires a three-step approach: setting clear expectations, giving specific feedback on the gap, and actively helping the employee close that gap.

**Tactical advice:**
- Be specific about what is required to reach the 'excellence' bar
- Jump in to help the employee iterate on work (like a document) to show them what the bar looks like

*Timestamp: 00:21:55*


## Evan LaPointe
*Evan LaPointe*

> "I struggled for years with feedback to generate the intended outcome... As soon as I started closing the gap and realized I need to try harder to think about the story arc of this feedback, that becomes clearest to me how to do it when I have the intended outcome in mind."

**Insight:** Effective feedback is designed by working backward from the intended behavioral outcome rather than just delivering the message.

**Tactical advice:**
- Design the 'story arc' of feedback to ensure the recipient remains in a receptive state.
- Ask 'Why do you believe that?' to drill below a behavior into the underlying belief during a tough conversation.

*Timestamp: 01:00:35*


## Ethan Evans
*Ethan Evans 2.0*

> "The first thing I did was I owned it. I said, 'Yes, it's not working. It's my fault. I will deal with it.' I took ownership. And the second thing I did was start updating him very proactively and saying, 'Here's where we are.'... I was buying life one hour at a time."

**Insight:** In high-stakes failure scenarios, taking immediate ownership and providing frequent, scheduled updates can prevent micromanagement and preserve trust.

**Tactical advice:**
- Admit mistakes immediately and take full responsibility without deflecting
- Establish a proactive communication cadence (e.g., hourly updates) during a crisis
- Meet the aggrieved party face-to-face as soon as possible to rebuild the human connection

*Timestamp: 00:44:26*


## Graham Weaver
*Graham Weaver*

> "I was teaching the Xs and Os of being a CEO, basically: hiring, firing, having hard conversations, managing a board, fundraising, selling, all the things you would imagine that a young CEO would need to know."

**Insight:** Hard conversations and firing are foundational 'Xs and Os' skills for any effective leader.

**Tactical advice:**
- Master the mechanics of hiring and firing as a core CEO competency
- Learn to manage board dynamics and fundraising alongside team management

*Timestamp: 00:21:20*


## Jerry Colonna
*Jerry Colonna*

> "My famous questions include things like, what am I not saying that I need to say? ... What am I saying that's not being heard? And then, of course, what's being said that I'm not hearing?"

**Insight:** Difficult conversations are often avoided because of unspoken truths; identifying these gaps is the first step to resolution.

**Tactical advice:**
- Journal on the question: 'What am I not saying that I need to say?'
- Evaluate communication gaps by asking what you are saying that isn't being heard and what others are saying that you are missing.

*Timestamp: 00:24:30*


## Joe Hudson
*Joe Hudson*

> "Since I'm coach executives, let's do an executive example, so conflict avoidant executive. I don't want to feel the out of control in this that I do when people argue. I don't want to feel that level of out of control, so I am going to be conflict avoidant. I'm going to avoid conflict. Every way that we go to avoid a feeling, becomes the way that, that feeling gets invited towards us."

**Insight:** Avoiding the internal discomfort of conflict actually causes more tension and unresolved issues to accumulate in an organization.

**Tactical advice:**
- Identify the specific emotion you are trying to avoid (e.g., feeling out of control or ashamed) during a conflict.
- Practice 'falling in love' with that uncomfortable feeling to remove the resistance that makes the conversation difficult.

*Timestamp: 00:30:46*


## Jules Walter
*Jules Walter*

> "if you manage to get them to take the risk to give you the feedback, your answer has to be enthusiastically grateful. That's the key... externally, I'm like, 'Hey, thank you,' and I mean it. I think that's the key that most people don't focus on."

**Insight:** To receive honest, difficult feedback, you must lower the social risk for the provider by responding with extreme gratitude.

**Tactical advice:**
- Ask for feedback on specific traits (e.g., 'executive presence') rather than general performance.
- Offer self-critique first to make it safe for others to provide honest agreement or disagreement.
- Respond to all feedback with enthusiastic gratitude to encourage future honesty.

*Timestamp: 00:46:45*


## Julie Zhuo
*Julie Zhuo 2.0*

> "Feedback really, in my mind, ideally, should be a daily practice... what is the best tool for us to get better? It is feedback."

**Insight:** Feedback should be a continuous calibration tool rather than a semi-annual event.

**Tactical advice:**
- Treat feedback as a daily practice to accelerate team improvement.

*Timestamp: 00:57:59*

---

> "The first tip on getting feedback or delivering hard feedback is first go and actually establish that our relationship is one in which we value each other's contribution... Start by saying, 'Hey, really excited to work with you. I feel like our best collaboration is I want you to help me get better.'"

**Insight:** The foundation of difficult feedback is an upfront agreement that both parties value growth and want to help each other.

**Tactical advice:**
- Establish a 'feedback-first' relationship early on.
- Ask colleagues if they prefer feedback in the moment or at set intervals.

*Timestamp: 01:01:18*

---

> "If I sit down with you and I say, 'Lenny, I'm so nervous right now. I want to give you some feedback and I'm really worried that it's going to impact our relationship... but I also feel like it's just going to help you to hear it if you can.' That does so much of the work of... It's humanizing."

**Insight:** Naming your own nervousness and vulnerability when delivering feedback reduces defensiveness in the recipient.

**Tactical advice:**
- Check your intention: ensure you are giving feedback to help, not to be 'right'.
- Verbally acknowledge the difficulty of the conversation to build human connection.

*Timestamp: 01:05:06*

---

> "Sometimes a win-win thing is to just say, 'Look, it's not working, and I respect and value you so much that I know you want to do something that you can be proud of and you can grow in... and right here, what we got, this isn't it.'"

**Insight:** Firing or letting someone go can be framed as a win-win if the current role prevents them from being successful and valued.

**Tactical advice:**
- Frame termination as a necessary step for the individual to find a role where they can truly thrive.

*Timestamp: 01:08:06*


## Katie Dill
*Katie Dill*

> "I walked into the room and there were five of them seated around the table. They had a pack of papers in front of them and they went on taking turns quietly reading from the papers all the things that they saw that I was doing wrong and all the things that they didn't like about me... luckily, thank goodness I had the sense to just listen and not respond in that way."

**Insight:** When receiving difficult feedback, the most effective response is to listen fully without immediate defensiveness.

**Tactical advice:**
- Listen and take in feedback without responding immediately to justify actions

*Timestamp: 00:07:22*


## Ken Norton
*Ken Norton*

> "Why don't you go to training to learn how to have difficult conversations? Because there's some great training about having difficult conversations... these are all really, really important factors that start to come into play."

**Insight:** Difficult conversations are a core leadership competency that requires formal training and practice, not just intuition.

**Tactical advice:**
- Treat difficult conversations as a skill to be trained rather than a personality trait
- Invest in formal training for conflict and feedback

*Timestamp: 00:47:25*


## Kenneth Berger
*Kenneth Berger*

> "I work with a lot of founders who are not the sort of classic control freaks. They're super nice and their teams love them and they love their teams. So for them, it can be really hard to deliver hard feedback, to deliver negative feedback and even more to actually create consequences."

**Insight:** Nice leaders often struggle with negative feedback because they fear damaging relationships or appearing unkind.

**Tactical advice:**
- Recognize that creating consequences is a form of respect for the other person's choices
- Move beyond just giving feedback to clearly stating the desired outcome or change

*Timestamp: 00:21:58*

---

> "I love radical candor, for example, where I try to go a step further than radical candor is to not just say, 'Hey, here's my feedback. Just wanted you to know.' But to say, 'And I want something. I would like to see an outcome.'"

**Insight:** Effective feedback should be paired with a specific request for change or a desired future state.

**Tactical advice:**
- Frame the complaint as an implied dream or vision for a better world
- Ensure the feedback includes a clear ask for what you want to happen next

*Timestamp: 00:35:11*

---

> "And it's basically when you want to give someone feedback, the template is when you do a behavior, I feel a feeling, and she's big on like say actual feeling word not like, 'I feel like, or I feel that,' blah, blah, blah. And step three is, 'I'm telling you this because...' and then what you want them to change."

**Insight:** A structured feedback loop involves describing a specific behavior, expressing a genuine feeling, and stating the purpose for the change.

**Tactical advice:**
- Use the 'Behavior-Feeling-Purpose' framework
- Avoid 'I feel like' (which introduces stories) and use actual feeling words
- Stay factual by describing what a video camera would have recorded

*Timestamp: 00:39:26*


## Kim Scott
*Kim Scott*

> "Radical Candor is just what happens when you care personally and challenge directly at the same time. And I think it's probably best understood by what it's not because we all fail on one of those two dimensions or both of them multiple times a day. So you can think about it as a two by two framework. On the vertical axis is care personally, the horizontal axis is challenge directly. What happens when we remember to challenge directly, but we forget to show that we care personally. That is what I call obnoxious aggression"

**Insight:** Radical Candor requires the simultaneous application of personal care and direct challenge to avoid being a jerk or being too soft.

**Tactical advice:**
- Avoid 'obnoxious aggression' by ensuring you show you care before challenging.
- Avoid 'ruinous empathy' by not withholding necessary feedback to spare feelings.
- Avoid 'manipulative insincerity' which is neither caring nor challenging.

*Timestamp: 00:04:04*

---

> "I can tell when you do that thing with your hand, then I'm going to have to be a lot more direct with you. When you say um every third word, it makes you sound stupid."

**Insight:** Sometimes feedback must be blunt and direct to penetrate a person's defenses or lack of awareness.

**Tactical advice:**
- If a person brushes off gentle feedback, increase the directness of the challenge until it is heard.
- Use specific, high-impact language if necessary to ensure the recipient understands the gravity of the issue.

*Timestamp: 00:11:41*

---

> "You want to be humble, you want to be helpful, you want to do it immediately. You want to do it in person or at least synchronously. If you can't do it in person. You also want to praise in public and criticize in private, and you don't want to give people either praise or criticism about their personality. So if you want to remember all that, it's HHIIPPP, two H's, two I's, kind of three P's depending on how you count."

**Insight:** Effective feedback follows the HHIIPPP framework: Humble, Helpful, Immediate, In-person, Public praise/Private criticism, and not Personal.

**Tactical advice:**
- Deliver feedback immediately rather than saving it for a later meeting.
- Ensure feedback is about work/behavior, not the person's inherent personality.
- Prioritize synchronous communication (phone or in-person) to gauge the recipient's emotional reaction.

*Timestamp: 00:18:52*

---

> "you want to use sort of context, observation, result, next step. So context, in the meeting, observation, when you said um every third word, it makes you sound stupid. Next step, go to the speech coach. Also is important for praise, in the meeting context, when you offered both sides of the argument, observation, result is it earned you credibility. Next step is do more of that. So you can call it CORE"

**Insight:** The CORE framework ensures feedback is specific, objective, and actionable for both praise and criticism.

**Tactical advice:**
- State the Context of the behavior.
- Share the specific Observation of what happened.
- Explain the Result or impact of that behavior.
- Define the Next Step or expected change.

*Timestamp: 00:19:21*

---

> "if I didn't fire Bob, I was going to lose all my best performers because not only had it been unfair to Bob not to tell him, I also had been unfair to everyone on the team. And they were frustrated. Their deliverables were late because his deliverables were late. They weren't able to do their best work because they were having to spend so much time redoing his work."

**Insight:** Failing to give direct feedback (ruinous empathy) damages team morale and causes high performers to leave.

**Tactical advice:**
- Address poor performance early to prevent a toxic environment for high performers.
- Realize that withholding criticism is ultimately unkind as it leads to avoidable terminations.

*Timestamp: 00:24:11*

---

> "if you find your employee looks sad or mad, if they look sad, pause and say, 'I feel like maybe I didn't say that in the best possible way. How could I have said it differently?' And so that means you're going up on the care personally, dimension, but you're not going the wrong way on challenge directly."

**Insight:** When feedback causes a negative emotional reaction, double down on showing care without retracting the truth of the feedback.

**Tactical advice:**
- Gauge the listener's reaction and adjust your approach in real-time.
- If the recipient is upset, acknowledge their feelings but stay firm on the necessary challenge.

*Timestamp: 00:55:51*


## Marc Benioff
*Marc Benioff*

> "One of those things that we did two years ago was we had to architect a layoff, and we had never done a scaled layoff before. We had to lay off 10% of the company to save the company... It's a complete dumpster fire. It's a nightmare. I'm getting bashed in the press, on Twitter. Everyone is shooting at me."

**Insight:** Large-scale layoffs are inherently painful and will likely result in public criticism, but they are sometimes necessary for the long-term survival of the company.

**Tactical advice:**
- Accept that difficult decisions like layoffs will never 'go well' regardless of communication
- Develop a 'thick skin' to handle inevitable public and internal backlash
- Focus on the 'regeneration' of the company post-crisis

*Timestamp: 47:12*


## Matt Abrahams
*Matt Abrahams*

> "There's a more robust structure I talk about in the book called The 4 Is... The first I is information. You're just setting the playing field so the person knows what you're giving the feedback about. The second is impact, and this is impact on you, the feedback giver. The third is the invitation that you make, and then the final is the implications or consequences."

**Insight:** Feedback should be framed as a collaborative problem-solving opportunity rather than a top-down critique.

**Tactical advice:**
- Start with objective information/facts about the behavior
- State the impact the behavior has on you or the team
- Invite the other person into the conversation to find a solution
- Outline the implications or benefits of changing the behavior

*Timestamp: 00:55:08*

---

> "An apology to me, I have a AAA... It's three steps, acknowledge, appreciate, and amends. So I have to acknowledge what I did. ... Then I appreciate. 'I can imagine my doing that made you feel bad...' The amends part is, 'I will work not to do this. In fact, I will wait till you're done...'"

**Insight:** A meaningful apology focuses on the specific transgression and a commitment to change, rather than just apologizing for the other person's feelings.

**Tactical advice:**
- Acknowledge the specific behavior or mistake made
- Appreciate the impact or negative feelings caused to the other person
- Make specific amends by stating exactly how you will change your behavior in the future

*Timestamp: 01:07:55*


## Matt MacInnis
*Matt MacInnis*

> "Fundamentally, the most selfish thing you can do is withhold feedback from someone. When you think a thought that would help someone improve and you avoid giving it to them because it would make you uncomfortable. Well, you're optimizing for your own comfort, and it's fundamentally selfish."

**Insight:** Withholding critical feedback is a selfish act that prioritizes the giver's comfort over the receiver's growth.

**Tactical advice:**
- Give feedback immediately when you observe something that could help someone improve.
- Reframe difficult feedback as an unselfish act of service to the recipient.

*Timestamp: 00:00:41*


## Matt Mochary
*Matt Mochary*

> "The biggest marker that I've seen between a botched layoff and a successful layoff is at the moment someone hears that they no longer have a job, did they hear it from their manager in a one-on-one? If that's when they heard it, it'll be okay. But if they heard it in an email, in a group chat, in any kind of thing where they were sitting next to or they're hearing it along with other people, it wasn't personalized, it wasn't one-on-one, that is terrible."

**Insight:** The success of a layoff depends entirely on the news being delivered personally by a direct manager in a private setting to maintain human dignity.

**Tactical advice:**
- Always deliver termination news in a 1:1 meeting, never via email or group announcement.
- Ensure the setting allows the person to express their emotions privately.

*Timestamp: 00:00:00*

---

> "I believe that fear is actually giving you bad advice and I think you're predicting that if you do this A will happen. Well, I'm predicting that if you do that, the exact opposite will happen."

**Insight:** Fear often leads leaders to avoid necessary but difficult conversations by making exaggerated negative predictions.

**Tactical advice:**
- Check with a neutral third party when you feel 'gripped' by fear to get a clearer view of reality.
- Test your fear-based predictions against a non-fearful person's predictions to see which outcome actually occurs.

*Timestamp: 00:09:31*

---

> "I at times feel anger and I act on that anger and I don't even realize I'm in anger... she said, 'I perceive you to be in anger.' So it's an I statement and it's simply what she's perceiving. There's no judgment. That was able to punch through my anger and then I woke up and went, oh, and then I stopped and just didn't act until I was able to shift out of anger."

**Insight:** Using non-judgmental 'I' statements to identify a leader's emotional state can help them pause before causing relational damage.

**Tactical advice:**
- Use the phrase 'I perceive you to be in [emotion]' to provide feedback without triggering defensiveness.
- Stop and refuse to act or speak until you have shifted out of an angry state.

*Timestamp: 00:12:40*

---

> "The reason people are bad at this is because they think that they're hurting the person who they're letting go... Decision is one thing, implementation is completely and utterly separate. That's the same thing here in letting someone go. But if you let them go kindly and humanely, the key is, in my opinion, you become their agent, like Michael Ovitz, the CAA agent. You help them find their next job actively."

**Insight:** Effective firing requires separating the business decision from the compassionate implementation of helping the person find their next role.

**Tactical advice:**
- Separate the decision (what the customer/business needs) from the implementation (how to help the person being hurt).
- Actively serve as the departing employee's 'agent' by reaching out to your network to find them a role that fits their passions.

*Timestamp: 00:24:03*

---

> "I start it off, 'Hey, this is going to be a difficult conversation. I want you to take a few seconds and prepare yourself. You are not going to enjoy this.' What I found is that the way the amygdala gets triggered is often because of surprise. So, if you give someone just a few seconds to mentally prepare, then the amygdala often doesn't get triggered nearly as hard."

**Insight:** Giving a brief warning before delivering bad news prevents the 'surprise' trigger that causes emotional hijacking.

**Tactical advice:**
- Start difficult conversations by explicitly stating it will be difficult and giving the person a few seconds to prepare.
- After delivering the news, ask the person to share their feelings to help them release the emotional charge.

*Timestamp: 00:30:10*

---

> "You actually want to cut deep because cutting two times or three times creates PTSD in an organization. It's trauma one, trauma two, trauma three. Now they're like, ah, it's just going to keep happening."

**Insight:** In large-scale layoffs, it is better to make one deep cut than multiple smaller rounds that destroy team trust and morale.

**Tactical advice:**
- Calculate the necessary savings in dollars rather than headcount to avoid losing the most productive junior staff.
- Complete all individual notification meetings in a single morning to minimize the period of uncertainty.

*Timestamp: 00:51:10*


## Maya Prohovnik
*Maya Prohovnik*

> "The big one for me is Radical Candor... you need to care personally and challenge directly. If you're only doing one of those things, you're not giving feedback in an effective way."

**Insight:** Effective feedback requires a balance of deep personal care and direct challenge to be constructive.

**Tactical advice:**
- Adopt the Radical Candor framework: Care Personally + Challenge Directly
- Frame underperformance as a 'wrong fit' for the role rather than a personal failing
- View feedback as a gift intended to help the recipient reach their career goals

*Timestamp: 00:49:05*


## Melissa Tan
*Melissa Tan*

> "I actually pulled them aside and I said, 'Hey, we need to move a lot faster. This is where we need to get to by X. We're a growth team. We need to prove wins out early.'... I think in that conversation what's important is also saying, 'I believe you can do all these things and I'm doing this to support you.'"

**Insight:** Difficult performance conversations are most effective when you explicitly state your positive intent and belief in the person's potential.

**Tactical advice:**
- Address performance or speed issues within the first few weeks of observation
- State clearly that the feedback is intended to set them up for success
- Keep feedback focused on specific observations and impacts rather than personal criticism

*Timestamp: 00:18:00*


## Mihika Kapoor
*Mihika Kapoor*

> "If you have feedback to give someone else, I think you can start by asking, 'Hey, do you have feedback from me?' And kind of taking the feedback first so then that person feels like, 'Okay, maybe I have my way of seeing this situation. Let me communicate that and get off my chest.'"

**Insight:** Opening a difficult feedback session by asking for feedback first creates a more balanced and receptive environment.

**Tactical advice:**
- Be explicit about your level of confidence in an opinion (e.g., 'medium confidence') to allow others to push back
- Establish a culture of directness early in a working relationship by stating your communication style upfront
- Act on received feedback immediately to demonstrate that feedback is valued

*Timestamp: 00:30:57*


## Molly Graham
*Molly Graham*

> "Firing people is as important as hiring people. Getting good at identifying when someone does not belong or someone is not going to work out is actually a skill."

**Insight:** Maintaining a high-performing team requires the discipline to remove underperformers who create 'drag' on the organization.

**Tactical advice:**
- Adopt the mantra 'serve the business, not the people' to make objective decisions about team composition.
- Ask: 'If there were no emotions involved, what would I do?' to strip away the fear of upsetting someone.
- Remember that being direct is being kind when letting someone go.

*Timestamp: 01:03:12*


## Paul Adams
*Paul Adams*

> "I'd never fired anyone before I joined Intercom... and realized it always works out for both sides. And the nicest thing to do is to do the harder thing. It's actually the nicer thing to do. People are relieved in this example."

**Insight:** The 'kindest' path in management is often the most difficult one, such as letting someone go when there isn't a fit.

**Tactical advice:**
- Reframe difficult conversations as the 'nicer' thing to do for the individual's long-term success.

*Timestamp: 01:19:08*


## Rachel Lockett
*Rachel Lockett*

> "Actually, the goal of any conflict is to create mutual understanding."

**Insight:** The objective of conflict resolution should be shared understanding rather than winning an argument or proving the other person wrong.

**Tactical advice:**
- Shift focus from convincing to understanding the other person's perspective.

*Timestamp: 00:00:32*

---

> "I'm going to give you a framework that I like that many of my clients use. It's from Marshall Rosenberg's Nonviolent Communication. It is a book and a framework. So it's four steps. The first step is observations... The next step is feelings... The third step is needs... And lastly, the step is to make a request."

**Insight:** Nonviolent Communication (NVC) provides a structured way to address conflict by focusing on objective facts and personal needs rather than blame.

**Tactical advice:**
- State objective observations (facts that can't be argued).
- Express feelings as body-based emotions (e.g., 'I feel anxious') rather than thoughts (avoid 'I feel like...').
- Identify the underlying human need (e.g., clarity, connection).
- Make a specific, achievable request.

*Timestamp: 01:13:54*

---

> "There is always something that we're doing to contribute to the conflict, even if it feels like the other person is insane... Entering any conflict conversation with humility, and curiosity about the other person's experience, is critical."

**Insight:** Taking 100% responsibility for your contribution to a conflict prevents the 'victim/hero/villain' dynamic.

**Tactical advice:**
- Ask: 'How am I complicit in creating the conditions that I claim I don't want?'
- Enter conversations with humility and curiosity instead of rigidity.

*Timestamp: 01:22:56*


## Uri Levine
*Uri Levine*

> "The problem was not that the team was not right. The problem was that the CEO did not make hard decision. Making hard decisions is hard... In a small place like a startup, the hard decisions will always go to the top. Now, if the CEO does not make that hard decisions, the result is always the same. The top performing people would leave."

**Insight:** A leader's inability to fire underperformers or 'assholes' directly causes the loss of top talent.

**Tactical advice:**
- Fire underperformers immediately to protect the culture and retain top talent.
- Recognize that everyone in a small team usually knows who shouldn't be there within the first month.

*Timestamp: 00:54:58*


## Wes Kao
*Wes Kao 2.0*

> "I have a framework called strategy, not self-expression... the goal is behavior change. So if that's the goal, trim everything else that you were about to say that does not actually contribute to that goal and only keep the part that will make the person want to change."

**Insight:** Feedback should be a strategic tool for behavior change, not a vehicle for emotional venting.

**Tactical advice:**
- Vent frustrations to a third party (therapist, partner) before the actual feedback conversation
- Trim 90% of the emotional 'fluff' and focus only on what motivates the change

*Timestamp: 01:05:05*


## Ebi Atawodi
*Ebi Atawodi*

> "When you are extending yourself, you're not nice. It's not always nice or like, it sometimes is having hard conversations. It's knowing that, oh, there's a human, they know I care about them. So when the feedback is coming like raw, they know that it's in their best interest because I've shown enough times that I genuinely care about the person behind the role."

**Insight:** Effective difficult conversations are rooted in 'love' (extending oneself for another's growth) rather than just being 'nice,' ensuring the recipient knows the feedback comes from a place of genuine care.

**Tactical advice:**
- Show genuine care for the person behind the role before delivering raw feedback
- Prioritize the other person's growth over being liked

*Timestamp: 00:00:00*


## Megan Cook
*Megan Cook*

> "What we put into place is something we call Fight Club. I'll probably get in trouble for talking about Fight Club. The first rule is you don't talk about Fight Club. But it's 30 minutes every week, and it's just for myself, my engineering, and my design leader; and we get together, and we know that we're going there to have a conflict."

**Insight:** Schedule a recurring weekly meeting specifically dedicated to surfacing and resolving leadership conflicts early.

**Tactical advice:**
- Create a dedicated 30-minute weekly slot for leadership conflict resolution
- Enter the meeting with the explicit mindset that disagreements will occur
- Address tensions early to prevent them from escalating into larger organizational issues

*Timestamp: 00:00:00*


## Paige Costello
*Paige Costello*

> "Convey this feedback as situation, behavior, impact. The situation is on Tuesday in that meeting at 3:00. Behavior, you interrupted me while I was saying this thing. Impact, made me feel like you weren't listening to me... it's a subjective observation. It's not what the camera recorded, it's what you experienced."

**Insight:** The Situation-Behavior-Impact (SBI) framework makes feedback objective and actionable by focusing on observed behaviors and their personal impact.

**Tactical advice:**
- Specify the exact time and place of the behavior (Situation).
- Describe the observable action without judgment (Behavior).
- Share how that behavior affected you or the team (Impact).

*Timestamp: 00:43:37*


## Sanchan Saxena
*Sanchan Saxena*

> "I had to let go of people over Zoom. I couldn't even meet them in-person. I still remember when I actually finished my speech and I told them, 'This is the last day,' now, I literally shed a tear in front of everybody, because I was like, 'Man, this is hard. This is really, really hard.'"

**Insight:** Leading through layoffs requires extreme vulnerability and empathy, especially when conducted remotely.

**Tactical advice:**
- Lead with vulnerability and human emotion during difficult organizational changes
- Acknowledge the external factors to ensure employees understand it is not a reflection of their performance

*Timestamp: 00:18:09*


## Tobi Lutke
*Tobi Lutke*

> "Spending time and longer time in careers with people and then holding them to a high standard means that they accomplish very often things that just they didn't imagine they could. To me this is the most wonderful thing to see... hearing from someone that you respect that 'Hey, I think you had it in you to do this thing significantly better because I think you probably saw fairly early in the project this sort of path A path B. You chose path B potentially out of convenience even though you knew that wasn't the right thing. And I actually expected better of you'... that's hard to hear, right, because it's right. But it's also extremely valuable, right?"

**Insight:** High-standard feedback should be based on a person's untapped potential rather than just their current performance level.

**Tactical advice:**
- Hold people accountable to their potential rather than their current level
- Call out when someone chooses a path of convenience over their own conviction
- Frame difficult feedback as an expectation of greatness based on respect

*Timestamp: 00:10:23*


## Varun Parmar
*Varun Parmar*

> "The number one thing that a product leader on the product leadership team needs to do is drive accountability with others in the product leadership team... When you go back and you work with your team, always have the lens are you improving things."

**Insight:** Product leaders must balance the duality of driving accountability among peers while driving continuous improvement within their own teams.

**Tactical advice:**
- In leadership meetings, prioritize holding peers accountable for business outcomes over just reporting status.
- Ask 'Have I improved things today compared to yesterday?' as the primary yardstick for team performance.

*Timestamp: 01:05:42*

---

> "Every offsite that I do with my leadership team, usually there is a one to two hour session where it is feedback to Varun, and I actually do it openly... I want to show my vulnerabilities to everyone, that I am not perfect."

**Insight:** Leaders can build radical trust by soliciting and receiving tough feedback in front of their entire direct report group.

**Tactical advice:**
- Dedicate specific time in offsites for 'open feedback' where the team critiques the leader's performance.
- Model vulnerability by acknowledging blind spots publicly to encourage a culture of honest feedback.

*Timestamp: 01:09:43*


