---
name: launch-marketing
description: Help users plan and execute product launches. Use when someone is planning a product launch, preparing PR outreach, coordinating a go-to-market campaign, launching on Product Hunt, or asking how to generate buzz for a new feature or product.
---

# Launch Marketing

Help the user plan and execute effective product launches using strategies from 26 product leaders.

## How to Help

When the user asks for help with a product launch:

1. **Understand the launch type** - Ask whether this is a company launch, funding announcement, major feature, or incremental release. Different types require different approaches
2. **Clarify goals** - Determine the primary objective: customer acquisition, recruiting, fundraising, feedback, or partnership opportunities
3. **Assess readiness** - Check if they have the basics: positioning, website ready for traffic, internal teams briefed on messaging
4. **Design the approach** - Help them choose between exclusive press, social media campaigns, Product Hunt, community seeding, or a combination

## Core Principles

### Pitch press as an exclusive, not a broad embargo
Arielle Jackson: "For early stage startups, we're almost always running the launch announcement as an exclusive, which means you give the news to a single outlet." Identify a single target outlet that covers companies at your stage. Offer the story exclusively to one reporter at a time.

### Funding is a news hook, not the story
Arielle Jackson: "Don't do a straight funding announcement. Use that funding as a news hook to tell a larger story - your product's available, you have reference customers, you have momentum." Combine funding news with a product launch or partnership to make it interesting to readers.

### Separate soft launch from hard launch
Janna Bastow: "Decoupling the technical release (soft launch) from the marketing event (hard launch) reduces stress and improves marketing quality." Soft launch first to gather functional videos and testimonials. Use the period between launches to plan a high-impact campaign based on the final product.

### Find the "sizzle" feature
Bret Taylor: "Satellite imagery wasn't the most important part of Google Maps, but it was the sizzle to the steak and it created a viral moment." Identify a visually impressive or shareable feature that generates buzz, even if it isn't the primary use case.

### Use lightning strikes, not peanut butter
Christopher Lochhead: "What if you launched like Hollywood launches a movie? I'd rather matter for one week a year than be irrelevant for the rest of the year." Concentrate marketing efforts into 1-2 massive events per year rather than spreading budget thinly over time. Be unavoidable to your target audience for a short window.

### Distribute in concentric circles
Lulu Cheng Meservey: "You go out in concentric circles starting from your own desk. First get clear on your message, then co-founders, executives, employees, investors, power users, and out from there." Ensure each inner circle is fully aligned before moving to the next. Internal alignment protects external credibility.

### Seed product to the right influencers
Lulu Cheng Meservey: "Find the Venn diagram of people who will be obsessed with this product AND have a large following among your target audience. Shower them with free product." Target the intersection of high product affinity and high audience influence for organic evangelism.

### PR is for credibility, not leads
Zoelle Egner: "PR is not going to get you leads or users. What it is good for is credibility - hiring or improving the response rate for your cold outbound." Use press coverage as social proof in recruiting emails and sales outreach. Don't rely on it for direct user acquisition.

### Use press coverage as marketing fuel
Jason Feifer: "Sometimes the point isn't to reach the readers at all. Put money behind promoting the tweet about your coverage to the people you want to notice you got coverage." The "As seen in" logo on your website may be more valuable than the article's direct traffic.

### Build a cadence of launches, not one big bang
Zoelle Egner: "Instead of one big launch, have a series of launches that allow you to stay top of mind and create momentum. Audiences respond to novelty." Plan launches every few months to re-engage communities and maintain presence.

### Start PR prep six weeks out
Emilie Gerber: "Before an announcement, you want to kick off six weeks in advance - working on the blog, media training, outreach, getting investor quotes." Prioritize reporter availability over internal deadlines. Be flexible on dates to secure quality coverage.

### Optimize for algorithm momentum
Chris Hutchins: "Ranking charts are driven by momentum of new subscribers, not total volume. Launch with multiple pieces of content to build early momentum." For platform-based launches (podcasts, Product Hunt), focus on concentrated activity in a short window to trigger algorithmic boost.

## Questions to Help Users

- "What's the primary goal of this launch - customers, recruiting, fundraising, or feedback?"
- "Do you have a single outlet in mind for an exclusive, or are you planning broad outreach?"
- "What's your 'sizzle' feature - the thing people will share even if it's not the core value?"
- "Is your website ready for traffic? Are internal teams briefed on messaging?"
- "Who are the influencers at the intersection of 'will love this product' and 'has your target audience'?"
- "How much lead time do you have? Ideal is 6 weeks for press."

## Common Mistakes to Flag

- **Launching too many things at once** - Kevin Weil on Libra: "The whole world went 'Oh my God, that's a lot of change at once.'" Introduce radical innovations one at a time
- **Pitching press without an exclusive offer** - Generic pitches to many outlets get ignored. Offer exclusives one reporter at a time
- **Treating funding as the story** - Funding is a hook, not news. Combine it with product or customer momentum
- **Relying on PR for user acquisition** - Press builds credibility but rarely drives direct signups. Use it for recruiting and sales enablement
- **Rigid launch dates** - Prioritize reporter availability over internal timelines. A flexible date beats no coverage

## Deep Dive

For all 42 insights from 26 guests, see `references/guest-insights.md`

## Related Skills

- Positioning & Messaging
- Brand Storytelling
- Content Marketing
- Media Relations
